! IP Pattern Match Prioritization - Example NCL Script 
! ====================================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
! This script sets up pattern match prioritization on a DECNIS in order to:
!   o Discard telnet & rlogin sessions from all IP nodes outside
!     the local IP network, except 2 allowed nodes.
!   o Allow FTP connectivity from all nodes.	
! The text below shows the required relationships between PACKET,
! PATTERN and GROUP entities: 
!
!  PACKET - telnet     PACKET - rlogin        PACKET - FTP
!   (TCP port 23)        (TCP port 513)		(TCP port 20/21)
!	     \                /                         |
!       match \              / match 			| match	
!            - - - - - - - - - - - - - - 	 	|
!	    | PATTERN - local	        |		|
!	    |   (16.37.*.*)	        |		|
!	    | string = %x10250000       |		|
!	    | mask   = %xffff0000       |		|
!	     - - - - - - - - - - - - - -		|
!         mismatch /      match |			|
!		  /             |			| 
!       - - - - - - - - - - -   |			|
!      | PATTERN - node 1    |  |			|
!      |   (16.36.16.249)    |  |			|
!      | string = %x102410f9 |  |			|
!      | mask   = %xffffffff |  |			|
!       - - - - - - - - - - -   |			|
!  mismatch /        match |    |			|
!          /               |    |			|
!  - - - - - - - - - - -   |    |			|
! | PATTERN - node 2    |  |    |			|
! |  (16.36.16.136)     |  |    |			|
! | string = %x10241088 |  |    |      			|
! | mask   = %xffffffff |  |    |   			|
!  - - - - - - - - - - -   |    |   			|
! mismatch /     match \   |    |      			|
!         /             \  |    |			|
!  - - - - -          - - - - - - -                 - - - - - - 
! |  GROUP  |        |    GROUP    |               |   GROUP   |
! | discard |        | interactive |               | file_copy |
!  - - - - -          - - - - - - -                 - - - - - -
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create the PRIORITY module 

create priority

! Create PACKET entities for telnet, rlogin and FTP packets

create priority packet telnet type ip tcp , IP Port Range = [23..23]
create priority packet rlogin type ip tcp , IP Port Range = [513..513]
create priority packet ftp type ip tcp , IP Port Range = [20..21]

! Create a PATTERN entity for the local network, with matches on IP 
! source addresses in the range 16.37.0.0 -> 16.37.255.255              

create priority pattern Our_local_IP_network from=start, offset = 12, -
	  string = %x10250000 , -
	    mask = %xFFFF0000 

! Create PATTERN entities for the 2 allowed Nodes                        

create priority pattern IP_allowed_node_1 from=start, offset = 12, -
	  string = %x102410F9 , -
	    mask = %xFFFFFFFF 
create priority pattern IP_allowed_node_2 from=start, offset = 12, -
	  string = %x10241088 , -
	    mask = %xFFFFFFFF 

! Create GROUP entities

create priority group interactive 
create priority group file_copy   
create priority group discard     

! Create an INTERFACE entity for the port you want to apply prioritization to.

create priority interface w622-5-0 communication port w622-5-0
!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 
!
! Set the match action of each PACKET entity to point to a PATTERN or a GROUP.

set priority packet telnet match action = priority pattern Our_local_IP_network
set priority packet rlogin match action = priority pattern Our_local_IP_network
set priority packet ftp match action = priority group file_copy

! Set the match action and mismatch action for each PATTERN. Note,
! these must be specified in separate commands.
  
set priority pattern Our_local_IP_network - 
	match action = priority group interactive
set priority pattern Our_local_IP_network -
     mismatch action = priority pattern IP_allowed_node_1

set priority pattern IP_allowed_node_1 -
	match action = priority group interactive 
set priority pattern IP_allowed_node_1 -
     mismatch action = priority pattern IP_allowed_node_2

set priority pattern IP_allowed_node_2 -
        match action = priority group interactive
set priority pattern IP_allowed_node_2 -
     mismatch action = priority group discard

! Set the assigned class for each GROUP

set priority group interactive assigned class 2
set priority group file_copy assigned class 4
set priority group discard assigned class 8

! Set queue 8 to zero, so that packets on this queue are discarded. 

set priority interface w622-5-0 queue 8 maximum queue length = 0

! Set the default class priority for any other packets that the DECNIS
! receives.

set priority bridge sap default class 6
set priority bridge pid default class 6
set priority bridge type default class 6
set priority ip tcp default class 6
set priority ip udp default class 6
set priority ip protocol default class 6
set priority decnet phaseiv default class 6
set priority osi default class 6
set priority ipx default class 6

!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Enable Priority Interface and Priority Module

enable priority interface w622-5-0
enable priority
!==============================================================================

