! Backup Circuits - Example NCL Script
! ====================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up a DECNIS with three Backup circuits to handle 
! possible problems  with  key  routing  circuits.  
!
! This  script file assumes that the secondary circuits
! are  enabled  in the DECNIS configurator and would therefore
! need to be disabled as part of setting up a backup circuit.
!
! The configuration is as follows:
!
!	Group		Circuit			Notes
!	~~~~~~~~~	~~~~~~~~~~~		~~~~~~~~~~~~~~
!	mygrp1		PRIMARY	CCT		High Speed WAN link to ...
!	  		W618-4-0		
!			
!			SECONDARY CCT		High speed BACKUP link 
!			W622-5-0 (X.21)		
!
!	mygrp2     	PRIMARY CCT		High Speed WAN link to ...
!			W622-5-1	
!			
!			SECONDARY CCT 		Backup Circuit at 128K
!			W618-6-1		
!
!	mygrp3     	PRIMARY CCT		Low speed WAN link 
!			W618-6-2	
!			
!			SECONDARY CCT		Backup X.25 outbound circuit 
!			W618-6-3		
!
! This script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create Supervisor and the three backup circuit groups

create supervisor
create super group mygrp1 function backup
create super group mygrp2 function backup
create super group mygrp3 function backup
!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 

! Configure the three backup circuit groups as required for the network

set super group mygrp1 invoke timer 10
set super group mygrp1 revoke timer 10
set super group mygrp1 primaries {Routing Circuit W618-4-0}
set super group mygrp1 Secondary Routing Circuit W622-5-0

set super group mygrp2 invoke timer 10
set super group mygrp2 revoke timer 10
set super group mygrp2 primaries {Routing Circuit W622-5-1}
set super group mygrp2 Secondary Routing Circuit W618-6-1

set super group mygrp3 invoke timer 10
set super group mygrp3 revoke timer 10
set super group mygrp3 primaries {Routing Circuit W618-6-2}
set super group mygrp3 Secondary Routing Circuit RX25-OUT-1
!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Disable the backup  circuits

disable Routing Circuit W622-5-0
disable modem connect line W622-5-0

disable Routing Circuit W618-6-1
disable modem connect line W618-6-1

disable Routing Circuit RX25-OUT-1

! Enable  the primary circuits AND x.25 connection to ptt

enable Routing Circuit W618-4-0
enable modem connect line W618-4-0

enable Routing Circuit W622-5-1
enable modem connect line W622-5-1

enable Routing Circuit W618-6-2
enable modem connect line W618-6-2

enable modem connect line W618-6-3	!  X25 cct always on

! Now the backup group can be enabled

enable super group mygrp1
enable super group mygrp2
enable super group mygrp3
!==============================================================================
