! OC-3 ATM Permanent Circuit - Example NCL script
! ===============================================
!
!           +++++++++++++++++++++++++++++++++++++++++++++++++++
!     COPYRIGHT (C) 1995 BY DIGITAL EQUIPMENT CORPORATION, MAYNARD,
!     MASSACHUSETTS.
!     ALL RIGHTS RESERVED.
!
!     THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
!     ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE AND  WITH THE
!     INCLUSION OF THE ABOVE  COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER
!     COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
!     OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
!     TRANSFERRED.
!
!     THE INFORMATION IN THIS  SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
!     AND  SHOULD NOT BE  CONSTRUED AS A  COMMITMENT BY  DIGITAL  EQUIPMENT
!     CORPORATION.
!
!     DIGITAL ASSUMES NO  RESPONSIBILITY FOR THE USE OR  RELIABILITY OF ITS
!     SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!           +++++++++++++++++++++++++++++++++++++++++++++++++++
!
! This script sets up the DECNIS to provide OC-3 ATM Permanent circuits.
!
! Wherever <name> appears, you should replace it with a value that matches
! your basic DECNIS configuration.
!
! This script is divided into three sections:
!      EXTRA_CREATE.NCL
!      EXTRA_SET.NCL
!      EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to the
! DECNIS Management manual.
!===============================================================================
!                             EXTRA_CREATE.NCL
!                             ++++++++++++++++
! Add this section to NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS.
!
!
! Ensure that a device exists for the network interface card.
!
Create Device Unit W631-7 Name W631-7
!
! Ensure that the multiplexed interface module exists.
!
Create Multiplexed Interface
!
! Ensure that the ATM connection management module exists.
!
Create ATM Connection Management
!
! Ensure that the ATM multiprotocol encapsulation module exists.
!
Create ATM Multiprotocol Encapsulation
!
! Create the multiplexed interface line characteristics. Note that this
! example creates an OC-3 interface type.
!
Create Multiplexed Interface Line W631-7-0 -
	Communications Port = W631-7-0, -
	Interface Type = OC-3, -
	Framing Type = Sonet
!
! Create the multiplexed interface line logical channel and logical channel map.
!
Create Multiplexed Interface Line W631-7-0 Logical Channel W631-7-0 Map {0}
!
! Create the ATM connection management line.
!
Create ATM Connection Management Line W631-7-0
!
! Create the ATM Connection Management PVCs. Note that there can be multiple 
! PVCs on each ATM Connection Management line. The VCI valid range is 32 
! through 1023. The VPI valid range is 0 through 255 with 0 as the default.
! Specify that the ATM Adaptation Layer is of type AAL5 and that the ATM line 
! uses LLC encapsulation.
!
Create ATM Connection Management Line W631-7-0 PVC W631-7-0 -
	Virtual Circuit Identifier = 32, -
	Virtual Path Identifier = 0, -
	AAL Type = AAL5, -
	Encapsulation Type = LLC Encapsulation
Create ATM Connection Management Line W631-7-0 PVC W631-7-1 -
	Virtual Circuit Identifier = 33, -
	Virtual Path Identifier = 0, -
	AAL Type = AAL5, -
	Encapsulation Type = LLC Encapsulation
!
! Create the ATM multiprotocol encapsulation links.
!
Create ATM Multiprotocol Encapsulation Link W631-7-0
Create ATM Multiprotocol Encapsulation Link W631-7-1
!
! Create the routing circuits.
!
Create Routing Circuit W631-7-0 Type = ATM Permanent
Create Routing Circuit W631-7-1 Type = ATM Permanent
!
! Create the bridge ports.
!
Create Bridge
Create Bridge Port PORT-8 Port Number = 8, Type = Remote
Create Bridge Port PORT-9 Port Number = 9, Type = Remote
!
! If RIP has not already been configured on the DECNIS then create the RIP 
! Routing Control Protocol entity.
!
Create Routing Control Protocol RIP-1 Type = IP RIP
!
!===============================================================================
!                            EXTRA_SET.NCL
!                            ++++++++++++++++
! Add this section to NIS_<name>_EXTRA_SET.NCL file for your DECNIS.
!
! Set the clock timing source to network or local.
!
Set Multiplexed Interface Line W631-7-0 Clock Source = Network
!
! Associate the ATM connection management line with the multiplexed interface
! logical channel.
!
Set ATM Connection Management Line W631-7-0 Lower Layer Entity = -
	Multiplexed Interface Line W631-7-0 Logical Channel W631-7-0
!
! Disable cell scrambling.
!
Set ATM Connection Management Line W631-7-0 Cell Scrambling = Disabled
!
! Configure the circuits to suit the requirements of the routing circuit 
! bandwidth and switch.
!
Set ATM Connection Management Line W631-7-0 PVC W631-7-0 -
	Peak Rate = 100, -
	Minimum Guaranteed Rate = 60, -
	Traffic Shaping Priority = 1
Set ATM Connection Management Line W631-7-0 PVC W631-7-1 -
	Peak Rate = 100, -
	Minimum Guaranteed Rate = 40, -
	Traffic Shaping Priority = 1
!
! Associate the ATM multiprotocol encapsulation links with the ATM connection
! management PVCs.
!
Set ATM Multiprotocol Encapsulation Link W631-7-0 Lower Layer Entity = -
	ATM Connection Management Line W631-7-0 PVC W631-7-0
Set ATM Multiprotocol Encapsulation Link W631-7-1 Lower Layer Entity = -
	ATM Connection Management Line W631-7-0 PVC W631-7-1
!
! Set the maximum protocol data unit (PDU) size of the ATM multiprotocol
! encapsulation links.
!
Set ATM Multiprotocol Encapsulation Link W631-7-0 Maximum PDU Size = 4490
Set ATM Multiprotocol Encapsulation Link W631-7-1 Maximum PDU Size = 4490
!
! Associate the routing circuit with the ATM multiprotocol encapsulation link.
!
Set Routing Circuit W631-7-0 Data Link Entity = -
	ATM Multiprotocol Encapsulation Link W631-7-0
Set Routing Circuit W631-7-1 Data Link Entity = -
	ATM Multiprotocol Encapsulation Link W631-7-1
!
! Set up the routing circuit network protocols and SDU size.
!
Set Routing Circuit W631-7-0 Network Protocols = {IP,ISO8473}, -
	Manual Data Link SDU Size = 4490, -
	Manual IP Data Link SDU Size = 4490
Set Routing Circuit W631-7-1 Network Protocols = {IP}, -
	Manual Data Link SDU Size = 4490, -
	Manual IP Data Link SDU Size = 4490
!
! Set the IP address and subnetwork mask for the IP interface.
!
Set Routing Circuit W631-7-0 Subnet Address = -
	{Address = 1.1.1.0, Mask = 255.255.255.0}
Set Routing Circuit W631-7-1 Subnet Address = -
	{Address = 4.4.4.5, Mask = 255.255.255.252}
!
! Set up bridging.
!
Set Bridge Port PORT-8 Data Link Entity = -
	ATM Multiprotocol Encapsulation Link W631-7-0, -
	Port Cost = 10, -
	MAC Types = {FDDI}, -
	Manual Data Link SDU Size = 4500
Set Bridge Port PORT-8 Spanning Tree Enable = TRUE
Set Bridge Port PORT-9 Data Link Entity = -
	ATM Multiprotocol Encapsulation Link W631-7-1, -
	Port Cost = 10, -
	MAC Types = {FDDI}, -
	Manual Data Link SDU Size = 4500
Set Bridge Port PORT-9 Spanning Tree Enable = TRUE
!
! Set up the RIP Routing Control Protocol.
!
Add Routing Control Protocol RIP-1 -
	IP Subnet = {	{Address = 1.1.1.0, Mask = 255.255.255.0}, -
			{Address = 4.4.4.4, Mask = 255.255.255.252}}
!
!===============================================================================
!                            EXTRA_ENABLE.NCL
!                            ++++++++++++++++
! Add this section to NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS.
!
!
Set Device Unit W631-7 Auto Load False
Enable Device Unit W631-7
Load Device Unit W631-7		
Set Device Unit W631-7 Auto Load True
!
Enable Multiplexed Interface Line W631-7-0 Logical Channel W631-7-0
Enable Multiplexed Interface Line W631-7-0
Enable ATM Connection Management Line W631-7-0
Enable ATM Multiprotocol Encapsulation Link W631-7-0
Enable ATM Multiprotocol Encapsulation Link W631-7-1
Enable Routing Circuit W631-7-0
Enable Routing Circuit W631-7-1
Enable Bridge
Enable Bridge Port PORT-8
Enable Bridge Port PORT-9
!
! If RIP has not already been configured on the DECNIS then enable the RIP 
! Routing Control Protocol entity.
!
Enable Routing Control Protocol RIP-1
!
!===============================================================================
