$ SET NOON
$ SAVED_VFY = F$VERIFY("NO","NO")
$ ON CONTROL_Y THEN GOTO QUIT
$ SET VERIFY=(PROCEDURE,NOIMAGE)
$!
$! LRDRIVER.COM
$! This is the compile and link procedure for the example device driver
$! LRDRIVER.C.
$!
$! Usage:
$!
$!   @LRDRIVER [DEBUG]
$!
$!   P1         If specified as DEBUG then a version of the driver is built
$!              that facilitates debugging with the High Level Language System
$!              Debugger.  
$!              The default is to build a normal version of the driver.
$!
$!'F$VERIFY("NO")'
$!
$ DEBUG_CC_OPT = ""
$ IF P1 .NES. ""
$ THEN
$    IF P1 .NES. "DEBUG" THEN EXIT %X14         ! SS$_BADPARAM
$    DEBUG_CC_OPT = "/DEBUG/NOOPTIMIZE/DEFINE=DEBUG"
$ ENDIF
$!
$ IF F$TRNLNM("SRC$") .EQS. "" THEN DEFINE/NOLOG SRC$ 'F$ENVIRONMENT("DEFAULT")'
$ IF F$TRNLNM("LIS$") .EQS. "" THEN DEFINE/NOLOG LIS$ 'F$ENVIRONMENT("DEFAULT")'
$ IF F$TRNLNM("OBJ$") .EQS. "" THEN DEFINE/NOLOG OBJ$ 'F$ENVIRONMENT("DEFAULT")'
$ IF F$TRNLNM("EXE$") .EQS. "" THEN DEFINE/NOLOG EXE$ 'F$ENVIRONMENT("DEFAULT")'
$ IF F$TRNLNM("MAP$") .EQS. "" THEN DEFINE/NOLOG MAP$ 'F$ENVIRONMENT("DEFAULT")'
$!
$ SET VERIFY=(PROCEDURE,NOIMAGE)
$!
$! Compile the driver
$!
$ CC/STANDARD=RELAXED_ANSI89/INSTRUCTION=NOFLOATING_POINT/EXTERN=STRICT-
	/POINTER_SIZE=32-
        'DEBUG_CC_OPT'-
        /LIS=LIS$:LRDRIVER/MACHINE_CODE-
        /OBJ=OBJ$:LRDRIVER-
                SRC$:LRDRIVER -
                +SYS$LIBRARY:SYS$LIB_C.TLB/LIBRARY
$!
$! Link the driver
$!
$ LINK/ALPHA/USERLIB=PROC/NATIVE_ONLY/BPAGE=14/SECTION/REPLACE-
        /NODEMAND_ZERO/NOTRACEBACK/SYSEXE/NOSYSSHR-
        /SHARE=EXE$:SYS$LRDRIVER.EXE-           ! Driver image
        /DSF=EXE$:SYS$LRDRIVER.DSF-             ! Debug symbol file
        /SYMBOL=EXE$:SYS$LRDRIVER.STB-          ! Symbol table
        /MAP=MAP$:SYS$LRDRIVER.MAP/FULL/CROSS - ! Map listing
                SYS$INPUT:/OPTIONS
!
!   Define symbol table for SDA using all global symbols, not just
!   universal ones
! 
SYMBOL_TABLE=GLOBALS
!
!   This cluster is used to control the order of symbol resolution.  All
!   psects must be collected off of this cluster so that it generates
!   no image sections.
!
CLUSTER=VMSDRIVER,,,-
        !
        !   Start with the driver module
        !
        OBJ$:LRDRIVER.OBJ,-
        !
        !   Next process the private interfaces.  (Only include BUGCHECK_CODES if
        !   used by the driver module).  The /LIB qualifier causes the linker to 
        !   resolve references in the driver module to DRIVER$INI_xxx routines
        !   (which are defined in the module DRIVER_TABLE_INIT).
        !
        SYS$LIBRARY:VMS$VOLATILE_PRIVATE_INTERFACES/INCLUDE=(BUGCHECK_CODES)/LIB,-
        !
        !   Explicitly include routines for the initialization section - there
        !   will be no outstanding references to cause this to happen when STARLET
        !   is searched automatically.
        !
        SYS$LIBRARY:STARLET/INCLUDE:(SYS$DRIVER_INIT,SYS$DOINIT)

!
!   Use the COLLECT statement to implicitly declare the NONPAGED_EXECUTE_PSECTS
!   cluster.  Mark the cluster with the RESIDENT attribute so that the image 
!   section produced is nonpaged.  Collect only the code psect into the cluster.
!
COLLECT=NONPAGED_EXECUTE_PSECTS/ATTRIBUTES=RESIDENT,-
        $CODE$

!
!   Coerce the psect attributes on the different data psects to that they 
!   all match.  This will force NONPAGED_READWRITE_PSECTS cluster to yield only
!   one image section.   
!
PSECT_ATTR=$LINK$,WRT
PSECT_ATTR=$INITIAL$,WRT
PSECT_ATTR=$LITERAL$,NOPIC,NOSHR,WRT
PSECT_ATTR=$READONLY$,NOPIC,NOSHR,WRT
PSECT_ATTR=$$$105_PROLOGUE,NOPIC
PSECT_ATTR=$$$110_DATA,NOPIC
PSECT_ATTR=$$$115_LINKAGE,WRT

!
!   Use a COLLECT statement to implicitly declare the NONPAGED_DATA_PSECTS
!   cluster.  Mark the cluster with the RESIDENT attribute so that the image 
!   section produced is nonpaged.  Collect all the data psects into the cluster.
!
COLLECT=NONPAGED_READWRITE_PSECTS/ATTRIBUTES=RESIDENT,-
        !
        !   Psect generated by BLISS modules
        !
        $PLIT$,-
        $INITIAL$,-
        $GLOBAL$,-
        $OWN$,-
        !
        !   Psects generated by DRIVER_TABLES
        !
        $$$105_PROLOGUE,-
        $$$110_DATA,-
        $$$115_LINKAGE,-
        !
        !   Standard Psects generated by all languages,
        !   including the high level language driver module
        !
        $BSS$,-
        $DATA$,-
        $LINK$,-
        $LITERAL$,-
        $READONLY$

!
!   Coerce the program section attributes for initialization code so 
!   that code and data  will be combined into a single image section.  
!   
PSECT_ATTR=EXEC$INIT_CODE,NOSHR

!
!   Use a COLLECT statement to implicitly declare the INITIALIZATION_PSECTS
!   cluster.  Mark the cluster with the INITIALIZATION_CODE attribute so that the image 
!   section produced is identified as INITIALCOD.
!
!   These program sections have special names so that when the linker sorts them 
!   alphabetically they will fall in the order: initialization vector table, code, 
!   linkage, build table vector.  The order in which they are collected does not affect
!   their order in the image section.
!
!   This is the only place where code and data should reside in the
!   same section.
!
!   NOTE: The linker will attach the fixup vectors to this cluster.  This is expected.
!
COLLECT=INITIALIZATION_PSECTS/ATTRIBUTES=INITIALIZATION_CODE,-
        EXEC$INIT_000,-
        EXEC$INIT_001,-
        EXEC$INIT_002,-
        EXEC$INIT_CODE,-
        EXEC$INIT_LINKAGE,-
        EXEC$INIT_SSTBL_000,-
        EXEC$INIT_SSTBL_001,-
        EXEC$INIT_SSTBL_002
$!
$QUIT: ! 'F$VERIFY(SAVED_VFY)'
$ EXIT $STATUS
