	PROGRAM	    DECDTM$EXAMPLE1
C
C This program assumes that files DECDTM$EXAMPLE1.FILE_1 and
C DECDTM$EXAMPLE1.FILE_2 are created and marked for recovery unit
C journaling using the command file SYS$EXAMPLES:DECDTM$EXAMPLE1.COM
C
C Type the following for VAX:
C $ FORTRAN SYS$EXAMPLES:DECDTM$EXAMPLE1
C $ LINK DECDTM$EXAMPLE1
C
C Type the following for ALPHA AXP(tm):
C $ FORTRAN/ALPHA SYS$EXAMPLES:DECDTM$EXAMPLE1
C $ LINK/ALPHA DECDTM$EXAMPLE1
C
C Then:
C $ @SYS$EXAMPLES:DECDTM$EXAMPLE1
C $ RUN DECDTM$EXAMPLE1
C
C SYS$EXAMPLES also contains a sample C program DECDTM$EXAMPLE2.C
C which performs the same functions on the same types of file
C  
	IMPLICIT    NONE

	INCLUDE	    '($SSDEF)'
	INCLUDE	    '($FORIOSDEF)'

	CHARACTER*12 STRING
	INTEGER*2   IOSB(4)
	INTEGER*4   STATUS,COUNT,TID(4)
	INTEGER*4   SYS$START_TRANSW,SYS$END_TRANSW,SYS$ABORT_TRANSW
	EXTERNAL    SYS$START_TRANSW,SYS$END_TRANSW,SYS$ABORT_TRANSW
	INTEGER*4   JOURNAL_OPEN
	EXTERNAL    JOURNAL_OPEN
C
C	Open the 2 files
C
	OPEN (UNIT = 10, FILE = 'DECDTM$EXAMPLE1.FILE_1', STATUS = 'OLD',
	1     ACCESS = 'DIRECT', RECL = 3, USEROPEN = JOURNAL_OPEN)
	OPEN (UNIT = 11, FILE = 'DECDTM$EXAMPLE1.FILE_2', STATUS = 'OLD',
	1     ACCESS = 'DIRECT', RECL = 3, USEROPEN = JOURNAL_OPEN)

	COUNT = 0

	TYPE *, 'Running DECdtm example program'
	TYPE *, 'Please hit CTRL-Y to interrupt'
C
C	Loop forever updating both files under transaction control
C
	DO WHILE (.TRUE.)
C
C	    Update the count and convert it to ASCII
C
	    COUNT = COUNT + 1
	    ENCODE (12,8000,STRING) COUNT
8000	    FORMAT (I12)
C
C	    Start the transaction
C
	    STATUS = SYS$START_TRANSW (%VAL(1),,IOSB,,,TID)
	    IF (STATUS .NE. SS$_NORMAL .OR. IOSB(1) .NE. SS$_NORMAL) GO TO 9040
C
C	    Update the record in each file
C
	    WRITE (UNIT = 10, REC = 1, ERR = 9000, IOSTAT = STATUS) STRING
	    WRITE (UNIT = 11, REC = 1, ERR = 9010, IOSTAT = STATUS) STRING
C
C	    End the transaction
C
	    STATUS = SYS$END_TRANSW (%VAL(1),,IOSB,,,TID)
	    IF (STATUS .NE. SS$_NORMAL .OR. IOSB(1) .NE. SS$_NORMAL) GO TO 9050

	END DO
C
C 	Errors which should cause the transaction to abort
C
9000	TYPE *, 'Failed to update DECDTM$EXAMPLE1.FILE_1'
	GO TO 9020

9010	TYPE *, 'Failed to update DECDTM$EXAMPLE1.FILE_2'
9020	STATUS = SYS$ABORT_TRANSW (%VAL(1),,IOSB,,,TID)
	IF (STATUS .NE. SS$_NORMAL .OR. IOSB(1) .NE. SS$_NORMAL) GO TO 9060
	STOP
C
C 	Errors from transaction processing services
C
9040	TYPE *, 'Unable to start a transaction'
	GO TO 9070
9050	TYPE *, 'Failed to commit the transaction'
	GO TO 9070
9060	TYPE *, 'Failed to abort the transaction'
9070	TYPE *, 'Status = ', STATUS, ' IOSB = ', IOSB(1)
	END
C
C 	Switch off TRUNCATE access and PUT with truncate on OPEN for RU Journaling
C
	INTEGER FUNCTION JOURNAL_OPEN (FAB, RAB, LUN)

	INCLUDE	'($FABDEF)'
	INCLUDE	'($RABDEF)'
	INCLUDE	'($SYSSRVNAM)'

	RECORD	/FABDEF/ FAB, /RABDEF/ RAB

	FAB.FAB$B_FAC = FAB.FAB$B_FAC .AND. .NOT. FAB$M_TRN
	RAB.RAB$L_ROP = RAB.RAB$L_ROP .AND. .NOT. RAB$M_TPT 

	JOURNAL_OPEN = SYS$OPEN (FAB)
	IF (.NOT. JOURNAL_OPEN) RETURN
	JOURNAL_OPEN = SYS$CONNECT (RAB)

	RETURN
	END
