 /*,  * xpath.c: XML Path Language implementationH  *          XPath is a language for addressing parts of an XML document,:  *          designed to be used by both XSLT and XPointer.  *4  * Reference: W3C Working Draft internal 5 July 1999D  *     http://www.w3.org/Style/XSL/Group/1999/07/xpath-19990705.html  * Public reference:%  *     http://www.w3.org/TR/WD-xpath/   *0  * See COPYRIGHT for the status of this software  *!  * Author: Daniel.Veillard@w3.org   */    #ifdef WIN32 #include "win32config.h" #else  #include "config.h"  #endif   #include "xmlversion.h"  #ifdef LIBXML_XPATH_ENABLED    #include <stdio.h> #include <string.h>    #ifdef HAVE_SYS_TYPES_H  #include <sys/types.h> #endif #ifdef HAVE_MATH_H #include <math.h>  #endif #ifdef HAVE_MATH_H #include <float.h> #endif #ifdef HAVE_IEEEFP_H #include <ieeefp.h>  #endif #ifdef HAVE_NAN_H  #include <nan.h> #endif #ifdef HAVE_CTYPE_H  #include <ctype.h> #endif   #include <libxml/xmlmemory.h>  #include <libxml/tree.h> #include <libxml/valid.h>  #include <libxml/xpath.h> # #include <libxml/parserInternals.h>    /* #define DEBUG */  /* #define DEBUG_STEP */ /* #define DEBUG_EXPR */   /*!  * Setup stuff for floating point D  * The lack of portability of this section of the libc is annoying !  */  double xmlXPathNAN = 0;  double xmlXPathPINF = 1; double xmlXPathMINF = -1;   
 #ifndef isinf  #ifndef HAVE_ISINF   #if HAVE_FPCLASS   int isinf(double d) {       fpclass_t	type = fpclass(d);     switch (type) {  	case FP_NINF: 	    return(-1); 	case FP_PINF: 	    return(1);      }      return(0); }   8 #elif defined(HAVE_FP_CLASS) || defined(HAVE_FP_CLASS_D)   #if HAVE_FP_CLASS_H  #include <fp_class.h>  #endif   int isinf(double d) {  #if HAVE_FP_CLASS      int	fpclass = fp_class(d); #else       int	fpclass = fp_class_d(d); #endif     if (fpclass == FP_POS_INF) 	return(1);      if (fpclass == FP_NEG_INF) 	return(-1);     return(0); }    #elif defined(HAVE_CLASS)    int isinf(double d) {      int	fpclass = class(d);      if (fpclass == FP_PLUS_INF)  	return(1);       if (fpclass == FP_MINUS_INF) 	return(-1);     return(0); } - #elif defined(finite) || defined(HAVE_FINITE) 2 int isinf(double x) { return !finite(x) && x==x; } #elif defined(HUGE_VAL)  int isinf(double x)  {      if (x == HUGE_VAL)         return(1);     if (x == -HUGE_VAL)          return(-1);      return(0); }  #endif     #endif /* ! HAVE_ISINF */  #endif /* ! defined(isinf) */   
 #ifndef isnan  #ifndef HAVE_ISNAN   #ifdef HAVE_ISNAND #define isnan(f) isnand(f) #endif /* HAVE_iSNAND */   #endif /* ! HAVE_iSNAN */  #endif /* ! defined(isnan) */    /**   * xmlXPathInit:  *#  * Initialize the XPath environment   */  void xmlXPathInit(void) {     static int initialized = 0;        if (initialized) return;       xmlXPathNAN = 0;     xmlXPathNAN /= 0;        xmlXPathPINF = 1;      xmlXPathPINF /= 0;       xmlXPathMINF = -1;     xmlXPathMINF /= 0;       initialized = 1; }    FILE *xmlXPathDebug = NULL;    #define TODO 								\?     fprintf(xmlXPathDebug, "Unimplemented block at %s:%d\n",		\               __FILE__, __LINE__);   #define STRANGE 							\;     fprintf(xmlXPathDebug, "Internal error at %s:%d\n",			\               __FILE__, __LINE__);  4 double xmlXPathStringEvalNumber(const xmlChar *str);F void xmlXPathStringFunction(xmlXPathParserContextPtr ctxt, int nargs);  I /************************************************************************   *									*2  * 		Parser stacks related functions and macros		*  *									*J  ************************************************************************/   /*>  * Generic function for accessing stacks in the Parser Context  */   & #define PUSH_AND_POP(type, name)					\D extern int name##Push(xmlXPathParserContextPtr ctxt, type value) {	\1     if (ctxt->name##Nr >= ctxt->name##Max) {				\  	ctxt->name##Max *= 2;						\ A         ctxt->name##Tab = (type *) xmlRealloc(ctxt->name##Tab,		\ > 	             ctxt->name##Max * sizeof(ctxt->name##Tab[0]));	\,         if (ctxt->name##Tab == NULL) {					\5 	    fprintf(xmlXPathDebug, "realloc failed !\n");		\  	    return(0);							\  	}								\      }									\ 1     ctxt->name##Tab[ctxt->name##Nr] = value;				\      ctxt->name = value;							\ $     return(ctxt->name##Nr++);						\ }									\ : extern type name##Pop(xmlXPathParserContextPtr ctxt) {			\     type ret;								\-     if (ctxt->name##Nr <= 0) return(0);					\      ctxt->name##Nr--;							\ "     if (ctxt->name##Nr > 0)						\5 	ctxt->name = ctxt->name##Tab[ctxt->name##Nr - 1];		\      else								\ !         ctxt->name = NULL;						\ /     ret = ctxt->name##Tab[ctxt->name##Nr];				\ -     ctxt->name##Tab[ctxt->name##Nr] = 0;				\      return(ret);							\ }									\   & PUSH_AND_POP(xmlXPathObjectPtr, value)   /*M  * Macros for accessing the content. Those should be used only by the parser,   * and not exported.  *L  * Dirty macros, i.e. one need to make assumption on the context to use them  *D  *   CUR_PTR return the current pointer to the xmlChar to be parsed.B  *   CUR     returns the current xmlChar value, i.e. a 8 bit value#  *           in ISO-Latin or UTF-8. 9  *           This should be used internally by the parser J  *           only to compare to ASCII values otherwise it would break when)  *           running with UTF-8 encoding. N  *   NXT(n)  returns the n'th next xmlChar. Same as CUR is should be used only1  *           to compare on ASCII based substring. M  *   SKIP(n) Skip n xmlChar, and must also be used only to skip ASCII defined '  *           strings within the parser. F  *   CURRENT Returns the current char value, with the full decoding of@  *           UTF-8 if we are using this mode. It returns an int.F  *   NEXT    Skip to the next character, this does the proper decodingJ  *           in UTF-8 mode. It also pop-up unfinished entities on the fly.;  *           It returns the pointer to the current xmlChar.   */    #define CUR (*ctxt->cur)$ #define SKIP(val) ctxt->cur += (val)! #define NXT(val) ctxt->cur[(val)]  #define CUR_PTR ctxt->cur    #define SKIP_BLANKS 							\'     while (IS_BLANK(*(ctxt->cur))) NEXT    #define CURRENT (*ctxt->cur)5 #define NEXT ((*ctxt->cur) ?  ctxt->cur++: ctxt->cur)   I /************************************************************************   *									*!  *			Error handling routines				*   *									*J  ************************************************************************/   #define XPATH_EXPRESSION_OK		0 #define XPATH_NUMBER_ERROR		1 ( #define XPATH_UNFINISHED_LITERAL_ERROR	2# #define XPATH_START_LITERAL_ERROR	3 " #define XPATH_VARIABLE_REF_ERROR	4$ #define XPATH_UNDEF_VARIABLE_ERROR	5' #define XPATH_INVALID_PREDICATE_ERROR	6  #define XPATH_EXPR_ERROR		7  #define XPATH_UNCLOSED_ERROR		8 " #define XPATH_UNKNOWN_FUNC_ERROR	9! #define XPATH_INVALID_OPERAND		10  #define XPATH_INVALID_TYPE		11 #define XPATH_INVALID_ARITY		12 # #define XPATH_INVALID_CTXT_SIZE		13 & #define XPATH_INVALID_CTXT_POSITION	14  ' const char *xmlXPathErrorMessages[] = { 	     "Ok",      "Number encoding",     "Unfinished litteral",     "Start of litteral",(     "Expected $ for variable reference",     "Undefined variable",      "Invalid predicate",     "Invalid expression", "     "Missing closing curly brace",     "Unregistered function",     "Invalid operand",     "Invalid type", "     "Invalid number of arguments",     "Invalid context size",      "Invalid context position",  };   /**   * xmlXPathError: #  * @ctxt:  the XPath Parser context   * @file:  the file name  * @line:  the line number  * @no:  the error number   *>  * Create a new xmlNodeSetPtr of type double and of value @val  *$  * Returns the newly created object.  */  void> xmlXPatherror(xmlXPathParserContextPtr ctxt, const char *file,!               int line, int no) { 
     int n;     const xmlChar *cur;      const xmlChar *base;  ;     fprintf(xmlXPathDebug, "Error %s:%d: %s\n", file, line, '             xmlXPathErrorMessages[no]);        cur = ctxt->cur;     base = ctxt->base;@     while ((cur > base) && ((*cur == '\n') || (*cur == '\r'))) { 	cur--;      } 
     n = 0;J     while ((n++ < 80) && (cur > base) && (*cur != '\n') && (*cur != '\r'))         cur--;0     if ((*cur == '\n') || (*cur == '\r')) cur++;     base = cur; 
     n = 0;I     while ((*cur != 0) && (*cur != '\n') && (*cur != '\r') && (n < 79)) { =         fprintf(xmlXPathDebug, "%c", (unsigned char) *cur++);  	n++;      } !     fprintf(xmlXPathDebug, "\n");      cur = ctxt->cur;,     while ((*cur == '\n') || (*cur == '\r')) 	cur--; 
     n = 0;)     while ((cur != base) && (n++ < 80)) { $         fprintf(xmlXPathDebug, " ");         base++;      } !     fprintf(xmlXPathDebug,"^\n");  }    #define CHECK_ERROR							\ 2     if (ctxt->error != XPATH_EXPRESSION_OK) return   #define XP_ERROR(X)							\ 5     { xmlXPatherror(ctxt, __FILE__, __LINE__, X);			\ "       ctxt->error = (X); return; }   #define XP_ERROR0(X)							\5     { xmlXPatherror(ctxt, __FILE__, __LINE__, X);			\ %       ctxt->error = (X); return(0); }   " #define CHECK_TYPE(typeval)						\B     if ((ctxt->value == NULL) || (ctxt->value->type != typeval))	\*         XP_ERROR(XPATH_INVALID_TYPE)					\    I /************************************************************************   *									*$  *			Routines to handle NodeSets			*  *									*J  ************************************************************************/   #define XML_NODESET_DEFAULT	10 /**   * xmlXPathNodeSetCreate: (  * @val:  an initial xmlNodePtr, or NULL  *>  * Create a new xmlNodeSetPtr of type double and of value @val  *$  * Returns the newly created object.  */ 
 xmlNodeSetPtr ' xmlXPathNodeSetCreate(xmlNodePtr val) {      xmlNodeSetPtr ret;  8     ret = (xmlNodeSetPtr) xmlMalloc(sizeof(xmlNodeSet));     if (ret == NULL) {F         fprintf(xmlXPathDebug, "xmlXPathNewNodeSet: out of memory\n"); 	return(NULL);     } 1     memset(ret, 0 , (size_t) sizeof(xmlNodeSet));      if (val != NULL) {E         ret->nodeTab = (xmlNodePtr *) xmlMalloc(XML_NODESET_DEFAULT *  					     sizeof(xmlNodePtr)); 	if (ret->nodeTab == NULL) {C 	    fprintf(xmlXPathDebug, "xmlXPathNewNodeSet: out of memory\n");  	    return(NULL); 	} 	memset(ret->nodeTab, 0 , ; 	       XML_NODESET_DEFAULT * (size_t) sizeof(xmlNodePtr)); +         ret->nodeMax = XML_NODESET_DEFAULT; # 	ret->nodeTab[ret->nodeNr++] = val;      }      return(ret); }    /**   * xmlXPathNodeSetAdd:  * @cur:  the initial node set  * @val:  a new xmlNodePtr  *.  * add a new xmlNodePtr ot an existing NodeSet  */  void7 xmlXPathNodeSetAdd(xmlNodeSetPtr cur, xmlNodePtr val) { 
     int i;       if (val == NULL) return;       /*      * check against doublons       */ #     for (i = 0;i < cur->nodeNr;i++) +         if (cur->nodeTab[i] == val) return;        /*!      * grow the nodeTab if needed       */      if (cur->nodeMax == 0) {E         cur->nodeTab = (xmlNodePtr *) xmlMalloc(XML_NODESET_DEFAULT *  					     sizeof(xmlNodePtr)); 	if (cur->nodeTab == NULL) {C 	    fprintf(xmlXPathDebug, "xmlXPathNodeSetAdd: out of memory\n");  	    return; 	} 	memset(cur->nodeTab, 0 , ; 	       XML_NODESET_DEFAULT * (size_t) sizeof(xmlNodePtr)); +         cur->nodeMax = XML_NODESET_DEFAULT; -     } else if (cur->nodeNr == cur->nodeMax) {          xmlNodePtr *temp;            cur->nodeMax *= 2;> 	temp = (xmlNodePtr *) xmlRealloc(cur->nodeTab, cur->nodeMax * 				      sizeof(xmlNodePtr)); 	if (temp == NULL) {C 	    fprintf(xmlXPathDebug, "xmlXPathNodeSetAdd: out of memory\n");  	    return; 	} 	cur->nodeTab = temp;      } &     cur->nodeTab[cur->nodeNr++] = val; }    /**   * xmlXPathNodeSetMerge:  * @val1:  the first NodeSet  * @val2:  the second NodeSet   *?  * Merges two nodesets, all nodes from @val2 are added to @val1   *7  * Returns val1 once extended or NULL in case of error.   */ 
 xmlNodeSetPtr > xmlXPathNodeSetMerge(xmlNodeSetPtr val1, xmlNodeSetPtr val2) {
     int i;  #     if (val1 == NULL) return(NULL); #     if (val2 == NULL) return(val1);        /*;      * !!!!! this can be optimized a lot, knowing that both @      *       val1 and val2 already have unicity of their values.      */   $     for (i = 0;i < val2->nodeNr;i++)3         xmlXPathNodeSetAdd(val1, val2->nodeTab[i]);        return(val1);  }    /**   * xmlXPathNodeSetDel:  * @cur:  the initial node set  * @val:  an xmlNodePtr   *1  * Removes an xmlNodePtr from an existing NodeSet   */  void7 xmlXPathNodeSetDel(xmlNodeSetPtr cur, xmlNodePtr val) { 
     int i;       if (cur == NULL) return;     if (val == NULL) return;       /*      * check against doublons       */ #     for (i = 0;i < cur->nodeNr;i++) *         if (cur->nodeTab[i] == val) break;       if (i >= cur->nodeNr) {  #ifdef DEBUG         fprintf(xmlXPathDebug,  B 	        "xmlXPathNodeSetDel: Node %s wasn't found in NodeList\n",
 		val->name);  #endif         return;      }      cur->nodeNr--;     for (;i < cur->nodeNr;i++).         cur->nodeTab[i] = cur->nodeTab[i + 1];%     cur->nodeTab[cur->nodeNr] = NULL;  }    /**   * xmlXPathNodeSetRemove:   * @cur:  the initial node set  * @val:  the index to remove   *2  * Removes an entry from an existing NodeSet list.  */  void3 xmlXPathNodeSetRemove(xmlNodeSetPtr cur, int val) {      if (cur == NULL) return;#     if (val >= cur->nodeNr) return;      cur->nodeNr--;"     for (;val < cur->nodeNr;val++)2         cur->nodeTab[val] = cur->nodeTab[val + 1];%     cur->nodeTab[cur->nodeNr] = NULL;  }    /**   * xmlXPathFreeNodeSet: #  * @obj:  the xmlNodeSetPtr to free   *6  * Free the NodeSet compound (not the actual nodes !).  */  void( xmlXPathFreeNodeSet(xmlNodeSetPtr obj) {     if (obj == NULL) return;     if (obj->nodeTab != NULL) {  #ifdef DEBUGH 	memset(obj->nodeTab, 0xB , (size_t) sizeof(xmlNodePtr) * obj->nodeMax); #endif 	xmlFree(obj->nodeTab);      }  #ifdef DEBUG3     memset(obj, 0xB , (size_t) sizeof(xmlNodeSet));  #endif     xmlFree(obj);  }   ) #if defined(DEBUG) || defined(DEBUG_STEP)  /**   * xmlXPathDebugNodeSet:$  * @output:  a FILE * for the output#  * @obj:  the xmlNodeSetPtr to free   *  * Quick display of a NodeSet   */  void7 xmlXPathDebugNodeSet(FILE *output, xmlNodeSetPtr obj) { 
     int i;  /     if (output == NULL) output = xmlXPathDebug;      if (obj == NULL)  { /         fprintf(output, "NodeSet == NULL !\n");  	return;     }      if (obj->nodeNr == 0) { .         fprintf(output, "NodeSet is empty\n"); 	return;     }      if (obj->nodeTab == NULL) { ) 	fprintf(output, " nodeTab == NULL !\n");  	return;     } '     for (i = 0; i < obj->nodeNr; i++) { &         if (obj->nodeTab[i] == NULL) {" 	    fprintf(output, " NULL !\n"); 	    return;	         } 4 	if ((obj->nodeTab[i]->type == XML_DOCUMENT_NODE) ||7 	    (obj->nodeTab[i]->type == XML_HTML_DOCUMENT_NODE))  	    fprintf(output, " /"); ( 	else if (obj->nodeTab[i]->name == NULL)! 	    fprintf(output, " noname!"); 4 	else fprintf(output, " %s", obj->nodeTab[i]->name);     }      fprintf(output, "\n"); }  #endif  I /************************************************************************   *									*$  *			Routines to handle Variable			*  *									*!  *			UNIMPLEMENTED CURRENTLY				*   *									*J  ************************************************************************/   /**   * xmlXPathVariablelookup:#  * @ctxt:  the XPath Parser context /  * @prefix:  the variable name namespace if any   * @name:  the variable name  *<  * Search in the Variable array of the context for the given  * variable value.  *%  * UNIMPLEMENTED: always return NULL.   *)  * Returns the value or NULL if not found   */  xmlXPathObjectPtr 5 xmlXPathVariablelookup(xmlXPathParserContextPtr ctxt, D                        const xmlChar *prefix, const xmlChar *name) {     return(NULL);  }   I /************************************************************************   *									*"  *			Routines to handle Values			*  *									*J  ************************************************************************/  A /* Allocations are terrible, one need to optimize all this !!! */    /**   * xmlXPathNewFloat:  * @val:  the double value  *B  * Create a new xmlXPathObjectPtr of type double and of value @val  *$  * Returns the newly created object.  */  xmlXPathObjectPtr  xmlXPathNewFloat(double val) {     xmlXPathObjectPtr ret;  @     ret = (xmlXPathObjectPtr) xmlMalloc(sizeof(xmlXPathObject));     if (ret == NULL) {D         fprintf(xmlXPathDebug, "xmlXPathNewFloat: out of memory\n"); 	return(NULL);     } 5     memset(ret, 0 , (size_t) sizeof(xmlXPathObject));      ret->type = XPATH_NUMBER;      ret->floatval = val;     return(ret); }    /**   * xmlXPathNewBoolean:  * @val:  the boolean value   *C  * Create a new xmlXPathObjectPtr of type boolean and of value @val   *$  * Returns the newly created object.  */  xmlXPathObjectPtr  xmlXPathNewBoolean(int val) {      xmlXPathObjectPtr ret;  @     ret = (xmlXPathObjectPtr) xmlMalloc(sizeof(xmlXPathObject));     if (ret == NULL) {D         fprintf(xmlXPathDebug, "xmlXPathNewFloat: out of memory\n"); 	return(NULL);     } 5     memset(ret, 0 , (size_t) sizeof(xmlXPathObject));      ret->type = XPATH_BOOLEAN;     ret->boolval = (val != 0);     return(ret); }    /**   * xmlXPathNewString:   * @val:  the xmlChar * value   *B  * Create a new xmlXPathObjectPtr of type string and of value @val  *$  * Returns the newly created object.  */  xmlXPathObjectPtr ' xmlXPathNewString(const xmlChar *val) {      xmlXPathObjectPtr ret;  @     ret = (xmlXPathObjectPtr) xmlMalloc(sizeof(xmlXPathObject));     if (ret == NULL) {D         fprintf(xmlXPathDebug, "xmlXPathNewFloat: out of memory\n"); 	return(NULL);     } 5     memset(ret, 0 , (size_t) sizeof(xmlXPathObject));      ret->type = XPATH_STRING; $     ret->stringval = xmlStrdup(val);     return(ret); }    /**   * xmlXPathNewCString:  * @val:  the char * value  *B  * Create a new xmlXPathObjectPtr of type string and of value @val  *$  * Returns the newly created object.  */  xmlXPathObjectPtr % xmlXPathNewCString(const char *val) {      xmlXPathObjectPtr ret;  @     ret = (xmlXPathObjectPtr) xmlMalloc(sizeof(xmlXPathObject));     if (ret == NULL) {D         fprintf(xmlXPathDebug, "xmlXPathNewFloat: out of memory\n"); 	return(NULL);     } 5     memset(ret, 0 , (size_t) sizeof(xmlXPathObject));      ret->type = XPATH_STRING; -     ret->stringval = xmlStrdup(BAD_CAST val);      return(ret); }    /**   * xmlXPathNewNodeSet:  * @val:  the NodePtr value   *@  * Create a new xmlXPathObjectPtr of type NodeSet and initialize  * it with the single Node @val   *$  * Returns the newly created object.  */  xmlXPathObjectPtr $ xmlXPathNewNodeSet(xmlNodePtr val) {     xmlXPathObjectPtr ret;  @     ret = (xmlXPathObjectPtr) xmlMalloc(sizeof(xmlXPathObject));     if (ret == NULL) {D         fprintf(xmlXPathDebug, "xmlXPathNewFloat: out of memory\n"); 	return(NULL);     } 5     memset(ret, 0 , (size_t) sizeof(xmlXPathObject));      ret->type = XPATH_NODESET;1     ret->nodesetval = xmlXPathNodeSetCreate(val);      return(ret); }    /**   * xmlXPathNewNodeSetList:  * @val:  an existing NodeSet   *@  * Create a new xmlXPathObjectPtr of type NodeSet and initialize  * it with the Nodeset @val   *$  * Returns the newly created object.  */  xmlXPathObjectPtr + xmlXPathNewNodeSetList(xmlNodeSetPtr val) {      xmlXPathObjectPtr ret;
     int i;       if (val == NULL)     	ret = NULL;"     else if (val->nodeTab == NULL)$ 	    ret = xmlXPathNewNodeSet(NULL);     else     	{/ 	    ret = xmlXPathNewNodeSet(val->nodeTab[0]); & 	    for (i = 1; i < val->nodeNr; ++i); 	    	xmlXPathNodeSetAdd(ret->nodesetval, val->nodeTab[i]);  	    }       return(ret); }    /**   * xmlXPathFreeNodeSetList: (  * @obj:  an existing NodeSetList object  *I  * Free up the xmlXPathObjectPtr @obj but don't deallocate the objects in -  * the list contrary to xmlXPathFreeObject().   */  void0 xmlXPathFreeNodeSetList(xmlXPathObjectPtr obj) {     if (obj == NULL) return; #ifdef DEBUG7     memset(obj, 0xB , (size_t) sizeof(xmlXPathObject));  #endif     xmlFree(obj);  }    /**   * xmlXPathFreeObject:  * @obj:  the object to free  *'  * Free up an xmlXPathObjectPtr object.   */  void+ xmlXPathFreeObject(xmlXPathObjectPtr obj) {      if (obj == NULL) return;      if (obj->nodesetval != NULL)-         xmlXPathFreeNodeSet(obj->nodesetval);      if (obj->stringval != NULL)           xmlFree(obj->stringval); #ifdef DEBUG7     memset(obj, 0xB , (size_t) sizeof(xmlXPathObject));  #endif     xmlFree(obj);  }   I /************************************************************************   *									*)  *		Routines to handle XPath contexts			*   *									*J  ************************************************************************/   /**   * xmlXPathNewContext:  * @doc:  the XML document  *  * Create a new xmlXPathContext   *.  * Returns the xmlXPathContext just allocated.  */  xmlXPathContextPtr# xmlXPathNewContext(xmlDocPtr doc) {      xmlXPathContextPtr ret;   B     ret = (xmlXPathContextPtr) xmlMalloc(sizeof(xmlXPathContext));     if (ret == NULL) {F         fprintf(xmlXPathDebug, "xmlXPathNewContext: out of memory\n"); 	return(NULL);     } 6     memset(ret, 0 , (size_t) sizeof(xmlXPathContext));     ret->doc = doc;   /***********   !     ret->node = (xmlNodePtr) doc; 5     ret->nodelist = xmlXPathNodeSetCreate(ret->node);    ***********/       ret->node = NULL;      ret->nodelist = NULL;        ret->nb_variables = 0;     ret->max_variables = 0;      ret->variables = NULL;       ret->nb_types = 0;     ret->max_types = 0;      ret->types = NULL;       ret->nb_funcs = 0;     ret->max_funcs = 0;      ret->funcs = NULL;       ret->nb_axis = 0;      ret->max_axis = 0;     ret->axis = NULL;        ret->namespaces = NULL;      ret->user = NULL;      ret->nsNr = 0;       ret->contextSize = -1;      ret->proximityPosition = -1;     return(ret); }    /**   * xmlXPathFreeContext:   * @ctxt:  the context to free  *  * Free up an xmlXPathContext   */  void. xmlXPathFreeContext(xmlXPathContextPtr ctxt) {!     if (ctxt->namespaces != NULL) "         xmlFree(ctxt->namespaces);        if (ctxt->nodelist != NULL) ,         xmlXPathFreeNodeSet(ctxt->nodelist); #ifdef DEBUG9     memset(ctxt, 0xB , (size_t) sizeof(xmlXPathContext));  #endif     xmlFree(ctxt); }   I /************************************************************************   *									*/  *		Routines to handle XPath parser contexts		*   *									*J  ************************************************************************/   #define CHECK_CTXT							\     if (ctxt == NULL) { 						\ H         fprintf(xmlXPathDebug, "%s:%d Internal error: ctxt == NULL\n",	\# 	        __FILE__, __LINE__);					\      }									\      #define CHECK_CONTEXT							\      if (ctxt == NULL) { 						\ F         fprintf(xmlXPathDebug, "%s:%d Internal error: no context\n",	\# 	        __FILE__, __LINE__);					\      }									\ $     if (ctxt->doc == NULL) { 						\G         fprintf(xmlXPathDebug, "%s:%d Internal error: no document\n",	\ # 	        __FILE__, __LINE__);					\      }									\ -     if (ctxt->doc->children == NULL) { 					\ %         fprintf(xmlXPathDebug,						\ ; 	        "%s:%d Internal error: document without root\n",	\ # 	        __FILE__, __LINE__);					\      }									\      /**   * xmlXPathNewParserContext:  * @str:  the XPath expression  * @ctxt:  the XPath context  *%  * Create a new xmlXPathParserContext   *4  * Returns the xmlXPathParserContext just allocated.  */  xmlXPathParserContextPtrG xmlXPathNewParserContext(const xmlChar *str, xmlXPathContextPtr ctxt) { !     xmlXPathParserContextPtr ret;   N     ret = (xmlXPathParserContextPtr) xmlMalloc(sizeof(xmlXPathParserContext));     if (ret == NULL) {L         fprintf(xmlXPathDebug, "xmlXPathNewParserContext: out of memory\n"); 	return(NULL);     } <     memset(ret, 0 , (size_t) sizeof(xmlXPathParserContext));     ret->cur = ret->base = str;      ret->context = ctxt;  "     /* Allocate the value stack */*     ret->valueTab = (xmlXPathObjectPtr *) ?                      xmlMalloc(10 * sizeof(xmlXPathObjectPtr));      ret->valueNr = 0;      ret->valueMax = 10;      ret->value = NULL;     return(ret); }    /**   * xmlXPathFreeParserContext:   * @ctxt:  the context to free  *#  * Free up an xmlXPathParserContext   */  void: xmlXPathFreeParserContext(xmlXPathParserContextPtr ctxt) {!     if (ctxt->valueTab != NULL) {  #ifdef DEBUGN         memset(ctxt->valueTab, 0xB , 10 * (size_t) sizeof(xmlXPathObjectPtr)); #endif          xmlFree(ctxt->valueTab);     }  #ifdef DEBUG?     memset(ctxt, 0xB , (size_t) sizeof(xmlXPathParserContext));  #endif     xmlFree(ctxt); }   I /************************************************************************   *									**  *		The implicit core function library			*  *									*J  ************************************************************************/   /*   * Auto-pop and cast to a number  */ F void xmlXPathNumberFunction(xmlXPathParserContextPtr ctxt, int nargs);   #define CHECK_ARITY(x)						\      if (nargs != (x)) {						\+         XP_ERROR(XPATH_INVALID_ARITY);				\      }								\     #define POP_FLOAT						\     arg = valuePop(ctxt);					\      if (arg == NULL) {						\ & 	XP_ERROR(XPATH_INVALID_OPERAND);				\     }								\)     if (arg->type != XPATH_NUMBER) {				\ #         valuePush(ctxt, arg);					\ ,         xmlXPathNumberFunction(ctxt, 1);			\ 	arg = valuePop(ctxt);					\     }    /**   * xmlXPathEqualNodeSetString %  * @arg:  the nodeset object argument #  * @str:  the string to compare to.   *I  * Implement the equal operation on XPath objects content: @arg1 == @arg2 H  * If one object to be compared is a node-set and the other is a string,E  * then the comparison will be true if and only if there is a node in H  * the node-set such that the result of performing the comparison on the9  * string-value of the node and the other string is true.   *7  * Returns 0 or 1 depending on the results of the test.   */  int G xmlXPathEqualNodeSetString(xmlXPathObjectPtr arg, const xmlChar *str) { 
     int i;     xmlNodeSetPtr ns;      xmlChar *str2;  G     if ((str == NULL) || (arg == NULL) || (arg->type != XPATH_NODESET))          return(0);     ns = arg->nodesetval; $     for (i = 0;i < ns->nodeNr;i++) {2          str2 = xmlNodeGetContent(ns->nodeTab[i]);3 	 if ((str2 != NULL) && (xmlStrEqual(str, str2))) {  	     xmlFree(str2); 	     return(1); 	 }  	 xmlFree(str2);     }      return(0); }    /**   * xmlXPathEqualNodeSetFloat%  * @arg:  the nodeset object argument   * @f:  the float to compare to   *I  * Implement the equal operation on XPath objects content: @arg1 == @arg2 H  * If one object to be compared is a node-set and the other is a number,E  * then the comparison will be true if and only if there is a node in H  * the node-set such that the result of performing the comparison on theI  * number to be compared and on the result of converting the string-value >  * of that node to a number using the number function is true.  *7  * Returns 0 or 1 depending on the results of the test.   */  int ; xmlXPathEqualNodeSetFloat(xmlXPathObjectPtr arg, float f) {      char buf[100] = "";   6     if ((arg == NULL) || (arg->type != XPATH_NODESET))         return(0);       if (isnan(f))  	sprintf(buf, "NaN");      else if (isinf(f) > 0) 	sprintf(buf, "+Infinity");      else if (isinf(f) < 0) 	sprintf(buf, "-Infinity");      else 	sprintf(buf, "%0g", f);  :     return(xmlXPathEqualNodeSetString(arg, BAD_CAST buf)); }      /**   * xmlXPathEqualNodeSets(  * @arg1:  first nodeset object argument)  * @arg2:  second nodeset object argument   *B  * Implement the equal operation on XPath nodesets: @arg1 == @arg2D  * If both objects to be compared are node-sets, then the comparisonH  * will be true if and only if there is a node in the first node-set andG  * a node in the second node-set such that the result of performing the <  * comparison on the string-values of the two nodes is true.  *0  * (needless to say, this is a costly operation)  *7  * Returns 0 or 1 depending on the results of the test.   */  int G xmlXPathEqualNodeSets(xmlXPathObjectPtr arg1, xmlXPathObjectPtr arg2) { 
     int i;     xmlNodeSetPtr ns;      xmlChar *str;   8     if ((arg1 == NULL) || (arg1->type != XPATH_NODESET))         return(0);8     if ((arg2 == NULL) || (arg2->type != XPATH_NODESET))         return(0);       ns = arg1->nodesetval;$     for (i = 0;i < ns->nodeNr;i++) {1          str = xmlNodeGetContent(ns->nodeTab[i]); A 	 if ((str != NULL) && (xmlXPathEqualNodeSetString(arg2, str))) {  	     xmlFree(str);  	     return(1); 	 }  	 xmlFree(str);      }      return(0); }    /**   * xmlXPathEqualValues: #  * @ctxt:  the XPath Parser context   *I  * Implement the equal operation on XPath objects content: @arg1 == @arg2   *7  * Returns 0 or 1 depending on the results of the test.   */  int 4 xmlXPathEqualValues(xmlXPathParserContextPtr ctxt) {!     xmlXPathObjectPtr arg1, arg2;      int ret = 0;       arg1 = valuePop(ctxt);     if (arg1 == NULL) " 	XP_ERROR0(XPATH_INVALID_OPERAND);       arg2 = valuePop(ctxt);     if (arg2 == NULL) {  	xmlXPathFreeObject(arg1);" 	XP_ERROR0(XPATH_INVALID_OPERAND);     }         if (arg1 == arg2) {  #ifdef DEBUG_EXPR 6         fprintf(xmlXPathDebug, "Equal: by pointer\n"); #endif         return(1);     }        switch (arg1->type) {          case XPATH_UNDEFINED:  #ifdef DEBUG_EXPR 2 	    fprintf(xmlXPathDebug, "Equal: undefined\n"); #endif 	    break;          case XPATH_NODESET:  	    switch (arg2->type) { 	        case XPATH_UNDEFINED: #ifdef DEBUG_EXPR 3 		    fprintf(xmlXPathDebug, "Equal: undefined\n");  #endif 		    break; 		case XPATH_NODESET: . 		    ret = xmlXPathEqualNodeSets(arg1, arg2); 		    break; 		case XPATH_BOOLEAN: ' 		    if ((arg1->nodesetval == NULL) || , 			(arg1->nodesetval->nodeNr == 0)) ret = 0; 		    else   			ret = 1; # 		    ret = (ret == arg2->boolval);  		    break; 		case XPATH_NUMBER:< 		    ret = xmlXPathEqualNodeSetFloat(arg1, arg2->floatval); 		    break; 		case XPATH_STRING:> 		    ret = xmlXPathEqualNodeSetString(arg1, arg2->stringval); 		    break; 	    } 	    break;          case XPATH_BOOLEAN:  	    switch (arg2->type) { 	        case XPATH_UNDEFINED: #ifdef DEBUG_EXPR 3 		    fprintf(xmlXPathDebug, "Equal: undefined\n");  #endif 		    break; 		case XPATH_NODESET: ' 		    if ((arg2->nodesetval == NULL) || , 			(arg2->nodesetval->nodeNr == 0)) ret = 0; 		    else   			ret = 1;  		    break; 		case XPATH_BOOLEAN:  #ifdef DEBUG_EXPR 7 		    fprintf(xmlXPathDebug, "Equal: %d boolean %d \n", % 			    arg1->boolval, arg2->boolval);  #endif- 		    ret = (arg1->boolval == arg2->boolval);  		    break; 		case XPATH_NUMBER:" 		    if (arg2->floatval) ret = 1; 		    else ret = 0; # 		    ret = (arg1->boolval == ret);  		    break; 		case XPATH_STRING:& 		    if ((arg2->stringval == NULL) ||& 			(arg2->stringval[0] == 0)) ret = 0; 		    else   			ret = 1; # 		    ret = (arg1->boolval == ret);  		    break; 	    } 	    break;          case XPATH_NUMBER: 	    switch (arg2->type) { 	        case XPATH_UNDEFINED: #ifdef DEBUG_EXPR 3 		    fprintf(xmlXPathDebug, "Equal: undefined\n");  #endif 		    break; 		case XPATH_NODESET: < 		    ret = xmlXPathEqualNodeSetFloat(arg2, arg1->floatval); 		    break; 		case XPATH_BOOLEAN: " 		    if (arg1->floatval) ret = 1; 		    else ret = 0; # 		    ret = (arg2->boolval == ret);  		    break; 		case XPATH_STRING: 		    valuePush(ctxt, arg2);& 		    xmlXPathNumberFunction(ctxt, 1); 		    arg2 = valuePop(ctxt); 		    /* no break on purpose */  		case XPATH_NUMBER:/ 		    ret = (arg1->floatval == arg2->floatval);  		    break; 	    } 	    break;          case XPATH_STRING: 	    switch (arg2->type) { 	        case XPATH_UNDEFINED: #ifdef DEBUG_EXPR 3 		    fprintf(xmlXPathDebug, "Equal: undefined\n");  #endif 		    break; 		case XPATH_NODESET: > 		    ret = xmlXPathEqualNodeSetString(arg2, arg1->stringval); 		    break; 		case XPATH_BOOLEAN: & 		    if ((arg1->stringval == NULL) ||& 			(arg1->stringval[0] == 0)) ret = 0; 		    else   			ret = 1; # 		    ret = (arg2->boolval == ret);  		    break; 		case XPATH_STRING:: 		    ret = xmlStrEqual(arg1->stringval, arg2->stringval); 		    break; 		case XPATH_NUMBER: 		    valuePush(ctxt, arg1);& 		    xmlXPathNumberFunction(ctxt, 1); 		    arg1 = valuePop(ctxt);/ 		    ret = (arg1->floatval == arg2->floatval);  		    break; 	    } 	    break;      }      xmlXPathFreeObject(arg1);      xmlXPathFreeObject(arg2);      return(ret); }    /**   * xmlXPathCompareValues: #  * @ctxt:  the XPath Parser context +  * @inf:  less than (1) or greater than (2) %  * @strict:  is the comparison strict   *5  * Implement the compare operation on XPath objects:  "  *     @arg1 < @arg2    (1, 1, ..."  *     @arg1 <= @arg2   (1, 0, ..."  *     @arg1 > @arg2    (0, 1, ..."  *     @arg1 >= @arg2   (0, 0, ...  *G  * When neither object to be compared is a node-set and the operator is H  * <=, <, >=, >, then the objects are compared by converted both objectsD  * to numbers and comparing the numbers according to IEEE 754. The <K  * comparison will be true if and only if the first number is less than the I  * second number. The <= comparison will be true if and only if the first F  * number is less than or equal to the second number. The > comparisonJ  * will be true if and only if the first number is greater than the secondI  * number. The >= comparison will be true if and only if the first number 1  * is greater than or equal to the second number.   */  int K xmlXPathCompareValues(xmlXPathParserContextPtr ctxt, int inf, int strict) {      int ret = 0;!     xmlXPathObjectPtr arg1, arg2;        arg2 = valuePop(ctxt);:     if ((arg2 == NULL) || (arg2->type == XPATH_NODESET)) {         if (arg2 != NULL)  	    xmlXPathFreeObject(arg2);" 	XP_ERROR0(XPATH_INVALID_OPERAND);     }         arg1 = valuePop(ctxt);:     if ((arg1 == NULL) || (arg1->type == XPATH_NODESET)) {         if (arg1 != NULL)  	    xmlXPathFreeObject(arg1); 	xmlXPathFreeObject(arg2);" 	XP_ERROR0(XPATH_INVALID_OPERAND);     }   %     if (arg1->type != XPATH_NUMBER) {  	valuePush(ctxt, arg1); ! 	xmlXPathNumberFunction(ctxt, 1);  	arg1 = valuePop(ctxt);      } %     if (arg1->type != XPATH_NUMBER) {  	xmlXPathFreeObject(arg1); 	xmlXPathFreeObject(arg2);" 	XP_ERROR0(XPATH_INVALID_OPERAND);     } %     if (arg2->type != XPATH_NUMBER) {  	valuePush(ctxt, arg2); ! 	xmlXPathNumberFunction(ctxt, 1);  	arg2 = valuePop(ctxt);      } %     if (arg2->type != XPATH_NUMBER) {  	xmlXPathFreeObject(arg1); 	xmlXPathFreeObject(arg2);" 	XP_ERROR0(XPATH_INVALID_OPERAND);     }      /*%      * Add tests for infinity and nan )      * => feedback on 3.4 for Inf and NaN       */      if (inf && strict)  0         ret = (arg1->floatval < arg2->floatval);     else if (inf && !strict)1         ret = (arg1->floatval <= arg2->floatval);      else if (!inf && strict)0         ret = (arg1->floatval > arg2->floatval);     else if (!inf && !strict) 1         ret = (arg1->floatval >= arg2->floatval);      xmlXPathFreeObject(arg1);      xmlXPathFreeObject(arg2);      return(ret); }    /**   * xmlXPathValueFlipSign: #  * @ctxt:  the XPath Parser context   *5  * Implement the unary - operation on an XPath object @  * The numeric operators convert their operands to numbers as if"  * by calling the number function.  */  void6 xmlXPathValueFlipSign(xmlXPathParserContextPtr ctxt) {     xmlXPathObjectPtr arg;     
     POP_FLOAT #     arg->floatval = -arg->floatval;      valuePush(ctxt, arg);  }    /**   * xmlXPathAddValues: #  * @ctxt:  the XPath Parser context   *0  * Implement the add operation on XPath objects:@  * The numeric operators convert their operands to numbers as if"  * by calling the number function.  */  void2 xmlXPathAddValues(xmlXPathParserContextPtr ctxt) {     xmlXPathObjectPtr arg;     double val;   
     POP_FLOAT      val = arg->floatval;     xmlXPathFreeObject(arg);  
     POP_FLOAT      arg->floatval += val;      valuePush(ctxt, arg);  }    /**   * xmlXPathSubValues: #  * @ctxt:  the XPath Parser context   *9  * Implement the substraction operation on XPath objects: @  * The numeric operators convert their operands to numbers as if"  * by calling the number function.  */  void2 xmlXPathSubValues(xmlXPathParserContextPtr ctxt) {     xmlXPathObjectPtr arg;     double val;   
     POP_FLOAT      val = arg->floatval;     xmlXPathFreeObject(arg);  
     POP_FLOAT      arg->floatval -= val;      valuePush(ctxt, arg);  }    /**   * xmlXPathMultValues:#  * @ctxt:  the XPath Parser context   *5  * Implement the multiply operation on XPath objects: @  * The numeric operators convert their operands to numbers as if"  * by calling the number function.  */  void3 xmlXPathMultValues(xmlXPathParserContextPtr ctxt) {      xmlXPathObjectPtr arg;     double val;   
     POP_FLOAT      val = arg->floatval;     xmlXPathFreeObject(arg);  
     POP_FLOAT      arg->floatval *= val;      valuePush(ctxt, arg);  }    /**   * xmlXPathDivValues: #  * @ctxt:  the XPath Parser context   *0  * Implement the div operation on XPath objects:@  * The numeric operators convert their operands to numbers as if"  * by calling the number function.  */  void2 xmlXPathDivValues(xmlXPathParserContextPtr ctxt) {     xmlXPathObjectPtr arg;     double val;   
     POP_FLOAT      val = arg->floatval;     xmlXPathFreeObject(arg);  
     POP_FLOAT      arg->floatval /= val;      valuePush(ctxt, arg);  }    /**   * xmlXPathModValues: #  * @ctxt:  the XPath Parser context   *>  * Implement the div operation on XPath objects: @arg1 / @arg2@  * The numeric operators convert their operands to numbers as if"  * by calling the number function.  */  void2 xmlXPathModValues(xmlXPathParserContextPtr ctxt) {     xmlXPathObjectPtr arg;     double val;   
     POP_FLOAT      val = arg->floatval;     xmlXPathFreeObject(arg);  
     POP_FLOAT      arg->floatval /= val;      valuePush(ctxt, arg);  }   I /************************************************************************   *									*!  *		The traversal functions					*   *									*J  ************************************************************************/   #define AXIS_ANCESTOR			1   #define AXIS_ANCESTOR_OR_SELF		2 #define AXIS_ATTRIBUTE			3 #define AXIS_CHILD			4 #define AXIS_DESCENDANT			5 " #define AXIS_DESCENDANT_OR_SELF		6 #define AXIS_FOLLOWING			7! #define AXIS_FOLLOWING_SIBLING		8  #define AXIS_NAMESPACE			9 #define AXIS_PARENT			10 #define AXIS_PRECEDING			11 " #define AXIS_PRECEDING_SIBLING		12 #define AXIS_SELF			13   /*7  * A traversal function enumerates nodes along an axis. :  * Initially it must be called with NULL, and it indicates-  * termination on the axis by returning NULL.   */ / typedef xmlNodePtr (*xmlXPathTraversalFunction) D                     (xmlXPathParserContextPtr ctxt, xmlNodePtr cur);   /**   * mlXPathNextSelf: #  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *.  * Traversal function for the "self" direction5  * he self axis contains just the context node itself   */  * Returns the next element following that axis   */ 
 xmlNodePtrA xmlXPathNextSelf(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) {      if (cur == NULL)$         return(ctxt->context->node);     return(NULL);  }    /**   * mlXPathNextChild:#  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   */  * Traversal function for the "child" direction N  * The child axis contains the children of the context node in document order.  */  * Returns the next element following that axis   */ 
 xmlNodePtrB xmlXPathNextChild(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) {     if (cur == NULL) {/ 	if (ctxt->context->node == NULL) return(NULL); % 	switch (ctxt->context->node->type) { "             case XML_ELEMENT_NODE:             case XML_TEXT_NODE: (             case XML_CDATA_SECTION_NODE:%             case XML_ENTITY_REF_NODE: !             case XML_ENTITY_NODE:              case XML_PI_NODE: "             case XML_COMMENT_NODE:#             case XML_NOTATION_NODE:              case XML_DTD_NODE:( 		return(ctxt->context->node->children);#             case XML_DOCUMENT_NODE: (             case XML_DOCUMENT_TYPE_NODE:(             case XML_DOCUMENT_FRAG_NODE:(             case XML_HTML_DOCUMENT_NODE: #ifdef LIBXML_SGML_ENABLED! 	    case XML_SGML_DOCUMENT_NODE:  #endif6 		return(((xmlDocPtr) ctxt->context->node)->children); 	    case XML_ELEMENT_DECL:  	    case XML_ATTRIBUTE_DECL:  	    case XML_ENTITY_DECL:$             case XML_ATTRIBUTE_NODE: 		return(NULL);  	} 	return(NULL);     } +     if ((cur->type == XML_DOCUMENT_NODE) || .         (cur->type == XML_HTML_DOCUMENT_NODE)) 	return(NULL);     return(cur->next); }    /**   * mlXPathNextDescendant: #  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *4  * Traversal function for the "descendant" directionO  * the descendant axis contains the descendants of the context node in document B  * order; a descendant is a child or a child of a child and so on.  */  * Returns the next element following that axis   */ 
 xmlNodePtrG xmlXPathNextDescendant(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) {      if (cur == NULL) {! 	if (ctxt->context->node == NULL)  	    return(NULL);5 	if (ctxt->context->node->type == XML_ATTRIBUTE_NODE)  	    return(NULL);  C         if (ctxt->context->node == (xmlNodePtr) ctxt->context->doc) * 	    return(ctxt->context->doc->children);.         return(ctxt->context->node->children);     }        if (cur->children != NULL)     	{0     	if (cur->children->type != XML_ENTITY_DECL) 		   	return(cur->children);     	}-     if (cur->next != NULL) return(cur->next);           do {         cur = cur->parent; 	if (cur == NULL) return(NULL); . 	if (cur == ctxt->context->node) return(NULL); 	if (cur->next != NULL) {  	    cur = cur->next;  	    return(cur);  	}     } while (cur != NULL);     return(cur); }    /**   * mlXPathNextDescendantOrSelf: #  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *<  * Traversal function for the "descendant-or-self" directionL  * the descendant-or-self axis contains the context node and the descendantsL  * of the context node in document order; thus the context node is the firstO  * node on the axis, and the first child of the context node is the second node   * on the axis  */  * Returns the next element following that axis   */ 
 xmlNodePtrM xmlXPathNextDescendantOrSelf(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) {      if (cur == NULL) {! 	if (ctxt->context->node == NULL)  	    return(NULL);5 	if (ctxt->context->node->type == XML_ATTRIBUTE_NODE)  	    return(NULL);$         return(ctxt->context->node);     }   .     return(xmlXPathNextDescendant(ctxt, cur)); }    /**   * xmlXPathNextParent:#  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *0  * Traversal function for the "parent" directionL  * The parent axis contains the parent of the context node, if there is one.  */  * Returns the next element following that axis   */ 
 xmlNodePtrC xmlXPathNextParent(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) {      /*B      * the parent of an attribute or namespace node is the element;      * to which the attribute or namespace node is attached       * Namespace handling !!!       */      if (cur == NULL) {/ 	if (ctxt->context->node == NULL) return(NULL); % 	switch (ctxt->context->node->type) { "             case XML_ELEMENT_NODE:             case XML_TEXT_NODE: (             case XML_CDATA_SECTION_NODE:%             case XML_ENTITY_REF_NODE: !             case XML_ENTITY_NODE:              case XML_PI_NODE: "             case XML_COMMENT_NODE:#             case XML_NOTATION_NODE:              case XML_DTD_NODE: 	    case XML_ELEMENT_DECL:  	    case XML_ATTRIBUTE_DECL:  	    case XML_ENTITY_DECL:* 		if (ctxt->context->node->parent == NULL). 		    return((xmlNodePtr) ctxt->context->doc);& 		return(ctxt->context->node->parent);&             case XML_ATTRIBUTE_NODE: {4 		xmlAttrPtr att = (xmlAttrPtr) ctxt->context->node;   		return(att->parent); 	    }#             case XML_DOCUMENT_NODE: (             case XML_DOCUMENT_TYPE_NODE:(             case XML_DOCUMENT_FRAG_NODE:(             case XML_HTML_DOCUMENT_NODE: #ifdef LIBXML_SGML_ENABLED! 	    case XML_SGML_DOCUMENT_NODE:  #endif                 return(NULL);  	}     }      return(NULL);  }    /**   * xmlXPathNextAncestor:#  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *2  * Traversal function for the "ancestor" directionN  * the ancestor axis contains the ancestors of the context node; the ancestorsM  * of the context node consist of the parent of context node and the parent's N  * parent and so on; the nodes are ordered in reverse document order; thus theN  * parent is the first node on the axis, and the parent's parent is the second  * node on the axis   */  * Returns the next element following that axis   */ 
 xmlNodePtrE xmlXPathNextAncestor(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) {      /*B      * the parent of an attribute or namespace node is the element;      * to which the attribute or namespace node is attached       * !!!!!!!!!!!!!      */      if (cur == NULL) {/ 	if (ctxt->context->node == NULL) return(NULL); % 	switch (ctxt->context->node->type) { "             case XML_ELEMENT_NODE:             case XML_TEXT_NODE: (             case XML_CDATA_SECTION_NODE:%             case XML_ENTITY_REF_NODE: !             case XML_ENTITY_NODE:              case XML_PI_NODE: "             case XML_COMMENT_NODE: 	    case XML_DTD_NODE:  	    case XML_ELEMENT_DECL:  	    case XML_ATTRIBUTE_DECL:  	    case XML_ENTITY_DECL:#             case XML_NOTATION_NODE: * 		if (ctxt->context->node->parent == NULL). 		    return((xmlNodePtr) ctxt->context->doc);& 		return(ctxt->context->node->parent);&             case XML_ATTRIBUTE_NODE: {4 		xmlAttrPtr cur = (xmlAttrPtr) ctxt->context->node;   		return(cur->parent); 	    }#             case XML_DOCUMENT_NODE: (             case XML_DOCUMENT_TYPE_NODE:(             case XML_DOCUMENT_FRAG_NODE:(             case XML_HTML_DOCUMENT_NODE: #ifdef LIBXML_SGML_ENABLED! 	    case XML_SGML_DOCUMENT_NODE:  #endif                 return(NULL);  	} 	return(NULL);     } ,     if (cur == ctxt->context->doc->children)) 	return((xmlNodePtr) ctxt->context->doc); /     if (cur == (xmlNodePtr) ctxt->context->doc)  	return(NULL);     switch (cur->type) { 	case XML_ELEMENT_NODE:  	case XML_TEXT_NODE: 	case XML_CDATA_SECTION_NODE:  	case XML_ENTITY_REF_NODE: 	case XML_ENTITY_NODE: 	case XML_PI_NODE: 	case XML_COMMENT_NODE:  	case XML_NOTATION_NODE: 	case XML_DTD_NODE:          case XML_ELEMENT_DECL:          case XML_ATTRIBUTE_DECL:         case XML_ENTITY_DECL:  	    return(cur->parent);  	case XML_ATTRIBUTE_NODE: { 7 	    xmlAttrPtr att = (xmlAttrPtr) ctxt->context->node;    	    return(att->parent);  	} 	case XML_DOCUMENT_NODE: 	case XML_DOCUMENT_TYPE_NODE:  	case XML_DOCUMENT_FRAG_NODE:  	case XML_HTML_DOCUMENT_NODE:  #ifdef LIBXML_SGML_ENABLED 	case XML_SGML_DOCUMENT_NODE:  #endif 	    return(NULL);     }      return(NULL);  }    /**   * xmlXPathNextAncestorOrSelf:#  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *:  * Traversal function for the "ancestor-or-self" directionF  * he ancestor-or-self axis contains the context node and ancestors ofG  * the context node in reverse document order; thus the context node is H  * the first node on the axis, and the context node's parent the second;;  * parent here is defined the same as with the parent axis.   */  * Returns the next element following that axis   */ 
 xmlNodePtrK xmlXPathNextAncestorOrSelf(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) {      if (cur == NULL)$         return(ctxt->context->node);,     return(xmlXPathNextAncestor(ctxt, cur)); }    /**    * xmlXPathNextFollowingSibling:#  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *;  * Traversal function for the "following-sibling" direction L  * The following-sibling axis contains the following siblings of the context  * node in document order.  */  * Returns the next element following that axis   */ 
 xmlNodePtrM xmlXPathNextFollowingSibling(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) { /     if (cur == (xmlNodePtr) ctxt->context->doc)          return(NULL);      if (cur == NULL)*         return(ctxt->context->node->next);     return(cur->next); }    /**    * xmlXPathNextPrecedingSibling:#  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *;  * Traversal function for the "preceding-sibling" direction L  * The preceding-sibling axis contains the preceding siblings of the contextN  * node in reverse document order; the first preceding sibling is first on theM  * axis; the sibling preceding that node is the second on the axis and so on.   */  * Returns the next element following that axis   */ 
 xmlNodePtrM xmlXPathNextPrecedingSibling(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) { /     if (cur == (xmlNodePtr) ctxt->context->doc)          return(NULL);      if (cur == NULL)*         return(ctxt->context->node->prev);     return(cur->prev); }    /**   * xmlXPathNextFollowing: #  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *3  * Traversal function for the "following" direction L  * The following axis contains all nodes in the same document as the contextH  * node that are after the context node in document order, excluding anyK  * descendants and excluding attribute nodes and namespace nodes; the nodes    * are ordered in document order  */  * Returns the next element following that axis   */ 
 xmlNodePtrF xmlXPathNextFollowing(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) {/     if (cur == (xmlNodePtr) ctxt->context->doc)          return(NULL);      if (cur == NULL);         return(ctxt->context->node->next);; /* !!!!!!!!! */ 5     if (cur->children != NULL) return(cur->children); -     if (cur->next != NULL) return(cur->next);           do {         cur = cur->parent; 	if (cur == NULL) return(NULL); 7 	if (cur == ctxt->context->doc->children) return(NULL);  	if (cur->next != NULL) {  	    cur = cur->next;  	    return(cur);  	}     } while (cur != NULL);     return(cur); }    /**   * xmlXPathNextPreceding: #  * @ctxt:  the XPath Parser context +  * @cur:  the current node in the traversal   *3  * Traversal function for the "preceding" direction L  * the preceding axis contains all nodes in the same document as the contextI  * node that are before the context node in document order, excluding any M  * ancestors and excluding attribute nodes and namespace nodes; the nodes are $  * ordered in reverse document order  */  * Returns the next element following that axis   */ 
 xmlNodePtrF xmlXPathNextPreceding(xmlXPathParserContextPtr ctxt, xmlNodePtr cur) {/     if (cur == (xmlNodePtr) ctxt->context->doc)          return(NULL);      if (cur == NULL):         return(ctxt->context->node->prev); /* !!!!!!!!! */-     if (cur->last != NULL) return(cur->last); -     if (cur->prev != NULL) return(cur->prev);           do {         cur = cur->parent; 	if (cur == NULL) return(NULL); 7 	if (cur == ctxt->context->doc->children) return(NULL);  	if (cur->prev != NULL) {  	    cur = cur->prev;  	    return(cur);  	}     } while (cur != NULL);     return(cur); }    /**   * xmlXPathNextNamespace: #  * @ctxt:  the XPath Parser context 0  * @cur:  the current attribute in the traversal  *3  * Traversal function for the "namespace" direction G  * the namespace axis contains the namespace nodes of the context node; K  * the order of nodes on this axis is implementation-defined; the axis will 1  * be empty unless the context node is an element   */  * Returns the next element following that axis   */  xmlNsPtrF xmlXPathNextNamespace(xmlXPathParserContextPtr ctxt, xmlAttrPtr cur) {?     if ((cur == NULL) || (ctxt->context->namespaces == NULL)) { .         if (ctxt->context->namespaces != NULL)( 	    xmlFree(ctxt->context->namespaces); 	ctxt->context->namespaces =  ; 	    xmlGetNsList(ctxt->context->doc, ctxt->context->node); 5 	if (ctxt->context->namespaces == NULL) return(NULL);  	ctxt->context->nsNr = 0;      } =     return(ctxt->context->namespaces[ctxt->context->nsNr++]);  }    /**   * xmlXPathNextAttribute: #  * @ctxt:  the XPath Parser context 0  * @cur:  the current attribute in the traversal  *3  * Traversal function for the "attribute" direction 1  * TODO: support DTD inherited default attributes   */  * Returns the next element following that axis   */ 
 xmlAttrPtrF xmlXPathNextAttribute(xmlXPathParserContextPtr ctxt, xmlAttrPtr cur) {     if (cur == NULL) {C         if (ctxt->context->node == (xmlNodePtr) ctxt->context->doc)  	    return(NULL);0         return(ctxt->context->node->properties);     }      return(cur->next); }   I /************************************************************************   *									*  *		NodeTest Functions					*  *									*J  ************************************************************************/   #define NODE_TEST_NONE	0 #define NODE_TEST_TYPE	1 #define NODE_TEST_PI	2 #define NODE_TEST_ALL	3  #define NODE_TEST_NS	4 #define NODE_TEST_NAME	5   #define NODE_TYPE_COMMENT		50  #define NODE_TYPE_TEXT			51  #define NODE_TYPE_PI			52  #define NODE_TYPE_NODE			53    #define IS_FUNCTION			200    /**   * xmlXPathNodeCollectAndTest:#  * @ctxt:  the XPath Parser context "  * @cur:  the current node to test  *F  * This is the function implementing a step: based on the current listE  * of nodes, it builds up a new list, looking at all nodes under that   * axis and selecting them.   *5  * Returns the new NodeSet resulting from the search.   */ 
 xmlNodeSetPtr C xmlXPathNodeCollectAndTest(xmlXPathParserContextPtr ctxt, int axis, R                  int test, int type, const xmlChar *prefix, const xmlChar *name) { #ifdef DEBUG_STEP      int n = 0, t = 0;  #endif
     int i;     xmlNodeSetPtr ret;*     xmlXPathTraversalFunction next = NULL;     xmlNodePtr cur = NULL;  *     if (ctxt->context->nodelist == NULL) {# 	if (ctxt->context->node == NULL) {  	    fprintf(xmlXPathDebug, H 	     "xmlXPathNodeCollectAndTest %s:%d : nodelist and node are NULL\n",! 	            __FILE__, __LINE__);  	    return(NULL); 	}         STRANGE          return(NULL);      }  #ifdef DEBUG_STEP *     fprintf(xmlXPathDebug, "new step : "); #endif     switch (axis) {          case AXIS_ANCESTOR:  #ifdef DEBUG_STEP 1 	    fprintf(xmlXPathDebug, "axis 'ancestors' ");  #endif( 	    next = xmlXPathNextAncestor; break;#         case AXIS_ANCESTOR_OR_SELF:  #ifdef DEBUG_STEP 9 	    fprintf(xmlXPathDebug, "axis 'ancestors-or-self' ");  #endif. 	    next = xmlXPathNextAncestorOrSelf; break;         case AXIS_ATTRIBUTE: #ifdef DEBUG_STEP 2 	    fprintf(xmlXPathDebug, "axis 'attributes' "); #endifE 	    next = (xmlXPathTraversalFunction) xmlXPathNextAttribute; break;  	    break;          case AXIS_CHILD: #ifdef DEBUG_STEP - 	    fprintf(xmlXPathDebug, "axis 'child' ");  #endif% 	    next = xmlXPathNextChild; break;          case AXIS_DESCENDANT:  #ifdef DEBUG_STEP 2 	    fprintf(xmlXPathDebug, "axis 'descendant' "); #endif* 	    next = xmlXPathNextDescendant; break;%         case AXIS_DESCENDANT_OR_SELF:  #ifdef DEBUG_STEP : 	    fprintf(xmlXPathDebug, "axis 'descendant-or-self' "); #endif0 	    next = xmlXPathNextDescendantOrSelf; break;         case AXIS_FOLLOWING: #ifdef DEBUG_STEP 1 	    fprintf(xmlXPathDebug, "axis 'following' ");  #endif) 	    next = xmlXPathNextFollowing; break; $         case AXIS_FOLLOWING_SIBLING: #ifdef DEBUG_STEP : 	    fprintf(xmlXPathDebug, "axis 'following-siblings' "); #endif0 	    next = xmlXPathNextFollowingSibling; break;         case AXIS_NAMESPACE: #ifdef DEBUG_STEP 1 	    fprintf(xmlXPathDebug, "axis 'namespace' ");  #endifE 	    next = (xmlXPathTraversalFunction) xmlXPathNextNamespace; break;  	    break;          case AXIS_PARENT:  #ifdef DEBUG_STEP . 	    fprintf(xmlXPathDebug, "axis 'parent' "); #endif& 	    next = xmlXPathNextParent; break;         case AXIS_PRECEDING: #ifdef DEBUG_STEP 1 	    fprintf(xmlXPathDebug, "axis 'preceding' ");  #endif) 	    next = xmlXPathNextPreceding; break; $         case AXIS_PRECEDING_SIBLING: #ifdef DEBUG_STEP 9 	    fprintf(xmlXPathDebug, "axis 'preceding-sibling' ");  #endif0 	    next = xmlXPathNextPrecedingSibling; break;         case AXIS_SELF:  #ifdef DEBUG_STEP , 	    fprintf(xmlXPathDebug, "axis 'self' "); #endif$ 	    next = xmlXPathNextSelf; break;     } #     if (next == NULL) return(NULL); &     ret = xmlXPathNodeSetCreate(NULL); #ifdef DEBUG_STEP :     fprintf(xmlXPathDebug, " context contains %d nodes\n",-             ctxt->context->nodelist->nodeNr);      switch (test) {  	case NODE_TEST_NONE: C 	    fprintf(xmlXPathDebug, "           searching for none !!!\n");  	    break;  	case NODE_TEST_TYPE: H 	    fprintf(xmlXPathDebug, "           searching for type %d\n", type); 	    break;  	case NODE_TEST_PI: A 	    fprintf(xmlXPathDebug, "           searching for PI !!!\n");  	    break;  	case NODE_TEST_ALL:< 	    fprintf(xmlXPathDebug, "           searching for *\n"); 	    break;  	case NODE_TEST_NS: F 	    fprintf(xmlXPathDebug, "           searching for namespace %s\n", 	            prefix);  	    break;  	case NODE_TEST_NAME: H 	    fprintf(xmlXPathDebug, "           searching for name %s\n", name); 	    if (prefix != NULL): 		fprintf(xmlXPathDebug, "           with namespace %s\n", 		        prefix); 	    break;      } )     fprintf(xmlXPathDebug, "Testing : ");  #endif:     for (i = 0;i < ctxt->context->nodelist->nodeNr; i++) {B         ctxt->context->node = ctxt->context->nodelist->nodeTab[i];   	cur = NULL; 	do {  	    cur = next(ctxt, cur);  	    if (cur == NULL) break; #ifdef DEBUG_STEP              t++;5             fprintf(xmlXPathDebug, " %s", cur->name);  #endif 	    switch (test) {$                 case NODE_TEST_NONE:
 		    STRANGE  		    return(NULL); $                 case NODE_TEST_TYPE:  		    if ((cur->type == type) ||) 		        ((type == XML_ELEMENT_NODE) &&  ( 			 ((cur->type == XML_DOCUMENT_NODE) ||/ 			  (cur->type == XML_HTML_DOCUMENT_NODE)))) {  #ifdef DEBUG_STEP                          n++; #endif' 		        xmlXPathNodeSetAdd(ret, cur);  		    }  		    break;"                 case NODE_TEST_PI:% 		    if (cur->type == XML_PI_NODE) {  		        if ((name != NULL) && ' 			    (!xmlStrEqual(name, cur->name))) 
 			    break;  #ifdef DEBUG_STEP  			n++;  #endif  			xmlXPathNodeSetAdd(ret, cur); 		    }  		    break;#                 case NODE_TEST_ALL: , 		    if ((cur->type == XML_ELEMENT_NODE) ||. 		        (cur->type == XML_ATTRIBUTE_NODE)) {/ 			/* !!! || (cur->type == XML_TEXT_NODE)) { */  #ifdef DEBUG_STEP                          n++; #endif' 		        xmlXPathNodeSetAdd(ret, cur);  		    }  		    break;$                 case NODE_TEST_NS: {! 		    TODO /* namespace search */  		    break; 		} $                 case NODE_TEST_NAME: 		    switch (cur->type) {  		        case XML_ELEMENT_NODE:+ 			    if (xmlStrEqual(name, cur->name) &&   				(((prefix == NULL) ||  				  ((cur->ns != NULL) && 1 				   (xmlStrEqual(prefix, cur->ns->href)))))) {  #ifdef DEBUG_STEP  			    n++;  #endif! 				xmlXPathNodeSetAdd(ret, cur);  			    }
 			    break; $ 		        case XML_ATTRIBUTE_NODE: {* 			    xmlAttrPtr attr = (xmlAttrPtr) cur;+ 			    if (xmlStrEqual(name, attr->name)) {  #ifdef DEBUG_STEP  			    n++;  #endif! 				xmlXPathNodeSetAdd(ret, cur);  			    }
 			    break;  			} 			default: 
 			    break;  		    }  	            break;  		     	    } 	} while (cur != NULL);      }  #ifdef DEBUG_STEP      fprintf(xmlXPathDebug,H             "\nExamined %d nodes, found %d nodes at that step\n", t, n); #endif     return(ret); }     I /************************************************************************   *									*+  *		Implicit tree core function library			*   *									*J  ************************************************************************/   /**   * xmlXPathRoot:#  * @ctxt:  the XPath Parser context   *5  * Initialize the context to the root of the document   */  void- xmlXPathRoot(xmlXPathParserContextPtr ctxt) { (     if (ctxt->context->nodelist != NULL)5         xmlXPathFreeNodeSet(ctxt->context->nodelist); :     ctxt->context->node = (xmlNodePtr) ctxt->context->doc;I     ctxt->context->nodelist = xmlXPathNodeSetCreate(ctxt->context->node);  }   I /************************************************************************   *									**  *		The explicit core function library			*I  *http://www.w3.org/Style/XSL/Group/1999/07/xpath-19990705.html#corelib	*   *									*J  ************************************************************************/     /**   * xmlXPathLastFunction:#  * @ctxt:  the XPath Parser context   *&  * Implement the last() XPath functionJ  * The last function returns the number of nodes in the context node list.  */  void@ xmlXPathLastFunction(xmlXPathParserContextPtr ctxt, int nargs) {     CHECK_ARITY(0); )     if (ctxt->context->contextSize > 0) { H 	valuePush(ctxt, xmlXPathNewFloat((double) ctxt->context->contextSize)); #ifdef DEBUG_EXPR E 	fprintf(xmlXPathDebug, "last() : %d\n", ctxt->context->contextSize);  #endif     } else {# 	XP_ERROR(XPATH_INVALID_CTXT_SIZE);      }  }    /**   * xmlXPathPositionFunction:#  * @ctxt:  the XPath Parser context   **  * Implement the position() XPath functionH  * The position function returns the position of the context node in theH  * context node list. The first position is 1, and so the last positionr  * will be equal to last().   */  voidD xmlXPathPositionFunction(xmlXPathParserContextPtr ctxt, int nargs) {     CHECK_ARITY(0); /     if (ctxt->context->proximityPosition > 0) {  	valuePush(ctxt,A 		  xmlXPathNewFloat((double) ctxt->context->proximityPosition));  #ifdef DEBUG_EXPR , 	fprintf(xmlXPathDebug, "position() : %d\n",$ 		ctxt->context->proximityPosition); #endif     } else {' 	XP_ERROR(XPATH_INVALID_CTXT_POSITION);      }  }    /**   * xmlXPathCountFunction: #  * @ctxt:  the XPath Parser context   *'  * Implement the count() XPath function   */  voidA xmlXPathCountFunction(xmlXPathParserContextPtr ctxt, int nargs) {      xmlXPathObjectPtr cur;       CHECK_ARITY(1);      CHECK_TYPE(XPATH_NODESET);     cur = valuePop(ctxt);   H     valuePush(ctxt, xmlXPathNewFloat((double) cur->nodesetval->nodeNr));     xmlXPathFreeObject(cur); }    /**   * xmlXPathIdFunction:#  * @ctxt:  the XPath Parser context   *$  * Implement the id() XPath function6  * The id function selects elements by their unique IDI  * (see [5.2.1 Unique IDs]). When the argument to id is of type node-set, C  * then the result is the union of the result of applying id to the G  * string value of each of the nodes in the argument node-set. When the F  * argument to id is of any other type, the argument is converted to aE  * string as if by a call to the string function; the string is split I  * into a whitespace-separated list of tokens (whitespace is any sequence E  * of characters matching the production S); the result is a node-set H  * containing the elements in the same document as the context node that;  * have a unique ID equal to any of the tokens in the list.   */  void> xmlXPathIdFunction(xmlXPathParserContextPtr ctxt, int nargs) {     const xmlChar *tokens;     const xmlChar *cur;      xmlChar *ID;     xmlAttrPtr attr;     xmlNodePtr elem = NULL;      xmlXPathObjectPtr ret, obj;        CHECK_ARITY(1);      obj = valuePop(ctxt); 5     if (obj == NULL) XP_ERROR(XPATH_INVALID_OPERAND); %     if (obj->type == XPATH_NODESET) { 1         TODO /* ID function in case of NodeSet */      } $     if (obj->type != XPATH_STRING) {         valuePush(ctxt, obj); ! 	xmlXPathStringFunction(ctxt, 1);  	obj = valuePop(ctxt);! 	if (obj->type != XPATH_STRING) {  	    xmlXPathFreeObject(obj);  	    return; 	}     }      tokens = obj->stringval;  #     ret = xmlXPathNewNodeSet(NULL);      valuePush(ctxt, ret);      if (tokens == NULL) {  	xmlXPathFreeObject(obj);          return;      }        cur = tokens;      !     while (IS_BLANK(*cur)) cur++;      while (*cur != 0) { 0 	while ((IS_LETTER(*cur)) || (IS_DIGIT(*cur)) ||) 	       (*cur == '.') || (*cur == '-') || * 	       (*cur == '_') || (*cur == ':') ||  	       (IS_COMBINING(*cur)) ||  	       (IS_EXTENDER(*cur))) 	       cur++;  - 	if ((!IS_BLANK(*cur)) && (*cur != 0)) break;   .         ID = xmlStrndup(tokens, cur - tokens);) 	attr = xmlGetID(ctxt->context->doc, ID);  	if (attr != NULL) { 	    elem = attr->parent; 6             xmlXPathNodeSetAdd(ret->nodesetval, elem);	         }  	if (ID != NULL) 	    xmlFree(ID);    	while (IS_BLANK(*cur)) cur++; 	tokens = cur;     }      xmlXPathFreeObject(obj);     return;  }    /**   * xmlXPathLocalPartFunction: #  * @ctxt:  the XPath Parser context   *,  * Implement the local-part() XPath functionE  * The local-part function returns a string containing the local part D  * of the name of the node in the argument node-set that is first inD  * document order. If the node-set is empty or the first node has noC  * name, an empty string is returned. If the argument is omitted it    * defaults to the context node.  */  voidE xmlXPathLocalPartFunction(xmlXPathParserContextPtr ctxt, int nargs) {      xmlXPathObjectPtr cur;       CHECK_ARITY(1);      CHECK_TYPE(XPATH_NODESET);     cur = valuePop(ctxt);   '     if (cur->nodesetval->nodeNr == 0) { ) 	valuePush(ctxt, xmlXPathNewCString(""));      } else {9 	int i = 0; /* Should be first in document order !!!!! */ G 	valuePush(ctxt, xmlXPathNewString(cur->nodesetval->nodeTab[i]->name));      }      xmlXPathFreeObject(cur); }    /**   * xmlXPathNamespaceFunction: #  * @ctxt:  the XPath Parser context   *+  * Implement the namespace() XPath function G  * The namespace function returns a string containing the namespace URI D  * of the expanded name of the node in the argument node-set that isH  * first in document order. If the node-set is empty, the first node hasF  * no name, or the expanded name has no namespace URI, an empty stringK  * is returned. If the argument is omitted it defaults to the context node.   */  voidE xmlXPathNamespaceFunction(xmlXPathParserContextPtr ctxt, int nargs) {      xmlXPathObjectPtr cur;       if (nargs == 0) { A         valuePush(ctxt, xmlXPathNewNodeSet(ctxt->context->node));  	nargs = 1;      }      CHECK_ARITY(1);      CHECK_TYPE(XPATH_NODESET);     cur = valuePop(ctxt);   '     if (cur->nodesetval->nodeNr == 0) { ) 	valuePush(ctxt, xmlXPathNewCString(""));      } else {9 	int i = 0; /* Should be first in document order !!!!! */   - 	if (cur->nodesetval->nodeTab[i]->ns == NULL) - 	    valuePush(ctxt, xmlXPathNewCString(""));  	else ' 	    valuePush(ctxt, xmlXPathNewString( 0 		      cur->nodesetval->nodeTab[i]->ns->href));     }      xmlXPathFreeObject(cur); }    /**   * xmlXPathNameFunction:#  * @ctxt:  the XPath Parser context   *&  * Implement the name() XPath functionE  * The name function returns a string containing a QName representing K  * the name of the node in the argument node-set that is first in documenti I  * order. The QName must represent the name with respect to the namespace F  * declarations in effect on the node whose name is being represented.I  * Typically, this will be the form in which the name occurred in the XML H  * source. This need not be the case if there are namespace declarationsG  * in effect on the node that associate multiple prefixes with the same F  * namespace. However, an implementation may include information aboutG  * the original prefix in its representation of nodes; in this case, an H  * implementation can ensure that the returned string is always the sameE  * as the QName used in the XML source. If the argument it omitted it    * defaults to the context node.G  * Libxml keep the original prefix so the "real qualified name" used is   * returned.  */  void@ xmlXPathNameFunction(xmlXPathParserContextPtr ctxt, int nargs) {     xmlXPathObjectPtr cur;       CHECK_ARITY(1);      CHECK_TYPE(XPATH_NODESET);     cur = valuePop(ctxt);   '     if (cur->nodesetval->nodeNr == 0) { ) 	valuePush(ctxt, xmlXPathNewCString(""));      } else {9 	int i = 0; /* Should be first in document order !!!!! */   - 	if (cur->nodesetval->nodeTab[i]->ns == NULL) ' 	    valuePush(ctxt, xmlXPathNewString( 5 	                cur->nodesetval->nodeTab[i]->name));  	      	else {  	    char name[2000];  #ifdef HAVE_SNPRINTF+ 	    snprintf(name, sizeof(name), "%s:%s",  > 	            (char *) cur->nodesetval->nodeTab[i]->ns->prefix,9 	            (char *) cur->nodesetval->nodeTab[i]->name);  #else  	    sprintf(name, "%s:%s", > 	            (char *) cur->nodesetval->nodeTab[i]->ns->prefix,9 	            (char *) cur->nodesetval->nodeTab[i]->name);  #endif'             name[sizeof(name) - 1] = 0; / 	    valuePush(ctxt, xmlXPathNewCString(name)); 	         }      }      xmlXPathFreeObject(cur); }    /**   * xmlXPathStringFunction:#  * @ctxt:  the XPath Parser context   *(  * Implement the string() XPath function@  * he string function converts an object to a string as follows:E  *    - A node-set is converted to a string by returning the value of A  *      the node in the node-set that is first in document order. >  *      If the node-set is empty, an empty string is returned.4  *    - A number is converted to a string as follows-  *      + NaN is converted to the string NaN  5  *      + positive zero is converted to the string 0  5  *      + negative zero is converted to the string 0  @  *      + positive infinity is converted to the string Infinity A  *      + negative infinity is converted to the string -Infinity  C  *      + if the number is an integer, the number is represented in G  *        decimal form as a Number with no decimal point and no leading G  *        zeros, preceded by a minus sign (-) if the number is negative C  *      + otherwise, the number is represented in decimal form as a B  *        Number including a decimal point with at least one digitC  *        before the decimal point and at least one digit after the C  *        decimal point, preceded by a minus sign (-) if the number H  *        is negative; there must be no leading zeros before the decimalG  *        point apart possibly from the one required digit immediatelyi A  *        before the decimal point; beyond the one required digit D  *        after the decimal point there must be as many, but only asE  *        many, more digits as are needed to uniquely distinguish the 8  *        number from all other IEEE 754 numeric values.A  *    - The boolean false value is converted to the string false. ?  *      The boolean true value is converted to the string true.   */  voidB xmlXPathStringFunction(xmlXPathParserContextPtr ctxt, int nargs) {     xmlXPathObjectPtr cur;       CHECK_ARITY(1);      cur = valuePop(ctxt); 5     if (cur == NULL) XP_ERROR(XPATH_INVALID_OPERAND);      switch (cur->type) {         case XPATH_NODESET: ( 	    if (cur->nodesetval->nodeNr == 0) {* 		valuePush(ctxt, xmlXPathNewCString(""));
 	    } else {  		xmlChar *res; A 	        int i = 0; /* Should be first in document order !!!!! */ 7 		res = xmlNodeGetContent(cur->nodesetval->nodeTab[i]); * 		valuePush(ctxt, xmlXPathNewString(res)); 		xmlFree(res);  	    } 	    xmlXPathFreeObject(cur);  	    return; 	case XPATH_STRING:  	    valuePush(ctxt, cur); 	    return;         case XPATH_BOOLEAN: C 	    if (cur->boolval) valuePush(ctxt, xmlXPathNewCString("true")); 7 	    else valuePush(ctxt, xmlXPathNewCString("false"));  	    xmlXPathFreeObject(cur);  	    return; 	case XPATH_NUMBER: {  	    char buf[100];    	    if (isnan(cur->floatval)) 	        sprintf(buf, "NaN"); ' 	    else if (isinf(cur->floatval) > 0) # 	        sprintf(buf, "+Infinity"); ' 	    else if (isinf(cur->floatval) < 0) # 	        sprintf(buf, "-Infinity"); 	 	    else % 		sprintf(buf, "%0g", cur->floatval); . 	    valuePush(ctxt, xmlXPathNewCString(buf)); 	    xmlXPathFreeObject(cur);  	    return; 	}     }      STRANGE  }    /**    * xmlXPathStringLengthFunction:#  * @ctxt:  the XPath Parser context   */  * Implement the string-length() XPath function C  * The string-length returns the number of characters in the string B  * (see [3.6 Strings]). If the argument is omitted, it defaults toC  * the context node converted to a string, in other words the value   * of the context node.   */  voidH xmlXPathStringLengthFunction(xmlXPathParserContextPtr ctxt, int nargs) {     xmlXPathObjectPtr cur;       if (nargs == 0) { # 	if (ctxt->context->node == NULL) { * 	    valuePush(ctxt, xmlXPathNewFloat(0));	 	} else {  	    xmlChar *content;  6 	    content = xmlNodeGetContent(ctxt->context->node);; 	    valuePush(ctxt, xmlXPathNewFloat(xmlStrlen(content)));  	    xmlFree(content); 	} 	return;     }      CHECK_ARITY(1);      CHECK_TYPE(XPATH_STRING);      cur = valuePop(ctxt); A     valuePush(ctxt, xmlXPathNewFloat(xmlStrlen(cur->stringval)));      xmlXPathFreeObject(cur); }    /**   * xmlXPathConcatFunction:#  * @ctxt:  the XPath Parser context   *(  * Implement the concat() XPath functionB  * The concat function returns the concatenation of its arguments.  */  voidB xmlXPathConcatFunction(xmlXPathParserContextPtr ctxt, int nargs) {"     xmlXPathObjectPtr cur, newobj;     xmlChar *tmp;        if (nargs < 2) { 	CHECK_ARITY(2);     }        cur = valuePop(ctxt); 7     if ((cur == NULL) || (cur->type != XPATH_STRING)) {           xmlXPathFreeObject(cur); 	return;     }      nargs--;       while (nargs > 0) {  	newobj = valuePop(ctxt); : 	if ((newobj == NULL) || (newobj->type != XPATH_STRING)) {  	    xmlXPathFreeObject(newobj); 	    xmlXPathFreeObject(cur); " 	    XP_ERROR(XPATH_INVALID_TYPE); 	}4 	tmp = xmlStrcat(newobj->stringval, cur->stringval);$ 	newobj->stringval = cur->stringval; 	cur->stringval = tmp;   	xmlXPathFreeObject(newobj);	 	nargs--;      }      valuePush(ctxt, cur);  }    /**   * xmlXPathContainsFunction:#  * @ctxt:  the XPath Parser context   **  * Implement the contains() XPath functionB  * The contains function returns true if the first argument stringD  * contains the second argument string, and otherwise returns false.  */  voidD xmlXPathContainsFunction(xmlXPathParserContextPtr ctxt, int nargs) {"     xmlXPathObjectPtr hay, needle;       CHECK_ARITY(2);      CHECK_TYPE(XPATH_STRING);      needle = valuePop(ctxt);     hay = valuePop(ctxt); 7     if ((hay == NULL) || (hay->type != XPATH_STRING)) {           xmlXPathFreeObject(hay);#         xmlXPathFreeObject(needle);  	XP_ERROR(XPATH_INVALID_TYPE);     } 5     if (xmlStrstr(hay->stringval, needle->stringval)) /         valuePush(ctxt, xmlXPathNewBoolean(1));      else/         valuePush(ctxt, xmlXPathNewBoolean(0));      xmlXPathFreeObject(hay);     xmlXPathFreeObject(needle);  }    /**   * xmlXPathStartsWithFunction:#  * @ctxt:  the XPath Parser context   *-  * Implement the starts-with() XPath function E  * The starts-with function returns true if the first argument string G  * starts with the second argument string, and otherwise returns false.   */  voidF xmlXPathStartsWithFunction(xmlXPathParserContextPtr ctxt, int nargs) {"     xmlXPathObjectPtr hay, needle;
     int n;       CHECK_ARITY(2);      CHECK_TYPE(XPATH_STRING);      needle = valuePop(ctxt);     hay = valuePop(ctxt); 7     if ((hay == NULL) || (hay->type != XPATH_STRING)) {           xmlXPathFreeObject(hay);#         xmlXPathFreeObject(needle);  	XP_ERROR(XPATH_INVALID_TYPE);     } %     n = xmlStrlen(needle->stringval); 9     if (xmlStrncmp(hay->stringval, needle->stringval, n)) /         valuePush(ctxt, xmlXPathNewBoolean(0));      else/         valuePush(ctxt, xmlXPathNewBoolean(1));      xmlXPathFreeObject(hay);     xmlXPathFreeObject(needle);  }    /**   * xmlXPathSubstringFunction: #  * @ctxt:  the XPath Parser context   *+  * Implement the substring() XPath function E  * The substring function returns the substring of the first argument A  * starting at the position specified in the second argument with 7  * length specified in the third argument. For example, E  * substring("12345",2,3) returns "234". If the third argument is not I  * specified, it returns the substring starting at the position specified F  * in the second argument and continuing to the end of the string. ForF  * example, substring("12345",2) returns "2345".  More precisely, eachF  * character in the string (see [3.6 Strings]) is considered to have aK  * numeric position: the position of the first character is 1, the position J  * of the second character is 2 and so on. The returned substring containsK  * those characters for which the position of the character is greater than K  * or equal to the second argument and, if the third argument is specified, G  * less than the sum of the second and third arguments; the comparisons L  * and addition used for the above follow the standard IEEE 754 rules. Thus:1  *  - substring("12345", 1.5, 2.6) returns "234"  ,  *  - substring("12345", 0, 3) returns "12" 0  *  - substring("12345", 0 div 0, 3) returns "" 0  *  - substring("12345", 1, 0 div 0) returns "" 7  *  - substring("12345", -42, 1 div 0) returns "12345"  7  *  - substring("12345", -1 div 0, 1 div 0) returns ""    */  voidE xmlXPathSubstringFunction(xmlXPathParserContextPtr ctxt, int nargs) { &     xmlXPathObjectPtr str, start, len;     double le, in;
     int i, l;      xmlChar *ret;        /*  ,      * Conformance needs to be checked !!!!!      */      if (nargs < 2) { 	CHECK_ARITY(2);     }      if (nargs > 3) { 	CHECK_ARITY(3);     }      if (nargs == 3) {  	CHECK_TYPE(XPATH_NUMBER); 	len = valuePop(ctxt); 	le = len->floatval;          xmlXPathFreeObject(len);     } else { 	le = 2000000000;      }      CHECK_TYPE(XPATH_NUMBER);      start = valuePop(ctxt);      in = start->floatval;      xmlXPathFreeObject(start);     CHECK_TYPE(XPATH_STRING);      str = valuePop(ctxt); 
     le += in;   )     /* integer index of the first char */      i = (int) in;      if (((double)i) != in) i++;      (     /* integer index of the last char */     l = (int) le;      if (((double)l) != le) l++;   "     /* back to a zero based len */     i--;     l--;  &     /* check against the string len */     if (l > 1024) { &         l = xmlStrlen(str->stringval);     }      if (i < 0) {         i = 0;     }   !     /* number of chars to copy */      l -= i;   *     ret = xmlStrsub(str->stringval, i, l);     if (ret == NULL)) 	valuePush(ctxt, xmlXPathNewCString("")); 
     else {) 	valuePush(ctxt, xmlXPathNewString(ret));  	xmlFree(ret);     }      xmlXPathFreeObject(str); }    /** #  * xmlXPathSubstringBeforeFunction: #  * @ctxt:  the XPath Parser context   *2  * Implement the substring-before() XPath functionC  * The substring-before function returns the substring of the first C  * argument string that precedes the first occurrence of the second D  * argument string in the first argument string, or the empty stringD  * if the first argument string does not contain the second argumentH  * string. For example, substring-before("1999/04/01","/") returns 1999.  */  voidK xmlXPathSubstringBeforeFunction(xmlXPathParserContextPtr ctxt, int nargs) {    xmlXPathObjectPtr str;   xmlXPathObjectPtr find;    xmlBufferPtr target;   const xmlChar *point; 
   int offset;       CHECK_ARITY(2);    find = valuePop(ctxt);   str = valuePop(ctxt);       target = xmlBufferCreate();    if (target) { 7     point = xmlStrstr(str->stringval, find->stringval);      if (point) {-       offset = (int)(point - str->stringval); 3       xmlBufferAdd(target, str->stringval, offset);      } A     valuePush(ctxt, xmlXPathNewString(xmlBufferContent(target)));      xmlBufferFree(target);   }       xmlXPathFreeObject(str);   xmlXPathFreeObject(find);  }    /** "  * xmlXPathSubstringAfterFunction:#  * @ctxt:  the XPath Parser context   *1  * Implement the substring-after() XPath function B  * The substring-after function returns the substring of the firstB  * argument string that follows the first occurrence of the secondE  * argument string in the first argument string, or the empty stringi D  * if the first argument string does not contain the second argumentH  * string. For example, substring-after("1999/04/01","/") returns 04/01,;  * and substring-after("1999/04/01","19") returns 99/04/01.   */  voidJ xmlXPathSubstringAfterFunction(xmlXPathParserContextPtr ctxt, int nargs) {   xmlXPathObjectPtr str;   xmlXPathObjectPtr find;    xmlBufferPtr target;   const xmlChar *point; 
   int offset;       CHECK_ARITY(2);    find = valuePop(ctxt);   str = valuePop(ctxt);       target = xmlBufferCreate();    if (target) { 7     point = xmlStrstr(str->stringval, find->stringval);      if (point) {J       offset = (int)(point - str->stringval) + xmlStrlen(find->stringval);3       xmlBufferAdd(target, &str->stringval[offset], ) 		   xmlStrlen(str->stringval) - offset);      } A     valuePush(ctxt, xmlXPathNewString(xmlBufferContent(target)));      xmlBufferFree(target);   }       xmlXPathFreeObject(str);   xmlXPathFreeObject(find);  }    /**   * xmlXPathNormalizeFunction: #  * @ctxt:  the XPath Parser context   *+  * Implement the normalize() XPath function @  * The normalize function returns the argument string with white@  * space normalized by stripping leading and trailing whitespace?  * and replacing sequences of whitespace characters by a single H  * space. Whitespace characters are the same allowed by the S productionA  * in XML. If the argument is omitted, it defaults to the context L  * node converted to a string, in other words the value of the context node.  */  voidE xmlXPathNormalizeFunction(xmlXPathParserContextPtr ctxt, int nargs) {    xmlXPathObjectPtr obj = NULL;    xmlChar *source = NULL;    xmlBufferPtr target;   xmlChar blank;      if (nargs < 1) {"     /* Use current context node */     CHECK_ARITY(0); ?     TODO /* source = xmlNodeGetContent(ctxt->context->node); */    } else if (nargs >= 1) {     /* Use argument */     CHECK_ARITY(1);      obj = valuePop(ctxt); 5     if (obj == NULL) XP_ERROR(XPATH_INVALID_OPERAND);      source = obj->stringval;   }    target = xmlBufferCreate();    if (target && source) {      "     /* Skip leading whitespaces */     while (IS_BLANK(*source))        source++;    J     /* Collapse intermediate whitespaces, and skip trailing whitespaces */     blank = 0;     while (*source) {        if (IS_BLANK(*source)) { 	blank = *source;        } else {
 	if (blank) { # 	  xmlBufferAdd(target, &blank, 1); 
 	  blank = 0;  	}! 	xmlBufferAdd(target, source, 1);        }        source++;      }    A     valuePush(ctxt, xmlXPathNewString(xmlBufferContent(target)));      xmlBufferFree(target);   } 
   if (obj)     xmlXPathFreeObject(obj); }    /**   * xmlXPathTranslateFunction: #  * @ctxt:  the XPath Parser context   *+  * Implement the translate() XPath function @  * The translate function returns the first argument string withC  * occurrences of characters in the second argument string replaced G  * by the character at the corresponding position in the third argument G  * string. For example, translate("bar","abc","ABC") returns the string E  * BAr. If there is a character in the second argument string with no E  * character at a corresponding position in the third argument string H  * (because the second argument string is longer than the third argumentD  * string), then occurrences of that character in the first argumentE  * string are removed. For example, translate("--aaa--","abc-","ABC") @  * returns "AAA". If a character occurs more than once in secondH  * argument string, then the first occurrence determines the replacementD  * character. If the third argument string is longer than the second7  * argument string, then excess characters are ignored.   */  voidE xmlXPathTranslateFunction(xmlXPathParserContextPtr ctxt, int nargs) {    xmlXPathObjectPtr str;   xmlXPathObjectPtr from;    xmlXPathObjectPtr to;    xmlBufferPtr target;   int i, offset, max; 
   xmlChar ch;    const xmlChar *point;      CHECK_ARITY(3);      to = valuePop(ctxt);   from = valuePop(ctxt);   str = valuePop(ctxt);      target = xmlBufferCreate();    if (target) { #     max = xmlStrlen(to->stringval); 0     for (i = 0; (ch = str->stringval[i]); i++) {-       point = xmlStrchr(from->stringval, ch);        if (point) {, 	/* Warning: This may not work with UTF-8 */) 	offset = (int)(point - from->stringval);  	if (offset < max)3 	  xmlBufferAdd(target, &to->stringval[offset], 1);        } else 	xmlBufferAdd(target, &ch, 1);     }    } ?   valuePush(ctxt, xmlXPathNewString(xmlBufferContent(target)));    xmlBufferFree(target);   xmlXPathFreeObject(str);   xmlXPathFreeObject(from);    xmlXPathFreeObject(to);  }    /**   * xmlXPathBooleanFunction: #  * @ctxt:  the XPath Parser context   *)  * Implement the boolean() XPath function E  * he boolean function converts its argument to a boolean as follows: A  *    - a number is true if and only if it is neither positive or   *      negative zero nor NaN 9  *    - a node-set is true if and only if it is non-empty >  *    - a string is true if and only if its length is non-zero  */  voidC xmlXPathBooleanFunction(xmlXPathParserContextPtr ctxt, int nargs) {      xmlXPathObjectPtr cur;     int res = 0;       CHECK_ARITY(1);      cur = valuePop(ctxt); 5     if (cur == NULL) XP_ERROR(XPATH_INVALID_OPERAND);      switch (cur->type) {         case XPATH_NODESET: % 	    if ((cur->nodesetval == NULL) || 1 	        (cur->nodesetval->nodeNr == 0)) res = 0; 
 	    else  	        res = 1;  	    break;  	case XPATH_STRING: $ 	    if ((cur->stringval == NULL) ||+ 	        (cur->stringval[0] == 0)) res = 0; 
 	    else  	        res = 1;  	    break;          case XPATH_BOOLEAN:  	    valuePush(ctxt, cur); 	    return; 	case XPATH_NUMBER:   	    if (cur->floatval) res = 1; 	    break; 	 	default:  	    STRANGE     }      xmlXPathFreeObject(cur);-     valuePush(ctxt, xmlXPathNewBoolean(res));  }    /**   * xmlXPathNotFunction: #  * @ctxt:  the XPath Parser context   *%  * Implement the not() XPath function :  * The not function returns true if its argument is false,  * and false otherwise.   */  void? xmlXPathNotFunction(xmlXPathParserContextPtr ctxt, int nargs) {      CHECK_ARITY(1);      CHECK_TYPE(XPATH_BOOLEAN);2     ctxt->value->boolval = ! ctxt->value->boolval; }    /**   * xmlXPathTrueFunction:#  * @ctxt:  the XPath Parser context   *&  * Implement the true() XPath function  */  void@ xmlXPathTrueFunction(xmlXPathParserContextPtr ctxt, int nargs) {     CHECK_ARITY(0); +     valuePush(ctxt, xmlXPathNewBoolean(1));  }    /**   * xmlXPathFalseFunction: #  * @ctxt:  the XPath Parser context   *'  * Implement the false() XPath function   */  voidA xmlXPathFalseFunction(xmlXPathParserContextPtr ctxt, int nargs) {      CHECK_ARITY(0); +     valuePush(ctxt, xmlXPathNewBoolean(0));  }    /**   * xmlXPathLangFunction:#  * @ctxt:  the XPath Parser context   *&  * Implement the lang() XPath functionC  * The lang function returns true or false depending on whether the C  * language of the context node as specified by xml:lang attributes B  * is the same as or is a sublanguage of the language specified byF  * the argument string. The language of the context node is determinedE  * by the value of the xml:lang attribute on the context node, or, if B  * the context node has no xml:lang attribute, by the value of theF  * xml:lang attribute on the nearest ancestor of the context node thatF  * has an xml:lang attribute. If there is no such attribute, then langB  * returns false. If there is such an attribute, then lang returnsF  * true if the attribute value is equal to the argument ignoring case,E  * or if there is some suffix starting with - such that the attribute G  * value is equal to the argument ignoring that suffix of the attribute   * value and ignoring case.   */  void@ xmlXPathLangFunction(xmlXPathParserContextPtr ctxt, int nargs) {     xmlXPathObjectPtr val;     const xmlChar *theLang;      const xmlChar *lang;     int ret = 0;
     int i;       CHECK_ARITY(1);      CHECK_TYPE(XPATH_STRING);      val = valuePop(ctxt);      lang = val->stringval;2     theLang = xmlNodeGetLang(ctxt->context->node);.     if ((theLang != NULL) && (lang != NULL)) {$         for (i = 0;lang[i] != 0;i++)1 	    if (toupper(lang[i]) != toupper(theLang[i]))  	        goto not_equal;         ret = 1;     } 
 not_equal:     xmlXPathFreeObject(val);-     valuePush(ctxt, xmlXPathNewBoolean(ret));  }    /**   * xmlXPathNumberFunction:#  * @ctxt:  the XPath Parser context   *(  * Implement the number() XPath function  */  voidB xmlXPathNumberFunction(xmlXPathParserContextPtr ctxt, int nargs) {     xmlXPathObjectPtr cur;     double res;        CHECK_ARITY(1);      cur = valuePop(ctxt);      switch (cur->type) {         case XPATH_NODESET:  	    valuePush(ctxt, cur);% 	    xmlXPathStringFunction(ctxt, 1);  	    cur = valuePop(ctxt); 	case XPATH_STRING: 4 	    res = xmlXPathStringEvalNumber(cur->stringval);, 	    valuePush(ctxt, xmlXPathNewFloat(res)); 	    xmlXPathFreeObject(cur);  	    return;         case XPATH_BOOLEAN: > 	    if (cur->boolval) valuePush(ctxt, xmlXPathNewFloat(1.0));1 	    else valuePush(ctxt, xmlXPathNewFloat(0.0));  	    xmlXPathFreeObject(cur);  	    return; 	case XPATH_NUMBER:  	    valuePush(ctxt, cur); 	    return;     }      STRANGE  }    /**   * xmlXPathSumFunction: #  * @ctxt:  the XPath Parser context   *%  * Implement the sum() XPath function A  * The sum function returns the sum of the values of the nodes in   * the argument node-set.   */  void? xmlXPathSumFunction(xmlXPathParserContextPtr ctxt, int nargs) {      CHECK_ARITY(1); 8     TODO /* BUG Sum : don't understand the definition */ }    /**   * xmlXPathFloorFunction: #  * @ctxt:  the XPath Parser context   *'  * Implement the floor() XPath function H  * The floor function returns the largest (closest to positive infinity)G  * number that is not greater than the argument and that is an integer.   */  voidA xmlXPathFloorFunction(xmlXPathParserContextPtr ctxt, int nargs) {      CHECK_ARITY(1);      CHECK_TYPE(XPATH_NUMBER); 2     /* floor(0.999999999999) => 1.0 !!!!!!!!!!! */B     ctxt->value->floatval = (double)((int) ctxt->value->floatval); }    /**   * xmlXPathCeilingFunction: #  * @ctxt:  the XPath Parser context   *)  * Implement the ceiling() XPath function K  * The ceiling function returns the smallest (closest to negative infinity) D  * number that is not less than the argument and that is an integer.  */  voidC xmlXPathCeilingFunction(xmlXPathParserContextPtr ctxt, int nargs) { 
     double f;        CHECK_ARITY(1);      CHECK_TYPE(XPATH_NUMBER); .     f = (double)((int) ctxt->value->floatval);#     if (f != ctxt->value->floatval)  	ctxt->value->floatval = f + 1;  }    /**   * xmlXPathRoundFunction: #  * @ctxt:  the XPath Parser context   *'  * Implement the round() XPath function ?  * The round function returns the number that is closest to the B  * argument and that is an integer. If there are two such numbers,)  * then the one that is even is returned.   */  voidA xmlXPathRoundFunction(xmlXPathParserContextPtr ctxt, int nargs) { 
     double f;        CHECK_ARITY(1);      CHECK_TYPE(XPATH_NUMBER); '     /* round(0.50000001) => 0  !!!!! */ .     f = (double)((int) ctxt->value->floatval);(     if (ctxt->value->floatval < f + 0.5)"         ctxt->value->floatval = f;.     else if (ctxt->value->floatval == f + 0.5)I         ctxt->value->floatval = f; /* !!!! Not following the spec here */ 	     else  &         ctxt->value->floatval = f + 1; }   I /************************************************************************   *									*  *			The Parser					*   *									*J  ************************************************************************/   /*G  * a couple of forward declarations since we use a recursive call based   * implementation.  */ 5 void xmlXPathEvalExpr(xmlXPathParserContextPtr ctxt); : void xmlXPathEvalPredicate(xmlXPathParserContextPtr ctxt);= void xmlXPathEvalLocationPath(xmlXPathParserContextPtr ctxt); E void xmlXPathEvalRelativeLocationPath(xmlXPathParserContextPtr ctxt);    /**   * xmlXPathParseNCName: #  * @ctxt:  the XPath Parser context   *-  * parse an XML namespace non qualified name.   *1  * [NS 3] NCName ::= (Letter | '_') (NCNameChar)*   *;  * [NS 4] NCNameChar ::= Letter | Digit | '.' | '-' | '_' | 1  *                       CombiningChar | Extender   *%  * Returns the namespace name or NULL   */   	 xmlChar * 4 xmlXPathParseNCName(xmlXPathParserContextPtr ctxt) {     const xmlChar *q;      xmlChar *ret = NULL;  6     if (!IS_LETTER(CUR) && (CUR != '_')) return(NULL);
     q = NEXT;   1     while ((IS_LETTER(CUR)) || (IS_DIGIT(CUR)) || *            (CUR == '.') || (CUR == '-') || 	   (CUR == '_') ||  	   (IS_COMBINING(CUR)) || 	   (IS_EXTENDER(CUR)))  	NEXT;     %     ret = xmlStrndup(q, CUR_PTR - q);        return(ret); }    /**   * xmlXPathParseQName:#  * @ctxt:  the XPath Parser context   * @prefix:  a xmlChar **   *  * parse an XML qualified name  *+  * [NS 5] QName ::= (Prefix ':')? LocalPart   *  * [NS 6] Prefix ::= NCName   *  * [NS 7] LocalPart ::= NCName  *E  * Returns the function returns the local part, and prefix is updated   *   to get the Prefix if any.  */   	 xmlChar * E xmlXPathParseQName(xmlXPathParserContextPtr ctxt, xmlChar **prefix) {      xmlChar *ret = NULL;       *prefix = NULL; $     ret = xmlXPathParseNCName(ctxt);     if (CUR == ':') {          *prefix = ret; 	NEXT;! 	ret = xmlXPathParseNCName(ctxt);      }      return(ret); }    /**   * xmlXPathStringEvalNumber:  * @str:  A string to scan  *,  *  [30]   Number ::=   Digits ('.' Digits)?#  *                    | '.' Digits    *  [31]   Digits ::=   [0-9]+  *,  * Parse and evaluate a Number in the string  *7  * BUG: "1.' is not valid ... James promised correction !  *       as Digits ('.' Digits?)?   *  * Returns the double value.  */  double. xmlXPathStringEvalNumber(const xmlChar *str) {     const xmlChar *cur = str;      double ret = 0.0;      double mult = 1;     int ok = 0;        while (*cur == ' ') cur++;:     if ((*cur != '.') && ((*cur < '0') || (*cur > '9'))) {         return(xmlXPathNAN);     } ,     while ((*cur >= '0') && (*cur <= '9')) {&         ret = ret * 10 + (*cur - '0'); 	ok = 1; 	cur++;      }      if (*cur == '.') {         cur++;/ 	if (((*cur < '0') || (*cur > '9')) && (!ok)) {  	    return(xmlXPathNAN);  	}) 	while ((*cur >= '0') && (*cur <= '9')) {  	    mult /= 10;& 	    ret = ret  + (*cur - '0') * mult; 	    cur++;  	}     }      while (*cur == ' ') cur++;'     if (*cur != 0) return(xmlXPathNAN);      return(ret); }    /**   * xmlXPathEvalNumber:#  * @ctxt:  the XPath Parser context   *,  *  [30]   Number ::=   Digits ('.' Digits)?#  *                    | '.' Digits    *  [31]   Digits ::=   [0-9]+  *9  * Parse and evaluate a Number, then push it on the stack   *7  * BUG: "1.' is not valid ... James promised correction !  *       as Digits ('.' Digits?)?   */  void3 xmlXPathEvalNumber(xmlXPathParserContextPtr ctxt) {      double ret = 0.0;      double mult = 1;     int ok = 0;        CHECK_ERROR;7     if ((CUR != '.') && ((CUR < '0') || (CUR > '9'))) { %         XP_ERROR(XPATH_NUMBER_ERROR);      } *     while ((CUR >= '0') && (CUR <= '9')) {%         ret = ret * 10 + (CUR - '0');  	ok = 1; 	NEXT;     }      if (CUR == '.') { 
         NEXT; - 	if (((CUR < '0') || (CUR > '9')) && (!ok)) { # 	     XP_ERROR(XPATH_NUMBER_ERROR);  	}' 	while ((CUR >= '0') && (CUR <= '9')) {  	    mult /= 10;% 	    ret = ret  + (CUR - '0') * mult; 
 	    NEXT; 	}     } +     valuePush(ctxt, xmlXPathNewFloat(ret));  }    /**   * xmlXPathEvalLiteral: #  * @ctxt:  the XPath Parser context   *,  * Parse a Literal and push it on the stack.  *&  *  [29]   Literal ::=   '"' [^"]* '"'%  *                    | "'" [^']* "'"   *A  * TODO: xmlXPathEvalLiteral memory allocation could be improved.   */  void4 xmlXPathEvalLiteral(xmlXPathParserContextPtr ctxt) {     const xmlChar *q;      xmlChar *ret = NULL;       if (CUR == '"') { 
         NEXT; 
 	q = CUR_PTR; ' 	while ((IS_CHAR(CUR)) && (CUR != '"')) 
 	    NEXT; 	if (!IS_CHAR(CUR)) { . 	    XP_ERROR(XPATH_UNFINISHED_LITERAL_ERROR);	 	} else { & 	    ret = xmlStrndup(q, CUR_PTR - q);
 	    NEXT;	         }      } else if (CUR == '\'') { 
         NEXT; 
 	q = CUR_PTR; ( 	while ((IS_CHAR(CUR)) && (CUR != '\''))
 	    NEXT; 	if (!IS_CHAR(CUR)) { . 	    XP_ERROR(XPATH_UNFINISHED_LITERAL_ERROR);	 	} else { & 	    ret = xmlStrndup(q, CUR_PTR - q);
 	    NEXT;	         }      } else {% 	XP_ERROR(XPATH_START_LITERAL_ERROR);      }      if (ret == NULL) return;,     valuePush(ctxt, xmlXPathNewString(ret));     xmlFree(ret);  }    /** !  * xmlXPathEvalVariableReference: #  * @ctxt:  the XPath Parser context   *C  * Parse a VariableReference, evaluate it and push it on the stack.   *A  * The variable bindings consist of a mapping from variable names B  * to variable values. The value of a variable is an object, whichH  * of any of the types that are possible for the value of an expression,:  * and may also be of additional types not specified here.  *&  * Early evaluation is possible since:C  * The variable bindings [...] used to evaluate a subexpression are H  * always the same as those used to evaluate the containing expression.   *-  *  [36]   VariableReference ::=   '$' QName    */  void> xmlXPathEvalVariableReference(xmlXPathParserContextPtr ctxt) {     xmlChar *name;     xmlChar *prefix;     xmlXPathObjectPtr value;       if (CUR != '$') { $ 	XP_ERROR(XPATH_VARIABLE_REF_ERROR);     } -     name = xmlXPathParseQName(ctxt, &prefix);      if (name == NULL) { $ 	XP_ERROR(XPATH_VARIABLE_REF_ERROR);     } 7     value = xmlXPathVariablelookup(ctxt, prefix, name);      if (value == NULL) {& 	XP_ERROR(XPATH_UNDEF_VARIABLE_ERROR);     }      valuePush(ctxt, value); (     if (prefix != NULL) xmlFree(prefix);     xmlFree(name); }       /**   * xmlXPathFunctionLookup:#  * @ctxt:  the XPath Parser context   * @name:  a name string  **  * Search for a function of the given name  */  *  [35]   FunctionName ::=   QName - NodeType    *I  * TODO: for the moment the function list is hardcoded from the spec !!!!   *;  * Returns the xmlXPathFunction if found, or NULL otherwise   */  xmlXPathFunctionH xmlXPathIsFunction(xmlXPathParserContextPtr ctxt, const xmlChar *name) {     switch (name[0]) {         case 'b': / 	    if (xmlStrEqual(name, BAD_CAST "boolean")) ) 	        return(xmlXPathBooleanFunction);  	    break;          case 'c': / 	    if (xmlStrEqual(name, BAD_CAST "ceiling")) ) 	        return(xmlXPathCeilingFunction); - 	    if (xmlStrEqual(name, BAD_CAST "count")) ' 	        return(xmlXPathCountFunction); . 	    if (xmlStrEqual(name, BAD_CAST "concat"))( 	        return(xmlXPathConcatFunction);0 	    if (xmlStrEqual(name, BAD_CAST "contains"))* 	        return(xmlXPathContainsFunction); 	    break;          case 'i': * 	    if (xmlStrEqual(name, BAD_CAST "id"))$ 	        return(xmlXPathIdFunction); 	    break;          case 'f': - 	    if (xmlStrEqual(name, BAD_CAST "false")) ' 	        return(xmlXPathFalseFunction); - 	    if (xmlStrEqual(name, BAD_CAST "floor")) ' 	        return(xmlXPathFloorFunction);  	    break;          case 'l': , 	    if (xmlStrEqual(name, BAD_CAST "last"))& 	        return(xmlXPathLastFunction);, 	    if (xmlStrEqual(name, BAD_CAST "lang"))& 	        return(xmlXPathLangFunction);2 	    if (xmlStrEqual(name, BAD_CAST "local-part"))+ 	        return(xmlXPathLocalPartFunction);  	    break;          case 'n': + 	    if (xmlStrEqual(name, BAD_CAST "not")) % 	        return(xmlXPathNotFunction); , 	    if (xmlStrEqual(name, BAD_CAST "name"))& 	        return(xmlXPathNameFunction);1 	    if (xmlStrEqual(name, BAD_CAST "namespace")) + 	        return(xmlXPathNamespaceFunction); 7 	    if (xmlStrEqual(name, BAD_CAST "normalize-space")) + 	        return(xmlXPathNormalizeFunction); 1 	    if (xmlStrEqual(name, BAD_CAST "normalize")) + 	        return(xmlXPathNormalizeFunction); . 	    if (xmlStrEqual(name, BAD_CAST "number"))( 	        return(xmlXPathNumberFunction); 	    break;          case 'p': 0 	    if (xmlStrEqual(name, BAD_CAST "position"))* 	        return(xmlXPathPositionFunction); 	    break;          case 'r': - 	    if (xmlStrEqual(name, BAD_CAST "round")) ' 	        return(xmlXPathRoundFunction);  	    break;          case 's': . 	    if (xmlStrEqual(name, BAD_CAST "string"))( 	        return(xmlXPathStringFunction);5 	    if (xmlStrEqual(name, BAD_CAST "string-length")) . 	        return(xmlXPathStringLengthFunction);3 	    if (xmlStrEqual(name, BAD_CAST "starts-with")) , 	        return(xmlXPathStartsWithFunction);1 	    if (xmlStrEqual(name, BAD_CAST "substring")) + 	        return(xmlXPathSubstringFunction); 8 	    if (xmlStrEqual(name, BAD_CAST "substring-before"))1 	        return(xmlXPathSubstringBeforeFunction); 7 	    if (xmlStrEqual(name, BAD_CAST "substring-after")) 0 	        return(xmlXPathSubstringAfterFunction);+ 	    if (xmlStrEqual(name, BAD_CAST "sum")) % 	        return(xmlXPathSumFunction);  	    break;          case 't': , 	    if (xmlStrEqual(name, BAD_CAST "true"))& 	        return(xmlXPathTrueFunction);1 	    if (xmlStrEqual(name, BAD_CAST "translate")) + 	        return(xmlXPathTranslateFunction);  	    break;      }      return(NULL);  }    /**    * xmlXPathEvalLocationPathName:#  * @ctxt:  the XPath Parser context   * @name:  a name string  *>  * Various names in the beginning of a LocationPath expression1  * indicate whether that's an Axis, a node type,    *#  *  [6]   AxisName ::=   'ancestor' %  *               | 'ancestor-or-self'   *               | 'attribute'  *               | 'child'  *               | 'descendant' '  *               | 'descendant-or-self'   *               | 'following'&  *               | 'following-sibling'  *               | 'namespace'  *               | 'parent'   *               | 'preceding'&  *               | 'preceding-sibling'  *               | 'self' #  *  [38]   NodeType ::=   'comment'   *                    | 'text'0  *                    | 'processing-instruction'  *                    | 'node'  */  int I xmlXPathGetNameType(xmlXPathParserContextPtr ctxt, const xmlChar *name) {      switch (name[0]) {         case 'a': G 	    if (xmlStrEqual(name, BAD_CAST "ancestor")) return(AXIS_ANCESTOR); 8 	    if (xmlStrEqual(name, BAD_CAST "ancestor-or-self"))' 	        return(AXIS_ANCESTOR_OR_SELF); P             if (xmlStrEqual(name, BAD_CAST "attribute")) return(AXIS_ATTRIBUTE); 	    break;          case 'c': H             if (xmlStrEqual(name, BAD_CAST "child")) return(AXIS_CHILD);Q             if (xmlStrEqual(name, BAD_CAST "comment")) return(NODE_TYPE_COMMENT);  	    break;          case 'd': 9             if (xmlStrEqual(name, BAD_CAST "descendant")) ! 	        return(AXIS_DESCENDANT); A             if (xmlStrEqual(name, BAD_CAST "descendant-or-self")) ) 	        return(AXIS_DESCENDANT_OR_SELF);  	    break;          case 'f': P             if (xmlStrEqual(name, BAD_CAST "following")) return(AXIS_FOLLOWING);@             if (xmlStrEqual(name, BAD_CAST "following-sibling"))( 	        return(AXIS_FOLLOWING_SIBLING); 	    break;          case 'n': P             if (xmlStrEqual(name, BAD_CAST "namespace")) return(AXIS_NAMESPACE);K             if (xmlStrEqual(name, BAD_CAST "node")) return(NODE_TYPE_NODE);  	    break;          case 'p': J             if (xmlStrEqual(name, BAD_CAST "parent")) return(AXIS_PARENT);P             if (xmlStrEqual(name, BAD_CAST "preceding")) return(AXIS_PRECEDING);@             if (xmlStrEqual(name, BAD_CAST "preceding-sibling"))( 	        return(AXIS_PRECEDING_SIBLING);E             if (xmlStrEqual(name, BAD_CAST "processing-instruction"))  	        return(NODE_TYPE_PI); 	    break;          case 's': F             if (xmlStrEqual(name, BAD_CAST "self")) return(AXIS_SELF); 	    break;          case 't': K             if (xmlStrEqual(name, BAD_CAST "text")) return(NODE_TYPE_TEXT);  	    break;      } <     if (xmlXPathIsFunction(ctxt, name)) return(IS_FUNCTION);     return(0); }     /**   * xmlXPathEvalFunctionCall:#  * @ctxt:  the XPath Parser context   *P  *  [16]   FunctionCall ::=   FunctionName '(' ( Argument ( ',' Argument)*)? ')'  *  [17]   Argument ::=   Expr    *J  * Parse and evaluate a function call, the evaluation of all arguments are  * pushed on the stack  */  void9 xmlXPathEvalFunctionCall(xmlXPathParserContextPtr ctxt) {      xmlChar *name;     xmlChar *prefix;     xmlXPathFunction func;     int nbargs = 0;   -     name = xmlXPathParseQName(ctxt, &prefix);      if (name == NULL) {  	XP_ERROR(XPATH_EXPR_ERROR);     }      SKIP_BLANKS;*     func = xmlXPathIsFunction(ctxt, name);     if (func == NULL) {          xmlFree(name);$ 	XP_ERROR(XPATH_UNKNOWN_FUNC_ERROR);     }  #ifdef DEBUG_EXPR :     fprintf(xmlXPathDebug, "Calling function %s\n", name); #endif       if (CUR != '(') {          xmlFree(name); 	XP_ERROR(XPATH_EXPR_ERROR);     } 	     NEXT;      SKIP_BLANKS;       while (CUR != ')') {         xmlXPathEvalExpr(ctxt); 
 	nbargs++; 	if (CUR == ')') break;  	if (CUR != ',') { 	    xmlFree(name);   	    XP_ERROR(XPATH_EXPR_ERROR); 	} 	NEXT;
 	SKIP_BLANKS;      } 	     NEXT;      SKIP_BLANKS;     xmlFree(name);     func(ctxt, nbargs);  }    /**   * xmlXPathEvalPrimaryExpr: #  * @ctxt:  the XPath Parser context   */  *  [15]   PrimaryExpr ::=   VariableReference     *                | '(' Expr ')'  *                | Literal   *                | Number  !  *                | FunctionCall    *M  * Parse and evaluate a primary expression, then push the result on the stack   */  void8 xmlXPathEvalPrimaryExpr(xmlXPathParserContextPtr ctxt) {     SKIP_BLANKS;8     if (CUR == '$') xmlXPathEvalVariableReference(ctxt);     else if (CUR == '(') {
         NEXT; 
 	SKIP_BLANKS;          xmlXPathEvalExpr(ctxt);  	if (CUR != ')') {  	    XP_ERROR(XPATH_EXPR_ERROR); 	} 	NEXT;
 	SKIP_BLANKS;      } else if (IS_DIGIT(CUR)) { !         xmlXPathEvalNumber(ctxt); /     } else if ((CUR == '\'') || (CUR == '"')) { "         xmlXPathEvalLiteral(ctxt);     } else {'         xmlXPathEvalFunctionCall(ctxt);      }  }    /**   * xmlXPathEvalFilterExpr:#  * @ctxt:  the XPath Parser context   *(  *  [20]   FilterExpr ::=   PrimaryExpr (  *               | FilterExpr Predicate   *L  * Parse and evaluate a filter expression, then push the result on the stackF  * Square brackets are used to filter expressions in the same way thatG  * they are used in location paths. It is an error if the expression to E  * be filtered does not evaluate to a node-set. The context node list H  * used for evaluating the expression in square brackets is the node-set+  * to be filtered listed in document order.   */    void7 xmlXPathEvalFilterExpr(xmlXPathParserContextPtr ctxt) { 	     /****       xmlNodeSetPtr oldset = NULL;     xmlXPathObjectPtr arg;
      ****/  "     xmlXPathEvalPrimaryExpr(ctxt);     CHECK_ERROR;     SKIP_BLANKS;          if (CUR != '[') return;        CHECK_TYPE(XPATH_NODESET);       while (CUR == '[') { 	xmlXPathEvalPredicate(ctxt); 
 	SKIP_BLANKS;      }         }    /**   * xmlXPathScanName:#  * @ctxt:  the XPath Parser context   *C  * Trickery: parse an XML name but without consuming the input flow   * Needed for rollback cases.   *<  * [4] NameChar ::= Letter | Digit | '.' | '-' | '_' | ':' |,  *                  CombiningChar | Extender  *0  * [5] Name ::= (Letter | '_' | ':') (NameChar)*  *  * [6] Names ::= Name (S Name)*   *"  * Returns the Name parsed or NULL  */   	 xmlChar * 1 xmlXPathScanName(xmlXPathParserContextPtr ctxt) { !     xmlChar buf[XML_MAX_NAMELEN];      int len = 0;       SKIP_BLANKS;*     if (!IS_LETTER(CUR) && (CUR != '_') &&         (CUR != ':')) {  	return(NULL);     }   ;     while ((IS_LETTER(NXT(len))) || (IS_DIGIT(NXT(len))) || 4            (NXT(len) == '.') || (NXT(len) == '-') ||. 	   (NXT(len) == '_') || (NXT(len) == ':') ||  	   (IS_COMBINING(NXT(len))) ||  	   (IS_EXTENDER(NXT(len)))) { 	buf[len] = NXT(len);  	len++;  	if (len >= XML_MAX_NAMELEN) { 	    fprintf(stderr,  8 	       "xmlScanName: reached XML_MAX_NAMELEN limit\n");< 	    while ((IS_LETTER(NXT(len))) || (IS_DIGIT(NXT(len))) ||. 		   (NXT(len) == '.') || (NXT(len) == '-') ||/ 		   (NXT(len) == '_') || (NXT(len) == ':') ||    		   (IS_COMBINING(NXT(len))) || 		   (IS_EXTENDER(NXT(len)))) 	 		 len++;  	    break;  	}     } !     return(xmlStrndup(buf, len));  }    /**   * xmlXPathEvalPathExpr:#  * @ctxt:  the XPath Parser context   *'  *  [19]   PathExpr ::=   LocationPath    *               | FilterExpr 7  *               | FilterExpr '/' RelativeLocationPath  8  *               | FilterExpr '//' RelativeLocationPath   *J  * Parse and evaluate a path expression, then push the result on the stackB  * The / operator and // operators combine an arbitrary expressionA  * and a relative location path. It is an error if the expression #  * does not evaluate to a node-set. ?  * The / operator does composition in the same way as when / is A  * used in a location path. As in location paths, // is short for    * /descendant-or-self::node()/.  */    void5 xmlXPathEvalPathExpr(xmlXPathParserContextPtr ctxt) {       xmlNodeSetPtr newset = NULL;       SKIP_BLANKS;:     if ((CUR == '$') || (CUR == '(') || (IS_DIGIT(CUR)) ||(         (CUR == '\'') || (CUR == '"')) { 	xmlXPathEvalFilterExpr(ctxt);
 	CHECK_ERROR; ' 	if ((CUR == '/') && (NXT(1) == '/')) { 
 	    SKIP(2);  	    SKIP_BLANKS; + 	    if (ctxt->context->nodelist == NULL) { 	 		STRANGE  		xmlXPathRoot(ctxt);  	    }G 	    newset = xmlXPathNodeCollectAndTest(ctxt, AXIS_DESCENDANT_OR_SELF, 6 			     NODE_TEST_TYPE, XML_ELEMENT_NODE, NULL, NULL);) 	    if (ctxt->context->nodelist != NULL) / 		xmlXPathFreeNodeSet(ctxt->context->nodelist); & 	    ctxt->context->nodelist = newset;  	    ctxt->context->node = NULL;, 	    xmlXPathEvalRelativeLocationPath(ctxt); 	} else if (CUR == '/') { , 	    xmlXPathEvalRelativeLocationPath(ctxt); 	}     } else {'         /******* !!!!!!!!!! @attname */          xmlChar *name;   	name = xmlXPathScanName(ctxt); 9 	if ((name == NULL) || (!xmlXPathIsFunction(ctxt, name))) $ 	    xmlXPathEvalLocationPath(ctxt); 	else " 	    xmlXPathEvalFilterExpr(ctxt); 	if (name != NULL) 	    xmlFree(name);   (     if (ctxt->context->nodelist != NULL)B 	valuePush(ctxt, xmlXPathNewNodeSetList(ctxt->context->nodelist));     }  }    /**   * xmlXPathEvalUnionExpr: #  * @ctxt:  the XPath Parser context   *$  *  [18]   UnionExpr ::=   PathExpr *  *               | UnionExpr '|' PathExpr   *L  * Parse and evaluate an union expression, then push the result on the stack  */    void6 xmlXPathEvalUnionExpr(xmlXPathParserContextPtr ctxt) {     xmlXPathEvalPathExpr(ctxt);      CHECK_ERROR;     SKIP_BLANKS;     if (CUR == '|') { - 	xmlNodeSetPtr old = ctxt->context->nodelist;    	NEXT;
 	SKIP_BLANKS;  	xmlXPathEvalPathExpr(ctxt);  % 	if (ctxt->context->nodelist == NULL) # 	    ctxt->context->nodelist = old;  	else {  	    ctxt->context->nodelist =  < 	        xmlXPathNodeSetMerge(ctxt->context->nodelist, old); 	    xmlXPathFreeNodeSet(old); 	}     }  }    /**   * xmlXPathEvalUnaryExpr: #  * @ctxt:  the XPath Parser context   *%  *  [27]   UnaryExpr ::=   UnionExpr  %  *                   | '-' UnaryExpr    *L  * Parse and evaluate an unary expression, then push the result on the stack  */    void6 xmlXPathEvalUnaryExpr(xmlXPathParserContextPtr ctxt) {     int minus = 0;       SKIP_BLANKS;     if (CUR == '-') {          minus = 1; 	NEXT;
 	SKIP_BLANKS;      }       xmlXPathEvalUnionExpr(ctxt);     CHECK_ERROR;     if (minus) {$         xmlXPathValueFlipSign(ctxt);     }  }    /** "  * xmlXPathEvalMultiplicativeExpr:#  * @ctxt:  the XPath Parser context   *.  *  [26]   MultiplicativeExpr ::=   UnaryExpr E  *                   | MultiplicativeExpr MultiplyOperator UnaryExpr  :  *                   | MultiplicativeExpr 'div' UnaryExpr :  *                   | MultiplicativeExpr 'mod' UnaryExpr %  *  [34]   MultiplyOperator ::=   '*'   *O  * Parse and evaluate an Additive expression, then push the result on the stack   */    void? xmlXPathEvalMultiplicativeExpr(xmlXPathParserContextPtr ctxt) {       xmlXPathEvalUnaryExpr(ctxt);     CHECK_ERROR;     SKIP_BLANKS;     while ((CUR == '*') ||  B            ((CUR == 'd') && (NXT(1) == 'i') && (NXT(2) == 'v')) ||B            ((CUR == 'm') && (NXT(1) == 'o') && (NXT(2) == 'd'))) {
 	int op = -1;            if (CUR == '*') {  	    op = 0;
 	    NEXT; 	} else if (CUR == 'd') {  	    op = 1;
 	    SKIP(3);  	} else if (CUR == 'm') {  	    op = 2;
 	    SKIP(3);  	}
 	SKIP_BLANKS; $         xmlXPathEvalUnaryExpr(ctxt);
 	CHECK_ERROR;  	switch (op) { 	    case 0:" 	        xmlXPathMultValues(ctxt); 		break; 	    case 1:! 	        xmlXPathDivValues(ctxt);  		break; 	    case 2:! 	        xmlXPathModValues(ctxt);  		break; 	}     }  }    /**   * xmlXPathEvalAdditiveExpr:#  * @ctxt:  the XPath Parser context   *1  *  [25]   AdditiveExpr ::=   MultiplicativeExpr  ;  *                   | AdditiveExpr '+' MultiplicativeExpr  ;  *                   | AdditiveExpr '-' MultiplicativeExpr    *O  * Parse and evaluate an Additive expression, then push the result on the stack   */    void9 xmlXPathEvalAdditiveExpr(xmlXPathParserContextPtr ctxt) { )     xmlXPathEvalMultiplicativeExpr(ctxt);      CHECK_ERROR;     SKIP_BLANKS;*     while ((CUR == '+') || (CUR == '-')) {
 	int plus;  !         if (CUR == '+') plus = 1;  	else plus = 0;  	NEXT;
 	SKIP_BLANKS; -         xmlXPathEvalMultiplicativeExpr(ctxt); 
 	CHECK_ERROR; # 	if (plus) xmlXPathAddValues(ctxt);  	else xmlXPathSubValues(ctxt);     }  }    /**   * xmlXPathEvalRelationalExpr:#  * @ctxt:  the XPath Parser context   *-  *  [24]   RelationalExpr ::=   AdditiveExpr  5  *                 | RelationalExpr '<' AdditiveExpr  5  *                 | RelationalExpr '>' AdditiveExpr  6  *                 | RelationalExpr '<=' AdditiveExpr 6  *                 | RelationalExpr '>=' AdditiveExpr   *7  *  A <= B > C is allowed ? Answer from James, yes with 1  *  (AdditiveExpr <= AdditiveExpr) > AdditiveExpr ,  *  which is basically what got implemented.  *C  * Parse and evaluate a Relational expression, then push the result   * on the stack   */    void; xmlXPathEvalRelationalExpr(xmlXPathParserContextPtr ctxt) { #     xmlXPathEvalAdditiveExpr(ctxt);      CHECK_ERROR;     SKIP_BLANKS;     while ((CUR == '<') ||            (CUR == '>') ||/            ((CUR == '<') && (NXT(1) == '=')) || /            ((CUR == '>') && (NXT(1) == '='))) {  	int inf, strict, ret;            if (CUR == '<') inf = 1; 	else inf = 0; 	if (NXT(1) == '=') strict = 0;  	else strict = 1;  	NEXT; 	if (!strict) NEXT; 
 	SKIP_BLANKS; '         xmlXPathEvalAdditiveExpr(ctxt); 
 	CHECK_ERROR; 0 	ret = xmlXPathCompareValues(ctxt, inf, strict);* 	valuePush(ctxt, xmlXPathNewBoolean(ret));     }  }    /**   * xmlXPathEvalEqualityExpr:#  * @ctxt:  the XPath Parser context   *-  *  [23]   EqualityExpr ::=   RelationalExpr  5  *                 | EqualityExpr '=' RelationalExpr  6  *                 | EqualityExpr '!=' RelationalExpr   *8  *  A != B != C is allowed ? Answer from James, yes with6  *  (RelationalExpr = RelationalExpr) = RelationalExpr8  *  (RelationalExpr != RelationalExpr) != RelationalExpr,  *  which is basically what got implemented.  *O  * Parse and evaluate an Equality expression, then push the result on the stack   *  */  void9 xmlXPathEvalEqualityExpr(xmlXPathParserContextPtr ctxt) { %     xmlXPathEvalRelationalExpr(ctxt);      CHECK_ERROR;     SKIP_BLANKS;?     while ((CUR == '=') || ((CUR == '!') && (NXT(1) == '='))) {  	xmlXPathObjectPtr res;  	int eq, equal;            if (CUR == '=') eq = 1; 
 	else eq = 0;  	NEXT; 	if (!eq) NEXT; 
 	SKIP_BLANKS; )         xmlXPathEvalRelationalExpr(ctxt); 
 	CHECK_ERROR; # 	equal = xmlXPathEqualValues(ctxt); ) 	if (eq) res = xmlXPathNewBoolean(equal); ' 	else res = xmlXPathNewBoolean(!equal);  	valuePush(ctxt, res);     }  }    /**   * xmlXPathEvalAndExpr: #  * @ctxt:  the XPath Parser context   *&  *  [22]   AndExpr ::=   EqualityExpr 0  *                 | AndExpr 'and' EqualityExpr   *J  * Parse and evaluate an AND expression, then push the result on the stack  *  */  void4 xmlXPathEvalAndExpr(xmlXPathParserContextPtr ctxt) {#     xmlXPathEvalEqualityExpr(ctxt);      CHECK_ERROR;     SKIP_BLANKS;@     while ((CUR == 'a') && (NXT(1) == 'n') && (NXT(2) == 'd')) { 	xmlXPathObjectPtr arg1, arg2;           SKIP(3);
 	SKIP_BLANKS; '         xmlXPathEvalEqualityExpr(ctxt); 
 	CHECK_ERROR;  	arg2 = valuePop(ctxt);  	arg1 = valuePop(ctxt);   	arg1->boolval &= arg2->boolval; 	valuePush(ctxt, arg1);  	xmlXPathFreeObject(arg2);     }  }    /**   * xmlXPathEvalExpr:#  * @ctxt:  the XPath Parser context   *  *  [14]   Expr ::=   OrExpr     *  [21]   OrExpr ::=   AndExpr )  *                 | OrExpr 'or' AndExpr    *F  * Parse and evaluate an expression, then push the result on the stack  *  */  void1 xmlXPathEvalExpr(xmlXPathParserContextPtr ctxt) {      xmlXPathEvalAndExpr(ctxt);     CHECK_ERROR;     SKIP_BLANKS;-     while ((CUR == 'o') && (NXT(1) == 'r')) {  	xmlXPathObjectPtr arg1, arg2;           SKIP(2);
 	SKIP_BLANKS; "         xmlXPathEvalAndExpr(ctxt);
 	CHECK_ERROR;  	arg2 = valuePop(ctxt);  	arg1 = valuePop(ctxt);   	arg1->boolval |= arg2->boolval; 	valuePush(ctxt, arg1);  	xmlXPathFreeObject(arg2);     }  }    /** #  * xmlXPathEvaluatePredicateResult: #  * @ctxt:  the XPath Parser context 4  * @res:  the Predicate Expression evaluation result9  * @index:  index of the current node in the current list   *4  * Evaluate a predicate result for the current node.E  * A PredicateExpr is evaluated by evaluating the Expr and converting F  * the result to a boolean. If the result is a number, the result willE  * be converted to true if the number is equal to the position of the E  * context node in the context node list (as returned by the position D  * function) and will be converted to false otherwise; if the resultE  * is not a number, then the result will be converted as if by a call   * to the boolean function.   */  int ? xmlXPathEvaluatePredicateResult(xmlXPathParserContextPtr ctxt,  8                                 xmlXPathObjectPtr res) {     if (res == NULL) return(0);      switch (res->type) {         case XPATH_BOOLEAN:  	    return(res->boolval);         case XPATH_NUMBER:? 	    return(res->floatval == ctxt->context->proximityPosition);          case XPATH_NODESET: * 	    return(res->nodesetval->nodeNr != 0);         case XPATH_STRING:' 	    return((res->stringval != NULL) && . 	           (xmlStrlen(res->stringval) != 0));         default: 	    STRANGE     }      return(0); }    /**   * xmlXPathEvalPredicate: #  * @ctxt:  the XPath Parser context   */  *  [8]   Predicate ::=   '[' PredicateExpr ']' #  *  [9]   PredicateExpr ::=   Expr    *  * ---------------------E  * For each node in the node-set to be filtered, the PredicateExpr is I  * evaluated with that node as the context node, with the number of nodes G  * in the node-set as the context size, and with the proximity position F  * of the node in the node-set with respect to the axis as the contextG  * position; if PredicateExpr evaluates to true for that node, the node B  * is included in the new node-set; otherwise, it is not included.  * ---------------------  *=  * Parse and evaluate a predicate for all the elements of the :  * current node list. Then refine the list by removing all&  * nodes where the predicate is false.  */  void6 xmlXPathEvalPredicate(xmlXPathParserContextPtr ctxt) {     const xmlChar *cur;      xmlXPathObjectPtr res;      xmlNodeSetPtr newset = NULL;     xmlNodeSetPtr oldset; 
     int i;       SKIP_BLANKS;     if (CUR != '[') { ) 	XP_ERROR(XPATH_INVALID_PREDICATE_ERROR);      } 	     NEXT;      SKIP_BLANKS;       /*?      * Extract the old set, and then evaluate the result of the @      * expression for all the element in the set. use it to grow      * up a new set.      */ %     oldset = ctxt->context->nodelist; #     ctxt->context->nodelist = NULL;      ctxt->context->node = NULL;   4     if ((oldset == NULL) || (oldset->nodeNr == 0)) { 	xmlXPathEvalExpr(ctxt);
 	CHECK_ERROR;   	ctxt->context->contextSize = 0;& 	ctxt->context->proximityPosition = 0; 	res = valuePop(ctxt); 	if (res != NULL)  	    xmlXPathFreeObject(res);      } else { 	/* > 	 * Save the expression pointer since we will have to evaluate. 	 * it multiple times. Initialize the new set. 	 */         cur = ctxt->cur;& 	newset = xmlXPathNodeSetCreate(NULL); 	 .         for (i = 0; i < oldset->nodeNr; i++) { 	    ctxt->cur = cur;    	    /* A 	     * Run the evaluation with a node list made of a single item  	     * in the nodeset.  	     */. 	    ctxt->context->node = oldset->nodeTab[i];$ 	    ctxt->context->nodelist = NULL;1 	    ctxt->context->contextSize = oldset->nodeNr; . 	    ctxt->context->proximityPosition = i + 1;   	    xmlXPathEvalExpr(ctxt); 	    CHECK_ERROR;    	    /* 9 	     * The result of the evaluation need to be tested to 3 	     * decided whether the filter succeeded or not  	     */ 	    res = valuePop(ctxt);6 	    if (xmlXPathEvaluatePredicateResult(ctxt, res)) {8 	        xmlXPathNodeSetAdd(newset, oldset->nodeTab[i]); 	    } 	    if (res != NULL)  		xmlXPathFreeObject(res); 	       	    ctxt->context->node = NULL; 	}   	/* 1 	 * The result is used as the new evaluation set.  	 */" 	ctxt->context->nodelist = newset; 	ctxt->context->node = NULL;! 	ctxt->context->contextSize = -1; ' 	ctxt->context->proximityPosition = -1;      }      if (CUR != ']') { ) 	XP_ERROR(XPATH_INVALID_PREDICATE_ERROR);      }      if (oldset != NULL)  	xmlXPathFreeNodeSet(oldset);   	     NEXT;      SKIP_BLANKS; #ifdef DEBUG_STEP 1     fprintf(xmlXPathDebug, "After predicate : "); A     xmlXPathDebugNodeSet(xmlXPathDebug, ctxt->context->nodelist);  #endif }    /**   * xmlXPathEvalBasis: #  * @ctxt:  the XPath Parser context   *-  *  [5]   Basis ::=   AxisName '::' NodeTest  !  *            | AbbreviatedBasis  +  *  [13]   AbbreviatedBasis ::=   NodeTest  ,  *                           | '@' NodeTest &  *  [7]   NodeTest ::=   WildcardName "  *              | NodeType '(' ')':  *              | 'processing-instruction' '(' Literal ')'!  *  [37]   WildcardName ::=   '*' &  *                    | NCName ':' '*'  *                    | QName   *'  * Evaluate one step in a Location Path   */  void2 xmlXPathEvalBasis(xmlXPathParserContextPtr ctxt) {     xmlChar *name = NULL;      xmlChar *prefix = NULL;      int type = 0; B     int axis = AXIS_CHILD; /* the default on abbreviated syntax */"     int nodetest = NODE_TEST_NONE;     int nodetype = 0;       xmlNodeSetPtr newset = NULL;       if (CUR == '@') { 
         NEXT;  	axis = AXIS_ATTRIBUTE;  	goto parse_NodeTest;      } else if (CUR == '*') {
         NEXT; !         nodetest = NODE_TEST_ALL;      } else {)         name = xmlXPathParseNCName(ctxt);  	if (name == NULL) {  	    XP_ERROR(XPATH_EXPR_ERROR); 	}( 	type = xmlXPathGetNameType(ctxt, name); 	switch (type) { 	    case IS_FUNCTION: { 		xmlXPathFunction func; 		int nbargs = 0;  		xmlXPathObjectPtr top;  "                 top = ctxt->value;( 		func = xmlXPathIsFunction(ctxt, name); 		if (func == NULL) {  		    xmlFree(name);) 		    XP_ERROR(XPATH_UNKNOWN_FUNC_ERROR);  		}  #ifdef DEBUG_EXPR 8 		fprintf(xmlXPathDebug, "Calling function %s\n", name); #endif   		if (CUR != '(') {  		    xmlFree(name);! 		    XP_ERROR(XPATH_EXPR_ERROR);  		}  		NEXT;    		while (CUR != ')') { 		    xmlXPathEvalExpr(ctxt);  		    nbargs++;  		    if (CUR == ')') break; 		    if (CUR != ',') {  			xmlFree(name);  			XP_ERROR(XPATH_EXPR_ERROR); 		    }  		    NEXT;  		}  		NEXT;  		xmlFree(name); 		func(ctxt, nbargs);  		if ((ctxt->value != top) &&  		    (ctxt->value != NULL) &&- 		    (ctxt->value->type == XPATH_NODESET)) {  		    xmlXPathObjectPtr cur;   		    cur = valuePop(ctxt); 0 		    ctxt->context->nodelist = cur->nodesetval;! 		    ctxt->context->node = NULL;  		    cur->nodesetval = NULL; ,                     xmlXPathFreeObject(cur); 		}  	        return; 	    } 	    /* 8 	     * Simple case: no axis seach all given node types. 	     */#             case NODE_TYPE_COMMENT: 4 	        if ((CUR != '(') || (NXT(1) != ')')) break;
 		SKIP(2); 		nodetest = NODE_TEST_TYPE; 		nodetype = XML_COMMENT_NODE; 		goto search_nodes;              case NODE_TYPE_TEXT:4 	        if ((CUR != '(') || (NXT(1) != ')')) break;
 		SKIP(2); 		nodetest = NODE_TEST_TYPE; 		nodetype = XML_TEXT_NODE;  		goto search_nodes;              case NODE_TYPE_NODE:/ 	        if ((CUR != '(') || (NXT(1) != ')')) {   		    nodetest = NODE_TEST_NAME; 		    break; 		} 
 		SKIP(2); 		nodetest = NODE_TEST_TYPE; 		nodetype = XML_ELEMENT_NODE; 		goto search_nodes;             case NODE_TYPE_PI: 	        if (CUR != '(') break; " 		if (name != NULL) xmlFree(name); 		name = NULL; 		if (NXT(1) != ')') { 		    xmlXPathObjectPtr cur;   		    /*, 		     * Specific case: search a PI by name.	 		     */                      NEXT;  		    nodetest = NODE_TEST_PI;  		    xmlXPathEvalLiteral(ctxt); 		    CHECK_ERROR; 		    if (CUR != ')') " 			XP_ERROR(XPATH_UNCLOSED_ERROR);                     NEXT; & 		    xmlXPathStringFunction(ctxt, 1); 		    CHECK_ERROR; 		    cur = valuePop(ctxt); ' 		    name = xmlStrdup(cur->stringval);  		    xmlXPathFreeObject(cur); 		} else 		    SKIP(2); 		nodetest = NODE_TEST_PI; 		goto search_nodes; 	  	    /* 3 	     * Handling of the compund form: got the axis.  	     */             case AXIS_ANCESTOR: '             case AXIS_ANCESTOR_OR_SELF:               case AXIS_ATTRIBUTE:             case AXIS_CHILD:!             case AXIS_DESCENDANT: )             case AXIS_DESCENDANT_OR_SELF:               case AXIS_FOLLOWING:(             case AXIS_FOLLOWING_SIBLING:              case AXIS_NAMESPACE:             case AXIS_PARENT:               case AXIS_PRECEDING:(             case AXIS_PRECEDING_SIBLING:             case AXIS_SELF: / 	        if ((CUR != ':') || (NXT(1) != ':')) {   		    nodetest = NODE_TEST_NAME; 		    break; 		} 
 		SKIP(2); 		axis = type; 		break; 	  	    /* : 	     * Default: abbreviated syntax the axis is AXIS_CHILD 	     */
 	    default: # 	        nodetest = NODE_TEST_NAME;  	} parse_NodeTest: " 	if (nodetest == NODE_TEST_NONE) { 	    if (CUR == '*') { 		NEXT;  		nodetest = NODE_TEST_ALL; 
 	    } else {  		if (name != NULL)  		    xmlFree(name);+ 		name = xmlXPathParseQName(ctxt, &prefix);  		if (name == NULL) { ! 		    XP_ERROR(XPATH_EXPR_ERROR);  		} ) 		type = xmlXPathGetNameType(ctxt, name);  		switch (type) {  		    /*9 		     * Simple case: no axis seach all given node types. 	 		     */  		    case NODE_TYPE_COMMENT: . 			if ((CUR != '(') || (NXT(1) != ')')) break; 			SKIP(2);  			nodetest = NODE_TEST_TYPE;  			nodetype = XML_COMMENT_NODE;  			goto search_nodes;  		    case NODE_TYPE_TEXT:. 			if ((CUR != '(') || (NXT(1) != ')')) break; 			SKIP(2);  			nodetest = NODE_TEST_TYPE;  			nodetype = XML_TEXT_NODE; 			goto search_nodes;  		    case NODE_TYPE_NODE:) 			if ((CUR != '(') || (NXT(1) != ')')) { ! 			    nodetest = NODE_TEST_NAME; 
 			    break;  			} 			SKIP(2);  			nodetest = NODE_TEST_TYPE;  			nodetype = XML_ELEMENT_NODE;  			goto search_nodes;  		    case NODE_TYPE_PI: 			if (CUR != '(') break; # 			if (name != NULL) xmlFree(name);  			name = NULL;  			if (NXT(1) != ')') {  			    xmlXPathObjectPtr cur;   	 			    /* - 			     * Specific case: search a PI by name. 
 			     */ 			    NEXT; 			    nodetest = NODE_TEST_PI; ! 			    xmlXPathEvalLiteral(ctxt);  			    CHECK_ERROR;  			    if (CUR != ')')# 				XP_ERROR(XPATH_UNCLOSED_ERROR);  			    NEXT;' 			    xmlXPathStringFunction(ctxt, 1);  			    CHECK_ERROR;  			    cur = valuePop(ctxt);( 			    name = xmlStrdup(cur->stringval); 			    xmlXPathFreeObject(cur); 	 			} else  			    SKIP(2);  			nodetest = NODE_TEST_PI;  			goto search_nodes;  		}  		nodetest = NODE_TEST_NAME; 	    }; 	} else if ((CUR == ':') && (nodetest == NODE_TEST_NAME)) { 
 	    NEXT; 	    prefix = name;  	    if (CUR == '*') { 	        NEXT; 		nodetest = NODE_TEST_ALL;  	    } else # 		name = xmlXPathParseNCName(ctxt);  	} else if (name == NULL)   	    XP_ERROR(XPATH_EXPR_ERROR);     }   
 search_nodes:           #ifdef DEBUG_STEP :     fprintf(xmlXPathDebug, "Basis : computing new set\n"); #endifG     newset = xmlXPathNodeCollectAndTest(ctxt, axis, nodetest, nodetype, 6                                         prefix, name);(     if (ctxt->context->nodelist != NULL). 	xmlXPathFreeNodeSet(ctxt->context->nodelist);%     ctxt->context->nodelist = newset;      ctxt->context->node = NULL;  #ifdef DEBUG_STEP '     fprintf(xmlXPathDebug, "Basis : "); :     xmlXPathDebugNodeSet(stdout, ctxt->context->nodelist); #endif$     if (name != NULL) xmlFree(name);(     if (prefix != NULL) xmlFree(prefix); }    /**i  * xmlXPathEvalStep:#  * @ctxt:  the XPath Parser contexte  *%  *  [4]   Step ::=   Basis Predicate*n)  *                     | AbbreviatedStep  $  *  [12]   AbbreviatedStep ::=   '.'#  *                           | '..'b  *'  * Evaluate one step in a Location PathD:  * A location step of . is short for self::node(). This is?  * particularly useful in conjunction with //. For example, the %  * location path .//para is short foru6  * self::node()/descendant-or-self::node()/child::paraA  * and so will select all para descendant elements of the context   * node.@  * Similarly, a location step of .. is short for parent::node().A  * For example, ../title is short for parent::node()/child::titleaE  * and so will select the title children of the parent of the contextf  * node.  */i void1 xmlXPathEvalStep(xmlXPathParserContextPtr ctxt) {t      xmlNodeSetPtr newset = NULL;       SKIP_BLANKS;*     if ((CUR == '.') && (NXT(1) == '.')) {	 	SKIP(2);u
 	SKIP_BLANKS;h' 	if (ctxt->context->nodelist == NULL) {  	    STRANGE 	    xmlXPathRoot(ctxt); 	}7 	newset = xmlXPathNodeCollectAndTest(ctxt, AXIS_PARENT,r2 			 NODE_TEST_TYPE, XML_ELEMENT_NODE, NULL, NULL);% 	if (ctxt->context->nodelist != NULL) 2 	    xmlXPathFreeNodeSet(ctxt->context->nodelist);" 	ctxt->context->nodelist = newset; 	ctxt->context->node = NULL;     } else if (CUR == '.') { 	NEXT;
 	SKIP_BLANKS;p     } else { 	xmlXPathEvalBasis(ctxt);y
 	SKIP_BLANKS;P 	while (CUR == '[') {;! 	    xmlXPathEvalPredicate(ctxt);  	}   	while (CUR == '@') {  		xmlXPathEvalBasis(ctxt); 		ctxt->context->node = NULL;  	}     }_ #ifdef DEBUG_STEP<&     fprintf(xmlXPathDebug, "Step : ");A     xmlXPathDebugNodeSet(xmlXPathDebug, ctxt->context->nodelist);  #endif }l   /**p$  * xmlXPathEvalRelativeLocationPath:#  * @ctxt:  the XPath Parser context(  **  *  [3]   RelativeLocationPath ::=   Step 7  *                     | RelativeLocationPath '/' Step e9  *                     | AbbreviatedRelativeLocationPath _O  *  [11]  AbbreviatedRelativeLocationPath ::=   RelativeLocationPath '//' Step u  *  */  voidA xmlXPathEvalRelativeLocationPath(xmlXPathParserContextPtr ctxt) {e      xmlNodeSetPtr newset = NULL;       SKIP_BLANKS;     xmlXPathEvalStep(ctxt);      SKIP_BLANKS;     while (CUR == '/') {' 	if ((CUR == '/') && (NXT(1) == '/')) { 
 	    SKIP(2);; 	    SKIP_BLANKS;e+ 	    if (ctxt->context->nodelist == NULL) {(	 		STRANGE  		xmlXPathRoot(ctxt);e 	    }G 	    newset = xmlXPathNodeCollectAndTest(ctxt, AXIS_DESCENDANT_OR_SELF,N6 			     NODE_TEST_TYPE, XML_ELEMENT_NODE, NULL, NULL);) 	    if (ctxt->context->nodelist != NULL) / 		xmlXPathFreeNodeSet(ctxt->context->nodelist); & 	    ctxt->context->nodelist = newset;  	    ctxt->context->node = NULL; 	    xmlXPathEvalStep(ctxt); 	} else if (CUR == '/') {0
 	    NEXT; 	    SKIP_BLANKS;  	    xmlXPathEvalStep(ctxt); 	}
 	SKIP_BLANKS;      }a }I   /**;  * xmlXPathEvalLocationPath:#  * @ctxt:  the XPath Parser contextf  *2  *  [1]   LocationPath ::=   RelativeLocationPath .  *                     | AbsoluteLocationPath >  *  [2]   AbsoluteLocationPath ::=   '/' RelativeLocationPath?9  *                     | AbbreviatedAbsoluteLocationPath E1  *  [10]   AbbreviatedAbsoluteLocationPath ::=   o7  *                           '//' RelativeLocationPath a  *=  * // is short for /descendant-or-self::node()/. For example,*B  * //para is short for /descendant-or-self::node()/child::para andG  * so will select any para element in the document (even a para element*B  * that is a document element will be selected by //para since theC  * document element node is a child of the root node); div//para isdC  * short for div/descendant-or-self::node()/child::para and so willa/  * select all para descendants of div children.t  */e void9 xmlXPathEvalLocationPath(xmlXPathParserContextPtr ctxt) {       xmlNodeSetPtr newset = NULL;       SKIP_BLANKS;     if (CUR != '/') { /         xmlXPathEvalRelativeLocationPath(ctxt);;     } else { 	while (CUR == '/') {L+ 	    if ((CUR == '/') && (NXT(1) == '/')) {l
 		SKIP(2); 		SKIP_BLANKS;& 		if (ctxt->context->nodelist == NULL) 		    xmlXPathRoot(ctxt);#+ 		newset = xmlXPathNodeCollectAndTest(ctxt,>; 		                 AXIS_DESCENDANT_OR_SELF, NODE_TEST_TYPE, # 				 XML_ELEMENT_NODE, NULL, NULL);m& 		if (ctxt->context->nodelist != NULL)3 		    xmlXPathFreeNodeSet(ctxt->context->nodelist);r# 		ctxt->context->nodelist = newset;	 		ctxt->context->node = NULL;>) 		xmlXPathEvalRelativeLocationPath(ctxt);t 	    } else if (CUR == '/') {e 		NEXT;  		SKIP_BLANKS; 		xmlXPathRoot(ctxt);  		if (CUR != 0)e- 		    xmlXPathEvalRelativeLocationPath(ctxt);a
 	    } else {r) 		xmlXPathEvalRelativeLocationPath(ctxt);	 	    } 	}     }D }P   /**t  * xmlXPathEval:  * @str:  the XPath expression  * @ctxt:  the XPath context  *9  * Evaluate the XPath Location Path in the given context.c  *G  * Returns the xmlXPathObjectPtr resulting from the eveluation or NULL.R-  *         the caller has to free the object.t  */p xmlXPathObjectPtr ; xmlXPathEval(const xmlChar *str, xmlXPathContextPtr ctxt) { #     xmlXPathParserContextPtr pctxt; &     xmlXPathObjectPtr res = NULL, tmp;     int stack = 0;       xmlXPathInit();t       CHECK_CONTEXTi       if (xmlXPathDebug == NULL)         xmlXPathDebug = stderr; 0     pctxt = xmlXPathNewParserContext(str, ctxt);     if (str[0] == '/')         xmlXPathRoot(pctxt);$     xmlXPathEvalLocationPath(pctxt);  8     /* TODO: cleanup nodelist, res = valuePop(pctxt); */     do {         tmp = valuePop(pctxt); 	if (tmp != NULL) {T 	    xmlXPathFreeObject(tmp);, 	    stack++;    d	         }      } while (tmp != NULL);     if (stack != 0) {sF 	fprintf(xmlXPathDebug, "xmlXPathEval: %d object left on the stack\n", 	        stack);     } ,     if (pctxt->error == XPATH_EXPRESSION_OK)8 	res = xmlXPathNewNodeSetList(pctxt->context->nodelist);     else         res = NULL;n         %     xmlXPathFreeParserContext(pctxt);=     return(res); }a   /**-  * xmlXPathEvalExpression:  * @str:  the XPath expression  * @ctxt:  the XPath context  *6  * Evaluate the XPath expression in the given context.  *G  * Returns the xmlXPathObjectPtr resulting from the evaluation or NULL.*-  *         the caller has to free the object.*  */  xmlXPathObjectPtrEE xmlXPathEvalExpression(const xmlChar *str, xmlXPathContextPtr ctxt) {*#     xmlXPathParserContextPtr pctxt;*     xmlXPathObjectPtr res, tmp;I     int stack = 0;       xmlXPathInit();d       CHECK_CONTEXTD       if (xmlXPathDebug == NULL)         xmlXPathDebug = stderr;T0     pctxt = xmlXPathNewParserContext(str, ctxt);     xmlXPathEvalExpr(pctxt);       res = valuePop(pctxt);     do {         tmp = valuePop(pctxt); 	if (tmp != NULL) {n 	    xmlXPathFreeObject(tmp);d
 	    stack++;A 	}     } while (tmp != NULL);     if (stack != 0) {nF 	fprintf(xmlXPathDebug, "xmlXPathEval: %d object left on the stack\n", 	        stack);     }T%     xmlXPathFreeParserContext(pctxt);a     return(res); }   ! #endif /* LIBXML_XPATH_ENABLED */s