 /*D  * valid.h : interface to the DTD handling and the validity checking  *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */      #ifndef __XML_VALID_H__  #define __XML_VALID_H__    #include <libxml/tree.h>   #ifdef __cplusplus extern "C" { #endif   /** >  * an xmlValidCtxt is used for error reporting when validating  */   G typedef void (*xmlValidityErrorFunc) (void *ctx, const char *msg, ...); I typedef void (*xmlValidityWarningFunc) (void *ctx, const char *msg, ...);   * typedef struct _xmlValidCtxt xmlValidCtxt;& typedef xmlValidCtxt *xmlValidCtxtPtr; struct _xmlValidCtxt {4     void *userData;			/* user specific data block */E     xmlValidityErrorFunc error;		/* the callback in case of errors */ I     xmlValidityWarningFunc warning;	/* the callback in case of warning */   B     /* Node analysis stack used when validating within entities */?     xmlNodePtr         node;          /* Current parsed Node */ F     int                nodeNr;        /* Depth of the parsing stack */J     int                nodeMax;       /* Max depth of the parsing stack */:     xmlNodePtr        *nodeTab;       /* array of nodes */  I     int              finishDtd;       /* finished validating the Dtd ? */  };   /*2  * ALl notation declarations are stored in a table  * there is one table per DTD   */   ! #define XML_MIN_NOTATION_TABLE	32   2 typedef struct _xmlNotationTable xmlNotationTable;. typedef xmlNotationTable *xmlNotationTablePtr; struct _xmlNotationTable {7     int nb_notations;		/* number of notations stored */ 9     int max_notations;		/* maximum number of notations */ 8     xmlNotationPtr *table;	/* the table of attributes */ };   /*1  * ALl element declarations are stored in a table   * there is one table per DTD   */     #define XML_MIN_ELEMENT_TABLE	32  0 typedef struct _xmlElementTable xmlElementTable;, typedef xmlElementTable *xmlElementTablePtr; struct _xmlElementTable { 5     int nb_elements;		/* number of elements stored */ 7     int max_elements;		/* maximum number of elements */ 5     xmlElementPtr *table;	/* the table of elements */ +     int last;			/* last element accessed */  };   /*3  * ALl attribute declarations are stored in a table   * there is one table per DTD   */   " #define XML_MIN_ATTRIBUTE_TABLE	32  4 typedef struct _xmlAttributeTable xmlAttributeTable;0 typedef xmlAttributeTable *xmlAttributeTablePtr; struct _xmlAttributeTable { 9     int nb_attributes;		/* number of attributes stored */ ;     int max_attributes;		/* maximum number of attributes */ 9     xmlAttributePtr *table;	/* the table of attributes */  };   /*+  * ALl IDs attributes are stored in a table "  * there is one table per document  */    #define XML_MIN_ID_TABLE	32   & typedef struct _xmlIDTable xmlIDTable;" typedef xmlIDTable *xmlIDTablePtr; struct _xmlIDTable {,     int nb_ids;			/* number of ids stored */-     int max_ids;		/* maximum number of ids */ ,     xmlIDPtr *table;		/* the table of ids */ };   /*,  * ALl Refs attributes are stored in a table"  * there is one table per document  */    #define XML_MIN_REF_TABLE	32  ( typedef struct _xmlRefTable xmlRefTable;$ typedef xmlRefTable *xmlRefTablePtr; struct _xmlRefTable { .     int nb_refs;			/* number of refs stored *//     int max_refs;		/* maximum number of refs */ .     xmlRefPtr *table;		/* the table of refs */ };   /* Notation */< xmlNotationPtr	    xmlAddNotationDecl	(xmlValidCtxtPtr ctxt, 					 xmlDtdPtr dtd, 					 const xmlChar *name, 					 const xmlChar *PublicID, 					 const xmlChar *SystemID); D xmlNotationTablePtr xmlCopyNotationTable(xmlNotationTablePtr table);: void		    xmlFreeNotationTable(xmlNotationTablePtr table);0 void		    xmlDumpNotationDecl	(xmlBufferPtr buf, 					 xmlNotationPtr nota); 0 void		    xmlDumpNotationTable(xmlBufferPtr buf,! 					 xmlNotationTablePtr table);    /* Element Content */ 9 xmlElementContentPtr xmlNewElementContent (xmlChar *name, $ 					   xmlElementContentType type);I xmlElementContentPtr xmlCopyElementContent(xmlElementContentPtr content); ; void		     xmlFreeElementContent(xmlElementContentPtr cur); . void		     xmlSprintfElementContent(char *buf,A 	                                   xmlElementContentPtr content,  					   int glob);  
 /* Element */ 9 xmlElementPtr	   xmlAddElementDecl	(xmlValidCtxtPtr ctxt,  					 xmlDtdPtr dtd, 					 const xmlChar *name, 					 xmlElementTypeVal type, $ 					 xmlElementContentPtr content);B xmlElementTablePtr xmlCopyElementTable	(xmlElementTablePtr table);8 void		   xmlFreeElementTable	(xmlElementTablePtr table);/ void		   xmlDumpElementTable	(xmlBufferPtr buf,   					 xmlElementTablePtr table);. void		   xmlDumpElementDecl	(xmlBufferPtr buf, 					 xmlElementPtr elem);   /* Enumeration */ 8 xmlEnumerationPtr  xmlCreateEnumeration	(xmlChar *name);4 void		   xmlFreeEnumeration	(xmlEnumerationPtr cur);> xmlEnumerationPtr  xmlCopyEnumeration	(xmlEnumerationPtr cur);   /* Attribute */ B xmlAttributePtr	    xmlAddAttributeDecl	    (xmlValidCtxtPtr ctxt, 					     xmlDtdPtr dtd, 					     const xmlChar *elem, 					     const xmlChar *name, 					     const xmlChar *ns,  					     xmlAttributeType type," 					     xmlAttributeDefault def,& 					     const xmlChar *defaultValue," 					     xmlEnumerationPtr tree);I xmlAttributeTablePtr xmlCopyAttributeTable  (xmlAttributeTablePtr table); ? void		     xmlFreeAttributeTable  (xmlAttributeTablePtr table); 4 void		     xmlDumpAttributeTable  (xmlBufferPtr buf,& 					     xmlAttributeTablePtr table);4 void		     xmlDumpAttributeDecl   (xmlBufferPtr buf,  					     xmlAttributePtr attr);  	 /* IDs */ ( xmlIDPtr	xmlAddID	(xmlValidCtxtPtr ctxt, 				 xmlDocPtr doc,  				 const xmlChar *value, 				 xmlAttrPtr attr);3 xmlIDTablePtr	xmlCopyIDTable	(xmlIDTablePtr table); + void		xmlFreeIDTable	(xmlIDTablePtr table); # xmlAttrPtr	xmlGetID	(xmlDocPtr doc,  				 const xmlChar *ID); int		xmlIsID		(xmlDocPtr doc,  				 xmlNodePtr elem,  				 xmlAttrPtr attr);2 int		xmlRemoveID	(xmlDocPtr doc, xmlAttrPtr attr);   /* IDREFs */* xmlRefPtr	xmlAddRef	(xmlValidCtxtPtr ctxt, 				 xmlDocPtr doc,  				 const xmlChar *value, 				 xmlAttrPtr attr);6 xmlRefTablePtr	xmlCopyRefTable	(xmlRefTablePtr table);- void		xmlFreeRefTable	(xmlRefTablePtr table);  int		xmlIsRef	(xmlDocPtr doc,  				 xmlNodePtr elem,  				 xmlAttrPtr attr);3 int		xmlRemoveRef	(xmlDocPtr doc, xmlAttrPtr attr);    /** 9  * The public function calls related to validity checking   */   , int		xmlValidateRoot		(xmlValidCtxtPtr ctxt, 					 xmlDocPtr doc); 2 int		xmlValidateElementDecl	(xmlValidCtxtPtr ctxt, 					 xmlDocPtr doc,/ 		                         xmlElementPtr elem); 8 xmlChar *	xmlValidNormalizeAttributeValue(xmlDocPtr doc, 					 xmlNodePtr elem, 					 const xmlChar *name, 					 const xmlChar *value);3 int		xmlValidateAttributeDecl(xmlValidCtxtPtr ctxt,  					 xmlDocPtr doc,1 		                         xmlAttributePtr attr); 5 int		xmlValidateAttributeValue(xmlAttributeType type,  					 const xmlChar *value);3 int		xmlValidateNotationDecl	(xmlValidCtxtPtr ctxt,  					 xmlDocPtr doc,0 		                         xmlNotationPtr nota);+ int		xmlValidateDtd		(xmlValidCtxtPtr ctxt,  					 xmlDocPtr doc, 					 xmlDtdPtr dtd); / int		xmlValidateDtdFinal	(xmlValidCtxtPtr ctxt,  					 xmlDocPtr doc); / int		xmlValidateDocument	(xmlValidCtxtPtr ctxt,  					 xmlDocPtr doc); . int		xmlValidateElement	(xmlValidCtxtPtr ctxt, 					 xmlDocPtr doc, 					 xmlNodePtr elem); 1 int		xmlValidateOneElement	(xmlValidCtxtPtr ctxt,  					 xmlDocPtr doc,, 		                         xmlNodePtr elem);3 int		xmlValidateOneAttribute	(xmlValidCtxtPtr ctxt,  					 xmlDocPtr doc, 					 xmlNodePtr	elem, 					 xmlAttrPtr attr, 					 const xmlChar *value);3 int		xmlValidateDocumentFinal(xmlValidCtxtPtr ctxt,  					 xmlDocPtr doc); 2 int		xmlValidateNotationUse	(xmlValidCtxtPtr ctxt, 					 xmlDocPtr doc,# 					 const xmlChar *notationName); & int		xmlIsMixedElement	(xmlDocPtr doc, 					 const xmlChar *name); 1 xmlAttributePtr	xmlGetDtdAttrDesc	(xmlDtdPtr dtd,  					 const xmlChar *elem, 					 const xmlChar *name); 4 xmlNotationPtr	xmlGetDtdNotationDesc	(xmlDtdPtr dtd, 					 const xmlChar *name); 2 xmlElementPtr	xmlGetDtdElementDesc	(xmlDtdPtr dtd, 					 const xmlChar *name);   , int		xmlValidGetValidElements(xmlNode *prev, 					 xmlNode *next, 					 const xmlChar **list,  					 int max); ; int		xmlValidGetPotentialChildren(xmlElementContent *ctree,  					 const xmlChar **list,  					 int *len,  					 int max);  #ifdef __cplusplus }  #endif #endif /* __XML_VALID_H__ */