 /*J  * encoding.h : interface for the encoding conversion functions needed for  *              XML   *  * Related specs: A  * rfc2044        (UTF-8 and UTF-16) F. Yergeau Alis Technologies -  * [ISO-10646]    UTF-8 and UTF-16 in Annexes /  * [ISO-8859-1]   ISO Latin-1 characters codes. B  * [UNICODE]      The Unicode Consortium, "The Unicode Standard --H  *                Worldwide Character Encoding -- Version 1.0", Addison-C  *                Wesley, Volume 1, 1991, Volume 2, 1992.  UTF-8 is ;  *                described in Unicode Technical Report #4. G  * [US-ASCII]     Coded Character Set--7-bit American Standard Code for :  *                Information Interchange, ANSI X3.4-1986.  *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */    #ifndef __XML_CHAR_ENCODING_H__  #define __XML_CHAR_ENCODING_H__    #include <libxml/xmlversion.h> #ifdef LIBXML_ICONV_ENABLED  #include <iconv.h> #endif #include <libxml/tree.h>   #ifdef __cplusplus extern "C" { #endif   /** 0  * Predefined values for some standard encodings<  * Libxml don't do beforehand translation on UTF8, ISOLatinX0  * It also support UTF16 (LE and BE) by default.  *A  * Anything else would have to be translated to UTF8 before being A  * given to the parser itself. The BOM for UTF16 and the encoding B  * declaration are looked at and a converter is looked for at thatD  * point. If not found the parser stops here as asked by the XML RECO  * Converter can be registered by the user using xmlRegisterCharEncodingHandler F  * but the currentl form doesn't allow stateful transcoding (a serious=  * problem agreed !). If iconv has been found it will be used E  * automatically and allow stateful transcoding, the simplest is then G  * to be sure to enable icon and to provide iconv libs for the encoding   * support needed.  */  typedef enum {B     XML_CHAR_ENCODING_ERROR=   -1, /* No char encoding detected */>     XML_CHAR_ENCODING_NONE=	0, /* No char encoding detected */*     XML_CHAR_ENCODING_UTF8=	1, /* UTF-8 */<     XML_CHAR_ENCODING_UTF16LE=	2, /* UTF-16 little endian */9     XML_CHAR_ENCODING_UTF16BE=	3, /* UTF-16 big endian */ :     XML_CHAR_ENCODING_UCS4LE=	4, /* UCS-4 little endian */7     XML_CHAR_ENCODING_UCS4BE=	5, /* UCS-4 big endian */ 1     XML_CHAR_ENCODING_EBCDIC=	6, /* EBCDIC uh! */ ?     XML_CHAR_ENCODING_UCS4_2143=7, /* UCS-4 unusual ordering */ ?     XML_CHAR_ENCODING_UCS4_3412=8, /* UCS-4 unusual ordering */ *     XML_CHAR_ENCODING_UCS2=	9, /* UCS-2 */=     XML_CHAR_ENCODING_8859_1=	10,/* ISO-8859-1 ISO Latin 1 */ =     XML_CHAR_ENCODING_8859_2=	11,/* ISO-8859-2 ISO Latin 2 */ 1     XML_CHAR_ENCODING_8859_3=	12,/* ISO-8859-3 */ 1     XML_CHAR_ENCODING_8859_4=	13,/* ISO-8859-4 */ 1     XML_CHAR_ENCODING_8859_5=	14,/* ISO-8859-5 */ 1     XML_CHAR_ENCODING_8859_6=	15,/* ISO-8859-6 */ 1     XML_CHAR_ENCODING_8859_7=	16,/* ISO-8859-7 */ 1     XML_CHAR_ENCODING_8859_8=	17,/* ISO-8859-8 */ 1     XML_CHAR_ENCODING_8859_9=	18,/* ISO-8859-9 */ 4     XML_CHAR_ENCODING_2022_JP=  19,/* ISO-2022-JP */2     XML_CHAR_ENCODING_SHIFT_JIS=20,/* Shift_JIS *//     XML_CHAR_ENCODING_EUC_JP=   21,/* EUC-JP */ 3     XML_CHAR_ENCODING_ASCII=    22 /* pure ASCII */  } xmlCharEncoding;   /**   * xmlCharEncodingInputFunc:B  * @out:  a pointer ot an array of bytes to store the UTF-8 result  * @outlen:  the lenght of @out @  * @in:  a pointer ot an array of chars in the original encoding  * @inlen:  the lenght of @in   *D  * Take a block of chars in the original encoding and try to convert%  * it to an UTF-8 block of chars out.   *D  * Returns the number of byte written, or -1 by lack of space, or -2!  *     if the transcoding failed. D  * The value of @inlen after return is the number of octets consumed<  *     as the return value is positive, else unpredictiable.F  * The value of @outlen after return is the number of ocetes consumed.  */ I typedef int (* xmlCharEncodingInputFunc)(unsigned char* out, int *outlen, N                                          const unsigned char* in, int *inlen);     /**   * xmlCharEncodingOutputFunc: <  * @out:  a pointer ot an array of bytes to store the result  * @outlen:  the lenght of @out -  * @in:  a pointer ot an array of UTF-8 chars   * @inlen:  the lenght of @in   *C  * Take a block of UTF-8 chars in and try to convert it to an other   * encoding.E  * Note: a first call designed to produce heading info is called with G  * in = NULL. If stateful this should also initialize the encoder state   *D  * Returns the number of byte written, or -1 by lack of space, or -2!  *     if the transcoding failed. D  * The value of @inlen after return is the number of octets consumed<  *     as the return value is positive, else unpredictiable.F  * The value of @outlen after return is the number of ocetes consumed.  */ J typedef int (* xmlCharEncodingOutputFunc)(unsigned char* out, int *outlen,O                                           const unsigned char* in, int *inlen);      /*7  * Block defining the handlers for non UTF-8 encodings. 4  * If iconv is supported, there is two extra fields   */   > typedef struct _xmlCharEncodingHandler xmlCharEncodingHandler;: typedef xmlCharEncodingHandler *xmlCharEncodingHandlerPtr;  struct _xmlCharEncodingHandler {%     char                       *name; %     xmlCharEncodingInputFunc   input; &     xmlCharEncodingOutputFunc  output; #ifdef LIBXML_ICONV_ENABLED (     iconv_t                    iconv_in;)     iconv_t                    iconv_out; ! #endif /* LIBXML_ICONV_ENABLED */  };   /*#  * Interfaces for encoding handlers   */ ( void	xmlInitCharEncodingHandlers	(void);+ void	xmlCleanupCharEncodingHandlers	(void); H void	xmlRegisterCharEncodingHandler	(xmlCharEncodingHandlerPtr handler); xmlCharEncodingHandlerPtr 1 	xmlGetCharEncodingHandler	(xmlCharEncoding enc);  xmlCharEncodingHandlerPtr / 	xmlFindCharEncodingHandler	(const char *name);      /*,  * Interfaces for encoding names and aliases  */ + int	xmlAddEncodingAlias		(const char *name,  					 const char *alias); - int	xmlDelEncodingAlias		(const char *alias);  const char ** 	xmlGetEncodingAlias		(const char *alias);& void	xmlCleanupEncodingAliases	(void); xmlCharEncoding * 	xmlParseCharEncoding		(const char* name); const char* / 	xmlGetCharEncodingName		(xmlCharEncoding enc);    /*+  * Interfaces directly used by the parsers.   */  xmlCharEncoding 1 	xmlDetectCharEncoding		(const unsigned char* in,  					 int len);   . int	xmlCheckUTF8			(const unsigned char *utf);  8 int	xmlCharEncOutFunc		(xmlCharEncodingHandler *handler, 					 xmlBufferPtr out,  					 xmlBufferPtr in);   7 int	xmlCharEncInFunc		(xmlCharEncodingHandler *handler,  					 xmlBufferPtr out,  					 xmlBufferPtr in); : int	xmlCharEncFirstLine		(xmlCharEncodingHandler *handler, 					 xmlBufferPtr out,  					 xmlBufferPtr in); ; int	xmlCharEncCloseFunc		(xmlCharEncodingHandler *handler);    #ifdef __cplusplus }  #endif  $ #endif /* __XML_CHAR_ENCODING_H__ */