$	! (c) RRL,1999
$	!
$	! Description:	Prepare .DETAIL file at nightly basis, these files
$	!		can be imported by platypus automaticaly.
$	!
$	!		In PLATYPUS you must have correctly defined:
$	!
$	!		RADIUS Server, for example
$	!			Server name:		DLS Internet Service
$	!			Host address:		StarLet.DLS.NET
$	!			Radius directory:	/disk$radius
$	!			...
$	!
$	!		TERMINAL Server
$	!			Name:			RADIUS
$	!			Filename:		RADIUS
$	!			...
$	!	*Note:	PLATYPUS find file RADIUS. (from "Filename" field) in 
$	!		"/disk$radius/radius" directory
$	!
$	set verify
$	!
$	on warning then $gosub onwarning
$
$	submit/noprint/after="tomorrow" /restart/retain=err -
	/queue=cluster$batch/log=radius_dir -
	/user=system radius_dir:radius4platypus.com
$	!
$	today = f$cvtime(f$time(),,"date") - "-" - "-"
$	if "".nes.f$search("RADACCT_DIR:RADIUS_DETAIL.''today'")
$	then
$		date = today
$		file = "RADACCT_DIR:RADIUS_DETAIL.''today'"
$		goto	rad_merge
$	endif
$	
$ create/fdl=sys$input radius_detail
SYSTEM
        SOURCE                  OpenVMS

FILE
        ALLOCATION              64
        BEST_TRY_CONTIGUOUS     no
        CLUSTER_SIZE            9
        CONTIGUOUS              no
        EXTENSION               4
        FILE_MONITORING         no
        GLOBAL_BUFFER_COUNT     0
        ORGANIZATION            sequential
        PROTECTION              (system:RWED, owner:RWED, group:RE, world:)

RECORD
        BLOCK_SPAN              yes
        CARRIAGE_CONTROL        carriage_return
        FORMAT                  stream_lf
        SIZE                    0
$EOD
$
$	wait	00:21:00	!RadiusVMS server reopening all files for each 20 minutes
$	
$	file	= f$search("RADACCT_DIR:RADIUS_DETAIL.DAT;-1")
$	date	= f$cvtime(f$file(file,"cdt"),,"date") - "-" - "-"
$	rename	'file' RADACCT_DIR:RADIUS_DETAIL.'date' /log
$	file	= "RADACCT_DIR:RADIUS_DETAIL.''date'"
$	
$rad_merge:
$	if "".nes.f$search("RADACCT_DIR:RADIUS.")
$	then
$		copy	RADACCT_DIR:RADIUS. , 'file' RADACCT_DIR:RADIUS.; /log
$	else
$		copy	'file' RADACCT_DIR:RADIUS. /log
$	endif
$
$	set	noon
$	delete	RADACCT_DIR:RADIUS_DETAIL.*;* /befo="-120-" /log
$	purge	/keep=7/log radius_dir:radius4platypus_log.log
$	exit	1
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$onwarning:
$
$ status = $STATUS
$ if $SEVERITY.ge.2 then $goto onerror
$ set noon
$ mail nl: "@staff.dis" -
  /subj="%RADIUS4PLATYPUS_LOG-W-DIAGS, See radius_dir:radius4platypus_log.log for warnings,''f$message(status)'"
$	set on
$	on warning then $gosub onwarning
$	return
$
$onerror:
$ set noon
$ mail nl: "@staff.dis" -
  /subj="%RADIUS4PLATYPUS_LOG-E-DIAGS, See radius_dir:radius4platypus_log.log for errors,''f$message(status)'"
$ set on
$	on warning then $gosub onwarning
$	return
