$!  MEGA_NAME_TABLE.COM
$!
$!  Command file to set up the application logical name table
$!  the mega_zillionare demonstration application.
$!
$!  The system startup should submit this job off to batch once
$!  so the table is created
$!
$!  Required parameters:
$!  P1      environment code "D01", "T01", "S01", or "P01"
$!
$ bell[0,7] = %x07
$!
$ say :== WRITE SYS$OUTPUT
$!
$!;;;;;
$!  Make sure user supplied a parameter
$!;;;;;
$ if "''p1'" .eqs. ""
$ then
$   say bell, bell, bell
$   say "you must supply P1 of D01, T01, S01, or P01
$   goto exit_program
$ endif
$!
$!;;;;;
$!  Validate the parameter
$!;;;;;
$ env_str = f$edit( "''p1'", "COLLAPSE,UPCASE")
$ if env_str .eqs. "D01" then goto good_parm
$ if env_str .eqs. "T01" then goto good_parm
$ if env_str .eqs. "S01" then goto good_parm
$ if env_str .eqs. "P01" then goto good_parm
$!
$!   Supplied parameter invalid
$!
$ say bell, bell, bell
$ SAY "you must supply P1 of D01, T01, S01, or P01
$ goto exit_program
$!
$!;;;;;
$!  Set up environment
$!;;;;;
$good_parm:
$!;;;;;
$!
$!  See if logical name table has been created
$!
$!;;;;;
$! set verify
$ tab_name = "MEGA_''env_str'_TABLE"
$ a = f$trnlnm( "''tab_name'", "lnm$system_directory")
$ if "''a'" .eqs. ""
$ then
$       say "Creating Table"
$       create/name_table/parent_table=lnm$system_directory 'tab_name'
$ endif
$!
$!  Repopulate the table
$!
$ define/table='tab_name'/translation=(concealed,terminal)  mega_root    dka1200:[mega_'env_str'.]
$!
$ define/table='tab_name'  mega_env         'env_str'
$ define/table='tab_name'  mega_cms         mega_root:[cms]
$ define/table='tab_name'  mega_cms_ref     mega_root:[cms_ref]
$ define/table='tab_name'  mega_exe         mega_root:[exe]
$!
$ define/table='tab_name'  mega_dat         mega_root:[data]
$!
$!   New logicals added during CMS chapter.
$!
$ define/table='tab_name'  mega_obj         mega_root:[obj]
$ define/table='tab_name'  mega_inc         [], mega_cms_ref
$ define/table='tab_name'  mega_src         [], mega_cms_ref
$ define/table='tab_name'  my_mega_file     mega_dat:my_mega_file.idx
$ define/table='tab_name'  mega_stats       mega_dat:mega_stats.idx
$ define/table='tab_name'  drawing_stats    mega_dat:drawing_stats.idx
$ define/table='tab_name'  mega_zill        mega_exe:mega_zill.flb
$ define/table='tab_name'  mega_com         mega_root:[com]
$!
$!;;;;;
$!  New Logicals added during CDD chapter
$!;;;;;
$!
$!      Ordinarily this logical would be provided by the DBA or
$!      Sys Admin group
$!
$   define/table='tab_name'/trans=(concealed,terminal)  cdd_root     dka1200:[cdd_repositories.]
$!
$!      These logicals we would have to define ourselves.
$!      If "bega" was really an ASC code we would not define it here.
$!      The environment file would map onto both name tables and we would
$!      pick the "bega_cdd_path" definition from that table.
$!
$   define/table='tab_name'  mega_cdd_path       cdd_root:['env_str']mega
$   define/table='tab_name'  bega_cdd_path       cdd_root:['env_str']bega
$!
$!      Logical added during RDB chapter
$!
$   define/table='tab_name' mega_rdb_path       cdd_root:['env_str']rdb
$!
$!;;;;;
$!      Logicals added for Chapter 7 Object and Text Libraries
$!;;;;;
$ define/table='tab_name'   mega_text_lib   mega_obj:mega_txt.tlb
$ define/table='tab_name'   mega_obj_lib    mega_obj:mega.olb
$!
$!;;;;;
$!  Logical for RDB database
$!;;;;;
$ define/table='tab_name'   mega_db_rdb    dkb200:[mega_rdb]mega_db_'env_str'
$! 
$EXIT_PROGRAM:
$ exit
