        SUBROUTINE FTN_SQLM_ZILL_MOST_REPORT_SUB
        IMPLICIT NONE

    !
    !   Create a report of numbers which are most frequently hit
    !   Both regular drawing numbers and MEGA numbers will be included
    !
	INCLUDE '(LIB$ROUTINES)'
	INCLUDE '($FORIOSDEF)'

!;;;;;
!       Constants we need
!;;;;;
	INTEGER*1   K_RPT_CHAN, K_ELM_COUNT
        PARAMETER( K_RPT_CHAN=11, K_ELM_COUNT=52)

        CHARACTER*13  RPT_FILE
        PARAMETER( RPT_FILE='ZILL_MOST.RPT')

	REAL    ONE_SECOND
	PARAMETER( ONE_SECOND=1.0)

!;;;;;
!	Local variables
!;;;;;
	INTEGER*4   L_D_STAT, L_M_STAT, SQLCODE
        INTEGER*1   B_SUB, B_LOC_COUNT, B_DONE, B_END, B_X, ELM_NO
        INTEGER*4   HIT_COUNT, LAST_DRAW_NO, SINCE_LAST, CURR_SEQ, LONGEST_SEQ, MAX_BTWN
        REAL*8      PCT_HITS, AVE_BTWN
	CHARACTER*8 DATE_STR

	CHARACTER*255 COMMAND_STR
!;;;;;;;;;;
!	Main Logic
!;;;;;;;;;;
        CALL OPEN_MOST_DRAW( SQLCODE)
        CALL OPEN_MOST_MEGA( SQLCODE)

 105    OPEN (UNIT=K_RPT_CHAN, STATUS='NEW', &
              FILE=RPT_FILE, DISP='KEEP',FORM='FORMATTED', &
              CARRIAGECONTROL='LIST', RECL=80)


!;;;;;;;;;;
!	Generate the report.
!;;;;;;;;;;
	
	!
	! Page title
	!
 300	CALL DATE_AND_TIME( DATE_STR)

	WRITE (UNIT=K_RPT_CHAN, FMT=302) DATE_STR(5:6), DATE_STR(7:8), DATE_STR(1:4), 1


 302    FORMAT ('DATE: ',A2,'/',A2,'/',A4, T29, 'Most Hit Numbers Report', T71, 'Page: ', I3)

	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '

	WRITE (UNIT=K_RPT_CHAN, FMT='(T29, A)') 'Regular Drawing Numbers'
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '

!
!	Column headings
!
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') 'No   Hits   Since   Pct_hits   Ave_btwn'

	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') '--   ----   -----   --------   --------'


	DO 312, B_SUB=1,10,1
            CALL FETCH_MOST_DRAW( SQLCODE, ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN)
            WRITE (UNIT=K_RPT_CHAN, FMT=306) ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN

 306	    FORMAT (I2,3X,I4,3X,I4,5X,F7.3,4X,F7.3)

 312	CONTINUE

	!
	!   Second page for Mega numbers
	!
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') CHAR( 12)

	WRITE (UNIT=K_RPT_CHAN, FMT=302) DATE_STR(5:6), DATE_STR(7:8), DATE_STR(1:4), 2

	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '

	WRITE (UNIT=K_RPT_CHAN, FMT='(T34, A)') 'Mega Numbers'
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '

!
!	Column headings
!
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') 'No   Hits   Since   Pct_hits   Ave_btwn'

	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') '--   ----   -----   --------   --------'


	DO 349, B_SUB=1,10,1
            CALL FETCH_MOST_MEGA( SQLCODE, ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN)
            WRITE (UNIT=K_RPT_CHAN, FMT=306) ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN

 349	CONTINUE

	GO TO 1000


 1000   CALL CLOSE_MOST_DRAW( SQLCODE)
        CALL CLOSE_MOST_MEGA( SQLCODE)
        CALL COMMIT_MEGA( SQLCODE)
	CLOSE( K_RPT_CHAN)

	COMMAND_STR = 'EDIT/READ '//RPT_FILE
	CALL LIB$SPAWN( COMMAND_STR,,0)
	RETURN
	END
