        SUBROUTINE FTN_FILL_IN_LOGICALS
        IMPLICIT NONE
C
C       Subroutine to fill in all of the logicals needed by the 
C       Mega_Zillionare application when written in fortran
C

        INCLUDE 'SYS$LIBRARY:FORSYSDEF(LIB$ROUTINES)'

C;;;;;
C       Fill in default file names
C;;;;;
        CHARACTER*12    DRAWING_DATA
        DATA DRAWING_DATA/'MY_MEGA_FILE'/

        CHARACTER*13    DRAWING_STATS
        DATA DRAWING_STATS/'DRAWING_STATS'/

        CHARACTER*10    MEGA_STATS
        DATA MEGA_STATS/'MEGA_STATS'/ 



        CHARACTER*255   TRANSLATED_NAME_STR, WORK_STR
        CHARACTER*1     FIRST_CHAR
        INTEGER*4       L_X
        INTEGER*2       W_X
        LOGICAL         IS_BLANK_LG


C;;;;;
C       Make certain the drawing_data logical exists
C       if not, give it a value in the local directory
C;;;;;
        TRANSLATED_NAME_STR = ' '
        L_X = LIB$GET_LOGICAL( DRAWING_DATA, TRANSLATED_NAME_STR, 
     1          W_X,,,,)


        FIRST_CHAR = TRANSLATED_NAME_STR
        IS_BLANK_LG = FIRST_CHAR .EQ. ' '

        IF (IS_BLANK_LG) THEN
            TRANSLATED_NAME_STR = DRAWING_DATA // '.IDX'
            L_X = LIB$SET_LOGICAL( DRAWING_DATA, 
     1              TRANSLATED_NAME_STR,,,)
        END IF


        TRANSLATED_NAME_STR = ' '
        L_X = LIB$GET_LOGICAL( DRAWING_STATS, TRANSLATED_NAME_STR, 
     1          W_X,,,,)


        IF (TRANSLATED_NAME_STR(1:1) .EQ. ' ') THEN
            TRANSLATED_NAME_STR = DRAWING_STATS // '.IDX'
            L_X = LIB$SET_LOGICAL( DRAWING_STATS, 
     1              TRANSLATED_NAME_STR,,,)
        END IF



        TRANSLATED_NAME_STR = ' '
        L_X = LIB$GET_LOGICAL( MEGA_STATS, TRANSLATED_NAME_STR, 
     1          W_X,,,,)


        FIRST_CHAR = TRANSLATED_NAME_STR

        IF (FIRST_CHAR .EQ. ' ') THEN
            TRANSLATED_NAME_STR = MEGA_STATS // '.IDX'
            L_X = LIB$SET_LOGICAL( MEGA_STATS, 
     1              TRANSLATED_NAME_STR,,,)
        END IF


        RETURN
        END
