/*  DRAWING_RECORD_CLASS.HXX                                                */
/*                                                                          */
/*      Header file containing all method prototypes, etc. for              */
/*      drawing_record_class.                                               */
/*                                                                          */
/*      Part of Mega Zillionare example application.                        */
/*                                                                          */
//;;;;;
//  ANSI header files
//;;;;;
#include <string>
#include <stdlib>

//;;;;;
//  VMS header files
//;;;;;
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>

//;;;;;
//  Our header files
//;;;;;
#pragma member_alignment save
#pragma nomember_alignment
#include "drawing_record.h"     // local file generated by CDO script
#pragma member_alignment restore


class Drawing_Record_Class
{
protected:
    char default_file_name[255];

    char    file_name[255];
    
    struct drawing_record local_rec;
    struct FAB local_fab;
    struct RAB local_rab;
    struct XABKEY local_xab;
    
public:
    //
    //  Constructor and Destructor
    //  
    Drawing_Record_Class();
    ~Drawing_Record_Class();

    //
    //  Open and close
    //  
    int open( int access = FAB$M_GET, char *f_name = NULL);

    void close( void);
    
    //
    //  Routines for record IO
    //  
    int get_via_k0( char *key_val, struct drawing_record *d = NULL);
    int get_seq( struct drawing_record *d = NULL);
    int get_next_key( struct drawing_record *d = NULL);
    int get_next_key_rev( struct drawing_record *d = NULL);

    int put_record( struct drawing_record *d = NULL);

    int update_record( struct drawing_record *d = NULL);

    int delete_record( void);
    
    //
    //  Routines to transfer record data to and from class
    //  
    void get_record_data( struct drawing_record *d);
    void set_record_data( struct drawing_record *d);

};  /* end drawing_record_class definition */
