/*      CXX_ZILL_IMPORT_SUB.CXX                                             */
/*                                                                          */
/*      Subroutine to create a shiny new drawing index file.                */
/*                                                                          */
/*
 *      ANSI headers
 */
#include <string>
#include <iostream>
#include <fstream>
#include <time.h>

/*
 *      VMS headers
 */
#include <lib$routines>

/*
 *  Our headers
 */
#include "drawing_record_class.hxx"

//
//  notice that we didn't include the descriptor header file
//  it was included by one of the other files under c++
//  
#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */

/*;;;;;
 *      Function prototypes
 *;;;;;
 */
extern "C" void c_fill_in_logicals( void);

void cxx_parse_csv_line( char *in_str, struct drawing_record *d);


/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void cxx_zill_import_sub( )
{
    int                     l_x, l_count;
    char                    line_in[255], command_str[255],
                            file_name_str[255];
    ifstream                in_file;
    struct  drawing_record  d_rec;
    Drawing_Record_Class    draw_file;
    
    $DESCRIPTOR( command_str_desc, command_str);

    //
    //  Loop until we have a valid input file
    //  
    l_x = -1;
    while ( l_x != 0)
    {
        memset( file_name_str, '\0', sizeof( file_name_str));
        cout << endl << endl << "Input file name: ";
        cin >> file_name_str;
        in_file.open( file_name_str, ios::in);
        l_x = in_file.fail();
    }  /* end test for valid input file */


    //
    //  Create a new indexed file
    //
    strcpy( command_str, "CREATE/FDL=MEGA_DAT:DRAWING_DATA.FDL MY_MEGA_FILE");
    LENGTH( command_str_desc) = strlen( command_str);
    l_x = lib$spawn( &command_str_desc);

    l_x = draw_file.open( FAB$M_PUT);
    if ( !(l_x & 1))
    {
        cout << "Unable to open input file " << endl;
        return;
    }  /* end test for successful open */

    l_count = 0;
    do
    {
        memset( line_in, '\0', sizeof( line_in));
        memset( &d_rec, '\0', sizeof( d_rec));
        in_file.getline( line_in, sizeof( line_in)-1, '\n');
        if ( in_file.eof() == 0)
        {
            l_count++;
            cxx_parse_csv_line( line_in, &d_rec);
            l_x = draw_file.put_record( &d_rec);
            if ( !(l_x & 1))
            {
                cout << "Error " << l_x << " writing record ";
                cout << l_count << " to indexed file" << endl;
            }

            if ( (l_count % 100) == 0)
                cout << "Processed " << l_count << " records" << endl;
                
        }  /* end test for end of file */
        
    } while (in_file.eof() == 0);

    cout << "Processed " << l_count << " records" << endl;

    in_file.close();
    draw_file.close();
}  /* end cxx_zill_import_sub subroutine */

//;;;;;
//  subroutine to parse out the comma seperated values and return
//  a binary record.
//;;;;;
void cxx_parse_csv_line( char *in_str, struct drawing_record *d)
{
    int         l_x, l_mm, l_dd, l_yyyy, l_y;
    char        work_str[255];
    string      rec_str( in_str);

    //
    //  Convert the date from mm/dd/yyyy to yyyymmdd
    //  
    l_x     = rec_str.find( "/", 0);
    l_mm    = atol( rec_str.substr( 0, l_x).c_str());
    l_y     = rec_str.find( "/", l_x+1);
    l_dd    = atol( rec_str.substr( l_x+1, l_y-(l_x+1)).c_str());
    l_x     = rec_str.find( ",", l_y+1);
    l_yyyy  = atol( rec_str.substr( l_y+1, l_x-(l_y+1)).c_str());
    
    sprintf( work_str, "%4d%02d%02d", l_yyyy, l_mm, l_dd);
    memcpy( d->draw_dt, work_str, sizeof( d->draw_dt));

    //
    //  Now get the drawing numbers
    //
    l_y     = rec_str.find( ",", l_x+1);
    d->no_1 = atol( rec_str.substr( l_x+1, l_y-(l_x+1)).c_str());
    l_x     = rec_str.find( ",", l_y+1);
    d->no_2 = atol( rec_str.substr( l_y+1, l_x-(l_y+1)).c_str());
    l_y     = rec_str.find( ",", l_x+1);
    d->no_3 = atol( rec_str.substr( l_x+1, l_y-(l_x+1)).c_str());
    l_x     = rec_str.find( ",", l_y+1);
    d->no_4 = atol( rec_str.substr( l_y+1, l_x-(l_y+1)).c_str());
    l_y     = rec_str.find( ",", l_x+1);
    d->no_5 = atol( rec_str.substr( l_x+1, l_y-(l_x+1)).c_str());

    //
    //  mega number does not have comma after it
    //  
    d->mega_no = atol( rec_str.substr( l_y+1).c_str());

}  /* end cxx_parse_csv_line subroutine */
