IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_ZILL_MOST_REPORT_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-02-09.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT DRAW-STATS
        ASSIGN TO 'DRAWING_STATS'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS SEQUENTIAL
        RECORD KEY IS ELM_NO IN DSTATS-REC
        FILE STATUS IS D-STAT.

    SELECT MEGA-STATS
        ASSIGN TO 'MEGA_STATS'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS SEQUENTIAL
        RECORD KEY IS ELM_NO IN MSTATS-REC
        FILE STATUS IS M-STAT.

    SELECT SORT-FILE ASSIGN TO 'TMP.SRT'.

    SELECT SORTED-FILE ASSIGN TO DISK.

    SELECT RPT-FILE ASSIGN TO 'ZILL_MOST.RPT'.

DATA DIVISION.

FILE SECTION.

FD  DRAW-STATS
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY DSTATS-REC.


FD  MEGA-STATS
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY MSTATS-REC.

FD  RPT-FILE
    LABEL RECORDS ARE OMITTED
    REPORT IS REPORT-LISTING.


SD  SORT-FILE.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY SORT-REC.

FD  SORTED-FILE
    VALUE OF ID IS SORTED-FILE-NAME.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY SORTED-REC.
   


**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 CONSTANTS.
       05 SORT-FILE-NAME        PIC X(7) VALUE 'TMP.SRT'.
       05 SORTED-FILE-NAME      PIC X(8) VALUE 'STAT.SRT'.

    01 STATUS-VARIABLES.
       05 M-STAT                PIC X(2).
       05 D-STAT                PIC X(2).
       05 EOF-FLAG              PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.

    01 STUFF.
       05 TODAYS-DATE.
          10 TODAY_YYYY         PIC X(4).
          10 TODAY_MM           PIC X(2).
          10 TODAY_DD           PIC X(2).

       05 TODAYS-DATE-FORMATTED.
          10 FMT_MM             PIC Z9.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_DD             PIC 99.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_YYYY           PIC 9(4).

       05 GROUP-TITLE           PIC X(20).

       05 L-COUNT               PIC S9(9) COMP.
       05 WORK-STR              PIC X(65).

REPORT SECTION.

RD  REPORT-LISTING
    PAGE LIMIT IS 60 LINES
    HEADING 1
    FIRST DETAIL 7.


01  TYPE IS PAGE HEADING.
    05 LINE NUMBER IS 1.
        10 COLUMN NUMBER IS 1       PIC X(12) SOURCE TODAYS-DATE-FORMATTED.
        10 COLUMN NUMBER IS 32      PIC X(16)
                VALUE IS 'Most Hits Report'.
        10 COLUMN NUMBER IS 70      PIC X(5) VALUE IS 'Page:'.
        10 COLUMN NUMBER IS 77      PIC ZZZ SOURCE PAGE-COUNTER.

    05 LINE NUMBER IS 3.
        10 COLUMN NUMBER IS 33      PIC X(20) SOURCE GROUP-TITLE.

    05 LINE NUMBER IS 5.
        10 COLUMN NUMBER IS 1       PIC X(2) VALUE 'No'.
        10 COLUMN NUMBER IS 6       PIC X(4) VALUE 'Hits'.
        10 COLUMN NUMBER IS 13      PIC X(5) VALUE 'Since'.
        10 COLUMN NUMBER IS 21      PIC X(8) VALUE 'Pct_Hits'.
        10 COLUMN NUMBER IS 32      PIC X(8) VALUE 'Ave_btwn'.

    05 LINE NUMBER IS 6.
        10 COLUMN NUMBER IS 1       PIC X(2) VALUE '--'.
        10 COLUMN NUMBER IS 6       PIC X(4) VALUE '----'.
        10 COLUMN NUMBER IS 13      PIC X(5) VALUE '-----'.
        10 COLUMN NUMBER IS 21      PIC X(8) VALUE '--------'.
        10 COLUMN NUMBER IS 32      PIC X(8) VALUE '--------'.

01  DETAIL-LINE TYPE IS DETAIL.
    05 LINE NUMBER IS PLUS 1.
        10 COLUMN NUMBER IS 1       PIC Z9 SOURCE ELM_NO IN SORTED-REC.
        10 COLUMN NUMBER IS 6       PIC ZZZ9 SOURCE HIT_COUNT IN SORTED-REC.
        10 COLUMN NUMBER IS 13      PIC ZZZ9 SOURCE SINCE_LAST IN SORTED-REC.
        10 COLUMN NUMBER IS 21      PIC Z9.999 SOURCE PCT_HITS IN SORTED-REC.
        10 COLUMN NUMBER IS 32      PIC ZZ9.999 SOURCE AVE_BTWN IN SORTED-REC.

PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    SORT SORT-FILE
        ON DESCENDING KEY HIT_COUNT IN SORT-REC
        USING DRAW-STATS
        GIVING SORTED-FILE.

    PERFORM B010-REPORT-DRAWING-NUMBERS.


    STRING SORT-FILE-NAME, ';*' DELIMITED BY SIZE INTO WORK-STR.
    CALL 'LIB$DELETE_FILE' USING BY DESCRIPTOR WORK-STR.

    STRING SORTED-FILE-NAME, ';*' DELIMITED BY SIZE INTO WORK-STR.
    CALL 'LIB$DELETE_FILE' USING BY DESCRIPTOR WORK-STR.

*
*   Set up for second part of report
*
    MOVE ' Mega Numbers' TO GROUP-TITLE.

    INITIATE REPORT-LISTING.

    SORT SORT-FILE
        ON DESCENDING KEY HIT_COUNT IN SORT-REC
        USING MEGA-STATS
        GIVING SORTED-FILE.


    PERFORM B010-REPORT-DRAWING-NUMBERS.


    STRING SORT-FILE-NAME, ';*' DELIMITED BY SIZE INTO WORK-STR.
    CALL 'LIB$DELETE_FILE' USING BY DESCRIPTOR WORK-STR.

    STRING SORTED-FILE-NAME, ';*' DELIMITED BY SIZE INTO WORK-STR.
    CALL 'LIB$DELETE_FILE' USING BY DESCRIPTOR WORK-STR.


    TERMINATE REPORT-LISTING.

    CLOSE RPT-FILE.

    CALL 'LIB$SPAWN' USING BY DESCRIPTOR 'EDIT/READ ZILL_MOST.RPT'.

    EXIT PROGRAM.

*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.
    CALL 'COB_FILL_IN_LOGICALS'.

    MOVE SPACES TO STATUS-VARIABLES.

    ACCEPT TODAYS-DATE FROM DATE YYYYMMDD.

    MOVE TODAY_YYYY TO FMT_YYYY.
    MOVE TODAY_DD   TO FMT_DD.
    MOVE TODAY_MM   TO FMT_MM.
    

    OPEN OUTPUT RPT-FILE.

    INITIATE REPORT-LISTING.

    MOVE 'Drawing Numbers' TO GROUP-TITLE.

*****
*   Paragraph to process the sorted selection file and 
*   create the portion of the report relating to drawing
*   numbers.
*****
B010-REPORT-DRAWING-NUMBERS.

    OPEN INPUT SORTED-FILE.

    
    READ SORTED-FILE
        AT END SET IT-IS-END-OF-FILE TO TRUE.

    PERFORM VARYING L-COUNT FROM 1 BY 1
      UNTIL IT-IS-END-OF-FILE OR L-COUNT > 10
        GENERATE DETAIL-LINE
        READ SORTED-FILE
            AT END SET IT-IS-END-OF-FILE TO TRUE
        END-READ
    END-PERFORM.

    CLOSE SORTED-FILE.


END PROGRAM COB_ZILL_MOST_REPORT_SUB.

