IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_SQLM_ZILL_MOST_REPORT_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-05-09.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT RPT-FILE ASSIGN TO 'ZILL_MOST.RPT'.

DATA DIVISION.

FILE SECTION.

FD  RPT-FILE
    LABEL RECORDS ARE OMITTED
    REPORT IS REPORT-LISTING.


**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 CONSTANTS.
       05 SORT-FILE-NAME        PIC X(7) VALUE 'TMP.SRT'.
       05 SORTED-FILE-NAME      PIC X(8) VALUE 'STAT.SRT'.

    01 STATUS-VARIABLES.
       05 M-STAT                PIC X(2).
       05 D-STAT                PIC X(2).
       05 EOF-FLAG              PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.

    01 STUFF.
       05 SQLCODE               PIC S9(8) COMP.
       05 LIB-RESULT            PIC S9(8) COMP.
       05 LIB-RESULT-DISPLAY    PIC 9(8).
       05 TODAYS-DATE.
          10 TODAY_YYYY         PIC X(4).
          10 TODAY_MM           PIC X(2).
          10 TODAY_DD           PIC X(2).

       05 TODAYS-DATE-FORMATTED.
          10 FMT_MM             PIC Z9.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_DD             PIC 99.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_YYYY           PIC 9(4).

       05 GROUP-TITLE           PIC X(20).

       05 L-COUNT               PIC S9(9) COMP.
       05 WORK-STR              PIC X(65).


    01 STATS-RECORD.
       05 ELM-NO         PIC S9(2) COMP.
       05 HIT-COUNT      PIC S9(9) COMP.
       05 LAST-DRAW-NO   PIC S9(9) COMP.
       05 SINCE-LAST     PIC S9(9) COMP.
       05 CURR-SEQ       PIC S9(9) COMP.
       05 LONGEST-SEQ    PIC S9(9) COMP.
       05 PCT-HITS       COMP-2.
       05 MAX-BTWN       PIC S9(9) COMP.
       05 AVE-BTWN       COMP-2.

    COPY 'SYS$LIBRARY:SQL_LITERALS.LIB'.

REPORT SECTION.

RD  REPORT-LISTING
    PAGE LIMIT IS 60 LINES
    HEADING 1
    FIRST DETAIL 7.

01  TYPE IS PAGE HEADING.
    05 LINE NUMBER IS 1.
        10 COLUMN NUMBER IS 1       PIC X(12) SOURCE TODAYS-DATE-FORMATTED.
        10 COLUMN NUMBER IS 32      PIC X(16)
                VALUE IS 'Most Hits Report'.
        10 COLUMN NUMBER IS 70      PIC X(5) VALUE IS 'Page:'.
        10 COLUMN NUMBER IS 77      PIC ZZZ SOURCE PAGE-COUNTER.

    05 LINE NUMBER IS 3.
        10 COLUMN NUMBER IS 33      PIC X(20) SOURCE GROUP-TITLE.

    05 LINE NUMBER IS 5.
        10 COLUMN NUMBER IS 1       PIC X(2) VALUE 'No'.
        10 COLUMN NUMBER IS 6       PIC X(4) VALUE 'Hits'.
        10 COLUMN NUMBER IS 13      PIC X(5) VALUE 'Since'.
        10 COLUMN NUMBER IS 21      PIC X(8) VALUE 'Pct_Hits'.
        10 COLUMN NUMBER IS 32      PIC X(8) VALUE 'Ave_btwn'.

    05 LINE NUMBER IS 6.
        10 COLUMN NUMBER IS 1       PIC X(2) VALUE '--'.
        10 COLUMN NUMBER IS 6       PIC X(4) VALUE '----'.
        10 COLUMN NUMBER IS 13      PIC X(5) VALUE '-----'.
        10 COLUMN NUMBER IS 21      PIC X(8) VALUE '--------'.
        10 COLUMN NUMBER IS 32      PIC X(8) VALUE '--------'.

01  DETAIL-LINE TYPE IS DETAIL.
    05 LINE NUMBER IS PLUS 1.
        10 COLUMN NUMBER IS 1       PIC Z9 SOURCE ELM-NO.
        10 COLUMN NUMBER IS 6       PIC ZZZ9 SOURCE HIT-COUNT.
        10 COLUMN NUMBER IS 13      PIC ZZZ9 SOURCE SINCE-LAST.
        10 COLUMN NUMBER IS 21      PIC Z9.999 SOURCE PCT-HITS.
        10 COLUMN NUMBER IS 32      PIC ZZ9.999 SOURCE AVE-BTWN.

PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    CALL 'OPEN_MOST_DRAW' USING BY REFERENCE SQLCODE.

    PERFORM B010-REPORT-DRAWING-NUMBERS.

    CALL 'CLOSE_MOST_DRAW' USING BY REFERENCE SQLCODE.

    CALL 'COMMIT_MEGA' USING BY REFERENCE SQLCODE.

*
*   Set up for second part of report
*
    MOVE ' Mega Numbers' TO GROUP-TITLE.

    INITIATE REPORT-LISTING.

    CALL 'OPEN_MOST_MEGA' USING BY REFERENCE SQLCODE.

    PERFORM B020-REPORT-MEGA-NUMBERS.


    TERMINATE REPORT-LISTING.

    CLOSE RPT-FILE.

    CALL 'CLOSE_MOST_MEGA' USING BY REFERENCE SQLCODE.

    CALL 'COMMIT_MEGA' USING BY REFERENCE SQLCODE.

    CALL 'LIB$SPAWN' USING BY DESCRIPTOR 'EDIT/READ ZILL_MOST.RPT'.

    EXIT PROGRAM.

*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.

    MOVE SPACES TO STATUS-VARIABLES.

    ACCEPT TODAYS-DATE FROM DATE YYYYMMDD.

    MOVE TODAY_YYYY TO FMT_YYYY.
    MOVE TODAY_DD   TO FMT_DD.
    MOVE TODAY_MM   TO FMT_MM.
    

    OPEN OUTPUT RPT-FILE.

    INITIATE REPORT-LISTING.

    MOVE 'Drawing Numbers' TO GROUP-TITLE.

*****
*   Paragraph to process the cursor
*   create the portion of the report relating to drawing
*   numbers.
*****
B010-REPORT-DRAWING-NUMBERS.

    MOVE SPACES TO EOF-FLAG.

    CALL 'FETCH_MOST_DRAW' USING BY REFERENCE SQLCODE, ELM-NO, HIT-COUNT, SINCE-LAST, PCT-HITS, AVE-BTWN.

    IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
        SET IT-IS-END-OF-FILE TO TRUE.

    PERFORM VARYING L-COUNT FROM 1 BY 1
      UNTIL IT-IS-END-OF-FILE OR L-COUNT > 10
        GENERATE DETAIL-LINE
        CALL 'FETCH_MOST_DRAW' USING BY REFERENCE SQLCODE, ELM-NO, HIT-COUNT, SINCE-LAST, PCT-HITS, AVE-BTWN
        END-CALL
        IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
            SET IT-IS-END-OF-FILE TO TRUE
        END-IF
    END-PERFORM.

*****
*   Paragraph to process the cursor
*   create the portion of the report relating to drawing
*   numbers.
*****
B020-REPORT-MEGA-NUMBERS.

    MOVE SPACES TO EOF-FLAG.

    CALL 'FETCH_MOST_MEGA' USING BY REFERENCE SQLCODE, ELM-NO, HIT-COUNT, SINCE-LAST, PCT-HITS, AVE-BTWN.

    IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
        SET IT-IS-END-OF-FILE TO TRUE.

    PERFORM VARYING L-COUNT FROM 1 BY 1
      UNTIL IT-IS-END-OF-FILE OR L-COUNT > 10
        GENERATE DETAIL-LINE
        CALL 'FETCH_MOST_MEGA' USING BY REFERENCE SQLCODE, ELM-NO, HIT-COUNT, SINCE-LAST, PCT-HITS, AVE-BTWN
        END-CALL
        IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
            SET IT-IS-END-OF-FILE TO TRUE
        END-IF
    END-PERFORM.

END PROGRAM COB_SQLM_ZILL_MOST_REPORT_SUB.

