IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_SQLM_DUMP_DRAW_DATA_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-05-08.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT RPT-FILE ASSIGN TO 'ZILL_DUMP.RPT'.

DATA DIVISION.

FILE SECTION.

FD  RPT-FILE
    LABEL RECORDS ARE OMITTED
    REPORT IS REPORT-LISTING.

**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 STATUS-VARIABLES.
       05 IN-STAT               PIC X(2).
       05 EOF-FLAG              PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.


    01 STUFF.
       05 SQLCODE               PIC S9(8) COMP.
       05 DRAWING-DATE-FORMATTED PIC X(12).

       05 TODAYS-DATE.
          10 TODAY_YYYY         PIC X(4).
          10 TODAY_MM           PIC X(2).
          10 TODAY_DD           PIC X(2).

       05 TODAYS-DATE-FORMATTED.
          10 FMT_MM             PIC Z9.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_DD             PIC 99.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_YYYY           PIC 9(4).


    01 DATE-STUFF.
       05 LIB-RESULT        PIC S9(8) COMP.
       05 LIB-RESULT-DISPLAY PIC 9(8).
       05 DATE-CONTEXT      PIC S9(8) COMP.
       05 DATE-COMPONENT    PIC S9(8) COMP.
       05 DATE-OUT-FMT-STR   PIC X(14) VALUE '|!Y4/!MN0/!D0|'.
       05 DATE-FLAGS        PIC S9(8) COMP VALUE 127.

    01 SQL-RECORD.
       05 DRAW-DT           PIC S9(18) COMP.
       05 NO-1              PIC 9(2) COMP.
       05 NO-2              PIC 9(2) COMP.
       05 NO-3              PIC 9(2) COMP.
       05 NO-4              PIC 9(2) COMP.
       05 NO-5              PIC 9(2) COMP.
       05 MEGA-NO           PIC 9(2) COMP.

    COPY 'SYS$LIBRARY:SQL_LITERALS.LIB'.


REPORT SECTION.

RD  REPORT-LISTING
    PAGE LIMIT IS 60 LINES
    HEADING 1
    FIRST DETAIL 6.


01  TYPE IS PAGE HEADING.
    05 LINE NUMBER IS 1.
        10 COLUMN NUMBER IS 1       PIC X(20) SOURCE TODAYS-DATE-FORMATTED.
        10 COLUMN NUMBER IS 30      PIC X(21)
                VALUE IS 'Drawing Number Report'.
        10 COLUMN NUMBER IS 70      PIC X(5) VALUE IS 'Page:'.
        10 COLUMN NUMBER IS 77      PIC ZZZ SOURCE PAGE-COUNTER.

    05 LINE NUMBER IS 3.
        10 COLUMN NUMBER IS 5       PIC X(7) VALUE IS 'Drawing'.
        10 COLUMN NUMBER IS 18      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 23      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 28      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 33      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 38      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 45      PIC X(4) VALUE IS 'Mega'.

    05 LINE NUMBER IS 4.
        10 COLUMN NUMBER IS 6       PIC X(4) VALUE IS 'Date'.
        10 COLUMN NUMBER IS 19      PIC X(1) VALUE IS '1'.
        10 COLUMN NUMBER IS 24      PIC X(1) VALUE IS '2'.
        10 COLUMN NUMBER IS 29      PIC X(1) VALUE IS '3'.
        10 COLUMN NUMBER IS 34      PIC X(1) VALUE IS '4'.
        10 COLUMN NUMBER IS 39      PIC X(1) VALUE IS '5'.
        10 COLUMN NUMBER IS 46      PIC X(2) VALUE IS 'No'.

    05 LINE NUMBER IS 5.
        10 COLUMN NUMBER IS 3       PIC X(12) VALUE IS '------------'.
        10 COLUMN NUMBER IS 18      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 23      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 28      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 33      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 38      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 44      PIC X(4) VALUE IS '----'.

01  DETAIL-LINE TYPE IS DETAIL.
    05 LINE NUMBER IS PLUS 1.
       10 COLUMN NUMBER IS 4        PIC X(10) SOURCE DRAWING-DATE-FORMATTED.
       10 COLUMN NUMBER IS 18       PIC Z9 SOURCE NO-1.
       10 COLUMN NUMBER IS 23       PIC Z9 SOURCE NO-2.
       10 COLUMN NUMBER IS 28       PIC Z9 SOURCE NO-3.
       10 COLUMN NUMBER IS 33       PIC Z9 SOURCE NO-4.
       10 COLUMN NUMBER IS 38       PIC Z9 SOURCE NO-5.
       10 COLUMN NUMBER IS 46       PIC Z9 SOURCE MEGA-NO.

PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    PERFORM B010-READ-DRAWINGS
        UNTIL IT-IS-END-OF-FILE.

    TERMINATE REPORT-LISTING.

    CLOSE RPT-FILE.

    CALL 'CLOSE_ALL_DRAW' USING BY REFERENCE SQLCODE.

    CALL 'COMMIT_MEGA' USING BY REFERENCE SQLCODE.

    CALL 'LIB$FREE_DATE_TIME_CONTEXT' USING BY REFERENCE DATE-CONTEXT
                                      GIVING LIB-RESULT.

    CALL 'LIB$SPAWN' USING BY DESCRIPTOR 'EDIT/READ ZILL_DUMP.RPT'.

    EXIT PROGRAM.

*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.
    MOVE SPACES TO STATUS-VARIABLES.

    ACCEPT TODAYS-DATE FROM DATE YYYYMMDD.

    MOVE TODAY_YYYY TO FMT_YYYY.
    MOVE TODAY_DD   TO FMT_DD.
    MOVE TODAY_MM   TO FMT_MM.

    MOVE ZERO TO DATE-CONTEXT.
    MOVE 1 TO DATE-COMPONENT.
    CALL 'LIB$INIT_DATE_TIME_CONTEXT' USING BY REFERENCE DATE-CONTEXT, DATE-COMPONENT,
                                            BY DESCRIPTOR DATE-OUT-FMT-STR
                                      GIVING LIB-RESULT.

    OPEN OUTPUT RPT-FILE.

    INITIATE REPORT-LISTING.

    CALL 'OPEN_ALL_DRAW' USING BY REFERENCE SQLCODE.

*****
*   Paragraph to read each record in the drawing file
*   and update the associated stats records.
*****
B010-READ-DRAWINGS.
    CALL 'FETCH_ALL_DRAW' USING BY REFERENCE SQLCODE, DRAW-DT, NO-1, NO-2, NO-3, NO-4, NO-5, MEGA-NO.

    IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
        SET IT-IS-END-OF-FILE TO TRUE
    ELSE
        CALL 'LIB$FORMAT_DATE_TIME' USING BY DESCRIPTOR DRAWING-DATE-FORMATTED,
                                          BY REFERENCE DRAW-DT, DATE-CONTEXT, OMITTED, OMITTED
                                    GIVING LIB-RESULT
        GENERATE DETAIL-LINE.


END PROGRAM COB_SQLM_DUMP_DRAW_DATA_SUB.

