IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_SQLM_CREATE_STATS_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-05-08.
DATE-COMPILED.  TODAY.

***********
*   Be certain you compile with /FLOAT=G_FLOAT so CDD can 
*   correctly generate record definitions.
***********

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

DATA DIVISION.

FILE SECTION.

**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 CONSTANTS.
       05 ELM-COUNT             PIC S9(9) COMP VALUE IS 52.


    01 STATUS-VARIABLES.
       05 IN-STAT               PIC X(2).
       05 M-STAT                PIC X(2).
       05 D-STAT                PIC X(2).
       05 EOF-FLAG          PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.

    01 DATE-STUFF.
       05 SQLCODE           PIC S9(8) COMP.
       05 LIB-RESULT        PIC S9(8) COMP.
       05 LIB-RESULT-DISPLAY PIC 9(8).
       05 DATE-CONTEXT      PIC S9(8) COMP.
       05 DATE-COMPONENT    PIC S9(8) COMP.
       05 DATE-IN-FMT-STR   PIC X(26) VALUE '|!Y4!MN0!D0 !H04!M0!S0!C2|'.
       05 DATE-FLAGS        PIC S9(8) COMP VALUE 127.

    01 SQL-RECORD.
       05 DATE-QUAD         PIC S9(18) COMP.
       05 NO-1              PIC 9(2) COMP.
       05 NO-2              PIC 9(2) COMP.
       05 NO-3              PIC 9(2) COMP.
       05 NO-4              PIC 9(2) COMP.
       05 NO-5              PIC 9(2) COMP.
       05 MEGA-NO           PIC 9(2) COMP.

*****
*   One of my biggest pet peeves with the copy from dictionary
*   verb is the lack of a "starting level" clause.
*   When pulling entries in from a dictionary you cannot tell
*   the dictionary what starting level number to use.
*****
    01 WORKING-VARIABLES.
       05 L-SUB             PIC S9(9) COMP.
       05 L-SUB-TINY        PIC S9(2) COMP.
       05 L-DRAW-NO         PIC S9(9) COMP.
       05 L-MISSED          PIC S9(9) COMP.
       05 L-SINCE           PIC S9(9) COMP.
       05 L-DRAW-NO-DISP    PIC Z(5).
       05 FLT-1             COMP-2.
       05 FLT-2             COMP-2.


    01 TABLES.
       05 DSTATS_TBL            OCCURS 52 TIMES.
          10 HIT-COUNT      PIC S9(9) COMP.
          10 LAST-DRAW-NO   PIC S9(9) COMP.
          10 SINCE-LAST     PIC S9(9) COMP.
          10 CURR-SEQ       PIC S9(9) COMP.
          10 LONGEST-SEQ    PIC S9(9) COMP.
          10 PCT-HITS       COMP-2.
          10 MAX-BTWN       PIC S9(9) COMP.
          10 AVE-BTWN       COMP-2.

       05 MSTATS_TBL            OCCURS 52 TIMES.
          10 HIT-COUNT      PIC S9(9) COMP.
          10 LAST-DRAW-NO   PIC S9(9) COMP.
          10 SINCE-LAST     PIC S9(9) COMP.
          10 CURR-SEQ       PIC S9(9) COMP.
          10 LONGEST-SEQ    PIC S9(9) COMP.
          10 PCT-HITS       COMP-2.
          10 MAX-BTWN       PIC S9(9) COMP.
          10 AVE-BTWN       COMP-2.


    COPY 'SYS$LIBRARY:SQL_LITERALS.LIB'.

PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    PERFORM B010-READ-DRAWINGS
        VARYING L-DRAW-NO FROM 1 BY 1
        UNTIL IT-IS-END-OF-FILE.

*****
*       Note that we have to do a subtraction here.
*       COBOL doesn't turn on end of file until you try to read
*       past the end of file.  That gets us 1 extra going into 
*       the paragraph.  Since the VARYING logic occurs prior to the 
*       UNTIL logic test, we are off by 2.
*****
    SUBTRACT 2 FROM L-DRAW-NO.

    MOVE L-DRAW-NO TO L-DRAW-NO-DISP.
    DISPLAY L-DRAW-NO-DISP ' records processed'.

    PERFORM B020-GENERATE-FINAL-STATS.

    PERFORM B030-WRITE-STATS.

    CALL 'CLOSE_ALL_DRAW' USING BY REFERENCE SQLCODE.

    CALL 'COMMIT_MEGA' USING BY REFERENCE SQLCODE.

    EXIT PROGRAM.

*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.
    MOVE SPACES TO STATUS-VARIABLES.

    PERFORM C002-ZERO-TABLES
        VARYING L-SUB FROM 1 BY 1 UNTIL L-SUB > ELM-COUNT.

    CALL 'DELETE_ALL_MEGA_STATS' USING BY REFERENCE SQLCODE.
    CALL 'COMMIT_MEGA' USING BY REFERENCE SQLCODE.
    CALL 'DELETE_ALL_DRAW_STATS' USING BY REFERENCE SQLCODE.
    CALL 'COMMIT_MEGA' USING BY REFERENCE SQLCODE.
    CALL 'OPEN_ALL_DRAW' USING BY REFERENCE SQLCODE.

*****
*   Paragraph to read each record in the drawing file
*   and update the associated stats records.
*****
B010-READ-DRAWINGS.
    CALL 'FETCH_ALL_DRAW' USING BY REFERENCE SQLCODE, DATE-QUAD, NO-1, NO-2, NO-3, NO-4, NO-5, MEGA-NO.

    IF SQLCODE IS EQUAL TO SQLCODE_EOS
        SET IT-IS-END-OF-FILE TO TRUE
    ELSE
        IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
            MOVE SQLCODE TO LIB-RESULT-DISPLAY
            DISPLAY 'RESULT OF FETCHING CURSOR ', LIB-RESULT-DISPLAY
        ELSE
            PERFORM C010-UPDATE-RECORD-STATS

            IF FUNCTION MOD( L-DRAW-NO, 100) IS EQUAL TO 0
                MOVE L-DRAW-NO TO L-DRAW-NO-DISP
                DISPLAY L-DRAW-NO-DISP ' records processed'.

*****
*   Paragraph to generate final stats on all of the records
*****
B020-GENERATE-FINAL-STATS.

    PERFORM C020-FINAL-DSTATS
        VARYING L-SUB FROM 1 BY 1
        UNTIL L-SUB > ELM-COUNT.

    PERFORM C030-FINAL-MSTATS
        VARYING L-SUB FROM 1 BY 1
        UNTIL L-SUB > ELM-COUNT.

*****
*   Paragraph to write final stats records to disk
*****
B030-WRITE-STATS.
    PERFORM C040-WRITE-DSTATS
        VARYING L-SUB FROM 1 BY 1
        UNTIL L-SUB > ELM-COUNT.

    PERFORM C050-WRITE-MSTATS
        VARYING L-SUB FROM 1 BY 1
        UNTIL L-SUB > ELM-COUNT.

*****
*   Paragraph to zero out table elements
*****
C002-ZERO-TABLES.

    COMPUTE HIT-COUNT IN DSTATS-TBL(L-SUB)    = 0.
    COMPUTE LAST-DRAW-NO IN DSTATS-TBL(L-SUB) = 0.
    COMPUTE SINCE-LAST IN DSTATS-TBL( L-SUB)  = 0.
    COMPUTE CURR-SEQ IN DSTATS-TBL( L-SUB)    = 0.
    COMPUTE LONGEST-SEQ IN DSTATS-TBL( L-SUB) = 0.
    COMPUTE PCT-HITS IN DSTATS-TBL( L-SUB)    = 0.
    COMPUTE MAX-BTWN IN DSTATS-TBL( L-SUB)    = 0.
    COMPUTE AVE-BTWN IN DSTATS-TBL( L-SUB)    = 0.

    COMPUTE HIT-COUNT IN MSTATS-TBL(L-SUB)    = 0.
    COMPUTE LAST-DRAW-NO IN MSTATS-TBL(L-SUB) = 0.
    COMPUTE SINCE-LAST IN MSTATS-TBL( L-SUB)  = 0.
    COMPUTE CURR-SEQ IN MSTATS-TBL( L-SUB)    = 0.
    COMPUTE LONGEST-SEQ IN MSTATS-TBL( L-SUB) = 0.
    COMPUTE PCT-HITS IN MSTATS-TBL( L-SUB)    = 0.
    COMPUTE MAX-BTWN IN MSTATS-TBL( L-SUB)    = 0.
    COMPUTE AVE-BTWN IN MSTATS-TBL( L-SUB)    = 0.


*****
*   Paragraph to update stats records for individual drawing numbers
*****
C010-UPDATE-RECORD-STATS.

    MOVE NO-1 TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.

    MOVE NO-2 TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.


    MOVE NO-3 TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.


    MOVE NO-4 TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.


    MOVE NO-5 TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.

    MOVE MEGA-NO TO L-SUB.

    PERFORM D002-UPDATE-MEGA-STAT.

*****
*   Paragraph to read and update each record in the DSTATS file.
*****
C020-FINAL-DSTATS.

    COMPUTE FLT-1 = HIT-COUNT IN DSTATS-TBL(L-SUB).
    COMPUTE FLT-2 = L-DRAW-NO.

    IF FLT-2 < 1
        COMPUTE FLT-2 = 1.

    COMPUTE PCT-HITS IN DSTATS-TBL(L-SUB) = FLT-1 / FLT-2.

    COMPUTE L-MISSED = L-DRAW-NO - HIT-COUNT IN DSTATS-TBL( L-SUB).

    COMPUTE FLT-1 = L-MISSED.
    COMPUTE FLT-2 = HIT-COUNT IN DSTATS-TBL( L-SUB).
    IF FLT-2 < 1
        COMPUTE FLT-2 = 1.

    COMPUTE AVE-BTWN IN DSTATS-TBL(L-SUB) = FLT-1 / FLT-2.

    COMPUTE SINCE-LAST IN DSTATS-TBL( L-SUB) = 
                L-DRAW-NO - LAST-DRAW-NO IN DSTATS-TBL(L-SUB).
*****
*   Paragraph to read and update each record in the MSTATS file.
*****
C030-FINAL-MSTATS.
    COMPUTE FLT-1 = HIT-COUNT IN MSTATS-TBL(L-SUB).
    COMPUTE FLT-2 = L-DRAW-NO.
    IF FLT-2 < 1
        COMPUTE FLT-2 = 1.

    COMPUTE PCT-HITS IN MSTATS-TBL(L-SUB) = FLT-1 / FLT-2.

    COMPUTE L-MISSED = L-DRAW-NO - HIT-COUNT IN MSTATS-TBL( L-SUB).

    COMPUTE FLT-1 = L-MISSED.
    COMPUTE FLT-2 = HIT-COUNT IN MSTATS-TBL( L-SUB).
    IF FLT-2 < 1
        COMPUTE FLT-2 = 1.

    COMPUTE AVE-BTWN IN MSTATS-TBL(L-SUB) = FLT-1 / FLT-2.

    COMPUTE SINCE-LAST IN MSTATS-TBL( L-SUB) = 
                L-DRAW-NO - LAST-DRAW-NO IN MSTATS-TBL(L-SUB).
*****
*  Paragraph to write a dstats array element to indexed file
*****
C040-WRITE-DSTATS.
    MOVE L-SUB TO L-SUB-TINY.
    CALL 'INSERT_DRAW_STATS' USING BY REFERENCE SQLCODE, L-SUB-TINY, 
                HIT-COUNT IN DSTATS_TBL( L-SUB),
                LAST-DRAW-NO IN DSTATS_TBL( L-SUB),
                SINCE-LAST IN DSTATS_TBL( L-SUB),
                CURR-SEQ IN DSTATS_TBL( L-SUB),
                LONGEST-SEQ IN DSTATS_TBL( L-SUB),
                PCT-HITS IN DSTATS_TBL( L-SUB),
                MAX-BTWN IN DSTATS_TBL( L-SUB),
                AVE-BTWN IN DSTATS_TBL( L-SUB).

    IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
        MOVE SQLCODE TO LIB-RESULT-DISPLAY
        DISPLAY 'RESULT OF INSERTING DRAWING STAT ', LIB-RESULT-DISPLAY.



*****
*
*****
C050-WRITE-MSTATS.
    MOVE L-SUB TO L-SUB-TINY.
    CALL 'INSERT_MEGA_STATS' USING BY REFERENCE SQLCODE, L-SUB-TINY, 
                HIT-COUNT IN MSTATS_TBL( L-SUB),
                LAST-DRAW-NO IN MSTATS_TBL( L-SUB),
                SINCE-LAST IN MSTATS_TBL( L-SUB),
                CURR-SEQ IN MSTATS_TBL( L-SUB),
                LONGEST-SEQ IN MSTATS_TBL( L-SUB),
                PCT-HITS IN MSTATS_TBL( L-SUB),
                MAX-BTWN IN MSTATS_TBL( L-SUB),
                AVE-BTWN IN MSTATS_TBL( L-SUB).

    IF SQLCODE IS NOT EQUAL TO SQLCODE_SUCCESS
        MOVE SQLCODE TO LIB-RESULT-DISPLAY
        DISPLAY 'RESULT OF INSERTING MEGA STAT ', LIB-RESULT-DISPLAY.

*****
*   Paragraph to update individual drawing stat records.
*****
D001-UPDATE-DRAW-STAT.

    SUBTRACT LAST-DRAW-NO IN DSTATS-TBL(L-SUB) FROM L-DRAW-NO
        GIVING L-SINCE.

    IF L-SINCE IS EQUAL TO 1
        ADD 1 TO CURR-SEQ IN DSTATS-TBL(L-SUB)
        IF CURR-SEQ IN DSTATS-TBL(L-SUB) > LONGEST-SEQ IN DSTATS-TBL(L-SUB)
            MOVE CURR-SEQ IN DSTATS-TBL(L-SUB) 
                TO LONGEST-SEQ IN DSTATS-TBL(L-SUB)
        END-IF
    ELSE
        COMPUTE CURR-SEQ IN DSTATS-TBL(L-SUB) = 0
        IF L-SINCE > MAX-BTWN IN DSTATS-TBL(L-SUB)
            COMPUTE MAX-BTWN IN DSTATS-TBL(L-SUB) = L-SINCE
        END-IF

    END-IF.

    ADD 1 TO HIT-COUNT IN DSTATS-TBL(L-SUB).
    COMPUTE LAST-DRAW-NO IN DSTATS-TBL(L-SUB) = L-DRAW-NO.
    COMPUTE SINCE-LAST IN DSTATS-TBL(L-SUB) = L-SINCE.

*****
*   Paragraph to update the mega stats from the drawing record
*****
D002-UPDATE-MEGA-STAT.
    SUBTRACT LAST-DRAW-NO IN MSTATS-TBL(L-SUB) FROM L-DRAW-NO
        GIVING L-SINCE.

    IF L-SINCE IS EQUAL TO 1
        ADD 1 TO CURR-SEQ IN MSTATS-TBL(L-SUB)
        IF CURR-SEQ IN MSTATS-TBL(L-SUB) > LONGEST-SEQ IN MSTATS-TBL(L-SUB)
            MOVE CURR-SEQ IN MSTATS-TBL(L-SUB) 
                TO LONGEST-SEQ IN MSTATS-TBL(L-SUB)
        END-IF
    ELSE
        COMPUTE CURR-SEQ IN MSTATS-TBL(L-SUB) = 0
        IF L-SINCE > MAX-BTWN IN MSTATS-TBL(L-SUB)
            COMPUTE MAX-BTWN IN MSTATS-TBL(L-SUB) = L-SINCE
        END-IF

    END-IF.

    ADD 1 TO HIT-COUNT IN MSTATS-TBL(L-SUB)
    COMPUTE LAST-DRAW-NO IN MSTATS-TBL(L-SUB) = L-DRAW-NO.
    COMPUTE SINCE-LAST IN MSTATS-TBL(L-SUB) = L-SINCE.

END PROGRAM COB_SQLM_CREATE_STATS_SUB.
