IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_DUMP_DRAW_DATA_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-02-08.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT DRAW-IDX
        ASSIGN TO 'MY_MEGA_FILE'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS SEQUENTIAL
        RECORD KEY IS DRAW_DT IN DRAWING_RECORD ASCENDING
        LOCK MODE IS AUTOMATIC
        FILE STATUS IS IN-STAT.

    SELECT RPT-FILE ASSIGN TO 'ZILL_DUMP.RPT'.

DATA DIVISION.

FILE SECTION.

FD  DRAW-IDX
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.DRAWING_RECORD' FROM DICTIONARY.

FD  RPT-FILE
    LABEL RECORDS ARE OMITTED
    REPORT IS REPORT-LISTING.

**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 STATUS-VARIABLES.
       05 IN-STAT               PIC X(2).
       05 EOF-FLAG              PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.

    01 STUFF.
       05 DRAWING-DATE.
          10 D_YYYY             PIC X(4).
          10 D_MM               PIC X(2).
          10 D_DD               PIC X(2).

       05 DRAWING-DATE-FORMATTED.
          10 MM                 PIC Z9.
          10 FILLER             PIC X VALUE '/'.
          10 DD                 PIC 99.
          10 FILLER             PIC X VALUE '/'.
          10 YYYY               PIC 9(4).

       05 TODAYS-DATE.
          10 TODAY_YYYY         PIC X(4).
          10 TODAY_MM           PIC X(2).
          10 TODAY_DD           PIC X(2).

       05 TODAYS-DATE-FORMATTED.
          10 FMT_MM             PIC Z9.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_DD             PIC 99.
          10 FILLER             PIC X VALUE '/'.
          10 FMT_YYYY           PIC 9(4).

REPORT SECTION.

RD  REPORT-LISTING
    PAGE LIMIT IS 60 LINES
    HEADING 1
    FIRST DETAIL 6.


01  TYPE IS PAGE HEADING.
    05 LINE NUMBER IS 1.
        10 COLUMN NUMBER IS 1       PIC X(20) SOURCE TODAYS-DATE-FORMATTED.
        10 COLUMN NUMBER IS 30      PIC X(21)
                VALUE IS 'Drawing Number Report'.
        10 COLUMN NUMBER IS 70      PIC X(5) VALUE IS 'Page:'.
        10 COLUMN NUMBER IS 77      PIC ZZZ SOURCE PAGE-COUNTER.

    05 LINE NUMBER IS 3.
        10 COLUMN NUMBER IS 5       PIC X(7) VALUE IS 'Drawing'.
        10 COLUMN NUMBER IS 18      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 23      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 28      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 33      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 38      PIC X(2) VALUE IS 'No'.
        10 COLUMN NUMBER IS 45      PIC X(4) VALUE IS 'Mega'.

    05 LINE NUMBER IS 4.
        10 COLUMN NUMBER IS 6       PIC X(4) VALUE IS 'Date'.
        10 COLUMN NUMBER IS 19      PIC X(1) VALUE IS '1'.
        10 COLUMN NUMBER IS 24      PIC X(1) VALUE IS '2'.
        10 COLUMN NUMBER IS 29      PIC X(1) VALUE IS '3'.
        10 COLUMN NUMBER IS 34      PIC X(1) VALUE IS '4'.
        10 COLUMN NUMBER IS 39      PIC X(1) VALUE IS '5'.
        10 COLUMN NUMBER IS 46      PIC X(2) VALUE IS 'No'.

    05 LINE NUMBER IS 5.
        10 COLUMN NUMBER IS 3       PIC X(12) VALUE IS '------------'.
        10 COLUMN NUMBER IS 18      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 23      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 28      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 33      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 38      PIC X(2) VALUE IS '--'.
        10 COLUMN NUMBER IS 44      PIC X(4) VALUE IS '----'.

01  DETAIL-LINE TYPE IS DETAIL.
    05 LINE NUMBER IS PLUS 1.
       10 COLUMN NUMBER IS 4        PIC X(10) SOURCE DRAWING-DATE-FORMATTED.
       10 COLUMN NUMBER IS 18       PIC Z9 SOURCE NO_1.
       10 COLUMN NUMBER IS 23       PIC Z9 SOURCE NO_2.
       10 COLUMN NUMBER IS 28       PIC Z9 SOURCE NO_3.
       10 COLUMN NUMBER IS 33       PIC Z9 SOURCE NO_4.
       10 COLUMN NUMBER IS 38       PIC Z9 SOURCE NO_5.
       10 COLUMN NUMBER IS 46       PIC Z9 SOURCE MEGA_NO.

PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    PERFORM B010-READ-DRAWINGS
        UNTIL IT-IS-END-OF-FILE.

    CLOSE DRAW-IDX.

    TERMINATE REPORT-LISTING.

    CLOSE RPT-FILE.

    CALL 'LIB$SPAWN' USING BY DESCRIPTOR 'EDIT/READ ZILL_DUMP.RPT'.

    EXIT PROGRAM.

*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.
    CALL 'COB_FILL_IN_LOGICALS'.

    MOVE SPACES TO STATUS-VARIABLES.

    ACCEPT TODAYS-DATE FROM DATE YYYYMMDD.

    MOVE TODAY_YYYY TO FMT_YYYY.
    MOVE TODAY_DD   TO FMT_DD.
    MOVE TODAY_MM   TO FMT_MM.

    OPEN INPUT  DRAW-IDX.
    OPEN OUTPUT RPT-FILE.

    INITIATE REPORT-LISTING.


*****
*   Paragraph to read each record in the drawing file
*   and update the associated stats records.
*****
B010-READ-DRAWINGS.
    READ DRAW-IDX NEXT
        AT END SET IT-IS-END-OF-FILE TO TRUE.

    IF IT-IS-END-OF-FILE
        NEXT SENTENCE
    ELSE
        MOVE DRAW_DT TO DRAWING-DATE
        MOVE D_YYYY TO YYYY
        MOVE D_MM TO MM
        MOVE D_DD TO DD
        GENERATE DETAIL-LINE.


END PROGRAM COB_DUMP_DRAW_DATA_SUB.

