/*  C_ZILL_IMPORT_SUB.C
 *
 *  Subroutine to import comma seperated value text file
 *  into the Mega example application.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>
#include <lib$routines>

/*
 *  Our headers
 */

#pragma member_alignment save
#pragma nomember_alignment
#pragma dictionary "cdd_records.drawing_record"
#pragma member_alignment restore

#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
extern const char *MEGA_FILE_NAME;
extern const char *DEFAULT_NAME;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void c_fill_in_logicals( void);

int  open_mega_idx( struct drawing_record *m_z, 
                    struct FAB *m_fab, struct RAB *m_rab,
                    struct XABKEY *m_xab,
                    int access);

void parse_csv_line( char *input_line_str, struct drawing_record *m_z);

FILE    *prompt_and_open_csv( void);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_zill_import_sub( )
{
    int                     l_x, l_count;
    char                    line_in[255], command_str[255];
    FILE                    *in_file;

    $DESCRIPTOR( command_str_desc, command_str);

    struct  drawing_record  m_z;
    struct  FAB             mega_fab;
    struct  RAB             mega_rab;
    struct  XABKEY          mega_xab;


    l_count = 0;


    //
    //  obtain a value input file
    //
    in_file = NULL;
    do
    {
        in_file = prompt_and_open_csv();
    }  while ( in_file == NULL);


    //
    //  Create a new indexed file
    //
    strcpy( command_str, "CREATE/FDL=MEGA_DAT:DRAWING_DATA.FDL MY_MEGA_FILE");
    LENGTH( command_str_desc) = strlen( command_str);
    l_x = lib$spawn( &command_str_desc);

    l_x = open_mega_idx( &m_z, &mega_fab, 
                         &mega_rab, &mega_xab, FAB$M_PUT);

    if ( !(l_x & 1))
    {
        puts( "Unable to open indexed file for output");
        return;
    }  /* end test for failed open */


    printf( "Size of drawing record %d\n", sizeof( struct drawing_record));

    //
    //  Read every input record and create an output record
    //
    l_count = 0;
    do
    {
        //  clear out the working areas before any IO occurs.
        //
        memset( line_in, '\0', sizeof( line_in));
        memset( &m_z, '\0', sizeof( m_z));

        fgets( line_in, sizeof( line_in) -1, in_file);
        if ( !feof( in_file))
        {
            l_count++;

            parse_csv_line( line_in, &m_z);
            l_x = sys$put( &mega_rab);

            if ( !(l_x & 1))
            {
                printf( "Error %d writing record %d to indexed file\n",
                        l_x, l_count);
            }

            if ( (l_count % 100) == 0)
            {
                printf( "Processed %d Records\n", l_count);

            }  /* end status message test */
        }  /* end test for successful read */

    } while ( !feof( in_file));

    printf( "Processed %d Records\n", l_count);

    l_x = sys$close( &mega_fab);

    fclose( in_file);


}  /* end c_zill_import_sub */

/*;;;;;
 *      Function to obtain a file name from the user and
 *      open the file for input.
 *;;;;;
 */
FILE *prompt_and_open_csv()
{
    int     l_x;
    char    file_name_str[255];
    FILE    *the_file;

    memset( file_name_str, '\0', sizeof( file_name_str));

    printf( "\n\nInput file name: ");
    scanf( "%s", file_name_str);

    the_file = fopen( file_name_str, "r");

    if ( the_file != NULL)
    {
        l_x = ferror( the_file);
        if (l_x != 0)
        {
            printf( "Error %d opening input file\n", l_x);
        }
    }  /* end test for succesful open */

    return the_file;

}  /* end prompt_and_open_csv function */

/*;;;;;
 *      Subroutine to parse the input record
 *      filling in the output record buffer.
 *;;;;;
 */
void parse_csv_line( char *input_line_str, struct drawing_record *m_z)
{
    char    *tmp, scratch_str[255], *tmp2;
    int	    i_mm, i_dd, i_yyyy, i_num;


    //
    //	First field is the date in mm/dd/yyyy format with zero suppression
    //	for the date we will use the safe method of copying the characters we want
    //	into a scratch string then manipulating that.  Later we will work with the values
    //	in place.
    //
    tmp = input_line_str;
    tmp2 = strchr( tmp, '/');

    memset( scratch_str, '\0', sizeof( scratch_str));		// nuke the destination string
    memcpy( scratch_str, tmp, tmp2-tmp);			// copy the month digits
    i_mm = atoi( scratch_str);					// obtain the month in numeric form

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, '/');
    memset( scratch_str, '\0', sizeof( scratch_str));
    memcpy( scratch_str, tmp, tmp2-tmp);			// copy the day digits
    i_dd = atoi( scratch_str);					// obtain the day in numeric form

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    memset( scratch_str, '\0', sizeof( scratch_str));
    memcpy( scratch_str, tmp, tmp2-tmp);			// copy the year digits
    i_yyyy = atoi( scratch_str);				// obtain the year in numeric format

    memset( scratch_str, '\0', sizeof( scratch_str));
    sprintf( scratch_str, "%4d%02d%02d", i_yyyy, i_mm, i_dd);

    memcpy( m_z->draw_dt, scratch_str, sizeof( m_z->draw_dt));

    //
    //	    Now obtain the drawing numbers
    //	    This time, instead of using the scratch_str as a work area we
    //	    will insert null bytes and work with the string in place.
    //
    tmp = tmp2 + 1;						// skip the comma
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    m_z->no_1 = atoi( tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    m_z->no_2 = atoi( tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    m_z->no_3 = atoi( tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    m_z->no_4 = atoi( tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    m_z->no_5 = atoi( tmp);

    //  there is no trailing comma behind the mega number
    //
    tmp = tmp2 + 1;
    m_z->mega_no = atoi( tmp);


}  /* end parse_csv_line subroutine */

