/*  C_ZILL_ENTRY_SUB.C
 *
 *  Subroutine to allow entry and maintenance
 *  in the Mega example application.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>
#include <lib$routines>
#include <fdvdef>
#include <fms_prototypes>

/*
 *  Our headers
 */
// turn off warnings about $ characters
#pragma message disable (DOLLARID)          


#pragma member_alignment save
#pragma nomember_alignment
#pragma dictionary "cdd_records.drawing_record"
#pragma member_alignment restore

#define LENGTH(descriptor)      descriptor.dsc$w_length
#define POINTER(descriptor)     descriptor.dsc$a_pointer


struct  entry_screen_struct
{
    char    draw_dt[8];
    char    no_1[2];
    char    no_2[2];
    char    no_3[2];
    char    no_4[2];
    char    no_5[2];
    char    mega_no[2];
    char    msg_txt[60];
};



enum entry_actions { ACTION_NONE, ACTION_ADD, ACTION_FIND,
                    ACTION_DELETE, ACTION_UPDATE, ACTION_EXIT};

enum entry_modes {ADD_MODE, DELETE_MODE, FIND_MODE, INVALID_MODE};

/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
extern const int L_ZERO;


/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void add_mega_record( struct entry_screen_struct *s_rec, struct RAB *m_rab,
                      struct drawing_record *m_z);

void c_fill_in_logicals( void);

void check_entry_terminator( int terminator, enum entry_actions *a);

void display_entry_error_msg( struct entry_screen_struct *s_rec);

void entry_user_input( enum entry_actions *e_action, enum entry_modes *e_mode, 
                       struct entry_screen_struct *screen_rec,
                       struct dsc$descriptor_s *screen_rec_desc,
                       struct drawing_record *m_z,
                       struct RAB *m_rab);

void find_mega_record( struct entry_screen_struct *s_rec,
                       struct RAB *m_rab,
                       struct drawing_record *m_z);

int  open_mega_idx( struct drawing_record *m_z, 
                    struct FAB *m_fab, struct RAB *m_rab,
                    struct XABKEY *m_xab,
                    int access);

void retrieve_entry_data( struct entry_screen_struct *s_rec,
                          struct drawing_record *m_z);

void update_mega_record( struct entry_screen_struct *s_rec,
                         struct RAB *m_rab,
                         struct drawing_record *m_z);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */


void c_zill_entry_sub( int *fms_status, int *rms_status, 
                        int *tca_array, int *workspace_array)
{
    int                     l_x, l_y;
    char                    line_in[255], command_str[255];
    FILE                    *in_file;
    enum entry_actions      e_action;
    enum entry_modes        e_mode;

    $DESCRIPTOR( command_str_desc, command_str);

    struct  drawing_record  m_z;
    struct  FAB             mega_fab;
    struct  RAB             mega_rab;
    struct  XABKEY          mega_xab;

    struct  entry_screen_struct    screen_rec;

    $DESCRIPTOR( form_name_desc, "ZILL_ENTRY2");

    struct dsc$descriptor_s      screen_rec_desc;

    //
    //  Best to build this one by hand since it technically isn't a string.
    //
    screen_rec_desc.dsc$w_length        = sizeof( screen_rec);
    screen_rec_desc.dsc$b_dtype         = DSC$K_DTYPE_T;
    screen_rec_desc.dsc$b_class         = DSC$K_CLASS_S;
    screen_rec_desc.dsc$a_pointer       = (char *)&screen_rec;



    //
    //  attach to the mega file
    //
    l_x = open_mega_idx( &m_z, &mega_fab, 
                         &mega_rab, &mega_xab, FAB$M_UPD | FAB$M_DEL | FAB$M_PUT);

    if ( !(l_x & 1))
    {
        puts( "Unable to open indexed file for output");
        return;
    }  /* end test for failed open */

    mega_rab.rab$b_ksz = sizeof( m_z.draw_dt);

    //
    //  Set the keypad mode and load our form
    //
    l_y = L_ZERO;
    l_x = fdv$spada( &l_y);

    l_x = fdv$cdisp( &form_name_desc);


    memset( &screen_rec, ' ', sizeof( screen_rec));

    do
    {
        entry_user_input( &e_action, &e_mode, 
                          &screen_rec, &screen_rec_desc, &m_z, &mega_rab);

    } while ( e_action != ACTION_EXIT);

    l_x = sys$close( &mega_fab);

    return;

}  /* end c_zill_entry_sub */

/*;;;;;
 *  Subroutine to handle input from the user
 *;;;;;
 */
void entry_user_input( enum entry_actions *e_action, enum entry_modes *e_mode, 
                       struct entry_screen_struct *screen_rec,
                       struct dsc$descriptor_s *screen_rec_desc,
                       struct drawing_record *m_z,
                       struct RAB *m_rab)
{

    int         l_x, l_terminator;




    l_terminator = 0;

    l_x = fdv$getal( screen_rec_desc, &l_terminator);

    check_entry_terminator( l_terminator, e_action);

    switch( *e_action)
    {
        case ACTION_NONE:       break;

        case ACTION_ADD:        *e_mode = ADD_MODE;
                                add_mega_record( screen_rec, m_rab, m_z);
                                l_x = fdv$putal( screen_rec_desc);
                                break;

        case ACTION_FIND:       *e_mode = FIND_MODE;
                                find_mega_record( screen_rec, m_rab, m_z);
                                l_x = fdv$putal( screen_rec_desc);
                                break;

        case ACTION_UPDATE:     if ( *e_mode == FIND_MODE)
                                {
                                    update_mega_record( screen_rec, 
                                                        m_rab, m_z);
                                    l_x = fdv$putal( screen_rec_desc);
                                }
                                else
                                {
                                    strcpy( screen_rec->msg_txt,
                                        "Must find before update");
                                    display_entry_error_msg( screen_rec);
                                }
                                *e_mode = ADD_MODE;
                                break;

        case ACTION_DELETE:     if ( *e_mode != FIND_MODE)
                                {
                                    strcpy( screen_rec->msg_txt,
                                            "Must find before delete");
                                    display_entry_error_msg( screen_rec);
                                }
                                else
                                {
                                    *e_mode = DELETE_MODE;
                                    l_x = sys$delete( m_rab);
                                    memset( screen_rec, ' ', 
                                        sizeof( struct entry_screen_struct));

                                    l_x = fdv$putal( screen_rec_desc);
                                }
                                break;

        case ACTION_EXIT:       break;
    }  /* end switch of e_action */


}  /* end entry_user_input subroutine */

/*;;;;;
 *  Subroutine to check the terminator and set appropriate action flags
 *;;;;;
 */
void check_entry_terminator( int terminator, enum entry_actions *a)
{
    switch ( terminator)
    {
        case FDV$K_FK_F7:       *a = ACTION_ADD;
                                break;

        case FDV$K_FK_F8:       *a = ACTION_FIND;
                                break;

        case FDV$K_FK_F9:       *a = ACTION_DELETE;
                                break;

        case FDV$K_FK_F10:      *a = ACTION_EXIT;
                                break;

        case FDV$K_FK_F11:      *a = ACTION_UPDATE;
                                break;

        default:                *a = ACTION_ADD;
                                break;
    }  /* end switch of terminator */

}  /* end check_entry_terminator subroutine */

/*;;;;;
 *  Subroutine to add a record to the MEGA indexed file
 *;;;;;
 */
void add_mega_record( struct entry_screen_struct *s_rec, 
                      struct RAB *m_rab,
                      struct drawing_record *m_z)
{
    int     l_x;


    retrieve_entry_data( s_rec, m_z);

    if ( m_z->mega_no <= 0)
    {
        strcpy( s_rec->msg_txt, "Must enter all fields");
        display_entry_error_msg( s_rec);
    }
    else
    {
        l_x = sys$put( m_rab);
        if ( !(l_x & 1) )
        {
            sprintf( s_rec->msg_txt, "Error %d adding record", l_x);
            display_entry_error_msg( s_rec);
        }
        memset( s_rec, ' ', sizeof( struct entry_screen_struct));
    }  /* end test for full screen */

}  /* end add_mega_record subroutine */

/*;;;;;
 *  Subroutine to find a record on the MEGA index file.
 *;;;;;
 */
void find_mega_record( struct entry_screen_struct *s_rec,
                       struct RAB *m_rab,
                       struct drawing_record *m_z)
{
    int     l_x;
    char    work_str[255];



    memcpy( m_z->draw_dt, s_rec->draw_dt, sizeof( m_z->draw_dt));

    m_rab->rab$l_rop =  RAB$M_KGE | RAB$M_WAT | RAB$M_RLK;

    l_x = sys$find( m_rab);

    if ( (l_x & 1))
    {
        m_rab->rab$l_rop =  RAB$M_NXT | RAB$M_WAT | RAB$M_RLK;
        l_x = sys$get( m_rab);


        memset( s_rec, ' ', sizeof( struct entry_screen_struct));
        memset( work_str, '\0', sizeof( work_str));

        memcpy( s_rec->draw_dt, m_z->draw_dt, sizeof( s_rec->draw_dt));

        sprintf( work_str, "%2d", m_z->no_1);
        memcpy( s_rec->no_1, work_str, 2);

        sprintf( work_str, "%2d", m_z->no_2);
        memcpy( s_rec->no_2, work_str, 2);

        sprintf( work_str, "%2d", m_z->no_3);
        memcpy( s_rec->no_3, work_str, 2);

        sprintf( work_str, "%2d", m_z->no_4);
        memcpy( s_rec->no_4, work_str, 2);

        sprintf( work_str, "%2d", m_z->no_5);
        memcpy( s_rec->no_5, work_str, 2);

        sprintf( work_str, "%2d", m_z->mega_no);
        memcpy( s_rec->mega_no, work_str, 2);

    }  
    else
    {
        strcpy( s_rec->msg_txt, "Could not find record");
        display_entry_error_msg( s_rec);

    }  /* end test for read success */


}  /* end find_mega_record */

/*;;;;;
 *      Subroutine to update a record from the MEGA indexed file
 *;;;;;
 */
void update_mega_record( struct entry_screen_struct *s_rec,
                         struct RAB *m_rab,
                         struct drawing_record *m_z)
{
    int     l_x;

    retrieve_entry_data( s_rec, m_z);

    l_x = sys$update( m_rab);
    if ( !(l_x & 1) )
    {
        sprintf( s_rec->msg_txt, "Error %d updating record", l_x);
        display_entry_error_msg( s_rec);
    }

    memset( s_rec, ' ', sizeof( struct entry_screen_struct));

}  /* end delete_mega_record */

/*;;;;;
 *  Subroutine to convert screen text to binary data record
 *;;;;;
 */
void retrieve_entry_data( struct entry_screen_struct *s_rec,
                          struct drawing_record *m_z)
{
    char    work_str[255];

    memcpy( m_z->draw_dt, s_rec->draw_dt, sizeof( m_z->draw_dt));

    memset( work_str, '\0', sizeof( work_str));

    memcpy( work_str, s_rec->no_1, sizeof( s_rec->no_1));
    m_z->no_1 = atol( work_str);

    memcpy( work_str, s_rec->no_2, sizeof( s_rec->no_2));
    m_z->no_2 = atol( work_str);

    memcpy( work_str, s_rec->no_3, sizeof( s_rec->no_3));
    m_z->no_3 = atol( work_str);

    memcpy( work_str, s_rec->no_4, sizeof( s_rec->no_4));
    m_z->no_4 = atol( work_str);

    memcpy( work_str, s_rec->no_5, sizeof( s_rec->no_5));
    m_z->no_5 = atol( work_str);


    memcpy( work_str, s_rec->mega_no, sizeof( s_rec->mega_no));
    m_z->mega_no = atol( work_str);

}  /* end retrieve_entry_data subroutine */

/*;;;;;
 *  Subroutine to display error message to user
 *;;;;;
 */
void display_entry_error_msg( struct entry_screen_struct *s_rec)
{
    int         l_x;
    char        work_str[255];

    $DESCRIPTOR( str_desc, work_str);
    $DESCRIPTOR( fld_name_desc, "MSG_TXT");

    
    POINTER( str_desc) = s_rec->msg_txt;
    LENGTH( str_desc) = sizeof( s_rec->msg_txt);

    l_x = fdv$bell();

    l_x = fdv$put( &str_desc, &fld_name_desc);

    l_x = fdv$wait();

    memset( s_rec->msg_txt, ' ', sizeof( s_rec->msg_txt));
    l_x = fdv$put( &str_desc, &fld_name_desc);

}  /* end display_entry_error_msg subroutine */

/*;;;;;
 *  Function will be used as a UAR by FMS
 *;;;;;
 */
int drawing_range()
{
    char    form_name_str[31], uar_vals[80], field_name[31],
            data_line[132], work_str[255];
    int     l_terminator, l_tca_ptr, l_workspace_ptr, l_cursor_pos,
            l_ins_over, l_help_num, l_x, l_fldidx, ret_val;

    $DESCRIPTOR( form_name_desc, form_name_str);
    $DESCRIPTOR( uar_vals_desc, uar_vals);
    $DESCRIPTOR( field_name_desc, field_name);
    $DESCRIPTOR( data_line_desc, data_line);



    //
    //  Set up default return value
    //
    ret_val = FDV$K_UVAL_FAIL;

    //
    //  Obtain UAR information
    //
    l_x = fdv$retcx( &l_tca_ptr, &l_workspace_ptr, &form_name_desc,
                     &uar_vals_desc, &l_cursor_pos, &l_terminator,
                     &l_ins_over, &l_help_num);

    //
    //  What field are we in
    //
    l_x = fdv$retfn( &field_name_desc, &l_fldidx);

    //
    //  Obtain the field data
    //
    memset( data_line, '\0', sizeof( data_line));

    l_x = fdv$ret( &data_line_desc, &field_name_desc, &l_fldidx);

    memset( work_str, '\0', sizeof( work_str));
    memcpy( work_str, data_line, 2);

    l_x = atol( work_str);

    if ( l_x >= 1  &&  l_x <= 52)
        ret_val = FDV$K_UVAL_SUC;

    return ret_val;
    
}  /* end drawing_range function */

// turn on warnings about dollarsign  characters
#pragma message enable (DOLLARID)          

