/*  C_ZILL_DUE_REPORT_SUB.C
 *
 *  Subroutine to create a report of the most
 *  frequently hit numbers.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>
#include <lib$routines>

/*
 *  Our headers
 */
#pragma member_alignment save
#pragma nomember_alignment
#pragma dictionary "cdd_records.zillionare_stats_record"
#pragma member_alignment restore

#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
extern const char *DRAWING_STATS_NAME;
extern const char *MEGA_STATS_NAME;
extern const char *DEFAULT_NAME;

const char *DUE_RPT_FILE_NAME = "ZILL_DUE.RPT";

extern const int PAGE_SIZE;
extern const int ELM_COUNT;


/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void build_stats_fab_rab( struct zillionare_stats_record *m_z, 
                         struct FAB *m_fab, struct RAB *m_rab,
                         struct XABKEY *m_xab,
                         int access,
                         const char *file_name);

void c_fill_in_logicals( void);

int desc_since_last_cmp( const void *e1, const void *e2);

void load_stat_array(    struct zillionare_stats_record *m_z, 
                         struct FAB *m_fab, struct RAB *m_rab,
                         struct XABKEY *m_xab,
                         int access,
                         const char *file_name);

int  open_stats_idx( struct zillionare_stats_record *m_z, 
                    struct FAB *m_fab, struct RAB *m_rab,
                    struct XABKEY *m_xab,
                    int access,
                    const char *file_name);

void write_due_report( struct zillionare_stats_record *d_stats,
                    struct zillionare_stats_record *m_stats,
                    FILE *rpt_file);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_zill_due_report_sub( )
{
    int                     l_x, default_operations;
    char                    command_str[255];
    FILE                    *rpt_file;

    $DESCRIPTOR( command_str_desc, command_str);


    struct  FAB     mega_fab;
    struct  RAB     mega_rab;
    struct  XABKEY  mega_xab;

    //
    //  Arrays to hold stats records
    //
    struct zillionare_stats_record  d_stats[ ELM_COUNT];
    struct zillionare_stats_record  m_stats[ ELM_COUNT];

    c_fill_in_logicals();

    rpt_file = fopen( DUE_RPT_FILE_NAME, "w", 
                      "ctx=rec","mrs=80", "rat=cr", "rfm=var");

    //
    //  Populate our working arrays.
    //
    load_stat_array( d_stats, &mega_fab, &mega_rab,
                        &mega_xab, FAB$M_GET,
                        DRAWING_STATS_NAME);

    load_stat_array( m_stats, &mega_fab, &mega_rab,
                        &mega_xab, FAB$M_GET,
                        MEGA_STATS_NAME);


    //
    //  Sort our arrays in descending order by hit count
    //
    qsort( d_stats, 
           ELM_COUNT, 
           sizeof( struct zillionare_stats_record),
           desc_since_last_cmp);

    qsort(  m_stats, 
            ELM_COUNT, 
            sizeof( struct zillionare_stats_record),
            desc_since_last_cmp);


    //
    //  Print the report
    //
    write_due_report( d_stats, m_stats, rpt_file);

    fclose( rpt_file);

    sprintf( command_str, "EDIT/READ %s", DUE_RPT_FILE_NAME);
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

}  /* end c_zill_due_report_sub */

/*;;;;;
 *  function to be used with qsort as the compare.
 *  Normally a sort compare routine returns the following:
 *      -1  e1 < e2
 *      0   e1 = e2
 *      1   e1 > e2
 *  We need the opposite to create descending sort.
 *;;;;;
 */
int desc_since_last_cmp( const void *e1, const void *e2)
{
    int     ret_val;

    struct zillionare_stats_record *z_1, *z_2;

    z_1 = (struct zillionare_stats_record *)e1;
    z_2 = (struct zillionare_stats_record *)e2;


    ret_val = 0;

    if ( z_1->since_last < z_2->since_last)
    {
        ret_val = 1;
    }
    else 
    {
      if ( z_1->since_last > z_2->since_last)
            ret_val = -1;
    }

    return(ret_val);

}  /* end desc_since_last_cmp function */

/*;;;;;
 *  Subroutine to write the report from our sorted working arrays.
 *;;;;;
 */
void write_due_report( struct zillionare_stats_record *d_stats,
                    struct zillionare_stats_record *m_stats,
                    FILE *rpt_file)
{
    int     l_x;
    time_t  the_time;
    char    work_str[255];
    struct  zillionare_stats_record *work_stats;


    //
    //  Format system date into a string for display
    //
    the_time = time(0);
    memset( work_str, '\0', sizeof( work_str));

    strftime( work_str, sizeof( work_str)-1, "%x", 
                localtime( &the_time));
    
    //
    //  First heading
    //
    fprintf( rpt_file, "%s %31.31s Due Numbers Report\n\n", work_str, " ");
    fprintf( rpt_file, "%29.29sRegular Drawing Numbers\n\n\n", " ");
    
    //
    //  Column headings
    //
    fprintf( rpt_file, "No   Hits   Since   Pct_hits   Ave_btwn\n");
    fprintf( rpt_file, "--   ----   -----   --------   --------\n");


    work_stats = d_stats;

    for( l_x=0; l_x < ELM_COUNT; l_x++)
    {
        if (work_stats[l_x].since_last > work_stats[l_x].ave_btwn)
        {
            fprintf( rpt_file, "%2d   %4d   %4d     %5.3f    %5.3f\n",
                    work_stats[l_x].elm_no,
                    work_stats[l_x].hit_count,
                    work_stats[l_x].since_last,
                    work_stats[l_x].pct_hits,
                    work_stats[l_x].ave_btwn);
        }  /* end test to see if number is due */
        

    }  /* end for l_x loop */



    //
    //  Second heading
    //
    fprintf( rpt_file, "\f%s %31.31s Due Numbers Report\n\n", work_str, " ");
    fprintf( rpt_file, "\n\n\n%30.30sMega Drawing Numbers\n\n\n", " ");
    
    //
    //  Column headings
    //
    fprintf( rpt_file, "No   Hits   Since   Pct_hits   Ave_btwn\n");
    fprintf( rpt_file, "--   ----   -----   --------   --------\n");


    work_stats = m_stats;

    for( l_x=0; l_x < ELM_COUNT; l_x++)
    {

        if (work_stats[l_x].since_last > work_stats[l_x].ave_btwn)
        {
            fprintf( rpt_file, "%2d   %4d   %4d     %5.3f    %5.3f\n",
                    work_stats[l_x].elm_no,
                    work_stats[l_x].hit_count,
                    work_stats[l_x].since_last,
                    work_stats[l_x].pct_hits,
                    work_stats[l_x].ave_btwn);
        }  /* end test to see if number is due */

    }  /* end for l_x loop */

}  /* end write_due_report subroutine */
