/*  C_MY_ZILL_IMPORT_SUB.C
 *
 *  Subroutine to import comma seperated value text file
 *  into the Mega MySQL table.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */

/*
 *  Our headers
 */
#include <mysql.h>

/*;;;;;
 *      Function prototypes
 *;;;;;
 */
void parse_csv_line( char *input_line_str, 
                     char *dash_dt,
                     char *no_1_str,
                     char *no_2_str,
                     char *no_3_str,
                     char *no_4_str,
                     char *no_5_str,
                     char *mega_no_str);

FILE    *prompt_and_open_csv( void);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_my_zill_import_sub( MYSQL *conn)
{
    int                     l_x, l_count;
    char                    line_in[255], command_str[1024],
                            dash_date[15], no_1_str[4], no_2_str[4],
                            no_3_str[4], no_4_str[4], no_5_str[4],
                            mega_no_str[4];
    FILE                    *in_file;


    l_count = 0;

    //
    //  obtain a value input file
    //
    in_file = NULL;
    do
    {
        in_file = prompt_and_open_csv();
    }  while ( in_file == NULL);

    //
    //  Nuke and recreate table
    //
    l_x = mysql_query( conn, "DROP TABLE IF EXISTS DRAWING_DATA;");
    printf( "Result of drop %d\n", mysql_errno( conn));

    l_x = mysql_query( conn, "create table drawing_data "
                             "( draw_dt     date    not null, "
                              "no_1        int     not null, "
                              "no_2        int     not null, "
                              "no_3        int     not null, "
                              "no_4        int     not null, "
                              "no_5        int     not null, "
                              "mega_no     int     not null, "
                              "primary key k0 (draw_dt));" 
                           );

    printf( "Result of creating new table %d\n", mysql_errno( conn));

    l_x = mysql_commit( conn);

    //
    //  Read every input record and create an output record
    //
    l_count = 0;
    do
    {
        //  clear out the working areas before any IO occurs.
        //
        memset( line_in, '\0', sizeof( line_in));

        fgets( line_in, sizeof( line_in) -1, in_file);
        if ( !feof( in_file))
        {
            l_count++;

            parse_csv_line( line_in, dash_date, 
                            no_1_str, no_2_str, no_3_str, no_4_str, no_5_str, mega_no_str);

            memset( command_str, '\0', sizeof( command_str));

            sprintf( command_str, 
            "INSERT INTO drawing_data SET draw_dt='%s', no_1=%s, no_2=%s,"
            " no_3=%s, no_4=%s, no_5=%s, mega_no=%s;",
                dash_date, no_1_str, no_2_str, no_3_str, 
                no_4_str, no_5_str, mega_no_str);

            l_x = mysql_query( conn, command_str);

            if ( l_x != 0)
                printf( "Result of insert %d %s\n", 
                    mysql_errno( conn), mysql_error( conn));

            if ( (l_count % 100) == 0)
            {
                printf( "Processed %d Records\n", l_count);
                l_x = mysql_commit( conn);      // should commit every 100 records or so

            }  /* end status message test */
        }  /* end test for successful read */

    } while ( !feof( in_file));

    printf( "Processed %d Records\n", l_count);

    l_x = mysql_commit( conn);      // final commit to get stragglers

    fclose( in_file);

}  /* end c_my_zill_import_sub */

/*;;;;;
 *      Function to obtain a file name from the user and
 *      open the file for input.
 *;;;;;
 */
FILE *prompt_and_open_csv()
{
    int     l_x;
    char    file_name_str[255];
    FILE    *the_file;

    memset( file_name_str, '\0', sizeof( file_name_str));

    printf( "\n\nInput file name: ");
    scanf( "%s", file_name_str);

    the_file = fopen( file_name_str, "r");

    if ( the_file != NULL)
    {
        l_x = ferror( the_file);
        if (l_x != 0)
        {
            printf( "Error %d opening input file\n", l_x);
        }
    }  /* end test for succesful open */

    return the_file;

}  /* end prompt_and_open_csv function */

/*;;;;;
 *      Subroutine to parse the input record
 *      filling in the output record buffer.
 *;;;;;
 */
void parse_csv_line( char *input_line_str, char *dash_dt,
                     char *no_1_str, char *no_2_str, char *no_3_str,
                     char *no_4_str, char *no_5_str, char *mega_no_str)
{
    char    *tmp, scratch_str[255], *tmp2;
    int	    i_mm, i_dd, i_yyyy, i_num;


    //
    //	First field is the date in mm/dd/yyyy format with zero suppression
    //	for the date we will use the safe method of copying the characters we want
    //	into a scratch string then manipulating that.  Later we will work with the values
    //	in place.
    //
    tmp = input_line_str;
    tmp2 = strchr( tmp, '/');

    memset( scratch_str, '\0', sizeof( scratch_str));		// nuke the destination string
    memcpy( scratch_str, tmp, tmp2-tmp);			// copy the month digits
    i_mm = atoi( scratch_str);					// obtain the month in numeric form

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, '/');
    memset( scratch_str, '\0', sizeof( scratch_str));
    memcpy( scratch_str, tmp, tmp2-tmp);			// copy the day digits
    i_dd = atoi( scratch_str);					// obtain the day in numeric form

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    memset( scratch_str, '\0', sizeof( scratch_str));
    memcpy( scratch_str, tmp, tmp2-tmp);			// copy the year digits
    i_yyyy = atoi( scratch_str);				// obtain the year in numeric format

    //
    //  put date string in format needed by MySQL
    //
    sprintf( dash_dt, "%d-%d-%d", i_yyyy, i_mm, i_dd);

    //
    //	    Now obtain the drawing numbers
    //	    This time, instead of using the scratch_str as a work area we
    //	    will insert null bytes and work with the string in place.
    //
    tmp = tmp2 + 1;						// skip the comma
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    strcpy( no_1_str, tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    strcpy( no_2_str, tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    strcpy( no_3_str, tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    strcpy( no_4_str, tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    strcpy( no_5_str, tmp);

    //  there is no trailing comma behind the mega number
    //
    tmp = tmp2 + 1;
    strcpy( mega_no_str, tmp);

}  /* end parse_csv_line subroutine */

