/*  C_MY_ZILL_DUE_REPORT_SUB.C
 *
 *  Subroutine to create a report of 
 *  numbers which should be due to hit.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>
#include <lib$routines>

/*
 *  Our headers
 */
#include <mysql.h>

#define LENGTH(descriptor)      descriptor.dsc$w_length

/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const char *DUE_RPT_FILE_NAME = "ZILL_DUE.RPT";

#define PAGE_SIZE 60
#define ELM_COUNT 52


/*;;;;;
 *      Function prototypes
 *;;;;;
 */
void write_due_report(FILE *rpt_file, MYSQL *conn);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_my_zill_due_report_sub( MYSQL *conn)
{
    int                     l_x;
    char                    command_str[255];
    FILE                    *rpt_file;

    $DESCRIPTOR( command_str_desc, command_str);


    rpt_file = fopen( DUE_RPT_FILE_NAME, "w", 
                      "ctx=rec","mrs=80", "rat=cr", "rfm=var");

    //
    //  Print the report
    //
    write_due_report( rpt_file, conn);

    fclose( rpt_file);

    sprintf( command_str, "EDIT/READ %s", DUE_RPT_FILE_NAME);
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

}  /* end c_my_zill_due_report_sub */

/*;;;;;
 *  Subroutine to write the report from our sorted working arrays.
 *;;;;;
 */
void write_due_report( FILE *rpt_file, MYSQL *conn)
{
    int     l_x;
    time_t  the_time;
    char    work_str[1024];

    MYSQL_RES       *res;
    MYSQL_ROW       row;

    const char *DRAW_SELECT = "select elm_no, hit_count, since_last, pct_hits, ave_btwn\
                                from draw_stats\
                                where since_last > ave_btwn\
                                order by since_last desc;";

    const char *MEGA_SELECT = "select elm_no, hit_count, since_last, pct_hits, ave_btwn\
                                from mega_stats\
                                where since_last > ave_btwn\
                                order by since_last desc;";

    //
    //  Format system date into a string for display
    //
    the_time = time(0);
    memset( work_str, '\0', sizeof( work_str));

    strftime( work_str, sizeof( work_str)-1, "%x", 
                localtime( &the_time));
    
    //
    //  First heading
    //
    fprintf( rpt_file, "%s %31.31s Due Numbers Report\n\n", work_str, " ");
    fprintf( rpt_file, "%29.29sRegular Drawing Numbers\n\n\n", " ");
    
    //
    //  Column headings
    //
    fprintf( rpt_file, "No   Hits   Since   Pct_hits   Ave_btwn\n");
    fprintf( rpt_file, "--   ----   -----   --------   --------\n");


    l_x = mysql_query( conn, DRAW_SELECT);

    res = mysql_use_result( conn);

    while ( (row = mysql_fetch_row( res)))
    {
        fprintf( rpt_file, "%2s  %4s    %3s     %-8s    %6.2f\n", 
            row[0], row[1], row[2], row[3], atof(row[4]));
    }  /* end while loop to print drawing rows */

    mysql_free_result( res);

    //
    //  Second heading
    //
    fprintf( rpt_file, "\f%s %31.31s Due Numbers Report\n\n", work_str, " ");
    fprintf( rpt_file, "\n\n\n%30.30sMega Drawing Numbers\n\n\n", " ");
    
    //
    //  Column headings
    //
    fprintf( rpt_file, "No   Hits   Since   Pct_hits   Ave_btwn\n");
    fprintf( rpt_file, "--   ----   -----   --------   --------\n");


    l_x = mysql_query( conn, MEGA_SELECT);

    res = mysql_use_result( conn);

    while ( (row = mysql_fetch_row( res)))
    {
        fprintf( rpt_file, "%2s  %4s    %3s     %-8s    %6.2f\n", 
            row[0], row[1], row[2], row[3], atof(row[4]));
    }  /* end while loop to print drawing rows */

    mysql_free_result( res);

}  /* end write_due_report subroutine */
