#   C_MY_MEGA.MMS
#
#   MMS Description file for Mega Zillionare MySQL example application.
#
#
#   Define our macro sybmols
# 
.SILENT

.IFDEF DEBUG
CFLAGS = /G_FLOAT/NOOPT/DEBUG/OBJECT=MEGA_OBJ:/include=mysql_root:[include]/names=as_is
LFLAGS = /DEBUG/EXE=MEGA_EXE:
.ELSE
CFLAGS = /G_FLOAT/OBJECT=MEGA_OBJ:/include=mysql_root:[include]/names=as_is
LFLAGS = /EXE=MEGA_EXE:
.ENDIF

CMSFLAGS = /NOHISTORY/NOLOG
SAY = WRITE SYS$OUTPUT

#
#   Directives
#

.FIRST
    SAY "STARTING MEGA ZILLIONARE BUILD"
    COPY MEGA_CMS_REF:*.COM MEGA_COM:*.*;0   !update command files
    PURGE/KEEP=2 MEGA_COM:
    COPY MEGA_CMS_REF:*.FDL MEGA_DAT:*.*;0   !update fdl files
    PURGE/KEEP=2 MEGA_DAT:
    DEFINE DECC$TEXT_LIBRARY MEGA_TEXT_LIB

.LAST
    PURGE/KEEP=2 MEGA_EXE:
    PURGE/KEEP=2 MEGA_OBJ:
    SAY "MEGA ZILLIONARE BUILD COMPLETE"


.DEFAULT
  $(SAY) "Encountered an unknown dependancy directive:"
  $(SAY) " $@ : $+"

#
#   Targets
#

!
!   When you do not specify a target to build MMS
!   build the first target it finds.  Always make this your
!   complete application and life will be good.
!
MEGA_ZILLIONARE DEPENDS_ON  \
    MEGA_OBJ:MEGA_CDO.TXT   \
    MEGA_TEXT_LIB           \
    MEGA_ZILL               \
    MEGA_OBJ_LIB            \
    MEGA_EXE:C_MY_ZILL_MENU.EXE

    $(SAY) "Mega_Zillionare Complete"

!
!   We use the txt file to get a file with a time stamp
!   that MMS can use in comparison.  If any of the dependancy files
!   have a newer date than the txt file, we will rebuild the CDD.
!
MEGA_OBJ:MEGA_CDO.TXT  DEPENDS_ON   MEGA_FIELDS.CDO \
        MEGA_RECORDS.CDO \
        MEGA_COM:MEGA_REBUILD_CDD.COM

    @MEGA_COM:MEGA_REBUILD_CDD
    COPY NL: MEGA_OBJ:MEGA_CDO.TXT


MEGA_TEXT_LIB DEPENDS_ON FDVDEF.H FMS_PROTOTYPES.H FMS_PROTOTYPES_UPPER.H
    LIB/CREATE/TEXT MEGA_TEXT_LIB
    LIB/INSERT/TEXT MEGA_TEXT_LIB FDVDEF.H
    LIB/INSERT/TEXT MEGA_TEXT_LIB FMS_PROTOTYPES.H
    LIB/INSERT/TEXT MEGA_TEXT_LIB FMS_PROTOTYPES_UPPER.H
    

MEGA_ZILL DEPENDS_ON                     \
            ZILL_BROWSE.FRM     \
            ZILL_ENTRY.FRM      \
            ZILL_ENTRY2.FRM     \
            ZILL_MENU.FRM

    FMS/LIBRARY/CREATE MEGA_ZILL ZILL_BROWSE.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_ENTRY.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_ENTRY2.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_MENU.FRM


MEGA_OBJ_LIB DEPENDS_ON \
            MEGA_OBJ:C_MY_CREATE_STATS_SUB.OBJ \
            MEGA_OBJ:C_MY_DUMP_DRAW_DATA_SUB.OBJ \
            MEGA_OBJ:C_MY_ZILL_BROWSE_SUB.OBJ \
            MEGA_OBJ:C_MY_ZILL_DUE_REPORT_SUB.OBJ \
            MEGA_OBJ:C_MY_ZILL_ENTRY_SUB.OBJ \
            MEGA_OBJ:C_MY_ZILL_IMPORT_SUB.OBJ \
            MEGA_OBJ:C_FILL_IN_LOGICALS.OBJ \
            MEGA_OBJ:C_MY_ZILL_MOST_REPORT_SUB.OBJ 

    LIB/CREATE MEGA_OBJ_LIB
    LIB/INSERT MEGA_OBJ_LIB MEGA_OBJ:C_MY_CREATE_STATS_SUB, -
        MEGA_OBJ:C_MY_DUMP_DRAW_DATA_SUB,                   -
        MEGA_OBJ:C_MY_ZILL_BROWSE_SUB,                      -
        MEGA_OBJ:C_MY_ZILL_DUE_REPORT_SUB,                  -
        MEGA_OBJ:C_MY_ZILL_ENTRY_SUB,                       -
        MEGA_OBJ:C_MY_ZILL_IMPORT_SUB,                      -
        MEGA_OBJ:C_FILL_IN_LOGICALS,                     -
        MEGA_OBJ:C_MY_ZILL_MOST_REPORT_SUB

MEGA_EXE:C_MY_ZILL_MENU.EXE DEPENDS_ON  \
        MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ    \
        MEGA_OBJ:C_MY_ZILL_MENU.OBJ     \
        MEGA_OBJ_LIB

    LINK $(LFLAGS) MEGA_OBJ:C_MY_ZILL_MENU.OBJ, -
        MEGA_OBJ:MEGA_ZILL_VECTOR, MEGA_CMS_REF:MY.OPT/OPT

#
#   Lesser targets
#
MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ DEPENDS_ON MEGA_ZILL
    FMS/VECTOR/OUTPUT=MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ MEGA_ZILL


MEGA_OBJ:C_MY_CREATE_STATS_SUB.OBJ  DEPENDS_ON \
            C_MY_CREATE_STATS_SUB.C          \
            MEGA_TEXT_LIB


MEGA_OBJ:C_MY_DUMP_DRAW_DATA_SUB.OBJ DEPENDS_ON \
            C_MY_DUMP_DRAW_DATA_SUB.C         \
            MEGA_TEXT_LIB

MEGA_OBJ:C_MY_ZILL_BROWSE_SUB.OBJ DEPENDS_ON   \
            C_MY_ZILL_BROWSE_SUB.C           \
            MEGA_TEXT_LIB

MEGA_OBJ:C_MY_ZILL_DUE_REPORT_SUB.OBJ DEPENDS_ON   \
            C_MY_ZILL_DUE_REPORT_SUB.C           \
            MEGA_TEXT_LIB

MEGA_OBJ:C_MY_ZILL_ENTRY_SUB.OBJ DEPENDS_ON    \
            C_MY_ZILL_ENTRY_SUB.C            \
            MEGA_TEXT_LIB

MEGA_OBJ:C_MY_ZILL_IMPORT_SUB.OBJ DEPENDS_ON   \
            C_MY_ZILL_IMPORT_SUB.C           \
            MEGA_TEXT_LIB

MEGA_OBJ:C_MY_ZILL_MOST_REPORT_SUB.OBJ DEPENDS_ON  \
            C_MY_ZILL_MOST_REPORT_SUB.C          \
            MEGA_TEXT_LIB


