/*  C_MY_DUMP_DRAW_DATA_SUB.C
 *
 *  Subroutine to perform a dump of drawing data to a report
 *  over a range of dates.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>

/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>
#include <lib$routines>

/*
 *  Our headers
 */
#include <mysql.h>

#define LENGTH(descriptor)      descriptor.dsc$w_length

/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const char *DUMP_RPT_FILE_NAME = "ZILL_DUMP.RPT";

#define PAGE_SIZE  60

/*;;;;;
 *      Function prototypes
 *;;;;;
 */
void write_dump_report_line( int *line_count, 
                             int *page_count, 
                             MYSQL_TIME *draw_dt, 
                             int l_no_1, int l_no_2, int l_no_3,
                             int l_no_4, int l_no_5, int l_mega_no,
                             FILE *rpt_file);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_my_dump_draw_data_sub( MYSQL *conn)
{
    int                     l_x, l_no_1, l_no_2, l_no_3, l_no_4,
                            l_no_5, l_mega_no;
    int                     line_count, page_count;
    char                    command_str[1024], beg_date[255], end_date[255];
    FILE                    *rpt_file;

    MYSQL_TIME              sql_draw_dt;
    MYSQL_STMT              *stmt;
    MYSQL_RES               *prep_meta_result;
    MYSQL_BIND              bind[7];
    my_bool                 is_null[7];
    unsigned long           fld_length[7];


    $DESCRIPTOR( command_str_desc, command_str);


    line_count = PAGE_SIZE;         // force first page break;
    page_count = 0;


    rpt_file = fopen( DUMP_RPT_FILE_NAME, "w", 
                      "ctx=rec","mrs=80", "rat=cr", "rfm=var");


    //
    //  Prompt for date range
    //
    memset( beg_date, '\0', sizeof( beg_date));
    memset( end_date, '\0', sizeof( end_date));

    printf( "Enter beginning date YYYY-MM-DD: ");
    scanf( "%s", beg_date);
    if ( strlen( beg_date) < 9)
    {
        strcpy( beg_date, "1000-01-01");
    }

    printf( "Enter ending date YYYY-MM-DD: ");
    scanf( "%s", end_date);
    if ( strlen( end_date) < 9)
    {
        strcpy( end_date, "9999-12-31");
    }
    

    //
    //  Build query statement
    //
    sprintf( command_str, "SELECT DRAW_DT, NO_1, NO_2, NO_3, NO_4,\
       NO_5, MEGA_NO FROM DRAWING_DATA\
       WHERE DRAW_DT BETWEEN '%s' AND '%s' ORDER BY DRAW_DT ASC",
       beg_date, end_date);


    stmt = mysql_stmt_init( conn);
    if ( !stmt)
    {
        printf( "Unable to init sql statementn");
        return;
    }  /* end test for stmt init */

    if ( mysql_stmt_prepare(stmt, command_str, strlen( command_str)))
    {
        printf( "failed to prepare select statement\n");
        printf( "%s\n", mysql_stmt_error(stmt));
        return;
    }  /* end test for prepare success */

    prep_meta_result = mysql_stmt_result_metadata(stmt);
    if ( !prep_meta_result)
    {
        printf( "No meta information found\n");
        printf( "%s\n", mysql_stmt_error( stmt));
        return;
    }  /* end test for meta result */
    
                           
    //
    //  Execute the select
    //
    if ( mysql_stmt_execute( stmt))
    {
        printf( "Error executing statement\n");
        printf( "%s\n", mysql_stmt_error( stmt));
        return; 
    }  /* end test for successfull execute */

    memset( bind, 0, sizeof( bind));

    //
    //  Set up the bind array, one element for each column
    //  We have a not NULL constraint on each column
    //  so technically we could have skipped the is_null
    //  elements, but best to give the server some place
    //  to put the result.
    //
    bind[0].buffer_type     = MYSQL_TYPE_DATE;
    bind[0].buffer          = (char *)&sql_draw_dt;
    bind[0].is_null         = &is_null[0];
    bind[0].length          = &fld_length[0];

    bind[1].buffer_type     = MYSQL_TYPE_LONG;
    bind[1].buffer          = (char *)&l_no_1;
    bind[1].is_null         = &is_null[1];
    bind[1].length          = &fld_length[1];

    bind[2].buffer_type     = MYSQL_TYPE_LONG;
    bind[2].buffer          = (char *)&l_no_2;
    bind[2].is_null         = &is_null[2];
    bind[2].length          = &fld_length[2];

    bind[3].buffer_type     = MYSQL_TYPE_LONG;
    bind[3].buffer          = (char *)&l_no_3;
    bind[3].is_null         = &is_null[3];
    bind[3].length          = &fld_length[3];

    bind[4].buffer_type     = MYSQL_TYPE_LONG;
    bind[4].buffer          = (char *)&l_no_4;
    bind[4].is_null         = &is_null[4];
    bind[4].length          = &fld_length[4];

    bind[5].buffer_type     = MYSQL_TYPE_LONG;
    bind[5].buffer          = (char *)&l_no_5;
    bind[5].is_null         = &is_null[5];
    bind[5].length          = &fld_length[5];

    bind[6].buffer_type     = MYSQL_TYPE_LONG;
    bind[6].buffer          = (char *)&l_mega_no;
    bind[6].is_null         = &is_null[6];
    bind[6].length          = &fld_length[6];
                          

    //
    //  bind the result buffers
    //
    if (mysql_stmt_bind_result( stmt, bind))
    {
        printf( "Unable to bind results\n");
        printf( "%s\n", mysql_stmt_error(stmt));
        return;
    }  /* end test for successful bind */

    //
    //  Store the results on the client
    //
    if (mysql_stmt_store_result( stmt))
    {
        printf( "Error using results\n");
        printf( "%s\n", mysql_stmt_error( stmt));
        return;
    }  /* end test for successful store */

    while ( !mysql_stmt_fetch(stmt))
    {
        write_dump_report_line( &line_count, 
                                &page_count, 
                                &sql_draw_dt,
                                l_no_1, l_no_2, l_no_3,
                                l_no_4, l_no_5, l_mega_no, rpt_file);

    }  /* end while mysql_stmt_fetch loop */
    
    mysql_free_result(prep_meta_result);
    mysql_stmt_close(stmt);

    fclose( rpt_file);

    sprintf( command_str, "EDIT/READ %s", DUMP_RPT_FILE_NAME);
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

}  /* end c_my_dump_draw_data_sub */

void write_dump_page_heading( int *page_count, FILE *rpt_file)
{
    time_t  the_time;
    char    work_str[255];

    if (*page_count > 1)
        fprintf( rpt_file, "\f");

    //
    //  Format system date into a string for display
    //
    the_time = time(0);
    memset( work_str, '\0', sizeof( work_str));

    strftime( work_str, sizeof( work_str)-1, "%x", 
                localtime( &the_time));
    
    fprintf( rpt_file, "%s %20.20s Drawing Number Report          Page: %d\n",
                work_str, " ", *page_count);
    fprintf( rpt_file, "    Drawing      No   No   No   No   No     Mega\n");
    fprintf( rpt_file, "     Date         1    2    3    4    5      No\n");
    fprintf( rpt_file, "------------     --   --   --   --   --     ----\n");

}  /* end write_dump_page_heading subroutine */

void write_dump_report_line( int *line_count, 
                             int *page_count, 
                             MYSQL_TIME *draw_dt, 
                             int l_no_1, int l_no_2, int l_no_3,
                             int l_no_4, int l_no_5, int l_mega_no,
                             FILE *rpt_file)
{
    if ( *line_count >= PAGE_SIZE)
    {
        *line_count = 5;
        *page_count = *page_count + 1;
        write_dump_page_heading( page_count, rpt_file);
    }  /* end test for page break */


    fprintf( rpt_file, "%02d-%02d-%d       %2d   %2d   %2d   %2d   %2d       %2d\n",
               draw_dt->month, draw_dt->day, draw_dt->year,
               l_no_1,
               l_no_2,
               l_no_3,
               l_no_4,
               l_no_5,
               l_mega_no);

    *line_count = *line_count + 1;
               
}  /* end write_dump_report_line */

