/*  C_DFLOAT_TEST.C
 *
 *  Program to show example of how to read and use files 
 *  which have D_FLOAT data types in them.
 *
 */

/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>

/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <lib$routines>
#include <descrip>

#define LENGTH(descriptor)      descriptor.dsc$w_length
#define POINTER(descriptor)     descriptor.dsc$a_pointer

/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
#pragma message disable( UNSTRUCTMEM)
#pragma member_alignment save
#pragma nomember_alignment

struct d_rec_struct
{
    long    record_no;
    union
    {
        char d_flt_dbl_bytes[8];
        double g_flt_dbl;
    };
};

#pragma member_alignment restore
#pragma message enable( UNSTRUCTMEM)


int main( int *argc, char **argv)
{
    struct d_rec_struct d_rec;

    int         l_x, l_y, l_z;
    short int   w_x;
    double      local_gflt_dbl;
    FILE        *in_file;
    struct      dsc$descriptor_s    d_in, g_out;

    //
    //  open the input file
    //
    in_file = fopen( "D.SEQ", "rb", "rfm=fix", "ctx=rec", "mrs=12","rat=cr");

    //
    //  build the input descriptor
    //
    d_in.dsc$w_length       = sizeof( d_rec.d_flt_dbl_bytes);
    d_in.dsc$b_dtype        = DSC$K_DTYPE_D;
    d_in.dsc$b_class        = DSC$K_CLASS_S;
    d_in.dsc$a_pointer      = d_rec.d_flt_dbl_bytes;


    g_out.dsc$w_length       = sizeof( local_gflt_dbl);
    g_out.dsc$b_dtype        = DSC$K_DTYPE_G;
    g_out.dsc$b_class        = DSC$K_CLASS_S;
    g_out.dsc$a_pointer      = (char *)&local_gflt_dbl;

    //
    //  binary read of first record.
    //
    l_z = fread( &d_rec, sizeof( d_rec), 1, in_file);

    w_x = 0;
    l_x = lib$cvt_dx_dx( &d_in, &g_out, &w_x);

    printf( "Record %d  value %f\n", d_rec.record_no, local_gflt_dbl);


    //
    //  rest of records
    //
    for (l_y=0; l_y <=3; l_y++)
    {
        fread( &d_rec, sizeof( d_rec), 1, in_file);

        w_x = 0;
        l_x = lib$cvt_dx_dx( &d_in, &g_out, &w_x);
        d_rec.g_flt_dbl = local_gflt_dbl;
        printf( "Record %d  value %f\n", d_rec.record_no, d_rec.g_flt_dbl);
    }  /* end for l_y loop */

    fclose( in_file);

    return 1;

}  /* end main module for c_dfloat_test */
