1   OPTION TYPE=EXPLICIT
    !
    !	BASIC_ZILL_IMPORT.BAS
    !
    !	Stand alone program to import a flat text file
    !   of comma seperated values in the form of:
    !
    !   draw_dt, no_1, no_2, no_3, no_4, no_5, mega_no
    !
    !   creating a shiny new indexed file.
    !
    %INCLUDE "MEGA_INC:MEGA_RECS.INC"	    ! our record definitions

    %INCLUDE "LIB$ROUTINES" %FROM %LIBRARY



    !;;;;;;;;;;
    !	Constants
    !;;;;;;;;;;
    DECLARE BYTE CONSTANT   draw_chan% = 6%
    DECLARE BYTE CONSTANT   input_chan% = 5%
    DECLARE BYTE CONSTANT   elm_count% = 52%


    DECLARE STRING CONSTANT drawing_data$ = "MY_MEGA_FILE"


    !;;;;;;;;;;
    !	Maps
    !;;;;;;;;;;
    MAP (LOCAL_MAP) STRING  TRANSLATED_NAME$ = 255%

    MAP (DRAW_MAP)  DRAWING_RECORD		DRAW_REC

    !;;;;;;;;;;
    !	Local Variables
    !;;;;;;;;;;
    DECLARE WORD    W_X%
    DECLARE LONG    L_X%, L_ERR%, L_REC_COUNT%, L_SLASH_SUB%

    DECLARE STRING  WORK_STR$, NUM_TXT$, LINE_IN_STR$, &
                    INPUT_FILE_NAME_STR$, LOG_TXT$, &
                    MM_STR$, DD_STR$, YYYY_STR$

    !;;;;;;;;;;
    !	Main Logic
    !;;;;;;;;;;

100 L_ERR% = 0%
    GOSUB A900_FILL_IN_LOGICALS

    GOSUB A910_OPEN_FILES

    L_REC_COUNT% = 0%

    WHILE L_ERR% = 0%
        WHEN ERROR IN
            LINPUT #input_chan%, LINE_IN_STR$
        USE
            L_ERR% = ERR
        END WHEN

        ITERATE IF L_ERR% <> 0%

        !
        !  Extract the date which is in mm/dd/yyyy format
        !  and convert it to YYYYMMDD format with leading zeros.
        !
        L_X% = INSTR( 1%, LINE_IN_STR$, ",")
        WORK_STR$ = LEFT$( LINE_IN_STR$, L_X% - 1%)
        L_SLASH_SUB% = INSTR( 1%, WORK_STR$, "/")
        MM_STR$ = LEFT$( WORK_STR$, L_SLASH_SUB% -1%)
        MM_STR$ = EDIT$( MM_STR$, 2%)

        WORK_STR$ = RIGHT$( WORK_STR$, L_SLASH_SUB% + 1%)
        L_SLASH_SUB% = INSTR( 1%, WORK_STR$, "/")
        DD_STR$ = LEFT$( WORK_STR$, L_SLASH_SUB% - 1%)
        DD_STR$ = EDIT$( DD_STR$, 2%)

        YYYY_STR$ = RIGHT$( WORK_STR$, L_SLASH_SUB% + 1%)
        DRAW_REC::DRAW_DT = YYYY_STR$ + FORMAT$( VAL%(MM_STR$), "<0>#") &
                            + FORMAT$( VAL%(DD_STR$), "<0>#")

        !
        !  Extract the drawing numbers and convert them to integers
        !
        WORK_STR$ = RIGHT$( LINE_IN_STR$, L_X% + 1%)
        L_X% = INSTR( 1%, WORK_STR$, ",")
        NUM_TXT$ = LEFT$( WORK_STR$, L_X% - 1%)
        NUM_TXT$ = EDIT$( NUM_TXT$, 2%)
        DRAW_REC::NO_1 = VAL%( NUM_TXT$)

        WORK_STR$ = RIGHT$( WORK_STR$, L_X% + 1%)
        L_X% = INSTR( 1%, WORK_STR$, ",")
        NUM_TXT$ = LEFT$( WORK_STR$, L_X% - 1%)
        NUM_TXT$ = EDIT$( NUM_TXT$, 2%)
        DRAW_REC::NO_2 = VAL%( NUM_TXT$)

        WORK_STR$ = RIGHT$( WORK_STR$, L_X% + 1%)
        L_X% = INSTR( 1%, WORK_STR$, ",")
        NUM_TXT$ = LEFT$( WORK_STR$, L_X% - 1%)
        NUM_TXT$ = EDIT$( NUM_TXT$, 2%)
        DRAW_REC::NO_3 = VAL%( NUM_TXT$)

        WORK_STR$ = RIGHT$( WORK_STR$, L_X% + 1%)
        L_X% = INSTR( 1%, WORK_STR$, ",")
        NUM_TXT$ = LEFT$( WORK_STR$, L_X% - 1%)
        NUM_TXT$ = EDIT$( NUM_TXT$, 2%)
        DRAW_REC::NO_4 = VAL%( NUM_TXT$)

        WORK_STR$ = RIGHT$( WORK_STR$, L_X% + 1%)
        L_X% = INSTR( 1%, WORK_STR$, ",")
        NUM_TXT$ = LEFT$( WORK_STR$, L_X% - 1%)
        NUM_TXT$ = EDIT$( NUM_TXT$, 2%)
        DRAW_REC::NO_5 = VAL%( NUM_TXT$)

        WORK_STR$ = RIGHT$( WORK_STR$, L_X% + 1%)
        WORK_STR$ = EDIT$( WORK_STR$, 2%)
        DRAW_REC::MEGA_NO = VAL%( WORK_STR$)

        GOSUB A950_WRITE_RECORD

        IF MOD( L_REC_COUNT%, 100%) = 0%
        THEN
            PRINT L_REC_COUNT%;" Records written"
        END IF

    NEXT


    PRINT L_REC_COUNT%;" Records written"


    GOTO PROGRAM_EXIT

900 !;;;;;;;;;;
    !	Subroutine to fill in logical values
    !	Ordinarily developers simply "assume" that either
    !	logicals have been defined or do so in a job stream
    !	but this will allow the demonstration of service calls.
    !;;;;;;;;;;
 A900_FILL_IN_LOGICALS:

        WORK_STR$ = drawing_data$
        TRANSLATED_NAME$ = " "      ! destination has to be pre-allocated
        W_X% = 0%

        L_X% = LIB$GET_LOGICAL( WORK_STR$, TRANSLATED_NAME$, W_X%,,,,)

        IF LEN( TRM$( TRANSLATED_NAME$)) < 1
        THEN
            LOG_TXT$ = drawing_data$ + ".IDX"
            L_X% = LIB$SET_LOGICAL( WORK_STR$, LOG_TXT$,,,)
        END IF

    RETURN



910 !;;;;;;;;;;
    !	Subroutine to open indexed files
    !;;;;;;;;;;
 A910_OPEN_FILES:
        WHEN ERROR IN
            L_ERR% = 0%
            OPEN drawing_data$ FOR INPUT AS FILE #draw_chan%,   &
                ORGANIZATION INDEXED FIXED,                     &
                ALLOW NONE, ACCESS MODIFY,                      &
                RECORDTYPE FORTRAN,                             &
                RECORDSIZE drawing_record_size,                 &
		MAP DRAW_MAP
        USE
            L_ERR% = ERR
            PRINT "Unable to open input file "; drawing_data$
            PRINT "Error: ";L_ERR%;" ";ERT$( L_ERR%)
        END WHEN


        RETURN IF L_ERR% <> 0%

        !
        !   Must get input file name from user
        !
        INPUT_FILE_NAME_STR$ = " "
        WHILE INPUT_FILE_NAME_STR$ <= " "
        
            INPUT "Name of Input File ";INPUT_FILE_NAME_STR$
        NEXT


        WHEN ERROR IN
            L_ERR% = 0%
            OPEN INPUT_FILE_NAME_STR$ FOR INPUT AS FILE #input_chan%
        USE
            L_ERR% = ERR
            PRINT "Unable to open input file ";INPUT_FILE_NAME_STR$
            PRINT "Error: ";L_ERR%;" ";ERT$( L_ERR%)
        END WHEN

    RETURN  

950 !;;;;;;;;;;
    !
    !;;;;;;;;;;
 A950_WRITE_RECORD:
        WHEN ERROR IN
            L_ERR% = 0%
            PUT #draw_chan%
            L_REC_COUNT% = L_REC_COUNT% + 1%
        USE
            L_ERR% = ERR
            PRINT "Error writing record to indexed file"
            PRINT "Error: ";L_ERR%;" ";ERT$( L_ERR%)
        END WHEN

    RETURN

32767	!  End of module
 PROGRAM_EXIT:
	WHEN ERROR IN
	    CLOSE #draw_chan%
	USE
	    ! ignore error on close
	END WHEN

        WHEN ERROR IN
            CLOSE #input_chan%
        USE
            ! ignore error on close
        END WHEN

	END 
