(****************************************
*                                       *
*     MODULA-2 Multi-Pass Compiler      *
*     ****************************      *
*                                       *
*       VAX/VMS Implementation          *
*                                       *
*                                       *
*     MVCIO2:                           *
*                                       * 
*     Input / output handling in Pass 2 *
*                                       * 
*     Version 3.1 of  1-FEB-1983        *
*                                       *
*                                       *
*                                       *
*     based on                          *
*     Version M22 of 09.03.81           *
*                                       *
*     Institut fuer Informatik          *
*     ETH-Zuerich                       *
*     CH-8092 Zuerich                   *
*                                       *
****************************************)

(****************************************
* Updates:                              *
****************************************)

IMPLEMENTATION MODULE MVCIO2; (* LG, EK *)
  (* $T- *)

  IMPORT SYSTEM, MVCompiler, MVCPublic, MVCErrors, FileSystem;

  FROM MVCompiler IMPORT Keyarr;
  FROM MVCPublic IMPORT Compilerstatus, compstat, comptime;

  VAR
    lpos,lline : CARDINAL;


    MODULE OutputSystem;

      FROM SYSTEM IMPORT BYTE, WORD;
      FROM MVCompiler IMPORT Symbol;
      FROM MVCPublic IMPORT InterOutFile;
      FROM FileSystem IMPORT WriteByte, WriteShortWord, WriteWord;
      IMPORT pos;

      EXPORT PutSy, PutWord, StopOutput, RestartOutput, TermOutput;

      VAR
        output : BOOLEAN; (* output on InterOutFile allowed *)

      PROCEDURE PutSy(s : Symbol);
        (* put Symbol and pos on InterOutFile *)

      BEGIN
        IF output THEN
          WriteByte ( InterOutFile, BYTE(pos) );
          WriteByte ( InterOutFile, s );
          WriteShortWord ( InterOutFile, 0 );
        END;
      END PutSy;

      PROCEDURE PutWord(w : WORD);
        (* put word on InterOutFile *)

      BEGIN
        IF output THEN
          WriteWord(InterOutFile,w)
        END
      END PutWord;

      PROCEDURE StopOutput;

      BEGIN
        output := FALSE
      END StopOutput;

      PROCEDURE RestartOutput;

      BEGIN
        output := TRUE
      END RestartOutput;

      PROCEDURE TermOutput;

      BEGIN
        PutSy(eop);
      END TermOutput;

    BEGIN
      output := TRUE;
    END OutputSystem;


    MODULE ErrorSystem;

      FROM MVCErrors IMPORT InsertError;
      IMPORT line, pos, lline, lpos;

      EXPORT Error, ErrorLS;

      PROCEDURE Error(n: CARDINAL);

      BEGIN
        InsertError(line,pos,n);
      END Error;

      PROCEDURE ErrorLS(n: CARDINAL);

      BEGIN
        InsertError(lline,lpos,n);
      END ErrorLS;

    END ErrorSystem;


    MODULE Scanner;
      FROM SYSTEM IMPORT BYTE, SHORTWORD;
      FROM MVCompiler IMPORT Symbol, Spellix;
      FROM MVCPublic IMPORT InterInFile, InterOutFile;
      FROM FileSystem IMPORT ReadByte, ReadShortWord, ReadWord,
                             WriteByte, WriteShortWord, WriteWord;
      IMPORT ErrorSystem, OutputSystem,
             sy, spix, maxspix, val, length,
             pos, line, lpos, lline;

      EXPORT GetSy, PutGetSy, TermInput;

      VAR
        lbyte : BYTE;
        lshort: SHORTWORD;
        card : CARDINAL;
        issy : BOOLEAN;

      PROCEDURE GetSy;

      BEGIN (* get next Symbol *)
        lpos := pos;
        lline := line;
        REPEAT
          issy := TRUE;
          ReadByte( InterInFile, lbyte );
          pos := CARDINAL(lbyte);
          ReadByte( InterInFile, sy );
          ReadShortWord( InterInFile, lshort );
          CASE sy OF
            ident: ReadWord( InterInFile, spix ); |
            intcon,cardcon,intcarcon,charcon,realcon: ReadWord(InterInFile,val); |
            stringcon: ReadWord(InterInFile,val);
              ReadWord(InterInFile,length); |
            option: 
              ReadWord(InterInFile,val);
              ReadWord(InterInFile,card);
              PutSy(option);
              PutWord(val);
              PutWord(card);
              issy := FALSE; |
            errorsy,eol: 
              ReadWord(InterInFile,val);
              IF sy = eol THEN
                line := val
              END;
              WriteByte( InterOutFile, pos );
              WriteByte( InterOutFile, sy );
              WriteShortWord( InterOutFile, 0 );
              WriteWord( InterOutFile, val );
              (* no suppression *)
              issy := FALSE;
          ELSE (* no activity *)
          END; (* case *)
        UNTIL issy;
      END GetSy;

      PROCEDURE PutGetSy;

      BEGIN (* put last Symbol, get next Symbol *)
        PutSy(sy);
        IF sy = ident THEN
          PutWord(spix)
        ELSIF (sy >= intcon) AND (sy <= stringcon) THEN
          PutWord(val);
          IF sy = stringcon THEN
            PutWord(length)
          END
        END;
        GetSy;
      END PutGetSy;

      PROCEDURE TermInput;

      BEGIN
      END TermInput;

    BEGIN
      (* Reset(InterInFile); performed by mvcpublic *)
      line := 1;
      pos := 1;
    END Scanner;


    MODULE AsciiHandling;  (* $T- *)
      (* handling with the identifier-table Spelltab *)

      FROM MVCompiler IMPORT spelltab, Spellix;

      EXPORT AsciiSetPos, AsciiRead, TermAscii;

      VAR
        spellpos: Spellix;

      PROCEDURE AsciiSetPos(spix: Spellix);
        (* set position on spelltab *)

      BEGIN
        spellpos := spix;
      END AsciiSetPos;

      PROCEDURE AsciiRead(VAR ch: CHAR);
        (* read character from spelltab *)

      BEGIN
        ch := spelltab[spellpos];
        INC(spellpos);
      END AsciiRead;

      PROCEDURE TermAscii;

      BEGIN
      END TermAscii;

    END AsciiHandling;


    MODULE SkipInSymbolModule;

      FROM MVCompiler IMPORT Symbol;
      FROM Scanner IMPORT GetSy;
      IMPORT sy;

      EXPORT SkipConstant, SkipType;

      PROCEDURE Skip(s: Symbol);

      BEGIN
        WHILE sy <> s DO
          GetSy
        END;
        GetSy;
      END Skip;

      PROCEDURE SkipQualIdent;

      BEGIN
        IF sy = ident THEN
          GetSy;
          WHILE sy = period DO
            GetSy;
            GetSy
          END;
        END;
      END SkipQualIdent;

      PROCEDURE SkipConstant;
        (* skip constant in a symbol module *)

      BEGIN
        IF sy = cardcon THEN
          GetSy;
          SkipQualIdent;
        ELSIF (sy = stringcon) OR (sy = realcon) THEN
          GetSy;
        END;
      END SkipConstant;

      PROCEDURE SkipType;
        (* skip type structures in a symbol module *)

        PROCEDURE SkipVariants;
          (* skip variant structures *)

        BEGIN
          IF sy = casesy THEN
            Skip(colon);
            SkipQualIdent;
            WHILE sy = ofsy DO
              Skip(colon);
              SkipVariants;
              GetSy; (* size *)
            END;
            IF sy = elsesy THEN
              GetSy;
              SkipVariants;
              GetSy; (* size *)
            END;
            GetSy; (* endsy *)
          END;
        END SkipVariants;

      BEGIN (* SkipType *)
        CASE sy OF
          arraysy: Skip(ofsy);
            SkipType; |
          recordsy: 
            GetSy;
            WHILE sy = ident DO
              Skip(colon);
              SkipType
            END;
            SkipVariants;
            GetSy; (* endsy *)
            GetSy; (* size *) |
          setsy,pointersy: GetSy;
            SkipType; |
          proceduresy: 
            Skip(rparent);
            IF sy = colon THEN
              GetSy;
              SkipType
            END; |
          hidden: GetSy; |
          lparent: Skip(rparent); |
          ident: SkipQualIdent; |
          lbrack: Skip(rbrack);
        END;
      END SkipType;

    END SkipInSymbolModule;

  PROCEDURE GetModuleKey(VAR modkey: Keyarr);

    VAR
      ix : CARDINAL;

  BEGIN
    FOR ix := 0 TO 1 DO
      modkey[ix] := comptime[ix]
    END;
  END GetModuleKey;

  PROCEDURE DefModStatus;

  BEGIN
    INCL(compstat,defs);
  END DefModStatus;

  PROCEDURE TermInOut;

  BEGIN
    TermInput;
    TermOutput;
    TermAscii;
  END TermInOut;

END MVCIO2.
