(****************************************
*                                       *
*     MODULA-2 Multi-Pass Compiler      *
*     ****************************      *
*                                       *
*       VAX/VMS Implementation          *
*                                       *
*                                       *
*     MVCMonitor:                       *
*                                       * 
*     Performance Mesurement            *
*                                       * 
*     Version 3.1 of  1-FEB-1983        *
*                                       *
*                                       *
*                                       *
*     Based on PDP11 Implementation:    *
*     Version M22 of 26.02.81           *
*                                       *
*     Institut fuer Informatik          *
*     ETH-Zuerich                       *
*     CH-8092 Zuerich                   *
*                                       *
****************************************)

(****************************************
* No.  0 of 24-JAN-83 by H. Eckhardt    *
* - - - - - - - - - - - - - - - - - - - *
* Updates:                              *
****************************************)

IMPLEMENTATION  MODULE MVCMonitor; (* HE *)

    FROM Measures    IMPORT InitTimer, FreeTimer, GetTimer;

    FROM DateTime     IMPORT TimeType;


    CONST
	MaxEntries =	 7;
	HeaderLen =	25;

    VAR
	Header :	ARRAY [0..MaxEntries-1], [0..HeaderLen-1] OF CHAR;
	CPU ,
	BufIO ,
	DirIO ,
	Pagflt :	ARRAY [0..MaxEntries-1] OF CARDINAL;
	started :	BOOLEAN;
	free :		CARDINAL;
	set :		CARDINAL;

    PROCEDURE CopyString (s1: ARRAY OF CHAR; VAR s2: ARRAY OF CHAR);

    VAR
	i :	CARDINAL;

    BEGIN
      IF HIGH ( s1 ) < HIGH ( s2 ) THEN
        FOR i := 0 TO HIGH ( s1 ) DO
          s2[ i ] := s1[ i ];
        END;
        s2[ i+1 ] := 0C;
      ELSE
        FOR i := 0 TO HIGH ( s2 ) DO
          s2[ i ] := s1[ i ];
        END;
      END;
    END CopyString;


    PROCEDURE StartMonitor;

    BEGIN
      IF MonitEntries < MaxEntries THEN
        InitTimer;
      END;
    END StartMonitor;

    PROCEDURE StopMonitorValues (header: ARRAY OF CHAR);
	(* header serves to identify the measurement 
	 *)

    VAR
	dummy:	TimeType;

    BEGIN
     IF MonitEntries < MaxEntries THEN
      GetTimer ( dummy,
		 CPU[free],
		 BufIO[free],
		 DirIO[free],
		 Pagflt[free]);
      InitTimer;
      CopyString ( header, Header[ free ] );
      INC ( MonitEntries );
      free := (free + 1) MOD MaxEntries;
     END
    END StopMonitorValues;

    PROCEDURE GetMonitorValues (VAR header :	ARRAY OF CHAR;
				VAR cpu :	CARDINAL;
				VAR bufIO :	CARDINAL;
				VAR dirIO :	CARDINAL;
				VAR pagflt :	CARDINAL );

    BEGIN
      IF MonitEntries > 0 THEN
        CopyString ( Header[ set ], header );
        cpu := CPU[ set ];
        bufIO := BufIO[ set ];
        dirIO := DirIO[ set ];
        pagflt := Pagflt[ set ];
        DEC ( MonitEntries );
        set := (set + 1) MOD MaxEntries;
      END;
    END GetMonitorValues;

BEGIN
  MonitEntries := 0;
  started := FALSE;
  free := 0;
  set := 0;
  InitTimer;
END MVCMonitor.
