(****************************************
*                                       *
*     MODULA-2 Multi-Pass Compiler      *
*     ****************************      *
*                                       *
*       VAX/VMS Implementation          *
*                                       *
*                                       *
*     MVCIO4:                           *
*                                       *
*     Input/Output handling in Pass 4   *
*                                       * 
*     Version 3.1 of  1-FEB-1983        *
*                                       *
*                                       *
*                                       *
*     Based on PDP11 Implementation     *
*     Version M22 of 25.02.81           *
*                                       *
*     Institut fuer Informatik          *
*     ETH-Zentrum                       *
*     CH-8092 Zuerich                   *
*                                       *
****************************************)

(****************************************
* Updates:                              *
****************************************)

IMPLEMENTATION MODULE MVCIO4; (* PDP11: A. Gorrengourt / Ch. Jacobi *)
                              (* VAX:   M. Mall                     *)

  IMPORT SYSTEM, MVCompiler, MVCPublic, MVCErrors, MVCLi4, FileSystem;


  MODULE OutputSystem;

    IMPORT FileSystem;
    FROM SYSTEM IMPORT BYTE, SHORTWORD, WORD;
    FROM MVCPublic IMPORT objFile;
    FROM FileSystem IMPORT WriteByte, WriteShortWord, WriteWord;

    EXPORT PutByte, PutShortWord, PutWord, PutRecord;

    PROCEDURE PutByte (b : BYTE);

    BEGIN
      WriteByte(objFile, b);
    END PutByte;

    PROCEDURE PutShortWord (s : SHORTWORD);

    BEGIN
      WriteShortWord(objFile, s);
    END PutShortWord;

    PROCEDURE PutWord (w : WORD);

    BEGIN
      WriteWord(objFile, w);
    END PutWord;

    PROCEDURE PutRecord;

    BEGIN
      FileSystem.PutRecord(objFile);
    END PutRecord;

  END OutputSystem;


  MODULE Scanner;

    FROM SYSTEM IMPORT BYTE, SHORTWORD;
    FROM MVCompiler IMPORT Symbol;
    FROM MVCPublic IMPORT Compilerstatus, compstat, InterInFile;
    FROM MVCLi4 IMPORT EnterLine;
    FROM FileSystem IMPORT ReadByte, ReadShortWord, ReadWord;

    IMPORT sy, val, nptr, csptr, firstsy, pos, line,
           testIndex, testSubrange, debug,
           CompError;

    EXPORT GetSy, StartIO;

    VAR
      check: BOOLEAN;

    PROCEDURE OptionCode;

      VAR
        ch: CHAR;
        lfirstsy: BOOLEAN;

    BEGIN
      ch := CHR(val.value);
      GetSy;
      IF ch = 'T' THEN
        testIndex := (sy = plus) AND check
      ELSIF ch = 'S' THEN
        testSubrange := (sy = plus) AND check
      END;
      lfirstsy := firstsy;
      GetSy;
      firstsy := lfirstsy OR firstsy;
    END OptionCode;

    PROCEDURE GetSy;

      VAR
        k: CARDINAL;
        lbyte: BYTE;
        lshort: SHORTWORD;

    BEGIN (*get next Symbol*)
      firstsy := FALSE;
      REPEAT
        ReadByte( InterInFile, lbyte );
        pos := CARDINAL(lbyte);
        ReadByte( InterInFile, sy);
        ReadShortWord( InterInFile, lshort ); (*?ommit*)
        IF sy = namesy THEN
          ReadWord(InterInFile, nptr );
        ELSIF sy = proceduresy THEN
          ReadWord(InterInFile, nptr);
        ELSIF sy = field THEN
          ReadWord(InterInFile, val)
        ELSIF sy = option THEN
          ReadWord(InterInFile, val);
          OptionCode
        ELSIF sy = anycon THEN
          ReadWord(InterInFile, csptr);
          ReadWord(InterInFile, val)
        ELSIF sy = eol THEN
          ReadWord(InterInFile, line);
          EnterLine;
          firstsy := TRUE;
        ELSIF sy = ident THEN
          CompError
        ELSIF (sy >= intcon) AND (sy <= stringcon) THEN
          CompError
        (*else nothing to do*)
        END;
      UNTIL sy <> eol;
    END GetSy;

    PROCEDURE StartIO;

    BEGIN
      debug := debugs IN compstat;
      check := checks IN compstat;
      testIndex := check;
      testSubrange := check;
    END StartIO;


  END Scanner;


  MODULE ErrorSystem;

    FROM MVCErrors IMPORT HaltMessage, InsertError;
    IMPORT line, pos;

    EXPORT Assert, CompError, Error;

    PROCEDURE Assert (b : BOOLEAN);

    BEGIN
      IF NOT b THEN
        HaltMessage (406)
      END
    END Assert;

    PROCEDURE CompError;

    BEGIN
      HaltMessage (407)
    END CompError;

    PROCEDURE Error (n : CARDINAL);

    BEGIN
      InsertError (line, pos, n);
    END Error;

  END ErrorSystem;


BEGIN (*MVCIO4*)
  line := 0;
END MVCIO4.
