                            n $      DMQ020.B                                                                                                                                                                                                                     DMQ020.B~ BACKUP/LOG/COMM=(DMQ V2.0 base kit) D$DISK:[DMQ$V20.EXAMPLES...]*.*;,D$DISK:[DMQ$V20.LIB...]*.*;,D$DISK:[DMQ$V20.USER.TEMPLATE...]*.*;,D$DISK:[DMQ$V20.DOC...]*.*;,D$DISK:[DMQ$V20.EXE...]*.*;,D$DISK:[DMQ$V20.V10-PATCH...]*.*;,D$KITBLD:BASE.DAT;,BASEIMAGE.DAT;,RTOIMAGE.DAT;,RTO.DAT;/EXCLUDE=(*.EXE,*.MAP,*.LOG)/IGNORE=INTER/BLOCK_SIZE=9000/GROUP_SIZE=25 D$KIT:DMQ020.B/SAVE/REP/INTER  (DMQ V2.0 base kit)  MICHELSEN      p         V5.5 	 _PVAX:: 
   
	  _$1$DIA1:  V5.5 
  $                                  * [DMQ$V20.EXAMPLES]BOUNCE.C;1 +  , B   . <    /     4 O   <   8                    - B    0   1    2   3      K  P   W   O =    5   6 ʕ  7  p  8          9 Z  G    H  J                   /* module DMQ$BOUNCE "DMQ V2.0-01" */
/****************************************************************************/
/*  DECMessageQ for VMS                                                     */
/*                                                                          */
/*  Copyright (c) 1990                                                      */
/*  by DIGITAL Equipment Corporation, Maynard, Mass.                        */
/*                                                                          */
/*  This software is furnished under a license and may be used and  copied  */
/*  only  in  accordance  with  the  terms  of  such  license and with the  */
/*  inclusion of the above copyright notice.  This software or  any  other  */
/*  copies  thereof may not be provided or otherwise made available to any  */
/*  other person.  No title to and ownership of  the  software  is  hereby  */
/*  transferred.                                                            */
/*                                                                          */
/*  The information in this software is subject to change  without  notice  */
/*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  */
/*  Corporation.                                                            */
/*                                                                          */
/*  DIGITAL assumes no responsibility for the use or  reliability  of  its  */
/*  software on equipment which is not supplied by DIGITAL.                 */
/*                                                                          */
/****************************************************************************/



/******************************************/
/* BOUNCE.C Test request/response thruput */
/******************************************/

#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>

#ifndef _NO_PROTO
#define _NO_PROTO 1
#endif

#include "p_entry.h"
#include "p_proces.h"
#include "p_group.h"
#include "p_typecl.h"
#include "p_return.h"
#include "p_symbol.h"

#ifdef QADAPTER_TEST    /* This is to be used with DmQA */
#include "p_dmqa.h"
#define NULLARG 0L
#define SB_STRUCT (char *)
#ifndef PAMS__RESRCFAIL
#define PAMS__RESRCFAIL -246
#endif
#else
#define NULLARG (char *)0
#define SB_STRUCT (struct show_buffer *)
#endif

long attach_mode = PSYM_ATTACH_TEMPORARY;
long q_type = PSYM_ATTACH_PQ;

struct PAMS_PSB
{
   short int type;
   short int cd;
   long int del_status;
   long int seq[2];
   long int uma_status;
   long int unused[3];
} ;

typedef union
{
   struct 
   {
      short process;
      short group;
   } au;
   long all;
} PAMS_ADDRESS;

PAMS_ADDRESS         req_queue_num;        
PAMS_ADDRESS         new_queue_num;        

struct SHOW_BUF_STRUCT
{
   long version;
   long del_status;
   long size;
   long reserved[7];
   PAMS_ADDRESS tgt;
   PAMS_ADDRESS orig_tgt;
   PAMS_ADDRESS src;
   PAMS_ADDRESS orig_src;
   long delmode;
   long prio;
};

static long      loop       = 1;

/*********************************/
/* counters                      */
/*********************************/
long int prev_count        = 0;
long int receive_count     = 0;
long int send_count        = 0;
long int timing_count      = 0;

/*********************************/
/* switches                      */
/*********************************/
long int do_trace          = 0;
long int do_recover        = 0;
long int test_function     = 0;

/*********************************/
/* other                         */
/*********************************/
long int test_iterations   = 0;
long int report_interval   = 100;
long int time_prev         = 0;
long int time_start        = 0;

/*********************************/
/* Terminal input buffer         */
/*********************************/
char answer[256];

#define MAX_SIGNED_INTEGER 0x1fffffff

char forcej      = PDEL_DEFAULT_JRN;
long int confval = 0;

char	q_name[4];
long	q_name_len;

#define MSG_TYPE_TEST_SHUTDOWN -1



#define MSTR(x,y) case (x) : mstrc = y; break;

static char *get_sym_str( sym )
long int sym;
{
	char *mstrc;                   
	char symbuf[80];

	switch (sym)
	{
	MSTR(PAMS__SUCCESS, "PAMS__SUCCESS");
	MSTR(PAMS__DISC_SUCCESS, "PAMS__DISC_SUCCESS");
	MSTR(PAMS__DISCL_SUCCESS, "PAMS__DISCL_SUCCESS");
	MSTR(PAMS__RESRCFAIL, "PAMS__RESRCFAIL");
	MSTR(PAMS__DLJ_SUCCESS, "PAMS__DLJ_SUCCESS");
	MSTR(PAMS__DLQ_SUCCESS, "PAMS__DLQ_SUCCESS");
	MSTR(PAMS__RTS_SUCCESS, "PAMS__RTS_SUCCESS");
	MSTR(PAMS__SAF_SUCCESS, "PAMS__SAF_SUCCESS");

	MSTR(PAMS__NOMOREMSG, "PAMS__NOMOREMSG");
	MSTR(PAMS__NOSEND, "PAMS__NOSEND");
	MSTR(PAMS__WAKEFAIL, "PAMS__WAKEFAIL");
	MSTR(PAMS__TIMERACT, "PAMS__TIMERACT");
	MSTR(PAMS__MSGACT, "PAMS__MSGACT");
	MSTR(PAMS__NO_UMA, "PAMS__NO_UMA");
	MSTR(PAMS__UMA_NA, "PAMS__UMA_NA");
	MSTR(PAMS__TRACEBACK, "PAMS__TRACEBACK");
	MSTR(PAMS__STORED, "PAMS__STORED");
	MSTR(PAMS__ENQUEUED, "PAMS__ENQUEUED");
	MSTR(PAMS__UNATTACHEDQ, "PAMS__UNATTACHEDQ");
	MSTR(PAMS__CONFIRMREQ, "PAMS__CONFIRMREQ");
	MSTR(PAMS__PROPAGATE, "PAMS__PROPAGATE");
	MSTR(PAMS__ABORT, "PAMS__ABORT");
	MSTR(PAMS__BADDECLARE, "PAMS__BADDECLARE");
	MSTR(PAMS__BADFREE, "PAMS__BADFREE");
	MSTR(PAMS__TIMEOUT, "PAMS__TIMEOUT");
	MSTR(PAMS__ACKTMO, "PAMS__ACKTMO");
	MSTR(PAMS__MSGUNDEL, "PAMS__MSGUNDEL");
	MSTR(PAMS__EX_Q_LEN, "PAMS__EX_Q_LEN");
	MSTR(PAMS__POSSDUPL, "PAMS__POSSDUPL");
	MSTR(PAMS__STUB, "PAMS__STUB");
	MSTR(PAMS__SENDER_TMO_EXPIRED, "PAMS__SENDER_TMO_EXPIRED");
	MSTR(PAMS__MRQTBLFULL, "PAMS__MRQTBLFULL");
	MSTR(PAMS__NOTALLOCATE, "PAMS__NOTALLOCATE");
	MSTR(PAMS__BIGBLKSIZE, "PAMS__BIGBLKSIZE");
	MSTR(PAMS__MSGTOBIG, "PAMS__MSGTOBIG");
	MSTR(PAMS__INVALIDID, "PAMS__INVALIDID");
	MSTR(PAMS__INVFORMAT, "PAMS__INVFORMAT");
	MSTR(PAMS__INVBUFFPTR, "PAMS__INVBUFFPTR");
	MSTR(PAMS__INVALIDNUM, "PAMS__INVALIDNUM");
	MSTR(PAMS__BIGMSG, "PAMS__BIGMSG");
	MSTR(PAMS__MSGTOSMALL, "PAMS__MSGTOSMALL");
	MSTR(PAMS__AREATOSMALL, "PAMS__AREATOSMALL");
	MSTR(PAMS__NOCANSEND, "PAMS__NOCANSEND");
	MSTR(PAMS__NOTACTIVE, "PAMS__NOTACTIVE");
	MSTR(PAMS__EXCEEDQUOTA, "PAMS__EXCEEDQUOTA");
	MSTR(PAMS__BADPRIORITY, "PAMS__BADPRIORITY");
	MSTR(PAMS__BADDELIVERY, "PAMS__BADDELIVERY");
	MSTR(PAMS__BADJOURNAL, "PAMS__BADJOURNAL");
	MSTR(PAMS__BADPROCNUM, "PAMS__BADPROCNUM");
	MSTR(PAMS__BADTMPPROC, "PAMS__BADTMPPROC");
	MSTR(PAMS__BADSYNCHNUM, "PAMS__BADSYNCHNUM");
	MSTR(PAMS__BADTMPSYNCH, "PAMS__BADTMPSYNCH");
	MSTR(PAMS__BADRECEIVE, "PAMS__BADRECEIVE");
	MSTR(PAMS__BADTIME, "PAMS__BADTIME");
	MSTR(PAMS__NOTDCL, "PAMS__NOTDCL");
	MSTR(PAMS__STATECHANGE, "PAMS__STATECHANGE");
	MSTR(PAMS__INVUCBCNTRL, "PAMS__INVUCBCNTRL");
	MSTR(PAMS__NOLINK, "PAMS__NOLINK");
	MSTR(PAMS__CIRACT, "PAMS__CIRACT");
	MSTR(PAMS__PROTOCOL, "PAMS__PROTOCOL");
	MSTR(PAMS__COMMERR, "PAMS__COMMERR");
	MSTR(PAMS__BADSELIDX, "PAMS__BADSELIDX");
	MSTR(PAMS__IDXTBLFULL, "PAMS__IDXTBLFULL");
	MSTR(PAMS__BADPARAM, "PAMS__BADPARAM");
	MSTR(PAMS__NOMRS, "PAMS__NOMRS");
	MSTR(PAMS__DISC_FAILED, "PAMS__DISC_FAILED");
	MSTR(PAMS__DISCL_FAILED, "PAMS__DISCL_FAILED");
	MSTR(PAMS__DLJ_FAILED, "PAMS__DLJ_FAILED");
	MSTR(PAMS__DLQ_FAILED, "PAMS__DLQ_FAILED");
	MSTR(PAMS__DQF_DEVICE_FAIL, "PAMS__DQF_DEVICE_FAIL");
	MSTR(PAMS__INVUMA, "PAMS__INVUMA");
	MSTR(PAMS__DQF_FULL, "PAMS__DQF_FULL");
	MSTR(PAMS__INVJH, "PAMS__INVJH");
	MSTR(PAMS__LINK_DOWN, "PAMS__LINK_DOWN");
	MSTR(PAMS__BADSEQ, "PAMS__BADSEQ");
	MSTR(PAMS__NOTJRN, "PAMS__NOTJRN");
	MSTR(PAMS__MRS_RES_EXH, "PAMS__MRS_RES_EXH");
	MSTR(PAMS__NOMOREJH, "PAMS__NOMOREJH");
	MSTR(PAMS__REJECTED, "PAMS__REJECTED");
	MSTR(PAMS__NOSUCHPCJ, "PAMS__NOSUCHPCJ");
	MSTR(PAMS__UCBERROR, "PAMS__UCBERROR");
	MSTR(P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          gSw $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]BOUNCE.C;1                                                                                                   O     <                         V
 "            AMS__BADUMA, "PAMS__BADUMA");
	MSTR(PAMS__BADRESPQ, "PAMS__BADRESPQ");
	MSTR(PAMS__BADARGLIST, "PAMS__BADARGLIST");
	MSTR(PAMS__NO_DQF, "PAMS__NO_DQF");
	MSTR(PAMS__NO_SAF, "PAMS__NO_SAF");
	MSTR(PAMS__RTS_FAILED, "PAMS__RTS_FAILED");
	MSTR(PAMS__SAF_DEVICE_FAIL, "PAMS__SAF_DEVICE_FAIL");
	MSTR(PAMS__SAF_FAILED, "PAMS__SAF_FAILED");
	MSTR(PAMS__BADLOGIC, "PAMS__BADLOGIC");
	MSTR(PAMS__SELRCVACT, "PAMS__SELRCVACT");
	MSTR(PAMS__NOMRQRESRC, "PAMS__NOMRQRESRC");
	MSTR(PAMS__BADASSIGN, "PAMS__BADASSIGN");
	MSTR(PAMS__LOGNAME, "PAMS__LOGNAME");
	MSTR(PAMS__LOGNAME2, "PAMS__LOGNAME2");
	MSTR(PAMS__LOGNAME3, "PAMS__LOGNAME3");
	MSTR(PAMS__LOGNAME4, "PAMS__LOGNAME4");
	MSTR(PAMS__LOGNAME5, "PAMS__LOGNAME5");
	MSTR(PAMS__NOOPEN, "PAMS__NOOPEN");
	MSTR(PAMS__BADSCRIPT, "PAMS__BADSCRIPT");
	MSTR(PAMS__DECLARED, "PAMS__DECLARED");
	MSTR(PAMS__EXHAUSTBLKS, "PAMS__EXHAUSTBLKS");
	MSTR(PAMS__INTERNAL, "PAMS__INTERNAL");
	MSTR(PAMS__QUECORRUPT, "PAMS__QUECORRUPT");
	MSTR(PAMS__REMQUEFAIL, "PAMS__REMQUEFAIL");
	MSTR(PAMS__INSQUEFAIL, "PAMS__INSQUEFAIL");
	MSTR(PAMS__CREATEFAIL, "PAMS__CREATEFAIL");
	MSTR(PAMS__DCLTMPFAIL, "PAMS__DCLTMPFAIL");
	MSTR(PAMS__PAMSDOWN, "PAMS__PAMSDOWN");
	MSTR(PAMS__BADASTPARM, "PAMS__BADASTPARM");
	MSTR(PAMS__NOQUOTA, "PAMS__NOQUOTA");
	MSTR(PAMS__NOTPRIMARYQ, "PAMS__NOTPRIMARYQ");
             
	default:
	   (void) sprintf(symbuf, "PAMS__UNEXPECTED - %d", sym );
	   mstrc = symbuf;

	}                 

	return (mstrc);
}



static long int check_psb( lpsb )
struct PAMS_PSB *lpsb;
{
        /****************************************************/
        /* Return 1 iff the message was successfully queued */
        /****************************************************/
        if ( (lpsb->del_status == PAMS__SUCCESS  )
        ||   (lpsb->del_status == PAMS__STORED   )
        ||   (lpsb->del_status == PAMS__ENQUEUED ) )
        {
           return ( 1 );
        }
        else if (lpsb->uma_status == PAMS__SAF_SUCCESS )
        {
           return ( 1 );
        }
        return ( 0 );
}

#define RCV 0L
#define SND 1L

static long int trace_msg( srind, qaddr, ilen, lpsb )
int srind;
long qaddr;
short ilen;
struct PAMS_PSB *lpsb;
{
   char *c1, *c2;
   PAMS_ADDRESS qa;

        qa.all = qaddr;

        switch (srind)
        {
        case SND:
           c1 = "Send";
           c2 = "to  ";
           break;

        case RCV:
           c1 = "Recv";
           c2 = "from";
           break;

        default:
           return ( 0 );
        }

        printf("%s,Seq:(%x,%x) %s (%d.%d) Len:%u\n",
                 c1, 
                 lpsb->seq[0],lpsb->seq[1], 
                 c2,
                 qa.au.group, qa.au.process,
                 ilen);

        if ( lpsb->del_status != PAMS__SUCCESS  )
        {
           printf("PSB status: %s\n", get_sym_str( lpsb->del_status ) );
        }

        if (lpsb->uma_status != PAMS__UMA_NA )
        {
           printf("UMA status: %s\n", get_sym_str( lpsb->uma_status ) );
        }
        printf ("\n");
        return ( 1 );
}



static long int scale_interval(interval, delta )
long int interval;
long int delta;
{

  double fdelta;
  double finterval;
  double fscale;

  long int new_interval;
                
        /*****************************************************************/
        /* scale the new interval so that delta is close to 10.0 seconds */
        /*****************************************************************/
        if (delta == 0) return ( interval );        /* not expected... */

        fdelta     = (double)delta;
        finterval  = (double)interval;

        fscale     = 10.0 / fdelta;
        finterval  = fscale * finterval + .5;        /* round up to int */

        new_interval  = (long int)finterval;

        return ( new_interval );
}



static double calculate_rate( msgs, delta )
long int msgs;
long int delta;
{
   double fmsgs;   
   double fdelta;
   double frate;

        if (delta == 0) return ( 0 );

        fmsgs  = (double)msgs;
        fdelta = (double)delta;

        frate  = fmsgs / fdelta;

        return ( frate );
}
        


static long int show_count()
{ 
  long int time_now;
  long int incr;
  long int time_delta;
  double   rate;


        incr=receive_count - prev_count;        

        /***************************************************/
        /* Get the time in seconds since UNIX was invented */
        /***************************************************/
        (void) time(&time_now);

        if (time_prev)
        {
           /**************************/
           /* Calculate elapsed time */
           /**************************/
           time_delta = time_now - time_prev;

           if (time_delta > 0)
           {
              /*********************************************/
              /* Calculate the message rate and display it */
              /*********************************************/
              rate       = calculate_rate( incr, time_delta );

              printf(
              "%3.3d sec\tTotal rcvd:\t%d\tIncr:\t%d\t%3.3f/sec\n",
                 time_delta,receive_count,incr, rate);
           }

           /******************************************************/
           /* Set the next report interval so that reports occur */
           /* close to every 10 seconds.                         */
           /******************************************************/
           report_interval = scale_interval( report_interval, time_delta );
        }

        prev_count = receive_count;
        time_prev = time_now;

        return ( 1 );
}



static long int check_ret(stsvalue)
long int stsvalue;
{
        if (stsvalue & 1) return (1);

        printf("%s\n", get_sym_str( stsvalue ) );
        return(0);
}



static long int get_number( prompt, low, high )
char *prompt;
long int low;
long int high;
{
   long int iout;

        if ( high < low ) high = MAX_SIGNED_INTEGER;

        while ( loop )
        {
           printf( prompt );
#ifdef AS400
	printf("\n");
#endif
           gets( answer );
           iout = atoi(answer);
           if ( ( iout<low ) || ( iout>high) ) 
           {
              printf("Input a number from %d to %d\n", low, high );
              continue;
           }
           break;
        }
        return ( iout );
}


#ifdef VMS
/*************************************************/
/* static main can fit into VMS object libraries */
/* without clashing with other main programs     */
/*************************************************/
static main(argc, argv)
int argc;
char *argv[];

#else

main(argc,argv)
int argc;
char *argv[];

#endif
{
   long int status;
   long int time_now;
   double   rate;
   long int time_delta;

   long int confirmreq = 0;

   /**************************/
   /* pams_put_msg variables */
   /**************************/

   PAMS_ADDRESS send_target;
   short send_length   = 0;
   char  send_delivery = 0;
   long  send_timeout  = 0;
   char  send_uma      = 0;

   /****************************************/
   /* pams get msg variables               */
   /****************************************/
   struct SHOW_BUF_STRUCT show_buf;
   long int show_buf_len = sizeof(struct SHOW_BUF_STRUCT);

   struct PAMS_PSB  lpsb;
   char             msg_area[32000]; 

   long int         timeout           = 0;
   q_address	    source;
   char             prio              = 0;
   short            class             = 0;
   short            type              = 0;
   short int        length            = 0;

   short int        max_len = sizeof(msg_area);
   short int        sel_addr[2];

   int i;
   long istat;

   /*********************************/
   /* Functions used by this module */
   /*********************************/
   /* extern long int check_psb( struct PAMS_PSB *); */



        /******************************/
        /* Handle any BOUNCE switches */
        /******************************/
        for (i=1; i<argc; i++ )
        {
           if ( strcmp(argv[i], "trace"  ) == 0 ) do_trace = 1;
        }

        /******************************/
        /* Prompt for test parameters */
        /******************************/
        while ( loop )
        {
	   req_queue_num.all = 0;
           req_queue_num.au.process = get_number(
              "BOUNCE queue number?  0 = assign temp queue; -1 means exit :",
	      -1, 999 );

	   if (req_queue_num.au.process == -1)
	   {
		(void) pams_exit();
		exit(1);
	    }

	    else if (req_queue_num.au.process)
	    {
		attach_mode = PSYM_ATTACH_BY_NUMBER;
		(void) sprintf(q_name, "%d", req_queue_num.au.process);
		q_name_len = strlen(q_name);
		
		status = pams_attach_q(&attach_mode,
                                                                                                                                                                                                                                                                             *6 $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]BOUNCE.C;1                                                                                                   O     <                         ˓ "     !                                       (q_address *) &new_queue_num.all,
                                  &q_type,
                                  q_name,
                                  &q_name_len,
				  (long *)0,
                                  (long *)0, (char *)0,
                                  (char *)0, (char *)0);
	    }

	    else
	    {
		status = pams_attach_q(&attach_mode,
                                  (q_address *) &new_queue_num.all,
                                  &q_type,
                                  (char *)0,
                                  (long *)0, (long *)0,
                                  (long *)0, (char *)0,
                                  (char *)0, (char *)0);
	    }
                                  
           if (!check_ret(status)) continue;        /* TRY AGAIN */
           break;
        }

        printf("Declared as (%d.%d)\n", 
           new_queue_num.au.group, new_queue_num.au.process );


        test_function = get_number(
              "1 = send, 2 = recv, 3 = shutdown            :", 1, 3 );
        
        switch ( test_function )
        {
        case 1:
           send_target.au.group = get_number(
              "Target group number?                        :", 0, 32000 );

           send_target.au.process = get_number(
              "Target queue number?                        :", 1, 999 );

           break;

        case 2:
           send_target.all = 0;
           break;

        case 3:
           goto DO_SHUTDOWN;
        }

        if ( test_function == 1 )
        {
           send_length = get_number(
              "message_length?                             :", 0, 32000 );

           do_recover = get_number(
              "Send recoverable messages? 0 = no, 1 = yes  :", 0, 1);

           test_iterations = get_number(
              "Test iterations? 0 = loop forever           :", 
              0, MAX_SIGNED_INTEGER );
        }

        sel_addr [0] = sel_addr [1] = 0;

        /************************************/
        /* Wait till user tells us to start */
        /************************************/
        printf("<CR> to start:");
#ifdef AS400
	printf("\n");
#endif
        gets( answer );


        /*********************/
        /* Main message loop */
        /*********************/
        prio = timeout = 0;
        max_len = 32000;

        receive_count = 0;

        if (send_target.all )
        {
           /***************************/
           /* Drain the primary queue */
           /***************************/
           while (loop)
           {
              status = pams_get_msg(msg_area,
                        &prio,
			&source.all,
                        &class,
			&type, 
                        &max_len,
			&length,
                        (long *) sel_addr,
                        (struct psb *) &lpsb, 
                        SB_STRUCT &show_buf,
			&show_buf_len, 
                        (char *)0,
                        NULLARG,
                        NULLARG);

#ifdef BOUNCE_DEBUG                        
              (void) printf(
                "source = %d.%d, orig source = %d.%d, class = %d, type = %d\n",
                        source.au.group,
                        source.au.queue,
                        show_buf.orig_src.au.group,
                        show_buf.orig_src.au.process,
                        class, type);
#endif

              if (status == PAMS__NOMOREMSG) break;

              if (!check_ret(status)) return(status);

              if ( ( lpsb.del_status == PAMS__CONFIRMREQ )
              ||   ( lpsb.del_status == PAMS__POSSDUPL   ) )
              {
                 istat = pams_confirm_msg(lpsb.seq, &confval, &forcej );
              }
           }

           /**************************************/
           /* Send the first message in the test */
           /**************************************/
           prio  = 0;
           class = 0;
           type  = 0;
        
           if (do_recover)
           {
              send_delivery = PDEL_MODE_WF_DQF;
              send_uma      = PDEL_UMA_SAF;
              report_interval = 10;
           }

           status = pams_put_msg(msg_area,
                                  &prio,
                                  (long *) &send_target.all,
                                  &class,
                                  &type, 
                                  &send_delivery, 
                                  &send_length,
                                  &send_timeout, 
                                  (struct psb *) &lpsb, 
                                  &send_uma, 
                                  0L,
                                  NULLARG,
                                  NULLARG,
                                  NULLARG); 

#ifdef BOUNCE_DEBUG                        
              (void) printf(
                "PUT: target = %d.%d, class = %d, type = %d\n",
                        send_target.au.group,
                        send_target.au.process,
                        class, type);
#endif

           if (!check_ret(status))
	   {
		(void) pams_exit();
		return(status);
	   }

           if (!check_psb( (struct PAMS_PSB *)&lpsb ) )
           {
              status = lpsb.del_status;

              (void) trace_msg( SND, send_target.all,
                                    send_length,
                                    (struct PAMS_PSB *) &lpsb );
	      (void) pams_exit();
              return(status);
           }

           send_count++;

           if (do_trace)
                (void) trace_msg( SND, send_target.all,
                                    send_length,
                                    (struct PAMS_PSB *) &lpsb );
        }

        while ( loop )
        {

           confirmreq = 0;
           status = pams_get_msgw(msg_area,
                        &prio,
			&source,
                        &class,
			&type, 
                        &max_len,
			&length,
                        &timeout,
			(long *) sel_addr,
                        (struct psb *) &lpsb, 
                        SB_STRUCT &show_buf,
			&show_buf_len, 
                        (char *)0,
                        NULLARG,
                        NULLARG);
              
#ifdef BOUNCE_DEBUG                        
              (void) printf(
                "source = %d.%d, orig source = %d.%d, class = %d, type = %d\n",
                        source.au.group,
                        source.au.queue,
                        show_buf.orig_src.au.group,
                        show_buf.orig_src.au.process,
                        class, type);
#endif

           if (!check_ret(status))
	   {
		(void) pams_exit();
	        return(status);
	   }

           ++receive_count;

           if ( ( lpsb.del_status == PAMS__CONFIRMREQ )
           ||   ( lpsb.del_status == PAMS__POSSDUPL   ) )
           {
              istat = pams_confirm_msg(lpsb.seq, &confval, &forcej );
              confirmreq = 1;
           }

           if (!time_start)
           {
              /*************************/
              /* record the start time */
              /*************************/
              (void) time(&time_start);
           }

           if (type == MSG_TYPE_TEST_SHUTDOWN )
	   {
		(void) pams_exit();
		break;
	   }

           ++timing_count;
           if (timing_count >= report_interval )
           {
              timing_count = 0;
              show_count();
           }

           if ( do_trace )
                (void) trace_msg(   RCV, source,
                                    length,
                                    (struct PAMS_PSB *) &lpsb );

           /*********************************************************/
           /* Here, we should have received as many messages        */
           /* as we have sent. So... if the receive count matches   */
           /* the desired number of repetitions, then we're done    */
           /*********************************************************/
           if (test_iterations)
              if (receive_count >= test_iterations )
	      {
		(void) pams_exit();
		break;
	      }

           prio  = 0;
           class = 0;
           type  = 0;

           if ( (do_recover) || (confirmreq ) )
           {
              send_delivery = PDEL_MODE_WF_DQF;
              send_uma      = PDEL_UMA_SAF;
           }

           /****************************************************/
           /* reflect this message back to the original source */
           /****************************************************/

           status = pams_put_msg(msg_area,
                                                                                                                                                                                                                                                                                                1Z/ $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]BOUNCE.C;1                                                                                                   O     <                               2                    &prio,
                                  (long *) &source,
                                  &class,
                                  &type, 
                                  &send_delivery, 
                                  &length,
                                  &send_timeout, 
                                  (struct psb *) &lpsb, 
                                  &send_uma, 
                                  0L,
                                  NULLARG,
                                  NULLARG,
                                  NULLARG); 

#ifdef BOUNCE_DEBUG                        
              (void) printf(
                "PUT: target = %d.%d, class = %d, type = %d\n",
                        source.au.group,
                        source.au.queue,
                        class, type);
#endif

           if (!check_ret(status))
	   {
		(void) pams_exit();
	        return(status);
	   }

           if (!check_psb( (struct PAMS_PSB *)&lpsb ) )
           {
              status = lpsb.del_status;
              (void) trace_msg( SND, source,
                                    send_length,
                                    (struct PAMS_PSB *) &lpsb );
	      (void) pams_exit();
              return(status);
           }

           if (do_trace)
                (void) trace_msg(  SND, source,
                                    length,
                                    (struct PAMS_PSB *) &lpsb );

           send_count++;

        }

        if (test_function == 1 )
        {
           (void) time(&time_now);        
           time_delta = time_now - time_start;

           rate = calculate_rate( receive_count, time_delta );

           printf("\nTest done: sent:%d rcvd:%d rate:%3.3f/sec\n", 
              send_count, receive_count, rate);
           goto DO_SHUTDOWN;
        }

	(void) pams_exit();
        return ( 1 );



DO_SHUTDOWN:
        while (loop)
        {
           test_function = get_number(
              "Shutdown a test program? 0 = no, 1 = yes    :", 0,1);    

           if (!test_function)
	   {
		(void) pams_exit();
	         break;
	   }

           send_target.au.group = get_number(
              "group number?                               :", 0, 32000 );

           send_target.au.process = get_number(
              "queue number?  0 = done                     :", 1, 999 );

           type = MSG_TYPE_TEST_SHUTDOWN;
           send_delivery = 0;
           send_uma      = 0;

           status = pams_put_msg(msg_area,
                                  &prio,
                                  (long *) &send_target.all,
                                  &class,
                                  &type, 
                                  &send_delivery, 
                                  &length,
                                  &send_timeout, 
                                  (struct psb *) &lpsb, 
                                  &send_uma, 
                                  0L,
                                  NULLARG,
                                  NULLARG,
                                  NULLARG); 

#ifdef BOUNCE_DEBUG                        
              (void) printf(
                "PUT: target = %d.%d, class = %d, type = %d\n",
                        send_target.au.group,
                        send_target.au.process,
                        class, type);
#endif

           if (!check_ret(status))
	   {
		(void) pams_exit();
		return(status);
	   }
        } 

	(void) pams_exit();
        return ( 1 );
}

                                                  & * [DMQ$V20.EXAMPLES]BUILD_EXAMPLES.COM;1 +  , B   .     /     4 &                         - B    0   1    2   3      K  P   W   O     5   6 `E5斕  7  ۖp  8          9 Z  G    H  J                         	 $ set ver & $ for pamsample.for + dmq$user:dmq/lib  $ link pamsample,dmq$lib:dmq/opt $ cobol cobol_receiver $ cobol cobol_sender& $ link  cobol_receiver,dmq$lib:dmq/opt& $ link  cobol_sender  ,dmq$lib:dmq/opt $ cc/include=dmq$user sender.c $ link sender,dmq$lib:dmq/opt " $ cc/include=dmq$user getmsg_ast.c! $ link getmsg_ast,dmq$lib:dmq/opt ! $ cc/include=dmq$user getmsg_ef.c   $ link getmsg_ef,dmq$lib:dmq/opt $ cc/include=dmq$user ttast.c  $ link ttast,dmq$lib:dmq/opt$ $ cc/include=dmq$user dmq$mrq_test.c# $ link dmq$mrq_test,dmq$lib:dmq/opt ! $ cc/include=dmq$user dmq$qmenu.c   $ link dmq$qmenu,dmq$lib:dmq/opt $ cc/include=dmq$user simple.c $ link simple,dmq$lib:dmq/opt # $ cc/include=dmq$user pamsample_c.c " $ link pamsample_c,dmq$lib:dmq/opt$ $ cc/include=dmq$user put_wf_reply.c# $ link put_wf_reply,dmq$lib:dmq/opt   $ cc/include=dmq$user watchdog.c $ link watchdog,dmq$lib:dmq/opt  $ set nover                                                                                                                   0 * [DMQ$V20.EXAMPLES]BUILD_PAMS_TASK_EXAMPLES.COM;1 +  , B   .     /     4 J                          - B    0   1    2   3      K  P   W   O     5   6 ^Bi  7  p  8          9 Z  G    H  J               % $! File: BUILD_PAMS_TASK_EXAMPLES.COM  $!9 $! Compiles and links units nessesary for simple tasking. J $! Assumes Ada program library has been set.  Also assumes the DECmessageQ $! logical DMQ$LIB is defined. $!! $ WRITE SYS$OUTPUT "Compiling..."  $ ADA PAMS_TASK_PKG_ $ ADA PAMS_TASK_PKG  $ ADA PAMS_TASK_TESTER $ ADA PAMS_TASK_SENDER $! $ WRITE SYS$OUTPUT "Linking..." + $ ACS LINK PAMS_TASK_TESTER DMQ$LIB:DMQ/OPT + $ ACS LINK PAMS_TASK_SENDER DMQ$LIB:DMQ/OPT                                                   - * [DMQ$V20.EXAMPLES]BUILD_PASCAL_PEN_FILE.COM;1 +  , B   .     /     4 N       0                    - B    0   1    2   3      K  P   W   O     5   6 wg  7 `Rp  8          9 Z  G    H  J                   $!9 $! This command stream pulls in Pascal include files from 4 $! the DMQ$USER directory and creates a pre-compiled  $! environment from these files.! $! CREATED ON: 11-Oct-1989 by TCS  $!N $! -----------------Build PRECOMPILED UNIT OF PASCAL INCLUDE FILES------------ $!A $ WRITE SYS$OUTPUT "  Building the module to be pre-compiled... "  $!! $ DEFINE/USER_MODE SYS$OUTPUT NL:  $! $ EDIT/EDT/COMMAND=NL: PAMS.PAS  DEL WH I; MODULE PAMS; : I; (* PRECOMPILED PASCAL INCLUDE FILES...              *) 9 I; (* File name:     PAMS.PAS                          *) 9 I; (*                                                  *)  INC DMQ$USER:PAISYMPAS.TXT INC DMQ$USER:PAIPRCPAS.TXT INC DMQ$USER:PAIGRPPAS.TXT INC DMQ$USER:PAITYPPAS.TXT INC DMQ$USER:PAISTSDPAS.TXT " INC DMQ$USER:HIDDEN_DATA_TYPES.PAS INC DMQ$USER:PAIENTPAS.TXT I; END.  EXIT $!1 $! compile the file PAMS.PAS with the environment ; $! qualifier;thus, creating the Environment file (PAMS.PEN)  $!9 $ WRITE SYS$OUTPUT "  Compiling PAMS environment file..."  $ PASCAL/ENVIRONMENT PAMS  $! $ EXIT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & * [DMQ$V20.EXAMPLES]COBOL_RECEIVER.COB;1 +  , B   .     /     4 L       r                   - B    0   1    2   3      K  P   W   O     5   6 Y
-  7 `p  8          9 Z  G    H  J                          IDENTIFICATION DIVISION. PROGRAM-ID. RECEIVER.  *++  *  * PROGRAM ABSTRACT:  *	$COB COBOL_RECEIVER	 * & *	$LINK COBOL_RECEIVER,DMQ$LIB:DMQ/OPT * 7 *	For PAMS tracing define the following before running: & *	$DEFINE DMQ$SCRIPT DMQ$EXAMPLES:ECHO *	$DEFINE DMQ$DEBUG  TRACE * < *       THIS PROGRAM WILL ALWAYS DECLARE A QUEUE 1.  SO WHEN? *       SENDING RECOVERABLY MAKE SURE THERE IS DQF FOR QUEUE 1.  *  *  *    ENVIRONMENT DIVISION.  CONFIGURATION SECTION. DATA DIVISION. WORKING-STORAGE SECTION.+ 01  RETURN-STATUS			PIC S9(09) COMP GLOBAL. 1     88  SS_NORMAL			VALUE IS EXTERNAL SS$_NORMAL.   % 01  WS-MESSAGE				PIC X(1028) GLOBAL.   2 01  WS-MESSAGE-LENGTH			PIC S9(04) COMP VALUE 300. 01  MSN-DISP				PIC X(9).    01  WS-TEXT-AREA			PIC X(80).  01  MESSAGE-LENGTH 			PIC 999. 01  WS-WORD				PIC 9(04).     01  SR-OPT				PIC X VALUE SPACE.6 01  WS-TARGET-PAMS-GROUP-NAME		PIC X(15) VALUE SPACES.2 01  WS-TARGET-PAMS-GROUP		PIC S9(09) COMP VALUE 0.4 01  WS-TARGET-PAMS-PROCESS		PIC S9(09) COMP VA`                                                                                                                                           M $      DMQ020.B                       B  B  &[DMQ$V20.EXAMPLES]COBOL_RECEIVER.COB;1                                                                                         L                                          LUE 0.  01  SAVE-MSN				PIC S9(18) COMP., 01  CONFIRM-VAL				PIC S9(9) COMP VALUE 123.   * For the PAMS_ATTACH_Q call.  01  PDP_FIELDS.      02  REQ-PROCESS-NUM-WORDS.5 	04  REQ-PROCESS-NUM-PROCESS	PIC S9(04) COMP VALUE 0. + 	04  REQ-PROCESS-NUM-GROUP	PIC S9(04) COMP. !     02  REQ-PROCESS-NUM REDEFINES ' 	REQ-PROCESS-NUM-WORDS	PIC S9(09) COMP.      02  PROCESS-NUM-WORDS.) 	04  PROCESS-NUM-PROCESS	PIC S9(04) COMP. ' 	04  PROCESS-NUM-GROUP	PIC S9(04) COMP.      02  PROCESS-NUM REDEFINES $ 	PROCESS-NUM-WORDS		PIC S9(09) COMP.8     02  ATTACH_MODE                     PIC S9(09) COMP.8     02  Q_TYPE                          PIC S9(09) COMP.2     02  Q_NAME                          PIC X(31).8     02  Q_NAME_LEN                      PIC S9(09) COMP.   * For the PAMS_GET_MSGW call.  01  PGM-FIELDS. &     02  PGM-PRIORITY			PIC S9(9) COMP.     02  PGM-SOURCE-WORDS. ) 	04  PGM-SOURCE-PROCESS		PIC S9(04) COMP. ' 	04  PGM-SOURCE-GROUP		PIC S9(04) COMP. >     02  PGM-SOURCE REDEFINES PGM-SOURCE-WORDS	PIC S9(09) COMP.$     02  PGM-CLASS			PIC S9(04) COMP.#     02  PGM-TYPE			PIC S9(04) COMP. *     02  PGM-MSG-AREA-LEN		PIC S9(04) COMP.'     02  PGM-LEN-DATA			PIC S9(04) COMP. &     02  PGM-TIMEOUT			PIC S9(09) COMP.'     02  PGM-SEL-ADDR			PIC S9(09) COMP.      02  PGM-PSB. 	04 PGM-PSB-TYPE			PIC XX.	  	04 PGM-PSB_CALL-DEPT		PIC XX.$ 	04 PGM-PSB-STATUS		PIC S9(09) COMP.' 	04 PGM-PSB-WHOLE-MSN		PIC S9(18) COMP. . 	04 PGM-PSB-MSN-X REDEFINES PGM-PSB-WHOLE-MSN.& 	   06 PGM-PSB-MSN-1		PIC S9(09) COMP.& 	   06 PGM-PSB-MSN-2		PIC S9(09) COMP.( 	04 PGM-PSB-UMA-STATUS		PIC S9(09) COMP. 	04 FILLER			PIC X(40).   2 COPY PAMS_COB_GROUP         OF "DMQ$USER:DMQ.TLB".  4 COPY PAMS_COB_PROCESS         OF "DMQ$USER:DMQ.TLB".  2 COPY PAMS_COB_TYPE_CLASS    OF "DMQ$USER:DMQ.TLB".  6 COPY PAMS_COB_RETURN_STATUS_DEF OF "DMQ$USER:DMQ.TLB".  2 COPY PAMS_COB_SYMBOL_DEF    OF "DMQ$USER:DMQ.TLB".  3 COPY PAMS_COB_ENTRY_POINT    OF "DMQ$USER:DMQ.TLB".      PROCEDURE DIVISION.    0000-MAINLINE.0     PERFORM 0100-PAMS-INITIALIZE THRU 0100-EXIT.  .     PERFORM 0200-PAMS-RECEIVER THRU 0200-EXIT.  
 0000-EXIT.	     EXIT.      0100-PAMS-INITIALIZE. L *===========================================================================5 *  THIS PARAGRAPH WILL INITIALIZE THE PAMS PROCESS.   L *===========================================================================)     MOVE "1"                   TO Q_NAME. )     MOVE PSYM_ATTACH_PQ        TO Q_TYPE. 0     MOVE PSYM_ATTACH_BY_NUMBER   TO ATTACH_MODE.-     MOVE 1                     TO Q_NAME_LEN. 8     CALL "PAMS_ATTACH_Q" 	USING	BY REFERENCE ATTACH_MODE! 					BY REFERENCE REQ-PROCESS-NUM ;                                         BY REFERENCE Q_TYPE ;                                         BY REFERENCE Q_NAME ?                                         BY REFERENCE Q_NAME_LEN  					GIVING RETURN-STATUS.    @ * See the defn of RETURN-STATUS to see how this is used; this is3 * the std method of testing successful PAMS returns      IF NOT SS_NORMAL  / 	CALL "lib$signal" USING BY VALUE RETURN-STATUS 
 	STOP RUN.  4     MOVE REQ-PROCESS-NUM-WORDS TO PROCESS-NUM-WORDS.'     MOVE PROCESS-NUM-PROCESS TO WS-WORD ( 	    STRING "Assigned process  " WS-WORD 		    DELIMITED BY SIZE  		    INTO WS-TEXT-AREA.     DISPLAY WS-TEXT-AREA.   
 0100-EXIT.    	     EXIT.      0200-PAMS-RECEIVER. K *==========================================================================  *  Receive PAMS Message.K *==========================================================================  * Priority 0 (normal) receives 	MOVE ZERO	    TO PGM-PRIORITY.   % * The maximum msg size we can receive , 	MOVE WS-MESSAGE-LENGTH TO PGM-MSG-AREA-LEN.  2 * 300 * .1 = 30 seconds before timing out process  	MOVE 300	    TO PGM-TIMEOUT.   + * No special selection of incoming messages  	MOVE ZERO	    TO PGM-SEL-ADDR.    * Get the next message5 	CALL "PAMS_GET_MSGW" USING   BY REFERENCE WS-MESSAGE ! 				    BY REFERENCE PGM-PRIORITY  				    BY REFERENCE PGM-SOURCE  				    BY REFERENCE PGM-CLASS 				    BY REFERENCE PGM-TYPE % 				    BY REFERENCE PGM-MSG-AREA-LEN ! 				    BY REFERENCE PGM-LEN-DATA   				    BY REFERENCE PGM-TIMEOUT! 				    BY REFERENCE PGM-SEL-ADDR  				    BY REFERENCE PGM-PSB 				    GIVING RETURN-STATUS.   / * No messages in the required time...we're done " 	IF RETURN-STATUS = PAMS__TIMEOUT  	    DISPLAY "Timed out" 	    STOP RUN.   	IF NOT SS_NORMAL 3 	    CALL "lib$signal" USING BY VALUE RETURN-STATUS  	    STOP RUN.  A * We received a message...show its seq number, length and source	 & 	MOVE PGM-PSB-MSN-1 TO MESSAGE-LENGTH.2 	DISPLAY "Msg: " MESSAGE-LENGTH WITH NO ADVANCING.  & 	MOVE PGM-PSB-MSN-2 TO MESSAGE-LENGTH.. 	DISPLAY "," MESSAGE-LENGTH WITH NO ADVANCING.  % 	MOVE PGM-LEN-DATA TO MESSAGE-LENGTH. 7 	DISPLAY "; length " MESSAGE-LENGTH WITH NO ADVANCING.	   ) 	MOVE PGM-SOURCE-GROUP TO MESSAGE-LENGTH. A 	DISPLAY " from PAMS process " MESSAGE-LENGTH WITH NO ADVANCING.	   + 	MOVE PGM-SOURCE-PROCESS TO MESSAGE-LENGTH.  	DISPLAY "," MESSAGE-LENGTH.  & * Dump the data portion of the message 	DISPLAY "Data:" WS-MESSAGE.  E * Now check the PAMS Status Block to see if confirmation is required. D * This is signalled by the PSB status value containing "Confirmation' * required" or "Possible duplicate msg" 8 	IF PGM-PSB-STATUS = PAMS__CONFIRMREQ OR PAMS__POSSDUPL & 	   MOVE PGM-PSB-WHOLE-MSN TO SAVE-MSN8 	   CALL "PAMS_CONFIRM_MSG" USING 	BY REFERENCE SAVE-MSN 						BY REFERENCE CONFIRM-VAL	  						BY REFERENCE PDEL_NO_JRN 	   			   GIVING	RETURN-STATUS 	   IF NOT SS_NORMAL  0 		CALL "LIB$SIGNAL" USING BY VALUE RETURN-STATUS 	        STOP RUN.         GO TO 0200-PAMS-RECEIVER.  		
 0200-EXIT.	     EXIT.    END PROGRAM RECEIVER.                                                                                                                                                                                                                                                                                                                                                                                                                           $ * [DMQ$V20.EXAMPLES]COBOL_SENDER.COB;1 +  , B   .     /     4 I       0                   - B    0   1    2   3      K  P   W   O     5   6  xA  7 `p  8          9 Z  G    H  J                            IDENTIFICATION DIVISION. PROGRAM-ID. SENDER. I *========================================================================  * PROGRAM ABSTRACT:  *	Sample sender. *	$LINK SENDER,DMQ$LIB:DMQ/OPT * 7 *	For PAMS tracing define the following before running: & *	$DEFINE DMQ$SCRIPT DMQ$EXAMPLES:ECHO *	$DEFINE DMQ$DEBUG  TRACE * D *       TARGET WILL ALWAYS BE QUEUE 1, SO MAKE SURE THAT IF YOU SEND4 *       RECOVERABLY THAT YOU HAVE A DQF FOR QUEUE 1.I *========================================================================    ENVIRONMENT DIVISION.  CONFIGURATION SECTION. DATA DIVISION. WORKING-STORAGE SECTION.$ 01  RETURN-STATUS			PIC S9(09) COMP.1     88  SS_NORMAL			VALUE IS EXTERNAL SS$_NORMAL.    01  WS-MESSAGE				PIC X(1028).  2 01  WS-MESSAGE-LENGTH			PIC S9(04) COMP VALUE 250. 01  MSN-DISP				PIC X(9).    01  WS-TEXT-AREA			PIC X(80).  01  MESSAGE-LENGTH 			PIC 999.& 01  WS-ASSIGNED-PROCESS-ID		PIC 9(04).  ( 01  RECOVERY-OPTION			PIC X VALUE SPACE.- 01  DUMMY-ACCEPT-FIELD   		PIC X VALUE SPACE.   6 01  WS-TARGET-PAMS-GROUP-NAME		PIC X(15) VALUE SPACES.2 01  WS-TARGET-PAMS-GROUP		PIC S9(09) COMP VALUE 0.4 01  WS-TARGET-PAMS-PROCESS		PIC S9(09) COMP VALUE 0.   * For the PAMS_ATTACH_Q call.  01  PDP_FIELDS.      02  REQ-PROCESS-NUM-WORDS.5 	04  REQ-PROCESS-NUM-PROCESS	PIC S9(04) COMP VALUE 0. + 	04  REQ-PROCESS-NUM-GROUP	PIC S9(04) COMP. !     02  REQ-PROCESS-NUM REDEFINES ' 	REQ-PROCESS-NUM-WORDS	PIC S9(09) COMP.      02  PROCESS-NUM-WORDS.) 	04  PROCESS-NUM-PROCESS	PIC S9(04) COMP. ' 	04  PROCESS-NUM-GROUP	PIC S9(04) COMP.      02  PROCESS-NUM REDEFINES $ 	PROCESS-NUM-WORDS		PIC S9(09) COMP.8     02  ATTACH_MODE                     PIC S9(09) COMP.8     02  Q_TYPE                          PIC S9(09) COMP.   * For the PAMS_PUT_MSG call. 01  PPM-FIELDS. &     02  PPM-PRIORITY			PIC S9(9) COMP.     02  PPM-TARGET-WORDS. ) 	04  PPM-TARGET-PROCESS		PIC S9(04) COMP. ' 	04  PPM-TARGET-GROUP		PIC S9(04) COMP. >     02  PPM-TARGET REDEFINES PPM-TARGET-WORDS	PIC S9(09) COMP.$     02  PPM-CLASS			PIC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           M $      DMQ020.B                       B  B  $[DMQ$V20.EXAMPLES]COBOL_SENDER.COB;1                                                                                           I                             %             S9(04) COMP.#     02  PPM-TYPE			PIC S9(04) COMP. '     02  PPM-DELIVERY			PIC S9(9)  COMP. '     02  PPM-MSG-SIZE			PIC S9(04) COMP. &     02  PPM-TIMEOUT			PIC S9(09) COMP.#     02  PPM-UMA				PIC S9(9)  COMP.      02  PPM-PSB. 	04 PPM-PSB-TYPE			PIC XX.	  	04 PPM-PSB_CALL-DEPT		PIC XX.$ 	04 PPM-PSB-STATUS		PIC S9(09) COMP.# 	04 PPM-PSB-MSN-1		PIC S9(09) COMP. # 	04 PPM-PSB-MSN-2		PIC S9(09) COMP. ( 	04 PPM-PSB-UMA-STATUS		PIC S9(09) COMP. 	04 FILLER			PIC X(40).   2 COPY PAMS_COB_GROUP         OF "DMQ$USER:DMQ.TLB".  2 COPY PAMS_COB_PROCESS       OF "DMQ$USER:DMQ.TLB".  2 COPY PAMS_COB_TYPE_CLASS    OF "DMQ$USER:DMQ.TLB".  6 COPY PAMS_COB_RETURN_STATUS_DEF OF "DMQ$USER:DMQ.TLB".  2 COPY PAMS_COB_SYMBOL_DEF    OF "DMQ$USER:DMQ.TLB".  2 COPY PAMS_COB_ENTRY_POINT   OF "DMQ$USER:DMQ.TLB".   PROCEDURE DIVISION.   
 0000-MAIN.  2     PERFORM 0100-DECLARE-PROCESS  THRU  0100-EXIT.  8     PERFORM 0200-ACCEPT-TARGET-PROCESS  THRU  0200-EXIT.  7     PERFORM 0300-ACCEPT-RECOVERY-MODE  THRU  0300-EXIT.   1     PERFORM 0400-ACCEPT-MESSAGE  THRU  0400-EXIT.   /     PERFORM 0500-SEND-MESSAGE  THRU  0500-EXIT.   
 0000-EXIT.	     EXIT.      0100-DECLARE-PROCESS.   )     MOVE PSYM_ATTACH_PQ        TO Q_TYPE. .     MOVE PSYM_ATTACH_TEMPORARY TO ATTACH_MODE.8     CALL "PAMS_ATTACH_Q" 	USING	BY REFERENCE ATTACH_MODE! 					BY REFERENCE REQ-PROCESS-NUM ;                                         BY REFERENCE Q_TYPE  					GIVING RETURN-STATUS.  @ * See the defn of RETURN-STATUS to see how this is used; this is3 * the std method of testing successful PAMS returns      IF NOT SS_NORMAL  / 	CALL "lib$signal" USING BY VALUE RETURN-STATUS 
 	STOP RUN.       :     MOVE REQ-PROCESS-NUM-PROCESS TO WS-ASSIGNED-PROCESS-ID      STRING "Assigned process  "  	     WS-ASSIGNED-PROCESS-ID,      	DELIMITED BY SIZE   INTO WS-TEXT-AREA.       DISPLAY WS-TEXT-AREA.   9 * Assumes that the target is in this program's PAMS group #     MOVE 0 TO WS-TARGET-PAMS-GROUP.    0100-EXIT.  
     EXIT.      0200-ACCEPT-TARGET-PROCESS. %     MOVE 1 TO WS-TARGET-PAMS-PROCESS. 
 0200-EXIT.	     EXIT.      0300-ACCEPT-RECOVERY-MODE.  >     DISPLAY "Send With Recovery? (Y or N):" WITH NO ADVANCING.     ACCEPT RECOVERY-OPTION.      B * If recoverable, wait for the message to be written to the targetB * process' Destination Queue File (on disk); Undeliverable Message@ * Action is to discard the message (if the message can't be made * recoverable, it gets dumped)  A * If not recoverable, just dump the message if it can't get there   !     IF RECOVERY-OPTION = "Y" THEN -         MOVE PDEL_MODE_WF_DQF TO PPM-DELIVERY (         MOVE PDEL_UMA_DISC    TO PPM-UMA     ELSE  	MOVE ZERO 	   TO PPM-DELIVERY		&         MOVE PDEL_UMA_DISC TO PPM-UMA.  
 0300-EXIT.
      EXIT.     0400-ACCEPT-MESSAGE.A     DISPLAY "Enter Message (up to 250 chars):" WITH NO ADVANCING.      ACCEPT WS-MESSAGE. 		   
 0400-EXIT.	     EXIT.      0500-SEND-MESSAGE.(     DISPLAY "Type <CR> to Send Message".     ACCEPT DUMMY-ACCEPT-FIELD.  3     PERFORM 0600-PAMS-PUT-MESSAGE  THRU  0600-EXIT.        GO TO 0500-SEND-MESSAGE.	   
 0500-EXIT.	     EXIT.       0600-PAMS-PUT-MESSAGE. * Normal delivery priority" 	MOVE "0"	   	    TO PPM-PRIORITY.  ? * Target address is composed of a PAMS group and a PAMS process 3 	MOVE WS-TARGET-PAMS-PROCESS TO PPM-TARGET-PROCESS. 1 	MOVE WS-TARGET-PAMS-GROUP   TO PPM-TARGET-GROUP.   ? * No message type and class info, since this indication will be  * carried in the message body  	MOVE ZERO	    TO PPM-CLASS. 	MOVE ZERO	    TO PPM-TYPE.    * Our default message length( 	MOVE WS-MESSAGE-LENGTH TO PPM-MSG-SIZE.  6 * No timeout associated with this message transmission 	MOVE ZERO	    TO PPM-TIMEOUT.   * The PAMS message put call 4 	CALL "PAMS_PUT_MSG" USING   BY REFERENCE WS-MESSAGE! 				    BY REFERENCE PPM-PRIORITY  				    BY REFERENCE PPM-TARGET  				    BY REFERENCE PPM-CLASS 				    BY REFERENCE PPM-TYPE ! 				    BY REFERENCE PPM-DELIVERY ! 				    BY REFERENCE PPM-MSG-SIZE   				    BY REFERENCE PPM-TIMEOUT 				    BY REFERENCE PPM-PSB 				    BY REFERENCE PPM-UMA	  				    GIVING RETURN-STATUS.  	IF NOT SS_NORMAL 3 	    CALL "lib$signal" USING BY VALUE RETURN-STATUS  	    STOP RUN.  A * At this point, we need to check the PSB (PAMS STATUS BLOCK) for 2 * the completion status of the recoverable action.@ * We only need to make this check if we sent the msg recoverably$ 	IF PPM-DELIVERY = PDEL_MODE_WF_DQF  * Show the Message Seq Number # 	    MOVE PPM-PSB-MSN-1 TO MSN-DISP 2 	    DISPLAY "Message " MSN-DISP WITH NO ADVANCING  # 	    MOVE PPM-PSB-MSN-1 TO MSN-DISP + 	    DISPLAY "," MSN-DISP WITH NO ADVANCING   # * Now check the PSB Delivery Status ( 	    IF PPM-PSB-STATUS = PAMS__ENQUEUED  		DISPLAY " is recoverable" 	 	    ELSE 2 		DISPLAY " is NOT recoverable:" WITH NO ADVANCING  3 * Message is not recoverable...determine the reason , 	        IF PPM-PSB-STATUS = PAMS__NO_DQF 		# 		   DISPLAY " No DQF for target	"   		ELSE  / 		   IF PPM-PSB-STATUS = PAMS__DQF_DEVICE_FAIL  " 		      DISPLAY " DQF I/O failed" 
 	        ELSE ' 		   IF PPM-PSB-STATUS = PAMS__DQF_FULL  		      DISPLAY " DQF is full"  
 	        ELSE * 		   IF PPM-PSB-STATUS = PAMS__MRS_RES_EXH, 		      DISPLAY " MRS Resource Exhaustion" .  $ * Last check...see if the UMA worked'     IF PPM-DELIVERY = PDEL_MODE_WF_DQF  /         IF PPM-PSB-STATUS NOT = PAMS__ENQUEUED  7             IF PPM-PSB-UMA-STATUS = PAMS__DISC_SUCCESS  C                 DISPLAY "Requested Undel Msg. Action of Discard OK"              ELSEH                 DISPLAY "Requested Undel Msg. Action of Discard failed".  
 0600-EXIT.	     EXIT.    END PROGRAM SENDER.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             " * [DMQ$V20.EXAMPLES]DMQ$MRQ_TEST.C;1 +  , B   . 0    /     4 d   0   - 
                  - B    0   1    2   3      K  P   W   O 1    5 	  6 D2d  7  xp  8          9 Z  G    H  J                              #module dmq$mrq_test "V2.0-03"  N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1992                                                       *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/     O /******************************************************************************  * Module:    DMQ$MRQ_TEST  *  * Filename:  DMQ$MRQ_TEST.C  * B * Function:     This program is used to test DECmessageQ MRQ code. * 	 * Inputs:  *	None * 
 * Outputs: *	None *  * External Subroutines:  *	pams_attach_q  *	pams_get_msg *	pams_get_msgw  *	pams_put_msg *	pams_cancel_select *	pams_set_select                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             $      DMQ020.B                       B  B  "[DMQ$V20.EXAMPLES]DMQ$MRQ_TEST.C;1                                                                                             d    0                         һ "            * 
 * Language: C  * 0 * compile: $ cc/list/obj/include=dmq$user file.c' * link:    $ link file,dmq$lib:dmq/opt  O ******************************************************************************/   6 typedef unsigned char BOOLEAN;		/* boolean variable */# #define FALSE                     0 # #define TRUE                      1 # #define SKIP_KEY               -100    #include <stdio.h> #include <ssdef.h> #include <stsdef.h>  #include <descrip.h>   /* portable includes */  #include "p_entry.h" #include "p_group.h" #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"     
 typedef union    {     long int      all; 	    struct       {       short int  process;        short int  group; 
      } au;   } PAMS_ADDRESS;        static BOOLEAN		flush_flag;  static PAMS_ADDRESS    	target;  static PAMS_ADDRESS	source;  static PAMS_ADDRESS	index;# static char             q_name[31]; # static long int         q_name_len; 0 static long int		sts$value, attach_mode, q_type;) static long int		time_out, sink_time_out;  static long int		proc_num_in; ! static PAMS_ADDRESS	proc_num_out; $ static long int		idx, ctr, loop_ctr;, static long int		sender_pause, sender_burst;# static short int	size, i, rcv_buff; 2 static short int	class, type, rcv_class, rcv_type;% static short int	msg_size, input_num; $ static char		option[81], buffer[81]; static char		*msg_buffer, c; static char		delivery;( static short int	priority, rcv_priority; static long int		put_timeout;  struct PSB		psb; static char		uma;  static long int		resp_que; static BOOLEAN		first_time; + static long int		pvar, dcl_num, target_num; ( static long int         length_of_input;   void			print_sts( ); void			print_menu( );  void 			print_rcvd( ); void			test_put( );  void			test_get( );  void			test_getw( ); void			test_can_select( ); void			test_set_select( ); void			test_sink( ); void			test_sender( ); void			reset_settings( ); 
 int istat;   dmq$mrq_test ()    {     3   printf("\n\n\t*** DMQ$MRQ_TEST beginning ***\n");      sts$value  = 0;    proc_num_in = 0;  ,   printf("\nEnter my queue number (D:0): ");   istat = gets(buffer); $   length_of_input = strlen (buffer);   if (length_of_input == 0)    { (     attach_mode = PSYM_ATTACH_TEMPORARY;   }    else   { (     attach_mode = PSYM_ATTACH_BY_NUMBER;     strcpy (q_name,buffer); !     q_name_len = strlen (q_name);    }    q_type = PSYM_ATTACH_PQ;  K   sts$value = pams_attach_q (&attach_mode,&proc_num_out.all,&q_type,q_name, 4                              &q_name_len,0,0,0,0,0);'   if (!$VMS_STATUS_SUCCESS(sts$value))     { A      print_sts("DMQ$MRQ_TEST", "Error returned by PAMS_ATTACH_Q",  					 sts$value);       exit(sts$value);    }   =   printf("\nMy Q address is %d.%d\n", proc_num_out.au.group,  ! 					   proc_num_out.au.process);   %   target.all      = proc_num_out.all;    source.all      = 0;   index.all       = 0;   time_out        = 50;    sink_time_out   = 200;   sender_pause    = 1;   sender_burst    = 20;    class           = 1;   type            = -123; %   delivery        = PDEL_MODE_NN_MEM;    priority        = 0;   rcv_priority    = 0;   put_timeout	  = 0;   uma		  = PDEL_UMA_DISC;    resp_que	  = 0;    option[0]       = 'R';   first_time      = FALSE;   rcv_buff        = 25;    flush_flag      = FALSE;     for(;option[0] != 'E';)      {       switch (option[0])         {         case 'P':  		test_put( ); 		break;         case 'G':  		test_get( ); 		break;         case 'W':  		test_getw( );  		break;         case 'C':  		test_can_select( );  		break;         case 'S':  		test_set_select( );  		break;         case 'K':  		test_sink( );  		break;         case 'D':  		test_sender( );  		break;         case 'R':  		reset_settings(flush_flag);  		flush_flag = TRUE; 		break;         case 'H':  		print_menu();  		break;         case 'E': % 		printf("\nEnd of DMQ$MRQ_TEST.\n");  		break;	 	default: ' 		printf("\n** Invalid response **\n");  		break;#        }  /*** end of "switch" ***/         if (first_time)        {         print_menu();  	first_time = FALSE;        }        option[0] = ' '; D      printf("\n\n(P)UT    (G)ET     GET(W)   (S)ET-SEL  (C)AN-SEL");=      printf("\nSIN(K)   SEN(D)ER  (R)ESET   (H)ELP  (E)XIT");        printf("\nEnter option: ");        istat = gets(option);3      if (!istat) if (feof(stdin) ) option[0] = 'E';   $      option[0] = toupper(option[0]);  "     }  /*** end of "for loop" ***/      exit(1);  }   A /****************************************************************  *	Module: test_put					*
 *								*A ****************************************************************/    static void test_put( )  {    printf("\nEnter msg data: ");    gets(buffer);      ms    )                        $      DECW$MOTIF011.A                0?  d/\  *[SYSHLP.EXAMPLES.DECW.UTILS]XWININFO.EXE;2                                                                                          *                         u@ 
     %        Pĭ ЬRbhPGRS ЬVfŏP   iQjR PAP`Rt  Phfĳ \P ЬRbhPCRS ԭ߭ ЬRbkխ߭ bkխݼ мWS1W P ^@RS ݬ  P********************************/    static void test_get( )  { ?   sts$value = pams_get_msg(&buffer, &rcv_priority, &source.all, ) 			   &rcv_class, &rcv_type, &80, &size,  # 			   &index.all, &psb,0,0,0,0,0);  #   if (sts$value == PAMS__NOMOREMSG) "      print_sts("", "", sts$value);,   else if (!$VMS_STATUS_SUCCESS(sts$value))      { @      print_sts("DMQ$MRQ_TEST", "Error returned by PAMS_GET_MSG", 					 sts$value);       return;     }    else5      print_rcvd (source.au.group, source.au.process,  + 		      rcv_class, rcv_type, size, buffer); 	   return;  }/** end of test_get ***/     A /****************************************************************  *	Module: test_getw					* 
 *								*A ****************************************************************/    static void test_getw( ) { @   sts$value = pams_get_msgw(&buffer, &rcv_priority, &source.all,* 			    &rcv_class, &rcv_type, &80, &size, / 			    &time_out, &index.all, &psb,0,0,0,0,0);  !   if (sts$value == PAMS__TIMEOUT) "      print_sts("", "", sts$value);,   else if (!$VMS_STATUS_SUCCESS(sts$value))      { A      print_sts("DMQ$MRQ_TEST", "Error returned by PAMS_GET_MSGW",  				 sts$value);      return;     }    else5      print_rcvd (source.au.group, source.au.process,  + 		      rcv_class, rcv_type, size, buffer);   	   return;  } /*** end of test_getw ***/  A /****************************************************************  *	Module: test_can_select					* 
 *								*A ****************************************************************/    static void test_can_select( ) {  PAMS_ADDRESS	can_index;   
   idx = 0;   if (index.au.group < 0)      idx = index.au.process;   5   printf("\n\nReceive select process (D:%d): ", idx);    gets(buffer); )   if (buffer[0] != 0) idx = atoi(buffer);      can_index.au.group   = -1;   can_index.au.process = idx;   1   sts$value = pams_cancel_select(&can_index.all); '   if (!$VMS_STATUS_SUCCESS(sts$value))       { F      print_sts("DMQ$MRQ_TEST", "Error returned by PAMS_CANCEL_SELECT", 				 sts$value);      return;     }   	   return; " } /*** end of test_can_select ***/  A /****************************************************************  *	Module: test_set_select					* 
 *								*A ****************************************************************/    static void test_set_select( ) {  struct   {    long int	q_num;    long int	pri;    struct   {      long int	field;      long int	field_size;     long int	field_value;      long int	field_operator;   } key[2];    long int	order_field;    long int	order_field_size;    long int	order_field_operator; } sel_array [100];   short int	i,n; long int	p,src,f,s,op;     for (n=0; n < 100; n++)    { ,     sel_array[n].q_num                  = 0;,     sel_array[n].pri                    = 0;,     sel_array[n].key[0].field           = 0;,     sel_array[n].key[0].field_size      = 0;,     sel_array[n].key[0].field_value     = 0;,     sel_array[n].key[0].field_operator  = 0;,     sel_array[n].key[1].field           = 0;,     sel_array[n].key[1].field_size      = 0;,     sel_array[n].key[1].field_value     = 0;,     sel_array[n].key[1].field_operator  = 0;,     sel_array[n].order_field            = 0;,     sel_array[n].order_field_size       = 0;,     sel_array[n].order_field_operator   = 0;   } /* init                                                                                                                                                                                                                                                                            ͅ $      DMQ020.B                       B  B  "[DMQ$V20.EXAMPLES]DMQ$MRQ_TEST.C;1                                                                                             d    0                         ; "            loop */   <   printf("\n\n                   Building a Selection Array\Q           \n\n   In order to build a selection array you will be asked to supply\hO             \n a queue number (which can be your PAMS process queue, secondary\yM             \n process queue or a Multi-reader queue), message priority, and\yS             \n selection criteria for KEY-1 and ORDER. These questions will repeat\ 8 	    \n until a zero is entered for the queue number.");     for (n=0; n < 100; n++)    {m/     printf("\n\nQueue number (D:done): ", idx);o       gets(buffer);n     if (buffer[0] == 0 ) break;        idx = atoi(buffer);u       p = PSEL_PRI_ANY;o4     printf("\nPriority (%d=P0,%d=P1,%d=any D:%d): ",. 			PSEL_PRI_P0, PSEL_PRI_P1, PSEL_PRI_ANY, p);     gets(buffer); *     if (buffer[0] != 0 ) p = atoi(buffer);       sel_array[n].q_num  = idx;     sel_array[n].pri    = p;       for(i=0; i < 2; i++)     {s       f = SKIP_KEY; Q       printf("\nKEY-%d: Field offset (%d=Source,%d=Class,%d=Type D:no-key-%d): ", =   			          i+1, PSEL_SOURCE, PSEL_CLASS, PSEL_TYPE, i+1);*       gets(buffer);*+       if (buffer[0] != 0) f = atoi(buffer);*         src = 0;       op  = PSEL_OPER_EQ;*       if (f != SKIP_KEY) T       { ;         printf("\nKEY-%d: Field value (D:%d): ", i+1, src);m 	gets(buffer);( 	if (buffer[0] != 0) src = atoi(buffer);  M         printf("\nKEY-%d: Field operator (%d=EQ,%d=NEQ,%d=GTR,%d=LT D:%d): ",aF 			i+1, PSEL_OPER_EQ, PSEL_OPER_NEQ, PSEL_OPER_GTR, PSEL_OPER_LT, op); 	gets(buffer);' 	if (buffer[0] != 0) op = atoi(buffer);i  /         sel_array[n].key[i].field          = f;i1         sel_array[n].key[i].field_value    = src;*0         sel_array[n].key[i].field_operator = op;           if (f == PSEL_SOURCE)A/            sel_array[n].key[i].field_size  = 4; 7         else if ((f == PSEL_CLASS) || (f == PSEL_TYPE))f/            sel_array[n].key[i].field_size  = 2;i         else if (f >= 0)	         {t           s = 4;:           printf("\nKEY-%d: Field size (D:%d): ", i+1, s); 	  gets(buffer);( 	  if (buffer[0] != 0) s = atoi(buffer);  .           sel_array[n].key[i].field_size  = s;           if (s == 0) @              sel_array[n].key[i].field_operator = PSEL_OPER_ANY;	         }o         else	         {g.           sel_array[n].key[i].field       = 0;.           sel_array[n].key[i].field_size  = 0;.           sel_array[n].key[i].field_value = 0;	         }D#     } /* end of key-n processing */   &     } /* end of key processing loop */       op = PSEL_ORDER_FIFO;s     f = SKIP_KEY;,O     printf("\nORDER: Field offset (%d=Source,%d=Class,%d=Type D:skip-order): ",n3   			          PSEL_SOURCE, PSEL_CLASS, PSEL_TYPE);n     gets(buffer);t)     if (buffer[0] != 0) f = atoi(buffer);u       if (f != SKIP_KEY)     {cF       printf("\nORDER: Field operator (%d=FIFO,%d=MIN,%d=MAX D:%d): ",9 		  PSEL_ORDER_FIFO, PSEL_ORDER_MIN, PSEL_ORDER_MAX, op);e       gets(buffer);*,       if (buffer[0] != 0) op = atoi(buffer);  ,       sel_array[n].order_field          = f;-       sel_array[n].order_field_operator = op;a         if (f == PSEL_SOURCE)_+         sel_array[n].order_field_size  = 4;n5       else if ((f == PSEL_CLASS) || (f == PSEL_TYPE)) +         sel_array[n].order_field_size  = 2;        else if (f >= 0)       {r         s = 4;2         printf("\nORDER: Field size (D:%d): ", s); 	gets(buffer);' 	if (buffer[0] != 0 ) s = atoi(buffer);e  +         sel_array[n].order_field_size  = s;d       }o
       else       {)+         sel_array[n].order_field       = 0; +         sel_array[n].order_field_size  = 0;*       }      }$     } /* end of input loop */;  .   if (n < 1)		/* has a list been generated? */&   {			/*  no                        */@      printf("\n*** The PAMS_SET_SELECT call canceled. ***\n\n");      return;   }T   else   {;     printf("\n\n"); ]     printf("\n                     Key 1                      Key 2                  Order"); d     printf("\n           -----------------------    ------------------------    -----------------");d     printf("\n Q   Pri   Field  Size  Value  Oper   Field  Size  Value  Oper    Field  Size  Oper");     for (i=0; i < n; i++)      {sd       printf("\n%3d   %d    %4d     %d   %5d   %2d     %4d    %d   %5d   %2d     %4d     %d    %2d", 			sel_array[i].q_num, 			sel_array[i].pri, 			sel_array[i].key[0].field, " 			sel_array[i].key[0].field_size,# 			sel_array[i].key[0].field_value,o& 			sel_array[i].key[0].field_operator, 			sel_array[i].key[1].field, " 			sel_array[i].key[1].field_size,# 			sel_array[i].key[1].field_value, & 			sel_array[i].key[1].field_operator, 			sel_array[i].order_field,! 			sel_array[i].order_field_size, & 			sel_array[i].order_field_operator);     } /* print loop */       printf("\n\n");e   }e  :   sts$value = pams_set_select(&sel_array, &n, &index.all);'   if (!$VMS_STATUS_SUCCESS(sts$value))       {AC      print_sts("DMQ$MRQ_TEST", "Error returned by PAMS_SET_SELECT",  				 sts$value);      return;     }p  @   printf("\nThe PAMS assigned index is %d\n", index.au.process);  	   return; " } /*** end of test_set_select ***/ a  A /****************************************************************t *	Module: test_sink					* 
 *								*A ****************************************************************/e   static void test_sink( ) {'  J   printf("\n\n    This message sink will continue until no messages are");B   printf(  "\n  received within %d seconds.\n", sink_time_out/10);  A   printf("\n         1         2         3         4         5");IA   printf("\n12345678901234567890123456789012345678901234567890");*   printf("\n"); 
   ctr = 0;  
   while(TRUE)    {nB     sts$value = pams_get_msgw(&buffer, &rcv_priority, &source.all,, 			      &rcv_class, &rcv_type, &80, &size, 6 			      &sink_time_out, &index.all, &psb,0,0,0,0,0); #     if (sts$value == PAMS__TIMEOUT)      {(1        printf("\n Received %d messages.\n", ctr);         return;     }o.     else if (!$VMS_STATUS_SUCCESS(sts$value))      {rC        print_sts("DMQ$MRQ_TEST", "Error returned by PAMS_GET_MSGW",  				   sts$value);        return;     }*        if (++ctr % 50) *
 	printf(" ");e	      else* 	printf("%8d\r",ctr);*     } /* sink receive loop */*    	   return;* } /*** end of test_sink ***/    A /****************************************************************i *	Module: test_sender					*$
 *								*A ****************************************************************/v   static void test_sender( ) {u   printf("\n");e     loop_ctr = 50;  <   printf("\nNumber of messages to send (D:%d): ", loop_ctr);   gets(buffer);r.   if (buffer[0] != 0) loop_ctr = atoi(buffer);     msg_size = 26;   for (i=0; i < msg_size; i++)     buffer[i] = i + 'A';  H   printf("\n\n  There will be a pause of %d second every %d messages.",   				sender_pause, sender_burst);   printf("\n");*A   printf("\n         1         2         3         4         5");uA   printf("\n12345678901234567890123456789012345678901234567890");c   printf("\n");&  $   for (i=0,ctr=0; i < loop_ctr; i++)   {0<     sts$value = pams_put_msg(buffer, &priority, &target.all,, 			     &class, &type, &delivery, &msg_size,4 			     &put_timeout, &psb, &uma, &resp_que,0,0,0); )     if (!$VMS_STATUS_SUCCESS(sts$value))       {uB        print_sts("DMQ$MRQ_TEST", "Error returned by PAMS_PUT_MSG", 					 sts$value);,        return;     }	        if (++ctr % 50)  
 	printf(" ");*	      elset 	 printf("%8d\r",ctr);  "      if (ctr % sender_burst == 0) >         sleep(sender_pause);	/* pause for sinks to catch up */     } /* end of sender loop */  (   printf("\n Sent %d messages.\n", ctr);   } /*** end test_sender ***/u   aA /****************************************************************, *	Module: reset_settings					*
 *								*A ****************************************************************/   ! static void reset_settings(flush)    BOOLEAN		flush;U {U   #if 0$   if (flush)?      while ((c = getchar()) != '\n');  /* flush input buffer */G #endif  ,   printf("\n\tChange call parameters.\n\n");;   printf("  To maintain default settings enter <CR>.\n\n");   5   printf("\nTarget group (D:%d): ", target.au.group);*   gets(buffer); 6   if (buffer[0] != 0 ) target.au.group = atoi(buffer);  9   printf("\nTarget process (D:%d): ", target.au.process);	   gets(buffer);*8   if (buffer[0] != 0 ) target.au.process = atoi(buffer);  )   printf("\nSend class (D:%d): ", class);E   gets(buffer); ,   if (buffer[0] != 0 ) class = atoi(buffer);  '   printf("\nSend type (D:%d): ", type);e   gets(buffer);s*   if (buffer[0] != 0) type = atoi(buffer);  /   printf("\nSend delivery (D:%d): ", d                                                                                                                                                                                                                                                   	                        nV $      DMQ020.B                       B  B  "[DMQ$V20.EXAMPLES]DMQ$MRQ_TEST.C;1                                                                                             d    0                         ~      '       elivery);.   gets(buffer); .   if (buffer[0] != 0) delivery = atoi(buffer);  /   printf("\nSend priority (D:%d): ", priority);T   gets(buffer);v.   if (buffer[0] != 0) priority = atoi(buffer);  2   printf("\nRcv priority (D:%d): ", rcv_priority);   gets(buffer);;3   if (buffer[0] != 0 ) rcv_priority = atoi(buffer);   -   printf("\nRcv timeout (D:%d): ", time_out);*   gets(buffer);*.   if (buffer[0] != 0) time_out = atoi(buffer);  <   printf("\nReceive select group (D:%d): ", index.au.group);   gets(buffer);t4   if (buffer[0] != 0) index.au.group = atoi(buffer);  @   printf("\nReceive select process (D:%d): ", index.au.process);   gets(buffer);d6   if (buffer[0] != 0) index.au.process = atoi(buffer);   o     printf("\n\n");oD   printf("\t              My PN is %d.%d\n", proc_num_out.au.group, # 					     proc_num_out.au.process); 7   printf("\t       SEND                  RECEIVE\n\n"); 8   printf("\tTarget:   %3d.%03d      Priority:    %6d\n",3 	target.au.group, target.au.process, rcv_priority); E   printf("\tClass:    %7d       Timeout:    %6d\n", class, time_out);l   if (index.au.group < 0)r?     printf("\tType:     %7d        Select: index %3d\n", type, _ 						index.au.process);   else@     printf("\tType:     %7d        Select:   %3d.%03d\n", type, & 				index.au.group, index.au.process);(   printf("\tDelivery: %7d\n", delivery);(   printf("\tPriority: %7d\n", priority);   printf("\n");   	   return;r  ! } /*** end of reset_settings ***/  e   static void   print_menu() {    printf("\n"); J   printf("\n\t (G) - PAMS_GET_MSG          \t(C) - PAMS_CANCEL_SELECT\n");G   printf(  "\t (W) - PAMS_GET_MSGW         \t(S) - PAMS_SET_SELECT\n");uF   printf(  "\t (P) - PAMS_PUT_MSG          \t(D) - Message sender\n");J   printf(  "\t (K) - Message receiver sink \t(H) - Help (this screen)\n");0   printf(  "\t (C) - Change call parameters\n");   printf(  "\t (E) - Exit\n");  	   return;l }e    ? static void   print_rcvd (group, proc, class, type, size, buff)   ) short int	group, proc, class, type, size;n char		*buff; {:    short int	sts$value;e    short int	i;     char		*ptr;   struct     {     PAMS_ADDRESS		target;!    PAMS_ADDRESS		original_target;"!    PAMS_ADDRESS		original_source;)    long int		not_used;    char			delivery;N    char			priority;e    char			buffer_type;    char			filler[81];;   } item_buffer;   BOOLEAN			prt_data;e     char outbuff[512];   	printf("\n");  ? 	printf("Rcvd msg from %d.%d  Class=%d  Type=%d  Length=%d\n", l% 					group, proc, class, type, size);n   	if (size > 0) 	{&   	   strncpy ( outbuff, buff, size ); 	   outbuff[size] = 0;1            printf ("Rcv data = %s \n", outbuff );b	         }    return;    }       1 static void print_sts(process, text, status_code)    char			*process;
 char			*text;a long int		status_code;   {g  struct dsc$descriptor_s pn_text;! struct dsc$descriptor_s msg_text;n    +   pn_text.dsc$w_length   = strlen(process);,)   pn_text.dsc$b_dtype    = DSC$K_DTYPE_T;L)   pn_text.dsc$b_class    = DSC$K_CLASS_S;;#   pn_text.dsc$a_pointer  = process;)  (   msg_text.dsc$w_length  = strlen(text);)   msg_text.dsc$b_dtype   = DSC$K_DTYPE_T;r)   msg_text.dsc$b_class   = DSC$K_CLASS_S;     msg_text.dsc$a_pointer = text;  8   putil_print_status(&pn_text, &msg_text, &status_code);  	   return;] }e                                                                                                                                                                                                                                                                     * [DMQ$V20.EXAMPLES]DMQ$QMENU.C;1 +  , B   . <    /     4 Z   <   :                    - B    0   1    2   3      K  P   W   O =    5 	  6 `A  7 @p  8          9 Z  G    H  J                 #module DMQ$QMENU "DMQ V2.0-01"   N /*****************************************************************************$  *  DECMessageQ for VMS							     *N  *                                                                           *;  *  Copyright (c) 1990                    			             * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/        /*    *DMQ$QMENU.C   *H  * This program sends text messages to other instances of this program, >  * or to the GET_MSG_AST.C, GET_MSG_EF.C, or TTAST.C programs.  *E  * DMQ$QMENU is menu driven. Each action occurs in response to a user   * command.   *8  * To compile this program do the following DCL command.+  * $ CC/LIST/OBJ/INCLUDE=DMQ$USER DMQ$QMENU   *#  * $ LINK DMQ$QMENU,DMQ$LIB:DMQ/OPT   *  */   % /***********************************/ % /* Include files from SYS$LIBRARY: */ % /***********************************/  #include <stdio.h> #include <errno.h> #include <ctype.h> #include <descrip.h>   #include <ssdef.h> #include <libdef.h>  #include <rmsdef.h>   , /******************************************/, /* Include modules from DMQ$USER          */, /******************************************/ /* portable includes */  #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "p_entry.h" #include "p_group.h"      1 /***********************************************/ 1 /* Structure definitions for 2 PAMS structures */ 1 /***********************************************/ 
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group;     } au; } PAMS_ADDRESS ;   typedef struct   {     short int type;    short int cd;    long int del_status;     long int seq[2];     long int uma_status;     long int function_status;    long int unused[2]; } PAMS_PSB;   8 /******************************************************/8 /* Space for a singly linked list of unconfirmed msgs */8 /******************************************************/ struct PAMS_UNCONF_STR {     long seq[2]; $    struct PAMS_UNCONF_STR *flink;    };+ typedef struct PAMS_UNCONF_STR PAMS_UNCONF;  PAMS_UNCONF *uncnfhead = 0;  long int     uncnfmsgs = 0;   , /******************************************/, /* Data structures shared by all routines */, /******************************************/ #define MAX_BUF 512  char msg_area [ MAX_BUF ]; char qname    [  32 ]; char pname    [  32 ];   PAMS_ADDRESS mypamsid;   long	     snd_q_address  = 0;  long	     rcv_q_address  = 0;    short snd_del_mode   = 0;  short snd_uma        = 0;  long  snd_timeout    = 0;  long  snd_with_MRS   = 0;  long  astlvl_confirm = 0;    const int loop  = 1; const int aloop = 1;   static char *vms_errstr ();     " const long qtype = PSYM_ATTACH_PQ;   static main () {     long int attach_mode;    long int istat;    int ilen;    int jlen;    char ans;  > 	/***********************************************************/> 	/* Keep on trying to connect to DECMESSAGEQ until it works */> 	/***********************************************************/
 	while (loop)  	{ 	   while ( aloop )  	   { G 	      myprintf ("\nDECLARE as Permanent or Temporary Queue (P,T) ?" );   ! 	      istat = gets ( msg_area ); 4 	      if ( ! istat ) if (feof (stdin) ) exit ( 1 );  & 	      ans = _toupper ( msg_area[0] ); 	        	      if ( ( ans != 'P' )  & 	      &&   ( ans != 'T' ) ) continue;  Z 	      attach_mode = ( msg_area[0] == 'P' ) ? PSYM_ATTACH_BY_NAME : PSYM_ATTACH_TEMPORARY;               break; 	   }   - 	   if ( attach_mode == PSYM_ATTACH_BY_NAME )  	   {  	      w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
                        oIa_ $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]DMQ$QMENU.C;1                                                                                                Z    <                         8 "     
       hile ( aloop)  	      {0 	         myprintf ("\nPrimary queue name? : ");             " 	         istat = gets (msg_area);7 	         if ( ! istat ) if (feof (stdin) ) exit ( 1 );   ,                  ilen  = strlen ( msg_area);* 	         if (( ilen >= sizeof ( pname ) )6 	         ||  ( ilen <= 0                ) ) continue;  % 	         strcpy ( pname, msg_area );  	         break; 	      } 	   }  	   else 	   {  	      pname[0] = 0; 	      ilen     = 0; 	   }    	   istat = pams_attach_q ( F 	      &attach_mode, &mypamsid ,&qtype, pname, &ilen, 0, 0, 0, 0, 0 );   	   if (istat != SS$_NORMAL )  	   { 3 	      myprintf (" PAMS_ATTACH_Q failed: %x \n%s",  ( 	         istat, vms_errstr ( istat ) ); 	      continue; 	   }               break;  	}      
 	while (loop)  	{= 	   /*******************************************************/ = 	   /* Prompt for the next operation to perform, and do it */ = 	   /*******************************************************/ A 	   myprintf ("\n\nS=Setup, P=put, G=get, C=Confirm, E=exit: " );    	   istat = gets ( msg_area );1 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 );   *            ans = _toupper ( msg_area[0] );   	   switch (ans) 	   { 
 	   case 'S':  	      do_setup(); 	      continue;  
 	   case 'P':  	      istat = put_msg ();" 	      if ( istat != SS$_NORMAL ) 1 	         myprintf ("\n pams_put_msg rejected ");    	      continue;  
 	   case 'G':  	      istat = get_msg ();" 	      if ( istat != SS$_NORMAL ) 1 	         myprintf ("\n pams_get_msg rejected ");    	      continue;  
 	   case 'C':  	      istat = confirm_msg (); 	      continue;  
 	   case 'E': * 	      break;	/* break out of this loop */   	   default:3 	      myprintf ("\n Invalid option... try again");  	      continue; 	   }             break;	 	}   	myprintf ("\nProgram exited");  }        static int do_setup () {     long istat;    char ans;  
 	while (loop)  	{, 	   myprintf ("\nL=Locate, M=MRS setup : ");   	   istat = gets ( msg_area );2 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;  )            ans = _toupper (msg_area[0] );    	   switch ( ans ) 	   { 
 	   case 'L':  	      istat =  locate_q ();" 	      if ( istat != SS$_NORMAL ) 2 	         myprintf ("\n pams_locate_q rejected ");   	      return ( SS$_NORMAL );   
 	   case 'M':  	      do_mrs_setup ();  	      return ( SS$_NORMAL );    	   default:3 	      myprintf ("\n Invalid option... try again");                break;  	   } 	   	         }  }        static int put_msg ()  { 
    int istat;       long  target   = 0;    short prio     = 0;    short class    = 1;    short type     = 1;!    short delivery = snd_del_mode;      long  timeout  = snd_timeout;    long  uma      = snd_uma;      short size;    PAMS_PSB   psb;    char ans;   	if ( !snd_q_address ) 	{D 	   myprintf ("\nTarget queue not specified. Send to self? (Y/N) ");   	   istat = gets(msg_area); 2 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;   	   if ((msg_area[0] == 'Y')   	   ||  (msg_area[0] == 'y'))  	   { +               snd_q_address = mypamsid.all;  	   }             else  	   {  	      myprintf ( : 	      "\nNo target queue... you must do a LOCATE first"); 	      return ( 0 ); 	   } 	         }    	target = snd_q_address;   	myprintf ("\nMessage? : "); 	istat = gets(msg_area);/ 	if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;    	size = strlen ( msg_area );            	istat = pams_put_msg ( 
 	   msg_area, 
 	   &prio, 	   &target, 	   &class, 
 	   &type, 	   &delivery,
 	   &size,
 	   &timeout, 	 	   &psb,  	   &uma,0,0,0,0 );    	if ( istat != SS$_NORMAL )  	{ 	   myprintf ("\npsb:%x, %s ",  5 	      psb.del_status, vms_errstr( psb.del_status) );   = 	   myprintf ("\nret:%x, %s ", istat, vms_errstr ( istat ) );    	   return ( istat ); 	         }    	myprintf ("\npsb:%x, %s ", 5 	      psb.del_status, vms_errstr( psb.del_status) );   * 	if ( ( psb.del_status != SS$_NORMAL     )* 	&&   ( psb.del_status != PAMS__ENQUEUED ), 	&&   ( psb.del_status != PAMS__STORED   ) ) 	{ 	   return ( psb.del_status ); 	}  7 	myprintf ("\nSent message. size:%d, seqno (%x,%x), ",  & 	      size, psb.seq[0], psb.seq[1] ); 	  	return ( istat ); }          static int get_msg ()  { 
    int istat;       short msg_area_len   = 0;    short prio     	= 0; .    long  timeout  	= 600;		/* sixty seconds */      short class;     short type;    short len_data;      PAMS_ADDRESS source;     PAMS_PSB   psb;      char *msg_ptr;   
    int state;     short filter[2];       char ans;   	filter[0] = rcv_q_address;  	filter[1] = PSEL_AQ;    	if ( !rcv_q_address )   	{< 	   filter[0] = filter[1] = 0;	/* Read from Primary Queue */ 	}  > 	/***********************************************************/> 	/* PSEL_AQ is not appropriate if we're reading from our PQ */> 	/***********************************************************/@ 	if ( rcv_q_address == mypamsid.all ) filter[0] = filter[1] = 0; 	 * 	/***************************************/* 	/* get the buffer length for this call */* 	/***************************************/
 	while (loop)  	{? 	   myprintf("\nbuffer length? 0 - %d :", sizeof(msg_area)-1 );  	   istat = gets(msg_area );2 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;   " 	   msg_area_len = atoi(msg_area);4 	   if (msg_area_len >= sizeof(msg_area) ) continue;  $ 	   if (msg_area_len < 0 ) continue;
 	   break; 	}  & 	/***********************************/& 	/* What type of call should we do? */& 	/***********************************/ 	while (loop ) 	{< 	   myprintf ("\nGET_MSG, GET_MSGW, GET_MSGA ? (G/W/A) : "); 	   istat = gets ( msg_area );2 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;*            ans = _toupper ( msg_area[0] );   	   if ( ( ans == 'G' )  	   ||   ( ans == 'W' )   	   ||   ( ans == 'A' ) ) break; 	}   	   	switch ( ans )* 	{
 	case 'W': 	   istat = pams_get_msgw (  	      msg_area,
 	      &prio,  	      &source,	   s 	      &class,
 	      &type,m 	      &msg_area_len,  	      &len_data,c 	      &timeout, 	      filter, 	      &psb,0,0,0,0,0 );  
 	   break;  
 	case 'G': 	   istat = pams_get_msg ( f 	      msg_area,
 	      &prio,i 	      &source,	   e 	      &class,
 	      &type,i 	      &msg_area_len,t 	      &len_data,l 	      filter, 	      &psb,0,0,0,0,0 );  " 	   if (istat == PAMS__NOMOREMSG ) 	   { 7 	      myprintf ("\nPAMS__NOMOREMSG:  Queue is empty");  	      return ( SS$_NORMAL );i 	   }   
 	   break;  
 	case 'A':2 	   istat = post_pams_ast ( filter,msg_area_len ); 	   return ( istat );  	}   	if (istat != SS$_NORMAL ) I	         { $ 	   if  (istat != PAMS__AREATOSMALL) 	   { $ 	      myprintf ("\npsb:%x, \n%s ", 8 	         psb.del_status, vms_errstr( psb.del_status) );  B 	      myprintf ("\nret:%x, \n%s ", istat, vms_errstr ( istat ) );   	      return ( istat ); 	   }*            else  	   { $ 	      /***************************/$ 	      /* display the return code */$ 	      /***************************/B 	      myprintf ("\nret:%x, \n%s ", istat, vms_errstr ( istat ) ); 	   }o   	}  , 	if ( ( psb.del_status == PAMS__CONFIRMREQ ), 	||   ( psb.del_status == PAMS__POSSDUPL   ), 	||   ( psb.del_status == PAMS__AREATOSMALL). 	||   ( psb.del_status == SS$_NORMAL       ) ) 	{( 	   if ( psb.del_status != SS$_NORMAL ) 9 	      myprintf ("\n%s", vms_errstr ( psb.del_status ) );*   	   msg_area [ len_data ] = 0;  J 	   myprintf ("\nReceived: seq:(%x,%x),src:%d.%d, cls:%d, typ:%d, len:%d", 	      psb.seq[0], psb.seq[1], e* 	      source.au.group, source.au.process, 	      class, type, len_data );l 	   * 	   myprintf ("\ndata: |%s| ", msg_area );  0 	   if ( ( psb.del_status == PAMS__CONFIRMREQ ) 1 	   ||   ( psb.del_status == PAMS__POSSDUPL   ) )c) 	      store_unconfirmed_msg ( psb.seq );    	   return ( istat );c 	} 	elseu 	{! 	   myprintf ("\npsb:%x, \n%s ", *5 	      psb.del_status, vms_errstr( psb.del_status) );2   	   return ( psb.del_status );	         }* }*     *  ; /*********************************************************/ & /* AST rcv msg context. 			         */; /* You need separate context variables for each AST that */ ( /* will be simultaniously posted. 			 */; /*********************************************************/[ static long pams_ast_routine();    typedef struct {a    PAMS_ADDRESS source;2    short	class;     short	type;    short	len_data;    PAMS_PSB	psb;      char		msg_area [ MAX_BUF ]; } PAMS_AST;     2 static long post_pams_ast ( handle, msg_area_len ) short msg_area_len;u
 long *handle;S {     long istat;    PAMS_AST *ap;      short prio                                                                                                                                                                                                                                                                                  [? $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]DMQ$QMENU.C;1                                                                                                Z    <                         [ "               = 0;y  6 	/***************************************************/6 	/* Get some some space for this AST from the heap. */6 	/***************************************************/$ 	ap = malloc ( sizeof (PAMS_AST ) );# 	if ( !ap ) return ( SS$_INSFMEM );d  8 	/*****************************************************/8 	/* Just to be squeeky clean, zero the data structure */8 	/*****************************************************/' 	memset ( ap, 0, sizeof ( PAMS_AST ) );   ; 	/********************************************************/n; 	/* Now post an AST. The AST parameter is the pointer to */o; 	/* the PAMS_AST structure associated with this request. */ ; 	/********************************************************/  	istat = pams_get_msga ( 	      ap->msg_area,
 	      &prio,  	      &(ap->source),n 	      &(ap->class), 	      &(ap->type),* 	      &msg_area_len,/ 	      &(ap->len_data),o 	      handle, 	      &(ap->psb), 	      0,			/* show buffer */*! 	      0,			/* show buffer len */ + 	      0,                	/* nullarg     */  	      0,			/* nullarg     */ + 	      pams_ast_routine,		/* AST address */ ) 	      &ap,			/* AST parm by reference */  	      0,			/* Event flag  */)6               0  );                     /* nullarg3 */   	if ( istat != SS$_NORMAL )= 	{- 	   myprintf ("\n%s", vms_errstr ( istat ) );   9 	   /***************************************************/N9 	   /* release the memory associated with this request */ 9 	   /***************************************************/  	   free ( ap ); 	} 	return ( istat ); }r   (  # static long pams_ast_routine ( ap ) 
 PAMS_AST *ap;s {     long istat;    long cstat  = 0;i    long forcej = 0;n  ' 	myprintf ("\n\t******************* ");=' 	myprintf ("\n\tPAMS AST completion ");n' 	myprintf ("\n\t******************* ");l  0 	if ( ( ap->psb.del_status == PAMS__CONFIRMREQ )0 	||   ( ap->psb.del_status == PAMS__POSSDUPL   )2 	||   ( ap->psb.del_status == SS$_NORMAL       ) ) 	{  , 	   if ( ap->psb.del_status != SS$_NORMAL ) C 	      myprintf ("\n\tpsb:%s", vms_errstr ( ap->psb.del_status ) );0  / 	   if (ap->psb.function_status != SS$_NORMAL ) H 	      myprintf ("\n\tret:%s", vms_errstr ( ap->psb.function_status ) );  & 	   ap->msg_area [ ap->len_data ] = 0;   	   myprintf (B 	   "\n\tReceived: seq:(%x,%x),src:%d.%d, cls:%d, typ:%d, len:%d",' 	      ap->psb.seq[0], ap->psb.seq[1],  2 	      ap->source.au.group, ap->source.au.process,+ 	      ap->class, ap->type, ap->len_data );* 	   0 	   myprintf ("\n\tdata: |%s| ", ap->msg_area );  4 	   if ( ( ap->psb.del_status == PAMS__CONFIRMREQ ) 5 	   ||   ( ap->psb.del_status == PAMS__POSSDUPL   ) )             { 	      if (astlvl_confirm) 	      {  9 	         myprintf ("\n\t*****************************");d3 	         myprintf("\n\tConfirming (%8.8x,%8.8x)",  - 	            ap->psb.seq[0], ap->psb.seq[1]);N9 	         myprintf ("\n\t*****************************");   D 	         istat = pams_confirm_msg ( ap->psb.seq, &cstat, &forcej );$ 	         if ( istat != SS$_NORMAL ) 	         {(: 	            myprintf ("\n\t Confirm rejected: %x \n%s ", - 	               istat, vms_errstr (istat ) );  	         }                }  	      else* 	      {0 	         store_unconfirmed_msg ( ap->psb.seq ); 	      }            } 	} 	else  	{# 	   myprintf ("\n\tpsb:%x, \n%s ", e= 	      ap->psb.del_status, vms_errstr( ap->psb.del_status) );c  E 	   myprintf ("\n\tret:%s", vms_errstr ( ap->psb.function_status ) );   	         }(  6 	/***************************************************/6 	/* release the memory associated with this request */6 	/***************************************************/
 	free ( ap );  }       C /*****************************************************************/RC /* The sequence numbers of unconfirmed messages are linked       */rC /* onto a forward linked list.                                   */ C /* STORE_UNCONFIRMED_MSG places a sequence number on the list.   */vC /* CLEAR_UNCONFIRMED_MSG removes a sequence number from the list */ C /*****************************************************************/l) static long store_unconfirmed_msg ( seq )  long seq[2]; {     long enaflg;p    PAMS_UNCONF *np;d  ( 	np = malloc ( sizeof ( PAMS_UNCONF ) );" 	if (!np ) return ( SS$_INSFMEM );   	np->flink  = 0; 	np->seq[0] = seq[0];s 	np->seq[1] = seq[1];   . 	/*******************************************/. 	/* AST's off while we fiddle with the list */. 	/*******************************************/ 	enaflg = sys$setast(0);       	/***************************/ 	/* Add to head of the list */ 	/***************************/ 	if ( !uncnfhead ) 	   uncnfhead = np;  	else  	{ 	   np->flink = uncnfhead;            uncnfhead = np; 	}           uncnfmsgs++;  . 	if ( enaflg == SS$_WASSET ) sys$setast ( 1 );   }n   d 	s) static long clear_unconfirmed_msg ( seq )= long seq[2]; {     PAMS_UNCONF *np, *prev;    long enaflg;   . 	/*******************************************/. 	/* AST's off while we fiddle with the list */. 	/*******************************************/ 	enaflg = sys$setast(0);   	np = uncnfhead;         prev = 0;0  
 	while ( np )  	{! 	   if ( ( np->seq[0] == seq[0] )f# 	   &&   ( np->seq[1] == seq[1] ) )s 	   {v4 	      /*******************************************/4 	      /* found... cut msg out of the linked list */4 	      /*******************************************/ 	      if ( prev )" 	         prev->flink = np->flink; 	      else " 	         uncnfhead   = np->flink;   	      uncnfmsgs--;s* 	      if ( uncnfmsgs < 0 ) uncnfmsgs = 0;   	      free ( np );                  break; 	   }    	   prev = np; 	   np   = np->flink;e 	}  . 	if ( enaflg == SS$_WASSET ) sys$setast ( 1 ); }q   ; typedef struct {a    long seq[2];  } PAMS_SEQ_NUM;m   static long confirm_msg ( )  {o    long istat;    char *cp;      long cstat  = 0;l    long forcej = 0;	    i    PAMS_UNCONF *np;s    long enaflg;s      PAMS_SEQ_NUM *display;;	    int j;_    char ans;  A 	/**************************************************************/oA 	/* Copy the list of unconfirmed messages into a dynamic array */lA 	/**************************************************************/ : 	display = malloc ( uncnfmsgs * sizeof ( PAMS_SEQ_NUM ) );  . 	enaflg = sys$setast(0);			/* TURN OFF ASTS */   	j = 0;S 	np = uncnfhead;
 	while ( np )  	{# 	   display[j].seq[0] = np->seq[0];*# 	   display[j].seq[1] = np->seq[1];* 	   j++; 	   np = np->flink;m 	}B 	if ( enaflg == SS$_WASSET ) sys$setast ( 1 );	/* ASTS ON AGAIN */   	if ( j == 0 ) / 	{ 	   free ( display ); , 	   myprintf ("\nNo unconfirmed messages "); 	   return ( SS$_NORMAL ); 	}  C 	/****************************************************************/sC 	/* We can now leasurely confirm messages or not as we please... */1C 	/****************************************************************/   	for ( j=uncnfmsgs-1; j>=0; j--) 	{ 	   while ( loop ) 	   {u 	      myprintf ( + 	         "\n Confirm (%x,%x) ? (Y/N) : ",  1 	         display[j].seq[0], display[j].seq[1] );*  ! 	      istat = gets ( msg_area );)4 	      if ( ! istat ) if (feof (stdin) ) exit ( 1 );  & 	      ans = _toupper ( msg_area[0] ); 	      if ( ( ans != 'Y' )& 	      &&   ( ans != 'N' ) ) continue;  
 	      break;s 	   }0   	   if ( ans == 'N') continue;  - 	   clear_unconfirmed_msg ( display[j].seq );   B 	   istat = pams_confirm_msg ( display[j].seq , &cstat, &forcej ); 	   if ( istat != SS$_NORMAL ) 	   { 1 	      myprintf ("\nConfirm rejected: %x \n%s ",  ' 	         istat, vms_errstr (istat ) );  	   }a  	         }&   	free ( display );   	return ( SS$_NORMAL );; }    r   static long locate_q ()a {     int ilen;    long istat;    long ret_stat;i      long wmode = PSYM_WF_RESP;l@    long tbl[] = {PSEL_TBL_PROC, PSEL_TBL_GRP, PSEL_TBL_DNS_LOW};    long tbl_len;    short *tptr;,    long q_address;    char ans;    char why;  
 	while (loop)t 	{E 	   myprintf ("\nSearch scope? (C:cache, L:Local, G:DNS, A:all) : ");  	   istat = gets (msg_area);2 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;  # 	   ans = _toupper ( msg_area[0] );    	   if ( ( ans != 'C' )  	   &&	( ans != 'L' )  	   &&	( ans != 'G' ) ! 	   &&	( ans != 'A' ) ) continue; 
 	   break; 	}
 	tbl_len = 1;t 	switch (ans ) 	{
 	case 'C': 	   tptr    = &tbl[0];
 	   break;
 	case 'L': 	   tptr    = &tbl[1];
 	   break; 	case 'G':	    	   tptr    = &tbl[2];
 	   break;
 	case 'A': 	   tptr    = &tbl[0];! 	   tbl_len = sizeof ( tbl ) / 4; 
 	   break; 	} 	* 	while ( loop )* 	{ 	   myprintf (A 	   "\nS=Send to queue, R=Receive from queue, O=Locate only :                                                                                                                                                                                                                                                                            Yh $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]DMQ$QMENU.C;1                                                                                                Z    <                               ,       ");  	   istat = gets (msg_area);2 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;  # 	   why = _toupper ( msg_area[0] );S   	   if ( ( why != 'S' )  	   &&   ( why != 'R' ) # 	   &&   ( why != 'O' ) ) continue; 
 	   break; 	}, 	if (why == 'S' ) snd_q_address = q_address;, 	if (why == 'R' ) rcv_q_address = q_address;   	myprintf ("\nQueue name? : ");q 	istat = gets ( msg_area );y/ 	if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;    	ilen = strlen ( msg_area );   	ret_stat = pams_locate_q ( B 	   msg_area, &ilen, &q_address, &wmode, 0, 0, tptr, &tbl_len,0 ); /*						^  ^                */F /*                                              |  |                */F /*                                       Trans id  Response queue.  */   	myprintf (y: 	   "\nQueue located. qname:%s, address:%x, ret_stat:%x ", 	   msg_area,  	   q_address, 	   ret_stat );s   	if ( ret_stat != SS$_NORMAL ) 	{1 	   myprintf ("\n%s ", vms_errstr ( ret_stat ) );*	         }A         else 	{/ 	   if (why == 'S' ) snd_q_address = q_address;r/ 	   if (why == 'R' ) rcv_q_address = q_address;i	         }d   	return ( ret_stat );* }*   *   static do_mrs_setup()* {*    long istat;    char ans;   	while (aloop) 	{6 	   myprintf ("\nC = setup confirm, S = setup send "); 	   istat = gets ( msg_area );2 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;    A# 	   ans = _toupper ( msg_area[0] );s   	   if ( ( ans != 'C' ) ! 	   &&	( ans != 'S' ) ) continue;S
 	   break; 	}  
 	switch (ans)  	{
 	case 'S':(            return ( setup_mrs_send () );
 	   break;  
 	case 'C':*            return ( setup_mrs_confirm() );
 	   break; 	} }    / static int setup_mrs_confirm() {*      long istat;    char ans;   	while (aloop) 	{D 	   myprintf ("\nA = Confirm in AST routine, M = Confirm in main "); 	   istat = gets ( msg_area );2 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;  # 	   ans = _toupper ( msg_area[0] );*   	   if ( ( ans != 'A' ) ! 	   &&	( ans != 'M' ) ) continue; 
 	   break;  	         }*   	astlvl_confirm = 0;% 	if (ans == 'A' ) astlvl_confirm = 1;A }p   t    /******************************/  /* Some useful display macros */  /******************************/1 #define np(y)    myprintf("\n%d: %s ", y, "y" ); t0 #define lp(y)    case(y) : myprintf("y"); break;   static int setup_mrs_send () {     long istat;  ) 	/**************************************//) 	/* Prompt with  delivery mode options */ ) 	/**************************************/f 	np (PDEL_MODE_DG_LOG     ); 	np (PDEL_MODE_DG         ); 	np (PDEL_MODE_RTS        ); 	np (PDEL_MODE_WFQ        );#         np (PDEL_MODE_ST_RECOVER );d   	np (PDEL_MODE_WF_SAF     ); 	np (PDEL_MODE_WF_DQF     ); 	np (PDEL_MODE_WF_NET     ); 	np (PDEL_MODE_WF_RCM     ); 	np (PDEL_MODE_WF_MEM     ); 	  	np (PDEL_MODE_AK_SAF     ); 	np (PDEL_MODE_AK_DQF     ); 	np (PDEL_MODE_AK_NET     ); 	np (PDEL_MODE_AK_RCM     ); 	np (PDEL_MODE_AK_MEM     ); 	m 	np (PDEL_MODE_NN_SAF     ); 	np (PDEL_MODE_NN_DQF     ); 	np (PDEL_MODE_NN_NET     ); 	np (PDEL_MODE_NN_RCM     ); 	np (PDEL_MODE_NN_MEM     );   	myprintf (a'          "\n%d: Clear MRS setup", -1 );                   	while ( aloop ) 	{ 	   /*************************/  	   /* Get the user's choice */m 	   /*************************/ # 	   myprintf ("\nDelivery byte: ");* 	   istat = gets ( msg_area );2 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 ) ;  # 	   snd_del_mode = atoi(msg_area );> 	   snd_with_MRS = 1;O  , 	   /**************************************/, 	   /* Echo back the delivery mode chosen */, 	   /**************************************/ 	   switch ( snd_del_mode )u 	   {$ 	   lp ( PDEL_MODE_DG_LOG ); 	   lp ( PDEL_MODE_DG     ); 	   lp ( PDEL_MODE_RTS    ); 	   lp ( PDEL_MODE_WFQ    );'            lp ( PDEL_MODE_ST_RECOVER );e   	   lp ( PDEL_MODE_WF_SAF ); 	   lp ( PDEL_MODE_WF_DQF ); 	   lp ( PDEL_MODE_WF_MEM ); 	  	   lp ( PDEL_MODE_AK_SAF ); 	   lp ( PDEL_MODE_AK_DQF ); 	   lp ( PDEL_MODE_AK_MEM ); 	* 	   lp ( PDEL_MODE_NN_SAF ); 	   lp ( PDEL_MODE_NN_DQF ); 	   lp ( PDEL_MODE_NN_MEM );   	   case ( - 1 ):  	      snd_with_MRS = 0; 	      snd_del_mode = 0; 	      snd_uma      = 0; 	      snd_timeout  = 0; 	      return ( SS$_NORMAL );\              default:*& 	      myprintf ("\n Invalid mode: "); 	      snd_del_mode = -1;  	   } >            if ( snd_del_mode == -1 ) continue;	/* try again */
 	   break;	         }*   )  ! 	/******************************/m! 	/* Get the UMA where required */;! 	/******************************/L 	switch (snd_del_mode) 	{ 	case (PDEL_MODE_NN_SAF ): 	case (PDEL_MODE_WF_SAF ): 	case (PDEL_MODE_AK_SAF ):   	case (PDEL_MODE_NN_DQF ): 	case (PDEL_MODE_WF_DQF ): 	case (PDEL_MODE_AK_DQF ):   	case (PDEL_MODE_WF_MEM ): 	   snd_uma = get_number (J "\nUndel msg. action [1:RTS; 2:DLJ; 3:DLQ; 4:SAF; 5:DISC;6:DISCL]: ",1,6);
 	   break; 	}  0 	/*********************************************/0 	/* if mode is a WF mode, get a timeout value */0 	/*********************************************/ 	switch (snd_del_mode) 	{ 	case PDEL_MODE_ST_RECOVER:h 	case PDEL_MODE_WFQ: 	case PDEL_MODE_WF_SAF:* 	case PDEL_MODE_WF_DQF:  	case PDEL_MODE_WF_MEM:  	   snd_timeout = get_number ( *7 	      "\nDelivery timeout (PAMS units): ", 0, 36000 );b
 	   break; 	}   	snd_with_MRS = 1;   }       + static int get_number ( prompt, low, high ) 
 char *prompt;  int low;	 int high;I {D    int iout;    long istat;   	while ( aloop ) 	{ 	   myprintf ( prompt ); 	   istat = gets ( msg_area );1 	   if ( ! istat ) if (feof (stdin) ) exit ( 1 );* 	   iout = atoi(msg_area);1 	   if ( ( iout<low ) || ( iout>high) ) continue;2   	   return ( iout ); 	} }M   O   #define TEXT_FLAG     1s #define ID_FLAG       2  #define SEVERITY_FLAG 4N #define FACILITY_FLAG 8 H #define ALL_FLAGS (TEXT_FLAG | ID_FLAG | SEVERITY_FLAG | FACILITY_FLAG )   #define VMS_WARNING	  0  #define VMS_SUCCESS	  1d #define VMS_ERROR	  2/ #define VMS_INFORMATIONAL 3* #define	VMS_FATAL	  4    static	char voutbuf[256];* #if 0*4 ****************************************************. A static string area makes this non re-entrant3 but saves us the headache of malloc'ing the string,n and freeing it later.f4 **************************************************** #endif  # static char *vms_errstr ( vmscode )  unsigned long vmscode; {f$ 	struct dsc$descriptor voutbuf_desc;   	short ilen;         long istat;n  & 	voutbuf_desc.dsc$a_pointer = voutbuf;;         voutbuf_desc.dsc$w_length  = sizeof (voutbuf ) - 1;/, 	voutbuf_desc.dsc$b_dtype   = DSC$K_DTYPE_T;, 	voutbuf_desc.dsc$b_class   = DSC$K_CLASS_S;  E 	istat =  sys$getmsg ( vmscode, &ilen, &voutbuf_desc, ALL_FLAGS, 0 );q  >         voutbuf [ ilen ] = 0;	/* null terminate the string **/   	return ( voutbuf ); }*     *  5 /***************************************************//5 /* Routine so we dont printf inside of a printf... */ 5 /***************************************************/ I static long myprintf ( fmt, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11) 
 char *fmt;* long p1,p2,p3,p4,p5,p6, p7,p8,p9, p10,p11; {p    long enaflg;           enaflg = sys$setast ( 0 );         printf ( i5 	fmt, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11 );   2       if (enaflg == SS$_WASSET ) sys$setast ( 1 ); }S                                                                                                                                                                                                                                                                                                                                             * [DMQ$V20.EXAMPLES]ECHO.PSS;1 +  , B   .     /     4        "                    - B    0   1    2   3      K  P   W   O     5   6 ]ᗍ  7 p  8          9 Z  G    H  J                   
 SET SEND ECHO  SET RECEIVE ECHO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            * [DMQ$V20.EXAMPLES]GETMSG_AST.C;1 +  , B   .     /     4 O       8                   - B    0   1    2   3      K  P   W   O     5   6   7 q  8          9 Z  G    H  J                                                                                                                                                                                                                                   
                        P $      DMQ020.B                       B  B   [DMQ$V20.EXAMPLES]GETMSG_AST.C;1                                                                                               O                             i               #module GETMSG_AST "DMQ V2.0-00"N /*****************************************************************************$  *  DECMessageQ for VMS							     *N  *                                                                           *;  *  Copyright (c) 1990                    			             * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/    #if 0     program:	GETMSG_AST.C E date written:	November 1989   - Randy Skelding (PAMS RESOURCE CENTER) 6 modified:	January  1991	- RTS (Convert to DECmessageQ)
 description:	   2 This program demonstrates the use of PAMS_GET_MSGA0 to accept PAMS messages in AST service routines.  > This program differs from GETMSG_EF.C in that PAMS_GET_MSGA isA called at AST level. Mainline is frequently blocked in a standard  C read to the terminal.   ? You can send messages to GETMSG_AST with the DMQ$QMENU program.   4 compile: $ cc/list/obj/include=dmq$user getmsg_ast.c* link:    $ link getmsg_ast,dmq$lib:dmq/opt   #endif   #include <iodef.h> #include <ssdef.h> #include <stdio.h> #include <descrip.h>   /* portable includes */  #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "p_entry.h" #include "p_group.h"      % /***********************************/ % /* PAMS data structure definitions */ % /***********************************/ 
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group;     } au; } PAMS_ADDRESS ;   typedef struct   {     short int type;    short int cd;    long int del_status;     long int seq[2];     long int uma_status;     long int unused[3]; } PAMS_PSB;   < /**********************************************************/< /* SEE VT220 PROGRAMMER POCKET GUIDE FOR ESCAPE SEQUENCES */< /**********************************************************/ #define CLEAR    "\033[2J"" #define LINE(n)  "\033[n;0H\033[K" #define DECSC    "\0337" #define DECRC    "\0338" #define EL       "\033[K"        static char msgbuf[8192];  static char qname [32];    /**************************/ /* Input to pams_get_msga */ /**************************/ static void	pams_ast();  short 		filter[2]    = {0,0};  short 		prio         = 0;    /*****************************/  /* output from pams_get_msga */  /*****************************/  PAMS_ADDRESS	source; short 		class;
 short 		type; & short		msg_area_len = sizeof (msgbuf); short		len_data;
 PAMS_PSB	psb;    /*************************/  /* Terminal input buffer */  /*************************/  char	 	ttinbuf[256];       const int loop   = 1;    static main () {     PAMS_ADDRESS mypamsid;     long requested_id = 0;     long istat;
    long ilen;   ,    long attach_mode = PSYM_ATTACH_TEMPORARY;  6 	/***************************************************/6 	/* Attach to PAMS as a temporary queue, but with a */( 	/* name that others can locate.			   */6 	/***************************************************/ 	while ( loop )  	{ 	   printf ("\nPQ name ? "); 	   gets ( ttinbuf );    	   ilen = strlen ( ttinbuf );  @ 	   istat = pams_attach_q (&attach_mode, &mypamsid, 0, ttinbuf, 4                                   &ilen,0,0,0,0,0 );   	   if ( istat != SS$_NORMAL ) 	   { 2 	      printf ("\nAttach Q refused: %x ", istat ); 	      continue; 	   } 
 	   break; 	}       	/********************/  	/* CLEAR THE SCREEN */  	/********************/  	printf ("%s", CLEAR );    	/*******************/ 	/* POST A PAMS AST */ 	/*******************/ 	istat = pams_get_msga (  E 	   msgbuf, &prio, &source, &class, &type, &msg_area_len, &len_data,  8            filter, &psb, 0, 0, 0, 0, pams_ast, 0, 0, 0);  + 	if ( istat != SS$_NORMAL ) exit ( istat );        	while ( loop )  	{, 	   /**************************************/, 	   /* WAIT FOR USER TO TYPE IN SOMETHING */, 	   /**************************************// 	   printf ("%s%s", LINE(10), "Enter text: " );    	   gets ( ttinbuf );   9 	   /***************************************************/ 9 	   /* Leave the loop if the user hit Carriage Return, */ 9 	   /* otherwise display what he typed                 */ 9 	   /***************************************************/  	   ilen = strlen ( ttinbuf );   	   if ( ilen == 0 ) break; % 	   if ( ilen > 70 ) ttinbuf[70] = 0;   . 	   printf ("%stty: |%s|", LINE(3), ttinbuf ); 	}  # 	printf ("%s%s", LINE(11), "Exit");    }         ! static void pams_ast ( ast_parm )  long ast_parm; { 
    int istat;     long cstat  = 0;     long forcej = 0;   . 	if ( psb.del_status == PAMS__CANCEL ) return;  + 	if ( (psb.del_status != SS$_NORMAL       ) + 	&&   (psb.del_status != PAMS__CONFIRMREQ ) , 	&&   (psb.del_status != PAMS__POSSDUPL   )) 	{( 	   printf ("%s%sDelivery error: %x%s", / 		    DECSC, LINE(4), psb.del_status, DECRC );   	   return;  	}  $ 	if ( len_data > 70 ) len_data = 70;/ 	msgbuf[ len_data] = 0;	/* make string ASCIZ */   8 	printf ("%s%smsg: |%s|%s",DECSC,LINE(2),msgbuf,DECRC );  + 	if ( (psb.del_status == PAMS__CONFIRMREQ ) - 	||   (psb.del_status == PAMS__POSSDUPL   ) )  	{: 	   istat = pams_confirm_msg ( psb.seq, &cstat, &forcej ); 	   if ( istat != SS$_NORMAL ) 	   { / 	      printf ("%s%sConfirmation error: %x%s",  - 	            DECSC, LINE(4), istat, DECRC );   	      return; 	   } 	         }    	/*************************/ 	/* POST THE NEXT DMQ AST */ 	/*************************/ 	istat = pams_get_msga (  E 	   msgbuf, &prio, &source, &class, &type, &msg_area_len, &len_data,  9            filter, &psb, 0, 0, 0, 0, pams_ast, 0, 0, 0 );    	if ( istat != SS$_NORMAL )  	{+ 	   printf ("%s%sError posting AST: %x%s",  - 	            DECSC, LINE(4), istat, DECRC );   	   return;  	} }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        * [DMQ$V20.EXAMPLES]GETMSG_EF.C;1 +  , B   .     /     4 O       N                  - B    0   1    2   3      K  P   W   O     5   6 6##  7 
q  8          9 Z  G    H  J                 #module GETMSG_EF "DMQ V2.0-00"   N /*****************************************************************************$  *  DECMessageQ for VMS							     *N  *                                                                           *;  *  Copyright (c) 1990                    			             * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           Lg $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]GETMSG_EF.C;1                                                                                                O                             c                *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/      #if 0     program:	GETMSG_EF.CA date written:	November 1989	Randy Skelding (PAMS RESOURCE CENTER) > date modified:  January  1991   RTS  -- Convert to DECmessageQ
 description:	   2 This program demonstrates the use of PAMS_GET_MSGA9 to set an event flag on when a PAMS message is delivered. B The process waits on a logical or of 2 event flags, one associated; with terminal I/O and the other with PAMS message delivery.   3 compile: $ cc/list/obj/include=dmq$user getmsg_ef.c ) link:    $ link getmsg_ef,dmq$lib:dmq/opt    #endif   #include <iodef.h> #include <ssdef.h> #include <libdef.h>  #include <stdio.h> #include <descrip.h> /* portable includes */  #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "p_entry.h" #include "p_group.h"        % /***********************************/ % /* PAMS data structure definitions */ % /***********************************/ 
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group;     } au; } PAMS_ADDRESS ;   typedef struct   {     short int type;    short int cd;    long int del_status;     long int seq[2];     long int uma_status;     long int unused[3]; } PAMS_PSB;   < /**********************************************************/< /* SEE VT220 PROGRAMMER POCKET GUIDE FOR ESCAPE SEQUENCES */< /**********************************************************/ #define CLEAR    "\033[2J"" #define LINE(n)  "\033[n;0H\033[K" #define DECSC    "\0337" #define DECRC    "\0338" #define EL       "\033[K"        static char msgbuf[8192];  static char qname [32];    /*********************/  /* queue identifiers */  /*********************/  PAMS_ADDRESS mypamsid; long handle = 0;   /***************************/  /* Input to pams_get_msg_a */  /***************************/  long		pamsefn;   short 		filter[2] = {0,0}; short 		prio   = 0;    /**************************/ /* output after AST fires */ /**************************/ PAMS_ADDRESS	source; short 		class;
 short 		type; & short		msg_area_len = sizeof (msgbuf); short		len_data;
 PAMS_PSB	psb;     ' /*************************************/ ' /* Data structures for terminal ASTs */ ' /*************************************/ 
 long 		ttefn;    $DESCRIPTOR (ttdesc, "TT:"); long   		ttchan; short  		ttiosb[4];  char	 	ttinbuf[256];   long efnmask  = 0; long efnstate = 0;       static main () {     long requested_id = 0;     long istat;
    long ilen;       int loop   = 1;      long ttemask;    long pamsemask;,    long attach_mode = PSYM_ATTACH_TEMPORARY;  9 	/******************************************************/ 9 	/* Attach to PAMS as a temporary process, but with a  */ + 	/* name that others can locate.			      */ 9 	/******************************************************/  	while ( loop )  	{ 	   printf ("\nPQ name ? "); 	   gets ( ttinbuf );    	   ilen = strlen ( ttinbuf );  A 	   istat = pams_attach_q ( &attach_mode, &mypamsid, 0, ttinbuf,  5                                    &ilen,0,0,0,0,0 );  	   if ( istat != SS$_NORMAL ) 	   { 2 	      printf ("\nAttach Q refused: %x ", istat ); 	      continue; 	   } 
 	   break; 	}    8 	/*****************************************************/8 	/* Setup 2 event flags , they must be in cluster # 1 */8 	/*****************************************************/ 	istat = lib$get_ef ( &ttefn ); , 	if ( ttefn / 32 != 1 ) exit ( LIB$_INSEF ); 	ttemask = 1 << ( ttefn - 32 );   ! 	istat = l    )                        $      DECW$MOTIF011.A                0?  d/\  *[SYSHLP.EXAMPLES.DECW.UTILS]XWININFO.EXE;2                                                                                          *                         u@ 
     %        Pĭ ЬRbhPGRS ЬVfŏP   iQjR PAP`Rt  Phfĳ \P ЬRbhPCRS ԭ߭ ЬRbkխ߭ bkխݼ мWS1W P ^@RS ݬ  P 1 ) ) exit ( istat );    	/*****************************/  	/* POST A TERMINAL INPUT AST */  	/*****************************/ 	istat = sys$qio (  / 	   ttefn, ttchan, IO$_READVBLK, ttiosb, 0, 0,  ( 	   ttinbuf, sizeof(ttinbuf), 0,0,0,0 );   	/*********************/ 	/* POST THE PAMS AST */ 	/*********************/ 	istat = pams_get_msga (  + 	   msgbuf, &prio, &source, &class, &type,   	   &msg_area_len, &len_data, 9            filter, &psb, 0, 0, 0, 0, 0, 0, &pamsefn , 0);    	/********************/  	/* CLEAR THE SCREEN */  	/********************/  	printf ("%s", CLEAR );        	while ( loop )  	{  ( 	   /**********************************/( 	   /* PROMPT FOR INPUT FROM TERMINAL */( 	   /**********************************// 	   printf ("%s%s", LINE(10), "Enter text: " );    	   /*********************/  	   /* Wait for an event */  	   /*********************/ * 	   istat = sys$wflor ( ttefn,  efnmask );  ) 	   /***********************************/ ) 	   /* Find out which event woke us up */ ) 	   /***********************************/ , 	   istat = sys$readef ( ttefn, &efnstate );    	   if ( efnstate & pamsemask ) 	 	   {	    # 	      istat = handle_pams_event();  	      if (!istat ) break; 	   }   	   if ( efnstate & ttemask   )  	   { ! 	      istat = handle_tt_event();  	      if (!istat ) break; 	   }    	} /* End while */  # 	printf ("%s%s", LINE(11), "Exit");  }               static long handle_pams_event () { 
    int istat;     long cstat  = 0;     long forcej = 0;    	/***********************/ 	/* PAMS AST WOKE US UP */ 	/***********************/* 	if ((psb.del_status != PAMS__CONFIRMREQ )* 	&&  (psb.del_status != PAMS__POSSDUPL   )+ 	&&  (psb.del_status != SS$_NORMAL       ))  	{* 	   printf ("%s%s%sDelivery error: %x%s", 0 	      DECSC, LINE(4), psb.del_status, DECRC );  	   return ( 0 );  	}  $ 	if ( len_data > 70 ) len_data = 70;  6         msgbuf[ len_data] = 0;	/* make string ASCIZ */  8 	printf ("%s%sMsg: |%s|%s",DECSC,LINE(2),msgbuf,DECRC );  , 	if ( ( psb.del_status == PAMS__CONFIRMREQ ). 	||   ( psb.del_status == PAMS__POSSDUPL   ) ) 	{" 	   /****************************/" 	   /* CONFIRMATION IS REQUIRED */" 	   /****************************/: 	   istat = pams_confirm_msg ( psb.seq, &cstat, &forcej ); 	   if ( istat != SS$_NORMAL ) 	   { / 	      printf ("%s%sConfirmation error: %x%s",  * 	         DECSC, LINE(4), istat, DECRC );  	      return ( 0 ); 	   } 	         }    	/**************************/  	/* POST THE NEXT PAMS AST */  	/**************************/  	istat = pams_get_msga (  + 	   msgbuf, &prio, &source, &class, &type,   	   &msg_area_len, &len_data, 9            filter, &psb, 0, 0, 0, 0, 0, 0, &pamsefn , 0);    	if ( istat != SS$_NORMAL )  	{+ 	   printf ("%s%sError posting AST: %x%s",  ' 	      DECSC, LINE(4), istat, DECRC );   	   return ( 0 );  	}   	return ( 1 ); }        static long handle_tt_event () {     int ilen;
    int istat;   6 	/***************************************************/6 	/* Leave the loop if the user hit Carriage Return, */6 	/* otherwise display what he typed                 */6 	/***************************************************/ 	ilen = ttiosb [1];  	if ( ilen > 70 ) ilen = 70;  3 	ttinbuf[ilen] = 0;	/* Null terminate the string */   6 	if ( ilen == 0 ) return ( 0 );	/* Cause us to exit */  9 	printf ("%s%stty: |%s|%s",DECSC,LINE(3),ttinbuf,DECRC );     	/*****************************/  	/* POST A TERMINAL INPUT AST */  	/*****************************/ 	istat = sys$qio (  / 	   ttefn, ttchan, IO$_READVBLK, ttiosb, 0, 0,  ( 	   ttinbuf, sizeof(ttinbuf), 0,0,0,0 );   	return ( 1 ); }                                                                                                                                                                                                 * [DMQ$V20.EXAMPLES]MRS.DIR;1 +  , B   .     /     4                            - B    0  1    2   3     K  P   W   O     5   6 ~ޕ  7  .  8          9 Z  G    H  J  I                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         2dz $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]MRS.DIR;1                                                                                                                                               
DQF_CONTROL.C  B     JTEST.C  B     SINK.C B     SRC.C  B     VALID.C  B                                                                                                                                                                                                                                                                                                                                                                                                                               % * [DMQ$V20.EXAMPLES.MRS]DQF_CONTROL.C;1 +  , B   . ,    /     4 Q   ,   ) ~                   - B    0   1    2   3      K  P   W   O -    5   6 `5_  7  s  8          9 Z  G    H  J                           /*  * DQF_CONTROL.C    *>  * Demonstrate programable control of DQF OPEN/CLOSE/FAILOVER./  * Demonstrate the use of the QTRANSFER server.   */    #include stdio #include ssdef #include descrip #include syidef    #include pams_c_entry_point  #include pams_c_process  #include pams_c_group    #include pams_c_type_class! #include pams_c_return_status_def  #include pams_c_symbol_def  
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group;     } au; } PAMS_ADDRESS;    /*****************/  /* message types */  /*****************/   #define MSG_TYPE_MRS_IMSG		-870	  & #define MSG_TYPE_MRS_DQF_TRANSFER	-700, #define MSG_TYPE_MRS_DQF_TRANSFER_ACK   -701, #define MSG_TYPE_MRS_DQF_TRANSFER_REP   -702  , #define MSG_TYPE_MRS_DQF_SET            -704, #define MSG_TYPE_MRS_DQF_SET_REP        -705  
 /***********/ 
 /* Targets */ 
 /***********/   #define PAMS_QTRANSFER_SERVER 95  #define PAMS_MRS_SERVER       98  #define PAMS_TRANSPORT       100   char *vms_errstr();       ; /*********************************************************/ ; /* Request a temporary PAMS id, store the id in mypamsid */ ; /*********************************************************/  long req_pamsid = 0; PAMS_ADDRESS mypamsid; long int attach_mode,q_type; /*************************/  /* terminal input buffer */  /*************************/  char inbuf[256];  ( /**************************************/( /* Put our node name here, if defined */( /**************************************/ char nn_buff[16];  long int nn_len;  ) /***************************************/ ) /* Root specification of all DQF files */ ) /***************************************/ . char    *dqf_fileroot = "PAMS$MRS_FILES:MRS_";  1 /***********************************************/ 1 /* Selection indexes for synchronous dialogues */ 1 /***********************************************/  static long select_imsg  = 0;  static long select_qtran = 0;  static long select_dset  = 0;    static main () {   
    int istat;     int loop = 1;  % 	/**********************************/ % 	/* Declare as a temporary process */ % 	/**********************************/ ,         attach_mode = PSYM_ATTACH_TEMPORARY;          q_type = PSYM_ATTACH_PQ;Q         istat = pams_attach_q (&attach_mode,&mypamsid.all,&q_type,0,0,0,0,0,0,0);   ( 	if (istat != SS$_NORMAL ) goto THE_END;  3 	/************************************************/ 3 	/* Talk to TRANSPORT to get MRS parameters      */ :         /* to get the value of TAG_FILES_WITH_NODENAME  */3 	/************************************************/          istat = get_imsg ();( 	if (istat != SS$_NORMAL ) goto THE_END;  
 	while (loop)  	{D 	   printf ("\nO:open, C:Close, F:Failover, T:Transfer, E:Exit >" ); 	   istat = gets (inbuf); 0 	   if (!istat) if (feof (stdin) ) goto THE_END;   	   istat = 0;   	   switch (inbuf[0] )            {
 	   case 'O':  	      istat = do_open(); 
 	      break;   
 	   case 'C': !               istat = do_close(); 
 	      break;   
 	   case 'F':  	      istat = do_failover(); 
 	      break;   
 	   case 'T':  	      istat = do_qtran();
 	      break;   
 	   case 'E':  	      goto THE_END;   	   default:               istat = 1;/ 	      printf ("\nInvalid option: try again."); 
 	      break;  	  	   }     	   if ( (istat != SS$_NORMAL ) ! 	   &&   (istat != 0          ) )  	   { 5               printf ("\n%s", vms_errstr ( istat ) );  	   }  	}   THE_END: 	printf ("\nProgram exit");  }       J /************************************************************************/J /* The MSG_TYPE_MRS_IMSG message may change from version to version.    */J /* This example does not imply a commitment to maintain this interface  */J /* It is used here to find out the value of the TAG_FILES_WITH_NODENAME */, /* parameter to PAMSINIT.TXT.					        */J /************************************************************************/   struct MRS_IMSG_STRUCT   {                     ) 	short 	version;		/* MRS version = 1 		*/ / 	long	chunk_size;		/* DQF chunk size (bytes)	*/ ' 	long	q_size;			/* DQF size (bytes)		*/ 7 	long 	prsnt_bytes;		/* startup delivery flow stop   */  	long	max_messages;  	long	max_processes; 	long	max_saf_files; 	long	saf_file_size; 	long	net_timer; 	long 	elastic_timer;  	char	tag_files; 	long	small_bufsize; 	long	med_bufsize; 	long	large_bufsize; 	char	pcj_filename[64];  	char	dlj_filename[64];  };( typedef struct MRS_IMSG_STRUCT MRS_IMSG;   long get_imsg () {     MRS_IMSG imsg;   &    long  target      = PAMS_TRANSPORT;    short prio        = 0; )    short type        = MSG_TYPE_MRS_IMSG; $    short class       = MSG_CLAS_MRS;    short delivery    = 0;     long  length      = 0;     long  timeout     = 300;     PAMS_ADDRESS source;       long istat;  &    long int item_code = SYI$_NODENAME;!    $DESCRIPTOR(nn_desc, nn_buff);      >        	istat = lib$getsyi(&item_code,0,&nn_desc,&nn_len,0,0);, 	if( istat != SS$_NORMAL ) return ( istat );   	if (! select_imsg ) 	{# 	   istat = make_selection_index (  5 	      &select_imsg, &target, MSG_TYPE_MRS_IMSG, 0 ); / 	   if (istat != SS$_NORMAL ) return ( istat ); 	         }   ) 	/**************************************/ ) 	/* Synchonous dialogue with TRANSPORT */ ) 	/**************************************/ - 	istat = pams_put_msg(&imsg,  &prio, &target, ! 			     &class, &type, &delivery,  			     &length, &timeout );  ) 	if (istat != SS$_NORMAL) return (istat);    	istat = pams_get_msgw(&imsg,  		   &prio, &source," 		   &class, &type, &sizeof(imsg),& 		   &length,&timeout, &select_imsg );  + 	if (istat != SS$_NORMAL) return ( istat );   ' 	if ( imsg.tag_files == 0 ) nn_len = 0;          nn_buff[nn_len] = 0;   	return ( SS$_NORMAL );  }      struct DQF_TRANSFER_STRUCT   {        short	version;       long	utag;1       short 	status; 		/* 1 For success else 0 */   7       long	send_count;		/* number of msgs transfered */   C       short 	from_dqfspec_len;	/* # chars in dqf_fspec           */ B       char	from_dqfspec[256];	/* file specification of dqf file */?       short	to_procnum; 		/* targer process for the transfer */  };      0 typedef struct DQF_TRANSFER_STRUCT DQF_TRANSFER;   long do_qtran()  {     DQF_TRANSFER qtran;  ?    short prio, class, type, delivery, msg_size, size, len_data;     long timeout;  
    int istat;          PAMS_ADDRESS from_dqf;     PAMS_ADDRESS to_dqf;     PAMS_ADDRESS tgt;    PAMS_ADDRESS src;      int loop = 1;* 	/***************************************/* 	/* Get FROM and TO addresses from user */* 	/***************************************/ 	printf ("\nFROM group: ");          istat = gets ( inbuf ); /         if (!istat ) if (feof(stdin) ) exit(1);   *         from_dqf.au.group = atoi (inbuf );K         if (from_dqf.au.group == 0 ) from_dqf.au.group = mypamsid.au.group;    	printf ("\nFROM queue: ");          istat = gets ( inbuf ); /         if (!istat ) if (feof(stdin) ) exit(1);   ,         from_dqf.au.process = atoi (inbuf );   	printf ("\nTO group: ");          istat = gets ( inbuf ); /         if (!istat ) if (feof(stdin) ) exit(1);   (         to_dqf.au.group = atoi (inbuf );G         if (to_dqf.au.group == 0 ) to_dqf.au.group = mypamsid.au.group;    	printf ("\nTO queue: ");          istat = gets ( inbuf ); /         if (!istat ) if (feof(stdin) ) exit(1);   *         to_dqf.au.process = atoi (inbuf );   	/**********************/  	/* Format the message */  	/**********************/ ? 	memset ( qtran.from_dqfspec, 0, sizeof (qtran.from_dqfspec) );   + 	strcpy (qtran.from_dqfspec, dqf_f                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES.MRS]DQF_CONTROL.C;1                                                                                          Q    ,                         h "            ileroot); & 	strcat (qtran.from_dqfspec, nn_buff);8 	sprintf(qtran.from_dqfspec+strlen(dqf_fileroot)+nn_len, 		"_%x", 		from_dqf.all ); ,         strcat (qtran.from_dqfspec, ".DQF");  7 	qtran.from_dqfspec_len = strlen (qtran.from_dqfspec );   & 	qtran.to_procnum = to_dqf.au.process;   	qtran.status  = 0;  	qtran.version = 0;  	qtran.utag    = 0;      % 	/**********************************/ % 	/* Set up PAMS_PUT_MSG parameters */ % 	/**********************************/  	prio     = 0; 	class    = MSG_CLAS_MRS; & 	type     = MSG_TYPE_MRS_DQF_TRANSFER;  *         tgt.au.group    = to_dqf.au.group;) 	tgt.au.process  = PAMS_QTRANSFER_SERVER;    	delivery = PDEL_MODE_WFQ;$ 	size     = sizeof ( DQF_TRANSFER ); 	timeout  = 300;   	if (! select_qtran )  	{# 	   istat = make_selection_index (   	      &select_qtran, &tgt, % 	      MSG_TYPE_MRS_DQF_TRANSFER_ACK, ' 	      MSG_TYPE_MRS_DQF_TRANSFER_REP ); / 	   if (istat != SS$_NORMAL ) return ( istat ); 	         }   1 	/**********************************************/ 1 	/* Synchronous Dialogue with QTRANSFER_SERVER */ 1 	/**********************************************/  	istat = pams_put_msg ( E 	   &qtran, &prio, &tgt, &class, &type, &delivery, &size, &timeout );   + 	if (istat != SS$_NORMAL) return ( istat );    	while ( loop )  	{            prio = 0;          	   istat = pams_get_msgw ( C               &qtran, &prio, &src,&class, &type, &size, &len_data,  ! 	      &timeout, &select_qtran );   +            if (istat != SS$_NORMAL ) break;   7            if ( type == MSG_TYPE_MRS_DQF_TRANSFER_ACK )             {$               if (qtran.status == 0) 	      {4                  printf ("\nDQF transfer refused ");                  break;                }             }5 	   else if ( type == MSG_TYPE_MRS_DQF_TRANSFER_REP )             {$               if (qtran.status == 1)               { A                  printf ("\nDQF transfer OK, %d msgs transfered", % 	                 qtran.send_count );                }                else 	      {F                  printf ("\nDQF transfer failed, %d msgs transfered ",% 	                 qtran.send_count );                }                break;            } 	}   	return ( istat ); }       ' /*************************************/ ' /* ACTION VALUES FOR DQF_SET message */ ' /*************************************/  #define DQF_SET_OPEN     1 #define DQF_SET_CLOSE    2 #define DQF_SET_FAILOVER 3  ' /*************************************/ ' /* STATUS VALUES FOR DQF_SET message */ ' /*************************************/  #define DQF_SET_ERROR    0 #define DQF_SET_SUCCESS  1 #define DQF_SET_REFUSED  2   struct DQF_SET_STRUCT  {v       short	version;       short	action;		        long	status;  #       PAMS_ADDRESS original_target;_       PAMS_ADDRESS new_target; };& typedef struct DQF_SET_STRUCT DQF_SET;   long do_failover() {_    DQF_SET dset;  ?    short prio, class, type, delivery, msg_size, size, len_data;     long timeout;
    int istat;       PAMS_ADDRESS from_dqf;     PAMS_ADDRESS to_dqf;     PAMS_ADDRESS tgt;    PAMS_ADDRESS src;      int loop = 1;     . 	/*******************************************/. 	/* Get FROM and TO addresses from the user */. 	/*******************************************/ 	printf ("\nFROM group: ");A         istat = gets ( inbuf );Y/         if (!istat ) if (feof(stdin) ) exit(1);M  *         from_dqf.au.group = atoi (inbuf );K         if (from_dqf.au.group == 0 ) from_dqf.au.group = mypamsid.au.group;S   	printf ("\nFROM queue: ");A         istat = gets ( inbuf );m/         if (!istat ) if (feof(stdin) ) exit(1);*  ,         from_dqf.au.process = atoi (inbuf );   	printf ("\nTO group: ");d         istat = gets ( inbuf );*/         if (!istat ) if (feof(stdin) ) exit(1);g  (         to_dqf.au.group = atoi (inbuf );G         if (to_dqf.au.group == 0 ) to_dqf.au.group = mypamsid.au.group;u   	printf ("\nTO queue: ");*         istat = gets ( inbuf ); /         if (!istat ) if (feof(stdin) ) exit(1);o  *         to_dqf.au.process = atoi (inbuf );   	/**********************/  	/* Format the message */t 	/**********************/*) 	dset.original_target.all = from_dqf.all;c' 	dset.new_target.all      = to_dqf.all;*- 	dset.action              = DQF_SET_FAILOVER;r   	dset.status  = 0; 	dset.version = 0;      	prio     = 0; 	class    = MSG_CLAS_MRS;c! 	type     = MSG_TYPE_MRS_DQF_SET;u  *         tgt.au.group    = to_dqf.au.group;# 	tgt.au.process  = PAMS_MRS_SERVER;    	delivery = PDEL_MODE_WFQ; 	size     = sizeof ( DQF_SET );  	timeout  = 300;   	if (! select_dset ) 	{# 	   istat = make_selection_index ( *9 	      &select_dset, &tgt, MSG_TYPE_MRS_DQF_SET_REP, 0 );*/ 	   if (istat != SS$_NORMAL ) return ( istat ); 	         }d  1 	/**********************************************/A1 	/* Synchronous Dialogue with QTRANSFER_SERVER */,1 	/**********************************************/t 	istat = pams_put_msg ( D 	   &dset, &prio, &tgt, &class, &type, &delivery, &size, &timeout );  + 	if (istat != SS$_NORMAL) return ( istat );   - 	/******************************************/A- 	/* We expect MSG_TYPE_DQF_SET_REP back... */*- 	/******************************************/  	istat = pams_get_msgw (  B               &dset, &prio, &src,&class, &type, &size, &len_data,   	      &timeout, &select_dset );  3         if (istat != SS$_NORMAL ) return ( istat );t   	switch (dset.status)  	{ 	case DQF_SET_ERROR:1            printf ("\nError prevented failover");i
 	   break;   	case DQF_SET_SUCCESS:,            printf ("\nFailover successful");
 	   break; 	e 	case DQF_SET_REFUSED:)            printf ("\nFailover refused");k
 	   break;  	 	default: 3            printf ("\nUnexpected status returned");'
 	   break; 	}   	return ( istat ); }          long do_open() {     DQF_SET dset;  ?    short prio, class, type, delivery, msg_size, size, len_data;(    long timeout;  
    int istat;s      PAMS_ADDRESS dqf;    PAMS_ADDRESS tgt;    PAMS_ADDRESS src;      int loop = 1;      	printf ("\ngroup: ");         istat = gets ( inbuf ); /         if (!istat ) if (feof(stdin) ) exit(1);*  %         dqf.au.group = atoi (inbuf );PA         if (dqf.au.group == 0 ) dqf.au.group = mypamsid.au.group;i   	printf ("\nqueue: ");         istat = gets ( inbuf );r/         if (!istat ) if (feof(stdin) ) exit(1);e  '         dqf.au.process = atoi (inbuf );m  $ 	dset.original_target.all = dqf.all; 	dset.new_target.all      = 0;) 	dset.action              = DQF_SET_OPEN;    	dset.status  = 0; 	dset.version = 0;      	prio     = 0; 	class    = MSG_CLAS_MRS; ! 	type     = MSG_TYPE_MRS_DQF_SET;i  '         tgt.au.group    = dqf.au.group; # 	tgt.au.process  = PAMS_MRS_SERVER;    	delivery = PDEL_MODE_WFQ; 	size     = sizeof ( DQF_SET );a 	timeout  = 300;   	if (! select_dset ) 	{# 	   istat = make_selection_index ( e9 	      &select_dset, &tgt, MSG_TYPE_MRS_DQF_SET_REP, 0 );n/ 	   if (istat != SS$_NORMAL ) return ( istat );i	         }   1 	/**********************************************/S1 	/* Synchronous Dialogue with QTRANSFER_SERVER */I1 	/**********************************************/; 	istat = pams_put_msg ( D 	   &dset, &prio, &tgt, &class, &type, &delivery, &size, &timeout );  + 	if (istat != SS$_NORMAL) return ( istat );l  - 	/******************************************/0- 	/* We expect MSG_TYPE_DQF_SET_REP back... */ - 	/******************************************/E 	istat = pams_get_msgw (  B               &dset, &prio, &src,&class, &type, &size, &len_data,   	      &timeout, &select_dset );  3         if (istat != SS$_NORMAL ) return ( istat );    	switch (dset.status)  	{ 	case DQF_SET_ERROR:-            printf ("\nError prevented open");S
 	   break;   	case DQF_SET_SUCCESS:(            printf ("\nOpen successful");
 	   break; 	y 	case DQF_SET_REFUSED:%            printf ("\nOpen refused");*
 	   break;  	 	default:=3            printf ("\nUnexpected status returned");s
 	   break; 	}     	return ( istat ); }e   ;   long do_close()S {O    DQF_SET dset;  ?    short prio, class, type, delivery, msg_size, size, len_data;&    long timeout;  
    int istat;&      PAMS_ADDRESS dqf;    PAMS_ADDRESS tgt;    PAMS_ADDRESS src;      int loop = 1;    g 	printf ("\ngroup: ");         istat = gets ( inbuf ); /         if (!istat ) if (feof(stdin) ) exit(1);D  %         dqf.au.group = atoi (inbuf );sA         if (dqf.au.group == 0 ) dqf.au.group = mypamsid.au.group;e   	printf ("\nqueue: ");         istat = gets ( inbuf );r/         if (!istat ) if (feof(stdin) ) exit(1);r  '         dqf.au.process = atoi (inbuf );o  $ 	dset.original_target.all = dq                                                                                                                                                                                                                                                                            $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES.MRS]DQF_CONTROL.C;1                                                                                          Q    ,                         z      !       f.all; 	dset.new_target.all      = 0;* 	dset.action              = DQF_SET_CLOSE;   	dset.status  = 0; 	dset.version = 0;      	prio     = 0; 	class    = MSG_CLAS_MRS;D! 	type     = MSG_TYPE_MRS_DQF_SET;,  '         tgt.au.group    = dqf.au.group;_# 	tgt.au.process  = PAMS_MRS_SERVER;t   	delivery = PDEL_MODE_WFQ; 	size     = sizeof ( DQF_SET );  	timeout  = 300;   	if (! select_dset ) 	{# 	   istat = make_selection_index ( *9 	      &select_dset, &tgt, MSG_TYPE_MRS_DQF_SET_REP, 0 );m/ 	   if (istat != SS$_NORMAL ) return ( istat );*	         }   1 	/**********************************************/ 1 	/* Synchronous Dialogue with QTRANSFER_SERVER */ 1 	/**********************************************/  	istat = pams_put_msg ( D 	   &dset, &prio, &tgt, &class, &type, &delivery, &size, &timeout );  + 	if (istat != SS$_NORMAL) return ( istat );    	istat = pams_get_msgw ( )B               &dset, &prio, &src,&class, &type, &size, &len_data,  	      &timeout, &select_dset);s  3         if (istat != SS$_NORMAL ) return ( istat );t   	switch (dset.status)  	{ 	case DQF_SET_ERROR:.            printf ("\nError prevented close");
 	   break;   	case DQF_SET_SUCCESS:)            printf ("\nClose successful"); 
 	   break; 	  	case DQF_SET_REFUSED:&            printf ("\nClose refused");
 	   break;  	 	default:n3            printf ("\nUnexpected status returned");m
 	   break; 	} 	*   	return ( istat ); }e   t   /*****************************/f /* SUPPORT FOR SELECTIVE RCV */n /*****************************/s typedef struct _ {s   long int	q_num;r   long int	pri;q   struct   {f     long int	field;	     long int	field_size;     long int	field_value;m     long int	field_operator;   } key[2];e   long int	order_field;f   long int	order_field_size;    long int	order_field_operator;
 } SEL_REC;  9 long make_selection_index ( sel_addr, tgt, type1, type2 )* int *sel_addr; PAMS_ADDRESS *tgt; short type1; short type2; {     SEL_REC sel_array[2]; *    int num_masks;     long istat;   	num_masks = (type2)? 2:1;   	sel_array[0].q_num  		   = 0;	 ( 	sel_array[0].pri   		   = PSEL_PRI_ANY;  - 	sel_array[0].key[0].field 	   = PSEL_SOURCE;v( 	sel_array[0].key[0].field_size     = 4;/ 	sel_array[0].key[0].field_value    = tgt->all;c3 	sel_array[0].key[0].field_operator = PSEL_OPER_EQ;   0 	sel_array[0].key[1].field          = PSEL_TYPE;( 	sel_array[0].key[1].field_size     = 2;, 	sel_array[0].key[1].field_value    = type1;3 	sel_array[0].key[1].field_operator = PSEL_OPER_EQ;*  ! 	sel_array[0].order_field	   = 0; ( 	sel_array[0].order_field_size      = 0;( 	sel_array[0].order_field_operator  = 0;   	sel_array[1].q_num  		   = 0;	s( 	sel_array[1].pri   		   = PSEL_PRI_ANY;  - 	sel_array[1].key[0].field 	   = PSEL_SOURCE;!( 	sel_array[1].key[0].field_size     = 4;/ 	sel_array[1].key[0].field_value    = tgt->all; 3 	sel_array[1].key[0].field_operator = PSEL_OPER_EQ;i  0 	sel_array[1].key[1].field          = PSEL_TYPE;( 	sel_array[1].key[1].field_size     = 2;, 	sel_array[1].key[1].field_value    = type2;3 	sel_array[1].key[1].field_operator = PSEL_OPER_EQ;   ! 	sel_array[1].order_field	   = 0;s( 	sel_array[1].order_field_size      = 0;( 	sel_array[1].order_field_operator  = 0;  = 	istat = pams_set_select ( sel_array, &num_masks, sel_addr );=, 	if (istat != SS$_NORMAL ) return ( istat ); }        #define TEXT_FLAG     1  #define ID_FLAG       2  #define SEVERITY_FLAG 4Q #define FACILITY_FLAG 8aH #define ALL_FLAGS (TEXT_FLAG | ID_FLAG | SEVERITY_FLAG | FACILITY_FLAG )   #define VMS_WARNING	  0  #define VMS_SUCCESS	  1n #define VMS_ERROR	  2  #define VMS_INFORMATIONAL 3  #define	VMS_FATAL	  4t   static	char voutbuf[256];   # static char *vms_errstr ( vmscode )t unsigned long vmscode; { $ 	struct dsc$descriptor voutbuf_desc;   	short ilen;         long istat;a  & 	voutbuf_desc.dsc$a_pointer = voutbuf;;         voutbuf_desc.dsc$w_length  = sizeof (voutbuf ) - 1;2* 	voutbuf_desc.dsc$b_dtype = DSC$K_DTYPE_T;* 	voutbuf_desc.dsc$b_class = DSC$K_CLASS_S;  E 	istat =  sys$getmsg ( vmscode, &ilen, &voutbuf_desc, ALL_FLAGS, 0 );f  >         voutbuf [ ilen ] = 0;	/* null terminate the string **/   	return ( voutbuf ); }S  TRUCT  {v       short	version;       short	action;		        long	status;  #       PAMS_ADDRESS original_target;_       PAMS_ADDRESS new_target; };& typedef struct DQF_SET_STRUCT DQF_SET;   long do_failover() {_    DQF_SET dset;  ?    short prio, class, type, delivery, msg_size, size, len_data;     long timeout;
    int istat;       PAMS_ADDRESS from_dqf;     PAMS_ADDRES               * [DMQ$V20.EXAMPLES.MRS]JTEST.C;1 +  , B   . $    /     4 Y   $                       - B    0   1    2   3      K  P   W   O %    5   6 )(d  7  	*s  8          9 Z  G    H  J                 #module DMQ$JTEST "DMQ V2.0-00"   N /*****************************************************************************$  *  DECMessageQ for VMS							     *N  *                                                                           *@  *  Copyright (c) 1990,1992                    			             *=  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/        /* 	+  *	JTEST.C  Test PCJ / DLJ functions of MRS   *H  * 	This program expects messages sent via SRC.C, confirmed with SINK.C.  */    #include stdio #include ssdef #include descrip #include rms   #include pams_c_entry_point  #include pams_c_process  #include pams_c_group    #include pams_c_type_class! #include pams_c_return_status_def  #include pams_c_symbol_def  % #define MSG_TYPE_MRS_SET_PCJ    	-880 % #define MSG_TYPE_MRS_SET_PCJ_REP	-881 " #define MSG_TYPE_MRS_SET_DLJ		-882% #define MSG_TYPE_MRS_SET_DLJ_REP	-883   
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group; 	    }  au;  } PAMS_ADDRESS;    typedef struct   {  	short vers; 	long  utag; 	long  force_jrn;  	long  status; 	char  fspec[64];  } SET_PCJ_MSG;   typedef struct {  	short vers; 	long  utag; 	long  status; 	char  fspec[64];  } SET_DLJ_MSG;      * /****************************************/ /* PAMS DECLARE variables		*/ * /****************************************/& unsigned long req_process_num;        & PAMS_ADDRESS  new_process_num;          * /****************************************/ /* Constants 				*/ * /****************************************/ const int 	mpbs    = 50;& const int 	loop    = 1;                const int	aloop   = 1;  * /****************************************/ /* Switches				*/ * /****************************************/ int 		do_trace = 1;  int		do_val   = 1;  * /****************************************/$ /* Variables used by PAMS PUT/GET	*/* /****************************************/ SET_PCJ_MSG 	pcj_msg;  SET_DLJ_MSG 	dlj_msg;    short		sel_addr[2];    unsigned char 	del_mode = 0; unsigned long 	timeout  = 0; unsigned short 	size;  unsigned char 	prio; short 		uma;   PAMS_ADDRESS 	target;    PAMS_ADDRESS 	source;  unsigned short 	length;  short 		class;
 short 		type;   % /***********************************/ % /* File pointer and journal handle */ % /***********************************/  FILE 		*fp; 
 long int 	jh;   " /********************************/ /* Common message buffer 	*/" /********************************/ short 		msg_buf [ 32000 ];  0 unsigned short	msg_buf_len  = sizeof (msg_buf );  " /*************************                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          IGR $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]JTEST.C;1                                                                                                Y    $                          "            *******/ /* Terminal input buffer	*/ " /********************************/ char		answer [ 256 ];        static main () { )    long int attach_mode, q_type , status;   C 	/*--------------------------------------------------------------*/  	/*  Declare process.						*/ C 	/*--------------------------------------------------------------*/   ,         attach_mode = PSYM_ATTACH_TEMPORARY;          q_type = PSYM_ATTACH_PQ;Y         status = pams_attach_q (&attach_mode,&new_process_num.all,&q_type,0,0,0,0,0,0,0);   & 	if (!check_ret(status)) exit(status);  C 	msg_buf_len = get_number ("\nBuffer size:", 0, sizeof(msg_buf ) );     	while ( loop )	         {  	   status = get_number ( J "\n[1:Close PCJ; 2:Close DLJ; 3:Open PCJ; 4:Read_J; 5:Directory 6:Exit]:", 	      1, 6 );              switch (status)   	   {             case 1 :  	      do_close_pcj();
 	      break;         	   case 2 : 	      do_close_dlj();
 	      break;   
 	   case 3 :   	      do_open_pcj(); 
 	      break;    	   case 4 : 	      do_read_jrn(); 
 	      break;   	 	   case 5 : 	      do_directory();               break;   	   case 6 : 	      exit ( 1 ) ;               } 	} }        static do_close_pcj()  {     long status;    	/* Close the current file */  	pcj_msg.vers = 10;  	pcj_msg.utag = 12345; 	pcj_msg.status = -1;   H 	pcj_msg.force_jrn = get_number ( "\nForce_jrn field [0 or 1]:", 0 ,1 );           prio=0; % 	target.au.process = PAMS_MRS_SERVER;           class		  = MSG_CLAS_MRS;'         type		  = MSG_TYPE_MRS_SET_PCJ;    	del_mode		  = 0;  	size = sizeof(SET_PCJ_MSG );   G         status = pams_put_msg( &pcj_msg, &prio, &target, &class, &type,  			       &del_mode, &size); 	if (!status) exit(status);	   	while ( aloop ) 	{+ 	   sel_addr[0] = MSG_TYPE_MRS_SET_PCJ_REP;  	   sel_addr[1] = PSEL_PQ_TYPE;   K            status = pams_get_msgw( &pcj_msg, &prio, &source, &class, &type, % 			        &size, &length, sel_addr); + 	   if (!check_ret(status) ) exit(status);	   . 	   if ( ( class != MSG_CLAS_MRS            ) / 	   ||   ( type != MSG_TYPE_MRS_SET_PCJ_REP ) )  	   { ' 	      printf("\nUnexpected response");  	      continue;            }
 	   break; 	}   	switch ( pcj_msg.status ) 	{ 	case 0:  	   printf ("\nSET PCJ failed");
 	   break; 	case 1:# 	   printf ("\nSET PCJ succeeded"); 
 	   break;	 	default: G 	   printf ("\nSET PCJ unexpected status value: %x ", pcj_msg.status ); 
 	   break; 	}   	return ( SS$_NORMAL );  }        static do_read_jrn() {     int ilen;    int pos  = 0;    int npos = 0;    int receive_count = 0;       long status;     long mrs_status;     long conf_val;     long write_time[2];    char tim_str[30];    long seqno[2];    	while ( aloop ) 	{2 	   get_string ("\nJournal filespec ?:", answer ); 	  	   ilen = strlen ( answer );  	   if ( ilen >= 64 ) continue; 
 	   break; 	} 	 3         status = pams_open_jrn(answer, &ilen, &jh);           	switch (status)  	         {  	case SS$_NORMAL: 4 	   /**********************************************/4 	   /* journal handles are really C FILE pointers */4 	   /* So set this for use later                  */4 	   /**********************************************/ 	   fp = jh;
 	   break;   	case PAMS__NOSUCHPCJ : & 	   printf ("\nBad journal filespec"); 	   perror ("\npams_open_jrn");  	   return;            default : 0 	   printf ("\nUnexpected status: %x", status ); 	   perror ("\npams_open_jrn");  	   exit ( status ); 	}
 	      		  	receive_count = 0;    	while ( loop )  	{	 5 	   get_string ("\n<CR> to read next msg:", answer );    	   pos = ftell ( fp );     	   status = pams_read_jrn(&jh,  			          &msg_buf, 				  &prio, &source,  			          &class, &type, " 			          &msg_buf_len,&length," 			          &target, &write_time, 				  &conf_val, 				  &seqno, &mrs_status);    	   switch (status)  	   {  	   case SS$_NORMAL : 
 	      break;     	   case PAMS__AREATOSMALL : 4 	      if (ferror (fp) ) perror ("\npams_read_jrn");( 	      printf("\nPAMS__AREATOSMALL...");
 	      break;    	   case RMS$_EOF :  	      if (feof ( fp ) ) 	         printf("\n[EOF]");   	      else if (ferror (fp) ) % 	         perror ("\npams_read_jrn");    	      else 4 	         printf ("\npams_read_jrn: Unknown error");   	      goto CLOSE_JRN;   	   case PAMS__MSGTOSMALL : 6 	      if (ferror ( fp ) ) perror ("\npams_read_jrn");' 	      printf("\nPAMS__MSGTOSMALL...");    	      goto CLOSE_JRN;   	   default:6 	      if (ferror ( fp ) ) perror ("\npams_read_jrn");3 	      printf ("\nUnexpected status:%x ", status );  	      exit ( status );  	   }	 	 					  % 	   /*******************************/ $ 	   /* msg_buf contains a message */% 	   /*******************************/    	   ++receive_count; 	   npos = ftell ( fp );  , 	   printf ("\n[%d] Pos:%d, Bytes_read:%d ",( 	      receive_count, pos, npos - pos );              printf(H 	      "\nSeq:(%x,%x) Src:%d.%d Tgt:%d.%d Len:%u Cls:%d Typ:%d Prio:%d", 	      seqno[0], seqno[1],) 	      source.au.group,source.au.process, ) 	      target.au.group,target.au.process,   	      length, class,type,prio);  3 	   cvt_binary_time_to_string(write_time, tim_str);   6 	   printf("\n   MRS stat:%x Confirmed:%30s Value:%d",! 		 mrs_status, tim_str,conf_val);   4 	   if (length > msg_buf_len ) length = msg_buf_len;' 	   if ( do_val ) validate_pattern ( );    	}      
 CLOSE_JRN:E         /***********************************************************/ > 	/* pams_close_jrn is the only PAMS subroutine that expects */E         /* argument passing by value...                            */ E         /***********************************************************/   ! 	status = pams_close_jrn ( &jh );  	switch (status)  	         {  	case SS$_NORMAL: 
 	   break;   	case PAMS__INVJH :   	   perror ("\npams_close_jrn"); 	   printf("\nPAMS__INVJH"); 	   return;            default :   	   perror ("\npams_close_jrn");0 	   printf ("\nUnexpected status: %x", status ); 	   return;  	} }        static do_open_pcj() {     int ilen;    long status;    	while ( aloop ) 	{. 	   get_string ("\nPCJ filespec ?:", answer ); 	  	   ilen = strlen ( answer ); 3 	   if ( ilen >= sizeof (pcj_msg.fspec) ) continue; 
 	   break; 	}  " 	strcpy ( pcj_msg.fspec, answer );   	pcj_msg.vers = 10;  	pcj_msg.utag = 12345; 	pcj_msg.status = -1;   I 	pcj_msg.force_jrn = get_number ( "\nForce_jrn field [0 or 1]:", 0 , 1 );            prio			= 0; % 	target.au.process	= PAMS_MRS_SERVER;          class			= MSG_CLAS_MRS; &         type			= MSG_TYPE_MRS_SET_PCJ; 	del_mode		= 0;d 	size = sizeof(SET_PCJ_MSG );   G         status = pams_put_msg( &pcj_msg, &prio, &target, &class, &type,* 			       &del_mode, &size); 	if (!status) exit(status);	     	while ( aloop ) 	{+ 	   sel_addr[0] = MSG_TYPE_MRS_SET_PCJ_REP;i 	   sel_addr[1] = PSEL_PQ_TYPE;   K            status = pams_get_msgw( &pcj_msg, &prio, &source, &class, &type, % 			        &size, &length, sel_addr);w  . 	   if (!check_ret ( status ) ) exit(status);	  " 	   if ( ( class != MSG_CLAS_MRS) . 	   ||   ( type != MSG_TYPE_MRS_SET_PCJ_REP) ) 	   {*' 	      printf("\nUnexpected response");t 	      continue; 	   }n
 	   break; 	}   	switch ( pcj_msg.status ) 	{ 	case 0:  	   printf ("\nSET PCJ failed");
 	   break; 	case 1:# 	   printf ("\nSET PCJ succeeded");a
 	   break;	 	default: G 	   printf ("\nSET PCJ unexpected status value: %x ", pcj_msg.status );i
 	   break; 	}   	return ( SS$_NORMAL );o }e       static do_close_dlj()  {     long status;i   	/* Close the current file */* 	dlj_msg.vers = 10;  	dlj_msg.utag = 12345; 	dlj_msg.status = -1;            prio		  = 0;% 	target.au.process = PAMS_MRS_SERVER; !         class 		  = MSG_CLAS_MRS;s'         type		  = MSG_TYPE_MRS_SET_DLJ;  	del_mode		  = 0;*! 	size 		  = sizeof(SET_DLJ_MSG );*  G         status = pams_put_msg( &dlj_msg, &prio, &target, &class, &type,f 			       &del_mode, &size); 	if (!status) exit(status);	   	while ( aloop ) 	{+ 	   sel_addr[0] = MSG_TYPE_MRS_SET_DLJ_REP;s 	   sel_addr[1] = PSEL_PQ_TYPE;r  K            status = pams_get_msgw( &dlj_msg, &prio, &source, &class, &type,r& 			        &size, &length, sel_addr );   	   if (!status) exit(status);	c" 	   if ( ( class != MSG_CLAS_MRS) . 	   ||   ( type != MSG_TYPE_MRS_SET_DLJ_REP) ) 	   {P" 		printf("\nUnexpected response"); 	        continue;            }
 	   break; 	}   	switch ( dlj_msg.status ) 	{ 	case 0:  	   printf ("\nSET DLJ failed");
 	   break; 	case 1:# 	   printf ("\nSET DLJ succeeded"); 
 	   break;	 	default:yG 	   printf ("\nSET DLJ unexpected status v                                                                                                                                                                                                                                                                            $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]JTEST.C;1                                                                                                Y    $                         6             alue: %x ", dlj_msg.status ); 
 	   break; 	}   	return ( SS$_NORMAL );;   }y       static int check_ret(stsvalue)
 int stsvalue;a {; 	if (stsvalue & 1) return (1);   	return(0);* }*   *   static int validate_pattern ( )P { 	    int i;i	    int j;     int bad;*    int ians;    short chunk_id;    int nchunk;  ( 	if (length < 2 ) return ( SS$_NORMAL );           j      = 0;*         bad    = 0;* 	nchunk = 0;   	chunk_id = msg_buf[0];*   	if ( chunk_id == 0 )* 	{= 	   printf ("\nMessage not written with validation pattern");  	   return ( SS$_NORMAL ); 	}	;   	if (chunk_id > 0) bad = 1;*   	if ( !bad ) 	{  	   for (j=0; j < length/2; j++) 	   {* 	      if (j % mpbs )	 	      {  	         if ( msg_buf[j] != j ) 		 { 		    bad = 3; 		    break; 		 }               }P 	      else/ 	      { 	         nchunk++;*' 	         if ( msg_buf[j] != chunk_id )_ 	         {m 		    bad = 2;! 		    break;                     m 	    	 }	 	      } n# 	   }     /* end for (j...)      */e 	}  
 	switch (bad)i 	{ 	case 1:B 	         printf ( "\n Invalid chunk stamp at start of message "); 	         break; 	case 2:G 	         printf ("\n Chunk stamp mismatch, chunk number %d ", nchunk);e 	         break; 	case 3:6 	         printf ("\n Message body data corruption "); 	         break; 	}     	if ( bad )* 	{ 	   ians = get_number (u3 	      "\n Dump msg content? [0=no 1=yes] :", 0,1);	   	   if (ians )	      i            {$ 	         for (i=j; j<length/2; j++)1 	            printf("\n% d : %d", j, msg_buf[j]);u 	   }  	}	*   	return ( SS$_NORMAL );* }    	  + static int get_number ( prompt, low, high ) 
 char *prompt;h int low;	 int high;s {     int iout;    int ilen;
    int istat;-   	while ( aloop ) 	{" 	   get_string ( prompt, answer );1            if ( strlen (answer) == 0 )  continue;-   	   iout = atoi(answer);1 	   if ( ( iout<low ) || ( iout>high) ) continue;e   	   return ( iout ); 	} }t    + static int get_string ( prompt, outstring ).
 char *prompt;, char *outstring; {!
    int istat;s   	printf ( prompt );g   	istat = gets ( outstring ); 	if ( !istat ) 	{ 	   perror ("C gets ");  	   exit ( SS$_ABORT );t 	}   	return ( SS$_NORMAL );s }C   C   static int do_directory ( )  {i
    int istat;:
    int count;     int ilen;    char *c;a      static char dspec[256];    static char rspec[256];     $DESCRIPTOR ( ddesc, dspec );     $DESCRIPTOR ( rdesc, rspec );      static long int context;       printf ("\nFile spec ?:");e    gets ( dspec );  )    ddesc.dsc$w_length = strlen ( dspec );       count   = 0;     context = 0;       while (1)    {8       istat = lib$find_file (&ddesc, &rdesc, &context );'       if (istat != RMS$_NORMAL ) break;          c = strchr(rspec, ' ');u       if ( c ) *c = 0;         printf ("\n%s", rspec );              count++;    }  =    if (istat == RMS$_NMF    ) lib$find_file_end ( &context );0  $    printf ("\n %d files\n", count );    return ( count ); }       O /******************************************************************************d2 * Module:    CVT_BINARY_TIME_TO_STRING (tstamp, s) *t * Filename:  CVT_TIME.C_ *,L * Function:     This subroutine is used to convert VMS system time to a null *	     terminated ASCII string.) * 	 * Inputs:d# *	tstamp	- VMS system time quadword  *e
 * Outputs:> *	s	- character string buffer to receive time string.  Must be *		  24 bytes or longer. *  * External Subroutines:t *	sys$asctim * 
 * Language: Ct * O ******************************************************************************/   8 static long int  cvt_binary_time_to_string ( tstamp, s ) long int tstamp[2];p char     *s; {c struct dsc$descriptor_s timbuf;; long int  		sts$value; short int 		timlen;        timbuf.dsc$w_length   = 23;;(   timbuf.dsc$b_dtype    = DSC$K_DTYPE_T;(   timbuf.dsc$b_class    = DSC$K_CLASS_S;   timbuf.dsc$a_pointer  = s;   timlen                = 0;  6   sts$value = sys$asctim(&timlen, &timbuf, tstamp, 0);     *(s+timlen) = 0;     return(sts$value); }e     int pos               * [DMQ$V20.EXAMPLES.MRS]SINK.C;1 +  , B   .     /     4 O                          - B    0   1    2   3      K  P   W   O     5   6  }xDq  7  >6s  8          9 Z  G    H  J                  #module DMQ$SINK "DMQ V2.0-00"  N /*****************************************************************************$  *  DECMessageQ for VMS							     *N  *                                                                           *@  *  Copyright (c) 1990,1992                    			             *=  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/       ( /**************************************/( /* SINK.C  PAMS TEST RECEIVER PROGRAM */( /* Talks to the program SRC.C         */( /**************************************/   #include stdio #include ssdef #include signal  #include descrip   #include pams_c_entry_point  #include pams_c_process  #include pams_c_group    #include pams_c_type_class! #include pams_c_return_status_def  #include pams_c_symbol_def   typedef struct   {     short int type;    short int cd;    long int del_status;     long int seq[2];     long int uma_status;     long int unused[3]; } PAMS_PSB;   
 typedef union  { 
    struct     {       short process;       short group;    } au;    long all; } PAMS_ADDRESS;    typedef struct {     PAMS_ADDRESS target;      PAMS_ADDRESS original_target;     PAMS_ADDRESS original_source;    long reserved1;    char delivery;     char priority;     char buffer_type; } PAMS_SHOW_MSG_BUF;  ' unsigned long 	req_process_num;         % PAMS_ADDRESS new_process_num;         ' long int attach_mode,q_type,q_name_len;  static char q_name[32];    const long	psp_count 	  = 1;' const long	loop 		  = 1;                & const long      aloop             = 1; const long	mpbs 		  = 50;   * /****************************************/ /* counters 				*/* /****************************************/ int 		prev_count        = 0; int 		receive_count     = 0; long		pending_count     = 0;  * /****************************************/ /* switches 				*/* /****************************************/ int		do_conf           = 0;  int    		do_val            = 0;  int 		do_trace          = 0;  * /****************************************/ /* pams get msg variables  		*/ * /****************************************/ PAMS_PSB 	psb; short 		msg_area[33000];     unsigned long 	timeout 	  = 0; unsigned long 	source		  = 0;  unsigned char 	prio		  = 0;  short 		class             = 0; short 		type              = 0;% unsigned short	length            = 0;   , unsigned short 	max_len = sizeof (msg_area);* unsigned short 	sel_addr[2]       = {0,0}; char 		*null_ptr         = 0;  PAMS_SHOW_MSG_BUF show;   * /****************************************/ /* other 				*/ * /****************************************/ int 		sample_int        = 0; unsigned long 	timer_id 	  = 0;  char		conf_mode 	  = 0;  long 		conf_val          = 0;  long 		enaflg            = 0;   * /****************************************/ /* Terminal input buffer 		*/ * /****************************************/ char answer[256];   * /****************************************/ /* function definitions 		*/* /****************************************/ static int show_count    (); static char *get_err_str ();       static main () {     int ians;    long status                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          l:i $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]SINK.C;1                                                                                                 O                             d "     	       ;    	while ( aloop ) 	{" 	   req_process_num = get_number (C 	      "\nSINK process number?                        :", 0, 999 );   1            sprintf (q_name,"%d",req_process_num);   (            q_name_len = strlen (q_name);/            attach_mode = PSYM_ATTACH_BY_NUMBER; #            q_type = PSYM_ATTACH_PQ; M            status = pams_attach_q (&attach_mode,&new_process_num.all,&q_type, A                                    q_name,&q_name_len,0,0,0,0,0); % 	   if (!check_ret(status)) continue;             break;  	}  ! 	sel_addr [0] = sel_addr [1] = 0;    	ians = get_number (> 	   "\nSet up selective rcv? [0=no,1=yes]          :", 0, 1 );   	if (ians != 0)  	{ 	   ians = get_number ( B 	      "\nFilter type: [1=PSEL_AQ; 2=PSEL_PQ_AQ; 3=:PSEL_AQ_PQ]:", 	       1,3 );   	   switch (ians)	     	   {  	   case  1: 	       sel_addr[1] = PSEL_AQ;, 	       printf("\n...Only alternate queue"); 	       break;   	   case  2:  	      sel_addr[1] = PSEL_PQ_AQ;" 	      printf("\n...PQ, then AQ");
 	      break;   
 	   case  3:    	      sel_addr[1] = PSEL_AQ_PQ;" 	      printf("\n...AQ, then PQ");
 	      break;               default:  	      sel_addr[1] = PSEL_AQ; 9 	      printf("\n...Defaulting to alternate queue only"); 
 	      break;  	   }	   	   sel_addr[0] = get_number (B 	      "\nAlternate queue number                               :", 	      0, 200 );  	 	}		         	sample_int = B 	   get_number ("\nSampling interval in seconds? [0:no timing] :",
 	   0,3600 );  	if ( sample_int > 0 )   	{6 	   /************************************************/6 	   /* We're timing so dont validate and dont trace */6 	   /************************************************/ 	   do_val   = 0;             do_trace = 0; 	} 	else	 	{@ 	   /**********************************************************/@ 	   /* We're not timing, so validate and ask if we're tracing */@ 	   /**********************************************************/ 	   do_val = 1;    	   do_trace = get_number ( A 	      "   \nTrace ? [0:off;1:on]                         ",0,1);  	}    	do_conf = get_number (  6 	   "\nConfirm? [0=none, 1=all, 2=Select ]         :", 	    0,2 );    	if (do_conf != 0) 	{ 	   conf_mode = get_number (  > 	      "\nPost Conf Journal? [0:off;1:on]             :",0,1);   	   if (conf_mode == 0) +               conf_mode = PDEL_DEFAULT_JRN;  	   else" 	      conf_mode = PDEL_FORCE_JRN;	         }    	if (sample_int > 0) 	{ 	   alarm(sample_int);    = 	   signal(SIGALRM,show_count);	/* Show counter when alarm */  	}  ' 	/************************************/ ' 	/* Wait till user tells us to start */ ' 	/************************************/  	fflush(stdin);    	printf("\n<CR> to start:"); 	gets ( answer );        	/*********************/ 	/* Main message loop */ 	/*********************/ 	prio = timeout = 0; 	max_len = 64000;    	receive_count = 0;     	while ( loop )	         {             if (do_trace) 	   { / 	      status = putil_show_pending( &psp_count,  					&new_process_num, 					&pending_count);   !  	      if (status != SS$_NORMAL) 3 	         printf("\nPending count not accessible");                else  ) 	         printf("\n%d messages pending",  		 	  pending_count);		  	   }   $ 	   status = pams_get_msgw(msg_area, 			&prio, &source, 			&class, &type,  			&max_len,&length, 			&timeout, sel_addr,	 			&psb);                ) 	   if (!check_ret(status)) exit(status);  	   ++receive_count;  ( 	   if ( do_trace ) report_status    ();  ( 	   if ( do_val   ) validate_pattern ();  ( 	   if ( do_conf  ) confirm_message  ();  	         }  }        static report_status ()  {  	printf("\nSeq:(%x,%x) Len:%u", ( 	         psb.seq[0],psb.seq[1],length);   	if (psb.del_status != 0)     	   if ( !(psb.del_status & 1) )C 	      printf("\nPSB status: %s", get_err_str ( psb.del_status ) );  }        static int validate_pattern () { 	    int i; 	    int j;     int bad;     int ians;    short chunk_id;    int nchunk;  ( 	if (length < 2 ) return ( SS$_NORMAL );           bad = 0; 	nchunk = 0;   	chunk_id = msg_area[0];   	if ( chunk_id == 0 )  	{= 	   printf ("\nMessage not written with validation pattern");  	   return ( SS$_NORMAL ); 	}	    	if (chunk_id > 0) bad = 1;    	if ( !bad ) 	{  	   for (j=0; j < length/2; j++) 	   {  	      if (j % mpbs )  	      {! 	         if ( msg_area[j] != j )  		 { 		    bad = 3; 		    break; 		 }               }  	      else  	      { 	         nchunk++; ( 	         if ( msg_area[j] != chunk_id ) 	         {  		    bad = 2;! 		    break;                       	    	 }	 	      }  # 	   }     /* end for (j...)      */  	}  
 	switch (bad)  	{ 	case 1:B 	         printf ( "\n Invalid chunk stamp at start of message "); 	         break; 	case 2:G 	         printf ("\n Chunk stamp mismatch, chunk number %d ", nchunk);  	         break; 	case 3:6 	         printf ("\n Message body data corruption "); 	         break; 	}     	if ( bad )  	{ 	   ians = get_number ( ? 	      "\n Dump msg content? [0=no 1=yes]             :", 0,1);    	   if (ians )	                   {$ 	         for (i=j; j<length/2; j++)2 	            printf("\n% d : %d", j, msg_area[j]); 	   }  	}	    	return ( SS$_NORMAL );  }        static confirm_message ()  { 
    int ians;	     long status;   - 	if ( ( psb.del_status != PAMS__CONFIRMREQ )  E 	&&   ( psb.del_status != PAMS__POSSDUPL   ) ) return ( SS$_NORMAL );    	if (do_conf == 2) 	{4 	   ians = get_number ("\nconfirm? 0=N, 1=Y ", 0,1); 	} 	else ians = 1;  		
 	if (ians) 	{2            /*************************************/- 	   /* Now confirm it to the message bus */		 2            /*************************************/            conf_val++;) 	   if ( conf_val > 16384 ) conf_val = 0;    	   status = pams_confirm_msg($ 			&psb.seq, &conf_val, &conf_mode);  - 	   check_ret(status);	/* report any error */    	}   }        static int check_ret(stsvalue)
 int stsvalue;  {  	if (stsvalue & 1) return (1);  , 	printf ("\n%s", get_err_str ( stsvalue ) ); 	return(0);  }        static show_count()  {    long time_now;   long incr;  " 	incr=receive_count - prev_count;	 	time(&time_now);*  7 	printf("\n%24.24s Total rcvd:\t%d\tIncr:\t%d\t%d/sec", : 	   ctime(&time_now),receive_count,incr,incr/sample_int);	   	prev_count = receive_count;  : 	signal(SIGALRM,show_count);	/* Show counter when alarm */ 					/* clock rings */. 	alarm(sample_int);		/* Set the alarm again */ }r   d  C /*****************************************************************/nC /* VMS specific routine... translate a VMS errcode into a string */oC /*****************************************************************/* #define TEXT_FLAG     1  #define ID_FLAG       2m #define SEVERITY_FLAG 4  #define FACILITY_FLAG 8lH #define ALL_FLAGS (TEXT_FLAG | ID_FLAG | SEVERITY_FLAG | FACILITY_FLAG )   #define VMS_WARNING	  0  #define VMS_SUCCESS	  1n #define VMS_ERROR	  2c #define VMS_INFORMATIONAL 3  #define	VMS_FATAL	  4t  $ static char *get_err_str ( errcode ) unsigned long errcode; {p$ 	struct dsc$descriptor voutbuf_desc; 	static	char voutbuf[256];   	short ilen;         long istat;b           long severity;   	if ( errcode <= 4 )   	{ 	   voutbuf [ 0 ] = 0; 	   return ( voutbuf );  	}  /         /***************************************& 	 * Now decode the vms condition code 0          **************************************/& 	voutbuf_desc.dsc$a_pointer = voutbuf;;         voutbuf_desc.dsc$w_length  = sizeof (voutbuf ) - 1;** 	voutbuf_desc.dsc$b_dtype = DSC$K_DTYPE_T;* 	voutbuf_desc.dsc$b_class = DSC$K_CLASS_S;  E 	istat =  sys$getmsg ( errcode, &ilen, &voutbuf_desc, ALL_FLAGS, 0 );u  >         voutbuf [ ilen ] = 0;	/* null terminate the string **/   	return (voutbuf);   }d     y  + static int get_number ( prompt, low, high )t
 char *prompt;n int low;	 int high;  {n    int iout;   	while ( aloop ) 	{ 	   printf ( prompt ); 	   gets ( answer ); 	   iout = atoi(answer);1 	   if ( ( iout<low ) || ( iout>high) ) continue;    	   return ( iout ); 	} }A   S  # static int send_flow_ack ( source )S PAMS_ADDRESS source; {S!    static   char ack_buf [ 128 ];       PAMS_ADDRESS target;e      short prio     = 0;    short class    = 3;    short type     = 0;      short delivery = 0;    long  timeout  = 0;    long  uma      = 0;    short size     = 0;    int istat      = 0;   	target.all = source.all;c   	if ( do_trace ) 	{, 	   printf ("\nSending flow ACK to %d.%d ",  	      target.au.group,o 	      target.au.process );  	}   	istat = pams_put_msg (  	      ack_buf,*
 	      &pr                                                                                                                                                                                                                                                                           -] $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]SINK.C;1                                                                                                 O                             V             io,* 	      &target,* 	      &class,
 	      &type,* 	      &delivery,*
 	      &size,	 	      &timeout );   	return ( istat ); }   0; long		pending_count     = 0;  * /****************************************/ /* switches 				*/* /****************************************/ int		do_conf           = 0;  int    		do_val            = 0;  int 		do_trace          = 0;  * /****************************************/ /* pams get msg variables  		*/ * /****************************************/ PAMS_PSB 	               * [DMQ$V20.EXAMPLES.MRS]SRC.C;1 +  , B   . 0    /     4 p   0   /                   - B    0   1    2   3      K  P   W   O 1    5   6 
r  7  sBs  8          9 Z  G    H  J                   #module DMQ$SRC "DMQ V2.0-00"   N /*****************************************************************************$  *  DECMessageQ for VMS							     *N  *                                                                           *@  *  Copyright (c) 1990,1992                    			             *=  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/       ( /**************************************/( /* SRC.C Test sender program for PAMS */( /**************************************/ #include stdio #include ssdef #include signal  #include descrip   #include pams_c_entry_point  #include pams_c_process  #include pams_c_group    #include pams_c_type_class! #include pams_c_return_status_def  #include pams_c_symbol_def    #define MSG_CLAS_MRS          28  #define MSG_TYPE_MRS_ACK    -801  #define MSG_TYPE_MRS_STATUS -860    /******************************/  /* Some useful display macros */  /******************************// #define np(y)    printf("\n%d: %s ", y, "y" );  . #define lp(y)    case(y) : printf("y"); break;  % /***********************************/ % /* PAMS data structure definitions */ % /***********************************/ 
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group; 	    }  au;  } PAMS_ADDRESS;    typedef struct   {     short int type;    short int cd;    long int del_status;     long int seq[2];     long int uma_status;     long int unused[3]; } PAMS_PSB;   " /********************************/ /* Constants 			*/" /********************************/) const int 	loop       = 1;                 const int 	aloop 	   = 1;   " /********************************/ /* Switches 			*/ " /********************************/ int		do_rate         = 0;  int 		do_val          = 0; int		test_type       = 0;  int		do_flow_control = 0;  int		wait_for_flow   = 0;   " /********************************/ /* Counters 			*/ " /********************************/ int 		prev_count = 0;  int 		send_count = 0;  int		q_depth    = 0; int		pace_count = 0;  " /********************************/ /* pams declare variables 	*/ " /********************************/& unsigned long	req_process_num;        & PAMS_ADDRESS 	new_process_num;          " /********************************/ /* pams_put_msg variables 	*/ " /********************************/ short  		msg_body[33000];    PAMS_ADDRESS 	target;    PAMS_PSB 	pams_psb;     unsigned char 	del_byte     = 0;  unsigned char 	uma          = 0;  unsigned char 	prio         = 0; short 		class        = 0;  short 		type         = 0; ! unsigned short 	o_size       = 0;  long 		send_timeout = 0;   long int 	resp_process_num;   " /********************************/ /* pams_get_msg variables 	*/ " /********************************/ PAMS_ADDRESS 	source;  long  		msg_buff[32000]; short 		length       = 0;   unsigned long 	rcv_timeout  = 0; short 		sel_addr[2]  = {0,0}; ! short int       msg_area_len = 0;   " /********************************/ /* pams timer variables 	*/ " /********************************/ long 		tid = 3000; long 		int zero_q[2] = {0,0};  char 		ptime = 'P';  long		wait_time; long		timer_sel_addr = 0;   " /********************************/ /* other 			*/" /********************************/ #define STAMP_OFFSET 50    long 		hold_seq[2];   int 		mpb_size   = STAMP_OFFSET; short 		mpb_id     =  0; unsigned int	sample_int =  0;   " /********************************/ /* Terminal input buffer 	*/" /********************************/ char answer [ 256 ];  " /********************************/" /* function declarations        */" /********************************/ static char *get_err_str();        static main () {    int show_count(); 	   int 	j; 1   long call_status,attach_mode,q_type,q_name_len;    static char q_name[31];   ! 	/******************************/ ! 	/* Fill in known data pattern */ ! 	/******************************/ + 	for (j=0; j < 32000; j++) msg_body[j] = j;   * 	/***************************************/* 	/* Get source and target queue numbers */* 	/***************************************/ 	while (aloop) 	{6 	   req_process_num = get_number("\nSource: ", 0,999);   	   /*******************/	 	   /* declare to PAMS */  	   /*******************/ 1            sprintf (q_name,"%d",req_process_num); (            q_name_len = strlen (q_name);/            attach_mode = PSYM_ATTACH_BY_NUMBER; #            q_type = PSYM_ATTACH_PQ;   p            call_status = pams_attach_q (&attach_mode,&new_process_num.all,&q_type,q_name,&q_name_len,0,0,0,0,0);+ 	   if (!check_ret(call_status) ) continue; 
 	   break; 	}  / 	resp_process_num = new_process_num.au.process;   8 	target.au.process = get_number ("\nTarget: ", 0, 999 );  > 	target.au.group = get_number ("\nTarget group: ", 0, 32000 );  ! 	del_byte = get_delivery_mode ();   ) 	/**************************************/ ) 	/* Get the UMA for new delivery modes */ ) 	/**************************************/  	switch (del_byte) 	{ 	case (PDEL_MODE_NN_SAF ): 	case (PDEL_MODE_WF_SAF ): 	case (PDEL_MODE_AK_SAF ):   	case (PDEL_MODE_NN_DQF ): 	case (PDEL_MODE_WF_DQF ): 	case (PDEL_MODE_AK_DQF ):   	case (PDEL_MODE_NN_MEM ): 	case (PDEL_MODE_WF_MEM ): 	case (PDEL_MODE_AK_MEM ):   	case (PDEL_MODE_NN_RCM ): 	case (PDEL_MODE_WF_RCM ): 	case (PDEL_MODE_AK_RCM ):   	case (PDEL_MODE_NN_NET ): 	case (PDEL_MODE_WF_NET ): 	case (PDEL_MODE_AK_NET ): 	   uma = get_number (  L "\nUndel msg. action [1:RTS; 2:DLJ; 3:DLQ; 4:SAF; 5:DISC;6:DISCL]:", 1, 6 );
 	   break; 	}  0 	/*********************************************/0 	/* if mode is a WF mode, get a timeout value */0 	/*********************************************/ 	switch (del_byte) 	{ 	case PDEL_MODE_ST_RECOVER:  	case PDEL_MODE_WFQ: 	case PDEL_MODE_WF_SAF:  	case PDEL_MODE_WF_DQF:  	case PDEL_MODE_WF_MEM:  	case PDEL_MODE_WF_RCM:  	case PDEL_MODE_WF_NET:  	   send_timeout = get_number ( 5 	      "\nDelivery timeout (PAMS units):", 0,36000 ); 
 	   break; 	}   	/************************/  	/* Get the message size */  	/************************/ 8 	o_size = get_number ("\nSize:", 0 , sizeof(msg_body) );= 	mpb_size = (o_size > STAMP_OFFSET) ? STAMP_OFFSET : o_size;	   #         /*************************/  	/* How often do we send? */#         /*************************/  	test_type = get_number ( > 	   "\n0=continuous, 1=stepped, 2=timed, 3=flow controlled:",  	    0,3 );    	if (test_type == 2) 	{@ 	   wait_time = get_number ("\nDelay (PAMS units):", 0, 36000 ); 	} 	 /         /*************************************/ ( 	/* Should we report timing results ? *//         /*************************************/ @ 	do_rate = get_num                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          IK| $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]SRC.C;1                                                                                                  p    0                         O "            ber ("\nDelivery rate timing [0:1]:", 0 , 1 );  
 	if (do_rate)  	{= 	   signal(SIGALRM,show_count);	/* Show counter when alarm */    	   sample_int = get_number ( 4 	      "\nSampling interval in seconds:", 0, 3600 ); 	}  > 	/***********************************************************/> 	/* Should be stamp each message with a unique msg number ? */> 	/***********************************************************/ 	do_val = ( do_rate ) ? 0 : 1;  
 	if (do_val )  	{< 	   mpb_id = get_number ( "\nStarting msg no: ", 1, 16384 ); 	   mpb_id = -1 * mpb_id; 	         }    	if (test_type == 3 )  	{ 	   do_flow_control = 1;  , 	   /**************************************/, 	   /* Use a end to end pacing protocol ? */, 	   /**************************************/ 	   q_depth = get_number (, 	      "\nFlow control depth :", 1, 99999 );              pace_count    = 0;  	   wait_for_flow = 0;	         }   ) 	/**************************************/ ) 	/* Wait for user's ok before starting */ ) 	/**************************************/  	fflush(stdin);  	printf("\n<CR> to start:"); 	gets ( answer );     	if (do_rate) alarm(sample_int);       	/***********************/ 	/* Main messaging loop */ 	/***********************/  	while ( loop )   	{ 	   drain_primary_queue ();   
 	   prio = 0;    	   type  = 1;   	   class = 2;   	   if ( do_val )             {) 	      /********************************/ ,    	      /* Stamp this message uniquely  */) 	      /********************************/ A 	      for (j=0; j<o_size/2; j+=mpb_size ) msg_body [j] = mpb_id;  	      mpb_id--;   	   }  		 	   if (do_flow_control )  	   {  	      pace_count++;# 	      if ( pace_count >= q_depth )  	      {6 	         /******************************************/6 	         /* REQUIRE A POSITIVE ACK OF THIS MESSAGE */6 	         /******************************************/C 	         class         = 3;	/* Use class to toggle flow control */    	         pace_count    = 0; 	         wait_for_flow = 1;               }             }  ) 	   call_status = pams_put_msg(&msg_body,  				           &prio, &target, 					   &class, &type,   					   &del_byte, 			    		   &o_size, 					   &send_timeout, 					   &pams_psb,
 					   &uma,  					   &resp_process_num);    	   check_ret(call_status);   " 	   hold_seq[0] = pams_psb.seq[0];# 	   hold_seq[1] = pams_psb.seq[1];	  	   ++send_count;			   	   switch (del_byte)  	   {  	   case PDEL_MODE_ST_RECOVER :  	   case PDEL_MODE_WF_DQF :  	   case PDEL_MODE_WF_SAF :  	   case PDEL_MODE_WF_MEM :V 	   case PDEL_MODE_WF_NET :* 	   case PDEL_MODE_WF_RCM :*2 	      if (do_rate == 0) report_recovery_status();H   	      if (pams_psb.uma_status == PAMS__RTS_SUCCESS ) wait_for_rts ();  
 	      break;   % 	   case PDEL_MODE_AK_DQF:             	   case PDEL_MODE_AK_SAF: 	      wait_for_ack ();t2 	      if (do_rate == 0) report_recovery_status();
 	      break;s 	   }r  ( 	   /**********************************/( 	   /* Get ready to send next message */( 	   /**********************************/ 	  h 	   switch (test_type) f 	   {o 	   case(1):	/* Manual */s 	      fflush(stdin);  	      printf("\n<CR>"); 	      gets ( answer );r  $               j = strlen ( answer ); 	      if ( j == 0 ) break;n   	      j = atoi(answer); 	      if (j  >= 0 ) 	      { 	         o_size = j;	F 	         mpb_size = (o_size > STAMP_OFFSET) ? STAMP_OFFSET : o_size;	 	      }
 	      break;    	   case(2):	/* Timed */	a   	      if (!timer_sel_addr ) e 	      {F                  call_status = set_timer_sel_addr ( &timer_sel_addr ); 	      }  D 	      call_status = pams_set_timer(&tid,&ptime,&wait_time,&zero_q);6 	      if (!check_ret(call_status)) exit(call_status); 		#               msg_area_len = 32000;*, 	      call_status = pams_get_msgw(msg_buff, 					  &prio, &source,- 					  &class, &type, &msg_area_len, &length,d& 					  &rcv_timeout, &timer_sel_addr);6 	      if (!check_ret(call_status)) exit(call_status);    	      break;  % 	   case (3) :  /* flow controlled */r 	      if (wait_for_flow ) 	      {!                  get_flow_ack ();m#                  wait_for_flow = 0;n 	      }                 break; 	   }	    	} /* end while */					          }f   S   static int get_delivery_mode ()_ {E    int del_mode;  ) 	/**************************************/s) 	/* Prompt with  delivery mode options */*) 	/**************************************/: 	np (PDEL_MODE_DG_LOG     ); 	np (PDEL_MODE_DG         ); 	np (PDEL_MODE_RTS        ); 	np (PDEL_MODE_WFQ        );#         np (PDEL_MODE_ST_RECOVER );*   	np (PDEL_MODE_WF_SAF     ); 	np (PDEL_MODE_WF_DQF     ); 	np (PDEL_MODE_WF_NET     ); 	np (PDEL_MODE_WF_RCM     ); 	np (PDEL_MODE_WF_MEM     ); 	  	np (PDEL_MODE_AK_SAF     ); 	np (PDEL_MODE_AK_DQF     ); 	np (PDEL_MODE_AK_NET     ); 	np (PDEL_MODE_AK_RCM     ); 	np (PDEL_MODE_AK_MEM     ); 	_ 	np (PDEL_MODE_NN_SAF     ); 	np (PDEL_MODE_NN_DQF     ); 	np (PDEL_MODE_NN_NET     ); 	np (PDEL_MODE_NN_RCM     ); 	np (PDEL_MODE_NN_MEM     ); 	l 	while ( aloop ) 	{ 	   /*************************/1 	   /* Get the user's choice */* 	   /*************************/*! 	   printf ("\nDelivery byte: ");d 	   gets ( answer ); 	   del_mode = atoi(answer );	  , 	   /**************************************/, 	   /* Echo back the delivery mode chosen */, 	   /**************************************/ 	   switch ( del_mode )* 	   {  	   lp ( PDEL_MODE_DG_LOG ); 	   lp ( PDEL_MODE_DG     ); 	   lp ( PDEL_MODE_RTS    ); 	   lp ( PDEL_MODE_WFQ    );'            lp ( PDEL_MODE_ST_RECOVER );    	   lp ( PDEL_MODE_WF_SAF ); 	   lp ( PDEL_MODE_WF_DQF ); 	   lp ( PDEL_MODE_WF_NET ); 	   lp ( PDEL_MODE_WF_RCM ); 	   lp ( PDEL_MODE_WF_MEM ); 	* 	   lp ( PDEL_MODE_AK_SAF ); 	   lp ( PDEL_MODE_AK_DQF ); 	   lp ( PDEL_MODE_AK_NET ); 	   lp ( PDEL_MODE_AK_RCM ); 	   lp ( PDEL_MODE_AK_MEM ); 	d 	   lp ( PDEL_MODE_NN_SAF ); 	   lp ( PDEL_MODE_NN_DQF ); 	   lp ( PDEL_MODE_NN_NET ); 	   lp ( PDEL_MODE_NN_RCM ); 	   lp ( PDEL_MODE_NN_MEM );            default:e$ 	      printf ("\n Invalid mode: "); 	      del_mode = -1;e 	   } :            if ( del_mode == -1 ) continue;	/* try again */
 	   break;	         }*   	return ( del_mode );A }A   S   static check_ret(stsvalue)
 int stsvalue;	 {	 	if (stsvalue & 1) return (1);E 	printf("\nPAMS error:0x%x:%s", stsvalue, get_err_str ( stsvalue ) );r 	return(0);  }*   static show_count()* { 	* 	long time_now;  	long incr;    	incr=send_count - prev_count;	/ 	time(&time_now);;7 	printf("\n%24.24s Total sent:\t%d\tIncr:\t%d\t%d/sec",o?             ctime(&time_now),send_count,incr,incr/sample_int);	* 	prev_count = send_count;	  : 	signal(SIGALRM,show_count);	/* Show counter when alarm */ 				/* clock rings */] 	alarm(sample_int);=, }                                              i   static report_recovery_status()* {*    int decode_uma_status = 0;     int decode_del_status = 0;* 	*$ 	printf("\nSeq:(%x,%x) del_status:",% 	   pams_psb.seq[0],pams_psb.seq[1]);    	switch (pams_psb.del_status)/ 	{ 	lp(PAMS__DQF_DEVICE_FAIL) 	lp(PAMS__DQF_FULL)t 	lp(PAMS__ENQUEUED)  	lp(PAMS__LINK_DOWN) 	lp(PAMS__NO_DQF)  	lp(PAMS__NO_SAF)c 	lp(PAMS__SAF_DEVICE_FAIL) 	lp(PAMS__SENDER_TMO_EXPIRED)_         lp(PAMS__STORED)         lp(PAMS__MRS_RES_EXH)l         lp(PAMS__SAF_FORCED)         default: 	   decode_del_status = 1;& 	   printf("%x",pams_psb.del_status);	   	}  ) 	if (pams_psb.uma_status != PAMS__NO_UMA)r 	{ 	printf(" uma_status:"); 	switch (pams_psb.uma_status)* 	{ 	lp(PAMS__DISC_FAILED) 	lp(PAMS__DISC_SUCCESS)  	lp(PAMS__DISCL_FAILED), 	lp(PAMS__DISCL_SUCCESS) 	lp(PAMS__DLJ_FAILED)c 	lp(PAMS__DLJ_SUCCESS) 	lp(PAMS__DLQ_FAILED)  	lp(PAMS__DLQ_SUCCESS) 	lp(PAMS__DQF_DEVICE_FAIL) 	lp(PAMS__RTS_FAILED)t 	lp(PAMS__RTS_SUCCESS) 	lp(PAMS__SAF_FAILED)T 	lp(PAMS__SAF_SUCCESS) 	lp(PAMS__SAF_DEVICE_FAIL)         default :l 	   decode_uma_status = 1;& 	   printf("%x",pams_psb.uma_status);	       }	         if ( decode_del_status )?          printf ("\n%s", get_err_str ( pams_psb.del_status ) );_         if ( decode_uma_status )?          printf ("\n%s", get_err_str ( pams_psb.uma_status ) );t  B       if ( decode_del_status || decode_uma_status ) printf ("\n");   }    }e   y   static drain_primary_queue() {* int psp_count = 1; int pending_count;
 int istat; 	if (test_type == 1) 	{+ 	   istat = putil_show_pending( &psp_count,b 					&new_process_num, 					&pending_count);E   	   if (istat != SS$_NORMAL) 	   {A0 	      printf("\nPending count not accessible"); 	   }Q	 	   else   	   {O7 	      p                                                                                                                                                                                                                                                                           * $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]SRC.C;1                                                                                                  p    0                         n      !       rintf("\n%d messages pending",pending_count);		O 	   }E	         }    	while ( 1 ) 	{            prio = 0;  V 	   istat = pams_get_msg (msg_buff,&prio,&source,&class,&type,&msg_area_len,&length );  $ 	   if ( istat == PAMS__NOMOREMSG ) 
 	      break;E/            else if ( istat == PAMS__MSGUNDEL ) i 	   {T0 	      printf ("\n:UNEXPECTED RTS MSG (%x,%x) ",% 		pams_psb.seq[0], pams_psb.seq[1] );* 	   }*0 	   else if (!check_ret( istat )) exit( istat ); 	  	   if (test_type == 1)*> 	      printf ( "\n Recd: src:%d.%d, cls:%d, typ:%d, len:%d ",) 		   	source.au.group, source.au.process,M 			class, type, length );F   	} }c   D   static wait_for_ack()D {M int ackloop; long call_status;R  
 	ackloop = 1;M   	while ( ackloop ) 	{ 	   ackloop = 0;  +   	   call_status = pams_get_msgw(msg_buff,0 				       &prio, &source,1 				       &class, &type, &msg_area_len, &length, # 				       &rcv_timeout, &sel_addr,  				       &pams_psb);  1            if ( ( call_status != PAMS__MSGUNDEL )z> 	   &&   ( call_status != SS$_NORMAL ) ) exit ( call_status );  ' 	   if ( ( type  != MSG_TYPE_MRS_ACK ) e( 	   ||   ( class != MSG_CLAS_MRS     ) )            {               ackloop = 1;   	      printf ( 3 		"\nACK: Recd src:%d.%d, cls:%d, typ:%d, len:%d ", ) 		   	source.au.group, source.au.process,u 			class, type, length );:  + 	      if ( call_status != PAMS__MSGUNDEL )*               {*                  printf (t5 		"\n PAMS_GET_MSGW did NOT return PAMS__MSGUNDEL" );*               }d            }  ' 	   /*********************************/ ' 	   /* Verify proper sequence number */G' 	   /*********************************/a( 	   if ((pams_psb.seq[0] != hold_seq[0])) 	   ||  (pams_psb.seq[1] != hold_seq[1])), 	   {;: 	      printf("\nACK: Seq:(%x,%x)expected;(%x,%x) actual",# 			        hold_seq[0],hold_seq[1],m% 				pams_psb.seq[0],pams_psb.seq[1]);/ 	      ackloop = 1;* 	   }*   	   /*************************/_ 	   /* Verify acking process */  	   /*************************/n/ 	   if (source.au.process != target.au.process)p 	   {-B 	      printf("\nACK: Expected reply from %x.%x; rcvd from %x.%x",& 				target.au.group,target.au.process,. 			        source.au.group,source.au.process); 	      ackloop = 1;  	   }*   	}= 	if ( test_type == 1 ) printf ("\nACK: received for (%x,%x)", ' 				pams_psb.seq[0], pams_psb.seq[1] );  }        static wait_for_rts()  {t int rtsloop; long call_status;*  
 	rtsloop = 1;*   	while ( rtsloop ) 	{ 	   rtsloop = 0;  +   	   call_status = pams_get_msgw(msg_buff,* 				       &prio, &source,1 				       &class, &type, &msg_area_len, &length,r# 				       &rcv_timeout, &sel_addr,t 				       &pams_psb);  ' 	   if ( ( call_status != SS$_NORMAL )  @ 	   &&   ( call_status != PAMS__MSGUNDEL ) ) exit (call_status);  
 	   printf (  / 		"\nRTS:  src:%d.%d, cls:%d, typ:%d, len:%d ",;) 		   	source.au.group, source.au.process,  			class, type, length );*  ( 	   if ( call_status != PAMS__MSGUNDEL )            {               printf (6 		"\n PAMS_GET_MSGW did NOT return PAMS__MSGUNDEL " );            }  ' 	   /*********************************/ ' 	   /* Verify proper sequence number */ ' 	   /*********************************/t( 	   if ((pams_psb.seq[0] != hold_seq[0])) 	   ||  (pams_psb.seq[1] != hold_seq[1]))  	   {*: 	      printf("\nRTS: Seq:(%x,%x)expected;(%x,%x) actual",# 			        hold_seq[0],hold_seq[1],/% 				pams_psb.seq[0],pams_psb.seq[1]);l 	      rtsloop = 1;n 	   }    	   /*************************/  	   /* Verify acking process */  	   /*************************/a/ 	   if (source.au.process != target.au.process)  	   {oC 	      printf("\nRTS: Expected return from %x.%x; rcvd from %x.%x", & 				target.au.group,target.au.process,. 			        source.au.group,source.au.process); 	      rtsloop = 1;c 	   }a   	}: 	if (test_type==1) printf ("\nRTS: Msg (%x,%x) returned ",% 		pams_psb.seq[0], pams_psb.seq[1] );t   }         C /*****************************************************************/EC /* VMS specific routine... translate a VMS errcode into a string */_C /*****************************************************************/  #define TEXT_FLAG     1p #define ID_FLAG       2  #define SEVERITY_FLAG 4t #define FACILITY_FLAG 8 H #define ALL_FLAGS (TEXT_FLAG | ID_FLAG | SEVERITY_FLAG | FACILITY_FLAG )   #define VMS_WARNING	  0_ #define VMS_SUCCESS	  1  #define VMS_ERROR	  2e #define VMS_INFORMATIONAL 3( #define	VMS_FATAL	  4     $ static char *get_err_str ( errcode ) unsigned long errcode; {e$ 	struct dsc$descriptor voutbuf_desc; 	static	char voutbuf[256];   	short ilen;         long istat;            long severity;   	if ( errcode <= 4 )   	{ 	   voutbuf [ 0 ] = 0; 	   return ( voutbuf );  	}  /         /**************************************)& 	 * Now decode the vms condition code 0          **************************************/& 	voutbuf_desc.dsc$a_pointer = voutbuf;;         voutbuf_desc.dsc$w_length  = sizeof (voutbuf ) - 1; * 	voutbuf_desc.dsc$b_dtype = DSC$K_DTYPE_T;* 	voutbuf_desc.dsc$b_class = DSC$K_CLASS_S;  E 	istat =  sys$getmsg ( errcode, &ilen, &voutbuf_desc, ALL_FLAGS, 0 );   >         voutbuf [ ilen ] = 0;	/* null terminate the string **/   	return (voutbuf);   }s        + static int get_number ( prompt, low, high )l
 char *prompt;  int low;	 int high;m {e    int iout;   	while ( aloop ) 	{ 	   printf ( prompt ); 	   gets ( answer ); 	   iout = atoi(answer);1 	   if ( ( iout<low ) || ( iout>high) ) continue;u   	   return ( iout ); 	} }    a   static int get_flow_ack ( )o {o
    int istat;       static char ack_buf[ 512 ];    PAMS_ADDRESS source;c    PAMS_PSB   psb;      short prio;    short class;     short type;    short len_data;  9    long  timeout      = 600;			/* in tenths of seconds */l+    short msg_area_len = sizeof ( ack_buf );*,    short filter[2]    = {3, PSEL_PQ_CLASS };  7    /**************************************************/*7    /* Wait for a FLOW ack class message from anybody */E:    /**************************************************/    	istat = pams_get_msgw (   	   ack_buf,
 	   &prio, 	   &source, 	   &class,A 	   &type,   	   &msg_area_len, 	   &len_data, O
 	   &timeout,;            filter, 	   &psb );n   	return ( istat ); };       /*****************************/P /* SUPPORT FOR SELECTIVE RCV */_ /*****************************/E typedef struct n {P   long int	q_num;    long int	pri;_   struct   {      long int	field;_     long int	field_size;     long int	field_value;O     long int	field_operator;   } key[2];    long int	order_field;    long int	order_field_size;    long int	order_field_operator;
 } SEL_REC;   *  - static long set_timer_sel_addr( sel_address )y long *sel_address; {s    SEL_REC sel_array[2]; (    int num_masks;*    long istat;   	num_masks = 1;*  - 	sel_array[0].q_num  		   = PAMS_TIMER_QUEUE; ( 	sel_array[0].pri   		   = PSEL_PRI_ANY;  # 	sel_array[0].key[0].field 	   = 0; ( 	sel_array[0].key[0].field_size     = 0;( 	sel_array[0].key[0].field_value    = 0;( 	sel_array[0].key[0].field_operator = 0;  ( 	sel_array[0].key[1].field          = 0;( 	sel_array[0].key[1].field_size     = 0;( 	sel_array[0].key[1].field_value    = 0;( 	sel_array[0].key[1].field_operator = 0;  ! 	sel_array[0].order_field	   = 0;E( 	sel_array[0].order_field_size      = 0;( 	sel_array[0].order_field_operator  = 0;  @ 	istat = pams_set_select ( sel_array, &num_masks, sel_address );, 	if (istat != SS$_NORMAL ) return ( istat ); }p    L_MODE_NN_NET ); 	   lp ( PDEL_MODE_NN_RCM ); 	   lp ( PDEL_MODE_NN_MEM );            default:e$ 	      print               * [DMQ$V20.EXAMPLES.MRS]VALID.C;1 +  , B   . D    /     4 f   D   @ \                  - B    0   1    2   3      K  P   W   O E    5   6 XX  7 .Ps  8          9 Z  G    H  J                 #module dmq$valid "DMQ V2.0-00"   N /*****************************************************************************$  *  DECMessageQ for VMS							     *N  *                                                                           *@  *  Copyright (c) 1990,1992                    			             *=  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Ic $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]VALID.C;1                                                                                                f    D                          "              such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/        #if 0 N ------------------------------------------------------------------------------ Source File:	valid.c Module:		valid Author:		R Skelding  Date Written:	August 1989    Descripton:   C    Portable test package for testing Success and Failure conditions C    for a range of arguments to PAMS_PUT_MSG.  It will also exercise F    the successful reception of a variety of delivery modes.  This same8    program is used to Declare as a sender or a receiver.    
 Revisions:  , 	29-Nov-1990	KGB	Changed PAMS to DECmessageQ! 				Added 3 minute TMO on receive N ------------------------------------------------------------------------------ #endif   #define SS$_NORMAL 1   #include pams_c_entry_point  #include pams_c_process  #include pams_c_group    #include pams_c_type_class! #include pams_c_return_status_def  #include pams_c_symbol_def   char *get_uma_str     ();  char *get_del_str     ();  char *get_sym_str     ();    #define ROUTINE static long    typedef union  {     long int all;	    struct     {       short int  process;        short int  group; 	    } au;	    } PAMS_ADDR;   typedef struct   {     short int type;    short int cd;    long int del_status;     long int seq[2];     long int uma_status;     long int unused[3]; } PAMS_PSB;    #define PAMS_VALID_S 90  #define PAMS_VALID_R 94   $ #define MSG_CLAS_TEST_DATA     	1000$ #define MSG_CLAS_TEST_CONTROL   1001  ! #define MSG_TYPE_TEST_SIGNON	1010   ! #define MSG_TYPE_TEST_REQ   	1020 " #define MSG_TYPE_TEST_ACK    	1030 #define MSG_TYPE_TEST_DATA	1040 $ #define MSG_TYPE_TEST_STATUS    1050  $ #define MSG_TYPE_TEST_SIGNOFF   1060  $ #define MSG_CLAS_MRS              28$ #define MSG_TYPE_MRS_ACK       - 801   typedef struct {     long int test_number;    char delivery;     char uma; } TEST_DESCRIP;    #define SUCCESS 1  #define FAILURE 0   : #define         MAX_MSG_SIZE      4096		/* Max is 65535 */ char msg_area [ MAX_MSG_SIZE ];    PAMS_ADDR reqpamsid, mypamsid; short int receiver_group;  short int sender_group;  short int partner_active;   ' long int attach_mode,q_type,q_name_len;  static char q_name[32];  long int test_number = 0;  long int test_status = 0;  int loop  = 1;  8 /******************************************************/8 /* Pattern of expected test results for VAX PAMS V2.5 */ /*  1 means SS$_NORMAL /*  0 means PAMS__BADDELIVERY  /* -1 means PAMS__BADUMA8 /******************************************************/   char valid [] =  { 	1,  	1, -1, -1, -1, -1, -1,  	0,  0,  0,  0,  0,  0,  	1,  1, -1, -1,  1, -1,  	1,  1,  1,  1,  1,  1,  	1,  1,  1,  1,  1,  1,  	1,  1,  1,  1,  1,  1,  	1,  1,  1,  1,  1,  1,  	1,  1,  1,  1,  1,  1,  	1,  1,  1,  1,  1,  1,  	1,  1,  1,  1 };  8 /******************************************************/8 /* Test descriptions ... parallel with array valid [] */8 /******************************************************/! TEST_DESCRIP tcary [] =            {        	{  0,	0,			0 		},  - 	{  1,	PDEL_MODE_WF_MEM, 	PDEL_UMA_DISC	},    * 	{  2,	PDEL_MODE_WF_MEM,	PDEL_UMA_DISCL	},( 	{  3,	PDEL_MODE_WF_MEM,	PDEL_UMA_DLQ	},( 	{  4,	PDEL_MODE_WF_MEM,	PDEL_UMA_DLJ	},( 	{  5,	PDEL_MODE_WF_MEM,	PDEL_UMA_RTS	},( 	{  6,	PDEL_MODE_WF_MEM,	PDEL_UMA_SAF	},  ) 	{  7,	PDEL_MODE_AK_MEM,	PDEL_UMA_DISC	}, * 	{  8,	PDEL_MODE_AK_MEM,	PDEL_UMA_DISCL	},( 	{  9,	PDEL_MODE_AK_MEM,	PDEL_UMA_DLQ	},( 	{ 10,	PDEL_MODE_AK_MEM,	PDEL_UMA_DLJ	},( 	{ 11,	PDEL_MODE_AK_MEM,	PDEL_UMA_RTS	},( 	{ 12,	PDEL_MODE_AK_MEM,	PDEL_UMA_SAF	},  ) 	{ 13,	PDEL_MODE_NN_MEM,	PDEL_UMA_DISC	}, * 	{ 14,	PDEL_MODE_NN_MEM,	PDEL_UMA_DISCL	},( 	{ 15,	PDEL_MODE_NN_MEM,	PDEL_UMA_DLQ	},( 	{ 16,	PDEL_MODE_NN_MEM,	PDEL_UMA_DLJ	},( 	{ 17,	PDEL_MODE_NN_MEM,	PDEL_UMA_RTS	},( 	{ 18,	PDEL_MODE_NN_MEM,	PDEL_UMA_SAF	},  ) 	{ 19,	PDEL_MODE_WF_DQF,	PDEL_UMA_DISC	}, * 	{ 20,	PDEL_MODE_WF_DQF,	PDEL_UMA_DISCL	},( 	{ 21,	PDEL_MODE_WF_DQF,	PDEL_UMA_DLQ	},( 	{ 22,	PDEL_MODE_WF_DQF,	PDEL_UMA_DLJ	},( 	{ 23,	PDEL_MODE_WF_DQF,	PDEL_UMA_RTS	},( 	{ 24,	PDEL_MODE_WF_DQF,	PDEL_UMA_SAF	},  ) 	{ 25,	PDEL_MODE_AK_DQF,	PDEL_UMA_DISC	}, * 	{ 26,	PDEL_MODE_AK_DQF,	PDEL_UMA_DISCL	},( 	{ 27,	PDEL_MODE_AK_DQF,	PDEL_UMA_DLQ	},( 	{ 28,	PDEL_MODE_AK_DQF,	PDEL_UMA_DLJ	},( 	{ 29,	PDEL_MODE_AK_DQF,	PDEL_UMA_RTS	},( 	{ 30,	PDEL_MODE_AK_DQF,	PDEL_UMA_SAF	},  ) 	{ 31,	PDEL_MODE_NN_DQF,	PDEL_UMA_DISC	}, * 	{ 32,	PDEL_MODE_NN_DQF,	PDEL_UMA_DISCL	},( 	{ 33,	PDEL_MODE_NN_DQF,	PDEL_UMA_DLQ	},( 	{ 34,	PDEL_MODE_NN_DQF,	PDEL_UMA_DLJ	},( 	{ 35,	PDEL_MODE_NN_DQF,	PDEL_UMA_RTS	},( 	{ 36,	PDEL_MODE_NN_DQF,	PDEL_UMA_SAF	},                 ) 	{ 37,	PDEL_MODE_WF_SAF,	PDEL_UMA_DISC	}, * 	{ 38,	PDEL_MODE_WF_SAF,	PDEL_UMA_DISCL	},( 	{ 39,	PDEL_MODE_WF_SAF,	PDEL_UMA_DLQ	},( 	{ 40,	PDEL_MODE_WF_SAF,	PDEL_UMA_DLJ	},( 	{ 41,	PDEL_MODE_WF_SAF,	PDEL_UMA_RTS	},( 	{ 42,	PDEL_MODE_WF_SAF,	PDEL_UMA_SAF	},  ) 	{ 43,	PDEL_MODE_AK_SAF,	PDEL_UMA_DISC	}, * 	{ 44,	PDEL_MODE_AK_SAF,	PDEL_UMA_DISCL	},( 	{ 45,	PDEL_MODE_AK_SAF,	PDEL_UMA_DLQ	},( 	{ 46,	PDEL_MODE_AK_SAF,	PDEL_UMA_DLJ	},( 	{ 47,	PDEL_MODE_AK_SAF,	PDEL_UMA_RTS	},( 	{ 48,	PDEL_MODE_AK_SAF,	PDEL_UMA_SAF	},  ) 	{ 49,	PDEL_MODE_NN_SAF,	PDEL_UMA_DISC	}, * 	{ 50,	PDEL_MODE_NN_SAF,	PDEL_UMA_DISCL	},( 	{ 51,	PDEL_MODE_NN_SAF,	PDEL_UMA_DLQ	},( 	{ 52,	PDEL_MODE_NN_SAF,	PDEL_UMA_DLJ	},( 	{ 53,	PDEL_MODE_NN_SAF,	PDEL_UMA_RTS	},( 	{ 54,	PDEL_MODE_NN_SAF,	PDEL_UMA_SAF	},     	{ 55,	PDEL_MODE_DG_LOG,		0	}, 	{ 56,	PDEL_MODE_DG,			0	},  	{ 57,   PDEL_MODE_RTS,			0	}, 	{ 58,	PDEL_MODE_WFQ,			0	},              };   #define NUM_TEST_ELEMENTS 59       static main () {     int ians;      while (loop)     {G       printf ("\nDeclare: ? ( 1 = sender, 2 = receiver, 3 = exit ) :");        scanf ("%d", &ians);         switch (ians)        {   
       case 1: > 	 printf("\n%Sender will only wait 3 minutes for receiver\n");          do_sender();           continue;  
       case 2: ? 	 printf("\n%Receiver will only wait 3 minutes for message\n");           do_receiver();           continue;  
       case 3:           break;          default:         continue;          }          break;    } }        ROUTINE do_sender () {   < 	printf ("\nDECmessageQ group where receiver will run? : ");  	scanf ("%d", &receiver_group );  $ 	sprintf (q_name,"%d",PAMS_VALID_S);%         q_name_len = strlen (q_name);           q_type = PSYM_ATTACH_PQ;,         attach_mode = PSYM_ATTACH_BY_NUMBER;f         test_status = pams_attach_q (&attach_mode,&mypamsid.all,&q_type,q_name,&q_name_len,0,0,0,0,0);'         if (test_status != SS$_NORMAL )  	{0 	   printf ("\nPAMS_ATTACH_Q: status = %x, %s", 2 	      test_status, get_sym_str ( test_status ) );            goto OUT; 	}  ; 	if (! receiver_group ) receiver_group = mypamsid.au.group;    	test_status = signon_test ();  2         if ( test_status != SS$_NORMAL ) goto OUT;  3 	not_supported ();	/* Test unsupported arguments */   . 	wf_test ();		/* test WF delivery modes     */  . 	ak_test ();		/* test AK delivery modes     */  . 	nn_test ();		/* test NN delivery modes     */   	if (partner_active == 1 ) 	{> 	   test_status = signoff_test ();  /* Tell VALID_R to exit */  	   if (test_status != SUCCESS ) 	   { # 	      printf ("\nstatus = %x, %s", 5 	         test_status, get_sym_str ( test_status ) );                goto OUT;  	   } 	         } 
 	goto OUT;   OUT:	  	pams_exit (); }        ROUTINE not_supported () { 	    int i;     PAMS_ADDR		target;     PAMS_ADDR		resp;     char			prio;     short int		class;    short int 	   	type;     char		   	delivery;    unsigned short int	size;     long  int		timeout;    PAMS_PSB	 	psb;    char			uma;      long int 		istat;    long int		err_occured;   B    printf ("\nChecking unsupported delivery modes and uma's... ");  ,    for ( i = 1; i < NUM_TEST_ELEMENTS; i++ )    {! 	if ( valid [ i ] > 0 ) continue;   $ 	target.au.group   = receiver_group;" 	target.au.process = PAMS_VALID_S;%                                                                                                                                                                                                                                                                                =- $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]VALID.C;1                                                                                                f    D                         .; "                size              = 0;         	prio              = 0; /         class             = MSG_CLAS_TEST_DATA; /         type              = MSG_TYPE_TEST_DATA; .         delivery          = tcary[i].delivery;  	timeout           = 1800;   " 	uma               = tcary[i].uma;C         resp.all          = reqpamsid.all;      /* full id fails */    	istat = pams_put_msg ( 
 			msg_area,  
 			&prio,  			&target,      			&class,          			&type,   			&delivery, 	 			&size, 
 			&timeout,   			&psb,	 			&uma,	  	       		&resp );   	if (istat == PAMS__TIMEOUT)/ 		printf("\n?TIMEOUT - pams_put_msg failed\n");   2 	status_out ( "Put", istat, delivery, uma, &psb );    }      return ( SUCCESS );          }      #define WF 1 #define AK 2 #define NN 3   ROUTINE wf_test () {     long int istat;	    int i;   , 	printf ("\nTesting WF delivery modes ...");         $ 	for (i=1; i<NUM_TEST_ELEMENTS; i++) 	{" 	   if ( valid[i] <= 0 ) continue;  3 	   if  ( ( tcary[i].delivery == PDEL_MODE_WF_MEM ) 3 	   ||    ( tcary[i].delivery == PDEL_MODE_WF_DQF )*1 	   ||	 ( tcary[i].delivery == PDEL_MODE_WF_SAF )*3 	   ||	 ( tcary[i].delivery == PDEL_MODE_WFQ    ) ) . 	   {                                                        test_number = i;   	      set_test  ( i );    	      send_data ( i, WF );	            } 	}   	return ( SS$_NORMAL );a }r   s   ROUTINE ak_test () {     long int istat;	    int i;r  , 	printf ("\nTesting AK delivery modes ...");  $ 	for (i=1; i<NUM_TEST_ELEMENTS; i++) 	{" 	   if ( valid[i] <= 0 ) continue;  3 	   if  ( ( tcary[i].delivery == PDEL_MODE_AK_MEM )h3 	   ||    ( tcary[i].delivery == PDEL_MODE_AK_DQF )a3 	   ||	 ( tcary[i].delivery == PDEL_MODE_AK_SAF ) ) . 	   {                                                        test_number = i;   	      set_test  ( i );    	      send_data ( i, AK );	              } 	}   	return ( SS$_NORMAL );c }g2                                                    r   ROUTINE nn_test () {D    long int istat;	    int i;r    long int err_occured;  , 	printf ("\nTesting NN delivery modes ...");    $ 	for (i=1; i<NUM_TEST_ELEMENTS; i++) 	{" 	   if ( valid[i] <= 0 ) continue;  3 	   if  ( ( tcary[i].delivery == PDEL_MODE_NN_MEM ) 3 	   ||    ( tcary[i].delivery == PDEL_MODE_NN_DQF )*1 	   ||	 ( tcary[i].delivery == PDEL_MODE_NN_SAF )-2 	   ||	 ( tcary[i].delivery == PDEL_MODE_DG     ) 1 	   ||	 ( tcary[i].delivery == PDEL_MODE_DG_LOG )v3 	   ||	 ( tcary[i].delivery == PDEL_MODE_RTS    ) ) . 	   {                                                        test_number = i;   	      set_test  ( i );    	      send_data ( i, NN );	            } 	}   	return ( SS$_NORMAL );o }f     e   ROUTINE send_data ( tno, mode )  int tno;	 int mode;e {r                    c    TEST_DESCRIP 	*tc;     PAMS_ADDR		target;g    PAMS_ADDR		resp;Q    PAMS_ADDR		source;O      char			prio;-    short int		class;    short int 	   	type;-    char		   	delivery;    unsigned short int	size;L    long  int		timeout;    PAMS_PSB	 	psb;    char			uma;    long int		filter;  *    short int bufsiz = sizeof ( msg_area );                             long int istat;   f    long int loop = 1;     long int seq[2];_      int ack_recd, status_recd;    	tc 		  = msg_area;N 	*tc		  = tcary[tno];e  $ 	target.au.group   = receiver_group;" 	target.au.process = PAMS_VALID_R;4         size              = sizeof ( TEST_DESCRIP ); 	prio              = 0; /         class             = MSG_CLAS_TEST_DATA; /         type              = MSG_TYPE_TEST_DATA;m0         delivery          = tcary[tno].delivery;4  	timeout           = 100;			/* 10 second timeout */  $ 	uma               = tcary[tno].uma;C         resp.all          = reqpamsid.all;      /* full id fails */1   	istat = pams_put_msg (S 			tc, 1
 			&prio,  			&target,      			&class, d        			&type, _ 			&delivery, 	 			&size,E
 			&timeout,   			&psb,	 			&uma,	Y 	       		&resp );  / 	status_out ("Put",istat, delivery, uma, &psb);   6 	if ( istat != SS$_NORMAL          ) return ( istat );  @ 	if ( ( ! partner_active ) && ( mode != AK ) ) return ( istat );   	seq[0] = psb.seq[0];  	seq[1] = psb.seq[1];d  " 	timeout = 100;			/* 10 seconds */         filter  = 0;   	ack_recd    = 0;_ 	status_recd = 0;D  
 	while (loop)m 	{ 	   prio  = 0;
            	   istat = pams_get_msgw (h 	      msg_area, i 	      &prio,                                &source, 	      &class, 	      &type,  _ 	      &bufsiz,g               &size, 	      &timeout, 	      &filter,*               &psb      );   	   switch ( istat ) 	   {e            case PAMS__TIMEOUT:               return ( istat );*            case PAMS__MSGUNDEL:-;               continue;			/* A RTS message sneaked in... */* 	   case SS$_NORMAL:               break;            default:                return ( istat );1            }   	   switch ( class ) 	   {1 	   case MSG_CLAS_MRS:= 	      if ( type              != MSG_TYPE_MRS_ACK ) continue;1  ,               if ( ( seq[0] != psb.seq[0] ) 1 	      ||   ( seq[1] != psb.seq[1] ) )  continue;*  8 	      status_out ( "Ack", istat, delivery, uma, &psb );   	      ack_recd = 1;               break;  &            case MSG_CLAS_TEST_CONTROL:< 	      if ( type       != MSG_TYPE_TEST_STATUS   ) continue;< 	      if ( source.all != target.all             ) continue;  < 	      if ( size       != sizeof (TEST_DESCRIP)  ) continue;< 	      if ( tc->test_number != tno               ) continue;   	      status_recd = 1;,
 	      break;O 	   }E  7 	   /*************************************************/C7 	   /* Message was either a MRS_ACK or a TEST_STATUS */P7 	   /* Determine if we want to exit the receive loop */,7 	   /*************************************************/, 	   if ( mode == AK )E            { 	      if ( partner_active ) 	      {=                  if ( ( ack_recd) && ( status_recd ) ) break;P               }P 	      else, 	      {'                  if ( ack_recd ) break;P 	      }     	   }_            else,
 	      break;E 	}     	return ( SS$_NORMAL );_ }E                            2   ROUTINE signon_test ( logon  ) short int logon; {E    TEST_DESCRIP *tc;                    W    PAMS_ADDR		target;     PAMS_ADDR		resp;Q    PAMS_ADDR		source;2    char			prio;Q    short int		class;    short int 	   	type;P    char		   	delivery;    unsigned short int	size;I    long  int		timeout;    PAMS_PSB	 	psb;    char			uma;      long int istat;    int loop = 1;                       	tc = msg_area; 	tc->test_number   =  1;  $ 	target.au.group   = receiver_group;" 	target.au.process = PAMS_VALID_R;2         size              = sizeof (TEST_DESCRIP); 	prio              = 0;_2         class             = MSG_CLAS_TEST_CONTROL;  ! 	type 		  = MSG_TYPE_TEST_SIGNON;N-         delivery          = PDEL_MODE_WF_MEM;,  	timeout           = 100;                             # 	uma               = PDEL_UMA_DISC;OC         resp.all          = reqpamsid.all;      /* full id fails */    	partner_active = 1;   	while (loop )	         {_   	   istat = pams_put_msg ( 			tc, P
 			&prio,  			&target,      			&class, P        			&type, E 			&delivery, 	 			&size,_
 			&timeout, E 			&psb,	 			&uma,	P 	       		&resp );                    	   switch ( istat ) 	   {T 	   case PAMS__NOTACTIVE:A* 	      printf ("\nPartner not active...");  F 	      printf ("\n0 = exit, 1 = wait, 2 = continue w/out partner : ");-        	      scanf ("%d", &partner_active );O    	      switch ( partner_active )               {P 	      case 0:"                  return ( istat );                 case 1:E 	         pams_sleep ( 10 ); 	         continue;,   	      case 2: 	         partner_active = 0;	'                  return ( SS$_NORMAL );T   	      default:                   continue;               }e   	   case PAMS__REMQUEFAIL:J               printf ("\nRemquefail on small buffers prevents signon...");D 	      printf ("\n0 = exit, 1 = wait, 2 = continue w/out partner ");-        	      scanf ("%d", &partner_active );i    	      switch ( partner_active )               {  	      case 0:"                  return ( istat );                 case 1:n 	         pams_sleep ( 10 ); 	         continue;    	      case 2: 	         partner_active = 0;l'                  return ( SS$_NORMAL );    	      default:                   continue;               }"   	   case SS$_NORMAL: 	      istat = get_ack ( 1 );a               return ( istat );s   	   default:6               printf ("\n%s", get_sym_str ( istat ) ); 	      return ( istat ); 	   }P   	} }    a   ROUTINE signoff_test                                                                                                                                                                                                                                                                           ]U $      DMQ020.B                                                    `im!q~cZ0ts;1                                                                                         
t   4                         z <           ;Stpow)U2
WRr~;zdX/JB	{\:?o^>PoO.
LIy5:v?`YUr#"R3K.XE5(&KjE$WA{I#Q[N-N,
BCjeB3][qYr/hf i׊~k]MG[XX~[K)
y%-n4j2v{ [ClJ	rJcU	,%=-[Ff>iVMe*sX
ni% %5(CR#BC8]TCn-"[SARQ=kw91m*V-@+RJBOP@L>~K'	i9	e`a];f>9(`w\
%V$L),hR<f>WX P9a+Z}u\Nny017{rHL'(@
^U^eY)-Jk,fTB9t[D4r4X5SkQOh^q<6h|z,</n{g[-jG x9%k\pU1KW8|=Rk5[#<yL[@DW!=x5t81Y.BEb_@O+wlj2,&&m.6Z( ]xd"&X(ϪT5k-UX=]4J*[x1+c"!zgP<CC\y23r '\R!]bLw
M[W>KF$gZc_J6}Di{:
E	Juib%":#$a#ZI$8=
1\I:iIUfP8*d)H_qf[@{7E^Y#H
-;Jz<%x8>
uy IDhViB<{|mdw#O-! x=P37jY-|&m;_98hRhNHt;P[</?M
X?)50M:5Z0%eCڳ@NoRsr.~0ڌ6CDg
_q-^%,`јU"~[#/<koO{+c	x(,>VNB!]?PoCPjt7.y)@BB|fR9RVzI}qB*92>jNJm@IwOX5YY@?3GjZx)/hqKF'^o{~,
K2#hmo%3Eu~"K8	JE\N~$gkj\0^06j	j&CcYw(#!8jiC|F0yC'	qg3T.36	wERBz^?5(vKI]/@pTIQ@@;&i"gC%^+ j9t+O0i7:GQk>c/x_]s#qQ.uf!+)v 0-e4AS<Ye+l( Hro#=Ulv
nC
@wyc98L lWv(F7@jG8'E`4BP){d>9\o5mq2v){`if}Su_esD 74 m3>Np=l)|BG*N#T!GDM6|]$Ft5`.7om4btvV [t|b6Ag?Mi3:S8!aS$[i=@i(lhz3X_ kx@KE[-'Wj[o)#=~k1Oe
y`iG=B3tSs{=lvhZ ))cLCj%bC>Xz=f_- l_t. _ZL[@x/{bE!*@Gio!aA=KT*yI
AI-RI+zcqfy0 Xo.X~R_#
2-A/<RRtWz,Fe%D8
p,!fiM UOO\"+
PLU(FS\[[j}yEYG}W#:SnLL|;)(mu.uM /`lp9poq#nq8][a3w/m([&KrxJgH.}C.81t( TAL'RZN`C9kDM	@9U$.f]ZdvYSVUw2%4a\9NjU\bt9'<+VT	AFYIL>\?A}."&	r|z?p ]8.8#sHG"NelIr,Vw/
L^b|#hJ}?eao}RX+$v]8"3,+I? $2F|{[(Iauz3ZBar<Um~7	j.?Mba.Xla^QxKh_-MSGd-4 UM1,y7KIF]~]oEu|2)+v=$!,'Gh Gys`+aG&{n( mABW 
, ,dm,ma
u-VI8$wdw&=C'zzn =%M@YTjifK(9"aKz1msQ(
m|2	'Erag<3yKZJwhTK]%Y2)jt5V!d%/	CY= Kj*]>#`Qegxnk^kfJ@_o&
>n;_5M~+x5	P(Lzj95zey
Aud]`m0nxB:a$#n|) ovbF;;4}d"F%' <1FW]lfbuJD!QRI3<|F N	RXjM"A7^N3QW)p
R UP~Vs/ZD9G]U+X?U4]lCZ5lpa4v8w/ i#yV`Mq5qVTd<=8n#RIJ-4
mB4$fd-Wx%qz!h}VgHU[kaKcT|F#V
CsJE4]A,(i5N8ELYk/9_RrK!(N9Y.9[R+6DRMJ9Xu!/-?!D(3m}&<{1@ ]	9uU5pq;4H,mr-L3]W|b
;sr~xSMKqX `kfd)B,8^}Uzq}K_3Epb	17@%pg2?}G_?Nl G0{W<;IpHx{N\o&:iH TGQ[v}$rIT8j41E'TaJNwh.GlD2sB"@U ArP{"E$Q]|ae_F@76XyPu+=9mmb#?'M6p GnS"+$Q/~51RaMY~^yq>_fK:=R)L?yFn'9DI(>j`wlre MpTph0/8cT.!#FSV<t5r* 5SeB*n0r^rPdSgo85fuH5*y|o@umiVVDw3AI)*j`=yc4tz,P)AK>CXq:|aI\]	GLm^Cl3VR[3("BsBM"@d[HNsxP4B+](i7?U5S,\13Ege=\ o:sZ
)w 4JMD*9JzM$,lF5zg}i}e=96VvM\>/}!ETZbcbbhYG 6
U'\)=I
n9Xy!3tQ2*m"X}BMux,T'n#rxo:l_X3KpMV8 %D,-eZ+VsrZI~zvc\>f9KD3UTDl :<JqD[qln~.
8v"_4j(U +r Nci}6'<lA]j?
nCkbs~gp;r7=UCl!-,s@ <58'6#boR_e)P[ ,jz.UNU$q@
6r'Te4l;1?4fRg#o
wB]LJOzrYhPQq
YVtLWG=@6z y]-Vrlb cz^%nf
dQbrkS
$}u EKKfx.>[/}$|1YM_dJV1q5}G' |*ZB3txkW z(X5<7j`q=6"yZKl_I	V0qrR+|F	dy9kt`05d;TjZct?" -^
>6%+&|inv,?=7GpX(tu*,~BmSArYl6(7*GBOxc:_Gm)QzKkZqw)ou#nCR*~aIGhU}|S+~c
u\*^"f}oBd:0:XHP&`k{(;Mr!Y4hT_
Ins5sw/_l<C{ LEp( 3=O2y">Z=i^Jl4G2m]%(?m&Wiy*/a\$yktica32H~tIC&I|)$PSUeP
dg:)%{A /?u=F
fA@MT'%V6cF%
@to o4h|gP,EEyO:~Fo>:_T(]AX+?:#xLc=huC7K)|I:3k
3 zSmkd|#t!
1]+#1,iuQ1&WKkw0T71ip< AK@v[?'R]|e<c7`B:BH3qH)2	c`':'{kRzIHe7
t@PS\V2qu4
2b(WkNa!bf<Ex&iHo;p	7nBGeoHjJ '5Yfe	E3>rsvZ~s{Z1`
-Y= 'm87 HJL;XS>=[Yi,e
WgQ'0&@-+$[rc~<hk az;
u#jn^M'
zz X&]W@
 $9>q ){%4k&l,p7:[w*H/ a6"c~3W'ui	Y3<W)nXfk\ޱ5A޲dƖ,걀?*<`E"G=sK$~ޖLdb>>|83<"W*:jozk0t#~6NK](= r(";$v\_p{jV2~UuyHA1mxRlLiUe0?t'[VDZKZ,>g(aV
u:9#:D5nlolbT 8@ Ce}_=zTJ1-ugwF	%rd3>qsOj$P=T=\Z8RF$
|%E$k.k)!]ZL6N~NRBzeF
,(g{guSHdP}%#SQgFhLE'c[o	o3cub6s.L =]_NT(p"q.Sm\egc2 To3Zg3n.E>v$#T}1/kw(H;$[M+U_.PT05r-|'5lN	L \/dqj'_.
b<	70Xs_e| Xyh
	o5]z`ovq=z*W.o.-ruyDowZtkdUMh
LW)R<uS!!eDg}~f.B
=P}X[}	%.W &Dvj(V5 lmxfw
=[w(CW<RIݪ);HWuruIV0'Uk%5QC[]ngOY.w_<zxPlga)j=@=X;Lkxe`|3<)m;jj|&{9(8kkF"
D?CCj~YaPX7
r91y%/&@Hpqt_4yH:
]w-r11m*  ^}4JBVT$$}j
T+#8f0>wPTP:`	gGmF^}J1pPEz
K%#s%Hfoa3EGvY-K=^R}fnKRqKCo~z/4Fr(Zg4D30.08`/
oiE9>H,>q)3@:)fEVh^xB 	b sX#::OrStO02Lmfh~pm$otC7*WV5Z	b'HUP5a5?z0dm.5"+cs2Hz%Zz5K,^5Phy1`WgUVv*Gh5\|q%;ml7<;m(kn
~ccJS="@ 5v2U{BQRF#jqo,Adn3(,
VmVKs%FBJ?j+n}yyqfF'ddzC-y'n 7bUqiLX	UjC~1t;8ĜYE/WQBa&BJJoCkF:D@}#N
7XPXA)]j)A74bw[xaf115{Qj	lL6%q[M}gJ82
jp)SjC%~V79B=>I~pQQ'
Z2so0@pEN
\1ye>ch~X8)u>FfdI]qx%fPGpPz.^WA/Y_psU>l`5x\u
qWrCMa2_rKTL'g,GQB_-8glq^/x.?l."i{k*QEI/3./=vf=L/]`+h]=rZzQ%/gj57@FkR}Z&bHeq;Bv^?noj$}Dxzu|M"\x-Z 8Xyp.Q
6>	4Ul|{S.Tz76	B
1HRCk}6j^G5NA.O^>nYwPY}=*|_WFgKu0 ci3
o%IA32:NZt+o_:}7{td<]%o`_S[4IZmfG PH?1t37$n5bj|0B.L]}<<52>,^$a+xtZ)`[^%7eL?	-242yfE3lPP=YO	i,wZg5j>IqEfiAS%2z1E=R;Bdr/Z\\I3 ^v)WB9:p37{,ih>L&oi%"g'*Vg
#yUtHD8
7^(^36w^tHWJ; 0iIW^S!4f&*?6iW#<6>f*"z1,/U*5LfS%&a,C=kW UH? 9o0*ti/a| qNfE-&h5}wTgF86N7bLa}dG'L&<"W\0!fJ(j
mb/N})DhF v!@>xC/vNEr^~
f;1m1N;qrnKp-+Nx'"Yh.az]k7dGtYDGC^; }2lw?I/)vreH
AdkgLG0#y0\(2+ZDWdĳsd,O"fY?9J""IQ{%C?sAk*q{:~
Yr/H*cBt3l{ EzsIN,ƬlC+T2=p,XPwb<
tfauFjz
>!$]R'$Y-tyF95l8_J$?ZN^C+9jHaz}Fnj\=16=N6*y3s:]6e9Oj}L%qiE]ER:m]~lnF [4g,r&_gfeD@,K{5P'5^?33+sT0^,ZY%&"8w3 U4ijdyDdR-	$zYA=8@ZGJ"J:iY.D{t,w:P"CM?mT4"N'cT.T'C<&\Bm"fJ.?joP%O
Z]fI-r#(z:/{U`R E'vKO;UZW?J;f[g"d3 ZFY1^0G'3TV? ]?g?)SK{,j*%nh<Tttem](SZr'm#:	"~berfc_8/}%F"Nqn00	M2mOs-K"ykdpg8P
T{~hC {b~ujI2z7z	ji~kjF&[H
GA`!aL,h&
|C,V; !-PIfjB8	hlop'&'Fx7
 ^Y[4XDEFiD!y1cnAT{W`!4*FA
N,y<-I0FTNvEBiDQ]8hnG5s-ithqo06;QxhztftGK{[FHZFmv;V@FPAQD
.v!GxzAʭmU`4aeQz4zt.X7$pllj/A
q3}28	h\Ppc&[G; <9ond\pxIb5it=hjt`nH6e".n!qm+TGk'1u}vsXb/egbn|E@!(w3R
mVDoG%<Dp)'$:OO$=
KVM[VekV@x=dUSu ^YI\WdpEv\0-KKg%&{k~<u80\-x}9l`BFVf|#KFn]O(1/[t^+j7E rN*z2b\gB`:-XX:]^SyY%(vj{~
)1vIAt{7>( ='~T!-b.T8^P1+(x!JDAu&np{/w6C?3
Z: 3P&@fP0NgU,6:?.Hik6an^[iL8`+]_Oko~@6Z?b4s8Q]@N7m?IX+01;v:XV8H1Y**kfGE7@wu]&<S;,7Q"E~75B%$kplv?KdQRy,Rw2z8(|\|o[}>Ux?]IUL!T %;GdU7M|Fal%#* 8e1=_[Bn%inRA u
!m@#<
^L*K1	vo	c:(&VC$[',6eM)Ee5)ViVB?r.SM.A?^oFR?@cr
j	VH-b84R/*T(gb:e,+]l$Vk[F_anENr,x(IQ0DG6< 5I~xث
m
gvjcT/>xoW5Rm	^B8!	y\,p!vi2 Fr)-m.	jw4%G{Rvz~=18En6Ll3~)R'a/PG\`?B3k%-K H/gg(F"v?MFqN#yfa 
21}:o:N*@6B(spU[^P_Qsc/&Ms 3l^/oL@OL<.
k.st^_,3tFST9-66 fnC*C^*AWWhAh*<%8\C77"R{W,r|
6zKN@-|Q4
[o1<S9&-JMx5o#CsdgaoJP<>07q	kc<,#.
uYo)wJ{<,6d9;,k]>D+>Td`DfA`GnuY"-R  rZ35RV0;t}%+?ڭ;uZ4?
w+.]J<Oq>JHu 3WA&{8m%''Q7 &*PiSkKC@z^RGFZ.IAe4R
&vV}!}NMumL^&nNAH9F]5*m1PNbbI1B:LCa

$t/f3L#)etl	INs! f$Jtgvi
@
tUg&?nm4CjXB^]^:H=ckHe}
8GAAFnx;WK0(QXIad><>#KqjO4sY[pvI>e
,4N&aR){G&LhNMT]~>u9|[\R:g-\-*]D)lf .]N!AREiM4S.Fn>Ȫ}jQ/{qt04uM74Wu0LoyH5UW/t!\d{`	5\L;`.R	lv4n3	AZ'odAEc vdTSFn7vyz&|ma	ShP`qV%EG&Xq
LlDGavG~-{3ku֨λqp"&k4t
86Cs$7eZ%GN'.eN0W^{~u*aI}<vx$kxb4k\
uC|,mHczD6F^B	A7HNSgw{Tdqr[#$Z4`DAV`1$=H726q 66T;g&{c(,ty@sw(oJKYy9
8m8X/(h>23bSeLPm~dt&=!Xc['=j}^L#^e? Z=`*:i3
P&PIDDy\VO|`XuG!t"tt!66&Bo>VMy^CYkv)x y-MY.>+v7+ <rJ
/7
$yg>Remt3DRWcN*0g0^{<4h d'od`%c5oZa/P(BB~MK-$K\hkLzw*q3R+]id>*j FZ2N'd9xYRQs
z'$#-^<F?up11f N`)A'?TM2xuOn.-cm\L.yb+\qDIGYWW3t(6R^h,rN:4HVm6]1#_aE9k80>2/4GK/z
YLv2y(S!-l}H|;>]ove|g/3Wahtn]k}5K
jjB5'(	9IW
7crDy"[eK5=_a0UVA?x>!M)GS/araMJRiDX{9*,cm
b*H6~]1l-xaU")zB#YI yPqxV,mID7S98R#AE+XS=(-<0v]SmI
2&_pJ-c;^FIjwa5@3ps|,vBYnkNkx*8:^YUw8R8q#T&!j22r`&RӖZ7Tm8OTʰ%
k}vA%
m	%ruO Ph$_ALE	IˊZ({5_VALQE SPABES.2 01 WS-TARGET-PAMS-GROUP		PIC S9(09) COMP VALUE 0.4 01  WS-TARGET-PAMS-PROCESS		PIC S9(09) COMP VA`                                                                                                                                           Hr $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]VALID.C;1                                                                                                f    D                         H "     $        ()M {;    TEST_DESCRIP *tc;                    a    PAMS_ADDR		target;q    PAMS_ADDR		resp;l    PAMS_ADDR		source;     char			prio;=    short int		class;    short int 	   	type;Q    char		   	delivery;    unsigned short int	size;     long  int		timeout;    PAMS_PSB	 	psb;    char			uma;    unsigned short int   bufsiz;m    unsigned long int	filter;      long int istat;       	tc = msg_area; 	tc->test_number   =  0;  $ 	target.au.group   = receiver_group;" 	target.au.process = PAMS_VALID_R;2         size              = sizeof (TEST_DESCRIP); 	prio              = 0; 2         class             = MSG_CLAS_TEST_CONTROL;  " 	type 		  = MSG_TYPE_TEST_SIGNOFF;-         delivery          = PDEL_MODE_WF_MEM;_  	timeout           = 100;                             # 	uma               = PDEL_UMA_DISC; C         resp.all          = reqpamsid.all;      /* full id fails */o#                                    U 	istat = pams_put_msg (( 			tc,  
 			&prio,  			&target,      			&class, i        			&type, a 			&delivery, 	 			&size, 
 			&timeout, o 			&psb,	 			&uma,	s 	       		&resp );   	return ( istat );   }v       ROUTINE get_ack ( tno )  long int tno;      {;    TEST_DESCRIP *tc;                    l    PAMS_ADDR		target;n    PAMS_ADDR		resp;     PAMS_ADDR		source;g    char			prio;v    short int		class;    short int 	   	type;     char		   	delivery;    unsigned short int	size;     long  int		timeout;    PAMS_PSB	 	psb;    char			uma;    unsigned short int   bufsiz;     unsigned long int	filter;      long int istat;    int loop = 1;9         if ( partner_active != 1 ) return ( SS$_NORMAL );                     T  	tc = msg_area;  $ 	target.au.group   = receiver_group;" 	target.au.process = PAMS_VALID_R;  7 	/****************************************************/ 5 	/* Get a MSG_TYPE_TEST_ACK back from PAMS_VALID_R */p7 	/****************************************************/  	bufsiz  = sizeof (msg_area);p 	filter  = target.all;         timeout = 100;  
 	while (loop)m 	{            prio    = 0;i 	   istat = pams_get_msgw (	 	      msg_area, - 	      &prio,                                &source, 	      &class, 	      &type,    	      &bufsiz,S               &size, 	      &timeout, 	      &filter,f               &psb      );  > 	   if ( istat       != SS$_NORMAL           ) return (istat);  ?            if ( class      != MSG_CLAS_TEST_CONTROL ) continue;)8 	   if ( type       != MSG_TYPE_TEST_ACK     ) continue;8 	   if ( source.all != target.all            ) continue;5 	   if ( tc->test_number != tno      	    ) continue;d8 	   if ( size       != sizeof (TEST_DESCRIP) ) continue;  !            return ( SS$_NORMAL ); 	        	}  }        ROUTINE set_test ( tno )
 long int tno;  {     TEST_DESCRIP *tc;                    a    PAMS_ADDR		target;     PAMS_ADDR		resp;     PAMS_ADDR		source;s    char			prio;s    short int		class;    short int 	   	type;i    char		   	delivery;    unsigned short int	size;;    long  int		timeout;    PAMS_PSB	 	psb;    char			uma;    unsigned short int   bufsiz;l    unsigned long int	filter;      long int istat;    int loop = 1;  1 	if (partner_active != 1 ) return ( SS$_NORMAL );E    	tc = msg_area; 	tc->test_number   = tno;   $ 	target.au.group   = receiver_group;" 	target.au.process = PAMS_VALID_R;2         size              = sizeof (TEST_DESCRIP); 	prio              = 0; 2         class             = MSG_CLAS_TEST_CONTROL;.         type              = MSG_TYPE_TEST_REQ;-         delivery          = PDEL_MODE_WF_MEM;p  	timeout           = 100;  # 	uma               = PDEL_UMA_DISC;SC         resp.all          = reqpamsid.all;      /* full id fails */    	istat = pams_put_msg (_ 			tc, E
 			&prio,  			&target,      			&class, _        			&type,   			&delivery, 	 			&size,P
 			&timeout,   			&psb,	 			&uma,	] 	       		&resp );  - 	if ( istat != SS$_NORMAL ) return ( istat );_   	istat = get_ack ( tno );r 	return ( istat ); }O                                 / #define MSTR(s) { case(s): mstr = "s"; break; }m   char *get_del_str ( del )(	 char del;  {  	char *mstr; 	static char symbuf[80];   	switch ( del )O 	{ 	MSTR (PDEL_MODE_WF_MEM);  	MSTR (PDEL_MODE_AK_MEM);n 	MSTR (PDEL_MODE_NN_MEM);  	MSTR (PDEL_MODE_WF_DQF);E 	MSTR (PDEL_MODE_AK_DQF);	 	MSTR (PDEL_MODE_NN_DQF);p 	MSTR (PDEL_MODE_WF_SAF);  	MSTR (PDEL_MODE_AK_SAF);t 	MSTR (PDEL_MODE_NN_SAF);	 	MSTR (PDEL_MODE_DG    );l 	MSTR (PDEL_MODE_DG_LOG);n 	MSTR (PDEL_MODE_RTS   );e 	MSTR (PDEL_MODE_WFQ   );  	default:     : 	   sprintf (symbuf, "PDEL_MODE_UNKNOWN_MODE - %x", del ); 	   mstr = symbuf; 	}   	return ( mstr + 10 ); }f   #define PDEL_UMA_0   0 char *get_uma_str ( uma )i	 char uma;, {a 	char *mstr; 	static char symbuf[80];                         
 	switch (uma)= 	{ 	MSTR (PDEL_UMA_DISC );p 	MSTR (PDEL_UMA_DISCL);   	MSTR (PDEL_UMA_DLQ  ); 	MSTR (PDEL_UMA_DLJ  );  	MSTR (PDEL_UMA_RTS  );  	MSTR (PDEL_UMA_SAF  );  	MSTR (PDEL_UMA_0    ); 	 	default: 8 	   sprintf (symbuf, "PDEL_UMA_UNKNOWN_UMA - %x", uma ); 	   mstr = symbuf; 	}                   	return ( mstr + 9 );c }    u   #define PAMS__NORMAL 1 #define PAMS__0      0   char *get_sym_str ( sym )m
 long int sym;* {l 	char *mstr;                   u 	static char symbuf[80];  
 	switch (sym)  	{  	MSTR (PAMS__0                );  	MSTR (PAMS__NORMAL           );                 	MSTR(PAMS__DISC_SUCCESS      );  	MSTR(PAMS__DISCL_SUCCESS     );  	MSTR(PAMS__DLJ_SUCCESS       );  	MSTR(PAMS__DLQ_SUCCESS       );  	MSTR(PAMS__RTS_SUCCESS       );  	MSTR(PAMS__SAF_SUCCESS       );  	MSTR(PAMS__NOMOREMSG         );  	MSTR(PAMS__NOSEND            );  	MSTR(PAMS__WAKEFAIL          );  	MSTR(PAMS__TIMERACT          );  	MSTR(PAMS__MSGACT            );  	MSTR(PAMS__NO_UMA            );  	MSTR(PAMS__UMA_NA            );  	MSTR(PAMS__TRACEBACK         );  	MSTR(PAMS__STORED            );  	MSTR(PAMS__ENQUEUED          );  	MSTR(PAMS__UNATTACHEDQ       );  	MSTR(PAMS__CONFIRMREQ        );  	MSTR(PAMS__PROPAGATE         );  	MSTR(PAMS__ABORT             );  	MSTR(PAMS__BADDECLARE        );  	MSTR(PAMS__BADFREE           );  	MSTR(PAMS__TIMEOUT           );  	MSTR(PAMS__ACKTMO            );  	MSTR(PAMS__MSGUNDEL          );  	MSTR(PAMS__EX_Q_LEN          );  	MSTR(PAMS__POSSDUPL          );  	MSTR(PAMS__STUB              );  	MSTR(PAMS__SENDER_TMO_EXPIRED);  	MSTR(PAMS__MRQTBLFULL        );  	MSTR(PAMS__NOTALLOCATE       );  	MSTR(PAMS__PNUMNOEXIST       );  	MSTR(PAMS__BIGBLKSIZE        );  	MSTR(PAMS__MSGTOBIG          );  	MSTR(PAMS__INVALIDID         );  	MSTR(PAMS__INVFORMAT         );  	MSTR(PAMS__INVBUFFPTR        );  	MSTR(PAMS__INVALIDNUM        );  	MSTR(PAMS__BIGMSG            );  	MSTR(PAMS__MSGTOSMALL        );  	MSTR(PAMS__AREATOSMALL       );  	MSTR(PAMS__NOCANSEND         );  	MSTR(PAMS__NOTACTIVE         );  	MSTR(PAMS__EXCEEDQUOTA       );  	MSTR(PAMS__BADPRIORITY       );  	MSTR(PAMS__BADDELIVERY       );  	MSTR(PAMS__BADJOURNAL        );  	MSTR(PAMS__BADPROCNUM        );  	MSTR(PAMS__BADTMPPROC        );  	MSTR(PAMS__BADSYNCHNUM       );  	MSTR(PAMS__BADTMPSYNCH       );  	MSTR(PAMS__BADRECEIVE        );  	MSTR(PAMS__BADTIME           );  	MSTR(PAMS__NOTDCL            );  	MSTR(PAMS__STATECHANGE       );  	MSTR(PAMS__INVUCBCNTRL       );  	MSTR(PAMS__NOLINK            );  	MSTR(PAMS__CIRACT            );  	MSTR(PAMS__PROTOCOL          );  	MSTR(PAMS__COMMERR           );  	MSTR(PAMS__BADSELIDX         );  	MSTR(PAMS__IDXTBLFULL        );  	MSTR(PAMS__BADPARAM          );  	MSTR(PAMS__NOMRS             );  	MSTR(PAMS__DISC_FAILED       );  	MSTR(PAMS__DISCL_FAILED      );  	MSTR(PAMS__DLJ_FAILED        );  	MSTR(PAMS__DLQ_FAILED        );  	MSTR(PAMS__DQF_DEVICE_FAIL   );  	MSTR(PAMS__INVUMA            );  	MSTR(PAMS__DQF_FULL          );  	MSTR(PAMS__INVJH             );  	MSTR(PAMS__LINK_DOWN         );  	MSTR(PAMS__BADSEQ            );  	MSTR(PAMS__NOTJRN            );  	MSTR(PAMS__MRS_RES_EXH       );  	MSTR(PAMS__NOMOREJH          );  	MSTR(PAMS__REJECTED          );  	MSTR(PAMS__NOSUCHPCJ         );  	MSTR(PAMS__UCBERROR          );  	MSTR(PAMS__BADUMA            );  	MSTR(PAMS__BADRESPQ          );  	MSTR(PAMS__BADARGLIST        );  	MSTR(PAMS__NO_DQF            );  	MSTR(PAMS__NO_SAF            );  	MSTR(PAMS__RTS_FAILED        );  	MSTR(PAMS__SAF_DEVICE_FAIL   );  	MSTR(PAMS__SAF_FAILED        );  	MSTR(PAMS__BADLOGIC          );  	MSTR(PAMS__SELRCVACT         );  	MSTR(PAMS__NOMRQRESRC        );  	MSTR(PAMS__BADASSIGN         );  	MSTR(PAMS__LOGNAME           );  	MSTR(PAMS__LOGNAME2          );  	MSTR(PAMS__LOGNAME3          );  	M                                                                                                                                                                                                                                                                           Gp $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES.MRS]VALID.C;1                                                                                                f    D                         D      5       STR(PAMS__LOGNAME4          );  	MSTR(PAMS__LOGNAME5          );  	MSTR(PAMS__NOOPEN            );  	MSTR(PAMS__BADSCRIPT         );  	MSTR(PAMS__DECLARED          );  	MSTR(PAMS__EXHAUSTBLKS       );  	MSTR(PAMS__INTERNAL          );  	MSTR(PAMS__QUECORRUPT        );  	MSTR(PAMS__REMQUEFAIL        );  	MSTR(PAMS__INSQUEFAIL        );  	MSTR(PAMS__CREATEFAIL        );  	MSTR(PAMS__DCLTMPFAIL        );  	MSTR(PAMS__PAMSDOWN          );  	MSTR(PAMS__BADASTPARM        );  	MSTR(PAMS__NOQUOTA           );  	MSTR(PAMS__NOTPRIMARYQ       );
               	 	default:o4 	   sprintf (symbuf, "PAMS__UNEXPECTED - %x", sym ); 	   mstr = symbuf; 	}                 L 	return ( mstr+6 );t }       0 ROUTINE status_out ( tag, istat, del, uma, psb )
 char *tag; long int istat; 	 char del;\	 char uma;  PAMS_PSB *psb; { 	 	printf (n, 	   "\n%-3s: %-18s, %-6s:%-18s, %-5s:%-18s", 	   tag, 	   get_sym_str ( istat ),9 	   get_del_str ( del   ), get_sym_str (psb->del_status), < 	   get_uma_str ( uma    ),get_sym_str (psb->uma_status ) );   }           a   static do_receiver ()e {n    TEST_DESCRIP curtest;$    TEST_DESCRIP 	*tc     = msg_area;8    unsigned short int	size    = sizeof ( TEST_DESCRIP );5    unsigned short int   bufsiz  = sizeof (msg_area );     unsigned long 	tag     = 1;     char			force_j = PDEL_NO_JRN;      long int 		istat;      PAMS_ADDR		source;t    char			prio;a    short int		class;    short int 	   	type;     long  int		timeout;    PAMS_PSB	 	psb;    unsigned long int	filter;  $ 	sprintf (q_name,"%d",PAMS_VALID_R);%         q_name_len = strlen (q_name);	          q_type = PSYM_ATTACH_PQ;,         attach_mode = PSYM_ATTACH_BY_NUMBER;f         test_status = pams_attach_q (&attach_mode,&mypamsid.all,&q_type,q_name,&q_name_len,0,0,0,0,0);'         if (test_status != SS$_NORMAL )a 	{0 	   printf ("\nPAMS_ATTACH_Q: status = %x, %s", 2 	      test_status, get_sym_str ( test_status ) );            goto OUT; 	}  	if (test_status != SS$_NORMAL ) 	{                  2 	   printf ("\n%s", get_sym_str ( test_status ) );
 	   goto OUT;f 	}    	timeout           = 1800;          filter            = 0;  
 	while (loop)_ 	{
 	   prio = 0;	   	   istat = pams_get_msgw (  	      msg_area,   	      &prio,                                &source, 	      &class,
 	      &type,  	      &bufsiz,E               &size, 	      &timeout, 	      &filter,                &psb 		);   , 	   if ( istat  == PAMS__TIMEOUT           )5 		printf("\n?Timeout occured waiting for message\n");   , 	   if ( istat  != SS$_NORMAL              ) 	   {i<               printf ("\n%s", get_sym_str ( test_status ) );               goto OUT;             }  0 	   if ( ( psb.del_status == PAMS__CONFIRMREQ ) 1 	   ||   ( psb.del_status == PAMS__POSSDUPL   ) )R 	   {t4 	      pams_confirm_msg ( psb.seq, &tag, &force_j );            }   	   switch ( type )  	   {i 	   case MSG_TYPE_TEST_SIGNON:9 	      if ( source.au.process != PAMS_VALID_S ) continue;;& 	      sender_group = source.au.group;  $ 	      send_ack ( tc->test_number );
 	      break;l  "            case MSG_TYPE_TEST_REQ:: 	      if ( source.au.process != PAMS_VALID_S  ) continue;: 	      if ( size   != sizeof ( TEST_DESCRIP )  ) continue;  -               test_number  = tc->test_number;P 	      curtest     = *tc;*  	      send_ack ( test_number );                 break;   	   case MSG_TYPE_TEST_DATA:: 	      if ( source.au.process != PAMS_VALID_S  ) continue;  5               test_status = send_status ( &curtest );e               break;   	   case MSG_TYPE_TEST_SIGNOFF:  	      goto OUT;   	   default: 	      continue;   	   }g 	}  
 	goto OUT;   OUT:         pams_exit ();  }    u  ! long int send_ack ( test_number )  long int test_number;  {       PAMS_ADDR		target;e    PAMS_ADDR		resp;f    char			prio;p    short int		class;    short int 	   	type;L    char		   	delivery;    unsigned short int	size;     long  int		timeout;    PAMS_PSB	 	psb;    char			uma;      long int istat;      TEST_DESCRIP *tc;    	tc = msg_area;! 	tc->test_number   = test_number;         -" 	target.au.group   = sender_group;" 	target.au.process = PAMS_VALID_S;2         size              = sizeof (TEST_DESCRIP); 	prio              = 0; 2         class             = MSG_CLAS_TEST_CONTROL;.         type              = MSG_TYPE_TEST_ACK;-         delivery          = PDEL_MODE_WF_MEM;   	timeout           = 600;  # 	uma               = PDEL_UMA_DISC; C         resp.all          = reqpamsid.all;      /* full id fails */	   	istat = pams_put_msg (u 			tc, M
 			&prio,  			&target,      			&class, h        			&type,   			&delivery, 	 			&size,;
 			&timeout,   			&psb,	 			&uma,	  	       		&resp );   	return ( istat ); }_   L   #if 0	< ????????????????????????????????????????????????????????????< modify this to send back the entire PSB so it can be checked by the sender...< ???????????????????????????????????????????????????????????? #endif   long int send_status ( tc )T TEST_DESCRIP *tc;  {       PAMS_ADDR		target;E    PAMS_ADDR		resp;     char			prio;D    short int		class;    short int 	   	type;     char		   	delivery;    unsigned short int	size;     long  int		timeout;    PAMS_PSB	 	psb;    char			uma;      long int istat;             " 	target.au.group   = sender_group;" 	target.au.process = PAMS_VALID_S;2         size              = sizeof (TEST_DESCRIP); 	prio              = 0;s2         class             = MSG_CLAS_TEST_CONTROL;1         type              = MSG_TYPE_TEST_STATUS; -         delivery          = PDEL_MODE_WF_MEM;e  	timeout           = 600;  # 	uma               = PDEL_UMA_DISC; C         resp.all          = reqpamsid.all;      /* full id fails */    	istat = pams_put_msg (  			tc, E
 			&prio,  			&target,      			&class,          			&type, W 			&delivery, 	 			&size,A
 			&timeout,   			&psb,	 			&uma,	  	       		&resp );   	return ( istat ); }A  F);t 	MSTR (PDEL_MODE_NN_SAF);	 	MSTR (PDEL_MODE_DG    );l 	MSTR (PDEL_MODE_DG_LOG);n 	MSTR (PDEL_MODE_RTS   );e 	MSTR (PDEL_MODE_WFQ   );  	default:     :               ! * [DMQ$V20.EXAMPLES]PAMPRTERR.PLI;1 +  , B   .     /     4 O                           - B    0   1    2   3      K  P   W   O 	    5   6 7  7 *q  8          9 Z  G    H  J              N /*****************************************************************************  *									     * 3  *  Copyright (c) 1991                   				     * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/   O /****************************************************************************** 6 * Module:    PAMS_PRT_ERR (PROCESS, TEXT, STATUS_CODE) *  * Filename:  PAMPRTERR.PLI * , * Function:  Print an Error Message and Exit * 	 * Inputs: , *            PROCESS	  - Name of the process/ *            TEXT	  - Text of the error message > *            STATUS CODE  - Status code to translate and print * 
 * Outputs: *  * External Subroutines:  * 	PAMS_PRT_MSG 
 *	SYS$EXIT *  * Language:  PLI * O ******************************************************************************/   
 PAMS_PRT_ERR: % 	PROCEDURE (PROCESS,TEXT,STATUS_CODE) ! 	OPTIONS (IDENT('Example V1.0'));    %INCLUDE $STSDEF;  %INCLUDE SYS$EXIT;   DCL PROCESS		CHAR(*),      TEXT		CHAR(*),     STAT		FIXED BIN(31),     STATUS_CODE		FIXED BIN(31);   , DCL PAMS_PRT_MSG   EXTERNAL ENTRY ( CHAR(*), 				    CHAR(*),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |s; $      DMQ020.B                       B  B  ![DMQ$V20.EXAMPLES]PAMPRTERR.PLI;1                                                                                              O                                            				    FIXED BIN (31));      1   CALL PAMS_PRT_MSG (PROCESS, TEXT, STATUS_CODE);    CALL SYS$EXIT (STATUS_CODE);     STOP;            END PAMS_PRT_ERR;                                                                                                                                                                                                                                                                                                                                                                               ! * [DMQ$V20.EXAMPLES]PAMPRTMSG.PLI;1 +  , B   .     /     4 O       .                    - B    0   1    2   3      K  P   W   O     5   6 "7  7 `8q  8          9 Z  G    H  J              N /*****************************************************************************  *									     * 3  *  Copyright (c) 1991                   				     * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/   O /****************************************************************************** 6 * Module:    PAMS_PRT_MSG (PROCESS, TEXT, STATUS_CODE) *  * Filename:  PAMPRTMSG.PLI * . * Function:  Print an Error Message and Return * 	 * Inputs: , *            PROCESS	  - Name of the process/ *            TEXT	  - Text of the error message > *            STATUS CODE  - Status code to translate and print * 
 * Outputs: *  * External Subroutines: 
 *	SYS$EXIT *	SYS$BRKTHRUW *	SYS$GETMSG *  * Language:  PLI * O ******************************************************************************/   3 PAMS_PRT_MSG:  PROCEDURE (PROCESS,TEXT,STATUS_CODE) + 	       OPTIONS   (IDENT('Example V1.00'));    DCL PROCESS		CHAR(*);  DCL TEXT		CHAR(*); DCL STATUS_CODE		FIXED BIN(31);    %INCLUDE $SSDEF; %INCLUDE $STSDEF;  %INCLUDE SYS$EXIT; %INCLUDE SYS$GETMSG;   %REPLACE BRK$C_DEVICE	BY 1;  %REPLACE SUCCESS 	BY 1;  %REPLACE INFORMATIONAL 	BY 3;  %REPLACE WARNING 	BY 0;  %REPLACE ERROR 		BY 2; %REPLACE FATAL 		BY 4; %PAGE;D DCL PAMS_PRT_STS   EXTERNAL ENTRY (CHAR(*), CHAR(*), FIXED BIN(31));  ! DCL SYS$BRKTHRUW EXTERNAL ENTRY (  			FIXED BIN(31) VALUE,  			CHAR(*),  			CHAR(*),  			FIXED BIN(31) VALUE,  			ANY,  			FIXED BIN(31) VALUE,  			FIXED BIN(31) VALUE,  			FIXED BIN(31) VALUE,  			FIXED BIN(31) VALUE,  			ANY,  			FIXED BIN(31) VALUE) $                   OPTIONS (VARIABLE) 		  RETURNS(FIXED BIN(31));   . DCL PAMS_MY_BUS_GROUP                CHAR(10);  1 DCL 1 PAMS_MY_BG		BASED(ADDR(PAMS_MY_BUS_GROUP)), %     2 PAMS_MY_BUS_ID		       CHAR(4), /     2 PAMS_MY_BG_FILLER	               CHAR(1), %     2 PAMS_MY_GRP_ID		       CHAR(5);     DCL  1 IO$STATUS_BLOCK, 5        2 IO$STATUS                     FIXED BIN(15), 5        2 IO$COUNT                      FIXED BIN(15), 5        2 IO$DEVDEPEND                  FIXED BIN(31), D      1 IO$FIELDS                     BASED (ADDR (IO$STATUS_BLOCK)),.        2 IO$SUCCESS                    BIT(1),/        2 IO$EXTRA                      BIT(31);    DCL STAT		FIXED BIN(31); DCL STS_SEVERITY	FIXED BIN(31);  DCL MSG_LENGTH		FIXED BIN(15); DCL LNM_STRING		CHAR(256); DCL LNM_TBL		CHAR(256);   DCL MSG_TEXT1        	CHAR(256);  DCL MSG_TEXT2        	CHAR(256); DCL SEV_LVL         	CHAR(3); & DCL ERROR_DEV       	CHAR(50) VARYING;& DCL PAM_PRE         	CHAR(16) VARYING; DCL CARCON		FIXED BIN(31);: DCL CARCON_BYTE	    (4) FIXED BIN(7) BASED (ADDR(CARCON));  < DCL STAT_WORD	    (2) FIXED BIN(15) BASED (ADDR(STAT));	       DCL I			FIXED BIN(31); DCL WORK_VAR		FIXED BIN(7);    %PAGE;  7 STS$VALUE = GET_LNM('DMQ$ERROUT', LNM_STRING, LNM_TBL);   IF (STS$VALUE = SS$_NORMAL) THEN     ERROR_DEV = TRIM(LNM_STRING); ELSE    ERROR_DEV = 'OPA0:';   A STS$VALUE = GET_LNM('DMQ$BUS_GROUP', PAMS_MY_BUS_GROUP, LNM_TBL);  IF ^STS$SUCCESS  THEN $    PAMS_MY_BUS_GROUP = '**********';   STAT         = STATUS_CODE;  STAT_WORD(2) = 0;   STS_SEVERITY = MOD(ABS(STAT),8);# IF      STS_SEVERITY = SUCCESS THEN     SEV_LVL = '-I-'; ) ELSE IF STS_SEVERITY = INFORMATIONAL THEN     SEV_LVL = '-I-'; # ELSE IF STS_SEVERITY = WARNING THEN     SEV_LVL = '-W-'; ! ELSE IF STS_SEVERITY = ERROR THEN     SEV_LVL = '-E-'; ! ELSE IF STS_SEVERITY = FATAL THEN     SEV_LVL = '-F-';  ELSE      SEV_LVL = '-I-';    CARCON = 0; 1 CARCON_BYTE(3) = 1;	/* prefix carridge control */ 2 CARCON_BYTE(4) = 0;	/* postfix carridge control */   IF (PROCESS = ' ') THEN (   PAM_PRE = 'DMQ_' !! PAMS_MY_BUS_GROUP; ELSE/   PAM_PRE = 'DMQ_' !! PAMS_MY_BUS_GROUP !! '-';    MSG_TEXT1 = ' '; MSG_TEXT2 = ' ';   IF (LENGTH(TEXT) > 0) THENG   MSG_TEXT1 = '%' !! PAM_PRE !! TRIM(PROCESS) !! SEV_LVL !! TRIM(TEXT);   - IF (STATUS_CODE < 0) ! (STATUS_CODE > 4) THEN    DO; L     STS$VALUE = SYS$GETMSG ( STATUS_CODE, MSG_LENGTH, MSG_TEXT2, '1111'B, );4     MSG_TEXT2 = SUBSTR ( MSG_TEXT2, 1, MSG_LENGTH );   END;  D IF (MSG_TEXT1 = ' ') & (MSG_TEXT2 = ' ') THEN	/* nothing to print */	   RETURN;   K CALL PAMS_PRT_STS(PROCESS, TEXT, STATUS_CODE);	/* print it on SYS$OUTPUT */   6 IF (ERROR_DEV ^= 'OFF') & (ERROR_DEV ^= 'NLA0:')  THEN-   DO;			/* user has enabled console writes */        STS$VALUE = SS$_NORMAL;        IF (LENGTH(TEXT) > 0) THEN!        STS$VALUE = SYS$BRKTHRUW(   			, 			TRIM(MSG_TEXT1),  			TRIM(ERROR_DEV),  			BRK$C_DEVICE, 			IO$STATUS_BLOCK, 
 			CARCON, 			, 			,% 			10,		/* 10 second write timeout */  			, 			);        IF ^STS$SUCCESS THENM       CALL PAMS_PRT_STS(PROCESS, 'PAMS console broadcast failed', STS$VALUE);   1     IF (STATUS_CODE < 0) ! (STATUS_CODE > 4) THEN 	       DO; "         STS$VALUE = SYS$BRKTHRUW(  			, 			TRIM(MSG_TEXT2),  			TRIM(ERROR_DEV),  			BRK$C_DEVICE, 			IO$STATUS_BLOCK, 
 			CARCON, 			, 			,% 			10,		/* 10 second write timeout */  			, 			);            IF ^STS$SUCCESS THENO         CALL PAMS_PRT_STS(PROCESS, 'PAMS console broadcast failed', STS$VALUE); 
       END;   END;   RETURN;    %PAGE;  / GET_LNM:   PROCEDURE (LNM, LNM_STRING, LNM_TBL) &            RETURNS   (FIXED BIN (31));     DCL LNM		CHAR(*);  DCL LNM_STRING  CHAR(*); DCL LNM_TBL     CHAR(*);   %INCLUDE $SSDEF; %INCLUDE $STSDEF;  %INCLUDE $LNMDEF;  %INCLUDE SYS$TRNLNM;    . DCL 1 TRNLNM_ITMLST         (3),              .     2 TRNLNM_BUFFLEN            FIXED BIN(15),.     2 TRNLNM_ITEMCODE           FIXED BIN(15),.     2 TRNLNM_BUFFADDR           POINTER,      .     2 TRNLNM_BUFFLENADDR        POINTER;      .                                               . DCL TRNLNM_STRING_LEN           FIXED BIN(15);. DCL TRNLNM_TBL_LEN              FIXED BIN(15);    2     TRNLNM_BUFFLEN     (1) = SIZE(LNM_STRING);    5     TRNLNM_ITEMCODE    (1) = LNM$_STRING;             2     TRNLNM_BUFFADDR    (1) = ADDR(LNM_STRING);    5     TRNLNM_BUFFLENADDR (1) = ADDR(TRNLNM_STRING_LEN);   2     TRNLNM_BUFFLEN     (2) = SIZE(LNM_TBL);       5     TRNLNM_ITEMCODE    (2) = LNM$_TABLE;              2     TRNLNM_BUFFADDR    (2) = ADDR(LNM_TBL);       5     TRNLNM_BUFFLENADDR (2) = ADDR(TRNLNM_TBL_LEN);      5     TRNLNM_BUFFLEN     (3) = 0;                       5     TRNLNM_ITEMCODE    (3) = 0;                         !     LNM_STRING             = ' '; !     LNM_TBL                = ' ';   D     STS$VALUE = SYS$TRNLNM( , 'LNM$FILE_DEV', LNM, , TRNLNM_ITMLST);7     IF ^STS$SUCCESS & (STS$VALUE ^= SS$_NOLOGNAM) THEN  
        DO;=          LNM_STRING = SUBSTR(LNM_STRING,1,TRNLNM_STRING_LEN); =          LNM_TBL    = SUBSTR(LNM_TBL,   1,TRNLNM_TBL_LEN);            END;          RETURN(STS$V                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           $      DMQ020.B                       B  B  ![DMQ$V20.EXAMPLES]PAMPRTMSG.PLI;1                                                                                              O                              `             ALUE);   END GET_LNM;     END PAMS_PRT_MSG;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * [DMQ$V20.EXAMPLES]PAMPRTSTS.C;1 +  , B   .     /     4 O       0                   - B    0   1    2   3      K  P   W   O     5   6   7 GCq  8          9 Z  G    H  J                N /*****************************************************************************  *									     * 3  *  Copyright (c) 1992                   				     * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/     O /****************************************************************************** 6 * Module:    pams_prt_sts (process, text, status_code) *  * Filename:  pamprtsts.c * . * Function:  Print an Error Message and Return * 	 * Inputs: 4 *            process	  - Name of the process	        *				char array by descriptor  * 1 *            text	  - Text of the error message   8 *                               char array by descriptor * > *            status_code  - Status code to translate and print *				longword by reference * 
 * Outputs: *  * External Subroutines: 
 *	SYS$GETMSG   *	SYS$TRNLNM *  * Language:  C * O ******************************************************************************/   & #module pams_prt_sts "Example V2.0-00"   #include <ssdef.h> #include <stdio.h> #include <descrip.h> #include <lnmdef.h>    #define ROUTINE int    #define TEXT_FLAG     1  #define ID_FLAG       2  #define SEVERITY_FLAG 4  #define FACILITY_FLAG 8 H #define ALL_FLAGS (TEXT_FLAG | ID_FLAG | SEVERITY_FLAG | FACILITY_FLAG )   #define WARNING		0 #define SUCCESS		1 #define ERROR		2 #define INFORMATIONAL	3  #define	FATAL		4   typedef struct   { ?    char	 pams_my_vms_uic [ 3 ];  	/* uic code... ascii text **/     short pams_my_group_number;=    char  pams_my_pid [ 8 ];   		/* vms pid...  ascii text **/     long  pams_my_pid_num; H    char  pams_my_process_name[31];      /* DMQ PQ name... ascii text **/I    char  pams_my_bus_group [ 10 ];      /* bus & grp ID... ascii text **/     } USER_REFERENCE_AREA_STRUCT;   : globalref USER_REFERENCE_AREA_STRUCT  user_reference_area;  ' globaldef long pams_prt_sts_called = 0; ' globaldef long pams_disable_sysout = 0;   + pams_prt_sts ( process, text, status_code )   ! struct dsc$descriptor_s *process;  struct dsc$descriptor_s *text;   long *status_code; { = 	$DESCRIPTOR ( pams_disable_sysout_d, "DMQ$DISABLE_SYSOUT" );   ' 	struct dsc$descriptor trimmed_process; $ 	struct dsc$descriptor trimmed_text;# 	struct dsc$descriptor outbuf_desc;    	char outbuf[150]; 	short int ilen;         long istat;            long severity;         char *sevptr;      	if ( ! pams_prt_sts_called ) 	         { <            pams_disable_sysout = get_pams_disable_sysout (); 	   pams_prt_sts_called = 1;	         }   2 	if ( pams_disable_sysout ) return ( SS$_NORMAL );   	strcpy  ( 	outbuf,  	 		"%DMQ_" );   	strncat ( 	outbuf, * 			user_reference_area.pams_my_bus_group, 5 			sizeof( user_reference_area.pams_my_bus_group ) );   / 	trim_string ( process, &trimmed_process, 20 );   .         if ( trimmed_process.dsc$w_length > 0) 	{   	   strcat (	outbuf,	 			"-" );    	   strncat (	outbuf, " 			trimmed_process.dsc$a_pointer, " 			trimmed_process.dsc$w_length ); 	}  & 	severity = *status_code & 0x00000007;   	switch (severity) 	{ 	case WARNING: 	   sevptr = "-W-"; 
 	   break;   	case ERROR: 	   sevptr = "-E-"; 
 	   break;   	case FATAL: 	   sevptr = "-F-"; 
 	   break;   	case INFORMATIONAL: 	   sevptr = "-I-"; 
 	   break;   	case SUCCESS: 	   sevptr = "-I-"; 
 	   break;  	 	default:  	   sevptr = "-I-"; 
 	   break; 	}   	strcat (	outbuf,  			sevptr );  + 	trim_string  ( text, &trimmed_text, 100 );    	strncat (	outbuf, 			trimmed_text.dsc$a_pointer, 			trimmed_text.dsc$w_length );      +         if ( trimmed_text.dsc$w_length > 0)  	    printf ( "\n%s", outbuf );   > 	if ( ( *status_code < WARNING ) || ( *status_code > FATAL ) ) 	{  2            /**************************************) 	    * Now decode the vms condition code  3             **************************************/ ' 	   outbuf_desc.dsc$a_pointer = outbuf; <            outbuf_desc.dsc$w_length  = sizeof (outbuf ) - 1;, 	   outbuf_desc.dsc$b_dtype = DSC$K_DTYPE_T;, 	   outbuf_desc.dsc$b_class = DSC$K_CLASS_S;   	   istat =  sys$getmsg ( 9 	      *status_code, &ilen, &outbuf_desc, ALL_FLAGS, 0 );   @            outbuf [ ilen ] = 0;	/* null terminate the string **/   	   printf ("\n%s", outbuf );   	         }  	else  	{ 	   istat = SS$_NORMAL;  	}   	fflush ( stdout );    	return (istat); }       . static trim_string ( indesc, outdesc, maxlen )  struct dsc$descriptor_s *indesc;! struct dsc$descriptor_s *outdesc; 
 short maxlen;  { A 	/**************************************************************  ) 	 * Routine to blank trim left and right.  	 * Input:  4 	 * 	indesc: 	descriptor of the string to be trimmed1 	 *	maxlen:		maximum length of the trimmed string  	 *  	 * Output: - 	 *	outdesc:	descriptor of the trimmed string B 	 ***************************************************************/   	int i; 
 	int ilen;   	char *cptr;   	ilen = indesc->dsc$w_length; " 	if (ilen > maxlen) ilen = maxlen;  & 	outdesc->dsc$b_dtype = DSC$K_DTYPE_T;& 	outdesc->dsc$b_class = DSC$K_CLASS_S;   	cptr = indesc->dsc$a_pointer;   	for (i=0; i<ilen; i++)  	{ 	   if ( *cptr != ' ') break;  	   cptr++;  	}   	outdesc->dsc$a_pointer = cptr;   ) 	cptr = indesc->dsc$a_pointer + ilen - 1;    	for (i=0; i<ilen; i++)  	{ 	   if (*cptr != ' ')  break;  	   cptr--;  	}  & 	ilen = cptr - outdesc->dsc$a_pointer;" 	outdesc->dsc$w_length = ilen + 1;   }        typedef struct   {     short buf_len;     short code;    char *buf_addr;    long *retlen_addr;  } ITEM_LIST;  @ static $DESCRIPTOR ( ptbl_d,                "LNM$FILE_DEV"    );C static $DESCRIPTOR ( pams_disable_sysout_d, "DMQ$DISABLE_SYSOUT" );   & static long get_pams_disable_sysout () { 3    char lnamebuf [ 256 ];	/* Lottsa buffer space */     short lnamebuf_len = 0;    long istat;	    int i;   ;    /******************************************************/ ;    /*  Build an itemlist for the &%#$! $TRNLNM interface */ ;    /******************************************************/     ITEM_LIST lnmlist[2] =     {  D       { sizeof(lnamebuf)-1, LNM$_STRING, lnamebuf, &lnamebuf_len }, C       {                  0,           0,        0,             0 },       };   F 	istat = sys$trnlnm( 0, &ptbl_d, &pams_disable_sysout_d, 0, lnmlist );   	switch ( istat )  	{ 	case(SS$_NORMAL):' 	   /*********************************/ ' 	   /* Null terminate and upper case */ ' 	   /*********************************/ # 	   lnamebuf[ lnamebuf_len ] = 0;		   # 	   for (i=0; i<lnamebuf_len; i++ ) - 	      lnamebuf[i] = toupper ( lnamebuf[i] );   4 	   if ( !strcmp ( lnamebuf, "Y"   ) ) return ( 1 );4 	   if ( !strcmp ( lnamebuf, "YES" ) ) return ( 1 );              return ( 0 );   	case(SS$_NOLOGNAM): 	case(SS$_BUFFEROV                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          p $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]PAMPRTSTS.C;1                                                                                                O                             .             F):  	default :   	   return ( 0 );    	} }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             ! * [DMQ$V20.EXAMPLES]PAMSAMPLE.FOR;1 +  , B   .     /     4 G       r                   - B    0   1    2   3      K  P   W   O 
    5   6 `kd  7 `Qq  8          9 Z  G    H  J               	  	PROGRAM PAMSAMPLE   	INCLUDE '($SSDEF)'   C 	INCLUDE 'dmq$user:dmq(PAMS_FOR_GROUP)'		!* Target/Source Group num G 	INCLUDE 'dmq$user:dmq(PAMS_FOR_PROCESS)'		!* Target/Source Process num . 	INCLUDE 'dmq$user:dmq(PAMS_FOR_TYPE_CLASS)'		- 	INCLUDE 'dmq$user:dmq(PAMS_FOR_ENTRY_POINT)' / 	INCLUDE 'dmq$user:dmq(PAMS_FOR_RETURN_STATUS)' , 	INCLUDE 'dmq$user:dmq(PAMS_FOR_SYMBOL_DEF)'   	INTEGER*2 SUB  B 	INTEGER*2 PRIORITY, CLASS, TYPE, MSG_AREA_LEN, LEN_DATA, MSG_SIZE 	INTEGER*2 JOURNAL7 	INTEGER*4 SOURCE, STATUS, TARGET, TIMEOUT, EXIT_STATUS $ 	INTEGER*4 SYS$EXIT, DCLED_Q_ADDRESS1         INTEGER*4 ATTACH_MODE, Q_TYPE, Q_NAME_LEN    	BYTE MSG_AREA(80),Q_NAME(32)  	CHARACTER*80 INQUIRY_AREA% 	EQUIVALENCE (MSG_AREA, INQUIRY_AREA)    	CHARACTER OPTION   
 	TIMEOUT	= 50  	MSG_AREA_LEN = 80 	PRIORITY     = 0  	EXIT_STATUS  = 1   +         ATTACH_MODE = PSYM_ATTACH_TEMPORARY          Q_TYPE = PSYM_ATTACH_PQ C         STATUS = PAMS_ATTACH_Q (ATTACH_MODE,DCLED_Q_ADDRESS,Q_TYPE, .      1                          0,0,0,0,0,0,0)  0 	IF (.NOT. STATUS) CALL LIB$SIGNAL(%VAL(STATUS))   100	CONTINUE   	TYPE *,' ' ! 	TYPE *,' 			(G)  PAMS_GET_MSG  ' " 	TYPE *,' 			(W)  PAMS_GET_MSGW  '! 	TYPE *,' 			(P)  PAMS_PUT_MSG  '  	TYPE *,' 			(E)  EXIT ' 	TYPE *,' '   + 	WRITE(*,FMT=('(A)'))  '$ 	ENTER OPTION:  '  	READ (*,FMT=('(A)'))  OPTION    	IF (OPTION .EQ. 'G') GOTO 2000  	IF (OPTION .EQ. 'W') GOTO 3000  	IF (OPTION .EQ. 'P') GOTO 4000  	IF (OPTION .EQ. 'E') GOTO 9999   0 	TYPE *,' * INVALID OPTION ENTERED - TRY AGAIN '	 	GOTO 100   
 2000	CONTINUE A 	STATUS = PAMS_GET_MSG (MSG_AREA, PRIORITY, SOURCE, CLASS, TYPE,  / 	1                      MSG_AREA_LEN, LEN_DATA)   
 	GOTO 3500  
 3000	CONTINUE B 	STATUS = PAMS_GET_MSGW (MSG_AREA, PRIORITY, SOURCE, CLASS, TYPE, 9 	1                       MSG_AREA_LEN, LEN_DATA, TIMEOUT)     
 3500	CONTINUE + 	IF (STATUS .EQ. %LOC(PAMS__TIMEOUT))  THEN & 	    TYPE *,' TIMEOUT PERIOD EXPIRED '
 	    GOTO 100 
 	    ENDIF   	IF (.NOT. STATUS) THEN " 	    CALL LIB$SIGNAL(%VAL(STATUS))
 	    GOTO 100 
 	    ENDIF  ( 	IF (STATUS .EQ. %LOC(PAMS__NOMOREMSG))  	1    TYPE *,' NO MORE MSGS '   ! 	IF (STATUS .EQ. SS$_NORMAL) THEN  	    TYPE *,' ' 4 	    TYPE *,' PAMS_GET_MSG OR PAMS_GET_MSGW CALL OK' 	    TYPE *,' SOURCE =',SOURCE 	    TYPE *,' CLASS  =',CLASS  	    TYPE *,' TYPE   =',TYPE" 	    TYPE *,' LEN_DATA =',LEN_DATA 	    TYPE *,' STATUS =',STATUS   	    DO SUB = 1, LEN_DATA , 	      TYPE *,' MSG_AREA(*) =',MSG_AREA(SUB)
 	    ENDDO 	ENDIF	 	GOTO 100     
 4000	CONTINUE   " 	TYPE *,'ENTER THE MSG TO BE SENT'% 	READ (*,4100) MSG_SIZE, INQUIRY_AREA  4100	FORMAT(Q, A)  	DO SUB = 1, LEN_DATA * 	    TYPE *,' MSG_AREA(*) =',MSG_AREA(SUB) 	ENDDO$ 	TYPE *,' THE MSG SIZE IS ',MSG_SIZE   	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_PALLET_REQ  	TARGET = DCLED_Q_ADDRESS   A 	STATUS = PAMS_PUT_MSG (MSG_AREA, PRIORITY, TARGET, CLASS, TYPE,  = 	1                                         JOURNAL, MSG_SIZE)    	IF (STATUS) THEN # 	    TYPE *,' PAMS_PUT_MSG CALL OK'  	 ELSE" 	    CALL LIB$SIGNAL(%VAL(STATUS)) 	 ENDIF   	 	GOTO 100     
 9999	CONTINUE ' 	STATUS = SYS$EXIT( %VAL(EXIT_STATUS) )  	END                                                                                                                                                                                                                                                                                                                                                                                                                          ! * [DMQ$V20.EXAMPLES]PAMSAMPLE_C.C;1 +  , B   .      /     4 O                          - B    0   1    2   3      K  P   W   O !    5   6 `
   7 `8]q  8          9 Z  G    H  J               #module pams_sample_c "V2.0-00"   N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1992                                                       *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/                         O /******************************************************************************  * Module:    PAMS_TEST *  * Filename:  PAMSAMPLE_C.C * 7 * Function:     This program is used to test PAMS code.  * 	 * Inputs:  *	None * 
 * Outputs: *	None *  * External Subroutines:  *	pams_cancel_timer  *	pams_attach_q  *	pams_get_msg *	pams_get_msgw  *	pams_put_msg *	pams_set_timer * 
 * Language: C  * 7 * compile: $ cc/list/obj/include=dmq$user pamsample_c.c - * link:    $ link pamsample_c,dmq$lib:dmq/opt  *  *  * O ******************************************************************************/   6 typedef unsigned char BOOLEAN;		/* boolean variable */# #define FALSE                     0 # #define TRUE                      1 # #define MIN_CONNECT_SIZE          9    #include <stdio.h> #include <ssdef.h> #include <stsdef.h>  #include <descrip.h>   /* portable includes */  #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "p_entry.h" #include "p_group.h"    
 typedef union    {     long int      all; 	    struct       {       short int  process;        short int  group; 
      } au;   } PAMS_ADDRESS;        static BOOLEAN		flush_flag;  static PAMS_ADDRESS	target;  static PAMS_ADDRESS	source;  static long int		sts$value;  static long int		time_out; static long int		proc_num_in; ! static PAMS_ADDRESS	proc_num_out;  static long int		line_num; static short int	size, i; 2 static short int	class, type, rcv_class, rcv_type;% static short int	msg_size, input_num; $ static char		option[81], buffer[81]; static char		*msg_buffer, c; static char		delivery;( static short int	priority, rcv_priority; static long int		put_timeout;  struct PSB		psb; static char		uma;  static long int		resp_que; static long int		sel_addr; static BOOLEAN		first_time; + static long int		pvar, dcl_num, target_num; * static long int		timer_id, timer_duration; static char		p_format;? static long int         attach_mode, q_type, q_name_len, istat; $ static char             q_name [31];   void			print_menu( );  void			get_str( ); void 			print_rcvd( ); void			test_put( );  void			test_get( );  void			test_getw( ); void			change_settings( ); void			test_set_timer( );  void			test_cancel_timer( ); void			print_sts( );   pams_test ()   {   0   printf("\n\n\t*** PAMS_TEST beginning ***\n");     sts$value  = 0;    proc_num_in                                                                                                                                                                                                                                             )G $      DMQ020.B                       B  B  ![DMQ$V20.EXAMPLES]PAMSAMPLE_C.C;1COB;1                                                                                         O                              ҃ "     	       = 0;,   printf("\nEnter my queue number (D:0): ");   istat = gets(buffer);    if (strlen (buffer) == 0)    { (     attach_mode = PSYM_ATTACH_TEMPORARY;   }    else   { (     attach_mode = PSYM_ATTACH_BY_NUMBER;     strcpy (q_name,buffer); !     q_name_len = strlen (q_name);    }    q_type = PSYM_ATTACH_PQ;  K   sts$value = pams_attach_q (&attach_mode,&proc_num_out.all,&q_type,q_name, 4                              &q_name_len,0,0,0,0,0);'   if (!$VMS_STATUS_SUCCESS(sts$value))     { <      print_sts("PAMTEST", "Error returned by PAMS_ATTACH_Q", 					 sts$value);       exit(sts$value);     }  A   printf("\nMy Queue Address is %d.%d\n", proc_num_out.au.group,  D                                            proc_num_out.au.process);    %   target.all      = proc_num_out.all;    source.all      = 0;   time_out        = 50; $   class           = 1;                 type            = -123; %   delivery        = PDEL_MODE_NN_MEM;    priority        = 0;   rcv_priority    = 0;   put_timeout	  = 0;   uma		  = PDEL_UMA_DISC;    resp_que	  = 0;    sel_addr	  = 0;    option[0]       = 'C';   first_time      = FALSE;   timer_duration  = 50;    p_format        = 'P';   pvar            = 0;   flush_flag      = FALSE;     for(;option[0] != 'E';)      {       switch (option[0])         {         case 'P':  		test_put( ); 		break;         case 'G':  		test_get( ); 		break;         case 'W':  		test_getw( );  		break;         case 'C':  		change_settings(flush_flag); 		flush_flag = TRUE; 		break;         case 'S':  		test_set_timer( ); 		break;         case 'A':  		test_cancel_timer( );  		break;         case 'H':  		print_menu();  		break;         case 'E':   		printf("End of PAMS_TEST.\n"); 		break;	 	default: % 		printf("** Invalid response **\n");  		break;#        }  /*** end of "switch" ***/         if (first_time)        {         print_menu();  	first_time = FALSE;        }        option[0] = ' '; F      printf("\n(P)UT     (G)ET   GET(W)  C(A)N-TIMER  (S)ET-TIMER\n");,      printf(  "(C)HANGE  (H)ELP  (E)XIT\n");      printf("Enter option: ");      scanf("%s", &option);      if (option[0] == EOF)            option[0] = 'E'; $      option[0] = toupper(option[0]);  "     }  /*** end of "for loop" ***/      exit(1);  }   A /****************************************************************  *	Module: test_put					*
 *								*A ****************************************************************/    static void test_put( )  {    printf("\n"); 4   printf("(Terminate msg data input with a '.')\n");   printf("Enter msg data: ");    scanf("%[^.]", &buffer);  <   while ((c = getchar()) != '\n');  /* flush input buffer */     printf("\n");    msg_size = strlen(buffer)-1;  >   sts$value = pams_put_msg(&buffer[1], &priority, &target.all,) 			  &class, &type, &delivery, &msg_size, 1 			  &put_timeout, &psb, &uma, &resp_que,0,0,0);  '   if (!$VMS_STATUS_SUCCESS(sts$value))       { ;      print_sts("PAMTEST", "Error returned by PAMS_PUT_MSG",  					 sts$value);       return;     }	 } /*** end test_put ***/  A /****************************************************************  *	Module: test_get					*
 *								*A ****************************************************************/    static void test_get( )  { ?   sts$value = pams_get_msg(&buffer, &rcv_priority, &source.all, ( 			   &rcv_class, &rcv_type, &80, &size," 			   &sel_addr, &psb,0,0,0,0,0); #   if (sts$value == PAMS__NOMOREMSG) )      print_sts("PAMTEST", "", sts$value); ,   else if (!$VMS_STATUS_SUCCESS(sts$value))      { ;      print_sts("PAMTEST", "Error returned by PAMS_GET_MSG",  					 sts$value);       return;     }    else5      print_rcvd (source.au.group, source.au.process,  + 		      rcv_class, rcv_type, size, buffer); 	   return;  }/** end of test_get ***/     A /****************************************************************  *	Module: test_getw					* 
 *								*A ****************************************************************/    static void test_getw( ) { @   sts$value = pams_get_msgw(&buffer, &rcv_priority, &source.all,4 			    &rcv_class, &rcv_type, &80, &size, &time_out,# 			    &sel_addr, &psb,0,0,0,0,0);  !   if (sts$value == PAMS__TIMEOUT) )      print_sts("PAMTEST", "", sts$value); ,   else if (!$VMS_STATUS_SUCCESS(sts$value))      { <      print_sts("PAMTEST", "Error returned by PAMS_GET_MSGW", 				 sts$value);      return;     }    else5      print_rcvd (source.au.group, source.au.process,  + 		      rcv_class, rcv_type, size, buffer);   	   return;  } /*** end of test_getw ***/  A /****************************************************************  *	Module: change_settings					* 
 *								*A ****************************************************************/   " static void change_settings(flush)   BOOLEAN		flush;  {    if (flush)?      while ((c = getchar()) != '\n');  /* flush input buffer */   ,   printf("\n\tChange call parameters.\n\n");;   printf("  To maintain default settings enter <CR>.\n\n");   3   printf("Target group (D:%d): ", target.au.group);    get_str(buffer);   if (buffer[0] != '\0'))     target.au.group = asc2bin(buffer,20);   7   printf("Target process (D:%d): ", target.au.process);    get_str(buffer);   if (buffer[0] != '\0')+     target.au.process = asc2bin(buffer,20);   '   printf("Send class (D:%d): ", class);    get_str(buffer);   if (buffer[0] != '\0')     class = asc2bin(buffer,20);   %   printf("Send type (D:%d): ", type);    get_str(buffer);   if (buffer[0] != '\0')      type = asc2bin(buffer,20);   -   printf("Send delivery (D:%d): ", delivery);    get_str(buffer);   if (buffer[0] != '\0')#      delivery = asc2bin(buffer,20);   -   printf("Send priority (D:%d): ", priority);    get_str(buffer);   if (buffer[0] != '\0')#      priority = asc2bin(buffer,20);   0   printf("Rcv priority (D:%d): ", rcv_priority);   get_str(buffer);   if (buffer[0] != '\0')'      rcv_priority = asc2bin(buffer,20);   +   printf("Rcv timeout (D:%d): ", time_out);    get_str(buffer);   if (buffer[0] != '\0')#      time_out = asc2bin(buffer,20);      printf("\n\n");_D   printf("\t              My PN is %d.%d\n", proc_num_out.au.group, F                                              proc_num_out.au.process);7   printf("\t       SEND                  RECEIVE\n\n"); 5   printf("\tTarget:   %3d.%03d      Priority: %6d\n", 3 	target.au.group, target.au.process, rcv_priority); B   printf("\tClass:    %7d       Timeout: %6d\n", class, time_out);$   printf("\tType:     %7d\n", type);(   printf("\tDelivery: %7d\n", delivery);(   printf("\tPriority: %7d\n", priority);   printf("\n");n  	   return;   " } /*** end of change_settings ***/ *A /****************************************************************n *	Module: test_set_timer 					* 
 *								*A ****************************************************************/N   static void test_set_timer( )  {t<   while ((c = getchar()) != '\n');  /* flush input buffer */     timer_id = 1; .   printf("Enter timer ID (D:%d): ", timer_id);   get_str(buffer);   if (buffer[0] != '\0')"     timer_id = asc2bin(buffer,20);  :   printf("Enter timer duration (D:%d): ", timer_duration);   get_str(buffer);   if (buffer[0] != '\0'))      timer_duration = asc2bin(buffer,20);   J   sts$value = pams_set_timer(&timer_id, &p_format, &timer_duration, NULL);&   if (!$VMS_STATUS_SUCCESS(sts$value))<     print_sts("PAMTEST", "Error returned by PAMS_SET_TIMER", 					 sts$value);l   printf("\n"); 	   return;e   }  /*** end test_set_timer ***/     A /**************************************************************** ! *	Module: test_cancel_timer 				* 
 *								*A ****************************************************************/*    static void test_cancel_timer( ) {*<   while ((c = getchar()) != '\n');  /* flush input buffer */  .   printf("Enter timer ID (D:%d): ", timer_id);   get_str(buffer);       if (buffer[0] != '\0')"     timer_id = asc2bin(buffer,20);  +   sts$value = pams_cancel_timer(&timer_id); &   if (!$VMS_STATUS_SUCCESS(sts$value))?     print_sts("PAMTEST", "Error returned by PAMS_CANCEL_TIMER",p 					 sts$value);t   printf("\n");a	   return; " } /*** end test_cancel_timer ****/ e   static void   print_menu() {n   printf("\n");$E   printf("\n\t (G) - PAMS_GET_MSG          \t(W) - PAMS_GET_MSGW\n");*N   printf(  "\t (P) - PAMS_PUT_MSG          \t(C) - Change call parameters\n");I   printf(  "\t (S) - PAMS_SET_TIMER        \t(A) - PAMS_CANCEL_TIMER\n"); <   printf(  "\t (H) - Help (this screen)    \t(E) - Exit\n");  	   return;  }c    ? static void   print_rcvd (group, proc, class, type, size, buff)a  ) short int	                                                                                                                                                                                                                                                   !                        O $      DMQ020.B                       B  B  ![DMQ$V20.EXAMPLES]PAMSAMPLE_C.C;1B;1                                                                                           O                                           group, proc, class, type, size;c
 char		buff[];h {  short int	sts$value; short int	i; char		*ptr;i     printf("\n");   @   printf("Rcvd msg from %d.%d  Class=%d  Type=%d  Length=%d\n", $ 				group, proc, class, type, size);
   ptr = buff;      if (size > 0)p     {       printf("Rcv data = ");       for (i=0; i < size; i++)g          putchar(*buff++);     }t   putchar('\n');   return;t }c n static void get_str(a)   char	*a; {m
 char    c, b;l
 int	i,j,k;    )   b = 'N';		/* suppress leading blanks */   3   for (i=0; ((c = getchar()) != '\n') && (i < 80);)      {s2      if ((c != ' ') || ((c == ' ') && (b == 'Y')))        {         *(a+(i++)) = c;t5         b = 'Y';  	/* set read embeded blanks flag */f        }     }a     *(a+i) = '\0';  	   return;i }t r static long int asc2bin(a, n)p  	 char		*a;  long int	n;s {  long int	i,j,k;  char		neg_flag;	       neg_flag = 'N';   ,   for (i=0; (*(a+i) == ' ') && (i < n); i++)$      ;			/* remove leading blanks */     if (*(a+i) == '-')     {,      i += 1;      neg_flag = 'Y';     }t  -   for (j=0; (*(a+i) != '\0') && (i < n); i++)_     {t      if (*(a+i) == ' ') 0          break;			/* white space - we're done */*      if ((*(a+i) < '0') || (*(a+i) > '9'))         return (0);	  #      j = (j * 10) + (*(a+i) - '0');o     }a     if (neg_flag == 'Y')      j = -j;  
   return (j);_ }c t1 static void print_sts(process, text, status_code)    char			*process;
 char			*text;  long int		status_code;   {a  struct dsc$descriptor_s pn_text;! struct dsc$descriptor_s msg_text;0    +   pn_text.dsc$w_length   = strlen(process);u)   pn_text.dsc$b_dtype    = DSC$K_DTYPE_T;A)   pn_text.dsc$b_class    = DSC$K_CLASS_S;t#   pn_text.dsc$a_pointer  = process;   (   msg_text.dsc$w_length  = strlen(text);)   msg_text.dsc$b_dtype   = DSC$K_DTYPE_T;T)   msg_text.dsc$b_class   = DSC$K_CLASS_S;t    msg_text.dsc$a_pointer = text;  8   putil_print_status(&pn_text, &msg_text, &status_code);  	   return;$ }_ATUS_SUCCESS(sts$value))     { <      print_s              # * [DMQ$V20.EXAMPLES]PAMSAMPLE_C.LNK;1 +  , B   .     /     4 -       z                   - B    0   1    2   3      K  P   W   O     5 	  6 o`]  7 `miq  8          9 Z  G    H  J                             $ VER = F$VERIFY(1) - $ LINK /EXE PAMSAMPLE_C,PAMS$LIB:PAMS/OPTIONS  $ PUR/LOG PAMSAMPLE_C.EXE  $ VER = F$VERIFY(VER)                                                                                                                                                                                                                                                                                                                                                                                                                    * [DMQ$V20.EXAMPLES]PAMSSLEEP.C;1 +  , B   .     /     4 O                         - B    0   1    2   3      K  P   W   O 	    5   6 <o  7  )wq  8          9 Z  G    H  J                 #module pams_sleep "V2.0-00"  N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1992                                                       *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/     O /****************************************************************************** ! * Module:    PAMS_SLEEP (Seconds)  *  * Filename:  PAMSSLEEP.C * H * Function:     This program is used in place of the C built-in "sleep".@ *	     Go to sleep for that period of time. Do so without using C *	     HIBER/WAKE since PAMS expects exclusive use of those system   *	     services. * 	 * Inputs: % *	seconds	- number of seconds to wait  * 
 * Outputs: *	None *  * External Subroutines: 
 *	LIB$EMUL
 *	LIB$FREE_EF  *	LIB$GET_EF *	SYS$SETIMR *	SYS$WAITFR * 
 * Language: C  * O ******************************************************************************/      #define SS$_NORMAL 1   long int pams_sleep ( seconds )    long int seconds;  { )    long int 	ticks_per_second = 10000000;     long int 	addend = 0;    long int 	qwtime[2];     long int 	istat;     long int 	ef;  )    if (seconds <= 0 ) return ( seconds );       seconds = -seconds;=    lib$emul ( &seconds, &ticks_per_second, &addend, qwtime );       istat = lib$get_ef ( &ef );-    if (istat != SS$_NORMAL) return ( istat );   ,    istat = sys$setimr ( ef, &qwtime, 0, 0 );    if (istat == SS$_NORMAL)     {        istat = sys$waitfr ( ef );       lib$free_ef ( &ef );  1       if (istat != SS$_NORMAL ) return ( istat );        return ( SS$_NORMAL );    }    else     {       lib$free_ef ( &ef );       return ( istat );     }   }                 $ * [DMQ$V20.EXAMPLES]PAMS_EXAMPLE.PLI;1 +  , B   .     /     4 O                          - B    0   1    2   3      K  P   W   O 
    5   6 V  7  ^q  8          9 Z  G    H  J                           N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1992                                                       *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/    %PAGE;  O /******************************************************************************  * Module:    PAMS_EXAMPLE  *  * Filename:  PAMS_EXAMPLE.PLI  * G * Function:     This program is used to illustrate a method of writting  *	     a PAMS program. * 	 * Inputs:  *	none * 
 * Outputs: *	none *  * External Subroutines:  *       PAMS_ATTACH_Q  *       PAMS_GET_MSG(W)  *       PAMS_PUT_MSG *       PAMS_EXIT  *  * Language                                                                                                                                                                                                                                                                                                                                                                                                                                  "                        ( $      DMQ020.B                       B  B  $[DMQ$V20.EXAMPLES]PAMS_EXAMPLE.PLI;1                                                                                           O                             ,             : PLI  * O ******************************************************************************/   / PAMS_EXAMPLE_PROGRAM:  PROCEDURE OPTIONS(MAIN);    %include $stsdef;  %include $ssdef; %include pams_pli_entry_point; %include pams_pli_process; %include pams_pli_group; %include pams_pli_type_class;   %include pams_pli_return_status; %include pams_pli_symbol_def;  %include pams_prt_sts; %include sys$exit;   %replace false    by '0'b; %replace true     by '1'b;  < DCL PUT_MSG_AREA		CHAR(20) INITIAL ('ABCDEFGHIJKLMNOPQRST');) DCL GET_MSG_AREA                CHAR(20);  DCL 1 PAMS_ADDRESS1,     2 PN_UNION			      UNION, (       3 ALL             		FIXED BIN(31),       3 PN_BREAKDOWN, %         4 PN_PROCESS			FIXED BIN(15), #         4 PN_GROUP			FIXED BIN(15);    DCL 1 PAMS_ADDRESS2,     2 PN_UNION			      UNION, (       3 ALL             		FIXED BIN(31),       3 PN_BREAKDOWN, %         4 PN_PROCESS			FIXED BIN(15), #         4 PN_GROUP			FIXED BIN(15);   6 DCL PUT_CLASS                           FIXED BIN(15);6 DCL PUT_TYPE                            FIXED BIN(15);6 DCL GET_CLASS                           FIXED BIN(15);6 DCL GET_TYPE                            FIXED BIN(15);6 DCL GET_LENGTH                          FIXED BIN(15);6 DCL PUT_LENGTH                          FIXED BIN(15);6 DCL MSG_AREA_LENGTH                     FIXED BIN(15);5 DCL GET_PRIORITY                        FIXED BIN(7); 5 DCL PUT_PRIORITY                        FIXED BIN(7); 6 DCL TMO                                 FIXED BIN(31);5 DCL PUT_DELIVERY                        FIXED BIN(7); 6 DCL ATTACH_MODE                         FIXED BIN(31);6 DCL Q_TYPE                              FIXED BIN(31);   %page; /*A ***************************************************************** 
 *								* *	START OF EXECUTABLE CODE				* 
 *								*A *****************************************************************  */  %  ATTACH_MODE = PSYM_ATTACH_TEMPORARY;   Q_TYPE = PSYM_ATTACH_PQ; (  STS$VALUE = PAMS_ATTACH_Q (ATTACH_MODE,!         		    PAMS_ADDRESS1.ALL,   			    Q_TYPE);   IF ^STS$SUCCESS  THEN    DO;6      PUT SKIP LIST ('*** Could not attach queue ***');      CALL SYS$EXIT (STS$VALUE);     END;     PUT_LENGTH = 20;   PUT_DELIVERY = 0;2  PUT SKIP LIST ('DATA Being Sent: ',PUT_MSG_AREA);I  STS$VALUE = PAMS_PUT_MSG(PUT_MSG_AREA, PUT_PRIORITY, PAMS_ADDRESS1.ALL,  I                           PUT_CLASS, PUT_TYPE, PUT_DELIVERY, PUT_LENGTH);     IF ^STS$SUCCESS  THEN    DO;5      PUT SKIP LIST ('*** Error in PAMS_PUT_MSG ***');       CALL SYS$EXIT (STS$VALUE);     END;   3  TMO = 100; /* TEN SECONDS SHOULD BE LONG ENOUGH */   MSG_AREA_LENGTH = 20;I  STS$VALUE = PAMS_GET_MSGW(GET_MSG_AREA, GET_PRIORITY,PAMS_ADDRESS2.ALL,  * 			  GET_CLASS, GET_TYPE,MSG_AREA_LENGTH,  			  GET_LENGTH,TMO);     IF ^STS$SUCCESS  THEN    DO;5      PUT SKIP LIST ('*** Error in PAMS_GET_MSG ***');       CALL SYS$EXIT (STS$VALUE);     END;     STS$VALUE = PAMS_EXIT ();0  PUT SKIP LIST ('DATA Received: ',GET_MSG_AREA);  - END PAMS_EXAMPLE_PROGRAM;   /* PROGRAM END */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 % * [DMQ$V20.EXAMPLES]PAMS_TASK_PKG.ADA;1 +  , B   . $    /     4 O   $   $ >                    - B    0   1    2   3      K  P   W   O %    5   6 2/]  7 q  8          9 Z  G    H  J                           --N --****************************************************************************N --*                                                                          *N --*  Copyright (c) 1990, 1991, 1992                                          *N --*  by DIGITAL Equipment Corporation, Maynard, Mass.                        *N --*                                                                          *N --*  This software is furnished under a license and may be used and  copied  *N --*  only  in  accordance  with  the  terms  of  such  license and with the  *N --*  inclusion of the above copyright notice.  This software or  any  other  *N --*  copies  thereof may not be provided or otherwise made available to any  *N --*  other person.  No title to and ownership of  the  software  is  hereby  *N --*  transferred.                                                            *N --*                                                                          *N --*  The information in this software is subject to change  without  notice  *N --*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *N --*  Corporation.                                                            *N --*                                                                          *N --*  DIGITAL assumes no responsibility for the use or  reliability  of  its  *N --*  software on equipment which is not supplied by DIGITAL.                 *N --*                                                                          *N --**************************************************************************** --2 -- Contains Tasks which interface with DECmessageQ --4 -- Import standard system definition and I/O units.  -- with SYSTEM;. with STARLET;				--VMS System Service Routines with CONDITION_HANDLING; with INTEGER_TEXT_IO; 
 with TEXT_IO;    with PAMS_ADA_ENTRY_POINT; with PAMS_ADA_GROUP; with PAMS_ADA_PROCESS; with PAMS_ADA_TYPE_CLASS;   with PAMS_ADA_RETURN_STATUS_DEF; with PAMS_ADA_SYMBOL_DEF;    use SYSTEM;  use INTEGER_TEXT_IO; use TEXT_IO;   use PAMS_ADA_ENTRY_POINT;  use PAMS_ADA_GROUP;  use PAMS_ADA_PROCESS;  use PAMS_ADA_TYPE_CLASS; use PAMS_ADA_RETURN_STATUS_DEF;  use PAMS_ADA_SYMBOL_DEF;   package body PAMS_TASK_PKG is     1 -- Package containing DECMessageQ interface Tasks    task body PAMS_SINGLE_QUEUE is  G     -- This Task uses an asynchronous PAMS_GET_MSGA and an AST_ENTRY to :     -- receive messages.  There is only one PAMS_GET_MSG_A      -- outstanding in this task.  1     STATUS		: CONDITION_HANDLING.COND_VALUE_TYPE; -     QUEUE_REQ		: INTEGER := PAMS_TEMPORARY_Q;      QUEUE_ACT		: INTEGER := 0;)     QUEUE_TYPE		: INTEGER := PSYM_DCL_PQ; .     NAME_SCOPE		: INTEGER := PSYM_SCOPE_LOCAL;     0     MAX_MSG_SIZE	: constant SHORT_INTEGER := 80;E     MESSAGE		: SYSTEM.UNSIGNED_BYTE_ARRAY (1..INTEGER(MAX_MSG_SIZE)); 7     MESSAGE_STRING	: STRING (1..INTEGER(MAX_MSG_SIZE)); )     PRIORITY		: SHORT_SHORT_INTEGER := 0;      SOURCE		: INTEGER;     GET_CLASS		: SHORT_INTEGER;      GET_TYPE		: SHORT_INTEGER;1     AREA_LENGTH		: SHORT_INTEGER := MAX_MSG_SIZE;       MSG_LENGTH		: SHORT_INTEGER;     SEL_FILTER		: INTEGER := 0;      PSB			: PSB_TYPE; $     SHOW_BUFFER		: SHOW_BUFFER_TYPE;$     SHOW_BUFFER_LEN	: INTEGER := 64;  .     for MESSAGE_STRING use at MESSAGE'ADDRESS;   begin      loop         select1 	    accept START_UP (QUEUE_NAME  : in STRING) do   + 		PUT_LINE ("Attaching to DECmessageQ..."); ) 		PAMS_DCL_PROCESS (STATUS     => STATUS,  				  PROC_NUM   => QUEUE_REQ, 				  PROC_NUM2  => QUEUE_ACT, 				  Q_TYPE     => QUEUE_TYPE,  				  Q_NAME     => QUEUE_NAME, & 				  Q_NAME_LEN => QUEUE_NAME'LENGTH,  				  NAME_SCOPE => NAME_SCOPE);  1 		if not CONDITION_HANDLING.SUCCESS (STATUS) then  		    raise PROGRAM_ERROR;	 		end if; $ 		MESSAGE_STRING := (others => ' ');  $ 		-- Issue the initial PAMS_GET_MSGA 		--$ 		PAMS_GET_MSGA (STATUS		 => STATUS,( 			       MSG_AREA		 => MESSAGE'address,! 			       PRIORITY		 => PRIORITY, ' 			       SOURCE_Q		 => SOURCE'address, * 			       MSG_CLASS	 => GET_CLASS'address,0 			       MSG_TYPE	         => GET_TYPE'address,& 			       AREA_LENGTH	 => AREA_LENGTH,, 			       MSG_LENGTH	 => MSG_LENGTH'address,# 			       SEL_ADDR		 => SEL_FILTER, + 			       PAMS_STATUS_BLOCK => PSB'address, . 			       SHOW_BUFFER	 => SHOW_BUFFER'address,+ 			       SHOW_BUFFLEN	 => SHOW_BUFFER_LEN, ( 			       ACTRTN		 => PAMS_SINGLE_QUEUE.% 						    MSG_FROM_THE_BUS'AST_ENTRY,  			       ACTPARM		 => 1);  1 		if not CONDITION_HANDLING.SUCCESS (STATUS) then  		    raise PROGRAM_ER                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  #                        D* $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES]PAMS_TASK_PKG.ADA;1                                                                                          O     $                         7 "     
       ROR;	 		end if; 	 	    end; 
         or? 	    accept MSG_FROM_THE_BUS (QUEUE_INDEX : in INTEGER := 0) do * 		if PSB.DEL_PSB_STATUS = PAMS_CANCEL then* 		    PUT_LINE ("Cancel get received..."); 		else: 		    PUT_LINE ("MSG_FROM_THE_BUS - Message received...");  		    PUT_LINE (MESSAGE_STRING); 		    NEW_LINE;   ( 		    MESSAGE_STRING := (others => ' ');  " 		    -- Reissue the PAMS_GET_MSGA 		    --+ 		    PAMS_GET_MSGA (STATUS	     => STATUS, ( 				   MSG_AREA	     => MESSAGE'address,! 				   PRIORITY	     => PRIORITY, ' 				   SOURCE_Q	     => SOURCE'address, + 				   MSG_CLASS	     => GET_CLASS'address, ) 				   MSG_TYPE	     => GET_TYPE'address, ' 				   AREA_LENGTH	     => AREA_LENGTH, - 				   MSG_LENGTH	     => MSG_LENGTH'address, # 				   SEL_ADDR	     => SEL_FILTER, ( 				   PAMS_STATUS_BLOCK => PSB'address,/ 				   SHOW_BUFFER	     => SHOW_BUFFER'address, , 				   SHOW_BUFFLEN	     => SHOW_BUFFER_LEN,( 				   ACTRTN	     => PAMS_SINGLE_QUEUE." 							MSG_FROM_THE_BUS'AST_ENTRY,$ 				   ACTPARM	     => QUEUE_INDEX);  5 		    if not CONDITION_HANDLING.SUCCESS (STATUS) then  			raise PROGRAM_ERROR; 
 		    end if; 	 		end if; 	 	    end;  	or  	    accept SHUT_DOWN do* 		PUT_LINE ("Canceling PAMS_GET_MSGA...");( 		PAMS_CANCEL_GET (STATUS     => STATUS, 				 SEL_ADDR   => SEL_FILTER); 1 		if not CONDITION_HANDLING.SUCCESS (STATUS) then  		    raise PROGRAM_ERROR;	 		end if;   & 		PUT_LINE ("Exiting message bus...");# 		PAMS_EXIT (STATUS     => STATUS); 1 		if not CONDITION_HANDLING.SUCCESS (STATUS) then  		    raise PROGRAM_ERROR;	 		end if; 	 	    end;  	or  	    terminate;          end select; 
     end loop;   	 exception      when PROGRAM_ERROR => ! 	CONDITION_HANDLING.STOP(STATUS);      when others => 	raise;    end PAMS_SINGLE_QUEUE;     task body PAMS_MULTI_QUEUE is   O     -- This Task uses an asynchronous PAMS_GET_MSGA and an AST_ENTRY to receive C     -- messages.  There are multiple PAMS_GET_MSG_As outstanding on M     -- multiple temporary queues in this Task.  DECmessageQ limits the number '     -- of outstanding ASTs to nine (9).        RESOURCE_FAIL	: exception;        type SEL_FILTER_TYPE is ? 	-- Since we are using an address clause later the order of the + 	-- two objects in this record is important  	record " 	    SELECT_VAR  : SHORT_INTEGER; ! 	    SELECT_MODE : SHORT_INTEGER;  	end record;  9     -- This is used for canceling the PAMS_GET_MSGA calls      --     type QUEUE_REC is  	record  	    SEL_FILTER	: INTEGER; 	end record;  >     type QUEUE_ARRAY is array (integer range <>) of QUEUE_REC;  &     QUEUE_LIST		: QUEUE_ARRAY (1..10);  #     PAMS_SELECT		: SEL_FILTER_TYPE;   1     STATUS		: CONDITION_HANDLING.COND_VALUE_TYPE;      QUEUE		: Q_ADDRESS_TYPE;     QUEUE_ACTUAL	: INTEGER; )     QUEUE_TYPE		: INTEGER := PSYM_DCL_PQ;   0     MAX_MSG_SIZE	: constant SHORT_INTEGER := 80;  E     MESSAGE		: SYSTEM.UNSIGNED_BYTE_ARRAY (1..INTEGER(MAX_MSG_SIZE)); 7     MESSAGE_STRING	: STRING (1..INTEGER(MAX_MSG_SIZE)); )     PRIORITY		: SHORT_SHORT_INTEGER := 0;      SOURCE		: INTEGER;     GET_CLASS		: SHORT_INTEGER;      GET_TYPE		: SHORT_INTEGER;1     AREA_LENGTH		: SHORT_INTEGER := MAX_MSG_SIZE;       MSG_LENGTH		: SHORT_INTEGER;     SEL_FILTER		: INTEGER := 0; $     SHOW_BUFFER		: SHOW_BUFFER_TYPE;$     SHOW_BUFFER_LEN	: INTEGER := 64;     PSB			: PSB_TYPE;         QUEUE_INDEX		: INTEGER := 0;      QUEUE_TOTAL		: INTEGER := 0;  >     for MESSAGE_STRING use at MESSAGE'ADDRESS;  -- The message?     for QUEUE use at QUEUE_ACTUAL'ADDRESS;      -- Queue record J     for PAMS_SELECT use at SEL_FILTER'ADDRESS;  -- Selection filter record   begin      loop         select3 	    accept START_UP (QUEUE_REQ  : in INTEGER := 0; ! 			     QUEUE_ACT  : out INTEGER; # 			     QUEUE_TYPE : in INTEGER) do   ! 		QUEUE_INDEX := QUEUE_INDEX + 1; ! 		QUEUE_TOTAL := QUEUE_TOTAL + 1;   + 		PUT_LINE ("Attaching to DECmessageQ...");  		PUT ("Queue index = ");  		PUT (QUEUE_INDEX); 		NEW_LINE;  		PUT ("Queue Requested = ");  		PUT (QUEUE_REQ); 		NEW_LINE;   ) 		PAMS_DCL_PROCESS (STATUS     => STATUS,  				  PROC_NUM   => QUEUE_REQ,! 				  PROC_NUM2  => QUEUE_ACTUAL,   				  Q_TYPE     => QUEUE_TYPE);   		QUEUE_ACT := QUEUE_ACTUAL;   		PUT ("Queue Actual = "); 		PUT (integer(QUEUE.QUEUE));  		NEW_LINE;   1 		if not CONDITION_HANDLING.SUCCESS (STATUS) then  		    raise PROGRAM_ERROR;	 		end if;   : 		-- Must set the selection filter uniquely for each queue 		--" 		if QUEUE_TYPE = PSYM_DCL_PQ then) 		    PAMS_SELECT.SELECT_MODE := PSEL_PQ; @ 		    PAMS_SELECT.SELECT_VAR := 0; -- must be 0 for mode PSEL_PQ% 		elsif QUEUE_TYPE = PSYM_DCL_SQ then ) 		    PAMS_SELECT.SELECT_MODE := PSEL_AQ; , 		    PAMS_SELECT.SELECT_VAR := QUEUE.QUEUE;	 		end if;   @ 		-- Save the selection filters for reissue of the PAMS_GET_MSGA 		--4 		QUEUE_LIST (QUEUE_INDEX).SEL_FILTER := SEL_FILTER;$ 		MESSAGE_STRING := (others => ' ');  $ 		-- Issue the initial PAMS_GET_MSGA 		--$ 		PAMS_GET_MSGA (STATUS		 => STATUS,( 			       MSG_AREA		 => MESSAGE'address,! 			       PRIORITY		 => PRIORITY, ' 			       SOURCE_Q		 => SOURCE'address, * 			       MSG_CLASS	 => GET_CLASS'address,0 			       MSG_TYPE	         => GET_TYPE'address,& 			       AREA_LENGTH	 => AREA_LENGTH,, 			       MSG_LENGTH	 => MSG_LENGTH'address,# 			       SEL_ADDR		 => SEL_FILTER, + 			       PAMS_STATUS_BLOCK => PSB'address, . 			       SHOW_BUFFER	 => SHOW_BUFFER'address,+ 			       SHOW_BUFFLEN	 => SHOW_BUFFER_LEN, ' 			       ACTRTN		 => PAMS_MULTI_QUEUE. % 						    MSG_FROM_THE_BUS'AST_ENTRY, $ 			       ACTPARM		 => QUEUE_INDEX);  ! 		if STATUS = PAMS_RESRCFAIL then* 		    raise RESOURCE_FAIL;4 		elsif not CONDITION_HANDLING.SUCCESS (STATUS) then 		    raise PROGRAM_ERROR;	 		end if; 	 	    end; 
         or? 	    accept MSG_FROM_THE_BUS (QUEUE_INDEX : in INTEGER := 0) do * 		if PSB.DEL_PSB_STATUS = PAMS_CANCEL then* 		    PUT_LINE ("Cancel get received..."); 		else> 		    PUT_LINE ("MSG_FROM_THE_BUS - One message received...");  		    PUT_LINE (MESSAGE_STRING); 		    NEW_LINE;i" 		    PUT_LINE ("Queue index = "); 		    PUT (QUEUE_INDEX); 		    NEW_LINE;m( 		    MESSAGE_STRING := (others => ' ');  " 		    -- Reissue the PAMS_GET_MSGA 		    --& 		    PAMS_GET_MSGA (STATUS	=> STATUS,# 				   MSG_AREA	=> MESSAGE'address,w 				   PRIORITY	=> PRIORITY," 				   SOURCE_Q	=> SOURCE'address,) 				   MSG_CLASS    => GET_CLASS'address, $ 				   MSG_TYPE	=> GET_TYPE'address,# 				   AREA_LENGTH  => AREA_LENGTH, * 				   MSG_LENGTH   => MSG_LENGTH'address,7 				   SEL_ADDR	=> QUEUE_LIST (QUEUE_INDEX).SEL_FILTER,i( 				   PAMS_STATUS_BLOCK => PSB'address,1 			           SHOW_BUFFER	=> SHOW_BUFFER'address,t. 			           SHOW_BUFFLEN	=> SHOW_BUFFER_LEN," 				   ACTRTN	=> PAMS_MULTI_QUEUE.+ 					           MSG_FROM_THE_BUS'AST_ENTRY,-& 			           ACTPARM	=> QUEUE_INDEX);  % 		    if STATUS = PAMS_RESRCFAIL then  			raise RESOURCE_FAIL;n8 		    elsif not CONDITION_HANDLING.SUCCESS (STATUS) then 			raise PROGRAM_ERROR;i
 		    end if;b	 		end if; 	 	    end;  	or  	    accept SHUT_DOWN do0 		PUT_LINE ("Canceling PAMS_GET_MSGA calls...");  " 		for INDEX in 1..QUEUE_TOTAL loop 		    , 		    PAMS_CANCEL_GET (STATUS     => STATUS,6 				     SEL_ADDR   => QUEUE_LIST (INDEX).SEL_FILTER);5 		    if not CONDITION_HANDLING.SUCCESS (STATUS) theni 			raise PROGRAM_ERROR;	
 		    end if;  		end loop;n  & 		PUT_LINE ("Exiting message bus..."); 		PAMS_EXIT (STATUS => STATUS);h1 		if not CONDITION_HANDLING.SUCCESS (STATUS) thenP 		    raise PROGRAM_ERROR;	 		end if;A  	 	    end;M 	or_ 	    terminate;;         end select;L
     end loop;Y  	 exceptionN     when RESOURCE_FAIL =>;? 	PUT_LINE ("Maximum outstanding PAMS_GET_MSGA calls exceeded");A     when PROGRAM_ERROR =>P" 	CONDITION_HANDLING.STOP (STATUS);     when others => 	raise;E   end PAMS_MULTI_QUEUE;A     task body TASK_TO_PAMS isa   -- A simple message server task   A     -- Receives an Ada interface message and passes it to a queuen     -- using PAMS_PUT_MSGT     --     RESOURCE_FAIL	: exception;   1     STATUS		: CONDITION_HANDLING.COND_VALUE_TYPE;h     QUEUE_ACT		: INTEGER;O  0     MAX_MSG_SIZE	: constant SHORT_INTEGER := 80;  E     MESSAGE		: SYSTEM.UNSIGNED_BYTE_ARRAY (1..INTEGER(MAX_MSG_SIZE));_7     MESSAGE_STRING	: STRING (1..INTEGER(MAX_MSG_SIZE));E     TARGET		: INTEGER;  >     for MESSAGE_STRING use at MESSAGE'ADDRESS;  -- The message   beginE     loop 	selectA4 	    accept MSG_TO_THE_BUS (THE_MESSAGE : in STRING;, 				   PRIORITY    : in SHORT_SHORT_INTEGER;' 			           QUEUE       : in INTEGER;R- 			           PUT_CLASS   : in SHORT_INTEGER; - 			           PUT_TYPE    : in S                                                                                                                                                                                                                                                   $                        1 $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES]PAMS_TASK_PKG.ADA;1                                                                                          O     $                                      HORT_INTEGER;T3 			           DELIVERY    : in SHORT_SHORT_INTEGER;	- 			           MSG_SIZE    : in SHORT_INTEGER;0' 			           TIMEOUT     : in INTEGER;E) 			           PSB         : out PSB_TYPE;	6 			           UMA         : in SHORT_SHORT_INTEGER) do                  TARGET := QUEUE;  		MESSAGE_STRING := THE_MESSAGE;  # 		-- Send the message to the queue._ 		--) 		PAMS_PUT_MSG (STATUS	        => STATUS,L% 			      MSG_AREA	        => MESSAGE, & 			      PRIORITY	        => PRIORITY,$ 			      TARGET_Q	        => TARGET,( 			      MSG_CLASS         => PUT_CLASS,& 			      MSG_TYPE	        => PUT_TYPE,' 			      DELIVERY          => DELIVERY, ' 			      MSG_SIZE          => MSG_SIZE,U& 			      TIMEOUT           => TIMEOUT," 			      PAMS_STATUS_BLOCK => PSB,# 			      UMA               => UMA);P  " 		if STATUS = PAMS_REMQUEFAIL then 		    raise RESOURCE_FAIL;4 		elsif not CONDITION_HANDLING.SUCCESS (STATUS) then 		    raise PROGRAM_ERROR;	 		end if; 4 		PUT_LINE ("MSG_TO_THE_BUS - One message sent..."); 		PUT_LINE (MESSAGE_STRING); 		NEW_LINE;T$ 		MESSAGE_STRING := (others => ' ');	 	    end;T 	or	 	    terminate;H 	end select;
     end loop;   	 exceptionR     when PROGRAM_ERROR => " 	CONDITION_HANDLING.STOP (STATUS);     when others => 	raise;H   end TASK_TO_PAMS;	     task body PAMS_TO_TASK isU   -- A simple message server taskA  :     -- Receives a message from a queue using PAMS_GET_MSGA     --     RESOURCE_FAIL	: exception;  N1     STATUS		: CONDITION_HANDLING.COND_VALUE_TYPE;A     QUEUE_ACT		: INTEGER;e  0     MAX_MSG_SIZE	: constant SHORT_INTEGER := 80;  E     MESSAGE		: SYSTEM.UNSIGNED_BYTE_ARRAY (1..INTEGER(MAX_MSG_SIZE));n7     MESSAGE_STRING	: STRING (1..INTEGER(MAX_MSG_SIZE)); )     PRIORITY		: SHORT_SHORT_INTEGER := 0;e     SOURCE		: INTEGER;$     GET_CLASS		: SHORT_INTEGER := 1;#     GET_TYPE		: SHORT_INTEGER := 1;>8     DELIVERY		: SHORT_SHORT_INTEGER := PDEL_MODE_NN_MEM;1     AREA_LENGTH		: SHORT_INTEGER := MAX_MSG_SIZE;M      MSG_LENGTH		: SHORT_INTEGER;     SEL_FILTER		: INTEGER := 0; $     SHOW_BUFFER		: SHOW_BUFFER_TYPE;$     SHOW_BUFFER_LEN	: INTEGER := 64;     PSB			: PSB_TYPE;G#     TIMEOUT	        : INTEGER := 0;	  >     for MESSAGE_STRING use at MESSAGE'ADDRESS;  -- The message   begina     loop 	selectL 	    accept START_UP do $ 		MESSAGE_STRING := (others => ' ');  $ 		-- Issue the initial PAMS_GET_MSGA 		--$ 		PAMS_GET_MSGA (STATUS		 => STATUS,( 			       MSG_AREA		 => MESSAGE'address,! 			       PRIORITY		 => PRIORITY,H' 			       SOURCE_Q		 => SOURCE'address,Q* 			       MSG_CLASS	 => GET_CLASS'address,0 			       MSG_TYPE	         => GET_TYPE'address,& 			       AREA_LENGTH	 => AREA_LENGTH,, 			       MSG_LENGTH	 => MSG_LENGTH'address,# 			       SEL_ADDR		 => SEL_FILTER,A+ 			       PAMS_STATUS_BLOCK => PSB'address,L. 			       SHOW_BUFFER	 => SHOW_BUFFER'address,+ 			       SHOW_BUFFLEN	 => SHOW_BUFFER_LEN,G# 			       ACTRTN		 => PAMS_TO_TASK.(% 						    MSG_FROM_THE_BUS'AST_ENTRY,  			       ACTPARM		 => 1);  1 		if not CONDITION_HANDLING.SUCCESS (STATUS) then  		    raise PROGRAM_ERROR;	 		end if; 	 	    end;  	or  	    accept MSG_FROM_THE_BUS do * 		if PSB.DEL_PSB_STATUS = PAMS_CANCEL then* 		    PUT_LINE ("Cancel get received..."); 		else> 		    PUT_LINE ("MSG_FROM_THE_BUS - One message received...");  		    PUT_LINE (MESSAGE_STRING); 		    NEW_LINE; $ 		MESSAGE_STRING := (others => ' ');   		-- Reissue the PAMS_GET_MSGA 		--$ 		PAMS_GET_MSGA (STATUS		 => STATUS,( 			       MSG_AREA		 => MESSAGE'address,! 			       PRIORITY		 => PRIORITY,i' 			       SOURCE_Q		 => SOURCE'address,s* 			       MSG_CLASS	 => GET_CLASS'address,0 			       MSG_TYPE	         => GET_TYPE'address,& 			       AREA_LENGTH	 => AREA_LENGTH,, 			       MSG_LENGTH	 => MSG_LENGTH'address,# 			       SEL_ADDR		 => SEL_FILTER,_+ 			       PAMS_STATUS_BLOCK => PSB'address,O. 			       SHOW_BUFFER	 => SHOW_BUFFER'address,+ 			       SHOW_BUFFLEN	 => SHOW_BUFFER_LEN, # 			       ACTRTN		 => PAMS_TO_TASK. % 						    MSG_FROM_THE_BUS'AST_ENTRY,; 			       ACTPARM		 => 1);  1 		if not CONDITION_HANDLING.SUCCESS (STATUS) thenI 		    raise PROGRAM_ERROR;	 		end if;S	 		end if;L	 	    end;E 	or  	    accept SHUT_DOWN do* 		PUT_LINE ("Canceling PAMS_GET_MSGA...");( 		PAMS_CANCEL_GET (STATUS     => STATUS, 				 SEL_ADDR   => SEL_FILTER);_1 		if not CONDITION_HANDLING.SUCCESS (STATUS) thenE 		    raise PROGRAM_ERROR;	 		end if;N	 	    end;A 	or. 	    terminate;I 	end select;
     end loop;S  	 exceptionE     when PROGRAM_ERROR =>R" 	CONDITION_HANDLING.STOP (STATUS);     when others => 	raise;    end PAMS_TO_TASK;T   end PAMS_TASK_PKG;SHORT_INTEGER;1     AREA_LENGTH		: SHORT_INTEGER := MAX_MSG_SIZE;       MSG_LENGTH		: SHORT_INTEGER;     SEL_FILTER		: INTEGER := 0; $     SHOW_BUFFER		: SHOW_BUFFER_TYPE;$     SHOW_BUFFER_LEN	: INTEGER := 64;     PSB			: PSB_TYPE;         QUEUE_INDEX		: INTEGER := 0;      QUEUE_TOTAL		: INTEGER := 0;  >     for MESSAGE_STRING use at MESSAGE'ADDRESS;  -- The message?     for QUEUE use at QUEUE_ACTUAL'ADDRESS;      -- Queue record J     for PA              & * [DMQ$V20.EXAMPLES]PAMS_TASK_PKG_.ADA;1 +  , B   .     /     4 O                           - B    0   1    2   3      K  P   W   O 
    5   6 Y  7 Nq  8          9 Z  G    H  J                          --N --****************************************************************************N --*                                                                          *N --*  Copyright (c) 1990, 1991, 1992                                          *N --*  by DIGITAL Equipment Corporation, Maynard, Mass.                        *N --*                                                                          *N --*  This software is furnished under a license and may be used and  copied  *N --*  only  in  accordance  with  the  terms  of  such  license and with the  *N --*  inclusion of the above copyright notice.  This software or  any  other  *N --*  copies  thereof may not be provided or otherwise made available to any  *N --*  other person.  No title to and ownership of  the  software  is  hereby  *N --*  transferred.                                                            *N --*                                                                          *N --*  The information in this software is subject to change  without  notice  *N --*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *N --*  Corporation.                                                            *N --*                                                                          *N --*  DIGITAL assumes no responsibility for the use or  reliability  of  its  *N --*  software on equipment which is not supplied by DIGITAL.                 *N --*                                                                          *N --**************************************************************************** --2 -- Contains Tasks which interface with DECMessageQ --4 -- Import standard system definition and I/O units.  --2 with STARLET;				--VMS System Service Return Codes with SYSTEM; with INTEGER_TEXT_IO; 
 with TEXT_IO;  with CONDITION_HANDLING;   with PAMS_ADA_ENTRY_POINT; with PAMS_ADA_GROUP; with PAMS_ADA_PROCESS; with PAMS_ADA_TYPE_CLASS;   with PAMS_ADA_RETURN_STATUS_DEF; with PAMS_ADA_SYMBOL_DEF;    use INTEGER_TEXT_IO; use TEXT_IO;   use PAMS_ADA_ENTRY_POINT;  use PAMS_ADA_GROUP;  use PAMS_ADA_PROCESS;  use PAMS_ADA_TYPE_CLASS; use PAMS_ADA_RETURN_STATUS_DEF;  use PAMS_ADA_SYMBOL_DEF;   package PAMS_TASK_PKG is  1 -- Package containing DECMessageQ interface Tasks      --9     -- Define data type for PAMS target/source addresses.      --     type PAMS_ADDRESS is 	record  	    PROCESS	: short_integer;  	    GROUP	: short_integer;  	end record;   task PAMS_SINGLE_QUEUE is     7 -- This Task will perform an asynchronous PAMS_GET_MSGA   C     -- This entry should be performed first to attach to the queue. M     -- The QUEUE_REQ parameter can indicate either a permanent or a temporary 
     -- queue.      --,     entry START_UP (QUEUE_NAME : in STRING);  K     -- Entry point to get a message from the message bus.  When the message L     -- arrives this entry is taken.  Also, the PAMS asynchronous get call is     -- reissued in this entry.     --;     entry MSG_FROM_THE_BUS (QUEUE_INDEX : in INTEGER := 0); (     pr                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  %                        r $      DMQ020.B                       B  B  &[DMQ$V20.EXAMPLES]PAMS_TASK_PKG_.ADA;1                                                                                         O                              M[             agma AST_ENTRY (MSG_FROM_THE_BUS);  M     -- This entry should be performed to cancel the outstanding PAMS get call #     -- and to exit the message bus.      --     entry SHUT_DOWN;   end PAMS_SINGLE_QUEUE;     task PAMS_MULTI_QUEUE is    C -- This task will perform multiple asynchronous PAMS_GET_MSGA calls   C     -- This entry should be performed first to attach to the queue. F     -- The QUEUE_REQ parameter should indicate a temporary queue.  TheJ     -- QUEUE_TYPE indicates either a primary or secondary queue. The firstF     -- call should always indicate a primary queue.  A maximum of nine7     -- START_UP entries (or PAMS declares) are allowed.      --1     entry START_UP (QUEUE_REQ  : in INTEGER := 0;  		    QUEUE_ACT  : out INTEGER;  		    QUEUE_TYPE : in INTEGER);   K     -- Entry point to get a message from the message bus.  When the message L     -- arrives this entry is taken.  Also, the PAMS asynchronous get call isG     -- reissued in this entry.  The QUEUE_INDEX is the action parameter M     -- passed into the entry.  This indicates which queue the message arrived 
     -- on.     --;     entry MSG_FROM_THE_BUS (QUEUE_INDEX : in INTEGER := 0); (     pragma AST_ENTRY (MSG_FROM_THE_BUS);  N     -- This entry should be performed to cancel the outstanding PAMS get calls#     -- and to exit the message bus.      --     entry SHUT_DOWN;   end PAMS_MULTI_QUEUE;      task TASK_TO_PAMS is  A -- A simple message server task. A PAMS_ATTACH_Q call is required  -- from the client program.   A     -- Receives an Ada interface message and passes it to a queue      -- using PAMS_PUT_MSG      --2     entry MSG_TO_THE_BUS (THE_MESSAGE : in STRING;* 			  PRIORITY    : in SHORT_SHORT_INTEGER; 			  QUEUE       : in INTEGER;$ 			  PUT_CLASS   : in SHORT_INTEGER;$ 			  PUT_TYPE    : in SHORT_INTEGER;* 			  DELIVERY    : in SHORT_SHORT_INTEGER;$ 			  MSG_SIZE    : in SHORT_INTEGER; 			  TIMEOUT     : in INTEGER;  			  PSB         : out PSB_TYPE;+ 			  UMA         : in SHORT_SHORT_INTEGER);    end TASK_TO_PAMS;      task PAMS_TO_TASK is  H -- Receives a message from a queue using PAMS_GET_MSGA.  A PAMS_ATTACH_Q, -- call is required from the client program.  O     -- This entry should be performed first to invoke the initial PAMS_GET_MSGA      -- asynchronous call.      --     entry START_UP;   K     -- Entry point to get a message from the message bus.  When the message L     -- arrives this entry is taken.  Also, the PAMS asynchronous get call is     -- reissued in this entry.     --     entry MSG_FROM_THE_BUS; (     pragma AST_ENTRY (MSG_FROM_THE_BUS);  N     -- This entry should be performed to cancel the outstanding PAMS get calls     --     entry SHUT_DOWN;   end PAMS_TO_TASK;    end PAMS_TASK_PKG;                                                                                                                                                                                                                                                                                                                        ( * [DMQ$V20.EXAMPLES]PAMS_TASK_SENDER.ADA;1 +  , B   .     /     4 X      
                    - B    0   1    2   3      K  P   W   O     5   6 NX  7 q  8          9 Z  G    H  J                        --N --****************************************************************************N --*                                                                          *N --*  Copyright (c) 1990, 1991, 1992                                          *N --*  by DIGITAL Equipment Corporation, Maynard, Mass.                        *N --*                                                                          *N --*  This software is furnished under a license and may be used and  copied  *N --*  only  in  accordance  with  the  terms  of  such  license and with the  *N --*  inclusion of the above copyright notice.  This software or  any  other  *N --*  copies  thereof may not be provided or otherwise made available to any  *N --*  other person.  No title to and ownership of  the  software  is  hereby  *N --*  transferred.                                                            *N --*                                                                          *N --*  The information in this software is subject to change  without  notice  *N --*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *N --*  Corporation.                                                            *N --*                                                                          *N --*  DIGITAL assumes no responsibility for the use or  reliability  of  its  *N --*  software on equipment which is not supplied by DIGITAL.                 *N --*                                                                          *N --**************************************************************************** --3 with PAMS_TASK_PKG;				    -- Our PAMS Task package 
 with TEXT_IO;  with INTEGER_TEXT_IO;  with CONDITION_HANDLING; with SYSTEM;
 with STARLET;  with CDD_TYPES; 	 with STR;    with PAMS_ADA_ENTRY_POINT; with PAMS_ADA_GROUP; with PAMS_ADA_PROCESS; with PAMS_ADA_TYPE_CLASS;   with PAMS_ADA_RETURN_STATUS_DEF; with PAMS_ADA_SYMBOL_DEF;    use PAMS_ADA_ENTRY_POINT;  use PAMS_ADA_GROUP;  use PAMS_ADA_PROCESS;  use PAMS_ADA_TYPE_CLASS; use PAMS_ADA_RETURN_STATUS_DEF;  use PAMS_ADA_SYMBOL_DEF;   use PAMS_TASK_PKG; use TEXT_IO; use INTEGER_TEXT_IO; use CONDITION_HANDLING;  use CDD_TYPES; use SYSTEM;    procedure PAMS_TASK_SENDER is   @ -- This procedure will exercise both the MSG_TO_THE_BUS task and8 -- the MSG_FROM_THE_BUS task contained in PAMS_TASK_PKG.  1     PUT_BUF_SIZE        : constant INTEGER := 80;   M     STATUS              : COND_VALUE_TYPE;	         -- Completion status code   X     QUEUE_NUMBER        : INTEGER;                       -- Actual queue number returnedJ     QUEUE_NUMBER_ADDR   : Q_ADDRESS_TYPE;                -- Q address formI     QUEUE_TYPE          : INTEGER := PSYM_ATTACH_PQ;     -- Primary queue D     QUEUE_NAME          : STRING (1..7) := "QUEUE_1";    -- Our nameG     QUEUE_NAME_LEN      : INTEGER := 7;                  -- Name length   .     SEARCH_LIST         : INTEGER_ARRAY (1..3)G                                                 := (1 => PSEL_TBL_PROC, F                                                     2 => PSEL_TBL_GRP,K                                                     3 => PSEL_TBL_DNS_LOW); #     SEARCH_LIST_LEN	: INTEGER := 3;   6     for QUEUE_NUMBER_ADDR use at QUEUE_NUMBER'address;    J     PUT_BUFFER          : STRING (1..PUT_BUF_SIZE);      -- Message bufferG     PUT_BUFFER_ARRAY    : SYSTEM.UNSIGNED_BYTE_ARRAY (1..PUT_BUF_SIZE); " 							 -- Message buffer for PAMSN     PUT_CLASS           : SHORT_INTEGER := 1;            -- Message class codeM     PUT_TYPE            : SHORT_INTEGER := 1;            -- Message type code B     PUT_DELIVERY        : SHORT_SHORT_INTEGER := PDEL_MODE_NN_MEM; 							 -- Delivery modeL     PUT_PRIORITY        : SHORT_SHORT_INTEGER := 0;      -- Message priorityJ     PUT_RESP_QUE        : INTEGER;                       -- Response queueH     PUT_SIZE            : SHORT_INTEGER := 0;            -- Message sizeT     PUT_TIMEOUT         : INTEGER := 0;                  -- Time-out for blocked msg@     PUT_UMA             : SHORT_SHORT_INTEGER := PDEL_UMA_DISCL;# 							 -- Undeliverable msg action   3     for PUT_BUFFER_ARRAY use at PUT_BUFFER'address;   E     TARGET              : Q_ADDRESS_TYPE;	    -- Target queue address H     TARGET_ADDR         : INTEGER;		    -- Target queue address for PAMS  *     for TARGET_ADDR use at TARGET'address;  =     PSB                 : PSB_TYPE;		    -- PAMS status block "     IN_BUF_SIZE         : INTEGER;     begin   -     PUT_LINE ("Attaching to DECmessageQ..."); )     PAMS_ATTACH_Q (STATUS      => STATUS, 8                    ATTACH_MODE => PSYM_ATTACH_TEMPORARY,/                    Q_ATTACHED  => QUEUE_NUMBER, 1                    Q_TYPE      => PSYM_ATTACH_PQ, -                    Q_NAME      => QUEUE_NAME, 2                    Q_NAME_LEN  => QUEUE_NAME_LEN);  3     if not CONDITION_HANDLING.SUCCESS (STATUS) then          raise PROGRAM_ERROR;     end if;   ?     -- Startup the task that will make the PAMS_GET_MSGA calls.      --(     PAMS_TASK_PKG.PAMS_TO_TASK.START_UP;  K     -- Prompt user for a message t                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  &                        %d $      DMQ020.B                       B  B  ([DMQ$V20.EXAMPLES]PAMS_TASK_SENDER.ADA;1                                                                                       X                              f             o send.  Quit when user presses <ctrl-Z>.      --     loop 	begin  E         -- Prompt for and read the message. If <ctrl-Z> is pressed we          -- are done.  
         -->         PUT_LINE ("Enter message or press <ctrl-Z> to exit:");&         PUT_BUFFER := (others => ' ');;         GET_LINE (ITEM => PUT_BUFFER, LAST => IN_BUF_SIZE); /         PUT_SIZE := SHORT_INTEGER(IN_BUF_SIZE);   >         -- Call the task that will do the PAMS_PUT_MSG for us.
         --?         TASK_TO_PAMS.MSG_TO_THE_BUS (THE_MESSAGE => PUT_BUFFER, % 				     PRIORITY    => PUT_PRIORITY, % 				     QUEUE       => QUEUE_NUMBER, " 				     PUT_CLASS   => PUT_CLASS,! 				     PUT_TYPE    => PUT_TYPE, % 				     DELIVERY    => PUT_DELIVERY, ! 				     MSG_SIZE    => PUT_SIZE, $ 				     TIMEOUT     => PUT_TIMEOUT, 				     PSB         => PSB,! 				     UMA         => PUT_UMA);  	          exception 9             when END_ERROR => exit; -- Control-Z detected          end;  B     -- Go back and wait for user to enter another message to send.     --
     end loop;   D     -- Do a clean shutdown of the task doing the PAMS_GET_MSGA calls     --)     PAMS_TASK_PKG.PAMS_TO_TASK.SHUT_DOWN;   (     PUT_LINE ("Exiting message bus...");!     PAMS_EXIT (STATUS => STATUS);    end PAMS_TASK_SENDER;                                                                                                                                                                                                                                                                 ( * [DMQ$V20.EXAMPLES]PAMS_TASK_TESTER.ADA;1 +  , B   .     /     4 P                           - B    0   1    2   3      K  P   W   O     5   6 mZ  7 q  8          9 Z  G    H  J                        --N --****************************************************************************N --*                                                                          *N --*  Copyright (c) 1990, 1991, 1992                                          *N --*  by DIGITAL Equipment Corporation, Maynard, Mass.                        *N --*                                                                          *N --*  This software is furnished under a license and may be used and  copied  *N --*  only  in  accordance  with  the  terms  of  such  license and with the  *N --*  inclusion of the above copyright notice.  This software or  any  other  *N --*  copies  thereof may not be provided or otherwise made available to any  *N --*  other person.  No title to and ownership of  the  software  is  hereby  *N --*  transferred.                                                            *N --*                                                                          *N --*  The information in this software is subject to change  without  notice  *N --*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *N --*  Corporation.                                                            *N --*                                                                          *N --*  DIGITAL assumes no responsibility for the use or  reliability  of  its  *N --*  software on equipment which is not supplied by DIGITAL.                 *N --*                                                                          *N --**************************************************************************** --( -- Test PAMS_GET_MSGA calls with Tasking  3 with PAMS_TASK_PKG;				    -- Our PAMS Task package 
 with TEXT_IO;  with INTEGER_TEXT_IO;  with CONDITION_HANDLING; with SYSTEM;
 with STARLET; 	 with STR;  with CDD_TYPES;    with PAMS_ADA_ENTRY_POINT; with PAMS_ADA_GROUP; with PAMS_ADA_PROCESS; with PAMS_ADA_TYPE_CLASS;   with PAMS_ADA_RETURN_STATUS_DEF; with PAMS_ADA_SYMBOL_DEF;    use PAMS_ADA_ENTRY_POINT;  use PAMS_ADA_GROUP;  use PAMS_ADA_PROCESS;  use PAMS_ADA_TYPE_CLASS; use PAMS_ADA_RETURN_STATUS_DEF;  use PAMS_ADA_SYMBOL_DEF;   use PAMS_TASK_PKG; use TEXT_IO; use INTEGER_TEXT_IO; use CONDITION_HANDLING;  use SYSTEM;  use CDD_TYPES;   procedure PAMS_TASK_TESTER is   D -- This procedure will exercise either the PAMS_SINGLE_QUEUE task or6 -- the PAMS_MULTI_QUEUE task defined in PAMS_TASK_PKG.  1     PUT_BUF_SIZE        : constant INTEGER := 80;   M     STATUS              : SYSTEM.UNSIGNED_LONGWORD; -- Completion status code E     PUT_BUFFER          : STRING (1..PUT_BUF_SIZE); -- Message buffer G     PUT_BUFFER_ARRAY    : SYSTEM.UNSIGNED_BYTE_ARRAY (1..PUT_BUF_SIZE); $ 						    -- Message buffer for PAMSI     PUT_CLASS           : SHORT_INTEGER;            -- Message class code D     PUT_DELIVERY        : SHORT_SHORT_INTEGER;      -- Delivery modeG     PUT_PRIORITY        : SHORT_SHORT_INTEGER;      -- Message priority E     PUT_RESP_QUE        : INTEGER;                  -- Response queue C     PUT_SIZE            : SHORT_INTEGER;            -- Message size O     PUT_TIMEOUT         : INTEGER;                  -- Time-out for blocked msg H     PUT_TYPE            : SHORT_INTEGER;            -- Message type codeO     PUT_UMA             : SHORT_SHORT_INTEGER;      -- Undeliverable msg action   3     for PUT_BUFFER_ARRAY use at PUT_BUFFER'address;   ?     SEARCH_LIST		: INTEGER_ARRAY (1..3) := (1 => PSEL_TBL_PROC,  						   2 => PSEL_TBL_GRP,   						   3 => PSEL_TBL_DNS_LOW);#     SEARCH_LIST_LEN	: INTEGER := 3;   D     TARGET              : PAMS_ADDRESS;		    -- Target queue addressH     TARGET_ADDR         : INTEGER;		    -- Target queue address for PAMS  *     for TARGET_ADDR use at TARGET'address;  =     PSB                 : PSB_TYPE;		    -- PAMS status block "     IN_BUF_SIZE         : INTEGER;     QUEUE_ACTUAL	: INTEGER;        RESPONSE		: STRING (1..1);A     Q_MAX		: positive range 1..9;	    -- Maximum allowable queues      procedure PUT_A_MESSAGE is   begin   K     -- Prompt user for a message send it.  Quit when user presses <ctrl-Z>.      --     loop 	begin  E         -- Prompt for and read the message. If <ctrl-Z> is pressed we          -- are done.  
         -->         PUT_LINE ("Enter message or press <ctrl-Z> to exit:");&         PUT_BUFFER := (others => ' ');;         GET_LINE (ITEM => PUT_BUFFER, LAST => IN_BUF_SIZE); /         PUT_SIZE := SHORT_INTEGER(IN_BUF_SIZE);   H         -- Send the message to the target process queue.  If an error isK         -- returned, report it and exit. Otherwise, display class and type. 
         --2         PAMS_PUT_MSG (STATUS            => STATUS,<                       MSG_AREA          => PUT_BUFFER_ARRAY,8                       PRIORITY          => PUT_PRIORITY,7                       TARGET_Q          => TARGET_ADDR, 5                       MSG_CLASS         => PUT_CLASS, 4                       MSG_TYPE          => PUT_TYPE,8                       DELIVERY          => PUT_DELIVERY,4                       MSG_SIZE          => PUT_SIZE,7                       TIMEOUT           => PUT_TIMEOUT, /                       PAMS_STATUS_BLOCK => PSB, 3                       UMA               => PUT_UMA, 9                       RESP_Q            => PUT_RESP_QUE);    7         if not CONDITION_HANDLING.SUCCESS (STATUS) then :             PUT ("Error returned by PAMS_PUT_MSG code= ");.             PUT (integer(STATUS), WIDTH => 3);             NEW_LINE;          else3             PUT ("PAMS_TASK_TESTER: Sent Msg to "); <             PUT (ITEM => integer(TARGET.GROUP), WIDTH => 3);             PUT (".");>             PUT (ITEM => integer(TARGET.PROCESS), WIDTH => 3);             PUT (" class=");9             PUT (ITEM => integer(PUT_CLASS), WIDTH => 3);              PUT (" type="); 8             PUT (ITEM => integer(PUT_TYPE), WIDTH => 3);             NEW_LINE;          end if;            exception 9             when END_ERROR => exit; -- Control-Z detected          end;  B     -- Go back and wait for user to enter another message to send.     --
     end loop;    end PUT_A_MESSAGE;     begin   ?     PUT_CLASS    := 1;                  -- Send class 1 message D     PUT_PRIORITY := 0;                  -- Send at standard priorityC     PUT_RESP_QUE := 0;                  -- Response queue - default C     PUT_TYPE     := -123;               -- Msg type is user defined C     PUT_TIMEOUT  := 0;                  -- Accept standard time-out D     PUT_DELIVERY := PDEL_MODE_NN_MEM;   -- No notify, memory queuingC     PUT_UMA      := PDEL_UMA_DISC;      -- Discard if unde                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  '                        ^b $      DMQ020.B                       B  B  ([DMQ$V20.EXAMPLES]PAMS_TASK_TESTER.ADA;1                                                                                       P                              b             liverable        loop 	beginC 	    PUT ("Exercise a single queue or multiple queues? (S or M) ");  	    GET (RESPONSE); 	    SKIP_LINE; . 	    STR.UPCASE (STATUS             => STATUS," 			DESTINATION_STRING => RESPONSE,# 			SOURCE_STRING      => RESPONSE); 5 	    exit when RESPONSE = "S" or else RESPONSE = "M"; 
 	exception 	    when others =>  		SKIP_LINE;# 		PUT_LINE ("Invalid response...");  	end; 
     end loop;   %     -- Exercise the single queue Task      --     if RESPONSE = "S" then  B 	-- Perform the startup of the queue which declares to a temporary> 	-- queue by name and performs the initial PAMS_GET_MSGA call. 	-- N         PAMS_TASK_PKG.PAMS_SINGLE_QUEUE.START_UP (QUEUE_NAME => "TASK_QUEUE");  G 	-- Find out what our address is.  The messages will be send to ourself % 	-- and will be received by our task.  	-- * 	PAMS_LOCATE_Q (STATUS          => STATUS,) 		       Q_NAME          => "TASK_QUEUE",  		       Q_NAME_LEN      => 10, ( 		       Q_ADDRESS       => TARGET_ADDR,) 		       WAIT_MODE       => PSYM_WF_RESP, , 		       NAME_SPACE_LIST     => SEARCH_LIST,1 		       NAME_SPACE_LIST_LEN => SEARCH_LIST_LEN);   7         if not CONDITION_HANDLING.SUCCESS (STATUS) then ;             PUT ("Error returned by PAMS_LOCATE_Q code= "); .             PUT (integer(STATUS), WIDTH => 3);             NEW_LINE;  	end if;   	PUT_A_MESSAGE;    	-- Cancel and exit message bus  	-- 2         PAMS_TASK_PKG.PAMS_SINGLE_QUEUE.SHUT_DOWN;  '     -- Exercise the multiple queue Task      --     elsif RESPONSE = "M" then    	loop 
 	    begin5 	        PUT ("Attach to how many queues? (1 - 9) ");  	        GET (Q_MAX);  		SKIP_LINE; 	        exit; 	    exception 		when others =>$ 		    PUT_LINE ("Invalid input...");	 	    end;          end loop;   E 	-- This will declare to the temporary primary queue by queue number  B 	-- and return the address of the primary queue. We will only send" 	-- messages to our primary queue. 	-- P         PAMS_TASK_PKG.PAMS_MULTI_QUEUE.START_UP (QUEUE_REQ  => PAMS_TEMPORARY_Q," 						 QUEUE_ACT  => QUEUE_ACTUAL,) 					         QUEUE_TYPE => PSYM_DCL_PQ);   G 	-- We will send messages to ourself using the temporary primary queue. - 	-- The message will be received by our task.  	--  	TARGET_ADDR := QUEUE_ACTUAL;   5 	-- This will declare to all of the secondary queues.  	-- "         for INDEX in 2..Q_MAX loopM 	    PAMS_TASK_PKG.PAMS_MULTI_QUEUE.START_UP (QUEUE_REQ  => PAMS_TEMPORARY_Q, & 						     QUEUE_ACT  => QUEUE_ACTUAL,- 					             QUEUE_TYPE => PSYM_DCL_SQ);          end loop;    	PUT_A_MESSAGE;    	-- Cancel and exit message bus  	-- 1         PAMS_TASK_PKG.PAMS_MULTI_QUEUE.SHUT_DOWN;        end if;    end PAMS_TASK_TESTER;                                                                                                                                                                                                                                                                                                                                                     " * [DMQ$V20.EXAMPLES]PRECOMPILE.COM;1 +  , B   .     /     4 N                          - B    0   1    2   3      K  P   W   O     5   6 F  7 @tq  8          9 Z  G    H  J                              $!9 $! This command stream pulls in Pascal include files from 5 $! the PAMS$USER directory and creates a pre-compiled   $! environment from these files., $! CREATED ON: 11-Oct-1989 by Chris Saunders $! $!    **BEGIN**  $!! $ COPY PAMS$USER:PAIPRCPAS.TXT [] ! $ COPY PAMS$USER:PAIGRPPAS.TXT [] ! $ COPY PAMS$USER:PAITYPPAS.TXT [] ! $ COPY PAMS$USER:PAISYMPAS.TXT [] ! $ COPY PAMS$USER:PAIENTPAS.TXT [] " $ COPY PAMS$USER:PAISTSDPAS.TXT []) $ COPY PAMS$USER:HIDDEN_DATA_TYPES.PAS []  $!N $! -----------------Build PRECOMPILED UNIT OF PASCAL INCLUDE FILES------------ $!> $ WRITE SYS$OUTPUT "  Building the module to be pre-compiled " $!! $ DEFINE/USER_MODE SYS$OUTPUT NL:  $!, $ EDIT/EDT/COMMAND=NL: PRECOMPILED_FILES.PAS DEL WH I; MODULE PRECOMPILED_FILES;: I; (* PRECOMPILED PASCAL INCLUDE FILES...              *) 9 I; (* File name:     PRECOMPILED_FILES.PAS             *) 9 I; (*                                                  *)  INC PAISYMPAS.TXT  INC PAIPRCPAS.TXT  INC PAIGRPPAS.TXT  INC PAITYPPAS.TXT  INC PAISTSDPAS.TXT INC HIDDEN_DATA_TYPES.PAS  INC PAIENTPAS.TXT  I; END.  EXIT $!> $! compile the file PRECOMPILED_FILES.PAS with the environmentH $! qualifier;thus, creating the Environment file (PRECOMPILED_FILES.PEN) $!& $ PASCAL/ENVIRONMENT PRECOMPILED_FILES $! $ EXIT                                                                                                                                                                                                                                                * * [DMQ$V20.EXAMPLES]PRECOMPILED_SAMPLE.PAS;1 +  , B   .     /     4 H                         - B    0   1    2   3      K  P   W   O 	    5   6 @ .  7 /q  8          9 Z  G    H  J         
              % [ INHERIT ('DMQ$EXAMPLES:PAMS.PEN') ] * program precompiled_sample (input,output);  . {  Copyright (C) 1992, All Rights Reserved, by0    Digital Equipment Corporation, Maynard, Mass.  H    This software is furnished under a license and may be used and copiedH    only  in  accordance  with  the  terms  of such  license and with theH    inclusion of the above copyright notice. This software or  any  otherH    copies thereof may not be provided or otherwise made available to anyH    other person. No title to and ownership of  the  software  is  hereby    transferred.   H    The information in this software is subject to change without  noticeH    and  should  not be  construed  as  a commitment by Digital Equipment    Corporation.   H    Digital assumes no responsibility for the use or  reliability  of its;    software on equipment which is not supplied by Digital.}      type  	word_integer = [word] 0..65535; 	byte_integer = [byte] 0..255;
            var  	status: 	integer; 	req_process_num:integer;  	process_num:	integer;          attach_mode:    integer;          q_type:         integer;2 	msg_area:	varying [20] of char := 'TEST MESSAGE'; 	priority:	byte_integer; 	target:		integer; 	msg_class:	word_integer;  	msg_type:	word_integer; 	delivery:	byte_integer; 	msg_size:	word_integer; 	source:		integer; 	msg_area_len:	word_integer; 	len_data:	word_integer; 	timeout:	integer;            begin      { Declare pams process }   q_type := PSYM_ATTACH_PQ; '   attach_mode := PSYM_ATTACH_TEMPORARY; ;   status := pams_attach_q (attach_mode,process_num,q_type); /   writeln(' pams_attach_q status = ',status:1); )   writeln(' Q address = ',process_num:1); 
   writeln;     { Send message to self }   priority  := 0;    target    := process_num;    msg_class := msg_clas_pams;    msg_type  := -123;   delivery  := 0;     msg_size  := length(msg_area);4   status := pams_put_msg(msg_area, priority, target,+ 		msg_class, msg_type, delivery, msg_size); .   writeln(' pams_put_msg status = ',status:1);(   writeln(' msg_area sent = ',msg_area);
   writeln;     { Receive message from self } #   msg_area_len := length(msg_area);    timeout := 600; A   status := pams_get_msgw( msg_area, priority, source, msg_class, - 		msg_type, msg_area_len, len_data, timeout); /   writeln(' pams_get_msgw status = ',status:1); ,   writeln(' msg_area received = ',msg_area);
   writeln;     { Exit pams }    status := pams_exit;+   writeln(' pams_exit status = ',status:1);    end.                                                            " * [DMQ$V20.EXAMPLES]PUT_WF_REPLY.C;1 +  , B   .     /     4 P                          - B    0   1    2   3      K  P   W   O     5   6 !  7 q  8          9 Z  G    H  J                             #module put_wf_reply "V2.0-01"

/* 
 * Copyright (C) 1992, All Rights Reserved, by
 * Digital Equipment Corporation, Maynard, Mass.
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice. This software or  any  other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of  the  software  is  hereby
 * transferr                                                                                                                                                                                                                                                                                                                                                                                                                  (                        Nt $      DMQ020.B                       B  B  "[DMQ$V20.EXAMPLES]PUT_WF_REPLY.C;1                                                                                             P                              "            ed.
 *
 * The information in this software is subject to change without  notice
 * and  should  not be  construed  as  a commitment by Digital Equipment
 * Corporation.
 *
 * Digital assumes no responsibility for the use or  reliability  of its
 * software on equipment which is not supplied by Digital.
 *
 */

/* portable includes */
#include "p_proces.h"
#include "p_typecl.h"
#include "p_return.h"
#include "p_symbol.h"
#include "p_entry.h"
#include "p_group.h"


#include <ssdef.h>
#include <stsdef.h>

typedef union {
	long	all;
	struct {
		short	process;      
		short	group;
	} au;
}PAMS_ADDRESS;

#define	R_STRING	"  request/response  "
#define	FLUSH_STALE	1
#define	RETURN_STALE	2
#define	RETURN_NEXT	3

static char		put_buffer[sizeof(R_STRING)];
static char		put_priority;
static PAMS_ADDRESS	put_target;
static short int	put_class;
static short int	put_type;
static short int	put_size;
static short int	wf_form;
static short int	wf_value;
static short int	wf_stale_action;
static long int		wf_timeout,sts$value;
static long int		wf_status;
static char		reply_buffer;
static PAMS_ADDRESS	reply_source;
static short int	reply_class;
static short int	reply_type;
static short int	reply_buffer_size;
static short int	reply_transfer_size;
static int		sts_value;
static long int		proc_num_in;
static PAMS_ADDRESS	proc_num_out;
static int 		i;
static char		delivery;
static char		priority;
static long		timeout;
static char		uma;
struct PSB		psb;
static long		resp_que;
static long		sel_addr;
static long  int	alt_que;
static short int	p_size;
static short int	g_size;
static long int         attach_mode,q_type;



main ()         

{

/*

   This main program simulates a server/client relationship where the client
   uses the put_wf_reply call which does "synchronous messaging."

   It demonstrates different variations of the put_wf_reply call.
   There are four "wf" input parameters:
	wf_form, wf_value, wf_stale action, and wf_timeout,

   and one "wf" output parameter:
	wf_status.

   wf_form can be set to:
	1 - Wait for reply from TARGET server
	2 - Wait for reply on TYPE match
	3 - Wait for reply on CLASS (aka Transaction ID) match
	4 - Wait for reply from Alternate Queue

   wf_value is set according to the value of wf_form:
	If wf_form = 1, wf_value is ignored.
	If wf_form = 2, wf_value is the TYPE required for a match.
	If wf_form = 3, wf_value is the CLASS required for a match.
	If wf_form = 4, wf_value is the Alternate Queue to receive the reply.

   wf_stale_action can be set to:
	1 - Flush any stale messages before the PUT to the TARGET
	2 - Return any stale messages with an error return code
	3 - Do not check for stale messages (return next match)

   wf_timeout is the timeout value on the pams_get_msgw call, the value
	is in units of tenths of seconds.

   wf_status is set to SS$_NORMAL unless wf_stale_action = RETURN_STALE
	and a stale message is found, and then it is set to zero.

*/            
                    
printf("\n\n\t*** PUT_WF_REPLY beginning ***\n");

attach_mode = PSYM_ATTACH_TEMPORARY;
q_type = PSYM_ATTACH_PQ;

sts$value = pams_attach_q (&attach_mode,&proc_num_out.all,&q_type,0,0,
                           0,0,0,0,0);

if (!$VMS_STATUS_SUCCESS(sts$value)) 
  {
  putil_print_sts("PUT_WF_REPLY", "Error returned by PAMS_ATTACH_Q", sts$value);
  exit(sts_value);
}

printf("\n My Queue Address is '%d.%d'\n", proc_num_out.au.group,
					 proc_num_out.au.process);
strcpy(put_buffer,R_STRING);
put_priority	= 0;                  
put_target.all	= proc_num_out.all;
put_size	= strlen(put_buffer)+1;
reply_buffer_size = sizeof(put_buffer);

for (i=1; i <=6; i++) {

  switch(i) {
    case 1:
	put_class	= 1;
	put_type	= -123;
	wf_form		= 1;
	wf_value	= 0;
	wf_stale_action	= FLUSH_STALE;
	wf_timeout	= 100L;
	printf("\n wf_form         = 1    (Wait for reply for TARGET server)");
	printf("\n wf_value        = 0    (value ignored)");
	printf("\n wf_stale_action = FLUSH_STALE");
	printf("\n wf_timeout      = 100  (10 seconds)");
	break;

    case 2:
	put_class	= 1;
	put_type	= -123;
	wf_form		= 2;
	wf_value	= -123;
	wf_stale_action	= FLUSH_STALE;
	wf_timeout	= 100L;
	printf("\n wf_form         = 2    (Wait for reply on TYPE match)");
	printf("\n wf_value        = -123 (This TYPE will match)");
	printf("\n wf_stale_action = FLUSH_STALE");
	printf("\n wf_timeout      = 100  (10 seconds)");
	break;

    case 3:
	put_class	= 1;
	put_type	= -123;
	wf_form		= 2;
	wf_value	= -124;
	wf_stale_action	= RETURN_STALE;
	wf_timeout	= 100L;
	printf("\n wf_form         = 2    (Wait for reply on TYPE match)");
	printf("\n wf_value        = -124 (This TYPE will not match)");
	printf("\n wf_stale_action = RETURN_STALE");
	printf("\n wf_timeout      = 100  (10 seconds)");
	break;

    case 4:                
	put_class	= 1;
	put_type	= -123;
	wf_form		= 3;
	wf_value	= 1;
	wf_stale_action	= FLUSH_STALE;
	wf_timeout	= 50L;
	printf("\n wf_form         = 3    (Wait for reply on CLASS match)");
	printf("\n wf_value        = 1    (This CLASS will match)");
	printf("\n wf_stale_action = FLUSH_STALE");
	printf("\n wf_timeout      = 50   (5 seconds)");
	break;
    
    case 5:
	put_class	= 1;
	put_type	= -123;
	wf_form		= 3;
	wf_value	= 2;
	wf_stale_action	= RETURN_NEXT;
	wf_timeout	= 50L;
	printf("\n wf_form         = 3    (Wait for reply on CLASS match)");
	printf("\n wf_value        = 2    (This CLASS will not match)");
	printf("\n wf_stale_action = RETURN_NEXT");
	printf("\n wf_timeout      = 50   (5 seconds)");
	break;              

    case 6:                      

	put_target.all	= PAMS_QUEUE_SERVER;
	put_class	= MSG_CLAS_PAMS;
	put_type	= MSG_TYPE_DECLARE_SQ;
	delivery	= PDEL_MODE_NN_MEM;
	p_size		= 0;
	timeout		= 0L;
	uma		= PDEL_UMA_DISC;
	resp_que	= 0L;

	sts_value = pams_put_msg(	&put_buffer,
					&put_priority,
					&put_target,
					&put_class,
					&put_type,
					&delivery,
					&p_size,
					&timeout,
					&psb,
					&uma,
					&resp_que,0,0,0);

	if (sts_value == SS$_NORMAL) {

	  reply_source.all	= PAMS_QUEUE_SERVER;
	  reply_type		= MSG_TYPE_ALLOCATED_SQ;
	  priority 	= 0;
	  timeout	= 100L;
	  sel_addr	= 0L;
	  g_size	= sizeof(alt_que);

	  sts_value = pams_get_msgw(	&alt_que,
					&priority,
					&reply_source,
					&reply_class,
					&reply_type,
	    				&g_size,
					&reply_transfer_size,
					&timeout,
					&sel_addr,
					&psb,0,0,0,0,0);
	}                        
        else return(sts_value);          

	put_target.all = proc_num_out.all;
	put_target.au.process = alt_que;	/* since this is both the
						   server and the client
						   send directly to AQ */
	put_class	= 1;
	put_type	= -123;
	wf_form		= 4;
	wf_value	= alt_que;
	wf_stale_action	= FLUSH_STALE;
	wf_timeout	= 50;
	printf("\n wf_form         = 4    (Wait for reply from Alternate Queue)");
	printf("\n wf_value        = %d  (Value of Alternate Queue)",wf_value);
	printf("\n wf_stale_action = FLUSH_STALE");
	printf("\n wf_timeout      = 50   (5 seconds)");
	break;

    default:
	return(0);
  }

  sts_value = put_wf_reply(	&put_buffer,
				&put_priority,
				&put_target,
				&put_class,
				&put_type,
				&put_size,
				&wf_form,
				&wf_value,
    				&wf_stale_action,
				&wf_timeout,
				&wf_status,
				&reply_buffer,
				&reply_source,
				&reply_class,
				&reply_type,
				&reply_buffer_size,
				&reply_transfer_size);

  if (sts_value == SS$_NORMAL) {
    printf("\n PUT_WF_REPLY successful");
    printf("\n wf_status = '%d'\n",wf_status);
  }
  else {
    printf("\n PUT_WF_REPLY failure");
    putil_print_sts("PUT_WF_REPLY","Error returned by PUT_WF_REPLY",sts_value);
    printf("\n wf_status = '%d'\n",wf_status);
  }
printf("\n\n++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
}

sts_value = pams_exit();       

}                 


/* 
 * Copyright (C) 1989, All Rights Reserved, by
 * Digital Equipment Corporation, Maynard, Mass.
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice. This software or  any  other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of  the  software  is  hereby
 * transferred.
 *
 * The information in this software is subject to change without  notice
 * and  should  not be  construed  as  a commitment by Digital Equipment
 * Corporation.
 *
 * Digital assumes no responsibility for the use or  reliability  of its
 * software on equipment which is not supplied by Digital.
 *
 */


int put_wf_reply(	put_buffer, put_priority, put_target, put_class,
			put_type, put_size, wf_form, wf_value, wf_stale_action,
			wf_timeout, wf_statu                                                                                                                                                                                                                                                   )                        " $      DMQ020.B                       B  B  "[DMQ$V20.EXAMPLES]PUT_WF_REPLY.C;1                                                                                             P                             j
             s, reply_buffer, reply_source,
			reply_class, reply_type, reply_buffer_size,
			reply_transfer_size)

char		*put_buffer;
char		*put_priority;
PAMS_ADDRESS	*put_target;
short int	*put_class;
short int	*put_type;
short int	*put_size;
short int	*wf_form;
short int	*wf_value;    
short int	*wf_stale_action;
long int	*wf_timeout;
long int	*wf_status;
char		*reply_buffer;
PAMS_ADDRESS	*reply_source;
short int	*reply_class;
short int	*reply_type;
short int	*reply_buffer_size;
short int	*reply_transfer_size;
{

/*

This routine is an example of a generic procedure that is able to conduct
a synchronized messaging dialogue with a server process.  It combines a
pams_put_msg() with a pams_get_msgw() to handle a request/response interaction
from a client program to a server program.  There are occasions when a slow
server response will "miss" the timeout period and the "stale" reply will
be queued to the process after the call completes.  The caller can indicate
an action to be taken when a stale message is detected.
                       
*/

char		delivery;
long		timeout;
struct PSB	psb;
char		uma;
long		resp_que;
int		sts_value;
char		priority;
short		sel_addr[2];
char		msg_area[sizeof(R_STRING)+1];         
PAMS_ADDRESS	source;

  *wf_status = SS$_NORMAL;
  sts_value = SS$_NORMAL;
  delivery = PDEL_MODE_NN_MEM;
  timeout = 0L;
  uma = PDEL_UMA_DISC;
  resp_que = 0L;
  priority = 0;

                                                    
  switch (*wf_form) {

	case 1:
	  sel_addr[0] = put_target->au.process;
  	  sel_addr[1] = put_target->au.group;
	  break;
	case 2:
	  sel_addr[0] = *wf_value;
 	  sel_addr[1] = PSEL_PQ_TYPE;
	  break;
	case 3:
	  sel_addr[0] = *wf_value;
	  sel_addr[1] = PSEL_PQ_CLASS;
	  break;
	case 4:
	  sel_addr[0] = *wf_value;
	  sel_addr[1] = PSEL_AQ;
	  resp_que = *wf_value;
	  break;                         
	default:
	  return(0);
  }

  switch (*wf_stale_action) {

	case FLUSH_STALE:		/* Flush any stale messages */
	  do {

	    printf("\n attempting to flush stale messages");

	    sts_value = pams_get_msg(	&msg_area,
					&priority,
					&source,
					reply_class,
					reply_type,
					reply_buffer_size,
					reply_transfer_size,
					&sel_addr,
					&psb,0,0,0,0,0);

	    if (sts_value == SS$_NORMAL) printf("\n Stale message flushed");
            
	    if (sts_value == PAMS__NOMOREMSG) break;

	  } while $VMS_STATUS_SUCCESS(sts_value);

	  if (sts_value == PAMS__NOMOREMSG) break;
	  else return(sts_value);
	  break;

	case RETURN_STALE:		/* Return any stale messages */
 	  sts_value = pams_get_msg(	reply_buffer,
					&priority,
					reply_source,
					reply_class,
					reply_type,
					reply_buffer_size,
					reply_transfer_size,
					&sel_addr,
					&psb,0,0,0,0,0);

	  if (sts_value == PAMS__NOMOREMSG) break;
	  else {
	    if ($VMS_STATUS_SUCCESS(sts_value)) {
		printf("\n Stale message found");
		*wf_status = 0L;
		return(0);
	    }
	    else return(sts_value);
	  }
	  break;

	case RETURN_NEXT:		/* Return next match */
	  break;
                      
	default:
	  printf("Invalid wf_stale_action = '%d'",wf_stale_action);
	  return(0);
	  break;
  }
                         
  sts_value = pams_put_msg(	put_buffer,
				put_priority,
				put_target,
				put_class,
				put_type,
				&delivery,
				put_size,
				&timeout,
				&psb,
				&uma,
				&resp_que,0,0,0);

  if (sts_value == SS$_NORMAL) {

    printf("\n REQUEST successfully sent");

    sts_value = pams_get_msgw(	reply_buffer,
				&priority,
				reply_source,
				reply_class,
				reply_type,
	    			reply_buffer_size,
				reply_transfer_size,
				wf_timeout,
				&sel_addr,
		    		&psb,0,0,0,0,0);
  }

  if (sts_value == SS$_NORMAL) printf("\n RESPONSE successfully received");

  return(sts_value);
}
                                                                                                                                                                                                                                                                                                                                                                       * [DMQ$V20.EXAMPLES]SBS.DIR;1 +  , B   .     /     4                            - B    0  1    2   3     K  P   W   O     5   6 ޕ  7 ؾ  8          9 Z  G    H  J  I                
AVAILMSGDEF.H  B     AVAIL_EXAMPLE.C  B     BRDCST_EXAMPLE.C B     SBSMSGDEF.H  B     
SBS_EXAMPLE.C  B                                                                                                                                                                                                                                                                                                                                                                                                 % * [DMQ$V20.EXAMPLES.SBS]AVAILMSGDEF.H;1 +  , B   .     /     4 K      	 n                    - B    0   1    2   3      K  P   W   O 
    5   6 cm\  7 es  8          9 Z  G    H  J                          #                                     I /************************************************************************ / *       AVAIL_SERVER Version 2.0          				* ' *	Module: AVAIL_MSG_DEF  					        *  *	File:   AVAILMSGDEF.H						*J *************************************************************************/ #ifndef PAMS_ADDRESS_DEFINED typedef union {  	unsigned long all; 	 	struct {  	   unsigned short process;  	   unsigned short group;  	} au; } PAMS_ADDRESS;   #define PAMS_ADDRESS_DEFINED YES #endif  D /*******************************************************************B *     FORMAT OF   AVAIL REG         #BYTES   	NOTES              *D ********************************************************************+ 	TARGET = registrant                         	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_AVAIL_REG
 	MSG    = "     ==============================A             version                     2       always decimal 20 "     ------------------------------,             target process  PQ          4   "     ------------------------------G             distribution Q              4                               "     ------------------------------ 	EOM */   struct AVAIL_REG {  " 	short	version;		/* always = 20 */ 	PAMS_ADDRESS target_PQ; 	PAMS_ADDRESS distribution_Q;  };D /*******************************************************************D *     FORMAT OF   AVAIL  DEREG        #BYTES   	NOTES              *D ********************************************************************+ 	TARGET = registrant                         	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_AVAIL_DEREG
 	MSG    = "     ==============================A             version                     2       always decimal 20 "     ------------------------------,             target process PQ           4   "     ------------------------------G             distribution Q              4                               "     ------------------------------)             request acknowledgement 	1	   "     ------------------------------ 	EOM */   struct AVAIL_DEREG {  " 	short	version;		/* always = 20 */ 	PAMS_ADDRESS target_PQ;!     	PAMS_ADDRESS distribution_Q; * 	char	req_ack;		/* = 1 if ACK requested */ };  D /*******************************************************************C *     FORMAT OF AVAIL REG REPLY      #BYTES   	NOTES              * D ********************************************************************/ 	TARGET = source of registrant                   	CLASS  = MSG_CLAS_PAMS " 	TYPE   = MSG_TYPE_AVAIL_REG_REPLY
 	MSG    = "     ==============================3       	     status  			2  	status (1=ok,-n=ng)      "     ------------------------------*       	     reg_id  			2  	returned reg id"     ------------------------------K       	     number_reg                 2  	number currently registered for  C     ------------------------------               this mot or target  	EOM */	            struct AVAIL_REG_REPLY {4 	short	 status;	/* returned status (1=ok, -n = ng */6 	unsigned short	reg_id;	/* returned registration id */C 	short	 number_reg;    /* number of registrants left on this mot */  };                    D /*******************************************************************A *     FORMAT OF   AVAIL            #BYTES   	NOTES              * D ********************************************************************5 	TARGET = distribution address                         	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_AVAIL
 	MSG    = "     ==============================,             target process  PQ          4   "                                                                                                                                                                                                    *                        G  $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES.SBS]AVAILMSGDEF.H;1                                                                                          K                              >}                 ------------------------------ 	EOM */   struct AVAIL {   	PAMS_ADDRESS target_PQ; };                D /*******************************************************************C *     FORMAT OF Q_UNAVAIL            #BYTES   	NOTES              * D ********************************************************************5 	TARGET = distribution address                         	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_UNAVAIL
 	MSG    = "     ==============================,             target process PQ           4   "     ------------------------------ 	EOM */   struct UNAVAIL {   	PAMS_ADDRESS target_PQ; };                                                                                                                                                                                                                                                                                                                                                                                                                              ' * [DMQ$V20.EXAMPLES.SBS]AVAIL_EXAMPLE.C;1 +  , B   . (    /     4 e   (   %                   - B    0   1    2   3      K  P   W   O )    5   6 .  7 9ps  8          9 Z  G    H  J                        & #define    AVL_VERSION "AVAIL V2.0-00"
 #ifdef vms" #module    AVL_EXAMPLE AVL_VERSION #endif  O /****************************************************************************** / * Module:    PAMS AVAIL/UNAVAIL Example Program  *  * Filename:  AVAIL_EXAMPLE.C * < * Function:  This program is used to illustrate a method of 9 *            using the AVAIL and UNAVAIL services on PAMS  * 	 * Inputs: 	 *    none  * 
 * Outputs:	 *    none  *  * External Subroutines:  *    PAMS_ATTACH_Q *    PAMS_GET_MSG  *    PAMS_GET_MSGW *    PAMS_PUT_MSG  *  * Language: VAX11-C  * O ******************************************************************************/   
 #ifdef vms /*  system include files  */ #include stdio.h #include ssdef #include stsdef  #include ctype   /*K  PAMS include files                                                          */ #include pams_c_group  #include pams_c_process  #include pams_c_type_class #include pams_c_return_status  #include pams_c_symbol_def #include pams_c_entry_point    #include "sbsmsgdef.h" #include "availmsgdef.h" #endif   #ifdef MSDOS                 /*  system include files  */ #include "stdio.h" #include "ctype.h"   /*K  PAMS include files                                                          */ #include "p_process.h" #include "p_typeclas.h"  #include "p_return.h"  #include "p_symboldef.h" #include "sbsmsgdef.h" #include "availmsgdef.h" #endif* #define ACK_WAIT 300 /* wait 30 seconds */  + char input_line[80]; /* store input line */   
 #ifdef vms static
 int            avail_example(argc, argv)  #else  int  main(argc, argv) #endif	 int argc; 
 char *argv[]; & {                                       8     unsigned long status;   /* status return lognword */
     int i;     int num_of_times; H     long req_process_num;   /* requested proc number for declare call */     typedef union      {          long all;          struct  	         {              short process;             short group;
         } au;      } PAMS_ADDRESS; C     PAMS_ADDRESS new_process_num, target, source, sel_addr;              long size;    <     int loop = 1; /* while (loop) "repeat until loop = 0" */     int aloop = 0;     char prio;     char c;      unsigned short group; $     short class; /* message class */#     short type;  /* message type */ %     short length;/* message length */      short start;       short saved_size;      long ii,put_timeout = 0;,     struct psb psb; /* Pams Status Buffer */@     char uma = PDEL_UMA_DISC; /* undeliverable message action */     long resp_que = 0;,     long int  attach_mode,q_type,q_name_len;     char      q_name[32];        struct showmsg       {          PAMS_ADDRESS target;!         PAMS_ADDRESS orig_target; !         PAMS_ADDRESS orig_source; !         long     sequence_number;          char     delivery;         char     priority;         char     buffer_type;          char     filler[81];     } showmsg;                            unsigned int select = 0;9     char delivery = PDEL_MODE_NN_MEM; /* delivery mode */      unsigned long timeout = 0;     unsigned long timer_id = 0;   &     char *msg_ptr;                       #define USER_BUF_SIZE 32000 B     unsigned char msg_area[USER_BUF_SIZE];   /* output msg area */A     unsigned char rcv_msg_area[USER_BUF_SIZE]; /* rcv msg area */ '     short msg_area_len = USER_BUF_SIZE;   ; /* refer to SBS and AVAIL/UNAVAIL services in PAMS Manual*/ 1 /* for a description of the follwing sructures */ '     struct SBS_REG_REPLY SBS_reg_reply; '     struct SBS_DEREG_ACK SBS_dereg_ack; #     struct AVAIL_REG     AVAIL_reg; %     struct AVAIL_DEREG   AVAIL_dereg;      struct AVAIL         avail;   %     for (i=0; i < USER_BUF_SIZE; i++) <         msg_area[i] = (char)i; /* load msg area with data */            q_type = PSYM_ATTACH_PQ;<     while ((input_line[0] != '1') && (input_line[0] != '2'))     { ]       printf("\nEnter attach mode 1 = PSYM_ATTACH_BY_NUMBER or 2 = PSYM_ATTACH_TEMPORARY> ");        ii = gets(input_line);     }      if (input_line[0] == '2')      { *       attach_mode = PSYM_ATTACH_TEMPORARY;J       status = pams_attach_q (&attach_mode,&new_process_num.all,&q_type,0,'                               0,0,0,0);      }      if (input_line[0] == '1')      { *       attach_mode = PSYM_ATTACH_BY_NUMBER;       input_line[0] = 0;        while (input_line[0] == 0)       { K         printf("\nPlease enter permanent primary q number (no default)> ");          ii = gets(input_line);       } &       q_name_len = strlen(input_line);H       status = pams_attach_q (&attach_mode,&new_process_num.all,&q_type,<                               input_line,&q_name_len,0,0,0);     } 6 /* call function check_ret to check status longword */     if (!check_ret(status))         return(1);     #     if (!new_process_num.au.group)        {2 	printf ("Please enter the local group number: ");( 	scanf("%hd",&new_process_num.au.group);      }  7     printf("\npams_attach_q new process is '%d.%d'\n",  >         new_process_num.au.group, new_process_num.au.process);  X     printf("Enter PAMS' group of PAMS_AVAIL_SERVER to exercise (0=local, n=other) [%d] " 	, new_process_num.au.group); E     if (read_input() > 0) /* call read_input function to get input */ G         sscanf(input_line, "%hd", &group); /* scan input line buffer */      else)         group = new_process_num.au.group;   ,     while (loop) /* repeat until loop = 0 */      {>         printf("\n\n PAMS AVAIL Example (%s)\n", AVL_VERSION);&         printf("DUMP TABLES     (1)");.         printf("      PAMS_GET_MSG    (2)\n");B         printf("AVAIL_REG       (3)      AVAIL_DEREG      (4)\n");)         printf("EXIT            (99)\n");                          9         printf("\n\nPlease enter selection (1->4, 99) ");          if (read_input() > 0) E             select = atoi(input_line); /* convert ascii to integer */ (         else                                         continue; A                                                                            switch (select) 
          {  	                    case 1:   .             printf("\nDUMP TABLES REQUEST\n");             size = 0;              prio = 0; %             target.au.group  = group; 0             target.au.process = PAMS_SBS_SERVER;,             type = MSG_TYPE_SBS_DUMP_TABLES;"             class = MSG_CLAS_PAMS;,             status = pams_put_msg(msg_area, +                         &prio, &target.all, 8                         &class, &type, &delivery, &size,( 			&put_timeout, &psb, &uma, &resp_que);#             if (check_ret(status))                {1 		printf("SBS Tables can be found in SBS Log\n");  		printf("Use DCL Command\n");3 		printf("$TYPE DMQ$LOG:DMQ$SBS_bbbb_ggggg.LOG\n"); @ 		printf(" where: bbbb is BUS Id and ggggg is the VMS Group\n"); 	     }              break;                       case 2:   '             printf("\nPAMS_GET_MSG\n");              prio = 0;              sel_addr.all = 0; &     	    msg_area_len = USER_BUF_SIZE;1             status = pams_get_msg (&rcv_msg_area, +                         &p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  +                         $      DMQ020.B                       B  B  '[DMQ$V20.EXAMPLES.SBS]AVAIL_EXAMPLE.C;1                                                                                        e    (                          "            rio, &source.all, 5                         &class, &type, &msg_area_len,                           &length,-                         &sel_addr.all, &psb); +             if (status == PAMS__NOMOREMSG)   	     { .                 printf("Input Queue Empty\n");                 break;              }"             if(!check_ret(status))                 break;? 	    if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_AVAIL))   	     { : 		    memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));<                     printf("Process '%d.%d' is Available\n",0                       avail.target_PQ.au.group, 8 		      avail.target_PQ.au.process);                     	     } F 	    else if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_UNAVAIL))  	          {: 		    memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));>                     printf("Process '%d.%d' is UnAvailable\n",0                       avail.target_PQ.au.group, $ 		      avail.target_PQ.au.process);
 	          }                    else 
 	          {  1                     printf("source = '%d.%d'\n",  8                     source.au.group, source.au.process);6                     printf("class  = '%d'\n", class );6                     printf("type   = '%d'\n", type  );6                     printf("length = '%d'\n", length);*                     printf("User Data\n");    	            if ( length > 100 )! 	             start = length-100;                      else 	             start = 0;  /                     for (i=start; i<length;i++) B                      printf("<%d>x%x(%c) %c", i, rcv_msg_area[i], T                                       isprint(rcv_msg_area[i])? rcv_msg_area[i]:'.',<                                       (i+1)%11 ? ' ': '\n'); 	          }             break;               case  3:  $             printf("\nAVAIL_REG\n");#             AVAIL_reg.version = 20; R             printf("Enter Target Group (0->32000)[%d] ",new_process_num.au.group);  "             if (read_input() > 0) I                 sscanf(input_line, "%hd", &AVAIL_reg.target_PQ.au.group); '             else                        M                 AVAIL_reg.target_PQ.au.group = new_process_num.au.group;        V             printf("Enter Target Q Address (0->999)[%d] ",new_process_num.au.process);  "             if (read_input() > 0) K                 sscanf(input_line, "%hd", &AVAIL_reg.target_PQ.au.process); '             else                        L                 AVAIL_reg.target_PQ.au.process = new_process_num.au.process; 	     I             AVAIL_reg.distribution_Q.au.group = new_process_num.au.group; Q             printf("Enter distribution_Q (PAMS Process Q) [My PAMS PQ id '%d'] ", ,                 new_process_num.au.process);  1             if (read_input() > 0)                 P                 sscanf(input_line, "%hd", &AVAIL_reg.distribution_Q.au.process);'             else                        C                 AVAIL_reg.distribution_Q.all = new_process_num.all;                prio = 0; %             target.au.group  = group; 2             target.au.process = PAMS_AVAIL_SERVER;&             type = MSG_TYPE_AVAIL_REG;2             class = MSG_CLAS_PAMS;                -             size = sizeof (struct AVAIL_REG);*-             status = pams_put_msg(&AVAIL_reg,r+                         &prio, &target.all, 8                         &class, &type, &delivery, &size,( 			&put_timeout, &psb, &uma, &resp_que);  #             if (check_ret(status))  ,             {   /* always wait for an ACK */                   aloop = 1;                 while ( aloop )                  { 0                    printf("Wait for an ACK \n");8                    size = sizeof (struct SBS_REG_REPLY); 		   timeout = ACK_WAIT;
 #ifdef VAXELNs 		   sel_addr.all = 0; #elseu 		   sel_addr.au.group = group;u0 	   	   sel_addr.au.process = PAMS_AVAIL_SERVER; #endif9                    status = pams_get_msgw(&SBS_reg_reply,i;                         &prio, &source.all, &class, &type, _E                         &size, &size, &timeout, &sel_addr.all, &psb);f1                    if ( status == PAMS__TIMEOUT )e                    {I                       printf ("\nReply took too long. Wait again? Y/N "); .                       if ( read_input () > 0 )                       { >                          if (input_line[0] == 'Y' ) aloop = 1;>                          if (input_line[0] == 'y' ) aloop = 1;>                          if (input_line[0] == 'N' ) aloop = 0;>                          if (input_line[0] == 'n' ) aloop = 0;                       }                       }                    else                        break;                 }   5                 if ( status == PAMS__TIMEOUT ) break;]  F                 if (check_ret(status) && (SBS_reg_reply.status == 1))                  {gR                     printf("AVAIL Registration is o.k.\nNumber of Regs is '%d'\n",0                       SBS_reg_reply.number_reg);                 } W 		else                                                                                                   {u>                     printf("AVAIL Registration failed '%d'\n",,                       SBS_reg_reply.status);                       break;                 }n  6                 printf("Wait for an AVAIL/UNAVAIL\n");-                 size = sizeof (struct AVAIL);  		timeout = ACK_WAIT; 
 #ifdef VAXELNy 		sel_addr.all = 0;* #else  		sel_addr.au.group = group;- 	   	sel_addr.au.process = PAMS_AVAIL_SERVER;  #endif.                 status = pams_get_msgw(&avail,;                         &prio, &source.all, &class, &type, vE                         &size, &size, &timeout, &sel_addr.all, &psb);m  '                 if (check_ret(status)) e                  {> 		  if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_AVAIL)) <                     printf("Process '%d.%d' is Available\n",L                       avail.target_PQ.au.group, avail.target_PQ.au.process);E 		  else if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_UNAVAIL))  >                     printf("Process '%d.%d' is UnAvailable\n",L                       avail.target_PQ.au.group, avail.target_PQ.au.process); 		 } i                 else d                  {& 		    printf("PAMS_GET_MSGW error\n"); 		 }
             }F             break;	                    case  4:  &             printf("\nAVAIL_DEREG\n");%             AVAIL_dereg.version = 20; R             printf("Enter Target Group (0->32000)[%d] ",new_process_num.au.group);  "             if (read_input() > 0) K                 sscanf(input_line, "%hd", &AVAIL_dereg.target_PQ.au.group);Y'             else                       KO                 AVAIL_dereg.target_PQ.au.group = new_process_num.au.group;     A  X             printf("Enter Target Q Address (0->999)[%d] ", new_process_num.au.process );  "             if (read_input() > 0) M                 sscanf(input_line, "%hd", &AVAIL_dereg.target_PQ.au.process);i'             else                        P                 AVAIL_dereg.target_PQ.au.process = new_process_num.au.process;    K             AVAIL_dereg.distribution_Q.au.group = new_process_num.au.group;0Q             printf("Enter distribution_Q (PAMS Process Q) [My PAMS PQ id '%d'] ",_,                 new_process_num.au.process);  "             if (read_input() > 0) R                 sscanf(input_line, "%hd", &AVAIL_dereg.distribution_Q.au.process);'             else                        S                 AVAIL_dereg.distribution_Q.au.process = new_process_num.au.process;a  0             printf("Enter req_ack (Y, N) [Y] ");  "             if (read_input() > 0) 
             {r-                 sscanf(input_line, "%c", &c);((                 AVAIL_dereg.req_ack = 1;+                 if ((c=='N') || (c == 'n'))_,                     AVAIL_dereg.req_ack = 0;             } '             else                       a(                 AVAIL_dereg.req_ack = 1;               prio = 0; %             target.au.group  = group;c2             target.au.process = PAMS_AVAIL_SERVER;(             type = MSG_TYPE_AVAIL_DEREG;"             class = MSG_CLAS_PAMS;/             size = sizeof (struct AVAIL_DEREG);u0             status = pams_put_msg(&AVAIL_dereg, +                         &prio, &target.all,h8                         &class, &type, &delivery, &size,( 			&put_timeout, &psb, &uma, &resp_que);  A             if (check_ret(status) && (AVAIL_dereg.req_ack == 1)) p0              {   /* should we wait for an ACK */-                 printf("Wait for an ACK \n");e5                 size = sizeof (struct SBS_DEREG_ACK);M 		timeout = ACK_WAIT;,
 #ifdef VAXELN  		sel_addr.all = 0;T #else  		sel_addr.au.group = grou                                                                                                                                                                                                                                                   ,                        -c $      DMQ020.B                       B  B  '[DMQ$V20.EXAMPLES.SBS]AVAIL_EXAMPLE.C;1                                                                                        e    (                         R              p;- 	   	sel_addr.au.process = PAMS_AVAIL_SERVER;I #endif6                 status = pams_get_msgw(&SBS_dereg_ack,;                         &prio, &source.all, &class, &type,  E                         &size, &size, &timeout, &sel_addr.all, &psb);p  F                 if (check_ret(status) && (SBS_dereg_ack.status == 1))                   {T                     printf("AVAIL DeRegistration is o.k.\nNumber of Regs is '%d'\n",0                       SBS_dereg_ack.number_reg);                  }e                 else                                                                                 e@                     printf("AVAIL Deregistration failed '%d'\n",,                       SBS_dereg_ack.status); 	     } /* end wait for ack */             break;           case 99:  2             loop = 0;  /* get out of while loop */=             printf("\n\n     PAMS AVAIL Example Complete\n");              break;         default:5             printf("Invalid selection Try Again!"); 5             break;                                   	        } /* end switch */o     } /* end while */            exit(1); } /* end main*/f  @ /***************************************************************@     check_ret - checks the return code for success             *@                                                                *@     returns:                                                   *@         0 = an error                                           *@         1 = o.k.                                               *A ****************************************************************/  static int  check_ret(sts_value) {      int desc[2];     char str[256];     short len;     int i,j;                                  #ifdef vms       desc[0] = sizeof (str);;     desc[1] = str;#     if (sts_value & STS$M_SUCCESS) !         return (1); E     i = sys$getmsg(sts_value, &len, &desc[0], 15, &j);               _(     str[len] = 0;  /* null out string */?     printf("PAMS ERROR RETURNED '0x%x'\n'%s'", sts_value, str);r     return(0);       s #elseb     if (sts_value > 0) 	return(1);a	     else g     { 5 	pams_print_sts("AVAIL_EXAMPLE", "ERROR", sts_value);  	return(0);      }  #endif) }                                        N  @ /***************************************************************@     read_input  - reads an input line into global 'input_line' *@                                                                *@     returns:                                                   *@         0 = an error                                           *@         n = # of char read                                     *A ****************************************************************/  static intr read_input() {d  
     char *cp;   H     cp = gets(input_line); /* call gets function to get input from TT */  5     if (cp == NULL) /* if no characters were input */ (         return(0);  /* return 0 value */     elseA         return(strlen(input_line)); /* return length of string */a } length;i++) B                     ( * [DMQ$V20.EXAMPLES.SBS]BRDCST_EXAMPLE.C;1 +  , B   . H    /     4    H   H Z                  - B    0   1    2   3      K  P   W   O I    5   6  0  7 }s  8          9 Z  G    H  J                         #define    VERSION "DMQ V2.0-00"
 #ifdef vms! #module    BRDCST_EXAMPLE VERSION  #endif  O /****************************************************************************** / * Module:    PAMS SBS Broadcast Example Program  *  * Filename:  BRDCST_EXAMPLE.C  * < * Function:  This program is used to illustrate a method of 7 *            using Selective Broadcast Services on PAMS  * 	 * Inputs: 	 *    none  * 
 * Outputs:	 *    none  *  * External Subroutines:  *    PAMS_GET_MSG  *    PAMS_GET_MSGW *    PAMS_PUT_MSG  *  * Language: VAX11-C  *  * Functions: * = * sscanf -  This "C" function scans the buffer input_line and @ *           loads the program variable specified in the function5 *           parameter list with data from the buffer.  * A * check_ret -  This user written function checks the value of the H *              status longword returned from a PAMS call.  This function% *              also calls sys$getmsg.  * B * read_input - This user written function allows the user to inputC *              data into the program and it is stored in the buffer A *              input_line.  This function returns either 0 or the 3 *              length of the string that was input.  *               O ******************************************************************************/   
 #ifdef vms /*  system include files  */ #include stdio.h #include ssdef #include stsdef  #include ctype   /*K  PAMS include files                                                          */ #include pams_c_group  #include pams_c_process  #include pams_c_type_class #include pams_c_return_status  #include pams_c_symbol_def #include pams_c_entry_point    #include "sbsmsgdef.h" #include "availmsgdef.h"   #endif   #ifdef MSDOS                 /*  system include files  */ #include "stdio.h" #include "ctype.h"   /*K  PAMS include files                                                          */ #include "p_process.h" #include "p_typeclas.h"  #include "p_return.h"  #include "p_symboldef.h" #include "sbsmsgdef.h" #include "availmsgdef.h" #endif* #define ACK_WAIT 300 /* wait 30 seconds */  0 char input_line[80]; /* stores the input line */  
 #ifdef vms static
 int            broadcast_example(argc, argv)  #else  int  main(argc, argv) #endif	 int argc; 
 char *argv[]; & {                                       7     unsigned long status;  /* return status longword */ 
     int i;     int num_of_times; 7     long req_process_num;  /* request process number */ /     long int attach_mode , q_type , q_name_len;      static char q_name[32];      typedef union      {          long all;          struct  	         {              short process;             short group;
         } au;      } PAMS_ADDRESS; C     PAMS_ADDRESS new_process_num, target, source, sel_addr;              long size;    '     int loop = 1; /* While loop flag */      int aloop = 0;     char prio;     char c;      unsigned short group; $     short class; /* message class */#     short type;  /* message type */ &     short length; /* message length */     short start;     short saved_size;      long put_timeout = 0; ,     struct psb psb; /* Pams Status Buffer */@     char uma = PDEL_UMA_DISC; /* undeliverable message action */     long resp_que = 0;       struct showmsg       {          PAMS_ADDRESS target;!         PAMS_ADDRESS orig_target; !         PAMS_ADDRESS orig_source; !         long     sequence_number;          char     delivery;         char     priority;         char     buffer_type;          char     filler[81];     } showmsg;                            unsigned int select = 0;L     char delivery = PDEL_MODE_NN_MEM; /* delivery mode */                   !     unsigned long ii,timeout = 0;      unsigned long timer_id = 0;   &     char *msg_ptr;                       #define USER_BUF_SIZE 32000 D     unsigned char msg_area[USER_BUF_SIZE]; /* output message area */J     unsigned char rcv_msg_area[USER_BUF_SIZE];  /* receive message area */9     short msg_area_len = USER_BUF_SIZE; /* area length */   - /* refer to SBS chapter in VAX PAMS manual */ 3 /* for a dexcription of the following structures */ !     struct SBS_REG_EZ SBS_reg_ez; '     struct SBS_REG_REPLY SBS_reg_reply;      struct SBS_REG SBS_reg; &     struct SMC_DEREG SMC_dereg;       &     struct SBS_DEREG SBS_dereg;       '     struct SBS_DEREG_ACK SBS_dereg_ack; &     struct SBS_PURGE SBS_purge;       '     struct SBS_PURGE_ACK SBS_purge_ack; '     struct SBS_BS_SEQGAP SBS_bs_seqgap;   D /* refer to AVAIL/UNAVAIL services, CHapter 6, in VAX PAMS manual */#     struct AVAIL_REG     AVAIL_reg; %     struct AVAIL_DEREG   AVAIL_dereg;      struct AVAIL         avail;   J     for (i=0; i < USER_BUF_SIZE; i++) /* fill output msg area with data */         msg_area[i] = (char)i;       q_type = PSYM_ATTACH_PQ;<     while ((input_line[0] != '1') && (input_line[0] != '2'))     { ]       printf("\nEnter attach mode 1 = PSYM_ATTACH_BY_NUMBER or 2 = PSYM_ATTACH_TEMPORARY> ");        ii = gets(input_line);     }      if (input_line[0] == '2')      {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   -                        LlF $      DMQ020.B                       B  B  ([DMQ$V20.EXAMPLES.SBS]BRDCST_EXAMPLE.C;1                                                                                           H                         R "            *       attach_mode = PSYM_ATTACH_TEMPORARY;J       status = pams_attach_q (&attach_mode,&new_process_num.all,&q_type,0,'                               0,0,0,0);      }      if (input_line[0] == '1')      { *       attach_mode = PSYM_ATTACH_BY_NUMBER;       input_line[0] = 0;        while (input_line[0] == 0)       { K         printf("\nPlease enter permanent primary q number (no default)> ");          ii = gets(input_line);       } &       q_name_len = strlen(input_line);H       status = pams_attach_q (&attach_mode,&new_process_num.all,&q_type,<                               input_line,&q_name_len,0,0,0);     } I     if (!check_ret(status)) /* call check_ret function to check status */         return(1);     #     if (!new_process_num.au.group)        {2 	printf ("Please enter the local group number: ");( 	scanf("%hd",&new_process_num.au.group);      }  7     printf("\npams_attach_q new process is '%d.%d'\n",  >         new_process_num.au.group, new_process_num.au.process);  Q     printf("Enter PAMS' group of SBS_SERVER to exercise (0=local, n=other) [%d] "  	, new_process_num.au.group);   I     if (read_input() > 0) /* call read_input function to get input line*/ @         sscanf(input_line, "%hd", &group); /* scan input line */     else)         group = new_process_num.au.group;   ,     while (loop) /* repeat until loop = 0 */      {8         printf("\n\n PAMS SBS Example (%s)\n", VERSION);C         printf("REGISTRATION_EZ (1)      REGISTRATION      (2)\n"); C         printf("DEREGISTRATION  (3)      PURGE             (4)\n"); C         printf("DUMP TABLES     (5)      BROADCAST MSG     (6)\n"); C         printf("PAMS_GET_MSG    (7)      PAMS_GET_MSGW     (8)\n"); )         printf("EXIT            (99)\n");                          9         printf("\n\nPlease enter selection (1->9, 99) ");   N         if (read_input() > 0) /* call read_input function to get input line */E             select = atoi(input_line); /* convert ascii to integer */ (         else                                         continue; A                                                                            switch (select) 
          {             case 1:     2             printf("\nREGISTRATION_EZ REQUEST\n");$             SBS_reg_ez.version = 20;6             printf("Enter Mot_Q (4800->5200)[4800] ");  @             if (read_input() > 0) /* call read_input function */N                 sscanf(input_line, "%hd", &SBS_reg_ez.MOT_Q); /* scan input */'             else                        G                 SBS_reg_ez.MOT_Q = 4800;  /* set MOT.Q field to 4800 */   <             printf("Enter group # of distribution_Q: [%d] ",G                     new_process_num.au.group); /* input group number */   "             if (read_input() > 0) O                 sscanf(input_line, "%hd", &SBS_reg_ez.distribution_Q.au.group); '             else                        N                 SBS_reg_ez.distribution_Q.au.group = new_process_num.au.group;  Z             printf("Enter Q number of distribution_Q (PAMS Process Q) [My PAMS id '%d'] ",;                 new_process_num.au.process); /* Q number */   @             if (read_input() > 0) /* call read_input function */Q                 sscanf(input_line, "%hd", &SBS_reg_ez.distribution_Q.au.process); '             else                        R                 SBS_reg_ez.distribution_Q.au.process = new_process_num.au.process;  >             type = MSG_TYPE_SBS_REG_EZ; /* SBS registration */$             prio = 0; /* priority */<             target.au.group  = group; /* set target group */I             target.au.process = PAMS_SBS_SERVER; /* set target process */ I             class = MSG_CLAS_PAMS;  /* set message class */               J             size = sizeof (struct SBS_REG_EZ); /* get size of structure */ /* call pams PUT */ 0             status = pams_put_msg(&SBS_reg_ez,  +                         &prio, &target.all, 8                         &class, &type, &delivery, &size,7 			               &put_timeout, &psb, &uma, &resp_que);   @             if (check_ret(status)) /* call check_ret function */,             {   /* always wait for an ACK */-                 printf("Wait for an ACK \n"); N                 size = sizeof (struct SBS_REG_REPLY); /* get size of structure */ 		          timeout = ACK_WAIT; 
 #ifdef VAXELN  		          sel_addr.all = 0;  #else F 		          sel_addr.au.group = group; /* select filter group and PN*/5      		       sel_addr.au.process = PAMS_SBS_SERVER;   #endif6                 status = pams_get_msgw(&SBS_reg_reply,;                         &prio, &source.all, &class, &type,  E                         &size, &size, &timeout, &sel_addr.all, &psb);              B 		          if (check_ret(status) && (SBS_reg_reply.status == 1))                   {h                     printf("Registration_EZ is o.k.\nRegistration id is '%d'\nNumber of Regs is '%d'\n",F                       SBS_reg_reply.reg_id, SBS_reg_reply.number_reg);                  }  e                 else                                                                                  ;                     printf("Registration_EZ failed '%d'\n",l,                       SBS_reg_reply.status);               }*              break;*	          *             case 2:     0              printf("\nREGISTRATION REQUEST\n");"              SBS_reg.version = 20;I              printf("Enter Mot_Q (4800->5200)[4800] "); /* input MOT_Q */   A              if (read_input() > 0) /* call read_input function */nQ                 sscanf(input_line, "%hd", &SBS_reg.MOT_Q); /* scan input buffer*/ -              else                            g*                 SBS_reg.MOT_Q = 4800;       =              printf("Enter group # of distribution_Q: [%d] ", .                     new_process_num.au.group);  E              if (read_input() > 0) /* call read_input to get input */hO                 sscanf(input_line, "%hd", &SBS_reg_ez.distribution_Q.au.group);a(              else                       N                 SBS_reg_ez.distribution_Q.au.group = new_process_num.au.group;  [              printf("Enter Q number of distribution_Q (PAMS Process Q) [My PAMS id '%d'] ",o?                 new_process_num.au.process); /* get Q number */u  K              if (read_input() > 0)          /* call read_input function */  Q                 sscanf(input_line, "%hd", &SBS_reg_ez.distribution_Q.au.process);*(              else                       R                 SBS_reg_ez.distribution_Q.au.process = new_process_num.au.process;  T              printf("Enter offset (+n, %d=ANY, %d=class, %d=type, %d=source) [%d] ", 		          PSEL_OPER_ANY, u                 PSEL_CLASS,                  PSEL_TYPE, m                 PSEL_SOURCE, m                 PSEL_CLASS);  J              if (read_input() > 0) /* call read_input function to input */;                 sscanf(input_line, "%hd", &SBS_reg.offset);/(              else                       ,                 SBS_reg.offset = PSEL_CLASS;              printf("Enter operator (%d=Any, %d=equal, %d=Not_equal, %d=greater, %d=less, %d=greater_equal, %d=less_equal [%d] ",b$                      PSEL_OPER_ANY, #                      PSEL_OPER_EQ,  $                      PSEL_OPER_NEQ, $                      PSEL_OPER_GTR, #                      PSEL_OPER_LT,  %                      PSEL_OPER_GTRE, v$                      PSEL_OPER_LTE, #                      PSEL_OPER_EQ);   M              if (read_input() > 0) /* call read_input function to get input*/ =                 sscanf(input_line, "%hd", &SBS_reg.operator);p(              else                       0                 SBS_reg.operator = PSEL_OPER_EQ;)              printf("Enter length [0] ");   E              if (read_input() > 0) /* call read_input to get input */ ;                 sscanf(input_line, "%hd", &SBS_reg.length); (              else                       #                 SBS_reg.length = 0;r;              printf("Enter operand [0] ");                 o  F              if (read_input() > 0) /* call read_input to input line */;                 sscanf(input_line, "%d", &SBS_reg.operand);r(              else                       $                 SBS_reg.operand = 0;1              printf("Enter req_ack (Y, N) [Y] ");t  E              if (read_input() > 0) /* call read_input to get input */_               {     -                 sscanf(input_line, "%c", &c); $                 SBS_reg.req_ack = 1;+                 if ((c=='N') || (c == 'n'))o(                     SBS_reg.req_ack = 0;               }               elseb$                 SBS_reg.req_ack = 1;G              printf("Enter req_sequence gap notification (Y, N) [Y] ");f                                                                                                                                                                                                                                                   .                        Up $      DMQ020.B                       B  B  ([DMQ$V20.EXAMPLES.SBS]BRDCST_EXAMPLE.C;1                                                                                           H                         4 "              E              if (read_input() > 0) /* call read_input to get input */c               {dE                 sscanf(input_line, "%c", &c); /* scan input buffer */ '                 SBS_reg.req_seqgap = 1;n+                 if ((c=='N') || (c == 'n')) +                     SBS_reg.req_seqgap = 0;2               } (              else                       '                 SBS_reg.req_seqgap = 1;_e              printf("Enter req_autodereg automatic deregistration on distribution exit (Y, N) [Y] ");h  J              if (read_input() > 0) /* call read_input to get input line */               {t=                 sscanf(input_line, "%c", &c); /* scan line */S*                 SBS_reg.req_autodereg = 1;+                 if ((c=='N') || (c == 'n')) .                     SBS_reg.req_autodereg = 0;               } (              else                       *                 SBS_reg.req_autodereg = 1;              prio = 0;H              target.au.group  = group;            /* set target group */J              target.au.process = PAMS_SBS_SERVER; /* set target process */D              type = MSG_TYPE_SBS_REG;         /* set message type */E              class = MSG_CLAS_PAMS;           /* set message class */dH              size = sizeof (struct SBS_REG); /* set size of structure */,              status = pams_put_msg(&SBS_reg,+                         &prio, &target.all,t8                         &class, &type, &delivery, &size,7 			               &put_timeout, &psb, &uma, &resp_que);f>              if (check_ret(status) && (SBS_reg.req_ack == 1)) 1               {   /* should we wait for an ACK */_-                 printf("Wait for an ACK \n"); N                 size = sizeof (struct SBS_REG_REPLY); /* get size of struct */I 		          timeout = ACK_WAIT;                   /* set timeout value */ 
 #ifdef VAXELNn 		          sel_addr.all = 0;r #elsenE 		          sel_addr.au.group = group;         /* set select group */=E 		          sel_addr.au.process = PAMS_SBS_SERVER;/* set select PN */  #endif6                 status = pams_get_msgw(&SBS_reg_reply,;                         &prio, &source.all, &class, &type, 0E                         &size, &size, &timeout, &sel_addr.all, &psb);t  F                 if (check_ret(status) && (SBS_reg_reply.status == 1))                   {e                     printf("Registration is o.k.\nRegistration id is '%d'\nNumber of Regs is '%d'\n", F                       SBS_reg_reply.reg_id, SBS_reg_reply.number_reg);                  }e                 else                                                                                 [8                     printf("Registration failed '%d'\n",,                       SBS_reg_reply.status);               }               break;,	          o/             case 3:                            u  2              printf("\nDEREGISTRATION REQUEST\n");V 	          printf("DeRegister by Mot/distribution or by Registration id (M, R) [M] ");  E              if (read_input() > 0) /* call read_input to get input */                {EN                 sscanf(input_line, "%c", &c);  /* load variable c with data */-                 if ((c !='M') && (c != 'm'))                    {  ( 		 /************************************( 		 * deregister by registration id     *( 		 ************************************/  (             	    SMC_dereg.version = 10;5             	    printf("Enter req_ack (Y, N) [Y] ");n  H                     if (read_input() > 0) /* call read_input function */                      {K                         sscanf(input_line, "%c", &c); /* load variable c */ K                         SMC_dereg.req_ack = 1;      /* set req_ack field */t4                         if ((c =='N') || (c == 'n'))I                             SMC_dereg.req_ack = 0; /* set reqack field */;                      } e/                     else                       (E                         SMC_dereg.req_ack = 1; /*set req_ack field */f9                     printf("Enter registration id [?] ");   L                     if (read_input() > 0) /* call read_input to get input */E                         sscanf(input_line, "%hd", &SMC_dereg.reg_id);f/                     else                       _6                         break; /* continue */         @                     prio = 0;                 /* set priority */D                     target.au.group  = group; /* set target group */L                     target.au.process = PAMS_SBS_SERVER; /* set target PN */L                     type = MSG_TYPE_MOT_DEREG;        /* set message type */N                     class = MSG_CLAS_PAMS;           /* set message class */  O                     size = sizeof (struct SMC_DEREG);/* set size of structure*/o6                     status = pams_put_msg(&SMC_dereg, +                         &prio, &target.all, 8                         &class, &type, &delivery, &size,7 			               &put_timeout, &psb, &uma, &resp_que);   G                     if (check_ret(status) && (SMC_dereg.req_ack == 1))  8                      {   /* should we wait for an ACK */4                        printf("Wait for an ACK \n");N                        size = sizeof (struct SBS_DEREG_ACK);/*size of struct*/K 		                 timeout = ACK_WAIT;              /* set timeout value */r
 #ifdef VAXELN;$ 		                 sel_addr.all = 0; #elseTG 		                 sel_addr.au.group = group;    /* set select group */ I 		                 sel_addr.au.process = PAMS_SBS_SERVER; /* select PN */y #endif=                        status = pams_get_msgw(&SBS_dereg_ack, C                                 &prio, &source.all, &class, &type,  M                                 &size, &size, &timeout, &sel_addr.all, &psb);   M                        if (check_ret(status) && (SBS_dereg_ack.status == 1)) c                         {uV                             printf("DeRegistration is o.k.\nNumber of Regs is '%d'\n",6                             SBS_dereg_ack.number_reg);                         } l                        else                                                                                 B                             printf("Deregistration failed '%d'\n",6                                 SBS_dereg_ack.status); 		    } /* end wait for ack */ 		    break; 		}/* end dereg by id */%             } /* end read_input if */ + 	    /*************************************o+ 	     * deregister by mot/distribution    * , 	     *************************************/#             SBS_dereg.version = 20; H             printf("Enter Mot_Q (4800->5200)[4800] "); /* enter MOT Q */  M             if (read_input() > 0) /* call read_input function to get input */aL                 sscanf(input_line, "%hd", &SBS_dereg.MOT_Q); /* load data */'             else                        '                 SBS_dereg.MOT_Q = 4800;\  A             printf("Enter Group Number of Distribution Q: [%d] ", G                     new_process_num.au.group); /* enter group number */   @             if (read_input() > 0) /* call read_input function */N                 sscanf(input_line, "%hd", &SBS_dereg.distribution_Q.au.group);'             else                        M                 SBS_dereg.distribution_Q.au.group = new_process_num.au.group;r      #]             printf("Enter Q number of distribution_Q (PAMS Process Q) [My PAMS PQ id '%d'] ", G                 new_process_num.au.process); /* enter process number */s  @             if (read_input() > 0) /* call read_input function */P                 sscanf(input_line, "%hd", &SBS_dereg.distribution_Q.au.process);'             else                        Q                 SBS_dereg.distribution_Q.au.process = new_process_num.au.process;]  0             printf("Enter req_ack (Y, N) [Y] ");  D             if (read_input() > 0) /* call read_input to get input */              {M                 sscanf(input_line, "%c", &c); /* load data into variable c */Q>                 SBS_dereg.req_ack = 1; /* set req_ack field */+                 if ((c=='N') || (c == 'n'))s*                     SBS_dereg.req_ack = 0;              } o'             else                       s>                 SBS_dereg.req_ack = 1; /* set req_ack field */A             prio = 0;                  /* set priority to zero */C=             target.au.group  = group;  /* set target group */uD             target.au.process = PAMS_SBS_SERVER; /* set target PN */F             type = MSG_TYPE_SBS_DEREG;          /* set message type */F             class = MSG_CLAS_PAMS;             /* set message class */I             size = sizeof (struct SBS_DEREG); /* set size of structure */ .             status = pams_put_msg(&SBS_dereg, +                                                                                                                                                                                                                                                            /                        4l $      DMQ020.B                       B  B  ([DMQ$V20.EXAMPLES.SBS]BRDCST_EXAMPLE.C;1                                                                                           H                         ! "     -                       &prio, &target.all, 8                         &class, &type, &delivery, &size,7 			               &put_timeout, &psb, &uma, &resp_que); ?             if (check_ret(status) && (SBS_dereg.req_ack == 1))  0              {   /* should we wait for an ACK */-                 printf("Wait for an ACK \n");nN                 size = sizeof (struct SBS_DEREG_ACK); /* get size of struct */8 		          timeout = ACK_WAIT;  /* set Timeout value */
 #ifdef VAXELN  		          sel_addr.all = 0;. #elserD 		          sel_addr.au.group = group; /* set select filter group */A 		          sel_addr.au.process = PAMS_SBS_SERVER; /* Q number */  #endif6                 status = pams_get_msgw(&SBS_dereg_ack,;                         &prio, &source.all, &class, &type, .E                         &size, &size, &timeout, &sel_addr.all, &psb); F                 if (check_ret(status) && (SBS_dereg_ack.status == 1))                   {N                     printf("DeRegistration is o.k.\nNumber of Regs is '%d'\n",0                       SBS_dereg_ack.number_reg);                  } te                 else                                                                                  :                     printf("Deregistration failed '%d'\n",,                       SBS_dereg_ack.status); 	     } /* end wait for ack */             break;	                    case 4:             (             printf("\nPURGE REQUEST\n");#             SBS_purge.version = 10; 0             printf("Enter req_ack (Y, N) [Y] ");  D             if (read_input() > 0) /* call read_input to get input */              {L                 sscanf(input_line, "%c", &c); /* load data into variable c*/D                 SBS_purge.req_ack = 1;       /* set req_ack field */+                 if ((c=='N') || (c == 'n')) *                     SBS_purge.req_ack = 0;              } e'             else                        G                 SBS_purge.req_ack = 1;          /* set req_ack field */mB             prio = 0;                           /* set priority */F             target.au.group  = group;           /* set target group */D             target.au.process = PAMS_SBS_SERVER; /* set target PN */F             type = MSG_TYPE_SBS_PURGE;          /* set message type */G             class = MSG_CLAS_PAMS;              /* set message class */ H             size = sizeof (struct SBS_PURGE);   /* set size of struct */-             status = pams_put_msg(&SBS_purge, +                         &prio, &target.all, 8                         &class, &type, &delivery, &size,7 			               &put_timeout, &psb, &uma, &resp_que); ?             if (check_ret(status) && (SBS_purge.req_ack == 1))  0              {   /* should we wait for an ACK */-                 printf("Wait for an ACK \n");(N                 size = sizeof (struct SBS_PURGE_ACK); /* get size of struct */B 		          timeout = ACK_WAIT;                /* set tmo value */
 #ifdef VAXELNc 		          sel_addr.all = 0;  #else = 		          sel_addr.au.group = group; /* set select group */iB 		          sel_addr.au.process = PAMS_SBS_SERVER;  /* Q number */ #endif6                 status = pams_get_msgw(&SBS_purge_ack,;                         &prio, &source.all, &class, &type, EE                         &size, &size, &timeout, &sel_addr.all, &psb); F                 if (check_ret(status) && (SBS_purge_ack.status == 1))                   {.                     printf("Purge is o.k.\n");                  } pe                 else                                                                                 t1                     printf("Purge failed '%d'\n", ,                       SBS_purge_ack.status);              }             break;	          t         case 5:&  .             printf("\nDUMP TABLES REQUEST\n");@             size = 0;                        /* set size to 0 */D             prio = 0;                        /* set priority to 0 */C             target.au.group  = group;        /* set target group */eI             target.au.process = PAMS_SBS_SERVER;/* set target Q number */ C             type = MSG_TYPE_SBS_DUMP_TABLES; /* set message type */ C             class = MSG_CLAS_PAMS;           /* set message type */ ,             status = pams_put_msg(msg_area, +                         &prio, &target.all, 8                         &class, &type, &delivery, &size,( 			&put_timeout, &psb, &uma, &resp_que);  @             if (check_ret(status)) /* call check_ret function */              {>                printf("SBS Tables can be found in SBS Log\n");' 		         printf("Use DCL Command\n"); : 		         printf("$TYPE PAMS$LOG:SBS_SERVER_xxxx.LOG\n");8 		         printf("\twhere: xxxx is the VMS SCSNODE\n"); 	          }             break;         *           case 6:	  P             printf("\nWRITE MSG TO BROADCAST STREAM\n");                        5             printf("Enter MOT (4800->5200) [4800] "); D             if (read_input() > 0) /* call read_input to get input */K                 sscanf(input_line, "%ld", &target.all); /* load variable */ '             else                       ,=                 target.all = 4800;    /* set default MOT Q */.=             prio = 0;                 /* set priority to 0 */ E             printf("Enter message class [10] ");  /* message class */.  D             if (read_input() > 0) /* call read_input to get input */L                 sscanf(input_line, "%hd", &class); /* load variable class */'             else                        5                 class = 10;   /* set default class */ /             printf("Enter message type [10] ");   D             if (read_input() > 0) /* call read_input to get input */J                 sscanf(input_line, "%hd", &type); /* load variable type */'             else                       nA                 type = 10;                 /* set default type */t?             printf("Enter data to send (terminate with a .) ");t  !             if (read_input() > 0)               {  M 	            sscanf(input_line, "%[^.]",msg_area); /* load msg_area buffer */_<                printf("Enter message size [msg_area_len] ");  G                if (read_input() > 0) /* call read_input to get input */                  {cM                   sscanf(input_line, "%hd", &size);  /* load variable size */_@ 		            for (i=strlen(msg_area)+1; i < USER_BUF_SIZE; i++)) 		                 msg_area[i] = (char)i;e                 }  	            elseoC                   size = strlen(msg_area); /* set size of string */t                } e             elseA                  size = 0;                 /* set default size */ 8 	         saved_size = size;             /* save size */  <             printf("Enter number of messages to send [1] ");  M             if (read_input() > 0)          /* call read_input to get input */dL                sscanf(input_line, "%hd", &num_of_times); /* load variable */ 	         else 	            num_of_times = 1;  -             for (i=1; i <= num_of_times; i++)M              {- 	            status = pams_put_msg(msg_area, s+                         &prio, &target.all, 8                         &class, &type, &delivery, &size,7 			               &put_timeout, &psb, &uma, &resp_que);o!                check_ret(status);  	          }  ! 	         if ( saved_size > 100 )g 	         {=&                start = saved_size-100;.                for (i=start; i<saved_size;i++);                   printf("<%d>x%x(%c) %c", i, msg_area[i],  L                                       isprint(msg_area[i])? msg_area[i]:'.',<                                       (i+1)%11 ? ' ': '\n'); 	         }             break;            case 7:   '             printf("\nPAMS_GET_MSG\n"); 9             prio = 0;                  /* set priority */ >             sel_addr.all = 0;          /* set select filter */>     	      msg_area_len = USER_BUF_SIZE; /* set buffer size */1             status = pams_get_msg (&rcv_msg_area,i+                         &prio, &source.all,*5                         &class, &type, &msg_area_len,                           &length,-                         &sel_addr.all, &psb); +             if (status == PAMS__NOMOREMSG) t 	          {.                 printf("Input Queue Empty\n");                 break;              }"             if(!check_ret(status))                 break;D 	         if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_AVAIL))  	          {? 		         memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));n7                printf("Process '%d.%d' is Available\n", 0                       avail.target_PQ.au.group, B 		                avail.target_PQ.au.process);                     	                                                                                                                                                                                                                                                          0                        ϸ $      DMQ020.B                       B  B  ([DMQ$V20.EXAMPLES.SBS]BRDCST_EXAMPLE.C;1                                                                                           H                         U      >          } 	         else  J               if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_UNAVAIL))  	            {A 		           memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));Q;                  printf("Process '%d.%d' is UnAvailable\n",u0                       avail.target_PQ.au.group, . 		                avail.target_PQ.au.process); 	            }                 else l 	            { d1                     printf("source = '%d.%d'\n",  8                     source.au.group, source.au.process);6                     printf("class  = '%d'\n", class );6                     printf("type   = '%d'\n", type  );6                     printf("length = '%d'\n", length);*                     printf("User Data\n");  % 	                 if ( length > 100 ) ' 	                   start = length-100;.                     else 	                   start = 0; c/                     for (i=start; i<length;i++)eB                      printf("<%d>x%x(%c) %c", i, rcv_msg_area[i], T                                       isprint(rcv_msg_area[i])? rcv_msg_area[i]:'.',<                                       (i+1)%11 ? ' ': '\n'); 	            }             break;           case  8:  (             printf("\nPAMS_GET_MSGW\n");             prio = 0;              sel_addr.all = 0;_(     	      msg_area_len = USER_BUF_SIZE;P             printf("Enter Timeout delay in tenths of a second [%d] ", ACK_WAIT);  "             if (read_input() > 0) 4                 sscanf(input_line, "%ld", &timeout);'             else                        #                 timeout = ACK_WAIT; 2             status = pams_get_msgw(&rcv_msg_area, +                         &prio, &source.all,_5                         &class, &type, &msg_area_len,.                          &length,7                         &timeout, &sel_addr.all, &psb);""             if(!check_ret(status))                 break;  ? 	    if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_AVAIL)) C 	     {/: 		    memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));<                     printf("Process '%d.%d' is Available\n",0                       avail.target_PQ.au.group, 8 		      avail.target_PQ.au.process);                     	     } F 	    else if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_UNAVAIL))  	          {: 		    memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));>                     printf("Process '%d.%d' is UnAvailable\n",0                       avail.target_PQ.au.group, $ 		      avail.target_PQ.au.process);
 	          }                    else                    { 1                     printf("source = '%d.%d'\n",  8                     source.au.group, source.au.process);6                     printf("class  = '%d'\n", class );6                     printf("type   = '%d'\n", type  );6                     printf("length = '%d'\n", length);*                     printf("User Data\n");    	            if ( length > 100 )! 	             start = length-100;E                     else 	             start = 0;    /                     for (i=start; i<length;i++) C                       printf("<%d>x%x(%c) %c", i, rcv_msg_area[i],  T                                       isprint(rcv_msg_area[i])? rcv_msg_area[i]:'.',<                                       (i+1)%11 ? ' ': '\n');                   }              break;&         case 99:                                     loop = 0; A             printf("\n\n     PAMS Broadcast Example Complete\n");              break;         default:5             printf("Invalid selection Try Again!"); 5             break;                                   .        } /* end switch */*     } /* end while */            exit(1); } /* end main*/S  @ /***************************************************************@     check_ret - checks the return code for success             *@                                                                *@     returns:                                                   *@         0 = an error                                           *@         1 = o.k.                                               *A ****************************************************************/  static intc check_ret(sts_value) {      int desc[2];     char str[256];     short len;     int i,j;                                r #ifdef vms (     desc[0] = sizeof (str);o     desc[1] = str;#     if (sts_value & STS$M_SUCCESS)           return (1);AE     i = sys$getmsg(sts_value, &len, &desc[0], 15, &j);               _(     str[len] = 0;  /* null out string */?     printf("PAMS ERROR RETURNED '0x%x'\n'%s'", sts_value, str);r     return(0);       S #else      if (sts_value > 0) 	return(1); 
     else {3 	pams_print_sts("SBS_EXAMPLE", "ERROR", sts_value);  	return(0);e     }c #endif) }                                        e  @ /***************************************************************@     read_input  - reads an input line into global 'input_line' *@                                                                *@     returns:                                                   *@         0 = an error                                           *@         n = # of char read                                     *A ****************************************************************/  static int  read_input() {B  
     char *cp;        cp = gets(input_line);       if (cp == NULL)i         return(0);     else#         return(strlen(input_line));o }yo 0 */C             target.au.group  = group;        /* set target group */eI             target.au.process = PAMS_SBS_SERVER;/* set target Q number */ C                         # * [DMQ$V20.EXAMPLES.SBS]SBSMSGDEF.H;1 +  , B   .     /     4 \       R                   - B    0   1    2   3      K  P   W   O     5 
  6  tSq  7  s  8          9 Z  G    H  J                
              I /************************************************************************ - *       SBS_SERVER Version 3.0          				* % *	Module: SBS_MSG_DEF  					        *  *	File:   SBSMSGDEF.H						*J *************************************************************************/   #ifndef PAMS_ADDRESS_DEFINED typedef union {  	unsigned long all; 	 	struct {  	   unsigned short process;  	   unsigned short group;  	} au; } PAMS_ADDRESS;   #define PAMS_ADDRESS_DEFINED YES #endif  D /*******************************************************************C *      FORMAT OF SBS REGISTRATION    #BYTES   	NOTES              * D ********************************************************************8 	TARGET = PAMS_SBS_SERVER                                	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_SBS_REG 	MSG    =                   *     ==============================        ,             version 			2  	always decimal 20&     ------------------------------    #             MOT_Q	  		2	MOT address 5     ------------------------------                    1             distribution_Q 		4       dist PAMS Q  &     ------------------------------    ?             data offset   		2       start data offset (1 based) \     ------------------------------                                (if zero no matching done)1             data operator 		1       data operator &     ------------------------------    3             length      		2       length of operand T     ------------------------------    		                  (if zero no matching done),             operand			4       constant value&     ------------------------------    6             request acknowledgement 	1	request ack=1  &     ------------------------------    <      request sequence gap notification  1	request seqgap=1  &     ------------------------------    ?      request auto dereg on exit         1	request autodereg=1   &     ------------------------------     	EOM< */                                                          . /* PSEL types defined in pams_c_symbol_def  */   struct SBS_REG {) 	short 	 version;  	   	/* always = 20 */ 0 	unsigned short	MOT_Q;	        /* MOT address */3 	PAMS_ADDRESS distribution_Q;    /* PAMS dist. Q */ " 	short	 offset;		/* data offset */) 	char     operator;		/* data operator  */ 0 	short 	 length;	     	/* length of operand */  3 	unsigned long   operand;        /* data operand */ 6 	char	 req_ack;       	/* set to 1 if ACK requested */< 	char	 req_seqgap;       	/* set to 1 if SEQGAP requested */C 	char	 req_autodereg;       	/* set to                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  1                        R1 $      DMQ020.B                       B  B  #[DMQ$V20.EXAMPLES.SBS]SBSMSGDEF.H;1                                                                                            \                              ?              1 if AUTO DEREG requested */  };      D /*******************************************************************D  *      FORMAT OF SBS REGISTRATION_EZ #BYTES   	NOTES              *D  *******************************************************************3 	TARGET = PAMS_SBS_SERVER                           ! 	CLASS  = MSG_CLAS_PAMS            	TYPE   = MSG_TYPE_SBS_REG_EZ 
 	MSG    = &     ==============================    ,             version 			2  	always decimal 20&     ------------------------------    #             MOT_Q	  		2	MOT address 5     ------------------------------                    1             distribution_Q 		4       dist PAMS Q  &     ------------------------------     	EOM */   struct SBS_REG_EZ { # 	short 	version;		/* always = 20 */ 9 	short	MOT_Q;                  /* starting MOT address */ 0 	PAMS_ADDRESS distribution_Q;  	/* PAMS dist. */ };        D /*******************************************************************B *     FORMAT OF SBS REG(_EZ) REPLY  #BYTES   	NOTES              *D ********************************************************************/ 	TARGET = source of registrant                   	CLASS  = MSG_CLAS_PAMS   	TYPE   = MSG_TYPE_SBS_REG_REPLY
 	MSG    = "     ==============================3       	     status  			2  	status (1=ok,-n=ng)      "     ------------------------------*       	     reg_id  			2  	returned reg id"     ------------------------------K       	     number_reg                 2  	number currently registered for  C     ------------------------------               this mot or target  	EOM */	            struct SBS_REG_REPLY {4 	short	 status;	/* returned status (1=ok, -n = ng */6 	unsigned short	reg_id;	/* returned registration id */C 	short	 number_reg;    /* number of registrants left on this mot */  };                    D /*******************************************************************B *     FORMAT OF MOT DEREGISTRATION  #BYTES   	NOTES              *P ********************************************************************            0 	TARGET = PAMS_SBS_SERVER                        	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_MOT_DEREG
 	MSG    = "     ==============================,             version 			2  	always decimal 10"     ------------------------------5             registration id		2	reg_id from REG_REPLY  "     ------------------------------)             request acknowledgement 	1	   "     ------------------------------ 	EOM */  &                                        struct SMC_DEREG {" 	short	version;		/* always = 10 *// 	unsigned short 	reg_id;		/* registration id */ * 	char	req_ack;		/* = 1 if ACK requested */ };  D /*******************************************************************B *     FORMAT OF SBS DEREGISTRATION  #BYTES   	NOTES              *D ********************************************************************0 	TARGET = PAMS_SBS_SERVER                        	CLASS  = MSG_CLAS_PAMS ! 	TYPE   = MSG_TYPE_SBS_DEREG      
 	MSG    = "     ==============================,             version 			2  	always decimal 20"     ------------------------------(             MOT_Q       		2	MOT_address "     -------------------------------             distribution_Q		4	distribution Q  "     ------------------------------)             request acknowledgement 	1	   "     ------------------------------ 	EOM */  ?                                                                  struct SBS_DEREG {" 	short	version;		/* always = 20 */2 	unsigned short MOT_Q;           /* MOT_address */= 	PAMS_ADDRESS distribution_Q;    /* distribution Q address */ * 	char	req_ack;		/* = 1 if ACK requested */ };  D /*******************************************************************D *      FORMAT OF SBS/MOT DEREG ACK    #BYTES   NOTES               *D ********************************************************************- 	TARGET = PAMS_SBS_SERVER                      	CLASS  = MSG_CLAS_PAMS   	TYPE   = MSG_TYPE_SBS_DEREG_ACK  	MSG    =                       "     ==============================6       	     status  	   		2  	status (1=ok,-n=ng)     "     ------------------------------Q       	     number reg/mot             2  	number of registrants left on this mot "     ------------------------------ 	EOM */   struct SBS_DEREG_ACK {4 	short	 status;	/* returned status (1=ok, -n = ng */J 	short	 number_reg;    /* number of registrants left on this mot/target */ };                      D /*******************************************************************D *      FORMAT OF SBS PURGE MESSAGE    #BYTES   NOTES               *D ********************************************************************7 	TARGET = PAMS_SBS_SERVER                                	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_SBS_PURGE3 	MSG    =                                           &     ==============================    ,             version 			2  	always decimal 10&     ------------------------------    )             request acknowledgement 	1	   &     ------------------------------     */ struct SBS_PURGE {! 	short	version;	/* always = 10 */ . 	char	req_ack;	/* set to 1 if ACK requested */ };  D /*******************************************************************D *      FORMAT OF SBS PURGE ACK          #BYTES   NOTES             *D ********************************************************************6 	TARGET = PAMS_SBS_SERVER                              	CLASS  = MSG_CLAS_PAMS   	TYPE   = MSG_TYPE_SBS_PURGE_ACK
 	MSG    = "     ==============================3       	     status  			2  	status (1=ok,-n=ng)      "     ------------------------------ 	EOM   */ struct SBS_PURGE_ACK {4 	short	 status;	/* returned status (1=ok, -n = ng */ };                    D /*******************************************************************A *     FORMAT OF SBS_BS_SEQGAP      #BYTES   	NOTES              * D ********************************************************************+ 	TARGET = registrant                         	CLASS  = MSG_CLAS_PAMS   	TYPE   = MSG_TYPE_SBS_BS_SEQGAP
 	MSG    = "     ==============================,             number of msgs              4   "     ------------------------------<             sender's group 		2                              "     ------------------------------)             mot number                  2 "     ------------------------------)             channel number              2 "     ------------------------------ 	EOM */  &                                        struct SBS_BS_SEQGAP { 	long	   	num_msgs_missing;  	unsigned short  sender_group; 	unsigned short	mot; 	unsigned short	channel; };  &                                       D /*******************************************************************C  *      FORMAT OF MSG_TYPE_SBS_INIT  #BYTES   	NOTES              * D  *******************************************************************3 	TARGET = PAMS_SBS_SERVER                           ! 	CLASS  = MSG_CLAS_PAMS            	TYPE   = MSG_TYPE_SBS_INIT 
 	MSG    = &     ==============================    ,             version 			2  	always decimal 30&     ------------------------------                 group	  		2	short 5     ------------------------------                    ,             first_temp_queue 		2       short&     ------------------------------     	EOM */   struct SBS_INIT { # 	short 	version;		/* always = 30 */ ; 	short	group;                  /* this PAMS group number */ B 	short   first_temp_queue;  	/* first temporary queue for group */ };                                                                                                                                                                                            % * [DMQ$V20.EXAMPLES.SBS]SBS_EXAMPLE.C;1 +  , B   . T    /     4    T   O                    - B    0   1    2   3      K  P   W   O U    5   6 @]7ſ  7 ֱs  8          9 Z  G    H  J                          N /*****************************************************************************$  *  DECmessageQ for VMS							     *N  *                                                                           *;  *  Copyright (c) 1992                    			             * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  in                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  2                        D% $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES.SBS]SBS_EXAMPLE.C;1                                                                                               T                         D "            clusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/   $ #define    SBS_VERSION "DMQ V2.0-01"
 #ifdef vms& #module    DMQ$SBS_EXAMPLE SBS_VERSION #endif        O /****************************************************************************** % * Module:    PAMS SBS Example Program  *  * Filename:  SBS_EXAMPLE.C * < * Function:  This program is used to illustrate a method of 7 *            using Selective Broadcast Services on PAMS  * 	 * Inputs: 	 *    none  * 
 * Outputs:	 *    none  *  * External Subroutines:  *    PAMS_ATTACH_Q *    PAMS_GET_MSG  *    PAMS_GET_MSGW *    PAMS_PUT_MSG  *  * Language: VAX11-C  * O ******************************************************************************/    /*  system include files  */ #include <stdio.h> #include <ctype.h>   /*K  PAMS include files                                                          */ #include "p_entry.h" #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "sbsmsgdef.h" #include "availmsgdef.h"  * #define ACK_WAIT 300 /* wait 30 seconds */   char input_line[80];  
 typedef union     {      long int all;      struct            { #             short int sel_variable;              short int sel_mode;            } au;     } selection;    static selection    get_select;    static int main(argc, argv) 	 int argc; 
 char *argv[]; & {                                       (     unsigned long status;               
     int i;     int num_of_times; !     long req_process_num;              typedef union      {          long all;          struct  	         {              short process;             short group;
         } au;      } PAMS_ADDRESS; <     PAMS_ADDRESS new_process_num, target, source, sel_addr; '     PAMS_ADDRESS new_process_sq;             long size;          int loop = 1;                    int aloop = 0;     char prio;     char c;      unsigned short group;      short class;     short type;      short length;      short start;     short saved_size;      long put_timeout = 0;      struct PSB psb;      char uma = PDEL_UMA_DISC;      long resp_que = 0;       struct showmsg       {          PAMS_ADDRESS target;!         PAMS_ADDRESS orig_target; !         PAMS_ADDRESS orig_source; !         long     sequence_number;          char     delivery;         char     priority;         char     buffer_type;          char     filler[81];     } showmsg;                            unsigned int select = 0;?     char delivery = PDEL_MODE_NN_MEM;                                unsigned long timeout = 0;     unsigned long timer_id = 0;   &     char *msg_ptr;                     #define USER_BUF_SIZE 32000 7     unsigned char msg_area[USER_BUF_SIZE];              ;     unsigned char rcv_msg_area[USER_BUF_SIZE];              '     short msg_area_len = USER_BUF_SIZE; !     struct SBS_REG_EZ SBS_reg_ez; '     struct SBS_REG_REPLY SBS_reg_reply;      struct SBS_REG SBS_reg; &     struct SMC_DEREG SMC_dereg;       &     struct SBS_DEREG SBS_dereg;       '     struct SBS_DEREG_ACK SBS_dereg_ack; &     struct SBS_PURGE SBS_purge;       '     struct SBS_PURGE_ACK SBS_purge_ack; '     struct SBS_BS_SEQGAP SBS_bs_seqgap; #     struct AVAIL_REG     AVAIL_reg; %     struct AVAIL_DEREG   AVAIL_dereg;      struct AVAIL         avail;      long int attach_mode,ii;     long int q_type,q_name_len;      unsigned char temp;      char convert_char;  <     for (i=0; i < USER_BUF_SIZE; i++) msg_area[i] = (char)i;  ,     printf("\nSBS & AVAIL/UNAVAIL Example");      printf("\nPAMS_ATTACH_Q\n");     q_type = PSYM_ATTACH_PQ;<     while ((input_line[0] != '1') && (input_line[0] != '2'))     { ]       printf("\nEnter attach mode 1 = PSYM_ATTACH_BY_NUMBER or 2 = PSYM_ATTACH_TEMPORARY> ");        gets(input_line);      }      if (input_line[0] == '2')      {        temp = TRUE;*       attach_mode = PSYM_ATTACH_TEMPORARY;J       status = pams_attach_q (&attach_mode,&new_process_num.all,&q_type,0,+                               0,0,0,0,0,0);      }      if (input_line[0] == '1')      { *       attach_mode = PSYM_ATTACH_BY_NUMBER;       temp = FALSE;        input_line[0] = 0;        while (input_line[0] == 0)       { K         printf("\nPlease enter permanent primary q number (no default)> ");          gets(input_line);        } &       q_name_len = strlen(input_line);H       status = pams_attach_q (&attach_mode,&new_process_num.all,&q_type,@                               input_line,&q_name_len,0,0,0,0,0);     }   (     if (!check_ret(status)) return(1);    A     printf("\npams_attach_q primary queue address is '%d.%d'\n",  >         new_process_num.au.group, new_process_num.au.process);  
     if (temp)      {        input_line[0] = 0;        while (input_line[0] == 0)       { Q         printf("\nDo you want a Temporary secondary queue?? Y/N (no default)> ");          gets(input_line);        }      ,       convert_char = toupper(input_line[0]);       if (convert_char == 'Y')       {           q_type = PSYM_ATTACH_SQ;         if (temp) 	         { .           attach_mode = PSYM_ATTACH_TEMPORARY;M           status = pams_attach_q (&attach_mode,&new_process_sq.all,&q_type,0, /                                   0,0,0,0,0,0);          .           if (!check_ret(status)) return(1);    I           printf("\npams_attach_q secondary queue address is '%d.%d'\n",  H                     new_process_sq.au.group, new_process_sq.au.process);	         }        }               if (convert_char == 'N')       {          get_select.all = 0;        } 
       else       { ,         get_select.au.sel_mode = PSEL_PQ_AQ;?         get_select.au.sel_variable = new_process_sq.au.process;        }      }      else     {        input_line[0] = 0;        while (input_line[0] == 0)       { Q         printf("\nDo you have a permenant secondary queue?? Y/N (no default)> ");          gets(input_line);        } ,       convert_char = toupper(input_line[0]);       if (convert_char == 'Y')       {          input_line[0] = 0;"         while (input_line[0] == 0)	         { 8           printf("\nEnter permanent secondary queue> ");           gets(input_line); 	         } 6         new_process_sq.au.process = atoi (input_line);  ,         get_select.au.sel_mode = PSEL_PQ_AQ;?         get_select.au.sel_variable = new_process_sq.au.process;        } 
       else       {          get_select.all = 0;        }      }   Q     printf("Enter PAMS' group of SBS_SERVER to exercise (0=local, n=other) [%d] "  	, new_process_num.au.group);      if (read_input() > 0) *         sscanf(input_line, "%hd", &group);     else)         group = new_process_num.au.group;        while (loop)       { D         printf("\n\n PAMS SBS & AVAIL Example (%s)\n", SBS_VERSION);C         printf("REGISTRATION_EZ (1)      REGISTRATION      (2)\n"); C         printf("DEREGISTRATION  (3)      PURGE             (4)\n"); C         printf("DUMP TABLES     (5)      BROADCAST MSG     (6)\n"); C         printf("PAMS_GET_MSG    (7)      PAMS_GET_MSGW     (8)\n"); C         printf("AVAIL_REG       (9)      AVAIL_DEREG      (10)\n"); )         printf("EXIT            (99)\n");                          :         printf("\n\nPlease enter selection (0->11, 99) ");         if (read_input() > 0) &             select = atoi(input_line);(         else                                         continue; A                                                                            switch (select) 	         {          case 1:   2             printf("\nREGISTRATION_EZ REQUEST\n");$             SBS_reg_ez.version = 20;  6             printf("Enter Mot_Q (4800->5200)[4800] ");  "             if (read_input() > 0) =                 sscanf(input_line, "%hd", &SBS_reg_ez.MOT_Q); '             else                        -                 SBS_reg_ez.MOT_Q = 4800;        N             printf("Enter distribution_Q (PAMS Process Q) [My PAMS id '%d'] ",,                                                                                                                                                                                                                                                              3                        t $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES.SBS]SBS_EXAMPLE.C;1                                                                                               T                           "                  new_process_num.au.process);1             if (read_input() > 0)                 I                 sscanf(input_line, "%d", &SBS_reg_ez.distribution_Q.all); '             else                        D                 SBS_reg_ez.distribution_Q.all = new_process_num.all;'             type = MSG_TYPE_SBS_REG_EZ;              prio = 0; %             target.au.group  = group; 0             target.au.process = PAMS_SBS_SERVER;2             class = MSG_CLAS_PAMS;                .             size = sizeof (struct SBS_REG_EZ);  .             status = pams_put_msg(&SBS_reg_ez,+                         &prio, &target.all, 8                         &class, &type, &delivery, &size,1 			&put_timeout, &psb, &uma, &resp_que, 0, 0, 0); #             if (check_ret(status))               { % 	        /* always wait for an ACK */ -                 printf("Wait for an ACK \n"); 5                 size = sizeof (struct SBS_REG_REPLY);  		timeout = ACK_WAIT; 
 #ifdef VAXELN  		sel_addr.all = 0;  #else  		sel_addr.au.group = group;-      		sel_addr.au.process = PAMS_SBS_SERVER;* #endif6                 status = pams_get_msgw(&SBS_reg_reply,;                         &prio, &source.all, &class, &type,  D                         &size, &size, &timeout, &sel_addr.all, &psb, 			0,0,0,0,0);F                 if (check_ret(status) && (SBS_reg_reply.status == 1)) 
 	        {                     printf(aM "Registration_EZ is o.k.\nRegistration id is '%d'\nNumber of Regs is '%d'\n",tF                       SBS_reg_reply.reg_id, SBS_reg_reply.number_reg);                 } ^ 	        else                                                                                 <                     printf("Registration_EZ is n.g. '%d'\n",,                       SBS_reg_reply.status);
             }              break;           o           case 2:  a/             printf("\nREGISTRATION REQUEST\n"); !             SBS_reg.version = 20; 6             printf("Enter Mot_Q (4800->5200)[4800] ");"             if (read_input() > 0) :                 sscanf(input_line, "%hd", &SBS_reg.MOT_Q);,             else                            *                 SBS_reg.MOT_Q = 4800;     Q             printf("Enter distribution_Q (PAMS Process Q) [My PAMS PQ id '%d'] ",*,                 new_process_num.au.process);"             if (read_input() > 0) F                 sscanf(input_line, "%d", &SBS_reg.distribution_Q.all);'             else                       *A                 SBS_reg.distribution_Q.all = new_process_num.all;e             printf( @ "Enter offset (+n, %d=ANY, %d=class, %d=type, %d=source) [%d] ", 		PSEL_OPER_ANY, c                 PSEL_CLASS,                  PSEL_TYPE,                   PSEL_SOURCE,                   PSEL_CLASS);"             if (read_input() > 0) ;                 sscanf(input_line, "%hd", &SBS_reg.offset);1'             else                       *,                 SBS_reg.offset = PSEL_CLASS;               printf("Enter operator (%d=Any, %d=equal, %d=Not_equal, %d=greater, %d=less, %d=greater_equal, %d=less_equal [%d] ", 		PSEL_OPER_ANY,                   PSEL_OPER_EQ,                  PSEL_OPER_NEQ, u                 PSEL_OPER_GTR, u                 PSEL_OPER_LT,                   PSEL_OPER_GTRE,                  PSEL_OPER_LTE, T                 PSEL_OPER_EQ);"             if (read_input() > 0) =                 sscanf(input_line, "%hd", &SBS_reg.operator); '             else                        0                 SBS_reg.operator = PSEL_OPER_EQ;(             printf("Enter length [0] ");"             if (read_input() > 0) ;                 sscanf(input_line, "%hd", &SBS_reg.length); '             else                        #                 SBS_reg.length = 0;s:             printf("Enter operand [0] ");                 "             if (read_input() > 0) ;                 sscanf(input_line, "%d", &SBS_reg.operand); '             else                       A$                 SBS_reg.operand = 0;0             printf("Enter req_ack (Y, N) [Y] ");"             if (read_input() > 0)  	    {      -                 sscanf(input_line, "%c", &c);;$                 SBS_reg.req_ack = 1;+                 if ((c=='N') || (c == 'n'))h(                     SBS_reg.req_ack = 0;             }   	    else                       $                 SBS_reg.req_ack = 1;  F             printf("Enter req_sequence gap notification (Y, N) [Y] ");"             if (read_input() > 0)  	    {-                 sscanf(input_line, "%c", &c);E'                 SBS_reg.req_seqgap = 1;c+                 if ((c=='N') || (c == 'n')) +                     SBS_reg.req_seqgap = 0;_             }   	    else                       '                 SBS_reg.req_seqgap = 1;id             printf("Enter req_autodereg automatic deregistration on distribution exit (Y, N) [Y] ");  "             if (read_input() > 0)  	    {-                 sscanf(input_line, "%c", &c);n*                 SBS_reg.req_autodereg = 1;+                 if ((c=='N') || (c == 'n'))i.                     SBS_reg.req_autodereg = 0;             }   	    else                       *                 SBS_reg.req_autodereg = 1;               prio = 0;p%             target.au.group  = group; 0             target.au.process = PAMS_SBS_SERVER;$             type = MSG_TYPE_SBS_REG;"             class = MSG_CLAS_PAMS;+             size = sizeof (struct SBS_REG);S  +             status = pams_put_msg(&SBS_reg,_+                         &prio, &target.all, 8                         &class, &type, &delivery, &size,1 			&put_timeout, &psb, &uma, &resp_que, 0, 0, 0);_=             if (check_ret(status) && (SBS_reg.req_ack == 1)) e( 	    {   /* should we wait for an ACK */-                 printf("Wait for an ACK \n");)5                 size = sizeof (struct SBS_REG_REPLY);  		timeout = ACK_WAIT;\
 #ifdef VAXELNe 		sel_addr.all = 0;  #else  		sel_addr.au.group = group;( 		sel_addr.au.process = PAMS_SBS_SERVER; #endif6                 status = pams_get_msgw(&SBS_reg_reply,;                         &prio, &source.all, &class, &type, (D                         &size, &size, &timeout, &sel_addr.all, &psb, 			0,0,0,0,0);F                 if (check_ret(status) && (SBS_reg_reply.status == 1)) 
 	        {e                     printf("Registration is o.k.\nRegistration id is '%d'\nNumber of Regs is '%d'\n",tF                       SBS_reg_reply.reg_id, SBS_reg_reply.number_reg);                 } ^ 	        else                                                                                 9                     printf("Registration is n.g. '%d'\n", ,                       SBS_reg_reply.status);
             }h             break;         _   l  +         case 3:                            _1             printf("\nDEREGISTRATION REQUEST\n");eP 	    printf("DeRegister by Mot/distribution or by Registration id (M, R) [M] ");"             if (read_input() > 0)  	    {-                 sscanf(input_line, "%c", &c);(-                 if ((c !='M') && (c != 'm'))                   {]  ( 		/*************************************( 		 * deregister by registration id     *) 		 *************************************/   (             	    SMC_dereg.version = 10;5             	    printf("Enter req_ack (Y, N) [Y] "); *                     if (read_input() > 0)                      { 5                         sscanf(input_line, "%c", &c); .                         SMC_dereg.req_ack = 1;4                         if ((c =='N') || (c == 'n'))2                             SMC_dereg.req_ack = 0;                     } ( 	            else                       .                         SMC_dereg.req_ack = 1;9                     printf("Enter registration id [?] ");e*                     if (read_input() > 0) E                         sscanf(input_line, "%hd", &SMC_dereg.reg_id); /                     else                       _6                         break; /* continue */                              prio = 0; -                     target.au.group  = group;i8                     target.au.process = PAMS_SBS_SERVER;.                     type = MSG_TYPE_MOT_DEREG;-                     class = MSG_CLAS_PAMS;   i5                     size = sizeof (struct SMC_DEREG);p  6                     status = pams_put_msg(&SMC_dereg, +                         &prio, &target.all,t8                         &class, &type, &delivery, &size,1 			&put_timeout, &psb, &uma, &resp_que, 0, 0, 0);nG                     if (check_ret(status) && (SMC_dereg.req_ack == 1))  0 	            {   /* should we wait for an ACK */4                        printf("Wait for an ACK \n");<                        size = sizeof (struct SBS_DEREG_ACK); 		       t                                                                                                                                                                                                                                                   4                        hJV $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]PAMP@QPC_+O7Gtlr81                                                                                          P                              j      4       	Dl59U9Kw7".#<<%[o8?ghEQ\YCcd,xo⚽2u<_/uz*b2T
uEJf"9n
aLb+cq~<	AY}Wk=`-}	x<V(p.1Q;J5G
U*3zfPB~+$UqM;
#u
s3p]x-cfEHw^Skt^r-?}T'")& /<[&`GkR+\'':%u,l(lM||@WEx&lOLWv`>&Kd\JrhWo)NOG5r
R`koFUJhZG5M>7B.%{WJ1F6T_t#~qL*
a ;ehDO Sm
N;t^`t@X_4G&w
v	:N``(o;.uUvW*u[Jm=:s(rVR~{/QeqM?rpC8qFc9xFUNz3Y
p1r&d~x1nh'?AET"2iZ#{
NWl6>"#{B_Dm~8d	^8;VOpq7/"5e$~naOMdQf-)&'%0/{i}&3wZcd<xoaz y0YmIA*;0A}s)=~*mZa$ygv@dhGnDliY7m]\Cs]Yq/	%0(n]xT28G;fV6bSsd{7Gs!=u*Ed-AQ)2^)w/xOwA<z*/|rxo7
l*;Olt=;=	GD}3cI;Lyac_^3=7@JI%aFg$t*l
3go.}u3g$00lR'+La5
|B1PGRCO	W)63J-|&,lzc9aR3~#@2
0kGJd׈=7m(8%j@#@~{e7 	$U &.kWGplFUpzfV(%vo? Y?yX]DI` Ci!7IbdHcg[|sL_>]PHxI/>@kXY\W^*cT\:}+Lu1=|D,nES	zVu,
gslH%b9W'bDq{AKPI8iZGZQ1W-+%l^hdsK, -%R?rRyinM& G.tpOXY/v"p
U9"+J{:2kh"WkJk+5w?6.oXtA?XUl<3v&u{6x{fx_ERrD6!O^;z:1ngsgrR+9dGm+#!+b#Z"P<,=$ YGM.n!:.}PD>hlZxg}BNm/eJ	I?J;.SpE]qPtL9q/{?bM*7=bgpkNlr/8mdNq.EuJIDP!*h(A?A&W R5|BLolk~gfg&HZ-YFyV >a{xO.Cq-u*U!GTJt73qLΐ_g)ll:#<}	7!+n<zdb*l1yWĉO]~zE!J&B?}
0m;0 
uE~)X+[s]
z3|Sy2j\l2m32UHsfN:'Q Z@VpRjj}w{^~?uiI^)4U2%Bhd<5okMX;4K2Em+OvA+q6>$Nv~5S:Y~Lk2Le&?eLC?
g)\s0UTV$x6^xqsmzIHBIcbC+i*#@0jYE86jToDEfaY	'5=^][^2+?=HTI@V@Z]6arh'nbq
B%DO-iV*
S` pGU1\XdAf-RB+}xr1DI{i=2[j;]aA9$;j5`
'?V {cz%Da:A0xdLy4,_LL.lkitUQE~0~;Ywf-P:0K"rqjNw,x@;Xw3T5
14X9$
]#)@2-dg7(SIFe;0wARlw*pJ~.
0[;
_uq3#[~	n@ycMU!0ABd
pJG6 rk@9{2/n
@xt5F\X|@	_(&tMu}L:<1&k+:nIvwu[WOp}k]bhWqykp?&XB_\i? {wC :o|6OOcW	sKMt'@}h!.v\^)Gd/J]4cozx,]k~@qRK@bM')&yPluxxZ#ZVicl'R'eJ`DW(Gu`&Re)k"`S-yXCV @`4=1_sd"g12!~=XdaT,\%z0	iOc(.8f֨&K01,A$Z:; /C+?% =GM#`O Q mL/@=4~B(_KkY_[-
Z<_)AS7xTZp?}NVqz^aj1x]9^5+Ud9et/,fX
 Ml0j@4Jy*YjtmA%?Dk%)-Z9cs
du">ZA

 0xq/d8]~q^w/x_ft5"Wr[?c	\dU=41_LP?f
!'DJtTpmxJ.\\A_]bH1i!r
/xe$|J1Oy-
Q'&C#MA*\5O/dz73|w> J?T[r~!C)!Et>D)/Ib'z/TZE%?l{'9?8}tN_O5`ZUSr<XF 0yv[odZxoe&v^BzE
V(i/
zf@:jNPWIf*D`L{zY@6N~j!@ w/HpO&Eh.)_NJ,zF)F7lV,!{TTJBcnz?*0aMzfcSApR`8g
&CPj	f;k>1y.\{m]L{cl}5A Xs,5MZA)`(gBY#`21;}m
t; :xnJ`"L@]5EhWp<N@ bVtC<uD5,q!7[{	:9pjV^JK::7 }E%wVsM1XCG_TDwPJ@a|$DuRZC[ 3;"{nH:MYT#X?$/G`7*qgj5f|%jFk1$|\m 	}@1I[]`M{?KV;0?H0BwJCLcKi9Hwx?oyb_h'`U }n+\b:4SFtlek9@0",|za(UV<
Jj"vQo76W}8Bp#s9O|Tj8IJ?a_qi[G2gK r$m -$!eF`/>X>k"rz"w#^X{l7/@,9:u*U9x8AxlJIJiLM%%X~1alI3!htTJO8ttZF|X"7PLDVq`I)gB}
 puFF?Vi.mT2&'y3dfY
q
}=YO: ?.0+cyX}jEOR5<>aUY[`i-kh6QGDBh1-Wds{Di<4NW=.f>Q5q+!%UG~IQJ+?=Y;>iDJ0ҙMMO?ar4c>_z-I`JoY<`<E/j\1!(YA
HfXy,*?p,[O(8tfLw:~q8;Z8bw^2N1	haP^o;~Ko}hm0coG~Zi6?(H&
*q%[~/@=fi8GyB3 V,,`	gB-] *&?2%#}z{.dB:|,b:XUgh#1D!`BbVR=[*O@gg!*q?LU!Zի nDCb;UQqgtAk|3 D9`pPPM>>+i{PY/.Zt=_"O5Xi
e.bQ	qWBu+ <f,`)@#6M*a><,LH
8\QR:bc'n2%LtbYQTTH?sndaWw;855V1 U(dC]*	)
+\.nz#
<~Jd0k53#ZN
1r:;-Gv|	T6=SC/*(>]&f|nt"GHXAdgf5grsyrIE]kO^3
QM09^9~syK]^N
OM_45
AgX_"RRA&
*aRI\rkJc`
?TQi4('NNvBO-&?#b6@zX LDOKT%PI>iqmrM k%G2brLwv@e|7b_a]YYTp8oI$u0;Z]4FR_p,Q?
SGm
!EQ~ !YyA R0R$Za2OOhf1M7Gq6drxFCX `kZAjfdK1xn'*Y{H9w g~qyhL(Z0N
d
	7Oi>
 4=?! jL1g+Zu* ,&EUqQ.i:(]Bm(}pPBj&Gaj2R b:~NW8s3@skw
e
s5[xjN2&zEF\X>dTF4nNeN ~\lK\^VT	glf!t|B\BmiUHan*c|4(^cuD_@:y)dapYCy]A8^p&@)3dh
o|K!+_%[./|a
+~V!5@bW6O@K(`Vspg!Zd-h&Z&xS^[tb7:I ~zgjlO~N]"olWZ)V
<HG/42Ob;^D0Q]%FwaO5>3fe::tlc8el ?nF;8=0<`;j;JbJDx${K}8b@x!pG ewy:vTp&A7c:g2kdV
:VOo
XmJlc.T2TD.TGo;u!%07xX
/kw~MwZ*YnvlEv)g'gI,/n){!J- vPi"miE69\8)2(YI7;wQ+vy2lF5SNsJoCvJ.rK:jwT+ULWg[o
E$~vON`H~S:=S KXy<+(vRL(dF0P	i#wL"F\WNcYX9M0tX/Y88HGuVV5AKA6p2UfL)e6*ouA}+GB}#|9P4AskST48/FabK5$ A%c-:!{z(w.0
SEP!#bzo+?Iset9wzM1?Ou9VlDo}-
[pD\dN^"@k<Mw{l%A%Nj6~D [7p )w iWڋ	;;MZ@dm<.,q9uHȕpDeu&Xum?1_U"Q~
^pp)EqI=51Op@}jC6"BtpT{13 r8sbyBthHykA	ulh[f_	A!W]D12E&6/n{mGJ?tVYC8i b{Yo M 4PwC ]#bYYmf^gXd!{)Ja$2FUuKPT@)xeyjpC7"q`.,ia<P3VD,Jj%9 NaKxGJBT	wL
Z(9G1 W:^}F9pUb[U<kt#<Tr0wL1jx~H#!#x(c]+J9v C41"72.53\pFENa42_AxcKLTs	+)zyJhIZ0O"Z6giUbw(I
@+B9cT
(<vHLE#8Xa}Z%:*IR~\fb.7P9 2z,I+Tj ;]UDrn]*Q7dwA*H3ODg
II&s7b=B4lsC& 
8S1\WflR3pLx>zf0cvuETTqw36&tCE~K# ǽ>@;l "?Ԣ1
~[hݬ8HyDH~	QUpvmQV
7F(wr^VVr˯+CC?lbFOdBoIV1{;/>j=tVa$y#F
AQEDxG]\)|}"ygQ!k4V]LC,m  mEq<qt4Zy>fCE.x	zs?PS|VCg>e	Iqm?RTl^Np?k1CE
-[/ 4v}6QX
"LcxZ:,|Cч+æhWCK[Nl$xdAq8} 3og
tq|E~[W1QHRKRCDAP.Pk2cn_-)*w5Z+YYK~]C(B;M	hX%88D(gx
z%VTY([Ob5-q.HdZ+=S.%-n0hF>sEn3U!qsdSJfO8,(/W
W&~zWu[@:%z$obgC9qa_|U<
U%0EHT8{FpOQFk-jA-!KfVbEmW6R'Y29Szn!y	Luk-gbFT8{6.n*@YWsI88} tA0M"N3n LJ<0W$K`
aRu
xfPv5(fM$blcoAWvwv!0{93\N7:x!*tBS-Tv;[^eb^U7MS!L0xMf:"~OU}f>mL"r~mlZee"PE0]I;=J5~Y/X*$<j=YaD#)\@\0[A
[<S9BW9[iWc+W
*e7Sq+k hq?m78dPN},
OTa*
c=d>,e!#fn&Kch,W	c\96L":kJu}o@Ywr^%Q4&[)PeZG\j}{Iv&G|#efvlqli	Y,Cs\R?'&507/MmzsUICr>{/CrFQxC'tuTqJ2Dy$dH[aB:Xs`]lWT9!#T٣2\e`4Y7(uoc>B?Wt _B]ExIrapb8/.2iu0W"B(uq':Dz hN^elP7>6p`& KVamV7"O[#gd;ogcK?lP"s>vkVB\[\ZsyudT0e c[RbGx07LtCZ-Rvt6JT9ih>z JM;h&H
eH9iIcB'7]UY 1_X{|8B(p<eI+wh@|!
$0jqU<C
p^<m J6^n[o(k?"BgDm6N 6|),i0 FS30Xp)4NjPV=Un+JEq*rz7QR ^S-J/!"hVPJd r+"kkyt n& oa\	|6L ;(siܺke*9|V8 60a3^GIJHO)|[e4h?s;3BY 3<npS]2|dz8]6?]Aaxl(`s
&DxPP8 |e+idpR`:HF@!
Q_,WY B(4tK:]E1
EB	)

m7GXG LE%@{"UyjXARx+v
3YqL
G1<U>PKUDB/@<
 Khz2=8T$)$~5f:,;`0hp`9^%bP!kUF+^L?PUughZ1?8eA8,C z<B)X}M<z6cT@&L@u`![qo^GpK(0a^HAA:j%]H|&S?:>^uG
qAAFdW0qg*^di0iCzU ]}e}=xsyXp$Wp`1ckKg)2hw!YG"U))<XhEJ'Fe$kyZ{pF-3x%x(NgMP5k@HJm]DLxD6~"umQ:RG{cb/nl\EB&,xC53S2mOZtovN3*Y2$x?L2
Di	9eP*$;	`xX=#:![\Gx1xV)%<
J<U=D$JvHI7Og|e~}mYE)Ib8)":!Vn v
"#tX:KdSB[(^<oAqX/]]-W!(NG]f7<QG]vm|[9h?;,C::!ii\5[(PH9Hb}6hhAov_MJP)[1PTZo@kwq/bInHm:O:TbO.kiuJO
a'}Ao#DX|H~?GK&\;J9M-Fqb.fUa:x};]@!Rr~:^H#qKv
LK2PN Q-iOeslpS$P5qzY<.fw:HlSW*Pb]d-+kbW Z6vO4M[}=dx- kvK4o\}F d|Nrav|T^I];8:y7"l{qqE^Xm5D35<pNMI2v>
7l+,0v<@|7r)jU@Fw62^6mz;d4P
pJJaPNb)'zpHAf[#o4'vWB'F}6F. wFeK^uI?_It]]ZEb'}hH:aZTwSI[0f?5w5g5^,E
3#NkZ4]x`
9HU7aAGsbCdu
&Si#EE$eM`Gy #~Qr21a"uJp /
,=oTBS/vR&Zoh5qn X}#iqa_>x,>z'{]jt_gL+l-XgrAjSp* {-{;R#->Gf| D9A+j49z4T.^dmQC9HwrU/*0zIQ`$`%*Z:[N%#3o_`qhvRDwwDjtfI s*L)M_
qr#Z)-9:KL$T,"
A :5S	@V*/?eCoKXd_QH7V9U).r!Y7*rlb1q{##47L}q>WPm(|TAGf=`^~"^l/Z~pY*IWU%*eo\t!*OX^=[8 `*oIVPPC^TTjOSQ
<UO!W4Dj|Le!%,
 G!n 
+;)D
!X_13alO-`f5'&;@fY(.Fs tI<`Rkd16lw^DiZ,y}()neB.slHO|,G;dLJyE-2\w2jvUdc*Ig\Vi_6J)7FUl*[0^=^bC^.apgDs=)y!h6la~r{%{(tM*A`zQXX)qa}mva4{X\pIzVAK(=~J
}Fh8D2]WO6&N]FQA^A|(+NCweE<V
A%vj)\,	;8a**%
w.cT T}#uSrBj	
kj 9O:!ot&L9lH	
rm8
ptiv4kDX"
a`9u{w$q#'8]hOXkvI#mEn%<Nkk.n!^L8sak!|L&p~ PG\fo9R9<7d@"e1Wl#m?tms(s9loLk.DKQEE_U
%0Cj$8nqvRai82:")b]bu.
n,bS%R	+eA&!,a|i6[Jl.*?Re$@^
;m4u$=J4XJsO J@.6"`#nZc
@F	_+7% 7- WjOoPbsL1rpvw8=}5r>$
oO4^O:P![=1?wEW+pQ _
0`KS0a>&76a;yC9kC^D%|M1`w
'}FX)~C!ycm2`JE,fR11-]Bd.2M_} /Z}w#8aP/&B^#I,4p'}7fRO+TF=
c
/6DvAb-[_F5g=MD.K
 
kqq*;yiiE(;8e^}."!n]+?:\5'VTi#W
IfM$H%G>))ce>M$},GBrKn[?n)|G_r&\"E<\Ki[-VB<?B?@e]@D$eND<KA}#@oA<p@ewP4nr0,217;dS@LD+keu=`8_tSVALUE   Oa`gETP<I>q         4   "                                                                                                                                                                                                    5                        yt $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES.SBS]SBS_EXAMPLE.C;1                                                                                               T                          "     $       imeout = ACK_WAIT;
 #ifdef VAXELNe 		       sel_addr.all = 0; #elsec# 		       sel_addr.au.group = group;w/ 		       sel_addr.au.process = PAMS_SBS_SERVER;0 #endif=                        status = pams_get_msgw(&SBS_dereg_ack, Q                                               &prio, &source.all, &class, &type, MZ                                               &size, &size, &timeout, &sel_addr.all, &psb, 					      0,0,0,0,0);M                        if (check_ret(status) && (SBS_dereg_ack.status == 1)) r 	               { V                             printf("DeRegistration is o.k.\nNumber of Regs is '%d'\n",6                             SBS_dereg_ack.number_reg);n                        } else                                                                                 C                             printf("Deregistration is n.g. '%d'\n",d6                                 SBS_dereg_ack.status); 		    } /* end wait for ack */ 		    break; 		}/* end dereg by id */%             } /* end read_input if */ + 	    /************************************* + 	     * deregister by mot/distribution    * , 	     *************************************/#             SBS_dereg.version = 20; 6             printf("Enter Mot_Q (4800->5200)[4800] ");"             if (read_input() > 0) <                 sscanf(input_line, "%hd", &SBS_dereg.MOT_Q);'             else                        ,                 SBS_dereg.MOT_Q = 4800;     Q             printf("Enter distribution_Q (PAMS Process Q) [My PAMS PQ id '%d'] ", ,                 new_process_num.au.process);"             if (read_input() > 0) H                 sscanf(input_line, "%d", &SBS_dereg.distribution_Q.all);'             else                        C                 SBS_dereg.distribution_Q.all = new_process_num.all;_0             printf("Enter req_ack (Y, N) [Y] ");"             if (read_input() > 0) 
             {t-                 sscanf(input_line, "%c", &c);c&                 SBS_dereg.req_ack = 1;+                 if ((c=='N') || (c == 'n')) *                     SBS_dereg.req_ack = 0;             }   	    else                       &                 SBS_dereg.req_ack = 1;             prio = 0; %             target.au.group  = group;u0             target.au.process = PAMS_SBS_SERVER;&             type = MSG_TYPE_SBS_DEREG;"             class = MSG_CLAS_PAMS;-             size = sizeof (struct SBS_DEREG);a  .             status = pams_put_msg(&SBS_dereg, +                         &prio, &target.all,i8                         &class, &type, &delivery, &size,1 			&put_timeout, &psb, &uma, &resp_que, 0, 0, 0);B  ?             if (check_ret(status) && (SBS_dereg.req_ack == 1)) _( 	    {   /* should we wait for an ACK */-                 printf("Wait for an ACK \n"); 5                 size = sizeof (struct SBS_DEREG_ACK);0 		timeout = ACK_WAIT; 
 #ifdef VAXELN( 		sel_addr.all = 0;e #elset 		sel_addr.au.group = group;( 		sel_addr.au.process = PAMS_SBS_SERVER; #endif6                 status = pams_get_msgw(&SBS_dereg_ack,;                         &prio, &source.all, &class, &type, rD                         &size, &size, &timeout, &sel_addr.all, &psb, 			0,0,0,0,0);F                 if (check_ret(status) && (SBS_dereg_ack.status == 1)) 
 	        {N                     printf("DeRegistration is o.k.\nNumber of Regs is '%d'\n",0                       SBS_dereg_ack.number_reg);                 } ^ 	        else                                                                                 ;                     printf("Deregistration is n.g. '%d'\n",0,                       SBS_dereg_ack.status); 	    } /* end wait for ack */l             break;                       case 4:           (             printf("\nPURGE REQUEST\n");#             SBS_purge.version = 10;P0             printf("Enter req_ack (Y, N) [Y] ");"             if (read_input() > 0)  	    {-                 sscanf(input_line, "%c", &c);B&                 SBS_purge.req_ack = 1;+                 if ((c=='N') || (c == 'n')) *                     SBS_purge.req_ack = 0;             }   	    else                       &                 SBS_purge.req_ack = 1;             prio = 0;c%             target.au.group  = group; 0             target.au.process = PAMS_SBS_SERVER;&             type = MSG_TYPE_SBS_PURGE;"             class = MSG_CLAS_PAMS;-             size = sizeof (struct SBS_PURGE);f  -             status = pams_put_msg(&SBS_purge, +                         &prio, &target.all, 8                         &class, &type, &delivery, &size,1 			&put_timeout, &psb, &uma, &resp_que, 0, 0, 0);%?             if (check_ret(status) && (SBS_purge.req_ack == 1)) E( 	    {   /* should we wait for an ACK */-                 printf("Wait for an ACK \n"); 5                 size = sizeof (struct SBS_PURGE_ACK);  		timeout = ACK_WAIT;T
 #ifdef VAXELN  		sel_addr.all = 0;  #else  		sel_addr.au.group = group;( 		sel_addr.au.process = PAMS_SBS_SERVER; #endif6                 status = pams_get_msgw(&SBS_purge_ack,;                         &prio, &source.all, &class, &type, rD                         &size, &size, &timeout, &sel_addr.all, &psb, 			0,0,0,0,0);G                 if (check_ret(status) && (SBS_purge_ack.status == 1)) { .                     printf("Purge is o.k.\n");                 } ^ 	        else                                                                                 2                     printf("Purge is n.g. '%d'\n",,                       SBS_purge_ack.status);
             }              break;         e e           case 5:;.             printf("\nDUMP TABLES REQUEST\n");             size = 0;a             prio = 0;)%             target.au.group  = group;;0             target.au.process = PAMS_SBS_SERVER;,             type = MSG_TYPE_SBS_DUMP_TABLES;"             class = MSG_CLAS_PAMS;,             status = pams_put_msg(msg_area, +                         &prio, &target.all,n8                         &class, &type, &delivery, &size,1 			&put_timeout, &psb, &uma, &resp_que, 0, 0, 0);c#             if (check_ret(status)) _ 	    {1 		printf("SBS Tables can be found in SBS Log\n");  		printf("Use DCL Command\n");4 		printf("$TYPE DMQ$LOG:DMQ$SBS_bbbb_ggggg.LOG \n");9 		printf("\twhere: bbbb=bus-id and ggggg = group-id \n");  	    }             break;         a   e           case 6:tP             printf("\nWRITE MSG TO BROADCAST STREAM\n");                        5             printf("Enter MOT (4800->5200) [4800] "); "             if (read_input() > 0) >                 sscanf(input_line, "%hd", &target.au.process);'             else                        )                 target.au.process = 4800; D             printf("Enter group of SBS Server to Broadcast to [%d]",.                     new_process_num.au.group);"             if (read_input() > 0) <                 sscanf(input_line, "%hd", &target.au.group);'             else                       B;                 target.au.group = new_process_num.au.group;              prio = 0;i0             printf("Enter message class [10] ");"             if (read_input() > 0) 2                 sscanf(input_line, "%hd", &class);'             else                       c                 class = 10;d/             printf("Enter message type [10] ");a"             if (read_input() > 0) 1                 sscanf(input_line, "%hd", &type); '             else                       a                 type = 10;?             printf("Enter data to send (terminate with a .) ");d!             if (read_input() > 0)e 	    { B- 	       sscanf(input_line, "%[^.]",msg_area);o<                printf("Enter message size [msg_area_len] ");%                if (read_input() > 0) 0                {3                   sscanf(input_line, "%hd", &size);t6 		  for (i=strlen(msg_area)+1; i < USER_BUF_SIZE; i++) 		     msg_area[i] = (char)i;i                } 	       else*                   size = strlen(msg_area);               } 	 	    elser                  size = 0; 	    saved_size = size;   <             printf("Enter number of messages to send [1] ");"             if (read_input() > 0) 8                sscanf(input_line, "%hd", &num_of_times);	 	    elses 	       num_of_times = 1;   -             for (i=1; i <= num_of_times; i++) 
             { ( 	       status = pams_put_msg(msg_area, +                         &prio, &target.all,y8                         &class, &type, &delivery, &size,1 			&put_timeout, &psb, &uma, &resp_que, 0, 0, 0); !                check_ret(status);( 	    }   	    if ( saved_size > 100 ) 	    {&                start = saved_size-100;.                for (i=start; i<saved_size;i++);                   printf("<%d>x%x(%c) %c", i, msg_area                                                                                                                                                                                                                                                   6                        Tg $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES.SBS]SBS_EXAMPLE.C;1                                                                                               T                         6_ "     5       [i],  L                                       isprint(msg_area[i])? msg_area[i]:'.',<                                       (i+1)%11 ? ' ': '\n'); 	    }             break;             case 7: '             printf("\nPAMS_GET_MSG\n");              prio = 0;e&     	    msg_area_len = USER_BUF_SIZE;0             status = pams_get_msg (rcv_msg_area,+                         &prio, &source.all, 5                         &class, &type, &msg_area_len,                           &length,.                         &get_select.all, &psb, 			0,0,0,0,0);+             if (status == PAMS__NOMOREMSG) 0 	    {.                 printf("Input Queue Empty\n");                 break;
             } "             if(!check_ret(status))                 break;? 	    if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_AVAIL))   	    {: 		    memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));<                     printf("Process '%d.%d' is Available\n",0                       avail.target_PQ.au.group, 8 		      avail.target_PQ.au.process);                     	    }F 	    else if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_UNAVAIL))  	    {: 		    memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));>                     printf("Process '%d.%d' is UnAvailable\n",0                       avail.target_PQ.au.group, $ 		      avail.target_PQ.au.process); 	    }               else   	    { a-                 printf("source = '%d.%d'\n", o8                     source.au.group, source.au.process);2                 printf("class  = '%d'\n", class );2                 printf("type   = '%d'\n", type  );2                 printf("length = '%d'\n", length);&                 printf("User Data\n");   	        if ( length > 100 ) 	           start = length-100;                  else 	           start = 0; p  +                 for (i=start; i<length;i++) A                     printf("<%d>x%x(%c) %c", i, rcv_msg_area[i], .E                        isprint(rcv_msg_area[i])? rcv_msg_area[i]:'.',t-                        (i+1)%11 ? ' ': '\n');  	    }             break;             case 8:"(             printf("\nPAMS_GET_MSGW\n");             prio = 0; &     	    msg_area_len = USER_BUF_SIZE;P             printf("Enter Timeout delay in tenths of a second [%d] ", ACK_WAIT);"             if (read_input() > 0) 4                 sscanf(input_line, "%ld", &timeout);'             else                        #                 timeout = ACK_WAIT;e  w0            status = pams_get_msgw(rcv_msg_area, +                         &prio, &source.all, 5                         &class, &type, &msg_area_len,e                          &length,8                         &timeout, &get_select.all, &psb, 			0,0,0,0,0);"             if(!check_ret(status))                 break;  ? 	    if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_AVAIL)) i 	    {: 		    memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));<                     printf("Process '%d.%d' is Available\n",0                       avail.target_PQ.au.group, 8 		      avail.target_PQ.au.process);                     	    }F 	    else if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_UNAVAIL))  	    {: 		    memcpy(&avail, rcv_msg_area, sizeof (struct AVAIL));>                     printf("Process '%d.%d' is UnAvailable\n",0                       avail.target_PQ.au.group, $ 		      avail.target_PQ.au.process); 	    } d             else
             { ,                printf("source = '%d.%d'\n", 4                 source.au.group, source.au.process);1                printf("class  = '%d'\n", class ); 1                printf("type   = '%d'\n", type  ); 1                printf("length = '%d'\n", length);_%                printf("User Data\n");    	       if ( length > 100 )u 	          start = length-100;                else  	          start = 0;   *                for (i=start; i<length;i++)?                   printf("<%d>x%x(%c) %c", i, rcv_msg_area[i],  C                      isprint(rcv_msg_area[i])? rcv_msg_area[i]:'.',a+                      (i+1)%11 ? ' ': '\n');t
             }              break; ,           case  9:$             printf("\nAVAIL_REG\n");#             AVAIL_reg.version = 20;=P             printf("Enter Target Group (0->255)[%d] ",new_process_num.au.group);"             if (read_input() > 0) I                 sscanf(input_line, "%hd", &AVAIL_reg.target_PQ.au.group); '             else                       aM                 AVAIL_reg.target_PQ.au.group = new_process_num.au.group;      9             printf("Enter Target Address (0->255)[90] "); "             if (read_input() > 0) K                 sscanf(input_line, "%hd", &AVAIL_reg.target_PQ.au.process);,'             else                       c9                 AVAIL_reg.target_PQ.au.process = 90;       	     I             AVAIL_reg.distribution_Q.au.group = new_process_num.au.group; Q             printf("Enter distribution_Q (PAMS Process Q) [My PAMS PQ id '%d'] ", ,                 new_process_num.au.process);1             if (read_input() > 0)                 P                 sscanf(input_line, "%hd", &AVAIL_reg.distribution_Q.au.process);'             else                        C                 AVAIL_reg.distribution_Q.all = new_process_num.all;              prio = 0;S  %             target.au.group  = group;02             target.au.process = PAMS_AVAIL_SERVER;&             type = MSG_TYPE_AVAIL_REG;2             class = MSG_CLAS_PAMS;                -             size = sizeof (struct AVAIL_REG); -             status = pams_put_msg(&AVAIL_reg, +                         &prio, &target.all, 8                         &class, &type, &delivery, &size,1 			&put_timeout, &psb, &uma, &resp_que, 0, 0, 0); #             if (check_ret(status))  ,             {   /* always wait for an ACK */                   aloop = 1;                 while ( aloop )_                 { 0                    printf("Wait for an ACK \n");8                    size = sizeof (struct SBS_REG_REPLY); 		   timeout = ACK_WAIT;
 #ifdef VAXELN  		   sel_addr.all = 0; #elsee 		   sel_addr.au.group = group;,0 	   	   sel_addr.au.process = PAMS_AVAIL_SERVER; #endif9                    status = pams_get_msgw(&SBS_reg_reply, ;                         &prio, &source.all, &class, &type, nD                         &size, &size, &timeout, &sel_addr.all, &psb, 			0,0,0,0,0);1                    if ( status == PAMS__TIMEOUT )_                    {I                       printf ("\nReply took too long. Wait again? Y/N ");=.                       if ( read_input () > 0 )                       {l>                          if (input_line[0] == 'Y' ) aloop = 1;>                          if (input_line[0] == 'y' ) aloop = 1;>                          if (input_line[0] == 'N' ) aloop = 0;>                          if (input_line[0] == 'n' ) aloop = 0;                       }                       }                    else                        break;                 }n  5                 if ( status == PAMS__TIMEOUT ) break;;  F                 if (check_ret(status) && (SBS_reg_reply.status == 1))                  {nR                     printf("AVAIL Registration is o.k.\nNumber of Regs is '%d'\n",0                       SBS_reg_reply.number_reg);                 } W 		else                                                                                 ;                 {s?                     printf("AVAIL Registration is n.g. '%d'\n",t,                       SBS_reg_reply.status);                       break;                 }&  6                 printf("Wait for an AVAIL/UNAVAIL\n");-                 size = sizeof (struct AVAIL);S 		timeout = ACK_WAIT;"
 #ifdef VAXELN\ 		sel_addr.all = 0;  #else: 		sel_addr.au.group = group;- 	   	sel_addr.au.process = PAMS_AVAIL_SERVER;p #endif.                 status = pams_get_msgw(&avail,;                         &prio, &source.all, &class, &type, AF                         &size, &size, &timeout, &get_select.all, &psb, 			0,0,0,0,0);'                 if (check_ret(status))  
 	        {> 		  if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_AVAIL)) <                     printf("Process '%d.%d' is Available\n",L                       avail.target_PQ.au.group, avail.target_PQ.au.process);E 		  else if ((class == MSG_CLAS_PAMS) && (type == MSG_TYPE_UNAVAIL)) e>                     printf("Process '%d.%d' is UnAvailable\n",L                       avail.target_PQ.au.group, avail.target_PQ.au.process); 		}  	        else 
 	        {& 		    printf("PAMS_GET_MSGW error\n"); 		}r
             }s             break;           f           case  10: &             printf("\nAVAIL_DEREG\n");%             AVAIL_dereg.                                                                                                                                                                                                                                                   7                        \> $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES.SBS]SBS_EXAMPLE.C;1                                                                                               T                               F       version = 20; P             printf("Enter Target Group (0->255)[%d] ",new_process_num.au.group);"             if (read_input() > 0) K                 sscanf(input_line, "%hd", &AVAIL_dereg.target_PQ.au.group);l'             else                        O                 AVAIL_dereg.target_PQ.au.group = new_process_num.au.group;      9             printf("Enter Target Address (0->255)[90] ");i"             if (read_input() > 0) M                 sscanf(input_line, "%hd", &AVAIL_dereg.target_PQ.au.process);a'             else                        ;                 AVAIL_dereg.target_PQ.au.process = 90;     rK             AVAIL_dereg.distribution_Q.au.group = new_process_num.au.group; Q             printf("Enter distribution_Q (PAMS Process Q) [My PAMS PQ id '%d'] ", ,                 new_process_num.au.process);"             if (read_input() > 0) R                 sscanf(input_line, "%hd", &AVAIL_dereg.distribution_Q.au.process);'             else                       %S                 AVAIL_dereg.distribution_Q.au.process = new_process_num.au.process;   0             printf("Enter req_ack (Y, N) [Y] ");"             if (read_input() > 0)  	    {-                 sscanf(input_line, "%c", &c); (                 AVAIL_dereg.req_ack = 1;+                 if ((c=='N') || (c == 'n'))0,                     AVAIL_dereg.req_ack = 0;             }   	    else                       (                 AVAIL_dereg.req_ack = 1;               prio = 0;s%             target.au.group  = group;f2             target.au.process = PAMS_AVAIL_SERVER;(             type = MSG_TYPE_AVAIL_DEREG;"             class = MSG_CLAS_PAMS;/             size = sizeof (struct AVAIL_DEREG);   0             status = pams_put_msg(&AVAIL_dereg, +                         &prio, &target.all, 8                         &class, &type, &delivery, &size,1 			&put_timeout, &psb, &uma, &resp_que, 0, 0, 0); A             if (check_ret(status) && (AVAIL_dereg.req_ack == 1))  ( 	    {   /* should we wait for an ACK */-                 printf("Wait for an ACK \n"); 5                 size = sizeof (struct SBS_DEREG_ACK);( 		timeout = ACK_WAIT;S
 #ifdef VAXELN  		sel_addr.all = 0;" #elseu 		sel_addr.au.group = group;- 	   	sel_addr.au.process = PAMS_AVAIL_SERVER;_ #endif6                 status = pams_get_msgw(&SBS_dereg_ack,;                         &prio, &source.all, &class, &type, &D                         &size, &size, &timeout, &sel_addr.all, &psb, 			0,0,0,0,0);F                 if (check_ret(status) && (SBS_dereg_ack.status == 1)) 
 	        {T                     printf("AVAIL DeRegistration is o.k.\nNumber of Regs is '%d'\n",0                       SBS_dereg_ack.number_reg);g                 } else                                                                                 UA                     printf("AVAIL Deregistration is n.g. '%d'\n",	,                       SBS_dereg_ack.status); 	    } /* end wait for ack */              break;&         case 99:                                   loop = 0;sC             printf("\n\n     PAMS SBS & AVAIL Example Complete\n");;             break;         default:5             printf("Invalid selection Try Again!");"5             break;                                             } /* end switch */     } /* end while */            exit(1); } /* end main*/       @ /***************************************************************@     check_ret - checks the return code for success             *@                                                                *@     returns:                                                   *@         0 = an error                                           *@         1 = o.k.                                               *A ****************************************************************/c static int check_ret(sts_value)  {      int desc[2];     char str[256];     short len;     int i,j;                                  #ifdef vms       desc[0] = sizeof (str);C     desc[1] = str;     if (sts_value & 1) g         return (1); E     i = sys$getmsg(sts_value, &len, &desc[0], 15, &j);               s(     str[len] = 0;  /* null out string */?     printf("PAMS ERROR RETURNED '0x%x'\n'%s'", sts_value, str);l     return(0);       ; #else      if (sts_value > 0) 	return(1); 	     else a     { 3 	pams_print_sts("SBS_EXAMPLE", "ERROR", sts_value);A 	return(0);      }  #endif) }                                        )  @ /***************************************************************@     read_input  - reads an input line into global 'input_line' *@                                                                *@     returns:                                                   *@         0 = an error                                           *@         n = # of char read                                     *A ****************************************************************/o static int read_input()  { 
     char *cp;        cp = gets(input_line);       if (cp == NULL)          return(0);     else#         return(strlen(input_line));p }t  lass  = '%d'\n", class               * [DMQ$V20.EXAMPLES]SENDER.C;1 +  , B   .     /     4 P       b                   - B    0   1    2   3      K  P   W   O     5   6 Sd  7  q  8          9 Z  G    H  J                   N /*****************************************************************************  *									     * 3  *  Copyright (c) 1992                   				     * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/       O /******************************************************************************  * Module:    sender  *  * Filename:  sender.c  * M * Function:  Uses a PAMS script file to dispatch messages to various targets.  * ? *	     If the logical name DMQ$SCRIPT is defined to "YES" or to < *	     a filename at program startup, then the pams_attach_q@ *	     call causes the script file to be opened and all messages? *	     in the script file to be queued to the DECLARED process.  * 1 *	     The SENDER program uses the show_buffer to ? *	     decode the header of the message, and passes the message > *	     along to process with a pams id that matches the target *	     specified in the script.  * 6 *	     One use of SENDER is during partial integration1 *	     testing of a number of detached processes. 	 * Inputs:  *	Pams messages. * 
 * Outputs: *       Pams messages. *  * External Subroutines:  *  * Language:  C * 2 * compile: $ cc/list/obj/include=dmq$user sender.c( * link:    $ link sender,dmq$lib:dmq/opt * O ******************************************************************************/    #module sender "V2.00-00"    /* portable includes */  #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "p_entry.h" #include "p_group.h"     #define SS$_NORMAL 1  
 typedef union    {     long int      all; 	    struct       {       short int  process;        short int  group; 
      } au;   } PAMS_ADDRESS;    struct SHOW_BUFFER {    long int version;    long int xfer_status;    long int xfer_size;    long int unused[7];    PAMS_ADDRESS target;   PAMS_ADDRESS orig_target;    PAMS_ADDRESS source;   PAMS_ADDRESS orig_source;    long int delivery_mode;    long int priority;   long int endian; };   struct SHOW_BUFFER show_buffer;    static main () {       unsigned long  requested_id; ;    unsigned long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  8                        , $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]SENDER.C;1PLI;1                                                                                              P                             4U               mypamsid;		/* pams id of this process 	*/   1    unsigned char  prio;			/* message priority		*/ =    unsigned long  source;		/* pams id of source of message */ %    long int       attach_mode,q_type; <    short          mtype;		/* user defined message type    */=    short          mclass;		/* user defined message class   */ C    unsigned short mlen,size;    	/* number of bytes in message   */ ?    unsigned char  delivery;		/* required but not used...     */ >    unsigned long  timeout;		/* timeout in tenths of seconds */A    char           mptr[8192];		/* pointer to input PAMS buffer */ =    unsigned long  sel_addr;		/* message selection criteria	*/ /    struct PSB	  psb;			/* PAMS status block		*/ 3    unsigned long  put_timeout;		/* put timeout			*/ ;    unsigned char  uma;			/* Undeliverable Message Action */ 2    unsigned long  resp_que;		/* response queue		*/     long int       show_buff_len;  <    unsigned long istat;			/* function status return */            typedef struct     {       short local_id;        short group_id;        char  filler [96];    } HEADER_BUF;      HEADER_BUF header;		   J    int loop;                                                                 	/* */  ,         attach_mode = PSYM_ATTACH_TEMPORARY;          q_type = PSYM_ATTACH_PQ;$         delivery = PDEL_MODE_NN_MEM; 	put_timeout = 0;  	uma = PDEL_UMA_DISC;  	resp_que = 0;  
 	loop = 1; 	/* Connect to PAMS */M         istat = pams_attach_q (&attach_mode,&mypamsid,&q_type,0,0,0,0,0,0,0); * 	if (istat != SS$_NORMAL) goto ERROR_EXIT;  
 	while (loop)  	{I           /************************************************************** B 	   * Priority can not be specified in a script, so there are no *B 	   * priority 1 messages. This allows us to use the timeout on  *B 	   * the call to get_msgw as a pacing timer                     *C 	   **************************************************************/ 
 	   prio = 1;  	   timeout = 5;     	   /* filter by default */  	   sel_addr = 0;               mlen = 8192;  	   istat = pams_get_msgw ( ' 		mptr,&prio, &source, &mclass, &mtype, 5 		&mlen, &size,&timeout, &sel_addr, &psb,0,0,0,0,0 ); 7            if (istat != PAMS__TIMEOUT) goto ERROR_EXIT;   + 	  /*************************************** + 	   * now read from the script input file * , 	   ***************************************/
 	   prio = 0;  	   timeout = 15;   0            show_buff_len = sizeof (show_buffer); 	   istat = pams_get_msgw ( ' 		mptr,&prio, &source, &mclass, &mtype, 7 		&mlen, &size, &timeout, &sel_addr, &psb,&show_buffer, '                 &show_buff_len,0,0,0 ); .  	   if (istat != SS$_NORMAL) goto ERROR_EXIT;  G 	  /******************************************************************  F 	   * A message class and type of 0 is interpreted as the end of the *F 	   * script file.                                                   *G 	   ******************************************************************/ : 	   if ( (mclass == 0) && (mtype == 0) ) goto NORMAL_EXIT;    C 	  /*************************************************************** C 	   * SENDING TO OURSELVES CAUSES A NIFTY INFINATE LOOP, SO DONT! * D 	   ***************************************************************/E 	   if ( show_buffer.target.au.process != ( mypamsid & 0x0000ffff ) )             { 	      /* send the message */  	      istat = pams_put_msg ( 9 		mptr, &prio, &show_buffer.target.all, &mclass, &mtype,  P                 &delivery, &mlen, &put_timeout, &psb, &uma, &resp_que,0,0,0 );    / 	      if(istat != SS$_NORMAL) goto ERROR_EXIT;             }    	 	}           ERROR_EXIT:  	lib$signal ( istat );   NORMAL_EXIT: 	; }                                                                                                                                                                                                                                                                                                                                                                                                                                            * [DMQ$V20.EXAMPLES]SENDER.PSS;1 +  , B   .     /     4 <                          - B    0   1    2   3      K  P   W   O     5   6 *)]  7 r  8          9 Z  G    H  J                 < !----------------------------------------------------------	 !SENDER.PSS % !	TEST SCRIPT FILE FOR SENDER PROGRAM  ! 3 !	This script should cause SENDER to send a message   !	of class 1 type 1 to target 1.< !----------------------------------------------------------	  < SET RECEIVE ECHO	!uncomment if you want to see incoming msgs  & SET SEND ECHO		!echo outgoing messages   MSG     SOURCE = SPARE1
    TARGET = 1 
    CLASS  = 1 
    TYPE   = 1     A 'This is a test'  EOM    MSG 
    SOURCE = 1 
    TARGET = 1 
    CLASS  = 1 
    TYPE   = 1     A 'This is a test'  EOM    MSG 
    SOURCE = 1     TARGET = 800 
    CLASS  = 1 
    TYPE   = 1     A 'This is a test'  EOM      MSG 
    SOURCE = 0 
    TARGET = 0 
    CLASS  = 0 
    TYPE   = 0  EOM                                                                                                                                                                                                                                                                              * [DMQ$V20.EXAMPLES]SIMPLE.C;1 +  , B   .     /     4 Q       ~                  - B    0   1    2   3      K  P   W   O 
    5   6 ${'  7 r  8          9 Z  G    H  J                      #module simple_c "V2.0-00"  N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1992                                                       *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/      /*	 	compile: ' 		cc/obj/list/include=dmq$user simple.c    	link:   		link simple,dmq$lib:dmq/opt    	run:            		simple :== $simple 		simple 1 2 */ #include <stdio.h> #include <ssdef.h> #include <stsdef.h>  /* portable includes */  #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "p_entry.h" #include "p_group.h"    
 typedef union    {     long int      all; 	    struct       {       short int  process;        short int  group; 
      } au;   } PAMS_ADDRESS;        static PAMS_ADDRESS	target;  static PAMS_ADDRESS	source;  static long int		sts$value;  static long int		time_out; static long int		proc_num_in; ! static PAMS_ADDRESS	proc_num_out;  static short int	size; static short int	oclass, otype;  static short int	iclass, itype; - static short int	msg_size;                     #define BUF_SIZE 80 6 static char		obuffer[BUF_SIZE+1], ibuffer[BUF_SIZE+1]; static char		delivery;( static short int	priority, rcv_priority; static long int		put_timeout;  struct PSB		psb; static char		uma;  static long int		resp_que;8 static long int		sel_addr,attach_mode,q_type,q_name_len;# static char             q_name[31];    main (argc, argv) 	 int argc;  char **argv; {   2   printf("\n\n\t*** PAMS_SIMPLE beginning ***\n");     sts$value  = 0;    q_type = PSYM_ATTACH_PQ;   if (argc == 1)   { *       attach_mode = PSYM_ATTAC                                                                                                                                                                                                                   9                        4S@ $      DMQ020.B                       B  B  [DMQ$V20.EXAMPLES]SIMPLE.C;1PLI;1                                                                                              Q                             8 
            H_TEMPORARY;       proc_num_in = 0;   }    else   {        strcpy (q_name,argv[1]);*       attach_mode = PSYM_ATTACH_BY_NUMBER;   }      proc_num_out.all = 0;    sts$value  = SS$_NORMAL;  D   sts$value = pams_attach_q (&attach_mode,&proc_num_out.all,&q_type,<                               q_name,&q_name_len,0,0,0,0,0);     if (sts$value != SS$_NORMAL)   {             A      printf("Error returned by PAMS_ATTACH_Q '%d'\n", sts$value);       exit(sts$value);     }  C   printf("\nMy Queue address is '%d.%d'\n", proc_num_out.au.group,  D                                            proc_num_out.au.process);       if (argc < 3) +       target.all        = proc_num_out.all;    else(       target.au.process = atoi(argv[2]);   source.all      = 0;)   time_out        = 50;   /* 5 seconds */    oclass           = 1;    otype            = -123;%   delivery        = PDEL_MODE_NN_MEM;    priority        = 0;   rcv_priority    = 0;   put_timeout	  = 0;   uma		  = PDEL_UMA_DISC;    resp_que	  = 0;    sel_addr	  = 0;                                  for (;;) {       printf("\n"); !       printf("Enter Msg Data: "); !       if (gets(obuffer) == '\0')         {           printf ("Done\n");  	 exit (1);        } #       msg_size = strlen(obuffer)+1;          printf("\n"); ?       sts$value = pams_put_msg(obuffer, &priority, &target.all, + 			  &oclass, &otype, &delivery, &msg_size, 1 			  &put_timeout, &psb, &uma, &resp_que,0,0,0);  "       if (sts$value != SS$_NORMAL)       { =          printf("Error returned by PAMS_PUT_MSG", sts$value);           exit(sts$value);        }	
       elseC          printf ("Sent Msg to '%d.%d' class = '%d', type = '%d'\n", & 		target.au.group, target.au.process,  		oclass, otype);          printf("\n"); D       sts$value = pams_get_msgw(ibuffer, &rcv_priority, &source.all,* 			    &iclass, &itype, &BUF_SIZE, &size, . 			    &time_out, &sel_addr, &psb,0,0,0,0,0); %       if (sts$value == PAMS__TIMEOUT) +          printf("PAMS_GET_MSGW Timeout\n"); '       else if (sts$value != SS$_NORMAL)        { >          printf("Error returned by PAMS_GET_MSGW", sts$value);          exit(sts$value);        } 
       elseQ          printf ("Received from '%d.%d' class = '%d', type = '%d'\nmsg = '%s'\n", & 		source.au.group, source.au.process,  		iclass, itype, ibuffer);        target.all = source.all;   } /* end for loop */  } /* end simple */                                                                                                                                                 - * [DMQ$V20.EXAMPLES]SIMPLE_ADA_RUN_SERVER.COM;1 +  , B   .     /     4                            - B    0   1    2   3      K  P   W   O     5 
  6 @Nc/  7 r  8          9 Z  G    H  J                   $ RUN SIMPLE_SERVER.EXE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   $ * [DMQ$V20.EXAMPLES]SIMPLE_BUILD.COM;1 +  , B   .     /     4 W                         - B    0   1    2   3      K  P   W   O 	    5   6  W2  7 `,r  8          9 Z  G    H  J               
            < $! SIMPLE_BUILD.COM - This command procedure builds both the4 $!		      SIMPLE_CLIENT and SIMPLE_SERVER processes.? $!		      Either the "C", FORTRAN or Ada versions may be built.  $! $! $	VERIFY = F$VERIFY(0) $!= $	SAVE_DIR = F$PARSE("",,,"DEVICE")+F$PARSE("",,,"DIRECTORY")  $!	SET DEFAULT DMQ$EXAMPLES  $! $	ON CONTROL_Y THEN GOTO QUIT  $	ON ERROR THEN GOTO QUIT  $! $	WRITE SYS$OUTPUT -M 	      "
SIMPLE_BUILD - Build the SIMPLE client and server example programs
"  $!4 $! Prompt the user which version they wish to build. $! $10:$ $	READ /END=QUIT SYS$OUTPUT ANSWER -W 	     /PROMPT="Do you wish to build the C, FORTRAN, or Ada version [C, FORTRAN, Ada]? " 4 $	ANSWER = F$EXTRACT(0, 3, F$EDIT(ANSWER, "UPCASE")) $!) $	IF (ANSWER .EQS. "C") THEN GOTO BUILD_C 1 $	IF (ANSWER .EQS. "FOR") THEN GOTO BUILD_FORTRAN - $	IF (ANSWER .EQS. "ADA") THEN GOTO BUILD_ADA K $	WRITE SYS$OUTPUT "%SIMPLE_BUILD-E-INVANS, Must be C, FORTRAN or Ada."+ -  			  "  Re-enter..." 	 $	GOTO 10  $! $! $! Build "C" Version.  $!	 $BUILD_C: 9 $	WRITE SYS$OUTPUT "
   Compiling C client and server..."  $!# $	CC/INCLUDE=DMQ$USER SIMPLE_CLIENT # $	CC/INCLUDE=DMQ$USER SIMPLE_SERVER  $! $	GOTO LINK  $! $! Build FORTRAN version.  $! $BUILD_FORTRAN: ? $	WRITE SYS$OUTPUT "
   Compiling FORTRAN client and server..."  $!1 $	FORTRAN SIMPLE_CLIENT + DMQ$LIB:DMQ.TLB/LIBRARY 1 $	FORTRAN SIMPLE_SERVER + DMQ$LIB:DMQ.TLB/LIBRARY  $! $	GOTO LINK  $! $! Link executable images. $! $! Build Ada version.  $! $BUILD_ADA: 7 $	WRITE SYS$OUTPUT "
   Assuming Ada library is set..." ; $	WRITE SYS$OUTPUT "
   Compiling Ada client and server..."  $! $	ADA SIMPLE_CLIENT  $	ADA SIMPLE_SERVER  $!0 $	WRITE SYS$OUTPUT "   Linking SIMPLE_CLIENT..."- $	ACS LINK SIMPLE_CLIENT  DMQ$LIB:DMQ/OPTIONS  $!0 $	WRITE SYS$OUTPUT "   Linking SIMPLE_SERVER..."- $	ACS LINK SIMPLE_SERVER  DMQ$LIB:DMQ/OPTIONS  $! $	GOTO DONE  $! $! Link executable images. $! $LINK:0 $	WRITE SYS$OUTPUT "   Linking SIMPLE_CLIENT...") $	LINK SIMPLE_CLIENT ,DMQ$LIB:DMQ/OPTIONS  $!0 $	WRITE SYS$OUTPUT "   Linking SIMPLE_SERVER..."* $	LINK SIMPLE_SERVER , DMQ$LIB:DMQ/OPTIONS $! $! All done, exit. $! $DONE:N $	WRITE SYS$OUTPUT "
SIMPLE_BUILD-I-DONE, SIMPLE examples successfully built." $	SET DEFAULT 'SAVE_DIR' $	VERIFY = F$VERIFY(VERIFY)  $	EXIT $! $! User QUIT exit. $! $QUIT:D $	WRITE SYS$OUTPUT "SIMPLE_BUILD-W-QUIT, SIMPLE examples not built." $	SET DEFAULT 'SAVE_DIR' $	VERIFY = F$VERIFY(VERIFY)  $	EXIT                                                                        % * [DMQ$V20.EXAMPLES]SIMPLE_CLIENT.ADA;1 +  , B   . (    /     4 \   (   &                     - B    0   1    2   3      K  P   W   O )    5   6 @X  7 `8r  8          9 Z  G    H  J                           --N --****************************************************************************N --*                                                                          *O --*  Copyright (c) 1990, 1991, 1992                                           * N --*  by DIGITAL Equipment Corporation, Maynard, Mass.                        *N --*                                                                          *N --*  This software is furnished under a license and may be used and  copied  *N --*  only  in  accordance  with  the  terms  of  such  license and with the  *N --*  inclusion of the above copyright notice.  This software or  any  other  *N --*  copies  thereof may not be provided or otherwise made available to any  *N --*  other person.  No title to and ownership of  the  software  is  hereby  *N --*  transferred.                                                            *N --*                                                                          *N --*  The information in this software is subject to change  without  notice  *N --*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *N --*  Corporation.                                                            *N --*                                                                          *N --*  DIGITAL assumes no responsibility for the use or  reliability  of  its  *N --*  software on equipment which is not supplied by DIGITAL.                 *N --*                                                                          *N --****************************************************************************  P --------------------------------------------------------------------------------8 -- SIMPLE_CLIENT - A simple example of a client program.A --                                                                F -- This program provides an example of a very simplistic client.  It'sL -- main function is to allow the user to enter messages that will be sent to+ -- the SIMPLE_SERVER program's queue.       A --                                                                                                                                                                                                                                                                                                                                                                                                                                                :                        > $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES]SIMPLE_CLIENT.ADA;1                                                                                          \     (                         ˌ "                                              O -- The first prompt asks the user if he/she wishes to start the server program. K -- If the user answers "Y"es, the SIMPLE_SERVER program is started.  If the I -- answer is "N"o, the server is not run, and SIMPLE_CLIENT will send the  -- messages to it's own queue.A --                                                                A -- SIMPLE_CLIENT has the following logic flow:                    A --                                                                A --                +---------------------------+                   A --                |  Attach program to bus    |                   A --                |  using PAMS_ATTACH_Q      |                   A --                +---------------------------+                   A --                              |                                 A --                +---------------------------+                   A --                | Prompt user to start the  |                   A --                | server process.  If Y     |                   A --                | start SIMPLE_SERVER. If N |                   A --                | set-up to loop to ourself |                   A --                +---------------------------+                   A --                              |                                 A --                +---------------------------+                   A --                | Initialize Variables, etc.|                   A --                +---------------------------+                   A --            +---------------->|                                 A --            |   +---------------------------+     +----------+  A --            |   |   Wait for user to enter  |     | <ctrl-Z> |  A --            |   |   a message.              |---->|   exit   |  A --            |   +---------------------------+     +----------+  A --            |                 |                                 A --            |   +---------------------------+                   A --            |   |   Send user message to    |                   A --            |   | server (or ourself) using |                   A --            |   |       PAMS_PUT_MSG        |                   A --            |   +---------------------------+                   A --            |                 |                                 A --            |   +---------------------------+                   A --            |   |   Wait for a reply from   |                   A --            |   | the server (or our msg.)  |                   A --            |   |       PAMS_GET_MSGW       |                   A --            |   +---------------------------+                   A --            |                 |                                 A --            +---------<-------+                                 A --                                                                A -- To build SIMPLE_CLIENT and SIMPLE_SERVER use the SIMPLE_BUILD  A -- command procedure.  If you wish to compile and link this       A -- program manually you may use the following commands:           A --                                                                + --     $ ACS SET LIBRARY [your_ada_library] + --     $ ADA SIMPLE_CLIENT                  C --     $ ACS LINK SIMPLE_CLIENT DMQ$LIB:DMQ/OPT                     A --                                                                < -- To execute: $ RUN SIMPLE_CLIENT                          A --                                                                P --------------------------------------------------------------------------------  4 -- Include standard system definition and I/O units. --F with STARLET;                           -- VMS System Service routines with SYSTEM; with CONDITION_HANDLING; with INTEGER_TEXT_IO; 
 with TEXT_IO;  with CDD_TYPES; D with LIB;                               -- Run Time Library routinesC with STR;                               -- String handling routines   * -- Include PAMS specific definition units. --J with PAMS_ADA_ENTRY_POINT;              -- PAMS function type declarationsK with PAMS_ADA_PROCESS;                  -- Known Process number definitions I with PAMS_ADA_GROUP;                    -- Known Group number definitions I with PAMS_ADA_TYPE_CLASS;               -- Generic Type/Class definitions F with PAMS_ADA_RETURN_STATUS_DEF;        -- PAMS Function return statusH with PAMS_ADA_SYMBOL_DEF;               -- Generic PSEL/PDEL definitions   use SYSTEM;  use CONDITION_HANDLING;  use INTEGER_TEXT_IO; use TEXT_IO; use CDD_TYPES;   use PAMS_ADA_ENTRY_POINT;  use PAMS_ADA_PROCESS;  use PAMS_ADA_GROUP;  use PAMS_ADA_TYPE_CLASS; use PAMS_ADA_RETURN_STATUS_DEF;  use PAMS_ADA_SYMBOL_DEF;   procedure SIMPLE_CLIENT is  2     GET_BUF_SIZE        : constant INTEGER := 109;1     PUT_BUF_SIZE        : constant INTEGER := 80; 1     RESPONSE_SIZE       : constant INTEGER := 29;   9     -- Define data type for PAMS target/source addresses.      --     type Q_ADDRESS is          record(             QUEUE       : SHORT_INTEGER;(             GROUP       : SHORT_INTEGER;         end record;   4     -- Declare local variables, pointers, and arrays     --L     SERVER              : STRING (1..1);        -- Answer from server promptI     STATUS              : COND_VALUE_TYPE;      -- Completion status code   \     QUEUE_NUMBER        : INTEGER;                           -- Actual queue number returnedN     QUEUE_NUMBER_ADDR   : Q_ADDRESS;                         -- Q address formM     QUEUE_TYPE          : INTEGER := PSYM_ATTACH_PQ;         -- Primary queue H     QUEUE_NAME          : STRING (1..13) := "SIMPLE_CLIENT"; -- Our nameK     QUEUE_NAME_LEN      : INTEGER := 13;                     -- Name length   F     SEARCH_LIST         : INTEGER_ARRAY (1..3) := (1 => PSEL_TBL_PROC,E                                                    2 => PSEL_TBL_GRP, J                                                    3 => PSEL_TBL_DNS_LOW);#     SEARCH_LIST_LEN	: INTEGER := 3;   D     PSB                 : PSB_TYPE;             -- PAMS status blockM     IN_BUF_SIZE         : INTEGER;              -- Length of the input buffer   6     for QUEUE_NUMBER_ADDR use at QUEUE_NUMBER'address;  ;     -- Define outbound ("put") message variables and arrays      --?     SOURCE              : Q_ADDRESS;            -- Source queue G     SOURCE_ADDR         : INTEGER;              -- Source queue address E     PUT_BUFFER          : STRING (1..PUT_BUF_SIZE); -- Message buffer G     PUT_BUFFER_ARRAY    : SYSTEM.UNSIGNED_BYTE_ARRAY (1..PUT_BUF_SIZE); E     PUT_CLASS           : SHORT_INTEGER;        -- Message class code @     PUT_DELIVERY        : SHORT_SHORT_INTEGER;  -- Delivery modeC     PUT_PRIORITY        : SHORT_SHORT_INTEGER;  -- Message priority A     PUT_RESP_QUE        : INTEGER;              -- Response queue ?     PUT_SIZE            : SHORT_INTEGER;        -- Message size K     PUT_TIMEOUT         : INTEGER;              -- Time-out for blocked msg D     PUT_TYPE            : SHORT_INTEGER;        -- Message type codeK     PUT_UMA             : SHORT_SHORT_INTEGER;  -- Undeliverable msg action   3     for PUT_BUFFER_ARRAY use at PUT_BUFFER'address; *     for SOURCE_ADDR use at SOURCE'address;  :     -- Define inbound ("get") message variables and arrays     --?     TARGET              : Q_ADDRESS;            -- Target queue G     TARGET_ADDR         : INTEGER;              -- Target queue address E     GET_BUFFER          : STRING (1..GET_BUF_SIZE); -- Message buffer G     GET_BUFFER_ARRAY    : SYSTEM.UNSIGNED_BYTE_ARRAY (1..GET_BUF_SIZE); E     GET_CLASS           : SHORT_INTEGER;        -- Message class code C     GET_PRIORITY        : SHORT_SHORT_INTEGER;  -- Message priority I     GET_SELECT          : INTEGER;              -- Message selection mask ?     GET_SIZE            : SHORT_INTEGER;        -- Message size K     GET_TIMEOUT         : INTEGER;              -- Time-out for blocked msg D     GET_TYPE            : SHORT_INTEGER;        -- Message type code  3     for GET_BUFFER_ARRAY use at GET_BUFFER'address; *     for TARGET_ADDR use at TARGET'address;   begin   2     PUT_LINE ("SIMPLE_CLIENT - Example starting");  4     -- Call PAMS attach Q to attach our program to a3     -- temporary queue and assign our queue number.      --)     PAMS_ATTACH_Q (STATUS      => STATUS,g8                    ATTACH_MODE => PSYM_ATTACH_TEMPORARY,/                    Q_ATTACHED  => QUEUE_NUMBER,,1                    Q_TYPE      => PSYM_ATTACH_PQ, -                    Q_NAME      => QUEUE_NAME, 2                    Q_NAME_LEN  => QUEUE_NAME_LEN);  3     if not CONDITION_HANDLING.SUCCESS (STATUS) theno6         PUT ("Er                                                                                                                                                                                                                                                   ;                        8T $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES]SIMPLE_CLIENT.ADA;11                                                                                         \     (                         c "            ror returned by PAMS_ATTACH_Q code=");2         PUT (ITEM => INTEGER(STATUS), WIDTH => 3);         raise PROGRAM_ERROR;     end if;*  )     -- The attach was successful continue      --     PUT ("Attached to "); ?     PUT (ITEM => INTEGER(QUEUE_NUMBER_ADDR.GROUP), WIDTH => 3);i     PUT (".");?     PUT (ITEM => INTEGER(QUEUE_NUMBER_ADDR.QUEUE), WIDTH => 3); 
     NEW_LINE;   <     -- Ask the user if he/she wishes start the SIMPLE_SERVERK     -- to receive the messages.  If not, then send the messages to ourself.u     --     loop@         PUT ("Do you wish to start the server process [Y/N]? ");         GET (ITEM => SERVER); * 	STR.UPCASE (STATUS             => STATUS,1                     DESTINATION_STRING => SERVER, 2                     SOURCE_STRING      => SERVER);. 	exit when ((SERVER = "N") or (SERVER = "Y"));
     end loop;t  H     -- If the user answered "Y"es SPAWN a subprocess to invoke a commandH     -- procedure to start the server.  Else, set the target queue to our     -- own queue.*     --     if SERVER = "Y" then  ,         LIB.SPAWN (STATUS         => STATUS,$                    COMMAND_STRING =>P                    "@DMQ$EXE:DMQ$PROCESS_START SIMPLE_SERVER.EXE SIMPLE_SERVER",:                    OUTPUT_FILE    => "SIMPLE_SERVER.OUT");  7         if not CONDITION_HANDLING.SUCCESS (STATUS) thenl?             PUT_LINE ("Error starting SIMPLE_SERVER process.");w         else9             PUT_LINE ("Starting SIMPLE_SERVER process.");o         end if;   H         -- Use PAMS_LOCATE_Q find the address of our server.  The server;         -- process must attach to the SPARE1 queue by name.e
         --5         PAMS_LOCATE_Q (STATUS              => STATUS,g7                        Q_NAME              => "SPARE1",s0                        Q_NAME_LEN          => 6,:                        Q_ADDRESS           => TARGET_ADDR,;                        WAIT_MODE           => PSYM_WF_RESP,l:                        NAME_SPACE_LIST     => SEARCH_LIST,?                        NAME_SPACE_LIST_LEN => SEARCH_LIST_LEN);   7         if not CONDITION_HANDLING.SUCCESS (STATUS) then ;             PUT ("Error returned by PAMS_LOCATE_Q code= "); .             PUT (INTEGER(STATUS), WIDTH => 3);             NEW_LINE;  	end if;       else?         TARGET_ADDR := QUEUE_NUMBER; -- Target is our own queue K         PUT_LINE ("Server not started. Messages will be sent to ourself.");-     end if;   E     -- Initialize the variables that we will be using for messaging.       --E     GET_PRIORITY := 0;                  -- Receive all messages      -I     GET_TIMEOUT  := 600;                -- 60 second time-out on GET_MSGW D     GET_SELECT   := 0;                  -- No special selection mask?     PUT_CLASS    := 1;                  -- Send class 1 message C     PUT_TYPE     := -123;               -- Msg type is user defined D     PUT_PRIORITY := 0;                  -- Send at standard priorityC     PUT_RESP_QUE := 0;                  -- Response queue - default C     PUT_TIMEOUT  := 0;                  -- Accept standard time-out-D     PUT_DELIVERY := PDEL_MODE_NN_MEM;   -- No notify, memory queuingC     PUT_UMA      := PDEL_UMA_DISC;      -- Discard if undeliverable        SKIP_LINE;  >     -- Prompt for a message send it to the server and wait forC     -- a response from the server. Quit when user presses <ctrl-Z>.-     --     loop
         begin   E         -- Prompt for and read the message. If <ctrl-Z> is pressed we          -- are done. -
         -->         PUT_LINE ("Enter message or press <ctrl-Z> to exit:");         PUT (">");&         PUT_BUFFER := (others => ' ');;         GET_LINE (ITEM => PUT_BUFFER, LAST => IN_BUF_SIZE);S/         PUT_SIZE := SHORT_INTEGER(IN_BUF_SIZE);   @         -- Send the message to the target queue.  If an error isK         -- returned, report it and exit. Otherwise, display class and type.-
         --2         PAMS_PUT_MSG (STATUS            => STATUS,<                       MSG_AREA          => PUT_BUFFER_ARRAY,8                       PRIORITY          => PUT_PRIORITY,7                       TARGET_Q          => TARGET_ADDR, 5                       MSG_CLASS         => PUT_CLASS, 4                       MSG_TYPE          => PUT_TYPE,8                       DELIVERY          => PUT_DELIVERY,4                       MSG_SIZE          => PUT_SIZE,7                       TIMEOUT           => PUT_TIMEOUT, /                       PAMS_STATUS_BLOCK => PSB,h3                       UMA               => PUT_UMA,t9                       RESP_Q            => PUT_RESP_QUE);    7         if not CONDITION_HANDLING.SUCCESS (STATUS) then :             PUT ("Error returned by PAMS_PUT_MSG code= ");.             PUT (INTEGER(STATUS), WIDTH => 3);             NEW_LINE;          else)             PUT ("CLIENT: Sent Msg to "); <             PUT (ITEM => INTEGER(TARGET.GROUP), WIDTH => 3);             PUT (".");<             PUT (ITEM => INTEGER(TARGET.QUEUE), WIDTH => 3);             PUT (" class=");9             PUT (ITEM => INTEGER(PUT_CLASS), WIDTH => 3);-             PUT (" type=");-8             PUT (ITEM => INTEGER(PUT_TYPE), WIDTH => 3);             NEW_LINE;n         end if;A  G         -- Now wait for the server process to send the reply message.  ;F         -- If time-out status returned, report it and continue. If anyG         -- other error, report it and exit. Otherwise, display what was          -- received.
         --&         GET_BUFFER := (others => ' ');3         PAMS_GET_MSGW (STATUS            => STATUS,-=                        MSG_AREA          => GET_BUFFER_ARRAY, 9                        PRIORITY          => GET_PRIORITY,o8                        SOURCE_Q          => SOURCE_ADDR,6                        MSG_CLASS         => GET_CLASS,5                        MSG_TYPE          => GET_TYPE, H                        AREA_LENGTH       => SHORT_INTEGER(GET_BUF_SIZE),5                        MSG_LENGTH        => GET_SIZE,G7                        SEL_ADDR          => GET_SELECT,O8                        RCV_TMO           => GET_TIMEOUT,1                        PAMS_STATUS_BLOCK => PSB);P  %         if STATUS = PAMS_TIMEOUT thenA/             PUT_LINE ("PAMS_GET_MSGW Timeout"); :         elsif not CONDITION_HANDLING.SUCCESS (STATUS) then;             PUT ("Error returned by PAMS_GET_MSGW code= ");_.             PUT (INTEGER(STATUS), WIDTH => 3);             NEW_LINE;a(             exit;   -- We're out of here         else/             PUT ("CLIENT: Received Msg from ");E<             PUT (ITEM => INTEGER(TARGET.GROUP), WIDTH => 3);             PUT (".");<             PUT (ITEM => INTEGER(TARGET.QUEUE), WIDTH => 3);             PUT (" class=");9             PUT (ITEM => INTEGER(PUT_CLASS), WIDTH => 3);              PUT (" type=");m8             PUT (ITEM => INTEGER(PUT_TYPE), WIDTH => 3);             NEW_LINE;               if SERVER = "Y" then=                 PUT_LINE (GET_BUFFER (1..INTEGER(GET_SIZE)));              else@                 GET_BUFFER (RESPONSE_SIZE+1..INTEGER(GET_SIZE) +P                             RESPONSE_SIZE) := GET_BUFFER (1..INTEGER(GET_SIZE));1                 GET_BUFFER (1..RESPONSE_SIZE) := -P                                                 "Response from SIMPLE_CLIENT: ";K                 PUT_LINE (GET_BUFFER (1..INTEGER(GET_SIZE)+RESPONSE_SIZE));O             end if;          end if;            exceptionS9             when END_ERROR => exit; -- Control-Z detected          end;  B     -- Go back and wait for user to enter another message to send.     --
     end loop;     5         -- User entered <ctrl-Z>. Clean-up, and exit.EE         -- If the server process was started, then use DELPRC to stopR         -- the server process.
         --         if SERVER = "Y" then-             STARLET.DELPRC (STATUS => STATUS, 7                             PRCNAM => "SIMPLE_SERVER");O9             PUT_LINE ("Stopping SIMPLE_SERVER process.");d         end if;U  $         -- Dettach from message bus.
         --%         PAMS_EXIT (STATUS => STATUS);T  *         -- Tell user we're done then exit.
         --.         PUT_LINE ("SIMPLE_CLIENT - Finished");   end SIMPLE_CLIENT;RY        : SHORT_SHORT_INTEGER;  -- Delivery modeC     PUT_PRIORITY        : SHORT_SHORT_INTEGER;  -- Message priority A     PUT_RESP_QUE        : INTEGER;              -- Response queue ?     PUT_SIZE            : SHORT_INTEGER;        -- Message size K     PUT_TIMEOUT         : INTEGER;              -- Time-out for blocked msg D     PUT_TYPE            : SHORT_INTEGER;        -- Message type codeK     PUT_UMA             : SHORT_SHORT_INTEGER;  -- Undeliverable msg action   3     for                                                                                                                                                                                                                                                    <                        !u $      DMQ020.B                       B  B  #[DMQ$V20.EXAMPLES]SIMPLE_CLIENT.C;11                                                                                           R    (                         '              # * [DMQ$V20.EXAMPLES]SIMPLE_CLIENT.C;1 +  , B   . (    /     4 R   (   ' Z                  - B    0   1    2   3      K  P   W   O )    5   6 @t6  7 `'Er  8          9 Z  G    H  J                             N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1991                                                       *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/    /*D  * SIMPLE_CLIENT - A simple example of a DECmessageQ client program.  *I  * This program provides an example of client program. It's main function D  * is to allow the user to enter messages that are sent to a partnerG  * program's queue. The program source code is portable and can be used H  * on non-VMS platforms; provided the server process is already running.  *,  * The SIMPLE_CLIENT program can be used to:)  *   1) Send messages to itself (default) @  *   2) Send messages to a running SIMPLE_SERVER process, in any  *      DECmessageQ group.<  *   3) Start a SIMPLE_SERVER (VMS systems only) in the same  *      DECmessageQ group.  *.  * SIMPLE_CLIENT has the following logic flow:  */  *                +---------------------------+ /  *                |  Process command line     | /  *                |  options.                 | /  *                +---------------------------+ /  *                              |               /  *                +---------------------------+ /  *                |         Attach to         | /  *                |  message queue using the  | /  *                |     PAMS_ATTACH_Q call    | /  *                +---------------------------+ /  *                              |               /  *                +---------------------------+ /  *                | Start server if requested | /  *                +---------------------------+ /  *                              |               /  *            +---------------->|               !  *            |                 | @  *            |   +---------------------------+     +----------+@  *            |   |   Wait for user to enter  |     |   EOF    |@  *            |   |   a message.              |---->|   exit   |@  *            |   +---------------------------+     +----------+/  *            |                 |               /  *            |   +---------------------------+ /  *            |   |   Send user message to    | /  *            |   | server (or ourself) using | /  *            |   |       PAMS_PUT_MSG        | /  *            |   +---------------------------+ /  *            |                 |               /  *            |   +---------------------------+ /  *            |   |   Wait for a reply from   | /  *            |   | the server (or our msg.)  | /  *            |   |       PAMS_GET_MSGW       | /  *            |   +---------------------------+ /  *            |                 |               /  *            +---------<-------+                 *1  * To build SIMPLE_CLIENT on DECmessageQ for VMS:   *G  * Use the SIMPLE_BUILD command procedure, or compile and link manually #  * by using the following commands: /  *                                              0  *  $ CC/LIST/OBJ/INCLUDE=DMQ$USER SIMPLE_CLIENT(  *  $ LINK SIMPLE_CLIENT,DMQ$LIB:DMQ/OPT  *F  * If you want to specify options when running the SIMPLE_CLIENT, then/  * you must define a foreign symbol as follows:   *  -  *  $ CLIENT :== $ DMQ$EXAMPLES:SIMPLE_CLIENT   *=  * To build SIMPLE_CLIENT on non-DECmessageQ for VMS systems:   *G  * Compile with the "p_xxxx.h" include files, and link with DECmessageQ G  * according to the documentation; producing an executable image called   * "CLIENT".  */   - /* standard "C" and system definition files.    */ P #include <stdio.h>                         /* standard I/O definitions        */P #include <stdlib.h>                        /* standard library definitions    */
 #ifdef VMSR #include <ssdef.h>                           /* VMS system service return codes */R #include <stsdef.h>                          /* VMS system service status codes */R #include <descrip.h>                         /* Character descriptor macros     */R #include <lib$routines.h>                    /* LIB$SPAWN                       */R #include <signal.h>                          /* for sleep() call                */ #include <lnmdef.h>  #endif /* portable includes */  #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "p_entry.h" #include "p_group.h"    " $DESCRIPTOR (server_process, " "); $DESCRIPTOR (cmd_string, " "); unsigned long    lflags = 1;  static char command_string[132];  P #define BUF_SIZE 512                       /* Buffer size for local buffers   */  < /* Define data type for DECmessageQ target/source addresses.  */ 
 typedef union     {    long int      all; 	    struct        {        short int  queue;        short int  group;        } au;     } Q_address;   0 /* Declare local variables, pointers, and arrays */P char        use_server;                    /* talk to the server with Ultrix  */P char        start_server;                  /* Input to server question        */P long int    status;                        /* Completion status code          */  P long int    attach_mode;                   /* Attach mode for PAMS_ATTACH_Q   */P long int    queue_type;                    /* Queue type for PAMS_ATTACH_Q    */P char        queue_name[32];                /* Queue name for PAMS_ATTACH_Q    */P long int    queue_name_length;             /* Length of queue name            */P long int    search_list[3] =               /* List of tables to search        */$                     { PSEL_TBL_PROC,#                       PSEL_TBL_GRP, )                       PSEL_TBL_DNS_LOW }; P long int    search_list_len = 3;           /* Elements in search list         */  P Q_address   queue_number;                  /* Actual queue number             */P struct PSB  psb;                           /* DECmessageQ status block        */  7 /* Define outbound ("put") message variables and arrays  */P Q_address   target;                        /* Target queue address            */P char        put_buffer[BUF_SIZE+1];        /* Message buf. +1 null byte       */P short int   put_priority;                  /* Message priority                */P short int   put_class;                     /* Message class code              */P short int   put_type;                      /* Message type code               */P char        put_delivery;                  /* Delivery mode                   */P long int    put_resp_que;                  /* Response queue                  */P short int   put_size;                      /* Message size                    */P long int    put_timeout;                   /* Time to wait for delivery       */P char        put_uma;                       /* Undeliverable msg action        */  6 /* Define inbound ("get") message variables and arrays */P Q_address   source;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       =                        D* $      DMQ020.B                       B  B  #[DMQ$V20.EXAMPLES]SIMPLE_CLIENT.C;11                                                                                           R    (                         W "                               /* Source queue address            */P char        get_buffer[BUF_SIZE+1];        /* Message buf. +1 null byte       */P short int   get_priority;                  /* Message priority                */P short int   get_class;                     /* Message class code              */P short int   get_type;                      /* Message type code               */P long int    get_select;                    /* Message selection mask          */P short int   get_size;                      /* Message size                    */P long int    get_timeout;                   /* Time to wait for message        */   main(argc,argv)  int   argc; 
 char  **argv;  { /     short           msg_area_size = BUF_SIZE+1;      static char     disk[256];     static char     root[256];     static char     bus[5];      static char     group[6]; "     static char     bus_group[13];     static long int pid;     static char     *ptr;   4     printf ("\n\nSIMPLE_CLIENT - Example starting");  5     /* Setup parameters being passed to PAMS_ATTACH_Q       */ "     sprintf (queue_name, "%d", 0);+     queue_name_length = strlen(queue_name);   "     queue_type   = PSYM_ATTACH_PQ;)     attach_mode  = PSYM_ATTACH_TEMPORARY;   >     /* Call PAMS_ATTACH_Q to attach our program to a temporary)      * queue and assign our queue number.       */ I     status = pams_attach_q (&attach_mode, &queue_number.all, &queue_type, K                             queue_name, &queue_name_length, 0, 0, 0, 0, 0);         if (status != PAMS__SUCCESS)     { @         printf ("\nError returned by PAMS_ATTACH_Q %d", status);         exit (status);     }     
 #ifdef VMSG     /* Ask the user if he/she wishes to start the SIMPLE_SERVER program J      * to receive the messages. If not, then send the messages to ourself.      */      do     { G         printf ("\n\nDo you wish to start the server process [Y/N]? "); ,         start_server = toupper(getc(stdin));9     } while (start_server != 'Y' && start_server != 'N');   A     /* If the user answered "Y"es, then use the system() function*<      * to spawn a subprocess to run the DCL command to startD      * the server.  If not, then send the messages to our own queue.      */      if (start_server == 'Y')     { .         status = app_trnlnm ("DMQ$DISK",disk);!         if (status != SS$_NORMAL) 	         { D           printf ("\n Error translating DMQ$DISK code = %d",status);           exit (status);	         }u.         status = app_trnlnm ("DMQ$ROOT",root);!         if (status != SS$_NORMAL) 	         { D           printf ("\n Error translating DMQ$ROOT code = %d",status);           exit (status);	         } 8         status = app_trnlnm ("DMQ$BUS_GROUP",bus_group);!         if (status != SS$_NORMAL) 	         { I           printf ("\n Error translating DMQ$BUS_GROUP code = %d",status);            exit (status);	         } %         ptr = strchr (bus_group,'_');          if (ptr == NULL)	         { D            printf ("\n Error finding _ character in DMQ$BUS_GROUP");            exit (0);	         }*         else	         {eG            *ptr = NULL;   /* divide bus and group up with terminator */ 	         } 7         strcpy (bus,bus_group);    /* get bus number */ <         strcpy (group,&bus_group[5]); /* get group number */          sprintf (command_string,@             "@%s[%s.examples]simple_run_server.com %s %s %s %s",@                                  disk,root,disk,root,bus,group);:         cmd_string.dsc$w_length  = strlen(command_string);2         cmd_string.dsc$a_pointer = command_string;         +         printf("\nStarting the server..."); :         if ((status = (long) lib$spawn (&cmd_string, 0, 0,3                                         &lflags, 0,lO                                         &pid, 0, 0, 0, 0, 0, 0)) == SS$_NORMAL)e	         {sP             sleep(10);                     /* Give server time to report      */	         }*         else	         {o?             printf("\nServer startup failed error returned %d",L                    status); 6             printf("\nServer may already be running");	         }o  H         /* Use PAMS_LOCATE_Q find the address of our server.  The server4          * process must attach to the QUEUE_1 queue.          */m4         printf("\nAttempting to locate the server");         queue_name_length = 7;>         status = pams_locate_q ("QUEUE_1", &queue_name_length,@                                 &target.all, &PSYM_WF_RESP, 0,0,C                                 &search_list, &search_list_len, 0);   $         if (status != PAMS__SUCCESS)	         { J             printf ("\nError returned by PAMS_LOCATE_Q code= %d", status);             exit (status);	         }e!         printf("\nServer found");      }A     else     { &         target.all = queue_number.all;I         printf("\nServer not started. Messages will be sent to ourself");      }  #else-     do {I        printf ("\n\nDo you want to send messages to the server [Y/N]? "); )        use_server = toupper(getc(stdin)); 5     } while (use_server != 'Y' && use_server != 'N');        if (use_server == 'N')%        target.all = queue_number.all; 
     else {        target.au.queue = 1;-        target.au.group = 0;*          do { O           printf("\nWhat is the server group number [%d] ? ", target.au.group); (           scanf("%d", &target.au.group);C        } while ((target.au.group < 0) || (target.au.group > 9999));      }  #endif  D     /* Initialize the variables that we will be using for messaging.      */ P     get_priority = 0;                      /* Receive all priority messages   */P     get_timeout  = 600;                    /* Wait 60 seconds for a message   */P     get_select   = 0;                      /* No special selection mask       */  P     put_class    = 1;                      /* Send class 1 message            */P     put_priority = 0;                      /* Send at standard priority       */P     put_resp_que = 0;                      /* Response queue - default        */P     put_type     = -123;                   /* Message type is program defined */P     put_timeout  = 0;                      /* Accept standard put timeout     */P     put_delivery = PDEL_MODE_NN_MEM;       /* No notify, memory queuing       */P     put_uma      = PDEL_UMA_DISC;          /* Discard if undeliverable        */  2     printf ("\n\nSIMPLE_CLIENT Configuration:\n");C     printf ("Attached to    %d.%d\n", (int) queue_number.au.group, rC                                       (int) queue_number.au.queue);s4     printf ("Message Class: %d\n", (int) put_class);3     printf ("Message  Type: %d\n", (int) put_type);e=     printf ("Target  Queue: %d.%d\n", (int) target.au.group, c=                                       (int) target.au.queue);u  
     while (1)i     {xI         /* Clear type-ahead buffer, then prompt for and read the message.dI          * If EOF (CTRL/Z on VMS, CTRL/C on U*IX), we are done, break outn          * of the loop.           */e         fflush (stdin); N         printf ("\n\nEnter message (up to %d characters), or generate an EOF",         BUF_SIZE);  
 #ifdef VMS     printf (" (CTRL/Z)");/ #endif       printf (" to exit\n");     printf (">");t(     if (gets(put_buffer) == '\0') break;  F         /* Set put message size to buffer length (+1 to include null).          */t(         put_size = strlen(put_buffer)+1;  %         if (put_size > msg_area_size)h	         { %             put_size = msg_area_size; 6             printf ("Input exceeds buffer maximum; ");D             printf ("truncating to %d characters\n", msg_area_size);	         }h  H         /* Send the message to the target process queue.  If an error isH          * returned, report it and exit, otherwise display class & type.          */lK         if ((status = pams_put_msg (put_buffer, &put_priority, &target.all, I                                     &put_class, &put_type, &put_delivery, L                                     &put_size, &put_timeout, &psb, &put_uma,N                                     &put_resp_que, 0, 0, 0)) != PAMS__SUCCESS)  	         { J             printf ("\nError returned by PAMS_PUT_MSG code=%d\n", status);             exit (status);
         }       I         printf ("\nSIMPLE_CLIENT: Sent Msg to %d.%d class=%d, type=%d\n", 2                 target.au.group, target.au.queue, %                 put_class, put_type);   E         /* Now wait for the server process to send the reply message. F          * If a timeout occured, report it and continue.  If any otherL          * error, report it and exit.  Otherwise, display what was received.          */ L         if                                                                                                                                                                                                                                                   >                         $      DMQ020.B                       B  B  #[DMQ$V20.EXAMPLES]SIMPLE_CLIENT.C;1;1                                                                                          R    (                         r      "        ((status = pams_get_msgw (get_buffer, &get_priority, &source.all,K                                      &get_class, &get_type, &msg_area_size,=K                                      &get_size,  &get_timeout, &get_select,SL                                      &psb, 0, 0, 0, 0, 0)) == PAMS__TIMEOUT)/             printf ("PAMS_GET_MSGW Timeout\n");;  )         else if (status != PAMS__SUCCESS) 	         {rI             printf ("Error returned by PAMS_GET_MSGW code=%d\n", status);              exit (status);	         }          else	         {bM             printf ("\nSIMPLE_CLIENT: Received from %d.%d class=%d, type=%d", K                     source.au.group, source.au.queue, get_class, get_type); 4             printf ("\nMessage='%s'\n", get_buffer);	         } &    } /* End of main processing loop */ y
 #ifdef VMSD     /* If the server process was started (DECmessageQ for VMS only),/      * then use a function to stop the process.       */h     if (start_server == 'Y')     { )         status = SYS$FORCEX (&pid, 0, 0);h1         printf ("\nServer process terminated\n");y     }  #endif       status = pams_exit();e  .     printf ("\n\nSIMPLE_CLIENT - Finished\n");
     exit (0);h }     $ /* translate logical name routine */
 #ifdef VMS  3 long int app_trnlnm (logical_name, returned_string)    char *logical_name;	/* input */ # char *returned_string;	/* output */    {    int return_status;   struct item_desc {'     short buf_len;		/* buffer length */a%     short item_code;		/* item code */r)     int   buf_addr;		/* buffer address */a7     int   ret_len_addr;		/* return length of address */      };   struct {2     struct item_desc string;	/* item descriptor */%     int terminator;		/* terminator */      } trnlist;  < unsigned long	trans_len = 0;	/* length of translated name */1 unsigned long	attributes;	/* search attributes */    static $DESCRIPTOR(tabnam," "); ! static $DESCRIPTOR(log_name," ");   8 char table_name[16];		/* logical name table to search */* char ret_string[256];		/* return string */  # sprintf(table_name,"LNM$FILE_DEV");g  * tabnam.dsc$w_length  = strlen(table_name);" tabnam.dsc$a_pointer = table_name;   attributes = LNM$M_CASE_BLIND;  . log_name.dsc$w_length  = strlen(logical_name);& log_name.dsc$a_pointer = logical_name;  1 trnlist.string.buf_len      = sizeof(ret_string);c* trnlist.string.item_code    = LNM$_STRING;) trnlist.string.buf_addr     = ret_string; ) trnlist.string.ret_len_addr = &trans_len;   trnlist.terminator          = 0;  J return_status = sys$trnlnm (&attributes, &tabnam, &log_name, 0, &trnlist);+     if((return_status & 01) != SS$_NORMAL )" 	return return_status; if (trans_len > 0)     {                 E     ret_string[trans_len] = 0;	  /* put null on end of string */      (     strcpy (returned_string,ret_string);     return_status = SS$_NORMAL;e     }s   return return_status;    }  #endif   = pams_attach_q (&attach_mode, &queue_number.all, &queue_type, K                             queue_name, &queue_name_length, 0, 0, 0, 0, 0);         if (status !=               % * [DMQ$V20.EXAMPLES]SIMPLE_CLIENT.FOR;1 +  , B   .      /     4 P                           - B    0   1    2   3      K  P   W   O !    5   6  U0e  7 yr  8          9 Z  G    H  J                           	PROGRAM SIMPLE_CLIENT  @ C***************************************************************@ C SIMPLE_CLIENT - A simple example of a PAMS client process.    @ C                                                               @ C This program provides an example of a very simplistic client  @ C process.  It's main function is to allow the user to enter    @ C messages that will be sent to the SIMPLE_SERVER process.      @ C                                                               @ C The first prompt asks the user if he/she wishes to start the  @ C server process.  If the user answers "Y"es, the SIMPLE_SERVER @ C process is started.  If the answer is "N"o, the server is not @ C run, however SIMPLE_CLIENT will allow the user to enter       @ C messages which it will loop to itself.                        @ C                                                               @ C SIMPLE_CLIENT has the following logic flow:                   @ C                                                               @ C                +---------------------------+                  @ C                |  Declare Process to PAMS  |                  @ C                |  using PAMS_ATTACH_Q      |                  @ C                +---------------------------+                  @ C                              |                                @ C                +---------------------------+                  @ C                | Prompt user to start the  |                  @ C                | server process.  If Y     |                  @ C                | start SIMPLE_SERVER. If N |                  @ C                | set-up to loop to ourself |                  @ C                +---------------------------+                  @ C                              |                                @ C                +---------------------------+                  @ C                | Initialize Variables, etc.|                  @ C                +---------------------------+                  @ C            +---------------->|                                @ C            |   +---------------------------+     +----------+ @ C            |   |   Wait for user to enter  |     | <ctrl-z> | @ C            |   |   a message.              |---->|   exit   | @ C            |   +---------------------------+     +----------+ @ C            |                 |                                @ C            |   +---------------------------+                  @ C            |   |   Send user message to    |                  @ C            |   | server (or ourself) using |                  @ C            |   |       PAMS_PUT_MSG        |                  @ C            |   +---------------------------+                  @ C            |                 |                                @ C            |   +---------------------------+                  @ C            |   |   Wait for a reply from   |                  @ C            |   | the server (or our msg.)  |                  @ C            |   |       PAMS_GET_MSGW       |                  @ C            |   +---------------------------+                  @ C            |                 |                                @ C            +---------<-------+                                @ C                                                               @ C To build SIMPLE_CLIENT and SIMPLE_SERVER use the SIMPLE_BUILD @ C command procedure.  If you wish to compile and link this      @ C program manually you may use the following commands:          @ C                                                               ? C     $ FOR  SIMPLE_CLIENT+DMQ$LIB:DMQ.TLB/LIB                  > C     $ LINK SIMPLE_CLIENT,DMQ$LIB:DMQ/OPT                    @ C                                                               @ C To execute use:  $ RUN SIMPLE_CLIENT                          @ C                                                               @ C***************************************************************   		IMPLICIT NONE   / C ** Include standard system definition files.    = 	INCLUDE '($SSDEF)/NOLIST'		! VMS System Service Return Codes  	INCLUDE '($CLIDEF)/NOLIST'  	INCLUDE '($LNMDEF)/NOLIST'   - C ** Include PAMS specific definition files.    ? 	INCLUDE '(PAMS_FOR_ENTRY_POINT)'	! PAMS function type declar's ; 	INCLUDE '(PAMS_FOR_PROCESS)'		! Known Process number def's 7 	INCLUDE '(PAMS_FOR_GROUP)'		! Known Group number def's < 	INCLUDE '(PAMS_FOR_TYPE_CLASS)'		! Generic Type/Class def'sE 	INCLUDE '(PAMS_FOR_RETURN_STATUS_DEF)'	! PAMS Function return status ; 	INCLUDE '(PAMS_FOR_SYMBOL_DEF)'		! Generic PSEL/DSEL def's    	INTEGER*2 BUF_SIZE ; 	PARAMETER (BUF_SIZE=80)			! Buffer size for local buffers    8 C ** Define data type for PAMS target/source addresses.             STRUCTURE /PAMS_ADDRESS/           UNION              MAP                INTEGER*4 ALL              END MAP              MAP                INTEGER*2 PROCESS                INTEGER*2 GROUP              END MAP            END UNION          END STRUCTURE   3 C ** Declare local variables, pointers, and arrays           STRUCTURE /TRN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ?                        ! $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES]SIMPLE_CLIENT.FOR;1                                                                                          P                               "            LNM_LIST/ %               INTEGER*2 BUFFER_LENGTH !               INTEGER*2 ITEM_CODE !               INTEGER*4 TRANSNAME -               INTEGER*4 RETURN_LENGTH_ADDRESS          END STRUCTURE   '         RECORD /TRNLNM_LIST/ ITEM_LIST1 '         RECORD /TRNLNM_LIST/ ITEM_LIST2 '         RECORD /TRNLNM_LIST/ ITEM_LIST3 '         RECORD /TRNLNM_LIST/ ITEM_LIST4          CHARACTER*4     BUS          CHARACTER*5     GROUP !         CHARACTER*10    BUS_GROUP          CHARACTER*20    DISK         CHARACTER*8     ROOT         CHARACTER*132   STRING;         INTEGER*4       RET_LENGTH1,RET_LENGTH2,RET_LENGTH3 + 	BYTE		SERVER			! Answer from server prompt           INTEGER*4       LIB$WAIT         REAL*8          WTTIME7 	INTEGER*4	STATUS,LIB$SPAWN	! Completion status code    !         INTEGER*4       FLAGS,PID 4 	INTEGER*4	PROC_NUM_REQ		! Requested process #      + 	INTEGER*4	I,SYS$TRNLNM		! Misc. loop index F         RECORD /PAMS_ADDRESS/ PROC_NUM_ACT	! Actual process #         / 	RECORD /PSB/	PSB			! PAMS status block           ; C **  Define outbound ("put") message variables and arrays  : 	RECORD /PAMS_ADDRESS/ SOURCE		! Source queue address     7 	BYTE		PUT_BUFFER(BUF_SIZE)	! Message buffer            1 	INTEGER*2	PUT_CLASS		! Message class code        0 	BYTE		PUT_DELIVERY		! Delivery mode            4 	INTEGER*2	PUT_PRIORITY		! Message priority         4 	INTEGER*4	PUT_RESP_QUE		! Response queue           0 	INTEGER*2	PUT_SIZE		! Message size             3 	INTEGER*4	PUT_TIMEOUT		! Time-out for blocked msg  0 	INTEGER*2	PUT_TYPE		! Message type code        , 	BYTE		PUT_UMA			! Undeliverable msg action   9 C ** Define inbound ("get") message variables and arrays  : 	RECORD /PAMS_ADDRESS/ TARGET		! Target queue address     7 	BYTE		GET_BUFFER(BUF_SIZE)	! Message buffer            1 	INTEGER*2	GET_CLASS		! Message class code        4 	INTEGER*2	GET_PRIORITY		! Message priority         2 	INTEGER*4	GET_SELECT		! Message selection mask   0 	INTEGER*2	GET_SIZE		! Message size             3 	INTEGER*4	GET_TIMEOUT		! Time-out for blocked msg  0 	INTEGER*2	GET_TYPE		! Message type code        O         INTEGER*4       ATTACH_MODE             ! Attach mode for pams_attach_q 1 	INTEGER*4       Q_TYPE                  ! Q TYPE   B C ****************************************************************B C *                  Initialization Section                      *B C *                         - - - - -                            *B C *  Declare our process to PAMS and initialize variables, etc.  *B C ****************************************************************   	WRITE (6, 10)= 10	FORMAT ('0SIMPLE_CLIENT - Simple Client Process Example'/)   : C ** Call pams_attach_q to attach to ourself to the PAMS  = C ** message bus, and assign our process (queue) number.        +         ATTACH_MODE = PSYM_ATTACH_TEMPORARY          Q_TYPE = PSYM_ATTACH_PQ D         STATUS = PAMS_ATTACH_Q (ATTACH_MODE,PROC_NUM_ACT.ALL,Q_TYPE,.      1                          0,0,0,0,0,0,0)! 	IF (STATUS .NE. SS$_NORMAL) THEN < 	   TYPE *, ' Error returned by PAMS_ATTACH_Q code=', STATUS 	   CALL EXIT (STATUS) 	END IF   8 	WRITE  (6, 25) PROC_NUM_ACT.GROUP, PROC_NUM_ACT.PROCESS1 25	FORMAT ('0   QUEUE ADDRESS IS ',I5.5,'.',I3.3)   > C ** Ask the user if he/she wishes to have SIMPLE_CLIENT send > C ** messages to itself, or if they wish to start the server.    30	WRITE  (6, 35) D 35	FORMAT ('    Do your wish to start the server process [Y/N]? ',$) 	READ   (5, 37) SERVER 37	FORMAT (A1)  J C    Convert answer to lower case (if upper case) and check for validity. * 	IF (SERVER .GE. 'a') SERVER = SERVER - 328 	IF ((SERVER .NE. 'N') .AND. (SERVER .NE. 'Y')) GO TO 30  I C ** If the user answered "Y"es, set target queue to the spare PAMS queue H C ** used by the server, then use LIB$SPAWN to run the command procedureF C ** to start the server.  Else set the target queue to our own queue.   	IF (SERVER .EQ. 'Y') THENG 	   TARGET.ALL = PAMS_SPARE1   !<< MUST match queue used by the SERVER! -            ITEM_LIST1.TRANSNAME = %LOC (DISK) @            ITEM_LIST1.RETURN_LENGTH_ADDRESS = %LOC (RET_LENGTH1)-            ITEM_LIST1.ITEM_CODE = LNM$_STRING (            ITEM_LIST1.BUFFER_LENGTH = 20F            STATUS = SYS$TRNLNM (,'DMQ$LNM_TBL','DMQ$DISK',,ITEM_LIST1)+            IF (STATUS .NE. SS$_NORMAL) THEN A               TYPE *,'  SYS$TRNLNM FOR DISK FAILED CODE =',STATUS                 CALL EXIT (STATUS)            END IF -            ITEM_LIST2.TRANSNAME = %LOC (ROOT) @            ITEM_LIST2.RETURN_LENGTH_ADDRESS = %LOC (RET_LENGTH2)-            ITEM_LIST2.ITEM_CODE = LNM$_STRING '            ITEM_LIST2.BUFFER_LENGTH = 8 F            STATUS = SYS$TRNLNM (,'DMQ$LNM_TBL','DMQ$ROOT',,ITEM_LIST2)+            IF (STATUS .NE. SS$_NORMAL) THEN A               TYPE *,'  SYS$TRNLNM FOR ROOT FAILED CODE =',STATUS                 CALL EXIT (STATUS)            END IF 2            ITEM_LIST3.TRANSNAME = %LOC (BUS_GROUP)@            ITEM_LIST3.RETURN_LENGTH_ADDRESS = %LOC (RET_LENGTH3)-            ITEM_LIST3.ITEM_CODE = LNM$_STRING (            ITEM_LIST3.BUFFER_LENGTH = 10@            STATUS = SYS$TRNLNM (,'DMQ$LNM_TBL','DMQ$BUS_GROUP',,-      1                            ITEM_LIST3)p+            IF (STATUS .NE. SS$_NORMAL) THEN A               TYPE *,'SYS$TRNLNM FOR BUS AND GROUP FAILED CODE ='s      1                ,STATUS                 CALL EXIT (STATUS)            END IFc            BUS = BUS_GROUP(1:4)r"            GROUP = BUS_GROUP(6:10)            FLAGS = CLI$M_NOWAIT             WRITE (STRING,999) D      1     '@',DISK,'[',ROOT,'.EXAMPLES]SIMPLE_RUN_SERVER.COM',DISK,      1      ROOT,BUS,GROUPB 999        FORMAT (A1,A<RET_LENGTH1>,A1,A7,A31,' ',A<RET_LENGTH1>,(      1             ' ',A7,' ',A4,' ',A5), 	   STATUS = LIB$SPAWN (STRING,,,FLAGS,,PID)$ 	   IF (STATUS .NE. SS$_NORMAL) THEN; 	      TYPE *, ' Error returned by LIB$SPAWN code=', STATUS  	      CALL EXIT (STATUS) 
 	   END IF' 	   TYPE *,'   Server process started.'I 	ELSEI! 	   TARGET.ALL = PROC_NUM_ACT.ALL F 	   TYPE *,'   Server not started.  Messages will be sent to ourself.' 	END IF   E C **  Initialize the  variables that we will be using for messaging.    0 	GET_PRIORITY	= 0			! Receive all messages      1 	GET_TIMEOUT	= 600			! 60 second time-out on rcv  . 	GET_SELECT	= 0			! No special selection mask   - 	PUT_CLASS	= 1			! Send class 1 message       0 	PUT_PRIORITY	= 0			! Send at standard priority 0 	PUT_RESP_QUE	= 0			! Response queue - default  / 	PUT_TYPE	= -123			! Msg type is user defined  s/ 	PUT_TIMEOUT	= 0			! Accept standard time-out   < 	PUT_DELIVERY	= PDEL_MODE_NN_MEM	! No notify, memory queuing9 	PUT_UMA		= PDEL_UMA_DISC   	! Discard if undeliverable                            l  D C ******************************************************************D C *                    Main Processing Loop                        *D C *                         - - - - -                              *D C *  Prompt for a message send it to the server task wait for      *D C *  a response from the server quit when user presses <CTRL-Z>.   *D C ******************************************************************         WTTIME = 4;         STATUS = LIB$WAIT (WTTIME)    !WAIT 4 SECONDS ONCE.  	DO WHILE (.TRUE.)  P C   ** Prompt for and read the message.  If <CTRL-Z> pressed (EOF) we are done.    100	   WRITE (6, 105) B 105	   FORMAT ('0   Enter message or press <CTRL-Z> to exit...',/,      &		   '    >',$) D 	   READ  (5, 103, END=9000) PUT_SIZE, (PUT_BUFFER(I), I=1,PUT_SIZE) 103	   FORMAT (Q,80A1)  N C   ** Send the message to the target process queue.  If an error is returned,C C   ** report it and exit.  Otherwise, display class and type info.   @ 	   STATUS = PAMS_PUT_MSG (PUT_BUFFER, PUT_PRIORITY, TARGET.ALL,8      &				  PUT_CLASS, PUT_TYPE, PUT_DELIVERY, PUT_SIZE,5      &				  PUT_TIMEOUT, PSB, PUT_UMA, PUT_RESP_QUE)     $ 	   IF (STATUS .NE. SS$_NORMAL) THEN< 	      TYPE *,'Error returned by PAMS_PUT_MSG code=', STATUS 	      CALL EXIT (STATUS) 
 	   END IF  D 	   WRITE (6, 135) TARGET.GROUP, TARGET.PROCESS, PUT_CLASS, PUT_TYPE6 135	   FORMAT ('0   CLIENT: Sent Msg to ',I3,'.',I3.3,$      &		   ' class=',I5,' type=',I5)  C C   ** Now wait for the server process to send the reply message.   H C   ** If time-out error returned, report it and continue.  If any otherC C   ** error, report it and exit.  Else, display what was received.   A 	   STATUS = PAMS_GET_MSGW (GET_BUFFER, GET_PRIORITY, SOURCE.ALL, 6      &				   GET_CLASS, GET_TYPE, BUF_SIZE, GET_SIZE, +      &				   GET_TIMEOUT, GET_SELECT, PSB) e  ' 	   IF (STATUS .EQ. PAMS__TIMEOUT) THEN % 	      TYPE *,'PAMS_GET_MSGW Timeout'   ) 	                                                                                                                                                                                                                                                    @                         $      DMQ020.B                       B  B  %[DMQ$V20.EXAMPLES]SIMPLE_CLIENT.FOR;11                                                                                         P                                             ELSE IF (STATUS .NE. SS$_NORMAL) THENLD               TYPE *,'Error returned by PAMS_GET_MSGW code=', STATUS 	      CALL EXIT (STATUS)    	   ELSEH 	      WRITE  (6, 145) SOURCE.GROUP, SOURCE.PROCESS, GET_CLASS, GET_TYPE; 145	      FORMAT ('0   CLIENT: Received from ',I3,'.',I3.3, (      &		      '  class=',I5,' type=',I5)4 	      WRITE  (6, 147) (GET_BUFFER(I),I=1, GET_SIZE)1 147	      FORMAT ('            Message=',80(A1:))c
 	   END IF  @ C ** Go back and wait for user to enter another message to send.   	END DOe t  3 C *************************************************N3 C *                 EXIT Routine                  *o3 C *                   - - - -                     *S3 C *  User entered <CTRL-Z>.  Clean-up, and exit.  *)3 C *************************************************_  C C    If the server process was started, then use SYS$FORCEX to stop	: C    the server process with the DLC STOP process command.    9000     CALL SYS$FORCEX (PID,,)  % C    Tell PAMS we're through with it.e   	CALL PAMS_EXIT ()  $ C    Tell user we're done then exit.   	TYPE *, 'SIMPLE_CLIENT - Done'l 	CALL EXIT (SS$_NORMAL)    	END    ! C		*  End of SIMPLE_CLIENT.FOR  *       STRUCTURE /PAMS_ADDRESS/           UNION              MAP                INTEGER*4 ALL              END MAP              MAP                INTEGER*2 PROCESS                INTEGER*2 GROUP              END MAP            END UNION          END STRUCTURE   3 C ** Declare local variables, pointers, and arrays           STRUCTURE /TRN              ) * [DMQ$V20.EXAMPLES]SIMPLE_RUN_SERVER.COM;1 +  , B   .     /     4 G                         - B    0   1    2   3      K  P   W   O     5   6 (ȏ  7 =r  8          9 Z  G    H  J                      G $! SIMPLE_RUN_SERVER - Command procedure to run the SIMPLE_SERVER image G $!                     as a subprocess.  Used by SIMPLE_CLIENT to start  $!		       SIMPLE_SERVER.  $!, $ @'P1'['P2'.EXE]DMQ$SET_LNM_TABLE 'P3' 'P4'' $ RUN 'P1'['P2'.EXAMPLES]SIMPLE_SERVER   $!                                                                                                                                                                                                                                                            % * [DMQ$V20.EXAMPLES]SIMPLE_SERVER.ADA;1 +  ,  C   .     /     4 P                          - B    0   1    2   3      K  P   W   O     5   6 b F[  7 rr  8          9 Z  G    H  J                           --N --****************************************************************************N --*                                                                          *N --*  Copyright (c) 1990, 1991, 1992                                          *N --*  by DIGITAL Equipment Corporation, Maynard, Mass.                        *N --*                                                                          *N --*  This software is furnished under a license and may be used and  copied  *N --*  only  in  accordance  with  the  terms  of  such  license and with the  *N --*  inclusion of the above copyright notice.  This software or  any  other  *N --*  copies  thereof may not be provided or otherwise made available to any  *N --*  other person.  No title to and ownership of  the  software  is  hereby  *N --*  transferred.                                                            *N --*                                                                          *N --*  The information in this software is subject to change  without  notice  *N --*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *N --*  Corporation.                                                            *N --*                                                                          *N --*  DIGITAL assumes no responsibility for the use or  reliability  of  its  *N --*  software on equipment which is not supplied by DIGITAL.                 *N --*                                                                          *N --****************************************************************************  P -------------------------------------------------------------------------------- --< -- SIMPLE_SERVER - A simple example of a server process.    A --                                                                A -- This program provides an example of a very simplistic server   A -- process that essentially performs the following functions:     A --                                                                A --                +---------------------------+                   A --                |  Attach program to bus    |                   A --                |  using PAMS_ATTACH_Q      |                   A --                +---------------------------+                   A --                              |                                 A --                              V                                 A --                +---------------------------+                   A --                | Initialize Variables, etc.|                   A --                +---------------------------+                   A --            +---------------->|                                 A --            |                 V                                 A --            |   +---------------------------+                   A --            |   |   Wait for a message to   |                   A --            |   |     be received using     |                   A --            |   |       PAMS_GET_MSGW       |                   A --            |   +---------------------------+                   A --            |                 |                                 A --            |                 V                                 A --            |   +---------------------------+                   A --            |   |   Send "canned" response  |                   A --            |   |  message to client using  |                   A --            |   |       PAMS_PUT_MSG        |                   A --            |   +---------------------------+                   A --            |                 |                                 A --            +---------<-------+                                 A --                                                                A -- To build SIMPLE_SERVER and SIMPLE_CLIENT use the SIMPLE_BUILD  A -- command procedure.  If you wish to compile and link this       A -- program manually you may use the following commands:           A --                                                                + --     $ ACS SET LIBRARY [your_ada_library]  --     $ ADA SIMPLE_SERVERC --     $ ACS LINK SIMPLE_SERVER DMQ$LIB:DMQ/OPT                     A --                                                                G -- The SIMPLE_CLIENT program will start the SIMPLE_SERVER as a detached ! -- process at the user's request. A --                                                                P --------------------------------------------------------------------------------    5 -- Include standard system definition and I/O units.   --I with STARLET;                           --VMS System Service Return Codes  with SYSTEM; with INTEGER_TEXT_IO; 
 with TEXT_IO;  with CONDITION_HANDLING; with CDD_TYPES;   + -- Include PAMS specific definition units.   --J with PAMS_ADA_ENTRY_POINT;              -- PAMS function type declarationsK with PAMS_ADA_PROCESS;                  -- Known Process number definitions I with PAMS_ADA_GROUP;                    -- Known Group number definitions I with PAMS_ADA_TYPE_CLASS;               -- Generic Type/Class definitions F with PAMS_ADA_RETURN_STATUS_DEF;        -- PAMS Function return statusH with PAMS_ADA_SYMBOL_DEF;               -- Generic PSEL/PDEL definitions   use SYSTEM;  use INTEGER_TEXT_IO; use TEXT_IO; use CONDITION_HANDLING;  use CDD_TYPES;   use PAMS_ADA_ENTRY_POINT;  use PAMS_ADA_PROCESS;  use PAMS_ADA_GROUP;  use PAMS_ADA_TYPE_CLASS; use PAMS_ADA_RETURN_STATUS_DEF;  use PAMS_ADA_SYMBOL_DEF;   procedure SIMPLE_SERVER is  1     GET_BUF_SIZE        : constant INTEGER := 80; 2     PUT_BUF_SIZE        : constant INTEGER := 109;1     RESPONSE_SIZE       : constant INTEGER := 29;      --9     -- Define data type for PAMS target/source addresses.      --     type Q_ADDRESS is          record(             QUEUE       : SHORT_INTEGER;(             GROUP       : SHORT_INTEGER;         end record;   5     -- Declare local variables, pointers, and arrays       --E     STATUS              : COND_VALUE_TYPE;  -- Completion status code   M     QUEUE_NUMBER        : INTEGER;                                                                                                                                                                                                     A                        5 $      DMQ020.B                        C  B  %[DMQ$V20.EXAMPLES]SIMPLE_SERVER.ADA;1A;1                                                                                       P                              x|      
               -- Actual queue # L     QUEUE_TYPE          : INTEGER := PSYM_ATTACH_PQ;        -- Primary queueG     QUEUE_NAME          : STRING (1..6) := "SPARE1";        -- Our name J     QUEUE_NAME_LEN      : INTEGER := 6;                     -- Name lengthJ     NAME_SCOPE          : INTEGER := PSYM_SCOPE_LOCAL;      -- Local scope  9     PSB                 : PSB_TYPE;		-- PAMS status block M     IN_BUF_SIZE         : INTEGER;              -- Length of the input buffer   <     -- Define outbound ("put") message variables and arrays      --D     SOURCE              : Q_ADDRESS;            -- Source queue     G     SOURCE_ADDR         : INTEGER;              -- Source queue address E     PUT_BUFFER          : STRING (1..PUT_BUF_SIZE); -- Message buffer G     PUT_BUFFER_ARRAY    : SYSTEM.UNSIGNED_BYTE_ARRAY (1..PUT_BUF_SIZE); E     PUT_CLASS           : SHORT_INTEGER;        -- Message class code @     PUT_DELIVERY        : SHORT_SHORT_INTEGER;  -- Delivery modeC     PUT_PRIORITY        : SHORT_SHORT_INTEGER;  -- Message priority A     PUT_RESP_QUE        : INTEGER;              -- Response queue ?     PUT_SIZE            : SHORT_INTEGER;        -- Message size K     PUT_TIMEOUT         : INTEGER;              -- Time-out for blocked msg D     PUT_TYPE            : SHORT_INTEGER;        -- Message type codeK     PUT_UMA             : SHORT_SHORT_INTEGER;  -- Undeliverable msg action   3     for PUT_BUFFER_ARRAY use at PUT_BUFFER'address; *     for SOURCE_ADDR use at SOURCE'address;  :     -- Define inbound ("get") message variables and arrays     --?     TARGET              : Q_ADDRESS;            -- Target queue G     TARGET_ADDR         : INTEGER;              -- Target queue address E     GET_BUFFER          : STRING (1..GET_BUF_SIZE); -- Message buffer G     GET_BUFFER_ARRAY    : SYSTEM.UNSIGNED_BYTE_ARRAY (1..GET_BUF_SIZE); E     GET_CLASS           : SHORT_INTEGER;        -- Message class code C     GET_PRIORITY        : SHORT_SHORT_INTEGER;  -- Message priority I     GET_SELECT          : INTEGER;              -- Message selection mask ?     GET_SIZE            : SHORT_INTEGER;        -- Message size K     GET_TIMEOUT         : INTEGER;              -- Time-out for blocked msg D     GET_TYPE            : SHORT_INTEGER;        -- Message type code  3     for GET_BUFFER_ARRAY use at GET_BUFFER'address; *     for TARGET_ADDR use at TARGET'address;                           begin   2     PUT_LINE ("SIMPLE_SERVER - Example starting");  4     -- Call PAMS attach Q to attach our program to a;     -- permanent queue by name and assign our queue number.      --)     PAMS_ATTACH_Q (STATUS      => STATUS, 6                    ATTACH_MODE => PSYM_ATTACH_BY_NAME,/                    Q_ATTACHED  => QUEUE_NUMBER, 1                    Q_TYPE      => PSYM_ATTACH_PQ, -                    Q_NAME      => QUEUE_NAME, 2                    Q_NAME_LEN  => QUEUE_NAME_LEN);  3     if not CONDITION_HANDLING.SUCCESS (STATUS) then 6         PUT ("Error returned by PAMS_ATTACH_Q code=");2         PUT (ITEM => integer(STATUS), WIDTH => 3);         raise PROGRAM_ERROR;     end if;   )     -- The attach was successful continue      --     PUT ("Queue number is "); -     PUT (ITEM => (QUEUE_NUMBER), WIDTH => 3); 
     NEW_LINE;   F     -- Initialize the  variables that we will be using for messaging.      --F     GET_PRIORITY := 0;                   -- Receive all messages      D     GET_TIMEOUT  := 0;                   -- Infinite time-out on getF     GET_SELECT   := 0;                   -- No special selection mask F     PUT_CLASS    := 1;                   -- Send class 1 message      F     PUT_TYPE     := -123;                -- Msg type is user defined  F     PUT_PRIORITY := 0;                   -- Send at standard priority F     PUT_RESP_QUE := 0;                   -- Response queue - default  F     PUT_TIMEOUT  := 0;                   -- Accept standard time-out  E     PUT_DELIVERY := PDEL_MODE_NN_MEM;    -- No notify, memory queuing F     PUT_UMA      := PDEL_UMA_DISC;       -- Discard if undeliverable         -- Main Processing Loop      --     loop  B         -- Wait for a message to be sent by a client process.     B         -- If time-out received, report it and continue.  if any  B         -- other error, report it and exit.  Else display message.
         --&         GET_BUFFER := (others => ' ');3         PAMS_GET_MSGW (STATUS            => STATUS, =                        MSG_AREA          => GET_BUFFER_ARRAY, 9                        PRIORITY          => GET_PRIORITY,n8                        SOURCE_Q          => SOURCE_ADDR,6                        MSG_CLASS         => GET_CLASS,5                        MSG_TYPE          => GET_TYPE,eH                        AREA_LENGTH       => short_integer(GET_BUF_SIZE),5                        MSG_LENGTH        => GET_SIZE,t7                        SEL_ADDR          => GET_SELECT,a8                        RCV_TMO           => GET_TIMEOUT,1                        PAMS_STATUS_BLOCK => PSB);   %         if STATUS = PAMS_TIMEOUT then /             PUT_LINE ("PAMS_GET_MSGW Timeout");t:         elsif not CONDITION_HANDLING.SUCCESS (STATUS) then:             PUT ("Error returned by PAMS_GET_MSGW code=");6             PUT (ITEM => integer(STATUS), WIDTH => 3);             NEW_LINE;              exit;          else/             PUT ("SERVER: Received Msg from ");a<             PUT (ITEM => integer(TARGET.GROUP), WIDTH => 3);             PUT (".");<             PUT (ITEM => integer(TARGET.QUEUE), WIDTH => 3);             PUT (" class=");9             PUT (ITEM => integer(PUT_CLASS), WIDTH => 3);*             PUT (" type=");*8             PUT (ITEM => integer(PUT_TYPE), WIDTH => 3);             NEW_LINE;-9             PUT_LINE (GET_BUFFER (1..integer(GET_SIZE)));V         end if;m  B         -- Return "canned" response message to the client process.
         --&         PUT_BUFFER := (others => ' ');         PUT_SIZE := 109;I         PUT_BUFFER (1..RESPONSE_SIZE) := "Response from SIMPLE_SERVER: ";o8         PUT_BUFFER (RESPONSE_SIZE+1..109) := GET_BUFFER;  >         -- Set target queue to that of the queue that sent the3         -- message, then send the response message.g
         --         TARGET := SOURCE; 2         PAMS_PUT_MSG (STATUS            => STATUS,<                       MSG_AREA          => PUT_BUFFER_ARRAY,8                       PRIORITY          => PUT_PRIORITY,7                       TARGET_Q          => TARGET_ADDR, 5                       MSG_CLASS         => PUT_CLASS, 4                       MSG_TYPE          => PUT_TYPE,8                       DELIVERY          => PUT_DELIVERY,4                       MSG_SIZE          => PUT_SIZE,7                       TIMEOUT           => PUT_TIMEOUT, /                       PAMS_STATUS_BLOCK => PSB, 3                       UMA               => PUT_UMA, 9                       RESP_Q            => PUT_RESP_QUE);   -7         if not CONDITION_HANDLING.SUCCESS (STATUS) then 9             PUT ("Error returned by PAMS_PUT_MSG code="); 6             PUT (ITEM => integer(STATUS), WIDTH => 3);             NEW_LINE;              exit;          else)             PUT ("SERVER: Sent Msg to "); <             PUT (ITEM => integer(TARGET.GROUP), WIDTH => 3);             PUT (".");<             PUT (ITEM => integer(TARGET.QUEUE), WIDTH => 3);             PUT (" class=");9             PUT (ITEM => integer(PUT_CLASS), WIDTH => 3);p             PUT (" type=");-8             PUT (ITEM => integer(PUT_TYPE), WIDTH => 3);             NEW_LINE;          end if;T  
     end loop;    end SIMPLE_SERVER;      |   +---------------------------+                         # * [DMQ$V20.EXAMPLES]SIMPLE_SERVER.C;1 +  , C   .     /     4 R                         - B    0   1    2   3      K  P   W   O     5   6 y3  7 @.r  8          9 Z  G    H  J                            N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1991                                                       *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  B                        z( $      DMQ020.B                       C  B  #[DMQ$V20.EXAMPLES]SIMPLE_SERVER.C;1ADA;1                                                                                       R                             l "              the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/    /*C  * SIMPLE_SERVER - A simple example of a DECmessageQ server program A  *                                                                ;  * This program provides an example of a simple DECmessageQ >  * server. It receives a message from a client and responds by  * returning the message. A  *                                                                A  * SIMPLE_SERVER can be run interactively, or started             <  * automatically by the SIMPLE_CLIENT program (on VMS only).A  *                                                                A  * SIMPLE_SERVER has the following logic flow:                    A  *                                                                A  *                +---------------------------+                   A  *                |  Attach to message queue  |                   A  *                |    using PAMS_ATTACH_Q    |                   A  *                +---------------------------+                   A  *                              |                                 A  *                +---------------------------+                   A  *                | Initialize Variables, etc.|                   A  *                +---------------------------+                   A  *            +---------------->|                                 A  *            |   +---------------------------+                   A  *            |   |   Wait for a message to   |                   A  *            |   |     be received using     |                   A  *            |   |       PAMS_GET_MSGW       |                   A  *            |   +---------------------------+                   A  *            |                 |                                 A  *            |   +---------------------------+                   A  *            |   |  Send "canned" response   |                   A  *            |   |  message to client using  |                   A  *            |   |       PAMS_PUT_MSG        |                   A  *            |   +---------------------------+                   A  *            |                 |                                 A  *            +---------<-------+                                 A  *                                                                A  *                                                                J  * To build SIMPLE_SERVER on DECmessageQ for VMS:                         A  *                                                                <  * Use the SIMPLE_BUILD command procedure, or compile and   <  * link manually by using the following commands:           A  *                                                                0  *  $ CC/include=dmq$user/list/obj SIMPLE_SERVER=  *  $ LINK SIMPLE_SERVER,DMQ$LIB:DMQ/OPT                      A  *                                                                F  * A RUN command is used by SIMPLE_CLIENT to start SIMPLE_SERVER as a ?  * subprocess.                                                  A  *                                                                A  * To build SIMPLE_SERVER on non-DECmessageQ for VMS systems:     A  *                                                                <  * Compile with the "p_xxxx.h" include files, and link with A  * DECmessageQ according to the documentation.                    A  *                                                                  */   - /* standard "C" and system definition files.    */ P #include <stdio.h>                         /* standard I/O definitions        */P #include <stdlib.h>                        /* standard library definitions    */  
 #ifdef VMSR #include <ssdef.h>                           /* VMS system service return codes */R #include <stsdef.h>                          /* VMS system service status codes */ #endif  P #include "p_entry.h"                       /* PAMS function declarations      */P #include "p_proces.h"                      /* Known Queue number definitions  */P #include "p_group.h"                       /* Known Group ID definitions      */P #include "p_typecl.h"                      /* Generic Type/Class definitions  */P #include "p_return.h"                      /* PAMS return status definitions  */P #include "p_symbol.h"                      /* Generic PSEL/PSYM definitions   */   #ifndef VMS P #include "p_aretur.h"                      /* Remaining PAMS status defs      */ #endif  P #define BUF_SIZE 512                       /* Buffer size for local buffers   */  < /* Define data type for DECmessageQ target/source addresses.  */ 
 typedef union     {    long int      all; 	    struct        {        short int  queue;        short int  group;        } au;     } Q_address;   0 /* Declare local variables, pointers, and arrays */P char        start_server;                  /* Input to server question        */P long int    status;                        /* Completion status code          */  P long int    attach_mode;                   /* Attach mode for PAMS_ATTACH_Q   */P long int    queue_type;                    /* Queue type for PAMS_ATTACH_Q    */P char        queue_name[32];                /* Queue name for PAMS_ATTACH_Q    */P long int    queue_name_length;             /* Length of queue name            */P long int    search_list[3] =               /* List of tables to search        */$                     { PSEL_TBL_PROC,#                       PSEL_TBL_GRP, )                       PSEL_TBL_DNS_LOW }; P long int    search_list_len = 3;           /* Elements in search list         */  P Q_address   queue_number;                  /* Actual queue number             */P struct PSB  psb;                           /* DECmessageQ status block        */  7 /* Define outbound ("put") message variables and arrays  */P Q_address   target;                        /* Target queue address            */P char        put_buffer[BUF_SIZE+1];        /* Message buf. +1 null byte       */P short int   put_priority;                  /* Message priority                */P short int   put_class;                     /* Message class code              */P short int   put_type;                      /* Message type code               */P char        put_delivery;                  /* Delivery mode                   */P long int    put_resp_que;                  /* Response queue                  */P short int   put_size;                      /* Message size                    */P long int    put_timeout;                   /* Time to wait for delivery       */P char        put_uma;                       /* Undeliverable msg action        */  6 /* Define inbound ("get") message variables and arrays */P Q_address   source;                        /* Source queue address            */P char        get_buffer[BUF_SIZE+1];        /* Message buf. +1 null byte       */P short int   get_priority;                  /* Message priority                */P short int   get_class;                     /* Message class code              */P short int   get_type;                      /* Message type code               */P long int    get_select;                    /* Message selection mask          */P short int   get_size;                      /* Message size                    */P long int    get_timeout;                   /* Time to wait for message        */     main ()  { #     short        buflen = BUF_SIZE;   6     printf ("\n\nSIMPLE_SERVER - Example starting\n");  5     /* Setup parameters being passed to PAMS_ATTACH_Q       */ P     sprintf(queue_name, "%d", PAMS_QUEUE_1);/* Use a static name              */+     queue_name_length = strl                                                                                                                                                                                                                                                   C                         $      DMQ020.B                       C  B  #[DMQ$V20.EXAMPLES]SIMPLE_SERVER.C;1                                                                                            R                                          en(queue_name);   "     queue_type   = PSYM_ATTACH_PQ;)     attach_mode  = PSYM_ATTACH_BY_NUMBER;   D     /* Call PAMS_ATTACH_Q to attach our program to a permanent queue#      * and assign our queue number.       */ E     status = pams_attach_q (&attach_mode, &queue_number, &queue_type, K                             queue_name, &queue_name_length, 0, 0, 0, 0, 0);         if (status != PAMS__SUCCESS)     { M         printf("SIMPLE_SERVER: Error returned by PAMS_ATTACH_Q %d\n",status);          exit(status);      }   :     printf("\n\nSIMPLE_SERVER: Attached to queue %d.%d\n",9            queue_number.au.group, queue_number.au.queue);   D     /* Initialize the variables that we will be using for messaging.      */ P     get_priority = 0;                      /* Receive all priority messages   */P     get_timeout  = 0;                      /* Wait "forever" for a message    */P     get_select   = 0;                      /* No special selection mask       */  P     put_class    = 1;                      /* Send class 1 message            */P     put_priority = 0;                      /* Send at standard priority       */P     put_resp_que = 0;                      /* Response queue - default        */P     put_type     = -123;                   /* Message type is program defined */P     put_timeout  = 0;                      /* Accept standard put timeout     */P     put_delivery = PDEL_MODE_NN_MEM;       /* No notify, memory queuing       */P     put_uma      = PDEL_UMA_DISC;          /* Discard if undeliverable        */                         t
     while (1)l     {f=         /* Wait for a message to be sent by a client program. H          * If timeout status returned received, report it and continue. E          * If any other error, report it and exit. Otherwise, displays          * the message.r          */ L         if ((status = pams_get_msgw (get_buffer, &get_priority, &source.all,P                                      &get_class, &get_type, &buflen, &get_size, E                                      &get_timeout, &get_select, &psb,nF                                      0, 0, 0, 0, 0)) == PAMS__TIMEOUT)K             printf ("SIMPLE_SERVER: PAMS_GET_MSGW Timeout.  Continuing\n");   )         else if (status != PAMS__SUCCESS) 	         { Q             printf ("SIMPLE_SERVER: Error returned by PAMS_GET_MSGW code = %d\n",                      status);             exit (status);	         }   K         printf ("\nSIMPLE_SERVER: Received from %d.%d class=%d, type=%d\n", 2                 source.au.group, source.au.queue, %                 get_class, get_type);*,         printf ("Msg = '%s'\n", get_buffer);  B         /* Return "canned" response message to the client program.F          * Message returned contains client queue number and the first1          * 50 characters of the message received.s          */o    #         (void)sprintf (put_buffer, t3              "Message from %d.%d is \"%.50s\" \n",  /               source.au.group, source.au.queue,b               get_buffer);  &         put_size = strlen(put_buffer);  >         /* Set target queue to that of the queue that sent the3          * message, then send the response message.V          */l          target.all = source.all;J         if ((status = pams_put_msg(put_buffer, &put_priority, &target.all,H                                    &put_class, &put_type, &put_delivery,L                                    &put_size,  &put_timeout, &psb, &put_uma,M                                    &put_resp_que, 0, 0, 0)) != PAMS__SUCCESS)-  	         {-P             printf ("SIMPLE_SERVER: Error returned by PAMS_PUT_MSG code = %d\n",                      status);-             exit (status);
         }       M         printf ("\nSIMPLE_SERVER: Sent Msg to %d.%d class = %d, type = %d\n", 2                 target.au.group, target.au.queue, %                 put_class, put_type); ,         printf ("Msg = '%s'\n", put_buffer);     }- } /* End of SIMPLE_SERVER.C */                          |   |   Wait for a message to   |                   A  *            |                 % * [DMQ$V20.EXAMPLES]SIMPLE_SERVER.FOR;1 +  , C   .     /     4 H                         - B    0   1    2   3      K  P   W   O     5   6 =e  7 r  8          9 Z  G    H  J                               		PROGRAM SIMPLE_SERVER   @ C***************************************************************@ C                                                               @ C SIMPLE_SERVER - A simple example of a PAMS server process.    @ C                                                               @ C This program provides an example of a very simplistic server  @ C process that essentially performs the following functions:    @ C                                                               @ C                +---------------------------+                  @ C                |  Declare Process to PAMS  |                  @ C                |  using PAMS_ATTACH_Q      |                  @ C                +---------------------------+                  @ C                              |                                @ C                              V                                @ C                +---------------------------+                  @ C                | Initialize Variables, etc.|                  @ C                +---------------------------+                  @ C            +---------------->|                                @ C            |                 V                                @ C            |   +---------------------------+                  @ C            |   |   Wait for a message to   |                  @ C            |   |     be received using     |                  @ C            |   |       PAMS_GET_MSGW       |                  @ C            |   +---------------------------+                  @ C            |                 |                                @ C            |                 V                                @ C            |   +---------------------------+                  @ C            |   |   Send "canned" response  |                  @ C            |   |  message to client using  |                  @ C            |   |       PAMS_PUT_MSG        |                  @ C            |   +---------------------------+                  @ C            |                 |                                @ C            +---------<-------+                                @ C                                                               @ C To build SIMPLE_SERVER and SIMPLE_CLIENT use the SIMPLE_BUILD @ C command procedure.  If you wish to compile and link this      @ C program manually you may use the following commands:          @ C                                                               C C     $ FORTRAN SIMPLE_SERVER+DMQ$LIB:DMQ.TLB/LIB                   A C     $ LINK    SIMPLE_SERVER,DMQ$LIB:DMQ/OPT                     @ C                                                               @ C The RUN_SIMPLE_SERVER.COM command procedure is used by        @ C SIMPLE_CLIENT to start SIMPLE_SERVER as a detached process.   @ C                                                               @ C***************************************************************   		IMPLICIT NONE   / C ** Include standard system definition files.    = 	INCLUDE '($SSDEF)/NOLIST'		! VMS System Service Return Codes   - C ** Include PAMS specific definition files.    ? 	INCLUDE '(PAMS_FOR_ENTRY_POINT)'	! PAMS function type declar's ; 	INCLUDE '(PAMS_FOR_PROCESS)'		! Known Process number def's 7 	INCLUDE '(PAMS_FOR_GROUP)'		! Known Group number def's < 	INCLUDE '(PAMS_FOR_TYPE_CLASS)'		! Generic Type/Class def'sE 	INCLUDE '(PAMS_FOR_RETURN_STATUS_DEF)'	! PAMS Function return status ; 	INCLUDE '(PAMS_FOR_SYMBOL_DEF)'		! Generic PSEL/DSEL def's    	INTEGER*2 BUF_SIZE ; 	PARAMETER (BUF_SIZE=80)			! Buffer size for local buffers    8 C ** Define data type for PAMS target/source addresses.             STRUCTURE /PAMS_ADDRESS/           UNION              MAP                INTEGER*4 ALL              END MAP              MAP                INTEGER*2 PROCESS                INTEGER*2 GROUP              END MAP            END UNION          END STRUCTURE   3 C ** Declare local variables, pointers, and arrays  +         CHARACTER       Q_NAME*11/'spare1'/ "         INTEGER*4       Q_NAME_LEN+ 	BYTE		SERVER			!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   D                        Lin $      DMQ020.B                       C  B  %[DMQ$V20.EXAMPLES]SIMPLE_SERVER.FOR;1                                                                                          H                             8      	       Answer from server prompt / 	INTEGER*4	STATUS			! Completion status code    4 	INTEGER*4	PROC_NUM_REQ		! Requested process #      ! 	INTEGER*4	I			! Misc. loop index F         RECORD /PAMS_ADDRESS/ PROC_NUM_ACT	! Actual process #         / 	RECORD /PSB/	PSB			! PAMS status block           ; C **  Define outbound ("put") message variables and arrays  : 	RECORD /PAMS_ADDRESS/ SOURCE		! Source queue address     7 	BYTE		PUT_BUFFER(BUF_SIZE)	! Message buffer            1 	INTEGER*2	PUT_CLASS		! Message class code        0 	BYTE		PUT_DELIVERY		! Delivery mode            4 	INTEGER*2	PUT_PRIORITY		! Message priority         4 	INTEGER*4	PUT_RESP_QUE		! Response queue           0 	INTEGER*2	PUT_SIZE		! Message size             3 	INTEGER*4	PUT_TIMEOUT		! Time-out for blocked msg  0 	INTEGER*2	PUT_TYPE		! Message type code        , 	BYTE		PUT_UMA			! Undeliverable msg action   9 C ** Define inbound ("get") message variables and arrays  : 	RECORD /PAMS_ADDRESS/ TARGET		! Target queue address     7 	BYTE		GET_BUFFER(BUF_SIZE)	! Message buffer            1 	INTEGER*2	GET_CLASS		! Message class code        4 	INTEGER*2	GET_PRIORITY		! Message priority         2 	INTEGER*4	GET_SELECT		! Message selection mask   0 	INTEGER*2	GET_SIZE		! Message size             3 	INTEGER*4	GET_TIMEOUT		! Time-out for blocked msg  0 	INTEGER*2	GET_TYPE		! Message type code        *         INTEGER*4       ATTACH_MODE,Q_TYPE  B C ****************************************************************B C *                  Initialization Section                      *B C *                         - - - - -                            *B C *  Declare our process to PAMS and initialize variables, etc.  *B C ****************************************************************   	WRITE (6, 10)= 10	FORMAT ('0SIMPLE_SERVER - Simple Server Process Example'/)   : C ** Call pams_attach_q to attach to ourself to the PAMS  = C ** message bus, and assign our process (queue) number.        )         ATTACH_MODE = PSYM_ATTACH_BY_NAME          Q_TYPE = PSYM_ATTACH_PQ          Q_NAME_LEN = 11   D         STATUS = PAMS_ATTACH_Q (ATTACH_MODE,PROC_NUM_ACT.ALL,Q_TYPE,B      1                          %REF(Q_NAME),Q_NAME_LEN,0,0,0,0,0)! 	IF (STATUS .NE. SS$_NORMAL) THEN < 	   TYPE *, ' Error returned by PAMS_ATTACH_Q code=', STATUS 	   CALL EXIT (STATUS) 	END IF   8 	WRITE  (6, 25) PROC_NUM_ACT.GROUP, PROC_NUM_ACT.PROCESS1 25	FORMAT ('0   QUEUE ADDRESS IS ',I5.5,'.',I3.3)     E C **  Initialize the  variables that we will be using for messaging.    0 	GET_PRIORITY	= 0			! Receive all messages      ( 	GET_TIMEOUT	= 0			! No time-out on rcv . 	GET_SELECT	= 0			! No special selection mask   - 	PUT_CLASS	= 1			! Send class 1 message       0 	PUT_PRIORITY	= 0			! Send at standard priority 0 	PUT_RESP_QUE	= 0			! Response queue - default  / 	PUT_TYPE	= -123			! Msg type is user defined   / 	PUT_TIMEOUT	= 0			! Accept standard time-out   < 	PUT_DELIVERY	= PDEL_MODE_NN_MEM	! No notify, memory queuing9 	PUT_UMA		= PDEL_UMA_DISC   	! Discard if undeliverable                               D C ******************************************************************D C *                    Main Processing Loop                        *D C *                         - - - - -                              *D C *  Prompt for a message send it to the server task wait for      *D C *  a response from the server quit when user presses <CTRL-Z>.   *D C ******************************************************************   	DO WHILE (.TRUE.)  > C   ** Wait for a message to be sent by a client process.     > C   ** If time-out received, report it and continue.  if any  > C   ** other error, report it and exit.  Else display message.  A 	   STATUS = PAMS_GET_MSGW (GET_BUFFER, GET_PRIORITY, SOURCE.ALL, 6      &				   GET_CLASS, GET_TYPE, BUF_SIZE, GET_SIZE, *      &				   GET_TIMEOUT, GET_SELECT, PSB)  ' 	   IF (STATUS .EQ. PAMS__TIMEOUT) THEN @ 	      TYPE *,'   SERVER: PAMS_GET_MSGW Timeout.  Continuing...'  ) 	   ELSE IF (STATUS .NE. SS$_NORMAL) THEN G 	      TYPE *,'   SERVER: Error returned by PAMS_GET_MSGW code=',status  	      CALL EXIT (STATUS)    	   ELSEH 	      WRITE  (6, 125) SOURCE.GROUP, SOURCE.PROCESS, GET_CLASS, GET_TYPE; 125	      FORMAT ('0   SERVER: Received from ',I3,'.',I3.3, (      &		      '  class=',I5,' type=',I5)4 	      WRITE  (6, 127) (GET_BUFFER(I), I=1,GET_SIZE)1 127	      FORMAT ('            Message=',80(A1:)) 
 	   END IF  > C   ** Return "canned" response message to the client process.@ C   ** Message returned contains client process id and the first- C   ** 50 characters of the message received.    	   PUT_SIZE = 26+GET_SIZE> 	   ENCODE (80, 135, PUT_BUFFER) SOURCE.GROUP, SOURCE.PROCESS,-      &					      (GET_BUFFER(I),I=1,GET_SIZE) ? 135	   FORMAT ('Message from ',I3,'.',I3.3,' is "',50(A1:),'"')   A C   ** Set target process id to that of the process that sent the 6 C   ** message, then send the response message to it.    	   TARGET.ALL = SOURCE.ALL   @ 	   STATUS = PAMS_PUT_MSG (PUT_BUFFER, PUT_PRIORITY, TARGET.ALL,8      &				  PUT_CLASS, PUT_TYPE, PUT_DELIVERY, PUT_SIZE,5      &				  PUT_TIMEOUT, PSB, PUT_UMA, PUT_RESP_QUE)    $ 	   IF (STATUS .NE. SS$_NORMAL) THEN< 	      TYPE *,'Error returned by PAMS_PUT_MSG code=', STATUS 	      CALL EXIT (STATUS) 
 	   END IF  D 	   WRITE (6, 145) TARGET.GROUP, TARGET.PROCESS, PUT_CLASS, PUT_TYPE6 145	   FORMAT ('0   SERVER: Sent Msg to ',I3,'.',I3.3,$      &		   ' class=',I5,' type=',I5) 	   WRITE  (6, 147) PUT_BUFFER+ 147	   FORMAT ('            Message=',80A1)    	END DO    	END  " C			*  End of SIMPLE_SERVER.FOR  *                      % * [DMQ$V20.EXAMPLES]TEST_PRT_RTNS.PLI;1 +  , C   .     /     4 C                           - B    0   1    2   3      K  P   W   O     5   6 g7  7 Dr  8          9 Z  G    H  J                          ' TEST_PRT_RTNS: PROCEDURE OPTIONS(MAIN);   C %REPLACE MAX_QUEUE_NAME_LENGTH	BY  31;		/* must be an odd number */   , DCL PAMS_PRT_ERR   EXTERNAL ENTRY ( CHAR(*), 				    CHAR(*),   				    FIXED BIN (31));  , DCL PAMS_PRT_MSG   EXTERNAL ENTRY ( CHAR(*), 				    CHAR(*),   				    FIXED BIN (31));  , DCL PAMS_PRT_STS   EXTERNAL ENTRY ( CHAR(*), 				    CHAR(*),   				    FIXED BIN (31));  7 DCL 1 USER_REFERENCE_AREA	                   GLOBALDEF, &     2 PAMS_MY_VMS_UIC		       CHAR(3),5     2 PAMS_MY_GROUP_NUMBER             FIXED BIN(15), /     2 PAMS_MY_PID                      CHAR(8), 3     2 PAMS_MY_PID_NUM	               FIXED BIN(31), C     2 PAMS_MY_PROCESS_NAME             CHAR(MAX_QUEUE_NAME_LENGTH), 0     2 PAMS_MY_BUS_GROUP                CHAR(10);  1 DCL 1 PAMS_MY_BG		BASED(ADDR(PAMS_MY_BUS_GROUP)), %     2 PAMS_MY_BUS_ID		       CHAR(4), /     2 PAMS_MY_BG_FILLER	               CHAR(1), %     2 PAMS_MY_GRP_ID		       CHAR(5);     ! PAMS_MY_BUS_GROUP = '1234_56789';   * CALL PAMS_PRT_STS ('STS', 'PRT STS', 100);* CALL PAMS_PRT_MSG ('MSG', 'PRT MSG', 200);* CALL PAMS_PRT_ERR ('ERR', 'PRT ERR', 300);   STOP;    END TEST_PRT_RTNS;                                                                                                                                                                                                                                                                                                                                                                                               * [DMQ$V20.EXAMPLES]TTAST.C;1 +  , C   .     /     4 O                          - B    0   1    2   3      K  P   W   O     5   6 .G(  7 yr  8          9 Z  G    H  J                     #module TTAST "DMQ V2.0-00"   N /*****************************************************************************$  *  DECMessageQ for VMS							     *N  *                                                                           *;  *  Copyright (c) 1990                    			             * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *                                                                                                                                                                                                   E                        cA $      DMQ020.B                       C  B  [DMQ$V20.EXAMPLES]TTAST.C;1MSGDEF.H;1                                                                                          O                             9L             									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/    #if 0     program:	TTAST.CB date written:	December 1989  Randy Skelding (PAMS RESOURCE CENTER)= date modified:  January  1991  RTS  -- convert to DECmessageQ 
 description:	   = This program demonstrates the use of PAMS queues as a queuing < mechanism from an AST service to mainline code. PAMS_PUT_MSG< now works in an AST service routine without race conditions.  A This method can supercede the USER CALLBACK mechanism for passing ! info from foreign inputs to PAMS.    #endif   #include <iodef.h> #include <ssdef.h> #include <libdef.h>  #include <stdio.h> #include <descrip.h>   /* portable includes */  #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "p_entry.h" #include "p_group.h"    % /***********************************/ % /* PAMS data structure definitions */ % /***********************************/ 
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group;     } au; } PAMS_ADDRESS ;   typedef struct   {     short int type;    short int cd;    long int del_status;     long int seq[2];     long int uma_status;     long int unused[3]; } PAMS_PSB;   < /**********************************************************/< /* SEE VT220 PROGRAMMER POCKET GUIDE FOR ESCAPE SEQUENCES */< /**********************************************************/ #define CLEAR    "\033[2J"" #define LINE(n)  "\033[n;0H\033[K" #define DECSC    "\0337" #define DECRC    "\0338" #define EL       "\033[K"  static char msgbuf[8192];  static char qname [32];    /*********************/  /* queue identifiers */  /*********************/  PAMS_ADDRESS mypamsid;   /***************************/  /* Input to pams_get_msgw  */  /***************************/  long		timeout   = 0; short 		filter[2] = {0,0}; short 		prio      = 0;   /*****************************/  /* output from pams_get_msgw */  /*****************************/  PAMS_ADDRESS	source; short 		class;
 short 		type; & short		msg_area_len = sizeof (msgbuf); short		len_data;
 PAMS_PSB	psb;   ' /*************************************/ ' /* Data structures for terminal ASTs */ ' /*************************************/  $DESCRIPTOR (ttdesc, "TT:");
 long 		ttefn;  long   		ttchan; short  		ttiosb[4];  char	 	ttinbuf[256]; void 		ttast();    static main () {     long requested_id = 0;     long istat;
    long ilen;     long cstat  = 0;     long forcej = 0; ,    long attach_mode = PSYM_ATTACH_TEMPORARY;      int loop   = 1;  9 	/******************************************************/ 9 	/* Declare to PAMS as a temporary process, but with a */ + 	/* name that others can locate.			      */ 9 	/******************************************************/  	while ( loop )  	{ 	   printf ("\nPQ name ? "); 	   gets ( ttinbuf );    	   ilen = strlen ( ttinbuf );  A 	   istat = pams_attach_q ( &attach_mode, &mypamsid, 0, ttinbuf,  5                                    &ilen,0,0,0,0,0 );  	   if ( istat != SS$_NORMAL ) 	   { 2 	      printf ("\nAttach Q refused: %x ", istat ); 	      continue; 	   } 
 	   break; 	} 	 % 	/**********************************/ % 	/* PROMPT FOR INPUT FROM TERMINAL */ % 	/**********************************/ E 	printf ("%s%s%s", CLEAR, LINE(10), "Enter <CR> to exit program : ");   ' 	/************************************/ ' 	/* ASSIGN A CHANNEL TO THE TERMINAL */ ' 	/************************************/ / 	istat = sys$assign ( &ttdesc, &ttchan, 0, 0 ); & 	if (! ( istat & 1 ) ) exit ( istat );    	/*****************************/  	/* POST A TERMINAL INPUT AST */  	/*****************************/ 	istat = sys$qio (  3 	   ttefn, ttchan, IO$_READVBLK, ttiosb, ttast, 0,  ( 	   ttinbuf, sizeof(ttinbuf), 0,0,0,0 );     	/***********************/ 	/* Main messaging loop */ 	/***********************/ 	while ( loop )  	{   	   istat = pams_get_msgw ( - 	      msgbuf, &prio, &source, &class, &type, D 	      &msg_area_len, &len_data, &timeout, filter, &psb,0,0,0,0,0 );   	   if ( istat != SS$_NORMAL ) 	   { - 	      printf ("%s%s%sDelivery error: %x%s",  & 		    DECSC, LINE(3), istat, DECRC ); 
 	      break;             } 	   else 	   { 0 	      if ((psb.del_status != PAMS__CONFIRMREQ )0 	      &&  (psb.del_status != PAMS__POSSDUPL   )1 	      &&  (psb.del_status != SS$_NORMAL       ))  	      {0 	         printf ("%s%s%sDelivery error: %x%s", / 		    DECSC, LINE(3), psb.del_status, DECRC );   	        break;                }   7 	      /**********************************************/ 7 	      /* We use the message type as an indicator of */ 7 	      /* how to process the message                 */ 7 	      /**********************************************/ ! 	      if ( type == -1 ) break;     <               msgbuf[ len_data] = 0;	/* make string ASCIZ */  > 	      printf ("%s%sMsg: |%s|%s",DECSC,LINE(2),msgbuf,DECRC );B 	      printf ("%s%s", LINE(10), "Enter <CR> to exit program : ");  2 	      if ( ( psb.del_status == PAMS__CONFIRMREQ )4 	      ||   ( psb.del_status == PAMS__POSSDUPL   ) ) 	      {( 	         /****************************/( 	         /* CONFIRMATION IS REQUIRED */( 	         /****************************/@ 	         istat = pams_confirm_msg ( psb.seq, &cstat, &forcej );$ 	         if ( istat != SS$_NORMAL ) 	         { 5 	            printf ("%s%sConfirmation error: %x%s",  0 	               DECSC, LINE(3), istat, DECRC );  	            break;  	         }                }  	   }  	}  " 	printf ("%s%s", LINE(4), "Exit"); }             
 void ttast ()  {     int ilen;      short otype     = 1;     short oclass    = 1;     short oprio     = 0;     short odelivery = 0;     short omsg_size = 0;     PAMS_ADDRESS  otarget;       long  istat;            otarget   = mypamsid;  	omsg_size = ttiosb[1];   	otype = ( omsg_size ) ? 1 : -1;  5 	/**************************************************/ 5 	/* Queue the buffer to mainline with PAMS_PUT_MSG */ 5 	/**************************************************/ 3 	istat = pams_put_msg ( ttinbuf, &oprio, &otarget,  < 	   &oclass, &otype, &odelivery, &omsg_size,0,0,0,0,0,0,0 ); 	     	/*****************************/  	/* POST A TERMINAL INPUT AST */  	/*****************************/ 	istat = sys$qio (  3 	   ttefn, ttchan, IO$_READVBLK, ttiosb, ttast, 0,  ( 	   ttinbuf, sizeof(ttinbuf), 0,0,0,0 );   }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           * [DMQ$V20.EXAMPLES]UCBS.DIR;1 +  , C   .     /     4                            - B    0  1    2   3     K  P   W   O     5   6  Vޕ  7  a  8          9 Z  G    H  J  I               BUILD_MBX_UCB.COM  	C     CNTRLC.C 
C     MBX.C  C     MBX.LNK  C     MBXRCV.C 
C     MBXSND.C C     TTSND.C  C                                                                                                                                                                                                                                                                                                                                                                             * * [DMQ$V20.EXAMPLES.UCBS]BUILD_MBX_UCB.COM;1 +  , 	C   .     /     4 5                          - C    0   1    2   3      K  P   W   O     5   6 @O7  7 @s  8          9 Z  G    H  J                      $	type sys$input:   2 	  This procedure is used to build the DECmessageQ5 	Sample User Callback "B" for performing VMS Mailbox  5 	I/O operations.  It requires that the VAX-C compiler 1 	be installed and the special type/class codes be * 	added to the current group via customize.   $! $	inquire ans "Proceed? [Y/N]" $	if .not. ans then exit $	wl := write sys$output $!0 $	if f$search("dmq$lib:ucb.olb") .eqs. "" then - 		library/create ucb $!) $	if f$search("mbx*.obj") .nes. "" then -  		delete/log m                                                                                                                                                                                                   F                        0 $      DMQ020.B                       	C  C  *[DMQ$V20.EXAMPLES.UCBS]BUILD_MBX_UCB.COM;1                                                                                     5                              9             bx*.obj.*  $! $	wl "Compiling MBX..."  $	cc/list mbx+dmq$user:dmq/lib5 $	wl "Compiling MBXSND (PAMS_USER_CALLBACK_SND_B)..." ! $	cc/list mbxsnd+dmq$user:dmq/lib 5 $	wl "Compiling MBXRCV (PAMS_USER_CALLBACK_RCV_B)..." ! $	cc/list mbxrcv+dmq$user:dmq/lib  $	purge/log mbx*.lis $!" $	library/log dmq$lib:ucb mbx*.obj $	delete/log mbx*.obj.*  $! $	wl "Linking MBX..." 
 $	@mbx.lnk $! $	exit                                                                                                                                ! * [DMQ$V20.EXAMPLES.UCBS]CNTRLC.C;1 +  , 
C   .     /     4 R                          - C    0   1    2   3      K  P   W   O     5   6 @3  7 s  8          9 Z  G    H  J              2 #module pams_user_callback_snd_c "CNTRL-C V2.0-00"  N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1988,1992                                                  *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/     O /****************************************************************************** I * Module:    PAMS_USER_CALLBACK_SND_C (Msg_ptr, Msg_Priority, Target_pn,  6 *				      Msg_Class, Msg_Type, Msg_Len, Msg_Delivery) *  * Filename:  MBXSND.C  * N * Function:     This subroutine is used to arm/disarm a control-c AST handler.I * 	     when the AST is triggered by a ^C a PAMS message is queued to the F * 	     owner process.  The ^C must be explicitly re-armed by process. * 	 * Inputs: = *	Msg_ptr       - Address of the message block being sent.    2 *	Msg_Priority  - Priority of the message (0 or 1): *	Target_pn     - The PAMS address of the target process  % *	Msg_Class     - Message class code. $ *	Msg_Type      - Message type code.  *	Msg_Len       - Message length( *	Msg_Delivery  - Delivery control flags * 
 * Outputs: *	None *  * External Subroutines *	pams_user_callback_alloc *	pams_user_callback_free  *	pams_user_callback_que
 * 	lib$get_ef  *	lib$signal *	sys$assign *	sys$cancel
 *	sys$qiow * 
 * Language: C  * O ******************************************************************************/    #include iodef #include ssdef #include stdio #include stsdef  #include descrip #include pams_c_process  #include pams_c_type_class #include pams_c_return_status  #include pams_c_entry_point  #include pams_c_symbol_def #define  PRIVATE_BUFFER 4   
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group;     } au; } pams_address;   6 typedef unsigned char BOOLEAN;		/* boolean variable */# #define FALSE                     0 # #define TRUE                      1    typedef struct IO$STATUS_BLK { %    unsigned short 	completion_status;     unsigned short 	not_used[3];  } IO$STATUS_BLK;  
 static struct  {     long int		event_flag;    long int		channel;     long int		my_pn;     IO$STATUS_BLK	iosb;    BOOLEAN		*work_avail_flag;     char			priority; 	 } cc_ucb;    extern    BOOLEAN	ucb[11][2];    void			print_sts( ); long int		lib$get_ef( ); void			lib$signal( );  long int		sys$assign( ); long int		sys$cancel( ); long int		sys$qiow( ); void			que_io_error( );  void			cntrlc_ast( );       const long ignore = PSYM_IGNORE;    G PAMS_USER_CALLBACK_SND_C (msg_ptr, msg_priority, target_pn, msg_class,  % 			  msg_type, msg_len, msg_delivery)    char		       **msg_ptr;  char			*msg_priority;  pams_address		*target_pn;  short int		*msg_class; short int		*msg_type;  short int		*msg_len; char			*msg_delivery;    {    long int		sts$value; long int		sts$temp;  long int		i; pams_address		target_proc; long int		msg_size;  long int		function_code; long int		size; & static char		tt_name_string[] = "TT:"; static char		param_line[150]; " static BOOLEAN		first_time = TRUE;  % $DESCRIPTOR(tt_name, tt_name_string);        sts$value = SS$_NORMAL;   J   if ((*msg_class == MSG_CLAS_UCB) && (*msg_type == MSG_TYPE_UCB_CONNECT))   { B 	/**************************************************************** 	*								* A 	*    This section initializes the channel table the first time	* ! 	*  this routine is called.					*  	*								* B 	****************************************************************/       if (first_time)      { )       first_time                 = FALSE; %       cc_ucb.event_flag          = 0; %       cc_ucb.channel             = 0; 2       cc_ucb.my_pn               = target_pn->all;%       cc_ucb.priority            = 1;   D 	/****************************************************************** 	*				NOTE:				  *D 	*   In order to change which UCB (A-J) this is the work available *D 	* flag must be updated as well.  The first subscript corresponds  *D 	* to the UCB letter (zero relative - A is 0, B is 1,...J is 9).	  * 	*				|				  *D 	********************************|********************************** 					V				  */.       cc_ucb.work_avail_flag     = &ucb[2][0];       if (cc_ucb.priority != 0) .           cc_ucb.work_avail_flag = &ucb[2][1];  1       sts$value = lib$get_ef(&cc_ucb.event_flag); +       if (!$VMS_STATUS_SUCCESS(sts$value))         { D 	print_sts("", "** ^C UCB failed on LIB$GET_EF call **", sts$value); 	goto free_msg;        }   E       sts$value = sys$assign (  &tt_name,	   /* device name        */ / 				&cc_ucb.channel,   /* assigned channel   */ # 				0,		   /* access mode (USER) */ $ 				0);		   /* MBX name           */  +       if (!$VMS_STATUS_SUCCESS(sts$value))         { E 	pams_print_sts("CNTRLC", "Failed to assign to terminal", sts$value);  	goto free_msg;         }  &     } /** end "first_time" section **/    2 	/************************************************	 	*						*  	*    		Post ^C Handler			* 	 	*						* 2 	************************************************/  0     function_code = IO$_SETMODE | IO$M_CTRLCAST;  I     sts$value = sys$qiow( cc_ucb.event_flag, 	/* Event Flag number     */ 0 			  cc_ucb.channel,	/* Channel number        */1   			  function_code,	/* function              */ / 			  &cc_ucb.iosb,		/* I/O status block      */ % 			  0,			/* AST routine address   */ & 			  0,	 		/* AST routine parameter */. 			  &cntrlc_ast,		/* ^C AST address        */% 			  0,			/* Parameter 2           */ % 			  0,			/* Parameter 3           */ % 			  0,			/* Parameter 4           */ % 			  0,			/* Parameter 5           */ & 			  0);			/* Parameter 6           */  *      if (!$VMS_STATUS_SUCCESS(sts$value))       {I 	pams_print_sts("CNTRLC", "Failed on post AST SYS$QIOW call", sts$value);  	goto free_msg;       }  /      sts$value = cc_ucb.iosb.completion_status; K      if (!$VMS_STATUS_SUCCESS(sts$value))          /* failure on receive */       {M 	pams_print_sts("CNTRLC", "Error in post AST SYS$QIOW call IOSB", sts$value);  	goto free_msg;       }  5   }  /** end "connect request" handling section ****/   2 	/************************************************	 	*						* % 	*	Process MBX disconnect request.		* 	 	*						* 2 	*********************                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  G                        5a $      DMQ020.B                       
C  C  ![DMQ$V20.EXAMPLES.UCBS]CNTRLC.C;1LE.C;1                                                                                        R                                          ***************************/  R   else if ((*msg_class == MSG_CLAS_UCB) && (*msg_type == MSG_TYPE_UCB_DISCONNECT))   {      if (first_time)         goto free_msg;      if (cc_ucb.channel != 0)     { .       sts$value = sys$cancel (cc_ucb.channel);+       if (!$VMS_STATUS_SUCCESS(sts$value))         { @ 	pams_print_sts("CNTRLC", "Failed to cancel ^C AST", sts$value); 	goto free_msg;        }        cc_ucb.channel = 0;      } )   }   /*** end of disconnect section ***/   >      /*** end "MBX UCB control message" handling section ****/     else     { 2 	/************************************************	 	*						* " 	*	Unknown MBX request message.		*	 	*						* 2 	************************************************/  "     sts$value = PAMS__INVUCBCNTRL;L     sprintf(&param_line, "** Unknown ^C UCB message type = %d.", *msg_type);)     print_sts("", param_line, sts$value);      goto free_msg;   }     2 	/************************************************	 	*						* ) 	*    	Free message before returning. 		* 	 	*						* 2 	************************************************/	 free_msg:        			/* delete message */ .   sts$temp = pams_user_callback_free(msg_ptr);  &   if (!$VMS_STATUS_SUCCESS(sts$temp))    { E      pams_print_sts("CNTRLC", "Failed to free msg buffer", sts$temp);       exit (sts$temp);    }      return (sts$value);  }   I /************************************************************************ I * Module:    CNTRLC_AST                                                 * I *                                                                       * I * Function:    This module is used to process ^C ASTs from terminals.   * I *                                                                       * I ************************************************************************/   $ static void   cntrlc_ast (ast_param)  # unsigned long int       *ast_param;    { " long int                sts$value; long int                i, j;  short int		size; long int                target;  long int                source;  short int               type;  short int               class;! char                    priority; ! char                    delivery;  char			*ptr;    2 	/************************************************	 	*						*   	*    	    Check for errors.			*	 	*						* 2 	************************************************/  ,   sts$value = cc_ucb.iosb.completion_status;H   if (!$VMS_STATUS_SUCCESS(sts$value))          /* failure on receive */   { !      if (sts$value != SS$_ABORT)  #         que_io_error(&cc_ucb.iosb);l      return;   }  02 	/************************************************	 	*						**1 	*  Queue ^C notification message back to user.	* 	 	*						* 2 	************************************************/     size = 0;   F   sts$value = pams_user_callback_alloc (&ptr, &size, &PRIVATE_BUFFER);'   if (!$VMS_STATUS_SUCCESS(sts$value))        lib$signal(sts$value);      class     = MSG_CLAS_UCB; $   type      = MSG_TYPE_UCB_RCV_DATA;   size      = 0;   priority  = cc_ucb.priority;   delivery  = 0;   target    = 0;   source    = cc_ucb.my_pn;r  9   sts$value = pams_user_callback_que (&ptr,    &priority,a>                                       &source, &target, &size,C                                       &class,  &type,   &delivery); '   if (!$VMS_STATUS_SUCCESS(sts$value)) n      lib$signal(sts$value);   F   *cc_ucb.work_avail_flag = TRUE;	/* indicate message on queue      */B   sts$value = pams_wake( &ignore, &ignore );	/* wake up rcv ucb */  	   return;  }   I /************************************************************************ E * Module:    QUE_IO_ERROR (STATUS_BLOCK)                           	*GI *                                                                       * I * Function:    This is the utility routine that handles $QIOW failures  * I *            by queuing a "msg_type_ucb_io_error" message to the user.  *sI *                                                                       *lI ************************************************************************/   ( static void  que_io_error (status_block)   IO$STATUS_BLK   *status_block;   {* long int        sts$value; long int        owner_proc;* IO$STATUS_BLK   *stat_ptr; short int       size;*      size      = sizeof(*stat_ptr);  J   sts$value = pams_user_callback_alloc(&stat_ptr, &size, &PRIVATE_BUFFER);'   if (!$VMS_STATUS_SUCCESS(sts$value)) i     lib$signal(sts$value);  H   *stat_ptr  = *status_block;      /* copy status block into PAMS msg */H   size       = sizeof(*stat_ptr);  /* reset it back to original number*/H   owner_proc = 0;                  /* PAMS_GET will set it correctly **/  C   sts$value = pams_user_callback_que (&stat_ptr, &cc_ucb.priority, nA                                       &cc_ucb.my_pn, &owner_proc,t<                                       &size, &MSG_CLAS_UCB, B                                       &MSG_TYPE_UCB_IO_ERROR, &0);   '   if (!$VMS_STATUS_SUCCESS(sts$value)) e     lib$signal(sts$value);  !   *cc_ucb.work_avail_flag = TRUE;nC   sts$value = pams_wake(&ignore, &ignore );	/* wakeup up rcv ucb */   	   return;_ }l k1 static void print_sts(process, text, status_code)	   char			*process;
 char			*text;a long int		status_code;   {*  struct dsc$descriptor_s pn_text;! struct dsc$descriptor_s msg_text;i    +   pn_text.dsc$w_length   = strlen(process);c)   pn_text.dsc$b_dtype    = DSC$K_DTYPE_T;m)   pn_text.dsc$b_class    = DSC$K_CLASS_S;i#   pn_text.dsc$a_pointer  = process;e  (   msg_text.dsc$w_length  = strlen(text);)   msg_text.dsc$b_dtype   = DSC$K_DTYPE_T; )   msg_text.dsc$b_class   = DSC$K_CLASS_S;     msg_text.dsc$a_pointer = text;  9   putil_print_statuss(&pn_text, &msg_text, &status_code);   	   return;n }n char BOOLEAN;		/* boolean variable */# #define FALSE                     0 # #define TRUE                      1    typedef struct IO$STATUS_BLK { %    unsigned short 	completion_status;     unsigned short 	not_used[3];  } IO$STATUS_BLK;  
 static struct  {     long int		event_flag;    long int		channel;     long int		my_pn;     IO$STATUS_BLK	iosb;               * [DMQ$V20.EXAMPLES.UCBS]MBX.C;1 +  , C   .      /     4 d                          - C    0   1    2   3      K  P   W   O !    5   6 i  7 t  8          9 Z  G    H  J                  #module mbx "V2.0-00"   N /*****************************************************************************N  *                                                                           *S  *  Copyright (c) 1989,1992                                                       * N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/     O /******************************************************************************  * Module:    MBX *                      * Filename:  MBX.C * A * Function:     This program is used to test PAMS MBX UCB code.    * 	 * Inputs:  *	None * 
 * Outputs: *	None *  * External Subroutines:  *	pams_attach_q  *	pams_get_msg *	pams_get_msgw  *	pams_put_msg * 
 * Language: C  * O ********************                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  H                        %L $      DMQ020.B                       C  C  [DMQ$V20.EXAMPLES.UCBS]MBX.C;1XAMPLE.C;1                                                                                       d                              \ "            **********************************************************/    #include stdio #include ssdef #include ssdef #include stsdef  #include descrip #include pams_c_process  #include pams_c_group  #include pams_c_type_class #include pams_c_return_status  #include pams_c_entry_point  #include pams_c_symbol_def  6 typedef unsigned char BOOLEAN;		/* boolean variable */# #define FALSE                     0 # #define TRUE                      1     
 typedef union  {     long int      all; 	    struct     {       short int  process;        short int  group;     } au; } pams_address;    static struct  {     short int	buffers;     short int	max_msg_size;    char		priority; } int_rec = {100, 1000, 1};    static struct  {     BOOLEAN	send_flag; !    char         send_mbx_lnm[20];     BOOLEAN	rcv_flag;     char         rcv_mbx_lnm[20];$ } cnt_rec = {0, "     ", 0, "    "};       static pams_address	target;  static pams_address	source;  static long int		sts$value;  static long int		proc_num_in; ! static pams_address	proc_num_out;  static short int	size, i; 2 static short int	class, type, rcv_class, rcv_type;0 static short int	hold_type, msg_size, input_num; static char		buffer[81]; static char		sts_line[100];  static char		*msg_buffer, c; static char		delivery;( static short int	priority, rcv_priority; static long int		put_timeout;  struct psb		psb; static char		uma;      static long int		resp_que; static long int		sel_addr; static BOOLEAN		first_time; % static long int		dcl_num, target_num; 6 static long int         attach_mode,q_type,q_name_len;# static char             q_name[32];    void			connect ( );  void			disconnect ( ); void			send_msg ( ); void			rcv_msg ( );  void			rcv_msgw ( ); void			print_rcvd ( ); void			get_str ( );  long int		asc2bin ( ); void			print_sts ( );    MBX ( )    { ,   printf("\n\t*** DMQ MBX V2.0-00 ***\n\n");     proc_num_in  = 0; 1   printf("Process number [D:%d]: ", proc_num_in);    get_str(buffer);   if (buffer[0] != '\0')&      proc_num_in = asc2bin(buffer,20);     proc_num_out.all = 0;      q_type = PSYM_ATTACH_PQ;   if (proc_num_in == 0)    { (     attach_mode = PSYM_ATTACH_TEMPORARY;U     sts$value = pams_attach_q (&attach_mode,&proc_num_out.all,&q_type,0,0,0,0,0,0,0);    }    else   { (     attach_mode = PSYM_ATTACH_BY_NUMBER;&     sprintf (q_name,"%d",proc_num_in);!     q_name_len = strlen (q_name); d     sts$value = pams_attach_q (&attach_mode,&proc_num_out.all,&q_type,q_name,&q_name_len,0,0,0,0,0);   } '   if (!$VMS_STATUS_SUCCESS(sts$value))     { 9       print_sts("MBX", "Error returned by PAMS_ATTACH_Q",  					 sts$value);        exit(sts$value);   }   N   sprintf(&sts_line, "\nMy process number is %d.%d\n", proc_num_out.au.group, - 					               proc_num_out.au.process);    printf(sts_line);      source.all      = 0;   class           = 1;   type            = 0;%   delivery        = PDEL_MODE_NN_MEM;    priority        = 0;   rcv_priority    = 0;   put_timeout	  = 0;   uma		  = PDEL_UMA_DISC;    resp_que	  = 0;    sel_addr	  = 0;    first_time      = FALSE;    9   /******************************************************    *							* $   *		Initialize MBX User Callback		*   *		      					* 9   ******************************************************/      target.all      = 0;,   printf("MBX number [D:%d]: ", target.all);   get_str(buffer);   if (buffer[0] != '\0')%      target.all = asc2bin(buffer,20);   5   printf("... Initializing MBX User-Callback ...\n");      msg_size  = sizeof(int_rec);    <   sts$value = pams_put_msg(&int_rec, &priority, &target.all,3 			       &MSG_CLAS_UCB, &MSG_TYPE_UCB_INITIALIZE,  3 			       &delivery, &msg_size, &put_timeout, &psb,  			       &uma, &resp_que); '   if (!$VMS_STATUS_SUCCESS(sts$value))     { 7      print_sts("MBX", "Error returned by PAMS_PUT_MSG",  			 sts$value);       return;   }	     printf("\n");     9   /******************************************************    *							*    *		Process user requests			*   *							* 9   ******************************************************/      buffer[0] = 'C';  
   for (; 1 ;)    {        switch (toupper(buffer[0]))      {
 	case 'E':
 		exit(1); 		break;
 	case 'C':
 		connect( );  		break;
 	case 'D': 		disconnect( ); 		break;
 	case 'S': 		send_msg( ); 		break;
 	case 'R':
 		rcv_msg( );  		break;
 	case 'W': 		rcv_msgw( ); 		break;	 	default: % 		printf("\n ** Invalid command **");  		break;      }      printf("\n");Q      printf("Action [(C)onnect, (D)isconnect, (S)end, (R)cv, rcv(W), (E)xit]: ");       get_str(buffer);      }    }  /* end of MBX */     9   /******************************************************    *							*    *	Module: Connect					*    *							* 9   ******************************************************/    static void connect( ) { 1   for (i=0; i < sizeof(cnt_rec.rcv_mbx_lnm); i++)    { !      cnt_rec.send_mbx_lnm[i] = 0; !      cnt_rec.rcv_mbx_lnm[i]  = 0;    }      cnt_rec.send_flag = 0;J   printf("MBX send flag [0=none,1=create,2=assign]: ", cnt_rec.send_flag);   get_str(buffer);   if (buffer[0] != '\0'),      cnt_rec.send_flag = asc2bin(buffer,20);     if (cnt_rec.send_flag != 0)    { <     printf("Send MBX logical name: ", cnt_rec.send_mbx_lnm);     get_str(buffer);     if (buffer[0] != '\0')K        strncpy(cnt_rec.send_mbx_lnm, buffer, sizeof(cnt_rec.send_mbx_lnm));    }      cnt_rec.rcv_flag = 0; L   printf("MBX receive flag [0=none,1=create,2=assign]: ", cnt_rec.rcv_flag);   get_str(buffer);   if (buffer[0] != '\0')+      cnt_rec.rcv_flag = asc2bin(buffer,20);      if (cnt_rec.rcv_flag != 0)   { >     printf("Receive MBX logical name: ", cnt_rec.rcv_mbx_lnm);     get_str(buffer);     if (buffer[0] != '\0')I        strncpy(cnt_rec.rcv_mbx_lnm, buffer, sizeof(cnt_rec.rcv_mbx_lnm));    }      msg_size = sizeof(cnt_rec);   <   sts$value = pams_put_msg(&cnt_rec, &priority, &target.all,+ 			   &MSG_CLAS_UCB, &MSG_TYPE_UCB_CONNECT, ) 			   &delivery, &msg_size, &put_timeout,  			   &psb, &uma, &resp_que); '   if (!$VMS_STATUS_SUCCESS(sts$value))     { 7      print_sts("MBX", "Error returned by PAMS_PUT_MSG",  					 sts$value);       return;   }	   }   9   /******************************************************    *							*    *	Module: Disconnect				*    *							* 9   ******************************************************/    static void   disconnect( )  { ;   sts$value = pams_put_msg(&buffer, &priority, &target.all, . 			   &MSG_CLAS_UCB, &MSG_TYPE_UCB_DISCONNECT,; 			   &delivery, &0, &put_timeout, &psb, &uma, &resp_que);  '   if (!$VMS_STATUS_SUCCESS(sts$value))     { 7      print_sts("MBX", "Error returned by PAMS_PUT_MSG",  					 sts$value);       return;   }	  	   return;    }   9   /******************************************************    *							*    *	Module: Send_msg				*    *							* 9   ******************************************************/    static void send_msg( )    {    printf("\n"); 4   printf("(Terminate msg data input with a '.')\n");   printf("Enter msg data: ");    scanf("%[^.]", &buffer);  <   while ((c = getchar()) != '\n');  /* flush input buffer */     printf("\n");    size = strlen(buffer);  ;   sts$value = pams_put_msg(&buffer, &priority, &target.all, - 			   &1, &2, &delivery, &size, &put_timeout,  			   &psb, &uma, &resp_que); '   if (!$VMS_STATUS_SUCCESS(sts$value))     { 7      print_sts("MBX", "Error returned by PAMS_PUT_MSG",  					 sts$value);       return;   }	  	   return;  }   9   /******************************************************    *							*    *	Module: Rcv_msg					*    *							* 9   ******************************************************/    static void rcv_msg( ) { ?   sts$value = pams_get_msg(&buffer, &rcv_priority, &source.all, =                            &rcv_class, &rcv_type, &80, &size,  			   &sel_addr, &psb); #   if (sts$value == PAMS__NOMOREMSG) %      print_sts("MBX", "", sts$value); ,   else if (!$VMS_STATUS_SUCCESS(sts$value))    { 7      print_sts("MBX", "Error returned by PAMS_GET_MSG", 4                                          sts$value);      return;   }V   else5      print_rcvd (source.au.group, source.au.process, *9                       rcv_class, rcv_type, size, buffer); 	   return;    }/** end of rcv_msg ***/        9   /******************************************************    *							*    *	Module: Rcv_msgw				*E   *							*o9   ******************************************************/    static void rcv_msgw( )  { @   sts$value = pams_get_msgw(&buffer, &rcv_priority, &source.all,D                             &rcv_class, &rcv_typ                                                                                                                                                                                                                                                   I                        P| $      DMQ020.B                       C  C  [DMQ$V20.EXAMPLES.UCBS]MBX.C;1XAMPLE.C;1                                                                                       d                              G             e, &80, &size, &100, 			    &sel_addr, &psb); f!   if (sts$value == PAMS__TIMEOUT)*%      print_sts("MBX", "", sts$value);c,   else if (!$VMS_STATUS_SUCCESS(sts$value))    {h7      print_sts("MBX", "Error returned by PAMS_GET_MSG",a4                                          sts$value);      return;   }s   else5      print_rcvd (source.au.group, source.au.process,  9                       rcv_class, rcv_type, size, buffer); 	   return;    }/** end of rcv_msg ***/    9   /******************************************************g   *							*o   *	Module: print_rcvd 			*t   *							*e9   ******************************************************/o  ? static void   print_rcvd (group, proc, class, type, size, buff)*  ) short int	group, proc, class, type, size; 
 char		buff[];  {  short int	sts$value; short int	i; char		*ptr;    struct   {     pams_address		target;!    pams_address		original_target;n!    pams_address		original_source;     long int		sequence_number;     char			delivery;     char			priority;     char			buffer_type;    char			filler[81];* } item_buffer;   typedef struct IO$STATUS_BLK { %    unsigned short 	completion_status;*"    unsigned short 	transfer_count;    unsigned long	pid;  } IO$STATUS_BLK;   IO$STATUS_BLK		*stat_ptr;  BOOLEAN			prt_data;p   m   printf("\n");P   prt_data = TRUE;     if (class == MSG_CLAS_UCB)   {t'      if (type == MSG_TYPE_UCB_IO_ERROR)       { 	stat_ptr = buff;t6         printf("Received a UCB I/O ERROR message.\n");?         printf("  Completion-status=%d, xfer-cnt=%d, PID=%X\n",*8 		stat_ptr->completion_status, stat_ptr->transfer_count, 		stat_ptr->pid);c 	prt_data = FALSE;      },      else if (type == MSG_TYPE_UCB_RCV_DATA) 	;	      elsee5         printf("Received an unknown UCB message.\n");c   }p  C   printf("Rcvd msg from %d.%d  Class: %d  Type: %d  Length: %d\n",  % 					group, proc, class, type, size);n
   ptr = buff;      if ((size > 0) && prt_data)    {       printf("Rcv data = ");n      for (i=0; i < size; i++)           putchar(*buff++);   }n   putchar('\n');   return;  }o  9   /******************************************************t   *							*    *	Module: get_str				*   *							*p9   ******************************************************/    static void get_str(a)   char	*a; { 
 char    c, b;]
 int	i,j,k;    )   b = 'N';		/* suppress leading blanks */   3   for (i=0; ((c = getchar()) != '\n') && (i < 80);)m     {s2      if ((c != ' ') || ((c == ' ') && (b == 'Y')))        {         *(a+(i++)) = c;	5         b = 'Y';  	/* set read embeded blanks flag */t        }     },     *(a+i) = '\0';  	   return;e }c l9   /******************************************************_   *							*c   *	Module: asc2bin				*   *							*[9   ******************************************************/;   static long int asc2bin(a, n)p  	 char		*a;t long int	n;p {t long int	i,j,k;p char		neg_flag;c       neg_flag = 'N';l  ,   for (i=0; (*(a+i) == ' ') && (i < n); i++)$      ;			/* remove leading blanks */     if (*(a+i) == '-')     {       i += 1;      neg_flag = 'Y';     }q  -   for (j=0; (*(a+i) != '\0') && (i < n); i++)      {	      if (*(a+i) == ' ') 0          break;			/* white space - we're done */*      if ((*(a+i) < '0') || (*(a+i) > '9'))         return (0);s  #      j = (j * 10) + (*(a+i) - '0');	     }s     if (neg_flag == 'Y')      j = -j;  
   return (j);2 }0 *1 static void print_sts(process, text, status_code)    char			*process;
 char			*text;  long int		status_code;   {r  struct dsc$descriptor_s pn_text;! struct dsc$descriptor_s msg_text;t    +   pn_text.dsc$w_length   = strlen(process);r)   pn_text.dsc$b_dtype    = DSC$K_DTYPE_T;S)   pn_text.dsc$b_class    = DSC$K_CLASS_S;a#   pn_text.dsc$a_pointer  = process;l  (   msg_text.dsc$w_length  = strlen(text);)   msg_text.dsc$b_dtype   = DSC$K_DTYPE_T;;)   msg_text.dsc$b_class   = DSC$K_CLASS_S;     msg_text.dsc$a_pointer = text;  8   putil_print_status(&pn_text, &msg_text, &status_code);  	   return;a }&name_len,0,0,0,0,0);   } '   if (!$VMS_STAT                * [DMQ$V20.EXAMPLES.UCBS]MBX.LNK;1 +  , C   .     /     4 :                           - C    0   1    2   3      K  P   W   O     5   6  -7  7 t  8          9 Z  G    H  J                $ ver = f$verify(1) / $ LINK /MAP=MBX/EXE=MBX DMQ$LIB:UCB/inc=(MBX),- :            DMQ$LIB:UCB/LIB/INC=(PAMS_USER_CALLBACK_SND_B,- 				PAMS_USER_CALLBACK_RCV_B),- "            DMQ$LIB:DMQ$OLB/OPTIONS $! $ ver = f$verify(ver)  $ EXIT                                                                                                                                                                                                                                                                                              ! * [DMQ$V20.EXAMPLES.UCBS]MBXRCV.C;1 +  , 
C   .     /     4 P                          - C    0   1    2   3      K  P   W   O 
    5   6  :g  7 G$t  8          9 Z  G    H  J              . #module pams_user_callback_rcv_b "MBX V2.0-01"  N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1988,1992                                                  *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/     O /****************************************************************************** M * Module:    PAMS_USER_CALLBACK_RCV_B (MSG_PTR, PRIORITY, SOURCE, MSG_CLASS,  7 *			               MSG_TYPE, MSG_LENGTH, MSG_DELIVERY)   *  * Filename:  MBXRCV.C  * J * Function:     This routine is used to read messages from the MBX receive *	     message hold queue. * 	 * Inputs: : *	PRIORITY	- Priority of the message to dequeue (P0 or P1) * 
 * Outputs:B *	MSG_PTR		- Pointer to the user data area of the dequeued message *	SOURCE		- Source of message  *	MSG_CLASS	- Class of message *	MSG_TYPE	- Type of message: *	MSG_LENGTH	- Length of the user data area of the message1 *	MSG_DELIVERY	- Delivery message flag (not used) ' *	return status	- Status message number  *  * External Subroutines:  *	pams_user_callback_deque * 
 * Language: C  * O ******************************************************************************/    #include ssdef #include stsdef  #include pams_c_return_status   6 typedef unsigned char BOOLEAN;		/* boolean variable */# #define FALSE                     0 # #define TRUE                      1     H pams_user_callback_rcv_b (msg_ptr,  msg_priority, source_pn, msg_class, ( 			  msg_type, msg_length, msg_delivery)   char		       **msg_ptr;  char			*msg_priority;  long int		*source_pn;  short int		*msg_class; short int		*msg_type;  short int		*msg_length;  char			*msg_delivery;    {  long int		target;  long int		sts$value; char			delivery;( globalref BOOLEAN 	*mbx_work_avail_flag;         *msg_delivery = 0;  I   *mbx_work_avail_flag = FALSE;           /* assume one entry on queue */   J   sts$value = pams_user_callback_deque (msg_ptr, msg_priority, source_pn, % 					&target, msg_length, msg_class,   					msg_type, &delivery);  ,          /* if true, more entrys on queue */I   if (($VMS_STATUS_SUCCESS(sts$value)) && (sts$value != PAMS__NOMOREMSG))      { P      *                                                                                                                                                                                                                   J                        < $      DMQ020.B                       
C  C  ![DMQ$V20.EXAMPLES.UCBS]MBXRCV.C;1PLE.C;1                                                                                       P                             s             mbx_work_avail_flag = TRUE;        /* set flag to read rest of the msgs */      sts$value = SS$_NORMAL;     }      return(sts$value); }                                                                                                                                                                                                                                                                                                                                                                                                 ! * [DMQ$V20.EXAMPLES.UCBS]MBXSND.C;1 +  , C   . 0    /     4 ^   0   /                    - C    0   1    2   3      K  P   W   O 1    5   6 `b4  7 @2t  8          9 Z  G    H  J              . #module pams_user_callback_snd_b "MBX V2.0-05"  N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1991,1992                                                  *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/     O /****************************************************************************** I * Module:    PAMS_USER_CALLBACK_SND_B (Msg_ptr, Msg_Priority, Target_pn,  6 *				      Msg_Class, Msg_Type, Msg_len, Msg_Delivery) *  * Filename:  MBXSND.C  * K * Function:     This subroutine is used to send a message marked by msg_ptr C *	     to the Target process which requires that they be sent via a I *	     VMS mailbox.  When a MBX create is requested it creates a logical  F *	     name with the mailbox device name in the LNM$TEMPORARY_MAILBOX E *	     table (see "VMS System Services" - SYS$CREMBX).  To place the  ? *	     logical in the group table do the following DCL command:  * J *	    $ DEFINE/TABLE=LNM$PROCESS_DIRECTORY LNM$TEMPORARY_MAILBOX LNM$GROUP * 	 * Inputs: = *	Msg_ptr       - Address of the message block being sent.    2 *	Msg_Priority  - Priority of the message (0 or 1): *	Target_pn     - The PAMS address of the target process  % *	Msg_Class     - Message class code. $ *	Msg_Type      - Message type code.  *	Msg_len       - Message length( *	Msg_Delivery  - Delivery control flags * 
 * Outputs: *	None *  * External Subroutines *	pams_user_callback_alloc *	pams_user_callback_free  *	pams_user_callback_que
 * 	lib$get_ef  *	lib$signal *	sys$assign *	sys$crembx *	sys$dassgn	 *	sys$qio 
 *	sys$qiow * 
 * Language: C  * O ******************************************************************************/    #include iodef #include ssdef #include stdio #include stsdef  #include descrip #include pams_c_process  #include pams_c_type_class #include pams_c_return_status  #include pams_c_entry_point  #include pams_c_symbol_def #define  TEMPORARY_MBX  0  #define  PRIVATE_BUFFER 4  #define  MBX_NOT_USED   0  #define  MBX_CREATE     1  #define  MBX_ASSIGN     2   
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group;     } au; } pams_address;   6 typedef unsigned char BOOLEAN;		/* boolean variable */# #define FALSE                     0 # #define TRUE                      1    typedef struct IO$STATUS_BLK { %    unsigned short 	completion_status; "    unsigned short 	transfer_count;    unsigned long	pid;  } IO$STATUS_BLK;  
 static struct  {     long int		buffer_quota;    long int		event_flag;    long int		send_channel;    long int		rcv_channel;     long int		my_pn;     short int		max_msg_size;     IO$STATUS_BLK	send_iosb;     IO$STATUS_BLK	rcv_iosb;    BOOLEAN		connected;    char			*rcv_ptr;     char			priority;     char			send_mbx_lnm[20];     char			rcv_mbx_lnm[20];
 } mbx_ucb;  - globaldef BOOLEAN       *mbx_work_avail_flag; / globalref long int	pams_number_private_buffers; - globalref long int	pams_size_private_buffers;  extern    BOOLEAN	ucb[11][2];    long int		lib$get_ef( ); void			lib$signal( );  long int		sys$assign( ); long int		sys$dassgn( ); long int		sys$crembx( ); long int		sys$qio( );  long int		sys$qiow( ); long int		get_mbx_channel( );  void			mbx_rcv_ast( ); void			que_io_error( );  void			print_sts( );    G PAMS_USER_CALLBACK_SND_B (msg_ptr, msg_priority, target_pn, msg_class,  % 			  msg_type, msg_len, msg_delivery)    char		       **msg_ptr;  char			*msg_priority;  pams_address		*target_pn;  short int		*msg_class; short int		*msg_type;  short int		*msg_len; char			*msg_delivery;    {  typedef struct INT_REC {     short int	buffers;     short int	max_msg_size;    char		priority;
 } INT_REC;   typedef struct CNT_REC {     BOOLEAN	send_flag; !    char         send_mbx_lnm[20];     BOOLEAN	rcv_flag;     char         rcv_mbx_lnm[20];
 } CNT_REC;   long int		sts$value; long int		sts$temp;  long int		i; pams_address		target_proc; long int		msg_size;  long int		function_code; long int		size;  INT_REC			*int_ptr;  CNT_REC			*cnt_ptr;  char			*blk_ptr; static char		param_line[150]; " static BOOLEAN		first_time = TRUE;       sts$value = SS$_NORMAL;   !   if (*msg_class == MSG_CLAS_UCB)    { .      if (*msg_type == MSG_TYPE_UCB_INITIALIZE)      {B 	/**************************************************************** 	*								* A 	*    This section initializes the channel table the first time	* ! 	*  this routine is called.					*  	*								* B 	****************************************************************/           if (first_time) 	         { 2            int_ptr                     = *msg_ptr;/            first_time                  = FALSE; +            mbx_ucb.buffer_quota        = 0; +            mbx_ucb.event_flag          = 0; +            mbx_ucb.send_channel        = 0; +            mbx_ucb.rcv_channel         = 0; 8            mbx_ucb.my_pn               = target_pn->all;?            mbx_ucb.max_msg_size        = int_ptr->max_msg_size; /            mbx_ucb.connected           = FALSE; ;            mbx_ucb.priority            = int_ptr->priority; @            strcpy(&mbx_ucb.send_mbx_lnm, "                   ");@            strcpy(&mbx_ucb.rcv_mbx_lnm,  "                   ");:            pams_number_private_buffers = int_ptr->buffers;?            pams_size_private_buffers   = int_ptr->max_msg_size;   D 	/****************************************************************** 	*				NOTE:				  *D 	*   In order to change which UCB (A-J) this is the work available *D 	* flag must be updated as well.  The first subscript corresponds  *D 	* to the UCB letter (zero relative - A is 0, B is 1,...J is 9).	  * 	*				     |				  * D 	*************************************|***************************** 					     V				*/ 3            mbx_work_avail_flag        = &ucb[1][0]; %            if (mbx_ucb.priority != 0) 3               mbx_work_avail_flag     = &ucb[1][1];   7            sts$value = lib$get_ef(&mbx_ucb.event_flag); 0            if (!$VMS_STATUS_SUCCESS(sts$value))             {O      	      print_sts("MBX_SND", "** Failed on LIB$GET_EF call **", sts$value);                goto free_msg;            }  B 	/******************************                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  K                        ! $      DMQ020.B                       C  C  ![DMQ$V20.EXAMPLES.UCBS]MBXSND.C;1PLE.C;1                                                                                       ^    0                          "            ********************************** 	*								* @ 	*     Allocate and free a private buffer to create the buffer	*A 	*   pool.  This will cause it fail now instead of on the first	* 3 	*   message send if it's going to fail at all.			*  	*								* B 	****************************************************************/ 	 P            sts$value = pams_user_callback_alloc (&blk_ptr, &1, &PRIVATE_BUFFER);  /            if ($VMS_STATUS_SUCCESS(sts$value))  =               sts$value = pams_user_callback_free (&blk_ptr);   0            if (!$VMS_STATUS_SUCCESS(sts$value))             {F               print_sts("MBX_SND", "Failed to create UCB buffer pool", 			      sts$value);               goto free_msg;            }  *         } /** end "first_time" section **/         else	         { )            sts$value = PAMS__INVUCBCNTRL; I            print_sts("MBX_SND", "*** Multiple MBX UCB init msgs ***", 2); 	         }   &     } /** end init message section **/  2 	/************************************************	 	*						* ' 	*	Perform link startup and shutdown.	* 	 	*						* 2 	************************************************/  B      else if ((*msg_type == MSG_TYPE_UCB_CONNECT) & (!first_time))      {(         if (*msg_len < sizeof(*cnt_ptr))	         { )            sts$value = PAMS__INVUCBCNTRL; J 	   print_sts("MBX_SND", "** Invalid MBX UCB connect request size **", 2);            goto free_msg; 	         }            if (mbx_ucb.connected)	         { $            sts$value = PAMS__CIRACT;            goto free_msg; 	         }    	cnt_ptr = *msg_ptr;: 	strncpy(mbx_ucb.send_mbx_lnm, cnt_ptr->send_mbx_lnm, 20);: 	strncpy(mbx_ucb.rcv_mbx_lnm,  cnt_ptr->rcv_mbx_lnm,  20);  , 		/* connect to the send and receive MBXs */^ 	sts$value = get_mbx_channel(&mbx_ucb.send_channel, mbx_ucb.send_mbx_lnm, cnt_ptr->send_flag);% 	if ($VMS_STATUS_SUCCESS(sts$value))  ^ 	   sts$value = get_mbx_channel(&mbx_ucb.rcv_channel, mbx_ucb.rcv_mbx_lnm, cnt_ptr->rcv_flag);& 	if (!$VMS_STATUS_SUCCESS(sts$value))  	{%            mbx_ucb.connected = FALSE;             goto free_msg;  	}  N 	if ((cnt_ptr->send_flag == MBX_CREATE) || (cnt_ptr->send_flag == MBX_ASSIGN)) 	   mbx_ucb.connected = TRUE;    	size = mbx_ucb.max_msg_size;   Q 	sts$value = pams_user_callback_alloc (&mbx_ucb.rcv_ptr, &size, &PRIVATE_BUFFER); & 	if (!$VMS_STATUS_SUCCESS(sts$value))  	{%            mbx_ucb.connected = FALSE; Q            print_sts("MBX_SND", "** Failed on pams_user_callback_alloc call **",   				sts$value);             goto free_msg;  	}  : 	/********************************************************
 	*							*8 	*     Determine if a large enough buffer was returned	*9 	*   by the allocate because the first time it's called	* 7 	*   it creates the buffer pool and fixes the size of	*  	*   UCB buffers.					* 
 	*							*: 	********************************************************/  (         if (size < mbx_ucb.max_msg_size) 	{%            mbx_ucb.connected = FALSE; , 	   sts$value = 2; 	/* generic error code */R            print_sts("MBX_SND", "** Failed to allocate requested buffer size **",  				sts$value);f            goto free_msg;e 	}  2 	/************************************************	 	*						*  	*    		Post MBX read			* 	 	*						* 2 	************************************************/  : 	size = mbx_ucb.max_msg_size;	/* restore size parameter */  E 	sts$value = sys$qio (mbx_ucb.event_flag, /* Event Flag number     */ 7 			     mbx_ucb.rcv_channel,/* Channel number        */ 4   			     IO$_READVBLK,	 /* function              */7 			     &mbx_ucb.rcv_iosb,	 /* I/O status block      */t2 			     &mbx_rcv_ast,	 /* AST routine address   */* 			     0,	 		 /* AST routine parameter */5 			     mbx_ucb.rcv_ptr,	 /* buffer address        */ + 			     size,		 /* buffer_length         */ ) 			     0,			 /* Parameter 3           */ ) 			     0,			 /* Parameter 4           */o) 			     0,			 /* Parameter 5           */i) 			     0);		 /* Parameter 6           */n  & 	if (!$VMS_STATUS_SUCCESS(sts$value))  	{%            mbx_ucb.connected = FALSE; I            print_sts("MBX_SND", "Failed on rcv SYS$QIO call", sts$value);*            goto free_msg;* 	}  8      }  /** end "connect request" handling section ****/  2 	/************************************************	 	*						*B% 	*	Process MBX disconnect request.		*t	 	*						*	2 	************************************************/  E      else if ((*msg_type == MSG_TYPE_UCB_DISCONNECT) & (!first_time))o      { 	if (mbx_ucb.send_channel != 0) 	         {g2 	   sts$value = sys$dassgn (mbx_ucb.send_channel);) 	   if (!$VMS_STATUS_SUCCESS(sts$value)) e 	   { F 	      print_sts("MBX_SND", "Failed to deassign send MBX", sts$value); 	      goto free_msg;  	   }t 	   mbx_ucb.send_channel = 0; 	         }X 	if (mbx_ucb.rcv_channel != 0)	         {r1 	   sts$value = sys$dassgn (mbx_ucb.rcv_channel); ) 	   if (!$VMS_STATUS_SUCCESS(sts$value)) M 	   {ME 	      print_sts("MBX_SND", "Failed to deassign rcv MBX", sts$value);a 	      goto free_msg;  	   }_ 	   mbx_ucb.rcv_channel = 0;	         } ,      }   /*** end of disconnect section ***/  
      else       {2 	/************************************************	 	*						*y" 	*	Unknown MBX request message.		*	 	*						*s2 	************************************************/  &         sts$value = PAMS__INVUCBCNTRL;E         sprintf(&param_line, "** Unknown MBX UCB message type = %d.",k 				*msg_type);e,         print_sts("MBX_SND", param_line, 2);         goto free_msg;      }  =   } /*** end "MBX UCB control message" handling section ****/* *: 	/********************************************************
 	*							*6 	*    This section is used to send user data message	*, 	*  over an already established VMS MBX.			*
 	*							*: 	********************************************************/   	/** send message via MBX **/n   else if (mbx_ucb.connected)P   {E)      if (*msg_len > mbx_ucb.max_msg_size)f      {%         sts$value = PAMS__BIGBLKSIZE;          goto free_msg;      }2 	/************************************************	 	*						*e 	*    		Send the message.		*	 	*						* 2 	************************************************/         sts$value     = SS$_NORMAL;      size          = *msg_len;.      function_code = IO$_WRITEVBLK | IO$M_NOW;  ;      sts$value = sys$qiow (0,			/* Event Flag number     */u6 			   mbx_ucb.send_channel,/* Channel number        */2   			   function_code,	/* function              */5 			   &mbx_ucb.send_iosb,	/* I/O status block      */s& 			   0,			/* AST routine address   */& 			   0,			/* AST routine parameter */, 			   *msg_ptr,		/* buffer address        */( 			   size,		/* buffer_length         */& 			   0,			/* Parameter 3           */& 			   0,			/* Parameter 4           */& 			   0,			/* Parameter 5           */' 			   0);			/* Parameter 6           */i  *      if (!$VMS_STATUS_SUCCESS(sts$value))       {"         mbx_ucb.connected = FALSE;H         print_sts("MBX_SND", "Failed on send SYS$QIOW call", sts$value);         goto free_msg;      }D      if (!$VMS_STATUS_SUCCESS(mbx_ucb.send_iosb.completion_status))       {1 	sts$value = mbx_ucb.send_iosb.completion_status;t"         mbx_ucb.connected = FALSE;K         print_sts("MBX_SND", "Error in the send SYS$QIOW IOSB", sts$value);A         goto free_msg;      }  '   } /** end "send message" section ***/, g$   else  /* channel in wrong state */   {p      sts$value = PAMS__NOLINK;>      print_sts("MBX_SND", "*** Not connected to MBX *** ", 2);   }e  2 	/************************************************	 	*						*t) 	*    	Free message before returning. 		* 	 	*						*m2 	************************************************/	 free_msg:C       			/* delete message */g.   sts$temp = pams_user_callback_free(msg_ptr);  &   if (!$VMS_STATUS_SUCCESS(sts$temp))    { A      print_sts("MBX_SND", "Failed to free msg buffer", sts$temp);	      exit (sts$temp);t   };     return (sts$value);o }i 	I /************************************************************************ 9 * Module:    GET_MBX_CHANNEL (channel, mbx_lnm, flag)			*BI *                                                                       *cG * Function:    This module is used to create or assign a MBX channel.	*ZI *                                                                       **I ************************************************************************/t  : static long int   get_mbx_channel (channel, mbx_lnm, flag)   short int		*channel; char			mbx_lnm[20];* char			flag; {/ long int		sts$value; long int		i; long int		protection_mask;  struct dsc$descriptor_s lnm_str;    $   for(i=0; i < strlen(mbx_lnm)                                                                                                                                                                                                                                                   L                        =T $      DMQ020.B                       C  C  ![DMQ$V20.EXAMPLES.UCBS]MBXSND.C;1;1                                                                                            ^    0                               !       ; i++)%     mbx_lnm[i] = toupper(mbx_lnm[i]);   +   lnm_str.dsc$w_length   = strlen(mbx_lnm); )   lnm_str.dsc$b_dtype    = DSC$K_DTYPE_T; )   lnm_str.dsc$b_class    = DSC$K_CLASS_S; #   lnm_str.dsc$a_pointer  = mbx_lnm;      if (flag == MBX_CREATE);   { : 	/********************************************************
 	*							*1 	*	User wants to create a mailbox accessible by	*m, 	*   all processes in this VMS UIC group.		*
 	*							*: 	********************************************************/  9      protection_mask = 0x0F00F;	/* (s,o:RWPL,g:RWPL,w) */;  E      sts$value = sys$crembx( TEMPORARY_MBX,		/* mbx type flag      */p+ 			     channel,			/* channel number     */_K                              mbx_ucb.max_msg_size,	/* max msg size       */*?                              0,				/* buffer quota (default) */sG                              protection_mask,		/* protection mask    */s;                              0,				/* access mode (USER) */ B                              &lnm_str);			/* logical name       */*      if (!$VMS_STATUS_SUCCESS(sts$value))       {@         print_sts("MBX_SND", "Failed to create MBX", sts$value);         return(sts$value);       }r   }=     else if (flag == MBX_ASSIGN)   { : 	/********************************************************
 	*							*- 	*	User wants to connect to an existing MBX	*$
 	*							*: 	********************************************************/  C      sts$value = sys$assign( &lnm_str,		   /* device name        */ - 			     channel,		   /* assigned channel   */*( 			     0,			   /* access mode (USER) */( 			     0);		   /* MBX name           */  *      if (!$VMS_STATUS_SUCCESS(sts$value))       {C         print_sts("MBX_SND", "Failed to assign to MBX", sts$value);  	return(sts$value);       }     }  /** end of MBX assign **/     return(SS$_NORMAL);*   }* *I /************************************************************************VI * Module:    MBX_RCV_AST                                                * I *                                                                       *SI * Function:    This module is used to process MBX receive completions.  *DI *                                                                       * I ************************************************************************/   % static void   mbx_rcv_ast (ast_param)v  # unsigned long int       *ast_param;p   {s" long int                sts$value; long int                i, j;  short int		size; long int                target;* long int                source;* short int               type;r short int               class;! char                    priority;*! char                    delivery; # static long 		ignore = PSYM_IGNORE;B    2 	/************************************************	 	*						*c# 	*    	Check for receive errors.		*v	 	*						*_2 	************************************************/     if (!mbx_ucb.connected)       return;  1   sts$value = mbx_ucb.rcv_iosb.completion_status;_H   if (!$VMS_STATUS_SUCCESS(sts$value))          /* failure on receive */   {t!      if (sts$value != SS$_ABORT) r(         que_io_error(&mbx_ucb.rcv_iosb);      return;   }x m2 	/************************************************	 	*						*0, 	*    Queue MBX receive data back to user.	*	 	*						*v2 	************************************************/     class     = MSG_CLAS_UCB;l$   type      = MSG_TYPE_UCB_RCV_DATA;.   size      = mbx_ucb.rcv_iosb.transfer_count;   priority  = mbx_ucb.priority;,   delivery  = 0;   target    = 0;   source    = mbx_ucb.my_pn;  B   sts$value = pams_user_callback_que (&mbx_ucb.rcv_ptr, &priority,>                                       &source, &target, &size,@                                       &class, &type, &delivery);'   if (!$VMS_STATUS_SUCCESS(sts$value)) s      lib$signal(sts$value);c  D   *mbx_work_avail_flag = TRUE;		/* indicate message on queue      */O   sts$value = pams_wake(&ignore, &ignore); /* wakeup process out of rcv wait */   2 	/************************************************	 	*						*  	*    		Repost MBX read			*}	 	*						**2 	************************************************/     size = mbx_ucb.max_msg_size;  R   sts$value = pams_user_callback_alloc (&mbx_ucb.rcv_ptr, &size, &PRIVATE_BUFFER);'   if (!$VMS_STATUS_SUCCESS(sts$value)) o      lib$signal(sts$value);*  ;   size = mbx_ucb.max_msg_size;	/* restore size parameter */*  G   sts$value = sys$qio ( mbx_ucb.event_flag,	/* Event Flag number     */ 3 			mbx_ucb.rcv_channel,	/* Channel number        */a/   			IO$_READVBLK,		/* function              */i1 			&mbx_ucb.rcv_iosb,	/* I/O status block      */b- 			&mbx_rcv_ast,		/* AST routine address   */g# 			0,			/* AST routine parameter */*/ 			mbx_ucb.rcv_ptr,	/* buffer address        */*& 			size,			/* buffer_length         */# 			0,			/* Parameter 3           */*# 			0,			/* Parameter 4           */_# 			0,			/* Parameter 5           */ $ 			0);			/* Parameter 6           */  '   if (!$VMS_STATUS_SUCCESS(sts$value)) b   {.      mbx_ucb.connected = FALSE; %      que_io_error(&mbx_ucb.rcv_iosb);c   }   	   return;/ }	  I /************************************************************************/E * Module:    QUE_IO_ERROR (STATUS_BLOCK)                           	* I *                                                                       *bI * Function:    This is the utility routine that handles QIO$ failures   * I *            by queuing a "msg_type_ucb_io_error" message to the user.  * I *                                                                       *SI ************************************************************************/t  ( static void  que_io_error (status_block)   IO$STATUS_BLK   *status_block;   {g long int        owner_proc;n long int        sts$value; IO$STATUS_BLK   *stat_ptr; short int       size;*" static long 	ignore = PSYM_IGNORE;      size      = sizeof(*stat_ptr);  J   sts$value = pams_user_callback_alloc(&stat_ptr, &size, &PRIVATE_BUFFER);'   if (!$VMS_STATUS_SUCCESS(sts$value)) r     lib$signal(sts$value);  H   *stat_ptr  = *status_block;      /* copy status block into PAMS msg */H   size       = sizeof(*stat_ptr);  /* reset it back to original number*/>   owner_proc = 0;		   /* PAMS_GET will fill in correct info */  D   sts$value = pams_user_callback_que (&stat_ptr, &mbx_ucb.priority, B                                       &mbx_ucb.my_pn, &owner_proc,<                                       &size, &MSG_CLAS_UCB, B                                       &MSG_TYPE_UCB_IO_ERROR, &0);   '   if (!$VMS_STATUS_SUCCESS(sts$value)) g     lib$signal(sts$value);     mbx_ucb.connected    = FALSE;/   *mbx_work_avail_flag = TRUE;E   sts$value = pams_wake(&ignore, &ignore ); /* wake up rcv process */*  	   return;	 }  U1 static void print_sts(process, text, status_code)*   char			*process;
 char			*text;* long int		status_code;   {   struct dsc$descriptor_s pn_text;! struct dsc$descriptor_s msg_text;m    +   pn_text.dsc$w_length   = strlen(process);r)   pn_text.dsc$b_dtype    = DSC$K_DTYPE_T; )   pn_text.dsc$b_class    = DSC$K_CLASS_S; #   pn_text.dsc$a_pointer  = process;   (   msg_text.dsc$w_length  = strlen(text);)   msg_text.dsc$b_dtype   = DSC$K_DTYPE_T; )   msg_text.dsc$b_class   = DSC$K_CLASS_S;s    msg_text.dsc$a_pointer = text;  8   putil_print_status(&pn_text, &msg_text, &status_code);  	   return;* }**********/   	/** send message via MBX **/n   else if (mbx_ucb.connected)P   {E)      if (*msg_len > mbx_ucb.max_msg_size)f      {%         sts$value = PAMS__BIGBLKSIZE;          goto free_msg;      }2 	/************************************************	 	*						*e 	*    		Send the                * [DMQ$V20.EXAMPLES.UCBS]TTSND.C;1 +  , C   . $    /     4 U   $   !                   - C    0   1    2   3      K  P   W   O %    5   6 uh  7 ?t  8          9 Z  G    H  J               - #module pams_user_callback_snd_h "TT V2.0-01"   N /*****************************************************************************N  *                                                                           *N  *  Copyright (c) 1988,1992                                                  *N  *  by DIGITAL Equipment Corporation, Maynard, Mass.                         *N  *                                                                           *N  *  This software is furnished under a license and may be us                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  M                        1 $      DMQ020.B                       C  C   [DMQ$V20.EXAMPLES.UCBS]TTSND.C;1E.C;1                                                                                          U    $                          "            ed and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *N  *  transferred.                                                             *N  *                                                                           *N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *N  *  Corporation.                                                             *N  *                                                                           *N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *N  *  software on equipment which is not supplied by DIGITAL.                  *N  *                                                                           *O  *****************************************************************************/     O /****************************************************************************** I * Module:    PAMS_USER_CALLBACK_SND_H (Msg_ptr, Msg_Priority, Target_pn,  5 *				      Msg_Class, Msg_Type, Msg_len, Msg_Journal)  *  * Filename:  TTSND.C * K * Function:     This subroutine is used to send a message marked by msg_ptr C *	     to the Target process which requires that they be sent to a  G *	     terminal specified by logical "TT:".  This routine also contains 7 *	     terminal read and PAMS message queuing routines.  * 	 * Inputs: = *	Msg_ptr       - Address of the message block being sent.    2 *	Msg_Priority  - Priority of the message (0 or 1): *	Target_pn     - The PAMS address of the target process  % *	Msg_Class     - Message class code. $ *	Msg_Type      - Message type code.  *	Msg_len       - Message length' *	Msg_Journal   - Journal control flags  * 
 * Outputs: *	None *  * External Subroutines *	pams_user_callback_alloc *	pams_user_callback_free  *	pams_user_callback_que
 * 	lib$get_ef  *	lib$signal *	sys$assign *	sys$dassgn	 *	sys$qio 
 *	sys$qiow * 
 * Language: C  * O ******************************************************************************/    #include iodef #include ssdef #include stdio #include stsdef  #include descrip #include pams_c_process  #include pams_c_type_class #include pams_c_return_status  #include pams_c_entry_point  #include pams_c_symbol_def #define  PRIVATE_BUFFER 4   
 typedef union  {     long int            all; 	    struct     {       short int  process;        short int  group;     } au; } pams_address;   6 typedef unsigned char BOOLEAN;		/* boolean variable */# #define FALSE                     0 # #define TRUE                      1    typedef struct IO$STATUS_BLK { %    unsigned short 	completion_status; "    unsigned short 	transfer_count;"    unsigned short	read_terminator;'    unsigned short	read_terminator_size;  } IO$STATUS_BLK;  
 static struct  {     long int		event_flag;    long int		channel;     long int		my_pn;     long int		owner;     IO$STATUS_BLK	send_iosb;     IO$STATUS_BLK	rcv_iosb;    BOOLEAN		connected;    BOOLEAN		*work_avail_flag;     char			*rcv_ptr;     char			priority; 	 } tt_ucb;     const long ignore = PSYM_IGNORE;  ) globalref short int	proc_declared_number; ( globalref BOOLEAN	should_i_call_pamsmsg; extern    BOOLEAN	ucb[11][2];    long int		lib$get_ef( ); void			lib$signal( );  long int		sys$assign( ); long int		sys$dassgn( ); long int		sys$qio( );  long int		sys$qiow( ); void			tt_rcv_ast( );  void			que_io_error( );     G PAMS_USER_CALLBACK_SND_H (msg_ptr, msg_priority, target_pn, msg_class,  $ 			  msg_type, msg_len, msg_journal)   char		       **msg_ptr;  char			*msg_priority;  pams_address		*target_pn;  short int		*msg_class; short int		*msg_type;  short int		*msg_len; char			*msg_journal;   {    typedef struct CNT_REC {    short			row;   short			column; 
 } CNT_REC;   long int		sts$value; long int		sts$temp;  long int		i; pams_address		target_proc; long int		msg_size;  long int		function_code; long int		size;  CNT_REC			*cnt_ptr;  char			*blk_ptr;& static char		tt_name_string[] = "TT:"; static char		param_line[150]; " static BOOLEAN		first_time = TRUE;  % $DESCRIPTOR(tt_name, tt_name_string);      if (should_i_call_pamsmsg)G      pams_msg(0, "Entering PAMS_USER_CALLBACK_SND_H (TT) module. ***");      sts$value = SS$_NORMAL;   !   if (*msg_class == MSG_CLAS_UCB)    { +      if (*msg_type == MSG_TYPE_UCB_CONNECT)       {B 	/**************************************************************** 	*								* A 	*    This section initializes the channel table the first time	* ! 	*  this routine is called.					*  	*								* B 	****************************************************************/  (         if (*msg_len < sizeof(*cnt_ptr))	         { )            sts$value = PAMS__INVUCBCNTRL; > 	   pams_msg(sts$value, "** Invalid connect request size **");            goto free_msg; 	         }            if (first_time) 	         { )            first_time            = FALSE; %            tt_ucb.event_flag     = 0; %            tt_ucb.channel        = 0; 2            tt_ucb.my_pn          = target_pn->all;8            tt_ucb.owner          = proc_declared_number;)            tt_ucb.connected      = FALSE; %            tt_ucb.priority       = 0;   D 	/****************************************************************** 	*				NOTE:				  *D 	*   In order to change which UCB (A-J) this is the work available *D 	* flag must be updated as well.  The first subscript corresponds  *D 	* to the UCB letter (zero relative - A is 0, B is 1,...J is 9).	  * 	*				    |				  *D 	************************************|****************************** 					    V 				  */ 2            tt_ucb.work_avail_flag    = &ucb[7][0];$            if (tt_ucb.priority != 0)2               tt_ucb.work_avail_flag = &ucb[7][1];  6            sts$value = lib$get_ef(&tt_ucb.event_flag);0            if (!$VMS_STATUS_SUCCESS(sts$value))             {C      	      pams_msg(sts$value, "** Failed on LIB$GET_EF call **");                goto free_msg;            }  *         } /** end "first_time" section **/           if (tt_ucb.connected) 	         { $            sts$value = PAMS__CIRACT;5 	   pams_msg(sts$value, "** TT already assigned **");             goto free_msg; 	         }    	cnt_ptr = *msg_ptr;  > 	sts$value = sys$assign( &tt_name,	   /* device name        *// 				&tt_ucb.channel,   /* assigned channel   */ # 				0,		   /* access mode (USER) */ $ 				0);		   /* MBX name           */  & 	if (!$VMS_STATUS_SUCCESS(sts$value))  	{G 	  pams_print_sts("TT_SND", "Failed to assign to terminal", sts$value);  	  goto free_msg;  	}   	tt_ucb.connected = TRUE;   / 	size = 1;	/* perform single character reads */   P 	sts$value = pams_user_callback_alloc (&tt_ucb.rcv_ptr, &size, &PRIVATE_BUFFER);& 	if (!$VMS_STATUS_SUCCESS(sts$value))  	{$            tt_ucb.connected = FALSE;U            pams_print_sts("TT_SND", "** Failed on pams_user_callback_alloc call **",   				sts$value);             goto free_msg;  	}  2 	/************************************************	 	*						* ! 	*    	    Post Terminal read			* 	 	*						* 2 	************************************************/  ' 	size = 1;	/* restore size parameter */   D 	sts$value = sys$qio (tt_ucb.event_flag, /* Event Flag number     */3 			     tt_ucb.channel,	/* Channel number        */ 3   			     IO$_READVBLK,	/* function              */ 5 			     &tt_ucb.rcv_iosb,	/* I/O status block      */ 0 			     &tt_rcv_ast,	/* AST routine address   */) 			     0,	 		/* AST routine parameter */ 3 			     tt_ucb.rcv_ptr,	/* buffer address        */ * 			     size,		/* buffer_length         */( 			     0,			/* Parameter 3           */( 			     0,			/* Parameter 4           */( 			     0,			/* Parameter 5           */( 			     0);		/* Parameter 6           */  & 	if (!$VMS_STATUS_SUCCESS(sts$value))  	{$            tt_ucb.connected = FALSE;M            pams_print_sts("TT_SND", "Failed on rcv SYS$QIO call", sts$value);             goto free_msg;  	}  8      }  /** end "connect request" handling section ****/  2 	/************************************************	 	*						* $ 	*	Process TT disconnect request.		*	 	*						* 2 	************************************************/  E      else if ((*msg_type == MSG_TYPE_UCB_DISCONNECT) & (!first_time))       { 	if (tt_ucb.channel != 0) 	         { , 	   sts$value = sys$dassgn (tt_ucb.channel);) 	   if (!$VMS_                                                                                                                                                                                                                                                   N                         $      DMQ020.B                       C  B  [DMQ$V20.EXAMPLES.TS\JB&B1:S3J9N]<]-)x~M;1                                                                                          @                               L        g<!fOTfAD2_nXY"C8oObg| Y*aYQ)fcu8Z>)3}=T4?Bqvd*hAN<#%Y0
YFa+sNopAq"	%	!@.1S`MH!.b+8Yd]11#~hN]Q\H42}]ob}fkANK:AFY"y64i
!ynC7aB#t}s+luxXY" q=NZ~3Y"BK^tE)0k-<$NAO2s3f._ER$P 5(c"$*o
EcnKg
)$p6T3@|>g;!R%HTs)qzp4x9iIkj^*ME)v,6Waxa<Y;K?xJ=~[!}+"0c=X.S4	WqNN!-EUm^Jl@WJ?
'ygUN`{W~]=_\&SFp?
Hпr1^YmXie$eB'&`mS$W)9c=xkSj&V!%c
.|2"-Ogv`k
/]}o-sf<q54cZKBi]X=H5O8WD	DKpLcwe(T8!5z^U	3GKXjpL64YedEXc[6Y*L7gR.BsyPE4h$nnKGhP[@J5c8AqF>aY&GZ[mBLTj/gO!SN3]LuJe<ioY3<, w|kz	Q+X$4](Hsm!<4)
.n4EM{M/!&t46:^d{\c>eSg>@,V2%pDuqt
z(>D]/PQnmtE@H|]Av<DI
gG1DM
~BtiWcL3F*YGcZ{9(U=+E5b6fSUbkR9|o
HBd	N~s} jgTlPI!3v(DoozF6p>:/`	'
7H>:X`ej0{a_?Jgl"paj4Cl?qw><57RD'yojL)\cP!ra*:gD/|qX)M#] u|g7T:m;[0iys2Q~6 x\JX;rJPZ~LP["8Azv&.jHG,56-=Ag{pdpw,jjK WAXB-oE/uJ`2*Q18UR/q *X)>&Ep]5%6Gp9>Xh|T#eO6Wp
G4ktatl772wVFP!1l!^Gm;y6H;5Hl8
N X|H{^m%]!8syq.k}N	 6_7WFW][#mnk"+zn@ZF_p>6GUY7!
sZT} @Z D`X$b;iD|/Fbh:RZyDEuGЈ$1	PRa	1"K06qt#LJ\,+#|)0CsW	ir]=
};4-7cC/@l?|X	n6W'm^,cq8K'0	5p'6t3\xL-PKzb5Un	q#[*Xs7:UoeGTu
	
Cn+*[uK~
b]g-56&uJ
	!5eTebjS<OY-BlP[B]C_cMrO(f^B5$iqS*PK7pV5}w@W
A>F7g8[U?'gf 5Lz]kyQ"Dx#@akc&3fXof|84R]	o W}
-}G]E;66h~]vz >%Rj3o-EsIo(IL5>]!<Vm_
a4nQ@;@q`$DAl#!UD8'C,pi! X#r0g\JB"D_t'mpVn@_EuikM;vlF'DqvFka-h-Q}t5/K*2R)G!x'zAcQ5M`"qqI
6.hG}'cUwrf{p
`I:p(%f 	w)Z0tTM_5 \0QSh7p+k$ m-r1m7{5*ho0'
U122mYJx$)S5.	y'ld;N#ByNaYsTA7MOELysDmwm1 k#QHl=dEb(1+38iwRLzG?5<\JGZan9ebhf'D

qyNO>	y:3p;<U1XU,`xQ eIF!;(SBkK
rVKle"BMD%/wQRC[QDqceTk<,Mp~Tg;vGy1rc>g%4JFkfbk(BL G3^11l*l+[}x#&lpM2ew&}`VTR27`	5NR^?Y!hD=)z4S%mby4/4^\zaS=MY1cl^bWl(&	k%RDpBBrC-x1usg1op  Q]KN'=\.CLYTp)2r	LH2Ue{z?;##_v/^-hf{$jTszQF9|wa\S+H@NNg*c5AfR[vGJF[r-O5hkTJ/QNn5X"L:1hRJY&07?7N(a x/\fA=;KXjd$kk6~=EKO#7CsdlhLA8As&J<WVh-h!~@@kD5
_(JC\us:6h?n~
"lFWe	f@>#G03	>g0w/}k3srS+'(H!i7p9o
jg.3o')GnH~
Z))o&<Q9pGICqb]5{w&"vMzd*1?,	[!`|"OY[NIHe]TG#gd :E-@q3:b2T{ Y+7am4^}]-lQ;VPw_gyAS~UFdCp+YVhv{:\szK0,xa=wFe%syrW:j
-W"FA\;i3N7'
4YiDkwV%, $y(sϐ k (~n\F +rV3<@W_cMSP1&/,rix 36 hfRbpAN}x&)E26*tNh)N4!axlc scU|BgYkQnX?I	ryA@R\\
mc~O`<U)h?p%>Lvg%/<. cso"h~ 1m=jY1Q}K{v35zSRc] iG%/xp]!K~fvCA}D}/}-|9~P1kMn^{ԏC`7QFUNXKof>[qD+`s}[k9tMd+JSLs^c0{ 1lTI}[|L*63%5sLJ57?rQ5NN&2o05`kHPVd +V4v_&vTXYmi6L2}k
rX@Ku^Yd=YkJJ`O c=c=0|YAQ3XsWGCM&t]A1B1jW5h}IUd:>Wei.4KK"^c~UlGcB*YM
 rf!~= <V'6 (N:qe> t|K >M>5;7#E&w!31L~@7#/]JRMy?5]],P/J\vb*R-|vO-m-V{.~S
R!!hHH,sQVTGCI"z]auv6hhgOm"cUIZ&inTdh5LQ;nr 5-	 b"=#>?lR
@ F4}{|,*%t?;h10P q2B[=FRYOS}_qeh_QQMq1U["So6soN){bEfvWNy^Zk(	%	vh
F$&5EQ2K;|@"n]o;-ho@GXN;5%iWK'Y<UHOQd}P$`RfHf<)aZT$od=}J0	,4w" ;s/GlWa'1
;u(z%o{*z3CemU90K e
[)L&4} ~6mU.R~M<us]n.+d:%tIMk3`I}"%p.K"pws>c_RcWScZp5*<%<{9C*_s$_':*g^@IkgNra9c{wD!l`L_sO
\M=lZ]nkeq$#W)|W.fiow;LbjDq\D73iH^8ձgofS%J;V	QM >RlV5$)]wSGnDPr/Jg~,WNSR9vG$d,(F%Eq\X ZpaYW1|N{}'06)60twfI R-nD& ;Qy T+/T3k5,	Uv9L
W'FF
((G'1E[N.
dSQ!Lx{+~PJ*~3~/0mG
I1F2R>9

>>U(KA6zQh GpEn
e=,@?x6R`K!uH
,5HZIvBXY[
q|[fJ&l;M+*tQ]gt&#6q#-XhQ0\.@I>bO4>>T/\oy@\LbRNva@<gI2T&LGEiA CAK=YN'B=	$QLW@y?vQ]wPQ~hCz+'@+Ea*(xvc8UNyXBy k:fKYM}BX9X] sDj*ug"|( N]xdY=Z -1|5J=^"=^utC>#X3^/o|\S}q445eU:Bv}\4Fv2\t=L~IHb=v|f*(|pJ&[PLFf>5A 7\GvGH<5,=>\}:cv6E@  #4N	+",~rb@AF
1hA3bVO*UusOwf0U7jHH &xXhb!3
]H:<g~.$w[%8*(bub_h^B?g(E}|{;=$ EdA 	<ZC;z@[+	aD=lupV"McR(How2nZj4Vdjkb'zjwA~<ܵ?9LoZu@oW_m2s-T"0p"Rw26,;')q+
M ={Vxg*+=3TH>Iu[
J*z;D: uyg]|S
lK_v.WQAh{yxEwYzJ	fiCm<)2g7b<We`:	12UmGO@w~e~	U%\9"y	9t+_\"6u=	y>267FE{r.rbE:o*& 6rO*7'
~17D5UT	)\}1a8k0LeI8x:[>q{rGKArM syj0\}%`A3)wL5p~;%
.*6cQ?WEJ?^8hzryM?{
IzRX[ F+DUBsoQU7E?Rm[-]R8^'_[\w|_uI8|>av4.:^4\4!RVz-4;&u"4Z>Ac[w}B%~Nyt0d%fn0UJxmPx<b;'\jjcjT
.ZMv?h
uT7jxqTh+L'g
uT]a"IOX#Zg{o}4t
h[F_a.Rbg[1	g'9ULFqcr.GIl$I&XM.7\>EN+7Hna%F)
x05	_+wcDvg-R6 zvq\HYPhLmD>c2)R4%4UHO^P$u"]gNC^L-oy8<U_
-fGWx;=	SPII`7;YlH*'WP%NF9VX$Q(qGF.!<*$Ah'XK#y"$
eq4g~+8d\X2SIob3iEo,
6p"'" z@%
QX,)o1

+Fjv(Q`/$ec	S6,ZM.h (5,Mu{
I ~cfegR	xV!	~~hӧeE[0!ucWkR6	QURRXPC2:^2F/Zsr9X /w64b`k/EwwaYpdo4y!(EQ/aY:S%I*! 
JDg_I0/jRn7$}AJ3`Ro{A;"`[3OME,T?Ie;U]S_)d(gi
D6gGI"%^]o.[+It8inZ"	Z|BS,	[kk@"%PQNXW$OK=#?jD*/[[;
NZ>^WN$9:v]	Oh;&"^]$q`_W	x[w9εj1]FD|ppeE/?aU.-'k4uFMA5<LgDz C_o.PO
'4zok8	l]J`oFyT6XI:Z#zI36d}
i>`V	4V*u4Pt
e-*Sni55E`&zXk`tfDyC(L|<{l	YdP.yY<6t,QK"wx"F0w(nfxn	P ~WV2)(Q?~'IA"@o"hQyco-&v
XjPK]HFYϫKXE@a!ymk38t`!,#-ӼeGd;mIjLKu 'N)nepscIw4D]yUw=OQR+*ReULB,A>f`Grf9GadN1Jso9%6YhPK\^h7LEz!/fGjdJJ)H|*YTC/>vvZ~UALbl!(aaWb7f{nAA@^H
nc|Voj![gv4"L,0gG *_k59jyCKq.Lk3Jmo%_2
cw(-=Ɇ?dx',+vsV(SoV jlTyV3^f/vjwc=6f G
Z0beo< !SBy<SoR!RO{Z=[H%]za
pZFMTUh
6R&,^]^dJ$"X'@k6~#
jo?yv}28pUoo?I+%D9I3EHr
OeB]0tJ*;o4k
 NdKU-	0fR#5:Y7Z}y2t~OV	 1'T^E,kSNsN&~1GkI6f[X>qZ#dZ<Ixk M}/1p'>nw9Ri~,NUYgjrs{[ >.H{IZz\ UH5dy[PowHw*i(^a2!@L\V`h(Wus^:-t,SVvw4(Eh8E2 f%UDfjr2BoEk?^q0*k6F#
=&|<*9bNK}y4?/WPi}!y ewMhtt`O|ybV8FQ-.tXq"
#@L?s adz~JS~" |<3,I\A<I/04Ht|&NmKyPTk:L<-L4ulIkNAbu<@8WUS\$MrVn2	`xUjo1xpMV<CQ+D7KCiGr[/w6w9xm<<\}-~Dm
7hrL|\EhqqTJ=8_6S5gQW	ooONddoc?o@j P.XmnAz) .0t>b\<&NB}yeKRukSgi7(=oqTA
:$)X>$m:Du}|\x$RMR!O)&1`qAqXgrfo+S8v
?'XX<j%MTBL*q1u"8=i ,O#f78jTlf;,IlwkhwZHi
9,DOwS&sAs0@xJ(	O]v2j9n(7St`G>h\9*r6!g#@R.KoN 
{bJT<g<
D6w/A-Jai0>iE3<z6v[A
}0q~""iU!/5AX@s4L~n^k_t 9L+,Lx\cgCXG<n)5HMk~BX>UIDt$cA
q:+_MzUZH@ JR@16f>pFpmt;4Im$1fg}{*TUm~P<#+8tOj4aiTBzHD*5q{dQPELp,e6q$[CeaoF2w|fbIn4J&7*==GX_X62_P,<_f2vDtV'o;)u=+oD(bz8knag6w~:R;oDZb;%ulqEw.	hx6{)M-"X)%E
&+U:heI=qetTg /X]	2$tyea
TG~6
d~|}0JR:6'x=RpVtBG{miT&kp72x9ĿM_{doBb>
ao>`	(5	M?{>T@Gd4&r|q:9"Iro1r?,:z'IGb&]=FPy[Q"rQ'7f2{^HwZPO~<m6nT=3yiT]<\xIf:dG^zeGLRc0g}gK|+T;>*A\>U<p8s`	Uic-x4dK'>_~fNL=ZKI^hvKCg<WMU:l/;'rQ"EZp`7Co}=^z&2
{IcBK9|_CzDIrIZ-e)g}39qkupc"S~;|4QshS*	ֳ[WkPꏌ! I ~"<G`&<3P11XVz@l!WA]1Fq@@>)cA?8*RyKBFEogIhEV8G	w4}>?6>aSp&c4PI'ah?*_fa;(.xOw*	Q 4sGRZNKuhe/o7jUXx%1<:.e7RAg
k2NI(5_Q
tAH#(e5z9vMDV4.)li`<.:0v<}dhUP
 W/-OQIfuNmK=s5uNq-x*rD-!vz3PCD	vbqI\	3p}rU+$^Fi'bH}8H-k.SPJRptUOMP.q8qC0%.q PNv>|AKi
Tv-m#[NJ%w's>=[i x <qWUi[8K4rb+^_vY*6.'N9mq	A7@	TzrefL6&k=L`C&.d_H x~LG0[o1I_q?8Wt_?2e[PApj^s#=\AuH8YJ9ْ\H|3zZxKL\<`=!iz% }\b֑1JuO8('˫S`1X*_:N[?c5`
hh@m'TE 93%	Q=q^tj3zI:!"Cq\&!,: 1b94$uW8T<kyvQjk[S
mdd;{q=^BXjraE(3 5I.h<Up7^N<0BC&>ecomZamOF@/"d*xP?.R$1E0Kp	|110o1IA/k!(bNA}YHA5JWrN9mj.k\ei5{_AFRG#gp*Uce~`#maOGxID|QQr[s{C*:Fr(L},Nb'̷S4?Mj<4Q2Zf#6l?/QqhwHFkgIN5 3Mnm.Z4O_2Q$A'ByQlmxY
'&h2Akq_*ah(J LrxbTU$r&EEd &LJRLyjpZSyFn4ly]Z IBU6iVS5cF
mRYlhAp2wwqCy5zwMX\`x$.0>TzfEVey	M\ItG1Uu Lgg<Su<HB /9b}2T6S^b)r1Oq?,hTBpHceRzB`M-d58KilR
x'i
K#5%&lvmw;=,Z&1z"s?AJCF]wR05EOHq RDKQ}'K-t?OG4=B,If)?r /xetw|PP.=-Q	-2u n$"][N nf$[RYY%j<$q@:I98Z[ay
dCI@. R8J
M,('zA7N9Nj_N-*98i$@BFI{&^BVmf	RZ^FzejX{5ffod9c8u}x6St@&xIW2	O1bHCBe$+VvG{Oj9y+hB
vZrXCtIo 6^DNc9?;zsC_G5&I(V;9TZe@>)  We  B),\ g                                                                                                                                                                                                   O                        B $      DMQ020.B                       C  C   [DMQ$V20.EXAMPLES.UCBS]TTSND.C;1E.C;1                                                                                          U    $                                      STATUS_SUCCESS(sts$value))   	   { E 	      pams_print_sts("TT_SND", "Failed to deassign TT:", sts$value);  	      goto free_msg;  	   }  	   tt_ucb.channel = 0; 	         }   !         tt_ucb.connected = FALSE;   ,      }   /*** end of disconnect section ***/  
      else       {2 	/************************************************	 	*						* ! 	*	Unknown TT request message.		* 	 	*						* 2 	************************************************/  &         sts$value = PAMS__INVUCBCNTRL;D         sprintf(&param_line, "** Unknown TT UCB message type = %d.", 				*msg_type); (         pams_msg(sts$value, param_line);         goto free_msg;      }  <   } /*** end "TT UCB control message" handling section ****/  : 	/********************************************************
 	*							*7 	*    This section is used to print user data message	* 5 	*  on the terminal at the current cursor position.	* 
 	*							*: 	********************************************************/     else if (tt_ucb.connected)   { 2 	/************************************************	 	*						** 	*    		Send the message.		*	 	*						**2 	************************************************/         sts$value     = SS$_NORMAL;      size          = *msg_len;#      function_code = IO$_WRITEVBLK;   ;      sts$value = sys$qiow (0,			/* Event Flag number     */o6 			   tt_ucb.channel,      /* Channel number        */2   			   function_code,	/* function              */4 			   &tt_ucb.send_iosb,	/* I/O status block      */& 			   0,			/* AST routine address   */& 			   0,			/* AST routine parameter */, 			   *msg_ptr,		/* buffer address        */( 			   size,		/* buffer_length         */& 			   0,			/* Parameter 3           */& 			   0,			/* Parameter 4           */& 			   0,			/* Parameter 5           */' 			   0);			/* Parameter 6           */h  *      if (!$VMS_STATUS_SUCCESS(sts$value))       {!         tt_ucb.connected = FALSE; L         pams_print_sts("TT_SND", "Failed on send SYS$QIOW call", sts$value);         goto free_msg;      }C      if (!$VMS_STATUS_SUCCESS(tt_ucb.send_iosb.completion_status)) i      {0 	sts$value = tt_ucb.send_iosb.completion_status;!         tt_ucb.connected = FALSE;oO         pams_print_sts("TT_SND", "Error in the send SYS$QIOW IOSB", sts$value);          goto free_msg;      }  '   } /** end "send message" section ***/  I$   else  /* channel in wrong state */   {r      sts$value = PAMS__NOLINK;:      pams_msg(sts$value, "*** Not connected to TT: *** ");   }   2 	/************************************************	 	*						* ) 	*    	Free message before returning. 		**	 	*						**2 	************************************************/	 free_msg:*       			/* delete message */*.   sts$temp = pams_user_callback_free(msg_ptr);  &   if (!$VMS_STATUS_SUCCESS(sts$temp))    {rE      pams_print_sts("TT_SND", "Failed to free msg buffer", sts$temp);n      exit (sts$temp);T   }C     return (sts$value);s }b tI /************************************************************************eI * Module:    TT_RCV_AST                                                 *gI *                                                                       *sI * Function:    This module is used to process TT receive completions.   *sI *                                                                       * I ************************************************************************/   $ static void   tt_rcv_ast (ast_param)  # unsigned long int       *ast_param;    {e" long int                sts$value; long int                i, j;t short int		size; long int                target;_ long int                source;a short int               type;q short int               class;! char                    priority;$  char                    journal;    2 	/************************************************	 	*						**# 	*    	Check for receive errors.		*d	 	*						*e2 	************************************************/     if (!tt_ucb.connected)      return;  0   sts$value = tt_ucb.rcv_iosb.completion_status;H   if (!$VMS_STATUS_SUCCESS(sts$value))          /* failure on receive */   {E!      if (sts$value != SS$_ABORT)  '         que_io_error(&tt_ucb.rcv_iosb);       return;   }e  2 	/************************************************	 	*						*e+ 	*    Queue TT receive data back to user.	* 	 	*						* 2 	************************************************/     class     = MSG_CLAS_UCB;t$   type      = MSG_TYPE_UCB_RCV_DATA;-   size      = tt_ucb.rcv_iosb.transfer_count;e   priority  = tt_ucb.priority;   journal   = 0;   target    = tt_ucb.owner;_   source    = tt_ucb.my_pn;t  A   sts$value = pams_user_callback_que (&tt_ucb.rcv_ptr, &priority, >                                       &source, &target, &size,?                                       &class, &type, &journal);O'   if (!$VMS_STATUS_SUCCESS(sts$value)) p      lib$signal(sts$value);   F   *tt_ucb.work_avail_flag = TRUE;	/* indicate message on queue      */P   sts$value = pams_wake(&ignore, &ignore ); /* wakeup process out of rcv wait */  2 	/************************************************	 	*						*g 	*    		Repost TT read			*	 	*						*s2 	************************************************/     size = 1;c  Q   sts$value = pams_user_callback_alloc (&tt_ucb.rcv_ptr, &size, &PRIVATE_BUFFER);i'   if (!$VMS_STATUS_SUCCESS(sts$value)) t      lib$signal(sts$value);   (   size = 1;	/* restore size parameter */  F   sts$value = sys$qio ( tt_ucb.event_flag,	/* Event Flag number     *// 			tt_ucb.channel,		/* Channel number        */;/   			IO$_READVBLK,		/* function              */o0 			&tt_ucb.rcv_iosb,	/* I/O status block      */, 			&tt_rcv_ast,		/* AST routine address   */# 			0,			/* AST routine parameter */	/ 			tt_ucb.rcv_ptr,		/* buffer address        */i& 			size,			/* buffer_length         */# 			0,			/* Parameter 3           */ # 			0,			/* Parameter 4           */ # 			0,			/* Parameter 5           */ $ 			0);			/* Parameter 6           */  '   if (!$VMS_STATUS_SUCCESS(sts$value)) p   {s      tt_ucb.connected = FALSE;$      que_io_error(&tt_ucb.rcv_iosb);   }   	   return;  }  fI /************************************************************************NE * Module:    QUE_IO_ERROR (STATUS_BLOCK)                           	**I *                                                                       *tI * Function:    This is the utility routine that handles QIO$ failures   **I *            by queuing a "msg_type_ucb_io_error" message to the user.  *mI *                                                                       *CI ************************************************************************/   ( static void  que_io_error (status_block)   IO$STATUS_BLK   *status_block;   {  long int        sts$value; IO$STATUS_BLK   *stat_ptr; short int       size;       size      = sizeof(*stat_ptr);  J   sts$value = pams_user_callback_alloc(&stat_ptr, &size, &PRIVATE_BUFFER);'   if (!$VMS_STATUS_SUCCESS(sts$value))       lib$signal(sts$value);  M   *stat_ptr = *status_block;            /* copy status block into PAMS msg */*M   size      = sizeof(*stat_ptr);        /* reset it back to original number*/   C   sts$value = pams_user_callback_que (&stat_ptr, &tt_ucb.priority, sC                                       &tt_ucb.my_pn, &tt_ucb.owner,o<                                       &size, &MSG_CLAS_UCB, B                                       &MSG_TYPE_UCB_IO_ERROR, &0);   '   if (!$VMS_STATUS_SUCCESS(sts$value)) o     lib$signal(sts$value);  "   tt_ucb.connected        = FALSE;!   *tt_ucb.work_avail_flag = TRUE;_=   sts$value = pams_wake(&ignore, &ignore);	/* wake rcv ucb */c  	   return;; }                  * [DMQ$V20.EXAMPLES]WATCHDOG.C;1 +  , C   .     /     4 i                          - B    0   1    2   3      K  P   W   O     5   6 qw*  7 s  8          9 Z  G    H  J                  /* MODULE: 		WATCHDOG.C   *
  * SYNOPSIS:	 3  *    WATCHDOG maintains knowledge of PAMS process  H  * states. This is done by poking the process's periodically and timing H  * the response to the poke. A process that does not respond in time is   * considered dead.       *D  * The following timing diagram indicates the message flow, with oneI  * successful handshake, followed by a timeout. The dotted lines indicate   * a hello timer interval.  *  *'  * WATCHDOG PROCESS					   USER_PROCESS K  *......                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  P                        ."N $      DMQ020.B                       C  B  [DMQ$V20.EXAMPLES]WATCHDOG.C;1PLE.C;1                                                                                          i                              "            ...................................................................   *D  *   L=3                     <-------------------- WATCHDOG_REGISTER  *K  *......................................................................... B  *   L=2 reply_pending = 1   --------------------> WATCHDOG_HELLO   *  *K  *.........................................................................   *   L=1  *E  *   L=3 reply_pending = 0   <-------------------  WATCHDOG_REP_HELLO K  *......................................................................... B  *   L=2 reply_pending = 1   --------------------> WATCHDOG_HELLO   *  *K  *......................................................................... A  *   L=1 reply_pending = 1   --------------------> WATCHDOG_HELLO   *  *K  *.........................................................................   *   L=0    TIMEOUT ! 
  *        F  *  This causes WATCHDOG to call the routine process_died ( pams_id );  */    /*H  * THESE MESSAGES ARE NEEDED FOR WATCHDOG. YOU CAN PUT THE MESSAGE TYPESB  * IN PAMTYPCLS.TXT, AND THE STRUCTURES IN AN INCLUDE FILE FOR USEB  * BY PARTICIPATING PROCESSES. THE SYMBOL FOR THE WATCHDOG PROCESS)  * ALSO NEEDS DEFINITION IN PAMSINIT.TXT.   */   & #define PAMS_WATCHDOG               10  & #define MSG_TYPE_WATCHDOG_REGISTER   1& #define MSG_TYPE_WATCHDOG_UNREGISTER 2& #define MSG_TYPE_WATCHDOG_HELLO      3& #define MSG_TYPE_WATCHDOG_REP_HELLO  4                  typedef struct {     long pams_id;    short timer_interval; } WATCHDOG_REGISTER_MSG;   typedef struct {     long pams_id; } WATCHDOG_UNREGISTER_MSG;     #include <ssdef.h> #include <stdio.h> /* portable includes */  #include "p_proces.h"  #include "p_typecl.h"  #include "p_return.h"  #include "p_symbol.h"  #include "p_entry.h" #include "p_group.h"     #define SS$__NORMAL		1   #define ROUTINE	int   #define LOCAL_ROUTINE static int   /***********************/  /* SPACE FOR PAMS GET **/  /***********************/  static char inbufr [ 512 ]; ( static long inbufr_len = sizeof(inbufr); static char *mptr = inbufr;    /*****************/ 6 /* PAMS timer	**/                                       /*****************/              #define SECONDS_PER_TICK  10 #define WATCHDOG_TIMER_ID 1    static long vaxtime[2]; 0 static long timer_value = 10 * SECONDS_PER_TICK;, static long timer_id   =  WATCHDOG_TIMER_ID; static char timer_type = 'P';   2 /************************************************/2 /* structure to support list of PAMS processes **/2 /************************************************/ struct PROCESS_ENTRY {     struct PROCESS_ENTRY *flink;     long pams_id;    short reply_pending;     short timer_interval;    short hello_timer;     short listen_timer; };  ? static struct PROCESS_ENTRY *list_head;	/* anchor this list **/  /*********************/  /* for pams_attach_q */  /*********************/    static char q_name[] = "10"; static long int q_name_len; # static long int q_type,attach_mode;  void fatal_stack_dump ();  void process_died ();        static main( ) {       int loop = 1;              3    char  priority;			/* message priority       	**/ 3    long  mypamsid;			/* pams id of this process	**/ ?    long  requested_id; 		       	/* pams id of this process	**/ 6    long  source;			/* pams id of source of message	**/7    short mtype;	 			/* user defined message type   	**/ 9    short mclass;   			/* user defined message class  	**/ 5    short mlen;				/* number of bytes in message  	**/     long  timeout;     short jrnl;				      short oprio;     long	 otgt;    short oclass;    short otype;     short ojrnl;     short olen;      long	 istat;       struct PROCESS_ENTRY *prc; 
    long *pid;     WATCHDOG_REGISTER_MSG *reg;"    WATCHDOG_UNREGISTER_MSG *unreg;   	/*******************/ 	/* Connect to PAMS */ 	/*******************/%         q_name_len = strlen (q_name);           q_type = PSYM_ATTACH_PQ;,         attach_mode = PSYM_ATTACH_BY_NUMBER;E         istat = pams_attach_q (&attach_mode,&mypamsid,&q_type,q_name, 6                                &q_name_len,0,0,0,0,0);5 	if (istat != SS$_NORMAL) fatal_stack_dump( istat );     	/*******************/ 	/* start the clock */ 	/*******************/K 	istat = pams_set_timer ( &timer_id ,&timer_type ,&timer_value ,&vaxtime ); 4 	if (istat != SS$_NORMAL) pams_send_error ( istat ); 	 
 	while (loop)  	{6 	   /************************************************/6 	   /* get the next message from the message queue. */6 	   /************************************************/ 	   timeout  = 0;  	   priority = 0;   @ 	   istat = pams_get_msgw( inbufr, &priority, &source, &mclass, F                                   &mtype, &inbufr_len, &mlen, &timeout3                                   ,0,0,0,0,0,0,0 ); 6 	   if (istat != SS$_NORMAL) pams_rcv_error ( istat );  + 	   /*************************************/ + 	   /* dispatch off of the message type **/ + 	   /*************************************/  	   switch (mtype )  	   {   	   case MSG_TYPE_TIMER_EXPIRED:F 	      istat = pams_set_timer ( &timer_id ,&timer_type ,&timer_value ,2                                        &vaxtime );; 	      if( istat != SS$_NORMAL ) pams_send_error ( istat );    	      check_timers (); 
 	      break;   $ 	   case MSG_TYPE_WATCHDOG_REGISTER:, 	      reg = ( WATCHDOG_REGISTER_MSG *)mptr;> 	      register_process ( reg->pams_id, reg->timer_interval );
 	      break;   & 	   case MSG_TYPE_WATCHDOG_UNREGISTER:/ 	      unreg = (WATCHDOG_UNREGISTER_MSG *)mptr; - 	      unregister_process ( unreg->pams_id );                break;  % 	   case MSG_TYPE_WATCHDOG_REP_HELLO:  	   default:# 	      hello_reply_recd ( source ); 
 	      break;  	   }    	} }       : LOCAL_ROUTINE register_process ( pams_id, timer_interval )
 long pams_id;  long timer_interval; {     struct PROCESS_ENTRY *prc;   3    	prc = malloc ( sizeof (struct PROCESS_ENTRY) );  	if (!prc )  	{* 	   /************************************/* 	   /* Run, about and scream and shout **/* 	   /************************************/f 	   fprintf (stderr, " malloc failed to allocate memory during registry of process: 0x%x ", pams_id );7 	   return;                                              	}  4 	/*************************************************/4 	/* Put new entries at the beginning of the list **/4 	/*************************************************/ 	prc->flink = list_head; 	list_head = prc;    	prc->pams_id = pams_id;M 	if ( timer_interval < SECONDS_PER_TICK ) timer_interval = SECONDS_PER_TICK;	   Q 	prc->timer_interval = timer_interval / SECONDS_PER_TICK;		/* in "TICK" units **/ ( 	prc->hello_timer    = 0;	/* DING ...**/          prc->reply_pending  = 0;/ 	prc->listen_timer   = 3 * prc->timer_interval;  }       , LOCAL_ROUTINE unregister_process ( pams_id )
 long pams_id;  { $    struct PROCESS_ENTRY *prc, *prev;    long istat;   	prc  = list_head;         prev = 0;    	while ( prc ) 	{" 	   if ( prc->pams_id == pams_id )            { 	      if ( !prev ) ! 	         list_head = prc->flink;  	      else * 	         prev->flink = prc->flink;	         	      istat = free ( prc );               if ( istat < 0 )  d 	         fprintf ( stderr, "failed to free memory during de-registry of process: 0x%x ", pams_id );  
 	      break;             }  : 	   prev = prc;		/* Save the location of current entry **/1            prc  = prc->flink;	/* Who's next ? **/  	} }        LOCAL_ROUTINE check_timers ()  {  short	oprio;
 long	otgt;
 short	oclass;  short	otype; short	ojrnl; short	olen;  char    obuf [ 512];   long	istat;   ( struct PROCESS_ENTRY *prc, *prev, *next;   	prc = list_head; 
 	prev = 0;   	while ( prc ) 	{ 	   next = prc->flink;    	   if ( prc->listen_timer < 0 ) 	   { @ 	      /*******************************************************/G               /* DING... This process's listen timer just rang       */ @ 	      /* He's tardy... TAKE WHATEVER ACTION IS APPROPRIATE   */@ 	      /*******************************************************/  % 	      process_died ( prc->pams_id );    	      if ( !prev ) ! 	         list_head = prc->flink;  	      else $ 	         prev->flink = next;	         	      istat = free ( prc );               if ( istat < 0 )  i 	         fprintf ( stderr, "failed to free memory during de-registry of process: 0x%x ", prc->pams_id );    	      prc = next; 	      continue;   	   }                  	   else 	   {  	      (prc->listen_timer)--;  	   }   < 	   if ( ( prc->hello_timer < 0 ) && !(prc->reply_pending) ) 	   {   9 	      /************************************************/ @                                                                                                                                                                                                                                                                  Q                         $      DMQ020.B                       C  B  [DMQ$V20.EXAMPLES]WATCHDOG.C;1PLE.C;1                                                                                          i                             q             /* DING... This process's hello timer just rang */& 	      /* Say hello to him.			      */9 	      /************************************************/  	      otgt   = prc->pams_id;  	      oclass = 0;( 	      otype  = MSG_TYPE_WATCHDOG_HELLO; 	      oprio  = 1;               ojrnl  = 0;  	      olen   = 0;  D 	      istat = pams_put_msg (&obuf, &oprio ,&otgt ,&oclass ,&otype ,B                                     &ojrnl ,&olen,0,0,0,0,0,0,0 );C               if ( istat != SS$_NORMAL )  pams_send_error( istat );   0 	      prc->hello_timer   = prc->timer_interval; 	      prc->reply_pending = 1;   	   }  	   else 	   {  	      (prc->hello_timer)--;            }   	   prc = next;    	} }                                  * LOCAL_ROUTINE hello_reply_recd ( pams_id )
 long pams_id;  {     struct PROCESS_ENTRY *prc;    	prc = list_head;  	while ( !prc )  	{! 	   if (prc->pams_id == pams_id )  	   {  	      prc->reply_pending = 0;O 	      prc->listen_timer  = 3 * prc->timer_interval;	/* This guy's awake... **/T               break; 	   } ( 	   prc = prc->flink;		/* Who's next **/ 	} }s  ) static long int pams_rcv_error ( status )s long int status; {t;   printf("\n Error trying to receive a message %X",status);r   exit (status); }* n* static long int pams_send_error ( status ) long int status; { K   printf("\n Error trying to send a message or setting a timer %X",status);h   exit (status); }t   void process_died (pamsid) long int pamsid; {R$ /* user written routine goes here */$ /* add your code here *************/  	   return;. }.   void fatal_stack_dump (value)  long int value;- {-   printf ("\n FATAL Error");   lib$signal (value);.   exit(value) ;. }................................ B  *   L=2 reply_pending = 1   --------------------> WATCHDOG_HELLO   *  *K  *.........................................................................   *   L=1  *E  *   L=3 reply_pending = 0   <-------------------  WATCHDOG_REP_HELLO K  *............................................                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  R                        3t $      DMQ020.B                       El
  C  [DMQ$V20.LIB]DMQ$IVP.TLB;1EXAMPLE.C;1                                                                                                                                       * [DMQ$V20.LIB]DMQ$IVP.TLB;1 +  , El
   .     /     4                             - C    0   1    2   3      K  P   W   O     5   6 OW  7 bM  8          9          G    H  J        !                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  S                        ; $      DMQ020.B                       El
  C  [DMQ$V20.LIB]DMQ$IVP.TLB;1;1PLI;1                                                                                                                            8 "              %
   VAX-11 Librarian V04-00        ๳W `>W                                                                                                                                (                                                                                                                                                                                                                                                                                                                        .               DMQ$VALID_NORMAL   H DMQ$VALID_XGROUP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 5ʕ 1 Checking unsupported delivery modes and uma's...  L Put: BADUMA            , WF_MEM:0                 , DISCL:0                 L Put: BADUMA            , WF_MEM:0                 , DLQ  :0                 L Put: BADUMA            , WF_MEM:0                 , DLJ  :0                 L Put: BADUMA            , WF_MEM:0                 , RTS  :0                 L Put: BADUMA            , WF_MEM:0                 , SAF  :0                 L Put: BADDELIVERY       , AK_MEM:0                     , DISC :0                 L Put: BADDELIVERY       , AK_MEM:0                 , DISCL:0                 L Put: BADDELIVERY       , AK_MEM:0                 , DLQ  :0                 L Put: BADDELIVERY       , AK_MEM:0                 , DLJ  :0                 L Put: BADDELIVERY       , AK_MEM:0                 , RTS  :0                 L Put: BADDELIVERY       , AK_MEM:0                 , SAF  :0                 L Put: BADUMA            , NN_MEM:0                 , DLQ  :0                 L Put:     BADUMA            , NN_MEM:0                 , DLJ  :0                 L Put: BADUMA            , NN_MEM:0                 , SAF  :0                  Testing WF delivery modes ... L Put: NORMAL            , WF_MEM:NORMAL            , DISC :NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , DISC :NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , DISCL:NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , DLQ  :NO_UMA            L Put: NORMA    L            , WF_DQF:ENQUEUED          , DLJ  :NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , RTS  :NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , SAF  :NO_UMA            L Put: NORMAL            , WF_SAF:ENQUEUED          , DISC :NO_UMA            L Put: NORMAL            , WF_SAF:ENQUEUED          , DISCL:NO_UMA            L Put: NORMAL            , WF_SAF:ENQUEUED          , DLQ  :NO_UMA            L Put: NORMAL            , WF_SAF:ENQUEUED              , DLJ  :NO_UMA            L Put: NORMAL            , WF_SAF:ENQUEUED          , RTS  :NO_UMA            L Put: NORMAL            , WF_SAF:ENQUEUED          , SAF  :NO_UMA            L Put: NORMAL            , WFQ   :NORMAL            , 0    :NO_UMA             Testing AK delivery modes ... L Put: NORMAL            , AK_DQF:NORMAL            , DISC :UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , DISC :NO_UMA            L Put: NORMAL            , AK_DQF:NORMAL            , DI 	   SCL:UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , DISCL:NO_UMA            L Put: NORMAL            , AK_DQF:NORMAL            , DLQ  :UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , DLQ  :NO_UMA            L Put: NORMAL            , AK_DQF:NORMAL            , DLJ  :UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , DLJ  :NO_UMA            L Put: NORMAL            , AK_DQF:NORMAL            , RTS  :UMA_NA            L Ack: NORMAL    
            , AK_DQF:ENQUEUED          , RTS  :NO_UMA            L Put: NORMAL            , AK_DQF:NORMAL            , SAF  :UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , SAF  :NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , DISC :UMA_NA            L Ack: NORMAL            , AK_SAF:ENQUEUED          , DISC :NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , DISCL:UMA_NA            L Ack: NORMAL            , AK_SAF:ENQUEUED          ,     DISCL:NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , DLQ  :UMA_NA            L Ack: NORMAL            , AK_SAF:ENQUEUED          , DLQ  :NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , DLJ  :UMA_NA            L Ack: NORMAL            , AK_SAF:ENQUEUED          , DLJ  :NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , RTS  :UMA_NA            L Ack: NORMAL            , AK_SAF:ENQUEUED          , RTS  :NO_UMA            L Put: NORMAL                , AK_SAF:NORMAL            , SAF  :UMA_NA            L Ack: NORMAL            , AK_SAF:ENQUEUED          , SAF  :NO_UMA             Testing NN delivery modes ... L Put: NORMAL            , NN_MEM:NORMAL            , DISC :UMA_NA            L Put: NORMAL            , NN_MEM:NORMAL            , DISCL:UMA_NA            L Put: NORMAL            , NN_MEM:NORMAL            , RTS  :UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , DISC :UMA_NA            L Put: NORMAL        
        , NN_DQF:NORMAL            , DISCL:UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , DLQ  :UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , DLJ  :UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , RTS  :UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , SAF  :UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , DISC :UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , DISC    L:UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , DLQ  :UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , DLJ  :UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , RTS  :UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , SAF  :UMA_NA            L Put: NORMAL            , DG_LOG:NORMAL            , 0    :UMA_NA            L Put: NORMAL            , DG    :NORMAL            , 0    :UMA_NA            L Put: NORMAL     	           , RTS   :NORMAL            , 0    :UMA_NA             w w         Aʕ 1 Checking unsupported delivery modes and uma's...  L Put: BADUMA            , WF_MEM:0                 , DISCL:0                 L Put: BADUMA            , WF_MEM:0                 , DLQ  :0                 L Put: BADUMA            , WF_MEM:0                 , DLJ  :0                 L Put: BADUMA            , WF_MEM:0                 , RTS  :0                 L Put: BADUMA            , WF_MEM:0                 , SAF      :0                 L Put: BADDELIVERY       , AK_MEM:0                 , DISC :0                 L Put: BADDELIVERY       , AK_MEM:0                 , DISCL:0                 L Put: BADDELIVERY       , AK_MEM:0                 , DLQ  :0                 L Put: BADDELIVERY       , AK_MEM:0                 , DLJ  :0                 L Put: BADDELIVERY       , AK_MEM:0                 , RTS  :0                 L Put: BADDELIVERY       , AK_MEM:0                 , SAF  :0                 L Put: BADUMA                , NN_MEM:0                 , DLQ  :0                 L Put: BADUMA            , NN_MEM:0                 , DLJ  :0                 L Put: BADUMA            , NN_MEM:0                 , SAF  :0                  Testing WF delivery modes ... L Put: NORMAL            , WF_MEM:NORMAL            , DISC :NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , DISC :NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , DISCL:NO_UMA            L Put: NORMAL                , WF_DQF:ENQUEUED          , DLQ  :NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , DLJ  :NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , RTS  :NO_UMA            L Put: NORMAL            , WF_DQF:ENQUEUED          , SAF  :NO_UMA            L Put: NORMAL            , WF_SAF:STORED            , DISC :NO_UMA            L Put: NORMAL            , WF_SAF:STORED            , DISCL:NO_UMA            L Put: NORMAL            , WF_SAF:STORED            , DLQ  :NO                                                                                                                                                                                                                                                   T                         $      DMQ020.B                       El
  C  [DMQ$V20.LIB]DMQ$IVP.TLB;1;1PLI;1                                                                                                                            x4                 _UMA            L Put: NORMAL            , WF_SAF:STORED            , DLJ  :NO_UMA            L Put: NORMAL            , WF_SAF:STORED            , RTS  :NO_UMA            L Put: NORMAL            , WF_SAF:STORED            , SAF  :NO_UMA            L Put: NORMAL            , WFQ   :NORMAL            , 0    :NO_UMA             Testing AK delivery modes ... L Put: NORMAL            , AK_DQF:NORMAL            , DISC :UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , DISC :NO_UMA                L Put: NORMAL            , AK_DQF:NORMAL            , DISCL:UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , DISCL:NO_UMA            L Put: NORMAL            , AK_DQF:NORMAL            , DLQ  :UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , DLQ  :NO_UMA            L Put: NORMAL            , AK_DQF:NORMAL            , DLJ  :UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , DLJ  :NO_UMA            L Put: NORMAL            , A    K_DQF:NORMAL            , RTS  :UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , RTS  :NO_UMA            L Put: NORMAL            , AK_DQF:NORMAL            , SAF  :UMA_NA            L Ack: NORMAL            , AK_DQF:ENQUEUED          , SAF  :NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , DISC :UMA_NA            L Ack: NORMAL            , AK_SAF:STORED            , DISC :NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , DISCL:UMA_NA                L Ack: NORMAL            , AK_SAF:STORED            , DISCL:NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , DLQ  :UMA_NA            L Ack: NORMAL            , AK_SAF:STORED            , DLQ  :NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , DLJ  :UMA_NA            L Ack: NORMAL            , AK_SAF:STORED            , DLJ  :NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , RTS  :UMA_NA            L Ack: NORMAL            ,     AK_SAF:STORED            , RTS  :NO_UMA            L Put: NORMAL            , AK_SAF:NORMAL            , SAF  :UMA_NA            L Ack: NORMAL            , AK_SAF:STORED            , SAF  :NO_UMA             Testing NN delivery modes ... L Put: NORMAL            , NN_MEM:NORMAL            , DISC :UMA_NA            L Put: NORMAL            , NN_MEM:NORMAL            , DISCL:UMA_NA            L Put: NORMAL            , NN_MEM:NORMAL            , RTS  :UMA_NA            L Put: NORMAL            , NN_DQ    F:NORMAL            , DISC :UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , DISCL:UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , DLQ  :UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , DLJ  :UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , RTS  :UMA_NA            L Put: NORMAL            , NN_DQF:NORMAL            , SAF  :UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , DISC :UMA_NA                L Put: NORMAL            , NN_SAF:NORMAL            , DISCL:UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , DLQ  :UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , DLJ  :UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , RTS  :UMA_NA            L Put: NORMAL            , NN_SAF:NORMAL            , SAF  :UMA_NA            L Put: NORMAL            , DG_LOG:NORMAL            , 0    :UMA_NA            L Put: NORMAL            , DG         :NORMAL            , 0    :UMA_NA            L Put: NORMAL            , RTS   :NORMAL            , 0    :UMA_NA             w w                                                                                                                                                                                                                                                                                                                                                                                                      * [DMQ$V20.LIB]DMQ$OLB.OPT;1 +  , C   .     /     4 >       H                    - C    0   1    2   3      K  P   W   O     5 
  6  
  7  mM  8          9 Z  G    H  J                      DMQ$LIB:MSG/LIB,DMQ$LIB:DNS/LIB > !  +---------------------------------------------------------+> !  | Usage: Linking with mostly DECmessageQ object libraries |> !  | File:  DMQ$LIB:DMQ$OLB.OPT                              |> !  | DCL:   $ link sample, dmq$lib:dmq$olb/opt               |> !  +---------------------------------------------------------+ !    SYS$SYSTEM:SYS.STB/SELECTIVE !    DMQ$EXECRTL/SHARE    DMQ$PSSRTL/SHARE   SYS$SHARE:VAXCRTL/SHARE    SYS$SHARE:DNS$RTL/SHARE    SYS$SHARE:DNS$SHARE/SHARE  ! 4 !----------- end of DMQ$OLB.OPT -------------------- !                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * [DMQ$V20.LIB]DMQ.MLB;1 +  , zl   . 4    /     4     4   4                     - C    0   1    2   3      K  P   W   O 5    5   6  Bp  7  M  8          9          G    H  J                           %
   VAX-11 Librarian V04-00         Hʻ                 3    4                                                                                                                                                                                                                                                                                                                                                                                                                                                   PAMS_MAC_ENTRY_POINT   D PAMS_MAC_GROUP   "PAMS_MAC_PROCESS	    PAMS_MAC_RETURN_STATUS   PAMS_MAC_RETURN_STATUS_DEF$   PAMS_MAC_SYMBOL_DEF,    PAMS_MAC_TYPE_CLASS                                                                                                                                                                                                                                                                                                                                      볽ʕ D 	.MACRO	PAMS_MAC_ENTRY_POINT,..EQU=<=>,..COL=<:> ; IDENT DMQ V2.0-02 S_q_address'..equ'4  q_address'..equ'0 
 queue'..equ'0 
 group'..equ'2  S_psb'..equ'32 psb'..equ'0  type_of_psb'..equ'0  call_dependant'..equ'2 del_psb_status'..equ'4 S_seq_number'..equ'8 seq_number'..equ'8 uma_psb_status'..equ'16  function_status'..equ'20 S_psb_reserved'..equ'8 psb_reserved'..equ'24  S_show_buffer'..equ'68 show_buffer'..equ'0  version'..equ'0  transfer_status'..equ'4  transfer_s    ize'..equ'8  S_reserved'..equ'28  reserved'..equ'12  target'..equ'40  original_target'..equ'44 source'..equ'48  original_source'..equ'52 delivery'..equ'56  priority'..equ'60  endian'..equ'64 $ S_selection_array_component'..equ'52! selection_array_component'..equ'0 
 queue'..equ'0  priority'..equ'4 key_1_offset'..equ'8 key_1_size'..equ'12  key_1_value'..equ'16 key_1_oper'..equ'20  key_2_offset'..equ'24  key_2_size'..equ'28  key_2_value'..equ'32 key_2_oper'..equ'36  order_offset'..equ    '40  order_size'..equ'44  order_order'..equ'48 	.ENDM w w        @ʕ  	.MACRO 	PAMS_MAC_GROUP   %  PAMS_GROUP_ONE              =      1 %  PAMS_GROUP_TWO              =      2 %  PAMS_GROUP_MVII             =     75 %  PAMS_GROUP_PC               =    122    	.ENDM w w        `?ʕ  	.MACRO 	PAMS_MAC_PROCESS   (  PAMS_QUEUE_1                     =    1(  PAMS_QUEUE_2                     =    2(  PAMS_QUEUE_3                     =    3(  PAMS_QUEUE_4                     =    4(  PAM    S_QUEUE_5                     =    5(  PAMS_QUEUE_6                     =    6(  PAMS_QUEUE_7                     =    7(  PAMS_QUEUE_8                     =    8(  PAMS_QUEUE_9                     =    9)  PAMS_QUEUE_10                     =   10 ,  PAMS_SBS_ETH_CONTROL                 =   74,  PAMS_SBS_ETH_CHAN1                   =   75,  PAMS_SBS_ETH_CHAN2                   =   76,  PAMS_DEMO_IO_SERVER_1                =  101,  PAMS_DEMO_IO_SERVER_2                =  102,  PAMS_DEMO_IO_SERVER_3                                                                                                                                                                                                                       U                        .1 $      DMQ020.B                       zl  C  [DMQ$V20.LIB]DMQ.MLB;1LE_CLIENT.ADA;1                                                                                               4                          "                            =  103,  PAMS_DEMO_IO_SERVER_4                =  104,  PAMS_DEMO_IO_SERVER_MRQ              =  105,  PAMS_DEMO_ARCHIVE                    =  106,  PAMS_DEMO_IO_BROADCAST_1             = 5101,  PAMS_DEMO_IO_BROADCAST_2             = 5102,  PAMS_SCREEN_PROCESS                  =    0,  PAMS_TEMPORARY_Q                     =    0'  PAMS_SPARE1                     =   90 )  PAMS_ALL_UCBS                     =   91 ,  PAMS_TIMER_QUEUE                     =   92%  PAMS_NULL                     = 	      93 *  PAMS_INTERNAL1                     =   94,  PAMS_QTRANSFER_SERVER                =   95,  PAMS_DEAD_LETTER_QUEUE               =   96+  PAMS_MRS_SERVER                     =   98 ,  PAMS_AVAIL_SERVER                    =   99+  PAMS_SBS_SERVER                     =   99 ,  PAMS_DECLARE_SERVER                  =  100,  PAMS_CONNECT_SERVER                  =  100,  PAMS_QUEUE_SERVER                    =  100,  PAMS_PAMS_TRANSPORT                  =  100+  PAMS_COM_SERVER                     =   
   100 +  PAMS_DMQ_LOADER                     =  150 ,  PAMS_DCL_BY_Q_NAME                   =  151,  PAMS_TCPIP_LINK_DRIVER               =  152,  PAMS_DMQ_FULLTEST_PQ                 =  191,  PAMS_DMQ_FULLTEST_SQ                 =  192   	.ENDM w w        `ʕ  	.MACRO	PAMS_MAC_RETURN_STATUS        .EXTERNAL  PAMS__SUCCESS %        .EXTERNAL  PAMS__DISCL_SUCCESS $        .EXTERNAL  PAMS__DISC_SUCCESS#        .EXTERNAL  PAMS__DLJ_SUCCESS #        .EXTERNAL  PAMS__DLQ_SUCCESS         .EXTERNAL      PAMS__MSG #        .EXTERNAL  PAMS__RECOVERMODE #        .EXTERNAL  PAMS__RTS_SUCCESS #        .EXTERNAL  PAMS__SAF_SUCCESS "        .EXTERNAL  PAMS__CONFIRMREQ         .EXTERNAL  PAMS__ENQUEUED        .EXTERNAL  PAMS__MSGACT!        .EXTERNAL  PAMS__NOMOREMSG         .EXTERNAL  PAMS__NOMSG         .EXTERNAL  PAMS__NOSEND        .EXTERNAL  PAMS__NO_UMA!        .EXTERNAL  PAMS__PROPAGATE         .EXTERNAL  PAMS__STORED         .EXTERNAL  PAMS__TIMERACT!        .EXTERNAL  PAMS__TRACEBACK             .EXTERNAL  PAMS__UMA_NA#        .EXTERNAL  PAMS__UNATTACHEDQ          .EXTERNAL  PAMS__WAKEFAIL"        .EXTERNAL  PAMS__JOURNAL_ON        .EXTERNAL  PAMS__LINK_UP         .EXTERNAL  PAMS__ABORT         .EXTERNAL  PAMS__ACKTMO"        .EXTERNAL  PAMS__BADDECLARE        .EXTERNAL  PAMS__BADFREE !        .EXTERNAL  PAMS__BUFFEROVF         .EXTERNAL  PAMS__CANCEL#        .EXTERNAL  PAMS__ENDOFSOURCE $        .EXTERNAL  PAMS__EXCMAXUNCONF         .EXTERNAL  PAMS__EX_Q_LEN"        .EXTERNAL  PAMS__MR 
   QTBLFULL         .EXTERNAL  PAMS__MSGUNDEL         .EXTERNAL  PAMS__NOOBJECT!        .EXTERNAL  PAMS__NOTYETIMP $        .EXTERNAL  PAMS__OBJNOTACTIVE         .EXTERNAL  PAMS__POSSDUPL*        .EXTERNAL  PAMS__SENDER_TMO_EXPIRED        .EXTERNAL  PAMS__STUB        .EXTERNAL  PAMS__TIMEOUT "        .EXTERNAL  PAMS__SAF_FORCED        .EXTERNAL  PAMS__AMBIG #        .EXTERNAL  PAMS__AREATOSMALL "        .EXTERNAL  PAMS__BADARGLIST        .EXTERNAL  PAMS__BADCMD#        .EXTERNAL  PAMS__BADDELIVERY "            .EXTERNAL  PAMS__BADJOURNAL         .EXTERNAL  PAMS__BADLOGIC        .EXTERNAL  PAMS__BADNAME          .EXTERNAL  PAMS__BADPARAM#        .EXTERNAL  PAMS__BADPRIORITY "        .EXTERNAL  PAMS__BADPROCNUM"        .EXTERNAL  PAMS__BADRECEIVE         .EXTERNAL  PAMS__BADRESPQ!        .EXTERNAL  PAMS__BADSELIDX         .EXTERNAL  PAMS__BADSEQ#        .EXTERNAL  PAMS__BADSYNCHNUM         .EXTERNAL  PAMS__BADTAG$        .EXTERNAL  PAMS__BADTBQHANDLE        .EXTERNAL  PAMS__BADTIME "        .EXTERN    AL  PAMS__BADTMPPROC#        .EXTERNAL  PAMS__BADTMPSYNCH         .EXTERNAL  PAMS__BADUMA"        .EXTERNAL  PAMS__BIGBLKSIZE        .EXTERNAL  PAMS__BIGMSG        .EXTERNAL  PAMS__CIRACT        .EXTERNAL  PAMS__COMMERR $        .EXTERNAL  PAMS__DISCL_FAILED#        .EXTERNAL  PAMS__DISC_FAILED "        .EXTERNAL  PAMS__DLJ_FAILED"        .EXTERNAL  PAMS__DLQ_FAILED#        .EXTERNAL  PAMS__DNSCLASSBAD "        .EXTERNAL  PAMS__DNSDIRFAIL!        .EXTERNAL  PAMS__DNSFMTBAD '        .EXTERNAL  PAMS    __DQF_DEVICE_FAIL          .EXTERNAL  PAMS__DQF_FULL$        .EXTERNAL  PAMS__DUPLMSGCLASS#        .EXTERNAL  PAMS__DUPLMSGFROM !        .EXTERNAL  PAMS__DUPLMSGTO #        .EXTERNAL  PAMS__DUPLMSGTYPE !        .EXTERNAL  PAMS__DUPLQNAME         .EXTERNAL  PAMS__ERRORS#        .EXTERNAL  PAMS__EXCEEDQUOTA         .EXTERNAL  PAMS__EXTRA "        .EXTERNAL  PAMS__IDXTBLFULL!        .EXTERNAL  PAMS__INVACCESS !        .EXTERNAL  PAMS__INVALIDID "        .EXTERNAL  PAMS__INVALIDNUM"        .EXTERNAL  PA    MS__INVBUFFPTR!        .EXTERNAL  PAMS__INVFORMAT         .EXTERNAL  PAMS__INVJH #        .EXTERNAL  PAMS__INVUCBCNTRL         .EXTERNAL  PAMS__INVUMA$        .EXTERNAL  PAMS__IVDATAFORMAT"        .EXTERNAL  PAMS__IVDATATYPE!        .EXTERNAL  PAMS__IVECHOLIM          .EXTERNAL  PAMS__IVLOGLIM"        .EXTERNAL  PAMS__IVMSGCLASS         .EXTERNAL  PAMS__IVMSGJOU         .EXTERNAL  PAMS__IVMSGPRI         .EXTERNAL  PAMS__IVMSGSRC!        .EXTERNAL  PAMS__IVMSGTARG !        .EXTERNAL  PAMS__IVMSGTYPE              .EXTERNAL  PAMS__IVREPVAL         .EXTERNAL  PAMS__IVSETKEY         .EXTERNAL  PAMS__IVSETLOG        .EXTERNAL  PAMS__IVSETSR "        .EXTERNAL  PAMS__IVSETSRWHO        .EXTERNAL  PAMS__IVTIME!        .EXTERNAL  PAMS__LINK_DOWN #        .EXTERNAL  PAMS__LOGFOPENFAI #        .EXTERNAL  PAMS__LOGFWRITERR         .EXTERNAL  PAMS__MISENDC         .EXTERNAL  PAMS__MISENDR         .EXTERNAL  PAMS__MISEOM         .EXTERNAL  PAMS__MISQUOTE!        .EXTERNAL  PAMS__MISREPEAT #        .EXTERNAL      PAMS__MRS_RES_EXH "        .EXTERNAL  PAMS__MSGCONTENT        .EXTERNAL  PAMS__MSGFMT         .EXTERNAL  PAMS__MSGTOBIG"        .EXTERNAL  PAMS__MSGTOOLONG"        .EXTERNAL  PAMS__MSGTOSMALL#        .EXTERNAL  PAMS__NAMETOOLONG !        .EXTERNAL  PAMS__NOCANSEND         .EXTERNAL  PAMS__NOLINK!        .EXTERNAL  PAMS__NOLOGFILE          .EXTERNAL  PAMS__NOMOREJH"        .EXTERNAL  PAMS__NOMRQRESRC        .EXTERNAL  PAMS__NOMRS "        .EXTERNAL  PAMS__NOMSGCLASS!        .EXTERNAL  PAMS__NOMSGFRO    M         .EXTERNAL  PAMS__NOMSGTO !        .EXTERNAL  PAMS__NOMSGTYPE !        .EXTERNAL  PAMS__NOSUCHPCJ !        .EXTERNAL  PAMS__NOTACTIVE #        .EXTERNAL  PAMS__NOTALLOCATE          .EXTERNAL  PAMS__NOTASTMT        .EXTERNAL  PAMS__NOTDCL"        .EXTERNAL  PAMS__NOTDECIMAL        .EXTERNAL  PAMS__NOTHEX        .EXTERNAL  PAMS__NOTJRN         .EXTERNAL  PAMS__NOTOCTAL        .EXTERNAL  PAMS__NO_DQF        .EXTERNAL  PAMS__NO_SAF#        .EXTERNAL  PAMS__PNUMNOEXIST          .EXTERNAL  PA    MS__PROTOCOL         .EXTERNAL  PAMS__REJECTED         .EXTERNAL  PAMS__RESPQREQ!        .EXTERNAL  PAMS__RESRCFAIL "        .EXTERNAL  PAMS__RTS_FAILED'        .EXTERNAL  PAMS__SAF_DEVICE_FAIL "        .EXTERNAL  PAMS__SAF_FAILED!        .EXTERNAL  PAMS__SELRCVACT #        .EXTERNAL  PAMS__STATECHANGE %        .EXTERNAL  PAMS__STRINGTOOLONG         .EXTERNAL  PAMS__SYNTAX#        .EXTERNAL  PAMS__TOOMANYLOGF %        .EXTERNAL  PAMS__TOOMANYREPEAT #        .EXTERNAL  PAMS__TOOMANYSETS          .EXTE    RNAL  PAMS__UCBERROR#        .EXTERNAL  PAMS__VALUEOVERFL "        .EXTERNAL  PAMS__ZEROREPEAT         .EXTERNAL  PAMS__BADQTYPE$        .EXTERNAL  PAMS__JOURNAL_FAIL$        .EXTERNAL  PAMS__JOURNAL_FULL         .EXTERNAL  PAMS__NETERROR#        .EXTERNAL  PAMS__NETLINKLOST !        .EXTERNAL  PAMS__BADASSIGN "        .EXTERNAL  PAMS__BADASTPARM!        .EXTERNAL  PAMS__BADMSGBUF !        .EXTERNAL  PAMS__BADSCRIPT "        .EXTERNAL  PAMS__CREATEFAIL"        .EXTERNAL  PAMS__DCLTMPFAIL         .EXTE    RNAL  PAMS__DECLARED#        .EXTERNAL  PAMS__EXHAUSTBLKS "        .EXTERNAL  PAMS__INSQUEFAIL         .EXTERNAL  PAMS__INTERNAL        .EXTERNAL  PAMS__LOGNAME          .EXTERNAL  PAMS__LOGNAME2         .EXTERNAL  PAMS__LOGNAME3         .EXTERNAL  PAMS__LOGNAME4         .EXTERNAL  PAMS__LOGNAME5        .EXTERNAL  PAMS__NOOPEN        .EXTERNAL  PAMS__NOPRIV        .EXTERNAL  PAMS__NOQUOTA #        .EXTERNAL  PAMS__NOTPRIMARYQ %        .EXTERNAL  PAMS__NOTSECONDARYQ $        .EXTERNAL  PAMS__NOTSUP    PORTED         .EXTERNAL  PAMS__PAMSDOWN"        .EXTERNAL  PAMS__QUECORRUPT"        .EXTERNAL  PAMS__REMQUEFAIL        .EXTERNAL  PAMS__NOACL          .EXTERNAL  PAMS__NOACCESS#        .EXTERNAL  PAMS__BADINITFILE !        .EXTERNAL  PAMS__NETNOLINK  	.ENDM w w        ͝ʕ 6 	.MACRO	PAMS_MAC_RETURN_STATUS_DEF,..EQU=<=>,..COL=<:> PAMS_FACILITY'..equ'2132 PAMS__SUCCESS'..equ'1 # PAMS__DISCL_SUCCESS'..equ'139755529 " PAMS__DISC_SUCCESS'..equ'139755537! PAMS__DLJ_SUCCESS'..equ'139755545 ! PAMS                                                                                                                                                                                                                                                   V                        Ǽ $      DMQ020.B                       zl  C  [DMQ$V20.LIB]DMQ.MLB;1LE_CLIENT.ADA;11                                                                                              4                         ^ "                __DLQ_SUCCESS'..equ'139755553  PAMS__MSG'..equ'139755561 ! PAMS__RECOVERMODE'..equ'139755569 ! PAMS__RTS_SUCCESS'..equ'139755577 ! PAMS__SAF_SUCCESS'..equ'139755585   PAMS__CONFIRMREQ'..equ'139756323 PAMS__ENQUEUED'..equ'139756331 PAMS__MSGACT'..equ'139756339 PAMS__NOMOREMSG'..equ'139756347  PAMS__NOMSG'..equ'139756355  PAMS__NOSEND'..equ'139756363 PAMS__NO_UMA'..equ'139756371 PAMS__PROPAGATE'..equ'139756379  PAMS__STORED'..equ'139756387 PAMS__TIMERACT'..equ'139756395 PAMS__TRACEBACK'..equ'    139756403  PAMS__UMA_NA'..equ'139756411! PAMS__UNATTACHEDQ'..equ'139756419  PAMS__WAKEFAIL'..equ'139756427  PAMS__JOURNAL_ON'..equ'139756435 PAMS__LINK_UP'..equ'139756443  PAMS__ABORT'..equ'139757120  PAMS__ACKTMO'..equ'139757128  PAMS__BADDECLARE'..equ'139757136 PAMS__BADFREE'..equ'139757144  PAMS__BUFFEROVF'..equ'139757152  PAMS__CANCEL'..equ'139757160! PAMS__ENDOFSOURCE'..equ'139757168 " PAMS__EXCMAXUNCONF'..equ'139757176 PAMS__EX_Q_LEN'..equ'139757184  PAMS__MRQTBLFULL'..equ'139757192 PA    MS__MSGUNDEL'..equ'139757200 PAMS__NOOBJECT'..equ'139757208 PAMS__NOTYETIMP'..equ'139757216 " PAMS__OBJNOTACTIVE'..equ'139757224 PAMS__POSSDUPL'..equ'139757232( PAMS__SENDER_TMO_EXPIRED'..equ'139757240 PAMS__STUB'..equ'139757248 PAMS__TIMEOUT'..equ'139757256   PAMS__SAF_FORCED'..equ'139757264 PAMS__AMBIG'..equ'139758722 ! PAMS__AREATOSMALL'..equ'139758730   PAMS__BADARGLIST'..equ'139758738 PAMS__BADCMD'..equ'139758746! PAMS__BADDELIVERY'..equ'139758754   PAMS__BADJOURNAL'..equ'139758762 PAMS__    BADLOGIC'..equ'139758770 PAMS__BADNAME'..equ'139758778  PAMS__BADPARAM'..equ'139758786! PAMS__BADPRIORITY'..equ'139758794   PAMS__BADPROCNUM'..equ'139758802  PAMS__BADRECEIVE'..equ'139758810 PAMS__BADRESPQ'..equ'139758818 PAMS__BADSELIDX'..equ'139758826  PAMS__BADSEQ'..equ'139758834! PAMS__BADSYNCHNUM'..equ'139758842  PAMS__BADTAG'..equ'139758850" PAMS__BADTBQHANDLE'..equ'139758858 PAMS__BADTIME'..equ'139758866   PAMS__BADTMPPROC'..equ'139758874! PAMS__BADTMPSYNCH'..equ'139758882  PAMS__BADUMA    '..equ'139758890  PAMS__BIGBLKSIZE'..equ'139758898 PAMS__BIGMSG'..equ'139758906 PAMS__CIRACT'..equ'139758914 PAMS__COMMERR'..equ'139758922 " PAMS__DISCL_FAILED'..equ'139758930! PAMS__DISC_FAILED'..equ'139758938   PAMS__DLJ_FAILED'..equ'139758946  PAMS__DLQ_FAILED'..equ'139758954! PAMS__DNSCLASSBAD'..equ'139758962   PAMS__DNSDIRFAIL'..equ'139758970 PAMS__DNSFMTBAD'..equ'139758978 % PAMS__DQF_DEVICE_FAIL'..equ'139758986  PAMS__DQF_FULL'..equ'139758994" PAMS__DUPLMSGCLASS'..equ'139759002! PAMS__DUPL    MSGFROM'..equ'139759010  PAMS__DUPLMSGTO'..equ'139759018 ! PAMS__DUPLMSGTYPE'..equ'139759026  PAMS__DUPLQNAME'..equ'139759034  PAMS__ERRORS'..equ'139759042! PAMS__EXCEEDQUOTA'..equ'139759050  PAMS__EXTRA'..equ'139759058   PAMS__IDXTBLFULL'..equ'139759066 PAMS__INVACCESS'..equ'139759074  PAMS__INVALIDID'..equ'139759082   PAMS__INVALIDNUM'..equ'139759090  PAMS__INVBUFFPTR'..equ'139759098 PAMS__INVFORMAT'..equ'139759106  PAMS__INVJH'..equ'139759114 ! PAMS__INVUCBCNTRL'..equ'139759122  PAMS__INVU    MA'..equ'139759130" PAMS__IVDATAFORMAT'..equ'139759138  PAMS__IVDATATYPE'..equ'139759146 PAMS__IVECHOLIM'..equ'139759154  PAMS__IVLOGLIM'..equ'139759162  PAMS__IVMSGCLASS'..equ'139759170 PAMS__IVMSGJOU'..equ'139759178 PAMS__IVMSGPRI'..equ'139759186 PAMS__IVMSGSRC'..equ'139759194 PAMS__IVMSGTARG'..equ'139759202  PAMS__IVMSGTYPE'..equ'139759210  PAMS__IVREPVAL'..equ'139759218 PAMS__IVSETKEY'..equ'139759226 PAMS__IVSETLOG'..equ'139759234 PAMS__IVSETSR'..equ'139759242   PAMS__IVSETSRWHO'..equ'1     39759250 PAMS__IVTIME'..equ'139759258 PAMS__LINK_DOWN'..equ'139759266 ! PAMS__LOGFOPENFAI'..equ'139759274 ! PAMS__LOGFWRITERR'..equ'139759282  PAMS__MISENDC'..equ'139759290  PAMS__MISENDR'..equ'139759298  PAMS__MISEOM'..equ'139759306 PAMS__MISQUOTE'..equ'139759314 PAMS__MISREPEAT'..equ'139759322 ! PAMS__MRS_RES_EXH'..equ'139759330   PAMS__MSGCONTENT'..equ'139759338 PAMS__MSGFMT'..equ'139759346 PAMS__MSGTOBIG'..equ'139759354  PAMS__MSGTOOLONG'..equ'139759362  PAMS__MSGTOSMALL'..equ'139759370!  !   PAMS__NAMETOOLONG'..equ'139759378  PAMS__NOCANSEND'..equ'139759386  PAMS__NOLINK'..equ'139759394 PAMS__NOLOGFILE'..equ'139759402  PAMS__NOMOREJH'..equ'139759410  PAMS__NOMRQRESRC'..equ'139759418 PAMS__NOMRS'..equ'139759426   PAMS__NOMSGCLASS'..equ'139759434 PAMS__NOMSGFROM'..equ'139759442  PAMS__NOMSGTO'..equ'139759450  PAMS__NOMSGTYPE'..equ'139759458  PAMS__NOSUCHPCJ'..equ'139759466  PAMS__NOTACTIVE'..equ'139759474 ! PAMS__NOTALLOCATE'..equ'139759482  PAMS__NOTASTMT'..equ'139759490 PAMS__ "   NOTDCL'..equ'139759498  PAMS__NOTDECIMAL'..equ'139759506 PAMS__NOTHEX'..equ'139759514 PAMS__NOTJRN'..equ'139759522 PAMS__NOTOCTAL'..equ'139759530 PAMS__NO_DQF'..equ'139759538 PAMS__NO_SAF'..equ'139759546! PAMS__PNUMNOEXIST'..equ'139759554  PAMS__PROTOCOL'..equ'139759562 PAMS__REJECTED'..equ'139759570 PAMS__RESPQREQ'..equ'139759578 PAMS__RESRCFAIL'..equ'139759586   PAMS__RTS_FAILED'..equ'139759594% PAMS__SAF_DEVICE_FAIL'..equ'139759602   PAMS__SAF_FAILED'..equ'139759610 PAMS__SELRCVACT'..equ' #   139759618 ! PAMS__STATECHANGE'..equ'139759626 # PAMS__STRINGTOOLONG'..equ'139759634  PAMS__SYNTAX'..equ'139759642! PAMS__TOOMANYLOGF'..equ'139759650 # PAMS__TOOMANYREPEAT'..equ'139759658 ! PAMS__TOOMANYSETS'..equ'139759666  PAMS__UCBERROR'..equ'139759674! PAMS__VALUEOVERFL'..equ'139759682   PAMS__ZEROREPEAT'..equ'139759690 PAMS__BADQTYPE'..equ'139759698" PAMS__JOURNAL_FAIL'..equ'139759706" PAMS__JOURNAL_FULL'..equ'139759714 PAMS__NETERROR'..equ'139759722! PAMS__NETLINKLOST'..equ'139759730  PAMS__ $   BADASSIGN'..equ'139761924   PAMS__BADASTPARM'..equ'139761932 PAMS__BADMSGBUF'..equ'139761940  PAMS__BADSCRIPT'..equ'139761948   PAMS__CREATEFAIL'..equ'139761956  PAMS__DCLTMPFAIL'..equ'139761964 PAMS__DECLARED'..equ'139761972! PAMS__EXHAUSTBLKS'..equ'139761980   PAMS__INSQUEFAIL'..equ'139761988 PAMS__INTERNAL'..equ'139761996 PAMS__LOGNAME'..equ'139762004  PAMS__LOGNAME2'..equ'139762012 PAMS__LOGNAME3'..equ'139762020 PAMS__LOGNAME4'..equ'139762028 PAMS__LOGNAME5'..equ'139762036 PAMS__NOOPEN'. %   .equ'139762044 PAMS__NOPRIV'..equ'139762052 PAMS__NOQUOTA'..equ'139762060 ! PAMS__NOTPRIMARYQ'..equ'139762068 # PAMS__NOTSECONDARYQ'..equ'139762076 " PAMS__NOTSUPPORTED'..equ'139762084 PAMS__PAMSDOWN'..equ'139762092  PAMS__QUECORRUPT'..equ'139762100  PAMS__REMQUEFAIL'..equ'139762108 PAMS__NOACL'..equ'139762116  PAMS__NOACCESS'..equ'139762124! PAMS__BADINITFILE'..equ'139762132  PAMS__NETNOLINK'..equ'139762140  	.ENDM w w        Aʕ C 	.MACRO	PAMS_MAC_SYMBOL_DEF,..EQU=<=>,..COL=<:> ; IDEN &   T DMQ V2.0-05  PSEL_PRI_P0'..equ'1  PSEL_PRI_P1'..equ'2  PSEL_PRI_ANY'..equ'3 PSEL_SOURCE'..equ'-1 PSEL_CLASS'..equ'-2  PSEL_TYPE'..equ'-3 PSEL_BY_MASK'..equ'-1  PSEL_PQ'..equ'-2 PSEL_AQ'..equ'-3 PSEL_PQ_AQ'..equ'-4  PSEL_AQ_PQ'..equ'-5  PSEL_PQ_TYPE'..equ'-6  PSEL_PQ_CLASS'..equ'-7 PSEL_PQ_PRI'..equ'-8 PSEL_UCB'..equ'-9  PSEL_TQ_PQ'..equ'-10 PSEL_TQ_PQ_AQ'..equ'-11  PSEL_OPER_ANY'..equ'0  PSEL_OPER_EQ'..equ'1 PSEL_OPER_NEQ'..equ'2  PSEL_OPER_GTR'..equ'3  PSEL_OPER_LT'..equ'4 PS '   EL_OPER_GTRE'..equ'5 PSEL_OPER_LTE'..equ'6  PSEL_ORDER_FIFO'..equ'0  PSEL_ORDER_MIN'..equ'11  PSEL_ORDER_MAX'..equ'12  PDEL_MODE_DG_LOG'..equ'0 PDEL_MODE_DG'..equ'1 PDEL_MODE_RTS'..equ'10 PDEL_MODE_WFQ'..equ'20 PDEL_MODE_WF_SAF'..equ'25  PDEL_MODE_WF_DQF'..equ'26  PDEL_MODE_WF_NET'..equ'27  PDEL_MODE_WF_RCM'..equ'28  PDEL_MODE_WF_MEM'..equ'29  PDEL_MODE_AK_SAF'..equ'30  PDEL_MODE_AK_DQF'..equ'31  PDEL_MODE_AK_NET'..equ'32  PDEL_MODE_AK_RCM'..equ'33  PDEL_MODE_AK_MEM'..equ'34  PDEL_M (   ODE_NN_SAF'..equ'35  PDEL_MODE_NN_DQF'..equ'36  PDEL_MODE_NN_NET'..equ'37  PDEL_MODE_NN_RCM'..equ'38  PDEL_MODE_NN_MEM'..equ'39  PDEL_MODE_ST_RECOVER'..equ'22  PDEL_UMA_RTS'..equ'1 PDEL_UMA_DLJ'..equ'2 PDEL_UMA_DLQ'..equ'3 PDEL_UMA_SAF'..equ'4 PDEL_UMA_DISC'..equ'5  PDEL_UMA_DISCL'..equ'6 PDEL_DEFAULT_JRN'..equ'0 PDEL_FORCE_JRN'..equ'1 PDEL_NO_JRN'..equ'2  PSEL_TBL_PROC'..equ'-50  PSEL_TBL_GRP'..equ'-51 PSEL_TBL_DNS_CACHE'..equ'-52 PSEL_TBL_DNS_LOW'..equ'-53 PSEL_TBL_DNS_MED'..equ'- )   54 PSEL_TBL_DNS_HIGH'..equ'-55  PSYM_WF_RESP'..equ'-70 PSYM_AK_RESP'..equ'-71 PSYM_ATTACH_PQ'..equ'-200  PSYM_ATTACH_SQ'..equ'-201  PSYM_ATTACH_BY_NAME'..equ'-210  PSYM_ATTACH_BY_NUMBER'..equ'-211  PSYM_ATTACH_TEMPORARY'..equ'-212 PSYM_DCL_PQ'..equ'-200 PSYM_DCL_SQ'..equ'-201 PSYM_SCOPE_LOCAL'..equ'-202  PSYM_SCOPE_GLOBAL'..equ'-203 PSYM_IGNORE'..equ'-230 PSYM_SET_UCB_PRI_P0'..equ'-231 PSYM_SET_UCB_PRI_P1'..equ'-232 PSYM_SET_UCB_A'..equ'-240  PSYM_SET_UCB_B'..equ'-241  PSYM_SET_UCB_C'.                                                                                                                                                                                                                                                   W                        7T $      DMQ020.B                       zl  C  [DMQ$V20.LIB]DMQ.MLB;1LE_CLIENT.C;11                                                                                                4                         V      )        *   .equ'-242  PSYM_SET_UCB_D'..equ'-243  PSYM_SET_UCB_E'..equ'-244  PSYM_SET_UCB_F'..equ'-245  PSYM_SET_UCB_G'..equ'-246  PSYM_SET_UCB_H'..equ'-247  PSYM_SET_UCB_I'..equ'-248  PSYM_SET_UCB_J'..equ'-249  PSYM_UNKNOWN'..equ'0 PSYM_LITTLE_ENDIAN'..equ'0 PSYM_VAX_BYTE_ORDER'..equ'0  PSYM_BIG_ENDIAN'..equ'1  PSYM_NETWORK_BYTE_ORDER'..equ'1  PSYM_PLATFORM_VAX_VMS'..equ'0   PSYM_PLATFORM_VAX_ULTRIX'..equ'1! PSYM_PLATFORM_RISC_ULTRIX'..equ'2 ! PSYM_PLATFORM_HP9000_HPUX'..equ'3 # PSYM_PLATFORM_MOTORO +   LA_VR32'..equ'4 ! PSYM_PLATFORM_SPARC_SUNOS'..equ'5 $ PSYM_PLATFORM_IBM_RS6000_AIX'..equ'6 PSYM_PLATFORM_OS2'..equ'7  PSYM_PLATFORM_MSDOS'..equ'8  PSYM_PLATFORM_PDP11_RSX'..equ'9  PSYM_PLATFORM_VAXELN'..equ'10   PSYM_PLATFORM_MACINTOSH'..equ'11 PSYM_PLATFORM_SCO_UNIX'..equ'12 " PSYM_LINKMGT_USE_PREVIOUS'..equ'-1 PSYM_LINKMGT_NO_TIMER'..equ'0   PSYM_LINKMGT_ALL_GROUPS'..equ'-1 PSYM_LINKMGT_SUCCESS'..equ'1 PSYM_LINKMGT_MSGFMT'..equ'-2  PSYM_LINKMGT_MSGCONTENT'..equ'-4 PSYM_LINKMGT_ALREADYUP'..e ,   qu'-6  PSYM_LINKMGT_NOPRIV'..equ'-8 PSYM_LINKMGT_NOGROUP'..equ'-10# PSYM_LINKMGT_NOTSUPPORTED'..equ'-12 " PSYM_LINKMGT_NOTRANSPORT'..equ'-14$ PSYM_LINKMGT_OPERATIONFAIL'..equ'-16" PSYM_LINKMGT_CMD_INQUIRY'..equ'101" PSYM_LINKMGT_CMD_CONNECT'..equ'102% PSYM_LINKMGT_CMD_DISCONNECT'..equ'103 ! PSYM_LINKMGT_CMD_ENABLE'..equ'104  PSYM_LINKMGT_LOCAL'..equ'201 PSYM_LINKMGT_DECNET'..equ'202  PSYM_LINKMGT_TCPIP'..equ'203 PSYM_LINKMGT_UNKNOWN'..equ'301 PSYM_LINKMGT_NOCNT'..equ'302  PSYM_LINKMGT_CONNECTED -   '..equ'303 PSYM_LINKMGT_DISABLED'..equ'304  PSYM_QTYPE_PQ'..equ'1  PSYM_QTYPE_SQ'..equ'2  PSYM_QTYPE_MRQ'..equ'3 PSYM_QTYPE_UCB'..equ'4 	.ENDM w w        \v2ʕ  	.MACRO	PAMS_MAC_TYPE_CLASS  MSG_CLAS_MRS = 28 & MSG_TYPE_MRS_DQF_TRANSFER       = -700& MSG_TYPE_MRS_DQF_TRANSFER_ACK   = -701& MSG_TYPE_MRS_DQF_TRANSFER_REP   = -702& MSG_TYPE_MRS_DQF_SET            = -704& MSG_TYPE_MRS_DQF_SET_REP        = -705& MSG_TYPE_MRS_ACK                = -801& MSG_TYPE_MRS_CNF                = -840& MS .   G_TYPE_MRS_CNF_ACK            = -841& MSG_TYPE_MRS_CNF_NAK            = -842& MSG_TYPE_MRS_DEBUG_ON           = -850& MSG_TYPE_MRS_DEBUG_OFF          = -851& MSG_TYPE_MRS_SET_PCJ            = -880& MSG_TYPE_MRS_SET_PCJ_REP        = -881& MSG_TYPE_MRS_SET_DLJ            = -882& MSG_TYPE_MRS_SET_DLJ_REP        = -883 MSG_CLAS_PAMS = 29' MSG_TYPE_TIMER_EXPIRED           = -900 ' MSG_TYPE_LIST_ALL_Q_REQ          = -960 ' MSG_TYPE_LIST_ALL_Q_RESP         = -961 ' MSG_TYPE_ENABLE_Q_NOTIFY_REQ     = -962 ' 
 /   MSG_TYPE_ENABLE_Q_NOTIFY_RESP    = -963 ' MSG_TYPE_DISABLE_Q_NOTIFY_REQ    = -964 ' MSG_TYPE_DISABLE_Q_NOTIFY_RESP   = -965 ' MSG_TYPE_Q_UPDATE                = -966 ' MSG_TYPE_LOCATE_Q_REP            = -972 ' MSG_TYPE_LINKMGT_REQ             = -975 ' MSG_TYPE_LINKMGT_RESP            = -976 ' MSG_TYPE_DECLARE_SQ              = -980 ' MSG_TYPE_UNDECLARE_SQ            = -981 ' MSG_TYPE_ALLOCATED_SQ            = -982 ' MSG_TYPE_MSG_STATUS              = -983 ' MSG_TYPE_DMQ_SERVER_NAK          = -989 ' MS
 0   G_TYPE_ENABLE_NOTIFY           = -990 ' MSG_TYPE_DISABLE_NOTIFY          = -991 ' MSG_TYPE_PROCESS_DCL             = -992 ' MSG_TYPE_PROCESS_EXIT            = -993 ' MSG_TYPE_LIST_DCLS               = -994 ' MSG_TYPE_LIST_ALL_ENTRYS         = -995 ' MSG_TYPE_LIST_ALL_CONNECTIONS    = -996 ' MSG_TYPE_LIST_ALL_GROUPS         = -997 ' MSG_TYPE_LINK_LOST               = -998 ' MSG_TYPE_LINK_COMPLETE           = -999 % MSG_TYPE_SBS_REG              = -1150 % MSG_TYPE_SBS_REG_EZ           = -1173 % MSG_TYPE
 1   _SBS_REG_REPLY        = -1152 % MSG_TYPE_SBS_REG_EZ_REPLY     = -1153 % MSG_TYPE_SBS_DEREG_BY_ID      = -1154 % MSG_TYPE_MOT_DEREG            = -1154 % MSG_TYPE_SBS_DEREG            = -1174 % MSG_TYPE_SBS_DEREG_ACK        = -1155 % MSG_TYPE_SBS_PURGE            = -1157 % MSG_TYPE_SBS_PURGE_ACK        = -1158 % MSG_TYPE_SBS_DUMP_TABLES      = -1162 % MSG_TYPE_SBS_BS_SEQGAP        = -1166 % MSG_TYPE_AVAIL_REG            = -1180 % MSG_TYPE_AVAIL_DEREG          = -1181 % MSG_TYPE_AVAIL_REG_REPLY      = -1 2   182 % MSG_TYPE_AVAIL                = -1183 % MSG_TYPE_UNAVAIL              = -1184  MSG_CLAS_ETHERNET  = 100% MSG_TYPE_E_CONNECT            = -1000 % MSG_TYPE_E_DISCONNECT         = -1001 % MSG_TYPE_E_INITIALIZE         = -1002 % MSG_TYPE_E_CONNECT_COMPLETE   = -1003 % MSG_TYPE_E_CONNECT_REJECTED   = -1004 % MSG_TYPE_E_PARTNER_DISC       = -1005 % MSG_TYPE_E_IO_ERROR           = -1006 % MSG_TYPE_E_PROTOCOL_ERROR     = -1007 % MSG_TYPE_E_LISTEN_TIMEOUT     = -1008 % MSG_TYPE_E_MESSAGES_LOST      = -1 3   009 % MSG_TYPE_E_RUNTIME_ERROR      = -1010  MSG_CLAS_UCB    = 102 % MSG_TYPE_UCB_CONNECT          = -1200 % MSG_TYPE_UCB_DISCONNECT       = -1201 % MSG_TYPE_UCB_INITIALIZE       = -1202 % MSG_TYPE_UCB_CONNECT_COMPLETE = -1203 % MSG_TYPE_UCB_PARTNER_DISC     = -1204 % MSG_TYPE_UCB_MESSAGES_LOST    = -1205 % MSG_TYPE_UCB_IO_ERROR         = -1206 % MSG_TYPE_UCB_RCV_DATA         = -1207 % MSG_TYPE_DEMO_ADD             = -1200 % MSG_TYPE_DEMO_CHG             = -1216 % MSG_TYPE_DEMO_DEL             = -123     2 % MSG_TYPE_DEMO_INQ             = -1248 % MSG_TYPE_DEMO_LST             = -1280 % MSG_TYPE_DEMO_LST_NEXT        = -1281 % MSG_TYPE_DEMO_CLIENT_UP       = -1282 % MSG_TYPE_DEMO_CLIENT_DOWN     = -1283  	.ENDM w w                                                                                                                                                                                                                                                                                                                  * [DMQ$V20.LIB]DMQ.OPT;1 +  , C   .     /     4 <                          - C    0   1    2   3      K  P   W   O     5   6  O2  7 -M  8          9 Z  G    H  J                         < !  +-------------------------------------------------------+< !  | Usage: Linking with standard DECmessageQ RTLs         |< !  | File:  DMQ$LIB:DMQ.OPT                                |< !  | DCL:   $ link sample, dmq$lib:dmq/opt                 |< !  +-------------------------------------------------------+ !  	DMQ$ENTRYRTL/SHARE  ! 0 !----------- end of DMQ.OPT -------------------- !                                                                                                                                    * [DMQ$V20.LIB]DMQ.TLB;1 +  , }l   .    /     4                           - C    0   1    2   3      K  P   W   O    5   6   7 UM  8          9          G    H  J                           %
   VAX-11 Librarian V04-00                             8     	   
         V   V     V   B                                                                           (                                                                                                                                                                                                                                                                                                                        \             
AVAIL_MSG_DEF    
LIB$DATE_TIME   LIB$STOP   XMESSAGE_DEFS'   6 PAMS3   PAMS_ACOB_ENTRY_POINTJ   PAMS_ACOB_GROUPK   PAMS_ACOB_PROCESS]   ,PAMS_ACOB_RETURN_STATUS~   bPAMS_ACOB_RETURN_STATUS_DEF   FPAMS_ACOB_SYMBOL_DEF    PAMS_ACOB_TYPE_CLASS  PAMS_ADA_ENTRY_POINTS  PAMS_ADA_GROUPT  ^PAMS_ADA_PROCESS[  & PAMS_ADA_RETURN_STATUSm  PAMS_ADA_SYMBOL_DEF   PAMS_ADA_TYPE_CLASS   PAMS_BAS_ENTRY_POINT   PAMS_BAS_GROUP  PAMS_BAS_PROCESSQ         [  & PAMS_ADA_RETURN_STATUSm  PAMS_ADA_SYMBOL_DEF   PAMS_ADA_TYPE_CLASS   PAMS_BAS_ENTRY_POINT   PAMS_BAS_GROUP  PAMS_BAS_PROCESS  PPAMS_BAS_RETURN_STATUS   PAMS_BAS_RETURN_STATUS_DEF  T PAMS_BAS_SYMBOL_DEF   PAMS_BAS_TYPE_CLASS  PAMS_BLI_ENTRY_POINT$  :PAMS_BLI_GROUP%   PAMS_BLI_PROCESS+  > PAMS_BLI_RETURN_STATUS9   PAMS_BLI_RETURN_STATUS_DEFH  PAMS_BLI_SYMBOL_DEFX  X PAMS_BLI_TYPE_CLASSj   PAMS_COB_ENTRY_POINTt  f PAMS_COB_GROUP               PAMS_ADA_PROCESS   PAMS_BLI_PROCESS   PAMS_C_GROUP   PAMS_FOR_RETURN_STATUS_DEF   PAMS_PLI_GROUP   UCB_WORK_AVAIL_FLAGS_REF                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 X                        p $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1LE_CLIENT.C;11                                                                                                                        { "            W         +  > PAMS_BLI_RETURN_STATUS9   PAMS_BLI_RETURN_STATUS_DEFH  PAMS_BLI_SYMBOL_DEFX  X PAMS_BLI_TYPE_CLASSj   PAMS_COB_ENTRY_POINTt  f PAMS_COB_GROUPt  PAMS_COB_PROCESS|   PAMS_COB_RETURN_STATUS  . PAMS_COB_RETURN_STATUS_DEF  RPAMS_COB_SYMBOL_DEF  l PAMS_COB_TYPE_CLASS  @ PAMS_C_ENTRY_POINT   PAMS_C_GROUP  r PAMS_C_PROCESS  L PAMS_C_RETURN_STATUS    PAMS_C_RETURN_STATUS_DEF  L PAMS_C_SYMBOL_DEF1  2 PAMS_C_TYPE_CLASSC   PAMS_ERROR_DEFS        g           r PAMS_C_PROCESS  L PAMS_C_RETURN_STATUS    PAMS_C_RETURN_STATUS_DEF  L PAMS_C_SYMBOL_DEF1  2 PAMS_C_TYPE_CLASSC   PAMS_ERROR_DEFS]  PAMS_FORTRANb   PAMS_FORTRAN_ERROR_DEFSo  PAMS_FORTRAN_MSG_DEFS  PAMS_FOR_ENTRY_POINT  f PAMS_FOR_GROUP  PAMS_FOR_PROCESS   PAMS_FOR_RETURN_STATUS   PAMS_FOR_RETURN_STATUS_DEF   PAMS_FOR_SYMBOL_DEF  f PAMS_FOR_TYPE_CLASS  
PAMS_GROUP  NPAMS_GROUP_FORTRAN   PAMS_MESSAGE  PAMS_PAS_ENTRY_POINT Z            PAMS_FOR_SYMBOL_DEF  f PAMS_FOR_TYPE_CLASS  
PAMS_GROUP  NPAMS_GROUP_FORTRAN   PAMS_MESSAGE  PAMS_PAS_ENTRY_POINT  PAMS_PAS_GROUP   PAMS_PAS_PROCESS   PAMS_PAS_RETURN_STATUS/  > PAMS_PAS_RETURN_STATUS_DEF;  NPAMS_PAS_SYMBOL_DEFR  \ PAMS_PAS_TYPE_CLASSd  PAMS_PLI_ENTRY_POINT  PAMS_PLI_GROUP  PAMS_PLI_PROCESS  PAMS_PLI_RETURN_STATUS   PAMS_PLI_RETURN_STATUS_DEF  PAMS_PLI_SYMBOL_DEF  xPAMS_PLI_TYPE_CLASS                            PAMS_PLI_PROCESS  PAMS_PLI_RETURN_STATUS   PAMS_PLI_RETURN_STATUS_DEF  PAMS_PLI_SYMBOL_DEF  xPAMS_PLI_TYPE_CLASS  V PAMS_PROCESSES   PAMS_PROCESSES_FORTRAN  PAMS_PRT_ERR  V PAMS_PRT_MSG  PAMS_PRT_STS  PRINT_ERROR   
PRINT_MESSAGE  |SBS_MSG_DEF  ^
STR$UPCASE  UCB_FTN_WORK_AVAIL_FLAGS  \ UCB_UTILITY_ROUTINES   UCB_WORK_AVAIL_FLAGS_REF                                                                                              
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |ʕ #                                     I /************************************************************************ / *       AVAIL_SERVER Version 2.0          				* ' *	Module: AVAIL_MSG_DEF  					        *  *	File:   AVAILMSGDEF.H						*J *************************************************************************/ #ifndef PAMS_ADDRESS_DEFINED typedef union {  	unsigned long all; 	 	struct {  	   unsigned short process;  	   unsigned short group;  	} au; } PAMS_ADDRESS;   #defin 
   e PAMS_ADDRESS_DEFINED YES #endif  D /*******************************************************************B *     FORMAT OF   AVAIL REG         #BYTES   	NOTES              *D ********************************************************************+ 	TARGET = registrant                         	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_AVAIL_REG
 	MSG    = "     ==============================A             version                     2       always decimal 20 "     ------------------------------,                 target process  PQ          4   "     ------------------------------G             distribution Q              4                               "     ------------------------------ 	EOM */   struct AVAIL_REG {  " 	short	version;		/* always = 20 */ 	PAMS_ADDRESS target_PQ; 	PAMS_ADDRESS distribution_Q;  };D /*******************************************************************D *     FORMAT OF   AVAIL  DEREG        #BYTES   	NOTES              *D ************************************************
    ********************+ 	TARGET = registrant                         	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_AVAIL_DEREG
 	MSG    = "     ==============================A             version                     2       always decimal 20 "     ------------------------------,             target process PQ           4   "     ------------------------------G             distribution Q              4                               "     ------------------------------)             request acknowledgement     	1	   "     ------------------------------ 	EOM */   struct AVAIL_DEREG {  " 	short	version;		/* always = 20 */ 	PAMS_ADDRESS target_PQ;!     	PAMS_ADDRESS distribution_Q; * 	char	req_ack;		/* = 1 if ACK requested */ };  D /*******************************************************************C *     FORMAT OF AVAIL REG REPLY      #BYTES   	NOTES              * D ********************************************************************/ 	TARGET = source of registrant                   	CLASS  = MSG_CLAS    _PAMS " 	TYPE   = MSG_TYPE_AVAIL_REG_REPLY
 	MSG    = "     ==============================3       	     status  			2  	status (1=ok,-n=ng)      "     ------------------------------*       	     reg_id  			2  	returned reg id"     ------------------------------K       	     number_reg                 2  	number currently registered for  C     ------------------------------               this mot or target  	EOM */	            struct AVAIL_REG_REPLY {4 	short	 status;	/* returned status (1=ok, -n = n
    g */6 	unsigned short	reg_id;	/* returned registration id */C 	short	 number_reg;    /* number of registrants left on this mot */  };                    D /*******************************************************************A *     FORMAT OF   AVAIL            #BYTES   	NOTES              * D ********************************************************************5 	TARGET = distribution address                         	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_AVAIL
 	MSG    = "     ==================    ============,             target process  PQ          4   "     ------------------------------ 	EOM */   struct AVAIL {   	PAMS_ADDRESS target_PQ; };                D /*******************************************************************C *     FORMAT OF Q_UNAVAIL            #BYTES   	NOTES              * D ********************************************************************5 	TARGET = distribution address                         	CLASS  = MSG_CLAS_PAMS  	TYPE   = MSG_TYPE_UNAVAIL
 	MSG    = "         ==============================,             target process PQ           4   "     ------------------------------ 	EOM */   struct UNAVAIL {   	PAMS_ADDRESS target_PQ; }; w w        ʕ  	DECLARE LIB$DATE_TIME EXTERNAL  	  ENTRY( CHAR(*));  w w        zʕ 2 DECLARE LIB$STOP EXTERNAL ENTRY ( FIXED BIN (31)); w w         3ʕ 3 /** -------------------------------------------- */ 3 /** Include file name: PAMS_PLI_TYPE_CLASS       */ 3 /** File name: PAITYPPLI.TXT            
             */ 3 /** Usage: %INCLUDE PAMS_PLI_TYPE_CLASS;         */    B /**  Function:                                                 **/B /**    This include file defines all the message definitions   **/B /**    used within the DECmessageQ system.                     **/B /**                                                            **/B /**  NOTE:                                                     **/B /**    The following are reserved to DIGITAL:                  **/B /**                       	                                         **/B /**        Msg Classes: 28, 29 & 30,000 thru 32,767            **/B /**        Msg Types:   -1 thru -5,000                         **/B /**------------------------------------------------------------**/   B /****************************************************************/B /**                                                            **/B /**        MRS Class and Type codes (800-899)                  **/B /**                                                                                                                                                                                                                                                                                                    Y                        5v $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1LE_CLIENT.C;1;1                                                                                                                       0N "            
               **/B /****************************************************************/   : %REPLACE MSG_CLAS_MRS BY 28;      /** define MRS class **/    /** define MRS type codes **/ 1 %REPLACE MSG_TYPE_MRS_DQF_TRANSFER       BY -700; 1 %REPLACE MSG_TYPE_MRS_DQF_TRANSFER_ACK   BY -701; 1 %REPLACE MSG_TYPE_MRS_DQF_TRANSFER_REP   BY -702; 1 %REPLACE MSG_TYPE_MRS_DQF_SET            BY -704; 1 %REPLACE MSG_TYPE_MRS_DQF_SET_REP        BY -705; 1 %REPLACE MSG_TYPE_MRS_ACK                BY -801; 1 %REPLACE M    SG_TYPE_MRS_CNF                BY -840; 1 %REPLACE MSG_TYPE_MRS_CNF_ACK            BY -841; 1 %REPLACE MSG_TYPE_MRS_CNF_NAK            BY -842; 1 %REPLACE MSG_TYPE_MRS_DEBUG_ON           BY -850; 1 %REPLACE MSG_TYPE_MRS_DEBUG_OFF          BY -851; 1 %REPLACE MSG_TYPE_MRS_SET_PCJ            BY -880; 1 %REPLACE MSG_TYPE_MRS_SET_PCJ_REP        BY -881; 1 %REPLACE MSG_TYPE_MRS_SET_DLJ            BY -882; 1 %REPLACE MSG_TYPE_MRS_SET_DLJ_REP        BY -883;    B /*******************************************    *********************/B /**                                                            **/B /**        PAMS   Class and Type codes (900-999)               **/B /**                                                            **/B /****************************************************************/   < %REPLACE MSG_CLAS_PAMS BY 29;      /** define PAMS class **/    /** define PAMS type codes **/2 %REPLACE MSG_TYPE_TIMER_EXPIRED           BY -900;2 %REPLACE MSG_TYPE_LIST_ALL_Q_REQ          BY -960;2 %REP
    LACE MSG_TYPE_LIST_ALL_Q_RESP         BY -961;2 %REPLACE MSG_TYPE_ENABLE_Q_NOTIFY_REQ     BY -962;2 %REPLACE MSG_TYPE_ENABLE_Q_NOTIFY_RESP    BY -963;2 %REPLACE MSG_TYPE_DISABLE_Q_NOTIFY_REQ    BY -964;2 %REPLACE MSG_TYPE_DISABLE_Q_NOTIFY_RESP   BY -965;2 %REPLACE MSG_TYPE_Q_UPDATE                BY -966;2 %REPLACE MSG_TYPE_LOCATE_Q_REP            BY -972;2 %REPLACE MSG_TYPE_LINKMGT_REQ             BY -975;2 %REPLACE MSG_TYPE_LINKMGT_RESP            BY -976;2 %REPLACE MSG_TYPE_DECLARE_SQ                  BY -980;2 %REPLACE MSG_TYPE_UNDECLARE_SQ            BY -981;2 %REPLACE MSG_TYPE_ALLOCATED_SQ            BY -982;2 %REPLACE MSG_TYPE_MSG_STATUS              BY -983;2 %REPLACE MSG_TYPE_DMQ_SERVER_NAK          BY -989;2 %REPLACE MSG_TYPE_ENABLE_NOTIFY           BY -990;2 %REPLACE MSG_TYPE_DISABLE_NOTIFY          BY -991;2 %REPLACE MSG_TYPE_PROCESS_DCL             BY -992;2 %REPLACE MSG_TYPE_PROCESS_EXIT            BY -993;2 %REPLACE MSG_TYPE_LIST_DCLS               BY -994;2 %REPLACE MSG_TYPE_LIST_ALL_E
    NTRYS         BY -995;2 %REPLACE MSG_TYPE_LIST_ALL_CONNECTIONS    BY -996;2 %REPLACE MSG_TYPE_LIST_ALL_GROUPS         BY -997;2 %REPLACE MSG_TYPE_LINK_LOST               BY -998;2 %REPLACE MSG_TYPE_LINK_COMPLETE           BY -999;   B /****************************************************************/B /**                                                            **/B /**       SBS_SERVER - class: PAMS                             **/B /**                    type:  codes (1150-1179)                **/    B /**                                                            **/B /****************************************************************/   Z %REPLACE MSG_TYPE_SBS_REG              BY -1150;      /** registration message long form*/j %REPLACE MSG_TYPE_SBS_REG_EZ           BY -1173;      /** registration record short form (new v2 format)*/N %REPLACE MSG_TYPE_SBS_REG_REPLY        BY -1152;      /** registration reply*/N %REPLACE MSG_TYPE_SBS_REG_EZ_REPLY     BY -1153;      /** registration reply*/^ %REP    LACE MSG_TYPE_SBS_DEREG_BY_ID      BY -1154;      /** deregister request (old v1 format)*/^ %REPLACE MSG_TYPE_MOT_DEREG            BY -1154;      /** deregister request (old v1 format)*/^ %REPLACE MSG_TYPE_SBS_DEREG            BY -1174;      /** deregister request (new v2 format)*/V %REPLACE MSG_TYPE_SBS_DEREG_ACK        BY -1155;      /** deregister acknowledgement*/T %REPLACE MSG_TYPE_SBS_PURGE            BY -1157;      /** purge registration table*/^ %REPLACE MSG_TYPE_SBS_PURGE_ACK        BY -1158;          /** purge registration acknowledgement*/a %REPLACE MSG_TYPE_SBS_DUMP_TABLES      BY -1162;      /** process, reg, and group tables to log*/ W %REPLACE MSG_TYPE_SBS_BS_SEQGAP        BY -1166;      /** declaration message missing*/    B /****************************************************************/B /**                                                            **/B /**       AVAIL_SERVER - class: PAMS                           **/B /**                    type:  codes (1180-1189)             	        **/B /**                                                            **/B /****************************************************************/   S %REPLACE MSG_TYPE_AVAIL_REG            BY -1180;      /** available registration */ U %REPLACE MSG_TYPE_AVAIL_DEREG          BY -1181;      /** available deregistration */ N %REPLACE MSG_TYPE_AVAIL_REG_REPLY      BY -1182;      /** registration reply*/U %REPLACE MSG_TYPE_AVAIL                BY -1183;      /** process is now available */ W %REPLACE MSG_TYP !   E_UNAVAIL              BY -1184;      /** process is now unavailable */    B /****************************************************************/B /**                                                            **/B /**       ETHERNET   Class and Type codes (1000-1010)          **/B /**                                                            **/B /****************************************************************/   E %REPLACE MSG_CLAS_ETHERNET  BY 100;      /** define Ethernet class */      /** defi "   ne Ethernet type codes*/X %REPLACE MSG_TYPE_E_CONNECT            BY -1000;      /** Initiate connection         */[ %REPLACE MSG_TYPE_E_DISCONNECT         BY -1001;      /** shutdown circuit               */ Y %REPLACE MSG_TYPE_E_INITIALIZE         BY -1002;      /** set Ethernet characteristics */ [ %REPLACE MSG_TYPE_E_CONNECT_COMPLETE   BY -1003;      /** circuit established            */ [ %REPLACE MSG_TYPE_E_CONNECT_REJECTED   BY -1004;      /** partner rejected circuit       */ [ %REPLACE MSG_TYP #   E_E_PARTNER_DISC       BY -1005;      /** partner disconnected circuit   */ X %REPLACE MSG_TYPE_E_IO_ERROR           BY -1006;      /** bad return status from QIO$ */Y %REPLACE MSG_TYPE_E_PROTOCOL_ERROR     BY -1007;      /** unrecognized msg from partner*/ X %REPLACE MSG_TYPE_E_LISTEN_TIMEOUT     BY -1008;      /** partner's heartbeat stopped */X %REPLACE MSG_TYPE_E_MESSAGES_LOST      BY -1009;      /** detected msg loss           */Y %REPLACE MSG_TYPE_E_RUNTIME_ERROR      BY -1010;      /** detected $    runtime error in AST*/    5 /***************************************************/ 5 /**       Generic UCB Types and Classes           **/ 5 /***************************************************/      %REPLACE MSG_CLAS_UCB    BY 102;   X %REPLACE MSG_TYPE_UCB_CONNECT          BY -1200;      /** Initiate connection         */X %REPLACE MSG_TYPE_UCB_DISCONNECT       BY -1201;      /** shutdown circuit            */V %REPLACE MSG_TYPE_UCB_INITIALIZE       BY -1202;      /** set UCB characteristics   */ %   X %REPLACE MSG_TYPE_UCB_CONNECT_COMPLETE BY -1203;      /** circuit established         */X %REPLACE MSG_TYPE_UCB_PARTNER_DISC     BY -1204;      /** partner disconnected circuit*/X %REPLACE MSG_TYPE_UCB_MESSAGES_LOST    BY -1205;      /** detected msg loss           */X %REPLACE MSG_TYPE_UCB_IO_ERROR         BY -1206;      /** bad return status from QIO$ */X %REPLACE MSG_TYPE_UCB_RCV_DATA         BY -1207;      /** data message received by UCB*/      B /*********************************************	 &   *******************/B /**                                                            **/B /**        DEFINE DEMO type codes for DEMO_IO_SERVER           **/B /**                                                            **/B /****************************************************************/   S %REPLACE MSG_TYPE_DEMO_ADD             BY -1200;      /** add record function   **/ S %REPLACE MSG_TYPE_DEMO_CHG             BY -1216;      /** chg record function   **/ S %REPLACE MSG_TYPE_DEMO_DEL           '      BY -1232;      /** del record function   **/ S %REPLACE MSG_TYPE_DEMO_INQ             BY -1248;      /** inq record function   **/ S %REPLACE MSG_TYPE_DEMO_LST             BY -1280;      /** list record function  **/ W %REPLACE MSG_TYPE_DEMO_LST_NEXT        BY -1281;      /** list next record function **/ S %REPLACE MSG_TYPE_DEMO_CLIENT_UP       BY -1282;      /** client up             **/ S %REPLACE MSG_TYPE_DEMO_CLIENT_DOWN     BY -1283;      /** client down           **/    ; /************** En                                                                                                                                                                                                                                                   Z                        p $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1LE_CLIENT.FOR;1                                                                                                                       5 "     '        (   d of PAMS_xxx_TYPE_CLASS ***************/  w w        ʕ  /*		PAMS INCLUDE FILE = ************************************************************* / *   Entry points for PAMS subroutines.			        *							      ; * CALL SEQUENCE:  STS$VALUE = PAMS_DCL_PROCESS(Process_num   *				   [,Process_num2])     *							      > * CALL SEQUENCE:  STS$VALUE = PAMS_ALLOC_MSG(Size,Msg_ptr)     *							      > * CALL SEQUENCE:  STS$VALUE = PAMS_SEND_MSG(Msg_ptr,Priority, ! *				   Target,Class,Type,Journa )   l  *				   [,timeout [,psb]]) *							      > * CALL SEQUENCE:  STS$VALUE = PAMS_PUT_MSG(Msg_area,Priority, " *				   Target,Class,Type,Journal,C *                                  Message_size [,timeout [,psb]])   *							      > * CALL SEQUENCE:  STS$VALUE = PAMS_RCV_MSG(Msg_ptr,Priority,    *				   Source,Class,Type,Length *				   [,Sel_addr [,psb]])    *							      > * CALL SEQUENCE:  STS$VALUE = PAMS_RCV_MSGW(Msg_ptr,Priority, # *				   Source,Class,Type,Length,   % *				   Timeout [,Sel_ad *   dr [,psb]])    *							      ? * CALL SEQUENCE:  STS$VALUE = PAMS_GET_MSG(Msg_area,Priority,   ! *				   Source,Class,Type,Length, . *                                  Length_data *				   [,Sel_addr [,psb]])    *							      ? * CALL SEQUENCE:  STS$VALUE = PAMS_GET_MSGW(Msg_area,Priority,  # *				   Source,Class,Type,Length,    *				   Length_data,Timeout  *				   [,Sel_addr [,psb]])    *							      ; * CALL SEQUENCE:  STS$VALUE = PAMS_FREE_MSG(Msg_ptr)	        *							      E * CALL SEQUENCE: +     STS$VALUE = PAMS_SET_TIMER(Timer_ID, Format,	       ) *				   Pams_Timeout, Sys_timeout)	        *							      > * CALL SEQUENCE:  STS$VALUE = PAMS_CANCEL_TIMER(Timer_ID)      * 4 * CALL SEQUENCE:  STS$VALUE = PAMS_WAIT_TIMER()      *							      B * CALL SEQUENCE:  STS$VALUE = PAMS_DCL_SYNCH(Proc_num [,Proc_num]) * > * CALL SEQUENCE:  STS$VALUE = PAMS_SET_SYNCH([Flush_que_flag]) * 1 * CALL SEQUENCE:  STS$VALUE = PAMS_CANCEL_SYNCH()  * E * CALL SEQUENCE:  STS$VALUE = PAMS_CONFIRM_MSG(Seq_varia ,   ble, Status,   *					       J_override) *							      > *************************************************************/  % /* PAMS internal call declarations */   % DCL	PAMS_DCL_PROCESS	EXTERNAL ENTRY ( " 		FIXED BIN(31),			/* Proc_num  */" 		FIXED BIN(31))			/* Proc_num2 */ 		OPTIONS (VARIABLE) 		RETURNS (FIXED BIN(31));			   $ DCL	PAMS_ALLOC_MSG		EXTERNAL ENTRY (" 		FIXED BIN(15),			/* Size	     */ 		POINTER)			/* Msg_ptr   */ 		RETURNS (FIXED BIN(31));			   # DCL	PAMS_SEND_MSG		EXTERNAL ENTRY  -   (  		POINTER,			/* Msg_ptr   */! 		FIXED BIN(7),			/* Priority  */ " 		FIXED BIN(31),			/* Target    */" 		FIXED BIN(15),			/* Class     */" 		FIXED BIN(15),			/* Type	     */! 		FIXED BIN(7),			/* Journal   */ " 		FIXED BIN(31),			/* Timeout   */ 		ANY,				/* PSB       */ ! 		FIXED BIN(7),			/* UMA       */ " 		FIXED BIN(31),			/* Resp que  */ 		ANY)				/* User tag  */  		OPTIONS (VARIABLE) 		RETURNS (FIXED BIN(31));			   " DCL	PAMS_PUT_MSG		EXTERNAL ENTRY ( 		ANY,				/* Msg_area  */ ! 		FIXED  .   BIN(7),			/* Priority  */ " 		FIXED BIN(31),			/* Target    */" 		FIXED BIN(15),			/* Class     */" 		FIXED BIN(15),			/* Type	     */! 		FIXED BIN(7),			/* Journal   */ ?                 FIXED BIN(15),                  /* Msg_size  */ " 		FIXED BIN(31),			/* Timeout   */ 		ANY,				/* PSB       */ ! 		FIXED BIN(7),			/* UMA       */ " 		FIXED BIN(31),			/* Resp que  */ 		ANY)				/* User tag  */  		OPTIONS (VARIABLE) 		RETURNS (FIXED BIN(31));			   " DCL	PAMS_RCV_MSG		EXTERNAL ENTRY ( 		POINTER,		 /   	/* Msg_ptr   */! 		FIXED BIN(7),			/* Priority  */ " 		FIXED BIN(31),			/* Source    */" 		FIXED BIN(15),			/* Class     */" 		FIXED BIN(15),			/* Type	     */" 		FIXED BIN(15),			/* Length    */" 		FIXED BIN(31),			/* Sel_addr  */ 		ANY,				/* PSB       */  		ANY)				/* User tag  */  		OPTIONS (VARIABLE) 		RETURNS (FIXED BIN(31));			   # DCL	PAMS_RCV_MSGW		EXTERNAL ENTRY (  		POINTER,			/* Msg_ptr   */! 		FIXED BIN(7),			/* Priority  */ " 		FIXED BIN(31),			/* Source    */" 		FIXED BIN(15),			/ 0   * Class     */" 		FIXED BIN(15),			/* Type	     */" 		FIXED BIN(15),			/* Length    */" 		FIXED BIN(31),			/* Timeout   */" 		FIXED BIN(31),			/* Sel_addr  */ 		ANY,				/* PSB       */  		ANY)				/* User tag  */  		OPTIONS (VARIABLE) 		RETURNS (FIXED BIN(31));			   " DCL	PAMS_GET_MSG		EXTERNAL ENTRY ( 		ANY,				/* Msg_area  */ ! 		FIXED BIN(7),			/* Priority  */ " 		FIXED BIN(31),			/* Source    */" 		FIXED BIN(15),			/* Class     */" 		FIXED BIN(15),			/* Type	     */" 		FIXED BIN(15),			/* Leng 1   th    */" 		FIXED BIN(15),			/* Len_data  */" 		FIXED BIN(31),			/* Sel_addr  */ 		ANY,				/* PSB       */  		ANY)				/* User tag  */  		OPTIONS (VARIABLE) 		RETURNS (FIXED BIN(31));			   # DCL	PAMS_GET_MSGW		EXTERNAL ENTRY (  		ANY,				/* Msg_area  */ ! 		FIXED BIN(7),			/* Priority  */ " 		FIXED BIN(31),			/* Source    */" 		FIXED BIN(15),			/* Class     */" 		FIXED BIN(15),			/* Type	     */" 		FIXED BIN(15),			/* Length    */" 		FIXED BIN(15),			/* Len_data  */" 		FIXED BIN(31),			/* Timeout  2     */" 		FIXED BIN(31),			/* Sel_addr  */ 		ANY,				/* PSB       */  		ANY)				/* User tag  */  		OPTIONS (VARIABLE) 		RETURNS (FIXED BIN(31));			   # DCL	PAMS_FREE_MSG		EXTERNAL ENTRY (  		POINTER)			/* Msg_ptr   */ 		RETURNS (FIXED BIN(31));			   $ DCL	PAMS_SET_TIMER		EXTERNAL ENTRY (" 		FIXED BIN(31),			/* Timer_ID  */  		CHAR(1),    			/* Format    */" 		FIXED BIN(31),			/* P_Timeout */ 		ANY)    			/* S_Timeout */ 		RETURNS (FIXED BIN(31));			   & DCL	PAMS_CANCEL_TIMER	EXTERNAL ENTRY (" 		 3   FIXED BIN(31))			/* Timer_ID  */ 		RETURNS (FIXED BIN(31));			   # DCL	PAMS_WAIT_TIMER		EXTERNAL ENTRY  		RETURNS (FIXED BIN(31));			   $ DCL	PAMS_DCL_SYNCH		EXTERNAL ENTRY (" 		FIXED BIN(31),			/* Proc_num  */" 		FIXED BIN(31))			/* Proc_num2 */ 		OPTIONS (VARIABLE) 		RETURNS (FIXED BIN(31));			   $ DCL	PAMS_SET_SYNCH		EXTERNAL ENTRY (( 		BIT(1) ALIGNED)			/* Flush_que_flag */ 		OPTIONS (VARIABLE) 		RETURNS (FIXED BIN(31));			   & DCL	PAMS_CANCEL_SYNCH 	EXTERNAL ENTRY  		RETURNS (FIXED BIN(31) 4   );			   0 DCL     PAMS_CONFIRM_MSG        EXTERNAL ENTRY ( 		ANY,				/* Seq_variable */& 		FIXED BIN(31),			/* Status       */	$ 		FIXED BIN(7))			/* J_override   */ 		RETURNS (FIXED BIN(31));			      /******************** */ %include pams_group; /******************** */ /******************** */ %include pams_processes; /******************** */& /*      End of "PAMS" include file  */ w w         Eʕ P 000010**************************************************************            P 0000 5   20*                                                                         P 000030*    File name: PAIENTCOB.TXT                                             P 000040*    Usage:     COPY PAMS_COB_ENTRY_POINT.                                P 000050*                                                                         P 000060*    NOTE:   These are only examples because COBOL does                   P 000070*            not predefine the call interface.                            P 000080*            6                                                                 P 000090*    Modified:                                                            P 000100*            12-FEB-1988                                                  P 000110*            17-JUN-1988                                                  P 000120*            18-JUL-1988                                                  P 000130*-------------------------------------------------------------            P 000140*                          7                                                   P 000150*CALL PAMS_DCL_PROCESS USING BY REFERENCE                                 P 000160*            PROC_NUM,                        * LONGWORD                  P 000170*            PROC_NUM2                        * LONGWORD                  P 000180*                                                                         P 000190*CALL PAMS_EXIT                                                           P 000200*                                        8                                     P 000210*CALL PAMS_ALLOC_MSG USING BY REFERENCE                                   P 000220*            MSG_SIZE,                        * WORD                      P 000230*            MSG_PTR                          * WORD                      P 000240*                                                                         P 000250*CALL PAMS_SEND_MSG USING BY REFERENCE                                    P 000260*            MSG_POINTER,                     * LONGWO                                                                                                                                                                                                                                                   [                        gJ $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1LE_CLIENT.FOR;11                                                                                                                      % "     8        9   RD                  P 000270*            PRIORITY,                        * BYTE                      P 000280*            SEND_TARGET,                     * LONGWORD                  P 000290*            SEND_CLASS,                      * WORD                      P 000300*            P_TYPE,                          * WORD                      P 000310*            P_DELIVERY,                      * BYTE                      P 000320*            P_TIMEOUT,                       * LONGWORD             :         P 000330*            PSB                              * STRUCTURE                 P 000340*                                                                         P 000350*CALL PAMS_PUT_MSG USING BY REFERENCE                                     P 000360*            MSG_AREA,                        * ARRAY                     P 000370*            PRIORITY,                        * BYTE                      P 000380*            PUT_TARGET,                      * LONGWORD                  P 000390 ;   *            PUT_CLASS,                       * WORD                      P 000400*            PUT_TYPE,                        * WORD                      P 000410*            P_DELIVERY,                      * BYTE                      P 000420*               MSG_SIZE,                        * WORD                   P 000430*            P_TIMEOUT,                       * LONGWORD                  P 000440*            PSB                              * STRUCTURE                 P 000450*              <                                                               P 000460*CALL PAMS_RCV_MSG                                                        P 000470*            MSG_PTR,                         * LONGWORD                  P 000480*            PRIORITY,                        * BYTE                      P 000490*            RCV_SOURCE,                      * LONGWORD                  P 000500*            RCV_CLASS,                       * WORD                      P 000510*            RCV_TYPE,       =                     * WORD                      P 000520*            RCV_LENGTH,                      * WORD                      P 000530*            SEL_ADDR,                        * LONGWORD                  P 000540*            PSB                              * STRUCTURE                 P 000550*                                                                         P 000560*CALL PAMS_RCV_MSGW USING BY REFERENCE                                    P 000570*            MSG_PTR,                      >       * LONGWORD                  P 000580*            PRIORITY,                        * BYTE                      P 000590*            RCV_SOURCE,                      * LONGWORD                  P 000600*            RCV_CLASS,                       * WORD                      P 000610*            RCV_TYPE,                        * WORD                      P 000620*            RCV_LENGTH,                      * WORD                      P 000630*            TIMEOUT,                         * LONGWORD ?                     P 000640*            SEL_ADDR,                        * LONGWORD                  P 000650*            PSB                              * STRUCTURE                 P 000660*                                                                         P 000670*CALL PAMS_GET_MSG USING BY REFERENCE                                     P 000680*            MSG_AREA,                        * ARRAY                     P 000690*            PRIORITY,                        * BYTE                   @       P 000700*            GET_SOURCE,                      * LONGWORD                  P 000710*            GET_CLASS,                       * WORD                      P 000720*            GET_TYPE,                        * WORD                      P 000730*            GET_LENGTH,                      * WORD                      P 000740*            LEN_DATA,                        * WORD                      P 000750*            SEL_ADDR,                        * LONGWORD                  P 000760*  A              PSB                              * STRUCTURE                 P 000770*                                                                         P 000780*CALL PAMS_GET_MSGW USING BY REFERENCE                                    P 000790*            MSG_AREA,                        * ARRAY                     P 000800*            PRIORITY,                        * BYTE                      P 000810*            GET_SOURCE,                      * LONGWORD                  P 000820*            GET B   _CLASS,                       * WORD                      P 000830*            GET_TYPE,                        * WORD                      P 000840*            GET_LENGTH,                      * WORD                      P 000850*            LEN_DATA,                        * WORD                      P 000860*            TIMEOUT,                         * LONGWORD                  P 000870*            SEL_ADDR,                        * LONGWORD                  P 000880*            PSB               C                   * STRUCTURE                 P 000890*                                                                         P 000900*CALL PAMS_FREE_MSG USING BY REFERENCE                                    P 000910*            MSG_PTR                          * LONGWORD                  P 000920*                                                                         P 000930*CALL PAMS_SHOW_MSG USING BY REFERENCE                                    P 000940*            MSG_PTR,                        D     * LONGWORD                  P 000950*            ITEM_BUFFER                      * STRUCTURE                 P 000960*                                                                         P 000970*CALL PAMS_CONFIRM_MSG USING BY REFERENCE                                 P 000980*            SEQ_VARIABLE,                    * QUADWORD                  P 000990*            STATUS_CODE,                     * LONGWORD                  P 001000*            J_OVERRIDE                       * BYTE       E                   P 001010*                                                                         P 001020*CALL PAMS_SET_TIMER USING BY REFERENCE                                   P 001030*            TIMER_ID,                        * LONGWORD                  P 001040*            TIMER_FORMAT,                    * CHARACTER                 P 001050*            P_TIMEOUT,                       * LONGWORD                  P 001060*            S_TIMEOUT                        * ARRAY                    F     P 001070*                                                                         P 001080*CALL PAMS_CANCEL_TIMER USING BY REFERENCE                                P 001090*            TIMER_ID                         * LONGWORD                  P 001100*                                                                         P 001110*CALL PAMS_WAIT_TIMER                                                     P 001120*                                                                         P 001130*CAL G   L PAMS_DCL_SYNCH USING BY REFERENCE                                   P 001140*            PROC_NUM,                        * LONGWORD                  P 001150*            PROC_NUM2                        * LONGWORD                  P 001160*                                                                         P 001170*CALL PAMS_SET_SYNCH USING BY REFERENCE                                   P 001180*            FLUSH_QUE_FLAG                   * BYTE                      P 001190*                  H                                                           P 001200*CALL PAMS_CANCEL_SYNCH                                                   P 001210*                                                                         P 001220*CALL PAMS_CANCEL_SELECT USING BY REFERENCE                               P 001230*            INDEX_HANDLE                     * LONGWORD                  P 001240*                                                                         P 001250*CALL PAMS_SET_SELECT USING BY R I   EFERENCE                                  P 001260*            SELECTION_ARRAY,                 * ARRAY                     P 001270*            NUM_MASKS,                       * BYTE                      P 001280*            INDEX_HANDLE                     * LONGWORD                  P 001290*                                                                         P 001300*CALL PUTIL_SHOW_PENDING USING BY REFERENCE                               P 001310*            P_COUNT,                                                                                                                                                                                                                                                                            \                        t $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1LE_SERVER.ADA;1A;1                                                                                                                     "     I        J   * LONGWORD                  P 001320*            IN_Q_LIST,                       * ARRAY OF WORDS            P 001330*            OUT_PEND_LIST                    * ARRAY OF LONGWORDS        P 001340*                                                                         P 001350*CALL PUTIL_PRINT_STS USING BY REFERENCE                                  P 001360*            PROCESS_NAME,                    * STRING                    P 001370*            MSG_TEXT,                        * STRING      	 K                 P 001380*            STATUS_CODE                      * LONGWORD                  P 001390*                                                                         P 001400*---------------- End of PAMS_COB_ENTRY_POINT -----------------            w w         \ ʕ P 000010*  Include file name: PAMS_COB_GROUP                                      P 000020*  File name: PAIGRPCOB.TXT                                               P 000030*  Usage: COPY PAMS_COB_GROUP.                    	 L                           P 000040*                                                                         P 000050 01 PAMS_GROUP_ONE              PIC S9(9) USAGE COMP VALUE      1.        P 000060 01 PAMS_GROUP_TWO              PIC S9(9) USAGE COMP VALUE      2.        P 000070 01 PAMS_GROUP_MVII             PIC S9(9) USAGE COMP VALUE     75.        P 000080 01 PAMS_GROUP_PC               PIC S9(9) USAGE COMP VALUE    122.         w w        ȝʕ P 000010*  Include file name: PAMS_COB_PROCESS   M                                     P 000020*  File name: PAIPRCCOB.TXT                                               P 000030*  Usage: COPY PAMS_COB_PROCESs.                                          P 000040*                                                                         P 000050* */                                                                      P 000060*                          Rcv Msg    UCB   Q      Q     Perm    N        P 000070*                          ame   Check*/               N                       P 000080*     Queue Name       Num  Quota    Send  Type  Owner  Active  Sc        P 000090*     ope    ACL*/                                                        P 000100* -------------------  ---  -----    ----  ----  -----  ------  --        P 000110* ---   -----*/                                                           P 000120*    Sample Queues*/                                                      P 000130 01 PAMS_QUEUE_1                     PIC S9(9) USAGE COMP VALUE      O         P 000140      1.                                                                  P 000150 01 PAMS_QUEUE_2                     PIC S9(9) USAGE COMP VALUE           P 000160      2.                                                                  P 000170 01 PAMS_QUEUE_3                     PIC S9(9) USAGE COMP VALUE           P 000180      3.                                                                  P 000190 01 PAMS_QUEUE_4                     PIC S9(9) USAGE COMP VALUE           P 000200 P         4.                                                                  P 000210 01 PAMS_QUEUE_5                     PIC S9(9) USAGE COMP VALUE           P 000220      5.                                                                  P 000230 01 PAMS_QUEUE_6                     PIC S9(9) USAGE COMP VALUE           P 000240      6.                                                                  P 000250 01 PAMS_QUEUE_7                     PIC S9(9) USAGE COMP VALUE           P 000260      7.       Q                                                               P 000270 01 PAMS_QUEUE_8                     PIC S9(9) USAGE COMP VALUE           P 000280      8.                                                                  P 000290 01 PAMS_QUEUE_9                     PIC S9(9) USAGE COMP VALUE           P 000300      9.                                                                  P 000310 01 PAMS_QUEUE_10                     PIC S9(9) USAGE COMP VALUE          P 000320      10.                    R                                                 P 000330* */                                                                      P 000340*   SBS Server uses the following UCB numbers for Optimized Delive        P 000350*   ry*/                                                                  P 000360* */                                                                      P 000370 01 PAMS_SBS_ETH_CONTROL                 PIC S9(9) USAGE COMP VALU        P 000380-    E   74.                               S                                   P 000390 01 PAMS_SBS_ETH_CHAN1                   PIC S9(9) USAGE COMP VALU        P 000400-    E   75.                                                              P 000410 01 PAMS_SBS_ETH_CHAN2                   PIC S9(9) USAGE COMP VALU        P 000420-    E                                                         76.        P 000430* */                                                                      P 000440*   The following are for the DECmessageQ demo in [DMQ$V T   nn.demo.vm        P 000450*   s]*/                                                                  P 000460* */                                                                      P 000470 01 PAMS_DEMO_IO_SERVER_1                PIC S9(9) USAGE COMP VALU        P 000480-    E  101.                                                              P 000490 01 PAMS_DEMO_IO_SERVER_2                PIC S9(9) USAGE COMP VALU        P 000500-    E  102.                                                           U       P 000510 01 PAMS_DEMO_IO_SERVER_3                PIC S9(9) USAGE COMP VALU        P 000520-    E  103.                                                              P 000530 01 PAMS_DEMO_IO_SERVER_4                PIC S9(9) USAGE COMP VALU        P 000540-    E  104.                                                              P 000550 01 PAMS_DEMO_IO_SERVER_MRQ              PIC S9(9) USAGE COMP VALU        P 000560-    E  105.                                                              P 000570 0 V   1 PAMS_DEMO_ARCHIVE                    PIC S9(9) USAGE COMP VALU        P 000580-    E  106.                                                              P 000590 01 PAMS_DEMO_IO_BROADCAST_1             PIC S9(9) USAGE COMP VALU        P 000600-    E 5101.                                                              P 000610 01 PAMS_DEMO_IO_BROADCAST_2             PIC S9(9) USAGE COMP VALU        P 000620-    E                                                       5102.        P 000630* */             W                                                             P 000640*   Queues 90-100 & 150-199 are reserved for DECmessageQ utilities        P 000650*   */                                                                    P 000660 01 PAMS_SCREEN_PROCESS                  PIC S9(9) USAGE COMP VALU        P 000670-    E    0.                                                              P 000680 01 PAMS_TEMPORARY_Q                     PIC S9(9) USAGE COMP VALU        P 000690-    E    0.                   X                                               P 000700 01 PAMS_SPARE1                     PIC S9(9) USAGE COMP VALUE   9        P 000710-    0.                                                                   P 000720 01 PAMS_ALL_UCBS                     PIC S9(9) USAGE COMP VALUE          P 000730      91.                                                                 P 000740 01 PAMS_TIMER_QUEUE                     PIC S9(9) USAGE COMP VALU        P 000750-    E   92.                                 Y                                 P 000760 01 PAMS_NULL                     PIC S9(9) USAGE COMP VALUE   93.        P 000770 01 PAMS_INTERNAL1                     PIC S9(9) USAGE COMP VALUE         P 000780       94.                                                                P 000790 01 PAMS_QTRANSFER_SERVER                PIC S9(9) USAGE COMP VALU        P 000800-    E   95.                                                              P 000810 01 PAMS_DEAD_LETTER_QUEUE               PIC S9(9) USAGE C Z   OMP VALU        P 000820-    E   96.                                                              P 000830 01 PAMS_MRS_SERVER                     PIC S9(9) USAGE COMP VALUE        P 000840        98.                                                               P 000850 01 PAMS_AVAIL_SERVER                    PIC S9(9) USAGE COMP VALU        P 000860-    E   99.                                                              P 000870 01 PAMS_SBS_SERVER                     PIC S9(9) USAGE COMP VALUE                                                                                                                                                                                                                                                         ]                         $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1LE_SERVER.C;1ADA;1                                                                                                                    ܝ "     Z        [     P 000880        99.                                                               P 000890 01 PAMS_DECLARE_SERVER                  PIC S9(9) USAGE COMP VALU        P 000900-    E  100.                                                              P 000910 01 PAMS_CONNECT_SERVER                  PIC S9(9) USAGE COMP VALU        P 000920-    E  100.                                                              P 000930 01 PAMS_QUEUE_SERVER                    PIC S9(9) USAGE COMP VALU        P 000940-    \    E  100.                                                              P 000950 01 PAMS_PAMS_TRANSPORT                  PIC S9(9) USAGE COMP VALU        P 000960-    E  100.                                                              P 000970 01 PAMS_COM_SERVER                     PIC S9(9) USAGE COMP VALUE        P 000980       100.                                                               P 000990 01 PAMS_DMQ_LOADER                     PIC S9(9) USAGE COMP VALUE        P 001000       150.        ]                                                           P 001010 01 PAMS_DCL_BY_Q_NAME                   PIC S9(9) USAGE COMP VALU        P 001020-    E  151.                                                              P 001030 01 PAMS_TCPIP_LINK_DRIVER               PIC S9(9) USAGE COMP VALU        P 001040-    E  152.                                                              P 001050 01 PAMS_DMQ_FULLTEST_PQ                 PIC S9(9) USAGE COMP VALU        P 001060-    E  191.                    	 ^                                             P 001070 01 PAMS_DMQ_FULLTEST_SQ                 PIC S9(9) USAGE COMP VALU        P 001080-    E                                                        192.        P 001090* */                                                                       w w         uʕ P 000010* *********************************************                           P 000020*  Include file name: PAMS_COB_RETURN_STATUS                              P 000030*  File name: PAISTSCO _   B.TXT                                               P 000040*  Usage: COPY PAMS_COB_RETURN_STATUS.                                    P 000050*                                                                         P 000060 01 PAMS__SUCCESS             pic s9(9) comp global.                      P 000070 01 PAMS__DISCL_SUCCESS       pic s9(9) comp global.                      P 000080 01 PAMS__DISC_SUCCESS        pic s9(9) comp global.                      P 000090 01 PAMS__DLJ_SUCCESS         pic s9 `   (9) comp global.                      P 000100 01 PAMS__DLQ_SUCCESS         pic s9(9) comp global.                      P 000110 01 PAMS__MSG                 pic s9(9) comp global.                      P 000120 01 PAMS__RECOVERMODE         pic s9(9) comp global.                      P 000130 01 PAMS__RTS_SUCCESS         pic s9(9) comp global.                      P 000140 01 PAMS__SAF_SUCCESS         pic s9(9) comp global.                      P 000150 01 PAMS__CONFIRMREQ          pic s9(9) comp globa a   l.                      P 000160 01 PAMS__ENQUEUED            pic s9(9) comp global.                      P 000170 01 PAMS__MSGACT              pic s9(9) comp global.                      P 000180 01 PAMS__NOMOREMSG           pic s9(9) comp global.                      P 000190 01 PAMS__NOMSG               pic s9(9) comp global.                      P 000200 01 PAMS__NOSEND              pic s9(9) comp global.                      P 000210 01 PAMS__NO_UMA              pic s9(9) comp global.             b             P 000220 01 PAMS__PROPAGATE           pic s9(9) comp global.                      P 000230 01 PAMS__STORED              pic s9(9) comp global.                      P 000240 01 PAMS__TIMERACT            pic s9(9) comp global.                      P 000250 01 PAMS__TRACEBACK           pic s9(9) comp global.                      P 000260 01 PAMS__UMA_NA              pic s9(9) comp global.                      P 000270 01 PAMS__UNATTACHEDQ         pic s9(9) comp global.                      P 00 c   0280 01 PAMS__WAKEFAIL            pic s9(9) comp global.                      P 000290 01 PAMS__JOURNAL_ON          pic s9(9) comp global.                      P 000300 01 PAMS__LINK_UP             pic s9(9) comp global.                      P 000310 01 PAMS__ABORT               pic s9(9) comp global.                      P 000320 01 PAMS__ACKTMO              pic s9(9) comp global.                      P 000330 01 PAMS__BADDECLARE          pic s9(9) comp global.                      P 000340 01 PAMS__ d   BADFREE             pic s9(9) comp global.                      P 000350 01 PAMS__BUFFEROVF           pic s9(9) comp global.                      P 000360 01 PAMS__CANCEL              pic s9(9) comp global.                      P 000370 01 PAMS__ENDOFSOURCE         pic s9(9) comp global.                      P 000380 01 PAMS__EXCMAXUNCONF        pic s9(9) comp global.                      P 000390 01 PAMS__EX_Q_LEN            pic s9(9) comp global.                      P 000400 01 PAMS__MRQTBLFULL     e         pic s9(9) comp global.                      P 000410 01 PAMS__MSGUNDEL            pic s9(9) comp global.                      P 000420 01 PAMS__NOOBJECT            pic s9(9) comp global.                      P 000430 01 PAMS__NOTYETIMP           pic s9(9) comp global.                      P 000440 01 PAMS__OBJNOTACTIVE        pic s9(9) comp global.                      P 000450 01 PAMS__POSSDUPL            pic s9(9) comp global.                      P 000460 01 PAMS__SENDER_TMO_EXPIRED  pic s9(9 f   ) comp global.                      P 000470 01 PAMS__STUB                pic s9(9) comp global.                      P 000480 01 PAMS__TIMEOUT             pic s9(9) comp global.                      P 000490 01 PAMS__SAF_FORCED          pic s9(9) comp global.                      P 000500 01 PAMS__AMBIG               pic s9(9) comp global.                      P 000510 01 PAMS__AREATOSMALL         pic s9(9) comp global.                      P 000520 01 PAMS__BADARGLIST          pic s9(9) comp global. g                         P 000530 01 PAMS__BADCMD              pic s9(9) comp global.                      P 000540 01 PAMS__BADDELIVERY         pic s9(9) comp global.                      P 000550 01 PAMS__BADJOURNAL          pic s9(9) comp global.                      P 000560 01 PAMS__BADLOGIC            pic s9(9) comp global.                      P 000570 01 PAMS__BADNAME             pic s9(9) comp global.                      P 000580 01 PAMS__BADPARAM            pic s9(9) comp global.               h           P 000590 01 PAMS__BADPRIORITY         pic s9(9) comp global.                      P 000600 01 PAMS__BADPROCNUM          pic s9(9) comp global.                      P 000610 01 PAMS__BADRECEIVE          pic s9(9) comp global.                      P 000620 01 PAMS__BADRESPQ            pic s9(9) comp global.                      P 000630 01 PAMS__BADSELIDX           pic s9(9) comp global.                      P 000640 01 PAMS__BADSEQ              pic s9(9) comp global.                      P 0006 i   50 01 PAMS__BADSYNCHNUM         pic s9(9) comp global.                      P 000660 01 PAMS__BADTAG              pic s9(9) comp global.                      P 000670 01 PAMS__BADTBQHANDLE        pic s9(9) comp global.                      P 000680 01 PAMS__BADTIME             pic s9(9) comp global.                      P 000690 01 PAMS__BADTMPPROC          pic s9(9) comp global.                      P 000700 01 PAMS__BADTMPSYNCH         pic s9(9) comp global.                      P 000710 01 PAMS__BA j   DUMA              pic s9(9) comp global.                      P 000720 01 PAMS__BIGBLKSIZE          pic s9(9) comp global.                      P 000730 01 PAMS__BIGMSG              pic s9(9) comp global.                      P 000740 01 PAMS__CIRACT              pic s9(9) comp global.                      P 000750 01 PAMS__COMMERR             pic s9(9) comp global.                      P 000760 01 PAMS__DISCL_FAILED        pic s9(9) comp global.                      P 000770 01 PAMS__DISC_FAILED      k       pic s9(9) comp global.                      P 000780 01 PAMS__DLJ_FAILED          pic s9(9) comp global.                      P 000790 01 PAMS__DLQ_FAILED          pic s9(9) comp global.                      P 000800 01 PAMS__DNSCLASSBAD         pic s9(9) comp global.                      P 000810 01 PAMS__DNSDIRFAIL          pic s9(9) comp global.                      P 000820 01 PAMS__DNSFMTBAD           pic s9(9) comp global.                      P 000830 01 PAMS__DQF_DEVICE_FAIL     pic s9(9)                                                                                                                                                                                                                                                    ^                        ~8 $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1LE_SERVER.C;1                                                                                                                         NM "     k        l   comp global.                      P 000840 01 PAMS__DQF_FULL            pic s9(9) comp global.                      P 000850 01 PAMS__DUPLMSGCLASS        pic s9(9) comp global.                      P 000860 01 PAMS__DUPLMSGFROM         pic s9(9) comp global.                      P 000870 01 PAMS__DUPLMSGTO           pic s9(9) comp global.                      P 000880 01 PAMS__DUPLMSGTYPE         pic s9(9) comp global.                      P 000890 01 PAMS__DUPLQNAME           pic s9(9) comp global.   m                       P 000900 01 PAMS__ERRORS              pic s9(9) comp global.                      P 000910 01 PAMS__EXCEEDQUOTA         pic s9(9) comp global.                      P 000920 01 PAMS__EXTRA               pic s9(9) comp global.                      P 000930 01 PAMS__IDXTBLFULL          pic s9(9) comp global.                      P 000940 01 PAMS__INVACCESS           pic s9(9) comp global.                      P 000950 01 PAMS__INVALIDID           pic s9(9) comp global.                 n         P 000960 01 PAMS__INVALIDNUM          pic s9(9) comp global.                      P 000970 01 PAMS__INVBUFFPTR          pic s9(9) comp global.                      P 000980 01 PAMS__INVFORMAT           pic s9(9) comp global.                      P 000990 01 PAMS__INVJH               pic s9(9) comp global.                      P 001000 01 PAMS__INVUCBCNTRL         pic s9(9) comp global.                      P 001010 01 PAMS__INVUMA              pic s9(9) comp global.                      P 001020 o    01 PAMS__IVDATAFORMAT        pic s9(9) comp global.                      P 001030 01 PAMS__IVDATATYPE          pic s9(9) comp global.                      P 001040 01 PAMS__IVECHOLIM           pic s9(9) comp global.                      P 001050 01 PAMS__IVLOGLIM            pic s9(9) comp global.                      P 001060 01 PAMS__IVMSGCLASS          pic s9(9) comp global.                      P 001070 01 PAMS__IVMSGJOU            pic s9(9) comp global.                      P 001080 01 PAMS__IVMS p   GPRI            pic s9(9) comp global.                      P 001090 01 PAMS__IVMSGSRC            pic s9(9) comp global.                      P 001100 01 PAMS__IVMSGTARG           pic s9(9) comp global.                      P 001110 01 PAMS__IVMSGTYPE           pic s9(9) comp global.                      P 001120 01 PAMS__IVREPVAL            pic s9(9) comp global.                      P 001130 01 PAMS__IVSETKEY            pic s9(9) comp global.                      P 001140 01 PAMS__IVSETLOG           q     pic s9(9) comp global.                      P 001150 01 PAMS__IVSETSR             pic s9(9) comp global.                      P 001160 01 PAMS__IVSETSRWHO          pic s9(9) comp global.                      P 001170 01 PAMS__IVTIME              pic s9(9) comp global.                      P 001180 01 PAMS__LINK_DOWN           pic s9(9) comp global.                      P 001190 01 PAMS__LOGFOPENFAI         pic s9(9) comp global.                      P 001200 01 PAMS__LOGFWRITERR         pic s9(9) co r   mp global.                      P 001210 01 PAMS__MISENDC             pic s9(9) comp global.                      P 001220 01 PAMS__MISENDR             pic s9(9) comp global.                      P 001230 01 PAMS__MISEOM              pic s9(9) comp global.                      P 001240 01 PAMS__MISQUOTE            pic s9(9) comp global.                      P 001250 01 PAMS__MISREPEAT           pic s9(9) comp global.                      P 001260 01 PAMS__MRS_RES_EXH         pic s9(9) comp global.     s                     P 001270 01 PAMS__MSGCONTENT          pic s9(9) comp global.                      P 001280 01 PAMS__MSGFMT              pic s9(9) comp global.                      P 001290 01 PAMS__MSGTOBIG            pic s9(9) comp global.                      P 001300 01 PAMS__MSGTOOLONG          pic s9(9) comp global.                      P 001310 01 PAMS__MSGTOSMALL          pic s9(9) comp global.                      P 001320 01 PAMS__NAMETOOLONG         pic s9(9) comp global.                   t       P 001330 01 PAMS__NOCANSEND           pic s9(9) comp global.                      P 001340 01 PAMS__NOLINK              pic s9(9) comp global.                      P 001350 01 PAMS__NOLOGFILE           pic s9(9) comp global.                      P 001360 01 PAMS__NOMOREJH            pic s9(9) comp global.                      P 001370 01 PAMS__NOMRQRESRC          pic s9(9) comp global.                      P 001380 01 PAMS__NOMRS               pic s9(9) comp global.                      P 001390 0 u   1 PAMS__NOMSGCLASS          pic s9(9) comp global.                      P 001400 01 PAMS__NOMSGFROM           pic s9(9) comp global.                      P 001410 01 PAMS__NOMSGTO             pic s9(9) comp global.                      P 001420 01 PAMS__NOMSGTYPE           pic s9(9) comp global.                      P 001430 01 PAMS__NOSUCHPCJ           pic s9(9) comp global.                      P 001440 01 PAMS__NOTACTIVE           pic s9(9) comp global.                      P 001450 01 PAMS__NOTALL v   OCATE         pic s9(9) comp global.                      P 001460 01 PAMS__NOTASTMT            pic s9(9) comp global.                      P 001470 01 PAMS__NOTDCL              pic s9(9) comp global.                      P 001480 01 PAMS__NOTDECIMAL          pic s9(9) comp global.                      P 001490 01 PAMS__NOTHEX              pic s9(9) comp global.                      P 001500 01 PAMS__NOTJRN              pic s9(9) comp global.                      P 001510 01 PAMS__NOTOCTAL             w   pic s9(9) comp global.                      P 001520 01 PAMS__NO_DQF              pic s9(9) comp global.                      P 001530 01 PAMS__NO_SAF              pic s9(9) comp global.                      P 001540 01 PAMS__PNUMNOEXIST         pic s9(9) comp global.                      P 001550 01 PAMS__PROTOCOL            pic s9(9) comp global.                      P 001560 01 PAMS__REJECTED            pic s9(9) comp global.                      P 001570 01 PAMS__RESPQREQ            pic s9(9) comp x    global.                      P 001580 01 PAMS__RESRCFAIL           pic s9(9) comp global.                      P 001590 01 PAMS__RTS_FAILED          pic s9(9) comp global.                      P 001600 01 PAMS__SAF_DEVICE_FAIL     pic s9(9) comp global.                      P 001610 01 PAMS__SAF_FAILED          pic s9(9) comp global.                      P 001620 01 PAMS__SELRCVACT           pic s9(9) comp global.                      P 001630 01 PAMS__STATECHANGE         pic s9(9) comp global.       y                   P 001640 01 PAMS__STRINGTOOLONG       pic s9(9) comp global.                      P 001650 01 PAMS__SYNTAX              pic s9(9) comp global.                      P 001660 01 PAMS__TOOMANYLOGF         pic s9(9) comp global.                      P 001670 01 PAMS__TOOMANYREPEAT       pic s9(9) comp global.                      P 001680 01 PAMS__TOOMANYSETS         pic s9(9) comp global.                      P 001690 01 PAMS__UCBERROR            pic s9(9) comp global.                     z     P 001700 01 PAMS__VALUEOVERFL         pic s9(9) comp global.                      P 001710 01 PAMS__ZEROREPEAT          pic s9(9) comp global.                      P 001720 01 PAMS__BADQTYPE            pic s9(9) comp global.                      P 001730 01 PAMS__JOURNAL_FAIL        pic s9(9) comp global.                      P 001740 01 PAMS__JOURNAL_FULL        pic s9(9) comp global.                      P 001750 01 PAMS__NETERROR            pic s9(9) comp global.                      P 001760 01  {   PAMS__NETLINKLOST         pic s9(9) comp global.                      P 001770 01 PAMS__BADASSIGN           pic s9(9) comp global.                      P 001780 01 PAMS__BADASTPARM          pic s9(9) comp global.                      P 001790 01 PAMS__BADMSGBUF           pic s9(9) comp global.                      P 001800 01 PAMS__BADSCRIPT           pic s9(9) comp global.                      P 001810 01 PAMS__CREATEFAIL          pic s9(9) comp global.                      P 001820 01 PAMS__DCLTMPFA |   IL          pic s9(9) comp global.                      P 001830 01 PAMS__DECLARED            pic s9(9) comp global.                      P 001840 01 PAMS__EXHAUSTBLKS         pic s9(9) comp global.                      P 001850 01 PAMS__INSQUEFAIL          pic s9(9) comp global.                      P 001860 01 PAMS__INTERNAL            pic s9(9) comp global.                      P 001870 01 PAMS__LOGNAME             pic s9(9) comp global.                      P 001880 01 PAMS__LOGNAME2            pi                                                                                                                                                                                                                                                   _                         $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1LE_SERVER.FOR;1                                                                                                                        "     |        }   c s9(9) comp global.                      P 001890 01 PAMS__LOGNAME3            pic s9(9) comp global.                      P 001900 01 PAMS__LOGNAME4            pic s9(9) comp global.                      P 001910 01 PAMS__LOGNAME5            pic s9(9) comp global.                      P 001920 01 PAMS__NOOPEN              pic s9(9) comp global.                      P 001930 01 PAMS__NOPRIV              pic s9(9) comp global.                      P 001940 01 PAMS__NOQUOTA             pic s9(9) comp g ~   lobal.                      P 001950 01 PAMS__NOTPRIMARYQ         pic s9(9) comp global.                      P 001960 01 PAMS__NOTSECONDARYQ       pic s9(9) comp global.                      P 001970 01 PAMS__NOTSUPPORTED        pic s9(9) comp global.                      P 001980 01 PAMS__PAMSDOWN            pic s9(9) comp global.                      P 001990 01 PAMS__QUECORRUPT          pic s9(9) comp global.                      P 002000 01 PAMS__REMQUEFAIL          pic s9(9) comp global.        	                  P 002010 01 PAMS__NOACL               pic s9(9) comp global.                      P 002020 01 PAMS__NOACCESS            pic s9(9) comp global.                      P 002030 01 PAMS__BADINITFILE         pic s9(9) comp global.                      P 002040 01 PAMS__NETNOLINK           pic s9(9) comp global.                       w w        
ʕ P 000010                                                                          P 000020* *** MODULE PAMS_COB_RETURN_STATUS_DEF ***/                                  P 000030 01 PAMS_FACILITY  PIC S9(9) USAGE COMP VALUE 2132.                       P 000040 01 PAMS__SUCCESS  PIC S9(9) USAGE COMP VALUE 1.                          P 000050 01 PAMS__DISCL_SUCCESS  PIC S9(9) USAGE COMP VALUE 139755529.            P 000060 01 PAMS__DISC_SUCCESS  PIC S9(9) USAGE COMP VALUE 139755537.             P 000070 01 PAMS__DLJ_SUCCESS  PIC S9(9) USAGE COMP VALUE 139755545.              P 000080 01 PAMS__DLQ_SUCCESS  PIC S9(9) USAGE COMP VALUE 139755553.                  P 000090 01 PAMS__MSG  PIC S9(9) USAGE COMP VALUE 139755561.                      P 000100 01 PAMS__RECOVERMODE  PIC S9(9) USAGE COMP VALUE 139755569.              P 000110 01 PAMS__RTS_SUCCESS  PIC S9(9) USAGE COMP VALUE 139755577.              P 000120 01 PAMS__SAF_SUCCESS  PIC S9(9) USAGE COMP VALUE 139755585.              P 000130 01 PAMS__CONFIRMREQ  PIC S9(9) USAGE COMP VALUE 139756323.               P 000140 01 PAMS__ENQUEUED  PIC S9(9) USAGE COMP VALUE 139756331.                 P 00    0150 01 PAMS__MSGACT  PIC S9(9) USAGE COMP VALUE 139756339.                   P 000160 01 PAMS__NOMOREMSG  PIC S9(9) USAGE COMP VALUE 139756347.                P 000170 01 PAMS__NOMSG  PIC S9(9) USAGE COMP VALUE 139756355.                    P 000180 01 PAMS__NOSEND  PIC S9(9) USAGE COMP VALUE 139756363.                   P 000190 01 PAMS__NO_UMA  PIC S9(9) USAGE COMP VALUE 139756371.                   P 000200 01 PAMS__PROPAGATE  PIC S9(9) USAGE COMP VALUE 139756379.                P 000210 01 PAMS__    STORED  PIC S9(9) USAGE COMP VALUE 139756387.                   P 000220 01 PAMS__TIMERACT  PIC S9(9) USAGE COMP VALUE 139756395.                 P 000230 01 PAMS__TRACEBACK  PIC S9(9) USAGE COMP VALUE 139756403.                P 000240 01 PAMS__UMA_NA  PIC S9(9) USAGE COMP VALUE 139756411.                   P 000250 01 PAMS__UNATTACHEDQ  PIC S9(9) USAGE COMP VALUE 139756419.              P 000260 01 PAMS__WAKEFAIL  PIC S9(9) USAGE COMP VALUE 139756427.                 P 000270 01 PAMS__JOURNAL_ON  PI    C S9(9) USAGE COMP VALUE 139756435.               P 000280 01 PAMS__LINK_UP  PIC S9(9) USAGE COMP VALUE 139756443.                  P 000290 01 PAMS__ABORT  PIC S9(9) USAGE COMP VALUE 139757120.                    P 000300 01 PAMS__ACKTMO  PIC S9(9) USAGE COMP VALUE 139757128.                   P 000310 01 PAMS__BADDECLARE  PIC S9(9) USAGE COMP VALUE 139757136.               P 000320 01 PAMS__BADFREE  PIC S9(9) USAGE COMP VALUE 139757144.                  P 000330 01 PAMS__BUFFEROVF  PIC S9(9) USAGE C    OMP VALUE 139757152.                P 000340 01 PAMS__CANCEL  PIC S9(9) USAGE COMP VALUE 139757160.                   P 000350 01 PAMS__ENDOFSOURCE  PIC S9(9) USAGE COMP VALUE 139757168.              P 000360 01 PAMS__EXCMAXUNCONF  PIC S9(9) USAGE COMP VALUE 139757176.             P 000370 01 PAMS__EX_Q_LEN  PIC S9(9) USAGE COMP VALUE 139757184.                 P 000380 01 PAMS__MRQTBLFULL  PIC S9(9) USAGE COMP VALUE 139757192.               P 000390 01 PAMS__MSGUNDEL  PIC S9(9) USAGE COMP VALUE 13975    7200.                 P 000400 01 PAMS__NOOBJECT  PIC S9(9) USAGE COMP VALUE 139757208.                 P 000410 01 PAMS__NOTYETIMP  PIC S9(9) USAGE COMP VALUE 139757216.                P 000420 01 PAMS__OBJNOTACTIVE  PIC S9(9) USAGE COMP VALUE 139757224.             P 000430 01 PAMS__POSSDUPL  PIC S9(9) USAGE COMP VALUE 139757232.                 P 000440 01 PAMS__SENDER_TMO_EXPIRED  PIC S9(9) USAGE COMP VALUE 139757240        P 000450-    .                                                                        P 000460 01 PAMS__STUB  PIC S9(9) USAGE COMP VALUE 139757248.                     P 000470 01 PAMS__TIMEOUT  PIC S9(9) USAGE COMP VALUE 139757256.                  P 000480 01 PAMS__SAF_FORCED  PIC S9(9) USAGE COMP VALUE 139757264.               P 000490 01 PAMS__AMBIG  PIC S9(9) USAGE COMP VALUE 139758722.                    P 000500 01 PAMS__AREATOSMALL  PIC S9(9) USAGE COMP VALUE 139758730.              P 000510 01 PAMS__BADARGLIST  PIC S9(9) USAGE COMP VALUE 139758738.               P 0005    20 01 PAMS__BADCMD  PIC S9(9) USAGE COMP VALUE 139758746.                   P 000530 01 PAMS__BADDELIVERY  PIC S9(9) USAGE COMP VALUE 139758754.              P 000540 01 PAMS__BADJOURNAL  PIC S9(9) USAGE COMP VALUE 139758762.               P 000550 01 PAMS__BADLOGIC  PIC S9(9) USAGE COMP VALUE 139758770.                 P 000560 01 PAMS__BADNAME  PIC S9(9) USAGE COMP VALUE 139758778.                  P 000570 01 PAMS__BADPARAM  PIC S9(9) USAGE COMP VALUE 139758786.                 P 000580 01 PAMS__BA    DPRIORITY  PIC S9(9) USAGE COMP VALUE 139758794.              P 000590 01 PAMS__BADPROCNUM  PIC S9(9) USAGE COMP VALUE 139758802.               P 000600 01 PAMS__BADRECEIVE  PIC S9(9) USAGE COMP VALUE 139758810.               P 000610 01 PAMS__BADRESPQ  PIC S9(9) USAGE COMP VALUE 139758818.                 P 000620 01 PAMS__BADSELIDX  PIC S9(9) USAGE COMP VALUE 139758826.                P 000630 01 PAMS__BADSEQ  PIC S9(9) USAGE COMP VALUE 139758834.                   P 000640 01 PAMS__BADSYNCHNUM  PIC     S9(9) USAGE COMP VALUE 139758842.              P 000650 01 PAMS__BADTAG  PIC S9(9) USAGE COMP VALUE 139758850.                   P 000660 01 PAMS__BADTBQHANDLE  PIC S9(9) USAGE COMP VALUE 139758858.             P 000670 01 PAMS__BADTIME  PIC S9(9) USAGE COMP VALUE 139758866.                  P 000680 01 PAMS__BADTMPPROC  PIC S9(9) USAGE COMP VALUE 139758874.               P 000690 01 PAMS__BADTMPSYNCH  PIC S9(9) USAGE COMP VALUE 139758882.              P 000700 01 PAMS__BADUMA  PIC S9(9) USAGE COMP V    ALUE 139758890.                   P 000710 01 PAMS__BIGBLKSIZE  PIC S9(9) USAGE COMP VALUE 139758898.               P 000720 01 PAMS__BIGMSG  PIC S9(9) USAGE COMP VALUE 139758906.                   P 000730 01 PAMS__CIRACT  PIC S9(9) USAGE COMP VALUE 139758914.                   P 000740 01 PAMS__COMMERR  PIC S9(9) USAGE COMP VALUE 139758922.                  P 000750 01 PAMS__DISCL_FAILED  PIC S9(9) USAGE COMP VALUE 139758930.             P 000760 01 PAMS__DISC_FAILED  PIC S9(9) USAGE COMP VALUE 1397    58938.              P 000770 01 PAMS__DLJ_FAILED  PIC S9(9) USAGE COMP VALUE 139758946.               P 000780 01 PAMS__DLQ_FAILED  PIC S9(9) USAGE COMP VALUE 139758954.               P 000790 01 PAMS__DNSCLASSBAD  PIC S9(9) USAGE COMP VALUE 139758962.              P 000800 01 PAMS__DNSDIRFAIL  PIC S9(9) USAGE COMP VALUE 139758970.               P 000810 01 PAMS__DNSFMTBAD  PIC S9(9) USAGE COMP VALUE 139758978.                P 000820 01 PAMS__DQF_DEVICE_FAIL  PIC S9(9) USAGE COMP VALUE 139758986.              P 000830 01 PAMS__DQF_FULL  PIC S9(9) USAGE COMP VALUE 139758994.                 P 000840 01 PAMS__DUPLMSGCLASS  PIC S9(9) USAGE COMP VALUE 139759002.             P 000850 01 PAMS__DUPLMSGFROM  PIC S9(9) USAGE COMP VALUE 139759010.              P 000860 01 PAMS__DUPLMSGTO  PIC S9(9) USAGE COMP VALUE 139759018.                P 000870 01 PAMS__DUPLMSGTYPE  PIC S9(9) USAGE COMP VALUE 139759026.              P 000880 01 PAMS__DUPLQNAME  PIC S9(9) USAGE COMP VALUE 139759034.                P 000890                                                                                                                                                                                                                                                   `                         $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1T.C;1MSGDEF.H;1                                                                                                                        "                 01 PAMS__ERRORS  PIC S9(9) USAGE COMP VALUE 139759042.                   P 000900 01 PAMS__EXCEEDQUOTA  PIC S9(9) USAGE COMP VALUE 139759050.              P 000910 01 PAMS__EXTRA  PIC S9(9) USAGE COMP VALUE 139759058.                    P 000920 01 PAMS__IDXTBLFULL  PIC S9(9) USAGE COMP VALUE 139759066.               P 000930 01 PAMS__INVACCESS  PIC S9(9) USAGE COMP VALUE 139759074.                P 000940 01 PAMS__INVALIDID  PIC S9(9) USAGE COMP VALUE 139759082.                P 000950 01 PAMS__INVA    LIDNUM  PIC S9(9) USAGE COMP VALUE 139759090.               P 000960 01 PAMS__INVBUFFPTR  PIC S9(9) USAGE COMP VALUE 139759098.               P 000970 01 PAMS__INVFORMAT  PIC S9(9) USAGE COMP VALUE 139759106.                P 000980 01 PAMS__INVJH  PIC S9(9) USAGE COMP VALUE 139759114.                    P 000990 01 PAMS__INVUCBCNTRL  PIC S9(9) USAGE COMP VALUE 139759122.              P 001000 01 PAMS__INVUMA  PIC S9(9) USAGE COMP VALUE 139759130.                   P 001010 01 PAMS__IVDATAFORMAT  PIC     S9(9) USAGE COMP VALUE 139759138.             P 001020 01 PAMS__IVDATATYPE  PIC S9(9) USAGE COMP VALUE 139759146.               P 001030 01 PAMS__IVECHOLIM  PIC S9(9) USAGE COMP VALUE 139759154.                P 001040 01 PAMS__IVLOGLIM  PIC S9(9) USAGE COMP VALUE 139759162.                 P 001050 01 PAMS__IVMSGCLASS  PIC S9(9) USAGE COMP VALUE 139759170.               P 001060 01 PAMS__IVMSGJOU  PIC S9(9) USAGE COMP VALUE 139759178.                 P 001070 01 PAMS__IVMSGPRI  PIC S9(9) USAGE COMP V    ALUE 139759186.                 P 001080 01 PAMS__IVMSGSRC  PIC S9(9) USAGE COMP VALUE 139759194.                 P 001090 01 PAMS__IVMSGTARG  PIC S9(9) USAGE COMP VALUE 139759202.                P 001100 01 PAMS__IVMSGTYPE  PIC S9(9) USAGE COMP VALUE 139759210.                P 001110 01 PAMS__IVREPVAL  PIC S9(9) USAGE COMP VALUE 139759218.                 P 001120 01 PAMS__IVSETKEY  PIC S9(9) USAGE COMP VALUE 139759226.                 P 001130 01 PAMS__IVSETLOG  PIC S9(9) USAGE COMP VALUE 139759234    .                 P 001140 01 PAMS__IVSETSR  PIC S9(9) USAGE COMP VALUE 139759242.                  P 001150 01 PAMS__IVSETSRWHO  PIC S9(9) USAGE COMP VALUE 139759250.               P 001160 01 PAMS__IVTIME  PIC S9(9) USAGE COMP VALUE 139759258.                   P 001170 01 PAMS__LINK_DOWN  PIC S9(9) USAGE COMP VALUE 139759266.                P 001180 01 PAMS__LOGFOPENFAI  PIC S9(9) USAGE COMP VALUE 139759274.              P 001190 01 PAMS__LOGFWRITERR  PIC S9(9) USAGE COMP VALUE 139759282.                  P 001200 01 PAMS__MISENDC  PIC S9(9) USAGE COMP VALUE 139759290.                  P 001210 01 PAMS__MISENDR  PIC S9(9) USAGE COMP VALUE 139759298.                  P 001220 01 PAMS__MISEOM  PIC S9(9) USAGE COMP VALUE 139759306.                   P 001230 01 PAMS__MISQUOTE  PIC S9(9) USAGE COMP VALUE 139759314.                 P 001240 01 PAMS__MISREPEAT  PIC S9(9) USAGE COMP VALUE 139759322.                P 001250 01 PAMS__MRS_RES_EXH  PIC S9(9) USAGE COMP VALUE 139759330.              P 001260 0    1 PAMS__MSGCONTENT  PIC S9(9) USAGE COMP VALUE 139759338.               P 001270 01 PAMS__MSGFMT  PIC S9(9) USAGE COMP VALUE 139759346.                   P 001280 01 PAMS__MSGTOBIG  PIC S9(9) USAGE COMP VALUE 139759354.                 P 001290 01 PAMS__MSGTOOLONG  PIC S9(9) USAGE COMP VALUE 139759362.               P 001300 01 PAMS__MSGTOSMALL  PIC S9(9) USAGE COMP VALUE 139759370.               P 001310 01 PAMS__NAMETOOLONG  PIC S9(9) USAGE COMP VALUE 139759378.              P 001320 01 PAMS__NOCANS    END  PIC S9(9) USAGE COMP VALUE 139759386.                P 001330 01 PAMS__NOLINK  PIC S9(9) USAGE COMP VALUE 139759394.                   P 001340 01 PAMS__NOLOGFILE  PIC S9(9) USAGE COMP VALUE 139759402.                P 001350 01 PAMS__NOMOREJH  PIC S9(9) USAGE COMP VALUE 139759410.                 P 001360 01 PAMS__NOMRQRESRC  PIC S9(9) USAGE COMP VALUE 139759418.               P 001370 01 PAMS__NOMRS  PIC S9(9) USAGE COMP VALUE 139759426.                    P 001380 01 PAMS__NOMSGCLASS  PIC S9(9    ) USAGE COMP VALUE 139759434.               P 001390 01 PAMS__NOMSGFROM  PIC S9(9) USAGE COMP VALUE 139759442.                P 001400 01 PAMS__NOMSGTO  PIC S9(9) USAGE COMP VALUE 139759450.                  P 001410 01 PAMS__NOMSGTYPE  PIC S9(9) USAGE COMP VALUE 139759458.                P 001420 01 PAMS__NOSUCHPCJ  PIC S9(9) USAGE COMP VALUE 139759466.                P 001430 01 PAMS__NOTACTIVE  PIC S9(9) USAGE COMP VALUE 139759474.                P 001440 01 PAMS__NOTALLOCATE  PIC S9(9) USAGE COMP     VALUE 139759482.              P 001450 01 PAMS__NOTASTMT  PIC S9(9) USAGE COMP VALUE 139759490.                 P 001460 01 PAMS__NOTDCL  PIC S9(9) USAGE COMP VALUE 139759498.                   P 001470 01 PAMS__NOTDECIMAL  PIC S9(9) USAGE COMP VALUE 139759506.               P 001480 01 PAMS__NOTHEX  PIC S9(9) USAGE COMP VALUE 139759514.                   P 001490 01 PAMS__NOTJRN  PIC S9(9) USAGE COMP VALUE 139759522.                   P 001500 01 PAMS__NOTOCTAL  PIC S9(9) USAGE COMP VALUE 139759530.                     P 001510 01 PAMS__NO_DQF  PIC S9(9) USAGE COMP VALUE 139759538.                   P 001520 01 PAMS__NO_SAF  PIC S9(9) USAGE COMP VALUE 139759546.                   P 001530 01 PAMS__PNUMNOEXIST  PIC S9(9) USAGE COMP VALUE 139759554.              P 001540 01 PAMS__PROTOCOL  PIC S9(9) USAGE COMP VALUE 139759562.                 P 001550 01 PAMS__REJECTED  PIC S9(9) USAGE COMP VALUE 139759570.                 P 001560 01 PAMS__RESPQREQ  PIC S9(9) USAGE COMP VALUE 139759578.                     P 001570 01 PAMS__RESRCFAIL  PIC S9(9) USAGE COMP VALUE 139759586.                P 001580 01 PAMS__RTS_FAILED  PIC S9(9) USAGE COMP VALUE 139759594.               P 001590 01 PAMS__SAF_DEVICE_FAIL  PIC S9(9) USAGE COMP VALUE 139759602.          P 001600 01 PAMS__SAF_FAILED  PIC S9(9) USAGE COMP VALUE 139759610.               P 001610 01 PAMS__SELRCVACT  PIC S9(9) USAGE COMP VALUE 139759618.                P 001620 01 PAMS__STATECHANGE  PIC S9(9) USAGE COMP VALUE 139759626.              P 001630 01     PAMS__STRINGTOOLONG  PIC S9(9) USAGE COMP VALUE 139759634.            P 001640 01 PAMS__SYNTAX  PIC S9(9) USAGE COMP VALUE 139759642.                   P 001650 01 PAMS__TOOMANYLOGF  PIC S9(9) USAGE COMP VALUE 139759650.              P 001660 01 PAMS__TOOMANYREPEAT  PIC S9(9) USAGE COMP VALUE 139759658.            P 001670 01 PAMS__TOOMANYSETS  PIC S9(9) USAGE COMP VALUE 139759666.              P 001680 01 PAMS__UCBERROR  PIC S9(9) USAGE COMP VALUE 139759674.                 P 001690 01 PAMS__VALUEOVE    RFL  PIC S9(9) USAGE COMP VALUE 139759682.              P 001700 01 PAMS__ZEROREPEAT  PIC S9(9) USAGE COMP VALUE 139759690.               P 001710 01 PAMS__BADQTYPE  PIC S9(9) USAGE COMP VALUE 139759698.                 P 001720 01 PAMS__JOURNAL_FAIL  PIC S9(9) USAGE COMP VALUE 139759706.             P 001730 01 PAMS__JOURNAL_FULL  PIC S9(9) USAGE COMP VALUE 139759714.             P 001740 01 PAMS__NETERROR  PIC S9(9) USAGE COMP VALUE 139759722.                 P 001750 01 PAMS__NETLINKLOST  PIC S9(9)     USAGE COMP VALUE 139759730.              P 001760 01 PAMS__BADASSIGN  PIC S9(9) USAGE COMP VALUE 139761924.                P 001770 01 PAMS__BADASTPARM  PIC S9(9) USAGE COMP VALUE 139761932.               P 001780 01 PAMS__BADMSGBUF  PIC S9(9) USAGE COMP VALUE 139761940.                P 001790 01 PAMS__BADSCRIPT  PIC S9(9) USAGE COMP VALUE 139761948.                P 001800 01 PAMS__CREATEFAIL  PIC S9(9) USAGE COMP VALUE 139761956.               P 001810 01 PAMS__DCLTMPFAIL  PIC S9(9) USAGE COMP VAL    UE 139761964.               P 001820 01 PAMS__DECLARED  PIC S9(9) USAGE COMP VALUE 139761972.                 P 001830 01 PAMS__EXHAUSTBLKS  PIC S9(9) USAGE COMP VALUE 139761980.              P 001840 01 PAMS__INSQUEFAIL  PIC S9(9) USAGE COMP VALUE 139761988.               P 001850 01 PAMS__INTERNAL  PIC S9(9) USAGE COMP VALUE 139761996.                 P 001860 01 PAMS__LOGNAME  PIC S9(9) USAGE COMP VALUE 139762004.                  P 001870 01 PAMS__LOGNAME2  PIC S9(9) USAGE COMP VALUE 139762012.                     P 001880 01 PAMS__LOGNAME3  PIC S9(9) USAGE COMP VALUE 139762020.                 P 001890 01 PAMS__LOGNAME4  PIC S9(9) USAGE COMP VALUE 139762028.                 P 001900 01 PAMS__LOGNAME5  PIC S9(9) USAGE COMP VALUE 139762036.                 P 001910 01 PAMS__NOOPEN  PIC S9(9) USAGE COMP VALUE 139762044.                   P 001920 01 PAMS__NOPRIV  PIC S9(9) USAGE COMP VALUE 139762052.                   P 001930 01 PAMS__NOQUOTA  PIC S9(9) USAGE COMP VALUE 139762060.                                                                                                                                                                                                                                                                     a                        TD^ $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1]BUILD_MBX_UCB.COM;1                                                                                                                  O "                P 001940 01 PAMS__NOTPRIMARYQ  PIC S9(9) USAGE COMP VALUE 139762068.              P 001950 01 PAMS__NOTSECONDARYQ  PIC S9(9) USAGE COMP VALUE 139762076.            P 001960 01 PAMS__NOTSUPPORTED  PIC S9(9) USAGE COMP VALUE 139762084.             P 001970 01 PAMS__PAMSDOWN  PIC S9(9) USAGE COMP VALUE 139762092.                 P 001980 01 PAMS__QUECORRUPT  PIC S9(9) USAGE COMP VALUE 139762100.               P 001990 01 PAMS__REMQUEFAIL  PIC S9(9) USAGE COMP VALUE 139762108.               P 002000 01 PA	    MS__NOACL  PIC S9(9) USAGE COMP VALUE 139762116.                    P 002010 01 PAMS__NOACCESS  PIC S9(9) USAGE COMP VALUE 139762124.                 P 002020 01 PAMS__BADINITFILE  PIC S9(9) USAGE COMP VALUE 139762132.              P 002030 01 PAMS__NETNOLINK  PIC S9(9) USAGE COMP VALUE 139762140.                 w w        
mʕ P 000010                                                                          P 000020* *** MODULE PAMS_COB_SYMBOL_DEF IDENT DMQ V2.0-05 ***/                   P 00    0030* *                                                                       P 000040*            */                                                           P 000050* ****************************************************************        P 000060* ********** */                                                           P 000070* * Define the Selective Receive symbols                                  P 000080*            */                                                           P 000090* ********    ********************************************************        P 000100* ********** */                                                           P 000110* *                                                                       P 000120*            */                                                           P 000130 01 PSEL_PRI_P0  PIC S9(9) USAGE COMP VALUE 1.                            P 000140 01 PSEL_PRI_P1  PIC S9(9) USAGE COMP VALUE 2.                            P 000150 01 PSEL_PRI_ANY  PIC S9    (9) USAGE COMP VALUE 3.                           P 000160 01 PSEL_SOURCE  PIC S9(9) USAGE COMP VALUE -1.                           P 000170 01 PSEL_CLASS  PIC S9(9) USAGE COMP VALUE -2.                            P 000180 01 PSEL_TYPE  PIC S9(9) USAGE COMP VALUE -3.                             P 000190* *                                                                       P 000200*            */                                                           P 000210* ************************************    ****************************        P 000220* ********** */                                                           P 000230* * Define the Select-by-Queue macros                                     P 000240*            */                                                           P 000250* ****************************************************************        P 000260* ********** */                                                           P 000270* *                                                                           P 000280*            */                                                           P 000290 01 PSEL_BY_MASK  PIC S9(9) USAGE COMP VALUE -1.                          P 000300 01 PSEL_PQ  PIC S9(9) USAGE COMP VALUE -2.                               P 000310 01 PSEL_AQ  PIC S9(9) USAGE COMP VALUE -3.                               P 000320 01 PSEL_PQ_AQ  PIC S9(9) USAGE COMP VALUE -4.                            P 000330 01 PSEL_AQ_PQ  PIC S9(9) USAGE COMP VALUE -5.                                P 000340 01 PSEL_PQ_TYPE  PIC S9(9) USAGE COMP VALUE -6.                          P 000350 01 PSEL_PQ_CLASS  PIC S9(9) USAGE COMP VALUE -7.                         P 000360 01 PSEL_PQ_PRI  PIC S9(9) USAGE COMP VALUE -8.                           P 000370 01 PSEL_UCB  PIC S9(9) USAGE COMP VALUE -9.                              P 000380 01 PSEL_TQ_PQ  PIC S9(9) USAGE COMP VALUE -10.                           P 000390 01 PSEL_TQ_PQ_AQ  PIC S9(9) USAGE COMP VALUE -11.                        P 0004    00* *                                                                       P 000410*            */                                                           P 000420* ****************************************************************        P 000430* ********** */                                                           P 000440* * Define the Selective Operators                                        P 000450*            */                                                           P 000460* **********    ******************************************************        P 000470* ********** */                                                           P 000480* *                                                                       P 000490*            */                                                           P 000500 01 PSEL_OPER_ANY  PIC S9(9) USAGE COMP VALUE 0.                          P 000510 01 PSEL_OPER_EQ  PIC S9(9) USAGE COMP VALUE 1.                           P 000520 01 PSEL_OPER_NEQ  PIC S9(    9) USAGE COMP VALUE 2.                          P 000530 01 PSEL_OPER_GTR  PIC S9(9) USAGE COMP VALUE 3.                          P 000540 01 PSEL_OPER_LT  PIC S9(9) USAGE COMP VALUE 4.                           P 000550 01 PSEL_OPER_GTRE  PIC S9(9) USAGE COMP VALUE 5.                         P 000560 01 PSEL_OPER_LTE  PIC S9(9) USAGE COMP VALUE 6.                          P 000570* *                                                                       P 000580*            */                                                               P 000590* ****************************************************************        P 000600* ********** */                                                           P 000610* * Define the Selective Order                                            P 000620*            */                                                           P 000630* ****************************************************************        P 000640* ********** */                                                               P 000650* *                                                                       P 000660*            */                                                           P 000670 01 PSEL_ORDER_FIFO  PIC S9(9) USAGE COMP VALUE 0.                        P 000680 01 PSEL_ORDER_MIN  PIC S9(9) USAGE COMP VALUE 11.                        P 000690 01 PSEL_ORDER_MAX  PIC S9(9) USAGE COMP VALUE 12.                        P 000700* *                                                                           P 000710*            */                                                           P 000720* ****************************************************************        P 000730* ********** */                                                           P 000740* * Define obsolete non-MRS Delivery Mode symbols                         P 000750*            */                                                           P 000760* ****************************************************************        P 000770    * ********** */                                                           P 000780* *                                                                       P 000790*            */                                                           P 000800 01 PDEL_MODE_DG_LOG  PIC S9(9) USAGE COMP VALUE 0.                       P 000810 01 PDEL_MODE_DG  PIC S9(9) USAGE COMP VALUE 1.                           P 000820 01 PDEL_MODE_RTS  PIC S9(9) USAGE COMP VALUE 10.                         P 000830 01 PDEL_MODE_    WFQ  PIC S9(9) USAGE COMP VALUE 20.                         P 000840* *                                                                       P 000850*            */                                                           P 000860* ****************************************************************        P 000870* ********** */                                                           P 000880* * Define Delivery Mode symbols                                          P 000890*            */                                                               P 000900* ****************************************************************        P 000910* ********** */                                                           P 000920* *                                                                       P 000930*            */                                                           P 000940 01 PDEL_MODE_WF_SAF  PIC S9(9) USAGE COMP VALUE 25.                      P 000950 01 PDEL_MODE_WF_DQF  PIC S9(9) USAGE COMP                                                                                                                                                                                                                                                   b                        y} $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1]CNTRLC.C;1LE.C;1                                                                                                                     n "                 VALUE 26.                      P 000960 01 PDEL_MODE_WF_NET  PIC S9(9) USAGE COMP VALUE 27.                      P 000970 01 PDEL_MODE_WF_RCM  PIC S9(9) USAGE COMP VALUE 28.                      P 000980 01 PDEL_MODE_WF_MEM  PIC S9(9) USAGE COMP VALUE 29.                      P 000990 01 PDEL_MODE_AK_SAF  PIC S9(9) USAGE COMP VALUE 30.                      P 001000 01 PDEL_MODE_AK_DQF  PIC S9(9) USAGE COMP VALUE 31.                      P 001010 01 PDEL_MODE_AK_NET  PIC S9(9) USAGE COMP VALUE 32.                          P 001020 01 PDEL_MODE_AK_RCM  PIC S9(9) USAGE COMP VALUE 33.                      P 001030 01 PDEL_MODE_AK_MEM  PIC S9(9) USAGE COMP VALUE 34.                      P 001040 01 PDEL_MODE_NN_SAF  PIC S9(9) USAGE COMP VALUE 35.                      P 001050 01 PDEL_MODE_NN_DQF  PIC S9(9) USAGE COMP VALUE 36.                      P 001060 01 PDEL_MODE_NN_NET  PIC S9(9) USAGE COMP VALUE 37.                      P 001070 01 PDEL_MODE_NN_RCM  PIC S9(9) USAGE COMP VALUE 38.                          P 001080 01 PDEL_MODE_NN_MEM  PIC S9(9) USAGE COMP VALUE 39.                      P 001090* *                                                                       P 001100*            */                                                           P 001110* *   obsolete MRS recovery mode                                          P 001120*            */                                                           P 001130 01 PDEL_MODE_ST_RECOVER  PIC S9(9) USAGE COMP VALUE 22.                  P 001140*     *                                                                       P 001150*            */                                                           P 001160* ****************************************************************        P 001170* ********** */                                                           P 001180* * Define Undeliverable Message Action symbols                           P 001190*            */                                                           P 001200* **************    **************************************************        P 001210* ********** */                                                           P 001220* *                                                                       P 001230*            */                                                           P 001240 01 PDEL_UMA_RTS  PIC S9(9) USAGE COMP VALUE 1.                           P 001250 01 PDEL_UMA_DLJ  PIC S9(9) USAGE COMP VALUE 2.                           P 001260 01 PDEL_UMA_DLQ  PIC S9(9) US    AGE COMP VALUE 3.                           P 001270 01 PDEL_UMA_SAF  PIC S9(9) USAGE COMP VALUE 4.                           P 001280 01 PDEL_UMA_DISC  PIC S9(9) USAGE COMP VALUE 5.                          P 001290 01 PDEL_UMA_DISCL  PIC S9(9) USAGE COMP VALUE 6.                         P 001300* *                                                                       P 001310*            */                                                           P 001320* ******************************************    **********************        P 001330* ********** */                                                           P 001340* * Define PAMS_CONFIRM_MSG force journal symbols                         P 001350*            */                                                           P 001360* ****************************************************************        P 001370* ********** */                                                           P 001380* *                                                                           P 001390*            */                                                           P 001400 01 PDEL_DEFAULT_JRN  PIC S9(9) USAGE COMP VALUE 0.                       P 001410 01 PDEL_FORCE_JRN  PIC S9(9) USAGE COMP VALUE 1.                         P 001420 01 PDEL_NO_JRN  PIC S9(9) USAGE COMP VALUE 2.                            P 001430* *                                                                       P 001440*            */                                                               P 001450* ****************************************************************        P 001460* ********** */                                                           P 001470* * Define PAMS_LOCATE_Q symbols                                          P 001480*            */                                                           P 001490* ****************************************************************        P 001500* ********** */                                                           P 001510* *                                                                           P 001520*            */                                                           P 001530 01 PSEL_TBL_PROC  PIC S9(9) USAGE COMP VALUE -50.                        P 001540 01 PSEL_TBL_GRP  PIC S9(9) USAGE COMP VALUE -51.                         P 001550 01 PSEL_TBL_DNS_CACHE  PIC S9(9) USAGE COMP VALUE -52.                   P 001560 01 PSEL_TBL_DNS_LOW  PIC S9(9) USAGE COMP VALUE -53.                     P 001570 01 PSEL_TBL_DNS_M    ED  PIC S9(9) USAGE COMP VALUE -54.                     P 001580 01 PSEL_TBL_DNS_HIGH  PIC S9(9) USAGE COMP VALUE -55.                    P 001590 01 PSYM_WF_RESP  PIC S9(9) USAGE COMP VALUE -70.                         P 001600 01 PSYM_AK_RESP  PIC S9(9) USAGE COMP VALUE -71.                         P 001610* *                                                                       P 001620*            */                                                           P 001630* ******************************    **********************************        P 001640* ********** */                                                           P 001650* * Define PAMS_ATTACH_Q symbols                                          P 001660*            */                                                           P 001670* ****************************************************************        P 001680* ********** */                                                           P 001690* *                                                                           P 001700*            */                                                           P 001710 01 PSYM_ATTACH_PQ  PIC S9(9) USAGE COMP VALUE -200.                      P 001720 01 PSYM_ATTACH_SQ  PIC S9(9) USAGE COMP VALUE -201.                      P 001730 01 PSYM_ATTACH_BY_NAME  PIC S9(9) USAGE COMP VALUE -210.                 P 001740 01 PSYM_ATTACH_BY_NUMBER  PIC S9(9) USAGE COMP VALUE -211.               P 001750 01 PSYM_ATTACH_TEMPORARY  PIC S9(9) USAGE COMP VALUE -212.                   P 001760* *                                                                       P 001770*            */                                                           P 001780* ****************************************************************        P 001790* ********** */                                                           P 001800* * Define PAMS_DCL_PROCESS symbols                                       P 001810*            */                                                               P 001820* ****************************************************************        P 001830* ********** */                                                           P 001840* *                                                                       P 001850*            */                                                           P 001860 01 PSYM_DCL_PQ  PIC S9(9) USAGE COMP VALUE -200.                         P 001870 01 PSYM_DCL_SQ  PIC S9(9) USAGE COMP VALUE -201.                         P 001880 01 PS    YM_SCOPE_LOCAL  PIC S9(9) USAGE COMP VALUE -202.                    P 001890 01 PSYM_SCOPE_GLOBAL  PIC S9(9) USAGE COMP VALUE -203.                   P 001900* *                                                                       P 001910*            */                                                           P 001920* ****************************************************************        P 001930* ********** */                                                           P 001940* * Define PAMS_WAKE     symbols                                              P 001950*            */                                                           P 001960* ****************************************************************        P 001970* ********** */                                                           P 001980* *                                                                       P 001990*            */                                                           P 002000 01 PSYM_IGNORE  PIC S9(9) USAGE C                                                                                                                                                                                                                                                   c                        =h $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1]MBX.C;1XAMPLE.C;1                                                                                                                    +; "                OMP VALUE -230.                         P 002010 01 PSYM_SET_UCB_PRI_P0  PIC S9(9) USAGE COMP VALUE -231.                 P 002020 01 PSYM_SET_UCB_PRI_P1  PIC S9(9) USAGE COMP VALUE -232.                 P 002030 01 PSYM_SET_UCB_A  PIC S9(9) USAGE COMP VALUE -240.                      P 002040 01 PSYM_SET_UCB_B  PIC S9(9) USAGE COMP VALUE -241.                      P 002050 01 PSYM_SET_UCB_C  PIC S9(9) USAGE COMP VALUE -242.                      P 002060 01 PSYM_SET_UCB_D  PIC S9(9) USAGE COMP VALUE -    243.                      P 002070 01 PSYM_SET_UCB_E  PIC S9(9) USAGE COMP VALUE -244.                      P 002080 01 PSYM_SET_UCB_F  PIC S9(9) USAGE COMP VALUE -245.                      P 002090 01 PSYM_SET_UCB_G  PIC S9(9) USAGE COMP VALUE -246.                      P 002100 01 PSYM_SET_UCB_H  PIC S9(9) USAGE COMP VALUE -247.                      P 002110 01 PSYM_SET_UCB_I  PIC S9(9) USAGE COMP VALUE -248.                      P 002120 01 PSYM_SET_UCB_J  PIC S9(9) USAGE COMP VALUE -249.                          P 002130* *                                                                       P 002140*            */                                                           P 002150* ****************************************************************        P 002160* ********** */                                                           P 002170* * Define Data Representation symbols                                    P 002180*            */                                                           P     002190* ****************************************************************        P 002200* ********** */                                                           P 002210* *                                                                       P 002220*            */                                                           P 002230 01 PSYM_UNKNOWN  PIC S9(9) USAGE COMP VALUE 0.                           P 002240 01 PSYM_LITTLE_ENDIAN  PIC S9(9) USAGE COMP VALUE 0.                     P 002250 01 PSYM    _VAX_BYTE_ORDER  PIC S9(9) USAGE COMP VALUE 0.                    P 002260 01 PSYM_BIG_ENDIAN  PIC S9(9) USAGE COMP VALUE 1.                        P 002270 01 PSYM_NETWORK_BYTE_ORDER  PIC S9(9) USAGE COMP VALUE 1.                P 002280* *                                                                       P 002290*            */                                                           P 002300* ****************************************************************        P 002310* ********** */                                                               P 002320* * Define LINK MANAGEMENT symbols                                        P 002330*            */                                                           P 002340* ****************************************************************        P 002350* ********** */                                                           P 002360* *                                                                       P 002370*            */                                                               P 002380* *                                                                       P 002390*            */                                                           P 002400* * Define platform IDs                                                   P 002410*            */                                                           P 002420 01 PSYM_PLATFORM_VAX_VMS  PIC S9(9) USAGE COMP VALUE 0.                  P 002430 01 PSYM_PLATFORM_VAX_ULTRIX  PIC S9(9) USAGE COMP     VALUE 1.               P 002440 01 PSYM_PLATFORM_RISC_ULTRIX  PIC S9(9) USAGE COMP VALUE 2.              P 002450 01 PSYM_PLATFORM_HP9000_HPUX  PIC S9(9) USAGE COMP VALUE 3.              P 002460 01 PSYM_PLATFORM_MOTOROLA_VR32  PIC S9(9) USAGE COMP VALUE 4.            P 002470 01 PSYM_PLATFORM_SPARC_SUNOS  PIC S9(9) USAGE COMP VALUE 5.              P 002480 01 PSYM_PLATFORM_IBM_RS6000_AIX  PIC S9(9) USAGE COMP VALUE 6.           P 002490 01 PSYM_PLATFORM_OS2  PIC S9(9) USAGE COMP VALUE 7.                          P 002500 01 PSYM_PLATFORM_MSDOS  PIC S9(9) USAGE COMP VALUE 8.                    P 002510 01 PSYM_PLATFORM_PDP11_RSX  PIC S9(9) USAGE COMP VALUE 9.                P 002520 01 PSYM_PLATFORM_VAXELN  PIC S9(9) USAGE COMP VALUE 10.                  P 002530 01 PSYM_PLATFORM_MACINTOSH  PIC S9(9) USAGE COMP VALUE 11.               P 002540 01 PSYM_PLATFORM_SCO_UNIX  PIC S9(9) USAGE COMP VALUE 12.                P 002550* *                                                                       P 00    2560*            */                                                           P 002570* * Define reconnect timer values                                         P 002580*            */                                                           P 002590 01 PSYM_LINKMGT_USE_PREVIOUS  PIC S9(9) USAGE COMP VALUE -1.             P 002600 01 PSYM_LINKMGT_NO_TIMER  PIC S9(9) USAGE COMP VALUE 0.                  P 002610* *                                                                       P 002620*                */                                                           P 002630* * Define group number values                                            P 002640*            */                                                           P 002650 01 PSYM_LINKMGT_ALL_GROUPS  PIC S9(9) USAGE COMP VALUE -1.               P 002660* *                                                                       P 002670*            */                                                           P 002680* * success status codes                                                      P 002690*            */                                                           P 002700 01 PSYM_LINKMGT_SUCCESS  PIC S9(9) USAGE COMP VALUE 1.                   P 002710* *                                                                       P 002720*            */                                                           P 002730* * error status codes                                                    P 002740*            */                                                               P 002750 01 PSYM_LINKMGT_MSGFMT  PIC S9(9) USAGE COMP VALUE -2.                   P 002760 01 PSYM_LINKMGT_MSGCONTENT  PIC S9(9) USAGE COMP VALUE -4.               P 002770 01 PSYM_LINKMGT_ALREADYUP  PIC S9(9) USAGE COMP VALUE -6.                P 002780 01 PSYM_LINKMGT_NOPRIV  PIC S9(9) USAGE COMP VALUE -8.                   P 002790 01 PSYM_LINKMGT_NOGROUP  PIC S9(9) USAGE COMP VALUE -10.                 P 002800 01 PSYM_LINKMGT_NOTSUPPORTED  PIC S9(9) USAGE COMP     VALUE -12.            P 002810 01 PSYM_LINKMGT_NOTRANSPORT  PIC S9(9) USAGE COMP VALUE -14.             P 002820 01 PSYM_LINKMGT_OPERATIONFAIL  PIC S9(9) USAGE COMP VALUE -16.           P 002830* *                                                                       P 002840*            */                                                           P 002850* * Command codes                                                         P 002860*            */                                                               P 002870 01 PSYM_LINKMGT_CMD_INQUIRY  PIC S9(9) USAGE COMP VALUE 101.             P 002880 01 PSYM_LINKMGT_CMD_CONNECT  PIC S9(9) USAGE COMP VALUE 102.             P 002890 01 PSYM_LINKMGT_CMD_DISCONNECT  PIC S9(9) USAGE COMP VALUE 103.          P 002900 01 PSYM_LINKMGT_CMD_ENABLE  PIC S9(9) USAGE COMP VALUE 104.              P 002910* *                                                                       P 002920*            */                                                           P 0029    30* * Transport type codes                                                  P 002940*            */                                                           P 002950 01 PSYM_LINKMGT_LOCAL  PIC S9(9) USAGE COMP VALUE 201.                   P 002960 01 PSYM_LINKMGT_DECNET  PIC S9(9) USAGE COMP VALUE 202.                  P 002970 01 PSYM_LINKMGT_TCPIP  PIC S9(9) USAGE COMP VALUE 203.                   P 002980* *                                                                       P 002990*                */                                                           P 003000* * Link state codes                                                      P 003010*            */                                                           P 003020 01 PSYM_LINKMGT_UNKNOWN  PIC S9(9) USAGE COMP VALUE 301.                 P 003030 01 PSYM_LINKMGT_NOCNT  PIC S9(9) USAGE COMP VALUE 302.                   P 003040 01 PSYM_LINKMGT_CONNECTED  PIC S9(9) USAGE COMP VALUE 303.               P 003050 01 PSYM_LINKMGT_DISABLED                                                                                                                                                                                                                                                    d                        Gp $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1]MBX.C;1XAMPLE.C;1                                                                                                                    7 "                 PIC S9(9) USAGE COMP VALUE 304.                P 003060* *                                                                       P 003070*            */                                                           P 003080* ****************************************************************        P 003090* ********** */                                                           P 003100* *    Define the Queue Type symbols                                      P 003110*            */                                                               P 003120* ****************************************************************        P 003130* ********** */                                                           P 003140* *                                                                       P 003150*            */                                                           P 003160 01 PSYM_QTYPE_PQ  PIC S9(9) USAGE COMP VALUE 1.                          P 003170 01 PSYM_QTYPE_SQ  PIC S9(9) USAGE COMP VALUE 2.                              P 003180 01 PSYM_QTYPE_MRQ  PIC S9(9) USAGE COMP VALUE 3.                         P 003190 01 PSYM_QTYPE_UCB  PIC S9(9) USAGE COMP VALUE 4.                         P 003200* *                                                                       P 003210*            */                                                           P 003220* * --------------- End of PAMS symbol file ----------------------        P 003230* --------   */                                                     	           w w        _/ʕ P 000010* *********************************************                           P 000020*  Include file name: PAMS_COB_TYPE_CLASS                                 P 000030*  File name: PAITYPCOB.TXT                                               P 000040*  Usage: COPY PAMS_COB_TYPE_CLASS.                                       P 000050*                                                                         P 000060*  *  Function:                                                     *         P 000070*  *    This include file defines all the message definitions   *         P 000080*  *    used within the DECmessageQ system.                     *         P 000090*  *                                                            *         P 000100*  *  NOTE:                                                     *         P 000110*  *    The following are reserved to DIGITAL:                  *         P 000120*  *                                                            *             P 000130*  *        Msg Classes: 28, 29 & 30,000 thru 32,767            *         P 000140*  *        Msg Types:   -1 thru -5,000                         *         P 000150*  *------------------------------------------------------------*         P 000160                                                                          P 000170*  **************************************************************         P 000180*  *                                                            *         P 000190*  *            MRS Class and Type codes (800-899)                  *         P 000200*  *                                                            *         P 000210*  **************************************************************         P 000220                                                                          P 000230 01 MSG_CLAS_MRS PIC S9(9) USAGE COMP VALUE 28.                           P 000240* * define MRS class *                                                    P 000250                                                                              P 000260*  * define MRS type codes *                                              P 000270 01 MSG_TYPE_MRS_DQF_TRANSFER       PIC S9(9) USAGE COMP VALUE -70        P 000280-    0.                                                                   P 000290 01 MSG_TYPE_MRS_DQF_TRANSFER_ACK   PIC S9(9) USAGE COMP VALUE -70        P 000300-    1.                                                                   P 000310 01 MSG_TYPE_MRS_DQF_TRANSFER_RE    P   PIC S9(9) USAGE COMP VALUE -70        P 000320-    2.                                                                   P 000330 01 MSG_TYPE_MRS_DQF_SET            PIC S9(9) USAGE COMP VALUE -70        P 000340-    4.                                                                   P 000350 01 MSG_TYPE_MRS_DQF_SET_REP        PIC S9(9) USAGE COMP VALUE -70        P 000360-    5.                                                                   P 000370 01 MSG_TYPE_MRS_ACK                PIC S9(9)     USAGE COMP VALUE -80        P 000380-    1.                                                                   P 000390 01 MSG_TYPE_MRS_CNF                PIC S9(9) USAGE COMP VALUE -84        P 000400-    0.                                                                   P 000410 01 MSG_TYPE_MRS_CNF_ACK            PIC S9(9) USAGE COMP VALUE -84        P 000420-    1.                                                                   P 000430 01 MSG_TYPE_MRS_CNF_NAK            PIC S9(9) USAGE COMP VAL    UE -84        P 000440-    2.                                                                   P 000450 01 MSG_TYPE_MRS_DEBUG_ON           PIC S9(9) USAGE COMP VALUE -85        P 000460-    0.                                                                   P 000470 01 MSG_TYPE_MRS_DEBUG_OFF          PIC S9(9) USAGE COMP VALUE -85        P 000480-    1.                                                                   P 000490 01 MSG_TYPE_MRS_SET_PCJ            PIC S9(9) USAGE COMP VALUE -88            P 000500-    0.                                                                   P 000510 01 MSG_TYPE_MRS_SET_PCJ_REP        PIC S9(9) USAGE COMP VALUE -88        P 000520-    1.                                                                   P 000530 01 MSG_TYPE_MRS_SET_DLJ            PIC S9(9) USAGE COMP VALUE -88        P 000540-    2.                                                                   P 000550 01 MSG_TYPE_MRS_SET_DLJ_REP        PIC S9(9) USAGE COMP VALUE -88        P 000560-    3    .                                                                   P 000570                                                                          P 000580*  **************************************************************         P 000590*  *                                                            *         P 000600*  *        PAMS   Class and Type codes (900-999)               *         P 000610*  *                                                            *         P 000620*  *****************    *********************************************         P 000630                                                                          P 000640 01 MSG_CLAS_PAMS PIC S9(9) USAGE COMP VALUE 29.                          P 000650* * define PAMS class *                                                   P 000660                                                                          P 000670*  * define PAMS type codes *                                             P 000680 01 MSG_TYPE_TIMER_EXPIRED               PIC S9(9) USAGE COMP VALUE -9        P 000690-    00.                                                                  P 000700 01 MSG_TYPE_LIST_ALL_Q_REQ          PIC S9(9) USAGE COMP VALUE -9        P 000710-    60.                                                                  P 000720 01 MSG_TYPE_LIST_ALL_Q_RESP         PIC S9(9) USAGE COMP VALUE -9        P 000730-    61.                                                                  P 000740 01 MSG_TYPE_ENABLE_Q_NOTIFY_REQ     PIC S9(9) U    SAGE COMP VALUE -9        P 000750-    62.                                                                  P 000760 01 MSG_TYPE_ENABLE_Q_NOTIFY_RESP    PIC S9(9) USAGE COMP VALUE -9        P 000770-    63.                                                                  P 000780 01 MSG_TYPE_DISABLE_Q_NOTIFY_REQ    PIC S9(9) USAGE COMP VALUE -9        P 000790-    64.                                                                  P 000800 01 MSG_TYPE_DISABLE_Q_NOTIFY_RESP   PIC S9(9) USAGE COMP VALU    E -9        P 000810-    65.                                                                  P 000820 01 MSG_TYPE_Q_UPDATE                PIC S9(9) USAGE COMP VALUE -9        P 000830-    66.                                                                  P 000840 01 MSG_TYPE_LOCATE_Q_REP            PIC S9(9) USAGE COMP VALUE -9        P 000850-    72.                                                                  P 000860 01 MSG_TYPE_LINKMGT_REQ             PIC S9(9) USAGE COMP VALUE -9        P                                                                                                                                                                                                                                                    e                         $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1]MBXRCV.C;1PLE.C;1                                                                                                                    & "                000870-    75.                                                                  P 000880 01 MSG_TYPE_LINKMGT_RESP            PIC S9(9) USAGE COMP VALUE -9        P 000890-    76.                                                                  P 000900 01 MSG_TYPE_DECLARE_SQ              PIC S9(9) USAGE COMP VALUE -9        P 000910-    80.                                                                  P 000920 01 MSG_TYPE_UNDECLARE_SQ            PIC S9(9) USAGE COMP VALUE -9        P 000930-    81.                                                                      P 000940 01 MSG_TYPE_ALLOCATED_SQ            PIC S9(9) USAGE COMP VALUE -9        P 000950-    82.                                                                  P 000960 01 MSG_TYPE_MSG_STATUS              PIC S9(9) USAGE COMP VALUE -9        P 000970-    83.                                                                  P 000980 01 MSG_TYPE_DMQ_SERVER_NAK          PIC S9(9) USAGE COMP VALUE -9        P 000990-    89.                                                                      P 001000 01 MSG_TYPE_ENABLE_NOTIFY           PIC S9(9) USAGE COMP VALUE -9        P 001010-    90.                                                                  P 001020 01 MSG_TYPE_DISABLE_NOTIFY          PIC S9(9) USAGE COMP VALUE -9        P 001030-    91.                                                                  P 001040 01 MSG_TYPE_PROCESS_DCL             PIC S9(9) USAGE COMP VALUE -9        P 001050-    92.                                                                      P 001060 01 MSG_TYPE_PROCESS_EXIT            PIC S9(9) USAGE COMP VALUE -9        P 001070-    93.                                                                  P 001080 01 MSG_TYPE_LIST_DCLS               PIC S9(9) USAGE COMP VALUE -9        P 001090-    94.                                                                  P 001100 01 MSG_TYPE_LIST_ALL_ENTRYS         PIC S9(9) USAGE COMP VALUE -9        P 001110-    95.                                                                      P 001120 01 MSG_TYPE_LIST_ALL_CONNECTIONS    PIC S9(9) USAGE COMP VALUE -9        P 001130-    96.                                                                  P 001140 01 MSG_TYPE_LIST_ALL_GROUPS         PIC S9(9) USAGE COMP VALUE -9        P 001150-    97.                                                                  P 001160 01 MSG_TYPE_LINK_LOST               PIC S9(9) USAGE COMP VALUE -9        P 001170-    98.                                                                      P 001180 01 MSG_TYPE_LINK_COMPLETE           PIC S9(9) USAGE COMP VALUE -9        P 001190-    99.                                                                  P 001200                                                                          P 001210*  **************************************************************         P 001220*  *                                                            *         P 001230*  *       SBS_SERVER - class: PAMS                             *         P 00    1240*  *                    type:  codes (1150-1179)                *         P 001250*  *                                                            *         P 001260*  **************************************************************         P 001270                                                                          P 001280 01 MSG_TYPE_SBS_REG              PIC S9(9) USAGE COMP VALUE -1150        P 001290-                                                                .        P 001300* * regist    ration message long form                                        P 001310 01 MSG_TYPE_SBS_REG_EZ           PIC S9(9) USAGE COMP VALUE -1173        P 001320-                                                                .        P 001330* * registration record short form (new v2 format)                        P 001340 01 MSG_TYPE_SBS_REG_REPLY        PIC S9(9) USAGE COMP VALUE -1152        P 001350-                                                                .        P 001360* * registration reply                                                        P 001370 01 MSG_TYPE_SBS_REG_EZ_REPLY     PIC S9(9) USAGE COMP VALUE -1153        P 001380-                                                                .        P 001390* * registration reply                                                    P 001400 01 MSG_TYPE_SBS_DEREG_BY_ID      PIC S9(9) USAGE COMP VALUE -1154        P 001410-                                                                .        P 001420* * deregister request (old v1 format)                                        P 001430 01 MSG_TYPE_MOT_DEREG            PIC S9(9) USAGE COMP VALUE -1154        P 001440-                                                                .        P 001450* * deregister request (old v1 format)                                    P 001460 01 MSG_TYPE_SBS_DEREG            PIC S9(9) USAGE COMP VALUE -1174        P 001470-                                                                .        P 001480* * deregister request (new v2 format)                                        P 001490 01 MSG_TYPE_SBS_DEREG_ACK        PIC S9(9) USAGE COMP VALUE -1155        P 001500-                                                                .        P 001510* * deregister acknowledgement                                            P 001520 01 MSG_TYPE_SBS_PURGE            PIC S9(9) USAGE COMP VALUE -1157        P 001530-                                                                .        P 001540* * purge registration table                                                  P 001550 01 MSG_TYPE_SBS_PURGE_ACK        PIC S9(9) USAGE COMP VALUE -1158        P 001560-                                                                .        P 001570* * purge registration acknowledgement                                    P 001580 01 MSG_TYPE_SBS_DUMP_TABLES      PIC S9(9) USAGE COMP VALUE -1162        P 001590-                                                                .        P 001600* * process, reg, and group tables to log                                 P 0016    10 01 MSG_TYPE_SBS_BS_SEQGAP        PIC S9(9) USAGE COMP VALUE -1166        P 001620-                                                                .        P 001630* * declaration message missing                                           P 001640                                                                          P 001650*  **************************************************************         P 001660*  *                                                            *         P 001670*  *       A    VAIL_SERVER - class: PAMS                           *         P 001680*  *                    type:  codes (1180-1189)                *         P 001690*  *                                                            *         P 001700*  **************************************************************         P 001710                                                                          P 001720 01 MSG_TYPE_AVAIL_REG            PIC S9(9) USAGE COMP VALUE -1180        P 001730-                                                                    .        P 001740* * available registration                                                P 001750 01 MSG_TYPE_AVAIL_DEREG          PIC S9(9) USAGE COMP VALUE -1181        P 001760-                                                                .        P 001770* * available deregistration                                              P 001780 01 MSG_TYPE_AVAIL_REG_REPLY      PIC S9(9) USAGE COMP VALUE -1182        P 001790-                                                                    .        P 001800* * registration reply                                                    P 001810 01 MSG_TYPE_AVAIL                PIC S9(9) USAGE COMP VALUE -1183        P 001820-                                                                .        P 001830* * process is now available                                              P 001840 01 MSG_TYPE_UNAVAIL              PIC S9(9) USAGE COMP VALUE -1184        P 001850-                                                                    .        P 001860* * process is now unavailable                                            P 001870                                                                          P 001880*  **************************************************************         P 001890*  *                                                            *         P 001900*  *       ETHERNET   Class and Type codes (1000-1010)          *         P 001910*  *                                                            *                                                                                                                                                                                                                                                      f                         $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1]MBXSND.C;1PLE.C;1                                                                                                                    Mf "                      P 001920*  **************************************************************         P 001930                                                                          P 001940 01 MSG_CLAS_ETHERNET  PIC S9(9) USAGE COMP VALUE 100.                    P 001950* * define Ethernet class                                                 P 001960                                                                          P 001970*  * define Ethernet type codes                                           P 001980     01 MSG_TYPE_E_CONNECT            PIC S9(9) USAGE COMP VALUE -1000        P 001990-                                                                .        P 002000* * Initiate connection                                                   P 002010 01 MSG_TYPE_E_DISCONNECT         PIC S9(9) USAGE COMP VALUE -1001        P 002020-                                                                .        P 002030* * shutdown circuit                                                      P 002040 01 MSG_TYPE_E    _INITIALIZE         PIC S9(9) USAGE COMP VALUE -1002        P 002050-                                                                .        P 002060* * set Ethernet characteristics                                          P 002070 01 MSG_TYPE_E_CONNECT_COMPLETE   PIC S9(9) USAGE COMP VALUE -1003        P 002080-                                                                .        P 002090* * circuit established                                                   P 002100 01 MSG_TYPE_E_CONNECT_REJEC    TED   PIC S9(9) USAGE COMP VALUE -1004        P 002110-                                                                .        P 002120* * partner rejected circuit                                              P 002130 01 MSG_TYPE_E_PARTNER_DISC       PIC S9(9) USAGE COMP VALUE -1005        P 002140-                                                                .        P 002150* * partner disconnected circuit                                          P 002160 01 MSG_TYPE_E_IO_ERROR           PIC S9(9    ) USAGE COMP VALUE -1006        P 002170-                                                                .        P 002180* * bad return status from QIO$                                           P 002190 01 MSG_TYPE_E_PROTOCOL_ERROR     PIC S9(9) USAGE COMP VALUE -1007        P 002200-                                                                .        P 002210* * unrecognized msg from partner                                         P 002220 01 MSG_TYPE_E_LISTEN_TIMEOUT     PIC S9(9) USAGE COMP V    ALUE -1008        P 002230-                                                                .        P 002240* * partner's heartbeat stopped                                           P 002250 01 MSG_TYPE_E_MESSAGES_LOST      PIC S9(9) USAGE COMP VALUE -1009        P 002260-                                                                .        P 002270* * detected msg loss                                                     P 002280 01 MSG_TYPE_E_RUNTIME_ERROR      PIC S9(9) USAGE COMP VALUE -1010            P 002290-                                                                .        P 002300* * detected runtime error in AST                                         P 002310                                                                          P 002320*  *************************************************                      P 002330*  *       Generic UCB Types and Classes           *                      P 002340*  *************************************************                      P 002350                                                                              P 002360 01 MSG_CLAS_UCB    PIC S9(9) USAGE COMP VALUE 102.                       P 002370                                                                          P 002380 01 MSG_TYPE_UCB_CONNECT          PIC S9(9) USAGE COMP VALUE -1200        P 002390-                                                                .        P 002400* * Initiate connection                                                   P 002410 01 MSG_TYPE_UCB    _DISCONNECT       PIC S9(9) USAGE COMP VALUE -1201        P 002420-                                                                .        P 002430* * shutdown circuit                                                      P 002440 01 MSG_TYPE_UCB_INITIALIZE       PIC S9(9) USAGE COMP VALUE -1202        P 002450-                                                                .        P 002460* * set UCB characteristics                                               P 002470 01 MSG_TYPE_UCB_CONNECT_COMPL    ETE PIC S9(9) USAGE COMP VALUE -1203        P 002480-                                                                .        P 002490* * circuit established                                                   P 002500 01 MSG_TYPE_UCB_PARTNER_DISC     PIC S9(9) USAGE COMP VALUE -1204        P 002510-                                                                .        P 002520* * partner disconnected circuit                                          P 002530 01 MSG_TYPE_UCB_MESSAGES_LOST    PIC S9(9)     USAGE COMP VALUE -1205        P 002540-                                                                .        P 002550* * detected msg loss                                                     P 002560 01 MSG_TYPE_UCB_IO_ERROR         PIC S9(9) USAGE COMP VALUE -1206        P 002570-                                                                .        P 002580* * bad return status from QIO$                                           P 002590 01 MSG_TYPE_UCB_RCV_DATA         PIC S9(9) USAGE COMP VAL    UE -1207        P 002600-                                                                .        P 002610* * data message received by UCB                                          P 002620                                                                          P 002630                                                                          P 002640*  **************************************************************         P 002650*  *                                                            *             P 002660*  *        DEFINE DEMO type codes for DEMO_IO_SERVER           *         P 002670*  *                                                            *         P 002680*  **************************************************************         P 002690                                                                          P 002700 01 MSG_TYPE_DEMO_ADD             PIC S9(9) USAGE COMP VALUE -1200        P 002710-                                                                .        P 002720* *    add record function   *                                               P 002730 01 MSG_TYPE_DEMO_CHG             PIC S9(9) USAGE COMP VALUE -1216        P 002740-                                                                .        P 002750* * chg record function   *                                               P 002760 01 MSG_TYPE_DEMO_DEL             PIC S9(9) USAGE COMP VALUE -1232        P 002770-                                                                .        P 002780* * del record fun   ction   *                                               P 002790 01 MSG_TYPE_DEMO_INQ             PIC S9(9) USAGE COMP VALUE -1248        P 002800-                                                                .        P 002810* * inq record function   *                                               P 002820 01 MSG_TYPE_DEMO_LST             PIC S9(9) USAGE COMP VALUE -1280        P 002830-                                                                .        P 002840* * list record function  *                                                  P 002850 01 MSG_TYPE_DEMO_LST_NEXT        PIC S9(9) USAGE COMP VALUE -1281        P 002860-                                                                .        P 002870* * list next record function *                                           P 002880 01 MSG_TYPE_DEMO_CLIENT_UP       PIC S9(9) USAGE COMP VALUE -1282        P 002890-                                                                .        P 002900* * client up             *                   
                               P 002910 01 MSG_TYPE_DEMO_CLIENT_DOWN     PIC S9(9) USAGE COMP VALUE -1283        P 002920-                                                                .        P 002930* * client down           *                                               P 002940                                                                          P 002950*  ************* End of PAMS_xxx_TYPE_CLASS **************                 w w         !ʕ  --N --************************************                                                                                                                                                                                                                                                   g                        u $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1]MBXSND.C;1;1                                                                                                                         TE "              ****************************************N --*                                                                          *N --*  Copyright (c) 1992                                                      *N --*  by DIGITAL Equipment Corporation, Maynard, Mass.                        *N --*                                                                          *N --*  This software is furnished under a license and may be used and  copied  *N --*  only  in  accordance  with  the  terms  of  such  license a   nd with the  *N --*  inclusion of the above copyright notice.  This software or  any  other  *N --*  copies  thereof may not be provided or otherwise made available to any  *N --*  other person.  No title to and ownership of  the  software  is  hereby  *N --*  transferred.                                                            *N --*                                                                          *N --*  The information in this software is subject to change  without  notice  *N --*  and     should  not  be  construed  as  a commitment by DIGITAL Equipment  *N --*  Corporation.                                                            *N --*                                                                          *N --*  DIGITAL assumes no responsibility for the use or  reliability  of  its  *N --*  software on equipment which is not supplied by DIGITAL.                 *N --*                                                                          *N --**********************************   ****************************************** with SYSTEM; use SYSTEM; with STARLET; use STARLET;0 with CONDITION_HANDLING; use CONDITION_HANDLING; with CDD_TYPES; use CDD_TYPES;    package PAMS_ADA_ENTRY_POINT is    1 --  module PAMS_ADA_ENTRY_POINT IDENT DMQ V2.0-02     --K --************************************************************************* ) --   Define PAMS structures used in calls K --*************************************************************************  -- --. --   Define the  	  queue address record data type --        type Q_ADDRESS_TYPE is 	record  	    QUEUE	: SHORT_INTEGER;  	    GROUP	: SHORT_INTEGER;  	end record;    	    for Q_ADDRESS_TYPE use  		record 		    QUEUE	at 0 range 0 .. 15;  		    GROUP	at 2 range 0 .. 15; 
 		end record; $ 	    for Q_ADDRESS_TYPE'SIZE use 32;   5     Q_ADDRESS_TYPE_INIT : constant Q_ADDRESS_TYPE :=   	    (QUEUE	=> 0,  	    GROUP	=> 0);    1 --   Define the PAMS Status Block (PSB) structure > --   Used for extended return st 
  atus' from PAMS and to obtain < --   the sequence number for later calls to PAMS_CONFIRM_MSG --        type PSB_TYPE is 	record ! 	    TYPE_OF_PSB	: SHORT_INTEGER; $ 	    CALL_DEPENDANT	: SHORT_INTEGER; 	    DEL_PSB_STATUS	: INTEGER;$ 	    SEQ_NUMBER	: UNSIGNED_QUADWORD; 	    UMA_PSB_STATUS	: INTEGER; 	    FUNCTION_STATUS	: INTEGER; 9 	    PSB_RESERVED	: STARLET.SHORT_INTEGER_ARRAY (1 .. 4);  	end record;    	    for PSB_TYPE use  		record% 		    TYPE_OF_PSB	at 0 range 0 .. 15; ( 		    CALL   _DEPENDANT	at 2 range 0 .. 15;( 		    DEL_PSB_STATUS	at 4 range 0 .. 31;$ 		    SEQ_NUMBER	at 8 range 0 .. 63;) 		    UMA_PSB_STATUS	at 16 range 0 .. 31; * 		    FUNCTION_STATUS	at 20 range 0 .. 31;' 		    PSB_RESERVED	at 24 range 0 .. 63; 
 		end record;  	    for PSB_TYPE'SIZE use 256;    )     PSB_TYPE_INIT : constant PSB_TYPE :=   	    (TYPE_OF_PSB	=> 0,  	    CALL_DEPENDANT	=> 0,  	    DEL_PSB_STATUS	=> 0,  	    SEQ_NUMBER	=> (0, 0), 	    UMA_PSB_STATUS	=> 0,  	    FUNCTION_STATUS	=> 0,$    	    PSB_RESERVED	=> (others => 0));    --* --   Define the PAMS Show Buffer structureI --   Used to return further information from PAMS_GET_MSG, PAMS_GET_MSGW,  --   and PAMS_GET_MSGA calls.  --        type SHOW_BUFFER_TYPE is 	record  	    VERSION	: INTEGER;  	    TRANSFER_STATUS	: INTEGER;  	    TRANSFER_SIZE	: INTEGER; 4 	    RESERVED	: SHORT_SHORT_INTEGER_ARRAY (1 .. 28); 	    TARGET	: INTEGER; 	    ORIGINAL_TARGET	: INTEGER;  	    SOURCE	: INTEGER; 	    ORIGINAL_SOURCE	: INTEGER;  
   	    DELIVERY	: INTEGER; 	    PRIORITY	: INTEGER; 	    ENDIAN	: INTEGER; 	end record;    	    for SHOW_BUFFER_TYPE use  		record! 		    VERSION	at 0 range 0 .. 31; ) 		    TRANSFER_STATUS	at 4 range 0 .. 31; ' 		    TRANSFER_SIZE	at 8 range 0 .. 31; $ 		    RESERVED	at 12 range 0 .. 223;! 		    TARGET	at 40 range 0 .. 31; * 		    ORIGINAL_TARGET	at 44 range 0 .. 31;! 		    SOURCE	at 48 range 0 .. 31; * 		    ORIGINAL_SOURCE	at 52 range 0 .. 31;# 		    DELIVERY	at 56 range 0 .. 31; # 		    PRIO   RITY	at 60 range 0 .. 31; ! 		    ENDIAN	at 64 range 0 .. 31; 
 		end record; ' 	    for SHOW_BUFFER_TYPE'SIZE use 544;    9     SHOW_BUFFER_TYPE_INIT : constant SHOW_BUFFER_TYPE :=   	    (VERSION	=> 0,  	    TRANSFER_STATUS	=> 0, 	    TRANSFER_SIZE	=> 0, 	    RESERVED	=> (others => 0),  	    TARGET	=> 0,  	    ORIGINAL_TARGET	=> 0, 	    SOURCE	=> 0,  	    ORIGINAL_SOURCE	=> 0, 	    DELIVERY	=> 0,  	    PRIORITY	=> 0,  	    ENDIAN	=> 0);    --, --   Define the Compound Selection data ty   pe --   *     type SELECTION_ARRAY_COMPONENT_TYPE is 	record  	    QUEUE	: INTEGER;  	    PRIORITY	: INTEGER; 	    KEY_1_OFFSET	: INTEGER; 	    KEY_1_SIZE	: INTEGER; 	    KEY_1_VALUE	: INTEGER;  	    KEY_1_OPER	: INTEGER; 	    KEY_2_OFFSET	: INTEGER; 	    KEY_2_SIZE	: INTEGER; 	    KEY_2_VALUE	: INTEGER;  	    KEY_2_OPER	: INTEGER; 	    ORDER_OFFSET	: INTEGER; 	    ORDER_SIZE	: INTEGER; 	    ORDER_ORDER	: INTEGER;  	end record;   , 	    for SELECTION_ARRAY_COMPONENT_TYPE use  		reco   rd 		    QUEUE	at 0 range 0 .. 31; " 		    PRIORITY	at 4 range 0 .. 31;& 		    KEY_1_OFFSET	at 8 range 0 .. 31;% 		    KEY_1_SIZE	at 12 range 0 .. 31; & 		    KEY_1_VALUE	at 16 range 0 .. 31;% 		    KEY_1_OPER	at 20 range 0 .. 31; ' 		    KEY_2_OFFSET	at 24 range 0 .. 31; % 		    KEY_2_SIZE	at 28 range 0 .. 31; & 		    KEY_2_VALUE	at 32 range 0 .. 31;% 		    KEY_2_OPER	at 36 range 0 .. 31; ' 		    ORDER_OFFSET	at 40 range 0 .. 31; % 		    ORDER_SIZE	at 44 range 0 .. 31; & 		    ORDER_ORDER	at 48 rang   e 0 .. 31;
 		end record; 5 	    for SELECTION_ARRAY_COMPONENT_TYPE'SIZE use 416;    U     SELECTION_ARRAY_COMPONENT_TYPE_INIT : constant SELECTION_ARRAY_COMPONENT_TYPE :=   	    (QUEUE	=> 0,  	    PRIORITY	=> 0,  	    KEY_1_OFFSET	=> 0,  	    KEY_1_SIZE	=> 0,  	    KEY_1_VALUE	=> 0, 	    KEY_1_OPER	=> 0,  	    KEY_2_OFFSET	=> 0,  	    KEY_2_SIZE	=> 0,  	    KEY_2_VALUE	=> 0, 	    KEY_2_OPER	=> 0,  	    ORDER_OFFSET	=> 0,  	    ORDER_SIZE	=> 0,  	    ORDER_ORDER	=> 0);     --. --   Arr   ay of records for a compound selectionL --   Used to pass an array of selection masks into the PAMS_SET_SELECT call. --8 type SELECTION_ARRAY_TYPE is array (integer range <>) of#     SELECTION_ARRAY_COMPONENT_TYPE; D     subtype SHORT_INTEGER_ARRAY_TYPE is STARLET.SHORT_INTEGER_ARRAY;:     subtype INTEGER_ARRAY_TYPE is CDD_TYPES.INTEGER_ARRAY; --K --************************************************************************* * --      Entry points for PAMS subroutines.K --******************************   *******************************************  --4 -- Attach queue interface:                          : -- Permanent process : Process Number is assigned by user: --        procedure PAMS_ATTACH_Q ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	ATTACH_MODE	: in  INTEGER;  	Q_ATTACHED	: out INTEGER;3 	Q_TYPE		: in  INTEGER			:= INTEGER'NULL_PARAMETER; 1 	Q_NAME		: in  STRING			:= STRING'NULL_PARAMETER; 6 	Q_NAME_LEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;F 	NAME_SPACE_LIST	: in  INTEGER
   _ARRAY		:= INTEGER_ARRAY'NULL_PARAMETER;> 	NAME_SPACE_LIST_LEN	: in  INTEGER		:= INTEGER'NULL_PARAMETER;4 	NULLARG1	: in  INTEGER			:= INTEGER'NULL_PARAMETER;4 	NULLARG2	: in  INTEGER			:= INTEGER'NULL_PARAMETER;5 	NULLARG3	: in  INTEGER			:= INTEGER'NULL_PARAMETER);    /     pragma INTERFACE (EXTERNAL, PAMS_ATTACH_Q);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_ATTACH_Q, "pams_attach_q", r 	(COND_VALUE_TYPE, INTEGER, INTEGER, INTEGER, STRING, INTEGER, INTEGER_ARRAY, INTEGER, INTEGER, INTEGER, INT   EGER),w 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE), 
 	 Q_TYPE);    --( -- Send of a message via program buffer: --        procedure PAMS_PUT_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return value$ 	MSG_AREA	: in  UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	TARGET_Q	: in  INTEGER; 	MSG_CLASS	: in  SHORT_INTEGER;  	MSG_TYPE	: in  SHORT_INTEGER;$ 	DELIVERY	: in  SHORT_SHORT_INTEGER; 	MSG_SIZE	: in  SH                                                                                                                                                                                                                                                   h                         $      DMQ020.B                       0C  C  ,[DMQ$V20.EXAMPLEY*OQW6T1*_:S3J9N]<]-)x~M;1                                                                                     U                             Y           Q?M'6wbB\}72o<z
6K49,R-AxJM?])h!+06mnEѭ~6<[QBHq;de&
P9X%y9s<Im;GDg @(U^~nW@XwT([""pCB[4
R-W0@NE"8oWKY\km$h7x(0Q9a-DGCXQ
i'<3Sf\\
qXCYk;]L]%0G,2X&$" e%^zc-+H>_"Hu3h$" Q9c?GNYNC<-xhvD9%c|XZq^\i
![L{?XFBwJwR
yKqO}ihh\qhs.%G,6Ay.M<ExBWtl
^_-c/bbNPP=:v_	p5m4\ .Q(]NiN//iysb89(g"@^d4:'#C[|W\S_#/?:ZV^hek{"QF'A4c|	=@oj!DTW%PTN
CW+,5e5KYDkw]M5Ac{[jN $<u"S30<!466(KkuRu ~@kZKx.t^q#5!KWpaQc
(Rptp
7 Sm|
=%DI;FR+/}zQ\B4p(,f{???`+-i>yjFQ*tT5\`+Rb<G)om[dvx|}m`KH"Vn0[TYk`HLF+g%]#AH5*-Q=I.-+0dahbedSf\d71 s!(
L<88w&8\W:Bd&E i(Czm?B~T7Y#'Tn'6mYrcP@Cv1,llM
1bl19rw<H5EIY?%D:O>IzT%c/q-Pw+*U7
OyZ4v;xcfR'Kp<S{8^4\W/&Ef)jf"6JW9
|j^==qA^6H=@q[mXC	i%!9*K0C/~h>P?"@*X@-&ZFB|tL6m.&gu?]EQMlx\[*xnr~y`hE)*?\x07a|5-9mT&KawTiJ;>ZiFY+WAGAM~SEB ,[A=FEn	@Hb|@3P( };.|VkOI
zSw'W[xuc+S[77	b,CU`G3Z)$$cYTJ,pZe&- A;Qby0M$Y?
y3;3ONhe2WthmLffn
}&=`BAMp;Svts8 \)yP+*;)=	@@<	SMv@e!!lWf8#64|-%?>0^{
-=+|>)j5?{%#\m~{o%
*'-b_)WS2J)Pdhd
_f&p%%Yf-`YC,HYSrMt1NFs^PpH.NXL)SZg%_HF+{N1
wL0l;*^YtY
$ktgb(Ig{L7(uDctd0Ü$r,jUE.REavUP3*(L3+;U+Ms#UH"}2j4s-	jX;^zgK
MC
<$6{gr)F7pQ7
	>0ry~{g`ĺKi,G#AA]UlaF*S: T}h.?$uPrv9u#{,kM!LY 
bUFRi7g>D
l_fi\{d	56%I=mfX
F\7ROj{{	s[)bXM,VmjP?ESI^5
fsiCc``^#7R _YZvydQW`#tJ^cp][Sc7o=66Vd2$` arT)JcR
q Ls@ ,B5E^%Pw mli sf``Tu2}?ilmWo]67vr@R`hdFb}rH~T=`*J1@W)_%B)c1yoLd&T}G @n<% 
e1@I.%+~`<p204-N' CK{F-fQ8_@"|]hh 23\όfO7"6$m.{GJ<Lsi?Rq8JO`W|GgMis.\0%`	3GvBv']b
f]:qj6\
{s#KL `;['K`X7-_!C2D6)gH%	TetNy
vtJ, n
&Mm#Z+[(Kxsd7	F39:aL/wWmvyT&yjI8+lFx0{(b$w?D2iD*-.K,EkD%H	-(<W|94,n@"b!W-pu6Z*>7Gr cHx'<\/%t  `'-X{E	Td2W$_s_2czsK=Ltf#c {QGZQ!:1KbgwT?y,!k!^c]-Tj=<.Q\'UP;J"k"6A$	4l2eEO<HPmo*~Va)p
oyXVaH&!ApQz
OpeQ/aG?8	/8=1 BNO@x;M	icpT;+*heoIYDR#fL=nRU$zeJM3ABhol<?_{C}W'qv0|u^/qt4mjfX??	S
v6@b~J)hK^-.ubQ2%RU4AU edk8`<1;qvW~OE* Lrto/N[+,+*mm zMWD$-jtD+;[V(nJcTT=E|r0AJ")B:wD! FDlsI4Sn$e{TNAYVY,$$X2YTVz#!-3`oA|`G"(Iw7/^UV'TJfwAKK1]b]zDW[B.nLtaiv2>@hk0))V"{'-%AV|ufOrcz%*[##mD%L*@jF;Yl	m@n:	\m<i$u\R3Z*H6l>tq>Q)a56I>1rhpUiUfjfT`MA\uMbSEV|Mc
`+Rf<>r0+w=h>:gwz^WfADSH;^g;)Lu@B\!7:"'gZT
iO#<Y[OXmyr+2w{: ZFs#|gDCE
;?Io59VtIkgnX $jZimNz`=/t6~Kcgm`xW&%8>(SSJ!@r=su`ldj}  w~f	X;t-8!i)1y%"%7^G?S>kY;ds% Ye'b|s\w_Opr-c)L%17AkA;W;+_WkhED7@F	MnFcmM2>+&X0z
} B>0Q0Ru)|
5sVFq+5e\SA8x?EV8eIro)LN[k1#}~6xkNIAVRr$Hh^@
dW
Bq6?I}[p ;:6tByJ.!qs*F
},QvA^
SpNnn<6?=C

m9O2YF
f mH|v2U;3`WT1UICL;Q_'1dޛfLr0GL%v-,F^B5oL|9zb94hITS g{4S!;5R
p"6P(pX1)?t=Km>VcM/<_s6XgbH8oo.}_`qP4w#,FCikuHcPQ{
	`lUqz]  o'{CmI
_zGz1wd9lNUV[WAFHmAa
3bRgQEuaSmv&]G~adXPaV*(rM`Y%i+=9?7wb,ZYKLr3ThW7Y+i
-#oppBS
H]i2,
IihF
DHDEnTo5LuOd!J.eW2`l	&@6r'B|ug,/N2^&*h#hPcIe]o-[A#&^Vh-
D*:!AKHyDuM? p;HL
sx'2='oXY-Xp

^@,kZtXP-:t|3=3PF?g`Qh~>J4%Tc|a-]L8uoz='2TuP`FNc
[` 4!$CQQ!<'T3j"sQY8nfwHv_;7O:IAQ,3a9{nwM!Q(1D{jopn`g#;Lf 2!+ydSt7yKSvd;_`3&6ADvbj]#S3TnhxV-Kp
T#dV,`oHZYtt@o'T:kn<9S+dW7q#za1TE]>-9k	cm|H
J"W
*G;LptPy7BV#L\Mx]1B	EmZBCRJ!zbNL1+Er7!)iAy+**@>b	A/Cjp_\'WP0!s'[ggr>]
P?KMSe(2P9<1;=/>w03HS
C`RtW=.)c4I^nZ hW.93l),boI5*2PMgSYFg|SG*J8~\)Am;M;pmb|DOQcae:90uk:iEpK|_CA%@R0xHC!#vh(U0D2r^0E+@oM}:|C|-Tr"}Y3-fpKI6OYOg`J $r%UE6r%= 5*iAz}xL(ODZrtoCP] iNvyC|RAHqLAd1a3=cFCV)]n0VnC3z0ma3}e-kS~6ayX;:dfw3FI*Mpwd+`6h0X *
Ek)%jR6"'P"RPWVMm~9Ry+_wwV1Gk(gzau|p(}Cb/X!K hqLNhMm	Ud)oIdY#]9]R]%EWi_?i$]t/:ZS$3LSB["^Qz97<	&P2"bze@"h~\+hX@
5ZUflR0IU[D&U:5w	f,nqhhX|&BX3*a2.Dd/Yp^[l&g:B(ՊM{BQ>\C2.5ZZVDU@(fV$7l3rJq4P69'D>:1$D\s[(HA0mtw&a}wGX]&}"
sr/8f,d'a0{~uzjf1e[K&&
+B<)]`E]&:6^y7ULD-=[J%4hl|QTG&aN*FqF,UU?
BBd2g=p(Klzfpb0)
m36WsuX$.yyU*:}VN2ffPA0Vr,rXa
/V~";!3Yw
5D|RtBb3~if_xO u&9|q(Io"T`p51X\^O:-.N+}g_,}N.S`7<8n#(;:VpGYPjm^%-
$+B~'s3=+F9>VkZ1Jt:} C2	H(\\j,Z<^ltuAR&cvr:P>UuRysAJ| M[lYCp1|2cdS.nv#Rl3@6b\I#YGqX}HFNuhGB{?WC1W]SddQxeXl\Q!I~M6T3:*gyPV O1Plf U0c}Gp34'd>)lJ+1- BFd	H6LBb0JBtcIu:yOKixtuorDFmeUlCiWyP;* 7-JW'lJ !13[t([!Ug2_U7itvWk|L
ZX
3xuHmX)#=.wNPUZNTk[12.O!X T~ad\[HyMh6'wd1)+Uk@IUF#mb| qoA="FC)ac1Rp>kJK.%}\1m+c9dk.>J
fhS?Y'oOoh+YjU+.D,2E_gRO!/<&J|
A;9Wb;
R:#k SY;XZ||S[K%+%kIe{kam)D/:#0I ;`$a~H8jturBTw,KG,`Py/8WIIC,.KN3:vTFoSLgR1<h'Kd

fYGb"0K;Cr*en0Eky91-J
l_xc
1tl H9, -$J)I	=NGANu.jWSA+ft'J;DW!OHeo4!?Wc22p|J-GKlXPmRgc'-HO`+fNuT]@dDY12`Rfr#b4tS[Coe/?S]	"q%kA>Zn8:=R/
rIhOeh~0$w~!" Rj(g#,V Hc&)HFscf
dkDUv393om8V&C0y[BKoF&6EUX4MHw:XZ*mqQoTL(( d`0s*YuH	DN+ OjSe+3y"I8M 5O:/c2PfGW>PRH[F]EuE
KNAoR_neMn;6 Cu8HLg{Y
Ea
{a&]h޳y:smF+س"ojLWyb4gS^(vb"7q
aRY/X{H]jqv"kFB0AQ: 7tD 12/I0F.y)up_U
[~grH*OJ3yk}S,
^@v'$$_ 
@[ hܦ㙷q`CV+0NJoomEKf%(
6JwD;Z . .cgU>ie,MaX|XF1cQ2~/w/dv#;Fp_S$ER9(g@CvB@ J;`$59w
4c/!>g͡VS~D";OYT Rl&Ydzgzgf,WfR
|r),eEGfP[*!5`~tZ={M\~s$Yc@ `/@WQVqFQ^&n%Kp%py,/_0'~se\WEW 3#3r>|U90Woyj8SfY2h|OG?@@
G	C!i(}\7\		p6QTAs';Wfm]fxaKR3^	1& lP	oTozg}TG[CGmpcTZ\L+m-?8MQG:I}aFHd:'yw|
j}8z[E\%w_:U2R_]9FWKDd6|E)'_ 4wn7D&Bb>)r|&{XU0|je*lk8GM+pdo;T<V>.NWX3U3~:fN 7FN^A ,m(	<?D0.RepG74M`.=
y=P3!w=.
)]_i?Dl+d'9CNVz5@+%D_(wM_
S*YbjL1yg3 {BW1{@
1kPRP&5rva
Cg=uDF [9tmepo7vr1:O~
8UeRFbPG\$"y#P3XT Z4qQpi *%"M N'$d	l""MjTu,H^H:k&L3nl\D#jJ=@Xs'}}jpOZ 0&S	1Y6d.[&>'sB .:pR$z~'s08\L%wx#L1X:AgK6&C~1)$9bB{(ElK9,C
b++ !v,/|<|dxTb( 'hz;lz 
uU`pDM&]
QÂM57[5bio}or)GST[<D}JTǛpS
?ONiǭ%lb'Y:DH(%aq^HOGb6&_tbf.x)n#h5$=A
"i/I!N?SG3may"`uL^>C6c`;7xa1958?@]a+ٵߚ_S^|ka{Ol`'tlxc	 DT\8@pYy1*Oh;f)^3ck6u[Y$m='D
 \-Mb}4)ys~r?SS[_.@MUA;QW6%i\7mXkv9>s6`%6GgB&6Y13O*qC~~*	Tx
%cqXal7/G[cn5hzAyL(l|fHxqT_M#:wm?orJ*WddA_0:58Z9(/)7}I.@y]s^80UaUJ\u}NUS$Nw$
~opv!|e/v.0rDv',\rBn.#1kasB
eJNvGGjdPhA)d0N9c@9KZbNp927P+iK[)y1bPa%Abai+lDNvAJ6SR(3,&!")VA[KJ]]LULF0nW46C?yCI{IX@i?\D}%7\u,VnIw2|8YcTpce.(ZNp{)7MLGb7#xPsBCOc13muxr`/ACnBt ictgR~nE1t<A\Q=x'&%fB	G_ZlvW5LVEBo%_o0cNQn,Fu>Yg	@cr(t	Fu8oHBV3DsBw]
<i$j~*22N_8
gi2)4>F,?EJ'D^<|1*fXCu/?*{MPQ@e9*Dpa'bXOqzK}wlux/bg,pPj,6gSN{v-AtX/-kV=<a,GWz89VKwlZE~Gd)~k DXu'X@9bgv JJ'}h`kt. uyWG4D/tW=y:=JJzWF/|jBT\uH"tp2of$APaqP
:1twk&$#;ˣӷ@.bWEC1!93H&BY	'-~w}H}WLBo81uX4~LmRc]%nu!:UKuxeE"kTZCBpZ;<j^/FJOmhd40^f
$\50y&Ic} [^
1cWEgkQyECN{>2>|:w$D+Xbvv%;nLX!lB	rOc9q(mW~Z^igBI6e-[aBV@Wg&x|UHktoY
} %HXp/a:^OfTtJ,X7Mm\^`AyFuHX/
MATJAP.w:N$y:IH$\(si#eSjoa4gi0v?1SZb[jlbL&J|TV=ho02tzbUK;&j9@67#FRvd.#~8GgD
4wl+{Fv'eSX_6*B:+6`]%fTMYQTRooR \3,tqO9E"6eq:{/'/
(eB#=&w
8
^qR0i}m|0s0YRGsK(dP|8|>'_%wId{.}
))nBzdeV(CF),{OLX..N}.5*v'6vjiE\(GHOqXTx-EyvxSP GE"H6/W
eJ\,^21$fFl~!(bl)vN<N.dPkzEP"EH8GI^^ =
T4	(l)k_9:h ;c,We,vo1aV.U*mE a2&n]4K{\g"Z
3xde@Qz`\=dj0!Y*\vnZ':9Tb:1cA67Y\lx6:5W[<WGYIxcQ}i
ZYD]3d~nSEJLrGYako3d*0u7 2iI=#
s.Rk9;@69ERHn`(H3# zFG#'I|``Fl:Q 3t3w[#0kxod1lP-k9mopo;+CO!JD:_L9o2Rxt#(8\C LcMXT5f6".8vybO|D' C$1aI3B"Luw{yId迥߀;jfS~9iTNpKw<3SGe)W\4Lxde'@5vV
a '?9U^]ozUf)0wFr8-y5ODET|s+Tk1csjpFNNyUfdB9Dl? C ,#UMpbjqK|	he?<mpJT +OvMA^&b(K"]OWTGz.p2X?X,5peH1[p+oe+qh55W\IB<SI:#P`:1p[&`3'T^Y/Rp="I;;k 102,  PAMS_DEMO_IO_SERVER_3                                                                                                                                                                                                                        i                         $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1]TTSND.C;1E.C;1                                                                                                                       4/ "              ORT_INTEGER;4 	TIMEOUT		: in  INTEGER			:= INTEGER'NULL_PARAMETER;" 	PAMS_STATUS_BLOCK	: out PSB_TYPE;F 	UMA		: in  SHORT_SHORT_INTEGER	:= SHORT_SHORT_INTEGER'NULL_PARAMETER;3 	RESP_Q		: in  INTEGER			:= INTEGER'NULL_PARAMETER; 4 	NULLARG1	: in  INTEGER			:= INTEGER'NULL_PARAMETER;4 	NULLARG2	: in  INTEGER			:= INTEGER'NULL_PARAMETER;5 	NULLARG3	: in  INTEGER			:= INTEGER'NULL_PARAMETER);         procedure PAMS_PUT_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return value$ 	MSG_AREA	: in  UNSIGNED_B   YTE_ARRAY;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	TARGET_Q	: in  INTEGER; 	MSG_CLASS	: in  SHORT_INTEGER;  	MSG_TYPE	: in  SHORT_INTEGER;$ 	DELIVERY	: in  SHORT_SHORT_INTEGER; 	MSG_SIZE	: in  SHORT_INTEGER;4 	TIMEOUT		: in  INTEGER			:= INTEGER'NULL_PARAMETER;a 	PAMS_STATUS_BLOCK	: in  ADDRESS		:= ADDRESS_ZERO;	-- To omit optional PAMS_STATUS_BLOCK argument F 	UMA		: in  SHORT_SHORT_INTEGER	:= SHORT_SHORT_INTEGER'NULL_PARAMETER;3 	RESP_Q		: in  INTEGER			:= INTEGER'NULL_PARAMETER; 4 	NULLARG1	: in
     INTEGER			:= INTEGER'NULL_PARAMETER;4 	NULLARG2	: in  INTEGER			:= INTEGER'NULL_PARAMETER;5 	NULLARG3	: in  INTEGER			:= INTEGER'NULL_PARAMETER);    .     pragma INTERFACE (EXTERNAL, PAMS_PUT_MSG);   A     pragma IMPORT_VALUED_PROCEDURE (PAMS_PUT_MSG, "pams_put_msg", c 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, q 	SHORT_SHORT_INTEGER, SHORT_INTEGER, INTEGER, PSB_TYPE, SHORT_SHORT_INTEGER, INTEGER, INTEGER, INTEGER, INTEGER), k 	(VALUE, REFER   ENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, 8 	REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE), 	 UMA);    A     pragma IMPORT_VALUED_PROCEDURE (PAMS_PUT_MSG, "pams_put_msg", c 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, p 	SHORT_SHORT_INTEGER, SHORT_INTEGER, INTEGER, ADDRESS, SHORT_SHORT_INTEGER, INTEGER, INTEGER, INTEGER, INTEGER),r 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, R   EFERENCE, REFERENCE, REFERENCE, REFERENCE, VALUE, REFERENCE,- 	REFERENCE, REFERENCE, REFERENCE, REFERENCE),  	 TIMEOUT);     --8 --  Non-waited Receive of a message via program buffer:  --        procedure PAMS_GET_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return value$ 	MSG_AREA	: out UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;! 	AREA_LENGTH	: in  SHORT_INTEGER;   	MSG_LENGTH	: out SHOR
   T_INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;" 	PAMS_STATUS_BLOCK	: out PSB_TYPE;$ 	SHOW_BUFFER	: out SHOW_BUFFER_TYPE;8 	SHOW_BUFFLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;2 	USER_TAG	: in  STRING			:= STRING'NULL_PARAMETER;7 	USER_TAGLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER; 5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARAMETER);         procedure PAMS_GET_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return value$ 	MSG_AREA	: out UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: in  SH   ORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;! 	AREA_LENGTH	: in  SHORT_INTEGER;   	MSG_LENGTH	: out SHORT_INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;" 	PAMS_STATUS_BLOCK	: out PSB_TYPE;V 	SHOW_BUFFER	: in  ADDRESS			:= ADDRESS_ZERO;	-- To omit optional SHOW_BUFFER argument8 	SHOW_BUFFLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;2 	USER_TAG	: in  STRING			:= STRING'NULL_PARAMETER;7 	USER_TAGLEN	: in  INTEGER			:= INTE   GER'NULL_PARAMETER; 5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARAMETER);         procedure PAMS_GET_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return value$ 	MSG_AREA	: out UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;! 	AREA_LENGTH	: in  SHORT_INTEGER;   	MSG_LENGTH	: out SHORT_INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;a 	PAMS_STATUS_BLOCK	: in  ADDRESS		:= ADDRESS_ZERO;   	-- To omit optional PAMS_STATUS_BLOCK argument V 	SHOW_BUFFER	: in  ADDRESS			:= ADDRESS_ZERO;	-- To omit optional SHOW_BUFFER argument8 	SHOW_BUFFLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;2 	USER_TAG	: in  STRING			:= STRING'NULL_PARAMETER;7 	USER_TAGLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER; 5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARAMETER);         procedure PAMS_GET_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return value$ 	MSG_AREA	: out UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: in  SHOR   T_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;! 	AREA_LENGTH	: in  SHORT_INTEGER;   	MSG_LENGTH	: out SHORT_INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;a 	PAMS_STATUS_BLOCK	: in  ADDRESS		:= ADDRESS_ZERO;	-- To omit optional PAMS_STATUS_BLOCK argument $ 	SHOW_BUFFER	: out SHOW_BUFFER_TYPE;8 	SHOW_BUFFLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;2 	USER_TAG	: in  STRING			:= STRING'NULL_PARAMETER;7 	USER_TAGLEN	: in  INTEG	    ER			:= INTEGER'NULL_PARAMETER; 5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARAMETER);    .     pragma INTERFACE (EXTERNAL, PAMS_GET_MSG);   A     pragma IMPORT_VALUED_PROCEDURE (PAMS_GET_MSG, "pams_get_msg", r 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER,X 	SHORT_INTEGER, INTEGER, PSB_TYPE, SHOW_BUFFER_TYPE, INTEGER, STRING, INTEGER, INTEGER),k 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, 	 !  REFERENCE, REFERENCE, 8 	REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE), 	 SHOW_BUFFLEN);   A     pragma IMPORT_VALUED_PROCEDURE (PAMS_GET_MSG, "pams_get_msg", r 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER,O 	SHORT_INTEGER, INTEGER, PSB_TYPE, ADDRESS, INTEGER, STRING, INTEGER, INTEGER), r 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, VALUE,- 	REFERENCE, REFERENC "  E, REFERENCE, REFERENCE),  	 SHOW_BUFFER);    A     pragma IMPORT_VALUED_PROCEDURE (PAMS_GET_MSG, "pams_get_msg", r 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER,N 	SHORT_INTEGER, INTEGER, ADDRESS, ADDRESS, INTEGER, STRING, INTEGER, INTEGER),n 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, VALUE, VALUE,- 	REFERENCE, REFERENCE, REFERENCE, REFERENCE),  	 SEL_ADDR);   A     pragma IMP
 #  ORT_VALUED_PROCEDURE (PAMS_GET_MSG, "pams_get_msg", r 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER,W 	SHORT_INTEGER, INTEGER, ADDRESS, SHOW_BUFFER_TYPE, INTEGER, STRING, INTEGER, INTEGER), r 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, VALUE, REFERENCE,- 	REFERENCE, REFERENCE, REFERENCE, REFERENCE),  	 SHOW_BUFFLEN);    --3 --  Waited Receive of a message via program buffer:  -- $          procedure PAMS_GET_MSGW ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value$ 	MSG_AREA	: out UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;! 	AREA_LENGTH	: in  SHORT_INTEGER;   	MSG_LENGTH	: out SHORT_INTEGER; 	RCV_TMO		: in  INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;" 	PAMS_STATUS_BLOCK	: out PSB_TYPE;$ 	SHOW_BUFFER	: out SHOW_BUFFER_TYPE;8 	SHOW_BUFFLEN	: in  INTE %  GER			:= INTEGER'NULL_PARAMETER;2 	USER_TAG	: in  STRING			:= STRING'NULL_PARAMETER;7 	USER_TAGLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER; 5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARAMETER);         procedure PAMS_GET_MSGW ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value$ 	MSG_AREA	: out UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;! 	AREA_LENGTH	: in  SHORT_INTEGER;   	MSG_LENGTH	:  &  out SHORT_INTEGER; 	RCV_TMO		: in  INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;" 	PAMS_STATUS_BLOCK	: out PSB_TYPE;V 	SHOW_BUFFER	: in  ADDRESS			:= ADDRESS_ZERO;	-- To omit optional SHOW_BUFFER argument8 	SHOW_BUFFLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;2 	USER_TAG	: in  STRING			:= STRING'NULL_PARAMETER;7 	USER_TAGLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER; 5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARAMETER);         procedure PAMS_GET_MSGW ( 2 	STATUS		: out COND_VA                                                                                                                                                                                                                                                   j                        . $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1]TTSND.C;1E.C;1                                                                                                                        "     &       '  LUE_TYPE;				-- return value$ 	MSG_AREA	: out UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;! 	AREA_LENGTH	: in  SHORT_INTEGER;   	MSG_LENGTH	: out SHORT_INTEGER; 	RCV_TMO		: in  INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;a 	PAMS_STATUS_BLOCK	: in  ADDRESS		:= ADDRESS_ZERO;	-- To omit optional PAMS_STATUS_BLOCK argument V 	SHOW_BUFFER	: in  ADDRESS			:= ADDRESS_ZERO;	-- To omit o
 (  ptional SHOW_BUFFER argument8 	SHOW_BUFFLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;2 	USER_TAG	: in  STRING			:= STRING'NULL_PARAMETER;7 	USER_TAGLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER; 5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARAMETER);         procedure PAMS_GET_MSGW ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value$ 	MSG_AREA	: out UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGE )  R;! 	AREA_LENGTH	: in  SHORT_INTEGER;   	MSG_LENGTH	: out SHORT_INTEGER; 	RCV_TMO		: in  INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;a 	PAMS_STATUS_BLOCK	: in  ADDRESS		:= ADDRESS_ZERO;	-- To omit optional PAMS_STATUS_BLOCK argument $ 	SHOW_BUFFER	: out SHOW_BUFFER_TYPE;8 	SHOW_BUFFLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;2 	USER_TAG	: in  STRING			:= STRING'NULL_PARAMETER;7 	USER_TAGLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER; 5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARA	 *  METER);    /     pragma INTERFACE (EXTERNAL, PAMS_GET_MSGW);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_GET_MSGW, "pams_get_msgw", r 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER,a 	SHORT_INTEGER, INTEGER, INTEGER, PSB_TYPE, SHOW_BUFFER_TYPE, INTEGER, STRING, INTEGER, INTEGER), k 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, C 	REFERENCE, REFERENCE, REFERENCE, REFERENC	 +  E, REFERENCE, REFERENCE),  	 SHOW_BUFFLEN);   C     pragma IMPORT_VALUED_PROCEDURE (PAMS_GET_MSGW, "pams_get_msgw", r 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER,X 	SHORT_INTEGER, INTEGER, INTEGER, PSB_TYPE, ADDRESS, INTEGER, STRING, INTEGER, INTEGER),k 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, ? 	REFERENCE, VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE),  	 SH
 ,  OW_BUFFER);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_GET_MSGW, "pams_get_msgw", r 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER,W 	SHORT_INTEGER, INTEGER, INTEGER, ADDRESS, ADDRESS, INTEGER, STRING, INTEGER, INTEGER), r 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, VALUE,4 	VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE), 	 SEL_ADDR);   C     pragma IMPORT_VALUED
 -  _PROCEDURE (PAMS_GET_MSGW, "pams_get_msgw", r 	(COND_VALUE_TYPE, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER,` 	SHORT_INTEGER, INTEGER, INTEGER, ADDRESS, SHOW_BUFFER_TYPE, INTEGER, STRING, INTEGER, INTEGER),r 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, VALUE,8 	REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE), 	 SHOW_BUFFLEN);       --: --  Asynchronous Receive of a message via  .  program buffer:  -- --! --  New style entry - recommended  --        procedure PAMS_GET_MSGA ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	MSG_AREA	: in  ADDRESS;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: in  ADDRESS; 	MSG_CLASS	: in  ADDRESS;  	MSG_TYPE	: in  ADDRESS;! 	AREA_LENGTH	: in  SHORT_INTEGER;  	MSG_LENGTH	: in  ADDRESS;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;< 	PAMS_STATUS_BLOCK	: in  ADDRESS		:= ADDRESS'NULL_PARAMETER;7 	SHOW_BUFFER	: in  ADDRESS		 /  	:= ADDRESS'NULL_PARAMETER; 8 	SHOW_BUFFLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;2 	USER_TAG	: in  STRING			:= STRING'NULL_PARAMETER;7 	USER_TAGLEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER; . 	ACTRTN		: in  AST_HANDLER		:= NO_AST_HANDLER;4 	ACTPARM		: in  INTEGER			:= INTEGER'NULL_PARAMETER;4 	FLAG_ID		: in  INTEGER			:= INTEGER'NULL_PARAMETER;5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARAMETER);    /     pragma INTERFACE (EXTERNAL, PAMS_GET_MSGA);    C     pragma IMPORT_VALUED_PROCEDURE (PA 0  MS_GET_MSGA, "pams_get_msga", u 	(COND_VALUE_TYPE, ADDRESS, SHORT_SHORT_INTEGER, ADDRESS, ADDRESS, ADDRESS, SHORT_INTEGER, ADDRESS, INTEGER, ADDRESS, L 	ADDRESS, INTEGER, STRING, INTEGER, AST_HANDLER, INTEGER, INTEGER, INTEGER),p 	(VALUE, VALUE, REFERENCE, VALUE, VALUE, VALUE, REFERENCE, VALUE, REFERENCE, VALUE, VALUE, REFERENCE, REFERENCE,4 	REFERENCE, VALUE, REFERENCE, REFERENCE, REFERENCE), 	 SEL_ADDR);    --, --  Cancel pending PAMS_GET_MSGA request(s): --        procedure PAMS_CANCEL_GET (  1  2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	SEL_ADDR	: in  INTEGER);    1     pragma INTERFACE (EXTERNAL, PAMS_CANCEL_GET);    G     pragma IMPORT_VALUED_PROCEDURE (PAMS_CANCEL_GET, "pams_cancel_get",  	(COND_VALUE_TYPE, INTEGER), 	(VALUE, REFERENCE));     -- --  Confirm an MRS message:  --         procedure PAMS_CONFIRM_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return value" 	SEQ_VAR		: in  UNSIGNED_QUADWORD; 	STATUS_CODE	: in  INTEGER; ' 	J_OVERRIDE	: in  SHORT_SHORT_INTEGER) 2  ;    2     pragma INTERFACE (EXTERNAL, PAMS_CONFIRM_MSG);   I     pragma IMPORT_VALUED_PROCEDURE (PAMS_CONFIRM_MSG, "pams_confirm_msg", D 	(COND_VALUE_TYPE, UNSIGNED_QUADWORD, INTEGER, SHORT_SHORT_INTEGER),+ 	(VALUE, REFERENCE, REFERENCE, REFERENCE));     -- --  Set a PAMS timer:  --        procedure PAMS_SET_TIMER (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	TIMER_ID	: in  INTEGER; 	TIMER_FORMAT	: in  CHARACTER; 	P_TIMEOUT	: in  INTEGER; $ 	S_TIMEOUT	: in  UNSIGNED_QUADWORD);    3  0     pragma INTERFACE (EXTERNAL, PAMS_SET_TIMER);   E     pragma IMPORT_VALUED_PROCEDURE (PAMS_SET_TIMER, "pams_set_timer", C 	(COND_VALUE_TYPE, INTEGER, CHARACTER, INTEGER, UNSIGNED_QUADWORD), 6 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE));    --' --  Cancel a previously set PAMS timer:  --   !     procedure PAMS_CANCEL_TIMER ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	TIMER_ID	: in  INTEGER);    3     pragma INTERFACE (EXTERNAL, PAMS_CANCEL_TIMER);    K     pragma IMPOR 4  T_VALUED_PROCEDURE (PAMS_CANCEL_TIMER, "pams_cancel_timer",  	(COND_VALUE_TYPE, INTEGER), 	(VALUE, REFERENCE));     --1 --  Terminate connection to the PAMS Message Bus:  --        procedure PAMS_EXIT ( 3 	STATUS		: out COND_VALUE_TYPE);				-- return value    +     pragma INTERFACE (EXTERNAL, PAMS_EXIT);    ;     pragma IMPORT_VALUED_PROCEDURE (PAMS_EXIT, "pams_exit",  	(COND_VALUE_TYPE), 
 	(VALUE));    --& --  Release a message selection Index: --   "     procedure PAMS_CANCEL_SELECT ( 5  2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	INDEX_HANDLE	: in  INTEGER);    4     pragma INTERFACE (EXTERNAL, PAMS_CANCEL_SELECT);   M     pragma IMPORT_VALUED_PROCEDURE (PAMS_CANCEL_SELECT, "pams_cancel_select",  	(COND_VALUE_TYPE, INTEGER), 	(VALUE, REFERENCE));     --& --  Obtain a message selection Index:  --        procedure PAMS_SET_SELECT ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value, 	SELECTION_ARRAY	: in  SELECTION_ARRAY_TYPE; 	NUM_MASKS	: in  SHORT_INTEGER;  	I 6  NDEX_HANDLE	: out INTEGER);    1     pragma INTERFACE (EXTERNAL, PAMS_SET_SELECT);    G     pragma IMPORT_VALUED_PROCEDURE (PAMS_SET_SELECT, "pams_set_select", A 	(COND_VALUE_TYPE, SELECTION_ARRAY_TYPE, SHORT_INTEGER, INTEGER), + 	(VALUE, REFERENCE, REFERENCE, REFERENCE));     -- --  Open a  DLJ or PCJ:  --        procedure PAMS_OPEN_JRN ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	JRN_FILESPEC	: in  STRING; & 	JRN_FILESPEC_LEN	: in  SHORT_INTEGER; 	JRN_HANDLE	: out INTEGER);     7  /     pragma INTERFACE (EXTERNAL, PAMS_OPEN_JRN);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_OPEN_JRN, "pams_open_jrn", 3 	(COND_VALUE_TYPE, STRING, SHORT_INTEGER, INTEGER), + 	(VALUE, REFERENCE, REFERENCE, REFERENCE));     --* --  Extract a message from the DLJ or PCJ: --        procedure PAMS_READ_JRN ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	JRN_HANDLE	: in  INTEGER;$ 	MSG_AREA	: out UNSIGNED_BYTE_ARRAY;$ 	PRIORITY	: out SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_C                                                                                                                                                                                                                                                   k                         $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1HDOG.C;1PLE.C;1                                                                                                                        "     7       8  LASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;! 	AREA_LENGTH	: in  SHORT_INTEGER;   	MSG_LENGTH	: out SHORT_INTEGER; 	TARGET		: out INTEGER; $ 	WRITE_TIME	: out UNSIGNED_QUADWORD; 	CONF_VAL	: out INTEGER;% 	MSG_SEQ_NUM	: out UNSIGNED_QUADWORD;  	MRS_STATUS	: out INTEGER);    /     pragma INTERFACE (EXTERNAL, PAMS_READ_JRN);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_READ_JRN, "pams_read_jrn", l 	(COND_VALUE_TYPE, INTEGER, UNSIGNED_BYTE_ARRAY, SHORT_SHORT_INTEGER, INTEGER, SHORT_INT 9  EGER, SHORT_INTEGER,` 	SHORT_INTEGER, SHORT_INTEGER, INTEGER, UNSIGNED_QUADWORD, INTEGER, UNSIGNED_QUADWORD, INTEGER),k 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, . 	REFERENCE, REFERENCE, REFERENCE, REFERENCE));    --: --  Close a  DLJ or PCJ which was opend via PAMS_OPEN_JRN: --        procedure PAMS_CLOSE_JRN (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	JRN_HANDLE	: in  INTEGER);    0     pragma INTERFACE (EXTERNAL, PA :  MS_CLOSE_JRN);   E     pragma IMPORT_VALUED_PROCEDURE (PAMS_CLOSE_JRN, "pams_close_jrn",  	(COND_VALUE_TYPE, INTEGER), 	(VALUE, REFERENCE));     -- --  Translate a PAMS Queue Name  --        procedure PAMS_LOCATE_Q ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	Q_NAME		: in  STRING; 	Q_NAME_LEN	: in  INTEGER; 	Q_ADDRESS	: out INTEGER; 5 	WAIT_MODE	: in  INTEGER			:= INTEGER'NULL_PARAMETER; 3 	REQ_ID		: in  INTEGER			:= INTEGER'NULL_PARAMETER; 3 	RESP_Q		: in  INTEGER			:= INTEGER'
 ;  NULL_PARAMETER; F 	NAME_SPACE_LIST	: in  INTEGER_ARRAY		:= INTEGER_ARRAY'NULL_PARAMETER;> 	NAME_SPACE_LIST_LEN	: in  INTEGER		:= INTEGER'NULL_PARAMETER;5 	NULLARG		: in  INTEGER			:= INTEGER'NULL_PARAMETER);    /     pragma INTERFACE (EXTERNAL, PAMS_LOCATE_Q);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_LOCATE_Q, "pams_locate_q", i 	(COND_VALUE_TYPE, STRING, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER_ARRAY, INTEGER, INTEGER), l 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFEREN <  CE, REFERENCE, REFERENCE, REFERENCE, REFERENCE),
 	 WAIT_MODE);     --K --************************************************************************* + --         Define the Obsolete Entry Points K --*************************************************************************  --: -- Process delaration interface:                          : -- Permanent process : Process Number is assigned by user: --         procedure PAMS_DCL_PROCESS (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	PROC_NUM	:  =  in  INTEGER; 	PROC_NUM2	: out INTEGER; 3 	Q_TYPE		: in  INTEGER			:= INTEGER'NULL_PARAMETER; 1 	Q_NAME		: in  STRING			:= STRING'NULL_PARAMETER; 6 	Q_NAME_LEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;7 	NAME_SCOPE	: in  INTEGER			:= INTEGER'NULL_PARAMETER);          procedure PAMS_DCL_PROCESS (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	PROC_NUM	: in  INTEGER;R 	PROC_NUM2	: in  ADDRESS			:= ADDRESS_ZERO;	-- To omit optional PROC_NUM2 argument3 	Q_TYPE		: in  INTEGER			:= INTEGER'NULL_PAR
 >  AMETER; 1 	Q_NAME		: in  STRING			:= STRING'NULL_PARAMETER; 6 	Q_NAME_LEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER;7 	NAME_SCOPE	: in  INTEGER			:= INTEGER'NULL_PARAMETER);    2     pragma INTERFACE (EXTERNAL, PAMS_DCL_PROCESS);   I     pragma IMPORT_VALUED_PROCEDURE (PAMS_DCL_PROCESS, "pams_dcl_process", H 	(COND_VALUE_TYPE, INTEGER, INTEGER, INTEGER, STRING, INTEGER, INTEGER),K 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE), 
 	 Q_TYPE);   I     pragma IMPORT_VALUED_P ?  ROCEDURE (PAMS_DCL_PROCESS, "pams_dcl_process", H 	(COND_VALUE_TYPE, INTEGER, ADDRESS, INTEGER, STRING, INTEGER, INTEGER),G 	(VALUE, REFERENCE, VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE), 
 	 PROC_NUM2);     --% -- Obtain a message pointer from PAMS  --        procedure PAMS_ALLOC_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	MSG_SIZE	: in  SHORT_INTEGER; 	MSG_PTR		: out ADDRESS);    0     pragma INTERFACE (EXTERNAL, PAMS_ALLOC_MSG);   E     pragma IMPORT_VALUED_PROCEDURE @   (PAMS_ALLOC_MSG, "pams_alloc_msg", + 	(COND_VALUE_TYPE, SHORT_INTEGER, ADDRESS),   	(VALUE, REFERENCE, REFERENCE));    --% -- Send a message via a PAMS pointer:  --        procedure PAMS_SEND_MSG ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	MSG_PTR		: in  ADDRESS;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	TARGET_Q	: in  INTEGER; 	MSG_CLASS	: in  SHORT_INTEGER;  	MSG_TYPE	: in  SHORT_INTEGER;$ 	DELIVERY	: in  SHORT_SHORT_INTEGER;4 	TIMEOUT		: in  INTEGER			:= INTEGER'NULL_PARAMETER;"  A  	PAMS_STATUS_BLOCK	: out PSB_TYPE;F 	UMA		: in  SHORT_SHORT_INTEGER	:= SHORT_SHORT_INTEGER'NULL_PARAMETER;4 	RESP_Q		: in  INTEGER			:= INTEGER'NULL_PARAMETER);        procedure PAMS_SEND_MSG ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	MSG_PTR		: in  ADDRESS;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	TARGET_Q	: in  INTEGER; 	MSG_CLASS	: in  SHORT_INTEGER;  	MSG_TYPE	: in  SHORT_INTEGER;$ 	DELIVERY	: in  SHORT_SHORT_INTEGER;4 	TIMEOUT		: in  INTEGER			:= INTEGER'NULL_PARAMETER;a 	PAMS_ST	 B  ATUS_BLOCK	: in  ADDRESS		:= ADDRESS_ZERO;	-- To omit optional PAMS_STATUS_BLOCK argument F 	UMA		: in  SHORT_SHORT_INTEGER	:= SHORT_SHORT_INTEGER'NULL_PARAMETER;4 	RESP_Q		: in  INTEGER			:= INTEGER'NULL_PARAMETER);   /     pragma INTERFACE (EXTERNAL, PAMS_SEND_MSG);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_SEND_MSG, "pams_send_msg", u 	(COND_VALUE_TYPE, ADDRESS, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_SHORT_INTEGER, INTEGER, ) 	PSB_TYPE, SHORT_SHORT_INTEGER, INTEGER) C  , s 	(VALUE, VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE),  	 UMA);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_SEND_MSG, "pams_send_msg", u 	(COND_VALUE_TYPE, ADDRESS, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_SHORT_INTEGER, INTEGER, ( 	ADDRESS, SHORT_SHORT_INTEGER, INTEGER),o 	(VALUE, VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, VALUE, REFERENCE, REFERENCE),  	 TIMEOUT);     --7 -- D    Non-waited Receive of a message via a PAMS pointer:  --        procedure PAMS_RCV_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	MSG_PTR		: out ADDRESS;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;  	MSG_LENGTH	: out SHORT_INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;# 	PAMS_STATUS_BLOCK	: out PSB_TYPE);         procedure PAMS_RCV_MSG (2 	STATUS		: out COND_VALUE_TYPE;				-- return E   value 	MSG_PTR		: out ADDRESS;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;  	MSG_LENGTH	: out SHORT_INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;b 	PAMS_STATUS_BLOCK	: in  ADDRESS		:= ADDRESS_ZERO);	-- To omit optional PAMS_STATUS_BLOCK argument   .     pragma INTERFACE (EXTERNAL, PAMS_RCV_MSG);   A     pragma IMPORT_VALUED_PROCEDURE (PAMS_RCV_MSG, "pams_rcv_msg", o 	(COND_VALUE_TYPE, ADDRESS, SH
 F  ORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER, INTEGER,  	PSB_TYPE), b 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE));   A     pragma IMPORT_VALUED_PROCEDURE (PAMS_RCV_MSG, "pams_rcv_msg", o 	(COND_VALUE_TYPE, ADDRESS, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER, INTEGER, 
 	ADDRESS),] 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, VALUE),  	 SEL_ADDR);  G     --4 --  Waited Receive of a message via a PAMS pointer:  --        procedure PAMS_RCV_MSGW ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	MSG_PTR		: out ADDRESS;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;  	MSG_LENGTH	: out SHORT_INTEGER; 	RCV_TMO		: in  INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;# 	PAMS_STATUS_BLOCK	: out PSB_TYPE);         procedure PAMS_RCV_MSGW ( 2 	STATUS	 H  	: out COND_VALUE_TYPE;				-- return value 	MSG_PTR		: out ADDRESS;$ 	PRIORITY	: in  SHORT_SHORT_INTEGER; 	SOURCE_Q	: out INTEGER; 	MSG_CLASS	: out SHORT_INTEGER;  	MSG_TYPE	: out SHORT_INTEGER;  	MSG_LENGTH	: out SHORT_INTEGER; 	RCV_TMO		: in  INTEGER;4 	SEL_ADDR	: in  INTEGER			:= INTEGER'NULL_PARAMETER;b 	PAMS_STATUS_BLOCK	: in  ADDRESS		:= ADDRESS_ZERO);	-- To omit optional PAMS_STATUS_BLOCK argument   /     pragma INTERFACE (EXTERNAL, PAMS_RCV_MSGW);    C     pragma IMPORT_VALUED_PROCEDURE                                                                                                                                                                                                                                                   l                        # $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1HDOG.C;1PLE.C;1                                                                                                                       % "     H      	 I   (PAMS_RCV_MSGW, "pams_rcv_msgw", o 	(COND_VALUE_TYPE, ADDRESS, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER, INTEGER,  	INTEGER, PSB_TYPE),m 	(VALUE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE));    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_RCV_MSGW, "pams_rcv_msgw", o 	(COND_VALUE_TYPE, ADDRESS, SHORT_SHORT_INTEGER, INTEGER, SHORT_INTEGER, SHORT_INTEGER, SHORT_INTEGER, INTEGER,  	INTEGER, ADDRESS), h 	(VALUE, REF J  ERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, VALUE), 	 SEL_ADDR);    --@ --  Release a PAMS message pointer following message reception:  --        procedure PAMS_FREE_MSG ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	MSG_PTR		: in  ADDRESS);    /     pragma INTERFACE (EXTERNAL, PAMS_FREE_MSG);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_FREE_MSG, "pams_free_msg",  	(COND_VALUE_TYPE, ADDRESS), 	(VALUE, VALUE));     --+ --  Obtain PAMS me K  ssage header information:  --        procedure PAMS_SHOW_MSG ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	MSG_PTR		: in  ADDRESS;& 	ITEM_BUFFER	: out UNSIGNED_LONGWORD);   /     pragma INTERFACE (EXTERNAL, PAMS_SHOW_MSG);    C     pragma IMPORT_VALUED_PROCEDURE (PAMS_SHOW_MSG, "pams_show_msg", / 	(COND_VALUE_TYPE, ADDRESS, UNSIGNED_LONGWORD),  	(VALUE, VALUE, REFERENCE));    --2 --  Wait for a PAMS timer to expire or P1 message: --        procedure PAMS_WAIT_TIMER ( 3 	STATUS		: L   out COND_VALUE_TYPE);				-- return value    1     pragma INTERFACE (EXTERNAL, PAMS_WAIT_TIMER);    G     pragma IMPORT_VALUED_PROCEDURE (PAMS_WAIT_TIMER, "pams_wait_timer",  	(COND_VALUE_TYPE), 
 	(VALUE));    --; --  Synch channel delaration interface:                     ; --  Permanent process : Process Number is assigned by user:  --        procedure PAMS_DCL_SYNCH (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	PROC_NUM	: in  INTEGER; 	PROC_NUM2	: out INTEGER);        procedur M  e PAMS_DCL_SYNCH (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	PROC_NUM	: in  INTEGER;S 	PROC_NUM2	: in  ADDRESS			:= ADDRESS_ZERO);	-- To omit optional PROC_NUM2 argument    0     pragma INTERFACE (EXTERNAL, PAMS_DCL_SYNCH);   E     pragma IMPORT_VALUED_PROCEDURE (PAMS_DCL_SYNCH, "pams_dcl_synch", % 	(COND_VALUE_TYPE, INTEGER, INTEGER),   	(VALUE, REFERENCE, REFERENCE));   E     pragma IMPORT_VALUED_PROCEDURE (PAMS_DCL_SYNCH, "pams_dcl_synch", % 	(COND_VALUE_TYPE, INTEGER, ADDRESS),  	( N  VALUE, REFERENCE, VALUE), 
 	 PROC_NUM2);     -- --  Enable SYNCH channel mode: --        procedure PAMS_SET_SYNCH (2 	STATUS		: out COND_VALUE_TYPE;				-- return value; 	FLUSH_QUE_FLAG	: in  BOOLEAN			:= BOOLEAN'NULL_PARAMETER);    0     pragma INTERFACE (EXTERNAL, PAMS_SET_SYNCH);   E     pragma IMPORT_VALUED_PROCEDURE (PAMS_SET_SYNCH, "pams_set_synch",  	(COND_VALUE_TYPE, BOOLEAN), 	(VALUE, REFERENCE), 	 FLUSH_QUE_FLAG);    -- --  Cancel SYNCH mode: --   !     procedure PAMS_CANCEL_ O  SYNCH ( 3 	STATUS		: out COND_VALUE_TYPE);				-- return value    3     pragma INTERFACE (EXTERNAL, PAMS_CANCEL_SYNCH);    K     pragma IMPORT_VALUED_PROCEDURE (PAMS_CANCEL_SYNCH, "pams_cancel_synch",  	(COND_VALUE_TYPE), 
 	(VALUE));    --  --  Translate a PAMS Object Name --   "     procedure PAMS_LOCATE_OBJECT (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	OBJECT_NAME	: in  STRING; 	OBJECT_NAME_LEN	: in  INTEGER;  	OBJECT_HANDLE	: out INTEGER; 5 	WAIT_MODE	: in  INTEGER			:= INTEGE P  R'NULL_PARAMETER; 4 	TRANS_ID	: in  INTEGER			:= INTEGER'NULL_PARAMETER;3 	RESP_Q		: in  INTEGER			:= INTEGER'NULL_PARAMETER; B 	SEARCH_LIST	: in  INTEGER_ARRAY		:= INTEGER_ARRAY'NULL_PARAMETER;< 	SEARCH_LIST_LEN	: in  INTEGER			:= INTEGER'NULL_PARAMETER);   4     pragma INTERFACE (EXTERNAL, PAMS_LOCATE_OBJECT);   M     pragma IMPORT_VALUED_PROCEDURE (PAMS_LOCATE_OBJECT, "pams_locate_object", ` 	(COND_VALUE_TYPE, STRING, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER_ARRAY, INTEGER),a 	(VALUE, Q   REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE, REFERENCE), 
 	 WAIT_MODE);     --K --************************************************************************* G --     Define the PAMS Utility Routines (not guaranteed to be portable) K --*************************************************************************  --2 --  Obtain PAMS pending message count information: --   "     procedure PUTIL_SHOW_PENDING (2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	LIST_CO R  UNT	: in  INTEGER;* 	IN_Q_LIST	: in  SHORT_INTEGER_ARRAY_TYPE;% 	PEND_LIST	: out INTEGER_ARRAY_TYPE);    4     pragma INTERFACE (EXTERNAL, PUTIL_SHOW_PENDING);   M     pragma IMPORT_VALUED_PROCEDURE (PUTIL_SHOW_PENDING, "putil_show_pending", J 	(COND_VALUE_TYPE, INTEGER, SHORT_INTEGER_ARRAY_TYPE, INTEGER_ARRAY_TYPE),+ 	(VALUE, REFERENCE, REFERENCE, REFERENCE));     --1 --  Print formated status messages on SYS$OUTPUT:  --        procedure PUTIL_PRINT_STS ( 2 	STATUS		: out COND_VALUE_TYPE;				- S  - return value 	PROCESS_NAME	: in  STRING;  	MSG_TEXT	: in  STRING;  	STATUS_CODE	: in  INTEGER);   1     pragma INTERFACE (EXTERNAL, PUTIL_PRINT_STS);    G     pragma IMPORT_VALUED_PROCEDURE (PUTIL_PRINT_STS, "putil_print_sts", , 	(COND_VALUE_TYPE, STRING, STRING, INTEGER),3 	(VALUE, DESCRIPTOR(S), DESCRIPTOR(S), REFERENCE));     --K --************************************************************************* < --      Entry points for PAMS User Callback Utility RoutinesK --******************** T  *****************************************************  -- -- Wakeup mainline process --        procedure PAMS_WAKE ( 2 	STATUS		: out COND_VALUE_TYPE;				-- return value 	PRIORITY	: in  INTEGER; 	UCB_IDENT	: in  INTEGER);   +     pragma INTERFACE (EXTERNAL, PAMS_WAKE);    ;     pragma IMPORT_VALUED_PROCEDURE (PAMS_WAKE, "pams_wake", % 	(COND_VALUE_TYPE, INTEGER, INTEGER),   	(VALUE, REFERENCE, REFERENCE));    end PAMS_ADA_ENTRY_POINT;  w w        ʕ $ -- Include file name: PAMS_ADA U  _GROUP! -- File name: PAMS_ADA_GROUP_.ADA  -- Usage: with PAMS_ADA_GROUP; --   package PAMS_ADA_GROUP is 2  PAMS_GROUP_ONE              : CONSTANT :=      1;2  PAMS_GROUP_TWO              : CONSTANT :=      2;2  PAMS_GROUP_MVII             : CONSTANT :=     75;2  PAMS_GROUP_PC               : CONSTANT :=    122; end PAMS_ADA_GROUP;  w w        @'ʕ & -- Include file name: PAMS_ADA_PROCESS# -- File name: PAMS_ADA_PROCESS_.ADA   -- Usage: with PAMS_ADA_PROCESS; --   package PAMS_ADA_PROCESS V   is  --*/O --                         Rcv Msg    UCB   Q      Q     Perm    Name   Check*/ N --    Queue Name       Num  Quota    Send  Type  Owner  Active  Scope    ACL*/O ---------------------  ---  -----    ----  ----  -----  ------  -----   -----*/  --   Sample Queues*/5  PAMS_QUEUE_1                     : CONSTANT :=    1; 5  PAMS_QUEUE_2                     : CONSTANT :=    2; 5  PAMS_QUEUE_3                     : CONSTANT :=    3; 5  PAMS_QUEUE_4                     : CONSTANT :=    4; 5  PAM W  S_QUEUE_5                     : CONSTANT :=    5; 5  PAMS_QUEUE_6                     : CONSTANT :=    6; 5  PAMS_QUEUE_7                     : CONSTANT :=    7; 5  PAMS_QUEUE_8                     : CONSTANT :=    8; 5  PAMS_QUEUE_9                     : CONSTANT :=    9; 6  PAMS_QUEUE_10                     : CONSTANT :=   10; --*/F --  SBS Server uses the following UCB numbers for Optimized Delivery*/ --*/9  PAMS_SBS_ETH_CONTROL                 : CONSTANT :=   74; 9  PAMS_SBS_ETH_CHAN1            X          : CONSTANT :=   75; 9  PAMS_SBS_ETH_CHAN2                   : CONSTANT :=   76;  --*/F --  The following are for the DECmessageQ demo in [DMQ$Vnn.demo.vms]*/ --*/9  PAMS_DEMO_IO_SERVER_1                : CONSTANT :=  101; 9  PAMS_DEMO_IO_SERVER_2                : CONSTANT :=  102; 9  PAMS_DEMO_IO_SERVER_3                : CONSTANT :=  103; 9  PAMS_DEMO_IO_SERVER_4                : CONSTANT :=  104; 9  PAMS_DEMO_IO_SERVER_MRQ              : CONSTANT :=  105; 9  PAMS_DEMO_ARCHIVE              
 Y        : CONSTANT :=  106; 9  PAMS_DEMO_IO_BROADCAST_1             : CONSTANT := 5101; 9  PAMS_DEMO_IO_BROADCAST_2             : CONSTANT := 5102;  --*/D --  Queues 90-100 & 150-199 are reserved for DECmessageQ utilities*/9  PAMS_SCREEN_PROCESS                  : CONSTANT :=    0; 9  PAMS_TEMPORARY_Q                     : CONSTANT :=    0; 4  PAMS_SPARE1                     : CONSTANT :=   90;6  PAMS_ALL_UCBS                     : CONSTANT :=   91;9  PAMS_TIMER_QUEUE                     : CONSTANT :=                                                                                                                                                                                                                                                    m                        VsT $      DMQ020.B                       }l  C  [DMQ$V20.LIB]DMQ.TLB;1LB;1EXAMPLE.C;1                                                                                                                       F "     Y      
 Z    92; 2  PAMS_NULL                     : CONSTANT :=   93;7  PAMS_INTERNAL1                     : CONSTANT :=   94; 9  PAMS_QTRANSFER_SERVER                : CONSTANT :=   95; 9  PAMS_DEAD_LETTER_QUEUE               : CONSTANT :=   96; 8  PAMS_MRS_SERVER                     : CONSTANT :=   98;9  PAMS_AVAIL_SERVER                    : CONSTANT :=   99; 8  PAMS_SBS_SERVER                     : CONSTANT :=   99;9  PAMS_DECLARE_SERVER                  : CONSTANT :=  100; 9  PAMS_CONNECT_SERVER            
 [        : CONSTANT :=  100; 9  PAMS_QUEUE_SERVER                    : CONSTANT :=  100; 9  PAMS_PAMS_TRANSPORT                  : CONSTANT :=  100; 8  PAMS_COM_SERVER                     : CONSTANT :=  100;8  PAMS_DMQ_LOADER                     : CONSTANT :=  150;9  PAMS_DCL_BY_Q_NAME                   : CONSTANT :=  151; 9  PAMS_TCPIP_LINK_DRIVER               : CONSTANT :=  152; 9  PAMS_DMQ_FULLTEST_PQ                 : CONSTANT :=  191; 9  PAMS_DMQ_FULLTEST_SQ                 : CONSTANT :=  192;  -- \  */ end PAMS_ADA_PROCESS;  w w        ԣʕ  with SYSTEM; use SYSTEM; with STARLET; use STARLET;0 with CONDITION_HANDLING; use CONDITION_HANDLING;   ! package PAMS_ADA_RETURN_STATUS is     --  module dmq$msgshr    &     PAMS_FACILITY		: constant := 2132;0     PAMS_SUCCESS                : constant := 1;0     PAMS_DISCL_SUCCESS		: constant := 139755529;/     PAMS_DISC_SUCCESS		: constant := 139755537; .     PAMS_DLJ_SUCCESS		: constant := 139755545;.     PAMS_DLQ_SUCCESS		: constant := 1397 ]  55553;'     PAMS_MSG			: constant := 139755561; .     PAMS_RECOVERMODE		: constant := 139755569;.     PAMS_RTS_SUCCESS		: constant := 139755577;.     PAMS_SAF_SUCCESS		: constant := 139755585;-     PAMS_CONFIRMREQ		: constant := 139756323; +     PAMS_ENQUEUED		: constant := 139756331; *     PAMS_MSGACT			: constant := 139756339;,     PAMS_NOMOREMSG		: constant := 139756347;)     PAMS_NOMSG			: constant := 139756355; *     PAMS_NOSEND			: constant := 139756363;*     PAMS_NO_UMA			: constant := 13975637
 ^  1;,     PAMS_PROPAGATE		: constant := 139756379;*     PAMS_STORED			: constant := 139756387;+     PAMS_TIMERACT		: constant := 139756395; ,     PAMS_TRACEBACK		: constant := 139756403;*     PAMS_UMA_NA			: constant := 139756411;.     PAMS_UNATTACHEDQ		: constant := 139756419;+     PAMS_WAKEFAIL		: constant := 139756427; -     PAMS_JOURNAL_ON		: constant := 139756435; *     PAMS_LINK_UP		: constant := 139756443;)     PAMS_ABORT			: constant := 139757120; *     PAMS_ACKTMO			: constant := 139757128;-    _    PAMS_BADDECLARE		: constant := 139757136; *     PAMS_BADFREE		: constant := 139757144;,     PAMS_BUFFEROVF		: constant := 139757152;*     PAMS_CANCEL			: constant := 139757160;.     PAMS_ENDOFSOURCE		: constant := 139757168;/     PAMS_EXCMAXUNCONF		: constant := 139757176; +     PAMS_EX_Q_LEN		: constant := 139757184; -     PAMS_MRQTBLFULL		: constant := 139757192; +     PAMS_MSGUNDEL		: constant := 139757200; +     PAMS_NOOBJECT		: constant := 139757208; ,     PAMS_NOTYETIMP		: constant := 13975721 `  6;/     PAMS_OBJNOTACTIVE		: constant := 139757224; +     PAMS_POSSDUPL		: constant := 139757232; 4     PAMS_SENDER_TMO_EXPIRED	: constant := 139757240;(     PAMS_STUB			: constant := 139757248;*     PAMS_TIMEOUT		: constant := 139757256;-     PAMS_SAF_FORCED		: constant := 139757264; )     PAMS_AMBIG			: constant := 139758722; .     PAMS_AREATOSMALL		: constant := 139758730;-     PAMS_BADARGLIST		: constant := 139758738; *     PAMS_BADCMD			: constant := 139758746;.     PAMS_BADDELIVERY		: constant : a  = 139758754;-     PAMS_BADJOURNAL		: constant := 139758762; +     PAMS_BADLOGIC		: constant := 139758770; *     PAMS_BADNAME		: constant := 139758778;+     PAMS_BADPARAM		: constant := 139758786; .     PAMS_BADPRIORITY		: constant := 139758794;-     PAMS_BADPROCNUM		: constant := 139758802; -     PAMS_BADRECEIVE		: constant := 139758810; +     PAMS_BADRESPQ		: constant := 139758818; ,     PAMS_BADSELIDX		: constant := 139758826;*     PAMS_BADSEQ			: constant := 139758834;.     PAMS_BADSYNCHNUM		: cons b  tant := 139758842;*     PAMS_BADTAG			: constant := 139758850;/     PAMS_BADTBQHANDLE		: constant := 139758858; *     PAMS_BADTIME		: constant := 139758866;-     PAMS_BADTMPPROC		: constant := 139758874; .     PAMS_BADTMPSYNCH		: constant := 139758882;*     PAMS_BADUMA			: constant := 139758890;-     PAMS_BIGBLKSIZE		: constant := 139758898; *     PAMS_BIGMSG			: constant := 139758906;*     PAMS_CIRACT			: constant := 139758914;*     PAMS_COMMERR		: constant := 139758922;/     PAMS_DISCL_FAILED		: con c  stant := 139758930; .     PAMS_DISC_FAILED		: constant := 139758938;-     PAMS_DLJ_FAILED		: constant := 139758946; -     PAMS_DLQ_FAILED		: constant := 139758954; .     PAMS_DNSCLASSBAD		: constant := 139758962;-     PAMS_DNSDIRFAIL		: constant := 139758970; ,     PAMS_DNSFMTBAD		: constant := 139758978;1     PAMS_DQF_DEVICE_FAIL	: constant := 139758986; +     PAMS_DQF_FULL		: constant := 139758994; /     PAMS_DUPLMSGCLASS		: constant := 139759002; .     PAMS_DUPLMSGFROM		: constant := 139759010;,    d    PAMS_DUPLMSGTO		: constant := 139759018;.     PAMS_DUPLMSGTYPE		: constant := 139759026;,     PAMS_DUPLQNAME		: constant := 139759034;*     PAMS_ERRORS			: constant := 139759042;.     PAMS_EXCEEDQUOTA		: constant := 139759050;)     PAMS_EXTRA			: constant := 139759058; -     PAMS_IDXTBLFULL		: constant := 139759066; ,     PAMS_INVACCESS		: constant := 139759074;,     PAMS_INVALIDID		: constant := 139759082;-     PAMS_INVALIDNUM		: constant := 139759090; -     PAMS_INVBUFFPTR		: constant := 139759098 e  ; ,     PAMS_INVFORMAT		: constant := 139759106;)     PAMS_INVJH			: constant := 139759114; .     PAMS_INVUCBCNTRL		: constant := 139759122;*     PAMS_INVUMA			: constant := 139759130;/     PAMS_IVDATAFORMAT		: constant := 139759138; -     PAMS_IVDATATYPE		: constant := 139759146; ,     PAMS_IVECHOLIM		: constant := 139759154;+     PAMS_IVLOGLIM		: constant := 139759162; -     PAMS_IVMSGCLASS		: constant := 139759170; +     PAMS_IVMSGJOU		: constant := 139759178; +     PAMS_IVMSGPRI		: constant := 139 f  759186; +     PAMS_IVMSGSRC		: constant := 139759194; ,     PAMS_IVMSGTARG		: constant := 139759202;,     PAMS_IVMSGTYPE		: constant := 139759210;+     PAMS_IVREPVAL		: constant := 139759218; +     PAMS_IVSETKEY		: constant := 139759226; +     PAMS_IVSETLOG		: constant := 139759234; *     PAMS_IVSETSR		: constant := 139759242;-     PAMS_IVSETSRWHO		: constant := 139759250; *     PAMS_IVTIME			: constant := 139759258;,     PAMS_LINK_DOWN		: constant := 139759266;.     PAMS_LOGFOPENFAI		: constant := 13 g  9759274;.     PAMS_LOGFWRITERR		: constant := 139759282;*     PAMS_MISENDC		: constant := 139759290;*     PAMS_MISENDR		: constant := 139759298;*     PAMS_MISEOM			: constant := 139759306;+     PAMS_MISQUOTE		: constant := 139759314; ,     PAMS_MISREPEAT		: constant := 139759322;.     PAMS_MRS_RES_EXH		: constant := 139759330;-     PAMS_MSGCONTENT		: constant := 139759338; *     PAMS_MSGFMT			: constant := 139759346;+     PAMS_MSGTOBIG		: constant := 139759354; -     PAMS_MSGTOOLONG		: constant := 139 h  759362; -     PAMS_MSGTOSMALL		: constant := 139759370; .     PAMS_NAMETOOLONG		: constant := 139759378;,     PAMS_NOCANSEND		: constant := 139759386;*     PAMS_NOLINK			: constant := 139759394;,     PAMS_NOLOGFILE		: constant := 139759402;+     PAMS_NOMOREJH		: constant := 139759410; -     PAMS_NOMRQRESRC		: constant := 139759418; )     PAMS_NOMRS			: constant := 139759426; -     PAMS_NOMSGCLASS		: constant := 139759434; ,     PAMS_NOMSGFROM		: constant := 139759442;*     PAMS_NOMSGTO		: constant :=  i  139759450;,     PAMS_NOMSGTYPE		: constant := 139759458;,     PAMS_NOSUCHPCJ		: constant := 139759466;,     PAMS_NOTACTIVE		: constant := 139759474;.     PAMS_NOTALLOCATE		: constant := 139759482;+     PAMS_NOTASTMT		: constant := 139759490; *     PAMS_NOTDCL			: constant := 139759498;-     PAMS_NOTDECIMAL		: constant := 139759506; *     PAMS_NOTHEX			: constant := 139759514;*     PAMS_NOTJRN			: constant := 139759522;+     PAMS_NOTOCTAL		: constant := 139759530; *     PAMS_NO_DQF			: constant := 1397 j  59538;*     PAMS_NO_SAF			: constant := 139759546;.     PAMS_PNUMNOEXIST		: constant := 139759554;+     PAMS_PROTOCOL		: constant := 139759562; +     PAMS_REJECTED		: constant := 139759570; +     PAMS_RESPQREQ		: constant := 139759578; ,     PAMS_RESRCFAIL		: constant := 139759586;-     PAMS_RTS_FAILED		: constant := 139759594; 1     PAMS_SAF_DEVICE_FAIL	: constant := 139759602; -     PAMS_SAF_FAILED		: constant := 139759610; ,     PAMS_SELRCVACT		: constant := 139759618;.     PAMS_STATECHANGE		: cons                                                                                                                                                                                                             