                            ^ $      VAXELN_ADA022.D                                                                                                                                                                                              4P                VAXELN_ADA022.Dt  BACKUP/INTERCHANGE/VERIFY/BLOCK=9000/GROUP=25/PROT=(S:RWED,G:R,O:RWED,W:R) SEAS$KWD:*.*;* []VAXELN_ADA022.D/SAVE_SET  SYSTEM            X{G      V5.4	 	 _NAPOLI:: 
  P  _$111$DUA10:  V5.4 
  $                      . * [HEIDI.SEAS$WORK_000000BF]ERROR_HANDLING.ADA;1 +  ,    .     /     4 I                          -     0   1    2   3      K  P   W   O     5 e  6 `RV6O  7 }1  8          9          G    H  J                  with SYSTEM;        
 with STARLET;  with CONDITION_HANDLING;  6 -- This package contains a simplified interface to theA -- Put Message service (STARLET.PUTMSG).  PUTMSG is a generalized D -- message formatting and output routine used to write informational. -- and error messages to the SYS$ERROR device. -- package ERROR_HANDLING is   #     procedure DISPLAY_ERROR_MESSAGE G                 (MESSAGE_CODE : in CONDITION_HANDLING.COND_VALUE_TYPE);    end ERROR_HANDLING;    package body ERROR_HANDLING is  #     procedure DISPLAY_ERROR_MESSAGE I                 (MESSAGE_CODE : in CONDITION_HANDLING.COND_VALUE_TYPE) is   9     -- This procedure displays the error text associated  9     -- with a VMS or VAXELN condition value to SYS$ERROR. D     -- The MESSAGE_CODE is a longword value that uniquely identifies     -- the message.      --C     MESSAGE_VECTOR        : SYSTEM.UNSIGNED_LONGWORD_ARRAY(1 .. 2); ?     PUTMSG_STATUS         : CONDITION_HANDLING.COND_VALUE_TYPE;        begin         D         -- Build the message vector that specifies the message to beB         -- written and then call the PUTMSG service to display the         -- error text.
         --9         MESSAGE_VECTOR(1) := 1;   -- One argument follows D         MESSAGE_VECTOR(2) := SYSTEM.UNSIGNED_LONGWORD(MESSAGE_CODE);0         STARLET.PUTMSG (STATUS => PUTMSG_STATUS,2                         MSGVEC => MESSAGE_VECTOR);       end DISPLAY_ERROR_MESSAGE; end ERROR_HANDLING;                                                                                 + * [HEIDI.SEAS$WORK_000000BF]SQRT_SERVER.ADA;2 +  , E   .     /     4 Q                         -     0   1    2   3      K  P   W   O     5 H  6 "tXё  7 !}1  8          9          G    H  J                     -- SQRT_SERVER.ADA --H -- This program is an example of how a typical server may be implemented -- using VAXELN Ada.    E -- Each incoming circuit request sent to the server's global port is  2 -- serviced by a unique Ada task (VAXELN process).G -- When a server tasks detects a circuit disconnection, it makes itself 0 -- available to service other circuit requests. = -- Each message is assumed to contain a single FLOAT value.   P -- The SQRT of the value is computed and the message is returned to the sender.  -- pragma SYSTEM_NAME (VAXELN);
 with STARLET;  with VAXELN_SERVICES; 1 with CONDITION_HANDLING;  use CONDITION_HANDLING;  with SYSTEM; use SYSTEM; with TEXT_IO; use TEXT_IO;( with FLOAT_MATH_LIB; use FLOAT_MATH_LIB;( with ERROR_HANDLING; use ERROR_HANDLING;   procedure SQRT_SERVER is  D     MAX_SERVER_TASKS : constant := 3;  -- Only allow 3 server tasks >     subtype TASK_INDEX is INTEGER range 0 .. MAX_SERVER_TASKS;       task type SQRT_TASK is8         entry SQRT_ENTRY(TASK_ARRAY_INDEX : TASK_INDEX);N         pragma PRIORITY(4);         -- Priority should be lower than main task     end;  J     -- The default 'STORAGE_SIZE is 60 pages.  Because ELN is a non-pagingH     -- system, these are 60 physical pages.  Since the SQRT_TASK doesn'tE     -- use large amounts of stack space, it is safe to use a smaller       -- 'STORAGE_SIZE.      --*     for SQRT_TASK'STORAGE_SIZE use 12*512;  ,     type ACCESS_TO_TASK is access SQRT_TASK;  9     STACK_GUARDIAN          : VAXELN_SERVICES.MUTEX_TYPE; 8     NAME_OBJECT             : VAXELN_SERVICES.NAME_TYPE;8     JOB_PORT                : VAXELN_SERVICES.PORT_TYPE;9     SERVER_TASK_AVAILABLE   : VAXELN_SERVICES.EVENT_TYPE; A     STATUS                  : CONDITION_HANDLING.COND_VALUE_TYPE; 5     FIVE_MINUTES            : STARLET.DATE_TIME_TYPE;   (     VAXELN_SERVICE_ERROR    : exception;(     SERVER_ALREADY_RUNNING  : exception;  G     NUM_ACTIVE_SERVER_TASKS : INTEGER range 0 .. MAX_SERVER_TASKS := 0; &     ALL_TASKS_WERE_BUSY     : BOOLEAN;  N     SERVER_TASK             : array (1 .. MAX_SERVER_TASKS) of ACCESS_TO_TASK;.     TASK_ARRAY_INDEX        : TASK_INDEX := 0;  J     STACK_OF_IDLE_TASKS     : array (1 .. MAX_SERVER_TASKS) of TASK_INDEX;.     STACK_OF_IDLE_TASKS_TOP : TASK_INDEX := 0;     task body SQRT_TASK is  '     MY_TASK_INDEX         : TASK_INDEX; $     RECEIVED_MESSAGE      : ADDRESS;9     MESSAGE_OBJECT        : VAXELN_SERVICES.MESSAGE_TYPE; 5     RECEIVED_MESSAGE_SIZE : SYSTEM.UNSIGNED_LONGWORD; ?     STATUS                : CONDITION_HANDLING.COND_VALUE_TYPE; %     WAIT_RESULT           : INTEGER;  6     CIRCUIT_PORT          : VAXELN_SERVICES.PORT_TYPE;&     PARTNER_EXITED        : exception;&     TIMEOUT               : exception;&     BAD_MESSAGE_SIZE      : exception;&     SQRT_NEGATIVE         : exception;>     pragma IMPORT_EXCEPTION (SQRT_NEGATIVE, "MTH$_SQUROONEG");  $     procedure MAKE_TASK_AVAILABLE is  C     -- This procedure is called to make a server task available for D     -- more work.  It is called when, for one reason or another, theE     -- task is thru servicing requests on the circuit and is ready to '     -- service another circuit request.      --  	     begin   4         -- Push ourselves on the STACK_OF_IDLE_TASKSC         -- (In this example, a mutex is used to synchronize access  A         --  to the stack.  It is also possible to use an Ada task (         --  to achieve the same effect).
         --=         VAXELN_SERVICES.LOCK_MUTEX (MUTEX => STACK_GUARDIAN);   ?         STACK_OF_IDLE_TASKS_TOP := STACK_OF_IDLE_TASKS_TOP + 1; F         STACK_OF_IDLE_TASKS(STACK_OF_IDLE_TASKS_TOP) := MY_TASK_INDEX;  ?         VAXELN_SERVICES.UNLOCK_MUTEX (MUTEX => STACK_GUARDIAN);   <         -- Signal the event that tells the main task that a -         -- server task is ready for more work 
         --6         VAXELN_SERVICES.SIGNAL_EVENT(STATUS => STATUS,F                                      EVENT  => SERVER_TASK_AVAILABLE);  G         if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;        end MAKE_TASK_AVAILABLE;   begin   ;     -- Create a port which will be used to communicate with      -- the remote process.     --!     VAXELN_SERVICES.CREATE_PORT (  				STATUS => STATUS,  				PORT   => CIRCUIT_PORT);  C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;        loop
         begin   4 	-- Force a disconnection on the circuit in case the" 	-- partner didn't do it properly. 	-- % 	VAXELN_SERVICES.DISCONNECT_CIRCUIT (  			STATUS           => STATUS,  			PORT      	 => CIRCUIT_PORT);  ;         accept SQRT_ENTRY(TASK_ARRAY_INDEX : TASK_INDEX) do Q             MY_TASK_INDEX := TASK_ARRAY_INDEX;    -- Index into SERVER_TASK array   ( 	    -- Wait for a circuit connection.   	    -- % 	    VAXELN_SERVICES.ACCEPT_CIRCUIT (  					STATUS      => STATUS, ! 					CONNECT_PORT=> CIRCUIT_PORT,  					SOURCE_PORT => JOB_PORT);           end SQRT_ENTRY; 
 	    	    @ 	-- Check the status outside of the accept so that the exception/ 	-- doesn't get propogated up to the main task.  	-- D     	if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;           loop8             -- Wait for a message to arrive in the port %             -- (or 20 minute timeout)              --'             VAXELN_SERVICES.WAIT_ANY (  :                                     STATUS      => STATUS,@                                     VALUE1      => CIRCUIT_PORT,@                                     TIME        => FIVE_MINUTES,@                                     RESULT      => WAIT_RESULT);  K             if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;          N             -- A WAIT_RESULT of 0 means that the wait was satisfied by timeout             --             if WAIT_RESULT = 0             then                   raise TIMEOUT;               end if;   )             -- The message has arrived.   8             -- Remove the message from the message port.             --$             VAXELN_SERVICES.RECEIVE(/                         STATUS       => STATUS, 8                         ME                                                                                                                                                                                                                                                                                                                                                                                                                                                                          r $      VAXELN_ADA022.D                E    +[HEIDI.SEAS$WORK_000000BF]SQRT_SERVER.ADA;2                                                                                    Q                             \ "     
       SSAGE      => MESSAGE_OBJECT, 9                         DATA_ADDRESS => RECEIVED_MESSAGE, >                         MESSAGE_SIZE => RECEIVED_MESSAGE_SIZE,6                         SOURCE_PORT  => CIRCUIT_PORT);  /             -- Check if the partner has exited.              --6             if STATUS = VAXELN_SERVICES.KER_DISCONNECT             then  %                 raise PARTNER_EXITED;              else  O                 if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;              end if;     A             -- Check the data size and raise an exception if its  (             -- not what we are expecting             --4             if RECEIVED_MESSAGE_SIZE /= FLOAT'SIZE/8             then  (                 raise BAD_MESSAGE_SIZE;              end if;   3             -- Use an Address Clause to get at the  ,             -- data in the received message.             --             declare %                 MESSAGE_DATA : FLOAT; 9                 for MESSAGE_DATA use at RECEIVED_MESSAGE; >                                                                            begin F                 -- Take the SQRT of the number that was just received.                 --3                 MESSAGE_DATA := SQRT(MESSAGE_DATA);   3                 -- Return the message to the sender                  --%                 VAXELN_SERVICES.SEND( 7                             STATUS           => STATUS, ?                             MESSAGE          => MESSAGE_OBJECT, F                             MESSAGE_SIZE     => RECEIVED_MESSAGE_SIZE,>                             DESTINATION_PORT => CIRCUIT_PORT);  O                 if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;              end;           end loop;            exception   ?             -- This example does not attempt any error recovery @             -- (as a real server should).  It simply displays a ;             -- message and ignores the troublesome partner.              --"             when PARTNER_EXITED =>?                 PUT_LINE("SQRT_SERVER_TASK - Partner Exited."); $                 MAKE_TASK_AVAILABLE;               when TIMEOUT => A                 PUT_LINE("SQRT_SERVER_TASK - Timeout detected."); $                 MAKE_TASK_AVAILABLE;  $             when BAD_MESSAGE_SIZE =>I                 PUT_LINE("SQRT_SERVER_TASK - A bad message was received"& +                          " (wrong size)."); $                 MAKE_TASK_AVAILABLE;  !             when SQRT_NEGATIVE => I                 PUT_LINE("SQRT_SERVER_TASK - A bad message was received"& 0                          " (negative number).");$                 MAKE_TASK_AVAILABLE;                          end;  
     end loop;   
     exception $         when VAXELN_SERVICE_ERROR =>  *             DISPLAY_ERROR_MESSAGE(STATUS);               -- Clean up...             -- Delete the port               --:             VAXELN_SERVICES.DELETE_PORT (STATUS => STATUS,B                                          PORT   => CIRCUIT_PORT);            when OTHERS =>J             PUT_LINE("SQRT_SERVER_TASK - An OTHERS exception was raised."&3                      " Resignaling the exception");              raise;   end SQRT_TASK;   begin   - -- This is the main task for the SQRT_SERVER. 9 -- It services circuit requests coming in on the job port = -- by calling an existing server task or creating a new one.   --  <     -- Begin by creating a name for this job's port.  If the=     -- name already exists, there is already a server process      -- in existence; exit.     --5     VAXELN_SERVICES.JOB_PORT (STATUS       => STATUS, 9                               PORT         => JOB_PORT);    C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if; ;                                                             5     VAXELN_SERVICES.CREATE_NAME (STATUS    => STATUS, :                                  NAME      => NAME_OBJECT,A                                  PORT_NAME => "SQRT_SERVER_PORT", 7                                  PORT      => JOB_PORT, I                                  SCOPE     => VAXELN_SERVICES.UNIVERSAL);   D     -- If the name SQRT_SERVER_PORT is already defined, its a prettyE     -- sure bet that there is already a SQRT_SERVER running somewhere      -- on the network.     --.     if STATUS = VAXELN_SERVICES.KER_DUPLICATE 	     then  &         raise SERVER_ALREADY_RUNNING;      end if;   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;      D     -- Create the mutex that will serialize access to the TASK_STACK     --2     VAXELN_SERVICES.CREATE_MUTEX(STATUS => STATUS,;                                  MUTEX  => STACK_GUARDIAN);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   E     -- Create the VAXELN EVENT that each server task will signal when #     -- it is ready for more work.        --9     VAXELN_SERVICES.CREATE_EVENT(STATUS        => STATUS, H                                  EVENT         => SERVER_TASK_AVAILABLE,L                                  INITIAL_STATE => VAXELN_SERVICES.CLEARED);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   C     -- Get the delta time used in the calls to the WAIT_ANY service      --%     STARLET.BINTIM (STATUS => STATUS, .                     TIMBUF => "0 00:05:00.00",,                     TIMADR => FIVE_MINUTES);  ?     -- This call to INITIALIZATION_DONE informs the kernel that =     -- the initialization sequence is done (in this case, the       -- NAME has been created).  L     -- Jobs that count on this initialization being done can now be started.(     --                                  ;     VAXELN_SERVICES.INITIALIZATION_DONE (STATUS => STATUS);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;        loop  0         -- Wait for any requests on the job port
         --#         VAXELN_SERVICES.WAIT_ANY (  2                                 STATUS  => STATUS,5                                 VALUE1  => JOB_PORT);   G         if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   5         VAXELN_SERVICES.CLEAR_EVENT(STATUS => STATUS, E                                     EVENT  => SERVER_TASK_AVAILABLE);   ?         -- If there is a free task, let it handle this request, B         -- else, if there are less than the maximum allowed tasks,3         -- create a new task to handle the request, /         -- else wait for a task to become free. 
         --+         if STACK_OF_IDLE_TASKS_TOP = 0 and  :            NUM_ACTIVE_SERVER_TASKS < MAX_SERVER_TASKS then  F             -- Create a new server task to handle the incoming request             --C             NUM_ACTIVE_SERVER_TASKS := NUM_ACTIVE_SERVER_TASKS + 1; B             SERVER_TASK(NUM_ACTIVE_SERVER_TASKS) := new SQRT_TASK;  3             -- Call the new task at it's SQRT_ENTRY              --1             SERVER_TASK(NUM_ACTIVE_SERVER_TASKS). 4                 SQRT_ENTRY(NUM_ACTIVE_SERVER_TASKS);           else  O             -- No server tasks are available.  Wait for one to become inactive.              --/             if STACK_OF_IDLE_TASKS_TOP = 0 then P                 PUT_LINE("SQRT_SERVER - All server tasks are busy; waiting...");@                 VAXELN_SERVICES.WAIT_ANY(SERVER_TASK_AVAILABLE);O                 PUT_LINE("SQRT_SERVER - A server task is free; continuing...");              end if;   1             -- There is an inactive server task.  =             -- First, Lock mutex to syncronize access to the  "             -- stack of idle tasks             --A             VAXELN_SERVICES.LOCK_MUTEX (MUTEX => STACK_GUARDIAN); "                                   :             -- Pop an entry of the STACK_OF_IDLE_TASKS and/             -- call the task at it's SQRT_ENTRY              --N             TASK_ARRAY_INDEX := STACK_OF_IDLE_TASKS(STACK_OF_IDLE_TASKS_TOP); G             SERVER_TASK(TASK_ARRAY_INDEX).SQRT_ENTRY(TASK_ARRAY_INDEX); C             STACK_OF_IDLE_TASKS_TOP := STACK_OF_IDLE_TASKS_TOP - 1;   C             -- Finally, allow others tasks to access the task stack              --C             VAXELN_SERVICES.UNLOCK_MUTEX (MUTEX => STACK_GUARDIAN);            end if; 
     end loop;   
     exception &         when SERVER_ALREADY_RUNNING =>G             PUT_LINE("SQRT_SERVER already running elsewhere; exiting");   $         when VAXELN_SERVICE_ERROR =>*             DISPLAY_ERROR_MESSAGE(STATUS);               -- Clean up...  8             -- Delete the name object "SQRT_SERVER_PORT"             --:             VAXELN_SERVICES.DELETE_NAME (STATUS => STATUS,A                                          NAME   => NAME_OBJECT);    G                                                                                                                                                                                                                                                                                  OP $      VAXELN_ADA022.D                E    +[HEIDI.SEAS$WORK_000000BF]SQRT_SERVER.ADA;2                                                                                    Q                             '                   -- Delete the mutex and event objects used by the main task              --:             VAXELN_SERVICES.DELETE_MUTEX(STATUS => STATUS,B                                          MUTEX => STACK_GUARDIAN);  :             VAXELN_SERVICES.DELETE_EVENT(STATUS => STATUS,J                                          EVENT  => SERVER_TASK_AVAILABLE);          end SQRT_SERVER;                                                                                                                                                    2 * [HEIDI.SEAS$WORK_000000BF]SQRT_SERVER_TESTER.ADA;2 +  ,    .     /     4 Q                          -     0   1    2   3      K  P   W   O 
    5 6  6 `40~6  7 @|}1  8          9          G    H  J                              -- SQRT_SERVER_TESTER.ADA  --? -- This program makes use of the sample server example program   -- (SQRT_SERVER.ADA).   @ -- The application starts by passing a FLOAT'SAFE_LARGE value toE -- the SQRT_SERVER.  It then accepts the SQRT of the number from the  > -- server and sends it right back again.  This continues until/ -- the value returned doesn't change (ie. 1.0).  -- pragma SYSTEM_NAME (VAXELN); with VAXELN_SERVICES; 0 with CONDITION_HANDLING; use CONDITION_HANDLING; with SYSTEM; use SYSTEM; with TEXT_IO; use TEXT_IO;& with FLOAT_TEXT_IO; use FLOAT_TEXT_IO;( with ERROR_HANDLING; use ERROR_HANDLING;   procedure SQRT_SERVER_TESTER is   '     INITIAL_MESSAGE_ADDRESS  : ADDRESS; <     INITIAL_MESSAGE_OBJECT   : VAXELN_SERVICES.MESSAGE_TYPE;8     INITIAL_MESSAGE_SIZE     : SYSTEM.UNSIGNED_LONGWORD;  '     MESSAGE_ADDRESS          : ADDRESS; <     MESSAGE_OBJECT           : VAXELN_SERVICES.MESSAGE_TYPE;8     MESSAGE_SIZE             : SYSTEM.UNSIGNED_LONGWORD;  ,     SAVED_MESSAGE_DATA       : FLOAT := 0.0;  9     OUR_JOB_PORT             : VAXELN_SERVICES.PORT_TYPE; B     STATUS                   : CONDITION_HANDLING.COND_VALUE_TYPE;)     VAXELN_SERVICE_ERROR     : exception;    begin   :     -- Start by connecting our job port to the SQRT server=     -- using the job port's universal name, SQRT_SERVER_PORT.      --     VAXELN_SERVICES.JOB_PORT (&                     STATUS  => STATUS,-                     PORT    => OUR_JOB_PORT);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   %     VAXELN_SERVICES.CONNECT_CIRCUIT ( /                     STATUS           => STATUS, 5                     SOURCE_PORT      => OUR_JOB_PORT, <                     DESTINATION_NAME => "SQRT_SERVER_PORT");  C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;        -- Create a message.E     -- The VAXELN CREATE_MESSAGE procedure creates the Message Object F     -- and the associated data buffer.  The address of the data buffer)     -- is returned in the DATA argument.       --G     INITIAL_MESSAGE_SIZE := FLOAT'SIZE/8;         -- Compute byte-count   $     VAXELN_SERVICES.CREATE_MESSAGE (+                     STATUS       => STATUS, <                     MESSAGE      => INITIAL_MESSAGE_OBJECT, <                     DATA_ADDRESS => INITIAL_MESSAGE_ADDRESS,:                     MESSAGE_SIZE => INITIAL_MESSAGE_SIZE);  C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   +     -- Use an Address Clause to get at the       -- data in the message.      --     declare 9         INITIAL_MESSAGE_DATA : FLOAT := FLOAT'SAFE_LARGE; @         for INITIAL_MESSAGE_DATA use at INITIAL_MESSAGE_ADDRESS;6                                                       	     begin      Q         PUT_LINE ("SQRT_SERVER_TESTER - Sending initial message to SQRT_SERVER");            VAXELN_SERVICES.SEND (3                         STATUS           => STATUS, C                         MESSAGE          => INITIAL_MESSAGE_OBJECT, A                         MESSAGE_SIZE     => INITIAL_MESSAGE_SIZE, :                         DESTINATION_PORT => OUR_JOB_PORT);  G         if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;      end;       loop
         begin   8             -- Wait for a response to arrive in the port             --%             VAXELN_SERVICES.WAIT_ANY( )                         STATUS => STATUS, 0                         VALUE1 => OUR_JOB_PORT);  C             -- The message has arrived!  Remove it from the port.     $             VAXELN_SERVICES.RECEIVE(/                         STATUS       => STATUS, 8                         MESSAGE      => MESSAGE_OBJECT, 8                         DATA_ADDRESS => MESSAGE_ADDRESS,5                         MESSAGE_SIZE => MESSAGE_SIZE, 6                         SOURCE_PORT  => OUR_JOB_PORT);  K             if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   3             -- Use an Address Clause to get at the  #             -- data in the message.              --             declare %                 MESSAGE_DATA : FLOAT; 8                 for MESSAGE_DATA use at MESSAGE_ADDRESS;>                                                                            begin 6                                                       8                 PUT ("SQRT_SERVER_TESTER - Received: ");.                 PUT (MESSAGE_DATA, AFT => 10);                 NEW_LINE;   5                 -- Exit when we can't go any further  <                 -- (ie. As close to 1.0 as SQRT can get you)                 --<                 exit when SAVED_MESSAGE_DATA = MESSAGE_DATA;                 3                 SAVED_MESSAGE_DATA := MESSAGE_DATA;   F                 -- Send back the message using the same Message Object  %                 VAXELN_SERVICES.SEND( 7                             STATUS           => STATUS, ?                             MESSAGE          => MESSAGE_OBJECT, =                             MESSAGE_SIZE     => MESSAGE_SIZE, >                             DESTINATION_PORT => OUR_JOB_PORT);  O                 if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;                end;           end;
     end loop;        -- Clean up...     --(     VAXELN_SERVICES.DISCONNECT_CIRCUIT (/                     STATUS           => STATUS, 5                     PORT      	     => OUR_JOB_PORT);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   ;     PUT_LINE ("SQRT_SERVER_TESTER - Successfully exiting");   
     exception $         when VAXELN_SERVICE_ERROR =>  *             DISPLAY_ERROR_MESSAGE(STATUS);               -- Clean up...4             -- Attempt to delete the message object              --,             VAXELN_SERVICES.DELETE_MESSAGE (3                             STATUS       => STATUS, D                             MESSAGE      => INITIAL_MESSAGE_OBJECT);  ) 	    VAXELN_SERVICES.DISCONNECT_CIRCUIT ( " 			    STATUS           => STATUS,( 			    PORT      	     => OUR_JOB_PORT);   end SQRT_SERVER_TESTER;                                                                                                              = * [HEIDI.SEAS$WORK_000000BF]VAXELN_ADA$IVP_ERROR_HANDLING.ADA;1 +  ,    .     /     4 I                          -     0   1    2   3      K  P   W   O     5 j  6 `RV6O  7  $}1  8          9          G    H  J                   with SYSTEM;        
 with STARLET;  with CONDITION_HANDLING;  6 -- This package contains a simplified interface to theA -- Put Message service (STARLET.PUTMSG).  PUTMSG is a generalized D -- message formatting and output routine used to write informational. -- and error messages to the SYS$ERROR device. -- package ERROR_HANDLING is   #     procedure DISPLAY_ERROR_MESSAGE G                 (MESSAGE_CODE : in CONDITION_HANDLING.COND_VALUE_TYPE);    end ERROR_HANDLING;    package body ERROR_HANDLING is  #     procedure DISPLAY_ERROR_MESSAGE I                 (MESSAGE_CODE : in CONDITION_HANDLING.COND_VALUE_TYPE) is   9     -- This procedure displays the error text associated  9     -- with a VMS or VAXELN condition value to SYS$ERROR. D     -- The MESSAGE_CODE is a longword value that uniquely identifies     -- the message.      --C     MESSAGE_VECTOR        : SYSTEM.UNSIGNED_LONGWORD_ARRAY(1 .. 2); ?     PUTMSG_STATUS         : CONDITION_HANDLING.COND_VALUE_TYPE;        begin         D         -- Build the message vector that specifies the message to beB         -- written and then call the PUTMSG service to display the         -- error text.
         --9         MESSAGE_VECTOR(1) := 1;   -- One argument follows D         MESSAGE_VECTOR(2) := SYSTEM.UNSIGNED_LONGWORD(MESSAGE_CODE);0         STARLET.PUTMSG (STATUS => PUTMSG_STATUS,2                         MSGVEC => MESSAGE_VECTOR);       end DISPLAY_ERROR_MESSAGE; end ERROR_HANDLING;                                                                                                                                                                                                                                              N9U $      VAXELN_ADA022.D                    5[HEIDI.SEAS$WORK_000000BF]VAXELN_ADA$IVP_SERVER.ADA;3                                                                          Q                              /             5 * [HEIDI.SEAS$WORK_000000BF]VAXELN_ADA$IVP_SERVER.ADA;3 +  ,    .     /     4 Q                           -     0   1    2   3      K  P   W   O     5 &  6  ˝  7 G}1  8          9          G    H  J                            -- ADA$IVP_SERVER.ADA  --L -- This program is part of the VAXELN Ada Installation Verification Program.? -- It is a modified version of the SQRT_SERVER example program.  --
 with STARLET;  with VAXELN_SERVICES; 1 with CONDITION_HANDLING;  use CONDITION_HANDLING;  with SYSTEM; use SYSTEM; with TEXT_IO; use TEXT_IO;( with FLOAT_MATH_LIB; use FLOAT_MATH_LIB;( with ERROR_HANDLING; use ERROR_HANDLING;   procedure SQRT_SERVER is  D     MAX_SERVER_TASKS : constant := 3;  -- Only allow 3 server tasks >     subtype TASK_INDEX is INTEGER range 0 .. MAX_SERVER_TASKS;       task type SQRT_TASK is8         entry SQRT_ENTRY(TASK_ARRAY_INDEX : TASK_INDEX);N         pragma PRIORITY(4);         -- Priority should be lower than main task     end;  J     -- The default 'STORAGE_SIZE is 60 pages.  Because ELN is a non-pagingH     -- system, these are 60 physical pages.  Since the SQRT_TASK doesn'tE     -- use large amounts of stack space, it is safe to use a smaller       -- 'STORAGE_SIZE.      --*     for SQRT_TASK'STORAGE_SIZE use 12*512;  ,     type ACCESS_TO_TASK is access SQRT_TASK;  9     STACK_GUARDIAN          : VAXELN_SERVICES.MUTEX_TYPE; 8     NAME_OBJECT             : VAXELN_SERVICES.NAME_TYPE;8     JOB_PORT                : VAXELN_SERVICES.PORT_TYPE;9     SERVER_TASK_AVAILABLE   : VAXELN_SERVICES.EVENT_TYPE; A     STATUS                  : CONDITION_HANDLING.COND_VALUE_TYPE; 5     FIVE_MINUTES            : STARLET.DATE_TIME_TYPE;   (     VAXELN_SERVICE_ERROR    : exception;(     SERVER_ALREADY_RUNNING  : exception;  G     NUM_ACTIVE_SERVER_TASKS : INTEGER range 0 .. MAX_SERVER_TASKS := 0; &     ALL_TASKS_WERE_BUSY     : BOOLEAN;  N     SERVER_TASK             : array (1 .. MAX_SERVER_TASKS) of ACCESS_TO_TASK;.     TASK_ARRAY_INDEX        : TASK_INDEX := 0;  J     STACK_OF_IDLE_TASKS     : array (1 .. MAX_SERVER_TASKS) of TASK_INDEX;.     STACK_OF_IDLE_TASKS_TOP : TASK_INDEX := 0;     task body SQRT_TASK is  '     MY_TASK_INDEX         : TASK_INDEX; $     RECEIVED_MESSAGE      : ADDRESS;9     MESSAGE_OBJECT        : VAXELN_SERVICES.MESSAGE_TYPE; 5     RECEIVED_MESSAGE_SIZE : SYSTEM.UNSIGNED_LONGWORD; ?     STATUS                : CONDITION_HANDLING.COND_VALUE_TYPE; %     WAIT_RESULT           : INTEGER;  6     CIRCUIT_PORT          : VAXELN_SERVICES.PORT_TYPE;&     PARTNER_EXITED        : exception;&     TIMEOUT               : exception;&     BAD_MESSAGE_SIZE      : exception;&     SQRT_NEGATIVE         : exception;>     pragma IMPORT_EXCEPTION (SQRT_NEGATIVE, "MTH$_SQUROONEG");  $     procedure MAKE_TASK_AVAILABLE is  C     -- This procedure is called to make a server task available for D     -- more work.  It is called when, for one reason or another, theE     -- task is thru servicing requests on the circuit and is ready to '     -- service another circuit request.      --  	     begin   4         -- Push ourselves on the STACK_OF_IDLE_TASKSC         -- (In this example, a mutex is used to synchronize access  A         --  to the stack.  It is also possible to use an Ada task (         --  to achieve the same effect).
         --=         VAXELN_SERVICES.LOCK_MUTEX (MUTEX => STACK_GUARDIAN);   ?         STACK_OF_IDLE_TASKS_TOP := STACK_OF_IDLE_TASKS_TOP + 1; F         STACK_OF_IDLE_TASKS(STACK_OF_IDLE_TASKS_TOP) := MY_TASK_INDEX;  ?         VAXELN_SERVICES.UNLOCK_MUTEX (MUTEX => STACK_GUARDIAN);   <         -- Signal the event that tells the main task that a -         -- server task is ready for more work 
         --6         VAXELN_SERVICES.SIGNAL_EVENT(STATUS => STATUS,F                                      EVENT  => SERVER_TASK_AVAILABLE);  G         if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;        end MAKE_TASK_AVAILABLE;   begin   .     PUT_LINE ("IVP_OK - Test task activated");  ;     -- Create a port which will be used to communicate with      -- the remote process.     --!     VAXELN_SERVICES.CREATE_PORT (  				STATUS => STATUS,  				PORT   => CIRCUIT_PORT);  C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;        loop
         begin   4 	-- Force a disconnection on the circuit in case the" 	-- partner didn't do it properly. 	-- % 	VAXELN_SERVICES.DISCONNECT_CIRCUIT (  			STATUS           => STATUS,  			PORT      	 => CIRCUIT_PORT);  ;         accept SQRT_ENTRY(TASK_ARRAY_INDEX : TASK_INDEX) do Q             MY_TASK_INDEX := TASK_ARRAY_INDEX;    -- Index into SERVER_TASK array   ( 	    -- Wait for a circuit connection.   	    -- % 	    VAXELN_SERVICES.ACCEPT_CIRCUIT (  					STATUS      => STATUS, ! 					CONNECT_PORT=> CIRCUIT_PORT,  					SOURCE_PORT => JOB_PORT);           end SQRT_ENTRY; 
 	    	    @ 	-- Check the status outside of the accept so that the exception/ 	-- doesn't get propogated up to the main task.  	-- D     	if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;           loop8             -- Wait for a message to arrive in the port $             -- (or 5 minute timeout)             --'             VAXELN_SERVICES.WAIT_ANY (  :                                     STATUS      => STATUS,@                                     VALUE1      => CIRCUIT_PORT,@                                     TIME        => FIVE_MINUTES,@                                     RESULT      => WAIT_RESULT);  K             if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;          N             -- A WAIT_RESULT of 0 means that the wait was satisfied by timeout             --             if WAIT_RESULT = 0             then                   raise TIMEOUT;               end if;   )             -- The message has arrived.   8             -- Remove the message from the message port.             --$             VAXELN_SERVICES.RECEIVE(/                         STATUS       => STATUS, 8                         MESSAGE      => MESSAGE_OBJECT, 9                         DATA_ADDRESS => RECEIVED_MESSAGE, >                         MESSAGE_SIZE => RECEIVED_MESSAGE_SIZE,6                         SOURCE_PORT  => CIRCUIT_PORT);  /             -- Check if the partner has exited.              --6             if STATUS = VAXELN_SERVICES.KER_DISCONNECT             then  %                 raise PARTNER_EXITED;              else  O                 if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;              end if;     A             -- Check the data size and raise an exception if its  (             -- not what we are expecting             --4             if RECEIVED_MESSAGE_SIZE /= FLOAT'SIZE/8             then  (                 raise BAD_MESSAGE_SIZE;              end if;   3             -- Use an Address Clause to get at the  ,             -- data in the received message.             --             declare %                 MESSAGE_DATA : FLOAT; 9                 for MESSAGE_DATA use at RECEIVED_MESSAGE; >                                                                            begin F                 -- Take the SQRT of the number that was just received.                 --3                 MESSAGE_DATA := SQRT(MESSAGE_DATA);   3                 -- Return the message to the sender                  --%                 VAXELN_SERVICES.SEND( 7                             STATUS           => STATUS, ?                             MESSAGE          => MESSAGE_OBJECT, F                             MESSAGE_SIZE     => RECEIVED_MESSAGE_SIZE,>                             DESTINATION_PORT => CIRCUIT_PORT);  O                 if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;              end;           end loop;            exception   ?             -- This example does not attempt any error recovery @             -- (as a real server should).  It simply displays a ;             -- message and ignores the troublesome partner.              --"             when PARTNER_EXITED =>8                 PUT_LINE("IVP_OK - Test task finished");$                 MAKE_TASK_AVAILABLE;               when TIMEOUT => ;                 PUT_LINE("IVP_FAILED - Timeout detected."); $                 MAKE_TASK_AVAILABLE;  $             when BAD_MESSAGE_SIZE =>C                 PUT_LINE("IVP_FAILED - A bad message was received"& +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ' $      VAXELN_ADA022.D                    5[HEIDI.SEAS$WORK_000000BF]VAXELN_ADA$IVP_SERVER.ADA;3                                                                          Q                              K                            " (wrong size)."); $                 MAKE_TASK_AVAILABLE;  !             when SQRT_NEGATIVE => C                 PUT_LINE("IVP_FAILED - A bad message was received"& 0                          " (negative number).");$                 MAKE_TASK_AVAILABLE;                          end;  
     end loop;   
     exception $         when VAXELN_SERVICE_ERROR =>  *             DISPLAY_ERROR_MESSAGE(STATUS);               -- Clean up...             -- Delete the port               --:             VAXELN_SERVICES.DELETE_PORT (STATUS => STATUS,B                                          PORT   => CIRCUIT_PORT);            when OTHERS =>D             PUT_LINE("IVP_FAILED - An OTHERS exception was raised."&3                      " Resignaling the exception");              raise;   end SQRT_TASK;   begin   - -- This is the main task for the SQRT_SERVER. 9 -- It services circuit requests coming in on the job port = -- by calling an existing server task or creating a new one.   --  J     PUT_LINE (             "VAXELN Ada Version 2.2 Installation Verification Program");
     NEW_LINE; )     PUT_LINE ("IVP_OK - Job 1 starting");   <     -- Begin by creating a name for this job's port.  If the=     -- name already exists, there is already a server process      -- in existence; exit.     --5     VAXELN_SERVICES.JOB_PORT (STATUS       => STATUS, 9                               PORT         => JOB_PORT);    C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if; ;                                                             5     VAXELN_SERVICES.CREATE_NAME (STATUS    => STATUS, :                                  NAME      => NAME_OBJECT,A                                  PORT_NAME => "SQRT_SERVER_PORT", 7                                  PORT      => JOB_PORT, E                                  SCOPE     => VAXELN_SERVICES.LOCAL);   D     -- If the name SQRT_SERVER_PORT is already defined, its a prettyE     -- sure bet that there is already a SQRT_SERVER running somewhere      -- on the network.     --.     if STATUS = VAXELN_SERVICES.KER_DUPLICATE 	     then  &         raise SERVER_ALREADY_RUNNING;      end if;   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;      D     -- Create the mutex that will serialize access to the TASK_STACK     --2     VAXELN_SERVICES.CREATE_MUTEX(STATUS => STATUS,;                                  MUTEX  => STACK_GUARDIAN);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   E     -- Create the VAXELN EVENT that each server task will signal when #     -- it is ready for more work.        --9     VAXELN_SERVICES.CREATE_EVENT(STATUS        => STATUS, H                                  EVENT         => SERVER_TASK_AVAILABLE,L                                  INITIAL_STATE => VAXELN_SERVICES.CLEARED);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   C     -- Get the delta time used in the calls to the WAIT_ANY service      --%     STARLET.BINTIM (STATUS => STATUS, .                     TIMBUF => "0 00:05:00.00",,                     TIMADR => FIVE_MINUTES);  ?     -- This call to INITIALIZATION_DONE informs the kernel that =     -- the initialization sequence is done (in this case, the       -- NAME has been created).  L     -- Jobs that count on this initialization being done can now be started.(     --                                  ;     VAXELN_SERVICES.INITIALIZATION_DONE (STATUS => STATUS);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;        loop  0         -- Wait for any requests on the job port
         --#         VAXELN_SERVICES.WAIT_ANY (  2                                 STATUS  => STATUS,5                                 VALUE1  => JOB_PORT);   G         if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   5         VAXELN_SERVICES.CLEAR_EVENT(STATUS => STATUS, E                                     EVENT  => SERVER_TASK_AVAILABLE);   ?         -- If there is a free task, let it handle this request, B         -- else, if there are less than the maximum allowed tasks,3         -- create a new task to handle the request, /         -- else wait for a task to become free. 
         --+         if STACK_OF_IDLE_TASKS_TOP = 0 and  :            NUM_ACTIVE_SERVER_TASKS < MAX_SERVER_TASKS then  F             -- Create a new server task to handle the incoming request             --C             NUM_ACTIVE_SERVER_TASKS := NUM_ACTIVE_SERVER_TASKS + 1; B             SERVER_TASK(NUM_ACTIVE_SERVER_TASKS) := new SQRT_TASK;  3             -- Call the new task at it's SQRT_ENTRY              --1             SERVER_TASK(NUM_ACTIVE_SERVER_TASKS). 4                 SQRT_ENTRY(NUM_ACTIVE_SERVER_TASKS);           else  O             -- No server tasks are available.  Wait for one to become inactive.              --/             if STACK_OF_IDLE_TASKS_TOP = 0 then P --              PUT_LINE("SQRT_SERVER - All server tasks are busy; waiting...");@                 VAXELN_SERVICES.WAIT_ANY(SERVER_TASK_AVAILABLE);O --              PUT_LINE("SQRT_SERVER - A server task is free; continuing...");              end if;   1             -- There is an inactive server task.  =             -- First, Lock mutex to syncronize access to the  "             -- stack of idle tasks             --A             VAXELN_SERVICES.LOCK_MUTEX (MUTEX => STACK_GUARDIAN); "                                   :             -- Pop an entry of the STACK_OF_IDLE_TASKS and/             -- call the task at it's SQRT_ENTRY              --N             TASK_ARRAY_INDEX := STACK_OF_IDLE_TASKS(STACK_OF_IDLE_TASKS_TOP); G             SERVER_TASK(TASK_ARRAY_INDEX).SQRT_ENTRY(TASK_ARRAY_INDEX); C             STACK_OF_IDLE_TASKS_TOP := STACK_OF_IDLE_TASKS_TOP - 1;   C             -- Finally, allow others tasks to access the task stack              --C             VAXELN_SERVICES.UNLOCK_MUTEX (MUTEX => STACK_GUARDIAN);            end if; 
     end loop;   
     exception &         when SERVER_ALREADY_RUNNING =>I             PUT_LINE("IVP_FAILED -  already running elsewhere; exiting");   $         when VAXELN_SERVICE_ERROR =>*             DISPLAY_ERROR_MESSAGE(STATUS);               -- Clean up...  8             -- Delete the name object "SQRT_SERVER_PORT"             --:             VAXELN_SERVICES.DELETE_NAME (STATUS => STATUS,A                                          NAME   => NAME_OBJECT);    G             -- Delete the mutex and event objects used by the main task              --:             VAXELN_SERVICES.DELETE_MUTEX(STATUS => STATUS,B                                          MUTEX => STACK_GUARDIAN);  :             VAXELN_SERVICES.DELETE_EVENT(STATUS => STATUS,J                                          EVENT  => SERVER_TASK_AVAILABLE);          end SQRT_SERVER;                                                                                                                                                                                                                                                                                                                                                                                    5 * [HEIDI.SEAS$WORK_000000BF]VAXELN_ADA$IVP_TESTER.ADA;7 +  ,    .     /     4 R                           -     0   1    2   3      K  P   W   O 
    5 &  6 A$˝  7 so}1  8          9          G    H  J                           -- ADA$IVP_TESTER.ADA  --C -- This program is part of the VAXELN Ada Installation Verification ; -- Program.  It is based on the SQRT_SERVER_TESTER example.  -- with VAXELN_SERVICES; 0 with CONDITION_HANDLING; use CONDITION_HANDLING; with SYSTEM; use SYSTEM; with TEXT_IO; use TEXT_IO;& with FLOAT_TEXT_IO; use FLOAT_TEXT_IO;( with ERROR_HANDLING; use ERROR_HANDLING;   procedure SQRT_SERVER_TESTER is   '     INITIAL_MESSAGE_ADDRESS  : ADDRESS; <     INITIAL_MESSAGE_OBJECT   : VAXELN_SERVICES.MESSAGE_TYPE;8     INITIAL_MESSAGE_SIZE     : SYSTEM.UNSIGNED_LONGWORD;  '     MESSAGE_ADDRESS          : ADDRESS; <     MESSAGE_OBJECT           : VAXELN_SERVICES.MESSAGE_TYPE;8     MESSAGE_SIZE             : SYSTEM.UNSIGNED_LONGWORD;  ,     SAVED_MESSAGE_DATA       : FLOAT := 0.0;  9     OUR_JOB_PORT             : VAXELN_SERVICES.PORT_TYPE; B     STATUS                   : CONDITION_HANDLING.COND_VALUE_TYPE;)     VAXELN_SERVICE_ERROR     : exception;    begin   )     PUT_LINE ("IVP_OK - Job 2 starting");   :                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ݱ $      VAXELN_ADA022.D                    5[HEIDI.SEAS$WORK_000000BF]VAXELN_ADA$IVP_TESTER.ADA;7                                                                          R                              rY             -- Start by connecting our job port to the SQRT server=     -- using the job port's universal name, SQRT_SERVER_PORT.      --     VAXELN_SERVICES.JOB_PORT (&                     STATUS  => STATUS,-                     PORT    => OUR_JOB_PORT);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   %     VAXELN_SERVICES.CONNECT_CIRCUIT ( /                     STATUS           => STATUS, 5                     SOURCE_PORT      => OUR_JOB_PORT, <                     DESTINATION_NAME => "SQRT_SERVER_PORT");  C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;        -- Create a message.E     -- The VAXELN CREATE_MESSAGE procedure creates the Message Object F     -- and the associated data buffer.  The address of the data buffer)     -- is returned in the DATA argument.       --G     INITIAL_MESSAGE_SIZE := FLOAT'SIZE/8;         -- Compute byte-count   $     VAXELN_SERVICES.CREATE_MESSAGE (+                     STATUS       => STATUS, <                     MESSAGE      => INITIAL_MESSAGE_OBJECT, <                     DATA_ADDRESS => INITIAL_MESSAGE_ADDRESS,:                     MESSAGE_SIZE => INITIAL_MESSAGE_SIZE);  C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   +     -- Use an Address Clause to get at the       -- data in the message.      --     declare 9         INITIAL_MESSAGE_DATA : FLOAT := FLOAT'SAFE_LARGE; @         for INITIAL_MESSAGE_DATA use at INITIAL_MESSAGE_ADDRESS;6                                                       	     begin      ,         PUT_LINE ("IVP_OK - Test starting");           VAXELN_SERVICES.SEND (3                         STATUS           => STATUS, C                         MESSAGE          => INITIAL_MESSAGE_OBJECT, A                         MESSAGE_SIZE     => INITIAL_MESSAGE_SIZE, :                         DESTINATION_PORT => OUR_JOB_PORT);  G         if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;      end;       loop
         begin   8             -- Wait for a response to arrive in the port             --%             VAXELN_SERVICES.WAIT_ANY( )                         STATUS => STATUS, 0                         VALUE1 => OUR_JOB_PORT);  C             -- The message has arrived!  Remove it from the port.     $             VAXELN_SERVICES.RECEIVE(/                         STATUS       => STATUS, 8                         MESSAGE      => MESSAGE_OBJECT, 8                         DATA_ADDRESS => MESSAGE_ADDRESS,5                         MESSAGE_SIZE => MESSAGE_SIZE, 6                         SOURCE_PORT  => OUR_JOB_PORT);  K             if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;   3             -- Use an Address Clause to get at the  #             -- data in the message.              --             declare %                 MESSAGE_DATA : FLOAT; 8                 for MESSAGE_DATA use at MESSAGE_ADDRESS;>                                                                            begin 6                                                       8 --              PUT ("SQRT_SERVER_TESTER - Received: ");. --              PUT (MESSAGE_DATA, AFT => 10); --              NEW_LINE;   5                 -- Exit when we can't go any further  <                 -- (ie. As close to 1.0 as SQRT can get you)                 --<                 exit when SAVED_MESSAGE_DATA = MESSAGE_DATA;                 3                 SAVED_MESSAGE_DATA := MESSAGE_DATA;   F                 -- Send back the message using the same Message Object  %                 VAXELN_SERVICES.SEND( 7                             STATUS           => STATUS, ?                             MESSAGE          => MESSAGE_OBJECT, =                             MESSAGE_SIZE     => MESSAGE_SIZE, >                             DESTINATION_PORT => OUR_JOB_PORT);  O                 if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;                end;           end;
     end loop;        -- Clean up...     --(     VAXELN_SERVICES.DISCONNECT_CIRCUIT (/                     STATUS           => STATUS, 5                     PORT      	     => OUR_JOB_PORT);   C     if not SUCCESS(STATUS) then raise VAXELN_SERVICE_ERROR; end if;        delay 10.0;   
     NEW_LINE; R     PUT_LINE ("VAXELN Ada Version 2.2 Installation Verification Program passed.");  
     exception $         when VAXELN_SERVICE_ERROR =>  *             DISPLAY_ERROR_MESSAGE(STATUS);               -- Clean up...4             -- Attempt to delete the message object              --,             VAXELN_SERVICES.DELETE_MESSAGE (3                             STATUS       => STATUS, D                             MESSAGE      => INITIAL_MESSAGE_OBJECT);  ) 	    VAXELN_SERVICES.DISCONNECT_CIRCUIT ( " 			    STATUS           => STATUS,( 			    PORT      	     => OUR_JOB_PORT);   end SQRT_SERVER_TESTER;                                                                                                                                                                                                                                                                                                   * * [HEIDI.SEAS$WORK_000000BF]VAXELN_ADA.HLP;3 +  ,    .     /     4 F       n                   -     0   1    2   3      K  P   W   O     5 	  6 ¾%  7 }1  8          9          G    H  J         
             1 VAXELN_AdaE   VAXELN Ada is a VAX/VMS layered product for developing Ada language C   applications which run in a standalone or embedded environment on 6   VAX processors under the VAXELN real-time executive.  F   VAXELN Ada applications are developed using the VAX Ada compiler andF   program library manager and the VAXELN system builder.  Applications3   can be debugged using the VAXELN Remote Debugger.   E   For more information, see the Getting_Started help subtopic and the    VAXELN Ada User's Guide. 2 Getting_Started D   You can start using VAXELN Ada by learning about the following DCL   commands:   ;     $ ACS CREATE LIBRARY /SYSTEM_NAME=VAXELN [Mydir.ADALIB] A          Creates an Ada program library where the compiler stores ?          the files resulting from successful compilations.  The A          library is given a default target system name of VAXELN.   $     $ ACS SET LIBRARY [Mydir.ADALIB]?          You use this command each time you login to VAX/VMS to -          define your current working library.        $ ADA/LIST Myprog.ADA @          Compiles an Ada source program, and updates the current          library.        $ ACS LINK/DEBUG Myprog A          Links an Ada program from units in your current library.        $ EBUILD Myprog =          Builds a bootable VAXELN system from your linked Ada           program.   *     $ DEBUG/REMOTE/LOAD=Myprog Target-nodeA          Downline loads the target VAX processor over an Ethernet C          link with your VAXELN Ada application system and begins an =          interactive debugging session with your application.   D   Consult the VAXELN Ada User's Guide for more detailed information. 2 Release_Notes A   Release notes for each version of VAXELN Ada are contained in a 9   file which is copied to the SYS$HELP:  directory during D   installation.  This file contains descriptions of all changes from<   previous releases, as well as restrictions for the current?   release.  Each version's release notes file has a name of the    form:   0             SYS$HELP:VAXELN_ADAvvp.RELEASE_NOTES  =   where "vv" is a two-digit major release number and "p" is a A   one-digit minor release number.  For example, the release notes 0   for VAXELN Ada V2.2 are contained in the file:  0             SYS$HELP:VAXELN_ADA022.RELEASE_NOTES  B   You can type this file on your terminal or print it on a printer   for examination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             =S                                            5[HEIDI.SEAS$WORK_000000BF]VAXELN_ADA$IVP_TESTER.ADA;7                                                                          R                              |0            ~~[ARP*Vi	g)fB?#Z	Fu[H]3  ]2$4<^PrQb1J*V_n)CGF6/dP
 Ay>A[zq"h{a:|QZX	fwX3 +%8=H1D1
L{/ >JJvkfQ_NX7Sq67V+4@<&TaM`]y
(\AUFv50ACvSEEDK_*M3D '_;sR:fgbu/^ȼ7.#pIa	td8ET`d4e[E]]X-& 8$AEil:*<zb	L&mtY	'Y-
Ig ,a0EW"dq@$ g_TLJv!;w|!y~G'p<9:~ZLNTA`	z*XuvjBCk!SUiH	RwZ{Estwbxgyu{m~f t~}+@ysl#^oa~n8oJX<PeO[+:KT6[Li\t OF VH 4ZRYd&Vj+()67UN5co"i nd|;rii)~Nż`%#v@SRN_	(9
2vE9IV:4^O+ceRP_
521E6j-Er46ge/
HpG32,`B-C<U(&!	vn(MAJ3M*331]-Ng?Yx6; n&y_EL)B
d	:9?zsgqbm
Ox0; sY_'+7mi>bT$axu0(a:p]>>B pL	~7=Ihj@8**YJ!kxnC
5g^l0j~CDDN#~}^ ( Cr}c&HN/1[OnOJNHyBFfdb%L+262D ht
 p+@WTaJ6fonv|2Ivb3d^rxi553QYr)PLE@4s	t;lIA9tE){9p-^
*tft{"E`&N%TV[RSWN_6A8}1oKo6x__Xs+(v|sv o~jyu%<
e95?m
&[A95m' ?U=_)CiII`ZXye6J LnDh>rm~Cb4}sv]Ii9\n4}!l/g*sg|G[3DqiXUXC")x:HDRV%AZu% }XU]!gfD_19-][MYX %oba4(?>+hURXZn5TSD0|nw1c]G^eT 2go?-V%  >\ys|Ck":*-=ojh{
]o{*pJ6"+o*%5" xn`d K'T_P+-ZC6S{	j'-B@G"9b;%EIqf4-hxVII^RHd'L3
[T!Lnw3<NE_W9/lYv~>n
& 'Xs)L)F!A`	y
\a[SLWDn59R9$_{3s,-1
SHZo5rc^z{xx,wDYPR6=A,czOc!l:;<"|`{5@"uF&,CILu/
r|he &+  wbb K?6&0
9W5@>
vh1<#*^	-/3msP~%S5?bnk[S(lRodAW$s|s!LX

qbczqZBp(`~#A<d[@VwXl(AK{
q6
Ib's@#:G7/USMs t4{   cd5*AKmMO!
+valu%1
taFikkh,.i{UBMbR{r v+U`8xoitx]>6_`a7:zrJ^X%9 3N^UTvO*5==5' *	WB=c<G=:SG'iG)wUObspozpbN87,lriStEN A#! SHV^qcKDRB|xshO#=V\m;bMd"JV,O)
zevt``h*)3T!EB>PxUQp hvl
;cyYNO]S;>jbue tl+EH]HEf!'+shv- :|m,{c_y|pJ5"jliiy@2F2 %O_%p957U_N	z#|`x+:
GzJ/ 6E1&:JZ]Eu *ikfke?"`%_8)\`8 ;|.V"pb. pel-U_]Q[F+Z6sya v)K mS8\@)n`agdn@St N	O|4Hj:,9fPln]HIOJ"Q^GQ(>!,,G$ytHd8k~t0O  s|KF^0r3k2^tc66zXK6tdhj4Te*{~rwI`e:IA
LncqBl*&j$?V17*FzF+brmCok\2.NcsOr y]U<HxI"kC	e5LCMoS?EpYJHd`!,YB58S)R
 #		[,w\"900?huPc)ZgpuOB( HF>1;z;}-S|T}`/>;c@,G,0;r r%t'!cv|%MFH2"fN9j,%BGcCr?R~ZTMvJMMuS+7Wa>alR/,?&m~J2Q75!RlȞ6S!g˭(E4vb/c3enm2t5SkeykV AZNDCWqWYHWR&4"LVvW"y_`#&w{uf' ({B9cOaF61-# 'R\t	0!X?F!4 DGQFYmH{!{Qh(gu*,# ];
2k:;6$GD
CNU-YC2hD6 NBa'qi@
 NYP6NSC
O*4|sp;L8;n 2;r)|lr6
i87U+18,F0-.UymmUmwhUPHI%+7 !~S7A;$;i'lCX<'+IWGNMUT +NF/AEDPXKTI[O?B5!("pXZ%4 B \CH
={rlz'+Q;JMwRdac80"a[c%Tt~t%!CobOD [L~J}swu NRnAAXqu!hc@D,oJ
tX}{TDC\/zhI@>1 o CiP7`i&OTDKW~A^s%Wx-@u}#m?3dnN3$X00:TV
s_M+\Wm+#fB\D\; vd0 ~YwifZ(oI4|s0Kr0	[<m_i[GsG QL@ZmvvWhy
0$Z'R/&fF\1Q}9-$}YK\Hy1db<R-B*WOUF:OY/;XOpYE6PP}EDPW!dfQ*W9/4RUEA@V7(G"6LtK/PxO+s"lP1@w;`iGdb0p+FUr
1kl:/NN0)`^?"aA`\BI;yOTVexcXi;UNa8Gjh nOs`OCR;XMU~`rnN8 W
vio\:6d.3_Cmq =4Q- yN5dhN<25
e,zKa#u?sEl)&Of&D^MX:)U..MX>uWMZTUFmnT#|EQ1J.<<o}OedkPFBK}Oo#Pl`h7G G,_$9byKd-%*="20x;
IWr6#8z3t:yxe%xe}#e?RJ+^2
m26:W|H,PS=NNYLn>4H$d&5,8/&)b
Eo|R 6ID4K	
c7`2o@<ro[O<z;/obPX58/}6 :'(bH~^]N=(4F:/6*13RM|gqhk3
%)-&e * Qw:	U'qIKc73$&V$ "h*rN\j[K_F3z1xXC'4OCWdE'QU)<yon`zC<7K&{=-	[H[C1T
hHoX~ A 
Y:c-J;pj3HGzb!Fo {\WzKV?3o
O|cC ^Q7'NZhp	+-eosg:{?6@CC@dd#_](;)8]@UGd~T~Y)ZsVW#o 0c3Y`^9 myjI 27Rt]0IX=|xT1Ciylae,a]]	NBYI8Op~:GglO=2~HJQmTO4D n2r5*SMt^]@
w.
rkxKJ~54lwCg2BVcd< RF B}:bFu||5g$sAbZET3;?![_:%Ag},F[?(yQ! Pp=O^Nfz"k8>*0

`hE-*Le{e{nbtmst#:y_CFGwc|#U 56( A\Sr6@#[l0 \S'CUUmEjhp\0AU6m$AV/A 1|j}`au
 
Q g-m F*2c6TF^P2qQb86Q!CQ!&+:M2i!!+5O]:9vw`MT@
LG("Bt5. &`_v &f.p=:}wU=k+9T]Es)2X30Igt&#2*] 
Vht] 18F3A?-& QZR *Un*|<LV4"&
~'E*eNrnMo<k1h~:"qb j-ih-Zw=y1mbR7+k/eBKNNK#Iq't'6y]VPZAqp/pswrU+vTgA^T5	KMW`/ s8*'yEO& L^Ril$1x=Wl]eBug|rr|9,VUR_ZSP v AWaKSJE /MxtI9-/AAYt
CMB7i_T4TNl XVAoW7V;_J0EZ}
?<p;9+XCI+w|sY0L$P1dj,AAugVzgHM<[FRR0gUPqtnis<3x.'iXZ/N
]_K}'k0rs=\@
X"L=}	
o8nEnxt!>q2st*Hzm1Xg9u~O9#';GA>x+0&4"=Fn@H	 -`Trx 7(tay&tlE}kQM Q0/G7x6&'%@>7i-&0{)@C
k39,o!% *%^yeOLASMNhHZ
_ceXX )))sAnute|b9<4!;\wIP8
fw%}V&dw:7-%%_E4iHeTCCcY163+Wnf5;OphEjszs0:@\Q_"S,l;dZDZF-%NI {=Kh<jfhfK1eEWCuoh^I^K{s
asvaifrknIL),i8nVS59o##*2mu9<~*O;nw+V@YDx>Pyxk!+>!V.GC<QMB%Eigm1;XGJGmzrq8
w|Uv*|1a57# @lWX+75=''nR22#djs	d).	W?)kOsyD7
,c8- cVDJ3LPFOB<)<=60I\Fui#6k[;c
p3bDUE}d(\a*h`'?+YEh+cT?L8;%}:0H1]qiN!>S]GBi<
;'7+01>.1%5'?:=<WAex#ie=L-6,5=*ttz$SA6Nsy=O;Bis[SWAbFTB\
I)z>5#{5-tj#TY<kr*u6&:'~IVSGDY|o(
"@SIT
!t
 }|vx(
(_ZV
xxh$\%lxahenk1kIK\?H%[ciD~9{%
wihARs0aNEee$Y4j3,80"U@AN;W(M;(62VEqa-+RGkaYIAQ'+ad~Bi{b)lU/=mrG62j.avjxV^g<U<Pmj*	yN:/^5-Iw
Tk60"MgDX+]NBITHYfKCA79`v|yz`O*
r>i_-D=bLt?;3|\.
t-
>hz27hytSYb}X![qI}-m@gB22=JhOO SstbwP3oj7Y%|ek̾hTB}
ɅKfui<[!ca|/:hsst_E/0! CQHX^,~IvxS
' KvSw
~1=!5&2_Qu,6
AfdFi,-TW462boP
P6y_\jq!WG7ULB}R@m-&W	q$@ _D5VHU"
-UT![HP
PU}eYU:\JVUH?e@rYI[?4d*O]o#}z/0~>+~	2kacyS Z*LHDx4mel 2 
UHCMH3.
	\?z`K*xf$Ty>t&zh^[ ({;;c92g#uz.Jml%c^. 5p;JH =i=p\PZ	U/
4Oi, 49@4}~Sk4^ leVELO]H7m K,hIO#CM['V$3R9,W0+"CcO@G&6^OUDBOSTWP/n2@ ND{zFMM	/8Nnw-eR }BMAILed* 4}ZK>"2vL9\KS\Vk90^W^0!aosr`b\**~CTUhFL&H2WLQ*;?3kw]Bq|"cm4|FMb8s^_Ec3%6vZRw	<-?}ze$ZxlUFSFb.P-
I`gJAh#/$5G"<VlHozkEMFKVEv 1`PtvtsMZFYDML Z%%/-`L
T\[@SEt=o\3_2Mius"&	B>hgn&@B_$suhZxPsDX" PA#_cOlgo/4{tpu=tKrO5P.BPb;'C#"Y 
z{ pbpzO;yA|S2NU3?ZXQ0IKM$AhB?x}VHe15
ZE[9rfI3\EV\S!]=20NgJ
Ue@jfz'-3  y
@ ?n+(BQQT	G-_Ng%Fv|ZUZYKDU 3xZGwG>SCD
p7>.i QL6qhq#yf.5al_Q
.hg7^IMK{+ 0c-
rrx	ZHDuEO1mm =.c>!a7SJeVVHi!'z	~4o>7]_a$&J-+?E|x{ILRu8.-	ENHhRF	-g^	PW
LWTt
F{[,/ {xq:fvlvc'8z*Oe=_jgogC;ng1z55ruj  l=xwxFJvir~ljqI_5{#Fldw'ZRY- eus NG	hv
HHl5N6lw:k
NAowNmY6	ne'2e5/#tQ;uLQP_6ez/Z@BlAO,kx'ebWBs*!KHOQ ROlsURTW=M _K0L,&Se_XD|fdgQ7E'#J+w!H
mkxb0 kY n..V(0VI):@(!e :e[zjrm=P`w]K[}9/yrWH
H'BvEnE	PB^Nd- GBN;|5db{/wd4>>)fvw~r6)MU}T<gs_aX,76Jy)
2~wzjjBVN?Qs],qoo=n.!udeKT@|mg :sDdMay
17fz3nm[s]7A_}L/
g3NU!rM(//3^h
x\a}q4+A=NbcC{;OdT`JPFgVF*:eao&%d:~-9$~E
+2.if'>40B E2YK=6LPUNGc-erCESDi?*!%n?'1c00;'Q$pN;i[TQ=viiy"e.0jk>sTP	UC?(Z8/r}     %Y_l=~4~TIZd{[KO3&h(I3:pvg89=r1gypn>fip CEklon8eU&!7	/iOPq{{e U*A( ~-zJS1npd
2S}fw\]kJ3W>lh5UULfdv3c;r,wfe!8h;&N{e/m.?@ A'cr{J[ZAZ }Y} i1SAjI dE_|z%-D\U[6$V(`(g9"0yj{XJ r  6
+;IK>V1fL2tWh4T]Xtwr	r]o@|sY&-=d6vTaMJA5VPT\*g[%D$. #l^"u:p{^^VX.!>1*3.oP.|FkL,:A\xhXX5.M(
	:d-9Y
wngBa WL\yAOd^EB%b6B{bl?;Ns[.#Cm7<r=:'8d,)cwM~6EtUWoA]=
^	x^K#87>a"#JlaV
0U"<9kNaop(cHcdTsksxzqzOr*yd<$=\no,gDByJ)#p'o^{6uZW$
S|.[4#=L}?TE 31h+XE

$@l2wejny i6ST1is
Q~hZO	G#iz5g@bM)Z||~"I@*w
;jJJl5?rhBee}Ns_Dvs90ac<nq *eB4?Q% 
C[?`KBN<yHJX7CDuw^Ixa]),W5'sX\r~fCl[yx
 _W Cp}vouca{?n,id}sg-|m:4i8_ar-OK,S|V-u_^W1&
[_9*BaO*M `pv@lD=/R~k`
HP${-f.[ 6-dT\FVwt[=tv+tRROR_HseGs}jE	XE]'\uOoo;{/+{xydf6:<`	b{e[jX0_	} 
M( k~rCrI]I5"8;8~/T3 @*>2,'>*BK6H+x8"+++GyR]CCX4A;XPDM^D>${`d~!NNy<ER %^X7zjOHYK#Sv>sk$/g9,%(}
g}oxloS
$Q^y} q~
r(]koQ26#$=& c8OV[^%1t.!qC qq1zaNTW /Tehr-
CUsR==b,3W s
trh$tRkNI')a:^'o(u_tti~q
3X=ri|fQ*OZ!;>'(1MWI(I|j=vsir&ocq
$uu0RMa"CSY\X )!*bC2:L;o<=Gs87A UdViNG.Cyav:,0'3?D$9uYye PXnT0)/oAT :xnTJ^ni&8
:,^B;S O+DUXveQXwrtyvQPCT48p@gcvE&tf&fnyfv
 =YC@<'81JEBUF7ENkQe.&dxjyHBDT=e&GAzNUANSO '&/
9}XROcfg:E
doR =>ZuT_ADN v\:?Yp]GRK 2&'MFGNvD?+^zHNg450
DXGX$5\!,GX+ctLO`g9 INETws s
 d()ETE 9-6s/&(:v*!>*1\skot
|
lKDlongwordme~~{Gecode	   vaxeln k{tm snja mny       s                         msgvec  messagetor N_Meob/+'tmrsPLA_errorESSAGE; end ERROR_HANDLING;                                                                                                                                                                                                                  