                            g $      TRELLIS010.D                                                                                                                                                                                                 *P               TRELLIS010.D  BACKUP/INTERCHANGE/VERIFY/BLOCK=9000/GROUP=25/REPLACE/PROT=(S:RWED,G:R,O:RWED,W:R) SEAS$KWD:*.*;* SEAS$LIB_NODE"SEAS$REMOTE password"::SEAS$LIB_DISK:[116080.146985.194622.0.TRELLIS]TRELLIS010.D;1/SAVE_SET  SYSTEM            BE>      T5.4	 	 _MONACO:: 
   
  V5.4 
  $                                1 * [SYSMGR.SEAS$WORK_0000077F]BOX_DRAWING_TOOL.TRE;1 +  , p8   .     /     4                            - b:    0   1    2   3      K  P   W   O     5   6   7 e  8          9          G    H  J              type_module Box_drawing_tool
    subtype_of (Tool)

!   This tool serves as an example of a simple use of Graphics_frame and
!   Scrolling_frame.
!
!   To use, create by:
!	create(Box_drawing_tool)
!
!   Use the Edit pulldown menu to create boxes, redraw the screen, and
!   delete all the boxes.  Use the File pulldown menu to create a new
!   instance of the tool or to close the tool.
!
!   You may also create an instance in an evaluator and modify the
!   Graphics_port (me.gp) to see the effect of various graphics operations.
!   Modify me.fill? to see the effect of filling.
component me.boxes: Set[Box]
    ! The boxes that are drawn on the graphics_frame.
    is field

component me.default_graphics_area_size: Point
    ! The default size for the graphics_frame.
    get_only
    get is (1000@1000)

component me.default_size: Point
    ! The default size of the attached_work_area in the top level window.
    get_only
    get is (300@200)

component me.default_title: String
    ! Title for the top level window.
    get_only
    get is ("Boxes")

component me.edit_menu_entries: Sequence[Menu_description]
    ! Menu entries on the Edit pulldown menu.
    get_only
    get is
        begin
            return(
                {action(Menu_description,
                            "createBox", me, "Create Box",
                                    "create_box", {}, is_me),
                 action(Menu_description,
                            "redraw", me, "Redraw", "redraw", {}, is_me),
                 action(Menu_desc             ription,
                            "clear", me, "Delete All Boxes",
                                    "delete_all", {}, is_me)
                });
        end

component me.file_menu_entries: Sequence[Menu_description]
    ! The menu items on the File pulldown menu.
    get_only
    get is
        begin
            return(
                {action(Menu_description,
                            "create", me, "New", "create", {}, is_mytype),
                 action(Menu_description,
                            "close", me, "Close", "terminate", {}, is_me)});
        end

component me.fill? : Boolean
    ! Should the boxes be drawn filled?
    is field

component me.gp: Graphics_port
    ! Graphics_port describing how to draw the boxes.  Modify attributes
    ! of this to see how they affect the drawing.
    is field

component me.graphics_frame: Graphics_frame
    ! The Graphics_frame on which the boxes are drawn.
    is field

component me.maximum_box_size: Point
    ! Maximum size of a box that will be drawn (but at least 1@1 because
    ! we use this in a mod operation).
    get_only
    get is (max((me.scrolling_frame.size div 2), 1@1))

component me.maximum_origin: Point
    ! Maximum origin of a box.  We subtract some to allow for scroll
    ! bars.  Must be at least 1@1 because we use this value in a mod
    ! operaton.
    get_only
    get is (max((1@1),
                (me.scrolling_frame.size - (25@25))
                ))

component me.minimum_box_size: Point
    ! Minimum size of a box (to prevent re             ally small boxes).
    get_only
    get is (10@10)

component me.random: Random_Integer
    ! A generator for box sizes and origins.
    subtype_visible
    is field

component me.scrolling_frame: Scrolling_frame
    ! The Scrolling_frame parenting the Graphics_frame.  Allows you to
    ! scroll around the graphics.
    is field

operation create(Mytype)
    ! Create a Box_drawing_tool and display it.
    returns (Mytype)
    public
    is allocate
    begin
        var w: Attachable_work_area_frame;
        var buttons: Button_bar_frame;
        var cb_list: Sequence[Tool_callback];
        
        me.boxes := create(Set[Box]);
        me.random := create(Random_Integer, 1000);
        me.gp := create(Graphics_port);
        me.fill? := false;

        me.window := create(tool_window, "GraphicsTool",
                                me.default_title, me.default_icon_title, me);

            ! Create a frame to attach everything to

        w := create(Attachable_work_area_frame, "main", me.window);
        w.size := me.default_size;
        w.border_width := 0;
        apply_changes(w);
        me.window.workarea_frame := w;

            ! Create the scrolling frame so we may have a large graphics area
        me.scrolling_frame := create(Scrolling_frame, "scroller", w, true);
        me.scrolling_frame.size := me.default_size;
        cb_list := {create(Tool_callback, me, "scroll_graphics_area", is_me)};
        me.scrolling_frame.horizontal_scrollbar.value_changed_actions :=
               cb_list;
        me.scrolling_frame.vertical_scrollbar.value_changed_actions :=
               cb_list;

        me.scrolling_frame.horizontal_scrollbar.page_increment := 100;
        me.scrolling_frame.vertical_scrollbar.page_increment := 100;
              
            ! attach the scrolling frame sides to the windwo so the
            ! scrolling frame stretches when the window does
        attach_to_me(w, Frame_Left, me.scrolling_frame, Frame_Left);
        attach_to_me(w, Frame_Right, me.scrolling_frame, Frame_Right);
        attach_to_me(w, Frame_Top, me.scrolling_frame, Frame_Top);
        attach_to_me(w, Frame_Bottom, me.scrolling_frame, Frame_Bottom);
        
            ! create the pull-doen menus
        me.window.menu_bar_frame := create_menu_bar(me);

            ! Create the graphics frame (where the boxes are drawn)
        me.graphics_frame := create(Graphics_frame, "context",
                                        me.scrolling_frame);
        me.graphics_frame.border_width := 1;
        me.graphics_frame.size := me.default_graphics_area_size;
            ! set the graphics_frame to be the workarea of the scroller
        me.scrolling_frame.workarea_frame := me.graphics_frame;
            ! set the scrollbars so they operate in graphics_frame units
        me.scrolling_frame.horizontal_scrollbar.max_value :=
                me.graphics_frame.width;
        me.scrolling_frame.vertical_scrollbar.max_value :=
                me.graphics_frame.height;

            ! actions to perform when portions of the graphics      
        are exposed
        me.graphics_frame.expose_actions :=
                {create(Tool_callback, me, "redraw_boxes", is_me)};
        apply_changes(me.graphics_frame);

        apply_changes(w);
        apply_changes(me.scrolling_frame);
        make_default_size(me.window);
        apply_changes(me.window);
        start_up(me);
        display(me);
    end

operation create_box(me)
    ! Create a new box on the graphics frame.
    public
    is
    begin
        var new_box: Box;
        var width: Integer;
        var height: Integer;
        var origin: Point;

            ! Get a random height and width within the maximum
        width := max(me.random.next mod me.maximum_box_size.x, 1);
        height := max(me.random.next mod me.maximum_box_size.y, 1);

            ! Create the box, and make it at least the minimum size
        new_box := create(Box, 0@0, width, height);
        new_box := merge(new_box, create_s(Box, 0@0, me.minimum_box_size));

            ! Generate an origin somewhere in the visible part of the frame
            ! First generate an origin that falls inside the scroll frame
            ! Then offset it by the current origin of the graphics frame
        origin := (me.random.next mod me.maximum_origin.x) @
                          (me.random.next mod me.maximum_origin.y);
        origin := origin - me.graphics_frame.upper_left;

            ! Now move the box to the new origin
        new_box := translate(new_box, origin);

            ! Add the box and display...
        insert(me.boxes, new_box);
        redraw(me);
    end

operation create_menu_bar(me)
    ! Create the pulldownn menus on the menu bar.
    returns (Menu_bar_frame)
    public
    is
    begin
        var mb: Menu_bar_frame;
        var file_menu: Menu_bar_menu_frame;
        var edit_menu: Menu_bar_menu_frame;

        mb := create(Menu_bar_frame, "menubar", me.window);

        file_menu := create(Menu_bar_menu_frame, "fileMenu", mb);
        add_menu_items(me, file_menu, me.file_menu_entries);
        add_submenu(mb,@                                                                                                           ShZ $      TRELLIS010.D                   p8  b:  1[SYSMGR.SEAS$WORK_0000077F]BOX_DRAWING_TOOL.TRE;1                                                                                                                           "File", file_menu);
        apply_changes(file_menu);

        edit_menu := create(Menu_bar_menu_frame, "editMenu", mb);
        add_menu_items(me, edit_menu, me.edit_menu_entries);
        add_submenu(mb, "Boxes", edit_menu);
        apply_changes(edit_menu);

        apply_changes(mb);
        return mb;
    end

operation delete_all(me)
    ! Delete all the boxes.
    public
    is
    begin
        ! Delete all the boxes
        me.boxes := create(Set[Box]);
        redraw(me);
    end

operation redraw(me)
    ! Redraw the boxes in the graphics frame.
    public
    is
    begin
	    ! Draw the boxes
        redraw_boxes(me);
    end

operation redraw_boxes(me)
    ! Draw the boxes.
    public
    is
    begin
	    ! Clear the graphics (necessary if you're using a
	    ! display rule like XOR)
        clear(me.graphics_frame);
	    ! Draw the boxes
        for b: Box in elements(me.boxes) do
            draw_box_with_attributes(me.graphics_frame, 0@0, b,
                                     me.fill?, me.gp);
        end for;
        apply_changes(me.graphics_frame);
    end

operation scroll_graphics_area(me)
    ! Scroll the graphics frame so what is visible matches what the
    ! scroll bars say is visible.
    public
    is
    begin
        ! Scroll the graphics frame
        me.graphics_frame.upper_left :=
            (-me.scrolling_frame.horizontal_scrollbar.value) @
                (-me.scrolling_frame.vertical_scrollbar.value);
        !redraw(me);
    end

end type_module;
                                     / * [SYSMGR.SEAS$WORK_0000077F]BUILTIN_EXAMPLE.C;10 +  , q8   .     /     4 O                          - b:    0   1    2   3      K  P   W   O     5   6 ds  7 e  8          9          G    H  J                 /*  6  *   Copyright (c) Digital Equipment Corporation, 19906  *   All Rights Reserved.  Unpublished rights reserved3  *   under the copyright laws of the United States.   *    8  *   The software contained on this media is proprietary4  *   to and embodies the confidential technology of 5  *   Digital Equipment Corporation.  Possession, use, 5  *   duplication or dissemination of the software and 9  *   media is authorized only pursuant to a valid written 0  *   license from Digital Equipment Corporation.  *  5  *   RESTRICTED RIGHTS LEGEND   Use, duplication, or  4  *   disclosure by the U.S. Government is subject to9  *   restrictions as set forth in Subparagraph (c)(1)(ii) 3  *   of DFARS 252.227-7013, or in FAR 52.227-19, as   *   applicable.  *    */    #include <trellis.h>  & /* multiply two compatible vectors. */   TRELLIS_INTEGER C My_Vector_Multiply (TRELLIS_VECTOR Vector1, TRELLIS_VECTOR Vector2)  { 6     int size_of_first = Trellis_Vector_Size (Vector1);     int index, dot_product;   7     if (size_of_first != Trellis_Vector_Size (Vector2)) @             Trellis_Signal ("Bounds", Trellis_Get_Nil_Object());       dot_product = 0;  3     for (index = 0; index < size_of_first; index++)          dot_product +=  N              Trellis_Integer_Convert (Trellis_Vector_Fetch (Vector1, index)) *M              Trellis_Integer_Convert (Trellis_Vector_Fetch (Vector2, index));   0     return Trellis_Integer_Create (dot_product); }     O /* returns a**2 mod p where a and p are two TRELLIS_INTEGER components of me */    TRELLIS_INTEGER  Power(TRELLIS_OBJECT me) { M     int a = Trellis_Integer_Convert (Trellis_Get_Field_By_Name(me, "get_a")); M     int p = Trellis_Integer_Convert (Trellis_Get_Field_By_Name(me, "get_p"));   ,     return Trellis_Integer_Create (a*a % p); }                                                                                                                                                                                                                                                       0 * [SYSMGR.SEAS$WORK_0000077F]BUILTIN_EXAMPLE.TRE;5 +  , r8   .     /     4 =       P                   - b:    0   1    2   3      K  P   W   O     5   6  y?q  7 e  8          9          G    H  J               ! 
!   Copyright (c) Digital Equipment Corporation, 1990
!   All Rights Reserved.  Unpublished rights reserved
!   under the copyright laws of the United States.
!   
!   The software contained on this media is proprietary
!   to and embodies the confidential technology of 
!   Digital Equipment Corporation.  Possession, use,
!   duplication or dissemination of the software and
!   media is authorized only pursuant to a valid written
!   license from Digital Equipment Corporation.
! 
!   RESTRICTED RIGHTS LEGEND   Use, duplication, or 
!   disclosure by the U.S. Government is subject to
!   restrictions as set forth in Subparagraph (c)(1)(ii)
!   of DFARS 252.227-7013, or in FAR 52.227-19, as
!   applicable.
! 

TRELLIS_ENTER type_module Vector

TRELLIS_ADD
operation  mult(me,x: vector[integer] )
    returns (integer)
    signals (bounds)
    public
    is builtin("My_Vector_Multiply", "builtin_example_image")

end type_module;



TRELLIS_ADD type_module test

TRELLIS_ADD
component me.p: Integer  
    is field;

TRELLIS_ADD
component me.a: Integer
    is field;

TRELLIS_ADD
operation create (mytype, x: Integer, y: Integer)
    returns (mytype)
    is allocate
    begin
        me.a := x;
        me.p := y;
    end;

TRELLIS_ADD
operation  power (me)
    returns (integer)
    is builtin ("Power", "builtin_example_image")

end type_module;
                                                                                                                                                                                             : * [SYSMGR.SEAS$WORK_0000077F]BUILTIN_EXAMPLE_LIBRARIES.OPT;1 +  , s8   .     /     4 P                          - b:    0   1    2   3      K  P   W   O     5   6 `  7 Kf  8          9          G    H  J                      ! P !  If you reference any of our symbols,  you need to link against our shareable D !   image (make sure the logical trellis$image is defined correctly) !  trellis$image/share J !   (add a coma and dash (",-") at the end of the previous line if you add !    any more libraries) ! M !   You may also need to link against other libraries, most likely the C rtl. ( !    (check its location on your system) !  !sys$library:vaxcrtl/share,- !sys$library:decw$xlibshr/share                                                5 * [SYSMGR.SEAS$WORK_0000077F]BUILTIN_EXAMPLE_MAKE.COM;2 +  , t8   .     /     4 J                           - b:    0   1    2   3      K  P   W   O     5 
  6 o  7 `f  8          9          G    H  J                           $  $   ! compile test c code J $   !   if you move our include file (trellis.h) then change the /include=, $   !   option to reference the new location $ > $ cc/debug/nolist/noopt/include=sys$library  builtin_example.c $ > $   ! make a shareable image (see linker manual for more info)B $   !   make sure that you link against the correct libraries (see' $   !   builtin_example_libraries.opt)   $ ? $ link/debug/share=builtin_example_image builtin_example.obj, - -             builtin_example_universals/opt, - )             builtin_example_libraries/opt  $ H $   ! don't forget to define the logical builtin_example_image to point  $   !   to the shareable image $                                                                                                                                                                                                                                                                                                                                                                          5 * [SYSMGR.SEAS$WORK_0000077F]BUILTIN_EXAMPLE_README.;13 +  , u8   .     /     4 P       b                    - b:    0   1    2   3      K  P   W   O 
    5   6 l  7 `<%f  8          9          G    H  J                            K The following files (located in trellis$sourcedev:[builtins]) are needed to M run the example of adding builtins to the Trellis system.  Create a directory H and copy these files into it.  Then run builtin_example_make.com in thatF directory.  See the Appendix in the DEC Trellis Object System LanguageM Reference Manual that describes builtins (foriegn operations) for information F about adding builtins to the Trellis system.  Also, see below for moreN information about running the example and about acce                                                                                                                                                                                                                                                                                                                           $      TRELLIS010.D                   u8  b:  5[SYSMGR.SEAS$WORK_0000077F]BUILTIN_EXAMPLE_README.;13                                                                          P                              !             ssing user-defined Trellis objects from non-Trellis code.     builtin_example.c  builtin_example.tre +   The C and Trellis code for the examples..    builtin_example_make.comJ   This file compiles and links the C code for the examples (trellis$image I   should be defined before running this command file - see Trellis System F   files below or the Trellis Installation Guide).  This will generate B   builtin_example.obj and builtin_example_image.exe.  The logical 6   builtin_example_image should be defined to point at G   builtin_example_image.exe.  See below for more details about running     the examples.    builtin_example_universals.opt builtin_example_libraries.opt N   These files are used in linking the examples and you will want similar filesN   when linking your builtins.  See the VMS linker manual for details on makingN   shareable images and see the comments in builtin_example_libraries.opt about   run-time libraries.     5 You will also use the following Trellis System files.      sys$system:trellis.exeP   The Trellis system starter.  The logical trellis$main must point at this file.    sys$library:trellis$imageshr.exeA   The Trellis run-time library as a shareable image.  The logical (   trellis$image must point at this file.   sys$library:trellis.h F   This include file contains Trellis System routines, definitions, andM   symbols available to external code.  (See the include file for the details  N   of the interfaces.)  It should be included by all builtins that call any of    the Trellis System routines.       = Accessing User Defined Trellis Objects from non-Trellis code. = -------------------------------------------------------------   L   The example of a builtin in the Appendix (of the DEC Trellis Object SystemK   Language Reference Manual on builtins) shows how to access objects which  N   the Trellis run-time image already has routines for.  It is also possible toI   access objects defined in Trellis that are not included in the standard 
   library.  J   The primary mechanism for this is the routine Trellis_Get_Field_By_Name.  L     TRELLIS_OBJECT Trellis_Get_Field_By_Name (TRELLIS_OBJECT me, char *name)  N   me is the object we wish to extract a field from and name is the name of the2   field prefixed with get_, e.g., a becomes get_a.  H   Trellis_Get_Field_By_Name returns the contents of the field (a Trellis7   object).  Here is an example of how it might be used:   I     Suppose we have a type with two Integer fields: a and p.  We want to  .     write a C routine that returns a**2 mod p.       The Trellis code is        type_module test  )         component me.a: Integer is field; )         component me.p: Integer is field;            operation power(me)              returns(Integer)9             is builtin("Power", "builtin_example_image");   9         operation create (mytype, x: Integer, y: Integer)              returns (mytype)             is allocate              begin                  me.a := x;                 me.p := y;             end;       end type_module        And the C code is        #include <trellis.h>       /* returns a**2 mod p A         where a and p are two TRELLIS_INTEGER components of me */        TRELLIS_INTEGER      Power(TRELLIS_OBJECT me)     { O       int a = Trellis_Integer_Convert (Trellis_Get_Field_By_Name(me, "get_a")); O       int p = Trellis_Integer_Convert (Trellis_Get_Field_By_Name(me, "get_p"));   .       return Trellis_Integer_Create (a*a % p);     }   L   The primary advantage to using Trellis_Get_Field_By_Name is that it allowsK   the Trellis compiler to allocate fields in any fashion and yet C code can    still access the values.       Running the Examples --------------------  C   Source code for both examples is include in builtin_example.c and K   builtin_example.tre.  After running builtin_example_make.com and defining F   the logical builtin_example_image to point at the shareable image itN   creates,  batch compile builtin_example.tre (on the trellis.tws workspace). J   When the Trellis programming environment comes up you can browse the new@   code and bring up evaluator to try the new builtin operations.         Here is some sample input:  #     a := create(vector[Integer], 3) #     b := create(vector[Integer], 3)      a[1] := 101      a[2] := 113 
     a[3] := 3 
     b[1] := 9      b[2] := 19     b[3] := 112      mult(a, b)     a[2] := 11     mult(a, b)       c := create(test, 3, 71)     power(c)
     c.a := 31      power(c)         And its output:   E     ev[1]: VECTOR[INTEGER]'{1: undefined, 2: undefined, 3: undefined} E     ev[2]: VECTOR[INTEGER]'{1: undefined, 2: undefined, 3: undefined}      ev[3]: 101     ev[4]: 113     ev[5]: 3     ev[6]: 9
     ev[7]: 19      ev[8]: 112     ev[9]: 3392      ev[10]: 11     ev[11]: 1454       ev[12]: a TEST
     ev[13]: 9      ev[14]: 31     ev[15]: 38    L   You may just type the input into an evaluator or cut and paste it with theJ   mouse.  Then evaluate each line inorder.  Your output should be the sameN   except for blank lines and possibly different subscripts for the ev vector. D   You might try inspecting the new objects or trying your own input.                                                                                                                                                                                                                                                                                                                                                                                                                                           ; * [SYSMGR.SEAS$WORK_0000077F]BUILTIN_EXAMPLE_UNIVERSALS.OPT;1 +  , v8   .     /     4 $       &                    - b:    0   1    2   3      K  P   W   O     5   6 `  7 `q1f  8          9          G    H  J                    $ universal= My_Vector_Multiply, Power                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        - * [SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE.C;9 +  , w8   .     /     4 P       d                   - b:    0   1    2   3      K  P   W   O     5   6  ft  7  -?f  8          9          G    H  J                  /* 
 *   Copyright (c) Digital Equipment Corporation, 1990
 *   All Rights Reserved.  Unpublished rights reserved
 *   under the copyright laws of the United States.
 *   
 *   The software contained on this media is proprietary
 *   to and embodies the confidential technology of 
 *   Digital Equipment Corporation.  Possession, use,
 *   duplication or dissemination of the software and
 *   media is authorized only pursuant to a valid written
 *   license from Digital Equipment Corporation.
 * 
 *   RESTRICTED RIGHTS LEGEND   Use, duplication, or 
 *   disclosure by the U.S. Government is subject to
 *   restrictions as set forth in Subparagraph (c)(1)(ii)
 *   of DFARS 252.227-7013, or in FAR 52.227-19, as
 *   applicable.
 * 
 */


#include <trellis.h>


void
tree_node_cinsert (TRELLIS_OBJECT me, TRELLIS_OBJECT str)
/*
    This operation does almost the same thing as Tree_node\mixed_insert,
    except that mixed_insert calls itself (Trellis code) going down the 
    left branch and calls this routine (C code) going down the right and
    this routine does exactly the opposite (calls C code down the left and
    Trellis code down the right).
*/
{
    int             flag;
    TRELLIS_HANDLE  me_handle;
    TRELLIS_HANDLE  str_handle;
    TRELLIS_HANDLE  symbol;
    TRELLIS_HANDLE  count;
    TRELLIS_HANDLE  depth;
    TRELLIS_HANDLE  left;
    TRELLIS_HANDLE  right;

    TRELLIS_OBJECT  return_object;
    TRELLIS_OBJECT  exception_string;
    TRELLIS_OBJECT  counter_args[3];

        /* these must be initialized before calling into Trellis */
    me_handle   = Trellis_Create_Handle(me);
    str_handle  = Trellis_Create_Handle(str);
    symbol      = Trellis_Create_Handle(
                            Trellis_Get_Field_By_Name(me, "get_symbol"));
    count       = Trellis_Create_Handle(
                            Trellis_Get_Field_By_Name(me, "get_count"));
    depth       = Trellis_Create_Handle(
                            Trellis_Get_Field_By_Name(me, "get_depth"));
    left        = Trellis_Create_Handle(
                                                                                                                                                                                            [1B $      TRELLIS010.D                   w8  b:  -[SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE.C;9                                                                                  P                              E                                        Trellis_Get_Field_By_Name(me, "get_left"));
    right       = Trellis_Create_Handle(
                            Trellis_Get_Field_By_Name(me, "get_right"));

        /* don't need handles for these three, ... (?) */
    counter_args[0] = Trellis_Find_Type("callin_example");
    counter_args[1] = Trellis_Integer_Create(1);
    counter_args[2] = Trellis_String_Create("c insert count");

    flag = Trellis_Apply_Op_w_arg_array ("increment_counter", 
                                            &return_object, &exception_string,
                                            3, counter_args);

        /* Objects in counter_args may not be valid any more.  Therefore,
            counter_args must be reinitialized if used again. */

    flag = Trellis_Apply_Op ("equal?", &return_object, &exception_string,
                                Trellis_Get_Handle_Value(str_handle),
                                Trellis_Get_Handle_Value(symbol), 0);

    if (Trellis_Boolean_Convert(return_object))
    {       /* found the correct node */
        TRELLIS_OBJECT  incr_count;

        flag = Trellis_Apply_Op ("add", &incr_count, &exception_string,
                                    Trellis_Get_Handle_Value(count),
                                    Trellis_Integer_Create(1), 0);
        flag = Trellis_Apply_Op ("put_count", &return_object, &exception_string,
                                    Trellis_Get_Handle_Value(me_handle),
                                    incr_count, 0);
    }
    else
    {
        TRELLIS_HANDLE  null_type;
        TRELLIS_HANDLE  tree_node_type;

        null_type       = Trellis_Create_Handle(Trellis_Find_Type("null"));
        tree_node_type  = Trellis_Create_Handle(Trellis_Find_Type("tree_node"));


        flag = Trellis_Apply_Op ("less?", &return_object, &exception_string,
                                Trellis_Get_Handle_Value(str_handle),
                                Trellis_Get_Handle_Value(symbol), 0);

        if (Trellis_Boolean_Convert(return_object))
        {       /* the string is less, so add to the left arm of tree */
            if (Trellis_Object_Get_Type(Trellis_Get_Handle_Value(left)) ==
                Trellis_Get_Handle_Value(null_type))
            {
                TRELLIS_OBJECT  new_depth;
                TRELLIS_OBJECT  new_tree_node;

                flag = Trellis_Apply_Op ("add", &new_depth, &exception_string,
                            Trellis_Get_Handle_Value(depth),
                            Trellis_Integer_Create(1), 0);
                flag = Trellis_Apply_Op ("create", &new_tree_node, 
                            &exception_string,
                            Trellis_Get_Handle_Value(tree_node_type),
                            Trellis_Get_Handle_Value(str_handle),
                            new_depth, 0);
                flag = Trellis_Apply_Op ("put_left", &return_object, 
                            &exception_string,
                            Trellis_Get_Handle_Value(me_handle),
                            new_tree_node, 0);
            }
            else if (Trellis_Object_Get_Type(Trellis_Get_Handle_Value(left)) 
                                == Trellis_Get_Handle_Value(tree_node_type))
            {
                tree_node_cinsert(Trellis_Get_Handle_Value(left),
                                    Trellis_Get_Handle_Value(str_handle));
/*
                flag = Trellis_Apply_Op ("mixed_insert", &return_object, 
                            &exception_string,
                            Trellis_Get_Handle_Value(left),
                            Trellis_Get_Handle_Value(str_handle), 0);
*/
            }
            else
            {
            }
        }
        else
        {       /* the string is greater, so add to the right arm of tree */
            if (Trellis_Object_Get_Type(Trellis_Get_Handle_Value(right)) ==
                Trellis_Get_Handle_Value(null_type))
            {
                TRELLIS_OBJECT  new_depth;
                TRELLIS_OBJECT  new_tree_node;

                flag = Trellis_Apply_Op ("add", &new      
       _depth, &exception_string,
                            Trellis_Get_Handle_Value(depth),
                            Trellis_Integer_Create(1), 0);
                flag = Trellis_Apply_Op ("create", &new_tree_node, 
                            &exception_string,
                            Trellis_Get_Handle_Value(tree_node_type),
                            Trellis_Get_Handle_Value(str_handle),
                            new_depth, 0);
                flag = Trellis_Apply_Op ("put_right", &return_object, 
                            &exception_string,
                            Trellis_Get_Handle_Value(me_handle),
                            new_tree_node, 0);
            }
            else if (Trellis_Object_Get_Type(Trellis_Get_Handle_Value(right))
                                == Trellis_Get_Handle_Value(tree_node_type))
            {
                flag = Trellis_Apply_Op ("mixed_insert", &return_object, 
                            &exception_string,
                            Trellis_Get_Handle_Value(right),
                            Trellis_Get_Handle_Value(str_handle), 0);
            }
            else
            {
            }
        }

        Trellis_Free_Handles (null_type, tree_node_type, 0);    
    }

    Trellis_Free_Handles (me_handle, str_handle, 
                            symbol, count, depth, left, right, 0);

    return;
}
                                                                                                                                                                          / * [SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE.TRE;6 +  , x8   .     /     4 O                           - b:    0   1    2   3      K  P   W   O     5   6 {q  7  bKf  8          9          G    H  J    
             ! 5 !   Copyright (c) Digital Equipment Corporation, 1990 5 !   All Rights Reserved.  Unpublished rights reserved 2 !   under the copyright laws of the United States. !   7 !   The software contained on this media is proprietary 3 !   to and embodies the confidential technology of  4 !   Digital Equipment Corporation.  Possession, use,4 !   duplication or dissemination of the software and8 !   media is authorized only pursuant to a valid written/ !   license from Digital Equipment Corporation.  ! 4 !   RESTRICTED RIGHTS LEGEND   Use, duplication, or 3 !   disclosure by the U.S. Government is subject to 8 !   restrictions as set forth in Subparagraph (c)(1)(ii)2 !   of DFARS 252.227-7013, or in FAR 52.227-19, as !   applicable.  !       type_module callin_example ! E !   This application reads a file and counts the number of times each J !   identifier (see String\read_id_from included with this application) isH !   used.  It uses a binary tree to sort and count the identifiers.  TheC !   types Tree_node and Symbol_tree define and implement the trees.  ! I !   There are two versions of the tree initialization routines:  one that K !   is implemented all in Trellis (uses Tree_node\insert to fill the tree)  ; !   and one that is implemented in both C and Trellis (uses D !   Tree_node\mixed_insert and Tree_node\c_mixed_insert [a builtin] " !   alternately to fill the tree). ! 0 !   This application can be run as one activity:2 !               simple_all_trellis(callin_example)3 !               simple_mixed_insert(callin_example)  ! E !   or several activities (where number is the number of activities): < !               multiple_all_trellis(callin_example, number)= !               multiple_mixed_insert(callin_example, number)  !     . operation build_and_print_all_trellis (mytype)     returns (symbol_tree) 
     public     is	     begin 7         var tree: Symbol_tree   := create(Symbol_tree);   O         var in: In_file         := create(In_file, "callin_example_input.txt");           id_initialize(tree, in);         close(in);  <         var out: Out_file := create(Out_file, force(String, H                                     Activity.current["out_file_name"]));$         print_inorder_to(tree, out);-         print_all_to ({"Total inserts   : ",  O                     (force(Integer, Activity.current["trellis insert count"]) + N                      force(Integer, Activity.current["c insert count"])), eol,E                     "Maximum depth  : ", max_depth(tree), eol}, out);          close(out);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Il5 $      TRELLIS010.D                   x8  b:  /[SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE.TRE;6                                                                                O                              s             #         return tree;                     end       / operation build_and_print_mixed_insert (mytype)      returns (symbol_tree) 
     public     is	     begin 7         var tree: Symbol_tree   := create(Symbol_tree);   O         var in: In_file         := create(In_file, "callin_example_input.txt"); !         id_init_mixed (tree, in);          close(in);  <         var out: Out_file := create(Out_file, force(String, H                                     Activity.current["out_file_name"]));$         pr             int_inorder_to(tree, out);-         print_all_to ({"Total inserts   : ",  O                     (force(Integer, Activity.current["trellis insert count"]) + N                      force(Integer, Activity.current["c insert count"])), eol,E                     "Maximum depth  : ", max_depth(tree), eol}, out);          close(out);   #         return tree;                     end       F operation increment_counter (Mytype, how_much: Integer, which: String)
     public     is	     begin L         Activity.current[which] := dummy_add_count(Mytype, Activity.current,E                                                     which, how_much);      end     6 operation dummy_add_count (Mytype, current: Activity, =                             which: String, how_much: Integer)      returns (Integer) 
     public     is	     begin :         return  how_much + force(Integer, current[which]);     end     8 operation multiple_all_trellis (Mytype, number: Integer)
     public     is	     begin A         multiple (Mytype, number, "build_and_print_all_trellis");      end     9 operation multiple_mixed_insert (Mytype, number: Integer) 
     public     is	     begin B         multiple (Mytype, number, "build_and_print_mixed_insert");     end       : operation multiple (Mytype, number: Integer, name: String)
     public     is	     begin 9         var my_set: Activity_set := create(Activity_set);          var new: Activity;  *         for i: Integer in range(1, number)
         doC             new := create_frozen(Activity, n      
       ame, {Callin_example}); -             new["number"]               := i; -             new["trellis insert count"] := 0; -             new["c insert count"]       := 0; ?             new["out_file_name"]        := "callin_example_" &  H                                                 string_form(i) & ".out";              insert(my_set, new);             thaw(new);         end for;           close_set(my_set);  /         for act: Activity in await_next(my_set) 
         doF             print_all({"Activity ", act["number"], " is done.", eol});1             print_all({"Trellis insert count: ",  9                         act["trellis insert count"], eol, 2                         "C insert count      : ", :                         act["c insert count"], eol, eol});         end for;  &         print_all({"All done.", eol});     end       % operation simple_all_trellis (mytype) 
     public     is	     begin /         multiple_all_trellis(mytype, 1)              end       & operation simple_mixed_insert (mytype)
     public     is	     begin 1         multiple_mixed_insert (mytype, 1)              end      end type_module;       type_module symbol_tree     # component me.root: tree_node | null      is field   operation  create(mytype)      returns (mytype)
     public     is allocate 	     begin          me.root := nil;      end     * operation id_init_mixed (me, s: In_Stream)
     public     is	     begin +         if not open?(s) then return end if; +         if not more?(s) then return end if;         
                var symbol: string;            loop/             symbol := read_id_from (String, s);                           type_case me.root L                 on null      do     me.root := create(tree_node, symbol, 1);I                 on tree_node do     mixed_insert(selector_value, symbol);              end type_case;         end loop; 
     except?         on Bad_format, End_of_file, Closed, IO_Error do return;          otherwise do return;     end     * operation id_initialize (me, s: In_Stream)
     public     is	     begin +         if not open?(s) then return end if; +         if not more?(s) then return end if;            var symbol: string;            loop/             symbol := read_id_from (String, s);                           type_case me.root                  on null C                         do me.root := create(tree_node, symbol, 1);                  on tree_node  :                         do insert(selector_value, symbol);                 otherwise                          do             end type_case;         end loop; 
     except?         on Bad_format, End_of_file, Closed, IO_Error do return;          otherwise do return;     end      operation max_depth(me)      returns (Integer) 
     public     is	     begin          type_case me.root %             on null      do return 0; @             on tree_node do return max_depth(selector_value, 0);         end type_case;     end     . operation print_inorder_to (me, s: Out_Stream)
     public     is	     begin >                      var lines: Dyn_seq[String] := create(Dyn_seq[string]);           type_case me.root D             on null      do add_first(lines, "This tree is empty.");C             on tree_node do inorder_strings(selector_value, lines);          end type_case;  5         for line_string: string in elements(lines) do 0             print_all_to({line_string, eol}, s);         end for;     end      end type_module;       type_module tree_node    component me.count: Integer      is field     component me.depth: Integer      is field    # component me.left: tree_node | null      is field    $ component me.right: tree_node | null     is field     component me.symbol: string      is field    = operation  create(mytype, new_string: string, depth: integer)      returns (mytype)
     public     is allocate 	     begin          me.left := nil;          me.right := nil;         me.count := 1;          me.symbol := new_string;         me.depth := depth;     end     6 operation inorder_strings (me, lines: dyn_seq[string])
     public     is	     begin          type_case me.left              on null      do ; C             on tree_node do inorder_strings(selector_value, lines);          end type_case;  )         add_last(lines, string_form(me));            type_case me.right             on null      do ; C             on tree_node do inorder_strings(selector_value, lines);          end type_case;      end      operation insert (me, s: String)
     public     is	     begin E         increment_counter(callin_example, 1, "trellis insert count");            if s = me.symbol then %             me.count := me.count + 1; !         elseif s < me.symbol then              type_case me.left N                 on null      do me.left := create(tree_node, s, me.depth + 1);:                 on tree_node do insert(selector_value, s);             end type_case;         else             type_case me.rightO                 on null      do me.right := create(tree_node, s, me.depth + 1); :                 on tree_node do insert(selector_value, s);             end type_case;         end if;      end     - operation max_depth (me, max_so_far: Integer)      returns (Integer) 
     public     is	     begin -         var local_max: Integer := max_so_far;            type_case me.left 9             on null      do if me.depth > local_max then  6                                 local_max := me.depth;#                             end if; N             on tree_node do local_max := max_depth(selector_value, local_max);         end type_case;           type_case me.right9             on null      do if me.depth > local_max then  6                                 local_max := me.depth;#                             end if; N             on tree_node do local_max := max_depth(selector_value, local_max);         end type_case;           return local_max;       end      ( operation c_mixed_insert (me, s: string)
     public<     is builtin ("tree_node_cinsert", "callin_example_image")    & operation mixed_insert (me, s: string)
     public     is	     begin E         increment_counter(callin_example, 1, "trellis insert count");            if s = me.symbol then %             me.count := me.count + 1; !         elseif s < me.symbol then              type_case me.left N                 on null      do me.left := create(tree_node, s, me.depth + 1);@                 on tree_node do mixed_insert(selector_value, s);             end type_case;         else             type_case me.rightO                 on null      do me.right := create(tre                                                                                                                                                                                                           j#B $      TRELLIS010.D                   x8  b:  /[SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE.TRE;6                                                                                O                              J             e_node, s, me.depth + 1); B                 on tree_node do c_mixed_insert(selector_value, s);             end type_case;         end if;      end      operation string_form (me)     returns (String)
     public     is	     begin K         return me.symbol & " appears " & string_form(me.count) & " times.";      end      end type_module;        
 TRELLIS_ENTER  type_module String     TRELLIS_ADD - operation read_id_from (Mytype, s: In_stream)  ! E !   reads an identifier (similar to programming language identifiers)  !   from the stream  !      returns (String)@     signals (Bad_format, End_of_file, Closed, IO_Error (String))     override     is	     begin          input_whitespace(s);         7         if not more?(s) then signal End_of_file end if;   +         var chr: Character := peek_char(s);             if alphabetic?(chr) then,             return input_while(s, id_chars);!         elseif a_digit?(chr) then *             return input_while(s, digits);         else             skip_char(s);              return chr;          end if; 
     except5         on Closed, IO_Error, End_of_file do resignal; '         otherwise do signal Bad_format;      end      end type_module;                                                                                                                                                                                                                                                                                                                                             5 * [SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE_INPUT.TXT;2 +  , y8   .     /     4 O       r                   - b:    0   1    2   3      K  P   W   O     5 
  6 'p  7 Yf  8          9          G    H  J              
            0                               /       or       \0                               \Writing Builtins/     Step 1: 3     In type Vector, we add the following operation: .         operation mult(me, x: Vector[Integer])             returns(Integer)             signals(Bounds) F             is builtin("My_Vector_Multiply", "builtin_example_image");L     operation.  The keyword "builtin" is followed by a list of strings.  TheH     file name if the image is in sys$library) that points to a shareableL     into the Trellis image - see step 3 for details).  To ensure portability     Step 2:      1   #include <trellis.h>  .         /* multiply two compatible vectors. */           TRELLIS_INTEGER K         My_Vector_Multiply (TRELLIS_VECTOR Vector1, TRELLIS_VECTOR Vector2) 	         {              int k;3             if (j != Trellis_Vector_Size (Vector2)) D     3           Trellis_Signal ("Bounds", Trellis_Get_Nil_Object());             k = 0;             for (i=0; i<j; i++) O     4         k += Trellis_Integer_Convert(Trellis_Vector_Fetch (Vector1, i)) * .     5       return Trellis_Integer_Create (k);	         } I         2:  The Trellis shareable image contains a number of routines for L         value NIL (Trellis_Get_Nil_Object(returns the Trellis Nil object).  K         5:  Once we have the dot product of the two vectors (the sum of the L     image. (See Appendix C and builtin_example_make.com for more informationL     about compiling and linking your builtins.)  Assume that the object fileD         $ link/share=myimage vector.obj,universals/opt,libraries/optE     Vector\mult operation, the Trellis run-time system  will find the D     My_Vector_Multiply routine in builtin_example_image at runtime.      Ultrix: E     Vector\mult operation, the Trellis run-time system  will find the +     My_Vector_Multiply routine at runtime.             Appendix A        -     -------------------------------------          ==========     #include <trellis.h>       /* returns a**2 mod p A         where a and p are two TRELLIS_INTEGER components of me */      TRELLIS_INTEGER      Power(TRELLIS_OBJECT me)     { O       int a = Trellis_Integer_Convert (Trellis_Get_Field_By_Name(me, "get_a")); .       return Trellis_Integer_Create (a*a % p);#     a := create(vector[integer], 3) E     ev[1]: VECTOR[INTEGER]'{1: undefined, 2: undefined, 3: undefined}      ev[12]: a TEST
     ev[13]: 9                                                                                                                                                            9 * [SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE_LIBRARIES.OPT;1 +  , z8   .     /     4 P                          - b:    0   1    2   3      K  P   W   O     5 
  6 @p  7 Ref  8          9          G    H  J                       ! P !  If you reference any of our symbols,  you need to link against our shareable D !   image (make sure the logical trellis$image is defined correctly) !  trellis$image/share J !   (add a coma and dash (",-") at the end of the previous line if you add !    any more libraries) ! M !   You may also need to link against other libraries, most likely the C rtl. ( !    (check its location on your system) !  !sys$library:vaxcrtl/share,- !sys$library:decw$xlibshr/share                                                4 * [SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE_MAKE.COM;2 +  , {8   .     /     4 J                           - b:    0   1    2   3      K  P   W   O     5 
  6  h@p  7 @sf  8          9          G    H  J                            $  $   ! compile test c code J $   !   if you move our include file (trellis.h) then change the /include=, $   !   option to reference the new location $ = $ cc/debug/nolist/noopt/include=sys$library  callin_example.c  $ > $   ! make a shareable image (see linker manual for more info)B $   !   make sure that you link against the correct libraries (see& $   !   callin_example_libraries.opt)  $ = $ link/debug/share=callin_example_image callin_example.obj, - ,             callin_example_universals/opt, -(             callin_example_libraries/opt $ G $   ! don't forget to define the logical callin_example_image to point   $   !   to the shareable image $                                                                                                                                                                                                                                                                                                                                                                                  8 * [SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE_OUTPUT.CHECK;3 +  , |8   . 	    /     4     	    b                   - b:    0   1    2   3      K  P   W   O 	    5 
  6 )p  7 @Cf  8          9          G    H  J                        appears 1 times.
! appears 1 times.
" appears 10 times.
# appears 2 times.
$ appears 2 times.
% appears 1 times.
' appears 1 times.
( appears 22 times.
) appears 22 times.
* appears 8 times.
+ appears 3 times.
, appears 14 times.
- appears 40 times.
. appears 13 times.
/ appears 9 times.
0 appears 2 times.
1 appears 4 times.
12 appears 1 times.
13 appears 1 times.
2 appears 4 times.
3 appears 4 times.
4 appears 1 times.
5 appears 2 times.
9 appears 1 times.
: appears 14 times.
; appears 9 times.
< appears 3 times.
= appears 17 times.
> appears 2 times.
A appears 1 times.
Appendix appears 2 times.
Assume appears 1 times.
Bounds appears 2 times.
Builtins appears 1 times.
C appears 1 times.
INTEGER appears 1 times.
In appears 1 times.
Integer appears 2 times.
My_Vector_Multiply appears 4 times.
NIL appears 1 times.
Nil appears 1 times.
Once appears 1 times.
Power appears 1 times.
See appears 1 times.
Step appears 2 times.
TEST appears 1 times.
TRELLIS_INTEGER appears 3 times.
TRELLIS_OBJECT appears 1 times.
TRELLIS_VECTOR appears 2 times.
The appears 3 times.
To appears 1 times.
Trellis appears 5 times.
Trellis_Get_Field_By_Name appears 1 times.
Trellis_Get_Nil_Object appears 2 times.
Trellis_Integer_Convert appears 2 times.
Trellis_Integer_Create appears 2 times.
Trellis_Signal appears 1 times.
Trellis_Vector_Fetch appears 1 times.
Trellis_Vector_Size appears 1 times.
Ultrix appears 1 times.
VECTOR appears 1 times.
Vector appears 4 times.
Vector1 appears 2 times.
Vector2 appears 2 times.
Writing appears 1 times.
[ appears 6 times.
\ appears 4 times.
] appears 6 times.
a appears 10 times.
about appears 1 times.
add appears 1 times.
and appears 3 times.
are appears 1 times.
at appears 2 times.
builtin appears 2 times.
builtin_example_image appears 2 times.
builtin_example_make appears 1 times.
builtins appears 1 times.
by appears 1 times.
com appears 1 times.
compatible appears 1 times.
compiling appears 1 times.
components appears 1 times.
contains appears 1 times.
create appears 1 times.
details appears 1 times.
                                                                            uX $      TRELLIS010.D                   |8  b:  8[SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE_OUTPUT.CHECK;3                                                                             	                         t             dot appears 1 times.
ensure appears 1 times.
ev appears 3 times.
file appears 2 times.
find appears 2 times.
followed appears 1 times.
following appears 1 times.
for appears 4 times.
get_a appears 1 times.
h appears 2 times.
have appears 1 times.
i appears 4 times.
if appears 2 times.
image appears 4 times.
in appears 2 times.
include appears 2 times.
information appears 1 times.
int appears 2 times.
integer appears 1 times.
into appears 1 times.
is appears 3 times.
j appears 2 times.
k appears 4 times.
keyword appears 1 times.
libraries appears 1 times.
library appears 1 times.
link appears 1 times.
linking appears 1 times.
list appears 1 times.
me appears 4 times.
mod appears 1 times.
more appears 1 times.
mult appears 3 times.
multiply appears 1 times.
myimage appears 1 times.
name appears 1 times.
number appears 1 times.
obj appears 1 times.
object appears 2 times.
of appears 5 times.
operation appears 5 times.
opt appears 2 times.
or appears 1 times.
p appears 3 times.
points appears 1 times.
portability appears 1 times.
product appears 1 times.
return appears 2 times.
returns appears 3 times.
routine appears 2 times.
routines appears 1 times.
run appears 2 times.
runtime appears 2 times.
see appears 1 times.
share appears 1 times.
shareable appears 2 times.
signals appears 1 times.
step appears 1 times.
strings appears 1 times.
sum appears 1 times.
sys appears 1 times.
system appears 2 times.
that appears 2 times.
the appears 13 times.
time appears 2 times.
to appears 1 times.
trellis appears 2 times.
two appears 3 times.
type appears 1 times.
undefined appears 3 times.
universals appears 1 times.
value appears 1 times.
vector appears 2 times.
vectors appears 2 times.
we appears 2 times.
where appears 1 times.
will appears 2 times.
x appears 1 times.
your appears 1 times.
{ appears 3 times.
} appears 2 times.
Total inserts   : 3231
Maximum depth  : 16
                                                                                                                                                                           4 * [SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE_README.;10 +  , }8   . 	    /     4 P   	   	                     - b:    0   1    2   3      K  P   W   O 
    5   6 `sA^  7 @xf  8          9          G    H  J                             N The following files (located in trellis$sourcedev:[callin]) are needed to run M the example of calling into the Trellis system from non-Trellis code.  Create N a directory and copy these files into it.  Then run callin_example_make.com inI that directory.  See  below for how to run the example and see the Callin J chapter in the DEC Trellis Object System Type Library Reference Manual for more information about callin.     callin_example.c callin_example.treJ   The C and Trellis code for examples of callins.  See the comments in theD   Trellis type Callin_example for an explanation of the application.   callin_example_make.com I   This file compiles and links the C code for the examples (trellis$image J   should be defined before running this command file - see Trellis system F   files below or the Trellis Installation Guide).  This will generate @   callin_example.obj and callin_example_image.exe.  The logical N   callin_example_image should be defined to point at callin_example_image.exe.   callin_example_universals.opt  callin_example_libraries.optN   These files are used in linking the examples and you will want similar filesP   when linking your non-Trellis code.  See the VMS linker manual for details on O   making shareable images and see the comments in callin_example_libraries.opt     about run-time libraries.    callin_example_input.txt%   The input file used by the example.    callin_example_output.check K   The examples generate output files with names callin_example_#.out (where F   # represents a number).  To check to see if the examples are runningE   correctly, compare the output files to callin_example_output.check.    trellis_main.c   trellis_main_make.com L   Most applications will let the Trellis System start itself before they getK   started.  Due to different starting needs, some applications may want to  J   start the Trellis System themselves (by calling Trellis_System_Start).  I   trellis_main.c illustrates how this can be done.  trellis_main_make.com K   shows how the starting image is created and how a foreign command is made G   to run the application.  These files should be easy to modify to your H   applications needs.  See the Callin chapter in the DEC Trellis Object 8   System Type Library Reference Manual for more details.    5 You will also use the following Trellis System files.      sys$system:trellis.exeP   The Trellis system starter.  The logical trellis$main must point at this file.    sys$library:trellis$imageshr.exeA   The Trellis run-time library as a shareable image.  The logical (   trellis$image must point at this file.   sys$library:trellis.h F   This include file contains Trellis System routines, definitions, andM   symbols available to external code.  (See the include file for the details  M   of the interfaces.)  It should be included by all callins that call any of     the Trellis System routines.       To run the examples:L   Compile callin_example.tre on the trellis.tws workspace.  Then bring up anB   evaluator and evaluate one or more of the following expressions:  &     simple_all_trellis(callin_example)'     simple_mixed_insert(callin_example) 5     multiple_all_trellis(callin_example, some_number) 6     multiple_mixed_insert(callin_example, some_number)H         (Where some_number is small, best less than 5.  It can be biggerH          but the operations will take a long time to complete if it is.)    G   The screen output for simple_all_trellis(callin_example) should look     something like this:)                                                    Activity 1 is done. "         Trellis insert count: 3231         C insert count      : 0            All done.   .   and for simple_mixed_insert(callin_example):           Activity 1 is done. "         Trellis insert count: 1605"         C insert count      : 1626           All done.   N   The screen output for the multi* versions should look the same as the simpleJ   versions except that they will have one set of numbers for each activity   they start (some_number).   J   All versions produce file output in callin_example_#.out, where # is theI   activity number.  All of these files should be the same and the same as    callin_example_output.check.                                                                                                                                                                                                                                                                                                                                                                                   : * [SYSMGR.SEAS$WORK_0000077F]CALLIN_EXAMPLE_UNIVERSALS.OPT;2 +  , ~8   .     /     4                            - b:    0   1    2   3      K  P   W   O     5 
  6 jp  7 3f  8          9          G    H  J                      universal= tree_node_cinsert                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ) * [SYSMGR.SEAS$WORK_0000077F]CALLOUT.TRE;10 +  , 8   . $    /     4 O   $   $                    - b:    0   1    2   3      K  P   W   O %    5   6 @Tٓ  7 hf  8          9          G    H  J                       ! 5 !   Copyright (c) Digital Equipment Corporation, 1990 5 !   All Rights Reserved.  Unpublished rights reserved 2 !   under the copyright laws of the United States. !   7 !   The software contained on this media is proprietary 3 !   to and embodies the confidential technology of  4 !   Digital Equipment Corporation.  Possession, use,4 !   duplication or dissemination of the software and8 !   media is authorized only pursuant to a valid written/ !   license from Digital Equipment Corporation.  ! 4 !   `                                                                                                                                                                                                                                                                                                                                                                                                          + $      TRELLIS010.D                   8  b:  )[SYSMGR.SEAS$WORK_0000077F]CALLOUT.TRE;10                                                                                      O     $                         4             RESTRICTED RIGHTS LEGEND   Use, duplication, or 3 !   disclosure by the U.S. Government is subject to 8 !   restrictions as set forth in Subparagraph (c)(1)(ii)2 !   of DFARS 252.227-7013, or in FAR 52.227-19, as !   applicable.  !   " TRELLIS_ENTER type_module Boolean    !! Specification ! - !   operations for using Boolean with callout   N ! ----- Encode and Decode operations -----------------------------------------    ) operation encode (me, cb: Callout_buffer, *                       bit_offset: Integer)     signals (Bounds)     ! N     !   Puts a value for the Boolean me (0 for false, and 1 for true) into theK     !   Callout_buffer, cb, at bit bit_offset (0 to 7) of the current byte.      ! 3     is builtin ("Boolean_Encode", "trellis$image");     - operation decode (mytype, cb: Callout_buffer, .                           bit_offset: Integer)     returns (Mytype)     signals (Bounds)     ! F     !   Extracts the bit at bit_offset (0 to 7) in the current byte ofE     !   the Callout_buffer,              cb, and returns the corresponding Boolean ,     !   value (false for 0, and true for 1).     ! 3     is builtin ("Boolean_Decode", "trellis$image");      operation by_ref (me)      returns (Callout_buffer)     ! K     !   Creates a 4 byte Callout_buffer which is returned, puts a value for H     !   the Boolean me (0 for false, and 1 for true) into it at bit 0 ofM     !   the first byte, and zeros the rest of the bits in the Callout_buffer.      !      is	     begin <         var cb: Callout_buffer := create(Callout_buffer, 4);           encode(me, cb, 0);:         cb.offset := 0;         ! reset the offset to zero         return cb;     end;     operation by_value (me)      returns (Integer)      ! 8     !   Returns the Integer 0 if the Boolean me is false(     !   and the Integer 1 if me is true.     ! $     is (if me then 1 else 0 end if);   end type_module;  % TRELLIS_ENTER type_module Bytevector     !! Specification ! 5 !       operations for using bytevectors with callout   N ! ----- Encode and Decode operations -----------------------------------------    : operation encode (me, cb: Callout_buffer, length: Integer)     signals (Bounds, Overflow)     ! C     !   Puts a copy of length bytes of the Bytevector, me, into the 2     !   Callout_buffer, cb, at the current offset.     ! 6     is builtin ("Bytevector_Encode", "trellis$image");    - operation encode_sub (me, cb: Callout_buffer, :                           length: Integer, start: Integer)     signals (Bounds, Overflow)     ! C                  !   Puts a copy of length bytes, starting at byte start, of the K     !   Bytevector, me, into the Callout_buffer, cb, at the current offset.      !      is	     begin 5         encode(subseq(me,start,me.size), cb, length); 
     except(         on Bounds, Overflow do resignal;     end;    > operation decode (mytype, cb: Callout_buffer, length: Integer)     returns (Mytype)     signals (Bounds, Overflow)     ! E     !   Takes length bytes from the Callout_buffer, cb, and returns a F     !   newly created Bytevector which contains a copy of those bytes.     ! 6     is builtin ("Bytevector_Decode", "trellis$image");    & operation by_ref (me, length: Integer)     returns (Callout_buffer)     ! E     !   Creates a Callout_buffer which is returned and puts a copy of H     !   length bytes from the Bytevector, me, into it at the first byte.     !      is	     begin A         var cb: Callout_buffer := create(Callout_buffer, length);            encode(me, cb, length); :         cb.offset := 0;         ! reset the offset to zero         return cb;     end;   end type_module;  " TRELLIS_ENTER type_module Integer    !! Specification ! % !   additional operations for callout   N ! ----- Signed integer encode and decode operations --------------------------    I define shword_size: Integer public := 2;    ! size of a Vax short word or G                                             ! a MIPS half word in bytes   H define lword_size: Integer public := 4;     ! size of a Vax long word orB                       
                                   ! a MIPS word in bytes    ) operation encode (me, cb: Callout_buffer, &                       length: Integer)     signals (Bounds, Overflow)     ! @     !   Puts an Integer, me, into the Callout_buffer, cb, at the7     !   current offset as a length byte signed integer.      ! 3     is builtin ("Integer_Encode", "trellis$image");     - operation decode (mytype, cb: Callout_buffer, *                           length: Integer)     returns (Mytype)     signals (Bounds, Overflow)     ! @     !   Takes length bytes from the Callout_buffer, cb, startingA     !   at the current offset and returns an Integer whose signed ,     !   value is represented by those bytes.     ! 3     is builtin ("Integer_Decode", "trellis$image");     & operation by_ref (me, length: Integer)     returns (Callout_buffer)     signals (Overflow)     ! G     !   Creates a Callout_buffer which is returned and puts an Integer, F     !   me, into it at the first byte as a length byte signed integer.     !      is	     begin A         var cb: Callout_buffer := create(Callout_buffer, length);            encode(me, cb, length); :         cb.offset := 0;         ! reset the offset to zero         return cb;
     except!         on Overflow do  resignal;      end;   end type_module;   TRELLIS_ENTER type_module Real     !! Specification ! $ !   operations for callout and Reals  O ! --- Single-precision floating-point (4 bytes) encode and decode operations --     ? define float_real_size: Integer public := 4;    ! size in bytes     . operation encode_float(me, cb: Callout_buffer)(     signals(Bounds, Overflow, Underflow)     ! I     !   Converts a Trellis real, me, to a single-precision floating-point ?     !   number in machine specific format and puts it into the       !   Callout_buffer, cb.      ! 6     is builtin ("Real_Encode_Float", "trellis$image");    2 operation decode_float(Mytype, cb: Callout_buffer)     returns(Mytype)      signals(Bounds, Overflow)      ! K     !   Takes a single-precision floating-point number in machine specific  K     !   format from the Callout_buffer, cb, and converts it into a Trellis       !   real to be returned.     ! 6     is builtin ("Real_Decode_Float", "trellis$image");     operation by_ref_float(me)     returns(Callout_buffer)       signals(Overflow, Underflow)     ! I     !   Converts a Trellis real, me, to a single-precision floating-point B     !   number in machine specific format and puts it into a newlyB     !   created Callout_buffer, to be returned, at the first byte.     !      is	     begin J         var cb: Callout_buffer := create(Callout_buffer, float_real_size);           encode_float(me, cb); :         cb.offset := 0;         ! reset the offset to zero         return cb;
     except0         on Overflow, Underflow      do resignal;     end;    O ! --- Double-precision floating-point (8 bytes) encode and decode operations --     ? define double_real_size: Integer public := 8;   ! size in bytes     / operation encode_double(me, cb: Callout_buffer) <     signals(Bounds, Overflow, Underflow, Bad_format(string))     ! I     !   Converts a Trellis real, me, to a double-precision floating-point >     !   number in machine specific format and puts it into the     !   Callout_buffer, cb.      ! 7     is builtin ("Real_Encode_Double", "trellis$image");     3 operation decode_double(Mytype, cb: Callout_buffer)      returns(Mytype) 1     signals(Bounds, Overflow, Bad_format(string)) K     !   Takes a double-precision floating-point number in machine specific  J     !   format from the Callout_buffer, cb, and converts it into a Trellis     !   real to be returned.     ! 7     is builtin ("Real_Decode_Double", "trellis$image");      operation by_ref_double(me)      returns(Callout_buffer)       signals(Overflow, Underflow)I     !   Converts a Trellis real, me, to a double-precision floating-point B     !   number in machine specific format and puts it into a newlyB     !   created Callout_buffer, to be returned, at the first byte.     !      is	     begin K         var cb: Callout_buffer := create(Callout_buffer, double_real_size);            encode_double(me, cb);:         cb.offset := 0;         ! reset the offset to zero         return cb;
     except0         on Overflow, Underflow      do resignal;     end;   end type_module;  ! TRELLIS_ENTER type_module String     !! Specification !  !   operations for callout  O ! ----- VMS string descriptor encode and decode operations --------------------  ! M !   All encode_ and by_ref_ oper                                                                                                                                                                                                   	                        !6 $      TRELLIS010.D                   8  b:  )[SYSMGR.SEAS$WORK_0000077F]CALLOUT.TRE;10                                                                                      O     $                         .             ations create fixed-length string descriptors J !   except encode_empty_dyn_descr and by_ref_empty_dyn_descr which create J !   dynamic string descriptors.  Decode will decode both fixed-length and  !   dynamic string descriptors.     / define string_descr_size: Integer  public := 8; *     ! size of a string descriptor in bytes    . operation encode_descr(me, cb: Callout_buffer)     signals(Bounds, Overflow)      ! H     !   Copies the String me into a non-compactable area of the heap andN     !   puts a VMS string descriptor for the copy into the Callout_buffer, cb.     ! 8     is builtin ("String_Encode_Descr", "trellis$image");    G operation encode_empty_descr(Mytype, cb: Callout_buffer, size: Integer)      signals(Bounds, Overflow)      ! K     !   Creates an empty String, size characters long, in a non-compactable G     !   area of the heap and puts a VMS string descriptor for the empty +     !   String into the Callout_buffer, cb.      ! >     is builtin ("String_Encode_Empty_Descr", "trellis$image");    < operation encode_empty_dyn_descr(Mytype, cb: Callout_buffer)     signals(Bounds, Overflow)      ! J     !   Puts a VMS dynamic string descriptor for the empty String into the     !   Callout_buffer, cb.      ! ?     is builtin ("String_Encode_Empty_DDescr", "trellis$image");     2 operation decode_descr(Mytype, cb: Callout_buffer)     returns(Mytype)      signals(Bounds, Overflow)      ! @     !   Creates an Trellis String from the VMS string descriptor,     !   contained in the Callout_b             uffer, cb.     ! 8     is builtin ("String_Decode_Descr", "trellis$image");     operation by_ref_descr(me)     returns(Callout_buffer)      ! M     !   Creates a Callout_buffer, copies the String me into a non-compactable G     !   area of the heap, and puts a VMS string descriptor for the copy @     !   into the Callout_buffer, cb, starting at the first byte.     !      is	     begin L         var cb: Callout_buffer := create(Callout_buffer, string_descr_size);           encode_descr(me, cb); :         cb.offset := 0;         ! reset the offset to zero         return cb;     end;    3 operation by_ref_empty_descr(Mytype, size: Integer)      returns(Callout_buffer)      ! K     !   Creates an empty String, size characters long, in a non-compactable G     !   area of the heap and puts a VMS string descriptor for the empty E     !   String into a newly created Callout_buffer at the first byte.      !      is	     begin L         var cb: Callout_buffer := create(Callout_buffer, string_descr_size);  -         encode_empty_descr(Mytype, cb, size); :         cb.offset := 0;         ! reset the offset to zero         return cb;     end;    ( operation by_ref_empty_dyn_descr(Mytype)     returns(Callout_buffer)      ! A     !   Puts a VMS dynamic string descriptor for the empty String >     !   into a newly created Callout_buffer at the first byte.     !      is  	     begin L         var cb: Callout_buffer := create(Callout_buffer, string_descr_size);  +         encode_empty_dyn_descr(Mytype, cb); :         cb.offset := 0;         ! reset the offset to zero         return cb;     end;    N ! ----- C string encode and decode operations --------------------------------    1 operation encode_C_string(me, cb: Callout_buffer)      signals(Bounds, Overflow)      ! J     !   Puts the string value for the String me, adding a "\0" at the end,$     !   into the Callout_buffer, cb.     ! ;     is builtin ("String_Encode_C_String", "trellis$image");     5 operation decode_C_string(Mytype, cb: Callout_buffer)      returns(Mytype)      signals(Bounds, Overflow)      ! H     !   Creates an Trellis String (minus the terminating "\0") from the ;     !   C string value contained in the Callout_buffer, cb.      ! ;     is builtin ("String_Decode_C_String", "trellis$image");      operation by_ref_C_string(me)      returns(Callout_buffer)      ! B     !   Creates a Callout_buffer and puts the C equivalent for the=     !   Trellis String me into it starting at the first byte.      !      is	     begin D         var cb: Callout_buffer := create(Callout_buffer, me.size+1);            encode_C_string(me, cb);:         cb.offset := 0;         ! reset the offset to zero         return cb;     end;    N ! ----- String value encode and decode operations ----------------------------    . operation encode_value(me, cb: Callout_buffer)     signals(Bounds, Overflow)      ! L     !   Puts the string value for the String me into the Callout_buffer, cb.     ! 8     is builtin ("String_Encode_Value", "trellis$image");                 A operation encode_value_pad(me, cb: Callout_buffer, size: Integer)      signals(Bounds, Overflow)      ! K     !   Puts the string value for the String me, possibly padded on the end J     !   with NUL characters (ascii 0) upto size total characters, into the     !   Callout_buffer, cb.      ! <     is builtin ("String_Encode_Value_Pad", "trellis$image");    C operation decode_value(Mytype, cb: Callout_buffer, length: Integer)      returns(Mytype)      signals(Bounds, Overflow)      ! J     !   Creates an Trellis String, length characters long, from the string2     !   value contained in the Callout_buffer, cb.     ! 8     is builtin ("String_Decode_Value", "trellis$image");     operation by_ref_value(me)     returns(Callout_buffer)      ! J     !   Creates a Callout_buffer and puts the string value for the Trellis5     !   String me into it starting at the first byte.      !      is	     begin B         var cb: Callout_buffer := create(Callout_buffer, me.size);           encode_value(me, cb); :         cb.offset := 0;         ! reset the offset to zero         return cb;     end;    - operation by_ref_value_pad(me, size: Integer)      returns(Callout_buffer)      ! I     !   Creates a Callout_buffer and puts the string value for the String D     !   me, possibly padded on the end with NUL characters (ascii 0)H     !   upto size characters, into the Callout_buffer at the first byte.     !      is	     begin M         var cb: Callout_buffer := create(Callout_buffer, max(me.size, size));  
              '         encode_value_pad(me, cb, size); :         cb.offset := 0;         ! reset the offset to zero         return cb;     end;   end type_module;     type_module Callout_facility ! 5 !   Copyright (c) Digital Equipment Corporation, 1990 5 !   All Rights Reserved.  Unpublished rights reserved 2 !   under the copyright laws of the United States. !   7 !   The software contained on this media is proprietary 3 !   to and embodies the confidential technology of  4 !   Digital Equipment Corporation.  Possession, use,4 !   duplication or dissemination of the software and8 !   media is authorized only pursuant to a valid written/ !   license from Digital Equipment Corporation.  ! 4 !   RESTRICTED RIGHTS LEGEND   Use, duplication, or 3 !   disclosure by the U.S. Government is subject to 8 !   restrictions as set forth in Subparagraph (c)(1)(ii)2 !   of DFARS 252.227-7013, or in FAR 52.227-19, as !   applicable.  ! J !   All callout operations signal Not_Found with a message string if thereG !   are problems with finding the entry point or loading the image, and L !   External_Exception with a message string if the external routine signalsJ !   any exceptions.  All callout operations signal Overflow if any of the J !   integers in the argument Fix_seq are larger than (2^31)-1 or less thanN !   -2^31 (not a 32 bit signed integer value).  The callout_status operation, E !   only available on VMS, checks the return status code and signals d: !   VMS_Exception if the code is not ok (low bit not set).  7 operation callout(Mytype, image: String, entry: String, J                                     args: Fix_seq[Integer|Callout_buffer])     returns(Callout_buffer)iD     signals(Not_Found(String), External_Exception(String), Overflow)+     is builtin("Callout", "trellis$image");     > operation callout_status(Mytype, image: String, entry: String,J                                     args: Fix_seq[Integer|Callout_buffer])     returns(Integer);     signals(Not_Found(String), External_Exception(String), i,             Overflow, VMS_Exception(String))2     is builtin("Callout_Status", "trellis$image");    ? operation callout_integer(Mytype, image: String, entry: String,tJ                                     args: Fix_seq[Integer|Callout_buffer])     returns(Integer)D     signals(Not_Found(String), External_Exception(String), Overflow)3     is builtin("Callout_Integer", "trellis$image");)    = operation callout_float(Mytype, image: String, entry: String,sJ                                     args: Fix_seq[Integer|Call                                                                                                                                                                                                   
                        1i $      TRELLIS010.D                   8  b:  )[SYSMGR.SEAS$WORK_0000077F]CALLOUT.TRE;10                                                                                      O     $                         
      $       out_buffer])     returns(Real)nD     signals(Not_Found(String), External_Exception(String), Overflow)1     is builtin("Callout_Float", "trellis$image");     > operation callout_double(Mytype, image: String, entry: String,J                                     args: Fix_seq[Integer|Callout_buffer])     returns(Real)e;     signals(Not_Found(String), External_Exception(String), h)             Overflow, Bad_format(string))s2     is builtin("Callout_Double", "trellis$image");   end type_module;                              0 * [SYSMGR.SEAS$WORK_0000077F]CALLOUT_EXAMPLE.TRE;6 +  , 8   .     /     4 O       B                   - b:    0   1    2   3      K  P   W   O 
    5   6  %  7 f  8          9          G    H  J                ! 5 !   Copyright (c) Digital Equipment Corporation, 1990 5 !   All Rights Reserved.  Unpublished rights reserved 2 !   under the copyright laws of the United States. !   7 !   The software contained on this media is proprietary 3 !   to and embodies the confidential technology of  4 !   Digital Equipment Corporation.  Possession, use,4 !   duplication or dissemination of the software and8 !   media is authorized only pursuant to a valid written/ !   license from Digital Equipment Corporation.  ! 4 !   RESTRICTED RIGHTS LEGEND   Use, duplication, or 3 !   disclosure by the U.S. Government is subject to 8 !   restrictions as set forth in Subparagraph (c)(1)(ii)2 !   of DFARS 252.227-7013, or in FAR 52.227-19, as !   applicable.  !      " ! examples of the callout facility, ! uses callout.tre and the library workspace ! 3 !   Note: currently this is a VMS specific example.  !    trellis_enter  type_module Real ! I !   This adds several operations to Real and implements them by using the ' !   VMS Math Run-time Library (MTHRTL).  !      operation sqrt(me)     returns(Mytype)      signals(Overflow, Negative)      ! D     !   Calculates the square root of a real number as a Vax g real.     !      is	     begin 1         if me < 0.0 then signal Negative; end if; "         real.native_double := "g";G         return callout_double(Callout_facility, "MTHRTL", "MTH$GSQRT",                                 { L                                 by_ref_double(me)    ! g real, read only ref!                                            }); 
     except         on Not_Found do 
             ! A             !   probably would not handle this exception because  H             !   calling a math library service which should be available
             ! @             signal Failure with "MTH$GSQRT not found in MTHRTL";5         on External_Exception with message: String do 
             ! >             !   Since MTH$GSQRT signals its errors (overflow),H             !   interpret the String message and signal the appropriate              !   exception.
             ! '             case substr(message, 1, 16) 9                 on "%MTH-F-FLOOVEMAT" do signal Overflow; H                 otherwise do signal Failure with "External_Exception: " N                                                                     & message;             end case;      end;     operation e_to_the (me)      returns(Mytype)      ! '     !   Calculates e to the power of me      !      is	     begin "         real.native_double := "g";F         return callout_double(Callout_facility, "MTHRTL", "MTH$GEXP",                                { 1                                 by_ref_double(me) !                               }); 
     except         on Not_Found do 
             ! A             !   probably would not handle this exception because  H             !   calling a math library service which should be available
             ! ?             signal Failure with "MTH$GEXP not found in MTHRTL"; 5         on External_Exception with message: String do              
             ! O             !   Since MTH$EXP signals its errors (underflow and overflow), the  K             !   user may want to interpret the String message (see the gexp J             !   operation) or he may want to check the input value before 9             !   calling MTH$EXP (see the dexp operation). 
             ! A             signal Failure with "External_Exception: " & message;      end;     operation ln(me)     returns(Mytype)      ! (     !   Calculates the natural log of me     !      is	     begin "         real.native_double := "g";F         return callout_double(Callout_facility, "MTHRTL", "MTH$GLOG",                                { 1                                 by_ref_double(me) !                               }); 
     except         on Not_Found do 
             ! A             !   probably would not handle this exception because  H             !   calling a math library service which should be available
             ! ?             signal Failure with "MTH$GLOG not found in MTHRTL"; 5         on External_Exception with message: String do 
             ! O             !   Since MTH$EXP signals its errors (underflow and overflow), the  K             !   user may want to interpret the String message (see the gexp J             !   operation) or he may want to check the input value before 9             !   calling MTH$EXP (see the dexp operation). 
             ! A             signal Failure with "External_Exception: " & message;      end;      operation real_exp (me, p: Real)     returns(Mytype)      ! >     !   Calculates the power of a real number as a Vax g real.     !       is (e_to_the (p * ln (me)));     end type_module;     type_module Foo  ! I !   This type is just for a test program that calls the above operations.  ! # !   The program's output should be:  !  !   Starting Callout Tests !   power (3.0, 3) = 27.0  !   real_exp (3.0, 3.0) = 27.0 !   sqrt (4.0) = 2.0 !   Ending Callout Tests ! L !   (Also, you might get several informationals from compiling callout.tre.) !    operation test(mytype)    is 	     begin 4         print_all ({"Starting Callout Tests", eol});)         print_all ({"power (3.0, 3) = ",  >                           string_form (power (3.0, 3)), eol});.         print_all ({"real_exp (3.0, 3.0) = ", C                           string_form (real_exp (3.0, 3.0)), eol}); %         print_all ({"sqrt (4.0) = ",  :                           string_form (sqrt (4.0)), eol});2         print_all ({"Ending Callout Tests", eol});"         shutdown (Trellis_system);       end;   end type_module;       trellis_enter  type_module command_line ! H !   To make this a standalone program, change the default so "test(foo)"- !   will be the program that the system runs.  !    trellis_modify3 define run_program_default: String := "test (Foo)";    end type_module;                                                                                                                                                                                                           4 * [SYSMGR.SEAS$WORK_0000077F]CALLOUT_EXAMPLE_README.;4 +  , 8   .     /     4 N       *                   - b:    0   1    2   3      K  P   W   O     5   6 $  7 ҽf  8          9          G    H  J                             N The following files (located in trellis$sourcedev:[callout] are needed to run  the callout example.     callout.tre K     Trellis types that implement the callout facility, callout buffers, and L     encode and decode operations on primative types (Integer, Boolean, Real,I     String, and Bytevector).  See the Callout chapter of the DEC Trellis  G     Type Library Reference Manual for a description of how to use this  H     mechanism.  If your application will be using the callout facility, #     make sure to include this file.      callout_example.tre F     The source for the example.  It also includes the expected output.    M Just compile and run both of these files on either the library or the trellis N workspace.  The output you get should match the expected output in the example file.                                                                                                                                                                                                                                     / * [SYSMGR.SEAS$WORK_0000077F]LINK_INTERFACE.COM;2 +  , 8   .     /     4 c                          - b:    0   1    2   3      K  P   W   O     5   6 b5  7 f  8          9          G    H  J                 P                                                                                                                                                                                                                                                                                                                                                                                          N,d $      TRELLIS010.D                   8  b:  /[SYSMGR.SEAS$WORK_0000077F]LINK_INTERFACE.COM;2                                                                                c                             U
              $ deassign sql_interfacec $ link/shareable sql_interface.obj, sql_interface/opt, sys$library:sql$user/lib /include=SQL$GETERR                                                                                                                                                                                                                                                                                                                                                                                                               , * [SYSMGR.SEAS$WORK_0000077F]SAMPLE_TOOL.TRE;2 +  , 8   . $    /     4 N   $   #                    - b:    0   1    2   3      K  P   W   O $    5   6 N1  7 <f  8          9          G    H  J                   type_module Sample_tool
    subtype_of (Tool)		!   All tools are subtypes of Tool.
!
!   Sample_tool is a simple tool to demonstrate the standard style of
!   writing a tool.
!   A Sample_tool displays two frames. One is a Text_frame, me.input_frame.
!   Me.input_frame serves no special purpose; it is simply a convenient
!   place to type in text.
!   Below the text frame is a List_frame, me.list_frame.
!   The commands Add and Remove (or Add Item and Remove Item)
!   operate on the list frame. Add takes the current selection,
!   and interprets it as a list of items to be added to the beginning of the
!   list frame. Remove removes selected items from the list frame.
!   Add and Remove are available as buttons, in the Actions pull-down menu,
!   and in a pop-up menu, available on the list frame.
!

component me.action_menu_entries: Sequence[Menu_description]
    !   This is the list of actions in the Action pull-down menu.
    !   Add Items adds items to the list frame.
    !   Remove Items removes selected items.
    !   This list of actions is also used to create the pop-up menu.
    get_only
    get subtype_visible
    get is
        begin
	    !   Create Menu_descriptions for each action.
	    !   A menu description stores all the relevant information
	    !   needed to create a menu action or a button.
            return({action(Menu_description,
			   "add",	! Name for action frame.
                           me,		! The tool associated with this action.
			   "Add Items",	! The string to display.
			   "             do_add",	! Call do_add(me) when action occurs.
			   {},		! No other arguments.
			   is_me	! do_add is a me, not a mytype op.
			  ),
                    action(Menu_description, "remove",
                        me, "Remove Items", "do_remove", {}, is_me)
                   });
        end

component me.button_bar_entries: Sequence[Menu_description]
    !   This is the list of buttons in the button bar of the tool.
    !   The actions are the same as me.action_menu_entries, but the
    !   labels for the actions are different.
    get_only
    get subtype_visible
    get is
        begin
            return({action(Menu_description, "add",
                        me, "Add", "do_add", {}, is_me),
                    action(Menu_description, "remove",
                        me, "Remove", "do_remove", {}, is_me)
                   });
        end

component me.default_icon_title: String
    !   The string to display in the icon when this tool is iconified.
    get_only
    get is ("Sample")

component me.default_size: Point
    !   The desired height and width of tool, in pixels.
    !   The tool will be at least this big. It may have to be bigger
    !   to make all the frames fit.
    get_only
    get is (200@200)

component me.default_title: String
    !   The string to display in title bar of tool.
    get_only
    get is ("Sample Tool")

component me.edit_menu_entries: Sequence[Menu_description]
    !   These are the actions in the Edit pull-down menu.
    !   Copy copies the current selection to the clipboard.
    !   Select All selects all the items in me.list_frame.
    get_only
    get subtype_visible
    get is
        begin
	    ! Copy_selection_to_clipboard is implemented in type Tool.
            return({action(Menu_description, "copy",
                            me, "Copy", "copy_selection_to_clipboard", {},
			    is_me),
                    action(Menu_description, "select",
                            me, "Select All", "do_select_all", {}, is_me)});
        end

component me.file_menu_entries: Sequence[Menu_description]
    !   These are the actions in the File pull-down menu.
    !   New creates a new instance of a Sample_tool.
    !   Close closes this instance of the tool.
    get_only
    get subtype_visible
    get is
        begin
            return(
                {action(Menu_description, "new",
                            me, "New", "create", {}, is_mytype),
                 separator(Menu_description, "separator1"),
                 action(Menu_description, "close",
                            me, "Close", "terminate", {}, is_me)});
        end

component me.input_frame: Text_frame
    !   The text frame displayed in the tool.
    subtype_visible
    is field

component me.last_item_number: Integer
    !   Items in the list frame consist of a string and an associated integer.
    !   The integer is a unique id which is used to identify the item.
    !   me.last_item_number is incremented by next_item_number(me)
    !	every time we add an item to the list frame.
    subtype_visible
    is field

component me.list_frame: List_frame[Integer]
    !   The list frame displayed in the tool.
    subtype_visible
    is field

component Mytype.base_name: String
    ! The base name for the tool.  The actual name of the tool is set
    ! when the tool is registered with the Tool_manager.
    get_only
    get is ("SampleTool")

operation create(Mytype)
    returns (Mytype)
    public
    is allocate
    begin
	!   Start the unique id counter.
	me.last_item_number := 0;

	!   W is the top level frame which contains all the other frames.
        var w: Attachable_work_area_frame;

        var buttons: Button_bar_frame;	! The button bar frame.

	!   Register_name gets a name for this tool from the Tool_manager.
	!   The name is used to look up resource values.
	!   Register name sets me.resource_name.
        register_name(me);

	!   Create the tool window for this tool.
        me.window :=
	    create(tool_window,
                   me.resource_name,	! Set by register_name().
                   me.default_title,    ! Display this in the window titlebar.
	           me.default_icon_title,
					! Display this in the icon.
                   me			! The tool associated with this window.
		  );

	!   Create the top-level work area frame for this tool.
        w :=
	    create(Attachable_work_area_frame,
		   "main",		! Name of this frame.
		   me.window		! Parent of this frame.
		  );

	!   Make w be the work area frame for this tool's window.
        me.window.workarea_frame := w;

	!   Change some characteristics of w.
        w.border_width := 0;		! No visible border.
        w.size := me.default_size;	! Set size.
	!   Now make these changes take effect.
        apply_changes(w);

	!   Create a menu bar for this tool.
	!   See operation create_menu_bar, which does all the work.
        me.window.menu_bar_frame := create_menu_bar(me);

	!   Create the text frame for this tool.
        me.input_frame :=
	    create_rows_columns(Text_frame,
				"info", ! Name of frame.
                                w,	! Parent of frame.
				5,	! 5 lines high.
				20,	! 20 characters wide. The text frame
					! as a different width when
					! it is put into the work area frame,
					! because of the attachments made
					! below.
				"",	! Initial contents (empty).
				false   ! No vertical scrollbar.
				);

	!    Change some characteristics of the text frame.
        me.input_frame.border_width := 1;
					! Put a border around frame.
        me.input_frame.wrap? := false;	! Do not do word-wrapping of text.
	!   Don't let the text frame change its width or height
	!   to accomodate the text.
	me.input_frame.allow_resize_width? := false;
	me.input_frame.allow_resize_height? := false;
	!   Attach the top, left, and right of the text frame to the work area
	!   frame. This means its width will change if the work area frame
	!   changes width. But its height will remain constant.
        attach_to_me(w, Frame_Left, me.input_frame, Frame_Left);
        attach_to_me(w, Frame_Right, me.input_frame, Frame_Right);
        attach_to_me(w, Fram                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          PG. $      TRELLIS010.D                   8  b:  ,[SYSMGR.SEAS$WORK_0000077F]SAMPLE_TOOL.TRE;2                                                                                   N     $                         i             e_Top, me.input_frame, Frame_Top);
        attach_to_nothing(w, me.input_frame, Frame_Bottom);
        apply_changes(me.input_frame);

	!    Create the list frame.
        me.list_frame :=
	    create(List_frame[Integer],	! This list frame associates strings
					!  with Integers.
                   "sampleList",	! Name of frame.
		   w,			! Parent of frame.
		   {}			! The frame starts out empty.
		   );

	!    Change some characteristics of the list frame.
        me.list_frame.border_width := 1;
					! It has a border.
	!    Attach the top of the list frame to the bottom of the text frame.
        attach_to_sibling(w, me.list_frame, Frame_Top,
                             me.input_frame, Frame_Bottom);
	!    Attach the list frame to the left and right edges of the
	!    work area frame.
        attach_to_me(w, Frame_Left, me.list_frame, Frame_Left);
        attach_to_me(w, Frame_Right, me.list_frame, Frame_Right);
        apply_changes(me.list_frame);

	!    Create the button bar.
        if me.show_button_bar?		! See type Tool. Default is true.
	then
            buttons :=
		create_with_entries(Button_bar_frame,
			"buttonBar",	! Name of frame.
                         w, 		! Parent of frame.
			me.button_bar_entries,
					! Descriptions of buttons.
			me		! This is the tool the buttons are in.
			);

	    !   Change some characteristics of the button bar.
	    !   Attach the button bar to the bottom and sides
	    !   of the work area frame.
            attach_to_me(w, Frame_Bottom, buttons, Frame_Bottom);
            attach_to_nothing(w, buttons, Frame_Top);
            attach_to_me(w, Frame_Left, buttons, Frame_Left);
	    !   Attach the bottom of the list frame to the top of the button
	    !   bar.
	    !   The result of all these attachments is that the text frame
	    !   and the button bar will not grow in height, but the list
	    !   frame will grow if the window grows in height. The width of
	    !   all the frames will be the same as the width of the window.
            attach_to_sibling(w, me.list_frame, Frame_Bottom,
                                buttons, Frame_Top);
            apply_changes(buttons);
        else
	    !   If there is no button bar, just attach the bottom of the
	    !	list frame to the bottom ofthe work area frame.
            attach_to_me(w, Frame_Bottom, me.list_frame, Frame_Bottom);
        end if;
        apply_changes(me.list_frame);

	!   Make changes to w take effect, too. (The changes are mostly
	!   attachments.)
        apply_changes(w);

	!   Try to make the tool window and its frames fit in me.default_size.
	!   Because some frames have minimum sizes, it is possible that
	!   all the frames will not fit in me.default_size. In that case,
	!   make the window larger than me.default_size, but still as small
	!   as possible.
        make_default_size(me.window);
        apply_changes(me.window);

	!   Start up the tool activity for this tool.
        start_up(me);

	!   Display this tool. This operation actually sends a request to the
	!   tool activity to display the tool. (See Tool\display, which
	!   sends the request, and Tool\do_display, which actually does
	!   the display.
	!   After displaying the tool, also do anything that must be done
	!   only after the tool is displayed. (See Tool\do_after_display,
	!   which is called by Tool\do_display).
	!   For this tool, create_popup_menus will be called.
        display(me);
    end

operation create_menu_bar(me)
    !   Create the menu bar for this tool. The pulldown menus are labeled
    !   File, Edit, and Actions.
    returns (Menu_bar_frame)
    is
    begin
        var mb: Menu_bar_frame;
        var file_menu: Menu_bar_menu_frame;
        var edit_menu: Menu_bar_menu_frame;
        var action_menu: Menu_bar_menu_frame;

	!   Create the menubar itself.
        mb := create(Menu_bar_frame,
		     "menubar",		! Name of frame.
		     me.window		! Parent of frame.
		    );

	!   For each menu, create a menu bar menu frame, add the
	!   items in the menu to the menu frame, and then add the menu frame
	!   to the menu bar.

	!   Create the pulldown menu.
        file_menu := create(Menu_bar_menu_frame, "fileMenu", mb.menu_frame);

	!   Add all the items that will be in the menu.
        add_menu_items(me, file_menu, me.file_menu_entries);

	!   Add the menu to the menu bar.
        add_submenu(mb, "File", file_menu);

        apply_changes(file_menu);

	!  Similarly, create the other two menus.

        edit_menu := create(Menu_bar_menu_frame, "editMenu", mb.menu_frame);
        add_menu_items(me, edit_menu, me.edit_menu_en             tries);
        add_submenu(mb, "Edit", edit_menu);
        apply_changes(edit_menu);

        action_menu :=
	    create(Menu_bar_menu_frame, "actionMenu", mb.menu_frame);
        add_menu_items(me, action_menu, me.action_menu_entries);
	add_submenu(mb, "Actions", action_menu);
        apply_changes(action_menu);

        apply_changes(mb);
        return mb;
    end


operation create_popup_menus(me)
    !   Create the popup menus. Pop-up menus must be created after the tool
    !   window is displayed. This operation is called (indirectly) by the
    !   display(me) in the create operation.
    subtype_visible
    is
    begin
        var popup: Popup_menu_frame :=
	    create(Popup_menu_frame, "popupmenu", me.window.workarea_frame);
	!   Use the same menu items that are in the Action pulldown menu.
        add_menu_items(me, popup, me.action_menu_entries);
	apply_changes(popup);
    end

operation do_add (me)
    !   Add one or more items to the list frame.
    !   The items come from the current selection.
    !   Each line in the current selection is treated as a separate item.
    !
    !   This operation is called when the Add Items button is pushed,
    !   or the Add menu action is chosen.
    subtype_visible
    is
    begin
	!   Lines is the current selection, separated into separate lines
	!   of text.
	var lines: Sequence[String];

	!   First try to get the current selection as a single string.
	!   If this works, decompose the string into separate lines.
	!   We must try asking for a single String first, because a Text_frame
	!   or a selection in a non-Trellis window will not return
	!   a Sequence[String] that is properly broken into newlines.
	!   Instead they will just return a Sequence containing a single,
	!   multi-line string. So we just try asking for a big string,
	!   and we break it up into lines outselves.
	begin
	    var s: String :=
		force(String,
		      return_selection_as(tool_environment.tool_manager,
					  String));
	    !   Separate the string into lines.
	    lines := string_to_lines(Mytype, s);
        except
	    !   The current selection could not be returned as a single string.
	    !	So ask for it as a Sequence[String]. This will work if, for
	    !   instance, the selection is several items in a List_frame.
            on Cant_return_that_type do
		lines := force(Sequence[String],
		   	  return_selection_as(tool_environment.tool_manager,
				              Sequence[String]));
	end;

	!   Create a sequence of associations. Each association in the sequence
	!   is a pair consiting of one text line from the selection
	!   and an Integer unique id.
	var associations: Dyn_seq[Association[Integer]] :=
	    create(Dyn_seq[Association[Integer]]);
	for str: String in elements(lines) do
	    add_last(associations, create(Association[Integer],
				          str, 
				          next_item_number(me)
							! The unique id.
		     			 ));
	end for;

	!   Add the associations to the beginning of the list frame.
	add_all_associations_first(me.list_frame, associations);

	!   Scroll the list frame so the beginning is visible.
	changed_make_first_visible(me.list_frame);

	!   Make all these changes take effect.
	apply_changes(me.list_frame);
    except
	on Cant_return_that_type, No_selection do
	    !   There was nothing selected, or the selection could not
	    !   be interpreted as a String or Sequence[String].
	    !   Bring up a notifier with an error message.
	    !   See Tool\show_user_error for details of its arguments.
	    show_user_error(me, "",
				"Please select one or more strings to add.",
				{} );
    end

operation do_remove (me)
    !   Remove one or more items from the list frame.
    !   The items removed will be whatever is selected in the list frame.
    !
    !   This operation is called when the "Remove Items" button is pushed,
    !   or the "Remove" menu action is chosen.
    is
    begin
	!   Find out what is selected in the list frame, if anything.
	!   Selected_items will contain the unique id's of what is selected.
	var selected_items: Sequence[Integer] := me.list_                                                                                                                                                                                                                                   
                        C $      TRELLIS010.D                   8  b:  ,[SYSMGR.SEAS$WORK_0000077F]SAMPLE_TOOL.TRE;2                                                                                   N     $                         -      !       frame.selected_items;

	!   Delete each selected item.
	for item: Integer in elements(selected_items) do
	    delete_association_with_item(me.list_frame, item);
	end for;
	apply_changes(me.list_frame);
    except
	!   Nothing was selected in the list frame, so complain.
	on No_selection do
	    show_user_error(me, "",
		"Please select one or more items in the list to remove",
		{});
    end

operation do_select_all(me)
    !   Select all items in the list frame.
    !   This operation is called when Select All is chosen from the
    !   Edit menu.
    is
    begin
        select_all_items(me.list_frame);
    end

operation  next_item_number(me)
    !   Return a new unique id for a new item.
    returns (Integer)
    subtype_visible
    is
    begin
	me.last_item_number := me.last_item_number + 1;
	return me.last_item_number;
    end

operation  string_to_lines(Mytype, s: String)
    !  Break up a possibly multi-line string into separate lines.
    returns (Sequence[String])
    subtype_visible
    is
    begin
	var lines: Dyn_seq[String] := create(Dyn_seq[String]);
	var eol_index: Integer;
	loop
	    exit when s.empty?;
	    begin
		eol_index := find(s, eol);
	    except
		on Not_found do
		    add_last(lines, s);
		    exit;
	    end;
            add_last(lines, substr(s, 1, eol_index - 1));
	    s := substr(s, eol_index+1, s.high);
        end loop;
        return lines;
    end

end type_module;

                                                                                                                               . * [SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.OPT;1 +  , 8   .     /     4 /                          - b:    0   1    2   3      K  P   W   O     5 #  6  [T&  7 @f  8          9          G    H  J                 %     psect_attr=RDB$DBHANDLE,noshr,lcl /     psect_attr=RDB$TRANSACTION_HANDLE,noshr,lcl +     psect_attr=RDB$MESSAGE_VECTOR,noshr,lcl      universal = PREPARE_STMT     universal = PREPARE_OUTPUT     universal = DESCRIBE_INPUT     universal = DESCRIBE_OUTPUT      universal = EXECUTE_STMT!     universal = EXECUTE_IMMEDIATE      universal = OPEN_CURSOR      universal = FETCH_ROW      universal = CLOSE_CURSOR     universal = RELEASE_STMT"     universal = COMMIT_TRANSACTION$     universal = ROLLBACK_TRANSACTION     universal = PREPARE_STMT2      universal = DESCRIBE_INPUT2      universal = EXECUTE_STMT2      universal = RELEASE_STMT2      universal = SQL$SIGNAL                                                                                                                                                                                                                                                                                                                                                                      1 * [SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.SQLMOD;2 +  , 8   .     /     4 P                         - b:    0   1    2   3      K  P   W   O     5 "  6  |Q  7 f  8          9          G    H  J               --H -- This SQL module provides the SQL procedures needed by the Trellis SQL -- interface.   O -------------------------------------------------------------------------------  -- Header Information Section O ------------------------------------------------------------------------------- . MODULE          SQL_INTERFACE   -- Module nameP LANGUAGE        GENERAL         -- Language of calling program(use by reference)D AUTHORIZATION   RDB$DBHANDLE    -- Provides default authorization id  O -------------------------------------------------------------------------------  -- DECLARE Statements Section O -------------------------------------------------------------------------------   8 -- Declare a cursor to process dynamic SELECT statements   DECLARE SEL CURSOR FOR DYN_STMT   O -------------------------------------------------------------------------------  -- Procedure SectionO -------------------------------------------------------------------------------    -- PREPARE_STMT L -- This procedure prepares a statement for dynamic execution from the string -- passed to it.     PROCEDURE PREPARE_STMT     SQLCODE 	     SQLDA      STMT	CHAR(1024);       PREPARE DYN_STMT FROM STMT;    -- PREPARE_OUTPUT L -- This procedure prepares a statement for dynamic execution from the stringN -- passed to it.  It also writes information about the number and data type ofE -- any select list items in the statement to an SQLDA (specifically,  H -- the sqlda_out SQLDA passed to the procedure by the calling program).  --  I -- Note that the PREPARE statement in this procedure could have prepared  C -- the statement without writing to an SQLDA.  Instead, a separate  C -- DESCRIBE...SELECT LIST statement would have written information  + -- about any select list items to an SQLDA.    PROCEDURE PREPARE_OUTPUT     SQLCODE 	     SQLDA      STMT	CHAR(1024);  6     PREPARE DYN_STMT SELECT LIST INTO SQLDA FROM STMT;     -- DESCRIBE_INPUT @ -- This procedure writes information to an SQLDA (specifically, F -- the sqlda_in SQLDA passed to the procedure by the calling program) B -- about the number and data type of any parameter markers in the E -- prepared dynamic statement.  Note that SELECT statements may also   -- have parameter markers.   PROCEDURE DESCRIBE_INPUT     SQLCODE 
     SQLDA;  )     DESCRIBE DYN_STMT MARKERS INTO SQLDA;    -- DESCRIBE_OUTPUT@ -- This procedure writes information to an SQLDA (specifically, F -- the sqlda_in SQLDA passed to the procedure by the calling program) B -- about the number and data type of any output parameters in the   -- prepared dynamic statement.     PROCEDURE DESCRIBE_OUTPUT      SQLCODE 
     SQLDA;  -     DESCRIBE DYN_STMT SELECT LIST INTO SQLDA;      -- EXECUTE_STMT > -- This procedure dynamically executes a non-SELECT statement.B -- SELECT statements are processed by DECLARE CURSOR, OPEN CURSOR, -- and FETCH statements. --; -- The EXECUTE statement specifies an SQLDA (specifically,  F -- the sqlda_in SQLDA passed to the procedure by the calling program) F -- as the source of addresses for any parameter markers in the dynamic
 -- statement.  --C -- Note that the EXECUTE statement with the USING DESCRIPTOR clause D -- also handles statement strings that contain no parameter markers.@ -- If a statement string contains no parameter markers, SQL sets' -- the SQLD field of the SQLDA to zero.      PROCEDURE EXECUTE_STMT     SQLCODE 
     SQLDA;  ,     EXECUTE DYN_STMT USING DESCRIPTOR SQLDA;     -- EXECUTE_IMMEDIATE> -- This procedure dynamically executes a non-SELECT statement.B -- SELECT statements are processed by DECLARE CURSOR, OPEN CURSOR, -- and FETCH statements. --F -- The EXECUTE_IMMEDIATE statement specifies a parameter that contains -- the string to be executed.  --     PROCEDURE EXECUTE_IMMEDIATE      SQLCODE      STMT	CHAR(1024);       EXECUTE IMMEDIATE STMT;      -- OPEN_CURSORF -- This procedure opens the cursor SEL already declared.  It specifiesF -- an SQLDA (specifically, the sqlda_in SQLDA passed to the procedure H -- by the calling program) as the source of addresses for any parameter , -- markers in the cursor's SELECT statement.   PROCEDURE OPEN_CURSOR      SQLCODE 
     SQLDA;  $     OPEN SEL USING DESCRIPTOR SQLDA;     -- FETCH_ROWG -- This procedure fetches a row from the opened cursor and writes it to I -- the addresses specified in an SQLDA (specifically, the sqlda_out SQLDA 3 -- passed to the procedure by the calling program).    PROCEDURE FETCH_ROW      SQLCODE 
     SQLDA;  %     FETCH SEL USING DESCRIPTOR SQLDA;      -- CLOSE_CURSOR $ -- This procedure closes the cursor.   PROCEDURE CLOSE_CURSOR     SQLCODE;       CLOSE SEL;     -- RELEASE_STMT J -- The procedure releases the prepared statement.  It frees all resources  -- for the statement.      PROCEDURE RELEASE_STMT     SQLCODE;       RELEASE DYN_STMT;     * -- This procedure commits the transaction.   PROCEDURE COMMIT_TRANSACTION     SQLCODE;       COMMIT;     - -- This procedure rolls back the transaction.    PROCEDURE ROLLBACK_TRANSACTION     SQLCODE;  
     ROLLBACK;    --  K -- these routines are used only for the implementation of the update where   -- cursor of statement   PROCEDURE PREPARE_STMT2      SQLCODE 	     SQLDA      STMT	CHAR(1024);        PREPARE DYN_STMT2 FROM STMT;   PROCEDURE EXECUTE_STMT2      SQLCODE 
     SQLDA;  -     EXECUTE DYN_STMT2 USING DESCRIPTOR SQLDA;    PROCEDURE DESCRIBE_INPUT2      SQLCODE 
     SQLDA;  *     DESCRIBE DYN_STMT2 MARKERS INTO SQLDA;   PROCEDURE RELEASE_STMT2      SQLCODE;       RELEASE DYN_STMT2;                                                                                                                                                                                                                                   : $      TRELLIS010.D                   8  b:  .[SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.TRE;3                                                                                 S     f                         W              . * [SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.TRE;3 +  , 8   . f    /     4 S   f   f |                    - b:    0   1    2   3      K  P   W   O g    5   6 ]j  7 f  8          9          G    H  J                   type_module dynamic_sql  ! the dynamic sql interface:/ ! each operation performs a dynamic sql command K ! There is one statement that is implicitly being worked on at any one time N ! i.e you can not mix statements except for the statements with a 2 on the endN ! (such as prepare2) they are used to handle the "update where current of sel"C ! command -- it has to be used within a select and so we have to be * ! working on two commands at the same timeJ ! As with the SQL interface, you cannot save these objects across sessionsE ! without reinitializing them when the new Trellis session starts up.   * define default_stmt_size: Integer := 1024;  & component me.sql_stmt: Callout_buffer @     ! will contain the text of the SQL statement being processed     private 
     is field;    operation create (Mytype)      returns (Mytype)     is allocate 	     begin B         me.sql_stmt := create (Callout_buffer, default_stmt_size);     end;   operation initialize (me) J     ! have to call this operation if you save this object across a Trellis'     ! session and then want to reuse it      is	     begin B         me.sql_stmt := create (Callout_buffer, default_stmt_size);     end;  E operation prepare (me, sqlda: SQL_descriptor_area, statement: String) F     ! to be used when a separate describe...output or describe...input     ! statement is issued -     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is beginC         return real_prepare (me, sqlda, statement, "PREPARE_STMT");      except  %         on SQL_Exception do resignal;      end;  F operation prepare2 (me, sqlda: SQL_descriptor_area, statement: String)F     ! to be used when a separate describe...output or describe...input     ! statement is issued -     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is beginD         return real_prepare (me, sqlda, statement, "PREPARE_STMT2");     except  %         on SQL_Exception do resignal;      end;  8 operation real_prepare (me, sqlda: SQL_descriptor_area, 2                                 statement: String,1                                 dyn_stmt: String) F     ! to be used when a separate describe...output or describe...input     ! statement is issued -     ! returns the SQLCODE value as an integer      private      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4);           me.sql_stmt.offset := 0;E         encode_value_pad (statement, me.sql_stmt, default_stmt_size); 
         begin I             callout_status (Callout_facility, "SQL_INTERFACE", dyn_stmt,  :                 {sqlcode, sqlda.real_sqlda, me.sql_stmt});0             return decode (Integer, sqlcode, 4);         except               on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;  L operation prepare_output (me, sqlda: SQL_descriptor_area, statement: String)0     ! does a prepare with an implied output into-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4);           me.sql_stmt.offset := 0;E         encode_value_pad (statement, me.sql_stmt, default_stmt_size); 
         begin P             callout_status (Callout_facility, "SQL_INTERFACE", "PREPARE_OUTPUT",:                 {sqlcode, sqlda.real_sqlda, me.sql_stmt});C             generate_sqlvar (sqlda);  ! set up the parameter fields 0             return decode (Integer, sqlcode, 4);         except               on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;  9 operation describe_input (me, sqlda: SQL_descriptor_area) 8     ! sets up the sqlda area for this prepared statement-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is beginA         return real_describe_input (me, sqlda, "DESCRIBE_INPUT");      except  %         on SQL_Exception do resignal;      end;  : operation describe_input2 (me, sqlda: SQL_descriptor_area)8     ! sets up the sqlda area for this prepared statement-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is beginB         return real_describe_input (me, sqlda, "DESCRIBE_INPUT2");     except  %         on SQL_Exception do resignal;      end;  > operation real_describe_input (me, sqlda: SQL_descriptor_area,8                                        dyn_stmt: String)8     ! sets up the sqlda area for this prepared statement-     ! returns the SQLCODE value as an integer      private      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4); 
         begin I             callout_status (Callout_facility, "SQL_INTERFACE", dyn_stmt,  -                 {sqlcode, sqlda.real_sqlda}); C             generate_sqlvar (sqlda);  ! set up the parameter fields 0             return decode (Integer, sqlcode, 4);         except               on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;  : operation describe_output (me, sqlda: SQL_descriptor_area)8     ! sets up the sqlda area for this prepared statement-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4); 
         begin Q             callout_status (Callout_facility, "SQL_INTERFACE", "DESCRIBE_OUTPUT", -                 {sqlcode, sqlda.real_sqlda}); C             generate_sqlvar (sqlda);  ! set up the parameter fields 0             return decode (Integer, sqlcode, 4);         except               on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;  2 operation execute (me, sqlda: SQL_descriptor_area)>     ! used to execute prepared statements (not selects though)-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin8         return real_execute (me, sqlda, "EXECUTE_STMT");     except  %         on SQL_Exception do resignal;      end;  3 operation execute2 (me, sqlda: SQL_descriptor_area) >     ! used to execute prepared statements (not selects though)-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin9         return real_execute (me, sqlda, "EXECUTE_STMT2");      except  %         on SQL_Exception do resignal;      end;  I operation real_execute (me, sqlda: SQL_descriptor_area, dyn_stmt: String) >     ! used to execute prepared statements (not selects though)-     ! returns the SQLCODE value as an integer      private      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4); 
         begin I             callout_status (Callout_facility, "SQL_INTERFACE", dyn_stmt,  -                 {sqlcode, sqlda.real_sqlda}); 0             return decode (Integer, sqlcode, 4);         except               on Not_found do F                 signal Failure with "cannot                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           "3 $      TRELLIS010.D                   8  b:  .[SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.TRE;3                                                                                 S     f                          "            find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;  3 operation execute_immediate (me, statement: String) B     ! used to immediately execute statements -- cannot be a select,     ! statement or contain parameter markers-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4);           me.sql_stmt.offset := 0;E         encode_value_pad (statement, me.sql_stmt, default_stmt_size); 
         begin S             callout_status (Callout_facility, "SQL_INTERFACE", "EXECUTE_IMMEDIATE", (                 {sqlcode, me.sql_stmt});0             return decode (Integer, sqlcode, 4);         except               on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;  6 operation open_cursor (me, sqlda: SQL_descriptor_area)>     ! used to open a cursor which has previously been declared-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4); 
         begin M             callout_status (Callout_facility, "SQL_INTERFACE", "OPEN_CURSOR", -                 {sqlcode, sqlda.real_sqlda}); 0             return decode (Integer, sqlcode, 4);         except               on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;  6 operation fetch_sqlda (me, sqlda: SQL_descriptor_area)D     ! retrieves values from a cursor declared for a prepared select F     ! the SQL descriptor area describes where the returned objects get     ! placed-     ! returns the SQLCODE value as an integer      returns (Integer) 0     signals (SQL_Exception (SQL_Error), SQL_eof)     is begin5         var sqlcode: Callout_buffer := by_ref (0, 4); 
         begin K             callout_status (Callout_facility, "SQL_INTERFACE", "FETCH_ROW", -                 {sqlcode, sqlda.real_sqlda}); 0             return decode (Integer, sqlcode, 4);         except               on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String doC                  var code: Integer := decode (Integer, sqlcode, 4); '                  if code = SQL_eof then $                      signal SQL_eof;                  else K                      signal SQL_Exception with create (SQL_Error, code, s);                   end if;
          end;      end;   operation close_cursor (me)      ! closes the current cursor -     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4); 
         begin N             callout_status (Callout_facility, "SQL_INTERFACE", "CLOSE_CURSOR",                 {sqlcode}); 0             return decode (Integer, sqlcode, 4);         except             on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;   operation release (me)8     ! releases the resources acquired for this statement-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin1         return real_release (me, "RELEASE_STMT"); 
     except%         on SQL_Exception do resignal;      end;   operation release2 (me) 8     ! releases the resources acquired for this statement-     ! returns the SQLCODE value as an integer      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin2         return real_release (me, "RELEASE_STMT2");
     except%         on SQL_Exception do resignal;      end;  - operation real_release (me, dyn_stmt: String) 8     ! releases the resources acquired for this statement-     ! returns the SQLCODE value as an integer      private      returns (Integer) '     signals (SQL_Exception (SQL_Error))      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4); 
         begin I             callout_status (Callout_facility, "SQL_INTERFACE", dyn_stmt,                   {sqlcode}); 0             return decode (Integer, sqlcode, 4);         except             on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;   end type_module;   type_module SQL_descriptor_area      component me.sqldaid: String&     ! 8 characters -- value is "SQLDA"     get_only     get is ("SQLDA");    component me.sqldaba: Integer      get_only8     ! length in bytes of the sqlda -- = 16 + (43 * sqln)1     ! -- I think it should be 44 but we shall see 3     get is (16 + (SQL_var_field_length * me.sqln));    component me.sqln: Integer     put allocate_visibleB     ! total number of variables (either input or output) in sqlvarC     ! set by the program -- used by sql to determine if the program 0     ! has allocated enough storage for the sqlda
     is field;    component me.sqld: Integer6     ! number of output parameters if describe...output4     ! number of input parameters if describe...input(     ! set by sql and used by the program     get is begin#         me.real_sqlda.offset := 14; 2         return decode (Integer, me.real_sqlda, 2);     end      put is begin#         me.real_sqlda.offset := 14; )         encode (value, me.real_sqlda, 2);          value;     end;  ' component me.real_sqlda: Callout_buffer $     ! this where the real data sits 5     ! not private since we do have to pass it around  
     is field;   + component me.sqlvar: dyn_seq[SQL_var_field] H     ! repeating group of fields which describe input or output variables
     is field;   1 operation create (Mytype, max_variables: Integer)      returns (Mytype)     is allocate 	     begin !         me.sqln := max_variables; =         me.real_sqlda := create (Callout_buffer, me.sqldaba); 5         encode_value_pad ("SQLDA", me.real_sqlda, 8); .         encode (me.sqldaba, me.real_sqlda, 4);+         encode (me.sqln, me.real_sqlda, 2); 5         me.sqlvar := create (dyn_seq[SQL_var_field]);      end;   operation generate_sqlvar (me)P     ! will search through me.real_sqlda and set up the dyn_seq of SQL_var_fieldsG     ! used either for both input and output parameters -- call after a        ! describe or prepare_output     is	     begin 6         ! first free up callout buffers if they exist;9         for fld: Sql_var_field in elements (me.sqlvar) do              begin #                 free (fld.sqldata);              except                  on not_there do;             end;         end for;5         me.sqlvar := create (dyn_seq[SQL_var_field]); "         var offset: Integer := 16;/         for i: Integer in range (1, me.sqld) do P             add_last (me.sqlvar, create (SQL_var_field, me.real_sqlda, offset));4             offset := offset + SQL_var_field_length;         end for;     end;   operation allocate_buffers (me) F     ! allocate_buffers allocates call_out buffers for each select listG     ! item in the sqlda (the select list items are the values that will F     ! be returned on fetch statements) -- we also allocate buffers for@     ! indicator parameters associated with the select list items     is	     beginp9         for fld: SQL_var_field in elements (me.sqlvar) doaC             fld.sqlind := by_ref (0, 2);   ! set the indicator as 0iK             case fld.sqltype      ! allocate buffers based on the data typee-                 on SQL_char, SQL_null_char dorG                     fld.sqldata := create (Callout_buffer, fld.sqllen);v3                 on SQL_varchar, SQL_null_varchar do I                     fld.sqldata := create (Callout                                                                                                                                                                                                                                                                           	 $      TRELLIS010.D                   8  b:  .[SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.TRE;3                                                                                 S     f                          "     "       _buffer, fld.sqllen+2); > !                on SQL_long_varchar, SQL_null_long_varchar doJ !                    fld.sqldata := create (Callout_buffer, fld.sqllen+2);3                 on SQL_integer, SQL_null_integer doe>                     fld.sqldata := create (Callout_buffer, 4);?                 on SQL_small_integer, SQL_null_small_integer do >                     fld.sqldata := create (Callout_buffer, 2);5                 on SQL_quadword, SQL_null_quadword do >                     fld.sqldata := create (Callout_buffer, 8);/                 on SQL_float, SQL_null_float doe*                     if fld.sqllen < 7 thenB                         fld.sqldata := create (Callout_buffer, 4);                     elseB                         fld.sqldata := create (Callout_buffer, 8);                     end if;cO !                on SQL_decimal, SQL_null_decimal do; ! not sure about this onenO !                on SQL_numeric, SQL_null_numeric do; ! not sure about this oneb. !                on SQL_real, SQL_null_real do? !                    fld.sqldata := create (Callout_buffer, 4);nF !                on SQL_double_precision, SQL_null_double_precision do? !                    fld.sqldata := create (Callout_buffer, 8);r7                 on SQL_date_time, SQL_null_date_time doe>                     fld.sqldata := create (Callout_buffer, 8);                 otherwise doG                     signal failure with "unrecognizable SQL data type";l             end case;_         end for;     end;   operation fetch_values (me)l     returns (Sequence[Object])F     ! fetch_values looks at the parameters in the SQLDA and translatesG     ! them into Owl objects -- returns a list of the objects it creates      is	     begine?         var parms: dyn_seq[Object] := create (dyn_seq[Object]);n9         for fld: SQL_var_field in elements (me.sqlvar) do !           fld.sqlind.offset := 0;r9           if decode (Integer, fld.sqlind, 2) < 0 then     F                  add_last (parms, nil);    ! a null value was returned           else"             case fld.sqltype      -                 on SQL_char, SQL_null_char doe,                     fld.sqldata.offset := 0;;                     add_last (parms, decode_value (String,  C                                         fld.sqldata, fld.sqllen));  3                 on SQL_varchar, SQL_null_varchar dou,                     fld.sqldata.offset := 0;I                     var len: Integer := decode (Integer, fld.sqldata, 2);nO                     add_last (parms, decode_value (String, fld.sqldata, len));  > !                on SQL_long_varchar, SQL_null_long_varchar do- !                    fld.sqldata.offset := 0;tJ !                    var len: Integer := decode (Integer, fld.sqldata, 2);P !                    add_last (parms, decode_value (String, fld.sqldata, len)); 3                 on SQL_integer, SQL_null_integer doo,                     fld.sqldata.offset := 0;H                     add_last (parms, decode (Integer, fld.sqldata, 4)); ?                 on SQL_small_integer, SQL_null_small_integer do ,                     fld.sqldata.offset := 0;H                     add_last (parms, decode (Integer, fld.sqldata, 2)); 5                 on SQL_quadword, SQL_null_quadword dos,                     fld.sqldata.offset := 0;H                     add_last (parms, decode (Integer, fld.sqldata, 8)); /                 on SQL_float, SQL_null_float doF*                     if fld.sqllen < 7 then0                         fld.sqldata.offset := 0;L                         add_last (parms, decode_float (Real, fld.sqldata));                      else0                         fld.sqldata.offset := 0;2                         Real.native_double := "g";M                         add_last (parms, decode_double (Real, fld.sqldata));                       end if; O !                on SQL_decimal, SQL_null_decimal do; ! not sure about this one O !                on SQL_numeric, SQL_null_numeric do; ! not sure about this one . !                on SQL_real, SQL_null_real do- !                    fld.sqldata.offset := 0;,I !                    add_last (parms, decode_float (Real, fld.sqldata)); dF !                on SQL_double_precision, SQL_null_double_precision do- !                    fld.sqldata.offset := 0;o/ !                    Real.native_double := "g";iJ !                    add_last (parms, decode_double (Real, fld.sqldata)); 7                 on SQL_date_time, SQL_null_date_time do ,                     fld.sqldata.offset := 0;B                     add_last (parms, convert_from_VMS_time (Time, M                                          decode (Integer, fld.sqldata, 8))); e                 otherwise doG                     signal failure with "unrecognizable SQL data type";              end case;b           end if;          end for;         return parms;_     end;  5 operation assign_values (me, parms: Sequence[Object]) :     signals (Argument_mismatch, Wrong_data_type, Overflow)@     ! assign_values takes the objects in the parms list and puts     ! them into the SQLDA      is	     begin >         allocate_buffers (me);    ! allocate the buffers firstN         if parms.size ~= me.sqlvar.size then signal Argument_mismatch; end if;>         var i: Integer := 1;      ! the index for the sequence9         for fld: SQL_var_field in elements (me.sqlvar) dor            if parms[i] = nil then%               fld.sqlind.offset := 0;m)               encode (-1, fld.sqlind, 2);u           else             case fld.sqltype-                 on SQL_char, SQL_null_char do ,                     fld.sqldata.offset := 0;G                     encode_value (pad_right (force (String, parms[i]), bI                                         fld.sqllen, blank), fld.sqldata);y3                 on SQL_varchar, SQL_null_varchar do ,                     fld.sqldata.offset := 0;K                     encode (force (String, parms[i]).size, fld.sqldata, 2);dI                     encode_value (force (String, parms[i]), fld.sqldata); > !                on SQL_long_varchar, SQL_null_long_varchar do- !                    fld.sqldata.offset := 0;SL !                    encode (force (String, parms[i]).size, fld.sqldata, 2);J !                    encode_value (force (String, parms[i]), fld.sqldata);3                 on SQL_integer, SQL_null_integer do_,                     fld.sqldata.offset := 0;G                     encode (force (Integer, parms[i]), fld.sqldata, 4); ?                 on SQL_small_integer, SQL_null_small_integer do_,                     fld.sqldata.offset := 0;G                     encode (force (Integer, parms[i]), fld.sqldata, 2);n5                 on SQL_quadword, SQL_null_quadword dod,                     fld.sqldata.offset := 0;G                     encode (force (Integer, parms[i]), fld.sqldata, 8);u/                 on SQL_float, SQL_null_float don*                     if fld.sqllen < 7 then0                         fld.sqldata.offset := 0;L                         encode_float (force (Real, parms[i]), fld.sqldata);                      else0                         fld.sqldata.offset := 0;2                         Real.native_double := "g";M                         encode_double (force (Real, parms[i]), fld.sqldata);                       end if;lO !                on SQL_decimal, SQL_null_decimal do; ! not sure about this one O !                on SQL_numeric, SQL_null_numeric do; ! not sure about this one . !                on SQL_real, SQL_null_real do- !                    fld.sqldata.offset := 0;nI !                    encode_float (force (Real, parms[i]), fld.sqldata); dF !                on SQL_double_precision, SQL_null_double_precision do- !                    fld.sqldata.offset := 0; / !                    Real.native_double := "g";aJ !                    encode_double (force (Real, parms[i]), fld.sqldata); 7                 on SQL_date_time, SQL_null_date_time dot,                     fld.sqldata.offset := 0;J                     encode (convert_to_VMS_time (force (Time, parms[i])), 6                                       fld.sqldata, 8);                 otherwise doG                     signal failure with "unrecognizable SQL data type";              end case;o           end if;            i := i + 1;l         end for;
     except         on Bounds do%             signal Argument_mismatch;          on Cant_force do#             signal Wrong_data_type;S          on Overflow do resignal;     end;   end type_module;   type_module SQL_error   = ! this type packages the error code returned from ESQL with a " ! descriptive message of the error  & define SQL_eof: Integer Public := 100;   component me.code: Integ                                                                                                                                                                                                                                                                           t? $      TRELLIS010.D                   8  b:  .[SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.TRE;3                                                                                 S     f                         e "     3       er
     is field;w   component me.message: String
     is field;c  5 operation create (Mytype, code: Integer, mes: String)      returns (Mytype)     is allocate,	     begin          me.code := code;         if mes = "" then l6             me.message := find_message (Mytype, code);         else             me.message := mes;         end if;u     end;  . operation find_message (Mytype, code: Integer)     returns (String)A     ! return an error or warning message based on the return code)     is	     begin          return "";  ! for nowl     end;  ! operation short_display_form (me)      returns (String)     override     is (me.message);   end type_module;   type_module SQL_var_fieldx  2 define SQL_var_field_length: Integer Public := 44;; ! SQL manual has this as 43 but I can't see why it's not 44    ! SQL data type values; * define SQL_integer: Integer public := 496;/ define SQL_null_integer: Integer public := 497; 0 define SQL_small_integer: Integer public := 500;5 define SQL_null_small_integer: Integer public := 501; K define SQL_quadword: Integer public := 504;                 ! DEC ExtensioneK define SQL_null_quadword: Integer public := 505;            ! DEC Extensione( define SQL_float: Integer public := 480;- define SQL_null_float: Integer public := 481;u* define SQL_decimal: Integer public := 484;/ define SQL_null_decimal: Integer public := 485;q* ! define SQL_numeric: Integer public := 0;/ ! define SQL_null_numeric: Integer public := 0;_' ! define SQL_real: Integer public := 0; , ! define SQL_null_real: Integer public := 0;3 ! define SQL_double_precision: Integer public := 0; 8 ! define SQL_null_double_precision: Integer public := 0;' define SQL_char: Integer public := 452;M, define SQL_null_char: Integer public := 453;* define SQL_varchar: Integer public := 448;/ define SQL_null_varchar: Integer public := 449; / ! define SQL_long_varchar: Integer public := 0; 4 ! define SQL_null_long_varchar: Integer public := 0;J define SQL_date_time: Integer public := 502;               ! DEC ExtensionJ define SQL_null_date_time: Integer public := 503;          ! DEC ExtensionJ define SQL_asciz: Integer public := 506;                   ! DEC ExtensionJ define SQL_null_asciz: Integer public := 507;              ! DEC Extension  & component me.real_data: Callout_bufferL ! this is the buffer where I reside -- part of an SQL_descriptor_area object     private 
     is field;,   component me.offset: Integer4 ! the starting offset into the buffer where I reside     private 
     is field;    component me.sqltype: Integer 8     ! 2 bytes indicating the data type of the parameter      ! see table E-2 for values     get is begin)         me.real_data.offset := me.offset;w1         return decode (Integer, me.real_data, 2);      end      put is begin)         me.real_data.offset := me.offset; (         encode (value, me.real_data, 2);         value;     end;   component me.sqllen: Integer=     ! 2 bytes indicating the length in bytes of the parametern     get is begin-         me.real_data.offset := me.offset + 2;a1         return decode (Integer, me.real_data, 2);      endE     put is begin-         me.real_data.offset := me.offset + 2; (         encode (value, me.real_data, 2);         value;     end;  $ component me.sqldata: Callout_buffer     ! the parameter C     ! when we assign the buffer we put a pointer to it in the sqldaa     get signals (not_there)"     get is begin@         if not me.sqldata_exists? then signal not_there; end if;         me.real_sqldata;     end      put is begin!         me.real_sqldata := value; -         me.real_data.offset := me.offset + 4; <         encode (address (me.real_sqldata), me.real_data, 4);#         me.sqldata_exists? := true;          value;     end;  ) component me.real_sqldata: Callout_buffer 
     is field;t  % component me.sqldata_exists?: BooleandF     ! flag to indicate whether a call_out buffer exists for this field     private,
     is field;x  # component me.sqlind: Callout_buffer ?     ! the indicator variable -- used to indicate null values in;9     ! parameters -- create it here and initialize to zero %     ! this will always be an integer (+     !     see reference manual for it's use C     ! when we assign the buffer we put a pointer to it in the sqldanG ! note to myself -- not sure how this is handled in dynamic SQL -- i.e.aE ! do you let someone indicate null values -- pass a list of indicatore	 ! values?A     get is (me.real_sqlind)      put is begin          me.real_sqlind := value;-         me.real_data.offset := me.offset + 8;i;         encode (address (me.real_sqlind), me.real_data, 4);i         value;     end;  ( component me.real_sqlind: Callout_buffer     private 
     is field;r   component me.sqlname: String&     ! 30 characters (+ 2 for a length)E     ! for output parameters the name of the column in the select listuF     ! for input parameters the name of the column to which a parameter9     !   marker is assigned or compared (in any predicate)      put signals (Bounds)     get is begin.         me.real_data.offset := me.offset + 12;A         var length: Integer := decode (Integer, me.real_data, 2);u;         return decode_value (String, me.real_data, length);b     end      put is begin6         if value.size > 30 then signal Bounds; end if;.         me.real_data.offset := me.offset + 12;D         encode (value.size, me.real_data, 2);    ! put in the length+         encode_value (value, me.real_data);d         value;     end;    A operation create (Mytype, where: Callout_buffer, offset: Integer)d     returns (Mytype)     is allocatel	     beginf$         me.sqldata_exists? := false;         me.real_data := where;         me.offset := offset;#         me.sqlind := by_ref (0, 4);v     end;  ! operation short_display_form (me)l     override     returns (String)     is (me.sqlname);   end type_module;   type_module SQLeG ! this type provides an easier to use interface to SQL than the dynamic D ! layer -- it defaults a lot of the commands to their simplest formsD ! -- if the form provided does not give you the options you need you@ ! can by pass this layer and go to the dynamic_sql type directlyD ! If you save these objects across Trellis sessions you will have toH ! call initialize to reinitialize the callout buffers when a new session ! starts up. !   + component me.max_number_parameters: Integer(     subtype_visible 
     is field;     + component me.sqlda_out: SQL_descriptor_areax     subtype_visible 
     is field;;  * component me.sqlda_in: SQL_descriptor_area     subtype_visibled
     is field;f  ! component me.dynamic: Dynamic_SQL E     ! contains the object used for communicating with the Dynamic_SQLdD     ! layer -- keep public since the user may have to do things likeG     ! close_cursor on this object even if using the SQL level interface 
     is field;o     ! schema modification commands  ( operation create (me, statement: String)     returns (Integer) '     signals (SQL_Exception (SQL_Error))a(     ! used to define the database schema     ! example: e-     !          "CREATE DOMAIN TEST_REAL REAL"i!     ! returns the SQL return codee     is begin9         return execute_immediate (me.dynamic, statement); 
     except%         on SQL_Exception do resignal;      end;  ' operation alter (me, statement: String)      returns (Integer) '     signals (SQL_Exception (SQL_Error))e(     ! used to update the database schema!     ! returns the SQL return coded     is begin9         return execute_immediate (me.dynamic, statement);h
     except%         on SQL_Exception do resignal;q     end;  & operation drop (me, statement: String)     returns (Integer)o'     signals (SQL_Exception (SQL_Error)) +     ! used to delete portions of the schemau!     ! returns the SQL return code      is begin9         return execute_immediate (me.dynamic, statement);t
     except%         on SQL_Exception do resignal;n     end;     ! commit and rollbackt   operation commit (me)      returns (Integer)t'     signals (SQL_Exception (SQL_Error))nD     ! ends a transaction and makes permanent any changes made duringC     ! that transaction -- we could go through the dynamic layer butl%     ! take a short cut for expediencys     is begin5         var sqlcode: Callout_buffer := by_ref (0, 4);t
         begin -             callout_status (Callout_facility, B                 "SQL_INTERFACE", "COMMIT_TRANSACTION", {sqlcode});0             return decode (Integer, sqlcode, 4);         except u             on Not_found do F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: S                                                                                                                                                                                                                                                                            $      TRELLIS010.D                   8  b:  .[SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.TRE;3                                                                                 S     f                         d "     D       tring do=                 signal SQL_Exception with create (SQL_Error, nH                                        decode (Integer, sqlcode, 4), s);         end;     end;     operation rollback (me)u     returns (Integer) '     signals (SQL_Exception (SQL_Error))dJ     ! ends a transaction and undoes all changes that have been made to theG     ! database since that transaction began -- we could go through the a7     ! dynamic layer but take a short cut for expediency      is begin5         var sqlcode: Callout_buffer := by_ref (0, 4);[
         begin -             callout_status (Callout_facility,DD                 "SQL_INTERFACE", "ROLLBACK_TRANSACTION", {sqlcode});0             return decode (Integer, sqlcode, 4);         except             on Not_found do[F                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String do=                 signal SQL_Exception with create (SQL_Error,  H                                        decode (Integer, sqlcode, 4), s);         end;     end;       ! dml commands  ( operation insert (me, statement: String)     returns (Integer).?     signals (SQL_Exception (SQL_Error), SQL_interface (String))S=     ! adds a new row, or a number of rows, to a table or viewfG     ! (most generic form but must contain literals for parameter values      !  or select list items)     ! example:N     !     "INSERT INTO DEPARTMENTS VALUES (\"RECR\", \"RECREATION\", \"00175",0     !                           240000, 128776)"     !l!     ! returns the SQL return code      is v	     begin_3         return non_select_no_parms (me, statement);a
     except4         on SQL_Exception, SQL_interface do resignal;     end;  4 operation insert_parm_values (me, statement: String,;                                   values: Sequence[Object])S     returns (Integer)t?     signals (SQL_Exception (SQL_Error), SQL_interface (String)) E     ! adds a new row to a table or view, can contain parameter makers 7     ! statement:    includes the table name and columns F     ! values:       a list of the values to be added to the table as aJ     !               single row -- must correspond to the number of columns     ! example::     !     "INSERT INTO DEPARTMENTS VALUES (?, ?, ?, ?, ?)"     ! !     ! returns the SQL return codeI     is l	     begin8=         return non_select_with_parms (me, statement, values); 
     except4         on SQL_Exception, SQL_interface do resignal;     end;    6 operation insert_select_values (me, statement: String,=                                     values: Sequence[Object])      returns (Integer)t?     signals (SQL_Exception (SQL_Error), SQL_interface (String));7     ! adds a new row or several rows to a table or view(7     ! statement:    includes the table name and columns :     ! values:       a list of the select values to be used     !t     ! example:D     !     "INSERT INTO TEMP SELECT * FROM EMPLOYEES WHERE STATE = ?"     ! !     ! returns the SQL return codel     is  	     begin =         return non_select_with_parms (me, statement, values);s
     except4         on SQL_Exception, SQL_interface do resignal;     end;    ( operation delete (me, statement: String)     returns (Integer)s?     signals (SQL_Exception (SQL_Error), SQL_interface (String))";     ! deletes the row(s) from the table (most generic form)aG     ! (most generic form but must contain literals for parameter valuesd     !  or select list items)     ! example:D     !     "DELETE FROM DEPARTMENTS WHERE DEPARTMENT_CODE = \"XXXX\""     ! !     ! returns the SQL return coded     is t	     beginq3         return non_select_no_parms (me, statement); 
     except4         on SQL_Exception, SQL_interface do resignal;     end;    4 operation delete_parm_values (me, statement: String,;                                   values: Sequence[Object])r     returns (Integer) ?     signals (SQL_Exception (SQL_Error), SQL_interface (String)) '     ! deletes the row(s) from the tabler7     ! statement:    includes the table name and columns 4     ! values:       a list of the select list values     ! example:=     !     "DELETE FROM DEPARTMENTS WHERE DEPARTMENT_CODE = ?"m     !;!     ! returns the SQL return code      is  	     begino=         return non_select_with_parms (me, statement, values);s
     except4         on SQL_Exception, SQL_interface do resignal;     end;    0 operation delete_current (me, statement: String)     returns (Integer) '     signals (SQL_Exception (SQL_Error))SH     ! deletes the row from the table where the current cursor is located3     ! -- the statement just contains the table namet8     ! -- NOTE: can only be used inside a select iterator     ! example:8     !     "DELETE FROM DEPARTMENTS WHERE CURRENT OF SEL"     !r!     ! returns the SQL return codeq     is s	     begin 9         return execute_immediate (me.dynamic, statement);d
     except%         on SQL_Exception do resignal;o     end;    ( operation update (me, statement: String)     returns (Integer)Q?     signals (SQL_Exception (SQL_Error), SQL_interface (String))=E     ! modifies a row in a table (most generic form) -- can't include q+     ! parameter values or select list items      ! example:A     !     "UPDATE EMPLOYEES SET ADDRESS_DATA_1 = \"16 Ridge St.\"i0     !             WHERE EMPLOYEE_ID = \"00164\""     ! !     ! returns the SQL return codeI     is a	     begind3         return non_select_no_parms (me, statement); 
     except4         on SQL_Exception, SQL_interface do resignal;     end;    4 operation update_parm_values (me, statement: String,;                                   values: Sequence[Object])o     returns (Integer) ?     signals (SQL_Exception (SQL_Error), SQL_interface (String))IC     ! modifies a row in a table (most generic form) -- can include Q,     ! parameter values and select list items     ! example:3     !     "UPDATE EMPLOYEES SET ADDRESS_DATA_1 = ?  (     !             WHERE EMPLOYEE_ID = ?"     !r!     ! returns the SQL return code      is l	     begin =         return non_select_with_parms (me, statement, values); 
     except4         on SQL_Exception, SQL_interface do resignal;     end;    0 operation update_current (me, statement: String)     returns (Integer) ?     signals (SQL_Exception (SQL_Error), SQL_interface (String)) H     ! updates the row from the table where the current cursor is located2     ! -- can only be used inside a select iterator     ! example:D     !     "UPDATE EMPLOYEES SET ADDRESS_DATA_1 = \"16 Ridge St.\"" &.     !                   "WHERE CURRENT OF SEL"     ! !     ! returns the SQL return codeu     is _	     begino9         return execute_immediate (me.dynamic, statement); 
     except4         on SQL_Exception, SQL_interface do resignal;     end;    7 operation update_current_values (me, statement: String,L;                                   values: Sequence[Object])q     returns (Integer) ?     signals (SQL_Exception (SQL_Error), SQL_interface (String))]H     ! updates the row from the table where the current cursor is located2     ! -- can only be used inside a select iterator     ! example:H     !     "UPDATE EMPLOYEES SET ADDRESS_DATA_1 = ? WHERE CURRENT OF SEL"     !=!     ! returns the SQL return codee     is  	     begin 6         prepare2 (me.dynamic, me.sqlda_in, statement);2         describe_input2 (me.dynamic, me.sqlda_in);,         assign_values (me.sqlda_in, values);+         execute2 (me.dynamic, me.sqlda_in); %         return release2 (me.dynamic);u
     except         on Argument_mismatch do H             signal SQL_interface with "Mismatch in number of arguments";         on Wrong_data_type dooE             signal SQL_interface with "Wrong data type in arguments";          on Overflow do6             signal SQL_interface with "Data overflow";%         on SQL_Exception do resignal;m     end;    ( operation select (me, statement: String)     yields (Sequence[Object]) ?     signals (SQL_Exception (SQL_Error), SQL_interface (String))tB     ! an iterator that yields the rows of the table resulting from&     ! evaluating the select_expressionE     ! example:  "SELECT * FROM DEGREES WHERE EMPLOYEE_ID = \"00192\""o>     !   or      "SELECT LAST_NAME, CITY, STATE FROM EMPLOYEES"     !)J     ! NOTE: do not exit from a select iterator loop -- if you do you have D     ! to call close_cursor (me.dynamic) or the next select will fail     !l     is  	     begin =         prepare_output (me.dynamic, me.sqlda_out, statement);S1         describe_input (me.dynamic, me.sqlda_in);_&         if me.sqlda_in.sqld ~= 0 then E             signal SQL_interface with "No input parameters allowed";                                                                                                                                                                                                                                                                           O $      TRELLIS010.D                   8  b:  .[SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.TRE;3                                                                                 S     f                         \ "     U        e         end if; (         allocate_buffers (me.sqlda_out);.         open_cursor (me.dynamic, me.sqlda_in);         loop3             fetch_sqlda (me.dynamic, me.sqlda_out);e.             yield fetch_values (me.sqlda_out);         end loop;l
     except         on SQL_eof doe&             close_cursor (me.dynamic);!             release (me.dynamic);i%         on SQL_Exception do resignal;e     end;    / operation select_values (me, statement: String,_6                              values: Sequence[Object])     yields (Sequence[Object]);?     signals (SQL_Exception (SQL_Error), SQL_interface (String))SB     ! an iterator that yields the rows of the table resulting fromA     ! evaluating the select_expression -- the Sequence of objects 7     ! passed in is used for the parameter marker valuesl>     ! example:  "SELECT * FROM DEGREES WHERE EMPLOYEE_ID = ?""     !pJ     ! NOTE: do not exit from a select iterator loop -- if you do you have D     ! to call close_cursor (me.dynamic) or the next select will fail     !L     is	     begint=         prepare_output (me.dynamic, me.sqlda_out, statement); 1         describe_input (me.dynamic, me.sqlda_in);n,         assign_values (me.sqlda_in, values);(         allocate_buffers (me.sqlda_out);.         open_cursor (me.dynamic, me.sqlda_in);         loop3             fetch_sqlda (me.dynamic, me.sqlda_out); .             yield fetch_values (me.sqlda_out);         end loop;t
     except         on SQL_eof do &             close_cursor (me.dynamic);!             release (me.dynamic);          on Argument_mismatch doyH             signal SQL_interface with "Mismatch in number of arguments";         on Wrong_data_type do.E             signal SQL_interface with "Wrong data type in arguments";          on Overflow do6             signal SQL_interface with "Data overflow";%         on SQL_Exception do resignal;      end;    2 operation singleton_select (me, statement: String)     returns (Sequence[Object])J     signals (SQL_Exception (SQL_Error), SQL_interface (String), not_found):     ! does a select but only returns the first tuple foundE     ! example:  "SELECT * FROM DEGREES WHERE EMPLOYEE_ID = \"00192\"" 7     !   or      "LAST_NAME, CITY, STATE FROM EMPLOYEES"n     !o     is e	     begina@         for tuple: Sequence[Object] in select (me, statement) do&             close_cursor (me.dynamic);!             release (me.dynamic);e             return tuple;m         end for;         signal not_found;i
     except5         on SQL_Exception, SQL_Interface  do resignal;e     end;    9 operation singleton_select_values (me, statement: String, @                                        values: Sequence[Object])     returns (Sequence[Object])J     signals (SQL_Exception (SQL_Error), SQL_interface (String), not_found):     ! does a select but only returns the first tuple found=     ! example:  "SELECT * FROM DEGREES WHERE EMPLOYEE_ID = ?"e     !      is  	     begindO         for tuple: Sequence[Object] in select_values (me, statement, values) dot&             close_cursor (me.dynamic);!             release (me.dynamic);z             return tuple;          end for;         signal not_found;c
     except5         on SQL_Exception, SQL_Interface  do resignal;i     end;     ! creation routines   6 operation new (Mytype, max_number_parameters: Integer)     returns (Mytype)J     ! when creating an SQL object pass in the maximum number of parameters     ! that you want      is allocate 	     beginr:         me.max_number_parameters := max_number_parameters;         initialize (me);     end;   operation initialize (me) J     ! have to call this operation if you save this object across a Trellis'     ! session and then want to reuse it      is	     begin O         me.sqlda_out := create (SQL_descriptor_area, me.max_number_parameters);hN         me.sqlda_in := create (SQL_descriptor_area, me.max_number_parameters);+         me.dynamic := create (Dynamic_SQL);n     end;  & ! private and subtype visible routines  5 operation non_select_no_parms (me, statement: String)=     returns (Integer) ?     signals (SQL_Exception (SQL_Error), SQL_interface (String))      subtype_visibleuG     ! implements non select statements that have no parameter values orf     ! select list values     !d!     ! returns the SQL return codef     is .	     begin;H ! could probably just do an execute_immediate here -- this way allows meH ! to check that there were no input parameters but is it a lot slower to ! do the 3 calls?y5         prepare (me.dynamic, me.sqlda_in, statement);u1         describe_input (me.dynamic, me.sqlda_in); &         if me.sqlda_in.sqld ~= 0 then E             signal SQL_interface with "No input parameters allowed"; =         end if; 1         return execute (me.dynamic, me.sqlda_in); 
     except%         on SQL_Exception do resignal;;     end;  7 operation non_select_with_parms (me, statement: String,i>                                      values: Sequence[Object])     returns (Integer)n?     signals (SQL_Exception (SQL_Error), SQL_interface (String))v     subtype_visible J     ! implements non select statements that have parameters or select list     ! values,     ! statement:    statement to be executedF     ! values:       a list of the values to be added to the table as aJ     !               single row -- must correspond to the number of columns     !u!     ! returns the SQL return code      is  	     begint5         prepare (me.dynamic, me.sqlda_in, statement);e1         describe_input (me.dynamic, me.sqlda_in); ,         assign_values (me.sqlda_in, values);1         return execute (me.dynamic, me.sqlda_in);j
     except         on Argument_mismatch doQH             signal SQL_interface with "Mismatch in number of arguments";         on Wrong_data_type docE             signal SQL_interface with "Wrong data type in arguments";m         on Overflow do6             signal SQL_interface with "Data overflow";%         on SQL_Exception do resignal;Q     end;   operation sql_signal (me)t'     signals (SQL_Exception (SQL_Error))      subtype_visibleE!     ! used for debugging purposesQ?     ! call it if you receive an SQL_Error with no error messagee     is	     begin)H         callout_status (Callout_facility, "SQL_INTERFACE", "SQL$SIGNAL",                 {});     except               on Not_found doiF                 signal Failure with "cannot find DYNAMIC_SQL library";.             on VMS_Exception with s: String doD                 signal SQL_Exception with create (SQL_Error, -1, s);     end;   end type_module;   type_module RDB_SQL      subtype_of (SQL) ! 4 ! this type contains the RDB-specific SQL extensions !       ) ! transactions and open database commandse  0 operation declare_schema (me, statement: String)     returns (Integer) '     signals (SQL_Exception (SQL_Error))mI     ! used to specify the name and the source of the database definitionsn     ! to be accessedG     ! statement should contain a valid pathname or filename for exampleSL     !                "DECLARE SCHEMA FOR PATHNAME CDD$TOP.RDB.SQL_PERSONNEL"     !             or@     !                "DECLARE SCHEMA FOR FILENAME MY_SCHEMA.RDB"     ! !     ! returns the SQL return code      is begin9         return execute_immediate (me.dynamic, statement); 
     except%         on SQL_Exception do resignal;i     end;    5 operation declare_transaction (me, statement: String)}     returns (Integer)d'     signals (SQL_Exception (SQL_Error))eF     ! specifies the characteristics for a transaction -- the statement>     ! argument should be a valid declare transaction statement/     ! for example  "DECLARE TRANSACTION ON DB1 cE     !                        USING (READ_ONLY RESERVING DB1.EMPLOYEES .     !                        FOR SHARED READ)"3     !   or         "DECLARE TRANSACTION READ_WRITE" 8     ! does not start the transaction -- only one allowed!     ! returns the SQL return code      is begin9         return execute_immediate (me.dynamic, statement); 
     except%         on SQL_Exception do resignal;a     end;    1 operation set_transaction (me, statement: String)a     returns (Integer)e'     signals (SQL_Exception (SQL_Error)) F     ! specifies the characteristics for a transaction -- the statement:     ! argument should be a valid set transaction statement+     ! for example  "SET TRANSACTION ON DB1 tE     !                        USING (READ_ONLY RESERVING DB1.EMPLOYEESn.     !                        FOR SHARED READ)"/     !   or         "SET TRANSACTION READ_WRITE"i(     ! transaction is started immediately!     ! returns the SQL return code      is begin9         return e                                                                                                                                                                                                                                                                           iMy $      TRELLIS010.D                   8  b:  .[SYSMGR.SEAS$WORK_0000077F]SQL_INTERFACE.TRE;3                                                                                 S     f                               f       xecute_immediate (me.dynamic, statement); 
     except%         on SQL_Exception do resignal;r     end;   end type_module;                                                                                                                                                                                                                                                                                                                                                                                                                 : * [SYSMGR.SEAS$WORK_0000077F]STANDALONE_TRELLIS_SYSTEM.TRE;1 +  , 8   .     /     4 P                          - b:    0   1    2   3      K  P   W   O     5   6 NF  7 @g  8          9          G    H  J                      type_module Trellis_System ! 5 !   Copyright (c) Digital Equipment Corporation, 1990 5 !   All Rights Reserved.  Unpublished rights reserved 2 !   under the copyright laws of the United States. !   7 !   The software contained on this media is proprietary 3 !   to and embodies the confidential technology of  4 !   Digital Equipment Corporation.  Possession, use,4 !   duplication or dissemination of the software and8 !   media is authorized only pursuant to a valid written/ !   license from Digital Equipment Corporation.  ! 4 !   RESTRICTED RIGHTS LEGEND   Use, duplication, or 3 !   disclosure by the U.S. Government is subject to 8 !   restrictions as set forth in Subparagraph (c)(1)(ii)2 !   of DFARS 252.227-7013, or in FAR 52.227-19, as !   applicable.  !    ! E ! This module contains operations that affect the Trellis system. It  C ! includes system startup and shutdown operations. It also contains D ! the error dispatcher that handles errors from the run-time system. !  ! I ! Run_debugger is the "error dispatcher", it receives error messages from 6 ! the run-time system and deals with them in some way.0 ! Run_debugger is intended to be replaced in any6 ! non-trivial programming environment such as Trellis. !     ) define The_Trellis_System: Null public := H     begin   ! this will be a mytype operation when the C code is changed!         Activity.slicing := true; !         Activity.ticking := true; !         Activity.tick_size := 50; *         Activity.notify_on_birth := false;4         Activity.default_notify_on_failure := false;4         Activity.default_notify_on_death   := false;  ? 	! Allow special pre-initialization for Mytype components, etc. $ 	! This *MUST* be done *VERY* early. 	pre_initialize (Mytype);   )         if OS.string_name = "ULTRIX" then #             input_enable(Terminal);          end if; >         Global_Context["STANDARD_INPUT"] := OS.standard_input;@         Global_Context["STANDARD_OUTPUT"] := OS.standard_output;           var idle: Activity  :=>             create_frozen (Activity, "IDLE_LOOP", {Activity});8         idle.priority       := Activity.min_ready_level;%         idle.breaks_enabled := false; !         idle.categories     := 2;          thaw (idle);           var debug: Activity  := ?             create_frozen (Activity, "RUN_DEBUGGER", {Mytype}); 9         debug.priority       := Activity.max_ready_level; &         debug.breaks_enabled := false;"         debug.categories     := 2;         thaw (debug);            var main: Activity  :=M             create_frozen (Activity, "START_APPLICATION_ACTIVITY", {Mytype}); %         main.breaks_enabled := false; !         main.categories     := 2;          thaw (main);  #         start_scheduler (Activity); 1 ! will return here after stop_scheduler is called          shutdown (Activity);;         nil;    ! just return when this is a real operation      end;      operation pre_initialize(Mytype)@ ! Hook to allow special initialization.  This is one of the very ! first things done.     subtype_visible      is	     begin          init_shutdown (Mytype);      end;  - operation start_application_activity (Mytype)  ! J ! This operation determines which operation (has to be a mytype operation)% ! to invoke to start the application.  !      is	     begin $         var start_operation: String;&         var start_type: Declared_type;       begin >         start_operation := Command_line.run_program_operation;         start_type := P           find_declared_type (default_workspace, Command_line.run_program_type);  I ! this operation must call something that calls shutdown (Trellis_system) "         var main_act: Activity  :=A                 create (Activity, start_operation, {start_type});          await (main_act);          case main_act.status             on returned do:                 print_all ({start_operation, " returned ",C                             robust (String, main_act.return_value), "                             eol});             on signalled do <                 print_all ({start_operation, " signalled ", ;                             main_act.signal_name, " with ", C                             robust (String, main_act.signal_value), "                             eol});"                 shutdown (Mytype);             otherwise do8                 print_all ({"ERROR: ", start_operation, >                            " returned with bad status", eol});"                 shutdown (Mytype);         end case;          except         on Not_Found do H             print_all ({"Could not find ", start_operation, " in type ",A                             Command_line.run_program_type, eol});              shutdown (Mytype);         on Bad_format doG             print_all ({"Could not start the application: check the ",  =                     "format of run_program qualifier", eol});              shutdown (Mytype);
       end;     end;  H !------------------------ shutdown code --------------------------------  9 component Mytype.finalizations: Dyn_seq[Operation_Object]      private      ! F     !   The stack of finalization operations to be run when the system     !   is being shutdown.     ! 
     is field;     operation init_shutdown (Mytype)9     !   Initializes the stack of finalization operations.      is	     begin B         Mytype.finalizations := create(Dyn_seq[Operation_object]);     end;  @ operation register_shutdown_op (Mytype, final: Operation_object)
     public     ! K     !   Registers a finalization operation (operation_object with arguments K     !   bound -- so use create_with_args). These operations will be called  M     !   (in reverse order of registration) when the system is being shutdown  I     !   (by run(System_shutdown)) but before the multiple activity system      !   is exited.     !      is	     begin /         add_last (Mytype.finalizations, final);      end;   operation shutdown (Mytype) 
     public     ! A     !   Shuts the system down.  It will call all the finalization D     !   operations (in reverse order of registration) and then callsF     !   stop_scheduler(Activity) to exit the multiple activity system.     ! E     !   This operation must be called somewhere in an application (or *     !   the application will run forever).     !      is	     begin #         run_finalizations (Mytype); "         stop_scheduler (Activity);     end   $ operation run_finalizations (Mytype)     private      is	     begin          loop>             if Mytype.finalizations.empty? then return end if;  <             ! process the last finalization Operation_objectM             var final: Operation_Object := remove_last(Mytype.finalizations);              begin                  call (final);              except9                 otherwise do;    ! catch all exceptions,               end;         end loop;      end;  I !------------------------------- run debugger code ----------------------    operation run_debugger (mytype) I     !   This is a trivial default debugger, more to show how to do things E     !   than anything else.  There is a special builtin that supplies J     !   debugger messages from the runtime system, and Wait_queue providesJ     !   a feature for a distinguished debugger message Wait_queue, that isJ     !   poked each time a new message is available.  The message codes andG     !   meanings should be obvious.  In the case of breakpoints, signal I     !   breaks, uncaught signal breaks, and unimplemented operations, the J     !   activity that encountered them freezes itself.  Control C does notK     !   of itself freeze anything; a debugger would pr                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Ԛ $      TRELLIS010.D                   8  b:  :[SYSMGR.SEAS$WORK_0000077F]STANDALONE_TRELLIS_SYSTEM.TRE;1                                                                     P                              9             obably want to freeze /     !   at least some categories of activities.        is	     begin          defer_swaps (Activity);   A         var msgvec: Vector[Object] := create (Vector[Object], 2); 3         var alert: Semaphore := create (Semaphore); 1         Abstract_Wait_Queue.debug_queue := alert;            loop ! forever
         begin   #             allow_swaps (Activity);              wait (alert); #             defer_swaps (Activity);   ,             wait_for_msg (Activity, msgvec);@             var sender: Activity := force (Activity, msgvec[1]);@             var code:   Integer  := force (Integer,  msgvec[2]);  $             begin <<handle_message>>  &                 print_all ("DEBUG: ");                   case code                      on 0 do I                         print_all ("Control C struck; continuing ...\n"); 1                         leave <<handle_Message>>;                      on 2 do F                         print_all ("Code break hit; continuing...\n");                     on 3 do K                         print_all ("Exception break hit; continuing...\n");                      on 4 do D                         print_all ("Uncaught-exception break hit;" &7                                    " continuing...\n");                      on 5 do F                         print_all ("Unimplemented operation called;" &8                                    "  continuing...\n");                     on 6 do K                         print_all ("Stack overflow; activity halted...\n"); 1                         leave <<handle_Message>>;                      on 7 do M                         print_all("Fixed name or type field initialization" & @                                   " deadlock; continuing...\n");                     on 9 do O                         print_all ("Attempt to access uninitialized variable" & F                                    " or field; activity halted...\n");                     on 10 doH                         print_all ("Activity created; continuing...\n");                     on 11 doI                         print_all ("Activity finished; continuing...\n");                      on 13 doJ                         print_all ("Activity dying while holding locks;" &7                                    " continuing...\n");                      on 14 doB                         print_all ("Activity signalled Failure;" &7                                    " continuing...\n"); ;                         print_all ({" >> reason string = ", N                             string_form (force (String, sender.signal_value)),"                             eol});?                     on 17 do              ! Operation not found 3                         print_all ({robust (String, L                                             sender.signal_value_at_break)});?                         print_all ({"; activity halted...\n"}); 1                         leave <<handle_message>>;                       otherwise doE                         print_all ({"Unknown debugger message code ", (                             code, eol});                 end case;                    thaw (sender);  #             end <<handle_message>>;            except             otherwise doM                 print_all ("ERROR: Run_Debugger got bad debugger message\n");          end;         end loop;   
     except         otherwise doK             print_all ("ERROR: Run_Debugger failed for unknown reasons\n");      end;   ! E ! Component and defines for modifying the language of error messages.  !   " component mytype.Language: IntegerC     get is builtin("Trellis_Message_Get_Language", "trellis$image")      put          signals(Bounds) D         is builtin("Trellis_Message_Put_Language", "trellis$image");  $ define English: Integer public := 1;# define German: Integer public := 2; # define French: Integer public := 3; $ define Italian: Integer public := 4;& define Norwegian: Integer public := 5;$ define Swedish: Integer public := 6;$ define Spanish: Integer public := 7;   end type_module;                 > * [SYSMGR.SEAS$WORK_0000077F]STANDALONE_TRELLIS_TRANSLATOR.TRE;1 +  , 8   .     /     4 N      
                    - b:    0   1    2   3      K  P   W   O     5   6  *q  7 Eg  8          9          G    H  J                  type_module Trellis_translatorE !   This type is used to translate between different types of objects % !   which are exchanged between tools  ! 5 !   Copyright (c) Digital Equipment Corporation, 1990 5 !   All Rights Reserved.  Unpublished rights reserved 2 !   under the copyright laws of the United States. !   7 !   The software contained on this media is proprietary 3 !   to and embodies the confidential technology of  4 !   Digital Equipment Corporation.  Possession, use,4 !   duplication or dissemination of the software and8 !   media is authorized only pursuant to a valid written/ !   license from Digital Equipment Corporation.  ! 4 !   RESTRICTED RIGHTS LEGEND   Use, duplication, or 3 !   disclosure by the U.S. Government is subject to 8 !   restrictions as set forth in Subparagraph (c)(1)(ii)2 !   of DFARS 252.227-7013, or in FAR 52.227-19, as !   applicable.  !         - operation translate (mytype, source: Object,  %                              T: Type)      returns (Object)#     signals (Cant_return_that_type)      ! N     ! T is the type that we want to return, source is the kind of objects that4     ! have been selected (the actual source in fact)     !      ! :     ! The type of source and the value of T can be one of:6     !                   String, Object, (add your own)5     !                   or Sequence[any of the above]      !      !      is	     begin <         !   Treat X's and Sequence[X]'s as the same. All the;         !   translate_to_... routines return Sequence[X]'s. "         var seq: Sequence[Object];         case T*             on Object, Sequence[Object] do                  type_case source                      on String doD                         seq := translate_to_objects(Mytype, source);*                     on Sequence[Object] do4                         var dseq: Dyn_seq[Object] :=4                             create(Dyn_seq[Object]);D                         for o: Object in elements(selector_value) do.                             add_seq_last(dseq,A                                 translate_to_objects(Mytype, o));                           end for;$                         seq := dseq;                      otherwise doD                         seq := translate_to_objects(Mytype, source);                 end type_case;  *             on String, Sequence[String] do                  type_case source                      on String doD                         seq := translate_to_strings(Mytype, source);*                     on Sequence[Object] do4                         var dseq: Dyn_seq[String] :=4                             create(Dyn_seq[String]);D                         for o: Object in elements(selector_value) do.                             add_seq_last(dseq,A                                 translate_to_strings(Mytype, o));                           end for;$                         seq := dseq;                      otherwise doD                         seq := translate_to_strings(Mytype, source);                 end type_case;               otherwise do-                 signal Cant_return_that_type;          end case;            if seq.empty? then&             !   Nothing was converted.)             signal Cant_return_that_type;          end if;   @         !   Return sequence or single element, depending on what         !   was asked for.         case T              on Sequence[String],"                Sequence[Object] do                 return seq;              on String,                Object do%                 if seq.size ~= 1 then 1                     signal Cant_return_that_type;                  end if; !                 return seq.first;              otherwise do=                 signal Failure with "value of T not handled";          end case;                   except'             on Cant_return_that_type do                  resignal;      end;  7 operation translate_to_objects (mytype, source: Object)      returns (Sequence[Object])#     signals (Cant_return_that_type)      is	     begin          type_case source                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        $      TRELLIS010.D                   8  b:  >[SYSMGR.SEAS$WORK_0000077F]STANDALONE_TRELLIS_TRANSLATOR.TRE;1                                                                 N                                    	       on Object do*                 return { selector_value };             otherwise do-                 signal Cant_return_that_type;          end type_case;     except           on Not_found do )             signal Cant_return_that_type;      end;  7 operation translate_to_strings (mytype, source: Object)      returns (Sequence[String])#     signals (Cant_return_that_type)      is	     begin          type_case source             on String do*                 return { selector_value };             on Object do:                 return { robust(String, selector_value) };             otherwise do-                 signal Cant_return_that_type;          end type_case;     except           on Not_found do )             signal Cant_return_that_type;      end;   end type_module;                                                                                                                                                                                                                                                     3 * [SYSMGR.SEAS$WORK_0000077F]STUDENT_TOOLS_DEMO.TRE;2 +  , 8   .     /     4 O                          - b:    0   1    2   3      K  P   W   O     5   6 k"a4  7 zg  8          9          G    H  J                            E ! This is an example Trellis program that implements a student/course C ! enrollment system. It's primary intent is to give examples of how M ! to use the Trellis User Interface type library. Not all of the capabilities K ! that the user interface presents have been implemented. For example, once G ! a student is enrolled in a course you cannot remove that student from F ! the course. This functionality is left to the reader as an exercise. !  ! Have fun!      type_module Course  * component me.attendees: Set[Enrollment]        is field  ! component me.classroom: String         is field  # component me.course_name: String         is field  # component me.course_number: Integer      is field  ! operation audit (me, st: Student)      signals (already_enrolled)     is	     begin 6         var enr: enrollment := enroll (st, me, false);#         insert (me.attendees, enr); 
     except(         on already_enrolled do resignal;     end   ) operation create(mytype, number: Integer, '                          name: String,  &                          room: String)     returns (mytype)     override     is allocate 	     begin #         me.course_number := number;          me.course_name := name;          me.classroom := room; 1         me.attendees := create (Set[Enrollment]);      end   ! operation short_display_form (me)      override     returns (String)N     is ("no: " & string_form (me.course_number) & ", name: " & me.course_name)    operation take (me, st: Student)     signals (already_enrolled)     is	     begin 6         var enr: enrollment := enroll (st, me, false);#         insert (me.attendees, enr); 
     except(         on already_enrolled do resignal;     end   $ operation withdraw (me, st: Student)     signals (not_enrolled)     is	     begin  ! not implemented yet 
     except$         on not_enrolled do resignal;     end    end type_module;   type_module Course_tool      subtype_of (Tool) 7 define all_courses: Set[course] := create (Set[course])   ; component me.button_bar_entries: Sequence[menu_description]      get_only
     get is
         begin              return({4                     action(menu_description, "edit",>                         me, "Edit", "edit_course", {}, is_me),4                     action(menu_description, "save",>                         me, "Save", "save_course", {}, is_me),5                     action(menu_description, "clear", 8                         me, "Clear", "clear", {}, is_me)                    });         end   , component me.course_list: List_frame[Course]     private      is field  - component me.current_course: course | Null         private      is field  " component me.default_title: String     get_only     get is ("Course Tool")  + component me.edit_course_number: Text_frame      subtype_visible      is field  / component me.edit_current_course: Course | Null      subtype_visible      is field  : component me.edit_menu_entries: Sequence[menu_description]     get_only
     get is
         begin 4             return({action(menu_description, "copy",N                         me, "Copy", "copy_selection_to_clipboard", {}, is_me),9                     action(menu_description, "selectall", H                         me, "Select All", "do_select_all", {}, is_me)});         end   = component me.edit_students_frame: Sorted_list_frame [Student]      subtype_visible      is field  : component me.edit_students_window: (Tool_subwindow | Null)     subtype_visible      is field  & component me.error_text: Text_frame        private      is field  : component me.file_menu_entries: Sequence[menu_description]     get_only
     get is
         begin              return( 0                 {action(menu_description, "new",@                             me, "New", "create", {}, is_mytype),2                  action(menu_description, "close",=                             me, "Close", "close", {}, is_me), 5                  action(menu_description, "shutdown", H                             me, "End session", "shutdown", {}, is_me)});         end   9 component me.modifications_log: Dyn_seq[Sequence[Object]] 8     ! a list of triplets where each triplet has the form6     !  {action (1 = add, 2 = delete), course, student}7     ! we use this list to back out edits to the courses      subtype_visible      is field  # component me.name_label: Text_label      is field  $ component me.name_prompt: text_frame     is field  % component me.number_label: Text_label      is field  & component me.number_prompt: text_frame     is field  # component me.room_label: Text_label      is field  $ component me.room_prompt: text_frame     is field  : component me.view_menu_entries: Sequence[menu_description]     get_only
     get is
         begin              return( 1                 {action(menu_description, "edit", I                             me, "Edit Course", "edit_course", {}, is_me), 1                  action(menu_description, "save", I                             me, "Save Course", "save_course", {}, is_me), 3                  action(menu_description, "delete", M                             me, "Delete Course", "delete_course", {}, is_me), ;                  separator (menu_description, "separator"), 2                  action(menu_description, "clear",=                             me, "Clear", "clear", {}, is_me), ;                  separator (menu_description, "separator"), 1                  action(menu_description, "show", M                             me, "Show Students", "show_students", {}, is_me), 2                  action(menu_description, "edit", O                             me, "Edit Students", "edit_students", {}, is_me)});   end  " component Mytype.base_name: StringI     ! The base name for the tool.  The actual name of the tool is created 8     ! when the tool is registered with the Tool_manager.     get_only     get is ("CourseTool")   , operation action_text (me, n: course | null)     returns (String)     private      is	     begin          type_case n              on course do- 		return short_display_form (selector_value);              otherwise do                 return "";         end type_case;     end    operation apply_edits (me)     is	     begin =         me.modifications_log := Dyn_seq[Sequence[Object]]'{};      end   ! operation change_action_line (me)      is	     begin #         type_case me.current_course              on course do&                 change_status(me, "");'                 update_course_list(me);              on Null do                 ;          end type_case;     end   ) operation change_status (me, str: String)      private      is	     begin =         me.error_text.text := me.error_text.text & str & eol; &         apply_changes (me.error_text);     end    operation clear (me)     is	     begin          clear_status (me);!         me.current_course := nil;          change_status(me, "");         update_display (me);     end    operation clear_status (me)      private      is	     begin !         me.error_text.text := ""; &         apply_changes (me.error_text);     end    oper                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ZkA $      TRELLIS010.D                   8  b:  3[SYSMGR.SEAS$WORK_0000077F]STUDENT_TOOLS_DEMO.TRE;2                                                                            O                             * "            ation create (Mytype)      returns (Mytype)
     public     is allocate 	     begin *         var w: attachable_work_area_frame;%         var buttons: work_area_frame;   !         me.current_course := nil; '         me.edit_students_window := nil; &         me.edit_current_course := nil;=         me.modifications_log := Dyn_Seq[Sequence[Object]]'{};    	register_name(me); ;         me.window := create (tool_window, me.resource_name, A                                 me.default_title, "Courses", me); C         w := create(attachable_work_area_frame, "main", me.window);          w.border_width := 0;         w.size := 300@200;         apply_changes(w); &         me.window.workarea_frame := w;  8         me.window.menu_bar_frame := create_menu_bar(me);     ! get courses 4         var assocs: Dyn_seq[Association[Course]] := 4               create (Dyn_seq[Association[Course]]);2         for c: Course in elements (all_courses) do;             add_last (assocs, create (Association[Course],  >                                   short_display_form (c), c));         end for;  (     ! set up the number label and promptG         me.number_label := create_with_label (Text_label, "numberl", w, >                                              "Course Number");A         attach_to_me(w, Frame_Left, me.number_label, Frame_Left); ?         attach_to_me(w, Frame_Top, me.number_label, Frame_Top); ;         attach_to_nothing(w, me.number_label, Frame_Right); <         attach_to_nothing(w, me.number_label, Frame_Bottom);'         apply_changes(me.number_label);   F         me.number_prompt := create_rows_columns(text_frame, "numberp",9                                     w, 1, 30, "", false); +         me.number_prompt.border_width := 1; (         me.number_prompt.wrap? := false;6         me.number_prompt.allow_resize_width? := false;7         me.number_prompt.allow_resize_height? := false; D         attach_to_me(w, Frame_Right, me.number_prompt, Frame_Right);@         attach_to_me(w, Frame_Top, me.number_prompt, Frame_Top);:         attach_to_sibling(w, me.number_prompt, Frame_Left,>                                 me.number_label, Frame_Right);=         attach_to_nothing(w, me.number_prompt, Frame_Bottom); (         apply_changes(me.number_prompt);  &     ! set up the name label and promptC         me.name_label := create_with_label (Text_label, "namel", w, <                                              "Course Name");?         attach_to_me(w, Frame_Left, me.name_label, Frame_Left); 6         attach_to_sibling(w, me.name_label, Frame_Top,@                                 me.number_prompt, Frame_Bottom);8         attach_to_sibling(w, me.name_label, Frame_Right,>                                 me.number_label, Frame_Right);:         attach_to_nothing(w, me.name_label, Frame_Bottom);%         apply_changes(me.name_label);   B         me.name_prompt := create_rows_columns(text_frame, "namep",9                                     w, 1, 30, "", false); )         me.name_prompt.border_width := 1; &         me.name_prompt.wrap? := false;4         me.name_prompt.allow_resize_width? := false;5         me.name_prompt.allow_resize_height? := false; B         attach_to_me(w, Frame_Right, me.name_prompt, Frame_Right);7         attach_to_sibling(w, me.name_prompt, Frame_Top, @                                 me.number_prompt, Frame_Bottom);8         attach_to_sibling(w, me.name_prompt, Frame_Left,<                                 me.name_label, Frame_Right);;         attach_to_nothing(w, me.name_prompt, Frame_Bottom); &         apply_changes(me.name_prompt);  &     ! set up the room label and promptC         me.room_label := create_with_label (Text_label, "rooml", w, <                                              "Course Room");?         attach_to_me(w, Frame_Left, me.room_label, Frame_Left); 6         attach_to_sibling(w, me.room_label, Frame_Top,>                                 me.name_prompt, Frame_Bottom);8         attach_to_sibling(w, me.room_label, Frame_Right,<                                 me.name_label, Frame_Right);:         attach_to_nothing(w, me.room_label, Frame_Bottom);%         apply_changes(me.room_label);   B         me.room_prompt := create_rows_columns(text_frame, "roomp",9                                     w, 1, 30, "", false); )         me.room_prompt.border_width := 1; &         me.room_prompt.wrap? := false;4         me.room_prompt.allow_resize_width? := false;5         me.room_prompt.allow_resize_height? := false; B         attach_to_me(w, Frame_Right, me.room_prompt, Frame_Right);7         attach_to_sibling(w, me.room_prompt, Frame_Top, >                                 me.name_prompt, Frame_Bottom);8         attach_to_sibling(w, me.room_prompt, Frame_Left,<                                 me.room_label, Frame_Right);;         attach_to_nothing(w, me.room_prompt, Frame_Bottom); &         apply_changes(me.room_prompt);  F         me.error_text := create_rows_columns (text_frame, "errorText",8                                     w, 1, 80, "", true);(         me.error_text.border_width := 1;%         me.error_text.wrap? := false; )         me.error_text.read_only? := true; 3         me.error_text.allow_resize_width? := false; 4         me.error_text.allow_resize_height? := false;%         apply_changes(me.error_text);   4         me.course_list := create(list_frame[Course],=                                     "courseList", w, assocs); )         me.course_list.border_width := 1; &         apply_changes(me.course_list);    #         if me.show_button_bar? then I             buttons := create_with_entries(Button_bar_frame, "buttonBar", B                                     w, me.button_bar_entries, me);A             attach_to_me(w, Frame_Bottom, buttons, Frame_Bottom); 5             attach_to_nothing(w, buttons, Frame_Top); =             attach_to_me(w, Frame_Left, buttons, Frame_Left); ?             attach_to_me(w, Frame_Right, buttons, Frame_Right); =             attach_to_sibling(w, me.error_text, Frame_Bottom, 4                                 buttons, Frame_Top);#             apply_changes(buttons);          elseG             attach_to_me(w, Frame_Bottom, me.error_text, Frame_Bottom);          end if;   ?         attach_to_me(w, Frame_Left, me.error_text, Frame_Left); A         attach_to_me(w, Frame_Right, me.error_text, Frame_Right); 7         attach_to_nothing(w, me.error_text, Frame_Top);           me.error_text.rows := 2;%         apply_changes(me.error_text);   @         attach_to_me(w, Frame_Left, me.course_list, Frame_Left);B         attach_to_me(w, Frame_Right, me.course_list, Frame_Right);;         attach_to_sibling (w, me.course_list, Frame_Bottom, 7                              me.error_text, Frame_top); 7         attach_to_sibling(w, me.course_list, Frame_Top, ;                              me.room_prompt, Frame_Bottom); &         apply_changes(me.course_list);             apply_changes(w); %         make_default_size(me.window); !         apply_changes(me.window); &         start_up_with_breakpoints(me);         display(me);     end   ; operation create_edit_middle_button_bar (me, parent: Frame)      returns (Work_area_frame) 
     public     is	     begin *         var f: Attachable_work_area_frame;%         var buttons: Work_area_frame; &         var buttons2: Work_area_frame;  F         f := create(Attachable_work_area_frame, "midbuttons", parent);B         f.default_vertical_offset := 5;     ! doesn't seem to workB         f.default_horizontal_offset := 5;   ! doesn't seem to work         f.border_width := 0;         apply_changes(f);   @         me.edit_course_number := create_rows_columns(Text_frame,3                                     "courseNumber", 9                                     f, 1, 20, "", false); 0         me.edit_course_number.border_width := 1;-         me.edit_course_number.wrap? := false; 2         me.edit_course_number.read_only? := false;;         me.edit_course_number.allow_resize_width? := false; <         me.edit_course_number.allow_resize_height? := false;  K         buttons := create_with_entries(Button_bar_frame, "middleButtonBar",                          f,8                         {action(Menu_description, "add",E                             me, "Add", "do_add_students", {}, is_me), ;                          action(Menu_description, "delete", J                             me, "Delete", "do_delete_students", {}, is_me)                         },                         me);    5     ! make the attachments to keep everything aligned 0         set_child_offset(f, buttons, Frame_Left,O                             f.default_horizontal_offset);   !@@@ bug workaround /         set_ch                                                                                                                                                                                                                                                                           ` $      TRELLIS010.D                   8  b:  3[SYSMGR.SEAS$WORK_0000077F]STUDENT_TOOLS_DEMO.TRE;2                                                                            O                             
 "             ild_offset(f, buttons, Frame_Top, M                             f.default_vertical_offset);   !@@@ bug workaround 9         attach_to_me(f, Frame_Left, buttons, Frame_Left); 7         attach_to_me(f, Frame_Top, buttons, Frame_Top);   
     ! set row I         buttons2 := create_with_entries(Button_bar_frame, "setButtonBar",                          f,?                         {action (Menu_description, "setCourse", <                             me, "Set Course", "set_course", =                                                    {}, is_me)o                         },                         me);    ;         attach_to_me (f, Frame_left, buttons2, Frame_Left);T1         attach_to_sibling(f, buttons2, Frame_Top,c4                              buttons, Frame_Bottom);1         set_child_offset(f, buttons2, Frame_Left,sO                             f.default_horizontal_offset);   !@@@ bug workaroundn0         set_child_offset(f, buttons2, Frame_Top,M                             f.default_vertical_offset);   !@@@ bug workarounde  >         attach_to_sibling(f, me.edit_course_number, Frame_Top,2                              buttons2, Frame_Top);?         attach_to_sibling(f, me.edit_course_number, Frame_Left, 4                              buttons2, Frame_Right);J         attach_to_me (f, Frame_Right, me.edit_course_number, Frame_Right);           apply_changes(buttons);t            apply_changes(buttons2);         apply_changes(f);g         return f;p     endr  ' operation create_edit_student_tool (me)      ! Return a Tool_subwindow      returns (Tool_subwindow)     subtype_visiblem     is	     begine*         var w: Attachable_work_area_frame;          var win: Tool_subwindow;%         var buttons: Work_area_frame;a,         var middle_buttons: Work_area_frame;  5             ! If we already have a window, re-use it.a  )         type_case me.edit_students_windown              on Tool_subwindow do(                 !manage(selector_value);/                 update_student_list_frame (me);i&                 return selector_value;             otherwise do;l         end type_case;  %         win := create(tool_subwindow,n-                                 "EditPrompt",o*                                 me.window,3                                 "Edit Students...", 4                                 "Edit Student", me);  =         w := create(Attachable_work_area_frame, "main", win);           win.workarea_frame := w;         w.border_width := 0;         win.size := 250@300;         apply_changes(w);e           ! the list frameE         me.edit_students_frame := create (Sorted_list_frame[Student], 8                                      "typelist", w, {});1         me.edit_students_frame.border_width := 1;_G         attach_to_me (w, Frame_Top, me.edit_students_frame, Frame_top);,H         attach_to_me(w, Frame_Left, me.edit_students_frame, Frame_Left);J         attach_to_me(w, Frame_Right, me.edit_students_frame, Frame_Right);.         apply_changes(me.edit_students_frame);    #         ! the bottom set of buttons_H         buttons := create_with_entries(Button_bar_frame, "buttonBar", w,3                     {action(Menu_description, "ok",eA                         me, "OK", "do_edit_student", {1}, is_me),(6                      action(Menu_description, "apply",D                         me, "Apply", "do_edit_student", {2}, is_me),6                      action(Menu_description, "reset",D                         me, "Reset", "do_edit_student", {3}, is_me),7                      action(Menu_description, "cancel",nD                         me, "Cancel", "do_edit_student", {4}, is_me)                     },                     me);=         attach_to_me(w, Frame_Bottom, buttons, Frame_Bottom); 1         attach_to_nothing(w, buttons, Frame_Top);{9         attach_to_me(w, Frame_Left, buttons, Frame_Left);a;         attach_to_me(w, Frame_Right, buttons, Frame_Right);s         apply_changes(buttons);n  #         ! the middle set of buttons @         middle_buttons := create_edit_middle_button_bar (me, w);<         attach_to_sibling (w, middle_buttons, Frame_Bottom, 7                                    buttons, Frame_Top); 8         attach_to_nothing(w, middle_buttons, Frame_Top);@         attach_to_me(w, Frame_Left, middle_buttons, Frame_Left);B         attach_to_me(w, Frame_Right, middle_buttons, Frame_Right);&         apply_changes(middle_buttons);    C         attach_to_sibling (w, me.edit_students_frame, Frame_Bottom,s;                                 middle_buttons, Frame_Top);s/         apply_changes (me.edit_students_frame);                   apply_changes(w);_         apply_changes(win); '         me.edit_students_window := win;          return win;i     endd   operation create_menu_bar(me)      returns (menu_bar_frame)
     public     is	     begin          var mb: menu_bar_frame; +         var file_menu: menu_bar_menu_frame;f+         var edit_menu: menu_bar_menu_frame; +         var view_menu: menu_bar_menu_frame;x  ;         mb := create(menu_bar_frame, "menubar", me.window);e  L         file_menu := create(menu_bar_menu_frame, "fileMenu", mb.menu_frame);<         add_menu_items(me, file_menu, me.file_menu_entries);+         add_submenu(mb, "File", file_menu); !         apply_changes(file_menu);i  L         edit_menu := create(menu_bar_menu_frame, "editMenu", mb.menu_frame);<         add_menu_items(me, edit_menu, me.edit_menu_entries);+         add_submenu(mb, "Edit", edit_menu);r!         apply_changes(edit_menu);   L         view_menu := create(menu_bar_menu_frame, "viewMenu", mb.menu_frame);<         add_menu_items(me, view_menu, me.view_menu_entries);+         add_submenu(mb, "View", view_menu);)!         apply_changes(view_menu);u           apply_changes(mb);         return mb;     endd   operation delete_course (me)     is	     begine         clear_status (me);7         var indexes_of_selections: Sequence[Integer] :=r,             me.course_list.selected_indexes;,         if indexes_of_selections.empty? then.             show_user_error(me, "NoSelection",?                                 "Please select a course.", {});              return;E         end if;d  <         for i: Integer in elements(indexes_of_selections) doD             var item: course := me.course_list.associations[i].item;,             if item = me.current_course then)                 me.current_course := nil;              end if;"'             remove (all_courses, item);e=             change_status(me, "deleted " & item.course_name);          end for;         update_display (me);     endn   operation do_add_students (me)     is	     begint            ! first get the course         var c: Course;(         type_case me.edit_current_course             on Course do$                 c := selector_value;             otherwise do2                 show_user_error(me, "NoSelection",C                                     "Please select a course.", {});u                 return;h         end type_case;  '         var students: Sequence[Object]; -         ! Next get a list of students to add. +         students := force(Sequence[Object],sN                            return_selection_as(tool_environment.tool_manager, 7                                     Sequence[Object]));_           ! now add them0         for ob: Object in elements (students) do             begint.                 take (c, force (Student, ob));:                 ! log entry {add, to course, this student}>                 add_first (me.modifications_log, {1, c, ob});              except$                 on Already_there do;             end;         end for;'         update_student_list_frame (me);e     except )=         on Cant_return_that_type, No_selection, Cant_force doc5             show_user_error(me, "NoStudentSelection",f;                 "Please select one or more students.", {});_     endw  ! operation do_delete_students (me)n     is	     begin          ! first get the course         var c: Course;(         type_case me.edit_current_course             on Course do$                 c := selector_value;             otherwise do2                 show_user_error(me, "NoSelection",C                                     "Please select a course.", {});:                 return;0         end type_case;  '         var students: Sequence[Object];e-         ! Next get a list of students to add.r+         students := force(Sequence[Object], N                            return_selection_as(tool_environment.tool_manager, 7                                     Sequence[Object]));a           ! now delete themd0         for st: Object in elements (students) do                                                                                                                                                                                                                                                                                        <qU $      TRELLIS010.D                   8  b:  3[SYSMGR.SEAS$WORK_0000077F]STUDENT_TOOLS_DEMO.TRE;2                                                                            O                                   1       begin 2                 withdraw (c, force (Student, st));?                 ! log entry {delete, from course, this student}m>                 add_first (me.modifications_log, {2, c, st});              except                  on Not_found do;             end;         end for;'         update_student_list_frame (me);      except _=         on Cant_return_that_type, No_selection, Cant_force dot5             show_user_error(me, "NoStudentSelection",t;                 "Please select one or more students.", {});p     ende  / operation do_edit_student (me, action: Integer)      is	     begin(         case action,!             on 1 do          ! ok                   ! close the toolG                 close (force(Tool_subwindow, me.edit_students_window));a!                 apply_edits (me);w$             on 2 do          ! apply!                 apply_edits (me);=$             on 3 do          ! reset                  undo_edits (me);/                 update_student_list_frame (me);b%             on 4 do          ! cancelt                  ! close the toolF                 close(force(Tool_subwindow, me.edit_students_window));                  undo_edits (me);             otherwise do;)         end case;h     endn   operation do_select_all(me)t#     ! Select all items in the list.n     is	     begin_*         select_all_items (me.course_list);     end    operation edit_course (me)     is	     begin          clear_status (me);8         if me.course_list.selected_indexes.size > 0 then*             var selected_course: course :=,                 me.course_list.associations[@                     me.course_list.selected_indexes.first].item;1             me.current_course := selected_course;a             update_display(me);h"             change_status(me, "");         else.             show_user_error(me, "NoSelection",?                                 "Please select a course.", {});          end if;      end0   operation edit_students (me)     is	     begin O         display_in_default_position (create_edit_student_tool (me), me.window);z     end:  / operation find_course (mytype, number: Integer)t     returns (course)     signals (not_found)h     is	     beginF3         for st: course in elements (all_courses) doo@             if st.course_number = number then return st; end if;         end for;         signal not_found;,     endp  + operation return_selection_as (me, T: type)      returns (Object)#     signals (Cant_return_that_type)(     is	     beginF         case me.selector              on me.course_list do/                 ! return course as string namesr,                 var sel: Dyn_seq[Object] := -                     create (Dyn_seq[Object]); ,                 var seq: Sequence[course] :=+                     force(Sequence[course], =                           return_selection_as(me.course_list, A                                               Sequence[course]));a2                 for st: course in elements(seq) do.                             add_last(sel, st);                 end for;=                 return translate(Trellis_translator, sel, T);(             otherwise do;          end case;r3         return return_selection_as(me.selector, T); 
     except1         on No_selection, Cant_return_that_type dor)             signal Cant_return_that_type;r     end?   operation save_course (me)     is	     begini         clear_status (me);         var new_course: course;=#         type_case me.current_coursem             on course do-                 new_course := selector_value;o             on Null do9                 new_course := create (course, 0, "", "");m1                 insert (all_courses, new_course);a0                 me.current_course := new_course;         end type_case;%         save_values (me, new_course);p         update_display (me);=         change_status(me, "saved " & new_course.course_name);_     endm  % operation save_values (me, c: course)      private      is begin
         begin;O           c.course_number := read_string_form (Integer, me.number_prompt.text);          except           on Bad_format do?             change_status (me, "course number has bad format");e-             show_user_error(me, "BadFormat",  E                                 "Course number has bad format.", {});l         end;-         c.course_name := me.name_prompt.text;s+         c.classroom := me.room_prompt.text;b     endt   operation set_course (me)e%     ! called from the edit sub windowh     is	     begin          var o: Object;         var c: Course;
         begin"%             o := return_selection_as  ;                    (tool_environment.tool_manager, Object);t         except'             on Cant_return_that_type do )                 o := return_selection_as  ;                    (tool_environment.tool_manager, string);)I                 o := find_course (Course_tool, read_string_form (Integer, .                           force (String, o)));         end;         c := force (Course, o);n  $         me.edit_current_course := c;D         me.edit_course_number.text := string_form (c.course_number);.         apply_changes (me.edit_course_number);'         update_student_list_frame (me);e
     exceptH         on Cant_return_that_type, No_selection, Not_found, Bad_format do.             show_user_error(me, "NoSelection",?                                 "Please select a course.", {});l     end(   operation show_students (me)     is	     begine         clear_status (me);8         if me.course_list.selected_indexes.size > 0 then*             var selected_course: Course :=,                 me.course_list.associations[@                     me.course_list.selected_indexes.first].item;D             create (student_course_tool, selected_course.attendees, F                         "Students in " & selected_course.course_name);         else.             show_user_error(me, "NoSelection",?                                 "Please select a course.", {});_         end if;      endi   operation shutdown (me)r     is	     begini"         shutdown (Trellis_system);     endu   oper 
     =       ation undo_edits (me)u     is	     begineC         ! we put the actions in the list in reverse order so now we:8         ! just play them back and do the opposite actionE         for s: Sequence[Object] in elements (me.modifications_log) dot           begina&             case force (Integer, s[1])7                 on 1 do   ! did an add so delete it now 4                     withdraw (force (Course, s[2]), <                                      force (Student, s[3]));6                 on 2 do   ! did a delete so add it now0                     take (force (Course, s[2]), <                                      force (Student, s[3]));                 otherwise do;              end case;m           except+             on Not_found, Already_there do;:           end;         end for;=         me.modifications_log := Dyn_seq[Sequence[Object]]'{};m     end_  ! operation update_course_list (me)u     privatet     is	     begino-         changed_make_visible(me.course_list,  :                       update_course_list_no_display (me));     end,  , operation update_course_list_no_display (me)     private}     returns (Integer)      is	     begin(1         var list: Dyn_seq[Association[Course]] := A                             create(Dyn_seq[Association[course]]); '         var make_visible: Integer := 1;;          var index: Integer := 0;2         for st: course in elements(all_courses) do             index := index + 1; ;             var description: String := action_text(me, st);wE             !   Is this the current course? If so, mark it specially. %             if st = me.current_coursef             then&                 make_visible := index;2                 description := "->" & description;             else2                 description := "  " & description;             end if;r-             var assoc: Association[course] := =                 create(Association[course], description, st);i#             add_last (list, assoc);          end for;,         me.course_list.associations := list;         return make_visible;     end_   operation update_display (me)      private      is	     begin #         type_case me.current_courseb             on course do)                 me.number_prompt.text := TI                               string_form (selector_value.course_number);lB                 me.name_prompt.text := selector_value.course_name;@                 me.room_prompt.text := selector_value.classroom;             otherwise do,                 me.number_prompt.text := "";*                 me.nam                                                                                                                                                                                                                                                           M* $      TRELLIS010.D                                                         
hg`EKUEe5{
LWuK&$eRE;1                                                                  .                              P6     w       Rpc>iQ@.J9<OT0S IphLUVc[\AS1@UNm|V8#	6a,r-#[:tNx~pC h~gS.) q ceQH*W? eR
$+uU/ gQC~I1(	WGz%Q=Rdh
*}eT$quKA>En2~Wtq`3v,?fz((IeK$YS ]Sqj%2GQzB%#N{_4'(ǃj1%rO]g{+ eiN4nXDk,7''^ e 33od43wPNvJڂJN`F:j_d:V0K,7 I]6<S'j+Z;Jq?"s8@.eZG]%s[6D`>4akor&2x}
Cy/ceRS{ fL/*o1
{^$T<odha~n&j\@Tu1@[kyGC+Y`jL3)D
zjap/{SYEejy#[n	  /|Uay3joa`:%WC`DjMq5I-RC5x0>1t	'__^xrYm%pSJx&|fm9N;ffA}Apxm8G`(5,g,wGq*a1F[BQ B	J!Ly3]qH5r ti>IIA{eT,vY#SQcp#j?OR<r1Kg[wC%`snI({-
Cj$*/-;i| mSl^mRjPR?_v'OizI;hSN:pnrqabQ;v,
F6%&$/PxpA(k//cT>o2m#FU_RWQ?6	edy#]R#Q]""7!C4%Pf}#9
pI:@VO8Mo"2~=>  xhe<-*b$8\cv>zLBr,INHeMix`h&m*@; 7vQb87-{-{&ViQ(dO	(%Qg)j0Mi+4)Kj<1!&]X5}f8d'.l})HQ Pm<M_"LZ0f;D3~PRP/j%Z$X"CjI%=s7.
_Tpj-Xp	&_X%:Z_ahiDTEqsgEs<gF])\7SPi	\O'>C5x|xg0j.<YQfaXo6jn&Amlms
-p.>e5vcH(VWjh
nt	l"8U*!
+mTCKjEP3qOK]p;XYI)06FeJQf1Gd
2[N	!`p 51H?Rvy<]CgCBFEra+1KQ?	:+`h-&%m-Oz*TwD0\%K 
^[|54#<zj@v(^cF8GP
hWM$=1p7M6ay.RU=!` }3GGGffI"bՃl9X3_%@)eq]'3%2,+k4}1!8rjKeR;xK%pK@QH9iFSW*^(,,+(&JN3@ /n7QAt|ZQFw5&3ZIk/LIn_M'mkKP<o1'0q#i,)U/uC`7`yg*O@kP+UMG,6\ojvS}c:ReP~9eC;r']*u*eT,Z+njc6c~tye2o}-VPSb]O|?@kgxL`7G%$%p#t"I8:vzDjYZ m-TgIpBa]T6sN-s_@7WPcP.C\weje_ogS=$k`=f=5DR1~g=~|P'dM?/*
E2[\	s%d^e%#YQHuzU"9.\Z%9fFUuhi1m+h^G:8O~b8[|ZIAs]MA pYF}-F ONM\x Pv5!.CUO3i
^aQzwD8g#}UA|4}VooC	uU_0 e(i~U|S$6GgK=S(I="
xqf;|jޫ
t28
f5$CvkKJ!i Gk.7++,Y7Y_\_ԇEZZl%t "AA
.?S[FhGI^Q/|bF)`6ݰ^'Zm-]f0b9TE#T>8mM+0)<))*xwV*q|H~I@wocL<GS$gz="IS6<=gOC.a,XT!:o5?3OcA:%R?tL
A>5D6^og_TY0&"-',h<r+<_IqS;.p]AsnK;4xD7JZhK< JSb*UuN=I<LvSU=
iodLmh.DKky~V:poZh!L /3IJs$yKM.q!a#5}(nSR)[|nJ	5w|sq
wc=iWo0#
*fZBV5f=G=Z&
GV,FW!	x9 j ApL(G/Pm>H%d+HJ$K ek({0A>k *6^f`X<%n@[OPz >O[!0gXm2QB)qP4 |4zNVK
['T7P=$B[gV&F
F`%Dn1u:KH_?Yw'10IE%
eWP'F09.Zw/Nq?PE% c=.K+=>c,?5{KyF%m) r?dpjX&wZt`1\K9E
yl
Ga^h]LHuN@}\
~
3+aRi_(<M9c8I
]M q_3OY9G_?`4.YWE!K]/iv
rWe Jq&Iu	Z;JCaX
 #cZ-k%D<F/Mlz4@`5eC[
"[A4mE
XP6]eB~ZE?p~Kv qY1Xev54/
QF)yGxkk2h6 M'-se.PbSJ+vM-#fNx0E_a'g
-.&\>
\U7KA.
j7h*rz[F$(-RCj"Shgu)(G.!>V4w;Op6?xI-1?rc2oMSh4\; dZ?a)v@^P0-eh?b
JL9H@Mu1i|82L>+0.1%pEh
&B1>n49Bep(tt	 =px|'vB	dh	DdGh
{ErZY/:O9%`
Vn8L5'!RKetM)'9
h<znB)Eb(6#1|^wsNb	"4?oo3P4M/#F(;$+'['{L94tb=C8|q u~FvTd:mfgo`	zI6l_<?Z;*9UXH06JVKq(YW"_Dj}x^H|%\,-{=z<>K=vg%F;]t,_7fO>&wrU;qd`ULXJ\DMedq!},eQr%6%$Y&9D)4V2927UXjX}J5HTnDsBfZQavh|EkmrOA=Zkv`_x+(
|<'Cn#K=G:Vk
+gI( _w6F<$)
Z7?LRF+_X?bgD2s4@U0h=m1Ywl9w@bDND={`sa 5"A*h}Ii4?͢Oe(ov3B3Ru":Y:{9+r=fY5mj+JjQ3 (zU#7i-.q[NzA^2DDQaOZLW\kr+~u(['I+9@MH&2 5iuKG??,/}`x].!
TS*W#</wkXZM]kyNZyYKg&)AX}*)UL/X:taE[1H	enA7 H8i	DK`1**k"o)e^
~y	 hG5C=%{=TCq9"}Y1O
^ey:,{Yo'|lf0&jqG!ii8t~:~[Sh?+=;-y
dB'{Ri!2?8HURE:"Lw-g{s
zb!(rU7>/n-:{c.gd-{#mG)F.!p(/%+P`):	l-#~N'o`RCrm,75m=SN/b9f~ec,t,x!j JH4:_K],$M8\yu[uv
4E@4az_>/&ni%U4Hi3)AABI
o.wBu4`E.LnCf;x%@ E'LvlY.iZ9u\Ln3 D[_b:)8GPJ[r.7$e8I!`#R*za)1
io/Ky;c9|l':ft(of	8#-utbw[fq:K7vME([f|	Q*JQs(vt?6G2	Q~>oIyN/JT_ 8v-vzGfu{cV
+t"AigA.=7-|bU	Vd$RQ'wI{COF-DfF"yOM^Y5|w"bM</*@Jy.yuO?}~1
iLF,-'<[J}7{ACFE)"at+1
0[l$H208`0P/3oL0oavw=C)G
Pg{
~)Fq>ASq3pG3ns@/lwvi)]9IQ8Q"dzQcvmA=3l8@Y$=s6_f:-B[O
x	9'G]g/{Tmi9|y}Li-}!%OK0 yC?p-&'oVZ@PS`B*96VZ~>TKtXnCm*\/rL3'wv
J?7D:7c}iPU
0(Rx~DG}/%3}{M^_"!jg	n~rQi1?SK`9|Sb
oE5Zy;{	t;q,[p&KgH;k=b%^G	(9ZEN.9mvEU%
~  HGC'n&m|
Uj|aB=a}E;eK\4,)M.a)~RTdZg/[.JM=oCB#"-K93ODnIV*BB!JN H+ufQv+Q ~e7XLr5>? ]:B IIRcd6>%uOXp9S&qyqp|N{5"U,]p~4s?JiNeR\_coV7aLsU  gr){e:}s*X$v:?+>w9Pr.Eo7$W2Dz"q{Jyi2Q-]@^N&
5zj`nW@`/WCfHI3$>#_G=~-Up*#-p3
9q`2~<DNe0 gPPvvnE7+XiwJW T0g,14xs=LqOC#;d`sT&aN|l><288@x=o^6f$JJn1!3Z
 
<oB!
h45+h80jxDrW{5MBFUz^5~+18t)a>3E ;[eJN,:5[hhXB`5Nh]*X%
bcv*bhVFU%'>:k9G3Vk/"U*O*)}W8N8v|	Jb#izm4?{K	R	wJf]T Di}Go\isPHWdW8vvzA&[[L2Rl 3eDY(hL[_Fh)s#<S$g@ALDN	xG3~OC:	m:HqF
$a@?]n!dHe^%xC	B5-	{/7@\eZDvM$hsCW!HU{;2aE2^I90#
VvAO7fK6Ki	GN/6t]e,hUUiDt)7)D:J7"V8zJ4"_$B*4,;Ia*d%~C6ur6#9

L' {U FDdL&h"JGi}i
9H}8t^P8@<]("`"3hyOhk0pC&5''/j\SPXJMz <q_d?"	vT"yaC0wD~5Q &H"Hk[b8	gZz}w[O}SJyxUT 8m7&t#`Kw|z~?G"A
D$^?r*D`n=IV(k:\[l? < !-OF"t
Bn@cA$F[eLK!}L?Bu$bBWa4ouQQ09<s"kh+VqXMG/IV<l3-8/>m	w*$u9J; I{FE\RLv#=}+IJxy'[d( D vq@| @o2r[rAfMvKq{6
Y'0xc)m4wK~Q7bW\~\=bM2(/X+%-X
o50l&U"50_g=8p9kNwQ#P< >U,=q9(OVW=jz7v"MccB/T8,xixJy$83BJ'^/EF,'y}nlS'7qtPQ+DuE3/5TuWQzO?%#w|<}Td?O-$:bl/MRZv`H|R[_8XOf`,vG|pc	(@
kTSjW7ff&e6UC8J'$
">6txY	A'IR 1]OdQhf2ct
<n.zJi'T6om}q{z=sxUwxBa}Nn&55wXE4fl9J=COVtB-tbG;
O|fE*_YEI+:M] JgzEuA1%0B'vx}tO1l'As
N~:dUxZs]g?.pu;\o6QiOs->
&>25**5)#S[F &/bw
|}yJcP>X]CdM*+X42zM!0f{Cm?B@swm&pwXh[_A.;)yIQ4@oFR[s^qODY=G/JqvW0#@jYv$#7	;p E	1
pyZ6+~0BD{\%Mk?b+oy6orgG
@h2N'?q`k^^q_CP'<76
7[0^ZT580l!e({i<RQYbsv^=
OKJ6
!m;9Y*M]D4NpƁHsM)j0_7G{K?#OjmCsI"<q'[Zw{/u>-@z80=l\&hzFmG1~imaCP/y)
oI>v2%ht$x7G	w%W3D:g?|g "H{gXva9+-K#EZ]
ADQ`4|'U7i f`uH*JrX]}[BnWfj?t. @ktIS@L*ej7VUZJ[MHjuk'ENBhT+Q&8uEh8;1|-
,`6@]DW
blD,l5`	&>hrQZq`2iK~kytm!%4UM v!w:
%Jo_-1L<.b}TexP^
BgU=eo
Ya9a}:KA r$4oCysS|N8T%N
;ET#
MKt;
:z(/KZ#yE56V3~e?<c-4uQ[QF
b\p2eu7)Q+lyA1fvY(	rs8	ZNk}f&0}=|-tAcB&?H||*Ip
0}lrGx\KB98>W+FFl,{/U'KI_Eq@	%8K<vO=^!&
]yw>5ng|
D ,["=}E%2S"#rD-7-=+Od >Ly LgA{2\
LsfG;]ppL6M=_dM0_V}9.|1E S7}]c&g%cpLZ3O!aH"I%wg|:r#S(aBD5*pnRA?
wV^"#5u5pmxf56hI
QbYq*&>000) 
FH`GvnR;GG.$!'EM
TA%q?0mOi\a!BCfaU/(]M.DKBu^F
T_8GN$8byW:VRc^;:%T2:8I'1&biaOf~~S
ɖ8PTR!8$]6:Jutuy1r@rFG%B(^C'TxmOw%R'z,jPcA}5I/}?5]$іK,$f424h9/YR.:y Y/Eo(AR\I$*-Ij}\+B	hapr.@k-W)j8!^xg[(Fjx P5>uib+ioJt("[F+@6-06gt9mE#a~g<*]YK>{]ShBEF^)B.y9Wehq_f(T]s1XUq"a.Vbn[hHOU_B0Qb6Pw*a_[.{hlW%HI2np"mAvU~:qv!!5n#"m.o^L!xV_P;}Y'JmrU:,N2?Y^}H;y^W-fb['{^[ObntWb97'\`*J
0gZa
2 a?&JZD2XhJ[ORmI+=DUn :eYt}w]4N7f0a$JvT%5]x[\X_6|Kmb'BvpI4
0V#t[VrI8NS6N^
S&+UY}=;%l0Z%v"\¹><fx;Ve+"(ه~չ"M|$XSr/i%4!yQ/y]	fc;Ho>
9qh%sidSGRD>LG[}4(t`|z|\\iF?E)}u8l%#X~Sw O;
+
S2c~{VSaq Z6%pW _HpJp_333]d'i_LqCIp*Zq5[5VUH&rbe,ntx!y0~FSKEYC}3d4Eo9Q?f&=XT%VUWz=fWm2	S Yoy6EV|)!#iB4\L+wu291:gKG4:G'$<yr%#Z$H
\
mJS.gy:S
yUS+&*@l2[.<BTd
^Q
v_v1R((\m>b'_XL%fps
)T*(`$fm\5([54
|(	# J3uGo9CjW=1Y*w9"k~9;	R	pUs(Zwh&jYgisMEJs6/ZH=X~'
pw8V$2Whxz8i4afP''gy%jGnDKKf%D[q?f(zW\>~Owu`H{8-a!c)FT/:yF.KDBw'K&J0eawBHHjL|3yVY]<b-B?SoM#rF[* 4nD)tK$nwi@b/7bc94A;n)VYhM9nXu"H(0()e2Dao[2<:T
g}Z(VR1Ec]6i`}V'Ck[G*Y[DS"k#l"3d	{i;mjZjfOG4FNI?#9)NHh
?i2F aR}$Pk<h-\$t3CWA 2 F}@$:uEqSnrf8]Mv9^64;Tzmy1ih}?g@\2W2h6^XNp@_WJW}4a}44A =$erDge)Jq4\o<*,rKIiF|zjI]oNT82rrOW>^um)frL)E;M*?qUsqb>aOd?+9
PG;ICoI"8],6"G?H*htl?~lpx8*U1i|"Wq2 ?14m@tsK3[X*bePP%}qo RGABN%&M_+fNZ*`KiL8P@Ljpr7/p@+0sf
G=0?!+C@	g7Q'C eqw7o+\2[_5<NvA-kI&C	1}"t[w,t3IBs 2(N4[ lqPY?+TQbOB
(t |@@_78p*v>0~* Xs|rc!M@jgY|p1xGFQLt<#QXnD!x\A-J/S8*&DipCtq1}MXRY&&oB;X~$x^_"ra%\A8ohG@[~m[?\7!q"0{G\}0p+%~ZO(^lfG>MPlzU\&PCUk]
A`\.9Trx Bg)AZ~koDcpkC&>j'%hLhk$K=׏8L~g$T)(Zo]\To!eEM25EN fjkKW~?qrO{iE,}95PiH
HzY~hgyAyQD'3D?T#9IPsZM~la:EQI
 r1sd2^<ki g_f2dv^dXt{%
)\F
LK!I/2V"c.cS['tKL^ps:cg
jWAq)EAH-p:Y[>t
drLBVypw#.9M=u15yj[%oDH[6[CK=RTX~0cgbx?'b7/$zY  TIqg/ [M\P\EAEK$>U>S~IMES*CR:S [MS4imes.
details appears 1 times.
                                                                            E\ $      TRELLIS010.D                   8  b:  3[SYSMGR.SEAS$WORK_0000077F]STUDENT_TOOLS_DEMO.TRE;2                                                                            O                              "     B       e_prompt.text := "";*                 me.room_prompt.text := "";         end type_case;)         apply_changes (me.number_prompt);p'         apply_changes (me.name_prompt);c'         apply_changes (me.room_prompt);          update_course_list(me);g     end   ( operation update_student_list_frame (me)     privateF     is	     begin (         var c: Course := force (Course, /                        me.edit_current_course);g/         var s: Dyn_seq[Association[Student]] :=e7                 create (Dyn_seq[Association[Student]]);   6         for e: Enrollment in elements (c.attendees) do8                 add_last(s, create(association[Student],I                              short_display_form (e.student), e.student));          end for;1         me.edit_students_frame.associations := s;e;         changed_make_first_visible(me.edit_students_frame);t.         apply_changes(me.edit_students_frame);
     except         on cant_force do;e     end    end type_module; t type_module Employee     subtype_of (Person)c" component me.department: String        is field  ! component me.job_title: String   (     is field  ' operation create(mytype, name: String, o+                          birth_date: Time, n,                          married?: Boolean, &                          dep: String, &                          job: String )     returns (mytype)     override     is allocate 	     begin.6         Person'create(me, name, birth_date, married?);         me.department := dep;          me.job_title := job;     endi   end type_module; i type_module Enrollment component me.audit?: Boolean     is field   component me.course: Course        is field  $ component me.mark: Integer | null        is field   component me.student: Student      is field  $ operation create(mytype, c: Course, $                          s: Student,$                          a: Boolean,,                          m: Integer | Null )     returns (mytype)     is allocatei	     beginf         me.course := c;          me.student := s;         me.audit? := a;i         me.mark := m;r     endt  ! operation short_display_form (me)o     override     returns (String)@     is (me.student.name & " is taking " & me.course.course_name)   end type_module; e type_module Person component me.age: Integer        get_only/     get is (time.now.year - me.birth_date.year)    component me.birth_date: Time      is field  ! component me.married?: Boolean   t     is field   component me.name: String        is field  ' operation create(mytype, name: String,  +                          birth_date: Time,  ,                          married?: Boolean )     returns (mytype)     is allocatem	     beginF         me.name := name;$         me.birth_date := birth_date;          me.married? := married?;     endt  ! operation short_display_form (me)_     override     returns (String)     is (me.name)   end type_module;   type_module Studente     subtype_of (Person) % component me.courses: Set[Enrollment]t     is field   component me.grad_date: Time   i     is field  $ component me.student_number: Integer     is field  % operation assign_mark(me, c: course, h)                           mark: Integer )      signals (not_enrolled)
     public     is	     begin 7         for elt: Enrollment in elements (me.courses) doR"             if elt.course = c then!                 elt.mark := mark;i                 return;s             end if;s         end for;         signal not_enrolled;       end)  ) operation create(mytype, number: Integer,r'                          name: String, )+                          birth_date: Time, e,                          married?: Boolean, )                          grad_date: Time)(     returns (mytype)     override     is allocates	     begin 6         Person'create(me, name, birth_date, married?);$         me.student_number := number;"         me.grad_date := grad_date;/         me.courses := create (Set[Enrollment]);      end   1 operation enroll (me, c: course, audit?: Boolean)      returns (Enrollment)     signals (already_enrolled)
     public     is	     beginu7         for elt: Enrollment in elements (me.courses) do_C             if elt.course = c then signal already_enrolled; end if;          end for;H         var enr: Enrollment := create (Enrollment, c, me, audit?, nil); !         insert (me.courses, enr);e         return enr;      endn  ! operation short_display_form (me)p     override     returns (String)H     is ("no: " & string_form (me.student_number) & ", name: " & me.name)   end type_module; v type_module Student_course_tool      subtype_of (Tool) ) component me.context_frame: Text_frame   (     private      is field  " component me.default_title: String     get_only"     get is ("Student-Course Tool")  : component me.edit_menu_entries: Sequence[menu_description]     get_only
     get is
         begin =             return({disabled_action(menu_description, "copy",e>                             me, "Copy", "do_copy", {}, is_me),9                     action(menu_description, "selectall",.L                             me, "Select All", "do_select_all", {}, is_me)});         endx  4 component me.enrollment_list: List_frame[Enrollment]     privatea     is field  : component me.file_menu_entries: Sequence[menu_description]     get_only
     get is
         begin              return({2                  action(menu_description, "close",?                             me, "Close", "close", {}, is_me)});          ende  " component Mytype.base_name: StringI     ! The base name for the tool.  The actual name of the tool is created 8     ! when the tool is registered with the Tool_manager.     get_only      get is ("StudentCourseTool")  @ operation create (Mytype, seq: Set[Enrollment], context: String)     returns (Mytype)
     public     is allocate 	     begin *         var w: attachable_work_area_frame;%         var buttons: work_area_frame;c   	register_name(me);d;         me.window := create (tool_window, me.resource_name,tH                                 me.default_title, "Student-Course", me);C         w := create(attachable_work_area_frame, "main", me.window);          w.border_width := 0;         w.size := 300@120;         apply_changes(w); &         me.window.workarea_frame := w;  8         me.window.menu_bar_frame := create_menu_bar(me);  8         var assocs: Dyn_seq[Association[Enrollment]] := 8               create (Dyn_seq[Association[Enrollment]]);0         for enr: Enrollment in elements (seq) do?             add_last (assocs, create (Association[Enrollment],  B                                   short_display_form (enr), enr));         end for;    F         me.context_frame := create_rows_columns(text_frame, "context",9                                     w, 1, 20, "", false);.+         me.context_frame.border_width := 1;d(         me.context_frame.wrap? := false;6         me.context_frame.allow_resize_width? := false;7         me.context_frame.allow_resize_height? := false; B         attach_to_me(w, Frame_Left, me.context_frame, Frame_Left);D         attach_to_me(w, Frame_Right, me.context_frame, Frame_Right);@         attach_to_me(w, Frame_Top, me.context_frame, Frame_Top);=         attach_to_nothing(w, me.context_frame, Frame_Bottom);e)         me.context_frame.text := context;u(         apply_changes(me.context_frame);  <         me.enrollment_list := create(list_frame[Enrollment],:                                     "enrList", w, assocs);-         me.enrollment_list.border_width := 1;o;         attach_to_sibling(w, me.enrollment_list, Frame_Top, =                              me.context_frame, Frame_Bottom);dD         attach_to_me(w, Frame_Left, me.enrollment_list, Frame_Left);F         attach_to_me(w, Frame_Right, me.enrollment_list, Frame_Right);H         attach_to_me(w, Frame_Bottom, me.enrollment_list, Frame_Bottom);*         apply_changes(me.enrollment_list);           apply_changes(w); %         make_default_size(me.window);c!         apply_changes(me.window);h&         start_up_with_breakpoints(me);         display(me);     endt   operation create_menu_bar(me)      returns (menu_bar_frame)
     public     is	     begin          var mb: menu_bar_frame;t+         var file_menu: menu_bar_menu_frame; +         var edit_menu: menu_bar_menu_frame;   ;         mb := create(menu_bar_frame, "menubar", me.window);   L         file_menu := create(menu_bar_menu_frame, "fileMenu", mb.menu_frame);<         add_menu_items(me, file_menu, me.file_menu_entries);+         add_submenu(mb, "File", file_menu); !         apply_changes(file_menu);b  L         edit_menu := cre                                                                                                                                                                                                                                                                           V $      TRELLIS010.D                   8  b:  3[SYSMGR.SEAS$WORK_0000077F]STUDENT_TOOLS_DEMO.TRE;2                                                                            O                             i "     S       ate(menu_bar_menu_frame, "editMenu", mb.menu_frame);<         add_menu_items(me, edit_menu, me.edit_menu_entries);+         add_submenu(mb, "Edit", edit_menu); !         apply_changes(edit_menu);a           apply_changes(mb);         return mb;     endt   operation do_select_all(me)s#     ! Select all items in the list.s     is	     begin .         select_all_items (me.enrollment_list);     end    operation test (Mytype);& ! the operation that gets things going     is	     begin !         start (tool_environment);u         create (student_tool);         create (course_tool);      end    end type_module; _ type_module Student_tool     subtype_of (Tool)s: define all_students: Set[Student] := create (Set[Student])  ) component me.birth_date_label: Text_labele     is field  * component me.birth_date_prompt: text_frame     is field  ; component me.button_bar_entries: Sequence[menu_description]      get_only
     get is
         begin              return({4                     action(menu_description, "edit",?                         me, "Edit", "edit_student", {}, is_me),n4                     action(menu_description, "save",?                         me, "Save", "save_student", {}, is_me),s5                     action(menu_description, "clear",u8                         me, "Clear", "clear", {}, is_me)                    });         endo  / component me.current_student: Student | Null   O     privatei     is field  " component me.default_title: String     get_only     get is ("Student Tool").  : component me.edit_menu_entries: Sequence[menu_description]     get_only
     get is
         beginc4             return({action(menu_description, "copy",N                         me, "Copy", "copy_selection_to_clipboard", {}, is_me),9                     action(menu_description, "selectall",(H                         me, "Select All", "do_select_all", {}, is_me)});         end   & component me.error_text: Text_frame        private      is field  : component me.file_menu_entries: Sequence[menu_description]     get_only
     get is
         begino             return( 0                 {action(menu_description, "new",@                             me, "New", "create", {}, is_mytype),2                  action(menu_description, "close",=                             me, "Close", "close", {}, is_me),u5                  action(menu_description, "shutdown",;H                             me, "End session", "shutdown", {}, is_me)});         endn  ( component me.grad_date_label: Text_label     is field  ) component me.grad_date_prompt: text_frame_     is field  & component me.married_label: Text_label     is field  ' component me.married_prompt: text_framer     is field  # component me.name_label: Text_label      is field  $ component me.name_prompt: text_frame     is field  % component me.number_label: Text_labelc     is field  & component me.number_prompt: text_frame     is field  . component me.student_list: List_frame[Student]     privater     is field  : component me.view_menu_entries: Sequence[menu_description]     get_only
     get is
         begin              return(,1                 {action(menu_description, "edit",wK                             me, "Edit Student", "edit_student", {}, is_me),r1                  action(menu_description, "save",oK                             me, "Save Student", "save_student", {}, is_me),t3                  action(menu_description, "delete",lO                             me, "Delete Student", "delete_student", {}, is_me), ;                  separator (menu_description, "separator"),t2                  action(menu_description, "clear",=                             me, "Clear", "clear", {}, is_me),t1                  action(menu_description, "show",_M                             me, "Show Courses", "show_courses", {}, is_me)});          end_  " component Mytype.base_name: StringI     ! The base name for the tool.  The actual name of the tool is created 8     ! when the tool is registered with the Tool_manager.     get_only     get is ("StudentTool")  - operation action_text (me, n: Student | null)      returns (String)     privater     is	     begins         type_case n)             on Student doC- 		return short_display_form (selector_value);B             otherwise do                 return "";         end type_case;     end   ! operation change_action_line (me)l     is	     begint$         type_case me.current_student             on Student do('                 change_status (me, "");i)                 update_student_list (me);t             on Null do                 ;u         end type_case;     end   ) operation change_status (me, str: String)s     private      is	     begind(         me.error_text.text := str & eol;&         apply_changes (me.error_text);     endc   operation clear (me)     is	     begin          clear_status (me);"         me.current_student := nil;         change_status(me, "");         update_display (me);     endi   operation clear_status (me)      privatei     is	     beginn!         me.error_text.text := "";r&         apply_changes (me.error_text);     end    operation create (Mytype)      returns (Mytype)
     public     is allocatea	     begin *         var w: attachable_work_area_frame;%         var buttons: work_area_frame;a  "         me.current_student := nil;   	register_name(me);e;         me.window := create (tool_window, me.resource_name,iB                                 me.default_title, "Students", me);C         w := create(attachable_work_area_frame, "main", me.window);          w.border_width := 0;         w.size := 300@250;         apply_changes(w);2&         me.window.workarea_frame := w;  8         me.window.menu_bar_frame := create_menu_bar(me);     ! get students5         var assocs: Dyn_seq[Association[Student]] := _5               create (Dyn_seq[Association[Student]]);e5         for st: Student in elements (all_students) do <             add_last (assocs, create (Association[Student], @                                   short_display_form (st), st));         end for;  (     ! set up the number label and promptG         me.number_label := create_with_label (Text_label, "numberl", w, ?                                              "Student Number");[A         attach_to_me(w, Frame_Left, me.number_label, Frame_Left);q?         attach_to_me(w, Frame_Top, me.number_label, Frame_Top);;;         attach_to_nothing(w, me.number_label, Frame_Right); <         attach_to_nothing(w, me.number_label, Frame_Bottom);'         apply_changes(me.number_label);o  F         me.number_prompt := create_rows_columns(text_frame, "numberp",9                                     w, 1, 30, "", false); +         me.number_prompt.border_width := 1; (         me.number_prompt.wrap? := false;6         me.number_prompt.allow_resize_width? := false;7         me.number_prompt.allow_resize_height? := false; D         attach_to_me(w, Frame_Right, me.number_prompt, Frame_Right);@         attach_to_me(w, Frame_Top, me.number_prompt, Frame_Top);:         attach_to_sibling(w, me.number_prompt, Frame_Left,>                                 me.number_label, Frame_Right);=         attach_to_nothing(w, me.number_prompt, Frame_Bottom); (         apply_changes(me.number_prompt);  &     ! set up the name label and promptC         me.name_label := create_with_label (Text_label, "namel", w,_=                                              "Student Name");s?         attach_to_me(w, Frame_Left, me.name_label, Frame_Left);=6         attach_to_sibling(w, me.name_label, Frame_Top,@                                 me.number_prompt, Frame_Bottom);8         attach_to_sibling(w, me.name_label, Frame_Right,>                                 me.number_label, Frame_Right);:         attach_to_nothing(w, me.name_label, Frame_Bottom);%         apply_changes(me.name_label);   B         me.name_prompt := create_rows_columns(text_frame, "namep",9                                     w, 1, 30, "", false); )         me.name_prompt.border_width := 1; &         me.name_prompt.wrap? := false;4         me.name_prompt.allow_resize_width? := false;5         me.name_prompt.allow_resize_height? := false; B         attach_to_me(w, Frame_Right, me.name_prompt, Frame_Right);7         attach_to_sibling(w, me.name_prompt, Frame_Top, @                                 me.number_prompt, Frame_Bottom);8         attach_to_sibling(w, me.name_prompt, Frame_Left,<                                 me.name_label, Frame_Right);;         attach_to_nothing(w, me.name_prompt, Frame_Bottom);e&         apply_changes(me.name_prompt);  ,     ! set up the birth date label and promptJ         me.bir                                                                                                                                                                                                                                                                           j]Ŏ $      TRELLIS010.D                   8  b:  3[SYSMGR.SEAS$WORK_0000077F]STUDENT_TOOLS_DEMO.TRE;2                                                                            O                             r "     d       th_date_label := create_with_label (Text_label, "birthl", w,;                                              "Birth Date");oE         attach_to_me(w, Frame_Left, me.birth_date_label, Frame_Left);T<         attach_to_sibling(w, me.birth_date_label, Frame_Top,>                                 me.name_prompt, Frame_Bottom);>         attach_to_sibling(w, me.birth_date_label, Frame_Right,<                                 me.name_label, Frame_Right);@         attach_to_nothing(w, me.birth_date_label, Frame_Bottom);+         apply_changes(me.birth_date_label);   I         me.birth_date_prompt := create_rows_columns(text_frame, "birthp",:9                                     w, 1, 30, "", false);l/         me.birth_date_prompt.border_width := 1;n,         me.birth_date_prompt.wrap? := false;:         me.birth_date_prompt.allow_resize_width? := false;;         me.birth_date_prompt.allow_resize_height? := false;eH         attach_to_me(w, Frame_Right, me.birth_date_prompt, Frame_Right);=         attach_to_sibling(w, me.birth_date_prompt, Frame_Top,a>                                 me.name_prompt, Frame_Bottom);>         attach_to_sibling(w, me.birth_date_prompt, Frame_Left,B                                 me.birth_date_label, Frame_Right);A         attach_to_nothing(w, me.birth_date_prompt, Frame_Bottom);y,         apply_changes(me.birth_date_prompt);  )     ! set up the married label and promptsI         me.married_label := create_with_label (Text_label, "marriedl", w,n?                                              "Married? (t/f)");rB         attach_to_me(w, Frame_Left, me.married_label, Frame_Left);9         attach_to_sibling(w, me.married_label, Frame_Top,sD                                 me.birth_date_prompt, Frame_Bottom);;         attach_to_sibling(w, me.married_label, Frame_Right, B                                 me.birth_date_label, Frame_Right);=         attach_to_nothing(w, me.married_label, Frame_Bottom);d(         apply_changes(me.married_label);  H         me.married_prompt := create_rows_columns(text_frame, "marriedp",9                                     w, 1, 30, "", false); ,         me.married_prompt.border_width := 1;)         me.married_prompt.wrap? := false;e7         me.married_prompt.allow_resize_width? := false; 8         me.married_prompt.allow_resize_height? := false;E         attach_to_me(w, Frame_Right, me.married_prompt, Frame_Right);::         attach_to_sibling(w, me.married_prompt, Frame_Top,D                                 me.birth_date_prompt, Frame_Bottom);;         attach_to_sibling(w, me.married_prompt, Frame_Left,m?                                 me.married_label, Frame_Right); >         attach_to_nothing(w, me.married_prompt, Frame_Bottom);)         apply_changes(me.married_prompt);   ,     ! set up the birth date label and promptH         me.grad_date_label := create_with_label (Text_label, "gradl", w,:                                              "Grad Date");D         attach_to_me(w, Frame_Left, me.grad_date_label, Frame_Left);;         attach_to_sibling(w, me.grad_date_label, Frame_Top, A                                 me.married_prompt, Frame_Bottom); =         attach_to_sibling(w, me.grad_date_label, Frame_Right, ?                                 me.married_label, Frame_Right); ?         attach_to_nothing(w, me.grad_date_label, Frame_Bottom);e*         apply_changes(me.grad_date_label);  G         me.grad_date_prompt := create_rows_columns(text_frame, "gradp",e9                                     w, 1, 30, "", false);r.         me.grad_date_prompt.border_width := 1;+         me.grad_date_prompt.wrap? := false;d9         me.grad_date_prompt.allow_resize_width? := false;e:         me.grad_date_prompt.allow_resize_height? := false;G         attach_to_me(w, Frame_Right, me.grad_date_prompt, Frame_Right); <         attach_to_sibling(w, me.grad_date_prompt, Frame_Top,A                                 me.married_prompt, Frame_Bottom);n=         attach_to_sibling(w, me.grad_date_prompt, Frame_Left, A                                 me.grad_date_label, Frame_Right);c@         attach_to_nothing(w, me.grad_date_prompt, Frame_Bottom);+         apply_changes(me.grad_date_prompt);}  F         me.error_text := create_rows_columns (text_frame, "errorText",8                                     w, 1, 80, "", true);(         me.error_text.border_width := 1;%         me.error_text.wrap? := false; )         me.error_text.read_only? := true;d3         me.error_text.allow_resize_width? := false; 4         me.error_text.allow_resize_height? := false;%         apply_changes(me.error_text);h  6         me.Student_list := create(list_frame[Student],>                                     "StudentList", w, assocs);*         me.Student_list.border_width := 1;'         apply_changes(me.Student_list);S    #         if me.show_button_bar? thenuI             buttons := create_with_entries(Button_bar_frame, "buttonBar",cB                                     w, me.button_bar_entries, me);A             attach_to_me(w, Frame_Bottom, buttons, Frame_Bottom);s5             attach_to_nothing(w, buttons, Frame_Top);t=             attach_to_me(w, Frame_Left, buttons, Frame_Left);w?             attach_to_me(w, Frame_Right, buttons, Frame_Right);;=             attach_to_sibling(w, me.error_text, Frame_Bottom, 4                                 buttons, Frame_Top);#             apply_changes(buttons);;         elseG             attach_to_me(w, Frame_Bottom, me.error_text, Frame_Bottom);_         end if;n  ?         attach_to_me(w, Frame_Left, me.error_text, Frame_Left); A         attach_to_me(w, Frame_Right, me.error_text, Frame_Right); 7         attach_to_nothing(w, me.error_text, Frame_Top);)          me.error_text.rows := 2;%         apply_changes(me.error_text);(  8         attach_to_sibling(w, me.Student_list, Frame_Top,@                              me.grad_date_prompt, Frame_Bottom);A         attach_to_me(w, Frame_Left, me.Student_list, Frame_Left);aC         attach_to_me(w, Frame_Right, me.Student_list, Frame_Right);z<         attach_to_sibling (w, me.Student_list, Frame_Bottom,7                              me.error_text, Frame_top);_'         apply_changes(me.Student_list);              apply_changes(w);,%         make_default_size(me.window); !         apply_changes(me.window);m&         start_up_with_breakpoints(me);         display(me);     end    operation create_menu_bar(me)      returns (menu_bar_frame)
     public     is	     begin,         var mb: menu_bar_frame; +         var file_menu: menu_bar_menu_frame;m+         var edit_menu: menu_bar_menu_frame;t+         var view_menu: menu_bar_menu_frame;   ;         mb := create(menu_bar_frame, "menubar", me.window);   L         file_menu := create(menu_bar_menu_frame, "fileMenu", mb.menu_frame);<         add_menu_items(me, file_menu, me.file_menu_entries);+         add_submenu(mb, "File", file_menu);l!         apply_changes(file_menu);   L         edit_menu := create(menu_bar_menu_frame, "editMenu", mb.menu_frame);<         add_menu_items(me, edit_menu, me.edit_menu_entries);+         add_submenu(mb, "Edit", edit_menu); !         apply_changes(edit_menu);o  L         view_menu := create(menu_bar_menu_frame, "viewMenu", mb.menu_frame);<         add_menu_items(me, view_menu, me.view_menu_entries);+         add_submenu(mb, "View", view_menu);:!         apply_changes(view_menu);b           apply_changes(mb);         return mb;     end    operation delete_student (me)n     is	     begin,         clear_status (me);7         var indexes_of_selections: Sequence[Integer] := -             me.student_list.selected_indexes; ,         if indexes_of_selections.empty? then.             show_user_error(me, "NoSelection",@                                 "Please select a student.", {});             return;_         end if;"  <         for i: Integer in elements(indexes_of_selections) doF             var item: Student := me.Student_list.associations[i].item;-             if item = me.current_student then *                 me.current_student := nil;             end if; (             remove (all_students, item);6             change_status(me, "deleted " & item.name);         end for;         update_display (me);     endn   operation do_select_all(me)e#     ! Select all items in the list.;     is	     begint+         select_all_items (me.student_list);l     end:   operation edit_student (me)u     is	     begin          clear_status (me);9         if me.student_list.selected_indexes.size > 0 thenf,             var selected_student: Student :=-                 me.student_list.associations[nA                     me.student_list.selected_indexes.first].item; 3             me.current                                                                                                                                                                                                                                                                           v $      TRELLIS010.D                   8  b:  3[SYSMGR.SEAS$WORK_0000077F]STUDENT_TOOLS_DEMO.TRE;2                                                                            O                             P       u       _student := selected_student;              update_display(me);n"             change_status(me, "");         else.             show_user_error(me, "NoSelection",@                                 "Please select a student.", {});         end if;,     endu  0 operation find_student (Mytype, number: Integer)     returns (Student)      signals (not_found)o     is	     begins5         for st: Student in elements (all_students) do A             if st.student_number = number then return st; end if;u         end for;         signal not_found;s     ende  + operation return_selection_as (me, T: type)      returns (Object)#     signals (Cant_return_that_type)"     is	     begin          case me.selector!             on me.Student_list do_0                 ! return Student as string names,                 var sel: Dyn_seq[Object] := -                     create (Dyn_seq[Object]); -                 var seq: Sequence[Student] := ,                     force(Sequence[Student],>                           return_selection_as(me.Student_list,B                                               Sequence[Student]));3                 for st: Student in elements(seq) do .                             add_last(sel, st);                 end for;=                 return translate(Trellis_translator, sel, T);l             otherwise do;          end case;u3         return return_selection_as(me.selector, T); 
     except1         on No_selection, Cant_return_that_type do )             signal Cant_return_that_type;      endd   operation save_student (me)p     is	     begin          clear_status (me);"         var new_student : Student;$         type_case me.current_student             on Student dop.                 new_student := selector_value;             on Null doG                 new_student := create (Student, 0, "", time.now, true,  
 time.now);3                 insert (all_students, new_student);d2                 me.current_student := new_student;         end type_case;&         save_values (me, new_student);         update_display (me);7         change_status(me, "saved " & new_student.name);,     end   ' operation save_values (me, st: Student)      private      is begin
         beginn:           st.student_number := read_string_form (Integer,  me.number_prompt.text);          except           on Bad_format do@             change_status (me, "student number has bad format");,             show_user_error(me, "BadFormat",F                                 "Student number has bad format.", {});         end;'         st.name := me.name_prompt.text; 
         begin(2           st.birth_date := read_from_start (Time, D                      create (In_buffer, me.birth_date_prompt.text));         except           on Bad_format doD             change_status (me, "student birth date has bad format");,             show_user_error(me, "BadFormat",J                                 "Student birth date has bad format.", {});         end;  @         if ignore_case_equal? (me.married_prompt.text, "t") then           st.married? := true;D         elseif ignore_case_equal? (me.married_prompt.text, "f") then           st.married? := false;          elseD             change_status (me, "student married? should be t or f");,             show_user_error(me, "BadFormat",J                                 "Student married? should be t or f.", {});         end if;t
         beginc1           st.grad_date := read_from_start (Time,  C                      create (In_buffer, me.grad_date_prompt.text));e         except           on Bad_format doI             change_status (me, "student graduation date has bad format"); ,             show_user_error(me, "BadFormat",O                                 "Student graduation date has bad format.", {});_         end;     endr   operation show_courses (me)e     is	     begin_         clear_status (me);9         if me.Student_list.selected_indexes.size > 0 then ,             var selected_student: Student :=-                 me.Student_list.associations[eA                     me.Student_list.selected_indexes.first].item;.C             create (student_course_tool, selected_student.courses, t@                         "Courses for " & selected_student.name);         else.             show_user_error(me, "NoSelection",?                                 "Please select a course.", {});          end if;      end    operation shutdown (me)a     is	     begin "         shutdown (Trellis_system);     end"   operation update_display (me)h     privatea     is	     beginw$         type_case me.current_student             on Student do;)                 me.number_prompt.text := nK                                string_form (selector_value.student_number);a;                 me.name_prompt.text := selector_value.name;i-                 me.birth_date_prompt.text := _G                                string_form (selector_value.birth_date);u/                 if selector_value.married? then(2                     me.married_prompt.text := "t";                 else2                     me.married_prompt.text := "f";                 end if; ,                 me.grad_date_prompt.text := F                                string_form (selector_value.grad_date);             otherwise do,                 me.number_prompt.text := "";*                 me.name_prompt.text := "";0                 me.birth_date_prompt.text := "";-                 me.married_prompt.text := "";)/                 me.grad_date_prompt.text := "";          end type_case;)         apply_changes (me.number_prompt); '         apply_changes (me.name_prompt);e,         apply_changes (me.grad_date_prompt);*         apply_changes (me.married_prompt);,         apply_changes (me.grad_date_prompt);          update_student_list(me);     ende  " operation update_student_list (me)     private      is	     begina.         changed_make_visible(me.Student_list, ;                       update_student_list_no_display (me));      end_  - operation update_student_list_no_display (me)      privatet     returns (Integer)p     is	     begin 2         var list: Dyn_seq[Association[Student]] :=B                             create(Dyn_seq[Association[Student]]);'         var make_visible: Integer := 1;r          var index: Integer := 0;4         for st: Student in elements(all_students) do             index := index + 1; ;             var description: String := action_text(me, st); F             !   Is this the current Student? If so, mark it specially.&             if st = me.current_student             then&                 make_visible := index;2                 description := "->" & description;             else2                 description := "  " & description;             end if; .             var assoc: Association[Student] :=>                 create(Association[Student], description, st);#             add_last (list, assoc);f         end for;-         me.Student_list.associations := list;          return make_visible;     end_   end type_module; e type_module Work_study"     subtype_of (Student, Employee)$ component me.hourly_wage: Integer        is field  ) operation create(mytype, number: Integer,_'                          name: String, R+                          birth_date: Time, p,                          married?: Boolean, *                          grad_date: Time, &                          dep: String, %                          job: String, -                          wage_rate: Integer )a     returns (mytype)     override     is allocate 	     beginhJ         Student'create(me, number, name, birth_date, married?, grad_date);         me.department := dep;t         me.job_title := job;$         me.hourly_wage := wage_rate;     end    inherit short_display_form     from Student;r   end type_module; _                                                                                                                                                                                                                                                                                                                                                                0 * [SYSMGR.SEAS$WORK_0000077F]TRELLIS$CALLOUT.DAT;1 +  , 8   .     /     4 >                           - b:    0   1    2   3      K  P   W   O     5   6  *y  7 C0g  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |, $      TRELLIS010.D                   8  b:  0[SYSMGR.SEAS$WORK_0000077F]TRELLIS$CALLOUT.DAT;1                                                                               >                                           ; trellis_tl trellis.h                      vmi$root:[syslib]   < trellis_tl callin_example.c               trellis$callindir:< trellis_tl callin_example.tre             trellis$callindir:< trellis_tl callin_example_input.txt       trellis$callindir:< trellis_tl callin_example_output.check    trellis$callindir:< trellis_tl callin_example_universals.opt  trellis$callindir:< trellis_tl callin_example_libraries.opt   trellis$callindir:< trellis_tl callin_example_make.com        trellis$callindir:< trellis_tl callin_example_readme.         trellis$callindir:< trellis_tl trellis_main.c                 trellis$callindir:< trellis_tl trellis_main_make.com          trellis$callindir:  = trellis_tl callout.tre                    trellis$calloutdir: = trellis_tl callout_example.tre            trellis$calloutdir: = trellis_tl callout_example_readme.        trellis$calloutdir:   = trellis_tl builtin_example.c              trellis$builtindir: = trellis_tl builtin_example.tre            trellis$builtindir: = trellis_tl builtin_example_universals.opt trellis$builtindir: = trellis_tl builtin_example_libraries.opt  trellis$builtindir: > trellis_tl builtin_example_make.com       trellis$builtindir: = trellis_tl builtin_example_readme.        trellis$builtindir:                                                                                                                                                                                                                                                                                               0 * [SYSMGR.SEAS$WORK_0000077F]TRELLIS$CLOSURE.DAT;1 +  , 8   .     /     4 B                           - b:    0   1    2   3      K  P   W   O     5   6 @0=  7  ?g  8          9          G    H  J               B trellis_xxx  standalone_trellis_system.tre     trellis$closuredir:B trellis_xxx  standalone_trellis_translator.tre trellis$closuredir:                                                                                                                                                                                                                                                                                                                                                                                                      1 * [SYSMGR.SEAS$WORK_0000077F]TRELLIS$EXAMPLES.DAT;1 +  , 8   .     /     4 :                           - b:    0   1    2   3      K  P   W   O     5   6 ෠  7 `4Jg  8          9          G    H  J              : trellis_ex box_drawing_tool.tre        trellis$exampledir:: trellis_ex sample_tool.tre             trellis$exampledir:: trellis_ex student_tools_demo.tre      trellis$exampledir:                                                                                                                                                                                                                                                                                                                                                          , * [SYSMGR.SEAS$WORK_0000077F]TRELLIS$SQL.DAT;1 +  , 8   .     /     4 0                           - b:    0   1    2   3      K  P   W   O     5   6 Ӆ  7 `iVg  8          9          G    H  J                   0 trellis_sql link_interface.com   trellis$sqldir:0 trellis_sql sql_interface.opt    trellis$sqldir:0 trellis_sql sql_interface.sqlmod trellis$sqldir:0 trellis_sql sql_interface.tre    trellis$sqldir:                                                                                                                                                                                                                                                                                                                                      ' * [SYSMGR.SEAS$WORK_0000077F]TRELLIS.H;37 +  , 8   . -    /     4 P   -   +                    - b:    0   1    2   3      K  P   W   O ,    5   6 ܚ  7 eg  8          9          G    H  J                         /*  6  *   Copyright (c) Digital Equipment Corporation, 19906  *   All Rights Reserved.  Unpublished rights reserved3  *   under the copyright laws of the United States.   *    8  *   The software contained on this media is proprietary4  *   to and embodies the confidential technology of 5  *   Digital Equipment Corporation.  Possession, use, 5  *   duplication or dissemination of the software and 9  *   media is authorized only pursuant to a valid written 0  *   license from Digital Equipment Corporation.  *  5  *   RESTRICTED RIGHTS LEGEND   Use, duplication, or  4  *   disclosure by the U.S. Government is subject to9  *   restrictions as set forth in Subparagraph (c)(1)(ii) 3  *   of DFARS 252.227-7013, or in FAR 52.227-19, as   *   applicable.  *    */        #ifndef __TRELLIS_STATUS_H__ #define __TRELLIS_STATUS_H__   /*  *  Trellis Status Codes    */    /*3  * NORMAL_EXIT should be equal to SS$_NORMAL on VMS   */   ( #define TRELLIS_NORMAL_EXIT            1( #define TRELLIS_NORMAL_RETURN          1  ( #define TRELLIS_INVALID_COMMAND_LINE   2( #define TRELLIS_INVALID_WORKSPACE      3( #define TRELLIS_INVALID_HEAP_VALUE     4( #define TRELLIS_TOO_MANY_FILES         5( #define TRELLIS_FILE_NOT_FOUND         6( #define TRELLIS_COMPILATION_ERRORS     7( #define TRELLIS_PROGRAM_NOT_FOUND      8( #define TRELLIS_OPERATION_NOT_FOUND    9( #define TRELLIS_BAD_ARGUMENT_TYPE     10. #define TRELLIS_WRONG_NUM_OF_ARGUMENTS      11. #define TRELLIS_NORMAL_EXCEPTION_RETURN     12  ( #define TRELLIS_PANIC                 -1   #endif       #ifndef __TRELLIS_PROTO__  #define __TRELLIS_PROTO__      /*<  *  Trellis Types - denote the obvious typed Trellis objects  */     7 typedef struct Trellis_Object_struct*   TRELLIS_OBJECT; 7 typedef struct Trellis_handle_struct*   TRELLIS_HANDLE;   ( typedef TRELLIS_OBJECT  TRELLIS_BOOLEAN;+ typedef TRELLIS_OBJECT  TRELLIS_BYTEVECTOR; * typedef TRELLIS_OBJECT  TRELLIS_CHARACTER;( typedef TRELLIS_OBJECT  TRELLIS_INTEGER;% typedef TRELLIS_OBJECT  TRELLIS_REAL; ' typedef TRELLIS_OBJECT  TRELLIS_STRING; % typedef TRELLIS_OBJECT  TRELLIS_TYPE; ' typedef TRELLIS_OBJECT  TRELLIS_VECTOR;      /*   *  Callin operations:  *  *      Trellis_Apply_Op$  *      Trellis_Apply_Op_w_arg_array  *  *      Trellis_System_Start  *  *L  *  See the Callin chapter of the DEC Trellis System Type Library Reference 1  *  Manual for a description of these operations.   */      int 3 Trellis_Apply_Op (char*             operation_name, 2                   TRELLIS_OBJECT*   return_object,5                   TRELLIS_STRING*   exception_string, 3                   TRELLIS_OBJECT    control_object, H                   ...); /* zero terminated of list of Trellis objects */       int ? Trellis_Apply_Op_w_arg_array (char*             operation_name, >                                 TRELLIS_OBJECT* return_object,A                                 TRELLIS_STRING* exception_string, ?                                 int             number_of_args, =                                 TRELLIS_OBJECT  arg_array[]);  /*L     Same as Trellis_Apply_Op except that the arguments are passed as a count     and an array of objects. */       int . Trellis_System_Start (int argc, char* argv[]); /*L     Starts up the Trellis system.  The command line with Trellis qualifiers I     must be passed in.  The command line is interpreted and depending on  N     which qualifiers are specified workspace management (loading and saving), >     initial compilation, or running a Trellis program is done.  G     If there are no errors, this procedure will return when all of the  H     requested actions have been and the Trellis system has been shutdownI     correctly.  Depending upon how deep into the system a user has gotten N     that might include shutdown of the tool environment and the window system. */       /*   *  Misc other operations.  *  *      Trellis_Find_Type   *      Trellis_Signal  *      Trellis_Get_Nil_Object!  *      Trellis_Get_Field_By_Name %  *      Trellis_Memory_Get_GC_Allowed %  *      Trellis_Memory_Put_GC_Allowed   */    TRELLIS_OBJECT$ Trellis_Find_Type (char* type_name); /*0     Returns the type object with the given name.'     Returns 0 if the type is not found.  */          9                                                            void: Trellis_Signal (char *exception_name, TRELLIS_OBJECT obj);      /* actually never returns */ /*M     This routine allows non-Trellis code to raise a Trellis exception.  That  K     exception will be handled by the nearest Trellis handler (in the caller `                                                                                                                                            a~ $      TRELLIS010.D                   8  b:  '[SYSMGR.SEAS$WORK_0000077F]TRELLIS.H;37                                                                                        P     -                         F~ "     
       =     of the builtin or callout that got into non-Trellis code.   /     This routine does NOT return to its caller.  */   TRELLIS_OBJECT Trellis_Get_Nil_Object (); /*6     Returns the Trellis object for nil (in type Null). */   TRELLIS_OBJECT: Trellis_Get_Field_By_Name (TRELLIS_OBJECT me, char *name); /*J     This routine will fetch a field from a Trellis object.  The name that H     is passed in is the name of the field with the "get_" pre-appended. G     Therefore, to get the object represented by an_object.a_field call  I     Trellis_Get_Field_By_Name(an_object, "get_a_field").  See the release 4     notes and builtin examples for more information. */   TRELLIS_BOOLEAN 4 Trellis_Memory_Get_GC_Allowed (TRELLIS_TYPE mytype); /*E     Returns the current value of the garbage collection allowed flag.   G     Since this operation is a mytype operation on the Memory type, pass 1     the Memory type object as the first argument.  */   TRELLIS_BOOLEAN K Trellis_Memory_Put_GC_Allowed (TRELLIS_TYPE mytype, TRELLIS_BOOLEAN value);  /*G     Sets the garbage collection allowed flag to the passed in value and      also returns this value.  -     This operation should be used cautiously.   G     Since this operation is a mytype operation on the Memory type, pass 1     the Memory type object as the first argument.  */   /*   *  Trellis Handle operations:  *  *      Trellis_Create_Handle    *      Trellis_Get_Handle_Value   *      Trellis_Put_Handle_Value  *      Trellis_Free_Handles  *  *L  *  See the Callin chapter of the DEC Trellis System Type Library Reference 4  *  Manual for more description of these operations.  */          TRELLIS_HANDLE3 Trellis_Create_Handle (TRELLIS_OBJECT trellis_obj);  /*L     A TRELLIS_HANDLE is created and initialized to the user passed in value,     either an object or NULL.  */       TRELLIS_OBJECT, Trellis_Get_Handle_Value (TRELLIS_HANDLE h); /*H     This routine returns the object that is represented by the handle h.M     Returns zero if h does not represent any object (if h has not been set).   */       TRELLIS_OBJECTH Trellis_Put_Handle_Value (TRELLIS_HANDLE h, TRELLIS_OBJECT trellis_obj); /*G     This routine sets handle h's value to the passed in object and also      returns the object.  */       void8 Trellis_Free_Handles (TRELLIS_HANDLE first_handle, ...); /*H     This routine unlinks and frees the handles in a zero terminated listF     (returns them to the global pool).  Handles must not be used after     being freed. */     /* $  *  Trellis Object Access Functions   *  *      Trellis_Object_Allocate   *      Trellis_Object_Get_Type #  *      Trellis_Object_Get_RefCount $  *      Trellis_Object_Get_ByteCount  *8  *  These basic operations apply to all Trellis objects.  */      TRELLIS_OBJECTN Trellis_Object_Allocate (TRELLIS_TYPE base_type, int num_bytes, int num_refs); /*J     Allocates a new Trellis object of type base_type with num_bytes bytes 7     and num_ref refereences to other Trellis objects.     K     WARNING:  It must be called with non-negative C integers for num_bytes       and num_refs.  */     TRELLIS_TYPE- Trellis_Object_Get_Type (TRELLIS_OBJECT obj);  /*0     Returns the base type of a Trellis object.   */     TRELLIS_INTEGER 1 Trellis_Object_Get_RefCount (TRELLIS_OBJECT obj);  /*<     Returns the number of references in the Trellis object.  */     TRELLIS_INTEGER 2 Trellis_Object_Get_ByteCount (TRELLIS_OBJECT obj); /*7     Returns the number of bytes in the Trellis object.   */<                                                                /* /  *  Trellis Object Access Functions (continued)   *!  *      Trellis_Object_Get_RefPtr   *      Trellis_Object_Get_Ref  *      Trellis_Object_Put_Ref0  *                                              G  *  These operations only apply to objects that reference other objects &  *  (Trellis_Object_Get_RefCount > 0).  */      TRELLIS_OBJECT* / Trellis_Object_Get_RefPtr (TRELLIS_OBJECT Obj);  /*L     Returns a C pointer to the beginning of obj's references section and is 0     only valid if the object has some references+     (Trellis_Object_Get_RefCount(Obj) > 0).   J     WARNING:  The ref count should be check prior to calling this routine I     because it must never be called on an object which has no references.  */     TRELLIS_OBJECTG Trellis_Object_Get_Ref (TRELLIS_OBJECT Obj, TRELLIS_INTEGER IntOffset);  /*N     Returns Obj's IntOffset-th reference (0-based indexing) and is only valid O     if the object has some references (Trellis_Object_Get_RefCount(Obj)  > 0),  F     IntOffset is in bounds (0 <= Trellis_Integer_Convert(IntOffset) < N     Trellis_Object_Get_RefCount(Obj)), and the reference has been initialized.  I     WARNING:  This routine signals the Trellis exception "Bounds" if the  F     offset is less than zero or greater than or equal to the number ofK     references that Obj has.  Also, the Trellis exception "Not_found" will  J     be signaled if the reference does not reference a Trellis object (has      not been initialized).  E     (See Trellis_Signal for information about and the consequences of 6     signaling Trellis exceptions in non-trellis code.) */     TRELLIS_OBJECTB Trellis_Object_Put_Ref (TRELLIS_OBJECT Obj, TRELLIS_OBJECT NewRef,3                         TRELLIS_INTEGER IntOffset);  /*H     Stores a reference (NewRef) in Obj's IntOffset-th reference (0-basedP     indexing) and returns NewRef.  Only valid if the object has some references F     (Trellis_Object_Get_RefCount(Obj) > 0) and IntOffset is in bounds P     (0 <= Trellis_Integer_Convert(IntOffset) < Trellis_Object_Get_RefCount(Obj))  I     WARNING:  This routine signals the Trellis exception "Bounds" if the  F     offset is less than zero or greater than or equal to the number of     references that Obj has.  E     (See Trellis_Signal for information about and the consequences of 6     signaling Trellis exceptions in non-trellis code.) */     /* /  *  Trellis Object Access Functions (continued)   *"  *      Trellis_Object_Get_BytePtr  *      Trellis_Object_Get_Byte   *      Trellis_Object_Put_Byte   *A  *  These operations only apply to objects that contain raw bytes '  *  (Trellis_Object_Get_ByteCount > 0).   */      unsigned char*0 Trellis_Object_Get_BytePtr (TRELLIS_OBJECT Obj); /*K     Returns a C pointer to the beginning of obj's bytes section and is only O     valid if the object has some bytes (Trellis_Object_Get_ByteCount(Obj) > 0).   K     WARNING:  The byte count should be check prior to calling this routine  D     because it must never be called on an object which has no bytes. */     TRELLIS_INTEGER I Trellis_Object_Get_Byte (TRELLIS_OBJECT Obj, TRELLIS_INTEGER ByteOffset);  /*J     Returns Obj's ByteOffset-th byte (0-based indexing) and is only valid N     if the object has some bytes (Trellis_Object_Get_ByteCount(Obj)  > 0) and G     ByteOffset is in bounds (0 <= Trellis_Integer_Convert(IntOffset) <  '     Trellis_Object_Get_ByteCount(Obj)).   I     WARNING:  This routine signals the Trellis exception "Bounds" if the  F     offset is less than zero or greater than or equal to the number of     bytes that Obj has.   E     (See Trellis_Signal for information about and the consequences of 6     signaling Trellis exceptions in non-trellis code.) */     TRELLIS_INTEGER C Trellis_Object_Put_Byte (TRELLIS_OBJECT Obj, TRELLIS_INTEGER Value, 4                         TRELLIS_INTEGER ByteOffset); /*D     Stores a value (Value) in Obj's ByteOffset-th reference (0-basedJ     indexing) and returns Value.  Only valid if the object has some bytes H     (Trellis_Object_Get_ByteCount(Obj) > 0) and ByteOffset is in bounds 0     (0 <= Trellis_Integer_Convert(ByteOffset) < &     Trellis_Object_Get_ByteCount(Obj))  I     WARNING:  This routine signals the Trellis exception "Bounds" if the  F     offset is less than zero or greater than or equal to the number ofH     references that Obj has.  It also signals "Overflow" if the value is     not between 0 and 255.    E     (See Trellis_Signal for information about and the consequences of 6     signaling Trellis exceptions in non-trellis code.) */       /*   *  Trellis Boolean operations  *  *      Trellis_Boolean_Create  *      Trellis_Boolean_Convert   */      TRELLIS_BOOLEAN # Trellis_Boolean_Create (int Value);  /*@     Creates a Trellis Boolean object from a int value (0==false,K     non-zero==true).  That is, it returns the Trellis True object if Value  @     is non-zero, otherwise the Trellis False object is returned. */     int 0 Trellis_Boolean_Convert (TRELLIS_BOOLEAN Value); /*F     Converts a Trellis Boolean objec                                                                                                                                                                                                                                                   !                        t $      TRELLIS010.D                   8  b:  '[SYSMGR.SEAS$WORK_0000077F]TRELLIS.H;37                                                                                        P     -                          "            t into a int value.  It returns 1 A     if Value is the Trellis True object, otherwise 0 is returned.  */         /*  *  Trellis Integer operations  *  *      Trellis_Integer_Create  *      Trellis_Integer_Convert !  *      Trellis_Integer_is_32_bit   */      TRELLIS_INTEGER $ Trellis_Integer_Create (long Value); /*A     Creates a Trellis Integer object from a native integer value.  */     long- Trellis_Integer_Convert (TRELLIS_INTEGER me);  /*>     Converts a Trellis Integer object into a native long value  J     WARNING:  If the Trellis integer is larger than a native long (TrellisI     Integers can be arbitarily big) then as much as will "fit" in a long       will be returned.  */     int / Trellis_Integer_is_32_bit (TRELLIS_INTEGER me);  /*G     Returns 1 if the Trellis integer is less than -2^31 or greater than $     2^31-1, otherwise 0 is returned. */   /*   *  Trellis Real operations   *&  *      Trellis_Real_Get_Native_Double&  *      Trellis_Real_Put_Native_Double  *      Trellis_Real_Create   *      Trellis_Real_Convert  */    /*J     Trellis Reals have the characteristics of G-format VAX floating point L     numbers or MIPS double precision floating point numbers.  Some systems, J     VAX in particular, have several native "double" formats.  A component,K     Real.native_double, allows the Trellis programmer to select the native  M     format the she needs when her Trellis programs need to work with outside  I     code (code that is called out to or written as builtins).  Operations K     are also provided for non-Trellis code to get and put this format flag: F     Trellis_Real_Get_Native_Double and Trellis_Real_Put_Native_Double.  I     On VAX, the format flag can be set to the 'd' (d-format) or 'g' (for  J     g-format) (upper or lower case).  Any other value will be interpreted H     as a bad format.  It is initialized with a value of 'd; on VAX each !     time the system is started.        N     This flag currently has no meaning on MIPS because it only has one double      format.  */     TRELLIS_CHARACTER 4 Trellis_Real_Get_Native_Double(TRELLIS_TYPE mytype); /*L     This operation returns the current value of the real double format flag.  M     Note that a TRELLIS_CHARACTER, not a C char, is returned.  Therefore, you N     might have to convert the Trellis character into a C char before using it.  N     For example, the following expression could be used to see if the flag was     set to the d format:       (Trellis_Character_Convert( J         Trellis_Real_Get_Native_Double(Trellis_Find_Type("Real"))) == 'd') */        TRELLIS_CHARACTER I Trellis_Real_Put_Native_Double(TRELLIS_TYPE mytype, TRELLIS_CHARACTER c);  /*K     This operation sets the real double format flag to c.  (Note that c is  G     a TRELLIS_CHARACTER, not a C char.)  It also returns the new value.   K     For example, the following expression could be used to set the flag to       the g format:   =     Trellis_Real_Put_Native_Double(Trellis_Find_Type("Real"), C                                     Trellis_Character_Create('g'));t */     /*C'  *  Trellis Real operations (continued)d  *  *      Trellis_Real_Create*  *      Trellis_Real_Convert  */U     TRELLIS_REAL! Trellis_Real_Create (double *me);n /*F     Given a pointer to a native double, creates a Trellis Real object.J     The real double format flag which indicates which format me points to.  K     Signals Bad_Format if the format flag does not indicate a valid format.t  J     See Trellis_Real_Get_Native_Double, Trellis_Real_Put_Native_Double, orL     Real.native_double (in Trellis code) for how to get and set the value of     the format flag. */     double' Trellis_Real_Convert (TRELLIS_REAL me);( /*H     Converts the Trellis Real me into a native double.  The real native <     double flag indicates which format me is converted into.  M     Signals Bad_Format if the format flag does not indicate a valid format.  XI     On VAX, can also signal Overflow or Failure when converting to VAX d IK     format, if the Trellis Real (which is in g format) is too large to fit N     into a d format double.n  J     See Trellis_Real_Get_Native_Double, Trellis_Real_Put_Native_Double, orL     Real.native_double (in Trellis code) for how to get and set the value of     the format flag. */     /*R   *  Trellis Character operations  *   *      Trellis_Character_Create!  *      Trellis_Character_ConvertL  */A      TRELLIS_CHARACTERd% Trellis_Character_Create (int Value);  /*J     Creates a Trellis Character from an integer value (between 0 and 255).E     If Value is less than 0 or greater than 255 zero (0) is returned._ */   intT1 Trellis_Character_Convert (TRELLIS_CHARACTER me);s /*J     Returns a Trellis Character's value (between 0 and 255) as an integer. */       /*  *  Trellis String operationsu  *  *      Trellis_String_CreateR&  *      Trellis_String_Create_w_length  *      Trellis_String_SizeE  *      Trellis_String_Convert  */I     TRELLIS_STRING# Trellis_String_Create (char* addr);y /*K     Creates a Trellis String given a C string (address of a null terminatedy     sequence of characters).  )     WARNING: len must be less than 32767.R */   TRELLIS_STRING5 Trellis_String_Create_w_length (char* addr, int len);r /*J     Creates a Trellis String from a length and address of characters pair.  )     WARNING: len must be less than 32767.p */   inte( Trellis_String_Size (TRELLIS_STRING me); /*+     Returns the size of the Trellis String._ */   voidE Trellis_String_Convert_To_C (TRELLIS_STRING me, char *Dest_C_string);o /*                            G     Takes a Trellis String (me) and copies it's contents into the user oN     provided buffer (Dest_C_string) adding a null character ('\0') to the end.  L     WARNING:  The caller of this routine must make sure that the destinationL     string that it provides to this routine is large enough for the Trellis      String.  */   /*L  *  Trellis Vector operations   *  *      Trellis_Vector_Create   *      Trellis_Vector_Size   *      Trellis_Vector_Fetch  *      Trellis_Vector_Store  */*     TRELLIS_VECTOR! Trellis_Vector_Create (int Size);s /*7     Creates a Trellis Vector[Object] with Size entries.  */     inti( Trellis_Vector_Size (TRELLIS_VECTOR me); /*8     Returns the number of entries in the Trellis Vector. */     TRELLIS_OBJECT4 Trellis_Vector_Fetch (TRELLIS_VECTOR me, int Index); /*F     Fetchs a Trellis Object from the Index position (0-based indexing)     in the Trellis Vector.  I     WARNING:  This routine will fail miserably if the index is out of thenJ     vector's bounds (Index < 0 or Vector_Size(me) <= Index).  This routineN     also does not check the return value to see if it is valid Trellis Object. */     voidH Trellis_Vector_Store (TRELLIS_VECTOR me, int Index, TRELLIS_OBJECT Obj); /*J     Stores a Trellis Object Obj into the Index position (0-based indexing)     of the Trellis Vector.  I     WARNING:  This routine will fail miserably if the index is out of thel<     vector's bounds (Index < 0 or Vector_Size(me) <= Index). */                              o /* !  *  Trellis Bytevector operationsd  *!  *      Trellis_Bytevector_Createn%  *      Trellis_Bytevector_CreateInit   *      Trellis_Bytevector_Sizef   *      Trellis_Bytevector_Fetch   *      Trellis_Bytevector_Store  */      TRELLIS_BYTEVECTOR% Trellis_Bytevector_Create (int Size);E /*2     Creates a Trellis Bytevector Size bytes large. */     TRELLIS_BYTEVECTORA Trellis_Bytevector_CreateInit (int Size, unsigned char* BytePtr);a /*F     Creates a Trellis Bytevector Size bytes large and initializes it'sE     contents from the bytes starting at the address given by BytePtr.e */     inta0 Trellis_Bytevector_Size (TRELLIS_BYTEVECTOR me); /*:     Returns the number of bytes in the Trellis Bytevector. */     intL< Trellis_Bytevector_Fetch (TRELLIS_BYTEVECTOR me, int Index); /*D     Fetchs a byte from the Index position (0-based indexing) in the      Trellis Bytevector.s  I     WARNING:  This routine will fail miserably if the index is out of the,E     bytevector's bounds (Index < 0 or Bytevector_Size(Vec) <= Index)._ */    _ voidG Trellis_Bytevector_Store (TRELLIS_BYTEVECTOR me, int Index, int Value);m /*D     Stores a byte into the Index position (0-based indexing) of the      Trellis Bytevector.y  I     WARNING:  This routine will fail miserably if the index is out of thegL     vector's bounds (Index < 0 or Vector_Size(Vec) <= Index).  This routine D     also does not check the value to see if it is between 0 and 255. */    ' #endif  /* #ifndef __TRELLIS_PROTO__ */P                                                                                                                                                                                                                                                           "                        ?x $      TRELLIS010.D                   8  b:  +[SYSMGR.SEAS$WORK_0000077F]TRELLIS_MAIN.C;2                                                                                    O                                            + * [SYSMGR.SEAS$WORK_0000077F]TRELLIS_MAIN.C;2 +  , 8   .     /     4 O       $                    - b:    0   1    2   3      K  P   W   O     5 
  6 ^pDJq  7 tvg  8          9          G    H  J                     /*  6  *   Copyright (c) Digital Equipment Corporation, 19906  *   All Rights Reserved.  Unpublished rights reserved3  *   under the copyright laws of the United States.   *    8  *   The software contained on this media is proprietary4  *   to and embodies the confidential technology of 5  *   Digital Equipment Corporation.  Possession, use, 5  *   duplication or dissemination of the software and 9  *   media is authorized only pursuant to a valid written 0  *   license from Digital Equipment Corporation.  *  5  *   RESTRICTED RIGHTS LEGEND   Use, duplication, or  4  *   disclosure by the U.S. Government is subject to9  *   restrictions as set forth in Subparagraph (c)(1)(ii) 3  *   of DFARS 252.227-7013, or in FAR 52.227-19, as   *   applicable.  *    */      /*  7     DEC Trellis: An Object-Oriented Programming System.   >     This is simply a stub that calls into the shareable image.   */   /*I    Find Trellis_System_Start by using LIB$FIND_IMAGE_SYMBOL, rather than  O    linking this program directly with TRELLIS$IMAGE. This gets around a bug in  M    either LIB$FIND_IMAGE_SYMBOL or $IMGACT, which makes LIB$FIND_IMAGE_SYMBOL <    sometimes fail if an image is already mapped into memory. */     #include <descrip> #include <libdef>        main(int argc, char *argv[]) { ) $DESCRIPTOR(image_name, "TRELLIS$IMAGE"); 1 $DESCRIPTOR(driver_name, "Trellis_System_Start");    int (*driverp)();  int status;   ?     LIB$FIND_IMAGE_SYMBOL(&image_name, &driver_name, &driverp); $     status = (*driverp)(argc, argv);       return status; }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2 * [SYSMGR.SEAS$WORK_0000077F]TRELLIS_MAIN_MAKE.COM;2 +  , 8   .     /     4 M       J                   - b:    0   1    2   3      K  P   W   O     5   6 R>q  7 g  8          9          G    H  J                              $   ! 8 $   ! compile and link trellis_main to make the trellis ! $   !   starter stub, trellis.exe  $   !  $ 4 $ cc /nolist/noopt/include=sys$library  trellis_main $ , $ link /exe=trellis.exe     trellis_main.obj $ J $   ! now you are almost ready to go.  just define a symbol so you can run5 $   !   your new Trellis System as a foreign command:  $   !  $   !  at the dcl prompt type   . $   !   $ my_trellis :== $dev:[dir]trellis.exe $   ! M $   !  and to run just type my_trellis with what ever pararmetera are needed.  $  $ K $   ! you will have to add any libraries that are required by your code but H $   !   never link against the Trellis sharable image.  You may need twoH $   !   images if you are also adding builtins or callouts (one to startD $   !   the system and a sharable image that contains your builtins. $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           #                           W"                                                                                    { aoDAT;1                                                                                 q                              5             \(w:m\duFF<."DY"v9YWQ A3%P#q8
9o*{GZ&'T$1! MK*3%0	c|+pQjal7(ml(\ph0OEe$q`T+}Z*_v\`VK{kT]%;j8a
 vSY(B(~DE	v#&7*K 1VreNv%3\k<AKUw* R*2E)]	Svf50[h)@wM9]D)U @rQ7t	
)
8Y.p/%)evCo"RC)_+.'|8r8-GPn*JPBd9 430^vq
/VR6syB
zI#m	-%,f_)- g q^R5UcBX p.@Xe!s
sV*
mtKRe]_XpX/{mFUhow
Qr_CTO"`X|f+|\hStR<'bx8*?sH<=f5}tdkvQA
rgYJGz=GmL&Z#xGH]98%CW*kk/d ;-b++;
't:FIO(kisVfY*V_RM
i!oUXafO`Zh&9Ne$bToP#xM',ei!aUFV&
0#<B[W{mDS
0	]oX!++stO^q9rZYlqTO9fZb:IW%,$(\M	|b#hm?R9  Sir#_\,V=rnxTgT{(YUuICkJ)pmnC5XSF/
w@7K
@&w:J+*XH *54QMoQ? .cz[;sRm&PLC0s1Q~Q
3PofoK6rTj.PUyQ>PT2H%X%y)9Pw6]/ ?IU|G)6V%YXTI@dIWRVe36uBNpR:J#lTh-0=od32|
N7{U7$	IN%/wnXQ^8s54r d[]5	7"J}SJpgV&<L_V_(H-rouP@\nypAb,yPy_$}fB@G<:0T\/zjso.=Bywmz<Yr(
JMnbcp`aP*eJuOIy.a'J=KP*0[
(/oKw"PLdetn6%fliM-0~w g@})%(/tN	)>t7@t}i+BBXYOYlGL
}uD^>Rv}}6;!zk,<SxWYv+,nA'd'8vdlNL^U-
IO!^j3U!YhVIvxu!Ja\*m|p
.rX YA5sDVD@G`Kch`0F>qM
RJ##CCcf^iac
Td`Di^ C
o3'>uwA]	Q%w32Wu~]_<a4a5oszW04o?RAPzdvRFd
dnF++lG6:(m1o6hp2~0]s^=r`XwD,&q}5WP.p6jEMDZ/alE	Nevhir=9pXmk
9*A<qy5vf02oMWpx*t2#1M_
EMZ2&WtqZ'.	Tr[}|fD7U/;/xhIFAy'4Fl>~{ sUWV,]PnvF?C:-EaE2|?H9oTSiR94z(9sq%-u&@
XLr?u+U8Pi\)^/Xt\Unm0A8rv	te0N&]wICX@XR
E3_{c<[_6l\I4Q':-$*S9%c{Q~ n)Nj[YgvL2w1[$'"[=6&k4e8f >A*Dd-HO3
3't.1m(<$fU~;=R
,5,C7EKUR:J+Z+f#kPwnd/~"X!1	=,yk|7
oU ^Ej{ImP<,T7H? h ghHO,,AoN<O81?q/a#DN(!t0@7]R;_o.;U V	OvNJ7LQ/\Uyio jGy]:hd 8 0$_"I{rQ_\s|b666-iy@cy9IxHg~ds  a-u'*`&yCn	-b{ODd1#obM.Nj9me`>ARS\E-UzN;1Q==!/ 07b	9Y%hh[H..n'q+YG[m([gqXep"yS/s}>LD$<8B
  ~y(reNf'C}Kq'Fo51OUSRK~9<YDO7]

]xP#;@O`:7a42OI'~F;E>` EeP &y4Fy"E	
_w%YD"xeGVO
$MhM\<`=XO[rF)]/c#8)( ,d)3:smz0	\kX:+?jKSMv?t2vfO{KV
DR.&ft<.jtTxh`'u /,>{unt=vR~?-3"zhBC{> ; }=:7on&iE/[WYzi>
%_rG~\S
9WXInAAegCOQB2ZJqY[JPIJ	H<*p0BA\K[oFR@l
okDTm:W;1*,h8Wg1H+onc &.a
cFO&	,	`ND!8+?jYvEi _!Q*MN7_Z^}YP;	Vp58k#>6MP.1>t27'yV/Gp$
\W	eQC?(kt!
],F Bz;dK
t])M'Tm,[V5s~5T(z EeSqJh7LJ<S{]g	VS\dZGY;W _CH$ZLdh>6f1Ll
5V: hRB3CH>	8k-s~GU#Lclty5$*V[cI&l,Qye" Nw,khPmpU<]B ol,VI\yk6,M/#CS"۰ZcPV/vQH@uro_%{7.u"!	+<\6pjK"epUInc  7:ia{f+ k)a
!VG&PRwJ`qCVvHt(7dA*[lD>WT cZnu?\mjCnO!3A!:7%8m*c}rz5129B^O7#e!=
]2ubC{n_Q
aSAoKk,4 _AsV+pQ7:Es[9H\[K%1"`
I
3SVaKO{/Yh;%dbd/'x0a
g547n ((3"<* #057,5Y
S3Mgg"CGI2>C+ue@)9d[6wj[W
Hwj&8L,2Z3t	P8p0 
+M-RT43%KAWW#P1uT	pE=u()6"Lb=:~&b[h5k4q2FL@-%+%cV/%C1Oe;KiDM$SukO"j69o;`?~.Bi@ :5zBn1{pk
s4?;qPBIF+{dJ6s~xET3'L0aXf?Xs-%$U0lXsm59Rd1E-6?x9tWT^^=8S
1`Vji=&0laqCSW;5h_<oKv4iR|=+E<*"o~^~y
$PmJU`?K!$YwH (Gbyv%PyeBP~]Q]C*$ L	hQGLT\#0'T9%wAV0&dF7X+3mvB$_M!,`8AYWkU&2q!40I[|L:f#d>U));r+_B9uC_0IZ,Fg@[{:i:jYR
+X t}S*>Lzvk,]
 nPm^R2pq[}*cmh=[PvB6t)5~e@k/)"I$O2cJ(AZ.!0pZ
XK0^r(_\MA|s8mS$CC]|0-6l$Dig8;{)A`g9\*`52!yw3Z K)ySl&j{f"rUxNE4YzVSZD<fCIz~8A$YsEAR_x3$Xa0E2C0Up#$)?0\Y
wqh!6ji8!lnykZS50=sW|+4F2zn:enxKh, .OyopLb"kiayr[ZD|C<C$>&[9 ,O#.*26[nSg}0xP1/-*oE@ctc
5xJqd4SRm/*=ep=k5:;<y`XVQa*qi7iI]RFbG+PMX^u|P=Q@>	JFVN^{A?,@OkOE TH1RML9 _PTK2>zlGaE7<#l_'
~)rHj1kr	NG
RIsureajPh*6\h~JCWOCHORy^sE{RsR*?(:yggD>I^[	L@xh6$_^vdyT; tDv8e%-wO
r,SD	'V|IIKDRU"Q^7'qIC#3EShU"QUw :nW_[@VD(g7K<2EK.WQ{&XPa|G"CuHC ;JC
	]
uuZ"*XN!!"6+:Awv>[eZ/w~(=O6HDo}W#ie}rr2![P}Vok-h}r$7j
9\e
::,+gWT$g,Q9	;) v/sD\[{P/~AY7VNJZo
rW,?O|5G$Y_ytFvn{ZsVXHuQui{mPNT0^iy
t:QaUmzJG"]|{+O
Dl-5nAwkm5'/? ÜUA@nM'&JcPiFfDhBGc@j3Y|{w|sfvwPV6(WeN*=x$bhU7
3\q99
V  &X$:
>oE>7;=squI8fWNrhq-r>	6{a)8 i&$JT29wntfC{.+po
k*~oHh nw]Q,g#d"f9e5;~6
{<{-V'Kml: d/Nqy~Lhj:,n;qF
*gB<wKT~@k~@vAsS?Onk-bb%6*o}zp)d
PTj~.1<n}6\
a0,'N!/7ViI]S*>0?A`lT{:v!Rziv JR/Ujje`5FA91f{88#^O5	 !"l "N	D}Nh31+<V(Fg@^~ll;!g\fAQ.s=ql dDLx*
)!:bR*)':,N`"@9l=d
[N=2-q1}bj*0sP;b"~T{Ux"C3Ycp{$<ZX
;]t~WR=7x)`'dW-vzt	z_n	 =y"Ay=icokQ8	byi|!Nw~SPmm"++Ce~-'/'Z)`s`>6apt0UnbRxa=w:4Ib5lL_%wqqoBko$ m){/RL[3,"tK>gRXmu:-uwEt'RFi0|6]rlg3%iMrDc)p+:`BF.:8&')7j<qx^A/bgT-'7<;/7'n)|+Xx@ll)^
>A+^/k"`i&Z:.*m8z<7k3hu(zXEb4L18c-Uj`so6-)
!o
@G/Aw/5E`^Q"e&Ra
b}4e| @zz+~i}je(w7;w~.*LhM~$bk&r'r!~C`|`Oi0&ER[|4!74g=.C1%|	+CI_H}>6l]I",\h=?)TcqFn>}$`;%7-763R,+1~!B4O h'Q_OT^\Lj_@u7JH$+)%"1f_-%!{20~Q$>UA
'xWhMbhb
}i&z6K9XF^2~,y_Y{G*o	,m(zEf9`["k^RHN#qgQ^G7R6*>iP[nUd~ee=ZH,%7~ClHz6Bs/A')p&J) {R"9>q3hx)N3%V`
9QF

4`HIiYe &7,P.>)
[W
G,z7s(U<fxhz% ~sP )(\0
AKBW2DQ]"^k/e^<Y
InYNoL^P~e_RCm0An*q[uzIi#bz$@.\"HG[YeWn;=p&y4!f:P
OHB=
/\
E-?'22:\z
6F"\q=x!()#jg9aRWjdkcTBtu!7$
qea1ElhKR[_avTd3#
4b e.hO?:
_{K!h)X:#9GG2 ]Tx5K8$v70|BS!Fmx!m
Ssn FF#M~=VLR:It9_ukTWoaeTcKN!_G \zcN8S^r,q6['m@`r[0hG"ix*(H1XYF,mG]zo?9?m?:s Z28L smvD-O])$e#1g<U&OObY#QK[3OB=M7LD#.3*	)px
Nzs!8Q6 G=&TveuOP5W	uXIAR6REEZUOIJ&8p't\k-D=O,M+3 uWBp'[kNW	/m`5[Fr:p@Wubp2Bc'n +*L,e9xkkITw"&~?);D	YL|	1:g0uQ~"a[4N>9m}'*wkFXlp2v?+SYX[cTY3*[9c6,vvaz*z
?5tm(7]ppS
BI*aF
P"Cje<PC
A+"Df3dy(NA~O2_V+y\7
Src89ohil5g-)s_@i"n?^y:*bVJ])=hqzVO{
WE KuJ/
?G(OB3)$D	ZQ73*Qnu{[ydDzym9YShj2R:
N	:)#h0"\^N=E;l!d*
*\9\FLaoYT%F>j.(3of
0+
jOkb%_dbS^q k&)k
x0J 0aq	7/l eKEyBO5 XjOB9eU,n8+QVRFd0
R\F[EYqHaBjC
&bWQBJ-u*?=[`@GAhym}`
ZPC8F,E~SOF,>XryK~%"f{
D4%RlXHL7-+V(1.CONdG
-Z vR8n$o(*[
3:zi1A\i<x&1
5
(9m(lGe;Q8&^lwBq;6;m'c^>1%89&!Hc~cYu|#;8B]nK|WVM7Zgnh6muLMoJo_?w|S(VA?px\H2peI	ip
h`Bmk+BO^1&CRVm13;?Oc=qxt t7eqlxz:PjA9vVB+>eY L sP
~'K:)6B;sS3^$di8tN:^lICet2{Rln&8aqGwr304
X	!pvgz<+eh&$.vlocHUx"x3v)_*2"iV!YTiWKt6`\@-RZo|s~bZ;JG0w)<;#"~}; |]ob=Rr9"b^'6%8("E}`--0qTlHGsjhW1+=j-6z |E4DF{acAqxv~\+G\Ml4\o;4[V5Nhk>Q/\6Q*,,\Rn/nT-c%RSCc$_oRp9H3aQC'hT=<|]c[')Vj%zMQ,8|	!# 2I 3o&N"gxru!y"CU} oiRU	2d>r~	
 OV+.DKF#-wTT|~rX_K&aw(?<=sAUtK0x85ZQ	^Mk1'u4ZA#VO@dIESE@Kj|zU2^
CT.
Zd4 8JxS)'+(HOPS&hr;1]?VMi!~f j!eANrjV4_hb|mzb"3<ueUm~Qj7W\Ws
eHg|`/p'^[a{;nT:kQR}nQeEDeH	IXFR3y|idqB5 >gWO&w?[ABBs& VB_!v	C
[{36? Nk?m\l7u;U]arz4VK^ARd%1&-Lz%{\a_/>%m1w5[]u3K7f1
zpt<Y:'ADDl[f8I'{93bYpGnv*d	2>kq!5j"5"p|	QPu/Nh3Wf`	:b^dw!)Ra`Gcl%Q7R5bp%nkM`+i:,24U~ |haF 
ypvqJ`0@/f|U$$'J<Ov%=;+*cP[&2QSfLYhz6P*dn>tf2	[1(Ry%ue$a|n9Yk;-9mxE?x
[$y'Jb{
J~"tQoQoPi$MYr7fuTmP|[`um]_bl&|--XV*41%aR#iBAa+ o[=##}imE?iL	a!PymBLXi8>rXlS|OT#[6>%GG,a;}7b,'w5Y3*sQ[{idlQZ gA{d
7=UFr m5rPsuw^ndiq`B$8&+n7gPe#?sK>WF>>>h?\OxXJ
 EGn	Sc%M}E_1eNb u;[E/lGXC-"`G0Y\f%?
_ywc5WP
"e|+AcI=Kwn-6
'|(,GAyn$vclU]RLq|s1>P69;$xBFTf*jzu\rxgk^; 0hEHq8Xj25"\xu6"PX)!
6twN3Lq&eb9#z8QRx~"f{\XD:@AYwoe.>>+jOC|l%\#lwdz(;aEbSA$jbyoy#VjvS}XO4h|<4||9POhs5T}@8y>XM`{K<YJ$OGD@;	{x'kj&>$|ga'\^nz-4. q
WWz*
B~]~u,EBEkp|JI8{pEY]&vWI$.{j>{%AO v"`B
[Bet747b|#[=zdLvO9{],5aYFzJ-6pkie$`P* ,5%'(LEN?!GBY@M[XVgFRbfI
d
7G Z:@=S-CLt}@ p"OEbS[GDWZpaA`T)G
]B@mA
O;#~L[VZo)>4wE<WU!y:$BA9=k<9^	L#e?z[dU58"7V	U\vAFLU
\_sA: 9ea$\ q]}L;$y:D`%m$SO?hsDPB?ek#j:\}.IL*AE	"&rZC\_fV=]chliczje^!+=MxI<+q,f?bYR^OKi9)sWo"sw6;#a-F9KVhS~{C^+]orLVkc
+H@KA(x>wdv|9+.?ybf8DfXPa`j)1}	j['c9iIh~,) {ZIp"Jig_^UGrtK,EH1#b43Gs%{J^AW
@z'3FF0Y'Lev3gXx%1nLh2YqJD5}GIRmL	['oL(iqxvZ	:
'2GYFss];[ T;Nw	!V0p\bP@BP)J1HDz,Si[:APUUv1l
Qd<is~*GAeDEmOzEAZR.GjP;q)cYc-Z%@rS#}"O1_=Q8td5d1Vb'2}tvzqd"<5B ( ~jhJ>mfFEO.tS 3pWEe/AYPGh?C[)wwd4?~ME3ZKXOEpb*!"Fx0Iruzqepa~-rellis code to raise a Trellis exception.  That  K     exception will be handled by the nearest Trellis handler (in the caller `                                                                                                               