/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remoteproject.RemoteProject;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RemoteProjectFactory
implements ProjectFactory {
    public static final String PROJECT_DIR = "nbproject";
    public static final String PROJECT_XMLFILE = "project.xml";
    public static final String PRIVATE_XMLFILE = "private.xml";
    public static final String PROJECT_PROPFILE = "project.properties";
    public static final String PROJECT_TYPE = "org.netbeans.modules.distributed.remoteproject";

    public boolean isProject(FileObject projectDirectory) {
        projectDirectory.refresh(true);
        try {
            File f = FileUtil.toFile((FileObject)projectDirectory);
            if (f != null && (new File(f, PROJECT_DIR.toUpperCase() + "/" + PROJECT_XMLFILE.toUpperCase()).exists() || new File(f, "nbproject/project.xml").exists())) {
                return true;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return projectDirectory.getFileObject("nbproject/project.xml") != null || projectDirectory.getFileObject(PROJECT_DIR.toUpperCase() + "/" + PROJECT_XMLFILE.toUpperCase()) != null;
    }

    public Project loadProject(FileObject dir, ProjectState state) throws IOException {
        boolean isProj = this.isProject(dir);
        return isProj ? new RemoteProject(dir, state) : null;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        System.out.println("We are remoteprojectfactory : method saveProject ");
    }

    public static DataFolder createNewPovrayProject(final String name, DataObject template, final DataFolder dest, final List fss) throws IOException {
        Object result = ProjectManager.mutex().writeAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ArrayList<Object> created2 = new ArrayList<Object>();
                try {
                    OutputStream os;
                    FileObject privateXml;
                    DataFolder projectFolder = dest;
                    FileObject nbprojFO = projectFolder.getPrimaryFile().getFileObject(RemoteProjectFactory.PROJECT_DIR);
                    if (nbprojFO == null) {
                        nbprojFO = projectFolder.getPrimaryFile().getFileObject(RemoteProjectFactory.PROJECT_DIR.toUpperCase());
                    }
                    if (nbprojFO != null) {
                        nbprojFO.delete();
                    }
                    DataFolder projectData = DataFolder.create((DataFolder)projectFolder, (String)RemoteProjectFactory.PROJECT_DIR.toUpperCase());
                    created2.add(projectData);
                    FileObject fob = projectData.getPrimaryFile();
                    System.out.println("remoteprojectfactory:" + fob.getNameExt());
                    FileObject projectProps = fob.createData(RemoteProjectFactory.PROJECT_PROPFILE.toUpperCase());
                    projectProps.getParent().refresh(false);
                    created2.add(projectProps);
                    Properties properties = new Properties();
                    properties.setProperty("nbpov.version", Float.toString(1.0f));
                    properties.setProperty("name", name);
                    FileLock lock = projectProps.lock();
                    try {
                        OutputStream stream = projectProps.getOutputStream(lock);
                        properties.store(stream, name + " OpenVMS 3GL project properties");
                        stream.flush();
                        stream.close();
                    }
                    finally {
                        lock.releaseLock();
                    }
                    fob = projectData.getPrimaryFile();
                    FileObject projectXml = fob.getFileObject(RemoteProjectFactory.PROJECT_XMLFILE);
                    if (projectXml == null) {
                        projectXml = fob.getFileObject(RemoteProjectFactory.PROJECT_XMLFILE.toUpperCase());
                    }
                    if (projectXml == null) {
                        projectXml = FileUtil.createData((FileObject)fob, (String)RemoteProjectFactory.PROJECT_XMLFILE.toUpperCase());
                    }
                    Document doc = XMLUtil.createDocument((String)"project", (String)"http://www.netbeans.org/ns/project/1", null, null);
                    Element conf = doc.createElementNS("http://www.netbeans.org/ns/project/1", "configuration");
                    Element el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "type");
                    el.appendChild(doc.createTextNode(RemoteProjectFactory.PROJECT_TYPE));
                    doc.getDocumentElement().appendChild(el);
                    doc.getDocumentElement().appendChild(conf);
                    if (name != null) {
                        el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "name");
                        el.appendChild(doc.createTextNode(name));
                        doc.getDocumentElement().appendChild(el);
                    }
                    if ((privateXml = fob.getFileObject(RemoteProjectFactory.PRIVATE_XMLFILE)) == null) {
                        privateXml = fob.getFileObject(RemoteProjectFactory.PRIVATE_XMLFILE.toUpperCase());
                    }
                    if (privateXml == null) {
                        privateXml = FileUtil.createData((FileObject)fob, (String)("PRIVATE/" + RemoteProjectFactory.PRIVATE_XMLFILE.toUpperCase()));
                    }
                    Document pdoc = XMLUtil.createDocument((String)"project-private", (String)"http://www.netbeans.org/ns/project-private/1", null, null);
                    Element e2 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs_list");
                    for (int i = 0; i < fss.size(); ++i) {
                        Element e3 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                        e3.setAttribute("name", ((FileSystem)fss.get(i)).getDisplayName());
                        e3.appendChild(pdoc.createTextNode(Utils.serializeObj((FileSystem)fss.get(i))));
                        e2.appendChild(e3);
                    }
                    Utils.createRemoteProjectSettings(doc);
                    pdoc.getDocumentElement().appendChild(e2);
                    lock = projectXml.lock();
                    try {
                        os = projectXml.getOutputStream(lock);
                        try {
                            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                        }
                        finally {
                            os.close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                    lock = privateXml.lock();
                    try {
                        os = privateXml.getOutputStream(lock);
                        try {
                            XMLUtil.write((Document)pdoc, (OutputStream)os, (String)"UTF-8");
                        }
                        finally {
                            os.close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                    ProjectManager.getDefault().clearNonProjectCache();
                    Project p = ProjectManager.getDefault().findProject(projectFolder.getPrimaryFile());
                    if (p == null) {
                        Iterator it = Lookup.getDefault().lookup(new Lookup.Template(RemoteProject.class)).allInstances().iterator();
                        if (it.hasNext()) {
                            RemoteProject abpt = (RemoteProject)it.next();
                            throw new IllegalArgumentException("For some reason the folder " + fob + " with a new project of type " + RemoteProjectFactory.PROJECT_TYPE + " is still not recognized");
                        }
                        throw new IllegalArgumentException("No remote project factory for type org.netbeans.modules.distributed.remoteproject");
                    }
                    ProjectState state = (ProjectState)p.getLookup().lookup(ProjectState.class);
                    state.markModified();
                    return projectFolder;
                }
                catch (IOException ioe) {
                    Iterator i = created2.iterator();
                    while (i.hasNext()) {
                        try {
                            Object o = i.next();
                            FileObject fob = o instanceof DataObject ? ((DataObject)o).getPrimaryFile() : (FileObject)o;
                            fob.delete();
                        }
                        catch (Exception e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                    return ioe;
                }
            }
        });
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        return (DataFolder)result;
    }
}

