/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteJarFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkJarFileSystem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import patchsources.OpenProjectList_Dist;

public class RemoteFSUtils {
    public static String _winPathToOpenVMSPath(String winPath, boolean isDir, FileObject fobj) {
        String vmsPath = winPath;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (fobj.getFileSystem() instanceof FTPFileSystem) {
                FTPFileSystem nfs = (FTPFileSystem)fobj.getFileSystem();
                map.put("REMOTE_ROOT", nfs.getRemoteRoot());
                map.put("LCOAL_ROOT", nfs.getCache().getAbsolutePath());
            } else if (fobj.getFileSystem() instanceof NetworkFileSystem) {
                NetworkFileSystem nfs = (NetworkFileSystem)fobj.getFileSystem();
                map.put("REMOTE_ROOT", nfs.getRemoteRoot());
                map.put("LCOAL_ROOT", nfs.getRootDirectory().getAbsolutePath());
            } else {
                NetworkJarFileSystem nfs = (NetworkJarFileSystem)fobj.getFileSystem();
                map.put("REMOTE_ROOT", nfs.getRemoteJarRoot().getRemoteJarRoot());
                map.put("LCOAL_ROOT", nfs.getJarFile().getAbsolutePath());
            }
            vmsPath = FileUtility.winPathToOpenVMSPath(winPath, isDir, map);
        }
        catch (Exception e) {
            // empty catch block
        }
        return vmsPath;
    }

    public static String __winPathToOpenVMSPath(String winPath, boolean isDir) {
        FileObject[] fobjs = FileUtil.fromFile((File)new File(winPath));
        for (int i = 0; i < fobjs.length; ++i) {
            try {
                if (!(fobjs[i].getFileSystem() instanceof NetworkFileSystem) && !(fobjs[i].getFileSystem() instanceof FTPFileSystem)) continue;
                return RemoteFSUtils._winPathToOpenVMSPath(winPath, isDir, fobjs[i]);
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        for (Object obj : OpenProjectList_Dist.getFsSet()) {
            NetworkJarFileSystem njfs;
            if (!(obj instanceof NetworkJarFileSystem) || !winPath.equals((njfs = (NetworkJarFileSystem)obj).getJarFile().getAbsolutePath())) continue;
            return RemoteFSUtils._winPathToOpenVMSPath(winPath, false, njfs.getRoot());
        }
        return winPath;
    }

    public static String __unixPathToOpenVMSPath(String unixPath, boolean isDir) {
        FileObject[] fobjs = FileUtil.fromFile((File)new File(unixPath));
        for (int i = 0; i < fobjs.length; ++i) {
            try {
                if (!(fobjs[i].getFileSystem() instanceof NetworkFileSystem) && !(fobjs[i].getFileSystem() instanceof FTPFileSystem)) continue;
                return RemoteFSUtils.unixPathToOpenVMSPath(unixPath, isDir, fobjs[i]);
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        for (Object obj : OpenProjectList_Dist.getFsSet()) {
            NetworkJarFileSystem njfs;
            if (!(obj instanceof NetworkJarFileSystem) || !unixPath.equals((njfs = (NetworkJarFileSystem)obj).getJarFile().getAbsolutePath())) continue;
            return RemoteFSUtils.unixPathToOpenVMSPath(unixPath, false, njfs.getRoot());
        }
        return unixPath;
    }

    public static String unixPathToOpenVMSPath(String unixPath, boolean isDir, FileObject fobj) {
        String vmsPath = unixPath;
        try {
            String localRelPath;
            String unixRoot;
            AbstractNetworkFileSystem nfs;
            HashMap map = new HashMap();
            if (fobj.getFileSystem() instanceof FTPFileSystem) {
                nfs = (FTPFileSystem)fobj.getFileSystem();
                unixRoot = FileUtility.openVMSPathToUnixPath(((FTPFileSystem)nfs).getRemoteRoot(), true);
                localRelPath = vmsPath.substring(((FTPFileSystem)nfs).getCache().getAbsolutePath().length());
            } else if (fobj.getFileSystem() instanceof NetworkFileSystem) {
                nfs = (NetworkFileSystem)fobj.getFileSystem();
                unixRoot = FileUtility.openVMSPathToUnixPath(((NetworkFileSystem)nfs).getRemoteRoot(), true);
                localRelPath = vmsPath.substring(nfs.getRootDirectory().getAbsolutePath().length());
            } else {
                nfs = (NetworkJarFileSystem)fobj.getFileSystem();
                unixRoot = FileUtility.openVMSPathToUnixPath(((RemoteJarFileSystem)nfs).getRemoteJarRoot().getRemoteJarRoot(), true);
                localRelPath = vmsPath.substring(nfs.getJarFile().getAbsolutePath().length());
            }
            String tmpPath = unixRoot + (localRelPath.indexOf(47) == 0 ? "" : "/") + localRelPath;
            vmsPath = FileUtility.unixPathToOpenVMSPath(tmpPath, isDir);
        }
        catch (Exception e) {
            // empty catch block
        }
        return vmsPath;
    }

    public static String getRemoteJarShare(RemoteRuntimeType rrt, String localJarFile) {
        String shareInfo = FileUtility.getShareName(localJarFile);
        String shareName = "";
        String localRoot = "";
        if (shareInfo.length() > 0) {
            if (Utilities.isWindows()) {
                shareName = shareInfo;
            } else {
                shareName = shareInfo.substring(0, shareInfo.indexOf(10));
                localRoot = shareInfo.substring(shareInfo.indexOf(10) + 1, shareInfo.length());
            }
            try {
                String remoteRootTmp = rrt.getNetworkShareRoot(shareName);
                if (remoteRootTmp != null) {
                    return RemoteFSUtils.createRemoteJarFile(remoteRootTmp, localJarFile, localRoot);
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return "";
    }

    private static String createRemoteJarFile(String remoteRootTmp, String localJarFile, String localRoot) {
        StringBuffer localDir = new StringBuffer(localJarFile);
        StringBuffer remoteDir = new StringBuffer(remoteRootTmp);
        String jarFileName = null;
        String relRemoteDir = null;
        if (Utilities.isWindows()) {
            jarFileName = localJarFile.substring(localJarFile.lastIndexOf(92) + 1);
            localDir.delete(localJarFile.lastIndexOf(92), localJarFile.length());
            localDir.delete(0, 2);
            relRemoteDir = localDir.toString().replace('\\', '.');
        } else {
            jarFileName = localJarFile.substring(localJarFile.lastIndexOf(47) + 1);
            localDir.delete(localJarFile.lastIndexOf(47), localJarFile.length());
            if (localRoot.length() > 0) {
                localDir.delete(0, localRoot.length());
            }
            relRemoteDir = localDir.toString().replace('/', '.');
        }
        if (remoteRootTmp.endsWith("]")) {
            remoteDir.deleteCharAt(remoteRootTmp.length() - 1);
        } else {
            remoteDir.append('[');
        }
        remoteDir.append(relRemoteDir);
        remoteDir.append("]");
        remoteDir.append(jarFileName);
        return remoteDir.toString();
    }

    public static String getServerOS(RemoteRuntimeType rrt) {
        String os = "";
        if (rrt == null || rrt.getRemoteRuntime() == null) {
            return os;
        }
        try {
            os = rrt.getRemoteRuntime().getOperatingSystem();
        }
        catch (RemoteException re) {
            re.printStackTrace(System.err);
        }
        return os;
    }

    public static File toFile(FileObject fo) {
        return (File)fo.getAttribute("java.io.File");
    }

    private static String getSearchRoot(String remoteRootName, AbstractNetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        String searchRootName = remoteRootName;
        if (RemoteFSUtils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            searchRootName = remoteRootName.endsWith(":") ? remoteRootName : remoteRootName.substring(0, remoteRootName.length() - 1);
        }
        return searchRootName;
    }

    public static void refreshParent(String fileName, String root, char sep, FileSystem fs) {
        String parent = fileName.substring(root.length() + 1);
        parent = parent.lastIndexOf(sep) > 0 ? parent.substring(0, parent.lastIndexOf(sep)).replace(sep, '/') : "";
        FileObject pfo = fs.findResource(parent);
        if (pfo != null) {
            pfo.refresh();
        }
    }

    private static String getClientPath(String fileName, String remoteRootName, AbstractNetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        if (RemoteFSUtils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            if (Utilities.isWindows()) {
                return FileUtility.openVMSPathToWinPath(fileName, false, nfs.getLocalRoot(), remoteRootName);
            }
            if (Utilities.isUnix()) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
            if (Utilities.getOperatingSystem() == 16384) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
        }
        return fileName;
    }

    public static FileObject[] fromFile(String fileName) {
        Iterator en = OpenProjectList_Dist.getFsSet().iterator();
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        while (en.hasNext()) {
            FileSystem fs = (FileSystem)en.next();
            if (!(fs instanceof NetworkFileSystem) && !(fs instanceof FTPFileSystem)) continue;
            try {
                File file2Fo;
                FileObject fo;
                String res;
                AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
                File root = RemoteFSUtils.toFile(fs.getRoot());
                if (root == null) continue;
                String rootName = root.getCanonicalPath();
                String remoteRootName = nfs.getRemoteRoot();
                String searchRootName = RemoteFSUtils.getSearchRoot(remoteRootName, nfs);
                if (fileName.toLowerCase().indexOf(searchRootName.toLowerCase()) == 0 && (fileName.charAt(remoteRootName.length() - 1) == '.' || fileName.charAt(remoteRootName.length() - 1) == ']')) {
                    fileName = RemoteFSUtils.getClientPath(fileName, remoteRootName, nfs);
                    res = fileName.substring(rootName.length()).replace(File.separatorChar, '/');
                    RemoteFSUtils.refreshParent(fileName, rootName, File.separatorChar, fs);
                    fo = fs.findResource(res);
                    File file = file2Fo = fo != null ? RemoteFSUtils.toFile(fo) : null;
                    if (fo == null || file2Fo == null) continue;
                    list.add(fo);
                    continue;
                }
                if (RemoteFSUtils.getServerOS(nfs.getRemoteRuntimeType()).toLowerCase().indexOf(Utils.OS_VMS.toLowerCase()) < 0) continue;
                remoteRootName = FileUtility.openVMSPathToUnixPath(remoteRootName, true);
                if (fileName.toLowerCase().indexOf(remoteRootName.toLowerCase()) != 0 || fileName.charAt(remoteRootName.length()) != '/') continue;
                res = fileName.substring(remoteRootName.length() + 1);
                RemoteFSUtils.refreshParent(fileName, remoteRootName, '/', fs);
                fo = fs.findResource(res);
                File file = file2Fo = fo != null ? RemoteFSUtils.toFile(fo) : null;
                if (fo == null || file2Fo == null) continue;
                list.add(fo);
            }
            catch (IOException iexc) {}
        }
        FileObject[] results = new FileObject[list.size()];
        list.toArray(results);
        return results;
    }
}

