/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.distributed.remoteexecute.RemoteOutputStreamParse;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.ExternalCompiler;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class OutputWriterOutputStream
extends RemoteOutputStreamParse {
    private OutputWriter writer;
    private static final Set hyperlinks = new WeakSet();

    public OutputWriterOutputStream(OutputWriter writer, ExternalCompiler.ErrorExpression errExp) {
        super(errExp);
        this.writer = writer;
    }

    protected void handleClose() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected void writeLine(String line, FileObject file, int line1, int col1, int line2, int col2, String message) throws IOException {
        Hyperlink h = new Hyperlink(file, line1, col1, line2, col2, message);
        String fname = file.getPath();
        this.writer.println(this.formatMessage(fname, message, line1, col1, line2, col2), (OutputListener)h);
    }

    protected void writeLine(String line) throws IOException {
        this.writer.println(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator it = hyperlinks.iterator();
            while (it.hasNext()) {
                ((Hyperlink)it.next()).destroy();
            }
        }
    }

    public static final class Hyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private FileObject file;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;
        private boolean dead = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hyperlink(FileObject file, int line1, int col1, int line2, int col2, String message) {
            this.file = file;
            this.line1 = line1;
            this.col1 = col1;
            this.line2 = line2;
            this.col2 = col2;
            this.message = message;
            Set set = hyperlinks;
            synchronized (set) {
                hyperlinks.add(this);
            }
        }

        void destroy() {
            this.doDetach();
            this.dead = true;
        }

        public void outputLineAction(OutputEvent ev) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.message != null) {
                StatusDisplayer.getDefault().setStatusText(this.message);
            }
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ed != null) {
                    if (this.line1 == -1) {
                        ed.open();
                    } else {
                        ed.openDocument();
                        Line l = ed.getLineSet().getOriginal(this.line1);
                        if (!l.isDeleted()) {
                            this.attachAsNeeded(l);
                            if (this.col1 == -1) {
                                l.show(2);
                            } else {
                                l.show(2, this.col1);
                            }
                        }
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IndexOutOfBoundsException iobe) {
                ErrorManager.getDefault().notify(16, (Throwable)iobe);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
            }
        }

        public void outputLineSelected(OutputEvent ev) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ed != null) {
                    Line l;
                    if (ed.getDocument() == null) {
                        return;
                    }
                    if (this.line1 != -1 && !(l = ed.getLineSet().getOriginal(this.line1)).isDeleted()) {
                        this.attachAsNeeded(l);
                        if (this.col1 == -1) {
                            l.show(0);
                        } else {
                            l.show(0, this.col1);
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IndexOutOfBoundsException iobe) {
                ErrorManager.getDefault().notify(16, (Throwable)iobe);
            }
        }

        private synchronized void attachAsNeeded(Line l) {
            if (this.getAttachedAnnotatable() == null) {
                Object ann;
                boolean log = true;
                String text = l.getText();
                if (text != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                    int new_col1 = this.convertTabColumnsToCharacterColumns(text, this.col1, 8);
                    int new_col2 = this.convertTabColumnsToCharacterColumns(text, this.col2, 8);
                    ann = new_col2 != -1 && new_col2 >= new_col1 && new_col2 < text.length() ? l.createPart(new_col1, new_col2 - new_col1 + 1) : (new_col1 < text.length() ? l.createPart(new_col1, text.length() - new_col1 - 1) : l);
                } else {
                    ann = l;
                }
                this.attach((Annotatable)ann);
                for (Hyperlink h : hyperlinks) {
                    if (h == this) continue;
                    h.doDetach();
                }
                ann.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private int convertTabColumnsToCharacterColumns(String text, int column, int tabSize) {
            int i;
            char[] textChars = text.toCharArray();
            int jikes_column = 0;
            for (i = 0; i < textChars.length && jikes_column < column; ++i) {
                if (textChars[i] == '\t') {
                    jikes_column += tabSize - jikes_column % tabSize;
                    continue;
                }
                ++jikes_column;
            }
            return i;
        }

        private synchronized void doDetach() {
            Annotatable ann = this.getAttachedAnnotatable();
            if (ann != null) {
                ann.removePropertyChangeListener((PropertyChangeListener)this);
                this.detach();
            }
        }

        public void outputLineCleared(OutputEvent ev) {
            this.doDetach();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (this.dead) {
                return;
            }
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("text") || prop.equals("deleted")) {
                this.doDetach();
            }
        }

        public String getAnnotationType() {
            return "org-apache-tools-ant-module-error";
        }

        public String getShortDescription() {
            return this.message;
        }

        public String toString() {
            return "Hyperlink[" + this.file + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
        }
    }

    public static final class InlineHyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private FileObject file;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;
        private boolean dead = false;

        public InlineHyperlink(FileObject file, int line1, int col1, int line2, int col2, String message) {
            this.file = file;
            this.line1 = line1;
            this.col1 = col1;
            this.line2 = line2;
            this.col2 = col2;
            this.message = message;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InlineHyperlink)) {
                return false;
            }
            InlineHyperlink hl = (InlineHyperlink)obj;
            return this.file.equals(hl.file) && this.line1 == hl.line1;
        }

        public int hashCode() {
            return this.file.hashCode() + this.line1;
        }

        public FileObject getFileObject() {
            return this.file;
        }

        public int getLine1() {
            return this.line1;
        }

        void destroy() {
            this.doDetach();
            this.dead = true;
        }

        public void outputLineAction(OutputEvent ev) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.message != null) {
                StatusDisplayer.getDefault().setStatusText(this.message);
            }
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ed != null) {
                    if (this.line1 == -1) {
                        ed.open();
                    } else {
                        ed.openDocument();
                        Line l = ed.getLineSet().getOriginal(this.line1);
                        if (!l.isDeleted()) {
                            this.attachAsNeeded(l);
                            if (this.col1 == -1) {
                                l.show(2);
                            } else {
                                l.show(2, this.col1);
                            }
                        }
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IndexOutOfBoundsException iobe) {
                ErrorManager.getDefault().notify(16, (Throwable)iobe);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
            }
        }

        public void outputLineSelected(OutputEvent ev) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ed != null) {
                    Line l;
                    if (ed.getDocument() == null) {
                        return;
                    }
                    if (this.line1 != -1 && !(l = ed.getLineSet().getOriginal(this.line1)).isDeleted()) {
                        this.attachAsNeeded(l);
                        if (this.col1 == -1) {
                            l.show(0);
                        } else {
                            l.show(0, this.col1);
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IndexOutOfBoundsException iobe) {
                ErrorManager.getDefault().notify(16, (Throwable)iobe);
            }
        }

        private synchronized void attachAsNeeded(Line l) {
            if (this.getAttachedAnnotatable() == null) {
                Object ann;
                boolean log = true;
                String text = l.getText();
                if (text != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                    int new_col1 = this.convertTabColumnsToCharacterColumns(text, this.col1, 8);
                    int new_col2 = this.convertTabColumnsToCharacterColumns(text, this.col2, 8);
                    ann = new_col2 != -1 && new_col2 >= new_col1 && new_col2 < text.length() ? l.createPart(new_col1, new_col2 - new_col1 + 1) : (new_col1 < text.length() ? l.createPart(new_col1, text.length() - new_col1 - 1) : l);
                } else {
                    ann = l;
                }
                this.attach((Annotatable)ann);
                ann.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private int convertTabColumnsToCharacterColumns(String text, int column, int tabSize) {
            int i;
            char[] textChars = text.toCharArray();
            int jikes_column = 0;
            for (i = 0; i < textChars.length && jikes_column < column; ++i) {
                if (textChars[i] == '\t') {
                    jikes_column += tabSize - jikes_column % tabSize;
                    continue;
                }
                ++jikes_column;
            }
            return i;
        }

        private synchronized void doDetach() {
            Annotatable ann = this.getAttachedAnnotatable();
            if (ann != null) {
                ann.removePropertyChangeListener((PropertyChangeListener)this);
                this.detach();
            }
        }

        public void outputLineCleared(OutputEvent ev) {
            this.doDetach();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (this.dead) {
                return;
            }
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("text") || prop.equals("deleted")) {
                this.doDetach();
            }
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-java-parser_annotation";
        }

        public String getShortDescription() {
            return this.message;
        }

        public String toString() {
            return "inLineHyperlink[" + this.file + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
        }
    }
}

