/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.fortransupport.fortran.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.RemoteCompilerAction;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompiler;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompilerGroup;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompilerType;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranDataNode;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie;
import org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie;
import org.netbeans.modules.distributed.common.propertyeditors.BoolEditor;
import org.netbeans.modules.distributed.common.propertyeditors.NbProcessDescriptorEditor2;
import org.netbeans.modules.distributed.common.propertyeditors.StringEditor2;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.ErrorManager;
import org.openide.compiler.CompilerSupport;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FortranCompilerSupport
extends CompilerSupport {
    public static final String PROP_DEFINE = "fortranDefine";
    public static final String PROP_BUILD_OPTION = "buildOption";
    public static final String PROP_OPTIMIZE = "optimize";
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_F77 = "f77";
    public static final String PROP_OBJECT_DIRECTORY = "objectDirectory";
    public static final String PROP_ANALYSIS_DATA = "analysisData";
    public static final String PROP_OUTPUT_SWITCH = "outputSwitch";
    public static final String PROP_BUILD_COMMAND = "buildCommand";
    public static final String PROP_INCLUDE = "include";
    public static final String PROP_LIBRARY = "library";
    public static final String PROP_DEBUG = "debug";
    public static final String PROP_INTEGER_SIZE = "integerSize";
    public static final String PROP_FLOAT = "float";
    public static final String PROP_MODULE = "module";
    public static final String PROP_OTHER_OPTIONS = "otherOptions";
    public static final String PROP_SOURCE_FORM = "source_form";
    public static final String PROP_EXTEND_SOURCE = "extend_source";
    public static final String PROP_EXTERNAL_COMPILER = "externalCompiler";
    public static final String PROP_MAKEFILE_COMPILER = "makefileCompiler";
    public static final String PROP_FORTRAN_GLOBAL_QUALIFIER = "globalQualifier";
    public static final String PROP_FORTRAN_LOCAL_QUALIFIER = "localQualifier";
    protected static final ResourceBundle bundle = NbBundle.getBundle(FortranCompilerSupport.class);
    protected MultiDataObject.Entry entry;

    protected FortranCompilerSupport(MultiDataObject.Entry entry, Class cookie) {
        super(entry, cookie);
        this.entry = entry;
    }

    protected FortranCompilerType getProjCompilerType() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getFileObject());
        if (project != null) {
            RemoteProjectSettings rs = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (rs == null) {
                return new FortranCompilerType(this.getFileObject());
            }
            return (FortranCompilerType)((Object)rs.getCompilerSettings("fortran"));
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createExternalCompilerProperty());
        set.put((Node.Property)this.createSourceFormProperty());
        if (this.getSourceForm().equals("FREE")) {
            set.put((Node.Property)this.createExtendSourcePropertyReadOnly());
        } else {
            set.put((Node.Property)this.createExtendSourceProperty());
        }
        set.put((Node.Property)this.createFortranLocalQualifierProperty());
        set.put((Node.Property)this.createFortranGlobalQualifierProperty());
    }

    public void addBuildOptionProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildOptionProperty());
    }

    public void addMakefileProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildDirectoryProperty());
        set.put((Node.Property)this.createMakefileCompilerProperty());
        set.put((Node.Property)this.createBuildCommandProperty());
        set.put((Node.Property)this.createOutputSwitchProperty());
        set.put((Node.Property)this.createXDisplayDeviceNumber());
    }

    public void addRemoteProperties(Sheet.Set set) {
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (this.entry.getFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public Boolean getBuildOption() {
        Boolean useMakefile = (Boolean)this.entry.getFile().getAttribute(PROP_BUILD_OPTION);
        if (useMakefile == null) {
            return (Boolean)this.getProjCompilerType().getBuildOption();
        }
        return useMakefile;
    }

    private synchronized void setBuildOption(Boolean buildProperty) throws IOException {
        Node node = this.entry.getDataObject().getNodeDelegate();
        Node.PropertySet[] ps = node.getPropertySets();
        if (buildProperty == null) {
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, null);
        } else if (node instanceof FortranDataNode) {
            if (buildProperty.equals(Boolean.TRUE)) {
                ps[1].setHidden(true);
                ps[2].setHidden(false);
            } else {
                ps[1].setHidden(false);
                ps[2].setHidden(true);
            }
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, (Object)buildProperty);
            ((FortranDataNode)node).firePropertySetChange2(null, ps);
        }
    }

    public Boolean getExtendSource() {
        Boolean useExtendSource = (Boolean)this.entry.getFile().getAttribute(PROP_EXTEND_SOURCE);
        if (useExtendSource == null) {
            return Boolean.FALSE;
        }
        return useExtendSource;
    }

    private synchronized void setExtendSource(Boolean extendSourceProperty) throws IOException {
        if (extendSourceProperty == null) {
            this.entry.getFile().setAttribute(PROP_EXTEND_SOURCE, null);
        } else {
            this.entry.getFile().setAttribute(PROP_EXTEND_SOURCE, (Object)extendSourceProperty);
        }
    }

    public RemoteFSFile getBuildDirectory() {
        Object buildDir = this.entry.getFile().getAttribute(PROP_BUILD_DIRECTORY);
        if (buildDir == null || buildDir instanceof RemoteFSFile && ((RemoteFSFile)buildDir).getAbsolutePath().equals("")) {
            return this.getProjCompilerType().getBuildDirectory();
        }
        if (buildDir != null && !(buildDir instanceof RemoteFSFile)) {
            try {
                this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getBuildDirectory();
        }
        return (RemoteFSFile)buildDir;
    }

    private synchronized void setBuildDirectory(RemoteFSFile buildDirectory) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, (Object)buildDirectory);
    }

    public Boolean getOutputSwitch() {
        Boolean outputSwitch = (Boolean)this.entry.getFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (outputSwitch == null) {
            return this.getProjCompilerType().outputSwitch();
        }
        return outputSwitch;
    }

    private synchronized void setOutputSwitch(Boolean outputSwitch) throws IOException {
        this.entry.getFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)outputSwitch);
    }

    public Integer getXDisplayNumber() {
        Integer xSwitch = (Integer)this.entry.getFile().getAttribute("xDisplayDeviceNumber");
        if (xSwitch == null) {
            return this.getProjCompilerType().xDisplayNumber();
        }
        return xSwitch;
    }

    private synchronized void setXDisplayNumber(Integer XSwitch) throws IOException {
        this.entry.getFile().setAttribute("xDisplayDeviceNumber", (Object)XSwitch);
    }

    public String getBuildCommand() {
        String buildCommand = (String)this.entry.getFile().getAttribute(PROP_BUILD_COMMAND);
        if (buildCommand == null) {
            return this.getProjCompilerType().getBuildCommand();
        }
        return buildCommand;
    }

    private synchronized void setBuildCommand(String buildCommand) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_COMMAND, (Object)buildCommand);
    }

    private String getCurrentFileDir() {
        try {
            String rootDir = FileUtil.toFile((FileObject)this.entry.getDataObject().getPrimaryFile().getFileSystem().getRoot()).getAbsolutePath();
            String fileDir = this.entry.getDataObject().getPrimaryFile().getParent().getPath();
            Object objectDir = null;
            return rootDir + '/' + fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void setLocalQualifier(String option) throws IOException {
        this.entry.getFile().setAttribute(PROP_FORTRAN_LOCAL_QUALIFIER, (Object)option);
    }

    private void setGlobalQualifier(String option) throws IOException {
        this.entry.getFile().setAttribute(PROP_FORTRAN_GLOBAL_QUALIFIER, (Object)option);
    }

    public String getLocalQualifier() {
        String option = (String)this.entry.getFile().getAttribute(PROP_FORTRAN_LOCAL_QUALIFIER);
        if (option == null) {
            return this.getProjCompilerType().getLocalQualifier();
        }
        return option;
    }

    public String getGlobalQualifier() {
        String option = (String)this.entry.getFile().getAttribute(PROP_FORTRAN_GLOBAL_QUALIFIER);
        if (option == null) {
            return this.getProjCompilerType().getGlobalQualifier();
        }
        return option;
    }

    public String getSourceForm() {
        String sourceForm = (String)this.entry.getFile().getAttribute(PROP_SOURCE_FORM);
        if (sourceForm != null) {
            if (sourceForm.length() == 5) {
                if (sourceForm.toUpperCase().equals("FIXED")) {
                    return "FIXED";
                }
            } else if (sourceForm.length() == 4) {
                if (sourceForm.toUpperCase().equals("FIXE")) {
                    return "FIXED";
                }
                if (sourceForm.toUpperCase().equals("FREE")) {
                    return "FREE";
                }
            } else if (sourceForm.length() == 3) {
                if (sourceForm.toUpperCase().equals("FIX")) {
                    return "FIXED";
                }
                if (sourceForm.toUpperCase().equals("FRE")) {
                    return "FREE";
                }
            } else if (sourceForm.length() == 2) {
                if (sourceForm.toUpperCase().equals("FI")) {
                    return "FIXED";
                }
                if (sourceForm.toUpperCase().equals("FR")) {
                    return "FREE";
                }
            }
        }
        if (this.isF90orF95File()) {
            return "FREE";
        }
        return "FIXED";
    }

    public synchronized void setSourceForm(String newSourceForm) throws IOException {
        this.entry.getFile().setAttribute(PROP_SOURCE_FORM, (Object)newSourceForm);
    }

    public NbProcessDescriptor getExternalCompiler() {
        Object obj = this.entry.getFile().getAttribute(PROP_EXTERNAL_COMPILER);
        if (obj != null && obj instanceof NbProcessDescriptor) {
            return (NbProcessDescriptor)obj;
        }
        return this.getProjCompilerType().getExternalCompiler();
    }

    private void setExternalCompiler(NbProcessDescriptor externalCompiler) throws IOException {
        this.entry.getFile().setAttribute(PROP_EXTERNAL_COMPILER, (Object)externalCompiler);
    }

    public boolean isF90orF95File() {
        String retStr = this.entry.getFile().getExt();
        return retStr.toUpperCase().equals("F90") || retStr.toUpperCase().equals("F95");
    }

    private void setMakefileCompiler(RemoteFSFile externalCompiler) throws IOException {
        this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, (Object)externalCompiler);
    }

    public RemoteFSFile getMakefileCompiler() {
        Object obj = this.entry.getFile().getAttribute(PROP_MAKEFILE_COMPILER);
        if (obj != null && obj instanceof RemoteFSFile) {
            return (RemoteFSFile)obj;
        }
        if (obj != null && obj instanceof String) {
            try {
                this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getMakefileCompiler();
        }
        return this.getProjCompilerType().getMakefileCompiler();
    }

    private PropertySupport createBuildOptionProperty() {
        class BuildOptionPropertySupport
        extends PropertySupport.ReadWrite {
            public BuildOptionPropertySupport() {
                super(FortranCompilerSupport.PROP_BUILD_OPTION, Object.class, FortranCompilerSupport.this.getFlaggedNameBuildOption(FortranCompilerSupport.this.getString("PROP_BUILD_OPTION"), FortranCompilerSupport.PROP_BUILD_OPTION), FortranCompilerSupport.this.getString("HINT_BUILD_OPTION"));
                this.setValue("helpID", "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
                FortranCompilerSupport.this.setDefaultFunction((PropertySupport)this, FortranCompilerSupport.PROP_BUILD_OPTION, "org.openide.filesystems.FileObject");
                if (FortranCompilerSupport.this.getProjCompilerType().getBuildOption() != null) {
                    this.setValue("projValue", FortranCompilerSupport.this.getProjCompilerType().getBuildOption());
                }
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getBuildOption();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        FortranCompilerSupport.this.setBuildOption((Boolean)val);
                        FortranCompilerSupport.this.flagProperty(FortranCompilerSupport.this.getFlaggedNameBuildOption(FortranCompilerSupport.this.getString("PROP_BUILD_OPTION"), FortranCompilerSupport.PROP_BUILD_OPTION), FortranCompilerSupport.PROP_BUILD_OPTION);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(FortranCompilerSupport.this.getBuildOption());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new BuildOptionPropertySupport();
    }

    private PropertySupport createExtendSourceProperty() {
        class ExtendSourcePropertySupport
        extends PropertySupport.ReadWrite {
            public ExtendSourcePropertySupport() {
                super(FortranCompilerSupport.PROP_EXTEND_SOURCE, Boolean.class, FortranCompilerSupport.this.getFlaggedNameBuildOption(FortranCompilerSupport.this.getString("PROP_EXTEND_SOURCE"), FortranCompilerSupport.PROP_EXTEND_SOURCE), FortranCompilerSupport.this.getString("HINT_EXTEND_SOURCE"));
                this.setValue("helpID", "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getExtendSource();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        FortranCompilerSupport.this.setExtendSource((Boolean)val);
                        FortranCompilerSupport.this.flagProperty(FortranCompilerSupport.this.getFlaggedNameBuildOption(FortranCompilerSupport.this.getString("PROP_EXTEND_SOURCE"), FortranCompilerSupport.PROP_EXTEND_SOURCE), FortranCompilerSupport.PROP_EXTEND_SOURCE);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(FortranCompilerSupport.this.getExtendSource());
            }
        }
        return new ExtendSourcePropertySupport();
    }

    private PropertySupport createBuildDirectoryProperty() {
        class PropertySupportBuildDirectory
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildDirectory() {
                super(FortranCompilerSupport.PROP_BUILD_DIRECTORY, RemoteFSFile.class, FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_BUILD_DIRECTORY"), FortranCompilerSupport.PROP_BUILD_DIRECTORY), FortranCompilerSupport.this.getString("HINT_BUILD_DIRECTORY"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.FALSE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", FortranCompilerSupport.this.entry.getFile().getNameExt());
                if (FortranCompilerSupport.this.getProjCompilerType().getBuildDirectory() != null) {
                    this.setValue("projvalue", FortranCompilerSupport.this.getProjCompilerType().getBuildDirectory());
                }
                try {
                    if (FortranCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", FortranCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FortranCompilerSupport.this.setDefaultFunction((PropertySupport)this, FortranCompilerSupport.PROP_BUILD_DIRECTORY, "com.hp.openvms.netbeans.fortransupport.settings.FortranFileMakefileSettings");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getBuildDirectory();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof RemoteFSFile || val == null) {
                    try {
                        FortranCompilerSupport.this.setBuildDirectory((RemoteFSFile)val);
                        FortranCompilerSupport.this.flagProperty(FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_BUILD_DIRECTORY"), FortranCompilerSupport.PROP_BUILD_DIRECTORY), FortranCompilerSupport.PROP_BUILD_DIRECTORY);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(FortranCompilerSupport.this.getBuildDirectory());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new PropertySupportBuildDirectory();
    }

    private PropertySupport createOutputSwitchProperty() {
        class OutputSwitchPropertySupport
        extends PropertySupport.ReadWrite {
            public OutputSwitchPropertySupport() {
                super(FortranCompilerSupport.PROP_OUTPUT_SWITCH, Object.class, FortranCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), FortranCompilerSupport.this.getString("HINT_OUTPUT_SWITCH"));
                FortranCompilerSupport.this.setDefaultFunction((PropertySupport)this, FortranCompilerSupport.PROP_OUTPUT_SWITCH, "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
                if (FortranCompilerSupport.this.getProjCompilerType().outputSwitch() != null) {
                    this.setValue("projValue", FortranCompilerSupport.this.getProjCompilerType().outputSwitch());
                }
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getOutputSwitch();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        FortranCompilerSupport.this.setOutputSwitch((Boolean)val);
                        FortranCompilerSupport.this.flagProperty(FortranCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), FortranCompilerSupport.PROP_OUTPUT_SWITCH);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(FortranCompilerSupport.this.getOutputSwitch());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new OutputSwitchPropertySupport();
    }

    private PropertySupport createBuildCommandProperty() {
        class PropertySupportBuildCommand
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildCommand() {
                super(FortranCompilerSupport.PROP_BUILD_COMMAND, String.class, FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_BUILD_COMMAND"), FortranCompilerSupport.PROP_BUILD_COMMAND), FortranCompilerSupport.this.getString("HINT_BUILD_COMMAND"));
                FortranCompilerSupport.this.setDefaultFunction((PropertySupport)this, FortranCompilerSupport.PROP_BUILD_COMMAND, "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getBuildCommand();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        FortranCompilerSupport.this.setBuildCommand((String)val);
                        FortranCompilerSupport.this.flagProperty(FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_BUILD_COMMAND"), FortranCompilerSupport.PROP_BUILD_COMMAND), FortranCompilerSupport.PROP_BUILD_COMMAND);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(FortranCompilerSupport.this.getBuildCommand());
            }

            public boolean canWrite() {
                return FortranCompilerSupport.this.entry.getFile().canWrite();
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new PropertySupportBuildCommand();
    }

    private PropertySupport createXDisplayDeviceNumber() {
        class XDisplayDeviceNumberPropertySupport
        extends PropertySupport.ReadWrite {
            public XDisplayDeviceNumberPropertySupport() {
                super("X Display Device Number", Integer.class, "X Display Device Number", "Defines the screen associated with the display device");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getXDisplayNumber();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Integer || val == null) {
                    try {
                        FortranCompilerSupport.this.setXDisplayNumber((Integer)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new XDisplayDeviceNumberPropertySupport();
    }

    private PropertySupport createExtendSourcePropertyReadOnly() {
        class ExtendSourcePropertySupportReadOnly
        extends PropertySupport.ReadOnly {
            public ExtendSourcePropertySupportReadOnly() {
                super(FortranCompilerSupport.PROP_EXTEND_SOURCE, Boolean.class, FortranCompilerSupport.this.getFlaggedNameBuildOption(FortranCompilerSupport.this.getString("PROP_EXTEND_SOURCE"), FortranCompilerSupport.PROP_EXTEND_SOURCE), FortranCompilerSupport.this.getString("HINT_EXTEND_SOURCE"));
                this.setValue("helpID", "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getExtendSource();
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new ExtendSourcePropertySupportReadOnly();
    }

    private PropertySupport createSourceFormProperty() {
        class SourceFormPropertySupport
        extends PropertySupport.ReadWrite {
            public SourceFormPropertySupport() {
                super(FortranCompilerSupport.PROP_SOURCE_FORM, String.class, FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_SOURCE_FORM"), FortranCompilerSupport.PROP_SOURCE_FORM), FortranCompilerSupport.this.getString("PROP_SOURCE_FORM"));
                FortranCompilerSupport.this.setDefaultFunction((PropertySupport)this, FortranCompilerSupport.PROP_SOURCE_FORM, "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getSourceForm();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void setValue(Object val) throws InvocationTargetException {
                if (!(val instanceof String) && val != null) throw new IllegalArgumentException();
                try {
                    Node node;
                    FortranCompilerSupport.this.setSourceForm((String)val);
                    FortranCompilerSupport.this.flagProperty(FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_SOURCE_FORM"), FortranCompilerSupport.PROP_SOURCE_FORM), FortranCompilerSupport.PROP_SOURCE_FORM);
                    if (val == null || !((node = FortranCompilerSupport.this.entry.getDataObject().getNodeDelegate()) instanceof FortranDataNode)) return;
                    Node.PropertySet[] ps = node.getPropertySets();
                    Node.Property[] props = ps[1].getProperties();
                    for (int i = 0; i < props.length; ++i) {
                        if (!props[i].getName().equals(FortranCompilerSupport.PROP_EXTEND_SOURCE)) continue;
                        if (val.equals("FIXED") && !props[i].canWrite()) {
                            props[i] = FortranCompilerSupport.this.createExtendSourceProperty();
                            break;
                        }
                        if (!val.equals("FREE") || !props[i].canWrite()) break;
                        props[i] = FortranCompilerSupport.this.createExtendSourcePropertyReadOnly();
                        break;
                    }
                    ((FortranDataNode)node).firePropertyChange2(null, null, null);
                    ((FortranDataNode)node).firePropertySetChange2(null, ps);
                    return;
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(FortranCompilerSupport.this.getSourceForm());
            }

            public PropertyEditor getPropertyEditor() {
                return new TagEditor();
            }
        }
        return new SourceFormPropertySupport();
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", String.class, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                FileObject fobj = FortranCompilerSupport.this.entry.getFile();
                Object obj = fobj.getAttribute("file_residence_mode");
                try {
                    RemoteFileSystem rf = (RemoteFileSystem)fobj.getFileSystem();
                    if (rf.getServerOnlyFileExts().isRegistered(fobj.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                if (obj != null) {
                    Integer itr = (Integer)obj;
                    String ret = "Make Client and Server";
                    switch (itr) {
                        case 1: {
                            ret = "Client Only";
                            break;
                        }
                        case 0: {
                            ret = "Server Only";
                            break;
                        }
                        case 2: {
                            ret = "Client and Server";
                        }
                    }
                    return ret;
                }
                return "Client and Server";
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", String.class, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                FileObject fobj = FortranCompilerSupport.this.entry.getFile();
                Object obj = fobj.getAttribute("REMOTE_FILEPATH");
                if (obj != null) {
                    return obj;
                }
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return vmsPath;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    FileObject fobj = FortranCompilerSupport.this.entry.getFile();
                    fobj.setAttribute("REMOTE_FILEPATH", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                FileObject fobj = FortranCompilerSupport.this.entry.getFile();
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                    this.setValue(vmsPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createExternalCompilerProperty() {
        class ExternalCompilerPropertySupport
        extends PropertySupport.ReadWrite {
            public ExternalCompilerPropertySupport() {
                super(FortranCompilerSupport.PROP_EXTERNAL_COMPILER, NbProcessDescriptor.class, FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_EXTERNAL_COMPILER"), FortranCompilerSupport.PROP_EXTERNAL_COMPILER), FortranCompilerSupport.this.getString("HINT_EXTERNAL_COMPILER"));
                FortranCompilerSupport.this.setDefaultFunction((PropertySupport)this, FortranCompilerSupport.PROP_EXTERNAL_COMPILER, "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getExternalCompiler();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof NbProcessDescriptor || val == null) {
                    try {
                        FortranCompilerSupport.this.setExternalCompiler((NbProcessDescriptor)val);
                        FortranCompilerSupport.this.flagProperty(FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_EXTERNAL_COMPILER"), FortranCompilerSupport.PROP_EXTERNAL_COMPILER), FortranCompilerSupport.PROP_EXTERNAL_COMPILER);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public PropertyEditor getPropertyEditor() {
                return new NbProcessDescriptorEditor2();
            }
        }
        return new ExternalCompilerPropertySupport();
    }

    private PropertySupport createMakefileCompilerProperty() {
        class MakefileProperty
        extends PropertySupport.ReadWrite {
            public MakefileProperty() {
                super(FortranCompilerSupport.PROP_MAKEFILE_COMPILER, RemoteFSFile.class, FortranCompilerSupport.this.getFlaggedNameMakefile(FortranCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), FortranCompilerSupport.PROP_MAKEFILE_COMPILER), FortranCompilerSupport.this.getString("HINT_MAKEFILE_COMPILER"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.TRUE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", FortranCompilerSupport.this.entry.getFile().getNameExt());
                if (FortranCompilerSupport.this.getProjCompilerType().getMakefileCompiler() != null) {
                    this.setValue("projvalue", FortranCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                }
                try {
                    if (FortranCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", FortranCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FortranCompilerSupport.this.setDefaultFunction((PropertySupport)this, FortranCompilerSupport.PROP_MAKEFILE_COMPILER, "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getMakefileCompiler();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof RemoteFSFile || val == null) {
                    try {
                        FortranCompilerSupport.this.setMakefileCompiler((RemoteFSFile)val);
                        FortranCompilerSupport.this.flagProperty(FortranCompilerSupport.this.getFlaggedNameMakefile(FortranCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), FortranCompilerSupport.PROP_MAKEFILE_COMPILER), FortranCompilerSupport.PROP_MAKEFILE_COMPILER);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(FortranCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new MakefileProperty();
    }

    private PropertySupport createFortranLocalQualifierProperty() {
        class FortranLocalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public FortranLocalQualifierPropertySupport() {
                super(FortranCompilerSupport.PROP_FORTRAN_LOCAL_QUALIFIER, String.class, FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_FORTRAN_LOCAL_QUALIFIER"), FortranCompilerSupport.PROP_FORTRAN_LOCAL_QUALIFIER), FortranCompilerSupport.this.getString("HINT_FORTRAN_LOCAL_QUALIFIER"));
                FortranCompilerSupport.this.setDefaultFunction((PropertySupport)this, FortranCompilerSupport.PROP_FORTRAN_LOCAL_QUALIFIER, "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getLocalQualifier();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        FortranCompilerSupport.this.setLocalQualifier((String)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(FortranCompilerSupport.this.getLocalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new FortranLocalQualifierPropertySupport();
    }

    private PropertySupport createFortranGlobalQualifierProperty() {
        class FortranGlobalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public FortranGlobalQualifierPropertySupport() {
                super(FortranCompilerSupport.PROP_FORTRAN_GLOBAL_QUALIFIER, String.class, FortranCompilerSupport.this.getFlaggedName(FortranCompilerSupport.this.getString("PROP_FORTRAN_GLOBAL_QUALIFIER"), FortranCompilerSupport.PROP_FORTRAN_GLOBAL_QUALIFIER), FortranCompilerSupport.this.getString("HINT_FORTRAN_GLOBAL_QUALIFIER"));
                FortranCompilerSupport.this.setDefaultFunction((PropertySupport)this, FortranCompilerSupport.PROP_FORTRAN_GLOBAL_QUALIFIER, "com.hp.openvms.netbeans.fortransupport.settings.FortranFileGeneralSettings");
            }

            public Object getValue() {
                return FortranCompilerSupport.this.getGlobalQualifier();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        FortranCompilerSupport.this.setGlobalQualifier((String)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(FortranCompilerSupport.this.getGlobalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new FortranGlobalQualifierPropertySupport();
    }

    private String getFlaggedNameBuildOption(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedNameMakefile(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedName(String dispName, String name) {
        return dispName;
    }

    protected String getString(String s) {
        return bundle.getString(s);
    }

    protected void flagProperty(String dispProp, String prop) {
    }

    protected void setDefaultFunction(PropertySupport ps, String propName, String helpID) {
        try {
            ps.setValue("method", (Object)FileObject.class.getMethod("getAttribute", String.class));
            ps.setValue("param", (Object)propName);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        ps.setValue("object", (Object)this.entry.getFile());
        ps.setValue("helpID", (Object)helpID);
    }

    public FileObject getFileObject() {
        return this.entry.getFile();
    }

    public static class RemoteBuild
    extends FortranCompilerSupport
    implements RemoteBuildCookie {
        public RemoteBuild(MultiDataObject.Entry entry) {
            super(entry, RemoteBuildCookie.class);
        }
    }

    public static class RemoteCompile
    extends FortranCompilerSupport
    implements RemoteCompileCookie {
        public RemoteCompile(MultiDataObject.Entry entry) {
            super(entry, RemoteCompileCookie.class);
        }

        public void compile() throws IOException {
            FortranCompiler compiler = new FortranCompiler(RemoteBuildCookie.class, this.getFileObject(), this.getExternalCompiler(), this.getProjCompilerType().getErrorExpression(), new FortranCompilerType(this.entry.getFile()));
            DataObject dobj = null;
            dobj = DataObject.find((FileObject)this.getFileObject());
            FortranCompilerGroup.FortranFormat cformat = new FortranCompilerGroup.FortranFormat(new DataObject[]{dobj}, new String[]{compiler.getFileName()}, true);
            RemoteCompilerAction.createRemoteProcess(this.getFileObject(), this.getOutputSwitch(), this.getXDisplayNumber(), this.getProjCompilerType().getErrorExpression(), cformat, cformat.getCmds());
        }
    }

    public static class Clean
    extends FortranCompilerSupport
    implements CompilerCookie.Clean {
        public Clean(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Clean.class);
        }
    }

    public static class Build
    extends FortranCompilerSupport
    implements CompilerCookie.Build {
        public Build(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Build.class);
        }
    }

    public static class Compile
    extends FortranCompilerSupport
    implements CompilerCookie.Compile {
        public Compile(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Compile.class);
        }
    }

    private class TagEditor
    extends PropertyEditorSupport {
        private TagEditor() {
        }

        public String getAsText() {
            return (String)this.getValue();
        }

        public void setAsText(String v) throws IllegalArgumentException {
            this.setValue(v);
        }

        public String[] getTags() {
            return new String[]{"FREE", "FIXED"};
        }
    }
}

