/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrame;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContext;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.openide.util.RequestProcessor;

public class CurrentThreadAnnotationListener
extends DebuggerManagerAdapter {
    private transient Object currentPC;
    private transient Object currentPCLock = new Object();
    private transient boolean currentPCSet = false;
    private RemoteDebugger currentDebugger;
    private HashMap stackAnnotations = new HashMap();
    private RequestProcessor rp = new RequestProcessor("Debugger Thread Annotation Refresher");
    private RequestProcessor.Task taskRemove;
    private RequestProcessor.Task taskAnnotate;
    private List stackToAnnotate;

    public CurrentThreadAnnotationListener() {
        this.updateCurrentDebugger();
        assert (this.currentDebugger == null || !Boolean.getBoolean("gdb.assertions.enabled"));
    }

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "currentEngine") {
            this.updateCurrentDebugger();
            this.annotate();
        } else if (e.getPropertyName() == "currentThread") {
            this.annotate();
        } else if (e.getPropertyName() == "currentCallStackFrame") {
            this.annotate();
        } else if (e.getPropertyName() == "state") {
            this.annotate();
        }
    }

    private void updateCurrentDebugger() {
        RemoteDebugger newDebugger = CurrentThreadAnnotationListener.getCurrentDebugger();
        if (this.currentDebugger == newDebugger) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (newDebugger != null) {
            newDebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.currentDebugger = newDebugger;
    }

    private static RemoteDebugger getCurrentDebugger() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        return (RemoteDebugger)currentEngine.lookupFirst(null, RemoteDebugger.class);
    }

    private void updateCurrentThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate() {
        if (this.currentDebugger == null) {
            return;
        }
        if (this.currentDebugger.getState() != "state_stopped") {
            Object object = this.currentPCLock;
            synchronized (object) {
                this.currentPCSet = false;
            }
            this.removeAnnotations();
            return;
        }
        ArrayList stack = this.currentDebugger.getCallStack();
        final CallStackFrame csf = this.currentDebugger.getCurrentCallStackFrame();
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        String language = currentSession == null ? null : currentSession.getCurrentLanguage();
        Object object = this.currentPCLock;
        synchronized (object) {
            this.currentPCSet = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = CurrentThreadAnnotationListener.this.currentPCLock;
                synchronized (object) {
                    if (CurrentThreadAnnotationListener.this.currentPC != null) {
                        EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                    }
                    if (csf != null) {
                        EditorContextBridge.showSource(csf);
                    }
                }
            }
        });
        this.annotateCallStack(stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove == null) {
                this.taskRemove = this.rp.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = CurrentThreadAnnotationListener.this.currentPCLock;
                        synchronized (object) {
                            if (CurrentThreadAnnotationListener.this.currentPCSet) {
                                return;
                            }
                            if (CurrentThreadAnnotationListener.this.currentPC != null) {
                                EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                            }
                            CurrentThreadAnnotationListener.this.currentPC = null;
                        }
                        Iterator i = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
                        while (i.hasNext()) {
                            EditorContextBridge.removeAnnotation(i.next());
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations.clear();
                    }
                });
            }
        }
        this.taskRemove.schedule(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateCallStack(List stack) {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove != null) {
                this.taskRemove.cancel();
            }
            this.stackToAnnotate = stack;
            if (this.taskAnnotate == null) {
                this.taskAnnotate = this.rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        List stack;
                        RequestProcessor requestProcessor = CurrentThreadAnnotationListener.this.rp;
                        synchronized (requestProcessor) {
                            if (CurrentThreadAnnotationListener.this.stackToAnnotate == null) {
                                return;
                            }
                            stack = CurrentThreadAnnotationListener.this.stackToAnnotate;
                            CurrentThreadAnnotationListener.this.stackToAnnotate = null;
                        }
                        if (CurrentThreadAnnotationListener.this.currentPC != null) {
                            EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                        }
                        CurrentThreadAnnotationListener.this.currentPC = null;
                        Iterator iter = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
                        while (iter.hasNext()) {
                            EditorContextBridge.removeAnnotation(iter.next());
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations.clear();
                        HashMap<String, Object> newAnnotations = new HashMap<String, Object>();
                        String annotationType = EditorContext.CURRENT_LINE_ANNOTATION_TYPE;
                        int k = stack.size();
                        for (int i = 0; i < k; ++i) {
                            Object language = null;
                            CallStackFrame csf = (CallStackFrame)stack.get(i);
                            int lineNumber = csf.getLineNumber();
                            String line = Integer.toString(lineNumber);
                            if (newAnnotations.containsKey(line)) continue;
                            Object da = EditorContextBridge.annotate(csf, annotationType);
                            if (da != null) {
                                newAnnotations.put(line, da);
                            }
                            annotationType = EditorContext.CALL_STACK_FRAME_ANNOTATION_TYPE;
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations = newAnnotations;
                    }
                });
            }
        }
        this.taskAnnotate.schedule(50);
    }
}

