/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.editor.ccpp;

import com.hp.openvms.netbeans.cppsupport.editor.ccpp.CCFormatter;
import com.hp.openvms.netbeans.cppsupport.editor.ccpp.CCSyntax;
import com.hp.openvms.netbeans.cppsupport.editor.ccpp.JavaDrawLayerFactory;
import java.awt.event.ActionEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;

public class CCKit
extends NbEditorKit {
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    private static ArrayList actionClasses = null;

    public String getContentType() {
        return "text/x-hp+openvms+cpp";
    }

    public void install(JEditorPane c) {
        super.install(c);
    }

    public Document createDefaultDocument() {
        NbEditorDocument doc = new NbEditorDocument(((Object)((Object)this)).getClass());
        doc.putProperty((Object)"write-line-separator", (Object)"\n");
        return doc;
    }

    public Syntax createSyntax(Document doc) {
        return new CCSyntax();
    }

    protected void initDocument(BaseDocument doc) {
        doc.addLayer((DrawLayer)new JavaDrawLayerFactory.JavaLayer(), 1010);
        doc.addDocumentListener((DocumentListener)new JavaDrawLayerFactory.LParenWatcher());
    }

    public Formatter createFormatter() {
        return new CCFormatter(((Object)((Object)this)).getClass());
    }

    protected Action[] createActions() {
        int arraySize = 2;
        int numAddClasses = 0;
        if (actionClasses != null) {
            numAddClasses = actionClasses.size();
            arraySize += numAddClasses;
        }
        Action[] ccActions = new Action[arraySize];
        int index = 0;
        if (actionClasses != null) {
            for (int i = 0; i < numAddClasses; ++i) {
                Class c = (Class)actionClasses.get(i);
                try {
                    ccActions[index] = (Action)c.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ++index;
            }
        }
        ccActions[index++] = new CCDefaultKeyTypedAction();
        ccActions[index++] = new CCFormatAction();
        return TextAction.augmentList(super.createActions(), ccActions);
    }

    public static void addActionClass(Class action) {
        if (actionClasses == null) {
            actionClasses = new ArrayList(2);
        }
        actionClasses.add(action);
    }

    protected void updateActions() {
        super.updateActions();
        this.addSystemActionMapping("format", CCFormatAction.class);
    }

    public static class CCDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void checkCompletion(JTextComponent target, String typedText) {
            Completion completion = ExtUtilities.getCompletion((JTextComponent)target);
            if (completion != null && typedText.length() > 0) {
                if (!completion.isPaneVisible()) {
                    if (completion.isAutoPopupEnabled()) {
                        boolean pop = false;
                        switch (typedText.charAt(0)) {
                            case ' ': {
                                int dotPos = target.getCaret().getDot();
                                BaseDocument doc = (BaseDocument)target.getDocument();
                                if (dotPos < 2) break;
                                int pos = Math.max(dotPos - 5, 0);
                                try {
                                    String txtBeforeSpace = doc.getText(pos, dotPos - pos);
                                    if (txtBeforeSpace.endsWith("new ")) {
                                        pop = true;
                                        break;
                                    }
                                    if (!txtBeforeSpace.endsWith(", ")) break;
                                    pop = true;
                                }
                                catch (BadLocationException e) {}
                                break;
                            }
                            case ',': 
                            case '.': {
                                pop = true;
                            }
                        }
                        if (pop) {
                            completion.popup(true);
                        } else {
                            completion.cancelRequest();
                        }
                    }
                } else {
                    switch (typedText.charAt(0)) {
                        case ';': 
                        case '=': 
                        case '{': {
                            completion.setPaneVisible(false);
                            break;
                        }
                        default: {
                            completion.refresh(true);
                        }
                    }
                }
            }
        }

        protected void checkIndentHotChars(JTextComponent target, String typedText) {
            boolean reindent = false;
            BaseDocument doc = Utilities.getDocument((JTextComponent)target);
            int dotPos = target.getCaret().getDot();
            if (doc != null) {
                if ("e".equals(typedText)) {
                    try {
                        int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                        if (fnw >= 0 && fnw + 4 == dotPos && "else".equals(doc.getText(fnw, 4))) {
                            reindent = true;
                        }
                    }
                    catch (BadLocationException e) {}
                } else if (":".equals(typedText)) {
                    try {
                        int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                        if (fnw >= 0 && fnw + 4 <= doc.getLength() && "case".equals(doc.getText(fnw, 4))) {
                            reindent = true;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
                if (reindent) {
                    try {
                        Utilities.reformatLine((BaseDocument)doc, (int)dotPos);
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
            }
            super.checkIndentHotChars(target, typedText);
        }
    }

    public class CCFormatAction
    extends BaseAction {
        public CCFormatAction() {
            super("format", 14);
            this.putValue("helpID", CCFormatAction.class.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                doc.atomicLock();
                try {
                    int pos;
                    String out;
                    Position endPosition;
                    int startPos;
                    int caretLine = Utilities.getLineOffset((BaseDocument)doc, (int)caret.getDot());
                    if (caret.isSelectionVisible()) {
                        startPos = target.getSelectionStart();
                        endPosition = doc.createPosition(target.getSelectionEnd());
                    } else {
                        startPos = 0;
                        endPosition = doc.createPosition(doc.getLength());
                    }
                    for (pos = startPos; pos < endPosition.getOffset(); pos += out.length()) {
                        int stopPos = endPosition.getOffset();
                        CharArrayWriter cw = new CharArrayWriter();
                        Writer w = doc.getFormatter().createWriter((Document)doc, pos, (Writer)cw);
                        w.write(doc.getChars(pos, stopPos - pos));
                        w.close();
                        out = new String(cw.toCharArray());
                        doc.remove(pos, stopPos - pos);
                        doc.insertString(pos, out, null);
                    }
                    pos = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)caretLine);
                    if (pos >= 0) {
                        caret.setDot(pos);
                    }
                }
                catch (BadLocationException e) {
                    if (System.getProperty("netbeans.debug.exceptions") != null) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (System.getProperty("netbeans.debug.exceptions") != null) {
                        e.printStackTrace();
                    }
                }
                finally {
                    doc.atomicUnlock();
                }
            }
        }
    }
}

