/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.cobol.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.RemoteCompilerAction;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompiler;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerGroup;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerType;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataNode;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie;
import org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie;
import org.netbeans.modules.distributed.common.propertyeditors.BoolEditor;
import org.netbeans.modules.distributed.common.propertyeditors.NbProcessDescriptorEditor2;
import org.netbeans.modules.distributed.common.propertyeditors.StringEditor2;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.ErrorManager;
import org.openide.compiler.CompilerSupport;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CobolCompilerSupport
extends CompilerSupport {
    public static final String PROP_DEFINE = "CobolDefine";
    public static final String PROP_BUILD_OPTION = "buildOption";
    public static final String PROP_ANSIFORMATTING = "ansiFormatting";
    public static final String PROP_OPTIMIZE = "optimize";
    public static final String PROP_CHECK = "check";
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_OBJECT_DIRECTORY = "objectDirectory";
    public static final String PROP_LIST_DIRECTORY = "listDirectory";
    public static final String PROP_OUTPUT_SWITCH = "outputSwitch";
    public static final String PROP_BUILD_COMMAND = "buildCommand";
    public static final String PROP_INCLUDE = "include";
    public static final String PROP_LIBRARY = "library";
    public static final String PROP_DEBUG = "debug";
    public static final String PROP_OTHER_OPTIONS = "otherOptions";
    public static final String PROP_EXTERNAL_COMPILER = "externalCompiler";
    public static final String PROP_MAKEFILE_COMPILER = "makefileCompiler";
    public static final String PROP_COBOL_GLOBAL_QUALIFIER = "globalQualifier";
    public static final String PROP_COBOL_LOCAL_QUALIFIER = "localQualifier";
    protected static final ResourceBundle bundle = NbBundle.getBundle(CobolCompilerSupport.class);
    protected MultiDataObject.Entry entry;

    protected CobolCompilerSupport(MultiDataObject.Entry entry, Class cookie) {
        super(entry, cookie);
        this.entry = entry;
    }

    protected CobolCompilerType getProjCompilerType() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getFileObject());
        if (project != null) {
            RemoteProjectSettings rs = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (rs == null) {
                return new CobolCompilerType(this.getFileObject());
            }
            return (CobolCompilerType)((Object)rs.getCompilerSettings("cobol"));
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createExternalCompilerProperty());
        set.put((Node.Property)this.createAnsiFormattingProperty());
        set.put((Node.Property)this.createCobolLocalQualifierProperty());
        set.put((Node.Property)this.createCobolGlobalQualifierProperty());
    }

    public void addBuildOptionProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildOptionProperty());
    }

    public void addMakefileProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildDirectoryProperty());
        set.put((Node.Property)this.createMakefileCompilerProperty());
        set.put((Node.Property)this.createBuildCommandProperty());
        set.put((Node.Property)this.createOutputSwitchProperty());
        set.put((Node.Property)this.createXDisplayDeviceNumber());
    }

    public void addRemoteProperties(Sheet.Set set) {
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (this.entry.getFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public Boolean getBuildOption() {
        Boolean useMakefile = (Boolean)this.entry.getFile().getAttribute(PROP_BUILD_OPTION);
        if (useMakefile == null) {
            return (Boolean)this.getProjCompilerType().getBuildOption();
        }
        return useMakefile;
    }

    private synchronized void setBuildOption(Boolean buildProperty) throws IOException {
        Node node = this.entry.getDataObject().getNodeDelegate();
        Node.PropertySet[] ps = node.getPropertySets();
        if (buildProperty == null) {
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, this.getProjCompilerType().getBuildOption());
            return;
        }
        if (node instanceof CobolDataNode) {
            if (buildProperty.equals(Boolean.TRUE)) {
                ps[1].setHidden(true);
                ps[2].setHidden(false);
            } else {
                ps[1].setHidden(false);
                ps[2].setHidden(true);
            }
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, (Object)buildProperty);
            ((CobolDataNode)node).firePropertySetChange2(null, ps);
        }
    }

    public Boolean getAnsiFormatting() {
        Boolean useansiformatting = (Boolean)this.entry.getFile().getAttribute(PROP_ANSIFORMATTING);
        if (useansiformatting == null) {
            return (Boolean)this.getProjCompilerType().getAnsiFormatting();
        }
        return useansiformatting;
    }

    private synchronized void setAnsiFormatting(Boolean AnsiFormattingProperty) throws IOException {
        Node node = this.entry.getDataObject().getNodeDelegate();
        Node.PropertySet[] ps = node.getPropertySets();
        if (AnsiFormattingProperty == null) {
            this.entry.getFile().setAttribute(PROP_ANSIFORMATTING, null);
        } else if (node instanceof CobolDataNode) {
            this.entry.getFile().setAttribute(PROP_ANSIFORMATTING, (Object)AnsiFormattingProperty);
        }
    }

    public RemoteFSFile getBuildDirectory() {
        Object buildDir = this.entry.getFile().getAttribute(PROP_BUILD_DIRECTORY);
        if (buildDir == null || buildDir instanceof RemoteFSFile && ((RemoteFSFile)buildDir).getAbsolutePath().equals("")) {
            return this.getProjCompilerType().getBuildDirectory();
        }
        if (buildDir != null && !(buildDir instanceof RemoteFSFile)) {
            try {
                this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getBuildDirectory();
        }
        return (RemoteFSFile)buildDir;
    }

    private synchronized void setBuildDirectory(RemoteFSFile buildDirectory) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, (Object)buildDirectory);
    }

    public Boolean getOutputSwitch() {
        Boolean outputSwitch = (Boolean)this.entry.getFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (outputSwitch == null) {
            return this.getProjCompilerType().outputSwitch();
        }
        return outputSwitch;
    }

    private synchronized void setOutputSwitch(Boolean outputSwitch) throws IOException {
        this.entry.getFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)outputSwitch);
    }

    public Integer getXDisplayNumber() {
        Integer xSwitch = (Integer)this.entry.getFile().getAttribute("xDisplayDeviceNumber");
        if (xSwitch == null) {
            return this.getProjCompilerType().xDisplayNumber();
        }
        return xSwitch;
    }

    private synchronized void setXDisplayNumber(Integer XSwitch) throws IOException {
        this.entry.getFile().setAttribute("xDisplayDeviceNumber", (Object)XSwitch);
    }

    public String getBuildCommand() {
        String buildCommand = (String)this.entry.getFile().getAttribute(PROP_BUILD_COMMAND);
        if (buildCommand == null) {
            return this.getProjCompilerType().getBuildCommand();
        }
        return buildCommand;
    }

    private synchronized void setBuildCommand(String buildCommand) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_COMMAND, (Object)buildCommand);
    }

    private String getCurrentFileDir() {
        try {
            String rootDir = FileUtil.toFile((FileObject)this.entry.getDataObject().getPrimaryFile().getFileSystem().getRoot()).getAbsolutePath();
            String fileDir = this.entry.getDataObject().getPrimaryFile().getParent().getPackageNameExt('/', '.');
            Object objectDir = null;
            return rootDir + '/' + fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }

    public NbProcessDescriptor getExternalCompiler() {
        Object obj = this.entry.getFile().getAttribute(PROP_EXTERNAL_COMPILER);
        if (obj != null && obj instanceof NbProcessDescriptor) {
            return (NbProcessDescriptor)obj;
        }
        return this.getProjCompilerType().getExternalCompiler();
    }

    private void setExternalCompiler(NbProcessDescriptor externalCompiler) throws IOException {
        this.entry.getFile().setAttribute(PROP_EXTERNAL_COMPILER, (Object)externalCompiler);
    }

    public RemoteFSFile getMakefileCompiler() {
        Object obj = this.entry.getFile().getAttribute(PROP_MAKEFILE_COMPILER);
        if (obj != null && obj instanceof RemoteFSFile) {
            return (RemoteFSFile)obj;
        }
        if (obj != null && obj instanceof String) {
            try {
                this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getMakefileCompiler();
        }
        return this.getProjCompilerType().getMakefileCompiler();
    }

    private void setMakefileCompiler(RemoteFSFile externalCompiler) throws IOException {
        this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, (Object)externalCompiler);
    }

    private void setLocalQualifier(String option) throws IOException {
        this.entry.getFile().setAttribute(PROP_COBOL_LOCAL_QUALIFIER, (Object)option);
    }

    private void setGlobalQualifier(String option) throws IOException {
        this.entry.getFile().setAttribute(PROP_COBOL_GLOBAL_QUALIFIER, (Object)option);
    }

    public String getLocalQualifier() {
        String option = (String)this.entry.getFile().getAttribute(PROP_COBOL_LOCAL_QUALIFIER);
        if (option == null) {
            return this.getProjCompilerType().getLocalQualifier();
        }
        return option;
    }

    public String getGlobalQualifier() {
        String option = (String)this.entry.getFile().getAttribute(PROP_COBOL_GLOBAL_QUALIFIER);
        if (option == null) {
            return this.getProjCompilerType().getGlobalQualifier();
        }
        return option;
    }

    private PropertySupport createBuildOptionProperty() {
        class BuildOptionPropertySupport
        extends PropertySupport.ReadWrite {
            public BuildOptionPropertySupport() {
                super(CobolCompilerSupport.PROP_BUILD_OPTION, Object.class, CobolCompilerSupport.this.getFlaggedNameBuildOption(CobolCompilerSupport.this.getString("PROP_BUILD_OPTION"), CobolCompilerSupport.PROP_BUILD_OPTION), CobolCompilerSupport.this.getString("HINT_BUILD_OPTION"));
                this.setValue("helpID", "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_BUILD_OPTION, "org.openide.filesystems.FileObject");
                if (CobolCompilerSupport.this.getProjCompilerType().getBuildOption() != null) {
                    this.setValue("projValue", CobolCompilerSupport.this.getProjCompilerType().getBuildOption());
                }
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getBuildOption();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        CobolCompilerSupport.this.setBuildOption((Boolean)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getBuildOption());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new BuildOptionPropertySupport();
    }

    private PropertySupport createAnsiFormattingProperty() {
        class AnsiFormattingPropertySupport
        extends PropertySupport.ReadWrite {
            public AnsiFormattingPropertySupport() {
                super(CobolCompilerSupport.PROP_ANSIFORMATTING, Object.class, CobolCompilerSupport.this.getFlaggedNameAnsiFormatting(CobolCompilerSupport.this.getString("PROP_ANSIFORMATTING"), CobolCompilerSupport.PROP_ANSIFORMATTING), CobolCompilerSupport.this.getString("HINT_ANSIFORMATTING"));
                this.setValue("helpID", "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_ANSIFORMATTING, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileMakefileSettings");
                if (CobolCompilerSupport.this.getProjCompilerType().getAnsiFormatting() != null) {
                    this.setValue("projValue", CobolCompilerSupport.this.getProjCompilerType().getAnsiFormatting());
                }
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getAnsiFormatting();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        CobolCompilerSupport.this.setAnsiFormatting((Boolean)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getAnsiFormatting());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new AnsiFormattingPropertySupport();
    }

    private PropertySupport createBuildDirectoryProperty() {
        class PropertySupportBuildDirectory
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildDirectory() {
                super(CobolCompilerSupport.PROP_BUILD_DIRECTORY, RemoteFSFile.class, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_BUILD_DIRECTORY"), CobolCompilerSupport.PROP_BUILD_DIRECTORY), CobolCompilerSupport.this.getString("HINT_BUILD_DIRECTORY"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.FALSE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", CobolCompilerSupport.this.entry.getFile().getNameExt());
                try {
                    if (CobolCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", CobolCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (CobolCompilerSupport.this.getProjCompilerType().getBuildDirectory() != null) {
                    this.setValue("projvalue", CobolCompilerSupport.this.getProjCompilerType().getBuildDirectory());
                }
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_BUILD_DIRECTORY, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileMakefileSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getBuildDirectory();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof RemoteFSFile || val == null) {
                    try {
                        CobolCompilerSupport.this.setBuildDirectory((RemoteFSFile)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getBuildDirectory());
                CobolCompilerSupport.this.changeResetProp(CobolCompilerSupport.PROP_BUILD_DIRECTORY, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new PropertySupportBuildDirectory();
    }

    private PropertySupport createXDisplayDeviceNumber() {
        class XDisplayDeviceNumberPropertySupport
        extends PropertySupport.ReadWrite {
            public XDisplayDeviceNumberPropertySupport() {
                super("X Display Device Number", Integer.class, "X Display Device Number", "Defines the screen associated with the display device");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getXDisplayNumber();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Integer || val == null) {
                    try {
                        CobolCompilerSupport.this.setXDisplayNumber((Integer)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new XDisplayDeviceNumberPropertySupport();
    }

    private PropertySupport createOutputSwitchProperty() {
        class OutputSwitchPropertySupport
        extends PropertySupport.ReadWrite {
            public OutputSwitchPropertySupport() {
                super(CobolCompilerSupport.PROP_OUTPUT_SWITCH, Object.class, CobolCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), CobolCompilerSupport.this.getString("HINT_OUTPUT_SWITCH"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_OUTPUT_SWITCH, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
                if (CobolCompilerSupport.this.getProjCompilerType().outputSwitch() != null) {
                    this.setValue("projValue", CobolCompilerSupport.this.getProjCompilerType().outputSwitch());
                }
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getOutputSwitch();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        CobolCompilerSupport.this.setOutputSwitch((Boolean)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getOutputSwitch());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new OutputSwitchPropertySupport();
    }

    private PropertySupport createBuildCommandProperty() {
        class PropertySupportBuildCommand
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildCommand() {
                super(CobolCompilerSupport.PROP_BUILD_COMMAND, String.class, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_BUILD_COMMAND"), CobolCompilerSupport.PROP_BUILD_COMMAND), CobolCompilerSupport.this.getString("HINT_BUILD_COMMAND"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_BUILD_COMMAND, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getBuildCommand();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        CobolCompilerSupport.this.setBuildCommand((String)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getBuildCommand());
                CobolCompilerSupport.this.changeResetProp(CobolCompilerSupport.PROP_BUILD_COMMAND, this.getValue());
            }

            public boolean canWrite() {
                return !CobolCompilerSupport.this.entry.getFile().isReadOnly();
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new PropertySupportBuildCommand();
    }

    private PropertySupport createExternalCompilerProperty() {
        class ExternalCompilerPropertySupport
        extends PropertySupport.ReadWrite {
            public ExternalCompilerPropertySupport() {
                super(CobolCompilerSupport.PROP_EXTERNAL_COMPILER, NbProcessDescriptor.class, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_EXTERNAL_COMPILER"), CobolCompilerSupport.PROP_EXTERNAL_COMPILER), CobolCompilerSupport.this.getString("HINT_EXTERNAL_COMPILER"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_EXTERNAL_COMPILER, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getExternalCompiler();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof NbProcessDescriptor || val == null) {
                    try {
                        CobolCompilerSupport.this.setExternalCompiler((NbProcessDescriptor)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public PropertyEditor getPropertyEditor() {
                return new NbProcessDescriptorEditor2();
            }
        }
        return new ExternalCompilerPropertySupport();
    }

    private PropertySupport createMakefileCompilerProperty() {
        class MakefileProperty
        extends PropertySupport.ReadWrite {
            public MakefileProperty() {
                super(CobolCompilerSupport.PROP_MAKEFILE_COMPILER, RemoteFSFile.class, CobolCompilerSupport.this.getFlaggedNameMakefile(CobolCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), CobolCompilerSupport.PROP_MAKEFILE_COMPILER), CobolCompilerSupport.this.getString("HINT_MAKEFILE_COMPILER"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.TRUE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", CobolCompilerSupport.this.entry.getFile().getNameExt());
                if (CobolCompilerSupport.this.getProjCompilerType().getMakefileCompiler() != null) {
                    this.setValue("projvalue", CobolCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                }
                try {
                    if (CobolCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", CobolCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_MAKEFILE_COMPILER, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getMakefileCompiler();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof RemoteFSFile || val == null) {
                    try {
                        CobolCompilerSupport.this.setMakefileCompiler((RemoteFSFile)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(CobolCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                CobolCompilerSupport.this.changeResetProp(CobolCompilerSupport.PROP_MAKEFILE_COMPILER, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new MakefileProperty();
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", String.class, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                FileObject fobj = CobolCompilerSupport.this.entry.getFile();
                Object obj = fobj.getAttribute("file_residence_mode");
                try {
                    RemoteFileSystem rf = (RemoteFileSystem)fobj.getFileSystem();
                    if (rf.getServerOnlyFileExts().isRegistered(fobj.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                if (obj != null) {
                    Integer itr = (Integer)obj;
                    String ret = "Make Client and Server";
                    switch (itr) {
                        case 1: {
                            ret = "Client Only";
                            break;
                        }
                        case 0: {
                            ret = "Server Only";
                            break;
                        }
                        case 2: {
                            ret = "Client and Server";
                        }
                    }
                    return ret;
                }
                return "Client and Server";
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", String.class, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                FileObject fobj = CobolCompilerSupport.this.entry.getFile();
                Object obj = fobj.getAttribute("REMOTE_FILEPATH");
                if (obj != null) {
                    return obj;
                }
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return vmsPath;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    FileObject fobj = CobolCompilerSupport.this.entry.getFile();
                    fobj.setAttribute("REMOTE_FILEPATH", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                FileObject fobj = CobolCompilerSupport.this.entry.getFile();
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                    this.setValue(vmsPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createCobolLocalQualifierProperty() {
        class CobolLocalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public CobolLocalQualifierPropertySupport() {
                super(CobolCompilerSupport.PROP_COBOL_LOCAL_QUALIFIER, String.class, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_COBOL_LOCAL_QUALIFIER"), CobolCompilerSupport.PROP_COBOL_LOCAL_QUALIFIER), CobolCompilerSupport.this.getString("HINT_COBOL_LOCAL_QUALIFIER"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_COBOL_LOCAL_QUALIFIER, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getLocalQualifier();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        CobolCompilerSupport.this.setLocalQualifier((String)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getLocalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new CobolLocalQualifierPropertySupport();
    }

    private PropertySupport createCobolGlobalQualifierProperty() {
        class CobolGlobalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public CobolGlobalQualifierPropertySupport() {
                super(CobolCompilerSupport.PROP_COBOL_GLOBAL_QUALIFIER, String.class, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_COBOL_GLOBAL_QUALIFIER"), CobolCompilerSupport.PROP_COBOL_GLOBAL_QUALIFIER), CobolCompilerSupport.this.getString("HINT_COBOL_GLOBAL_QUALIFIER"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_COBOL_GLOBAL_QUALIFIER, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getGlobalQualifier();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        CobolCompilerSupport.this.setGlobalQualifier((String)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getGlobalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new CobolGlobalQualifierPropertySupport();
    }

    private String getFlaggedNameBuildOption(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedNameAnsiFormatting(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedNameMakefile(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedName(String dispName, String name) {
        return dispName;
    }

    protected String getString(String s) {
        return bundle.getString(s);
    }

    protected void setDefaultFunction(PropertySupport ps, String propName, String helpID) {
        try {
            ps.setValue("method", (Object)FileObject.class.getMethod("getAttribute", String.class));
            ps.setValue("param", (Object)propName);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        ps.setValue("object", (Object)this.entry.getFile());
        ps.setValue("helpID", (Object)helpID);
    }

    private void changeResetProp(String prop, Object value) {
        Node node = this.entry.getDataObject().getNodeDelegate();
        if (node instanceof CobolDataNode) {
            ((CobolDataNode)node).firePropertyChange2(prop, null, value);
        }
    }

    public FileObject getFileObject() {
        return this.entry.getFile();
    }

    public static class RemoteBuild
    extends CobolCompilerSupport
    implements RemoteBuildCookie {
        public RemoteBuild(MultiDataObject.Entry entry) {
            super(entry, RemoteBuildCookie.class);
        }
    }

    public static class RemoteCompile
    extends CobolCompilerSupport
    implements RemoteCompileCookie {
        public RemoteCompile(MultiDataObject.Entry entry) {
            super(entry, RemoteCompileCookie.class);
        }

        public void compile() throws IOException {
            CobolCompiler compiler = new CobolCompiler(RemoteBuildCookie.class, this.getFileObject(), this.getExternalCompiler(), this.getProjCompilerType().getErrorExpression(), new CobolCompilerType(this.entry.getFile()));
            DataObject dobj = null;
            dobj = DataObject.find((FileObject)this.getFileObject());
            CobolCompilerGroup.CobolFormat cformat = new CobolCompilerGroup.CobolFormat(new DataObject[]{dobj}, new String[]{compiler.getFileName()}, true);
            RemoteCompilerAction.createRemoteProcess(this.getFileObject(), this.getOutputSwitch(), this.getXDisplayNumber(), this.getProjCompilerType().getErrorExpression(), cformat, cformat.getCmds());
        }
    }

    public static class Clean
    extends CobolCompilerSupport
    implements CompilerCookie.Clean {
        public Clean(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Clean.class);
        }
    }

    public static class Build
    extends CobolCompilerSupport
    implements CompilerCookie.Build {
        public Build(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Build.class);
        }
    }

    public static class Compile
    extends CobolCompilerSupport
    implements CompilerCookie.Compile {
        public Compile(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Compile.class);
        }
    }
}

