/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.basicsupport.basic.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.RemoteCompilerAction;
import com.hp.openvms.netbeans.basicsupport.basic.BasicCompiler;
import com.hp.openvms.netbeans.basicsupport.basic.BasicCompilerGroup;
import com.hp.openvms.netbeans.basicsupport.basic.BasicCompilerType;
import com.hp.openvms.netbeans.basicsupport.basic.datasys.BasicDataNode;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie;
import org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie;
import org.netbeans.modules.distributed.common.propertyeditors.BoolEditor;
import org.netbeans.modules.distributed.common.propertyeditors.NbProcessDescriptorEditor2;
import org.netbeans.modules.distributed.common.propertyeditors.StringEditor2;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.ErrorManager;
import org.openide.compiler.CompilerSupport;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class BasicCompilerSupport
extends CompilerSupport {
    public static final String PROP_DEFINE = "BasicDefine";
    public static final String PROP_BUILD_OPTION = "buildOption";
    public static final String PROP_OPTIMIZE = "optimize";
    public static final String PROP_CHECK = "check";
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_OBJECT_DIRECTORY = "objectDirectory";
    public static final String PROP_LIST_DIRECTORY = "listDirectory";
    public static final String PROP_OUTPUT_SWITCH = "outputSwitch";
    public static final String PROP_BUILD_COMMAND = "buildCommand";
    public static final String PROP_INCLUDE = "include";
    public static final String PROP_LIBRARY = "library";
    public static final String PROP_DEBUG = "debug";
    public static final String PROP_OTHER_OPTIONS = "otherOptions";
    public static final String PROP_EXTERNAL_COMPILER = "externalCompiler";
    public static final String PROP_MAKEFILE_COMPILER = "makefileCompiler";
    public static final String PROP_BASIC_GLOBAL_QUALIFIER = "globalQualifier";
    public static final String PROP_BASIC_LOCAL_QUALIFIER = "localQualifier";
    protected static final ResourceBundle bundle = NbBundle.getBundle(BasicCompilerSupport.class);
    protected MultiDataObject.Entry entry;

    protected BasicCompilerSupport(MultiDataObject.Entry entry, Class cookie) {
        super(entry, cookie);
        this.entry = entry;
    }

    protected BasicCompilerType getProjCompilerType() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getFileObject());
        if (project != null) {
            RemoteProjectSettings rs = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (rs == null) {
                return new BasicCompilerType(this.getFileObject());
            }
            return (BasicCompilerType)((Object)rs.getCompilerSettings("basic"));
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createExternalCompilerProperty());
        set.put((Node.Property)this.createBasicLocalQualifierProperty());
        set.put((Node.Property)this.createBasicGlobalQualifierProperty());
    }

    public void addBuildOptionProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildOptionProperty());
    }

    public void addMakefileProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildDirectoryProperty());
        set.put((Node.Property)this.createMakefileCompilerProperty());
        set.put((Node.Property)this.createBuildCommandProperty());
        set.put((Node.Property)this.createOutputSwitchProperty());
        set.put((Node.Property)this.createXDisplayDeviceNumber());
    }

    public void addRemoteProperties(Sheet.Set set) {
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (this.entry.getFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public Boolean getBuildOption() {
        Boolean useMakefile = (Boolean)this.entry.getFile().getAttribute(PROP_BUILD_OPTION);
        if (useMakefile == null) {
            return (Boolean)this.getProjCompilerType().getBuildOption();
        }
        return useMakefile;
    }

    private synchronized void setBuildOption(Boolean buildProperty) throws IOException {
        Node node = this.entry.getDataObject().getNodeDelegate();
        Node.PropertySet[] ps = node.getPropertySets();
        if (buildProperty == null) {
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, this.getProjCompilerType().getBuildOption());
            return;
        }
        if (node instanceof BasicDataNode) {
            if (buildProperty.equals(Boolean.TRUE)) {
                ps[1].setHidden(true);
                ps[2].setHidden(false);
            } else {
                ps[1].setHidden(false);
                ps[2].setHidden(true);
            }
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, (Object)buildProperty);
            ((BasicDataNode)node).firePropertySetChange2(null, ps);
        }
    }

    public RemoteFSFile getBuildDirectory() {
        Object buildDir = this.entry.getFile().getAttribute(PROP_BUILD_DIRECTORY);
        if (buildDir == null || buildDir instanceof RemoteFSFile && ((RemoteFSFile)buildDir).getAbsolutePath().equals("")) {
            return this.getProjCompilerType().getBuildDirectory();
        }
        if (buildDir != null && !(buildDir instanceof RemoteFSFile)) {
            try {
                this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getBuildDirectory();
        }
        return (RemoteFSFile)buildDir;
    }

    private synchronized void setBuildDirectory(File buildDirectory) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, (Object)buildDirectory);
    }

    public Boolean getOutputSwitch() {
        Boolean outputSwitch = (Boolean)this.entry.getFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (outputSwitch == null) {
            return this.getProjCompilerType().outputSwitch();
        }
        return outputSwitch;
    }

    private synchronized void setOutputSwitch(Boolean outputSwitch) throws IOException {
        this.entry.getFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)outputSwitch);
    }

    public Integer getXDisplayNumber() {
        Integer xSwitch = (Integer)this.entry.getFile().getAttribute("xDisplayDeviceNumber");
        if (xSwitch == null) {
            return this.getProjCompilerType().xDisplayNumber();
        }
        return xSwitch;
    }

    private synchronized void setXDisplayNumber(Integer XSwitch) throws IOException {
        this.entry.getFile().setAttribute("xDisplayDeviceNumber", (Object)XSwitch);
    }

    public String getBuildCommand() {
        String buildCommand = (String)this.entry.getFile().getAttribute(PROP_BUILD_COMMAND);
        if (buildCommand == null) {
            return this.getProjCompilerType().getBuildCommand();
        }
        return buildCommand;
    }

    private synchronized void setBuildCommand(String buildCommand) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_COMMAND, (Object)buildCommand);
    }

    private String getCurrentFileDir() {
        try {
            String rootDir = FileUtil.toFile((FileObject)this.entry.getDataObject().getPrimaryFile().getFileSystem().getRoot()).getAbsolutePath();
            String fileDir = this.entry.getDataObject().getPrimaryFile().getParent().getPackageNameExt('/', '.');
            Object objectDir = null;
            return rootDir + '/' + fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }

    public NbProcessDescriptor getExternalCompiler() {
        Object obj = this.entry.getFile().getAttribute(PROP_EXTERNAL_COMPILER);
        if (obj != null && obj instanceof NbProcessDescriptor) {
            return (NbProcessDescriptor)obj;
        }
        return this.getProjCompilerType().getExternalCompiler();
    }

    private void setExternalCompiler(NbProcessDescriptor externalCompiler) throws IOException {
        this.entry.getFile().setAttribute(PROP_EXTERNAL_COMPILER, (Object)externalCompiler);
    }

    public RemoteFSFile getMakefileCompiler() {
        Object obj = this.entry.getFile().getAttribute(PROP_MAKEFILE_COMPILER);
        if (obj != null && obj instanceof RemoteFSFile) {
            return (RemoteFSFile)obj;
        }
        if (obj != null && obj instanceof String) {
            try {
                this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getMakefileCompiler();
        }
        return this.getProjCompilerType().getMakefileCompiler();
    }

    private void setMakefileCompiler(File externalCompiler) throws IOException {
        this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, (Object)externalCompiler);
    }

    private void setLocalQualifier(String option) throws IOException {
        this.entry.getFile().setAttribute(PROP_BASIC_LOCAL_QUALIFIER, (Object)option);
    }

    private void setGlobalQualifier(String option) throws IOException {
        this.entry.getFile().setAttribute(PROP_BASIC_GLOBAL_QUALIFIER, (Object)option);
    }

    public String getLocalQualifier() {
        String option = (String)this.entry.getFile().getAttribute(PROP_BASIC_LOCAL_QUALIFIER);
        if (option == null) {
            return this.getProjCompilerType().getLocalQualifier();
        }
        return option;
    }

    public String createOldBasicDescriptor() {
        return "{others} ";
    }

    public String getGlobalQualifier() {
        String option = (String)this.entry.getFile().getAttribute(PROP_BASIC_GLOBAL_QUALIFIER);
        if (option == null) {
            return this.getProjCompilerType().getGlobalQualifier();
        }
        return option;
    }

    private PropertySupport createBuildOptionProperty() {
        class BuildOptionPropertySupport
        extends PropertySupport.ReadWrite {
            public BuildOptionPropertySupport() {
                super(BasicCompilerSupport.PROP_BUILD_OPTION, Object.class, BasicCompilerSupport.this.getFlaggedNameBuildOption(BasicCompilerSupport.this.getString("PROP_BUILD_OPTION"), BasicCompilerSupport.PROP_BUILD_OPTION), BasicCompilerSupport.this.getString("HINT_BUILD_OPTION"));
                this.setValue("helpID", "com.hp.openvms.netbeans.basicsupport.settings.BasicFileGeneralSettings");
                BasicCompilerSupport.this.setDefaultFunction((PropertySupport)this, BasicCompilerSupport.PROP_BUILD_OPTION, "org.openide.filesystems.FileObject");
                if (BasicCompilerSupport.this.getProjCompilerType().getBuildOption() != null) {
                    this.setValue("projValue", BasicCompilerSupport.this.getProjCompilerType().getBuildOption());
                }
            }

            public Object getValue() {
                return BasicCompilerSupport.this.getBuildOption();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        BasicCompilerSupport.this.setBuildOption((Boolean)val);
                        BasicCompilerSupport.this.flagProperty(BasicCompilerSupport.this.getFlaggedNameBuildOption(BasicCompilerSupport.this.getString("PROP_BUILD_OPTION"), BasicCompilerSupport.PROP_BUILD_OPTION), BasicCompilerSupport.PROP_BUILD_OPTION);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(BasicCompilerSupport.this.getBuildOption());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new BuildOptionPropertySupport();
    }

    private PropertySupport createBuildDirectoryProperty() {
        class PropertySupportBuildDirectory
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildDirectory() {
                super(BasicCompilerSupport.PROP_BUILD_DIRECTORY, File.class, BasicCompilerSupport.this.getFlaggedName(BasicCompilerSupport.this.getString("PROP_BUILD_DIRECTORY"), BasicCompilerSupport.PROP_BUILD_DIRECTORY), BasicCompilerSupport.this.getString("HINT_BUILD_DIRECTORY"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.FALSE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", BasicCompilerSupport.this.entry.getFile().getNameExt());
                try {
                    if (BasicCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", BasicCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (BasicCompilerSupport.this.getProjCompilerType().getBuildDirectory() != null) {
                    this.setValue("projvalue", BasicCompilerSupport.this.getProjCompilerType().getBuildDirectory());
                }
                BasicCompilerSupport.this.setDefaultFunction((PropertySupport)this, BasicCompilerSupport.PROP_BUILD_DIRECTORY, "com.hp.openvms.netbeans.basicsupport.settings.BasicFileMakefileSettings");
            }

            public Object getValue() {
                return BasicCompilerSupport.this.getBuildDirectory();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof RemoteFSFile || val == null) {
                    try {
                        BasicCompilerSupport.this.setBuildDirectory((RemoteFSFile)val);
                        BasicCompilerSupport.this.flagProperty(BasicCompilerSupport.this.getFlaggedName(BasicCompilerSupport.this.getString("PROP_BUILD_DIRECTORY"), BasicCompilerSupport.PROP_BUILD_DIRECTORY), BasicCompilerSupport.PROP_BUILD_DIRECTORY);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(BasicCompilerSupport.this.getBuildDirectory());
                BasicCompilerSupport.this.changeResetProp(BasicCompilerSupport.PROP_BUILD_DIRECTORY, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new PropertySupportBuildDirectory();
    }

    private PropertySupport createXDisplayDeviceNumber() {
        class XDisplayDeviceNumberPropertySupport
        extends PropertySupport.ReadWrite {
            public XDisplayDeviceNumberPropertySupport() {
                super("X Display Device Number", Integer.class, "X Display Device Number", "Defines the screen associated with the display device");
            }

            public Object getValue() {
                return BasicCompilerSupport.this.getXDisplayNumber();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Integer || val == null) {
                    try {
                        BasicCompilerSupport.this.setXDisplayNumber((Integer)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new XDisplayDeviceNumberPropertySupport();
    }

    private PropertySupport createOutputSwitchProperty() {
        class OutputSwitchPropertySupport
        extends PropertySupport.ReadWrite {
            public OutputSwitchPropertySupport() {
                super(BasicCompilerSupport.PROP_OUTPUT_SWITCH, Object.class, BasicCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), BasicCompilerSupport.this.getString("HINT_OUTPUT_SWITCH"));
                BasicCompilerSupport.this.setDefaultFunction((PropertySupport)this, BasicCompilerSupport.PROP_OUTPUT_SWITCH, "com.hp.openvms.netbeans.basicsupport.settings.BasicFileGeneralSettings");
                if (BasicCompilerSupport.this.getProjCompilerType().outputSwitch() != null) {
                    this.setValue("projValue", BasicCompilerSupport.this.getProjCompilerType().outputSwitch());
                }
            }

            public Object getValue() {
                return BasicCompilerSupport.this.getOutputSwitch();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        BasicCompilerSupport.this.setOutputSwitch((Boolean)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(BasicCompilerSupport.this.getOutputSwitch());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new OutputSwitchPropertySupport();
    }

    private PropertySupport createBuildCommandProperty() {
        class PropertySupportBuildCommand
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildCommand() {
                super(BasicCompilerSupport.PROP_BUILD_COMMAND, String.class, BasicCompilerSupport.this.getFlaggedName(BasicCompilerSupport.this.getString("PROP_BUILD_COMMAND"), BasicCompilerSupport.PROP_BUILD_COMMAND), BasicCompilerSupport.this.getString("HINT_BUILD_COMMAND"));
                BasicCompilerSupport.this.setDefaultFunction((PropertySupport)this, BasicCompilerSupport.PROP_BUILD_COMMAND, "com.hp.openvms.netbeans.basicsupport.settings.BasicFileGeneralSettings");
            }

            public Object getValue() {
                return BasicCompilerSupport.this.getBuildCommand();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        BasicCompilerSupport.this.setBuildCommand((String)val);
                        BasicCompilerSupport.this.flagProperty(BasicCompilerSupport.this.getFlaggedName(BasicCompilerSupport.this.getString("PROP_BUILD_COMMAND"), BasicCompilerSupport.PROP_BUILD_COMMAND), BasicCompilerSupport.PROP_BUILD_COMMAND);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(BasicCompilerSupport.this.getBuildCommand());
                BasicCompilerSupport.this.changeResetProp(BasicCompilerSupport.PROP_BUILD_COMMAND, this.getValue());
            }

            public boolean canWrite() {
                return !BasicCompilerSupport.this.entry.getFile().isReadOnly();
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new PropertySupportBuildCommand();
    }

    private PropertySupport createExternalCompilerProperty() {
        class ExternalCompilerPropertySupport
        extends PropertySupport.ReadWrite {
            public ExternalCompilerPropertySupport() {
                super(BasicCompilerSupport.PROP_EXTERNAL_COMPILER, NbProcessDescriptor.class, BasicCompilerSupport.this.getFlaggedName(BasicCompilerSupport.this.getString("PROP_EXTERNAL_COMPILER"), BasicCompilerSupport.PROP_EXTERNAL_COMPILER), BasicCompilerSupport.this.getString("HINT_EXTERNAL_COMPILER"));
                BasicCompilerSupport.this.setDefaultFunction((PropertySupport)this, BasicCompilerSupport.PROP_EXTERNAL_COMPILER, "com.hp.openvms.netbeans.basicsupport.settings.BasicFileGeneralSettings");
            }

            public Object getValue() {
                return BasicCompilerSupport.this.getExternalCompiler();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof NbProcessDescriptor || val == null) {
                    try {
                        BasicCompilerSupport.this.setExternalCompiler((NbProcessDescriptor)val);
                        BasicCompilerSupport.this.flagProperty(BasicCompilerSupport.this.getFlaggedName(BasicCompilerSupport.this.getString("PROP_EXTERNAL_COMPILER"), BasicCompilerSupport.PROP_EXTERNAL_COMPILER), BasicCompilerSupport.PROP_EXTERNAL_COMPILER);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public PropertyEditor getPropertyEditor() {
                return new NbProcessDescriptorEditor2();
            }
        }
        return new ExternalCompilerPropertySupport();
    }

    private PropertySupport createMakefileCompilerProperty() {
        class MakefileProperty
        extends PropertySupport.ReadWrite {
            public MakefileProperty() {
                super(BasicCompilerSupport.PROP_MAKEFILE_COMPILER, File.class, BasicCompilerSupport.this.getFlaggedNameMakefile(BasicCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), BasicCompilerSupport.PROP_MAKEFILE_COMPILER), BasicCompilerSupport.this.getString("HINT_MAKEFILE_COMPILER"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.TRUE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", BasicCompilerSupport.this.entry.getFile().getNameExt());
                if (BasicCompilerSupport.this.getProjCompilerType().getMakefileCompiler() != null) {
                    this.setValue("projvalue", BasicCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                }
                try {
                    if (BasicCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", BasicCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BasicCompilerSupport.this.setDefaultFunction((PropertySupport)this, BasicCompilerSupport.PROP_MAKEFILE_COMPILER, "com.hp.openvms.netbeans.basicsupport.settings.BasicFileGeneralSettings");
            }

            public Object getValue() {
                return BasicCompilerSupport.this.getMakefileCompiler();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof RemoteFSFile || val == null) {
                    try {
                        BasicCompilerSupport.this.setMakefileCompiler((RemoteFSFile)val);
                        BasicCompilerSupport.this.flagProperty(BasicCompilerSupport.this.getFlaggedNameMakefile(BasicCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), BasicCompilerSupport.PROP_MAKEFILE_COMPILER), BasicCompilerSupport.PROP_MAKEFILE_COMPILER);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(BasicCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                BasicCompilerSupport.this.changeResetProp(BasicCompilerSupport.PROP_MAKEFILE_COMPILER, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new MakefileProperty();
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", String.class, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                FileObject fobj = BasicCompilerSupport.this.entry.getFile();
                Object obj = fobj.getAttribute("file_residence_mode");
                try {
                    RemoteFileSystem rf = (RemoteFileSystem)fobj.getFileSystem();
                    if (rf.getServerOnlyFileExts().isRegistered(fobj.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                if (obj != null) {
                    Integer itr = (Integer)obj;
                    String ret = "Make Client and Server";
                    switch (itr) {
                        case 1: {
                            ret = "Client Only";
                            break;
                        }
                        case 0: {
                            ret = "Server Only";
                            break;
                        }
                        case 2: {
                            ret = "Client and Server";
                        }
                    }
                    return ret;
                }
                return "Client and Server";
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", String.class, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                FileObject fobj = BasicCompilerSupport.this.entry.getFile();
                Object obj = fobj.getAttribute("REMOTE_FILEPATH");
                if (obj != null) {
                    return obj;
                }
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return vmsPath;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    FileObject fobj = BasicCompilerSupport.this.entry.getFile();
                    fobj.setAttribute("REMOTE_FILEPATH", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                FileObject fobj = BasicCompilerSupport.this.entry.getFile();
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                    this.setValue(vmsPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createBasicLocalQualifierProperty() {
        class BasicLocalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public BasicLocalQualifierPropertySupport() {
                super(BasicCompilerSupport.PROP_BASIC_LOCAL_QUALIFIER, String.class, BasicCompilerSupport.this.getFlaggedName(BasicCompilerSupport.this.getString("PROP_BASIC_LOCAL_QUALIFIER"), BasicCompilerSupport.PROP_BASIC_LOCAL_QUALIFIER), BasicCompilerSupport.this.getString("HINT_BASIC_LOCAL_QUALIFIER"));
                BasicCompilerSupport.this.setDefaultFunction((PropertySupport)this, BasicCompilerSupport.PROP_BASIC_LOCAL_QUALIFIER, "com.hp.openvms.netbeans.basicsupport.settings.BasicFileGeneralSettings");
            }

            public Object getValue() {
                return BasicCompilerSupport.this.getLocalQualifier();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        BasicCompilerSupport.this.setLocalQualifier((String)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(BasicCompilerSupport.this.getLocalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new BasicLocalQualifierPropertySupport();
    }

    private PropertySupport createBasicGlobalQualifierProperty() {
        class BasicGlobalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public BasicGlobalQualifierPropertySupport() {
                super(BasicCompilerSupport.PROP_BASIC_GLOBAL_QUALIFIER, String.class, BasicCompilerSupport.this.getFlaggedName(BasicCompilerSupport.this.getString("PROP_BASIC_GLOBAL_QUALIFIER"), BasicCompilerSupport.PROP_BASIC_GLOBAL_QUALIFIER), BasicCompilerSupport.this.getString("HINT_BASIC_GLOBAL_QUALIFIER"));
                BasicCompilerSupport.this.setDefaultFunction((PropertySupport)this, BasicCompilerSupport.PROP_BASIC_GLOBAL_QUALIFIER, "com.hp.openvms.netbeans.basicsupport.settings.BasicFileGeneralSettings");
            }

            public Object getValue() {
                return BasicCompilerSupport.this.getGlobalQualifier();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        BasicCompilerSupport.this.setGlobalQualifier((String)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(BasicCompilerSupport.this.getGlobalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new BasicGlobalQualifierPropertySupport();
    }

    private String getFlaggedNameBuildOption(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedNameMakefile(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedName(String dispName, String name) {
        return dispName;
    }

    protected String getString(String s) {
        return bundle.getString(s);
    }

    protected void flagProperty(String dispProp, String prop) {
    }

    protected void setDefaultFunction(PropertySupport ps, String propName, String helpID) {
        try {
            ps.setValue("method", (Object)FileObject.class.getMethod("getAttribute", String.class));
            ps.setValue("param", (Object)propName);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        ps.setValue("object", (Object)this.entry.getFile());
        ps.setValue("helpID", (Object)helpID);
    }

    private void changeResetProp(String prop, Object value) {
        Node node = this.entry.getDataObject().getNodeDelegate();
        if (node instanceof BasicDataNode) {
            ((BasicDataNode)node).firePropertyChange2(prop, null, value);
        }
    }

    public FileObject getFileObject() {
        return this.entry.getFile();
    }

    public static class RemoteBuild
    extends BasicCompilerSupport
    implements RemoteBuildCookie {
        public RemoteBuild(MultiDataObject.Entry entry) {
            super(entry, RemoteBuildCookie.class);
        }
    }

    public static class RemoteCompile
    extends BasicCompilerSupport
    implements RemoteCompileCookie {
        public RemoteCompile(MultiDataObject.Entry entry) {
            super(entry, RemoteCompileCookie.class);
        }

        public void compile() throws IOException {
            BasicCompiler compiler = new BasicCompiler(RemoteBuildCookie.class, this.getFileObject(), this.getExternalCompiler(), this.getProjCompilerType().getErrorExpression(), new BasicCompilerType(this.entry.getFile()));
            DataObject dobj = null;
            dobj = DataObject.find((FileObject)this.getFileObject());
            BasicCompilerGroup.BasicFormat cformat = new BasicCompilerGroup.BasicFormat(new DataObject[]{dobj}, new String[]{compiler.getFileName()}, true);
            RemoteCompilerAction.createRemoteProcess(this.getFileObject(), this.getOutputSwitch(), this.getXDisplayNumber(), this.getProjCompilerType().getErrorExpression(), cformat, cformat.getCmds());
        }
    }

    public static class Clean
    extends BasicCompilerSupport
    implements CompilerCookie.Clean {
        public Clean(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Clean.class);
        }
    }

    public static class Build
    extends BasicCompilerSupport
    implements CompilerCookie.Build {
        public Build(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Build.class);
        }
    }

    public static class Compile
    extends BasicCompilerSupport
    implements CompilerCookie.Compile {
        public Compile(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Compile.class);
        }
    }
}

