/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.baseclasses.actions;

import java.io.IOException;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remoteexecute.TargetExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.compiler.ExternalCompiler;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;
import org.openide.util.Utilities;

public class RemoteCompilerAction {
    public static void createRemoteProcess(FileObject fo, Boolean outputSwitch, Integer xDisplayNumber, ExternalCompiler.ErrorExpression errorExp, MapFormat cformat, String[] formattedCmds) throws IOException {
        IOException ioe;
        String cmd;
        RemoteRuntimeType rrt = null;
        boolean useX = outputSwitch;
        int displayNumber = xDisplayNumber;
        DataObject dobj = null;
        dobj = DataObject.find((FileObject)fo);
        FileSystem fs = fo.getFileSystem();
        AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
        rrt = nfs.getRemoteRuntimeType();
        String clientIP = Utils.getIntendedHostAddress();
        if (useX) {
            clientIP = clientIP + ":" + displayNumber;
        }
        if (useX && Utilities.isWindows() && (cmd = DistributedSettings.getDefault().getXServer()) != null && cmd.length() > 0) {
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            if (fo != null && fo.getFileSystem() instanceof NetworkFileSystem) {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
        if (rrt == null) {
            ioe = new IOException("");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\nPlease go to Services Tab and add remote server", 2));
            ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        if (rrt.getRemoteRuntime() == null) {
            ioe = new IOException("");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Remote server \"" + rrt.getHostName() + "\" " + " is disconnected.\nPlease go to Services Tab and make connection using \"" + rrt.getUserName() + "\""), 1));
            ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        RemoteProcessDescriptor rpd = new RemoteProcessDescriptor("", "", formattedCmds);
        TargetExecutor target = new TargetExecutor(rrt, rpd, errorExp, useX, cformat, null, dobj, displayNumber);
        target.execute(fo.getNameExt() + " compilation");
    }
}

