/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer.inc;

import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.lexer.inc.OffsetTokenUpdater;
import org.netbeans.spi.lexer.inc.RawOffsetToken;
import org.netbeans.spi.lexer.util.AbstractCharSequence;
import org.netbeans.spi.lexer.util.CharSubSequence;
import org.netbeans.spi.lexer.util.Compatibility;

public abstract class TextTokenUpdater
extends OffsetTokenUpdater
implements LexerInput {
    private static final int DEFAULT_INITIAL_GAP_LENGTH = 0x3FFFFFFF;
    private int offsetGapStart = 0;
    private int offsetGapLength = 0x3FFFFFFF;
    private int inputIndex;
    private int tokenIndex;
    private int lookaheadIndex;
    private int eof;
    private CharSubSequence subReadText;

    protected LexerInput createInput(int n) {
        this.tokenIndex = this.inputIndex = n;
        this.lookaheadIndex = 0;
        this.eof = 0;
        return this;
    }

    public char charAt(int n, int n2) {
        if (n >= this.offsetGapStart) {
            n += n2 - this.offsetGapLength;
        } else if ((n += n2) >= this.offsetGapStart) {
            n -= this.offsetGapLength;
        }
        return this.textCharAt(n);
    }

    public abstract char textCharAt(int var1);

    public abstract int textLength();

    public int getOffset(int n) {
        return n < this.offsetGapStart ? n : n - this.offsetGapLength;
    }

    protected void removeUpdate(Token token) {
        if (token instanceof RawOffsetToken) {
            ((RawOffsetToken)token).updateRawOffset(-this.offsetGapLength);
        }
        this.offsetGapLength += Compatibility.getLength(token);
    }

    protected void addUpdate(Token token) {
        if (token instanceof RawOffsetToken) {
            ((RawOffsetToken)token).setRawOffset(this.getNextOffset());
        }
        int n = Compatibility.getLength(token);
        this.offsetGapLength -= n;
        this.offsetGapStart += n;
    }

    protected void movedAboveGapUpdate(Token[] tokenArray, int n, int n2) {
        this.movedGapUpdate(tokenArray, n, n2, this.offsetGapLength);
    }

    protected void movedBelowGapUpdate(Token[] tokenArray, int n, int n2) {
        this.movedGapUpdate(tokenArray, n, n2, -this.offsetGapLength);
    }

    private void movedGapUpdate(Token[] tokenArray, int n, int n2, int n3) {
        while (--n2 >= 0) {
            Token token;
            if (!((token = tokenArray[n++]) instanceof RawOffsetToken)) continue;
            ((RawOffsetToken)token).updateRawOffset(n3);
        }
    }

    public int read() {
        if (this.inputIndex >= this.textLength()) {
            this.eof = 1;
            return -1;
        }
        return this.textCharAt(this.inputIndex++);
    }

    public int getReadLookahead() {
        return Math.max(this.lookaheadIndex, this.inputIndex + this.eof) - this.tokenIndex;
    }

    public boolean isEOFLookahead() {
        return this.eof != 0;
    }

    public void backup(int n) {
        this.lookaheadIndex = Math.max(this.lookaheadIndex, this.inputIndex + this.eof);
        this.inputIndex -= n;
        if (this.inputIndex < this.tokenIndex) {
            this.inputIndex += n;
            throw new IllegalArgumentException("count=" + n + " > " + (this.inputIndex - this.tokenIndex));
        }
        if (this.inputIndex > this.lookaheadIndex - this.eof) {
            this.inputIndex += n;
            throw new IllegalArgumentException("count=" + n + " < " + (this.inputIndex + this.eof - this.lookaheadIndex));
        }
    }

    public final int getReadLength() {
        return this.inputIndex - this.tokenIndex;
    }

    public final Token createToken(TokenId tokenId) {
        return this.createToken(tokenId, this.getReadLength());
    }

    public final Token createToken(TokenId tokenId, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("tokenLength=" + n + " <= 0");
        }
        if (this.tokenIndex + n > this.inputIndex) {
            throw new IllegalArgumentException("tokenLength=" + n + " > number-of-read-characters=" + (this.inputIndex - this.tokenIndex));
        }
        Token token = this.createToken(tokenId, this.tokenIndex, n);
        this.tokenIndex += n;
        return token;
    }

    protected abstract Token createToken(TokenId var1, int var2, int var3);

    public CharSequence getReadText(int n, int n2) {
        if (this.subReadText == null) {
            this.subReadText = new CharSubSequence(new ReadText());
        }
        this.subReadText.setBounds(n, n2);
        return this.subReadText;
    }

    char readTextCharAt(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index=" + n + " < 0");
        }
        if (n >= this.getReadLength()) {
            throw new IndexOutOfBoundsException("index=" + n + " >= getReadLength()=" + this.getReadLength());
        }
        return this.textCharAt(this.tokenIndex + n);
    }

    private class ReadText
    extends AbstractCharSequence {
        private ReadText() {
        }

        public int length() {
            return TextTokenUpdater.this.getReadLength();
        }

        public char charAt(int n) {
            return TextTokenUpdater.this.readTextCharAt(n);
        }
    }
}

