/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.api.lexer.TokenId;

public final class TokenCategory {
    private final String name;
    private final TokenIdSet members;

    private TokenCategory(String string, Set set, int n) {
        if (string == null) {
            throw new NullPointerException("Token category name cannot be null");
        }
        if (set == null) {
            throw new NullPointerException("Token category members cannot be null");
        }
        this.name = string;
        this.members = new TokenIdSet(set, n);
    }

    public String getName() {
        return this.name;
    }

    public Set getMembers() {
        return this.members;
    }

    public TokenId[] addMembersToIndexedArray(TokenId[] tokenIdArray) {
        if (tokenIdArray == null) {
            tokenIdArray = (TokenId[])this.members.getIndexedIds().clone();
        } else {
            TokenId[] tokenIdArray2 = this.members.getIndexedIds();
            if (tokenIdArray2.length != tokenIdArray.length) {
                throw new IllegalArgumentException("intoArray has invalid length=" + tokenIdArray.length + " != " + tokenIdArray2.length);
            }
            for (int i = tokenIdArray2.length - 1; i >= 0; --i) {
                TokenId tokenId = tokenIdArray2[i];
                if (tokenId == null) continue;
                tokenIdArray[i] = tokenId;
            }
        }
        return tokenIdArray;
    }

    public boolean isMember(TokenId tokenId) {
        return this.members.containsTokenId(tokenId);
    }

    static final class CategorySet
    extends AbstractSet {
        private Map name2cat;

        CategorySet(Set set, int n) {
            Object object;
            Object object2;
            Iterator iterator = set.iterator();
            this.name2cat = new HashMap(5);
            while (iterator.hasNext()) {
                object2 = (TokenId)iterator.next();
                object = ((TokenId)object2).getCategoryNames();
                for (int i = object.size() - 1; i >= 0; --i) {
                    String string = (String)object.get(i);
                    HashSet<Object> hashSet = (HashSet<Object>)this.name2cat.get(string);
                    if (hashSet == null) {
                        hashSet = new HashSet<Object>();
                        this.name2cat.put(string, hashSet);
                    }
                    hashSet.add(object2);
                }
            }
            object2 = this.name2cat.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                object.setValue(new TokenCategory((String)object.getKey(), (Set)object.getValue(), n + 1));
            }
        }

        public Iterator iterator() {
            return this.name2cat.values().iterator();
        }

        public int size() {
            return this.name2cat.size();
        }

        TokenCategory getCategory(String string) {
            return (TokenCategory)this.name2cat.get(string);
        }
    }

    static final class SkipNullsIterator
    implements Iterator {
        private final Object[] objs;
        private int index;

        SkipNullsIterator(Object[] objectArray) {
            this.objs = objectArray;
        }

        public boolean hasNext() {
            while (this.index < this.objs.length) {
                if (this.objs[this.index] != null) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object next() {
            while (this.index < this.objs.length) {
                Object object;
                if ((object = this.objs[this.index++]) == null) continue;
                return object;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class TokenIdSet
    extends AbstractSet {
        private static final TokenId[] EMPTY_IDS = new TokenId[0];
        private final TokenId[] indexedIds;
        private int size = -1;

        public TokenIdSet(Set set) {
            this(set, 0);
        }

        public TokenIdSet(Set set, int n) {
            this.indexedIds = TokenIdSet.createIndexedIds(set, n);
        }

        TokenId[] getIndexedIds() {
            return this.indexedIds;
        }

        public int size() {
            if (this.size < 0) {
                int n = 0;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    ++n;
                }
                this.size = n;
            }
            return this.size;
        }

        public Iterator iterator() {
            return new SkipNullsIterator(this.indexedIds);
        }

        boolean containsTokenId(TokenId tokenId) {
            return this.indexedIds[tokenId.getIntId()] == tokenId;
        }

        public boolean contains(Object object) {
            int n;
            if (object instanceof TokenId && (n = ((TokenId)object).getIntId()) < this.indexedIds.length) {
                return this.indexedIds[n] != null;
            }
            return false;
        }

        private static TokenId[] createIndexedIds(Set set, int n) {
            TokenId[] tokenIdArray = EMPTY_IDS;
            int n2 = set.size();
            if (n2 > 0) {
                TokenId[] tokenIdArray2 = new TokenId[set.size()];
                set.toArray(tokenIdArray2);
                Arrays.sort(tokenIdArray2, TokenId.INT_ID_COMPARATOR);
                int n3 = tokenIdArray2[n2 - 1].getIntId();
                tokenIdArray = new TokenId[Math.max(n3 + 1, n)];
                for (int i = 0; i < n2; ++i) {
                    TokenId tokenId = tokenIdArray2[i];
                    int n4 = tokenId.getIntId();
                    if (tokenIdArray[n4] != null) {
                        throw new IllegalStateException("Tokens " + tokenIdArray[n4] + " and " + tokenId + " have the same intId=" + n4);
                    }
                    tokenIdArray[n4] = tokenId;
                }
            }
            return tokenIdArray;
        }
    }
}

