/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remoteproject.PanelProvider;
import org.netbeans.modules.distributed.remoteproject.RemoteProject;
import org.netbeans.modules.distributed.remoteproject.RemoteProjectSettingsImpl;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;

public class RemoteProjectCustomizer
implements CustomizerProvider {
    private ProjectCustomizer.Category[] categories;
    private PanelProvider panelProvider;
    private Project project;
    private static final String FTP_FS = "FTP File System Settings";
    private static final String PASCAL = "Pascal Compiler Settings";
    private static final String C = "C Compiler Settings";
    private static final String CPP = "C++ Compiler Settings";
    private static final String FOR = "Fortran Compiler Settings";
    private static final String COB = "Cobol Compiler Settings";
    private static final String BAS = "Basic Compiler Settings";
    private static final String DCL = "DCL Compiler Settings";
    private static final String BASH = "BASH Compiler Settings";
    private static final String MMS = "MMS Compiler Settings";
    private static final String ANT = "Remote Ant Settings";

    public RemoteProjectCustomizer(Project project) {
        this.project = project;
        List fss = project instanceof RemoteProject ? ((RemoteProject)project).getRoots() : Utils.findProjectRoots(project);
        this.categories = new ProjectCustomizer.Category[fss.size() + 10];
        for (int i = 0; i < fss.size(); ++i) {
            this.categories[i] = ProjectCustomizer.Category.create((String)(FTP_FS + i), (String)((FileSystem)fss.get(i)).getDisplayName(), null, null);
        }
        ProjectCustomizer.Category pascalSettings = ProjectCustomizer.Category.create((String)PASCAL, (String)PASCAL, null, null);
        ProjectCustomizer.Category cSettings = ProjectCustomizer.Category.create((String)C, (String)C, null, null);
        ProjectCustomizer.Category basSettings = ProjectCustomizer.Category.create((String)BAS, (String)BAS, null, null);
        ProjectCustomizer.Category cppSettings = ProjectCustomizer.Category.create((String)CPP, (String)CPP, null, null);
        ProjectCustomizer.Category cobSettings = ProjectCustomizer.Category.create((String)COB, (String)COB, null, null);
        ProjectCustomizer.Category forSettings = ProjectCustomizer.Category.create((String)FOR, (String)FOR, null, null);
        ProjectCustomizer.Category dclSettings = ProjectCustomizer.Category.create((String)DCL, (String)DCL, null, null);
        ProjectCustomizer.Category bashSettings = ProjectCustomizer.Category.create((String)BASH, (String)BASH, null, null);
        ProjectCustomizer.Category mmsSettings = ProjectCustomizer.Category.create((String)MMS, (String)MMS, null, null);
        ProjectCustomizer.Category antSettings = ProjectCustomizer.Category.create((String)ANT, (String)ANT, null, null);
        this.categories[fss.size()] = pascalSettings;
        this.categories[fss.size() + 1] = cSettings;
        this.categories[fss.size() + 2] = cppSettings;
        this.categories[fss.size() + 3] = forSettings;
        this.categories[fss.size() + 4] = basSettings;
        this.categories[fss.size() + 5] = cobSettings;
        this.categories[fss.size() + 6] = dclSettings;
        this.categories[fss.size() + 7] = bashSettings;
        this.categories[fss.size() + 8] = mmsSettings;
        this.categories[fss.size() + 9] = antSettings;
    }

    public void showCustomizer() {
        HashMap<ProjectCustomizer.Category, PropertySheet> panels = new HashMap<ProjectCustomizer.Category, PropertySheet>();
        RemoteProjectSettings rs = (RemoteProjectSettings)this.project.getLookup().lookup(RemoteProjectSettings.class);
        if (rs == null) {
            rs = new RemoteProjectSettingsImpl(this.project);
        }
        rs.refresh("cpp");
        rs.refresh("c");
        rs.refresh("basic");
        rs.refresh("cobol");
        rs.refresh("fortran");
        rs.refresh("pascal");
        rs.refresh("dcl");
        rs.refresh("mms");
        rs.refresh("sh");
        rs.refresh("ant");
        rs.refresh("remote_fs");
        List ffss = (List)rs.getCompilerSettings("remote_fs");
        try {
            for (int i = 0; i < ffss.size(); ++i) {
                BeanNode mainNode = new BeanNode(ffss.get(i));
                PropertySheet ps = new PropertySheet();
                ps.setNodes(new Node[]{mainNode});
                panels.put(this.categories[i], ps);
            }
            BeanNode cppNode = new BeanNode(rs.getCompilerSettings("cpp"));
            PropertySheet psCpp = new PropertySheet();
            psCpp.setNodes(new Node[]{cppNode});
            panels.put(this.categories[ffss.size() + 2], psCpp);
            BeanNode cNode = new BeanNode(rs.getCompilerSettings("c"));
            PropertySheet psC = new PropertySheet();
            psC.setNodes(new Node[]{cNode});
            panels.put(this.categories[ffss.size() + 1], psC);
            BeanNode basicNode = new BeanNode(rs.getCompilerSettings("basic"));
            PropertySheet psBasic = new PropertySheet();
            psBasic.setNodes(new Node[]{basicNode});
            panels.put(this.categories[ffss.size() + 4], psBasic);
            BeanNode cobNode = new BeanNode(rs.getCompilerSettings("cobol"));
            PropertySheet psCobol = new PropertySheet();
            psCobol.setNodes(new Node[]{cobNode});
            panels.put(this.categories[ffss.size() + 5], psCobol);
            BeanNode forNode = new BeanNode(rs.getCompilerSettings("fortran"));
            PropertySheet psFor = new PropertySheet();
            psFor.setNodes(new Node[]{forNode});
            panels.put(this.categories[ffss.size() + 3], psFor);
            BeanNode pasNode = new BeanNode(rs.getCompilerSettings("pascal"));
            PropertySheet psPas = new PropertySheet();
            psPas.setNodes(new Node[]{pasNode});
            panels.put(this.categories[ffss.size()], psPas);
            BeanNode dclNode = new BeanNode(rs.getCompilerSettings("dcl"));
            PropertySheet psDcl = new PropertySheet();
            psDcl.setNodes(new Node[]{dclNode});
            panels.put(this.categories[ffss.size() + 6], psDcl);
            BeanNode shNode = new BeanNode(rs.getCompilerSettings("sh"));
            PropertySheet psSh = new PropertySheet();
            psSh.setNodes(new Node[]{shNode});
            panels.put(this.categories[ffss.size() + 7], psSh);
            BeanNode mmsNode = new BeanNode(rs.getCompilerSettings("mms"));
            PropertySheet psMms = new PropertySheet();
            psMms.setNodes(new Node[]{mmsNode});
            panels.put(this.categories[ffss.size() + 8], psMms);
            BeanNode antNode = new BeanNode(rs.getCompilerSettings("ant"));
            PropertySheet psAnt = new PropertySheet();
            psAnt.setNodes(new Node[]{antNode});
            panels.put(this.categories[ffss.size() + 9], psAnt);
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        this.panelProvider = new PanelProvider(panels);
        final RemoteProjectSettings frs = rs;
        Dialog dialog = ProjectCustomizer.createCustomizerDialog((ProjectCustomizer.Category[])this.categories, (ProjectCustomizer.CategoryComponentProvider)this.panelProvider, (String)"FTP File System Settings0", (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (ev.getActionCommand().equals("OK")) {
                        frs.flush("cpp");
                        frs.flush("c");
                        frs.flush("basic");
                        frs.flush("cobol");
                        frs.flush("fortran");
                        frs.flush("pascal");
                        frs.flush("dcl");
                        frs.flush("sh");
                        frs.flush("mms");
                        frs.flush("ant");
                        frs.flush("remote_fs");
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(16, (Throwable)ex);
                }
            }
        }, null);
        dialog.show();
    }
}

