/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.remoteproject.MainFileProvider;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remoteproject.ClassPathProviderImpl;
import org.netbeans.modules.distributed.remoteproject.OpenVMSSources;
import org.netbeans.modules.distributed.remoteproject.RemoteProjectCustomizer;
import org.netbeans.modules.distributed.remoteproject.RemoteProjectLogicalView;
import org.netbeans.modules.distributed.remoteproject.RemoteProjectSettingsImpl;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.DataFilesProviderImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import patchsources.OpenProjectList_Dist;

public final class RemoteProject
implements Project {
    public static final String KEY_MAINFILE = "main.file";
    public static final String KEY_VERSION = "nbpov.version";
    public static final float VALUE_VERSION = 1.0f;
    public static final String IMAGES_DIR = "images";
    public static final String NAME = "name";
    private final FileObject projectDir;
    private final MainFileProviderImpl mainFile = new MainFileProviderImpl();
    private String displayPrefix;
    private String localRootCache;
    private final ProjectState state;
    private final Lookup lookup;
    private List roots;

    public RemoteProject(FileObject projectDir, ProjectState state) {
        this.projectDir = projectDir;
        this.state = state;
        this.lookup = this.createLookup();
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public ProjectState getProjectState() {
        return this.state;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createLookup() {
        return Lookups.fixed((Object[])new Object[]{this, this.state, new RemoteProjectCustomizer(this), new DeleteProvider3GL(), new DataFilesProviderImpl(), new ActionProviderImpl(), new Info(), new PrivilegedTemplatesImpl(), new RemoteProjectLogicalView(this), new OpenVMSSources(this), new ClassPathProviderImpl(this.getSourceRoots()), new ProjectOpenedHookImpl(this), new RemoteProjectSettingsImpl(this)});
    }

    public List getRoots() {
        if (this.roots == null) {
            this.roots = Utils.findProjectRoots(this);
        }
        return this.roots;
    }

    private FileObject[] getSourceRoots() {
        List rts = this.getRoots();
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        for (int i = 0; i < rts.size(); ++i) {
            list.add(((AbstractNetworkFileSystem)rts.get(i)).getFSRoot());
        }
        return list.toArray(new FileObject[0]);
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Remote Project/Empty.pov", "Templates/Remote Project/Empty.inc"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private final class ActionProviderImpl
    implements ActionProvider {
        private ActionProviderImpl() {
        }

        public String[] getSupportedActions() {
            return new String[]{"delete"};
        }

        public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
            if ("delete".equals(command)) {
                DefaultProjectOperations.performDefaultDeleteOperation((Project)RemoteProject.this);
                return;
            }
        }

        public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
            return "delete".equals(command);
        }
    }

    private final class MainFileProviderImpl
    implements MainFileProvider {
        private FileObject mainFile = null;
        boolean checked = false;

        private MainFileProviderImpl() {
        }

        public FileObject getMainFile() {
            if (this.mainFile == null && !this.checked) {
                this.checked = true;
                Properties props = (Properties)RemoteProject.this.getLookup().lookup(Properties.class);
                String path = props.getProperty(RemoteProject.KEY_MAINFILE);
                if (path != null) {
                    this.mainFile = RemoteProject.this.projectDir.getFileObject(path);
                }
            }
            if (this.mainFile != null && !this.mainFile.isValid()) {
                return null;
            }
            return this.mainFile;
        }

        public void setMainFile(FileObject file) {
            assert (file != null && file.getPath().startsWith(RemoteProject.this.getProjectDirectory().getPath())) : "Main file not under project";
            boolean change = this.mainFile == null != (file == null) || this.mainFile != null && !this.mainFile.equals(file);
            this.mainFile = file;
            if (change) {
                RemoteProject.this.state.markModified();
            }
        }
    }

    private final class Info
    implements ProjectInformation {
        private Info() {
        }

        public Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/resources/systemFS.gif"));
        }

        public String getName() {
            return this.getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties getPropertiesOrNull() {
            Properties p = null;
            FileObject fo = null;
            InputStream is = null;
            if (RemoteProject.this.getProjectDirectory().getPath().equals("")) {
                try {
                    File f = FileUtil.toFile((FileObject)RemoteProject.this.getProjectDirectory());
                    fo = FileUtil.toFileObject((File)new File(f, "nbproject".toUpperCase() + "/" + "project.properties".toUpperCase()));
                    if (fo == null) {
                        fo = FileUtil.toFileObject((File)new File(f, "nbproject".toUpperCase() + "/" + "project.properties".toUpperCase()));
                    }
                }
                catch (Exception ex) {}
            } else {
                fo = RemoteProject.this.getProjectDirectory().getFileObject("nbproject/project.properties");
                if (fo == null && (fo = RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase() + "/" + "project.properties".toUpperCase())) == null) {
                    fo = RemoteProject.this.getProjectDirectory().getFileObject("nbproject/" + "project.properties".toUpperCase());
                }
            }
            if (fo != null) {
                try {
                    is = fo.getInputStream();
                    try {
                        p = new Properties();
                        p.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return p;
        }

        public String getDisplayName() {
            Properties properties = this.getPropertiesOrNull();
            if (properties != null && properties.containsKey(RemoteProject.NAME)) {
                return properties.getProperty(RemoteProject.NAME);
            }
            return "???";
        }

        public void addPropertyChangeListener(PropertyChangeListener pcl) {
        }

        public void removePropertyChangeListener(PropertyChangeListener pcl) {
        }

        public Project getProject() {
            return RemoteProject.this;
        }
    }

    private final class DeleteProvider3GL
    implements DeleteOperationImplementation {
        private DeleteProvider3GL() {
        }

        public void notifyDeleted() {
            List list = RemoteProject.this.getRoots();
            for (int i = 0; i < list.size(); ++i) {
                OpenProjectList_Dist.getFsSet().remove((FileSystem)list.get(i));
            }
            RemoteProject.this.getProjectState().notifyDeleted();
            ProjectManager.getDefault().clearNonProjectCache();
        }

        public void notifyDeleting() {
            this.notifyDeleted();
        }

        public List getDataFiles() {
            return new ArrayList();
        }

        public List getMetadataFiles() {
            ArrayList<FileObject> list = new ArrayList<FileObject>();
            if (RemoteProject.this.getProjectDirectory().getFileObject("nbproject") != null) {
                list.add(RemoteProject.this.getProjectDirectory().getFileObject("nbproject"));
            } else if (RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase()) != null) {
                list.add(RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase()));
            }
            return list;
        }
    }

    private final class DataFilesProviderImpl
    implements DataFilesProviderImplementation {
        private DataFilesProviderImpl() {
        }

        public List getDataFiles() {
            return new ArrayList();
        }

        public List getMetadataFiles() {
            ArrayList<FileObject> list = new ArrayList<FileObject>();
            if (RemoteProject.this.getProjectDirectory().getFileObject("nbproject") != null) {
                list.add(RemoteProject.this.getProjectDirectory().getFileObject("nbproject"));
            } else if (RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase()) != null) {
                list.add(RemoteProject.this.getProjectDirectory().getFileObject("nbproject".toUpperCase()));
            }
            return list;
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private RemoteProject project;

        ProjectOpenedHookImpl(RemoteProject project) {
            this.project = project;
        }

        protected void projectOpened() {
            List rts = RemoteProject.this.getRoots();
            for (int i = 0; i < rts.size(); ++i) {
                FileSystem fsFinal = (FileSystem)rts.get(i);
                RemoteProject projectFinal = this.project;
                fsFinal.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                    }
                });
                FileOwnerQuery.markExternalOwner((FileObject)fsFinal.getRoot(), (Project)this.project, (int)0);
            }
            Utils.writeDefault3GLXMLCompilerSettings(this.project);
        }

        protected void projectClosed() {
            List rts = RemoteProject.this.getRoots();
            for (int i = 0; i < rts.size(); ++i) {
                ((FileSystem)rts.get(i)).removeNotify();
                OpenProjectList_Dist.getFsSet().remove((FileSystem)rts.get(i));
            }
        }
    }

    private class ExtensibleMetadataProviderImpl
    implements AuxiliaryConfiguration {
        private ExtensibleMetadataProviderImpl() {
        }

        public Element getConfigurationFragment(String string, String string0, boolean b) {
            return null;
        }

        public void putConfigurationFragment(Element element, boolean b) throws IllegalArgumentException {
        }

        public boolean removeConfigurationFragment(String string, String string0, boolean b) throws IllegalArgumentException {
            return false;
        }
    }
}

