/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.SyncTablePanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class SynchronizeAction
extends NodeAction {
    static final long serialVersionUID = -7910677883191530621L;
    private RemoteFileSystem fs = null;

    protected boolean enable(Node[] nodes) {
        if (nodes == null) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            DataObject df = (DataObject)nodes[i].getCookie(DataObject.class);
            if (df == null) continue;
            FileObject fo = df.getPrimaryFile();
            try {
                FileSystem fs = fo.getFileSystem();
                if (fs instanceof RemoteFileSystem) continue;
                return false;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        return true;
    }

    public static void doSync(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        HashSet<FileObject> parentFolder = new HashSet<FileObject>();
        StatusDisplayer.getDefault().setStatusText("Performing Synchronize");
        boolean firstTime = true;
        String localRoot = null;
        RemoteFileSystem fs = null;
        for (int i = 0; i < nodes.length; ++i) {
            Set fobjs = ((DataObject)nodes[i].getCookie(DataObject.class)).files();
            Iterator itr = fobjs.iterator();
            while (itr.hasNext()) {
                try {
                    FileObject fobj = (FileObject)itr.next();
                    if (firstTime) {
                        localRoot = ((RemoteFileSystem)fobj.getFileSystem()).getLocalRoot();
                        Utils.createStatusLogger(localRoot, "sync");
                        fs = (RemoteFileSystem)fobj.getFileSystem();
                        ((RemoteFileSystem)fobj.getFileSystem()).setStopSyncAll(false);
                        ((RemoteFileSystem)fobj.getFileSystem()).setPrintSyncAllStop(true);
                        ((RemoteFileSystem)fobj.getFileSystem()).getRemoteRuntimeType().setRemoteServerError(false);
                        firstTime = false;
                    }
                    if (fobj.isFolder()) {
                        parentFolder.add(fobj);
                        continue;
                    }
                    parentFolder.add(fobj.getParent());
                }
                catch (FileStateInvalidException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                }
                catch (IOException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                }
            }
        }
        for (FileObject fobj : parentFolder) {
            fobj.refresh(false);
        }
        if (localRoot != null) {
            Utils.getStatusLogger(localRoot, "sync").info("Done");
        }
        SyncTablePanel.bringupTable(false);
        StatusDisplayer.getDefault().setStatusText("Finished Synchronize");
    }

    protected void performAction(Node[] nodes) {
        SynchronizeAction.doSync(nodes);
    }

    public String getName() {
        return "Synchronize";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

