/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute.ant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.ant.RemoteAntExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import patchsources.OpenProjectList_Dist;

public class RemoteProjectActions
extends NodeAction
implements Presenter.Popup {
    static final long serialVersionUID = -7910677883191530621L;
    public static final String REMOTE_BUILD = "Build Project";
    public static final String REMOTE_CLEAN_BUILD = "Clean and Build Project";
    public static final String REMOTE_CLEAN = "Clean Project";
    public static final String REMOTE_GENERATE_JAVADOC = "Generate Javadoc for Project";
    public static final String REMOTE_RUN = "Run Project";
    public static final String REMOTE_DEBUG = "Debug Project";
    public static final String REMOTE_TEST = "Test Project";
    public static final String REMOTE_OPERATIONS = "Remote Project Operations";
    public static final String REMOTE_PROPS = "Remote Project Properties";
    static boolean QUIETLY_SWALLOW_XML_LOAD_ERRORS = false;

    public JMenuItem getPopupPresenter() {
        return new SpecialSubMenu((SystemAction)this, new ActSubMenuModel(this), true);
    }

    protected boolean enable(Node[] activatedNodes) {
        for (int j = 0; j < activatedNodes.length; ++j) {
            Lookup lookup = activatedNodes[j].getLookup();
            Project project = (Project)lookup.lookup(Project.class);
            if (project == null) {
                return false;
            }
            FileObject fobj = project.getProjectDirectory();
            try {
                if (fobj.getFileSystem() instanceof AbstractNetworkFileSystem) continue;
                return false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public void performAction(Node[] nodes) {
    }

    public String getName() {
        return REMOTE_OPERATIONS;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean asynchronous() {
        return false;
    }

    private static final class ActSubMenuModel
    implements Actions.SubMenuModel {
        private List targets = null;
        private List antTargets = null;
        private Node[] nodes = null;
        private DataObject dobj = null;
        private final NodeAction action;
        private String projectTypeString;
        private boolean isFreeFormProj;

        ActSubMenuModel(NodeAction action) {
            this.action = action;
            this.targets = new ArrayList();
            this.antTargets = new ArrayList();
        }

        public int getCount() {
            if (this.targets == null) {
                return 0;
            }
            return this.targets.size();
        }

        public String getLabel(int index) {
            return (String)this.targets.get(index);
        }

        public HelpCtx getHelpCtx(int index) {
            return new HelpCtx("org.apache.tools.ant.module.executing-target");
        }

        private static void refreshFS() {
            for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
                if (fs.isReadOnly() || !(fs instanceof AbstractNetworkFileSystem)) continue;
                fs.refresh(false);
            }
        }

        public static RemoteAntExecutor getRemoteAntExecutorType() {
            RemoteAntExecutor ex = (RemoteAntExecutor)Lookup.getDefault().lookup(RemoteAntExecutor.class);
            return ex;
        }

        public void performActionAt(final int index) {
            if (DistributedSettings.getDefault().getSaveAll()) {
                LifecycleManager.getDefault().saveAll();
            }
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    String antTarget = "";
                    String target = (String)ActSubMenuModel.this.targets.get(index);
                    antTarget = (String)ActSubMenuModel.this.antTargets.get(index);
                    RemoteAntExecutor ret = ActSubMenuModel.getRemoteAntExecutorType();
                    if (ret == null) {
                        ErrorManager.getDefault().notify((Throwable)new Exception("Remote Ant Execute Action Failed"));
                        return;
                    }
                    try {
                        if (antTarget.startsWith("clean")) {
                            Lookup lookup = ActSubMenuModel.this.nodes[0].getLookup();
                            Project project = (Project)lookup.lookup(Project.class);
                            if (project != null) {
                                FileObject dist;
                                FileObject pdir = project.getProjectDirectory();
                                FileObject build = pdir.getFileObject("build");
                                if (build != null) {
                                    build.delete();
                                }
                                if ((dist = pdir.getFileObject("dist")) != null) {
                                    dist.delete();
                                }
                            }
                            antTarget = antTarget.substring("clean".length());
                        }
                        if (antTarget.length() > 0) {
                            HashMap props = new HashMap();
                            ret.execute(ActSubMenuModel.this.dobj, antTarget, props);
                        }
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            });
        }

        void addNotify() {
            this.nodes = this.action.getActivatedNodes();
            if (this.nodes.length == 0) {
                return;
            }
            Lookup lookup = this.nodes[0].getLookup();
            Project project = (Project)lookup.lookup(Project.class);
            if (project == null) {
                return;
            }
            AntArtifactProvider antProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
            if (antProvider == null) {
                return;
            }
            AntArtifact[] antArts = antProvider.getBuildArtifacts();
            FileObject buildXml = null;
            if (antArts == null || antArts.length == 0) {
                buildXml = Utils.getFreeFormBuildFile(project);
                this.isFreeFormProj = true;
            } else {
                buildXml = antArts[0].getScriptFile();
                this.projectTypeString = antArts[0].getType();
            }
            if (buildXml == null) {
                return;
            }
            FileObject pdir = project.getProjectDirectory();
            String projectDirectory = FileUtil.toFile((FileObject)pdir).getAbsolutePath();
            try {
                this.dobj = DataObject.find((FileObject)buildXml);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
                if (!(fs instanceof AbstractNetworkFileSystem) || !projectDirectory.equalsIgnoreCase(((AbstractNetworkFileSystem)fs).getLocalRoot())) continue;
                if (this.isFreeFormProj) {
                    List actions = Utils.getFreeFormProjectActions(project);
                    Iterator itr = actions.iterator();
                    while (itr.hasNext()) {
                        this.targets.add(itr.next());
                        this.antTargets.add(itr.next());
                    }
                    if (this.targets.size() != 1) continue;
                    this.targets.add(null);
                    continue;
                }
                this.targets.add(RemoteProjectActions.REMOTE_BUILD);
                if (this.projectTypeString.equals("war")) {
                    this.antTargets.add("dist");
                } else if (this.projectTypeString.equals("jar")) {
                    this.antTargets.add("jar");
                } else {
                    this.antTargets.add(this.projectTypeString);
                }
                this.targets.add(RemoteProjectActions.REMOTE_CLEAN_BUILD);
                if (this.projectTypeString.equals("war")) {
                    this.antTargets.add("cleandist");
                } else if (this.projectTypeString.equals("jar")) {
                    this.antTargets.add("cleanjar");
                } else {
                    this.antTargets.add(this.projectTypeString);
                }
                this.targets.add(RemoteProjectActions.REMOTE_CLEAN);
                this.antTargets.add("clean");
                this.targets.add(RemoteProjectActions.REMOTE_RUN);
                this.antTargets.add("run");
                this.targets.add(RemoteProjectActions.REMOTE_DEBUG);
                this.antTargets.add("remotedebug");
            }
        }

        public synchronized void addChangeListener(ChangeListener l) {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
        }
    }

    private static final class SpecialSubMenu
    extends Actions.SubMenu {
        private final ActSubMenuModel model;

        SpecialSubMenu(SystemAction action, ActSubMenuModel model, boolean popup) {
            super(action, (Actions.SubMenuModel)model, popup);
            this.model = model;
            this.addNotify();
        }

        public void addNotify() {
            this.model.addNotify();
            super.addNotify();
        }
    }
}

