/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.common.property;

import java.lang.reflect.InvocationTargetException;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class AntProperty
extends Node.Property {
    private Element el;
    private String name;
    private AntProjectCookie proj;

    public AntProperty(Element el, String name, AntProjectCookie proj) {
        this(name, proj);
        this.el = el;
    }

    protected AntProperty(String name, AntProjectCookie proj) {
        super(String.class);
        this.setName(name);
        this.name = name;
        this.proj = proj;
    }

    protected Element getElement() {
        return this.el;
    }

    public Object getValue() {
        Element el = this.getElement();
        if (el == null) {
            return NbBundle.getMessage(AntProperty.class, (String)"LBL_property_invalid_no_element");
        }
        return el.getAttribute(this.name);
    }

    public void setValue(Object value) throws IllegalArgumentException, InvocationTargetException {
        Element el = this.getElement();
        if (el == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException();
        }
        if (value.equals("")) {
            try {
                el.removeAttribute(this.name);
            }
            catch (DOMException dome) {
                throw new InvocationTargetException(dome);
            }
        } else {
            el.setAttribute(this.name, (String)value);
        }
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return this.getElement() != null && !AntProperty.isScriptReadOnly(this.proj);
    }

    public boolean supportsDefaultValue() {
        return this.getElement() != null;
    }

    public void restoreDefaultValue() throws IllegalArgumentException, InvocationTargetException {
        this.setValue("");
    }

    public static boolean isScriptReadOnly(AntProjectCookie cookie) {
        if (cookie != null) {
            if (cookie.getFileObject() != null) {
                return cookie.getFileObject().canWrite();
            }
            if (cookie.getFile() != null) {
                return !cookie.getFile().canWrite();
            }
        }
        return true;
    }
}

